"use strict";
(self["webpackChunkproject"] = self["webpackChunkproject"] || []).push([[59],{

/***/ 3230:
/*!************************************************************!*\
  !*** ./src/app/data/components/layout/layout.component.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LayoutComponent: () => (/* binding */ LayoutComponent)
/* harmony export */ });
/* harmony import */ var _Users_jeffreywilbur_projects_repipe_unified_app_node_modules_pnpm_babel_runtime_7_26_0_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/.pnpm/@babel+runtime@7.26.0/node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 4626);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/authentication/services/auth-ref.service */ 4387);
/* harmony import */ var src_app_shared_authentication_services_auth_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/authentication/services/auth.service */ 1619);
/* harmony import */ var src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/data/services/db.service */ 1235);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 4947);
/* harmony import */ var _shared_ui_components_loader_loader_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../shared/ui/components/loader/loader.component */ 5086);








const _c0 = ["componentElm"];
let LayoutComponent = /*#__PURE__*/(() => {
  class LayoutComponent {
    constructor(authRefService, authService, dbService, router, route) {
      this.authRefService = authRefService;
      this.authService = authService;
      this.dbService = dbService;
      this.router = router;
      this.route = route;
      // #region Authentication
      this.activeUser = null;
      this.initiatedAuth = false;
      // #endregion
      // #region Retrieval
      this.progressPercentage = 0;
      this.retrievalTitle = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject("Signing In...");
      // #endregion
      // #region Title
      this.showTitle = false;
      this.title = "";
      // #endregion
      // #region Bootstrapping
      this.path = "/";
    }
    watchAuth() {
      var _this = this;
      this.authSubscription = this.authRefService.authenticated.subscribe({
        next: function () {
          var _ref = (0,_Users_jeffreywilbur_projects_repipe_unified_app_node_modules_pnpm_babel_runtime_7_26_0_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (authenticated) {
            if (authenticated) {
              _this.authSubscription?.unsubscribe();
              if (!_this.initiatedAuth) {
                _this.initiatedAuth = true;
              }
            }
          });
          return function next(_x) {
            return _ref.apply(this, arguments);
          };
        }()
      });
      this.userSubscription = this.authRefService.user.subscribe({
        next: user => {
          if (user != null && user.id != this.activeUser?.id) {
            this.initRetrieval().then();
          }
          this.activeUser = user;
        }
      });
    }
    initAuth() {
      this.watchAuth();
    }
    destroyAuth() {
      this.authSubscription?.unsubscribe();
      this.userSubscription?.unsubscribe();
    }
    retrieveData() {
      var _this2 = this;
      return (0,_Users_jeffreywilbur_projects_repipe_unified_app_node_modules_pnpm_babel_runtime_7_26_0_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        _this2.progressPercentage = 50;
        const now = new Date();
        let sinceInMs = null;
        const lastCommissionEstimateRetrieval = yield _this2.dbService.getLastCommissionEstimateRetrieval();
        if (lastCommissionEstimateRetrieval?.timestamp != null) {
          sinceInMs = now.getTime() - lastCommissionEstimateRetrieval.timestamp.getTime() + 60000; // Buffer to allow for server operations;
        } else {
          sinceInMs = null;
        }
        _this2.retrievalTitle.next("Getting Latest Commissions");
        yield _this2.dbService.retrieveCommissionEstimates(sinceInMs);
        _this2.progressPercentage = 30;
        const lastReminderRetrieval = yield _this2.dbService.getLastReminderRetrieval();
        if (lastReminderRetrieval?.timestamp != null) {
          sinceInMs = now.getTime() - lastReminderRetrieval.timestamp.getTime() + 60000; // Buffer to allow for server operations;
        } else {
          sinceInMs = null;
        }
        _this2.retrievalTitle.next("Getting Latest Reminders");
        yield _this2.dbService.retrieveReminders(sinceInMs);
        _this2.progressPercentage = 50;
        const lastAppointmentsRetrieval = yield _this2.dbService.getLastAppointmentsRetrieval();
        if (lastAppointmentsRetrieval?.timestamp != null) {
          sinceInMs = now.getTime() - lastAppointmentsRetrieval.timestamp.getTime() + 60000; // Buffer to allow for server operations;
        } else {
          sinceInMs = null;
        }
        if (_this2.activeUser?.isManager) {
          _this2.progressPercentage = 75;
        } else {
          _this2.progressPercentage = 100;
        }
        _this2.retrievalTitle.next("Getting Latest Appointments");
        yield _this2.dbService.retrieveAppointments(sinceInMs);
        if (_this2.activeUser?.isManager) {
          _this2.progressPercentage = 100;
          const lastTeamAppointmentsRetrieval = yield _this2.dbService.getLastTeamAppointmentsRetrieval();
          if (lastTeamAppointmentsRetrieval?.timestamp != null) {
            sinceInMs = now.getTime() - lastTeamAppointmentsRetrieval.timestamp.getTime() + 60000; // Buffer to allow for server operations;
          } else {
            sinceInMs = null;
          }
          _this2.retrievalTitle.next("Getting Latest Team Appointments");
          yield _this2.dbService.retrieveTeamAppointments(sinceInMs);
        }
        _this2.dbService.dataRetrieved.next(true);
        _this2.dbService.init();
        _this2.router.navigate([_this2.path]);
      })();
    }
    initRetrieval() {
      var _this3 = this;
      return (0,_Users_jeffreywilbur_projects_repipe_unified_app_node_modules_pnpm_babel_runtime_7_26_0_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
        _this3.progressPercentage = 0;
        setTimeout(/*#__PURE__*/(0,_Users_jeffreywilbur_projects_repipe_unified_app_node_modules_pnpm_babel_runtime_7_26_0_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
          yield _this3.retrieveData();
          _this3.router.navigate([_this3.path]);
        }), 100);
      })();
    }
    setTitle(title) {
      window.clearTimeout(this.titleTimer);
      if (title.length > 0) {
        if (this.title.length <= 0) {
          this.title = title;
          this.showTitle = true;
        } else {
          this.showTitle = false;
          this.titleTimer = window.setTimeout(() => {
            this.title = title;
            this.showTitle = true;
          }, 500);
        }
      }
    }
    watchTitle() {
      this.titleSubscription = this.retrievalTitle.subscribe({
        next: title => {
          this.setTitle(title);
        }
      });
    }
    get showLoader() {
      return true;
    }
    init() {
      this.initAuth();
      this.watchTitle();
    }
    // #endregion
    ngOnInit() {
      this.route.params.subscribe(params => {
        this.path = params['encodedPath'] ? decodeURIComponent(params['encodedPath']) : "/";
      });
      this.init();
    }
    ngOnDestroy() {
      this.destroyAuth();
      this.titleSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function LayoutComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || LayoutComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_1__.AuthRefService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_service__WEBPACK_IMPORTED_MODULE_2__.AuthService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_3__.DbService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_7__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineComponent"]({
      type: LayoutComponent,
      selectors: [["ng-component"]],
      viewQuery: function LayoutComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      standalone: false,
      decls: 12,
      vars: 7,
      consts: [["id", "dataLayout"], [1, "content"], [1, "loader"], [1, "bar"], [1, "bg"], [1, "indicator"], [1, "meta"], [1, "logo"], ["src", "/assets/images/logo.svg"]],
      template: function LayoutComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "section", 0)(1, "div", 1)(2, "div", 2);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](3, "loader");
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](4, "div", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](5, "div", 4)(6, "div", 5);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](7, "div", 6)(8, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](9);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](10, "div", 7);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](11, "img", 8);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("active", ctx.showLoader);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵstyleProp"]("transform", "translateX(" + (100 - ctx.progressPercentage) * -1 + "%)");
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵclassProp"]("active", ctx.showTitle);
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtextInterpolate"](ctx.title);
        }
      },
      dependencies: [_shared_ui_components_loader_loader_component__WEBPACK_IMPORTED_MODULE_4__.LoaderComponent],
      styles: ["@keyframes _ngcontent-%COMP%_progressLoad {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_logoLoad {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n#dataLayout[_ngcontent-%COMP%] {\n  position: fixed;\n  width: 100vw;\n  height: 100vh;\n  background-color: var(--color2Alt1);\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  display: flex;\n  align-items: center;\n  flex-direction: column;\n  justify-content: center;\n  --fillSpeed: 10s;\n  animation-name: _ngcontent-%COMP%_progressLoad;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: 0.2s;\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  transition: opacity 0.2s linear;\n  width: 20vw;\n  height: 20vw;\n  border-radius: 100%;\n  background-color: var(--color2);\n  box-shadow: 0 0 2vw rgba(var(--color1-raw), 0.1);\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  display: block;\n  height: 18vw;\n  width: 18vw;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .loader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%] {\n  width: 50vw;\n  margin-top: 3vw;\n  height: 1.6vw;\n  border-radius: 999px;\n  position: relative;\n  overflow: hidden;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 0;\n  background-color: var(--color2Alt2);\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border-top-right-radius: 999px;\n  border-bottom-right-radius: 999px;\n  background-color: var(--color4) 0%;\n  background-image: linear-gradient(to right, var(--color4) 0%, var(--color3) 100%);\n  transition: transform var(--fillSpeed) linear;\n  transform: translateX(-100%);\n  overflow: hidden;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%]:before {\n  content: \"\";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  box-shadow: 0 0 1vw 0.8vw rgba(255, 255, 255, 0.5);\n  border: 0.4vw groove rgba(255, 255, 255, 0.5);\n  background: linear-gradient(172deg, rgba(var(--white-raw), 0.8) 0%, rgba(var(--white-raw), 0.4) 20%, rgba(var(--white-raw), 0.1) 48%, rgba(var(--white-raw), 0) 100%);\n  z-index: -1;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 3vw;\n  position: relative;\n  overflow: hidden;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  color: var(--color1);\n  font-size: 3.2vw;\n  font-weight: var(--ltweight);\n  white-space: nowrap;\n  transform: translateY(100%);\n  transition: transform 0.5s linear;\n}\n#dataLayout[_ngcontent-%COMP%]   .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h2.active[_ngcontent-%COMP%] {\n  transform: translateY(0);\n}\n#dataLayout[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  transform: translate3d(-50%, 0, 0);\n  bottom: 2vw;\n  opacity: 0;\n  pointer-events: none;\n  animation-name: _ngcontent-%COMP%_progressLoad;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#dataLayout[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 20vw;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return LayoutComponent;
})();

/***/ }),

/***/ 4778:
/*!*********************************************!*\
  !*** ./src/app/data/data-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DataRoutingModule: () => (/* binding */ DataRoutingModule)
/* harmony export */ });
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ 4947);
/* harmony import */ var _components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/layout/layout.component */ 3230);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 4380);

/* Components */



const routes = [{
  path: '',
  component: _components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.LayoutComponent
}];
let DataRoutingModule = /*#__PURE__*/(() => {
  class DataRoutingModule {
    static #_ = (() => this.ɵfac = function DataRoutingModule_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DataRoutingModule)();
    })();
    static #_2 = (() => this.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineNgModule"]({
      type: DataRoutingModule
    }))();
    static #_3 = (() => this.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjector"]({
      imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterModule.forChild(routes), _angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterModule]
    }))();
  }
  return DataRoutingModule;
})();
(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵsetNgModuleScope"](DataRoutingModule, {
    imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterModule],
    exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterModule]
  });
})();

/***/ }),

/***/ 7059:
/*!*************************************!*\
  !*** ./src/app/data/data.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DataModule: () => (/* binding */ DataModule)
/* harmony export */ });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var _components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/layout/layout.component */ 3230);
/* harmony import */ var _data_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./data-routing.module */ 4778);
/* harmony import */ var _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../shared/ui/ui.module */ 663);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 4380);


/* Components */

/* Modules */



/* Services */
let DataModule = /*#__PURE__*/(() => {
  class DataModule {
    static #_ = (() => this.ɵfac = function DataModule_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DataModule)();
    })();
    static #_2 = (() => this.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineNgModule"]({
      type: DataModule
    }))();
    static #_3 = (() => this.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineInjector"]({
      providers: [(0,_angular_common_http__WEBPACK_IMPORTED_MODULE_4__.provideHttpClient)((0,_angular_common_http__WEBPACK_IMPORTED_MODULE_4__.withInterceptorsFromDi)())],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_2__.UiModule, _data_routing_module__WEBPACK_IMPORTED_MODULE_1__.DataRoutingModule]
    }))();
  }
  return DataModule;
})();
(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsetNgModuleScope"](DataModule, {
    declarations: [_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.LayoutComponent],
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule, _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_2__.UiModule, _data_routing_module__WEBPACK_IMPORTED_MODULE_1__.DataRoutingModule]
  });
})();

/***/ })

}]);
//# sourceMappingURL=59.js.map