"use strict";
(self["webpackChunkproject"] = self["webpackChunkproject"] || []).push([[65],{

/***/ 6214:
/*!***************************************************************************!*\
  !*** ./src/app/dashboard/components/appointment/appointment.component.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentComponent: () => (/* binding */ AppointmentComponent)
/* harmony export */ });
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! leaflet */ 3448);
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/appointments/models/appointment */ 8723);
/* harmony import */ var src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/contact-information/models/contact-information */ 904);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/ui/services/ui.service */ 345);
/* harmony import */ var _services_dashboard_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/dashboard.service */ 5909);
/* harmony import */ var src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/shared/authentication/services/auth-ref.service */ 4387);
/* harmony import */ var src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/shared/appointments/services/appointment.service */ 8036);
/* harmony import */ var src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/shared/navigation/services/device-route.service */ 2405);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6216);

/* Models */









const _c0 = ["componentElm"];
function AppointmentComponent_div_0_div_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "div", 20)(1, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](2, "Emergency");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
}
function AppointmentComponent_div_0_div_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "div", 21)(1, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](2, "Canceled");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](3, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", ctx_r1.appointment.statusDescription, " ");
  }
}
function AppointmentComponent_div_0_span_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "span", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate2"](" ", ctx_r1.address.city, ", ", ctx_r1.address.regionIso3166, " ");
  }
}
function AppointmentComponent_div_0_div_26_label_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Accepted ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function AppointmentComponent_div_0_div_26_label_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Not Accepted ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function AppointmentComponent_div_0_div_26_span_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "span", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](2, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" on ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind2"](2, 1, ctx_r1.appointment.accepted_Utc, "MMM, dd h:mm a"), " ");
  }
}
function AppointmentComponent_div_0_div_26_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](1, AppointmentComponent_div_0_div_26_label_1_Template, 2, 0, "label", 24)(2, AppointmentComponent_div_0_div_26_label_2_Template, 2, 0, "label", 24)(3, AppointmentComponent_div_0_div_26_span_3_Template, 3, 4, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("accepted", ctx_r1.accepted);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.accepted);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", !ctx_r1.accepted);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.appointment.accepted_Utc != null);
  }
}
function AppointmentComponent_div_0_div_27_span_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "span", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const item_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", item_r3, " ");
  }
}
function AppointmentComponent_div_0_div_27_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "div", 27)(1, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](2, " Attachment Items: ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](3, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](4, AppointmentComponent_div_0_div_27_span_4_Template, 2, 1, "span", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngForOf", ctx_r1.attachmentItems);
  }
}
function AppointmentComponent_div_0_button_30_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "button", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function AppointmentComponent_div_0_button_30_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r4);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r1.acceptAppointment());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](1, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](2, "Accept");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
}
function AppointmentComponent_div_0_button_31_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "button", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function AppointmentComponent_div_0_button_31_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r5);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r1.goToAppointment());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](1, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](2, "Open");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("disabled", !ctx_r1.canOpen);
  }
}
function AppointmentComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "div", 1)(1, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](2, "div", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](3, "div", 4)(4, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](5, AppointmentComponent_div_0_div_5_Template, 3, 0, "div", 6)(6, AppointmentComponent_div_0_div_6_Template, 5, 1, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](7, "h2");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](9, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](10, AppointmentComponent_div_0_span_10_Template, 2, 2, "span", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](11, " at ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](12, "span", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](14, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](15, "div", 11)(16, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](17, "Job:");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](18, "span", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](20, "div", 13)(21, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](22, "Price:");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](23, "span", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](24);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipe"](25, "currency");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](26, AppointmentComponent_div_0_div_26_Template, 4, 5, "div", 14)(27, AppointmentComponent_div_0_div_27_Template, 5, 1, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](28, "div", 16)(29, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](30, AppointmentComponent_div_0_button_30_Template, 3, 0, "button", 17)(31, AppointmentComponent_div_0_button_31_Template, 3, 1, "button", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](32, "button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function AppointmentComponent_div_0_Template_button_click_32_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r1);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r1.getDirections());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](33, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](34, "Text Me Directions");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()()()()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵattribute"]("id", ctx_r1.mapElmId);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.appointment.isEmergency);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.appointment.status == ctx_r1.AppointmentStatus.Canceled);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate2"]("", ctx_r1.customer == null ? null : ctx_r1.customer.firstName, " ", ctx_r1.customer == null ? null : ctx_r1.customer.lastName, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.address != null);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind2"](14, 14, ctx_r1.appointment.scheduled_Utc, "h:mm a"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", ctx_r1.appointment.jobId, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpipeBind2"](25, 17, ctx_r1.displayPrice, "USD"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.management);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.hasAttachmentItems);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.canAccept);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx_r1.canOpen);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("disabled", !ctx_r1.canGetDirections);
  }
}
let AppointmentComponent = /*#__PURE__*/(() => {
  class AppointmentComponent {
    constructor(uiService, dashboardService, authRefService, appointmentService, deviceRouteService) {
      this.uiService = uiService;
      this.dashboardService = dashboardService;
      this.authRefService = authRefService;
      this.appointmentService = appointmentService;
      this.deviceRouteService = deviceRouteService;
      this.AppointmentStatus = src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_1__.AppointmentStatus;
      // #endregion
      // #region User
      this.activeUser = null;
      // #endregion
      // #region Manager
      this.manager = null;
      this.management = false;
      // #endregion
      // #region Attachment Items
      this.attachmentItems = [];
      // #endregion
      // #region Acceptance
      this.acceptingAppointment = false;
      // #endregion
      // #region Addresses
      this.requestingDirections = false;
      this.directionsCooldown = false;
    }
    watchUser() {
      this.userSubscription = this.authRefService.user.subscribe({
        next: user => {
          this.activeUser = user;
          if (this.activeUser != null) {
            this.activeUser.phone = "+18014997396";
          }
        }
      });
    }
    // #endregion
    // #region Customer
    get customer() {
      return this.appointment?.customer;
    }
    // #endregion
    // #region Price
    get price() {
      return this.appointment?.price;
    }
    get displayPrice() {
      return this.price?.finalPrice ?? 0;
    }
    get hasAttachmentItems() {
      return this.attachmentItems.length > 0;
    }
    initAttachmentItems() {
      if (this.appointment?.price != null) {
        this.appointment.price.details.forEach(detail => {
          detail.lineItems.forEach(lineItem => {
            if (lineItem.isAttachment) {
              if (!this.attachmentItems.includes(lineItem.skuCategory)) {
                this.attachmentItems.push(lineItem.skuCategory);
              }
            }
          });
        });
      }
    }
    // #endregion
    // #region Address
    get address() {
      return this.appointment?.property?.address;
    }
    // #endregion
    // #region Issues
    get hasIssues() {
      return this.appointment?.opportunityPlumbingIssues != null && this.appointment.opportunityPlumbingIssues.length > 0;
    }
    // #endregion
    // #region Contact
    get email() {
      const contactInfo = this.appointment?.customer?.contactInformation ?? [];
      for (var i = 0, len = contactInfo.length; i < len; i++) {
        const info = contactInfo[i];
        if (info.type == src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_2__.ContactInformationType.Email) {
          return info.value;
        }
      }
      return undefined;
    }
    get hasEmail() {
      return this.email != null;
    }
    get phone() {
      const contactInfo = this.appointment?.customer?.contactInformation ?? [];
      for (var i = 0, len = contactInfo.length; i < len; i++) {
        const info = contactInfo[i];
        if (info.type == src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_2__.ContactInformationType.Phone) {
          return info.value;
        }
      }
      return undefined;
    }
    get hasPhone() {
      return this.email != null;
    }
    get mapElmId() {
      return `map${this.appointment?.id}`;
    }
    get mapLink() {
      return `https://www.google.com/maps/dir/?api=1&destination=${this.mappingAddress}`;
    }
    get friendlyAddress() {
      return this.address?.friendlyAddress;
    }
    get mappingAddress() {
      return this.address?.mappingAddress;
    }
    initMap() {
      setTimeout(() => {
        if (this.mappingAddress != null && this.mapElmId != null) {
          this.map = new leaflet__WEBPACK_IMPORTED_MODULE_0__.Map(this.mapElmId, {
            zoomControl: false,
            dragging: false,
            attributionControl: false
          }).setView([37.7749, -122.4194], 13);
          (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.tileLayer)('https://{s}.basemaps.cartocdn.com/rastertiles/voyager/{z}/{x}/{y}{r}.png', {
            subdomains: 'abcd',
            maxZoom: 13
          }).addTo(this.map);
          this.mapAddress(this.mappingAddress);
        }
      }, 0);
    }
    mapAddress(address) {
      this.appointmentService.getCoordinatesForAddress(address).subscribe({
        next: results => {
          if (results.length > 0) {
            if (this.map != null) {
              const nominatim = results[0];
              const coordinates = new leaflet__WEBPACK_IMPORTED_MODULE_0__.LatLng(nominatim.lat, nominatim.lon);
              this.map.setView(coordinates, 15);
              // Add a marker for the address
              (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.marker)(coordinates, {
                icon: (0,leaflet__WEBPACK_IMPORTED_MODULE_0__.icon)({
                  iconSize: [25, 41],
                  iconAnchor: [13, 41],
                  iconUrl: 'assets/images/maps/marker.svg'
                })
              }).bindPopup(`<b>${address}</b>`).addTo(this.map);
            }
          }
        }
      });
    }
    get accepted() {
      return this.appointment?.accepted ?? false;
    }
    acceptAppointment() {
      if (this.appointment != null && !this.acceptingAppointment) {
        this.acceptingAppointment = true;
        this.appointmentService.acceptAppointment(this.appointment.id).subscribe({
          next: () => {
            if (this.appointment != null) {
              this.appointment.accepted = true;
            }
            this.acceptingAppointment = false;
          },
          error: () => {
            this.acceptingAppointment = false;
          }
        });
      }
    }
    get canAccept() {
      return this.appointment != null && !this.management && !this.appointment.accepted && this.appointment.status == src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_1__.AppointmentStatus.Open;
    }
    get canGetDirections() {
      return this.activeUser != null && !this.requestingDirections && !this.directionsCooldown && this.activeUser.phone != null;
    }
    cooldownDirections() {
      this.directionsCooldown = true;
      setTimeout(() => {
        this.directionsCooldown = false;
      }, 10000);
    }
    getDirections() {
      if (this.appointment != null && this.activeUser != null && !this.requestingDirections) {
        this.requestingDirections = true;
        this.appointmentService.getDirections(this.appointment.id, this.activeUser.phone).subscribe({
          next: () => {
            this.uiService.prompt("Directions Sent", "A link for directions to the appointment has been texted to your phone.", "Okay").subscribe({
              next: () => {
                this.cooldownDirections();
                this.requestingDirections = false;
              }
            });
          },
          error: () => {
            this.requestingDirections = false;
          }
        });
      }
    }
    // #endregion
    // #region Open
    goToAppointment() {
      if (this.appointment != null) {
        this.deviceRouteService.viewRouteByType("Appointment", [this.appointment.id], true);
      }
    }
    get canOpen() {
      if (this.appointment != null) {
        return this.appointment.accepted || this.management || this.appointment.status != src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_1__.AppointmentStatus.Open;
      }
      return false;
    }
    init() {
      this.watchUser();
      this.initMap();
      this.initAttachmentItems();
    }
    // #endregion
    ngOnInit() {
      this.init();
    }
    ngOnDestroy() {}
    static #_ = (() => this.ɵfac = function AppointmentComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || AppointmentComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_3__.UiService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_services_dashboard_service__WEBPACK_IMPORTED_MODULE_4__.DashboardService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_5__.AuthRefService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_6__.AppointmentService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_7__.DeviceRouteService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineComponent"]({
      type: AppointmentComponent,
      selectors: [["appointment"]],
      viewQuery: function AppointmentComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        appointment: "appointment",
        manager: "manager",
        management: "management"
      },
      standalone: false,
      decls: 1,
      vars: 1,
      consts: [["class", "appointment", 4, "ngIf"], [1, "appointment"], [1, "map"], [1, "render"], [1, "content"], [1, "info"], ["class", "emergency", 4, "ngIf"], ["class", "canceled", 4, "ngIf"], [1, "meta"], ["class", "address", 4, "ngIf"], [1, "time"], [1, "job"], [1, "value"], [1, "price"], ["class", "acceptance", 3, "accepted", 4, "ngIf"], ["class", "attachments", 4, "ngIf"], [1, "controls"], ["class", "control alternate", 3, "click", 4, "ngIf"], ["class", "control", 3, "disabled", "click", 4, "ngIf"], [1, "control", "open", 3, "click", "disabled"], [1, "emergency"], [1, "canceled"], [1, "address"], [1, "acceptance"], [4, "ngIf"], ["class", "date", 4, "ngIf"], [1, "date"], [1, "attachments"], [1, "items"], ["class", "item", 4, "ngFor", "ngForOf"], [1, "item"], [1, "control", "alternate", 3, "click"], [1, "control", 3, "click", "disabled"]],
      template: function AppointmentComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](0, AppointmentComponent_div_0_Template, 35, 20, "div", 0);
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.appointment != null);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.CurrencyPipe, _angular_common__WEBPACK_IMPORTED_MODULE_9__.DatePipe],
      styles: [".appointment[_ngcontent-%COMP%] {\n  display: flex;\n}\n.appointment[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%] {\n  position: relative;\n  width: 25%;\n}\n.appointment[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  pointer-events: none;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 1vw;\n  flex: 1;\n  display: flex;\n  align-items: flex-start;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%] {\n  flex: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .emergency[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color1) solid;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--errorAlt3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .acceptance.accepted[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--successAlt3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%] {\n  margin-right: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n  position: relative;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:after {\n  content: \", \";\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:last-of-type {\n  margin-right: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:last-of-type:after {\n  content: \"\";\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  display: inline-block;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .address[_ngcontent-%COMP%] {\n  color: var(--color3Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .time[_ngcontent-%COMP%] {\n  color: var(--color3Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  width: 40%;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--color3);\n  border-radius: 999px;\n  border: 0.1vw var(--color2Alt3) solid;\n  padding: 0.25vw 1vw;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transition: border-color 0.1s;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.open[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.open[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-of-type {\n  margin-top: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  margin-top: 0.75vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-radius: 999px;\n  border: 0.1vw var(--color3) solid;\n  width: 100%;\n  margin-left: 0.5vw;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 0.5vw 0;\n  cursor: pointer;\n  text-decoration: none;\n  transition: border-color 0.1s;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return AppointmentComponent;
})();

/***/ }),

/***/ 2880:
/*!*****************************************************************!*\
  !*** ./src/app/dashboard/components/layout/layout.component.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DashboardLayoutComponent: () => (/* binding */ DashboardLayoutComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/navigation/models/navigation */ 9518);
/* harmony import */ var _models_navigation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/navigation */ 8290);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_authentication_services_auth_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/authentication/services/auth.service */ 1619);
/* harmony import */ var src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/navigation/services/device-route.service */ 2405);
/* harmony import */ var src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/shared/ui/services/ui.service */ 345);
/* harmony import */ var _services_dashboard_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../services/dashboard.service */ 5909);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _rc_rc_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../rc/rc.component */ 4198);
/* harmony import */ var _rgm_rgm_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../rgm/rgm.component */ 4258);











const _c0 = ["componentElm"];
function DashboardLayoutComponent_rc_view_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "rc-view", 6);
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassMapInterpolate1"]("route ", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.loadDirection, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("rendered", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.rendered)("animate", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.animating)("closing", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.closing);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("params", ctx_r0.routeParams)("route", ctx_r0.rcRoute);
  }
}
function DashboardLayoutComponent_rgm_view_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "rgm-view", 6);
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassMapInterpolate1"]("route ", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.loadDirection, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵclassProp"]("rendered", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.rendered)("animate", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.animating)("closing", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.closing);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("params", ctx_r0.routeParams)("route", ctx_r0.rgmRoute);
  }
}
let DashboardLayoutComponent = /*#__PURE__*/(() => {
  class DashboardLayoutComponent {
    constructor(authService, deviceRouteService, uiService, dashboardService) {
      this.authService = authService;
      this.deviceRouteService = deviceRouteService;
      this.uiService = uiService;
      this.dashboardService = dashboardService;
      // #region Routes
      this.params = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject([]);
      this.routeParams = new rxjs__WEBPACK_IMPORTED_MODULE_9__.BehaviorSubject([]);
      this.routeLabel = "Your day at a glance";
    }
    get routesInitialized() {
      return this.dashboardService.routesInitialized;
    }
    get routes() {
      return this.dashboardService.routeService.routes;
    }
    watchParams() {
      this.paramsSubscription = this.params.subscribe({
        next: params => {
          const componentElm = this.componentElm?.nativeElement;
          if (componentElm != null) {
            let route = params[0]?.toLowerCase();
            if (route != null) {
              const routeMatches = Object.values(_models_navigation__WEBPACK_IMPORTED_MODULE_1__.DashboardRouteType).includes(route);
              const routeParams = params.slice(1);
              this.routeParams.next(routeParams);
              if (routeMatches) {
                if (!this.routesInitialized) {
                  this.dashboardService.initRoutes(route, componentElm);
                } else {
                  this.viewRoute(route);
                }
              } else {
                if (!this.routesInitialized) {
                  this.dashboardService.initRoutes(undefined, componentElm);
                }
              }
            } else {
              if (!this.routesInitialized) {
                this.dashboardService.initRoutes(undefined, componentElm);
              }
            }
          }
        }
      });
    }
    viewRoute(name) {
      if (name != null) {
        this.dashboardService.routeService.viewRoute(name, src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_0__.RouteLoadDirection.Forward, true);
      }
    }
    watchRoute() {
      this.routeSubscription = this.dashboardService.routeService.activeRoute.subscribe({
        next: route => {
          if (route != null) {
            switch (route.type) {
              case _models_navigation__WEBPACK_IMPORTED_MODULE_1__.DashboardRouteType.team:
                {
                  this.routeLabel = "Your team at a glance";
                }
                break;
              case _models_navigation__WEBPACK_IMPORTED_MODULE_1__.DashboardRouteType.today:
                {
                  this.routeLabel = "Your day at a glance";
                }
            }
          }
        }
      });
    }
    initRouting() {
      setTimeout(() => {
        this.watchParams();
        this.watchRoute();
      }, 0);
    }
    // #endregion
    // #region RC
    get rcRoute() {
      return this.routes[_models_navigation__WEBPACK_IMPORTED_MODULE_1__.DashboardRouteType.today];
    }
    // #endregion
    // #region RGM
    get rgmRoute() {
      return this.routes[_models_navigation__WEBPACK_IMPORTED_MODULE_1__.DashboardRouteType.team];
    }
    init() {
      this.initRouting();
    }
    // #endregion
    ngOnInit() {
      this.init();
    }
    ngOnDestroy() {
      this.paramsSubscription?.unsubscribe();
      this.routeSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function DashboardLayoutComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DashboardLayoutComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_service__WEBPACK_IMPORTED_MODULE_2__.AuthService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_3__.DeviceRouteService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_4__.UiService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_services_dashboard_service__WEBPACK_IMPORTED_MODULE_5__.DashboardService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineComponent"]({
      type: DashboardLayoutComponent,
      selectors: [["ng-component"]],
      viewQuery: function DashboardLayoutComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        params: "params"
      },
      standalone: false,
      decls: 12,
      vars: 3,
      consts: [["componentElm", ""], ["id", "dashboardLayout"], [1, "primary"], [1, "secondary"], [1, "routes"], [3, "class", "params", "route", "rendered", "animate", "closing", 4, "ngIf"], [3, "params", "route"]],
      template: function DashboardLayoutComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h1");
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](5, "Dashboard");
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](6, "div", 3)(7, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](8);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](9, "div", 4);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](10, DashboardLayoutComponent_rc_view_10_Template, 1, 11, "rc-view", 5)(11, DashboardLayoutComponent_rgm_view_11_Template, 1, 11, "rgm-view", 5);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](8);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate"](ctx.routeLabel);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.rcRoute == null ? null : ctx.rcRoute.active);
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.rgmRoute == null ? null : ctx.rgmRoute.active);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_10__.NgIf, _rc_rc_component__WEBPACK_IMPORTED_MODULE_6__.RcComponent, _rgm_rgm_component__WEBPACK_IMPORTED_MODULE_7__.RgmComponent],
      styles: ["@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    transform: translateY(100%);\n  }\n  100% {\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    transform: translateY(100%);\n  }\n  100% {\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#dashboardLayout[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return DashboardLayoutComponent;
})();

/***/ }),

/***/ 4198:
/*!*********************************************************!*\
  !*** ./src/app/dashboard/components/rc/rc.component.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RcComponent: () => (/* binding */ RcComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! chart.js */ 3875);
/* harmony import */ var src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/ui/pipes/order-by.pipe */ 9093);
/* harmony import */ var src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/reminders/models/reminder */ 353);
/* harmony import */ var src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/appointments/models/appointment */ 8723);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var _services_dashboard_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/dashboard.service */ 5909);
/* harmony import */ var src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/shared/reminders/services/reminder.service */ 9654);
/* harmony import */ var src_app_shared_system_services_ai_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/shared/system/services/ai.service */ 3786);
/* harmony import */ var src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/shared/navigation/services/device-route.service */ 2405);
/* harmony import */ var src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/shared/authentication/services/auth-ref.service */ 4387);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/shared/appointments/services/appointment.service */ 8036);
/* harmony import */ var _shared_appointments_components_appointment_summary_appointment_summary_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../shared/appointments/components/appointment-summary/appointment-summary.component */ 2814);
/* harmony import */ var _reminders_reminders_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../reminders/reminders.component */ 4938);

















function RcComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](0, "div", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelement"](1, "img", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("src", ctx_r0.profileImage, _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵsanitizeUrl"]);
  }
}
function RcComponent_p_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtextInterpolate1"](" ", ctx_r0.summaryText, " ");
  }
}
function RcComponent_div_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](0, "div", 19)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelement"](3, "div", 20)(4, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtextInterpolate"](ctx_r0.summaryLoaderLabel);
  }
}
function RcComponent_div_35_appointment_summary_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelement"](0, "appointment-summary", 23);
  }
  if (rf & 2) {
    const appointment_r2 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("appointment", appointment_r2);
  }
}
function RcComponent_div_35_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](0, "div", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtemplate"](1, RcComponent_div_35_appointment_summary_1_Template, 1, 1, "appointment-summary", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("ngForOf", ctx_r0.sortedAppointments);
  }
}
function RcComponent_div_36_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](0, "div", 24)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](2, " You currently have no appointments scheduled for today. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](3, "div", 25)(4, "button", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵlistener"]("click", function RcComponent_div_36_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵrestoreView"](_r3);
      const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵresetView"](ctx_r0.goToAppointments());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](5, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](6, " Go to Book of Business ");
    _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()()()();
  }
}
chart_js__WEBPACK_IMPORTED_MODULE_12__.Chart.register(chart_js__WEBPACK_IMPORTED_MODULE_12__.CategoryScale, chart_js__WEBPACK_IMPORTED_MODULE_12__.Filler, chart_js__WEBPACK_IMPORTED_MODULE_12__.Tooltip, chart_js__WEBPACK_IMPORTED_MODULE_12__.LinearScale, chart_js__WEBPACK_IMPORTED_MODULE_12__.LineController, chart_js__WEBPACK_IMPORTED_MODULE_12__.LineElement, chart_js__WEBPACK_IMPORTED_MODULE_12__.PointElement, chart_js__WEBPACK_IMPORTED_MODULE_12__.Title);
let RcComponent = /*#__PURE__*/(() => {
  class RcComponent {
    constructor(http, dashboardService, reminderService, aiService, deviceRouteService, authRefService, datePipe, currencyPipe, orderByPipe, appointmentService) {
      this.http = http;
      this.dashboardService = dashboardService;
      this.reminderService = reminderService;
      this.aiService = aiService;
      this.deviceRouteService = deviceRouteService;
      this.authRefService = authRefService;
      this.datePipe = datePipe;
      this.currencyPipe = currencyPipe;
      this.orderByPipe = orderByPipe;
      this.appointmentService = appointmentService;
      // #region User
      this.user = null;
      // #endregion
      // #region Close Percentage
      this.closePercentage = 0.00;
      // #endregion
      // #endregion
      // #region Reminders
      this.reminders = [];
      // #endregion
      // #region Summary
      this.retrievingSummary = false;
      this.summaryLoaderLabel = "Your AI summary for today...";
      this.summaryText = "generating ai summmary...";
      // #endregion
      // #region Appointments
      this.AppointmentStatus = src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus;
      this.retrievingAppointments = false;
      this.appointments = [];
      this.todaysAppointments = [];
      this.sortedAppointments = [];
      // #endregion
      // #region Bootstrapping
      this.userId = new rxjs__WEBPACK_IMPORTED_MODULE_13__.BehaviorSubject(undefined);
      this.params = new rxjs__WEBPACK_IMPORTED_MODULE_13__.BehaviorSubject([]);
      this.today = new Date();
    }
    get firstName() {
      return this.user?.firstName ?? "";
    }
    get profileImage() {
      return this.user?.profileImage_B64;
    }
    watchUser() {
      this.userSubscription = this.authRefService.user.subscribe({
        next: user => {
          this.user = user;
        }
      });
    }
    get outstandingCriticalTasks() {
      const reminders = [];
      this.reminders.forEach(reminder => {
        if (reminder.priority == src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_1__.ReminderPriority.Critical) {
          reminders.push(reminder);
        }
      });
      return reminders;
    }
    finalizeReminders(reminders) {
      this.reminders = reminders;
      this.initSummaryText();
    }
    initSummaryText() {
      this.summaryText = this.aiService.generateDailySummary(this.todaysAppointments, this.reminders);
    }
    get hasAppointments() {
      return this.sortedAppointments.length > 0;
    }
    get loadingUpcomingAppointment() {
      return this.retrievingAppointments;
    }
    sortAppointments(property) {
      this.sortedAppointments = this.orderByPipe.transform(this.todaysAppointments, property);
    }
    validateAppointments(appointments) {
      for (var i = 0, len = appointments.length; i < len; i++) {
        const appointment = appointments[i];
        const nextAppointment = appointments[i + 1];
        if (appointment.status == src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus.Open && nextAppointment != null) {
          nextAppointment.available = false;
        }
      }
    }
    getAppointmentsForToday(appointments) {
      const todayAppointments = [];
      const today = new Date();
      const year = today.getFullYear();
      const month = today.getMonth();
      const date = today.getDate();
      appointments.forEach(appointment => {
        if (appointment.scheduled_Utc != null) {
          const appYear = appointment.scheduled_Utc.getFullYear();
          const appMonth = appointment.scheduled_Utc.getMonth();
          const appDate = appointment.scheduled_Utc.getDate();
          if (appYear == year && appMonth == month && appDate == date) {
            todayAppointments.push(appointment);
          }
        }
      });
      return todayAppointments;
    }
    getAppointments() {
      this.retrievingAppointments = true;
      this.appointmentService.getAppointments().subscribe({
        next: appointments => {
          this.appointments = appointments;
          this.todaysAppointments = this.getAppointmentsForToday(appointments);
          this.sortAppointments("scheduled_Utc");
          this.validateAppointments(this.todaysAppointments);
          this.upcomingAppointment = this.sortedAppointments[0];
          this.initSummaryText();
          this.retrievingAppointments = false;
        },
        error: () => {
          this.retrievingAppointments = false;
        }
      });
    }
    goToAppointments() {
      this.deviceRouteService.viewRouteByType("Appointments", ['all'], true);
    }
    initAppointments() {
      this.getAppointments();
    }
    watchParams() {
      this.paramsSubscription = this.params.subscribe({
        next: params => {
          let route = params[0]?.toLowerCase();
          if (route != null) {}
        }
      });
    }
    init() {
      this.watchParams();
      this.watchUser();
      this.initAppointments();
    }
    // #endregion
    ngAfterViewInit() {
      setTimeout(() => {
        this.init();
        setTimeout(() => {
          if (this.route != null) {
            this.route.initialized.next();
          }
        }, 32);
      }, 16);
    }
    ngOnDestroy() {
      this.userSubscription?.unsubscribe();
      this.paramsSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function RcComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || RcComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_14__.HttpClient), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](_services_dashboard_service__WEBPACK_IMPORTED_MODULE_3__.DashboardService), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_4__.ReminderService), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](src_app_shared_system_services_ai_service__WEBPACK_IMPORTED_MODULE_5__.AiService), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_6__.DeviceRouteService), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_7__.AuthRefService), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_15__.DatePipe), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_15__.CurrencyPipe), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_0__.OrderByPipe), _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdirectiveInject"](src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_8__.AppointmentService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdefineComponent"]({
      type: RcComponent,
      selectors: [["rc-view"]],
      inputs: {
        userId: "userId",
        route: "route",
        params: "params"
      },
      standalone: false,
      features: [_angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵProvidersFeature"]([src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_0__.OrderByPipe])],
      decls: 37,
      vars: 13,
      consts: [["id", "rcView"], [1, "primary"], [1, "content"], [1, "summary", "card"], ["class", "profile", 4, "ngIf"], [4, "ngIf"], ["class", "loader", 4, "ngIf"], [1, "closing"], [1, "tile"], [1, "bg"], [1, "value"], [1, "focus"], [1, "column", "tasks"], [3, "retrieved", "activeUser", "appointments"], [1, "column", "appointments"], ["class", "appointments", 4, "ngIf"], ["class", "message", 4, "ngIf"], [1, "profile"], [3, "src"], [1, "loader"], [1, "bar"], [1, "appointments"], [3, "appointment", 4, "ngFor", "ngForOf"], [3, "appointment"], [1, "message"], [1, "controls"], [1, "control", 3, "click"]],
      template: function RcComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](0, "section", 0)(1, "div", 1)(2, "div", 2)(3, "div", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtemplate"](4, RcComponent_div_4_Template, 2, 1, "div", 4);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](5, "div", 2)(6, "header")(7, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](8);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵpipe"](9, "date");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](10, "h3");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](11);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](12, "div", 2);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtemplate"](13, RcComponent_p_13_Template, 2, 1, "p", 5)(14, RcComponent_div_14_Template, 5, 1, "div", 6);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](15, "div", 7)(16, "div", 8);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelement"](17, "div", 9);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](18, "div", 2)(19, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](20, "4-week Close Percentage");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](21, "p");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](22, "Your appointment sell-through rate.");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](23, "span", 10);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](24);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()()()()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](25, "div", 11)(26, "div", 2)(27, "div", 12)(28, "reminders", 13);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵlistener"]("retrieved", function RcComponent_Template_reminders_retrieved_28_listener($event) {
            return ctx.finalizeReminders($event);
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](29, "div", 14)(30, "header")(31, "div", 1)(32, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtext"](33, " Today's Appointments ");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementStart"](34, "div", 2);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtemplate"](35, RcComponent_div_35_Template, 2, 1, "div", 15)(36, RcComponent_div_36_Template, 7, 0, "div", 16);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵelementEnd"]()()()()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("ngIf", ctx.profileImage != null);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtextInterpolate1"]("Your daily summary for ", _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵpipeBind2"](9, 10, ctx.today, "EEEE, MMMM d"), "");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtextInterpolate1"]("Welcome back, ", ctx.firstName, "");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("ngIf", !ctx.retrievingSummary);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("ngIf", ctx.retrievingSummary);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](10);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵtextInterpolate1"](" ", ctx.closePercentage, "% ");
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("activeUser", ctx.user)("appointments", ctx.appointments);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"](7);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("ngIf", ctx.hasAppointments);
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵproperty"]("ngIf", !ctx.hasAppointments);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_15__.NgIf, _shared_appointments_components_appointment_summary_appointment_summary_component__WEBPACK_IMPORTED_MODULE_9__.AppointmentSummaryComponent, _reminders_reminders_component__WEBPACK_IMPORTED_MODULE_10__.RemindersComponent, _angular_common__WEBPACK_IMPORTED_MODULE_15__.DatePipe],
      styles: ["@keyframes _ngcontent-%COMP%_closeLoadIn {\n  0% {\n    opacity: 0;\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n#rcView[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 2vw;\n  right: 2vw;\n  bottom: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%] {\n  width: 70%;\n  border-radius: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n  background-color: var(--color6);\n  border: 0.1vw var(--color6Alt3) solid;\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  display: flex;\n  align-items: flex-start;\n  height: 15vw;\n  margin-right: 1vw;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n  position: relative;\n  z-index: 1;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 2.2vw;\n  white-space: nowrap;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw 1vw;\n  background-color: rgba(var(--color6-raw), 0.6);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  border-radius: 1vw;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strongest);\n  font-style: italic;\n  text-transform: lowercase;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%] {\n  margin-top: 0.8vw;\n  border-radius: 999px;\n  position: relative;\n  height: 1.4vw;\n  background-color: var(--color2Alt2);\n  overflow: hidden;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:before {\n  content: \"\";\n  display: block;\n  position: absolute;\n  border-radius: 999px;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  transform: translateX(-100%);\n  animation-name: barLoader;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n  background-color: var(--color2Alt1);\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(2):before {\n  animation-name: barLoader;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 0.5s;\n  animation-fill-mode: forwards;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(3):before {\n  animation-name: barLoader;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 1s;\n  animation-fill-mode: forwards;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%] {\n  width: 10vw;\n  height: 100%;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  mix-blend-mode: multiply;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%] {\n  width: 30%;\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  border: 0.1vw var(--color1) solid;\n  position: relative;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 0;\n  background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100%25' height='100%25' viewBox='0 0 800 400'%3E%3Cdefs%3E%3CradialGradient id='a' cx='396' cy='281' r='514' gradientUnits='userSpaceOnUse'%3E%3Cstop offset='0' stop-color='%23D18'/%3E%3Cstop offset='1' stop-color='%23330000'/%3E%3C/radialGradient%3E%3ClinearGradient id='b' gradientUnits='userSpaceOnUse' x1='400' y1='148' x2='400' y2='333'%3E%3Cstop offset='0' stop-color='%23FA3' stop-opacity='0'/%3E%3Cstop offset='1' stop-color='%23FA3' stop-opacity='0.5'/%3E%3C/linearGradient%3E%3C/defs%3E%3Crect fill='url(%23a)' width='800' height='400'/%3E%3Cg fill-opacity='0.4'%3E%3Ccircle fill='url(%23b)' cx='267.5' cy='61' r='300'/%3E%3Ccircle fill='url(%23b)' cx='532.5' cy='61' r='300'/%3E%3Ccircle fill='url(%23b)' cx='400' cy='30' r='300'/%3E%3C/g%3E%3C/svg%3E\");\n  background-size: cover;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  transform: translateY(-50%);\n  width: 100%;\n  padding: 0 2vw;\n  z-index: 1;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 2.1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--color2Alt2);\n  font-size: 1.6vw;\n}\n#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 7vw;\n  color: var(--color2);\n  font-weight: var(--strongest);\n  line-height: 1;\n  animation-name: _ngcontent-%COMP%_closeLoadIn;\n  animation-iteration-count: 1;\n  animation-timing-function: linear;\n  animation-duration: 2s;\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%] {\n  flex: 1;\n  margin-top: 1vw;\n  position: relative;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  height: 100%;\n  position: relative;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  margin-left: 1vw;\n  overflow-x: hidden;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tasks[_ngcontent-%COMP%] {\n  width: calc(40% - 0.5vw);\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%] {\n  height: 100%;\n  width: calc(60% - 0.5vw);\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  z-index: 1;\n  padding: 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding-top: 2vw;\n  position: relative;\n  z-index: 0;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .appointments[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden;\n  padding: 0 1vw 1vw;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .appointments[_ngcontent-%COMP%]    > appointment-summary[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .appointments[_ngcontent-%COMP%]    > appointment-summary[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin: 5vw auto 0;\n  width: 60%;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n  text-align: center;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%] {\n  position: relative;\n  overflow: hidden;\n  height: 100%;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  flex: 1;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%] {\n  border-radius: 0.5vw;\n  overflow: hidden;\n  opacity: 0;\n  transition: opacity 0.2s linear;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%]   #routeMap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  transform: translate3d(-50%, 0, 0);\n  top: 2vw;\n  z-index: 1;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 8vw;\n  width: 8vw;\n  -moz-filter: saturate(0);\n  -o-filter: saturate(0);\n  -ms-filter: saturate(0);\n  filter: saturate(0);\n  opacity: 0.6;\n}\n#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  font-size: 1.6vw;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  font-weight: var(--ltweight);\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9zdHlsZXMvX21peGlucy5zY3NzIiwid2VicGFjazovLy4vc3JjL2FwcC9kYXNoYm9hcmQvY29tcG9uZW50cy9yYy9yYy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFpaUJJO0VDOWhCQTtJQUNJLFVBQUE7SURnT0osc0JDL04yQjtJRGdPM0Isb0JDaE8yQjtJRGlPM0IscUJDak8yQjtJRGtPM0IsaUJDbE8yQjtFQXlEN0I7RUF0REU7SUFDSSxVQUFBO0lEMk5KLG9CQzFOMkI7SUQyTjNCLGtCQzNOMkI7SUQ0TjNCLG1CQzVOMkI7SUQ2TjNCLGVDN04yQjtFQTREN0I7QUFDRjtBQXpEQTtFQUNJLGtCQUFBO0VEMGhCQSx3Q0N6aEJzQjtFRDBoQnRCLFNDMWhCcUU7RUQyaEJyRSxVQzNoQjJEO0VENGhCM0QsV0M1aEJnRTtFQUNoRSxhQUFBO0VBQ0Esc0JBQUE7QUE4REo7QUEzRFE7RUFDSSxhQUFBO0FBNkRaO0FBM0RZO0VBQ0ksVUFBQTtFQUNBLGtCQUFBO0VBQ0Esa0JBQUE7RUFDQSxnQkFBQTtFQUNBLGtCQUFBO0VBQ0EsK0JBQUE7RUFDQSxxQ0FBQTtFRHFNWixnRUNwTW1DO0VEcU1uQyw4RENyTW1DO0VEc01uQywrREN0TW1DO0VEdU1uQywyREN2TW1DO0VBQ3ZCLGFBQUE7RUFDQSx1QkFBQTtFQUNBLFlBQUE7RUFDQSxpQkFBQTtBQWlFaEI7QUEvRGdCO0VBQ0ksT0FBQTtFQUNBLFdBQUE7RUFDQSxrQkFBQTtFQUNBLFVBQUE7QUFpRXBCO0FBL0RvQjtFQUNJLFlBQUE7QUFpRXhCO0FBL0R3QjtFQUNJLGNBQUE7RUFDQSxnQkFBQTtFQUNBLG1CQUFBO0VBQ0Esb0JBQUE7RUFDQSw0QkFBQTtBQWlFNUI7QUE5RHdCO0VBQ0ksZ0JBQUE7RUFDQSx3QkFBQTtFQUNBLDZCQUFBO0FBZ0U1QjtBQTVEb0I7RUFDSSxzQkFBQTtFQUNBLDhDQUFBO0VEMktwQixvQ0MxS29EO0VEMktwRCxpQ0MzS29EO0VENEtwRCwrQkM1S29EO0VEOEtwRCw0QkM5S29EO0VBQ2hDLGtCQUFBO0FBa0V4QjtBQWhFd0I7RUFDSSxnQkFBQTtFQUNBLG9CQUFBO0VBQ0EsMEJBQUE7QUFrRTVCO0FBOUQ0QjtFQUNJLGdCQUFBO0VBQ0Esd0JBQUE7RUFDQSw2QkFBQTtFQUNBLGtCQUFBO0VBQ0EseUJBQUE7QUFnRWhDO0FBN0Q0QjtFQUNJLGlCQUFBO0VBQ0Esb0JBQUE7RUFDQSxrQkFBQTtFQUNBLGFBQUE7RUFDQSxtQ0FBQTtFQUNBLGdCQUFBO0FBK0RoQztBQTdEZ0M7RUFDSSxXQUFBO0VBQ0EsY0FBQTtFQUNBLGtCQUFBO0VBQ0Esb0JBQUE7RUQwY2hDLE1DemNzRDtFRDBjdEQsT0MxYytEO0VEMmMvRCxRQzNjeUQ7RUQ0Y3pELFNDNWM0RDtFRDJaNUQsNEJDMVowRDtFRGdXMUQseUJDL1YwRDtFRG9XMUQsbUNDcFdxRTtFRHlXckUsaUNDelcrRTtFRDhXL0Usc0JDOVd1RjtFRG1YdkYsMkJBekI2RTtFQThCN0UsbUJBOUI2RDtFQW1DN0QsNkJBbkNpRztFQ3pWakUsbUNBQUE7QUF3R3BDO0FBcEdvQztFRDBWaEMseUJDelY4RDtFRDhWOUQsbUNDOVZ5RTtFRG1XekUsaUNDbldtRjtFRHdXbkYsc0JDeFcyRjtFRDZXM0YsMkJBekI2RTtFQThCN0UscUJDbFgrRjtFRHVYL0YsNkJBbkNpRztBQzVNckc7QUFuSW9DO0VEb1ZoQyx5QkNuVjhEO0VEd1Y5RCxtQ0N4VnlFO0VENlZ6RSxpQ0M3Vm1GO0VEa1duRixzQkNsVzJGO0VEdVczRiwyQkF6QjZFO0VBOEI3RSxtQkM1VytGO0VEaVgvRiw2QkFuQ2lHO0FDdktyRztBQS9KZ0I7RUFDSSxXQUFBO0VBQ0EsWUFBQTtFQUNBLGdCQUFBO0VBQ0EsVUFBQTtFQUNBLG9CQUFBO0VBQ0Esd0JBQUE7QUFpS3BCO0FBL0pvQjtFQUNJLFlBQUE7RUFDQSxXQUFBO0VEdUZwQix5QkN0RitDO0VEdUYvQyxzQkN2RitDO0VEd0YvQyx5QkN4RitDO0VEeUYvQyxpQkN6RitDO0FBb0tuRDtBQS9KWTtFQUNJLFVBQUE7RUQ2RlosZ0VDNUZtQztFRDZGbkMsOERDN0ZtQztFRDhGbkMsK0RDOUZtQztFRCtGbkMsMkRDL0ZtQztBQXFLdkM7QUFuS2dCO0VBQ0ksV0FBQTtFQUNBLFlBQUE7RUFDQSxpQ0FBQTtFQUNBLGtCQUFBO0VBQ0Esa0JBQUE7RUFDQSxnQkFBQTtBQXFLcEI7QUFuS29CO0VBQ0ksa0JBQUE7RURzWnBCLE1DclowQztFRHNaMUMsT0N0Wm1EO0VEdVpuRCxRQ3ZaNkM7RUR3WjdDLFNDeFpnRDtFQUM1QixVQUFBO0VBQ0EsdTFCQUFBO0VBQ0Esc0JBQUE7QUF3S3hCO0FBcktvQjtFRHFhaEIsa0JDcGE0QztFRHFhNUMsUUFBQTtFQUtBLDJCQUFBO0VDemFvQixXQUFBO0VBQ0EsY0FBQTtFQUNBLFVBQUE7QUE2S3hCO0FBM0t3QjtFQUNJLGdCQUFBO0VBQ0Esb0JBQUE7RUFDQSwwQkFBQTtBQTZLNUI7QUExS3dCO0VBQ0ksd0JBQUE7RUFDQSxnQkFBQTtBQTRLNUI7QUF6S3dCO0VBQ0ksY0FBQTtFQUNBLGNBQUE7RUFDQSxvQkFBQTtFQUNBLDZCQUFBO0VBQ0EsY0FBQTtFRGlSeEIsMkJDaFJrRDtFRHFSbEQsNEJDclIrRDtFRDBSL0QsaUNDMVJrRTtFRCtSbEUsc0JDL1IwRTtFRG9TMUUsMkJBekI2RTtFQThCN0UsbUJBOUI2RDtFQW1DN0QsNkJBbkNpRztBQzlEckc7QUFyTUk7RUFDSSxPQUFBO0VBQ0EsZUFBQTtFQUNBLGtCQUFBO0FBdU1SO0FBck1RO0VBQ0ksa0JBQUE7RUQwV1IsTUN6VzhCO0VEMFc5QixPQzFXdUM7RUQyV3ZDLFFDM1dpQztFRDRXakMsU0M1V29DO0VBQzVCLGFBQUE7QUEwTVo7QUF4TVk7RUFDSSxZQUFBO0VBQ0Esa0JBQUE7RUFDQSxrQkFBQTtFQUNBLCtCQUFBO0VENkJaLGdFQzVCbUM7RUQ2Qm5DLDhEQzdCbUM7RUQ4Qm5DLCtEQzlCbUM7RUQrQm5DLDJEQy9CbUM7RUFDdkIsZ0JBQUE7RUFDQSxrQkFBQTtBQThNaEI7QUE1TWdCO0VBQ0ksY0FBQTtBQThNcEI7QUExTVk7RUFDSSx3QkFBQTtBQTRNaEI7QUF6TVk7RUFDSSxZQUFBO0VBQ0Esd0JBQUE7QUEyTWhCO0FBek1nQjtFQUNJLFVBQUE7RUFDQSxZQUFBO0VBQ0EsK0JBQUE7RUFDQSw0Q0FBQTtFQUNBLGdCQUFBO0VBQ0EsTUFBQTtFQUNBLFVBQUE7RUFDQSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQTJNcEI7QUF4TXdCO0VBQ0ksZ0JBQUE7RUFDQSxvQkFBQTtFQUNBLDBCQUFBO0FBME01QjtBQXJNZ0I7RUFDSSxnQkFBQTtFQUNBLGtCQUFBO0VBQ0EsVUFBQTtBQXVNcEI7QUFyTW9CO0VBQ0ksWUFBQTtFQUNBLFdBQUE7RUFDQSxrQkFBQTtFQUNBLGtCQUFBO0FBdU14QjtBQXJNd0I7RUFDSSxjQUFBO0VBQ0EsV0FBQTtFQUNBLGVBQUE7RUFDQSxvQkFBQTtFQUNBLGdCQUFBO0VBQ0EscUNBQUE7QUF1TTVCO0FBck00QjtFQUNJLGFBQUE7QUF1TWhDO0FBbE1vQjtFQUNJLGtCQUFBO0VBQ0EsVUFBQTtBQW9NeEI7QUFsTXdCO0VBQ0ksY0FBQTtFQUNBLHdCQUFBO0VBQ0EsNEJBQUE7RUFDQSxrQkFBQTtBQW9NNUI7QUFqTXdCO0VBQ0ksZUFBQTtFQUNBLGFBQUE7RUFDQSx1QkFBQTtBQW1NNUI7QUFqTTRCO0VBQ0ksZUFBQTtFQUNBLGNBQUE7RUFDQSxrQkFBQTtBQW1NaEM7QUFqTWdDO0VBQ0ksY0FBQTtFQUNBLG9CQUFBO0VBQ0EsNEJBQUE7QUFtTXBDO0FBM0xZO0VBQ0ksa0JBQUE7RUFDQSxnQkFBQTtFQUNBLFlBQUE7QUE2TGhCO0FBM0xnQjtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0VBQ0EsWUFBQTtBQTZMcEI7QUExTHdCO0VBQ0ksZ0JBQUE7RUFDQSxvQkFBQTtFQUNBLDBCQUFBO0FBNEw1QjtBQXZMd0I7RUFDSSxlQUFBO0FBeUw1QjtBQXZMNEI7RUFDSSxnQkFBQTtFQUNBLG9CQUFBO0FBeUxoQztBQW5MZ0I7RUFDSSxrQkFBQTtFQUNBLFlBQUE7RUFDQSxPQUFBO0FBcUxwQjtBQW5Mb0I7RUFDSSxvQkFBQTtFQUNBLGdCQUFBO0VBQ0EsVUFBQTtFRDRMcEIsK0JBQUE7QUNISjtBQXRMd0I7RUFDSSxrQkFBQTtFRHVOeEIsTUN0TjhDO0VEdU45QyxPQ3ZOdUQ7RUR3TnZELFFDeE5pRDtFRHlOakQsU0N6Tm9EO0FBMkx4RDtBQXhMd0I7RUFDSSxVQUFBO0FBMEw1QjtBQXRMb0I7RUR5TmhCLGtCQ3hONEM7RUR5TjVDLFNBQUE7RUExREEsa0NBMkRtQjtFQ3pOQyxRQUFBO0VBQ0EsVUFBQTtFQUNBLGFBQUE7RUFDQSxzQkFBQTtFQUNBLG1CQUFBO0FBOEx4QjtBQTVMd0I7RUFDSSxjQUFBO0VBQ0EsV0FBQTtFQUNBLFVBQUE7RURsSXhCLHdCQ21JK0M7RURsSS9DLHNCQ2tJK0M7RURqSS9DLHVCQ2lJK0M7RURoSS9DLG1CQ2dJK0M7RUFDdkIsWUFBQTtBQWtNNUI7QUEvTHdCO0VBQ0ksZUFBQTtFQUNBLGdCQUFBO0VBQ0EsbUJBQUE7RUFDQSx3QkFBQTtFQUNBLDRCQUFBO0FBaU01QiIsInNvdXJjZXNDb250ZW50IjpbIkB1c2UgXCJzYXNzOmNvbG9yXCI7XHJcbkB1c2UgXCJzYXNzOmxpc3RcIjtcclxuJG1pbkJyZWFrVGFibGV0OiA2MDBweDtcclxuXHJcbi8vIFN0cnVjdHVyZSBtaXhpbnNcclxuXHJcbkBtaXhpbiByZXNldCgpIHtcclxuICAgIC1tb3otYm94LXNpemluZzogYm9yZGVyLWJveDtcclxuICAgIC13ZWJraXQtYm94LXNpemluZzogYm9yZGVyLWJveDtcclxuICAgIGJveC1zaXppbmc6IGJvcmRlci1ib3g7XHJcbiAgICBtYXJnaW46IDA7XHJcbiAgICBwYWRkaW5nOiAwO1xyXG5cclxuICAgICoge1xyXG4gICAgICAgIC1tb3otYm94LXNpemluZzogYm9yZGVyLWJveDtcclxuICAgICAgICAtd2Via2l0LWJveC1zaXppbmc6IGJvcmRlci1ib3g7XHJcbiAgICAgICAgYm94LXNpemluZzogYm9yZGVyLWJveDtcclxuICAgICAgICBtYXJnaW46IDA7XHJcbiAgICAgICAgcGFkZGluZzogMDtcclxuICAgIH1cclxuXHJcbiAgICBwIHtcclxuICAgICAgICBmb250LXNpemU6ICRpbml0aWFsdGV4dDtcclxuICAgICAgICBsaW5lLWhlaWdodDogMTtcclxuICAgIH1cclxufVxyXG5cclxuLy8gVHlwb2dyYXBoeSBtaXhpbnNcclxuXHJcbkBtaXhpbiBwb2ludGVyLWV2ZW50cygkdmFsdWUpIHtcclxuICAgIC1tcy1wb2ludGVyLWV2ZW50czogJHZhbHVlO1xyXG4gICAgcG9pbnRlci1ldmVudHM6ICR2YWx1ZTtcclxufVxyXG5cclxuQG1peGluIGVtcGhhc2lzKCkge1xyXG4gICAgZm9udC1zdHlsZTogaXRhbGljO1xyXG59XHJcblxyXG5AbWl4aW4gZWxsaXBzaXMoKSB7XHJcbiAgICAtbXMtdGV4dC1vdmVyZmxvdzogZWxsaXBzaXM7XHJcbiAgICAtby10ZXh0LW92ZXJmbG93OiBlbGxpcHNpcztcclxuICAgIHRleHQtb3ZlcmZsb3c6IGVsbGlwc2lzO1xyXG4gICAgZGlzcGxheTogYmxvY2s7XHJcbiAgICB3aGl0ZS1zcGFjZTogbm93cmFwO1xyXG4gICAgb3ZlcmZsb3c6IGhpZGRlbjtcclxufVxyXG5cclxuQG1peGluIG11bHRpbGluZS1lbGxpcHNpcygkbGluZXMpIHtcclxuICAgIG92ZXJmbG93OiBoaWRkZW47XHJcbiAgICB0ZXh0LW92ZXJmbG93OiBlbGxpcHNpcztcclxuICAgIGRpc3BsYXk6IC13ZWJraXQtYm94O1xyXG4gICAgLXdlYmtpdC1saW5lLWNsYW1wOiAkbGluZXM7XHJcbiAgICAtd2Via2l0LWJveC1vcmllbnQ6IHZlcnRpY2FsO1xyXG59XHJcblxyXG5AbWl4aW4gaWNvbi1mb250KCRmYW1pbHkpIHtcclxuICAgIGZvbnQtZmFtaWx5OiAkZmFtaWx5ICAhaW1wb3J0YW50O1xyXG4gICAgdGV4dC10cmFuc2Zvcm06IG5vbmUgIWltcG9ydGFudDtcclxuICAgIGZvbnQtd2VpZ2h0OiBub3JtYWwgIWltcG9ydGFudDtcclxuICAgIGZvbnQtdmFyaWFudDogbm9ybWFsICFpbXBvcnRhbnQ7XHJcbiAgICAtd2Via2l0LWZvbnQtc21vb3RoaW5nOiBhbnRpYWxpYXNlZCAhaW1wb3J0YW50O1xyXG4gICAgLW1vei1vc3gtZm9udC1zbW9vdGhpbmc6IGdyYXlzY2FsZSAhaW1wb3J0YW50O1xyXG4gICAgc3BlYWs6IG5vbmUgIWltcG9ydGFudDtcclxufVxyXG5cclxuQG1peGluIHRleHQtYWxpZ24oJHZhbHVlLCAkcmVzcG9uc2l2ZVZhbHVlOiBudWxsLCAkYnJlYWtwb2ludDogbnVsbCkge1xyXG4gICAgdGV4dC1hbGlnbjogJHZhbHVlO1xyXG5cclxuICAgIEBtZWRpYSBvbmx5IHNjcmVlbiBhbmQgKG1heC13aWR0aCA6ICRicmVha3BvaW50KSB7XHJcbiAgICAgICAgdGV4dC1hbGlnbjogJHJlc3BvbnNpdmVWYWx1ZTtcclxuICAgIH1cclxufVxyXG5cclxuQG1peGluIHRvdWNoLWNhbGxvdXQoJHZhbHVlOiBub25lKSB7XHJcbiAgICAtd2Via2l0LXRvdWNoLWNhbGxvdXQ6ICR2YWx1ZTtcclxuICAgIHRvdWNoLWNhbGxvdXQ6ICR2YWx1ZTtcclxufVxyXG5cclxuQG1peGluIGRpc2FibGUtZHJhZygpIHtcclxuICAgIC13ZWJraXQtdXNlci1kcmFnOiBub25lO1xyXG4gICAgdXNlci1kcmFnOiBub25lO1xyXG4gICAgdXNlci1zZWxlY3Q6IG5vbmU7XHJcbn1cclxuXHJcbkBtaXhpbiB1c2VyLXNlbGVjdCgkdmFsdWU6IG5vbmUpIHtcclxuICAgIEBpbmNsdWRlIHRvdWNoLWNhbGxvdXQobm9uZSk7XHJcbiAgICAtd2Via2l0LXVzZXItc2VsZWN0OiAkdmFsdWU7XHJcbiAgICAtbW96LXVzZXItc2VsZWN0OiAkdmFsdWU7XHJcbiAgICAtbXMtdXNlci1zZWxlY3Q6ICR2YWx1ZTtcclxuICAgIHVzZXItc2VsZWN0OiAkdmFsdWU7XHJcblxyXG4gICAgaW5wdXQsXHJcbiAgICB0ZXh0YXJlYSxcclxuICAgIFtjb250ZW50ZWRpdGFibGVdIHtcclxuICAgICAgICAtd2Via2l0LXVzZXItc2VsZWN0OiB0ZXh0O1xyXG4gICAgICAgIC1tb3otdXNlci1zZWxlY3Q6IHRleHQ7XHJcbiAgICAgICAgLW1zLXVzZXItc2VsZWN0OiB0ZXh0O1xyXG4gICAgICAgIHVzZXItc2VsZWN0OiB0ZXh0O1xyXG4gICAgICAgIGN1cnNvcjogdGV4dDtcclxuICAgIH1cclxufVxyXG5cclxuQG1peGluIGNvbHVtbnMoJGNvdW50OiBudWxsLCAkd2lkdGg6IG51bGwsICRnYXA6IG51bGwsICRydWxlU3R5bGU6IG51bGwsICRydWxlV2lkdGg6IG51bGwsICRydWxlQ29sb3I6IG51bGwpIHtcclxuICAgIC13ZWJraXQtY29sdW1uLWNvdW50OiAkY291bnQ7XHJcbiAgICAtbW96LWNvbHVtbi1jb3VudDogJGNvdW50O1xyXG4gICAgY29sdW1uLWNvdW50OiAkY291bnQ7XHJcbiAgICAtd2Via2l0LWNvbHVtbi1nYXA6ICRnYXA7XHJcbiAgICAtbW96LWNvbHVtbi1nYXA6ICRnYXA7XHJcbiAgICBjb2x1bW4tZ2FwOiAkZ2FwO1xyXG4gICAgLXdlYmtpdC1jb2x1bW4td2lkdGg6ICR3aWR0aDtcclxuICAgIC1tb3otY29sdW1uLXdpZHRoOiAkd2lkdGg7XHJcbiAgICBjb2x1bW4td2lkdGg6ICR3aWR0aDtcclxufVxyXG5cclxuQG1peGluIGFwcGVhcmFuY2UoJGFwcGVhcmFuY2U6IG51bGwpIHtcclxuICAgIC1tb3otYXBwZWFyYW5jZTogJGFwcGVhcmFuY2U7XHJcbiAgICAtd2Via2l0LWFwcGVhcmFuY2U6ICRhcHBlYXJhbmNlO1xyXG4gICAgYXBwZWFyYW5jZTogJGFwcGVhcmFuY2U7XHJcbn1cclxuXHJcbi8vIE1hZ2ljIGVsZW1lbnQgc3R5bGVzXHJcblxyXG5AbWl4aW4gaW5saW5lLXdyYXBwZXIoKSB7XHJcbiAgICB0ZXh0LWFsaWduOiBqdXN0aWZ5O1xyXG4gICAgLW1zLXRleHQtanVzdGlmeTogZGlzdHJpYnV0ZS1hbGwtbGluZXM7XHJcbiAgICB0ZXh0LWp1c3RpZnk6IGRpc3RyaWJ1dGUtYWxsLWxpbmVzO1xyXG4gICAgZm9udC1zaXplOiAwO1xyXG5cclxuICAgICY6YWZ0ZXIge1xyXG4gICAgICAgIGRpc3BsYXk6IGlubGluZS1ibG9jaztcclxuICAgICAgICB3aWR0aDogMTAwJTtcclxuICAgICAgICBjb250ZW50OiBcIlwiO1xyXG4gICAgICAgIGZvbnQtc2l6ZTogMDtcclxuICAgICAgICBsaW5lLWhlaWdodDogMDtcclxuICAgIH1cclxufVxyXG5cclxuQG1peGluIGlubGluZS1lbGVtZW50KCR3aWR0aCwgJHZhbGlnbiwgJGZvbnRzaXplLCAkcmVzcG9uc2l2ZVdpZHRoOiBudWxsLCAkYnJlYWtwb2ludDogbnVsbCkge1xyXG4gICAgQGlmIGxpc3QubGVuZ3RoKCRmb250c2l6ZSk9PTAge1xyXG4gICAgICAgICRmb250c2l6ZTogJGluaXRpYWx0ZXh0O1xyXG4gICAgfVxyXG5cclxuICAgIGRpc3BsYXk6IGlubGluZS1ibG9jaztcclxuICAgIHdpZHRoOiAkd2lkdGg7XHJcbiAgICB2ZXJ0aWNhbC1hbGlnbjogJHZhbGlnbjtcclxuICAgIGZvbnQtc2l6ZTogJGZvbnRzaXplO1xyXG5cclxuICAgIEBpZiAoJHJlc3BvbnNpdmVXaWR0aCkgYW5kICgkYnJlYWtwb2ludCkge1xyXG4gICAgICAgIEBtZWRpYSBvbmx5IHNjcmVlbiBhbmQgKG1heC13aWR0aCA6ICRicmVha3BvaW50KSB7XHJcbiAgICAgICAgICAgIHdpZHRoOiAkcmVzcG9uc2l2ZVdpZHRoO1xyXG4gICAgICAgIH1cclxuICAgIH1cclxufVxyXG5cclxuLy8gQWVzdGhldGljc1xyXG5cclxuQG1peGluIG1hc2soJHZhbHVlKSB7XHJcbiAgICAtd2Via2l0LW1hc2s6ICR2YWx1ZTtcclxuICAgIG1hc2s6ICR2YWx1ZTtcclxufVxyXG5cclxuQG1peGluIGdsYXNzKCkge1xyXG4gICAgb3ZlcmZsb3c6IGhpZGRlbjtcclxuXHJcbiAgICAmOmJlZm9yZSB7XHJcbiAgICAgICAgY29udGVudDogJyc7XHJcbiAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xyXG4gICAgICAgIEBpbmNsdWRlIGNvdmVyKDAsIDAsIDAsIDApO1xyXG4gICAgICAgIGJveC1zaGFkb3c6IDAgMCAxdncgLjh2dyByZ2IoMjU1IDI1NSAyNTUgLyA1MCUpO1xyXG4gICAgICAgIGJvcmRlcjogLjR2dyBncm9vdmUgcmdiYSgyNTUsIDI1NSwgMjU1LCAwLjUpO1xyXG4gICAgICAgIGJhY2tncm91bmQ6IGxpbmVhci1ncmFkaWVudCgxNzJkZWcsIHJnYmEodmFyKC0td2hpdGUtcmF3KSwgMC44KSAwJSwgcmdiYSh2YXIoLS13aGl0ZS1yYXcpLCAwLjQpIDIwJSwgcmdiYSh2YXIoLS13aGl0ZS1yYXcpLCAwLjEpIDQ4JSwgcmdiYSh2YXIoLS13aGl0ZS1yYXcpLCAwLjApIDEwMCUpO1xyXG4gICAgICAgIHotaW5kZXg6IC0xO1xyXG4gICAgfVxyXG59XHJcblxyXG5AbWl4aW4gdGV4dC1zdHJva2UoJHZhbHVlKSB7XHJcbiAgICAtd2Via2l0LXRleHQtc3Ryb2tlOiAkdmFsdWU7XHJcbn1cclxuXHJcbkBtaXhpbiB0ZXh0LWJvcmRlcigkc2l6ZTogMXB4LCAkY29sb3I6IHdoaXRlKSB7XHJcbiAgICB0ZXh0LXNoYWRvdzogKC0kc2l6ZSkgKC0kc2l6ZSkgJHNpemUgJGNvbG9yLFxyXG4gICAgICAgICgtJHNpemUpICRzaXplICRzaXplICRjb2xvcixcclxuICAgICAgICAkc2l6ZSAoLSRzaXplKSAkc2l6ZSAkY29sb3IsXHJcbiAgICAgICAgJHNpemUgJHNpemUgJHNpemUgJGNvbG9yO1xyXG59XHJcblxyXG5AbWl4aW4gdGV4dC1ncmFkaWVudCgkZGlyZWN0aW9uOiA5MGRlZywgJGdyYWRpZW50cy4uLikge1xyXG4gICAgYmFja2dyb3VuZC1pbWFnZTogbGluZWFyLWdyYWRpZW50KCRkaXJlY3Rpb24sICRncmFkaWVudHMpO1xyXG4gICAgYmFja2dyb3VuZC1zaXplOiBjb3ZlcjtcclxuICAgIEBpbmNsdWRlIGJhY2tncm91bmQtY2xpcCh0ZXh0KTtcclxuICAgIEBpbmNsdWRlIHRleHQtZmlsbC1jb2xvcih0cmFuc3BhcmVudCk7XHJcbn1cclxuXHJcbkBtaXhpbiB0ZXh0LWZpbGwtY29sb3IoJHZhbHVlKSB7XHJcbiAgICAtd2Via2l0LXRleHQtZmlsbC1jb2xvcjogJHZhbHVlO1xyXG4gICAgLW1vei10ZXh0LWZpbGwtY29sb3I6ICR2YWx1ZTtcclxuICAgIC1vLXRleHQtZmlsbC1jb2xvcjogJHZhbHVlO1xyXG4gICAgdGV4dC1maWxsLWNvbG9yOiAkdmFsdWU7XHJcbn1cclxuXHJcbkBtaXhpbiBiYWNrZ3JvdW5kLXNpemUoJHZhbHVlKSB7XHJcbiAgICAtd2Via2l0LWJhY2tncm91bmQtc2l6ZTogJHZhbHVlO1xyXG4gICAgLW1vei1iYWNrZ3JvdW5kLXNpemU6ICR2YWx1ZTtcclxuICAgIC1vLWJhY2tncm91bmQtc2l6ZTogJHZhbHVlO1xyXG4gICAgYmFja2dyb3VuZC1zaXplOiAkdmFsdWU7XHJcbn1cclxuXHJcbkBtaXhpbiBiYWNrZ3JvdW5kLWNsaXAoJHZhbHVlKSB7XHJcbiAgICAtd2Via2l0LWJhY2tncm91bmQtY2xpcDogJHZhbHVlO1xyXG4gICAgLW1vei1iYWNrZ3JvdW5kLWNsaXA6ICR2YWx1ZTtcclxuICAgIC1vLWJhY2tncm91bmQtY2xpcDogJHZhbHVlO1xyXG4gICAgYmFja2dyb3VuZC1jbGlwOiAkdmFsdWU7XHJcbn1cclxuXHJcbkBtaXhpbiBvYmplY3QtZml0KCR2YWx1ZSkge1xyXG4gICAgLXdlYmtpdC1vYmplY3QtZml0OiAkdmFsdWU7XHJcbiAgICAtbW96LW9iamVjdC1maXQ6ICR2YWx1ZTtcclxuICAgIC1vLWJhY2tncm91bmQtc2l6ZTogJHZhbHVlO1xyXG4gICAgb2JqZWN0LWZpdDogJHZhbHVlO1xyXG59XHJcblxyXG5AbWl4aW4gb2JqZWN0LXBvc2l0aW9uKCR2YWx1ZSkge1xyXG4gICAgLW8tb2JqZWN0LXBvc2l0aW9uOiAkdmFsdWU7XHJcbiAgICBvYmplY3QtcG9zaXRpb246ICR2YWx1ZTtcclxufVxyXG5cclxuQG1peGluIGZpbHRlcigkY29udGVudCkge1xyXG4gICAgLXdlYmtpdC1maWx0ZXI6ICRjb250ZW50O1xyXG4gICAgLW1vei1maWx0ZXI6ICRjb250ZW50O1xyXG4gICAgLW8tZmlsdGVyOiAkY29udGVudDtcclxuICAgIC1tcy1maWx0ZXI6ICRjb250ZW50O1xyXG4gICAgZmlsdGVyOiAkY29udGVudDtcclxufVxyXG5cclxuQG1peGluIGJhY2tkcm9wLWZpbHRlcigkY29udGVudCkge1xyXG4gICAgLXdlYmtpdC1iYWNrZHJvcC1maWx0ZXI6ICRjb250ZW50O1xyXG4gICAgLW1vei1iYWNrZHJvcC1maWx0ZXI6ICRjb250ZW50O1xyXG4gICAgLW8tYmFja2Ryb3AtZmlsdGVyOiAkY29udGVudDtcclxuICAgIC1tcy1iYWNrZHJvcC1maWx0ZXI6ICRjb250ZW50O1xyXG4gICAgYmFja2Ryb3AtZmlsdGVyOiAkY29udGVudDtcclxufVxyXG5cclxuQG1peGluIGNvbmljLWdyYWRpZW50KCRkaXJlY3Rpb246IGZyb20gMGRlZywgJGdyYWRpZW50cy4uLikge1xyXG4gICAgYmFja2dyb3VuZC1pbWFnZTogY29uaWMtZ3JhZGllbnQoJGRpcmVjdGlvbiwgJGdyYWRpZW50cyk7XHJcbn1cclxuXHJcbkBtaXhpbiBsaW5lYXItZ3JhZGllbnQoJGRpcmVjdGlvbjogdG8gYm90dG9tLCAkZ3JhZGllbnRzLi4uKSB7XHJcbiAgICBiYWNrZ3JvdW5kLWNvbG9yOiBsaXN0Lm50aCgkZ3JhZGllbnRzLCAxKTtcclxuICAgIGJhY2tncm91bmQtaW1hZ2U6IGxpbmVhci1ncmFkaWVudCgkZGlyZWN0aW9uLCAkZ3JhZGllbnRzKTtcclxufVxyXG5cclxuQG1peGluIHJhZGlhbC1ncmFkaWVudCgkZGlyZWN0aW9uOiBlbGxpcHNlIGF0IGNlbnRlciwgJGdyYWRpZW50cy4uLikge1xyXG4gICAgYmFja2dyb3VuZC1jb2xvcjogbGlzdC5udGgoJGdyYWRpZW50cywgMSk7XHJcbiAgICBiYWNrZ3JvdW5kLWltYWdlOiByYWRpYWwtZ3JhZGllbnQoJGRpcmVjdGlvbiwgJGdyYWRpZW50cyk7XHJcbn1cclxuXHJcbkBmdW5jdGlvbiBncmFkaWVudHNoYWRvdygkY29sb3IsICRsZW5ndGgsICRkaXJlY3Rpb24pIHtcclxuICAgICR2YWw6IDBweCAwcHggJGNvbG9yO1xyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSdudycpIHtcclxuICAgICAgICBAZm9yICRpIGZyb20gMSB0byAkbGVuZ3RoIHtcclxuICAgICAgICAgICAgJHZhbDogI3skdmFsfSxcclxuICAgICAgICAgICAgLSN7JGl9cHggLSN7JGl9cHggI3tjb2xvci5hZGp1c3QoJGNvbG9yLCRsaWdodG5lc3M6ICRpKX07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSduJykge1xyXG4gICAgICAgIEBmb3IgJGkgZnJvbSAxIHRvICRsZW5ndGgge1xyXG4gICAgICAgICAgICAkdmFsOiAjeyR2YWx9LFxyXG4gICAgICAgICAgICAwIC0jeyRpfXB4ICN7Y29sb3IuYWRqdXN0KCRjb2xvciwkbGlnaHRuZXNzOiAkaSl9O1xyXG4gICAgICAgIH1cclxuICAgIH1cclxuXHJcbiAgICBAaWYgKCRkaXJlY3Rpb24gPT0nbmUnKSB7XHJcbiAgICAgICAgQGZvciAkaSBmcm9tIDEgdG8gJGxlbmd0aCB7XHJcbiAgICAgICAgICAgICR2YWw6ICN7JHZhbH0sXHJcbiAgICAgICAgICAgICN7JGl9cHggLSN7JGl9cHggI3tjb2xvci5hZGp1c3QoJGNvbG9yLCRsaWdodG5lc3M6ICRpKX07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSdlJykge1xyXG4gICAgICAgIEBmb3IgJGkgZnJvbSAxIHRvICRsZW5ndGgge1xyXG4gICAgICAgICAgICAkdmFsOiAjeyR2YWx9LFxyXG4gICAgICAgICAgICAjeyRpfXB4IDAgI3tjb2xvci5hZGp1c3QoJGNvbG9yLCRsaWdodG5lc3M6ICRpKX07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSdzZScpIHtcclxuICAgICAgICBAZm9yICRpIGZyb20gMSB0byAkbGVuZ3RoIHtcclxuICAgICAgICAgICAgJHZhbDogI3skdmFsfSxcclxuICAgICAgICAgICAgI3skaX1weCAjeyRpfXB4ICN7Y29sb3IuYWRqdXN0KCRjb2xvciwkbGlnaHRuZXNzOiAkaSl9O1xyXG4gICAgICAgIH1cclxuICAgIH1cclxuXHJcbiAgICBAaWYgKCRkaXJlY3Rpb24gPT0ncycpIHtcclxuICAgICAgICBAZm9yICRpIGZyb20gMSB0byAkbGVuZ3RoIHtcclxuICAgICAgICAgICAgJHZhbDogI3skdmFsfSxcclxuICAgICAgICAgICAgMCAjeyRpfXB4ICN7Y29sb3IuYWRqdXN0KCRjb2xvciwkbGlnaHRuZXNzOiAkaSl9O1xyXG4gICAgICAgIH1cclxuICAgIH1cclxuXHJcbiAgICBAaWYgKCRkaXJlY3Rpb24gPT0nc3cnKSB7XHJcbiAgICAgICAgQGZvciAkaSBmcm9tIDEgdG8gJGxlbmd0aCB7XHJcbiAgICAgICAgICAgICR2YWw6ICN7JHZhbH0sXHJcbiAgICAgICAgICAgIC0jeyRpfXB4ICN7JGl9cHggI3tjb2xvci5hZGp1c3QoJGNvbG9yLCRsaWdodG5lc3M6ICRpKX07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSd3Jykge1xyXG4gICAgICAgIEBmb3IgJGkgZnJvbSAxIHRvICRsZW5ndGgge1xyXG4gICAgICAgICAgICAkdmFsOiAjeyR2YWx9LFxyXG4gICAgICAgICAgICAtI3skaX1weCAwICN7Y29sb3IuYWRqdXN0KCRjb2xvciwkbGlnaHRuZXNzOiAkaSl9O1xyXG4gICAgICAgIH1cclxuICAgIH1cclxuXHJcbiAgICBAcmV0dXJuICR2YWw7XHJcbn1cclxuXHJcbkBmdW5jdGlvbiBsb25nc2hhZG93KCRjb2xvciwgJGxlbmd0aCwgJGRpcmVjdGlvbikge1xyXG4gICAgJHZhbDogMHB4IDBweCAkY29sb3I7XHJcblxyXG4gICAgQGlmICgkZGlyZWN0aW9uID09J253Jykge1xyXG4gICAgICAgIEBmb3IgJGkgZnJvbSAxIHRocm91Z2ggJGxlbmd0aCB7XHJcbiAgICAgICAgICAgICR2YWw6ICN7JHZhbH0sXHJcbiAgICAgICAgICAgIC0jeyRpfXB4IC0jeyRpfXB4ICN7JGNvbG9yfTtcclxuICAgICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgQGlmICgkZGlyZWN0aW9uID09J24nKSB7XHJcbiAgICAgICAgQGZvciAkaSBmcm9tIDEgdGhyb3VnaCAkbGVuZ3RoIHtcclxuICAgICAgICAgICAgJHZhbDogI3skdmFsfSxcclxuICAgICAgICAgICAgMCAtI3skaX1weCAjeyRjb2xvcn07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSduZScpIHtcclxuICAgICAgICBAZm9yICRpIGZyb20gMSB0aHJvdWdoICRsZW5ndGgge1xyXG4gICAgICAgICAgICAkdmFsOiAjeyR2YWx9LFxyXG4gICAgICAgICAgICAjeyRpfXB4IC0jeyRpfXB4ICN7JGNvbG9yfTtcclxuICAgICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgQGlmICgkZGlyZWN0aW9uID09J2UnKSB7XHJcbiAgICAgICAgQGZvciAkaSBmcm9tIDEgdGhyb3VnaCAkbGVuZ3RoIHtcclxuICAgICAgICAgICAgJHZhbDogI3skdmFsfSxcclxuICAgICAgICAgICAgI3skaX1weCAwICN7JGNvbG9yfTtcclxuICAgICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgQGlmICgkZGlyZWN0aW9uID09J3NlJykge1xyXG4gICAgICAgIEBmb3IgJGkgZnJvbSAxIHRocm91Z2ggJGxlbmd0aCB7XHJcbiAgICAgICAgICAgICR2YWw6ICN7JHZhbH0sXHJcbiAgICAgICAgICAgICN7JGl9cHggI3skaX1weCAjeyRjb2xvcn07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSdzJykge1xyXG4gICAgICAgIEBmb3IgJGkgZnJvbSAxIHRocm91Z2ggJGxlbmd0aCB7XHJcbiAgICAgICAgICAgICR2YWw6ICN7JHZhbH0sXHJcbiAgICAgICAgICAgIDAgI3skaX1weCAjeyRjb2xvcn07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEBpZiAoJGRpcmVjdGlvbiA9PSdzdycpIHtcclxuICAgICAgICBAZm9yICRpIGZyb20gMSB0aHJvdWdoICRsZW5ndGgge1xyXG4gICAgICAgICAgICAkdmFsOiAjeyR2YWx9LFxyXG4gICAgICAgICAgICAtI3skaX1weCAjeyRpfXB4ICN7JGNvbG9yfTtcclxuICAgICAgICB9XHJcbiAgICB9XHJcblxyXG4gICAgQGlmICgkZGlyZWN0aW9uID09J3cnKSB7XHJcbiAgICAgICAgQGZvciAkaSBmcm9tIDEgdGhyb3VnaCAkbGVuZ3RoIHtcclxuICAgICAgICAgICAgJHZhbDogI3skdmFsfSxcclxuICAgICAgICAgICAgLSN7JGl9cHggMCAjeyRjb2xvcn07XHJcbiAgICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIEByZXR1cm4gJHZhbDtcclxufVxyXG5cclxuQG1peGluIHBsYWNlaG9sZGVycygkY29sb3IsICR3ZWlnaHQ6IG51bGwpIHtcclxuICAgICY6Oi13ZWJraXQtaW5wdXQtcGxhY2Vob2xkZXIge1xyXG4gICAgICAgIGNvbG9yOiAkY29sb3I7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6ICR3ZWlnaHQ7XHJcbiAgICB9XHJcblxyXG4gICAgJjotbW96LXBsYWNlaG9sZGVyIHtcclxuICAgICAgICBjb2xvcjogJGNvbG9yO1xyXG4gICAgICAgIGZvbnQtd2VpZ2h0OiAkd2VpZ2h0O1xyXG4gICAgfVxyXG5cclxuICAgICY6Oi1tb3otcGxhY2Vob2xkZXIge1xyXG4gICAgICAgIGNvbG9yOiAkY29sb3I7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6ICR3ZWlnaHQ7XHJcbiAgICB9XHJcblxyXG4gICAgJjotbXMtaW5wdXQtcGxhY2Vob2xkZXIge1xyXG4gICAgICAgIGNvbG9yOiAkY29sb3I7XHJcbiAgICAgICAgZm9udC13ZWlnaHQ6ICR3ZWlnaHQ7XHJcbiAgICB9XHJcbn1cclxuXHJcbkBtaXhpbiBoaWRlLXNjcm9sbGJhcigpIHtcclxuICAgIHNjcm9sbGJhci13aWR0aDogbm9uZTsgLyogRm9yIEZpcmVmb3ggKi9cclxuICAgIC1tcy1vdmVyZmxvdy1zdHlsZTogbm9uZTsgLyogRm9yIEludGVybmV0IEV4cGxvcmVyIGFuZCBFZGdlICovXHJcbiAgXHJcbiAgICAvKiBIaWRlIHRoZSBzY3JvbGxiYXIgZm9yIFdlYktpdCBiYXNlZCBicm93c2VycyAoQ2hyb21lLCBTYWZhcmkpICovXHJcbiAgICAmOjotd2Via2l0LXNjcm9sbGJhciB7XHJcbiAgICAgIHdpZHRoOiAwdnc7XHJcbiAgICB9XHJcbiAgXHJcbiAgICAmOjotd2Via2l0LXNjcm9sbGJhci10aHVtYiB7XHJcbiAgICAgIGJhY2tncm91bmQtY29sb3I6IHRyYW5zcGFyZW50O1xyXG4gICAgfVxyXG59XHJcblxyXG5AbWl4aW4gc2Nyb2xsYmFyKCRzaXplLCAkcHJpbWFyeSwgJHNlY29uZGFyeTogI2ZmZmZmZiwgJHJhZGl1czogMCwgJHNlbGVjdG9yOiBib2R5KSB7XHJcbiAgICAjeyRzZWxlY3Rvcn0ge1xyXG5cclxuICAgICAgICAmOjotd2Via2l0LXNjcm9sbGJhcixcclxuICAgICAgICAqOjotd2Via2l0LXNjcm9sbGJhciB7XHJcbiAgICAgICAgICAgIHdpZHRoOiAkc2l6ZTtcclxuICAgICAgICAgICAgaGVpZ2h0OiAkc2l6ZTtcclxuICAgICAgICB9XHJcblxyXG4gICAgICAgICY6Oi13ZWJraXQtc2Nyb2xsYmFyLXRodW1iLFxyXG4gICAgICAgICo6Oi13ZWJraXQtc2Nyb2xsYmFyLXRodW1iIHtcclxuICAgICAgICAgICAgYmFja2dyb3VuZDogJHByaW1hcnk7XHJcbiAgICAgICAgICAgIGJvcmRlci1yYWRpdXM6ICRyYWRpdXM7XHJcbiAgICAgICAgfVxyXG5cclxuICAgICAgICAmOjotd2Via2l0LXNjcm9sbGJhci10cmFjayxcclxuICAgICAgICAqOjotd2Via2l0LXNjcm9sbGJhci10cmFjayB7XHJcbiAgICAgICAgICAgIGJhY2tncm91bmQ6ICRzZWNvbmRhcnk7XHJcbiAgICAgICAgfVxyXG5cclxuICAgICAgICBzY3JvbGxiYXItYmFzZS1jb2xvcjogJHByaW1hcnk7XHJcbiAgICAgICAgc2Nyb2xsYmFyLXRyYWNrLWNvbG9yOiAkc2Vjb25kYXJ5O1xyXG4gICAgfVxyXG5cclxufVxyXG5cclxuLy8gVHJhbnNmb3JtYXRpb24gbWl4aW5zXHJcblxyXG5AbWl4aW4gYW5pbWF0aW9uKCRuYW1lLCAkaXRlcmF0aW9ucywgJHRpbWluZywgJGR1cmF0aW9uLCAkZGVsYXk6IDBzLCAkZGlyZWN0aW9uOiBub3JtYWwsICRmaWxsLW1vZGU6IGZvcndhcmRzKSB7XHJcbiAgICAtbW96LWFuaW1hdGlvbi1uYW1lOiAkbmFtZTtcclxuICAgIC1tcy1hbmltYXRpb24tbmFtZTogJG5hbWU7XHJcbiAgICAtby1hbmltYXRpb24tbmFtZTogJG5hbWU7XHJcbiAgICAtd2Via2l0LWFuaW1hdGlvbi1uYW1lOiAkbmFtZTtcclxuICAgIGFuaW1hdGlvbi1uYW1lOiAkbmFtZTtcclxuICAgIC1tb3otYW5pbWF0aW9uLWl0ZXJhdGlvbi1jb3VudDogJGl0ZXJhdGlvbnM7XHJcbiAgICAtbXMtYW5pbWF0aW9uLWl0ZXJhdGlvbi1jb3VudDogJGl0ZXJhdGlvbnM7XHJcbiAgICAtby1hbmltYXRpb24taXRlcmF0aW9uLWNvdW50OiAkaXRlcmF0aW9ucztcclxuICAgIC13ZWJraXQtYW5pbWF0aW9uLWl0ZXJhdGlvbi1jb3VudDogJGl0ZXJhdGlvbnM7XHJcbiAgICBhbmltYXRpb24taXRlcmF0aW9uLWNvdW50OiAkaXRlcmF0aW9ucztcclxuICAgIC1tb3otYW5pbWF0aW9uLXRpbWluZy1mdW5jdGlvbjogJHRpbWluZztcclxuICAgIC1tcy1hbmltYXRpb24tdGltaW5nLWZ1bmN0aW9uOiAkdGltaW5nO1xyXG4gICAgLW8tYW5pbWF0aW9uLXRpbWluZy1mdW5jdGlvbjogJHRpbWluZztcclxuICAgIC13ZWJraXQtYW5pbWF0aW9uLXRpbWluZy1mdW5jdGlvbjogJHRpbWluZztcclxuICAgIGFuaW1hdGlvbi10aW1pbmctZnVuY3Rpb246ICR0aW1pbmc7XHJcbiAgICAtbW96LWFuaW1hdGlvbi1kdXJhdGlvbjogJGR1cmF0aW9uO1xyXG4gICAgLW1zLWFuaW1hdGlvbi1kdXJhdGlvbjogJGR1cmF0aW9uO1xyXG4gICAgLW8tYW5pbWF0aW9uLWR1cmF0aW9uOiAkZHVyYXRpb247XHJcbiAgICAtd2Via2l0LWFuaW1hdGlvbi1kdXJhdGlvbjogJGR1cmF0aW9uO1xyXG4gICAgYW5pbWF0aW9uLWR1cmF0aW9uOiAkZHVyYXRpb247XHJcbiAgICAtbW96LWFuaW1hdGlvbi1kaXJlY3Rpb246ICRkaXJlY3Rpb247XHJcbiAgICAtbXMtYW5pbWF0aW9uLWRpcmVjdGlvbjogJGRpcmVjdGlvbjtcclxuICAgIC1vLWFuaW1hdGlvbi1kaXJlY3Rpb246ICRkaXJlY3Rpb247XHJcbiAgICAtd2Via2l0LWFuaW1hdGlvbi1kaXJlY3Rpb246ICRkaXJlY3Rpb247XHJcbiAgICBhbmltYXRpb24tZGlyZWN0aW9uOiAkZGlyZWN0aW9uO1xyXG4gICAgLW1vei1hbmltYXRpb24tZGVsYXk6ICRkZWxheTtcclxuICAgIC1tcy1hbmltYXRpb24tZGVsYXk6ICRkZWxheTtcclxuICAgIC1vLWFuaW1hdGlvbi1kZWxheTogJGRlbGF5O1xyXG4gICAgLXdlYmtpdC1hbmltYXRpb24tZGVsYXk6ICRkZWxheTtcclxuICAgIGFuaW1hdGlvbi1kZWxheTogJGRlbGF5O1xyXG4gICAgLW1vei1hbmltYXRpb24tZmlsbC1tb2RlOiAkZmlsbC1tb2RlO1xyXG4gICAgLW1zLWFuaW1hdGlvbi1maWxsLW1vZGU6ICRmaWxsLW1vZGU7XHJcbiAgICAtby1hbmltYXRpb24tZmlsbC1tb2RlOiAkZmlsbC1tb2RlO1xyXG4gICAgLXdlYmtpdC1hbmltYXRpb24tZmlsbC1tb2RlOiAkZmlsbC1tb2RlO1xyXG4gICAgYW5pbWF0aW9uLWZpbGwtbW9kZTogJGZpbGwtbW9kZTtcclxufVxyXG5cclxuQG1peGluIHBlcnNwZWN0aXZlKCR2YWx1ZSkge1xyXG4gICAgLW1vei1wZXJzcGVjdGl2ZTogJHZhbHVlO1xyXG4gICAgLW1zLXBlcnNwZWN0aXZlOiAkdmFsdWU7XHJcbiAgICAtd2Via2l0LXBlcnNwZWN0aXZlOiAkdmFsdWU7XHJcbiAgICBwZXJzcGVjdGl2ZTogJHZhbHVlO1xyXG59XHJcblxyXG5AbWl4aW4gYmFja2ZhY2UoJHZpc2liaWxpdHkpIHtcclxuICAgIC1tb3otYmFja2ZhY2UtdmlzaWJpbGl0eTogJHZpc2liaWxpdHk7XHJcbiAgICAtd2Via2l0LWJhY2tmYWNlLXZpc2liaWxpdHk6ICR2aXNpYmlsaXR5O1xyXG4gICAgYmFja2ZhY2UtdmlzaWJpbGl0eTogJHZpc2liaWxpdHk7XHJcbn1cclxuXHJcbkBtaXhpbiB0cmFuc2Zvcm0tc3R5bGUoJHZhbHVlKSB7XHJcbiAgICAtbXMtdHJhbnNmb3JtLXN0eWxlOiAkdmFsdWU7XHJcbiAgICAtbW96LXRyYW5zZm9ybS1zdHlsZTogJHZhbHVlO1xyXG4gICAgLXdlYmtpdC10cmFuc2Zvcm0tc3R5bGU6ICR2YWx1ZTtcclxuICAgIHRyYW5zZm9ybS1zdHlsZTogJHZhbHVlO1xyXG59XHJcblxyXG5AbWl4aW4gdHJhbnNmb3JtKCRjb250ZW50KSB7XHJcbiAgICAtbW96LXRyYW5zZm9ybTogJGNvbnRlbnQ7XHJcbiAgICAtbXMtdHJhbnNmb3JtOiAkY29udGVudDtcclxuICAgIC1vLXRyYW5zZm9ybTogJGNvbnRlbnQ7XHJcbiAgICAtd2Via2l0LXRyYW5zZm9ybTogJGNvbnRlbnQ7XHJcbiAgICB0cmFuc2Zvcm06ICRjb250ZW50O1xyXG59XHJcblxyXG5AbWl4aW4gdHJhbnNmb3JtLW9yaWdpbigkY29udGVudCkge1xyXG4gICAgLW1vei10cmFuc2Zvcm0tb3JpZ2luOiAkY29udGVudDtcclxuICAgIC1tcy10cmFuc2Zvcm0tb3JpZ2luOiAkY29udGVudDtcclxuICAgIC1vLXRyYW5zZm9ybS1vcmlnaW46ICRjb250ZW50O1xyXG4gICAgLXdlYmtpdC10cmFuc2Zvcm0tb3JpZ2luOiAkY29udGVudDtcclxuICAgIHRyYW5zZm9ybS1vcmlnaW46ICRjb250ZW50O1xyXG59XHJcblxyXG5AbWl4aW4gdHJhbnNpdGlvbigkcHJvcGVydHk6IGFsbCwgJGR1cmF0aW9uOiAxcywgJGVhc2luZzogbGluZWFyLCAkZGVsYXk6IG51bGwpIHtcclxuICAgIC1tb3otdHJhbnNpdGlvbjogJHByb3BlcnR5ICRkdXJhdGlvbiAkZWFzaW5nICRkZWxheTtcclxuICAgIC1vLXRyYW5zaXRpb246ICRwcm9wZXJ0eSAkZHVyYXRpb24gJGVhc2luZyAkZGVsYXk7XHJcbiAgICAtd2Via2l0LXRyYW5zaXRpb246ICRwcm9wZXJ0eSAkZHVyYXRpb24gJGVhc2luZyAkZGVsYXk7XHJcbiAgICB0cmFuc2l0aW9uOiAkcHJvcGVydHkgJGR1cmF0aW9uICRlYXNpbmcgJGRlbGF5O1xyXG59XHJcblxyXG5AbWl4aW4gdHJhbnNpdGlvbnMoJHRyYW5zaXRpb25zLi4uKSB7XHJcbiAgICAtbW96LXRyYW5zaXRpb246ICR0cmFuc2l0aW9ucztcclxuICAgIC1vLXRyYW5zaXRpb246ICR0cmFuc2l0aW9ucztcclxuICAgIC13ZWJraXQtdHJhbnNpdGlvbjogJHRyYW5zaXRpb25zO1xyXG4gICAgdHJhbnNpdGlvbjogJHRyYW5zaXRpb25zO1xyXG59XHJcblxyXG5AbWl4aW4ga2V5ZnJhbWVzKCRhbmltYXRpb25OYW1lKSB7XHJcbiAgICBALXdlYmtpdC1rZXlmcmFtZXMgI3skYW5pbWF0aW9uTmFtZX0ge1xyXG4gICAgICAgIEBjb250ZW50O1xyXG4gICAgfVxyXG5cclxuICAgIEAtbW96LWtleWZyYW1lcyAjeyRhbmltYXRpb25OYW1lfSB7XHJcbiAgICAgICAgQGNvbnRlbnQ7XHJcbiAgICB9XHJcblxyXG4gICAgQC1vLWtleWZyYW1lcyAjeyRhbmltYXRpb25OYW1lfSB7XHJcbiAgICAgICAgQGNvbnRlbnQ7XHJcbiAgICB9XHJcblxyXG4gICAgQGtleWZyYW1lcyAjeyRhbmltYXRpb25OYW1lfSB7XHJcbiAgICAgICAgQGNvbnRlbnQ7XHJcbiAgICB9XHJcbn1cclxuXHJcbi8vIFN0cnVjdHVyaW5nIG1peGluc1xyXG5cclxuQG1peGluIGNvdmVyKCR0b3AsICRyaWdodCwgJGJvdHRvbSwgJGxlZnQpIHtcclxuICAgIHRvcDogJHRvcDtcclxuICAgIGxlZnQ6ICRsZWZ0O1xyXG4gICAgcmlnaHQ6ICRyaWdodDtcclxuICAgIGJvdHRvbTogJGJvdHRvbTtcclxufVxyXG5cclxuQG1peGluIGhjZW50ZXIoJHBvc2l0aW9uKSB7XHJcbiAgICBAaWYgbGlzdC5sZW5ndGgoJHBvc2l0aW9uKT09MCB7XHJcbiAgICAgICAgJHBvc2l0aW9uOiByZWxhdGl2ZTtcclxuICAgIH1cclxuXHJcbiAgICBwb3NpdGlvbjogJHBvc2l0aW9uO1xyXG4gICAgbGVmdDogNTAlO1xyXG4gICAgQGluY2x1ZGUgdHJhbnNmb3JtKHRyYW5zbGF0ZTNkKC01MCUsIDAsIDApKTtcclxufVxyXG5cclxuQG1peGluIHZjZW50ZXIoJHBvc2l0aW9uKSB7XHJcblxyXG4gICAgQGlmIGxpc3QubGVuZ3RoKCRwb3NpdGlvbik9PTAge1xyXG4gICAgICAgICRwb3NpdGlvbjogcmVsYXRpdmU7XHJcbiAgICB9XHJcblxyXG4gICAgcG9zaXRpb246ICRwb3NpdGlvbjtcclxuICAgIHRvcDogNTAlO1xyXG4gICAgLW1vei10cmFuc2Zvcm06IHRyYW5zbGF0ZVkoLTUwJSk7XHJcbiAgICAtbXMtdHJhbnNmb3JtOiB0cmFuc2xhdGVZKC01MCUpO1xyXG4gICAgLW8tdHJhbnNmb3JtOiB0cmFuc2xhdGVZKC01MCUpO1xyXG4gICAgLXdlYmtpdC10cmFuc2Zvcm06IHRyYW5zbGF0ZVkoLTUwJSk7XHJcbiAgICB0cmFuc2Zvcm06IHRyYW5zbGF0ZVkoLTUwJSk7XHJcbn1cclxuXHJcbkBtaXhpbiBhbGxjZW50ZXIoJHBvc2l0aW9uKSB7XHJcbiAgICBAaWYgbGlzdC5sZW5ndGgoJHBvc2l0aW9uKT09MCB7XHJcbiAgICAgICAgJHBvc2l0aW9uOiByZWxhdGl2ZTtcclxuICAgIH1cclxuXHJcbiAgICBwb3NpdGlvbjogJHBvc2l0aW9uO1xyXG4gICAgdG9wOiA1MCU7XHJcbiAgICBsZWZ0OiA1MCU7XHJcbiAgICAtbW96LXRyYW5zZm9ybTogdHJhbnNsYXRlKC01MCUsIC01MCUpO1xyXG4gICAgLW1zLXRyYW5zZm9ybTogdHJhbnNsYXRlKC01MCUsIC01MCUpO1xyXG4gICAgLW8tdHJhbnNmb3JtOiB0cmFuc2xhdGUoLTUwJSwgLTUwJSk7XHJcbiAgICAtd2Via2l0LXRyYW5zZm9ybTogdHJhbnNsYXRlKC01MCUsIC01MCUpO1xyXG4gICAgdHJhbnNmb3JtOiB0cmFuc2xhdGUoLTUwJSwgLTUwJSk7XHJcbn1cclxuXHJcbkBtaXhpbiBib3R0b20oJHBvc2l0aW9uKSB7XHJcbiAgICBwb3NpdGlvbjogJHBvc2l0aW9uO1xyXG4gICAgQGluY2x1ZGUgY292ZXIoYXV0bywwLDAsMCk7XHJcbn0iLCJAdXNlIFwic3JjL3N0eWxlcy9taXhpbnNcIjtcblxuQGluY2x1ZGUgbWl4aW5zLmtleWZyYW1lcyhjbG9zZUxvYWRJbikge1xuICAgIDAlIHtcbiAgICAgICAgb3BhY2l0eTogMDtcbiAgICAgICAgQGluY2x1ZGUgbWl4aW5zLmZpbHRlcihibHVyKDV2dykpO1xuICAgIH1cblxuICAgIDEwMCUge1xuICAgICAgICBvcGFjaXR5OiAxO1xuICAgICAgICBAaW5jbHVkZSBtaXhpbnMuZmlsdGVyKGJsdXIoMCkpO1xuICAgIH1cbn1cblxuI3JjVmlldyB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIEBpbmNsdWRlIG1peGlucy5jb3ZlcihjYWxjKDZ2dyArIHZhcigtLXN5c3RlbU9mZnNldC10b3ApKSwgMnZ3LCAydncsIDJ2dyk7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuXG4gICAgPi5wcmltYXJ5IHtcbiAgICAgICAgPi5jb250ZW50IHtcbiAgICAgICAgICAgIGRpc3BsYXk6IGZsZXg7XG5cbiAgICAgICAgICAgID4uc3VtbWFyeSB7XG4gICAgICAgICAgICAgICAgd2lkdGg6IDcwJTtcbiAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiAxdnc7XG4gICAgICAgICAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICAgICAgICAgIG92ZXJmbG93OiBoaWRkZW47XG4gICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogMXZ3O1xuICAgICAgICAgICAgICAgIGJhY2tncm91bmQtY29sb3I6IHZhcigtLWNvbG9yNik7XG4gICAgICAgICAgICAgICAgYm9yZGVyOiAuMXZ3IHZhcigtLWNvbG9yNkFsdDMpIHNvbGlkO1xuICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5maWx0ZXIoZHJvcC1zaGFkb3coMCAzcHggMnB4IHJnYmEodmFyKC0tY29sb3IxLXJhdyksIDAuMSkpKTtcbiAgICAgICAgICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICAgICAgICAgIGFsaWduLWl0ZW1zOiBmbGV4LXN0YXJ0O1xuICAgICAgICAgICAgICAgIGhlaWdodDogMTV2dztcbiAgICAgICAgICAgICAgICBtYXJnaW4tcmlnaHQ6IDF2dztcblxuICAgICAgICAgICAgICAgID4uY29udGVudCB7XG4gICAgICAgICAgICAgICAgICAgIGZsZXg6IDE7XG4gICAgICAgICAgICAgICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICAgICAgICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgICAgICAgICAgICAgIHotaW5kZXg6IDE7XG5cbiAgICAgICAgICAgICAgICAgICAgPmhlYWRlciB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwYWRkaW5nOiAxdnc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgIGgyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsaW5lLWhlaWdodDogMTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXNpemU6IDIuMnZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHdoaXRlLXNwYWNlOiBub3dyYXA7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sb3I6IHZhcigtLWNvbG9yMSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9udC13ZWlnaHQ6IHZhcigtLXN0cm9uZ2VyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgaDMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtc2l6ZTogMS42dnc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sb3I6IHZhcigtLWNvbG9yMUFsdDMpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtd2VpZ2h0OiB2YXIoLS1zdGR3ZWlnaHQpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgPi5jb250ZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHBhZGRpbmc6IC41dncgMXZ3IDF2dztcbiAgICAgICAgICAgICAgICAgICAgICAgIGJhY2tncm91bmQtY29sb3I6IHJnYmEodmFyKC0tY29sb3I2LXJhdyksIC42KTtcbiAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5iYWNrZHJvcC1maWx0ZXIoYmx1ciguNXZ3KSk7XG4gICAgICAgICAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiAxdnc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgID5wIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXNpemU6IDEuNHZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvbG9yOiB2YXIoLS1jb2xvcjEpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtd2VpZ2h0OiB2YXIoLS1zdHJvbmcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICA+LmxvYWRlciB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPnAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXNpemU6IDEuMnZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2xvcjogdmFyKC0tY29sb3IxQWx0Mik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtd2VpZ2h0OiB2YXIoLS1zdHJvbmdlc3QpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXN0eWxlOiBpdGFsaWM7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRleHQtdHJhbnNmb3JtOiBsb3dlcmNhc2U7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgPi5iYXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBtYXJnaW4tdG9wOiAuOHZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiA5OTlweDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBoZWlnaHQ6IDEuNHZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1jb2xvcjJBbHQyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAmOmJlZm9yZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb250ZW50OiAnJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogOTk5cHg7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMuY292ZXIoMCwgMCwgMCwgMCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMudHJhbnNmb3JtKHRyYW5zbGF0ZVgoLTEwMCUpKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5hbmltYXRpb24oYmFyTG9hZGVyLCBpbmZpbml0ZSwgbGluZWFyLCAzcyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1jb2xvcjJBbHQxKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICY6bnRoLW9mLXR5cGUoMikge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJjpiZWZvcmUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5hbmltYXRpb24oYmFyTG9hZGVyLCBpbmZpbml0ZSwgbGluZWFyLCAzcywgLjVzKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICY6bnRoLW9mLXR5cGUoMykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJjpiZWZvcmUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5hbmltYXRpb24oYmFyTG9hZGVyLCBpbmZpbml0ZSwgbGluZWFyLCAzcywgMXMpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgPi5wcm9maWxlIHtcbiAgICAgICAgICAgICAgICAgICAgd2lkdGg6IDEwdnc7XG4gICAgICAgICAgICAgICAgICAgIGhlaWdodDogMTAwJTtcbiAgICAgICAgICAgICAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcbiAgICAgICAgICAgICAgICAgICAgei1pbmRleDogMDtcbiAgICAgICAgICAgICAgICAgICAgcG9pbnRlci1ldmVudHM6IG5vbmU7XG4gICAgICAgICAgICAgICAgICAgIG1peC1ibGVuZC1tb2RlOiBtdWx0aXBseTtcblxuICAgICAgICAgICAgICAgICAgICBpbWcge1xuICAgICAgICAgICAgICAgICAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgICAgICAgICAgICAgICAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgICAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMub2JqZWN0LWZpdChjb3Zlcik7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgID4uY2xvc2luZyB7XG4gICAgICAgICAgICAgICAgd2lkdGg6IDMwJTtcbiAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMuZmlsdGVyKGRyb3Atc2hhZG93KDAgM3B4IDJweCByZ2JhKHZhcigtLWNvbG9yMS1yYXcpLCAwLjEpKSk7XG5cbiAgICAgICAgICAgICAgICA+LnRpbGUge1xuICAgICAgICAgICAgICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgICAgICAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgICAgICAgICAgICAgICAgICBib3JkZXI6IC4xdncgdmFyKC0tY29sb3IxKSBzb2xpZDtcbiAgICAgICAgICAgICAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiAxdnc7XG4gICAgICAgICAgICAgICAgICAgIG92ZXJmbG93OiBoaWRkZW47XG5cbiAgICAgICAgICAgICAgICAgICAgPi5iZyB7XG4gICAgICAgICAgICAgICAgICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgICAgICAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMuY292ZXIoMCwgMCwgMCwgMCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB6LWluZGV4OiAwO1xuICAgICAgICAgICAgICAgICAgICAgICAgYmFja2dyb3VuZC1pbWFnZTogdXJsKFwiZGF0YTppbWFnZS9zdmcreG1sLCUzQ3N2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIHdpZHRoPScxMDAlMjUnIGhlaWdodD0nMTAwJTI1JyB2aWV3Qm94PScwIDAgODAwIDQwMCclM0UlM0NkZWZzJTNFJTNDcmFkaWFsR3JhZGllbnQgaWQ9J2EnIGN4PSczOTYnIGN5PScyODEnIHI9JzUxNCcgZ3JhZGllbnRVbml0cz0ndXNlclNwYWNlT25Vc2UnJTNFJTNDc3RvcCBvZmZzZXQ9JzAnIHN0b3AtY29sb3I9JyUyM0QxOCcvJTNFJTNDc3RvcCBvZmZzZXQ9JzEnIHN0b3AtY29sb3I9JyUyMzMzMDAwMCcvJTNFJTNDL3JhZGlhbEdyYWRpZW50JTNFJTNDbGluZWFyR3JhZGllbnQgaWQ9J2InIGdyYWRpZW50VW5pdHM9J3VzZXJTcGFjZU9uVXNlJyB4MT0nNDAwJyB5MT0nMTQ4JyB4Mj0nNDAwJyB5Mj0nMzMzJyUzRSUzQ3N0b3Agb2Zmc2V0PScwJyBzdG9wLWNvbG9yPSclMjNGQTMnIHN0b3Atb3BhY2l0eT0nMCcvJTNFJTNDc3RvcCBvZmZzZXQ9JzEnIHN0b3AtY29sb3I9JyUyM0ZBMycgc3RvcC1vcGFjaXR5PScwLjUnLyUzRSUzQy9saW5lYXJHcmFkaWVudCUzRSUzQy9kZWZzJTNFJTNDcmVjdCBmaWxsPSd1cmwoJTIzYSknIHdpZHRoPSc4MDAnIGhlaWdodD0nNDAwJy8lM0UlM0NnIGZpbGwtb3BhY2l0eT0nMC40JyUzRSUzQ2NpcmNsZSBmaWxsPSd1cmwoJTIzYiknIGN4PScyNjcuNScgY3k9JzYxJyByPSczMDAnLyUzRSUzQ2NpcmNsZSBmaWxsPSd1cmwoJTIzYiknIGN4PSc1MzIuNScgY3k9JzYxJyByPSczMDAnLyUzRSUzQ2NpcmNsZSBmaWxsPSd1cmwoJTIzYiknIGN4PSc0MDAnIGN5PSczMCcgcj0nMzAwJy8lM0UlM0MvZyUzRSUzQy9zdmclM0VcIik7XG4gICAgICAgICAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kLXNpemU6IGNvdmVyO1xuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgPi5jb250ZW50IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy52Y2VudGVyKGFic29sdXRlKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICAgICAgICAgICAgICAgICAgcGFkZGluZzogMCAydnc7XG4gICAgICAgICAgICAgICAgICAgICAgICB6LWluZGV4OiAxO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICBsYWJlbCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9udC1zaXplOiAyLjF2dztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2xvcjogdmFyKC0tY29sb3IyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXdlaWdodDogdmFyKC0tc3Ryb25nKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgcCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sb3I6IHZhcigtLWNvbG9yMkFsdDIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtc2l6ZTogMS42dnc7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgID4udmFsdWUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtc2l6ZTogN3Z3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvbG9yOiB2YXIoLS1jb2xvcjIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtd2VpZ2h0OiB2YXIoLS1zdHJvbmdlc3QpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxpbmUtaGVpZ2h0OiAxO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5hbmltYXRpb24oY2xvc2VMb2FkSW4sIDEsIGxpbmVhciwgMnMpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfVxuXG4gICAgPi5mb2N1cyB7XG4gICAgICAgIGZsZXg6IDE7XG4gICAgICAgIG1hcmdpbi10b3A6IDF2dztcbiAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuXG4gICAgICAgID4uY29udGVudCB7XG4gICAgICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMuY292ZXIoMCwgMCwgMCwgMCk7XG4gICAgICAgICAgICBkaXNwbGF5OiBmbGV4O1xuXG4gICAgICAgICAgICA+LmNvbHVtbiB7XG4gICAgICAgICAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgICAgICAgICAgICAgIHBvc2l0aW9uOiByZWxhdGl2ZTtcbiAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiAxdnc7XG4gICAgICAgICAgICAgICAgYmFja2dyb3VuZC1jb2xvcjogdmFyKC0tY29sb3IyKTtcbiAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMuZmlsdGVyKGRyb3Atc2hhZG93KDAgM3B4IDJweCByZ2JhKHZhcigtLWNvbG9yMS1yYXcpLCAwLjEpKSk7XG4gICAgICAgICAgICAgICAgbWFyZ2luLWxlZnQ6IDF2dztcbiAgICAgICAgICAgICAgICBvdmVyZmxvdy14OiBoaWRkZW47XG5cbiAgICAgICAgICAgICAgICAmOmZpcnN0LWNoaWxkIHtcbiAgICAgICAgICAgICAgICAgICAgbWFyZ2luLWxlZnQ6IDA7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAudGFza3Mge1xuICAgICAgICAgICAgICAgIHdpZHRoOiBjYWxjKDQwJSAtIC41dncpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAuYXBwb2ludG1lbnRzIHtcbiAgICAgICAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG4gICAgICAgICAgICAgICAgd2lkdGg6IGNhbGMoNjAlIC0gLjV2dyk7XG5cbiAgICAgICAgICAgICAgICA+aGVhZGVyIHtcbiAgICAgICAgICAgICAgICAgICAgei1pbmRleDogMTtcbiAgICAgICAgICAgICAgICAgICAgcGFkZGluZzogMXZ3O1xuICAgICAgICAgICAgICAgICAgICBiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1jb2xvcjIpO1xuICAgICAgICAgICAgICAgICAgICBib3JkZXItYm90dG9tOiAuMXZ3IHZhcigtLWNvbG9yMkFsdDIpIHNvbGlkO1xuICAgICAgICAgICAgICAgICAgICBwb3NpdGlvbjogc3RpY2t5O1xuICAgICAgICAgICAgICAgICAgICB0b3A6IDA7XG4gICAgICAgICAgICAgICAgICAgIHotaW5kZXg6IDE7XG4gICAgICAgICAgICAgICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgICAgICAgICAgICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gICAgICAgICAgICAgICAgICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcblxuICAgICAgICAgICAgICAgICAgICA+LnByaW1hcnkge1xuICAgICAgICAgICAgICAgICAgICAgICAgaDIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtc2l6ZTogMS42dnc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sb3I6IHZhcigtLWNvbG9yMSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9udC13ZWlnaHQ6IHZhcigtLXN0cm9uZyk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICA+LmNvbnRlbnQge1xuICAgICAgICAgICAgICAgICAgICBwYWRkaW5nLXRvcDogMnZ3O1xuICAgICAgICAgICAgICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgICAgICAgICAgICAgIHotaW5kZXg6IDA7XG5cbiAgICAgICAgICAgICAgICAgICAgPi5hcHBvaW50bWVudHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgICAgICAgICAgICAgICAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgICAgICAgICAgICAgICAgICBvdmVyZmxvdy14OiBoaWRkZW47XG4gICAgICAgICAgICAgICAgICAgICAgICBwYWRkaW5nOiAwIDF2dyAxdnc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgID5hcHBvaW50bWVudC1zdW1tYXJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaXNwbGF5OiBibG9jaztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBtYXJnaW4tdG9wOiAxdnc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYm9yZGVyLXJhZGl1czogLjV2dztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBvdmVyZmxvdzogaGlkZGVuO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGJvcmRlcjogLjF2dyB2YXIoLS1jb2xvcjJBbHQyKSBzb2xpZDtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICY6Zmlyc3QtY2hpbGQge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBtYXJnaW4tdG9wOiAwO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgID4ubWVzc2FnZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBtYXJnaW46IDV2dyBhdXRvIDA7XG4gICAgICAgICAgICAgICAgICAgICAgICB3aWR0aDogNjAlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICBwIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXNpemU6IDJ2dztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2xvcjogdmFyKC0tY29sb3IxQWx0Mik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9udC13ZWlnaHQ6IHZhcigtLWx0d2VpZ2h0KTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgIC5jb250cm9scyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbWFyZ2luLXRvcDogMXZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA+LmNvbnRyb2wge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjdXJzb3I6IHBvaW50ZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPmxhYmVsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtc2l6ZTogMnZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sb3I6IHZhcigtLWNvbG9yMyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXdlaWdodDogdmFyKC0tbHR3ZWlnaHQpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAubWFwIHtcbiAgICAgICAgICAgICAgICBwb3NpdGlvbjogcmVsYXRpdmU7XG4gICAgICAgICAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcbiAgICAgICAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG5cbiAgICAgICAgICAgICAgICA+aGVhZGVyIHtcbiAgICAgICAgICAgICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICAgICAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICAgICAgICAgICAgICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgICAgICAgICAgICAgICAgICBwYWRkaW5nOiAxdnc7XG5cbiAgICAgICAgICAgICAgICAgICAgPi5wcmltYXJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGgyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmb250LXNpemU6IDEuNnZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNvbG9yOiB2YXIoLS1jb2xvcjEpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtd2VpZ2h0OiB2YXIoLS1zdHJvbmcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgPi5jb250cm9scyB7XG4gICAgICAgICAgICAgICAgICAgICAgICA+LmNvbnRyb2wge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGN1cnNvcjogcG9pbnRlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgID5pIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9udC1zaXplOiAxLjh2dztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29sb3I6IHZhcigtLWNvbG9yMSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgPi5jb250ZW50IHtcbiAgICAgICAgICAgICAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICAgICAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG4gICAgICAgICAgICAgICAgICAgIGZsZXg6IDE7XG5cbiAgICAgICAgICAgICAgICAgICAgPi5tYXAtd3JhcCB7XG4gICAgICAgICAgICAgICAgICAgICAgICBib3JkZXItcmFkaXVzOiAuNXZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgb3ZlcmZsb3c6IGhpZGRlbjtcbiAgICAgICAgICAgICAgICAgICAgICAgIG9wYWNpdHk6IDA7XG4gICAgICAgICAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMudHJhbnNpdGlvbihvcGFjaXR5LCAuMnMpO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAjcm91dGVNYXAge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBAaW5jbHVkZSBtaXhpbnMuY292ZXIoMCwgMCwgMCwgMCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICYuYWN0aXZlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBvcGFjaXR5OiAxO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICAgICAgPi5sb2FkZXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgQGluY2x1ZGUgbWl4aW5zLmhjZW50ZXIoYWJzb2x1dGUpO1xuICAgICAgICAgICAgICAgICAgICAgICAgdG9wOiAydnc7XG4gICAgICAgICAgICAgICAgICAgICAgICB6LWluZGV4OiAxO1xuICAgICAgICAgICAgICAgICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICAgICAgICAgICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgICAgICAgICAgICAgICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICA+bG9hZGVyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaXNwbGF5OiBibG9jaztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBoZWlnaHQ6IDh2dztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB3aWR0aDogOHZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBpbmNsdWRlIG1peGlucy5maWx0ZXIoc2F0dXJhdGUoMCkpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIG9wYWNpdHk6IC42O1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICA+cCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbWFyZ2luLXRvcDogMXZ3O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvbnQtc2l6ZTogMS42dnc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgd2hpdGUtc3BhY2U6IG5vd3JhcDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb2xvcjogdmFyKC0tY29sb3IxQWx0MSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZm9udC13ZWlnaHQ6IHZhcigtLWx0d2VpZ2h0KTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH1cbn0iXSwic291cmNlUm9vdCI6IiJ9 */"]
    }))();
  }
  return RcComponent;
})();

/***/ }),

/***/ 2064:
/*!*******************************************************************************!*\
  !*** ./src/app/dashboard/components/reminders/reminder/reminder.component.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ReminderComponent: () => (/* binding */ ReminderComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 2714);
/* harmony import */ var src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/reminders/models/reminder */ 353);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/reminders/services/reminder.service */ 9654);
/* harmony import */ var src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/navigation/services/device-route.service */ 2405);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 6216);

/* Models */





const _c0 = ["componentElm"];
function ReminderComponent_div_0_div_21_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 17)(1, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, " Follow up by ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](3, "span", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](5, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("warning", ctx_r1.isInPast);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind2"](5, 3, ctx_r1.reminder.scheduled_Utc, "MMM d, h:mm a"), " ");
  }
}
function ReminderComponent_div_0_div_23_button_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ReminderComponent_div_0_div_23_button_5_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r3);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](3);
      return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r1.goToAppointment(ctx_r1.reminder.reference.referenceId));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](1, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](2, " Go to Appointment ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
  }
}
function ReminderComponent_div_0_div_23_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 18)(1, "div", 6)(2, "span", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](4, "div", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](5, ReminderComponent_div_0_div_23_button_5_Template, 3, 0, "button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", ctx_r1.reminder.reference.content, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r1.reminder.reference.type == ctx_r1.ReminderReferenceType.Appointment);
  }
}
function ReminderComponent_div_0_div_28_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](1, "i", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
  }
}
function ReminderComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function ReminderComponent_div_0_Template_button_click_2_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵrestoreView"](_r1);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵresetView"](ctx_r1.completeReminder(ctx_r1.reminder));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](3, "span", 4)(4, "i", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](5, "div", 6)(6, "div", 7)(7, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](9, "div", 8)(10, "div", 9)(11, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](12, " Created By ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](13, "span", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](15, "div", 11)(16, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](17, "On");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](18, "span", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipe"](20, "date");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](21, ReminderComponent_div_0_div_21_Template, 6, 6, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](22, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](23, ReminderComponent_div_0_div_23_Template, 6, 2, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](24, "div", 14)(25, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](26);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](27, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](28, ReminderComponent_div_0_div_28_Template, 2, 0, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵclassProp"]("completed", ctx_r1.reminder.status == ctx_r1.ReminderStatus.Completed || ctx_r1.reminder.completing);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx_r1.reminder.title);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate2"](" ", ctx_r1.reminder.creator == null ? null : ctx_r1.reminder.creator.firstName, " ", ctx_r1.reminder.creator == null ? null : ctx_r1.reminder.creator.lastName, " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵpipeBind2"](20, 10, ctx_r1.reminder.created_Utc, "MMM d, h:mm a"), " ");
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r1.reminder.scheduled_Utc != null);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r1.reminder.reference != null);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtextInterpolate"](ctx_r1.reminder.note);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx_r1.reminder.priority == ctx_r1.ReminderPriority.Critical);
  }
}
let ReminderComponent = /*#__PURE__*/(() => {
  class ReminderComponent {
    constructor(reminderService, routeService) {
      this.reminderService = reminderService;
      this.routeService = routeService;
      this.updated = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
      this.ReminderStatus = src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderStatus;
      this.ReminderPriority = src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderPriority;
      this.isInPast = false;
      // #endregion
      // #region References
      this.ReminderReferenceType = src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderReferenceType;
      // #endregion
      // #region Active User
      this.activeUser = null;
      this.retrieved = new rxjs__WEBPACK_IMPORTED_MODULE_4__.Subject();
    }
    completeReminder(reminder) {
      reminder.completing = true;
      setTimeout(() => {
        reminder.status = src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderStatus.Completed;
        this.reminderService.storeReminder(reminder);
        this.updated.next();
      }, 750);
    }
    initReminder() {
      if (this.reminder != null) {
        const now = new Date();
        if (this.reminder.scheduled_Utc != null) {
          const scheduled = new Date(this.reminder.scheduled_Utc);
          if (scheduled < now) {
            this.isInPast = true;
          }
        }
      }
    }
    goToAppointment(id) {
      this.routeService.viewRouteByType("Appointment", [id], true);
    }
    init() {
      this.initReminder();
    }
    // #endregion
    ngOnInit() {
      this.init();
    }
    ngOnDestroy() {}
    static #_ = (() => this.ɵfac = function ReminderComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || ReminderComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_1__.ReminderService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_2__.DeviceRouteService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({
      type: ReminderComponent,
      selectors: [["reminder"]],
      viewQuery: function ReminderComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        reminder: "reminder",
        activeUser: "activeUser"
      },
      outputs: {
        updated: "updated",
        retrieved: "retrieved"
      },
      standalone: false,
      decls: 1,
      vars: 1,
      consts: [["class", "reminder", 3, "completed", 4, "ngIf"], [1, "reminder"], [1, "controls"], [1, "control", 3, "click"], [1, "fill"], [1, "fa-solid", "fa-check"], [1, "content"], [1, "title"], [1, "meta"], [1, "author"], [1, "value"], [1, "timestamp"], ["class", "scheduled", 3, "warning", 4, "ngIf"], ["class", "reference", 4, "ngIf"], [1, "notes"], [1, "priority"], ["class", "icon critical", 4, "ngIf"], [1, "scheduled"], [1, "reference"], ["class", "control", 3, "click", 4, "ngIf"], [1, "icon", "critical"], [1, "fa-sharp", "fa-light", "fa-triangle-exclamation"]],
      template: function ReminderComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtemplate"](0, ReminderComponent_div_0_Template, 29, 13, "div", 0);
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("ngIf", ctx.reminder != null);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.NgIf, _angular_common__WEBPACK_IMPORTED_MODULE_5__.DatePipe],
      styles: [".reminder[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  padding: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-right: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n  width: 2vw;\n  height: 2vw;\n  border-radius: 100%;\n  border: 0.2vw var(--color1) solid;\n  position: relative;\n  overflow: hidden;\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .fill[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: var(--color1);\n  border-radius: 100%;\n  transform: scale(0);\n  transition: transform 0.25s var(--easeInOutCirc);\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color2);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  z-index: 2;\n  opacity: 0;\n  transition: opacity 0.4s linear;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 80%;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%] {\n  margin-top: -0.2vw;\n  position: relative;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: inline-block;\n  position: relative;\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%]:after {\n  display: block;\n  content: \"\";\n  position: absolute;\n  top: 50%;\n  transform: translateY(-50%);\n  width: 100%;\n  height: 0.1vw;\n  background-color: var(--color1);\n  pointer-events: none;\n  transform: scaleX(0);\n  transform-origin: left center;\n  transition: transform 0.5s var(--easeInOutCirc);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  color: var(--color3);\n  margin-left: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  color: var(--color4Alt4);\n  margin-left: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled.warning[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled.warning[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n  transition: opacity 0.2s var(--easeInOutCirc);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0.25vw 0.5vw;\n  background-color: rgba(var(--color5-raw), 0.2);\n  border-radius: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  border-radius: 0.5vw;\n  background-color: var(--color3);\n  padding: 0.25vw 0.5vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color2);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n  display: flex;\n  align-items: flex-start;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  margin-left: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 0.8vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date.scheduled[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color4);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date.completed[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--success);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%] {\n  flex: 1;\n  text-align: right;\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%]    > .icon.important[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--warning);\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%]    > .icon.critical[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--critical);\n}\n.reminder.completed[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .fill[_ngcontent-%COMP%] {\n  transform: scale(1);\n}\n.reminder.completed[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n.reminder.completed[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%]:after {\n  transform: scaleX(1);\n}\n.reminder.completed[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  opacity: 0.6;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return ReminderComponent;
})();

/***/ }),

/***/ 4938:
/*!***********************************************************************!*\
  !*** ./src/app/dashboard/components/reminders/reminders.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RemindersComponent: () => (/* binding */ RemindersComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! rxjs */ 2714);
/* harmony import */ var src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/reminders/models/reminder */ 353);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/ui/services/ui.service */ 345);
/* harmony import */ var src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/ui/pipes/order-by.pipe */ 9093);
/* harmony import */ var src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/authentication/services/auth-ref.service */ 4387);
/* harmony import */ var src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/shared/reminders/services/reminder.service */ 9654);
/* harmony import */ var src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/shared/data/services/db.service */ 1235);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _reminder_reminder_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./reminder/reminder.component */ 2064);

/* Models */









const _c0 = ["componentElm"];
function RemindersComponent_ng_container_32_reminder_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "reminder", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("updated", function RemindersComponent_ng_container_32_reminder_1_Template_reminder_updated_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r1);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r1.sortReminders());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const reminder_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("reminder", reminder_r3);
  }
}
function RemindersComponent_ng_container_32_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](1, RemindersComponent_ng_container_32_reminder_1_Template, 1, 1, "reminder", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementContainerEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngForOf", ctx_r1.displayReminders);
  }
}
function RemindersComponent_div_33_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementContainerEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate2"](" You currently have no ", ctx_r1.selectedSort, " reminders with ", ctx_r1.selectedPriority, " priority. ");
  }
}
function RemindersComponent_div_33_ng_container_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementContainerEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate1"](" You currently have no reminders with ", ctx_r1.selectedPriority, " priority. ");
  }
}
function RemindersComponent_div_33_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 16)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](2, RemindersComponent_div_33_ng_container_2_Template, 2, 2, "ng-container", 12)(3, RemindersComponent_div_33_ng_container_3_Template, 2, 1, "ng-container", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx_r1.selectedSort != "All");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx_r1.selectedSort == "All");
  }
}
let RemindersComponent = /*#__PURE__*/(() => {
  class RemindersComponent {
    constructor(uiService, orderByPipe, authRefService, reminderService, dbService) {
      this.uiService = uiService;
      this.orderByPipe = orderByPipe;
      this.authRefService = authRefService;
      this.reminderService = reminderService;
      this.dbService = dbService;
      // #region Sort
      this.selectedSort = "Open";
      this.selectingSort = false;
      // #endregion
      // #region Priority
      this.selectedPriority = "Critical";
      this.selectingPriority = false;
      // #endregion
      // #region Reminders
      this.retrievingReminders = false;
      this.reminders = [];
      this.displayReminders = [];
      this.now = new Date();
      // #endregion
      // #region Reminder
      this.ReminderStatus = src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderStatus;
      this.ReminderPriority = src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderPriority;
      // #endregion
      // #region Appointments
      this.appointments = [];
      // #endregion
      // #region Active User
      this.activeUser = null;
      this.retrieved = new rxjs__WEBPACK_IMPORTED_MODULE_8__.Subject();
    }
    setSort(sort) {
      this.selectedSort = sort;
      this.selectingSort = false;
      this.sortReminders();
    }
    selectSort() {
      this.selectingSort = !this.selectingSort;
    }
    setPriority(priority) {
      this.selectedPriority = priority;
      this.selectingPriority = false;
      this.sortReminders();
    }
    selectPriority() {
      this.selectingPriority = !this.selectingPriority;
    }
    get hasReminders() {
      return this.displayReminders.length > 0;
    }
    sortReminders() {
      const reminders = [];
      for (var i = 0, len = this.reminders.length; i < len; i++) {
        const reminder = this.reminders[i];
        switch (this.selectedSort) {
          case "All":
            {
              reminders.push(reminder);
            }
            break;
          case "Open":
            {
              if (reminder.status != src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderStatus.Completed) {
                reminders.push(reminder);
              }
            }
            break;
          case "Completed":
            {
              if (reminder.status == src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderStatus.Completed) {
                reminders.push(reminder);
              }
            }
            break;
        }
      }
      const sortedReminders = [];
      for (var i = 0, len = reminders.length; i < len; i++) {
        const reminder = reminders[i];
        switch (this.selectedPriority) {
          case "All":
            {
              sortedReminders.push(reminder);
            }
            break;
          case "Standard":
            {
              if (reminder.priority == src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderPriority.Standard) {
                sortedReminders.push(reminder);
              }
            }
            break;
          case "Critical":
            {
              if (reminder.priority == src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_0__.ReminderPriority.Critical) {
                sortedReminders.push(reminder);
              }
            }
            break;
        }
      }
      this.displayReminders = this.orderByPipe.transform(sortedReminders, "lastUpdated_Utc", true);
    }
    retrieveReminders() {
      this.retrievingReminders = true;
      this.reminderService.getReminders().subscribe({
        next: reminders => {
          this.reminders = reminders;
          this.sortReminders();
          this.retrieved.next(this.reminders);
          this.retrievingReminders = false;
        },
        error: () => {
          this.retrievingReminders = false;
        }
      });
    }
    updateReminders(reminders) {
      reminders.forEach(reminder => {
        const existingReminder = this.reminders.find(x => x.id == reminder.id);
        if (existingReminder == null) {
          this.reminders.push(reminder);
        }
      });
      this.sortReminders();
      this.retrieved.next(this.reminders);
    }
    initReminders() {
      this.retrieveReminders();
      this.reminderSubscription = this.dbService.remindersRetrieved.subscribe({
        next: reminders => {
          this.updateReminders(reminders);
        }
      });
      this.savedReminderSubscription = this.reminderService.reminderSaved.subscribe({
        next: reminders => {
          this.retrieveReminders();
        }
      });
    }
    createReminder() {
      const user = this.authRefService.user.getValue();
      if (user != null && this.activeUser != null) {
        this.reminderService.manageReminder(undefined, this.appointments, user, this.activeUser);
      }
    }
    init() {
      this.initReminders();
    }
    // #endregion
    ngOnInit() {
      this.init();
    }
    ngOnDestroy() {
      this.reminderSubscription?.unsubscribe();
      this.savedReminderSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function RemindersComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || RemindersComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_1__.UiService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByPipe), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_3__.AuthRefService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_4__.ReminderService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_5__.DbService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
      type: RemindersComponent,
      selectors: [["reminders"]],
      viewQuery: function RemindersComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        appointments: "appointments",
        activeUser: "activeUser"
      },
      outputs: {
        retrieved: "retrieved"
      },
      standalone: false,
      decls: 34,
      vars: 14,
      consts: [["id", "tasks"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-plus"], [1, "secondary"], [1, "primary-controls"], [1, "secondary-controls"], [1, "control", "all", 3, "click"], [1, "control", "standard", 3, "click"], [1, "control", "critical", 3, "click"], [1, "reminders"], [4, "ngIf"], ["class", "message", 4, "ngIf"], [3, "reminder", "updated", 4, "ngFor", "ngForOf"], [3, "updated", "reminder"], [1, "message"]],
      template: function RemindersComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "section", 0)(1, "header")(2, "div", 1)(3, "h1");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](4, "Your reminders");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "div", 2)(6, "button", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_6_listener() {
            return ctx.createReminder();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](7, "i", 4);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](8, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](9, "Add a reminder");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](10, "div", 5)(11, "div", 6)(12, "button", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_12_listener() {
            return ctx.setSort("All");
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](13, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](14, "All Tasks");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](15, "button", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_15_listener() {
            return ctx.setSort("Open");
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](16, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](17, "Open");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](18, "button", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_18_listener() {
            return ctx.setSort("Completed");
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](19, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](20, "Completed");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](21, "div", 7)(22, "button", 8);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_22_listener() {
            return ctx.setPriority("All");
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](23, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](24, "All Priorities");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](25, "button", 9);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_25_listener() {
            return ctx.setPriority("Standard");
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](26, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](27, "Normal");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](28, "button", 10);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_28_listener() {
            return ctx.setPriority("Critical");
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](29, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](30, "Critical");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](31, "div", 11);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](32, RemindersComponent_ng_container_32_Template, 2, 1, "ng-container", 12)(33, RemindersComponent_div_33_Template, 4, 2, "div", 13);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](12);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵclassProp"]("active", ctx.selectedSort == "All");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵclassProp"]("active", ctx.selectedSort == "Open");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵclassProp"]("active", ctx.selectedSort == "Completed");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵclassProp"]("active", ctx.selectedPriority == "All");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵclassProp"]("active", ctx.selectedPriority == "Standard");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵclassProp"]("active", ctx.selectedPriority == "Critical");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx.hasReminders);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", !ctx.hasReminders);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, _reminder_reminder_component__WEBPACK_IMPORTED_MODULE_6__.ReminderComponent],
      styles: ["#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: 1vw 2vw 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  transition: background-color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n  transition: color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%] {\n  position: relative;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  padding: 0.5vw 0.8vw;\n  border-radius: 0.5vw;\n  background-color: transparent;\n  margin-left: 1vw;\n  transition: background-color 0.2s linear;\n  cursor: pointer;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  transition: color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  display: flex;\n  align-items: center;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  white-space: nowrap;\n  text-align: center;\n  padding: 0.4vw 0.6vw;\n  border-radius: 0.5vw;\n  background-color: transparent;\n  margin-left: 1vw;\n  transition: background-color 0.2s linear;\n  cursor: pointer;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 0.9vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  transition: color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.all[_ngcontent-%COMP%] {\n  background-color: var(--color1);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.standard[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.important[_ngcontent-%COMP%] {\n  background-color: var(--warning);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.critical[_ngcontent-%COMP%] {\n  background-color: var(--critical);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  padding: 0 2vw 2vw;\n  position: relative;\n  z-index: 0;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]   reminder[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 1.25vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]   reminder[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]   reminder[_ngcontent-%COMP%]:last-child {\n  border-bottom: none;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  transform: translate3d(-50%, 0, 0);\n  top: 10%;\n  width: 75%;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return RemindersComponent;
})();

/***/ }),

/***/ 4258:
/*!***********************************************************!*\
  !*** ./src/app/dashboard/components/rgm/rgm.component.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RgmComponent: () => (/* binding */ RgmComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! chart.js */ 3875);
/* harmony import */ var src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/ui/pipes/order-by.pipe */ 9093);
/* harmony import */ var src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/reminders/models/reminder */ 353);
/* harmony import */ var src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/appointments/models/appointment */ 8723);
/* harmony import */ var src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/helpers/models/searching */ 3945);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var _services_dashboard_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/dashboard.service */ 5909);
/* harmony import */ var src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/shared/reminders/services/reminder.service */ 9654);
/* harmony import */ var src_app_shared_system_services_ai_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/shared/system/services/ai.service */ 3786);
/* harmony import */ var src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/shared/navigation/services/device-route.service */ 2405);
/* harmony import */ var src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/shared/authentication/services/auth-ref.service */ 4387);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! src/app/shared/appointments/services/appointment.service */ 8036);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/forms */ 8335);
/* harmony import */ var _shared_appointments_components_appointment_summary_appointment_summary_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../shared/appointments/components/appointment-summary/appointment-summary.component */ 2814);
/* harmony import */ var _shared_ui_pipes_phone_pipe__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../shared/ui/pipes/phone.pipe */ 3407);



















function RgmComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "img", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("src", ctx_r0.profileImage, _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵsanitizeUrl"]);
  }
}
function RgmComponent_p_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", ctx_r0.summaryText, " ");
  }
}
function RgmComponent_div_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 22)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](3, "div", 23)(4, "div", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](ctx_r0.summaryLoaderLabel);
  }
}
function RgmComponent_div_23_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "img", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const member_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("src", member_r3.profileImage_B64, _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵsanitizeUrl"]);
  }
}
function RgmComponent_div_23_div_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "i", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
}
function RgmComponent_div_23_div_9_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 37)(1, "a", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const member_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("href", "mailto:" + member_r3.emailAddress, _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", member_r3.emailAddress, " ");
  }
}
function RgmComponent_div_23_div_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 37)(1, "a", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](3, "phone");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const member_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]().$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("href", "tel:" + member_r3.phone, _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind1"](3, 2, member_r3.phone), " ");
  }
}
function RgmComponent_div_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("click", function RgmComponent_div_23_Template_div_click_0_listener() {
      const member_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r2).$implicit;
      const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r0.setActiveMember(member_r3));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](1, "div", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](2, "canvas", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](3, RgmComponent_div_23_div_3_Template, 2, 1, "div", 27)(4, RgmComponent_div_23_div_4_Template, 2, 0, "div", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](5, "div", 29)(6, "div", 30)(7, "h3");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](9, RgmComponent_div_23_div_9_Template, 3, 2, "div", 31)(10, RgmComponent_div_23_div_10_Template, 4, 4, "div", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](11, "div", 32)(12, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](13, "Current Week Close Percentage");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](14, "span", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](15, "0%");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](16, "div", 32)(17, "label");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](18, "4-Week Close Percentage");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](19, "span", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](20, "0%");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const member_r3 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵclassProp"]("active", (ctx_r0.activeMember == null ? null : ctx_r0.activeMember.id) == member_r3.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", member_r3.profileImage_B64 != null);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", member_r3.profileImage_B64 == null);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](member_r3.fullName);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", member_r3.emailAddress != null);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", member_r3.phone != null);
  }
}
function RgmComponent_div_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 39)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](2, " No team members. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
  }
}
function RgmComponent_option_41_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "option", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const option_r4 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngValue", option_r4.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](option_r4.name);
  }
}
function RgmComponent_option_47_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "option", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const option_r5 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngValue", option_r5.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](option_r5.name);
  }
}
function RgmComponent_div_48_appointment_summary_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](0, "appointment-summary", 43);
  }
  if (rf & 2) {
    const appointment_r6 = ctx.$implicit;
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("appointment", appointment_r6)("manager", ctx_r0.user)("management", true);
  }
}
function RgmComponent_div_48_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](1, RgmComponent_div_48_appointment_summary_1_Template, 1, 3, "appointment-summary", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngForOf", ctx_r0.visibleAppointments);
  }
}
function RgmComponent_div_49_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div", 39)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](2, " No matching appointments found. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
  }
}
chart_js__WEBPACK_IMPORTED_MODULE_13__.Chart.register(chart_js__WEBPACK_IMPORTED_MODULE_13__.CategoryScale, chart_js__WEBPACK_IMPORTED_MODULE_13__.Filler, chart_js__WEBPACK_IMPORTED_MODULE_13__.Tooltip, chart_js__WEBPACK_IMPORTED_MODULE_13__.LinearScale, chart_js__WEBPACK_IMPORTED_MODULE_13__.LineController, chart_js__WEBPACK_IMPORTED_MODULE_13__.LineElement, chart_js__WEBPACK_IMPORTED_MODULE_13__.PointElement, chart_js__WEBPACK_IMPORTED_MODULE_13__.Title);
let RgmComponent = /*#__PURE__*/(() => {
  class RgmComponent {
    constructor(http, dashboardService, reminderService, aiService, deviceRouteService, authRefService, datePipe, currencyPipe, orderByPipe, appointmentService) {
      this.http = http;
      this.dashboardService = dashboardService;
      this.reminderService = reminderService;
      this.aiService = aiService;
      this.deviceRouteService = deviceRouteService;
      this.authRefService = authRefService;
      this.datePipe = datePipe;
      this.currencyPipe = currencyPipe;
      this.orderByPipe = orderByPipe;
      this.appointmentService = appointmentService;
      // #region User
      this.user = null;
      // #endregion
      // #endregion
      // #region Reminders
      this.reminders = [];
      // #endregion
      // #region Summary
      this.retrievingSummary = false;
      this.summaryLoaderLabel = "Your AI summary for today...";
      this.summaryText = "generating ai summmary...";
      // #endregion
      // #region Appointments
      this.AppointmentStatus = src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus;
      this.retrievingAppointments = false;
      this.appointments = [];
      this.visibleAppointments = [];
      this.sortOptions = [];
      this.statusOptions = [];
      // #endregion
      // #region Searching
      this.searchInput = "";
      // #endregion
      // #region Bootstrapping
      this.userId = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject(undefined);
      this.params = new rxjs__WEBPACK_IMPORTED_MODULE_14__.BehaviorSubject([]);
      this.today = new Date();
    }
    get firstName() {
      return this.user?.firstName ?? "";
    }
    get profileImage() {
      return this.user?.profileImage_B64;
    }
    watchUser() {
      this.userSubscription = this.authRefService.user.subscribe({
        next: user => {
          this.user = user;
          this.initTeam();
          this.initAppointments(user);
        }
      });
    }
    get teamMembers() {
      return this.user?.teamMembers ?? [];
    }
    get hasTeamMembers() {
      return this.teamMembers.length > 0;
    }
    setActiveMember(member) {
      this.activeMember = member;
      this.filterAppointments();
    }
    initTeam() {
      if (this.teamMembers.length > 0) {
        this.setActiveMember(this.teamMembers[0]);
      }
    }
    get outstandingCriticalTasks() {
      const reminders = [];
      this.reminders.forEach(reminder => {
        if (reminder.priority == src_app_shared_reminders_models_reminder__WEBPACK_IMPORTED_MODULE_1__.ReminderPriority.Critical) {
          reminders.push(reminder);
        }
      });
      return reminders;
    }
    finalizeReminders(reminders) {
      this.reminders = reminders;
      this.initSummaryText();
    }
    initSummaryText() {
      this.summaryText = this.aiService.generateManagerSummary(this.teamMembers, this.appointments);
    }
    get hasAppointments() {
      return this.visibleAppointments.length > 0;
    }
    get loadingUpcomingAppointment() {
      return this.retrievingAppointments;
    }
    validateAppointments(appointments) {
      for (var i = 0, len = appointments.length; i < len; i++) {
        const appointment = appointments[i];
        const nextAppointment = appointments[i + 1];
        if (appointment.status == src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus.Open && nextAppointment != null) {
          nextAppointment.available = false;
        }
      }
    }
    getAppointments(user) {
      this.retrievingAppointments = true;
      this.appointmentService.getTeamAppointments(user).subscribe({
        next: appointments => {
          this.appointments = appointments;
          this.filterAppointments();
          this.initSummaryText();
          this.retrievingAppointments = false;
        },
        error: () => {
          this.retrievingAppointments = false;
        }
      });
    }
    goToAppointments() {
      this.deviceRouteService.viewRouteByType("Appointments", ['all'], true);
    }
    initAppointments(user) {
      if (user != null) {
        this.initSortOptions();
        this.getAppointments(user);
      }
    }
    sortAppointments(property, descending = false) {
      this.visibleAppointments = this.orderByPipe.transform(this.visibleAppointments, property, descending);
    }
    initSortOptions() {
      const sortOptions = [];
      const statusOptions = [];
      sortOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption("scheduled_Utc", "Scheduled"));
      sortOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption("lastUpdated_Utc", "Last Updated"));
      this.activeSort = sortOptions[0].id;
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption(undefined, "All"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus.Open, "Open"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus.Dispositioned, "Dispositioned"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus.InProgress, "In Progress"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_3__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_2__.AppointmentStatus.Sold, "Sold"));
      this.activeStatus = undefined;
      this.sortOptions = sortOptions;
      this.statusOptions = statusOptions;
    }
    filterAppointments() {
      const visibleAppointments = [];
      const searchInput = this.searchInput.toLocaleLowerCase();
      this.appointments.forEach(appointment => {
        let matched = false;
        if (searchInput.length <= 0) {
          matched = true;
        } else {
          if (appointment.customer != null) {
            const customerName = `${appointment.customer.firstName.toLocaleLowerCase()} ${appointment.customer.lastName.toLocaleLowerCase()}`;
            if (customerName.includes(searchInput)) {
              matched = true;
            }
            const matchingContact = appointment.customer.contactInformation.find(x => x.value.includes(searchInput));
            if (matchingContact != null) {
              matched = true;
            }
          }
          if (appointment.property?.address?.friendlyAddress != null) {
            const friendlyAddress = appointment.property.address.friendlyAddress.toLocaleLowerCase();
            if (friendlyAddress.includes(searchInput)) {
              matched = true;
            }
          }
          if (appointment.jobId != null && appointment.jobId.toString().includes(searchInput)) {
            matched = true;
          }
        }
        if (matched && (this.activeStatus == null || appointment.status == this.activeStatus) && (this.activeMember == null || appointment.assignedTo?.id == this.activeMember.id)) {
          visibleAppointments.push(appointment);
        }
      });
      this.visibleAppointments = visibleAppointments;
      if (this.activeSort != null) {
        this.sortAppointments(this.activeSort, true);
      }
    }
    watchParams() {
      this.paramsSubscription = this.params.subscribe({
        next: params => {
          let route = params[0]?.toLowerCase();
          if (route != null) {}
        }
      });
    }
    init() {
      this.watchParams();
      this.watchUser();
    }
    // #endregion
    ngAfterViewInit() {
      setTimeout(() => {
        this.init();
        setTimeout(() => {
          if (this.route != null) {
            this.route.initialized.next();
          }
        }, 32);
      }, 16);
    }
    ngOnDestroy() {
      this.userSubscription?.unsubscribe();
      this.paramsSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function RgmComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || RgmComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_15__.HttpClient), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_services_dashboard_service__WEBPACK_IMPORTED_MODULE_4__.DashboardService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_reminders_services_reminder_service__WEBPACK_IMPORTED_MODULE_5__.ReminderService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_system_services_ai_service__WEBPACK_IMPORTED_MODULE_6__.AiService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_7__.DeviceRouteService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_authentication_services_auth_ref_service__WEBPACK_IMPORTED_MODULE_8__.AuthRefService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_16__.DatePipe), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_16__.CurrencyPipe), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_0__.OrderByPipe), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_9__.AppointmentService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdefineComponent"]({
      type: RgmComponent,
      selectors: [["rgm-view"]],
      inputs: {
        userId: "userId",
        route: "route",
        params: "params"
      },
      standalone: false,
      features: [_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵProvidersFeature"]([src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_0__.OrderByPipe])],
      decls: 50,
      vars: 18,
      consts: [["id", "rgmView"], [1, "primary"], [1, "content"], [1, "summary", "card"], ["class", "profile", 4, "ngIf"], [4, "ngIf"], ["class", "loader", 4, "ngIf"], [1, "focus"], [1, "column", "team"], ["class", "member", 3, "active", "click", 4, "ngFor", "ngForOf"], ["class", "message", 4, "ngIf"], [1, "column", "appointments"], [1, "search"], [1, "input"], ["type", "text", "placeholder", "Search appointments...", 3, "ngModelChange", "input", "ngModel"], [1, "sorting"], [1, "control"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], ["class", "appointments", 4, "ngIf"], [1, "profile"], [3, "src"], [1, "loader"], [1, "bar"], [1, "member", 3, "click"], [1, "avatar"], ["width", "3", "height", "4"], ["class", "image", 4, "ngIf"], ["class", "placeholder", 4, "ngIf"], [1, "meta"], [1, "name"], ["class", "contact", 4, "ngIf"], [1, "closing"], [1, "value"], [1, "image"], [1, "placeholder"], [1, "fa-solid", "fa-user"], [1, "contact"], [3, "href"], [1, "message"], [3, "ngValue"], [1, "appointments"], [3, "appointment", "manager", "management", 4, "ngFor", "ngForOf"], [3, "appointment", "manager", "management"]],
      template: function RgmComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "section", 0)(1, "div", 1)(2, "div", 2)(3, "div", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](4, RgmComponent_div_4_Template, 2, 1, "div", 4);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](5, "div", 2)(6, "header")(7, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](8);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipe"](9, "date");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](10, "h3");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](11);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](12, "div", 2);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](13, RgmComponent_p_13_Template, 2, 1, "p", 5)(14, RgmComponent_div_14_Template, 5, 1, "div", 6);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](15, "div", 7)(16, "div", 2)(17, "div", 8)(18, "header")(19, "div", 1)(20, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](21, " Your Team ");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](22, "div", 2);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](23, RgmComponent_div_23_Template, 21, 7, "div", 9)(24, RgmComponent_div_24_Template, 3, 0, "div", 10);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](25, "div", 11)(26, "header")(27, "div", 1)(28, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](29);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](30, "div", 2)(31, "header")(32, "div", 12)(33, "div", 13)(34, "input", 14);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayListener"]("ngModelChange", function RgmComponent_Template_input_ngModelChange_34_listener($event) {
            _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayBindingSet"](ctx.searchInput, $event) || (ctx.searchInput = $event);
            return $event;
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("input", function RgmComponent_Template_input_input_34_listener() {
            return ctx.filterAppointments();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](35, "div", 15)(36, "div", 16)(37, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](38, "Sorting By");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](39, "div", 13)(40, "select", 17);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayListener"]("ngModelChange", function RgmComponent_Template_select_ngModelChange_40_listener($event) {
            _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayBindingSet"](ctx.activeSort, $event) || (ctx.activeSort = $event);
            return $event;
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("change", function RgmComponent_Template_select_change_40_listener() {
            return ctx.filterAppointments();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](41, RgmComponent_option_41_Template, 2, 2, "option", 18);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](42, "div", 16)(43, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](44, "Status");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](45, "div", 13)(46, "select", 17);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayListener"]("ngModelChange", function RgmComponent_Template_select_ngModelChange_46_listener($event) {
            _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayBindingSet"](ctx.activeStatus, $event) || (ctx.activeStatus = $event);
            return $event;
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("change", function RgmComponent_Template_select_change_46_listener() {
            return ctx.filterAppointments();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](47, RgmComponent_option_47_Template, 2, 2, "option", 18);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](48, RgmComponent_div_48_Template, 2, 1, "div", 19)(49, RgmComponent_div_49_Template, 3, 0, "div", 10);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()()()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.profileImage != null);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"]("Your team summary for ", _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵpipeBind2"](9, 15, ctx.today, "EEEE, MMMM d"), "");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"]("Welcome back, ", ctx.firstName, "");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", !ctx.retrievingSummary);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.retrievingSummary);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](9);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngForOf", ctx.teamMembers);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", !ctx.hasTeamMembers);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](5);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate1"](" ", ctx.activeMember == null ? null : ctx.activeMember.fullName, "'s Appointments ");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](5);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayProperty"]("ngModel", ctx.searchInput);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](6);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayProperty"]("ngModel", ctx.activeSort);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngForOf", ctx.sortOptions);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](5);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtwoWayProperty"]("ngModel", ctx.activeStatus);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngForOf", ctx.statusOptions);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.hasAppointments);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", !ctx.hasAppointments);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_16__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_16__.NgIf, _angular_forms__WEBPACK_IMPORTED_MODULE_17__.NgSelectOption, _angular_forms__WEBPACK_IMPORTED_MODULE_17__["ɵNgSelectMultipleOption"], _angular_forms__WEBPACK_IMPORTED_MODULE_17__.DefaultValueAccessor, _angular_forms__WEBPACK_IMPORTED_MODULE_17__.SelectControlValueAccessor, _angular_forms__WEBPACK_IMPORTED_MODULE_17__.NgControlStatus, _shared_appointments_components_appointment_summary_appointment_summary_component__WEBPACK_IMPORTED_MODULE_10__.AppointmentSummaryComponent, _angular_forms__WEBPACK_IMPORTED_MODULE_17__.NgModel, _angular_common__WEBPACK_IMPORTED_MODULE_16__.DatePipe, _shared_ui_pipes_phone_pipe__WEBPACK_IMPORTED_MODULE_11__.PhoneFormatPipe],
      styles: ["@keyframes _ngcontent-%COMP%_closeLoadIn {\n  0% {\n    opacity: 0;\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n#rgmView[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 2vw;\n  right: 2vw;\n  bottom: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%] {\n  border-radius: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n  background-color: var(--color6);\n  border: 0.1vw var(--color6Alt3) solid;\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  display: flex;\n  align-items: flex-start;\n  height: 15vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n  position: relative;\n  z-index: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 2.2vw;\n  white-space: nowrap;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw 1vw;\n  background-color: rgba(var(--color6-raw), 0.6);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  border-radius: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strongest);\n  font-style: italic;\n  text-transform: lowercase;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%] {\n  margin-top: 0.8vw;\n  border-radius: 999px;\n  position: relative;\n  height: 1.4vw;\n  background-color: var(--color2Alt2);\n  overflow: hidden;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:before {\n  content: \"\";\n  display: block;\n  position: absolute;\n  border-radius: 999px;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  transform: translateX(-100%);\n  animation-name: barLoader;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n  background-color: var(--color2Alt1);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(2):before {\n  animation-name: barLoader;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 0.5s;\n  animation-fill-mode: forwards;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(3):before {\n  animation-name: barLoader;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n  animation-duration: 3s;\n  animation-direction: normal;\n  animation-delay: 1s;\n  animation-fill-mode: forwards;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%] {\n  width: 10vw;\n  height: 100%;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  mix-blend-mode: multiply;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%] {\n  flex: 1;\n  margin-top: 1vw;\n  position: relative;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  height: 100%;\n  position: relative;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  margin-left: 1vw;\n  overflow-x: hidden;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  z-index: 1;\n  padding: 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  position: relative;\n  height: 100%;\n  z-index: 0;\n  overflow-x: hidden;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  transform: translate3d(-50%, 0, 0);\n  top: 10%;\n  width: 50%;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n  text-align: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%] {\n  width: calc(40% - 0.5vw);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2);\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%] {\n  height: 15vw;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  position: relative;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  height: 100%;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  mix-blend-mode: multiply;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]    > img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .placeholder[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color3Alt4-raw), 0.2);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .placeholder[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  font-size: 4vw;\n  color: var(--color3Alt3);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  flex: 1;\n  margin: 0 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -ms-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  line-height: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .contact[_ngcontent-%COMP%]   a[_ngcontent-%COMP%] {\n  color: var(--color3);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-decoration: none;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  margin-right: 0.25vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1.8vw;\n  color: var(--color5Alt4);\n  font-weight: var(--strongest);\n  animation-name: _ngcontent-%COMP%_closeLoadIn;\n  animation-iteration-count: 1;\n  animation-timing-function: linear;\n  animation-duration: 2s;\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member.active[_ngcontent-%COMP%] {\n  border-color: var(--color3Alt3);\n  background-color: rgba(var(--color3-raw), 0.1);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%] {\n  width: calc(60% - 0.5vw);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 2vw 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.1vw 0.5vw rgba(var(--black-raw), 0.1);\n  padding: 0.5vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%] {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%] {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 0.8vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .appointments[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden;\n  padding: 0 1vw 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .appointments[_ngcontent-%COMP%]    > appointment-summary[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .appointments[_ngcontent-%COMP%]    > appointment-summary[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  top: 8vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%] {\n  position: relative;\n  overflow: hidden;\n  height: 100%;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  flex: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%] {\n  border-radius: 0.5vw;\n  overflow: hidden;\n  opacity: 0;\n  transition: opacity 0.2s linear;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%]   #routeMap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  transform: translate3d(-50%, 0, 0);\n  top: 2vw;\n  z-index: 1;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 8vw;\n  width: 8vw;\n  -moz-filter: saturate(0);\n  -o-filter: saturate(0);\n  -ms-filter: saturate(0);\n  filter: saturate(0);\n  opacity: 0.6;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  font-size: 1.6vw;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  font-weight: var(--ltweight);\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return RgmComponent;
})();

/***/ }),

/***/ 2065:
/*!***********************************************!*\
  !*** ./src/app/dashboard/dashboard.module.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DashboardModule: () => (/* binding */ DashboardModule)
/* harmony export */ });
/* harmony import */ var _angular_elements__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/elements */ 3440);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/forms */ 8335);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var _components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/layout/layout.component */ 2880);
/* harmony import */ var _components_rc_rc_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/rc/rc.component */ 4198);
/* harmony import */ var _components_rgm_rgm_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/rgm/rgm.component */ 4258);
/* harmony import */ var _components_reminders_reminders_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/reminders/reminders.component */ 4938);
/* harmony import */ var _components_reminders_reminder_reminder_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/reminders/reminder/reminder.component */ 2064);
/* harmony import */ var _components_appointment_appointment_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/appointment/appointment.component */ 6214);
/* harmony import */ var _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../shared/ui/ui.module */ 663);
/* harmony import */ var _services_dashboard_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./services/dashboard.service */ 5909);
/* harmony import */ var _shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/navigation/services/internal-route.service */ 8858);
/* harmony import */ var _shared_appointments_appointments_module__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/appointments/appointments.module */ 7215);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 4380);




/* Components */






/* Modules */

/* Services */




let DashboardModule = /*#__PURE__*/(() => {
  class DashboardModule {
    constructor(injector) {
      this.injector = injector;
      this.ngDoBootstrap();
    }
    ngDoBootstrap() {
      const el = (0,_angular_elements__WEBPACK_IMPORTED_MODULE_10__.createCustomElement)(_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.DashboardLayoutComponent, {
        injector: this.injector
      });
      customElements.define('global-dashboard', el);
    }
    static #_ = (() => this.ɵfac = function DashboardModule_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DashboardModule)(_angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_11__.Injector));
    })();
    static #_2 = (() => this.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdefineNgModule"]({
      type: DashboardModule
    }))();
    static #_3 = (() => this.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵdefineInjector"]({
      providers: [_services_dashboard_service__WEBPACK_IMPORTED_MODULE_7__.DashboardService, _shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_8__.InternalRouteService, (0,_angular_common_http__WEBPACK_IMPORTED_MODULE_12__.provideHttpClient)((0,_angular_common_http__WEBPACK_IMPORTED_MODULE_12__.withInterceptorsFromDi)())],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.CommonModule, _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_6__.UiModule, _angular_forms__WEBPACK_IMPORTED_MODULE_14__.ReactiveFormsModule, _shared_appointments_appointments_module__WEBPACK_IMPORTED_MODULE_9__.SharedAppointmentsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_14__.FormsModule]
    }))();
  }
  return DashboardModule;
})();
(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_11__["ɵɵsetNgModuleScope"](DashboardModule, {
    declarations: [_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.DashboardLayoutComponent, _components_rc_rc_component__WEBPACK_IMPORTED_MODULE_1__.RcComponent, _components_rgm_rgm_component__WEBPACK_IMPORTED_MODULE_2__.RgmComponent, _components_reminders_reminder_reminder_component__WEBPACK_IMPORTED_MODULE_4__.ReminderComponent, _components_reminders_reminders_component__WEBPACK_IMPORTED_MODULE_3__.RemindersComponent, _components_appointment_appointment_component__WEBPACK_IMPORTED_MODULE_5__.AppointmentComponent],
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.CommonModule, _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_6__.UiModule, _angular_forms__WEBPACK_IMPORTED_MODULE_14__.ReactiveFormsModule, _shared_appointments_appointments_module__WEBPACK_IMPORTED_MODULE_9__.SharedAppointmentsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_14__.FormsModule]
  });
})();

/***/ }),

/***/ 8290:
/*!************************************************!*\
  !*** ./src/app/dashboard/models/navigation.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DashboardRouteType: () => (/* binding */ DashboardRouteType)
/* harmony export */ });
var DashboardRouteType = /*#__PURE__*/function (DashboardRouteType) {
  DashboardRouteType["today"] = "today";
  DashboardRouteType["team"] = "team";
  return DashboardRouteType;
}(DashboardRouteType || {});

/***/ }),

/***/ 5909:
/*!*********************************************************!*\
  !*** ./src/app/dashboard/services/dashboard.service.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DashboardService: () => (/* binding */ DashboardService)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 2921);
/* harmony import */ var _models_navigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/navigation */ 8290);
/* harmony import */ var src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/navigation/models/navigation */ 9518);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/data/services/db.service */ 1235);
/* harmony import */ var src_app_shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/navigation/services/internal-route.service */ 8858);







let DashboardService = /*#__PURE__*/(() => {
  class DashboardService {
    constructor(http, dbService, routeService) {
      this.http = http;
      this.dbService = dbService;
      this.routeService = routeService;
      // #region Routes
      this.routesInitialized = false;
    }
    initRoutes(initialRouteType = undefined, componentElm) {
      setTimeout(() => {
        if (componentElm != null) {
          const routes = {
            [_models_navigation__WEBPACK_IMPORTED_MODULE_0__.DashboardRouteType.today]: new src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_1__.InternalRoute(_models_navigation__WEBPACK_IMPORTED_MODULE_0__.DashboardRouteType.today),
            [_models_navigation__WEBPACK_IMPORTED_MODULE_0__.DashboardRouteType.team]: new src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_1__.InternalRoute(_models_navigation__WEBPACK_IMPORTED_MODULE_0__.DashboardRouteType.team)
          };
          const initialRoute = initialRouteType != null ? initialRouteType : _models_navigation__WEBPACK_IMPORTED_MODULE_0__.DashboardRouteType.today;
          this.routeService.init(routes, initialRoute, 250, componentElm);
          this.routesInitialized = true;
        }
      }, 0);
    }
    // #endregion
    // #region Reminders
    getReminders() {
      return new rxjs__WEBPACK_IMPORTED_MODULE_4__.Observable(o => {
        this.dbService.getRemindersForActiveUser().then(reminders => {
          o.next(reminders);
          o.complete();
        }).catch(() => {
          o.next([]);
          o.complete();
        });
      });
    }
    static #_ = (() => this.ɵfac = function DashboardService_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DashboardService)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_6__.HttpClient), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_2__.DbService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](src_app_shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_3__.InternalRouteService));
    })();
    static #_2 = (() => this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineInjectable"]({
      token: DashboardService,
      factory: DashboardService.ɵfac,
      providedIn: 'root'
    }))();
  }
  return DashboardService;
})();

/***/ }),

/***/ 8858:
/*!**********************************************************************!*\
  !*** ./src/app/shared/navigation/services/internal-route.service.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InternalRouteService: () => (/* binding */ InternalRouteService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var _models_navigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/navigation */ 9518);


/* Models */


/* Services */
let InternalRouteService = /*#__PURE__*/(() => {
  class InternalRouteService {
    constructor(renderFactory) {
      this.renderFactory = renderFactory;
      // #region UI
      this.transitionInMs = 250;
      // #endregion
      // #region Routes
      this.routes = {};
      this.routeChanging = false;
      this.activeRoute = new rxjs__WEBPACK_IMPORTED_MODULE_1__.BehaviorSubject(undefined);
      this.renderer = renderFactory.createRenderer(null, null);
    }
    setCssVariable(nativeElement, name, value) {
      this.renderer.setStyle(nativeElement, name, value, _angular_core__WEBPACK_IMPORTED_MODULE_2__.RendererStyleFlags2.DashCase);
    }
    viewRoute(type, direction, animate = false, activeDirection = _models_navigation__WEBPACK_IMPORTED_MODULE_0__.RouteLoadDirection.Forward, params = []) {
      const route = this.routes[type];
      if (route != null) {
        route.params.next(params);
        const activeRoute = this.activeRoute.getValue();
        if (activeRoute?.type != type) {
          this.closeActiveRoute(activeDirection, animate);
        }
        this.routeChanging = true;
        route.loadDirection = direction;
        route.active = true;
        this.activeRoute.next(route);
        const transitionInMs = animate ? this.transitionInMs : 0;
        const initSubscription = route.initialized.subscribe({
          next: () => {
            route.animating = animate;
            setTimeout(() => {
              this.routeChanging = false;
              route.animating = false;
              route.rendered = true;
            }, transitionInMs);
            initSubscription.unsubscribe();
          }
        });
      }
    }
    closeActiveRoute(direction, animate = false) {
      const route = this.activeRoute.getValue();
      if (route != null) {
        route.loadDirection = direction;
        route.closing = true;
        route.animating = animate;
        setTimeout(() => {
          route.active = false;
          route.closing = false;
          route.animating = false;
          route.rendered = false;
        }, this.transitionInMs);
      }
    }
    // #endregion
    // #region Bootstrapping
    init(routes, defaultRoute = null, transitionInMs = 250, componentElm) {
      this.routes = routes;
      this.transitionInMs = transitionInMs;
      this.setCssVariable(componentElm, "--routeTransition", `${transitionInMs}ms`);
      if (defaultRoute != null) {
        this.defaultRoute = this.routes[defaultRoute];
        this.viewRoute(defaultRoute, this.defaultRoute.loadDirection);
      }
    }
    // #endregion
    ngOnDestroy() {}
    static #_ = (() => this.ɵfac = function InternalRouteService_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || InternalRouteService)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__.RendererFactory2));
    })();
    static #_2 = (() => this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
      token: InternalRouteService,
      factory: InternalRouteService.ɵfac
    }))();
  }
  return InternalRouteService;
})();

/***/ }),

/***/ 9804:
/*!*********************************************************************************************!*\
  !*** ./node_modules/.pnpm/@kurkle+color@0.3.2/node_modules/@kurkle/color/dist/color.esm.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Color: () => (/* binding */ Color),
/* harmony export */   b2n: () => (/* binding */ b2n),
/* harmony export */   b2p: () => (/* binding */ b2p),
/* harmony export */   "default": () => (/* binding */ index_esm),
/* harmony export */   hexParse: () => (/* binding */ hexParse),
/* harmony export */   hexString: () => (/* binding */ hexString),
/* harmony export */   hsl2rgb: () => (/* binding */ hsl2rgb),
/* harmony export */   hslString: () => (/* binding */ hslString),
/* harmony export */   hsv2rgb: () => (/* binding */ hsv2rgb),
/* harmony export */   hueParse: () => (/* binding */ hueParse),
/* harmony export */   hwb2rgb: () => (/* binding */ hwb2rgb),
/* harmony export */   lim: () => (/* binding */ lim),
/* harmony export */   n2b: () => (/* binding */ n2b),
/* harmony export */   n2p: () => (/* binding */ n2p),
/* harmony export */   nameParse: () => (/* binding */ nameParse),
/* harmony export */   p2b: () => (/* binding */ p2b),
/* harmony export */   rgb2hsl: () => (/* binding */ rgb2hsl),
/* harmony export */   rgbParse: () => (/* binding */ rgbParse),
/* harmony export */   rgbString: () => (/* binding */ rgbString),
/* harmony export */   rotate: () => (/* binding */ rotate),
/* harmony export */   round: () => (/* binding */ round)
/* harmony export */ });
/*!
 * @kurkle/color v0.3.2
 * https://github.com/kurkle/color#readme
 * (c) 2023 Jukka Kurkela
 * Released under the MIT License
 */
function round(v) {
  return v + 0.5 | 0;
}
const lim = (v, l, h) => Math.max(Math.min(v, h), l);
function p2b(v) {
  return lim(round(v * 2.55), 0, 255);
}
function b2p(v) {
  return lim(round(v / 2.55), 0, 100);
}
function n2b(v) {
  return lim(round(v * 255), 0, 255);
}
function b2n(v) {
  return lim(round(v / 2.55) / 100, 0, 1);
}
function n2p(v) {
  return lim(round(v * 100), 0, 100);
}
const map$1 = {
  0: 0,
  1: 1,
  2: 2,
  3: 3,
  4: 4,
  5: 5,
  6: 6,
  7: 7,
  8: 8,
  9: 9,
  A: 10,
  B: 11,
  C: 12,
  D: 13,
  E: 14,
  F: 15,
  a: 10,
  b: 11,
  c: 12,
  d: 13,
  e: 14,
  f: 15
};
const hex = [...'0123456789ABCDEF'];
const h1 = b => hex[b & 0xF];
const h2 = b => hex[(b & 0xF0) >> 4] + hex[b & 0xF];
const eq = b => (b & 0xF0) >> 4 === (b & 0xF);
const isShort = v => eq(v.r) && eq(v.g) && eq(v.b) && eq(v.a);
function hexParse(str) {
  var len = str.length;
  var ret;
  if (str[0] === '#') {
    if (len === 4 || len === 5) {
      ret = {
        r: 255 & map$1[str[1]] * 17,
        g: 255 & map$1[str[2]] * 17,
        b: 255 & map$1[str[3]] * 17,
        a: len === 5 ? map$1[str[4]] * 17 : 255
      };
    } else if (len === 7 || len === 9) {
      ret = {
        r: map$1[str[1]] << 4 | map$1[str[2]],
        g: map$1[str[3]] << 4 | map$1[str[4]],
        b: map$1[str[5]] << 4 | map$1[str[6]],
        a: len === 9 ? map$1[str[7]] << 4 | map$1[str[8]] : 255
      };
    }
  }
  return ret;
}
const alpha = (a, f) => a < 255 ? f(a) : '';
function hexString(v) {
  var f = isShort(v) ? h1 : h2;
  return v ? '#' + f(v.r) + f(v.g) + f(v.b) + alpha(v.a, f) : undefined;
}
const HUE_RE = /^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;
function hsl2rgbn(h, s, l) {
  const a = s * Math.min(l, 1 - l);
  const f = (n, k = (n + h / 30) % 12) => l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);
  return [f(0), f(8), f(4)];
}
function hsv2rgbn(h, s, v) {
  const f = (n, k = (n + h / 60) % 6) => v - v * s * Math.max(Math.min(k, 4 - k, 1), 0);
  return [f(5), f(3), f(1)];
}
function hwb2rgbn(h, w, b) {
  const rgb = hsl2rgbn(h, 1, 0.5);
  let i;
  if (w + b > 1) {
    i = 1 / (w + b);
    w *= i;
    b *= i;
  }
  for (i = 0; i < 3; i++) {
    rgb[i] *= 1 - w - b;
    rgb[i] += w;
  }
  return rgb;
}
function hueValue(r, g, b, d, max) {
  if (r === max) {
    return (g - b) / d + (g < b ? 6 : 0);
  }
  if (g === max) {
    return (b - r) / d + 2;
  }
  return (r - g) / d + 4;
}
function rgb2hsl(v) {
  const range = 255;
  const r = v.r / range;
  const g = v.g / range;
  const b = v.b / range;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  const l = (max + min) / 2;
  let h, s, d;
  if (max !== min) {
    d = max - min;
    s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
    h = hueValue(r, g, b, d, max);
    h = h * 60 + 0.5;
  }
  return [h | 0, s || 0, l];
}
function calln(f, a, b, c) {
  return (Array.isArray(a) ? f(a[0], a[1], a[2]) : f(a, b, c)).map(n2b);
}
function hsl2rgb(h, s, l) {
  return calln(hsl2rgbn, h, s, l);
}
function hwb2rgb(h, w, b) {
  return calln(hwb2rgbn, h, w, b);
}
function hsv2rgb(h, s, v) {
  return calln(hsv2rgbn, h, s, v);
}
function hue(h) {
  return (h % 360 + 360) % 360;
}
function hueParse(str) {
  const m = HUE_RE.exec(str);
  let a = 255;
  let v;
  if (!m) {
    return;
  }
  if (m[5] !== v) {
    a = m[6] ? p2b(+m[5]) : n2b(+m[5]);
  }
  const h = hue(+m[2]);
  const p1 = +m[3] / 100;
  const p2 = +m[4] / 100;
  if (m[1] === 'hwb') {
    v = hwb2rgb(h, p1, p2);
  } else if (m[1] === 'hsv') {
    v = hsv2rgb(h, p1, p2);
  } else {
    v = hsl2rgb(h, p1, p2);
  }
  return {
    r: v[0],
    g: v[1],
    b: v[2],
    a: a
  };
}
function rotate(v, deg) {
  var h = rgb2hsl(v);
  h[0] = hue(h[0] + deg);
  h = hsl2rgb(h);
  v.r = h[0];
  v.g = h[1];
  v.b = h[2];
}
function hslString(v) {
  if (!v) {
    return;
  }
  const a = rgb2hsl(v);
  const h = a[0];
  const s = n2p(a[1]);
  const l = n2p(a[2]);
  return v.a < 255 ? `hsla(${h}, ${s}%, ${l}%, ${b2n(v.a)})` : `hsl(${h}, ${s}%, ${l}%)`;
}
const map = {
  x: 'dark',
  Z: 'light',
  Y: 're',
  X: 'blu',
  W: 'gr',
  V: 'medium',
  U: 'slate',
  A: 'ee',
  T: 'ol',
  S: 'or',
  B: 'ra',
  C: 'lateg',
  D: 'ights',
  R: 'in',
  Q: 'turquois',
  E: 'hi',
  P: 'ro',
  O: 'al',
  N: 'le',
  M: 'de',
  L: 'yello',
  F: 'en',
  K: 'ch',
  G: 'arks',
  H: 'ea',
  I: 'ightg',
  J: 'wh'
};
const names$1 = {
  OiceXe: 'f0f8ff',
  antiquewEte: 'faebd7',
  aqua: 'ffff',
  aquamarRe: '7fffd4',
  azuY: 'f0ffff',
  beige: 'f5f5dc',
  bisque: 'ffe4c4',
  black: '0',
  blanKedOmond: 'ffebcd',
  Xe: 'ff',
  XeviTet: '8a2be2',
  bPwn: 'a52a2a',
  burlywood: 'deb887',
  caMtXe: '5f9ea0',
  KartYuse: '7fff00',
  KocTate: 'd2691e',
  cSO: 'ff7f50',
  cSnflowerXe: '6495ed',
  cSnsilk: 'fff8dc',
  crimson: 'dc143c',
  cyan: 'ffff',
  xXe: '8b',
  xcyan: '8b8b',
  xgTMnPd: 'b8860b',
  xWay: 'a9a9a9',
  xgYF: '6400',
  xgYy: 'a9a9a9',
  xkhaki: 'bdb76b',
  xmagFta: '8b008b',
  xTivegYF: '556b2f',
  xSange: 'ff8c00',
  xScEd: '9932cc',
  xYd: '8b0000',
  xsOmon: 'e9967a',
  xsHgYF: '8fbc8f',
  xUXe: '483d8b',
  xUWay: '2f4f4f',
  xUgYy: '2f4f4f',
  xQe: 'ced1',
  xviTet: '9400d3',
  dAppRk: 'ff1493',
  dApskyXe: 'bfff',
  dimWay: '696969',
  dimgYy: '696969',
  dodgerXe: '1e90ff',
  fiYbrick: 'b22222',
  flSOwEte: 'fffaf0',
  foYstWAn: '228b22',
  fuKsia: 'ff00ff',
  gaRsbSo: 'dcdcdc',
  ghostwEte: 'f8f8ff',
  gTd: 'ffd700',
  gTMnPd: 'daa520',
  Way: '808080',
  gYF: '8000',
  gYFLw: 'adff2f',
  gYy: '808080',
  honeyMw: 'f0fff0',
  hotpRk: 'ff69b4',
  RdianYd: 'cd5c5c',
  Rdigo: '4b0082',
  ivSy: 'fffff0',
  khaki: 'f0e68c',
  lavFMr: 'e6e6fa',
  lavFMrXsh: 'fff0f5',
  lawngYF: '7cfc00',
  NmoncEffon: 'fffacd',
  ZXe: 'add8e6',
  ZcSO: 'f08080',
  Zcyan: 'e0ffff',
  ZgTMnPdLw: 'fafad2',
  ZWay: 'd3d3d3',
  ZgYF: '90ee90',
  ZgYy: 'd3d3d3',
  ZpRk: 'ffb6c1',
  ZsOmon: 'ffa07a',
  ZsHgYF: '20b2aa',
  ZskyXe: '87cefa',
  ZUWay: '778899',
  ZUgYy: '778899',
  ZstAlXe: 'b0c4de',
  ZLw: 'ffffe0',
  lime: 'ff00',
  limegYF: '32cd32',
  lRF: 'faf0e6',
  magFta: 'ff00ff',
  maPon: '800000',
  VaquamarRe: '66cdaa',
  VXe: 'cd',
  VScEd: 'ba55d3',
  VpurpN: '9370db',
  VsHgYF: '3cb371',
  VUXe: '7b68ee',
  VsprRggYF: 'fa9a',
  VQe: '48d1cc',
  VviTetYd: 'c71585',
  midnightXe: '191970',
  mRtcYam: 'f5fffa',
  mistyPse: 'ffe4e1',
  moccasR: 'ffe4b5',
  navajowEte: 'ffdead',
  navy: '80',
  Tdlace: 'fdf5e6',
  Tive: '808000',
  TivedBb: '6b8e23',
  Sange: 'ffa500',
  SangeYd: 'ff4500',
  ScEd: 'da70d6',
  pOegTMnPd: 'eee8aa',
  pOegYF: '98fb98',
  pOeQe: 'afeeee',
  pOeviTetYd: 'db7093',
  papayawEp: 'ffefd5',
  pHKpuff: 'ffdab9',
  peru: 'cd853f',
  pRk: 'ffc0cb',
  plum: 'dda0dd',
  powMrXe: 'b0e0e6',
  purpN: '800080',
  YbeccapurpN: '663399',
  Yd: 'ff0000',
  Psybrown: 'bc8f8f',
  PyOXe: '4169e1',
  saddNbPwn: '8b4513',
  sOmon: 'fa8072',
  sandybPwn: 'f4a460',
  sHgYF: '2e8b57',
  sHshell: 'fff5ee',
  siFna: 'a0522d',
  silver: 'c0c0c0',
  skyXe: '87ceeb',
  UXe: '6a5acd',
  UWay: '708090',
  UgYy: '708090',
  snow: 'fffafa',
  sprRggYF: 'ff7f',
  stAlXe: '4682b4',
  tan: 'd2b48c',
  teO: '8080',
  tEstN: 'd8bfd8',
  tomato: 'ff6347',
  Qe: '40e0d0',
  viTet: 'ee82ee',
  JHt: 'f5deb3',
  wEte: 'ffffff',
  wEtesmoke: 'f5f5f5',
  Lw: 'ffff00',
  LwgYF: '9acd32'
};
function unpack() {
  const unpacked = {};
  const keys = Object.keys(names$1);
  const tkeys = Object.keys(map);
  let i, j, k, ok, nk;
  for (i = 0; i < keys.length; i++) {
    ok = nk = keys[i];
    for (j = 0; j < tkeys.length; j++) {
      k = tkeys[j];
      nk = nk.replace(k, map[k]);
    }
    k = parseInt(names$1[ok], 16);
    unpacked[nk] = [k >> 16 & 0xFF, k >> 8 & 0xFF, k & 0xFF];
  }
  return unpacked;
}
let names;
function nameParse(str) {
  if (!names) {
    names = unpack();
    names.transparent = [0, 0, 0, 0];
  }
  const a = names[str.toLowerCase()];
  return a && {
    r: a[0],
    g: a[1],
    b: a[2],
    a: a.length === 4 ? a[3] : 255
  };
}
const RGB_RE = /^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/;
function rgbParse(str) {
  const m = RGB_RE.exec(str);
  let a = 255;
  let r, g, b;
  if (!m) {
    return;
  }
  if (m[7] !== r) {
    const v = +m[7];
    a = m[8] ? p2b(v) : lim(v * 255, 0, 255);
  }
  r = +m[1];
  g = +m[3];
  b = +m[5];
  r = 255 & (m[2] ? p2b(r) : lim(r, 0, 255));
  g = 255 & (m[4] ? p2b(g) : lim(g, 0, 255));
  b = 255 & (m[6] ? p2b(b) : lim(b, 0, 255));
  return {
    r: r,
    g: g,
    b: b,
    a: a
  };
}
function rgbString(v) {
  return v && (v.a < 255 ? `rgba(${v.r}, ${v.g}, ${v.b}, ${b2n(v.a)})` : `rgb(${v.r}, ${v.g}, ${v.b})`);
}
const to = v => v <= 0.0031308 ? v * 12.92 : Math.pow(v, 1.0 / 2.4) * 1.055 - 0.055;
const from = v => v <= 0.04045 ? v / 12.92 : Math.pow((v + 0.055) / 1.055, 2.4);
function interpolate(rgb1, rgb2, t) {
  const r = from(b2n(rgb1.r));
  const g = from(b2n(rgb1.g));
  const b = from(b2n(rgb1.b));
  return {
    r: n2b(to(r + t * (from(b2n(rgb2.r)) - r))),
    g: n2b(to(g + t * (from(b2n(rgb2.g)) - g))),
    b: n2b(to(b + t * (from(b2n(rgb2.b)) - b))),
    a: rgb1.a + t * (rgb2.a - rgb1.a)
  };
}
function modHSL(v, i, ratio) {
  if (v) {
    let tmp = rgb2hsl(v);
    tmp[i] = Math.max(0, Math.min(tmp[i] + tmp[i] * ratio, i === 0 ? 360 : 1));
    tmp = hsl2rgb(tmp);
    v.r = tmp[0];
    v.g = tmp[1];
    v.b = tmp[2];
  }
}
function clone(v, proto) {
  return v ? Object.assign(proto || {}, v) : v;
}
function fromObject(input) {
  var v = {
    r: 0,
    g: 0,
    b: 0,
    a: 255
  };
  if (Array.isArray(input)) {
    if (input.length >= 3) {
      v = {
        r: input[0],
        g: input[1],
        b: input[2],
        a: 255
      };
      if (input.length > 3) {
        v.a = n2b(input[3]);
      }
    }
  } else {
    v = clone(input, {
      r: 0,
      g: 0,
      b: 0,
      a: 1
    });
    v.a = n2b(v.a);
  }
  return v;
}
function functionParse(str) {
  if (str.charAt(0) === 'r') {
    return rgbParse(str);
  }
  return hueParse(str);
}
class Color {
  constructor(input) {
    if (input instanceof Color) {
      return input;
    }
    const type = typeof input;
    let v;
    if (type === 'object') {
      v = fromObject(input);
    } else if (type === 'string') {
      v = hexParse(input) || nameParse(input) || functionParse(input);
    }
    this._rgb = v;
    this._valid = !!v;
  }
  get valid() {
    return this._valid;
  }
  get rgb() {
    var v = clone(this._rgb);
    if (v) {
      v.a = b2n(v.a);
    }
    return v;
  }
  set rgb(obj) {
    this._rgb = fromObject(obj);
  }
  rgbString() {
    return this._valid ? rgbString(this._rgb) : undefined;
  }
  hexString() {
    return this._valid ? hexString(this._rgb) : undefined;
  }
  hslString() {
    return this._valid ? hslString(this._rgb) : undefined;
  }
  mix(color, weight) {
    if (color) {
      const c1 = this.rgb;
      const c2 = color.rgb;
      let w2;
      const p = weight === w2 ? 0.5 : weight;
      const w = 2 * p - 1;
      const a = c1.a - c2.a;
      const w1 = ((w * a === -1 ? w : (w + a) / (1 + w * a)) + 1) / 2.0;
      w2 = 1 - w1;
      c1.r = 0xFF & w1 * c1.r + w2 * c2.r + 0.5;
      c1.g = 0xFF & w1 * c1.g + w2 * c2.g + 0.5;
      c1.b = 0xFF & w1 * c1.b + w2 * c2.b + 0.5;
      c1.a = p * c1.a + (1 - p) * c2.a;
      this.rgb = c1;
    }
    return this;
  }
  interpolate(color, t) {
    if (color) {
      this._rgb = interpolate(this._rgb, color._rgb, t);
    }
    return this;
  }
  clone() {
    return new Color(this.rgb);
  }
  alpha(a) {
    this._rgb.a = n2b(a);
    return this;
  }
  clearer(ratio) {
    const rgb = this._rgb;
    rgb.a *= 1 - ratio;
    return this;
  }
  greyscale() {
    const rgb = this._rgb;
    const val = round(rgb.r * 0.3 + rgb.g * 0.59 + rgb.b * 0.11);
    rgb.r = rgb.g = rgb.b = val;
    return this;
  }
  opaquer(ratio) {
    const rgb = this._rgb;
    rgb.a *= 1 + ratio;
    return this;
  }
  negate() {
    const v = this._rgb;
    v.r = 255 - v.r;
    v.g = 255 - v.g;
    v.b = 255 - v.b;
    return this;
  }
  lighten(ratio) {
    modHSL(this._rgb, 2, ratio);
    return this;
  }
  darken(ratio) {
    modHSL(this._rgb, 2, -ratio);
    return this;
  }
  saturate(ratio) {
    modHSL(this._rgb, 1, ratio);
    return this;
  }
  desaturate(ratio) {
    modHSL(this._rgb, 1, -ratio);
    return this;
  }
  rotate(deg) {
    rotate(this._rgb, deg);
    return this;
  }
}
function index_esm(input) {
  return new Color(input);
}


/***/ }),

/***/ 3875:
/*!*******************************************************************************!*\
  !*** ./node_modules/.pnpm/chart.js@4.4.6/node_modules/chart.js/dist/chart.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Animation: () => (/* binding */ Animation),
/* harmony export */   Animations: () => (/* binding */ Animations),
/* harmony export */   ArcElement: () => (/* binding */ ArcElement),
/* harmony export */   BarController: () => (/* binding */ BarController),
/* harmony export */   BarElement: () => (/* binding */ BarElement),
/* harmony export */   BasePlatform: () => (/* binding */ BasePlatform),
/* harmony export */   BasicPlatform: () => (/* binding */ BasicPlatform),
/* harmony export */   BubbleController: () => (/* binding */ BubbleController),
/* harmony export */   CategoryScale: () => (/* binding */ CategoryScale),
/* harmony export */   Chart: () => (/* binding */ Chart),
/* harmony export */   Colors: () => (/* binding */ plugin_colors),
/* harmony export */   DatasetController: () => (/* binding */ DatasetController),
/* harmony export */   Decimation: () => (/* binding */ plugin_decimation),
/* harmony export */   DomPlatform: () => (/* binding */ DomPlatform),
/* harmony export */   DoughnutController: () => (/* binding */ DoughnutController),
/* harmony export */   Element: () => (/* binding */ Element),
/* harmony export */   Filler: () => (/* binding */ index),
/* harmony export */   Interaction: () => (/* binding */ Interaction),
/* harmony export */   Legend: () => (/* binding */ plugin_legend),
/* harmony export */   LineController: () => (/* binding */ LineController),
/* harmony export */   LineElement: () => (/* binding */ LineElement),
/* harmony export */   LinearScale: () => (/* binding */ LinearScale),
/* harmony export */   LogarithmicScale: () => (/* binding */ LogarithmicScale),
/* harmony export */   PieController: () => (/* binding */ PieController),
/* harmony export */   PointElement: () => (/* binding */ PointElement),
/* harmony export */   PolarAreaController: () => (/* binding */ PolarAreaController),
/* harmony export */   RadarController: () => (/* binding */ RadarController),
/* harmony export */   RadialLinearScale: () => (/* binding */ RadialLinearScale),
/* harmony export */   Scale: () => (/* binding */ Scale),
/* harmony export */   ScatterController: () => (/* binding */ ScatterController),
/* harmony export */   SubTitle: () => (/* binding */ plugin_subtitle),
/* harmony export */   Ticks: () => (/* reexport safe */ _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aL),
/* harmony export */   TimeScale: () => (/* binding */ TimeScale),
/* harmony export */   TimeSeriesScale: () => (/* binding */ TimeSeriesScale),
/* harmony export */   Title: () => (/* binding */ plugin_title),
/* harmony export */   Tooltip: () => (/* binding */ plugin_tooltip),
/* harmony export */   _adapters: () => (/* binding */ adapters),
/* harmony export */   _detectPlatform: () => (/* binding */ _detectPlatform),
/* harmony export */   animator: () => (/* binding */ animator),
/* harmony export */   controllers: () => (/* binding */ controllers),
/* harmony export */   defaults: () => (/* reexport safe */ _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d),
/* harmony export */   elements: () => (/* binding */ elements),
/* harmony export */   layouts: () => (/* binding */ layouts),
/* harmony export */   plugins: () => (/* binding */ plugins),
/* harmony export */   registerables: () => (/* binding */ registerables),
/* harmony export */   registry: () => (/* binding */ registry),
/* harmony export */   scales: () => (/* binding */ scales)
/* harmony export */ });
/* harmony import */ var _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/helpers.segment.js */ 3348);
/*!
 * Chart.js v4.4.6
 * https://www.chartjs.org
 * (c) 2024 Chart.js Contributors
 * Released under the MIT License
 */


class Animator {
  constructor() {
    this._request = null;
    this._charts = new Map();
    this._running = false;
    this._lastDate = undefined;
  }
  _notify(chart, anims, date, type) {
    const callbacks = anims.listeners[type];
    const numSteps = anims.duration;
    callbacks.forEach(fn => fn({
      chart,
      initial: anims.initial,
      numSteps,
      currentStep: Math.min(date - anims.start, numSteps)
    }));
  }
  _refresh() {
    if (this._request) {
      return;
    }
    this._running = true;
    this._request = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.r.call(window, () => {
      this._update();
      this._request = null;
      if (this._running) {
        this._refresh();
      }
    });
  }
  _update(date = Date.now()) {
    let remaining = 0;
    this._charts.forEach((anims, chart) => {
      if (!anims.running || !anims.items.length) {
        return;
      }
      const items = anims.items;
      let i = items.length - 1;
      let draw = false;
      let item;
      for (; i >= 0; --i) {
        item = items[i];
        if (item._active) {
          if (item._total > anims.duration) {
            anims.duration = item._total;
          }
          item.tick(date);
          draw = true;
        } else {
          items[i] = items[items.length - 1];
          items.pop();
        }
      }
      if (draw) {
        chart.draw();
        this._notify(chart, anims, date, 'progress');
      }
      if (!items.length) {
        anims.running = false;
        this._notify(chart, anims, date, 'complete');
        anims.initial = false;
      }
      remaining += items.length;
    });
    this._lastDate = date;
    if (remaining === 0) {
      this._running = false;
    }
  }
  _getAnims(chart) {
    const charts = this._charts;
    let anims = charts.get(chart);
    if (!anims) {
      anims = {
        running: false,
        initial: true,
        items: [],
        listeners: {
          complete: [],
          progress: []
        }
      };
      charts.set(chart, anims);
    }
    return anims;
  }
  listen(chart, event, cb) {
    this._getAnims(chart).listeners[event].push(cb);
  }
  add(chart, items) {
    if (!items || !items.length) {
      return;
    }
    this._getAnims(chart).items.push(...items);
  }
  has(chart) {
    return this._getAnims(chart).items.length > 0;
  }
  start(chart) {
    const anims = this._charts.get(chart);
    if (!anims) {
      return;
    }
    anims.running = true;
    anims.start = Date.now();
    anims.duration = anims.items.reduce((acc, cur) => Math.max(acc, cur._duration), 0);
    this._refresh();
  }
  running(chart) {
    if (!this._running) {
      return false;
    }
    const anims = this._charts.get(chart);
    if (!anims || !anims.running || !anims.items.length) {
      return false;
    }
    return true;
  }
  stop(chart) {
    const anims = this._charts.get(chart);
    if (!anims || !anims.items.length) {
      return;
    }
    const items = anims.items;
    let i = items.length - 1;
    for (; i >= 0; --i) {
      items[i].cancel();
    }
    anims.items = [];
    this._notify(chart, anims, Date.now(), 'complete');
  }
  remove(chart) {
    return this._charts.delete(chart);
  }
}
var animator = /* #__PURE__ */new Animator();
const transparent = 'transparent';
const interpolators = {
  boolean(from, to, factor) {
    return factor > 0.5 ? to : from;
  },
  color(from, to, factor) {
    const c0 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.c)(from || transparent);
    const c1 = c0.valid && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.c)(to || transparent);
    return c1 && c1.valid ? c1.mix(c0, factor).hexString() : to;
  },
  number(from, to, factor) {
    return from + (to - from) * factor;
  }
};
class Animation {
  constructor(cfg, target, prop, to) {
    const currentValue = target[prop];
    to = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.to, to, currentValue, cfg.from]);
    const from = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.from, currentValue, to]);
    this._active = true;
    this._fn = cfg.fn || interpolators[cfg.type || typeof from];
    this._easing = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.e[cfg.easing] || _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.e.linear;
    this._start = Math.floor(Date.now() + (cfg.delay || 0));
    this._duration = this._total = Math.floor(cfg.duration);
    this._loop = !!cfg.loop;
    this._target = target;
    this._prop = prop;
    this._from = from;
    this._to = to;
    this._promises = undefined;
  }
  active() {
    return this._active;
  }
  update(cfg, to, date) {
    if (this._active) {
      this._notify(false);
      const currentValue = this._target[this._prop];
      const elapsed = date - this._start;
      const remain = this._duration - elapsed;
      this._start = date;
      this._duration = Math.floor(Math.max(remain, cfg.duration));
      this._total += elapsed;
      this._loop = !!cfg.loop;
      this._to = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.to, to, currentValue, cfg.from]);
      this._from = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([cfg.from, currentValue, to]);
    }
  }
  cancel() {
    if (this._active) {
      this.tick(Date.now());
      this._active = false;
      this._notify(false);
    }
  }
  tick(date) {
    const elapsed = date - this._start;
    const duration = this._duration;
    const prop = this._prop;
    const from = this._from;
    const loop = this._loop;
    const to = this._to;
    let factor;
    this._active = from !== to && (loop || elapsed < duration);
    if (!this._active) {
      this._target[prop] = to;
      this._notify(true);
      return;
    }
    if (elapsed < 0) {
      this._target[prop] = from;
      return;
    }
    factor = elapsed / duration % 2;
    factor = loop && factor > 1 ? 2 - factor : factor;
    factor = this._easing(Math.min(1, Math.max(0, factor)));
    this._target[prop] = this._fn(from, to, factor);
  }
  wait() {
    const promises = this._promises || (this._promises = []);
    return new Promise((res, rej) => {
      promises.push({
        res,
        rej
      });
    });
  }
  _notify(resolved) {
    const method = resolved ? 'res' : 'rej';
    const promises = this._promises || [];
    for (let i = 0; i < promises.length; i++) {
      promises[i][method]();
    }
  }
}
class Animations {
  constructor(chart, config) {
    this._chart = chart;
    this._properties = new Map();
    this.configure(config);
  }
  configure(config) {
    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(config)) {
      return;
    }
    const animationOptions = Object.keys(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.animation);
    const animatedProps = this._properties;
    Object.getOwnPropertyNames(config).forEach(key => {
      const cfg = config[key];
      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(cfg)) {
        return;
      }
      const resolved = {};
      for (const option of animationOptions) {
        resolved[option] = cfg[option];
      }
      ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(cfg.properties) && cfg.properties || [key]).forEach(prop => {
        if (prop === key || !animatedProps.has(prop)) {
          animatedProps.set(prop, resolved);
        }
      });
    });
  }
  _animateOptions(target, values) {
    const newOptions = values.options;
    const options = resolveTargetOptions(target, newOptions);
    if (!options) {
      return [];
    }
    const animations = this._createAnimations(options, newOptions);
    if (newOptions.$shared) {
      awaitAll(target.options.$animations, newOptions).then(() => {
        target.options = newOptions;
      }, () => {});
    }
    return animations;
  }
  _createAnimations(target, values) {
    const animatedProps = this._properties;
    const animations = [];
    const running = target.$animations || (target.$animations = {});
    const props = Object.keys(values);
    const date = Date.now();
    let i;
    for (i = props.length - 1; i >= 0; --i) {
      const prop = props[i];
      if (prop.charAt(0) === '$') {
        continue;
      }
      if (prop === 'options') {
        animations.push(...this._animateOptions(target, values));
        continue;
      }
      const value = values[prop];
      let animation = running[prop];
      const cfg = animatedProps.get(prop);
      if (animation) {
        if (cfg && animation.active()) {
          animation.update(cfg, value, date);
          continue;
        } else {
          animation.cancel();
        }
      }
      if (!cfg || !cfg.duration) {
        target[prop] = value;
        continue;
      }
      running[prop] = animation = new Animation(cfg, target, prop, value);
      animations.push(animation);
    }
    return animations;
  }
  update(target, values) {
    if (this._properties.size === 0) {
      Object.assign(target, values);
      return;
    }
    const animations = this._createAnimations(target, values);
    if (animations.length) {
      animator.add(this._chart, animations);
      return true;
    }
  }
}
function awaitAll(animations, properties) {
  const running = [];
  const keys = Object.keys(properties);
  for (let i = 0; i < keys.length; i++) {
    const anim = animations[keys[i]];
    if (anim && anim.active()) {
      running.push(anim.wait());
    }
  }
  return Promise.all(running);
}
function resolveTargetOptions(target, newOptions) {
  if (!newOptions) {
    return;
  }
  let options = target.options;
  if (!options) {
    target.options = newOptions;
    return;
  }
  if (options.$shared) {
    target.options = options = Object.assign({}, options, {
      $shared: false,
      $animations: {}
    });
  }
  return options;
}
function scaleClip(scale, allowedOverflow) {
  const opts = scale && scale.options || {};
  const reverse = opts.reverse;
  const min = opts.min === undefined ? allowedOverflow : 0;
  const max = opts.max === undefined ? allowedOverflow : 0;
  return {
    start: reverse ? max : min,
    end: reverse ? min : max
  };
}
function defaultClip(xScale, yScale, allowedOverflow) {
  if (allowedOverflow === false) {
    return false;
  }
  const x = scaleClip(xScale, allowedOverflow);
  const y = scaleClip(yScale, allowedOverflow);
  return {
    top: y.end,
    right: x.end,
    bottom: y.start,
    left: x.start
  };
}
function toClip(value) {
  let t, r, b, l;
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(value)) {
    t = value.top;
    r = value.right;
    b = value.bottom;
    l = value.left;
  } else {
    t = r = b = l = value;
  }
  return {
    top: t,
    right: r,
    bottom: b,
    left: l,
    disabled: value === false
  };
}
function getSortedDatasetIndices(chart, filterVisible) {
  const keys = [];
  const metasets = chart._getSortedDatasetMetas(filterVisible);
  let i, ilen;
  for (i = 0, ilen = metasets.length; i < ilen; ++i) {
    keys.push(metasets[i].index);
  }
  return keys;
}
function applyStack(stack, value, dsIndex, options = {}) {
  const keys = stack.keys;
  const singleMode = options.mode === 'single';
  let i, ilen, datasetIndex, otherValue;
  if (value === null) {
    return;
  }
  let found = false;
  for (i = 0, ilen = keys.length; i < ilen; ++i) {
    datasetIndex = +keys[i];
    if (datasetIndex === dsIndex) {
      found = true;
      if (options.all) {
        continue;
      }
      break;
    }
    otherValue = stack.values[datasetIndex];
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(otherValue) && (singleMode || value === 0 || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(value) === (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(otherValue))) {
      value += otherValue;
    }
  }
  if (!found && !options.all) {
    return 0;
  }
  return value;
}
function convertObjectDataToArray(data, meta) {
  const {
    iScale,
    vScale
  } = meta;
  const iAxisKey = iScale.axis === 'x' ? 'x' : 'y';
  const vAxisKey = vScale.axis === 'x' ? 'x' : 'y';
  const keys = Object.keys(data);
  const adata = new Array(keys.length);
  let i, ilen, key;
  for (i = 0, ilen = keys.length; i < ilen; ++i) {
    key = keys[i];
    adata[i] = {
      [iAxisKey]: key,
      [vAxisKey]: data[key]
    };
  }
  return adata;
}
function isStacked(scale, meta) {
  const stacked = scale && scale.options.stacked;
  return stacked || stacked === undefined && meta.stack !== undefined;
}
function getStackKey(indexScale, valueScale, meta) {
  return `${indexScale.id}.${valueScale.id}.${meta.stack || meta.type}`;
}
function getUserBounds(scale) {
  const {
    min,
    max,
    minDefined,
    maxDefined
  } = scale.getUserBounds();
  return {
    min: minDefined ? min : Number.NEGATIVE_INFINITY,
    max: maxDefined ? max : Number.POSITIVE_INFINITY
  };
}
function getOrCreateStack(stacks, stackKey, indexValue) {
  const subStack = stacks[stackKey] || (stacks[stackKey] = {});
  return subStack[indexValue] || (subStack[indexValue] = {});
}
function getLastIndexInStack(stack, vScale, positive, type) {
  for (const meta of vScale.getMatchingVisibleMetas(type).reverse()) {
    const value = stack[meta.index];
    if (positive && value > 0 || !positive && value < 0) {
      return meta.index;
    }
  }
  return null;
}
function updateStacks(controller, parsed) {
  const {
    chart,
    _cachedMeta: meta
  } = controller;
  const stacks = chart._stacks || (chart._stacks = {});
  const {
    iScale,
    vScale,
    index: datasetIndex
  } = meta;
  const iAxis = iScale.axis;
  const vAxis = vScale.axis;
  const key = getStackKey(iScale, vScale, meta);
  const ilen = parsed.length;
  let stack;
  for (let i = 0; i < ilen; ++i) {
    const item = parsed[i];
    const {
      [iAxis]: index,
      [vAxis]: value
    } = item;
    const itemStacks = item._stacks || (item._stacks = {});
    stack = itemStacks[vAxis] = getOrCreateStack(stacks, key, index);
    stack[datasetIndex] = value;
    stack._top = getLastIndexInStack(stack, vScale, true, meta.type);
    stack._bottom = getLastIndexInStack(stack, vScale, false, meta.type);
    const visualValues = stack._visualValues || (stack._visualValues = {});
    visualValues[datasetIndex] = value;
  }
}
function getFirstScaleId(chart, axis) {
  const scales = chart.scales;
  return Object.keys(scales).filter(key => scales[key].axis === axis).shift();
}
function createDatasetContext(parent, index) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {
    active: false,
    dataset: undefined,
    datasetIndex: index,
    index,
    mode: 'default',
    type: 'dataset'
  });
}
function createDataContext(parent, index, element) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {
    active: false,
    dataIndex: index,
    parsed: undefined,
    raw: undefined,
    element,
    index,
    mode: 'default',
    type: 'data'
  });
}
function clearStacks(meta, items) {
  const datasetIndex = meta.controller.index;
  const axis = meta.vScale && meta.vScale.axis;
  if (!axis) {
    return;
  }
  items = items || meta._parsed;
  for (const parsed of items) {
    const stacks = parsed._stacks;
    if (!stacks || stacks[axis] === undefined || stacks[axis][datasetIndex] === undefined) {
      return;
    }
    delete stacks[axis][datasetIndex];
    if (stacks[axis]._visualValues !== undefined && stacks[axis]._visualValues[datasetIndex] !== undefined) {
      delete stacks[axis]._visualValues[datasetIndex];
    }
  }
}
const isDirectUpdateMode = mode => mode === 'reset' || mode === 'none';
const cloneIfNotShared = (cached, shared) => shared ? cached : Object.assign({}, cached);
const createStack = (canStack, meta, chart) => canStack && !meta.hidden && meta._stacked && {
  keys: getSortedDatasetIndices(chart, true),
  values: null
};
let DatasetController = /*#__PURE__*/(() => {
  class DatasetController {
    static defaults = {};
    static datasetElementType = null;
    static dataElementType = null;
    constructor(chart, datasetIndex) {
      this.chart = chart;
      this._ctx = chart.ctx;
      this.index = datasetIndex;
      this._cachedDataOpts = {};
      this._cachedMeta = this.getMeta();
      this._type = this._cachedMeta.type;
      this.options = undefined;
      this._parsing = false;
      this._data = undefined;
      this._objectData = undefined;
      this._sharedOptions = undefined;
      this._drawStart = undefined;
      this._drawCount = undefined;
      this.enableOptionSharing = false;
      this.supportsDecimation = false;
      this.$context = undefined;
      this._syncList = [];
      this.datasetElementType = new.target.datasetElementType;
      this.dataElementType = new.target.dataElementType;
      this.initialize();
    }
    initialize() {
      const meta = this._cachedMeta;
      this.configure();
      this.linkScales();
      meta._stacked = isStacked(meta.vScale, meta);
      this.addElements();
      if (this.options.fill && !this.chart.isPluginEnabled('filler')) {
        console.warn("Tried to use the 'fill' option without the 'Filler' plugin enabled. Please import and register the 'Filler' plugin and make sure it is not disabled in the options");
      }
    }
    updateIndex(datasetIndex) {
      if (this.index !== datasetIndex) {
        clearStacks(this._cachedMeta);
      }
      this.index = datasetIndex;
    }
    linkScales() {
      const chart = this.chart;
      const meta = this._cachedMeta;
      const dataset = this.getDataset();
      const chooseId = (axis, x, y, r) => axis === 'x' ? x : axis === 'r' ? r : y;
      const xid = meta.xAxisID = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.xAxisID, getFirstScaleId(chart, 'x'));
      const yid = meta.yAxisID = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.yAxisID, getFirstScaleId(chart, 'y'));
      const rid = meta.rAxisID = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(dataset.rAxisID, getFirstScaleId(chart, 'r'));
      const indexAxis = meta.indexAxis;
      const iid = meta.iAxisID = chooseId(indexAxis, xid, yid, rid);
      const vid = meta.vAxisID = chooseId(indexAxis, yid, xid, rid);
      meta.xScale = this.getScaleForId(xid);
      meta.yScale = this.getScaleForId(yid);
      meta.rScale = this.getScaleForId(rid);
      meta.iScale = this.getScaleForId(iid);
      meta.vScale = this.getScaleForId(vid);
    }
    getDataset() {
      return this.chart.data.datasets[this.index];
    }
    getMeta() {
      return this.chart.getDatasetMeta(this.index);
    }
    getScaleForId(scaleID) {
      return this.chart.scales[scaleID];
    }
    _getOtherScale(scale) {
      const meta = this._cachedMeta;
      return scale === meta.iScale ? meta.vScale : meta.iScale;
    }
    reset() {
      this._update('reset');
    }
    _destroy() {
      const meta = this._cachedMeta;
      if (this._data) {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.u)(this._data, this);
      }
      if (meta._stacked) {
        clearStacks(meta);
      }
    }
    _dataCheck() {
      const dataset = this.getDataset();
      const data = dataset.data || (dataset.data = []);
      const _data = this._data;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(data)) {
        const meta = this._cachedMeta;
        this._data = convertObjectDataToArray(data, meta);
      } else if (_data !== data) {
        if (_data) {
          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.u)(_data, this);
          const meta = this._cachedMeta;
          clearStacks(meta);
          meta._parsed = [];
        }
        if (data && Object.isExtensible(data)) {
          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.l)(data, this);
        }
        this._syncList = [];
        this._data = data;
      }
    }
    addElements() {
      const meta = this._cachedMeta;
      this._dataCheck();
      if (this.datasetElementType) {
        meta.dataset = new this.datasetElementType();
      }
    }
    buildOrUpdateElements(resetNewElements) {
      const meta = this._cachedMeta;
      const dataset = this.getDataset();
      let stackChanged = false;
      this._dataCheck();
      const oldStacked = meta._stacked;
      meta._stacked = isStacked(meta.vScale, meta);
      if (meta.stack !== dataset.stack) {
        stackChanged = true;
        clearStacks(meta);
        meta.stack = dataset.stack;
      }
      this._resyncElements(resetNewElements);
      if (stackChanged || oldStacked !== meta._stacked) {
        updateStacks(this, meta._parsed);
        meta._stacked = isStacked(meta.vScale, meta);
      }
    }
    configure() {
      const config = this.chart.config;
      const scopeKeys = config.datasetScopeKeys(this._type);
      const scopes = config.getOptionScopes(this.getDataset(), scopeKeys, true);
      this.options = config.createResolver(scopes, this.getContext());
      this._parsing = this.options.parsing;
      this._cachedDataOpts = {};
    }
    parse(start, count) {
      const {
        _cachedMeta: meta,
        _data: data
      } = this;
      const {
        iScale,
        _stacked
      } = meta;
      const iAxis = iScale.axis;
      let sorted = start === 0 && count === data.length ? true : meta._sorted;
      let prev = start > 0 && meta._parsed[start - 1];
      let i, cur, parsed;
      if (this._parsing === false) {
        meta._parsed = data;
        meta._sorted = true;
        parsed = data;
      } else {
        if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(data[start])) {
          parsed = this.parseArrayData(meta, data, start, count);
        } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(data[start])) {
          parsed = this.parseObjectData(meta, data, start, count);
        } else {
          parsed = this.parsePrimitiveData(meta, data, start, count);
        }
        const isNotInOrderComparedToPrev = () => cur[iAxis] === null || prev && cur[iAxis] < prev[iAxis];
        for (i = 0; i < count; ++i) {
          meta._parsed[i + start] = cur = parsed[i];
          if (sorted) {
            if (isNotInOrderComparedToPrev()) {
              sorted = false;
            }
            prev = cur;
          }
        }
        meta._sorted = sorted;
      }
      if (_stacked) {
        updateStacks(this, parsed);
      }
    }
    parsePrimitiveData(meta, data, start, count) {
      const {
        iScale,
        vScale
      } = meta;
      const iAxis = iScale.axis;
      const vAxis = vScale.axis;
      const labels = iScale.getLabels();
      const singleScale = iScale === vScale;
      const parsed = new Array(count);
      let i, ilen, index;
      for (i = 0, ilen = count; i < ilen; ++i) {
        index = i + start;
        parsed[i] = {
          [iAxis]: singleScale || iScale.parse(labels[index], index),
          [vAxis]: vScale.parse(data[index], index)
        };
      }
      return parsed;
    }
    parseArrayData(meta, data, start, count) {
      const {
        xScale,
        yScale
      } = meta;
      const parsed = new Array(count);
      let i, ilen, index, item;
      for (i = 0, ilen = count; i < ilen; ++i) {
        index = i + start;
        item = data[index];
        parsed[i] = {
          x: xScale.parse(item[0], index),
          y: yScale.parse(item[1], index)
        };
      }
      return parsed;
    }
    parseObjectData(meta, data, start, count) {
      const {
        xScale,
        yScale
      } = meta;
      const {
        xAxisKey = 'x',
        yAxisKey = 'y'
      } = this._parsing;
      const parsed = new Array(count);
      let i, ilen, index, item;
      for (i = 0, ilen = count; i < ilen; ++i) {
        index = i + start;
        item = data[index];
        parsed[i] = {
          x: xScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, xAxisKey), index),
          y: yScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(item, yAxisKey), index)
        };
      }
      return parsed;
    }
    getParsed(index) {
      return this._cachedMeta._parsed[index];
    }
    getDataElement(index) {
      return this._cachedMeta.data[index];
    }
    applyStack(scale, parsed, mode) {
      const chart = this.chart;
      const meta = this._cachedMeta;
      const value = parsed[scale.axis];
      const stack = {
        keys: getSortedDatasetIndices(chart, true),
        values: parsed._stacks[scale.axis]._visualValues
      };
      return applyStack(stack, value, meta.index, {
        mode
      });
    }
    updateRangeFromParsed(range, scale, parsed, stack) {
      const parsedValue = parsed[scale.axis];
      let value = parsedValue === null ? NaN : parsedValue;
      const values = stack && parsed._stacks[scale.axis];
      if (stack && values) {
        stack.values = values;
        value = applyStack(stack, parsedValue, this._cachedMeta.index);
      }
      range.min = Math.min(range.min, value);
      range.max = Math.max(range.max, value);
    }
    getMinMax(scale, canStack) {
      const meta = this._cachedMeta;
      const _parsed = meta._parsed;
      const sorted = meta._sorted && scale === meta.iScale;
      const ilen = _parsed.length;
      const otherScale = this._getOtherScale(scale);
      const stack = createStack(canStack, meta, this.chart);
      const range = {
        min: Number.POSITIVE_INFINITY,
        max: Number.NEGATIVE_INFINITY
      };
      const {
        min: otherMin,
        max: otherMax
      } = getUserBounds(otherScale);
      let i, parsed;
      function _skip() {
        parsed = _parsed[i];
        const otherValue = parsed[otherScale.axis];
        return !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(parsed[scale.axis]) || otherMin > otherValue || otherMax < otherValue;
      }
      for (i = 0; i < ilen; ++i) {
        if (_skip()) {
          continue;
        }
        this.updateRangeFromParsed(range, scale, parsed, stack);
        if (sorted) {
          break;
        }
      }
      if (sorted) {
        for (i = ilen - 1; i >= 0; --i) {
          if (_skip()) {
            continue;
          }
          this.updateRangeFromParsed(range, scale, parsed, stack);
          break;
        }
      }
      return range;
    }
    getAllParsedValues(scale) {
      const parsed = this._cachedMeta._parsed;
      const values = [];
      let i, ilen, value;
      for (i = 0, ilen = parsed.length; i < ilen; ++i) {
        value = parsed[i][scale.axis];
        if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value)) {
          values.push(value);
        }
      }
      return values;
    }
    getMaxOverflow() {
      return false;
    }
    getLabelAndValue(index) {
      const meta = this._cachedMeta;
      const iScale = meta.iScale;
      const vScale = meta.vScale;
      const parsed = this.getParsed(index);
      return {
        label: iScale ? '' + iScale.getLabelForValue(parsed[iScale.axis]) : '',
        value: vScale ? '' + vScale.getLabelForValue(parsed[vScale.axis]) : ''
      };
    }
    _update(mode) {
      const meta = this._cachedMeta;
      this.update(mode || 'default');
      meta._clip = toClip((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(this.options.clip, defaultClip(meta.xScale, meta.yScale, this.getMaxOverflow())));
    }
    update(mode) {}
    draw() {
      const ctx = this._ctx;
      const chart = this.chart;
      const meta = this._cachedMeta;
      const elements = meta.data || [];
      const area = chart.chartArea;
      const active = [];
      const start = this._drawStart || 0;
      const count = this._drawCount || elements.length - start;
      const drawActiveElementsOnTop = this.options.drawActiveElementsOnTop;
      let i;
      if (meta.dataset) {
        meta.dataset.draw(ctx, area, start, count);
      }
      for (i = start; i < start + count; ++i) {
        const element = elements[i];
        if (element.hidden) {
          continue;
        }
        if (element.active && drawActiveElementsOnTop) {
          active.push(element);
        } else {
          element.draw(ctx, area);
        }
      }
      for (i = 0; i < active.length; ++i) {
        active[i].draw(ctx, area);
      }
    }
    getStyle(index, active) {
      const mode = active ? 'active' : 'default';
      return index === undefined && this._cachedMeta.dataset ? this.resolveDatasetElementOptions(mode) : this.resolveDataElementOptions(index || 0, mode);
    }
    getContext(index, active, mode) {
      const dataset = this.getDataset();
      let context;
      if (index >= 0 && index < this._cachedMeta.data.length) {
        const element = this._cachedMeta.data[index];
        context = element.$context || (element.$context = createDataContext(this.getContext(), index, element));
        context.parsed = this.getParsed(index);
        context.raw = dataset.data[index];
        context.index = context.dataIndex = index;
      } else {
        context = this.$context || (this.$context = createDatasetContext(this.chart.getContext(), this.index));
        context.dataset = dataset;
        context.index = context.datasetIndex = this.index;
      }
      context.active = !!active;
      context.mode = mode;
      return context;
    }
    resolveDatasetElementOptions(mode) {
      return this._resolveElementOptions(this.datasetElementType.id, mode);
    }
    resolveDataElementOptions(index, mode) {
      return this._resolveElementOptions(this.dataElementType.id, mode, index);
    }
    _resolveElementOptions(elementType, mode = 'default', index) {
      const active = mode === 'active';
      const cache = this._cachedDataOpts;
      const cacheKey = elementType + '-' + mode;
      const cached = cache[cacheKey];
      const sharing = this.enableOptionSharing && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(index);
      if (cached) {
        return cloneIfNotShared(cached, sharing);
      }
      const config = this.chart.config;
      const scopeKeys = config.datasetElementScopeKeys(this._type, elementType);
      const prefixes = active ? [`${elementType}Hover`, 'hover', elementType, ''] : [elementType, ''];
      const scopes = config.getOptionScopes(this.getDataset(), scopeKeys);
      const names = Object.keys(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.elements[elementType]);
      const context = () => this.getContext(index, active, mode);
      const values = config.resolveNamedOptions(scopes, names, context, prefixes);
      if (values.$shared) {
        values.$shared = sharing;
        cache[cacheKey] = Object.freeze(cloneIfNotShared(values, sharing));
      }
      return values;
    }
    _resolveAnimations(index, transition, active) {
      const chart = this.chart;
      const cache = this._cachedDataOpts;
      const cacheKey = `animation-${transition}`;
      const cached = cache[cacheKey];
      if (cached) {
        return cached;
      }
      let options;
      if (chart.options.animation !== false) {
        const config = this.chart.config;
        const scopeKeys = config.datasetAnimationScopeKeys(this._type, transition);
        const scopes = config.getOptionScopes(this.getDataset(), scopeKeys);
        options = config.createResolver(scopes, this.getContext(index, active, transition));
      }
      const animations = new Animations(chart, options && options.animations);
      if (options && options._cacheable) {
        cache[cacheKey] = Object.freeze(animations);
      }
      return animations;
    }
    getSharedOptions(options) {
      if (!options.$shared) {
        return;
      }
      return this._sharedOptions || (this._sharedOptions = Object.assign({}, options));
    }
    includeOptions(mode, sharedOptions) {
      return !sharedOptions || isDirectUpdateMode(mode) || this.chart._animationsDisabled;
    }
    _getSharedOptions(start, mode) {
      const firstOpts = this.resolveDataElementOptions(start, mode);
      const previouslySharedOptions = this._sharedOptions;
      const sharedOptions = this.getSharedOptions(firstOpts);
      const includeOptions = this.includeOptions(mode, sharedOptions) || sharedOptions !== previouslySharedOptions;
      this.updateSharedOptions(sharedOptions, mode, firstOpts);
      return {
        sharedOptions,
        includeOptions
      };
    }
    updateElement(element, index, properties, mode) {
      if (isDirectUpdateMode(mode)) {
        Object.assign(element, properties);
      } else {
        this._resolveAnimations(index, mode).update(element, properties);
      }
    }
    updateSharedOptions(sharedOptions, mode, newOptions) {
      if (sharedOptions && !isDirectUpdateMode(mode)) {
        this._resolveAnimations(undefined, mode).update(sharedOptions, newOptions);
      }
    }
    _setStyle(element, index, mode, active) {
      element.active = active;
      const options = this.getStyle(index, active);
      this._resolveAnimations(index, mode, active).update(element, {
        options: !active && this.getSharedOptions(options) || options
      });
    }
    removeHoverStyle(element, datasetIndex, index) {
      this._setStyle(element, index, 'active', false);
    }
    setHoverStyle(element, datasetIndex, index) {
      this._setStyle(element, index, 'active', true);
    }
    _removeDatasetHoverStyle() {
      const element = this._cachedMeta.dataset;
      if (element) {
        this._setStyle(element, undefined, 'active', false);
      }
    }
    _setDatasetHoverStyle() {
      const element = this._cachedMeta.dataset;
      if (element) {
        this._setStyle(element, undefined, 'active', true);
      }
    }
    _resyncElements(resetNewElements) {
      const data = this._data;
      const elements = this._cachedMeta.data;
      for (const [method, arg1, arg2] of this._syncList) {
        this[method](arg1, arg2);
      }
      this._syncList = [];
      const numMeta = elements.length;
      const numData = data.length;
      const count = Math.min(numData, numMeta);
      if (count) {
        this.parse(0, count);
      }
      if (numData > numMeta) {
        this._insertElements(numMeta, numData - numMeta, resetNewElements);
      } else if (numData < numMeta) {
        this._removeElements(numData, numMeta - numData);
      }
    }
    _insertElements(start, count, resetNewElements = true) {
      const meta = this._cachedMeta;
      const data = meta.data;
      const end = start + count;
      let i;
      const move = arr => {
        arr.length += count;
        for (i = arr.length - 1; i >= end; i--) {
          arr[i] = arr[i - count];
        }
      };
      move(data);
      for (i = start; i < end; ++i) {
        data[i] = new this.dataElementType();
      }
      if (this._parsing) {
        move(meta._parsed);
      }
      this.parse(start, count);
      if (resetNewElements) {
        this.updateElements(data, start, count, 'reset');
      }
    }
    updateElements(element, start, count, mode) {}
    _removeElements(start, count) {
      const meta = this._cachedMeta;
      if (this._parsing) {
        const removed = meta._parsed.splice(start, count);
        if (meta._stacked) {
          clearStacks(meta, removed);
        }
      }
      meta.data.splice(start, count);
    }
    _sync(args) {
      if (this._parsing) {
        this._syncList.push(args);
      } else {
        const [method, arg1, arg2] = args;
        this[method](arg1, arg2);
      }
      this.chart._dataChanges.push([this.index, ...args]);
    }
    _onDataPush() {
      const count = arguments.length;
      this._sync(['_insertElements', this.getDataset().data.length - count, count]);
    }
    _onDataPop() {
      this._sync(['_removeElements', this._cachedMeta.data.length - 1, 1]);
    }
    _onDataShift() {
      this._sync(['_removeElements', 0, 1]);
    }
    _onDataSplice(start, count) {
      if (count) {
        this._sync(['_removeElements', start, count]);
      }
      const newCount = arguments.length - 2;
      if (newCount) {
        this._sync(['_insertElements', start, newCount]);
      }
    }
    _onDataUnshift() {
      this._sync(['_insertElements', 0, arguments.length]);
    }
  }
  return DatasetController;
})();
function getAllScaleValues(scale, type) {
  if (!scale._cache.$bar) {
    const visibleMetas = scale.getMatchingVisibleMetas(type);
    let values = [];
    for (let i = 0, ilen = visibleMetas.length; i < ilen; i++) {
      values = values.concat(visibleMetas[i].controller.getAllParsedValues(scale));
    }
    scale._cache.$bar = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__._)(values.sort((a, b) => a - b));
  }
  return scale._cache.$bar;
}
function computeMinSampleSize(meta) {
  const scale = meta.iScale;
  const values = getAllScaleValues(scale, meta.type);
  let min = scale._length;
  let i, ilen, curr, prev;
  const updateMinAndPrev = () => {
    if (curr === 32767 || curr === -32768) {
      return;
    }
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(prev)) {
      min = Math.min(min, Math.abs(curr - prev) || min);
    }
    prev = curr;
  };
  for (i = 0, ilen = values.length; i < ilen; ++i) {
    curr = scale.getPixelForValue(values[i]);
    updateMinAndPrev();
  }
  prev = undefined;
  for (i = 0, ilen = scale.ticks.length; i < ilen; ++i) {
    curr = scale.getPixelForTick(i);
    updateMinAndPrev();
  }
  return min;
}
function computeFitCategoryTraits(index, ruler, options, stackCount) {
  const thickness = options.barThickness;
  let size, ratio;
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(thickness)) {
    size = ruler.min * options.categoryPercentage;
    ratio = options.barPercentage;
  } else {
    size = thickness * stackCount;
    ratio = 1;
  }
  return {
    chunk: size / stackCount,
    ratio,
    start: ruler.pixels[index] - size / 2
  };
}
function computeFlexCategoryTraits(index, ruler, options, stackCount) {
  const pixels = ruler.pixels;
  const curr = pixels[index];
  let prev = index > 0 ? pixels[index - 1] : null;
  let next = index < pixels.length - 1 ? pixels[index + 1] : null;
  const percent = options.categoryPercentage;
  if (prev === null) {
    prev = curr - (next === null ? ruler.end - ruler.start : next - curr);
  }
  if (next === null) {
    next = curr + curr - prev;
  }
  const start = curr - (curr - Math.min(prev, next)) / 2 * percent;
  const size = Math.abs(next - prev) / 2 * percent;
  return {
    chunk: size / stackCount,
    ratio: options.barPercentage,
    start
  };
}
function parseFloatBar(entry, item, vScale, i) {
  const startValue = vScale.parse(entry[0], i);
  const endValue = vScale.parse(entry[1], i);
  const min = Math.min(startValue, endValue);
  const max = Math.max(startValue, endValue);
  let barStart = min;
  let barEnd = max;
  if (Math.abs(min) > Math.abs(max)) {
    barStart = max;
    barEnd = min;
  }
  item[vScale.axis] = barEnd;
  item._custom = {
    barStart,
    barEnd,
    start: startValue,
    end: endValue,
    min,
    max
  };
}
function parseValue(entry, item, vScale, i) {
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(entry)) {
    parseFloatBar(entry, item, vScale, i);
  } else {
    item[vScale.axis] = vScale.parse(entry, i);
  }
  return item;
}
function parseArrayOrPrimitive(meta, data, start, count) {
  const iScale = meta.iScale;
  const vScale = meta.vScale;
  const labels = iScale.getLabels();
  const singleScale = iScale === vScale;
  const parsed = [];
  let i, ilen, item, entry;
  for (i = start, ilen = start + count; i < ilen; ++i) {
    entry = data[i];
    item = {};
    item[iScale.axis] = singleScale || iScale.parse(labels[i], i);
    parsed.push(parseValue(entry, item, vScale, i));
  }
  return parsed;
}
function isFloatBar(custom) {
  return custom && custom.barStart !== undefined && custom.barEnd !== undefined;
}
function barSign(size, vScale, actualBase) {
  if (size !== 0) {
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(size);
  }
  return (vScale.isHorizontal() ? 1 : -1) * (vScale.min >= actualBase ? 1 : -1);
}
function borderProps(properties) {
  let reverse, start, end, top, bottom;
  if (properties.horizontal) {
    reverse = properties.base > properties.x;
    start = 'left';
    end = 'right';
  } else {
    reverse = properties.base < properties.y;
    start = 'bottom';
    end = 'top';
  }
  if (reverse) {
    top = 'end';
    bottom = 'start';
  } else {
    top = 'start';
    bottom = 'end';
  }
  return {
    start,
    end,
    reverse,
    top,
    bottom
  };
}
function setBorderSkipped(properties, options, stack, index) {
  let edge = options.borderSkipped;
  const res = {};
  if (!edge) {
    properties.borderSkipped = res;
    return;
  }
  if (edge === true) {
    properties.borderSkipped = {
      top: true,
      right: true,
      bottom: true,
      left: true
    };
    return;
  }
  const {
    start,
    end,
    reverse,
    top,
    bottom
  } = borderProps(properties);
  if (edge === 'middle' && stack) {
    properties.enableBorderRadius = true;
    if ((stack._top || 0) === index) {
      edge = top;
    } else if ((stack._bottom || 0) === index) {
      edge = bottom;
    } else {
      res[parseEdge(bottom, start, end, reverse)] = true;
      edge = top;
    }
  }
  res[parseEdge(edge, start, end, reverse)] = true;
  properties.borderSkipped = res;
}
function parseEdge(edge, a, b, reverse) {
  if (reverse) {
    edge = swap(edge, a, b);
    edge = startEnd(edge, b, a);
  } else {
    edge = startEnd(edge, a, b);
  }
  return edge;
}
function swap(orig, v1, v2) {
  return orig === v1 ? v2 : orig === v2 ? v1 : orig;
}
function startEnd(v, start, end) {
  return v === 'start' ? start : v === 'end' ? end : v;
}
function setInflateAmount(properties, {
  inflateAmount
}, ratio) {
  properties.inflateAmount = inflateAmount === 'auto' ? ratio === 1 ? 0.33 : 0 : inflateAmount;
}
let BarController = /*#__PURE__*/(() => {
  class BarController extends DatasetController {
    static id = 'bar';
    static defaults = {
      datasetElementType: false,
      dataElementType: 'bar',
      categoryPercentage: 0.8,
      barPercentage: 0.9,
      grouped: true,
      animations: {
        numbers: {
          type: 'number',
          properties: ['x', 'y', 'base', 'width', 'height']
        }
      }
    };
    static overrides = {
      scales: {
        _index_: {
          type: 'category',
          offset: true,
          grid: {
            offset: true
          }
        },
        _value_: {
          type: 'linear',
          beginAtZero: true
        }
      }
    };
    parsePrimitiveData(meta, data, start, count) {
      return parseArrayOrPrimitive(meta, data, start, count);
    }
    parseArrayData(meta, data, start, count) {
      return parseArrayOrPrimitive(meta, data, start, count);
    }
    parseObjectData(meta, data, start, count) {
      const {
        iScale,
        vScale
      } = meta;
      const {
        xAxisKey = 'x',
        yAxisKey = 'y'
      } = this._parsing;
      const iAxisKey = iScale.axis === 'x' ? xAxisKey : yAxisKey;
      const vAxisKey = vScale.axis === 'x' ? xAxisKey : yAxisKey;
      const parsed = [];
      let i, ilen, item, obj;
      for (i = start, ilen = start + count; i < ilen; ++i) {
        obj = data[i];
        item = {};
        item[iScale.axis] = iScale.parse((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, iAxisKey), i);
        parsed.push(parseValue((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, vAxisKey), item, vScale, i));
      }
      return parsed;
    }
    updateRangeFromParsed(range, scale, parsed, stack) {
      super.updateRangeFromParsed(range, scale, parsed, stack);
      const custom = parsed._custom;
      if (custom && scale === this._cachedMeta.vScale) {
        range.min = Math.min(range.min, custom.min);
        range.max = Math.max(range.max, custom.max);
      }
    }
    getMaxOverflow() {
      return 0;
    }
    getLabelAndValue(index) {
      const meta = this._cachedMeta;
      const {
        iScale,
        vScale
      } = meta;
      const parsed = this.getParsed(index);
      const custom = parsed._custom;
      const value = isFloatBar(custom) ? '[' + custom.start + ', ' + custom.end + ']' : '' + vScale.getLabelForValue(parsed[vScale.axis]);
      return {
        label: '' + iScale.getLabelForValue(parsed[iScale.axis]),
        value
      };
    }
    initialize() {
      this.enableOptionSharing = true;
      super.initialize();
      const meta = this._cachedMeta;
      meta.stack = this.getDataset().stack;
    }
    update(mode) {
      const meta = this._cachedMeta;
      this.updateElements(meta.data, 0, meta.data.length, mode);
    }
    updateElements(bars, start, count, mode) {
      const reset = mode === 'reset';
      const {
        index,
        _cachedMeta: {
          vScale
        }
      } = this;
      const base = vScale.getBasePixel();
      const horizontal = vScale.isHorizontal();
      const ruler = this._getRuler();
      const {
        sharedOptions,
        includeOptions
      } = this._getSharedOptions(start, mode);
      for (let i = start; i < start + count; i++) {
        const parsed = this.getParsed(i);
        const vpixels = reset || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(parsed[vScale.axis]) ? {
          base,
          head: base
        } : this._calculateBarValuePixels(i);
        const ipixels = this._calculateBarIndexPixels(i, ruler);
        const stack = (parsed._stacks || {})[vScale.axis];
        const properties = {
          horizontal,
          base: vpixels.base,
          enableBorderRadius: !stack || isFloatBar(parsed._custom) || index === stack._top || index === stack._bottom,
          x: horizontal ? vpixels.head : ipixels.center,
          y: horizontal ? ipixels.center : vpixels.head,
          height: horizontal ? ipixels.size : Math.abs(vpixels.size),
          width: horizontal ? Math.abs(vpixels.size) : ipixels.size
        };
        if (includeOptions) {
          properties.options = sharedOptions || this.resolveDataElementOptions(i, bars[i].active ? 'active' : mode);
        }
        const options = properties.options || bars[i].options;
        setBorderSkipped(properties, options, stack, index);
        setInflateAmount(properties, options, ruler.ratio);
        this.updateElement(bars[i], i, properties, mode);
      }
    }
    _getStacks(last, dataIndex) {
      const {
        iScale
      } = this._cachedMeta;
      const metasets = iScale.getMatchingVisibleMetas(this._type).filter(meta => meta.controller.options.grouped);
      const stacked = iScale.options.stacked;
      const stacks = [];
      const currentParsed = this._cachedMeta.controller.getParsed(dataIndex);
      const iScaleValue = currentParsed && currentParsed[iScale.axis];
      const skipNull = meta => {
        const parsed = meta._parsed.find(item => item[iScale.axis] === iScaleValue);
        const val = parsed && parsed[meta.vScale.axis];
        if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(val) || isNaN(val)) {
          return true;
        }
      };
      for (const meta of metasets) {
        if (dataIndex !== undefined && skipNull(meta)) {
          continue;
        }
        if (stacked === false || stacks.indexOf(meta.stack) === -1 || stacked === undefined && meta.stack === undefined) {
          stacks.push(meta.stack);
        }
        if (meta.index === last) {
          break;
        }
      }
      if (!stacks.length) {
        stacks.push(undefined);
      }
      return stacks;
    }
    _getStackCount(index) {
      return this._getStacks(undefined, index).length;
    }
    _getStackIndex(datasetIndex, name, dataIndex) {
      const stacks = this._getStacks(datasetIndex, dataIndex);
      const index = name !== undefined ? stacks.indexOf(name) : -1;
      return index === -1 ? stacks.length - 1 : index;
    }
    _getRuler() {
      const opts = this.options;
      const meta = this._cachedMeta;
      const iScale = meta.iScale;
      const pixels = [];
      let i, ilen;
      for (i = 0, ilen = meta.data.length; i < ilen; ++i) {
        pixels.push(iScale.getPixelForValue(this.getParsed(i)[iScale.axis], i));
      }
      const barThickness = opts.barThickness;
      const min = barThickness || computeMinSampleSize(meta);
      return {
        min,
        pixels,
        start: iScale._startPixel,
        end: iScale._endPixel,
        stackCount: this._getStackCount(),
        scale: iScale,
        grouped: opts.grouped,
        ratio: barThickness ? 1 : opts.categoryPercentage * opts.barPercentage
      };
    }
    _calculateBarValuePixels(index) {
      const {
        _cachedMeta: {
          vScale,
          _stacked,
          index: datasetIndex
        },
        options: {
          base: baseValue,
          minBarLength
        }
      } = this;
      const actualBase = baseValue || 0;
      const parsed = this.getParsed(index);
      const custom = parsed._custom;
      const floating = isFloatBar(custom);
      let value = parsed[vScale.axis];
      let start = 0;
      let length = _stacked ? this.applyStack(vScale, parsed, _stacked) : value;
      let head, size;
      if (length !== value) {
        start = length - value;
        length = value;
      }
      if (floating) {
        value = custom.barStart;
        length = custom.barEnd - custom.barStart;
        if (value !== 0 && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(value) !== (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(custom.barEnd)) {
          start = 0;
        }
        start += value;
      }
      const startValue = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(baseValue) && !floating ? baseValue : start;
      let base = vScale.getPixelForValue(startValue);
      if (this.chart.getDataVisibility(index)) {
        head = vScale.getPixelForValue(start + length);
      } else {
        head = base;
      }
      size = head - base;
      if (Math.abs(size) < minBarLength) {
        size = barSign(size, vScale, actualBase) * minBarLength;
        if (value === actualBase) {
          base -= size / 2;
        }
        const startPixel = vScale.getPixelForDecimal(0);
        const endPixel = vScale.getPixelForDecimal(1);
        const min = Math.min(startPixel, endPixel);
        const max = Math.max(startPixel, endPixel);
        base = Math.max(Math.min(base, max), min);
        head = base + size;
        if (_stacked && !floating) {
          parsed._stacks[vScale.axis]._visualValues[datasetIndex] = vScale.getValueForPixel(head) - vScale.getValueForPixel(base);
        }
      }
      if (base === vScale.getPixelForValue(actualBase)) {
        const halfGrid = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(size) * vScale.getLineWidthForValue(actualBase) / 2;
        base += halfGrid;
        size -= halfGrid;
      }
      return {
        size,
        base,
        head,
        center: head + size / 2
      };
    }
    _calculateBarIndexPixels(index, ruler) {
      const scale = ruler.scale;
      const options = this.options;
      const skipNull = options.skipNull;
      const maxBarThickness = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.maxBarThickness, Infinity);
      let center, size;
      if (ruler.grouped) {
        const stackCount = skipNull ? this._getStackCount(index) : ruler.stackCount;
        const range = options.barThickness === 'flex' ? computeFlexCategoryTraits(index, ruler, options, stackCount) : computeFitCategoryTraits(index, ruler, options, stackCount);
        const stackIndex = this._getStackIndex(this.index, this._cachedMeta.stack, skipNull ? index : undefined);
        center = range.start + range.chunk * stackIndex + range.chunk / 2;
        size = Math.min(maxBarThickness, range.chunk * range.ratio);
      } else {
        center = scale.getPixelForValue(this.getParsed(index)[scale.axis], index);
        size = Math.min(maxBarThickness, ruler.min * ruler.ratio);
      }
      return {
        base: center - size / 2,
        head: center + size / 2,
        center,
        size
      };
    }
    draw() {
      const meta = this._cachedMeta;
      const vScale = meta.vScale;
      const rects = meta.data;
      const ilen = rects.length;
      let i = 0;
      for (; i < ilen; ++i) {
        if (this.getParsed(i)[vScale.axis] !== null && !rects[i].hidden) {
          rects[i].draw(this._ctx);
        }
      }
    }
  }
  return BarController;
})();
let BubbleController = /*#__PURE__*/(() => {
  class BubbleController extends DatasetController {
    static id = 'bubble';
    static defaults = {
      datasetElementType: false,
      dataElementType: 'point',
      animations: {
        numbers: {
          type: 'number',
          properties: ['x', 'y', 'borderWidth', 'radius']
        }
      }
    };
    static overrides = {
      scales: {
        x: {
          type: 'linear'
        },
        y: {
          type: 'linear'
        }
      }
    };
    initialize() {
      this.enableOptionSharing = true;
      super.initialize();
    }
    parsePrimitiveData(meta, data, start, count) {
      const parsed = super.parsePrimitiveData(meta, data, start, count);
      for (let i = 0; i < parsed.length; i++) {
        parsed[i]._custom = this.resolveDataElementOptions(i + start).radius;
      }
      return parsed;
    }
    parseArrayData(meta, data, start, count) {
      const parsed = super.parseArrayData(meta, data, start, count);
      for (let i = 0; i < parsed.length; i++) {
        const item = data[start + i];
        parsed[i]._custom = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(item[2], this.resolveDataElementOptions(i + start).radius);
      }
      return parsed;
    }
    parseObjectData(meta, data, start, count) {
      const parsed = super.parseObjectData(meta, data, start, count);
      for (let i = 0; i < parsed.length; i++) {
        const item = data[start + i];
        parsed[i]._custom = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(item && item.r && +item.r, this.resolveDataElementOptions(i + start).radius);
      }
      return parsed;
    }
    getMaxOverflow() {
      const data = this._cachedMeta.data;
      let max = 0;
      for (let i = data.length - 1; i >= 0; --i) {
        max = Math.max(max, data[i].size(this.resolveDataElementOptions(i)) / 2);
      }
      return max > 0 && max;
    }
    getLabelAndValue(index) {
      const meta = this._cachedMeta;
      const labels = this.chart.data.labels || [];
      const {
        xScale,
        yScale
      } = meta;
      const parsed = this.getParsed(index);
      const x = xScale.getLabelForValue(parsed.x);
      const y = yScale.getLabelForValue(parsed.y);
      const r = parsed._custom;
      return {
        label: labels[index] || '',
        value: '(' + x + ', ' + y + (r ? ', ' + r : '') + ')'
      };
    }
    update(mode) {
      const points = this._cachedMeta.data;
      this.updateElements(points, 0, points.length, mode);
    }
    updateElements(points, start, count, mode) {
      const reset = mode === 'reset';
      const {
        iScale,
        vScale
      } = this._cachedMeta;
      const {
        sharedOptions,
        includeOptions
      } = this._getSharedOptions(start, mode);
      const iAxis = iScale.axis;
      const vAxis = vScale.axis;
      for (let i = start; i < start + count; i++) {
        const point = points[i];
        const parsed = !reset && this.getParsed(i);
        const properties = {};
        const iPixel = properties[iAxis] = reset ? iScale.getPixelForDecimal(0.5) : iScale.getPixelForValue(parsed[iAxis]);
        const vPixel = properties[vAxis] = reset ? vScale.getBasePixel() : vScale.getPixelForValue(parsed[vAxis]);
        properties.skip = isNaN(iPixel) || isNaN(vPixel);
        if (includeOptions) {
          properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? 'active' : mode);
          if (reset) {
            properties.options.radius = 0;
          }
        }
        this.updateElement(point, i, properties, mode);
      }
    }
    resolveDataElementOptions(index, mode) {
      const parsed = this.getParsed(index);
      let values = super.resolveDataElementOptions(index, mode);
      if (values.$shared) {
        values = Object.assign({}, values, {
          $shared: false
        });
      }
      const radius = values.radius;
      if (mode !== 'active') {
        values.radius = 0;
      }
      values.radius += (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(parsed && parsed._custom, radius);
      return values;
    }
  }
  return BubbleController;
})();
function getRatioAndOffset(rotation, circumference, cutout) {
  let ratioX = 1;
  let ratioY = 1;
  let offsetX = 0;
  let offsetY = 0;
  if (circumference < _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T) {
    const startAngle = rotation;
    const endAngle = startAngle + circumference;
    const startX = Math.cos(startAngle);
    const startY = Math.sin(startAngle);
    const endX = Math.cos(endAngle);
    const endY = Math.sin(endAngle);
    const calcMax = (angle, a, b) => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle, true) ? 1 : Math.max(a, a * cutout, b, b * cutout);
    const calcMin = (angle, a, b) => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle, true) ? -1 : Math.min(a, a * cutout, b, b * cutout);
    const maxX = calcMax(0, startX, endX);
    const maxY = calcMax(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, startY, endY);
    const minX = calcMin(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P, startX, endX);
    const minY = calcMin(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, startY, endY);
    ratioX = (maxX - minX) / 2;
    ratioY = (maxY - minY) / 2;
    offsetX = -(maxX + minX) / 2;
    offsetY = -(maxY + minY) / 2;
  }
  return {
    ratioX,
    ratioY,
    offsetX,
    offsetY
  };
}
let DoughnutController = /*#__PURE__*/(() => {
  class DoughnutController extends DatasetController {
    static id = 'doughnut';
    static defaults = {
      datasetElementType: false,
      dataElementType: 'arc',
      animation: {
        animateRotate: true,
        animateScale: false
      },
      animations: {
        numbers: {
          type: 'number',
          properties: ['circumference', 'endAngle', 'innerRadius', 'outerRadius', 'startAngle', 'x', 'y', 'offset', 'borderWidth', 'spacing']
        }
      },
      cutout: '50%',
      rotation: 0,
      circumference: 360,
      radius: '100%',
      spacing: 0,
      indexAxis: 'r'
    };
    static descriptors = {
      _scriptable: name => name !== 'spacing',
      _indexable: name => name !== 'spacing' && !name.startsWith('borderDash') && !name.startsWith('hoverBorderDash')
    };
    static overrides = {
      aspectRatio: 1,
      plugins: {
        legend: {
          labels: {
            generateLabels(chart) {
              const data = chart.data;
              if (data.labels.length && data.datasets.length) {
                const {
                  labels: {
                    pointStyle,
                    color
                  }
                } = chart.legend.options;
                return data.labels.map((label, i) => {
                  const meta = chart.getDatasetMeta(0);
                  const style = meta.controller.getStyle(i);
                  return {
                    text: label,
                    fillStyle: style.backgroundColor,
                    strokeStyle: style.borderColor,
                    fontColor: color,
                    lineWidth: style.borderWidth,
                    pointStyle: pointStyle,
                    hidden: !chart.getDataVisibility(i),
                    index: i
                  };
                });
              }
              return [];
            }
          },
          onClick(e, legendItem, legend) {
            legend.chart.toggleDataVisibility(legendItem.index);
            legend.chart.update();
          }
        }
      }
    };
    constructor(chart, datasetIndex) {
      super(chart, datasetIndex);
      this.enableOptionSharing = true;
      this.innerRadius = undefined;
      this.outerRadius = undefined;
      this.offsetX = undefined;
      this.offsetY = undefined;
    }
    linkScales() {}
    parse(start, count) {
      const data = this.getDataset().data;
      const meta = this._cachedMeta;
      if (this._parsing === false) {
        meta._parsed = data;
      } else {
        let getter = i => +data[i];
        if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(data[start])) {
          const {
            key = 'value'
          } = this._parsing;
          getter = i => +(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(data[i], key);
        }
        let i, ilen;
        for (i = start, ilen = start + count; i < ilen; ++i) {
          meta._parsed[i] = getter(i);
        }
      }
    }
    _getRotation() {
      return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.rotation - 90);
    }
    _getCircumference() {
      return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.circumference);
    }
    _getRotationExtents() {
      let min = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T;
      let max = -_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T;
      for (let i = 0; i < this.chart.data.datasets.length; ++i) {
        if (this.chart.isDatasetVisible(i) && this.chart.getDatasetMeta(i).type === this._type) {
          const controller = this.chart.getDatasetMeta(i).controller;
          const rotation = controller._getRotation();
          const circumference = controller._getCircumference();
          min = Math.min(min, rotation);
          max = Math.max(max, rotation + circumference);
        }
      }
      return {
        rotation: min,
        circumference: max - min
      };
    }
    update(mode) {
      const chart = this.chart;
      const {
        chartArea
      } = chart;
      const meta = this._cachedMeta;
      const arcs = meta.data;
      const spacing = this.getMaxBorderWidth() + this.getMaxOffset(arcs) + this.options.spacing;
      const maxSize = Math.max((Math.min(chartArea.width, chartArea.height) - spacing) / 2, 0);
      const cutout = Math.min((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.m)(this.options.cutout, maxSize), 1);
      const chartWeight = this._getRingWeight(this.index);
      const {
        circumference,
        rotation
      } = this._getRotationExtents();
      const {
        ratioX,
        ratioY,
        offsetX,
        offsetY
      } = getRatioAndOffset(rotation, circumference, cutout);
      const maxWidth = (chartArea.width - spacing) / ratioX;
      const maxHeight = (chartArea.height - spacing) / ratioY;
      const maxRadius = Math.max(Math.min(maxWidth, maxHeight) / 2, 0);
      const outerRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.n)(this.options.radius, maxRadius);
      const innerRadius = Math.max(outerRadius * cutout, 0);
      const radiusLength = (outerRadius - innerRadius) / this._getVisibleDatasetWeightTotal();
      this.offsetX = offsetX * outerRadius;
      this.offsetY = offsetY * outerRadius;
      meta.total = this.calculateTotal();
      this.outerRadius = outerRadius - radiusLength * this._getRingWeightOffset(this.index);
      this.innerRadius = Math.max(this.outerRadius - radiusLength * chartWeight, 0);
      this.updateElements(arcs, 0, arcs.length, mode);
    }
    _circumference(i, reset) {
      const opts = this.options;
      const meta = this._cachedMeta;
      const circumference = this._getCircumference();
      if (reset && opts.animation.animateRotate || !this.chart.getDataVisibility(i) || meta._parsed[i] === null || meta.data[i].hidden) {
        return 0;
      }
      return this.calculateCircumference(meta._parsed[i] * circumference / _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);
    }
    updateElements(arcs, start, count, mode) {
      const reset = mode === 'reset';
      const chart = this.chart;
      const chartArea = chart.chartArea;
      const opts = chart.options;
      const animationOpts = opts.animation;
      const centerX = (chartArea.left + chartArea.right) / 2;
      const centerY = (chartArea.top + chartArea.bottom) / 2;
      const animateScale = reset && animationOpts.animateScale;
      const innerRadius = animateScale ? 0 : this.innerRadius;
      const outerRadius = animateScale ? 0 : this.outerRadius;
      const {
        sharedOptions,
        includeOptions
      } = this._getSharedOptions(start, mode);
      let startAngle = this._getRotation();
      let i;
      for (i = 0; i < start; ++i) {
        startAngle += this._circumference(i, reset);
      }
      for (i = start; i < start + count; ++i) {
        const circumference = this._circumference(i, reset);
        const arc = arcs[i];
        const properties = {
          x: centerX + this.offsetX,
          y: centerY + this.offsetY,
          startAngle,
          endAngle: startAngle + circumference,
          circumference,
          outerRadius,
          innerRadius
        };
        if (includeOptions) {
          properties.options = sharedOptions || this.resolveDataElementOptions(i, arc.active ? 'active' : mode);
        }
        startAngle += circumference;
        this.updateElement(arc, i, properties, mode);
      }
    }
    calculateTotal() {
      const meta = this._cachedMeta;
      const metaData = meta.data;
      let total = 0;
      let i;
      for (i = 0; i < metaData.length; i++) {
        const value = meta._parsed[i];
        if (value !== null && !isNaN(value) && this.chart.getDataVisibility(i) && !metaData[i].hidden) {
          total += Math.abs(value);
        }
      }
      return total;
    }
    calculateCircumference(value) {
      const total = this._cachedMeta.total;
      if (total > 0 && !isNaN(value)) {
        return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T * (Math.abs(value) / total);
      }
      return 0;
    }
    getLabelAndValue(index) {
      const meta = this._cachedMeta;
      const chart = this.chart;
      const labels = chart.data.labels || [];
      const value = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(meta._parsed[index], chart.options.locale);
      return {
        label: labels[index] || '',
        value
      };
    }
    getMaxBorderWidth(arcs) {
      let max = 0;
      const chart = this.chart;
      let i, ilen, meta, controller, options;
      if (!arcs) {
        for (i = 0, ilen = chart.data.datasets.length; i < ilen; ++i) {
          if (chart.isDatasetVisible(i)) {
            meta = chart.getDatasetMeta(i);
            arcs = meta.data;
            controller = meta.controller;
            break;
          }
        }
      }
      if (!arcs) {
        return 0;
      }
      for (i = 0, ilen = arcs.length; i < ilen; ++i) {
        options = controller.resolveDataElementOptions(i);
        if (options.borderAlign !== 'inner') {
          max = Math.max(max, options.borderWidth || 0, options.hoverBorderWidth || 0);
        }
      }
      return max;
    }
    getMaxOffset(arcs) {
      let max = 0;
      for (let i = 0, ilen = arcs.length; i < ilen; ++i) {
        const options = this.resolveDataElementOptions(i);
        max = Math.max(max, options.offset || 0, options.hoverOffset || 0);
      }
      return max;
    }
    _getRingWeightOffset(datasetIndex) {
      let ringWeightOffset = 0;
      for (let i = 0; i < datasetIndex; ++i) {
        if (this.chart.isDatasetVisible(i)) {
          ringWeightOffset += this._getRingWeight(i);
        }
      }
      return ringWeightOffset;
    }
    _getRingWeight(datasetIndex) {
      return Math.max((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(this.chart.data.datasets[datasetIndex].weight, 1), 0);
    }
    _getVisibleDatasetWeightTotal() {
      return this._getRingWeightOffset(this.chart.data.datasets.length) || 1;
    }
  }
  return DoughnutController;
})();
let LineController = /*#__PURE__*/(() => {
  class LineController extends DatasetController {
    static id = 'line';
    static defaults = {
      datasetElementType: 'line',
      dataElementType: 'point',
      showLine: true,
      spanGaps: false
    };
    static overrides = {
      scales: {
        _index_: {
          type: 'category'
        },
        _value_: {
          type: 'linear'
        }
      }
    };
    initialize() {
      this.enableOptionSharing = true;
      this.supportsDecimation = true;
      super.initialize();
    }
    update(mode) {
      const meta = this._cachedMeta;
      const {
        dataset: line,
        data: points = [],
        _dataset
      } = meta;
      const animationsDisabled = this.chart._animationsDisabled;
      let {
        start,
        count
      } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(meta, points, animationsDisabled);
      this._drawStart = start;
      this._drawCount = count;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(meta)) {
        start = 0;
        count = points.length;
      }
      line._chart = this.chart;
      line._datasetIndex = this.index;
      line._decimated = !!_dataset._decimated;
      line.points = points;
      const options = this.resolveDatasetElementOptions(mode);
      if (!this.options.showLine) {
        options.borderWidth = 0;
      }
      options.segment = this.options.segment;
      this.updateElement(line, undefined, {
        animated: !animationsDisabled,
        options
      }, mode);
      this.updateElements(points, start, count, mode);
    }
    updateElements(points, start, count, mode) {
      const reset = mode === 'reset';
      const {
        iScale,
        vScale,
        _stacked,
        _dataset
      } = this._cachedMeta;
      const {
        sharedOptions,
        includeOptions
      } = this._getSharedOptions(start, mode);
      const iAxis = iScale.axis;
      const vAxis = vScale.axis;
      const {
        spanGaps,
        segment
      } = this.options;
      const maxGapLength = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;
      const directUpdate = this.chart._animationsDisabled || reset || mode === 'none';
      const end = start + count;
      const pointsCount = points.length;
      let prevParsed = start > 0 && this.getParsed(start - 1);
      for (let i = 0; i < pointsCount; ++i) {
        const point = points[i];
        const properties = directUpdate ? point : {};
        if (i < start || i >= end) {
          properties.skip = true;
          continue;
        }
        const parsed = this.getParsed(i);
        const nullData = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(parsed[vAxis]);
        const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);
        const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? this.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);
        properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;
        properties.stop = i > 0 && Math.abs(parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;
        if (segment) {
          properties.parsed = parsed;
          properties.raw = _dataset.data[i];
        }
        if (includeOptions) {
          properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? 'active' : mode);
        }
        if (!directUpdate) {
          this.updateElement(point, i, properties, mode);
        }
        prevParsed = parsed;
      }
    }
    getMaxOverflow() {
      const meta = this._cachedMeta;
      const dataset = meta.dataset;
      const border = dataset.options && dataset.options.borderWidth || 0;
      const data = meta.data || [];
      if (!data.length) {
        return border;
      }
      const firstPoint = data[0].size(this.resolveDataElementOptions(0));
      const lastPoint = data[data.length - 1].size(this.resolveDataElementOptions(data.length - 1));
      return Math.max(border, firstPoint, lastPoint) / 2;
    }
    draw() {
      const meta = this._cachedMeta;
      meta.dataset.updateControlPoints(this.chart.chartArea, meta.iScale.axis);
      super.draw();
    }
  }
  return LineController;
})();
let PolarAreaController = /*#__PURE__*/(() => {
  class PolarAreaController extends DatasetController {
    static id = 'polarArea';
    static defaults = {
      dataElementType: 'arc',
      animation: {
        animateRotate: true,
        animateScale: true
      },
      animations: {
        numbers: {
          type: 'number',
          properties: ['x', 'y', 'startAngle', 'endAngle', 'innerRadius', 'outerRadius']
        }
      },
      indexAxis: 'r',
      startAngle: 0
    };
    static overrides = {
      aspectRatio: 1,
      plugins: {
        legend: {
          labels: {
            generateLabels(chart) {
              const data = chart.data;
              if (data.labels.length && data.datasets.length) {
                const {
                  labels: {
                    pointStyle,
                    color
                  }
                } = chart.legend.options;
                return data.labels.map((label, i) => {
                  const meta = chart.getDatasetMeta(0);
                  const style = meta.controller.getStyle(i);
                  return {
                    text: label,
                    fillStyle: style.backgroundColor,
                    strokeStyle: style.borderColor,
                    fontColor: color,
                    lineWidth: style.borderWidth,
                    pointStyle: pointStyle,
                    hidden: !chart.getDataVisibility(i),
                    index: i
                  };
                });
              }
              return [];
            }
          },
          onClick(e, legendItem, legend) {
            legend.chart.toggleDataVisibility(legendItem.index);
            legend.chart.update();
          }
        }
      },
      scales: {
        r: {
          type: 'radialLinear',
          angleLines: {
            display: false
          },
          beginAtZero: true,
          grid: {
            circular: true
          },
          pointLabels: {
            display: false
          },
          startAngle: 0
        }
      }
    };
    constructor(chart, datasetIndex) {
      super(chart, datasetIndex);
      this.innerRadius = undefined;
      this.outerRadius = undefined;
    }
    getLabelAndValue(index) {
      const meta = this._cachedMeta;
      const chart = this.chart;
      const labels = chart.data.labels || [];
      const value = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(meta._parsed[index].r, chart.options.locale);
      return {
        label: labels[index] || '',
        value
      };
    }
    parseObjectData(meta, data, start, count) {
      return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y.bind(this)(meta, data, start, count);
    }
    update(mode) {
      const arcs = this._cachedMeta.data;
      this._updateRadius();
      this.updateElements(arcs, 0, arcs.length, mode);
    }
    getMinMax() {
      const meta = this._cachedMeta;
      const range = {
        min: Number.POSITIVE_INFINITY,
        max: Number.NEGATIVE_INFINITY
      };
      meta.data.forEach((element, index) => {
        const parsed = this.getParsed(index).r;
        if (!isNaN(parsed) && this.chart.getDataVisibility(index)) {
          if (parsed < range.min) {
            range.min = parsed;
          }
          if (parsed > range.max) {
            range.max = parsed;
          }
        }
      });
      return range;
    }
    _updateRadius() {
      const chart = this.chart;
      const chartArea = chart.chartArea;
      const opts = chart.options;
      const minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);
      const outerRadius = Math.max(minSize / 2, 0);
      const innerRadius = Math.max(opts.cutoutPercentage ? outerRadius / 100 * opts.cutoutPercentage : 1, 0);
      const radiusLength = (outerRadius - innerRadius) / chart.getVisibleDatasetCount();
      this.outerRadius = outerRadius - radiusLength * this.index;
      this.innerRadius = this.outerRadius - radiusLength;
    }
    updateElements(arcs, start, count, mode) {
      const reset = mode === 'reset';
      const chart = this.chart;
      const opts = chart.options;
      const animationOpts = opts.animation;
      const scale = this._cachedMeta.rScale;
      const centerX = scale.xCenter;
      const centerY = scale.yCenter;
      const datasetStartAngle = scale.getIndexAngle(0) - 0.5 * _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P;
      let angle = datasetStartAngle;
      let i;
      const defaultAngle = 360 / this.countVisibleElements();
      for (i = 0; i < start; ++i) {
        angle += this._computeAngle(i, mode, defaultAngle);
      }
      for (i = start; i < start + count; i++) {
        const arc = arcs[i];
        let startAngle = angle;
        let endAngle = angle + this._computeAngle(i, mode, defaultAngle);
        let outerRadius = chart.getDataVisibility(i) ? scale.getDistanceFromCenterForValue(this.getParsed(i).r) : 0;
        angle = endAngle;
        if (reset) {
          if (animationOpts.animateScale) {
            outerRadius = 0;
          }
          if (animationOpts.animateRotate) {
            startAngle = endAngle = datasetStartAngle;
          }
        }
        const properties = {
          x: centerX,
          y: centerY,
          innerRadius: 0,
          outerRadius,
          startAngle,
          endAngle,
          options: this.resolveDataElementOptions(i, arc.active ? 'active' : mode)
        };
        this.updateElement(arc, i, properties, mode);
      }
    }
    countVisibleElements() {
      const meta = this._cachedMeta;
      let count = 0;
      meta.data.forEach((element, index) => {
        if (!isNaN(this.getParsed(index).r) && this.chart.getDataVisibility(index)) {
          count++;
        }
      });
      return count;
    }
    _computeAngle(index, mode, defaultAngle) {
      return this.chart.getDataVisibility(index) ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.resolveDataElementOptions(index, mode).angle || defaultAngle) : 0;
    }
  }
  return PolarAreaController;
})();
let PieController = /*#__PURE__*/(() => {
  class PieController extends DoughnutController {
    static id = 'pie';
    static defaults = {
      cutout: 0,
      rotation: 0,
      circumference: 360,
      radius: '100%'
    };
  }
  return PieController;
})();
let RadarController = /*#__PURE__*/(() => {
  class RadarController extends DatasetController {
    static id = 'radar';
    static defaults = {
      datasetElementType: 'line',
      dataElementType: 'point',
      indexAxis: 'r',
      showLine: true,
      elements: {
        line: {
          fill: 'start'
        }
      }
    };
    static overrides = {
      aspectRatio: 1,
      scales: {
        r: {
          type: 'radialLinear'
        }
      }
    };
    getLabelAndValue(index) {
      const vScale = this._cachedMeta.vScale;
      const parsed = this.getParsed(index);
      return {
        label: vScale.getLabels()[index],
        value: '' + vScale.getLabelForValue(parsed[vScale.axis])
      };
    }
    parseObjectData(meta, data, start, count) {
      return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.y.bind(this)(meta, data, start, count);
    }
    update(mode) {
      const meta = this._cachedMeta;
      const line = meta.dataset;
      const points = meta.data || [];
      const labels = meta.iScale.getLabels();
      line.points = points;
      if (mode !== 'resize') {
        const options = this.resolveDatasetElementOptions(mode);
        if (!this.options.showLine) {
          options.borderWidth = 0;
        }
        const properties = {
          _loop: true,
          _fullLoop: labels.length === points.length,
          options
        };
        this.updateElement(line, undefined, properties, mode);
      }
      this.updateElements(points, 0, points.length, mode);
    }
    updateElements(points, start, count, mode) {
      const scale = this._cachedMeta.rScale;
      const reset = mode === 'reset';
      for (let i = start; i < start + count; i++) {
        const point = points[i];
        const options = this.resolveDataElementOptions(i, point.active ? 'active' : mode);
        const pointPosition = scale.getPointPositionForValue(i, this.getParsed(i).r);
        const x = reset ? scale.xCenter : pointPosition.x;
        const y = reset ? scale.yCenter : pointPosition.y;
        const properties = {
          x,
          y,
          angle: pointPosition.angle,
          skip: isNaN(x) || isNaN(y),
          options
        };
        this.updateElement(point, i, properties, mode);
      }
    }
  }
  return RadarController;
})();
let ScatterController = /*#__PURE__*/(() => {
  class ScatterController extends DatasetController {
    static id = 'scatter';
    static defaults = {
      datasetElementType: false,
      dataElementType: 'point',
      showLine: false,
      fill: false
    };
    static overrides = {
      interaction: {
        mode: 'point'
      },
      scales: {
        x: {
          type: 'linear'
        },
        y: {
          type: 'linear'
        }
      }
    };
    getLabelAndValue(index) {
      const meta = this._cachedMeta;
      const labels = this.chart.data.labels || [];
      const {
        xScale,
        yScale
      } = meta;
      const parsed = this.getParsed(index);
      const x = xScale.getLabelForValue(parsed.x);
      const y = yScale.getLabelForValue(parsed.y);
      return {
        label: labels[index] || '',
        value: '(' + x + ', ' + y + ')'
      };
    }
    update(mode) {
      const meta = this._cachedMeta;
      const {
        data: points = []
      } = meta;
      const animationsDisabled = this.chart._animationsDisabled;
      let {
        start,
        count
      } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.q)(meta, points, animationsDisabled);
      this._drawStart = start;
      this._drawCount = count;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.w)(meta)) {
        start = 0;
        count = points.length;
      }
      if (this.options.showLine) {
        if (!this.datasetElementType) {
          this.addElements();
        }
        const {
          dataset: line,
          _dataset
        } = meta;
        line._chart = this.chart;
        line._datasetIndex = this.index;
        line._decimated = !!_dataset._decimated;
        line.points = points;
        const options = this.resolveDatasetElementOptions(mode);
        options.segment = this.options.segment;
        this.updateElement(line, undefined, {
          animated: !animationsDisabled,
          options
        }, mode);
      } else if (this.datasetElementType) {
        delete meta.dataset;
        this.datasetElementType = false;
      }
      this.updateElements(points, start, count, mode);
    }
    addElements() {
      const {
        showLine
      } = this.options;
      if (!this.datasetElementType && showLine) {
        this.datasetElementType = this.chart.registry.getElement('line');
      }
      super.addElements();
    }
    updateElements(points, start, count, mode) {
      const reset = mode === 'reset';
      const {
        iScale,
        vScale,
        _stacked,
        _dataset
      } = this._cachedMeta;
      const firstOpts = this.resolveDataElementOptions(start, mode);
      const sharedOptions = this.getSharedOptions(firstOpts);
      const includeOptions = this.includeOptions(mode, sharedOptions);
      const iAxis = iScale.axis;
      const vAxis = vScale.axis;
      const {
        spanGaps,
        segment
      } = this.options;
      const maxGapLength = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;
      const directUpdate = this.chart._animationsDisabled || reset || mode === 'none';
      let prevParsed = start > 0 && this.getParsed(start - 1);
      for (let i = start; i < start + count; ++i) {
        const point = points[i];
        const parsed = this.getParsed(i);
        const properties = directUpdate ? point : {};
        const nullData = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(parsed[vAxis]);
        const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);
        const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? this.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);
        properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;
        properties.stop = i > 0 && Math.abs(parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;
        if (segment) {
          properties.parsed = parsed;
          properties.raw = _dataset.data[i];
        }
        if (includeOptions) {
          properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? 'active' : mode);
        }
        if (!directUpdate) {
          this.updateElement(point, i, properties, mode);
        }
        prevParsed = parsed;
      }
      this.updateSharedOptions(sharedOptions, mode, firstOpts);
    }
    getMaxOverflow() {
      const meta = this._cachedMeta;
      const data = meta.data || [];
      if (!this.options.showLine) {
        let max = 0;
        for (let i = data.length - 1; i >= 0; --i) {
          max = Math.max(max, data[i].size(this.resolveDataElementOptions(i)) / 2);
        }
        return max > 0 && max;
      }
      const dataset = meta.dataset;
      const border = dataset.options && dataset.options.borderWidth || 0;
      if (!data.length) {
        return border;
      }
      const firstPoint = data[0].size(this.resolveDataElementOptions(0));
      const lastPoint = data[data.length - 1].size(this.resolveDataElementOptions(data.length - 1));
      return Math.max(border, firstPoint, lastPoint) / 2;
    }
  }
  return ScatterController;
})();
var controllers = /*#__PURE__*/Object.freeze({
  __proto__: null,
  BarController: BarController,
  BubbleController: BubbleController,
  DoughnutController: DoughnutController,
  LineController: LineController,
  PieController: PieController,
  PolarAreaController: PolarAreaController,
  RadarController: RadarController,
  ScatterController: ScatterController
});

/**
 * @namespace Chart._adapters
 * @since 2.8.0
 * @private
 */
function abstract() {
  throw new Error('This method is not implemented: Check that a complete date adapter is provided.');
}
/**
 * Date adapter (current used by the time scale)
 * @namespace Chart._adapters._date
 * @memberof Chart._adapters
 * @private
 */
class DateAdapterBase {
  /**
  * Override default date adapter methods.
  * Accepts type parameter to define options type.
  * @example
  * Chart._adapters._date.override<{myAdapterOption: string}>({
  *   init() {
  *     console.log(this.options.myAdapterOption);
  *   }
  * })
  */
  static override(members) {
    Object.assign(DateAdapterBase.prototype, members);
  }
  options;
  constructor(options) {
    this.options = options || {};
  }
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  init() {}
  formats() {
    return abstract();
  }
  parse() {
    return abstract();
  }
  format() {
    return abstract();
  }
  add() {
    return abstract();
  }
  diff() {
    return abstract();
  }
  startOf() {
    return abstract();
  }
  endOf() {
    return abstract();
  }
}
var adapters = {
  _date: DateAdapterBase
};
function binarySearch(metaset, axis, value, intersect) {
  const {
    controller,
    data,
    _sorted
  } = metaset;
  const iScale = controller._cachedMeta.iScale;
  if (iScale && axis === iScale.axis && axis !== 'r' && _sorted && data.length) {
    const lookupMethod = iScale._reversePixels ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.A : _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B;
    if (!intersect) {
      return lookupMethod(data, axis, value);
    } else if (controller._sharedOptions) {
      const el = data[0];
      const range = typeof el.getRange === 'function' && el.getRange(axis);
      if (range) {
        const start = lookupMethod(data, axis, value - range);
        const end = lookupMethod(data, axis, value + range);
        return {
          lo: start.lo,
          hi: end.hi
        };
      }
    }
  }
  return {
    lo: 0,
    hi: data.length - 1
  };
}
function evaluateInteractionItems(chart, axis, position, handler, intersect) {
  const metasets = chart.getSortedVisibleDatasetMetas();
  const value = position[axis];
  for (let i = 0, ilen = metasets.length; i < ilen; ++i) {
    const {
      index,
      data
    } = metasets[i];
    const {
      lo,
      hi
    } = binarySearch(metasets[i], axis, value, intersect);
    for (let j = lo; j <= hi; ++j) {
      const element = data[j];
      if (!element.skip) {
        handler(element, index, j);
      }
    }
  }
}
function getDistanceMetricForAxis(axis) {
  const useX = axis.indexOf('x') !== -1;
  const useY = axis.indexOf('y') !== -1;
  return function (pt1, pt2) {
    const deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;
    const deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;
    return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
  };
}
function getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) {
  const items = [];
  if (!includeInvisible && !chart.isPointInArea(position)) {
    return items;
  }
  const evaluationFunc = function (element, datasetIndex, index) {
    if (!includeInvisible && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)(element, chart.chartArea, 0)) {
      return;
    }
    if (element.inRange(position.x, position.y, useFinalPosition)) {
      items.push({
        element,
        datasetIndex,
        index
      });
    }
  };
  evaluateInteractionItems(chart, axis, position, evaluationFunc, true);
  return items;
}
function getNearestRadialItems(chart, position, axis, useFinalPosition) {
  let items = [];
  function evaluationFunc(element, datasetIndex, index) {
    const {
      startAngle,
      endAngle
    } = element.getProps(['startAngle', 'endAngle'], useFinalPosition);
    const {
      angle
    } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(element, {
      x: position.x,
      y: position.y
    });
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle)) {
      items.push({
        element,
        datasetIndex,
        index
      });
    }
  }
  evaluateInteractionItems(chart, axis, position, evaluationFunc);
  return items;
}
function getNearestCartesianItems(chart, position, axis, intersect, useFinalPosition, includeInvisible) {
  let items = [];
  const distanceMetric = getDistanceMetricForAxis(axis);
  let minDistance = Number.POSITIVE_INFINITY;
  function evaluationFunc(element, datasetIndex, index) {
    const inRange = element.inRange(position.x, position.y, useFinalPosition);
    if (intersect && !inRange) {
      return;
    }
    const center = element.getCenterPoint(useFinalPosition);
    const pointInArea = !!includeInvisible || chart.isPointInArea(center);
    if (!pointInArea && !inRange) {
      return;
    }
    const distance = distanceMetric(position, center);
    if (distance < minDistance) {
      items = [{
        element,
        datasetIndex,
        index
      }];
      minDistance = distance;
    } else if (distance === minDistance) {
      items.push({
        element,
        datasetIndex,
        index
      });
    }
  }
  evaluateInteractionItems(chart, axis, position, evaluationFunc);
  return items;
}
function getNearestItems(chart, position, axis, intersect, useFinalPosition, includeInvisible) {
  if (!includeInvisible && !chart.isPointInArea(position)) {
    return [];
  }
  return axis === 'r' && !intersect ? getNearestRadialItems(chart, position, axis, useFinalPosition) : getNearestCartesianItems(chart, position, axis, intersect, useFinalPosition, includeInvisible);
}
function getAxisItems(chart, position, axis, intersect, useFinalPosition) {
  const items = [];
  const rangeMethod = axis === 'x' ? 'inXRange' : 'inYRange';
  let intersectsItem = false;
  evaluateInteractionItems(chart, axis, position, (element, datasetIndex, index) => {
    if (element[rangeMethod] && element[rangeMethod](position[axis], useFinalPosition)) {
      items.push({
        element,
        datasetIndex,
        index
      });
      intersectsItem = intersectsItem || element.inRange(position.x, position.y, useFinalPosition);
    }
  });
  if (intersect && !intersectsItem) {
    return [];
  }
  return items;
}
var Interaction = {
  evaluateInteractionItems,
  modes: {
    index(chart, e, options, useFinalPosition) {
      const position = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);
      const axis = options.axis || 'x';
      const includeInvisible = options.includeInvisible || false;
      const items = options.intersect ? getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) : getNearestItems(chart, position, axis, false, useFinalPosition, includeInvisible);
      const elements = [];
      if (!items.length) {
        return [];
      }
      chart.getSortedVisibleDatasetMetas().forEach(meta => {
        const index = items[0].index;
        const element = meta.data[index];
        if (element && !element.skip) {
          elements.push({
            element,
            datasetIndex: meta.index,
            index
          });
        }
      });
      return elements;
    },
    dataset(chart, e, options, useFinalPosition) {
      const position = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);
      const axis = options.axis || 'xy';
      const includeInvisible = options.includeInvisible || false;
      let items = options.intersect ? getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) : getNearestItems(chart, position, axis, false, useFinalPosition, includeInvisible);
      if (items.length > 0) {
        const datasetIndex = items[0].datasetIndex;
        const data = chart.getDatasetMeta(datasetIndex).data;
        items = [];
        for (let i = 0; i < data.length; ++i) {
          items.push({
            element: data[i],
            datasetIndex,
            index: i
          });
        }
      }
      return items;
    },
    point(chart, e, options, useFinalPosition) {
      const position = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);
      const axis = options.axis || 'xy';
      const includeInvisible = options.includeInvisible || false;
      return getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible);
    },
    nearest(chart, e, options, useFinalPosition) {
      const position = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);
      const axis = options.axis || 'xy';
      const includeInvisible = options.includeInvisible || false;
      return getNearestItems(chart, position, axis, options.intersect, useFinalPosition, includeInvisible);
    },
    x(chart, e, options, useFinalPosition) {
      const position = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);
      return getAxisItems(chart, position, 'x', options.intersect, useFinalPosition);
    },
    y(chart, e, options, useFinalPosition) {
      const position = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(e, chart);
      return getAxisItems(chart, position, 'y', options.intersect, useFinalPosition);
    }
  }
};
const STATIC_POSITIONS = ['left', 'top', 'right', 'bottom'];
function filterByPosition(array, position) {
  return array.filter(v => v.pos === position);
}
function filterDynamicPositionByAxis(array, axis) {
  return array.filter(v => STATIC_POSITIONS.indexOf(v.pos) === -1 && v.box.axis === axis);
}
function sortByWeight(array, reverse) {
  return array.sort((a, b) => {
    const v0 = reverse ? b : a;
    const v1 = reverse ? a : b;
    return v0.weight === v1.weight ? v0.index - v1.index : v0.weight - v1.weight;
  });
}
function wrapBoxes(boxes) {
  const layoutBoxes = [];
  let i, ilen, box, pos, stack, stackWeight;
  for (i = 0, ilen = (boxes || []).length; i < ilen; ++i) {
    box = boxes[i];
    ({
      position: pos,
      options: {
        stack,
        stackWeight = 1
      }
    } = box);
    layoutBoxes.push({
      index: i,
      box,
      pos,
      horizontal: box.isHorizontal(),
      weight: box.weight,
      stack: stack && pos + stack,
      stackWeight
    });
  }
  return layoutBoxes;
}
function buildStacks(layouts) {
  const stacks = {};
  for (const wrap of layouts) {
    const {
      stack,
      pos,
      stackWeight
    } = wrap;
    if (!stack || !STATIC_POSITIONS.includes(pos)) {
      continue;
    }
    const _stack = stacks[stack] || (stacks[stack] = {
      count: 0,
      placed: 0,
      weight: 0,
      size: 0
    });
    _stack.count++;
    _stack.weight += stackWeight;
  }
  return stacks;
}
function setLayoutDims(layouts, params) {
  const stacks = buildStacks(layouts);
  const {
    vBoxMaxWidth,
    hBoxMaxHeight
  } = params;
  let i, ilen, layout;
  for (i = 0, ilen = layouts.length; i < ilen; ++i) {
    layout = layouts[i];
    const {
      fullSize
    } = layout.box;
    const stack = stacks[layout.stack];
    const factor = stack && layout.stackWeight / stack.weight;
    if (layout.horizontal) {
      layout.width = factor ? factor * vBoxMaxWidth : fullSize && params.availableWidth;
      layout.height = hBoxMaxHeight;
    } else {
      layout.width = vBoxMaxWidth;
      layout.height = factor ? factor * hBoxMaxHeight : fullSize && params.availableHeight;
    }
  }
  return stacks;
}
function buildLayoutBoxes(boxes) {
  const layoutBoxes = wrapBoxes(boxes);
  const fullSize = sortByWeight(layoutBoxes.filter(wrap => wrap.box.fullSize), true);
  const left = sortByWeight(filterByPosition(layoutBoxes, 'left'), true);
  const right = sortByWeight(filterByPosition(layoutBoxes, 'right'));
  const top = sortByWeight(filterByPosition(layoutBoxes, 'top'), true);
  const bottom = sortByWeight(filterByPosition(layoutBoxes, 'bottom'));
  const centerHorizontal = filterDynamicPositionByAxis(layoutBoxes, 'x');
  const centerVertical = filterDynamicPositionByAxis(layoutBoxes, 'y');
  return {
    fullSize,
    leftAndTop: left.concat(top),
    rightAndBottom: right.concat(centerVertical).concat(bottom).concat(centerHorizontal),
    chartArea: filterByPosition(layoutBoxes, 'chartArea'),
    vertical: left.concat(right).concat(centerVertical),
    horizontal: top.concat(bottom).concat(centerHorizontal)
  };
}
function getCombinedMax(maxPadding, chartArea, a, b) {
  return Math.max(maxPadding[a], chartArea[a]) + Math.max(maxPadding[b], chartArea[b]);
}
function updateMaxPadding(maxPadding, boxPadding) {
  maxPadding.top = Math.max(maxPadding.top, boxPadding.top);
  maxPadding.left = Math.max(maxPadding.left, boxPadding.left);
  maxPadding.bottom = Math.max(maxPadding.bottom, boxPadding.bottom);
  maxPadding.right = Math.max(maxPadding.right, boxPadding.right);
}
function updateDims(chartArea, params, layout, stacks) {
  const {
    pos,
    box
  } = layout;
  const maxPadding = chartArea.maxPadding;
  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(pos)) {
    if (layout.size) {
      chartArea[pos] -= layout.size;
    }
    const stack = stacks[layout.stack] || {
      size: 0,
      count: 1
    };
    stack.size = Math.max(stack.size, layout.horizontal ? box.height : box.width);
    layout.size = stack.size / stack.count;
    chartArea[pos] += layout.size;
  }
  if (box.getPadding) {
    updateMaxPadding(maxPadding, box.getPadding());
  }
  const newWidth = Math.max(0, params.outerWidth - getCombinedMax(maxPadding, chartArea, 'left', 'right'));
  const newHeight = Math.max(0, params.outerHeight - getCombinedMax(maxPadding, chartArea, 'top', 'bottom'));
  const widthChanged = newWidth !== chartArea.w;
  const heightChanged = newHeight !== chartArea.h;
  chartArea.w = newWidth;
  chartArea.h = newHeight;
  return layout.horizontal ? {
    same: widthChanged,
    other: heightChanged
  } : {
    same: heightChanged,
    other: widthChanged
  };
}
function handleMaxPadding(chartArea) {
  const maxPadding = chartArea.maxPadding;
  function updatePos(pos) {
    const change = Math.max(maxPadding[pos] - chartArea[pos], 0);
    chartArea[pos] += change;
    return change;
  }
  chartArea.y += updatePos('top');
  chartArea.x += updatePos('left');
  updatePos('right');
  updatePos('bottom');
}
function getMargins(horizontal, chartArea) {
  const maxPadding = chartArea.maxPadding;
  function marginForPositions(positions) {
    const margin = {
      left: 0,
      top: 0,
      right: 0,
      bottom: 0
    };
    positions.forEach(pos => {
      margin[pos] = Math.max(chartArea[pos], maxPadding[pos]);
    });
    return margin;
  }
  return horizontal ? marginForPositions(['left', 'right']) : marginForPositions(['top', 'bottom']);
}
function fitBoxes(boxes, chartArea, params, stacks) {
  const refitBoxes = [];
  let i, ilen, layout, box, refit, changed;
  for (i = 0, ilen = boxes.length, refit = 0; i < ilen; ++i) {
    layout = boxes[i];
    box = layout.box;
    box.update(layout.width || chartArea.w, layout.height || chartArea.h, getMargins(layout.horizontal, chartArea));
    const {
      same,
      other
    } = updateDims(chartArea, params, layout, stacks);
    refit |= same && refitBoxes.length;
    changed = changed || other;
    if (!box.fullSize) {
      refitBoxes.push(layout);
    }
  }
  return refit && fitBoxes(refitBoxes, chartArea, params, stacks) || changed;
}
function setBoxDims(box, left, top, width, height) {
  box.top = top;
  box.left = left;
  box.right = left + width;
  box.bottom = top + height;
  box.width = width;
  box.height = height;
}
function placeBoxes(boxes, chartArea, params, stacks) {
  const userPadding = params.padding;
  let {
    x,
    y
  } = chartArea;
  for (const layout of boxes) {
    const box = layout.box;
    const stack = stacks[layout.stack] || {
      count: 1,
      placed: 0,
      weight: 1
    };
    const weight = layout.stackWeight / stack.weight || 1;
    if (layout.horizontal) {
      const width = chartArea.w * weight;
      const height = stack.size || box.height;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(stack.start)) {
        y = stack.start;
      }
      if (box.fullSize) {
        setBoxDims(box, userPadding.left, y, params.outerWidth - userPadding.right - userPadding.left, height);
      } else {
        setBoxDims(box, chartArea.left + stack.placed, y, width, height);
      }
      stack.start = y;
      stack.placed += width;
      y = box.bottom;
    } else {
      const height = chartArea.h * weight;
      const width = stack.size || box.width;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(stack.start)) {
        x = stack.start;
      }
      if (box.fullSize) {
        setBoxDims(box, x, userPadding.top, width, params.outerHeight - userPadding.bottom - userPadding.top);
      } else {
        setBoxDims(box, x, chartArea.top + stack.placed, width, height);
      }
      stack.start = x;
      stack.placed += height;
      x = box.right;
    }
  }
  chartArea.x = x;
  chartArea.y = y;
}
var layouts = {
  addBox(chart, item) {
    if (!chart.boxes) {
      chart.boxes = [];
    }
    item.fullSize = item.fullSize || false;
    item.position = item.position || 'top';
    item.weight = item.weight || 0;
    item._layers = item._layers || function () {
      return [{
        z: 0,
        draw(chartArea) {
          item.draw(chartArea);
        }
      }];
    };
    chart.boxes.push(item);
  },
  removeBox(chart, layoutItem) {
    const index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;
    if (index !== -1) {
      chart.boxes.splice(index, 1);
    }
  },
  configure(chart, item, options) {
    item.fullSize = options.fullSize;
    item.position = options.position;
    item.weight = options.weight;
  },
  update(chart, width, height, minPadding) {
    if (!chart) {
      return;
    }
    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(chart.options.layout.padding);
    const availableWidth = Math.max(width - padding.width, 0);
    const availableHeight = Math.max(height - padding.height, 0);
    const boxes = buildLayoutBoxes(chart.boxes);
    const verticalBoxes = boxes.vertical;
    const horizontalBoxes = boxes.horizontal;
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(chart.boxes, box => {
      if (typeof box.beforeLayout === 'function') {
        box.beforeLayout();
      }
    });
    const visibleVerticalBoxCount = verticalBoxes.reduce((total, wrap) => wrap.box.options && wrap.box.options.display === false ? total : total + 1, 0) || 1;
    const params = Object.freeze({
      outerWidth: width,
      outerHeight: height,
      padding,
      availableWidth,
      availableHeight,
      vBoxMaxWidth: availableWidth / 2 / visibleVerticalBoxCount,
      hBoxMaxHeight: availableHeight / 2
    });
    const maxPadding = Object.assign({}, padding);
    updateMaxPadding(maxPadding, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(minPadding));
    const chartArea = Object.assign({
      maxPadding,
      w: availableWidth,
      h: availableHeight,
      x: padding.left,
      y: padding.top
    }, padding);
    const stacks = setLayoutDims(verticalBoxes.concat(horizontalBoxes), params);
    fitBoxes(boxes.fullSize, chartArea, params, stacks);
    fitBoxes(verticalBoxes, chartArea, params, stacks);
    if (fitBoxes(horizontalBoxes, chartArea, params, stacks)) {
      fitBoxes(verticalBoxes, chartArea, params, stacks);
    }
    handleMaxPadding(chartArea);
    placeBoxes(boxes.leftAndTop, chartArea, params, stacks);
    chartArea.x += chartArea.w;
    chartArea.y += chartArea.h;
    placeBoxes(boxes.rightAndBottom, chartArea, params, stacks);
    chart.chartArea = {
      left: chartArea.left,
      top: chartArea.top,
      right: chartArea.left + chartArea.w,
      bottom: chartArea.top + chartArea.h,
      height: chartArea.h,
      width: chartArea.w
    };
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(boxes.chartArea, layout => {
      const box = layout.box;
      Object.assign(box, chart.chartArea);
      box.update(chartArea.w, chartArea.h, {
        left: 0,
        top: 0,
        right: 0,
        bottom: 0
      });
    });
  }
};
class BasePlatform {
  acquireContext(canvas, aspectRatio) {}
  releaseContext(context) {
    return false;
  }
  addEventListener(chart, type, listener) {}
  removeEventListener(chart, type, listener) {}
  getDevicePixelRatio() {
    return 1;
  }
  getMaximumSize(element, width, height, aspectRatio) {
    width = Math.max(0, width || element.width);
    height = height || element.height;
    return {
      width,
      height: Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height)
    };
  }
  isAttached(canvas) {
    return true;
  }
  updateConfig(config) {}
}
class BasicPlatform extends BasePlatform {
  acquireContext(item) {
    return item && item.getContext && item.getContext('2d') || null;
  }
  updateConfig(config) {
    config.options.animation = false;
  }
}
const EXPANDO_KEY = '$chartjs';
const EVENT_TYPES = {
  touchstart: 'mousedown',
  touchmove: 'mousemove',
  touchend: 'mouseup',
  pointerenter: 'mouseenter',
  pointerdown: 'mousedown',
  pointermove: 'mousemove',
  pointerup: 'mouseup',
  pointerleave: 'mouseout',
  pointerout: 'mouseout'
};
const isNullOrEmpty = value => value === null || value === '';
function initCanvas(canvas, aspectRatio) {
  const style = canvas.style;
  const renderHeight = canvas.getAttribute('height');
  const renderWidth = canvas.getAttribute('width');
  canvas[EXPANDO_KEY] = {
    initial: {
      height: renderHeight,
      width: renderWidth,
      style: {
        display: style.display,
        height: style.height,
        width: style.width
      }
    }
  };
  style.display = style.display || 'block';
  style.boxSizing = style.boxSizing || 'border-box';
  if (isNullOrEmpty(renderWidth)) {
    const displayWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(canvas, 'width');
    if (displayWidth !== undefined) {
      canvas.width = displayWidth;
    }
  }
  if (isNullOrEmpty(renderHeight)) {
    if (canvas.style.height === '') {
      canvas.height = canvas.width / (aspectRatio || 2);
    } else {
      const displayHeight = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.J)(canvas, 'height');
      if (displayHeight !== undefined) {
        canvas.height = displayHeight;
      }
    }
  }
  return canvas;
}
const eventListenerOptions = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.K ? {
  passive: true
} : false;
function addListener(node, type, listener) {
  if (node) {
    node.addEventListener(type, listener, eventListenerOptions);
  }
}
function removeListener(chart, type, listener) {
  if (chart && chart.canvas) {
    chart.canvas.removeEventListener(type, listener, eventListenerOptions);
  }
}
function fromNativeEvent(event, chart) {
  const type = EVENT_TYPES[event.type] || event.type;
  const {
    x,
    y
  } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.z)(event, chart);
  return {
    type,
    chart,
    native: event,
    x: x !== undefined ? x : null,
    y: y !== undefined ? y : null
  };
}
function nodeListContains(nodeList, canvas) {
  for (const node of nodeList) {
    if (node === canvas || node.contains(canvas)) {
      return true;
    }
  }
}
function createAttachObserver(chart, type, listener) {
  const canvas = chart.canvas;
  const observer = new MutationObserver(entries => {
    let trigger = false;
    for (const entry of entries) {
      trigger = trigger || nodeListContains(entry.addedNodes, canvas);
      trigger = trigger && !nodeListContains(entry.removedNodes, canvas);
    }
    if (trigger) {
      listener();
    }
  });
  observer.observe(document, {
    childList: true,
    subtree: true
  });
  return observer;
}
function createDetachObserver(chart, type, listener) {
  const canvas = chart.canvas;
  const observer = new MutationObserver(entries => {
    let trigger = false;
    for (const entry of entries) {
      trigger = trigger || nodeListContains(entry.removedNodes, canvas);
      trigger = trigger && !nodeListContains(entry.addedNodes, canvas);
    }
    if (trigger) {
      listener();
    }
  });
  observer.observe(document, {
    childList: true,
    subtree: true
  });
  return observer;
}
const drpListeningCharts = new Map();
let oldDevicePixelRatio = 0;
function onWindowResize() {
  const dpr = window.devicePixelRatio;
  if (dpr === oldDevicePixelRatio) {
    return;
  }
  oldDevicePixelRatio = dpr;
  drpListeningCharts.forEach((resize, chart) => {
    if (chart.currentDevicePixelRatio !== dpr) {
      resize();
    }
  });
}
function listenDevicePixelRatioChanges(chart, resize) {
  if (!drpListeningCharts.size) {
    window.addEventListener('resize', onWindowResize);
  }
  drpListeningCharts.set(chart, resize);
}
function unlistenDevicePixelRatioChanges(chart) {
  drpListeningCharts.delete(chart);
  if (!drpListeningCharts.size) {
    window.removeEventListener('resize', onWindowResize);
  }
}
function createResizeObserver(chart, type, listener) {
  const canvas = chart.canvas;
  const container = canvas && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.I)(canvas);
  if (!container) {
    return;
  }
  const resize = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)((width, height) => {
    const w = container.clientWidth;
    listener(width, height);
    if (w < container.clientWidth) {
      listener();
    }
  }, window);
  const observer = new ResizeObserver(entries => {
    const entry = entries[0];
    const width = entry.contentRect.width;
    const height = entry.contentRect.height;
    if (width === 0 && height === 0) {
      return;
    }
    resize(width, height);
  });
  observer.observe(container);
  listenDevicePixelRatioChanges(chart, resize);
  return observer;
}
function releaseObserver(chart, type, observer) {
  if (observer) {
    observer.disconnect();
  }
  if (type === 'resize') {
    unlistenDevicePixelRatioChanges(chart);
  }
}
function createProxyAndListen(chart, type, listener) {
  const canvas = chart.canvas;
  const proxy = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.L)(event => {
    if (chart.ctx !== null) {
      listener(fromNativeEvent(event, chart));
    }
  }, chart);
  addListener(canvas, type, proxy);
  return proxy;
}
class DomPlatform extends BasePlatform {
  acquireContext(canvas, aspectRatio) {
    const context = canvas && canvas.getContext && canvas.getContext('2d');
    if (context && context.canvas === canvas) {
      initCanvas(canvas, aspectRatio);
      return context;
    }
    return null;
  }
  releaseContext(context) {
    const canvas = context.canvas;
    if (!canvas[EXPANDO_KEY]) {
      return false;
    }
    const initial = canvas[EXPANDO_KEY].initial;
    ['height', 'width'].forEach(prop => {
      const value = initial[prop];
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(value)) {
        canvas.removeAttribute(prop);
      } else {
        canvas.setAttribute(prop, value);
      }
    });
    const style = initial.style || {};
    Object.keys(style).forEach(key => {
      canvas.style[key] = style[key];
    });
    canvas.width = canvas.width;
    delete canvas[EXPANDO_KEY];
    return true;
  }
  addEventListener(chart, type, listener) {
    this.removeEventListener(chart, type);
    const proxies = chart.$proxies || (chart.$proxies = {});
    const handlers = {
      attach: createAttachObserver,
      detach: createDetachObserver,
      resize: createResizeObserver
    };
    const handler = handlers[type] || createProxyAndListen;
    proxies[type] = handler(chart, type, listener);
  }
  removeEventListener(chart, type) {
    const proxies = chart.$proxies || (chart.$proxies = {});
    const proxy = proxies[type];
    if (!proxy) {
      return;
    }
    const handlers = {
      attach: releaseObserver,
      detach: releaseObserver,
      resize: releaseObserver
    };
    const handler = handlers[type] || removeListener;
    handler(chart, type, proxy);
    proxies[type] = undefined;
  }
  getDevicePixelRatio() {
    return window.devicePixelRatio;
  }
  getMaximumSize(canvas, width, height, aspectRatio) {
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.G)(canvas, width, height, aspectRatio);
  }
  isAttached(canvas) {
    const container = canvas && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.I)(canvas);
    return !!(container && container.isConnected);
  }
}
function _detectPlatform(canvas) {
  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)() || typeof OffscreenCanvas !== 'undefined' && canvas instanceof OffscreenCanvas) {
    return BasicPlatform;
  }
  return DomPlatform;
}
class Element {
  static defaults = {};
  static defaultRoutes = (() => undefined)();
  x;
  y;
  active = false;
  options;
  $animations;
  tooltipPosition(useFinalPosition) {
    const {
      x,
      y
    } = this.getProps(['x', 'y'], useFinalPosition);
    return {
      x,
      y
    };
  }
  hasValue() {
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(this.x) && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(this.y);
  }
  getProps(props, final) {
    const anims = this.$animations;
    if (!final || !anims) {
      // let's not create an object, if not needed
      return this;
    }
    const ret = {};
    props.forEach(prop => {
      ret[prop] = anims[prop] && anims[prop].active() ? anims[prop]._to : this[prop];
    });
    return ret;
  }
}
function autoSkip(scale, ticks) {
  const tickOpts = scale.options.ticks;
  const determinedMaxTicks = determineMaxTicks(scale);
  const ticksLimit = Math.min(tickOpts.maxTicksLimit || determinedMaxTicks, determinedMaxTicks);
  const majorIndices = tickOpts.major.enabled ? getMajorIndices(ticks) : [];
  const numMajorIndices = majorIndices.length;
  const first = majorIndices[0];
  const last = majorIndices[numMajorIndices - 1];
  const newTicks = [];
  if (numMajorIndices > ticksLimit) {
    skipMajors(ticks, newTicks, majorIndices, numMajorIndices / ticksLimit);
    return newTicks;
  }
  const spacing = calculateSpacing(majorIndices, ticks, ticksLimit);
  if (numMajorIndices > 0) {
    let i, ilen;
    const avgMajorSpacing = numMajorIndices > 1 ? Math.round((last - first) / (numMajorIndices - 1)) : null;
    skip(ticks, newTicks, spacing, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(avgMajorSpacing) ? 0 : first - avgMajorSpacing, first);
    for (i = 0, ilen = numMajorIndices - 1; i < ilen; i++) {
      skip(ticks, newTicks, spacing, majorIndices[i], majorIndices[i + 1]);
    }
    skip(ticks, newTicks, spacing, last, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(avgMajorSpacing) ? ticks.length : last + avgMajorSpacing);
    return newTicks;
  }
  skip(ticks, newTicks, spacing);
  return newTicks;
}
function determineMaxTicks(scale) {
  const offset = scale.options.offset;
  const tickLength = scale._tickSize();
  const maxScale = scale._length / tickLength + (offset ? 0 : 1);
  const maxChart = scale._maxLength / tickLength;
  return Math.floor(Math.min(maxScale, maxChart));
}
function calculateSpacing(majorIndices, ticks, ticksLimit) {
  const evenMajorSpacing = getEvenSpacing(majorIndices);
  const spacing = ticks.length / ticksLimit;
  if (!evenMajorSpacing) {
    return Math.max(spacing, 1);
  }
  const factors = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.N)(evenMajorSpacing);
  for (let i = 0, ilen = factors.length - 1; i < ilen; i++) {
    const factor = factors[i];
    if (factor > spacing) {
      return factor;
    }
  }
  return Math.max(spacing, 1);
}
function getMajorIndices(ticks) {
  const result = [];
  let i, ilen;
  for (i = 0, ilen = ticks.length; i < ilen; i++) {
    if (ticks[i].major) {
      result.push(i);
    }
  }
  return result;
}
function skipMajors(ticks, newTicks, majorIndices, spacing) {
  let count = 0;
  let next = majorIndices[0];
  let i;
  spacing = Math.ceil(spacing);
  for (i = 0; i < ticks.length; i++) {
    if (i === next) {
      newTicks.push(ticks[i]);
      count++;
      next = majorIndices[count * spacing];
    }
  }
}
function skip(ticks, newTicks, spacing, majorStart, majorEnd) {
  const start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(majorStart, 0);
  const end = Math.min((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(majorEnd, ticks.length), ticks.length);
  let count = 0;
  let length, i, next;
  spacing = Math.ceil(spacing);
  if (majorEnd) {
    length = majorEnd - majorStart;
    spacing = length / Math.floor(length / spacing);
  }
  next = start;
  while (next < 0) {
    count++;
    next = Math.round(start + count * spacing);
  }
  for (i = Math.max(start, 0); i < end; i++) {
    if (i === next) {
      newTicks.push(ticks[i]);
      count++;
      next = Math.round(start + count * spacing);
    }
  }
}
function getEvenSpacing(arr) {
  const len = arr.length;
  let i, diff;
  if (len < 2) {
    return false;
  }
  for (diff = arr[0], i = 1; i < len; ++i) {
    if (arr[i] - arr[i - 1] !== diff) {
      return false;
    }
  }
  return diff;
}
const reverseAlign = align => align === 'left' ? 'right' : align === 'right' ? 'left' : align;
const offsetFromEdge = (scale, edge, offset) => edge === 'top' || edge === 'left' ? scale[edge] + offset : scale[edge] - offset;
const getTicksLimit = (ticksLength, maxTicksLimit) => Math.min(maxTicksLimit || ticksLength, ticksLength);
function sample(arr, numItems) {
  const result = [];
  const increment = arr.length / numItems;
  const len = arr.length;
  let i = 0;
  for (; i < len; i += increment) {
    result.push(arr[Math.floor(i)]);
  }
  return result;
}
function getPixelForGridLine(scale, index, offsetGridLines) {
  const length = scale.ticks.length;
  const validIndex = Math.min(index, length - 1);
  const start = scale._startPixel;
  const end = scale._endPixel;
  const epsilon = 1e-6;
  let lineValue = scale.getPixelForTick(validIndex);
  let offset;
  if (offsetGridLines) {
    if (length === 1) {
      offset = Math.max(lineValue - start, end - lineValue);
    } else if (index === 0) {
      offset = (scale.getPixelForTick(1) - lineValue) / 2;
    } else {
      offset = (lineValue - scale.getPixelForTick(validIndex - 1)) / 2;
    }
    lineValue += validIndex < index ? offset : -offset;
    if (lineValue < start - epsilon || lineValue > end + epsilon) {
      return;
    }
  }
  return lineValue;
}
function garbageCollect(caches, length) {
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(caches, cache => {
    const gc = cache.gc;
    const gcLen = gc.length / 2;
    let i;
    if (gcLen > length) {
      for (i = 0; i < gcLen; ++i) {
        delete cache.data[gc[i]];
      }
      gc.splice(0, gcLen);
    }
  });
}
function getTickMarkLength(options) {
  return options.drawTicks ? options.tickLength : 0;
}
function getTitleHeight(options, fallback) {
  if (!options.display) {
    return 0;
  }
  const font = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.font, fallback);
  const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);
  const lines = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(options.text) ? options.text.length : 1;
  return lines * font.lineHeight + padding.height;
}
function createScaleContext(parent, scale) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {
    scale,
    type: 'scale'
  });
}
function createTickContext(parent, index, tick) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {
    tick,
    index,
    type: 'tick'
  });
}
function titleAlign(align, position, reverse) {
  let ret = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a1)(align);
  if (reverse && position !== 'right' || !reverse && position === 'right') {
    ret = reverseAlign(ret);
  }
  return ret;
}
function titleArgs(scale, offset, position, align) {
  const {
    top,
    left,
    bottom,
    right,
    chart
  } = scale;
  const {
    chartArea,
    scales
  } = chart;
  let rotation = 0;
  let maxWidth, titleX, titleY;
  const height = bottom - top;
  const width = right - left;
  if (scale.isHorizontal()) {
    titleX = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, left, right);
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
      const positionAxisID = Object.keys(position)[0];
      const value = position[positionAxisID];
      titleY = scales[positionAxisID].getPixelForValue(value) + height - offset;
    } else if (position === 'center') {
      titleY = (chartArea.bottom + chartArea.top) / 2 + height - offset;
    } else {
      titleY = offsetFromEdge(scale, position, offset);
    }
    maxWidth = right - left;
  } else {
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
      const positionAxisID = Object.keys(position)[0];
      const value = position[positionAxisID];
      titleX = scales[positionAxisID].getPixelForValue(value) - width + offset;
    } else if (position === 'center') {
      titleX = (chartArea.left + chartArea.right) / 2 - width + offset;
    } else {
      titleX = offsetFromEdge(scale, position, offset);
    }
    titleY = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, bottom, top);
    rotation = position === 'left' ? -_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H : _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H;
  }
  return {
    titleX,
    titleY,
    maxWidth,
    rotation
  };
}
class Scale extends Element {
  constructor(cfg) {
    super();
    this.id = cfg.id;
    this.type = cfg.type;
    this.options = undefined;
    this.ctx = cfg.ctx;
    this.chart = cfg.chart;
    this.top = undefined;
    this.bottom = undefined;
    this.left = undefined;
    this.right = undefined;
    this.width = undefined;
    this.height = undefined;
    this._margins = {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    };
    this.maxWidth = undefined;
    this.maxHeight = undefined;
    this.paddingTop = undefined;
    this.paddingBottom = undefined;
    this.paddingLeft = undefined;
    this.paddingRight = undefined;
    this.axis = undefined;
    this.labelRotation = undefined;
    this.min = undefined;
    this.max = undefined;
    this._range = undefined;
    this.ticks = [];
    this._gridLineItems = null;
    this._labelItems = null;
    this._labelSizes = null;
    this._length = 0;
    this._maxLength = 0;
    this._longestTextCache = {};
    this._startPixel = undefined;
    this._endPixel = undefined;
    this._reversePixels = false;
    this._userMax = undefined;
    this._userMin = undefined;
    this._suggestedMax = undefined;
    this._suggestedMin = undefined;
    this._ticksLength = 0;
    this._borderValue = 0;
    this._cache = {};
    this._dataLimitsCached = false;
    this.$context = undefined;
  }
  init(options) {
    this.options = options.setContext(this.getContext());
    this.axis = options.axis;
    this._userMin = this.parse(options.min);
    this._userMax = this.parse(options.max);
    this._suggestedMin = this.parse(options.suggestedMin);
    this._suggestedMax = this.parse(options.suggestedMax);
  }
  parse(raw, index) {
    return raw;
  }
  getUserBounds() {
    let {
      _userMin,
      _userMax,
      _suggestedMin,
      _suggestedMax
    } = this;
    _userMin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMin, Number.POSITIVE_INFINITY);
    _userMax = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMax, Number.NEGATIVE_INFINITY);
    _suggestedMin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(_suggestedMin, Number.POSITIVE_INFINITY);
    _suggestedMax = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(_suggestedMax, Number.NEGATIVE_INFINITY);
    return {
      min: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMin, _suggestedMin),
      max: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(_userMax, _suggestedMax),
      minDefined: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(_userMin),
      maxDefined: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(_userMax)
    };
  }
  getMinMax(canStack) {
    let {
      min,
      max,
      minDefined,
      maxDefined
    } = this.getUserBounds();
    let range;
    if (minDefined && maxDefined) {
      return {
        min,
        max
      };
    }
    const metas = this.getMatchingVisibleMetas();
    for (let i = 0, ilen = metas.length; i < ilen; ++i) {
      range = metas[i].controller.getMinMax(this, canStack);
      if (!minDefined) {
        min = Math.min(min, range.min);
      }
      if (!maxDefined) {
        max = Math.max(max, range.max);
      }
    }
    min = maxDefined && min > max ? max : min;
    max = minDefined && min > max ? min : max;
    return {
      min: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(min, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(max, min)),
      max: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(max, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(min, max))
    };
  }
  getPadding() {
    return {
      left: this.paddingLeft || 0,
      top: this.paddingTop || 0,
      right: this.paddingRight || 0,
      bottom: this.paddingBottom || 0
    };
  }
  getTicks() {
    return this.ticks;
  }
  getLabels() {
    const data = this.chart.data;
    return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels || [];
  }
  getLabelItems(chartArea = this.chart.chartArea) {
    const items = this._labelItems || (this._labelItems = this._computeLabelItems(chartArea));
    return items;
  }
  beforeLayout() {
    this._cache = {};
    this._dataLimitsCached = false;
  }
  beforeUpdate() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeUpdate, [this]);
  }
  update(maxWidth, maxHeight, margins) {
    const {
      beginAtZero,
      grace,
      ticks: tickOpts
    } = this.options;
    const sampleSize = tickOpts.sampleSize;
    this.beforeUpdate();
    this.maxWidth = maxWidth;
    this.maxHeight = maxHeight;
    this._margins = margins = Object.assign({
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    }, margins);
    this.ticks = null;
    this._labelSizes = null;
    this._gridLineItems = null;
    this._labelItems = null;
    this.beforeSetDimensions();
    this.setDimensions();
    this.afterSetDimensions();
    this._maxLength = this.isHorizontal() ? this.width + margins.left + margins.right : this.height + margins.top + margins.bottom;
    if (!this._dataLimitsCached) {
      this.beforeDataLimits();
      this.determineDataLimits();
      this.afterDataLimits();
      this._range = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.R)(this, grace, beginAtZero);
      this._dataLimitsCached = true;
    }
    this.beforeBuildTicks();
    this.ticks = this.buildTicks() || [];
    this.afterBuildTicks();
    const samplingEnabled = sampleSize < this.ticks.length;
    this._convertTicksToLabels(samplingEnabled ? sample(this.ticks, sampleSize) : this.ticks);
    this.configure();
    this.beforeCalculateLabelRotation();
    this.calculateLabelRotation();
    this.afterCalculateLabelRotation();
    if (tickOpts.display && (tickOpts.autoSkip || tickOpts.source === 'auto')) {
      this.ticks = autoSkip(this, this.ticks);
      this._labelSizes = null;
      this.afterAutoSkip();
    }
    if (samplingEnabled) {
      this._convertTicksToLabels(this.ticks);
    }
    this.beforeFit();
    this.fit();
    this.afterFit();
    this.afterUpdate();
  }
  configure() {
    let reversePixels = this.options.reverse;
    let startPixel, endPixel;
    if (this.isHorizontal()) {
      startPixel = this.left;
      endPixel = this.right;
    } else {
      startPixel = this.top;
      endPixel = this.bottom;
      reversePixels = !reversePixels;
    }
    this._startPixel = startPixel;
    this._endPixel = endPixel;
    this._reversePixels = reversePixels;
    this._length = endPixel - startPixel;
    this._alignToPixels = this.options.alignToPixels;
  }
  afterUpdate() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterUpdate, [this]);
  }
  beforeSetDimensions() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeSetDimensions, [this]);
  }
  setDimensions() {
    if (this.isHorizontal()) {
      this.width = this.maxWidth;
      this.left = 0;
      this.right = this.width;
    } else {
      this.height = this.maxHeight;
      this.top = 0;
      this.bottom = this.height;
    }
    this.paddingLeft = 0;
    this.paddingTop = 0;
    this.paddingRight = 0;
    this.paddingBottom = 0;
  }
  afterSetDimensions() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterSetDimensions, [this]);
  }
  _callHooks(name) {
    this.chart.notifyPlugins(name, this.getContext());
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options[name], [this]);
  }
  beforeDataLimits() {
    this._callHooks('beforeDataLimits');
  }
  determineDataLimits() {}
  afterDataLimits() {
    this._callHooks('afterDataLimits');
  }
  beforeBuildTicks() {
    this._callHooks('beforeBuildTicks');
  }
  buildTicks() {
    return [];
  }
  afterBuildTicks() {
    this._callHooks('afterBuildTicks');
  }
  beforeTickToLabelConversion() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeTickToLabelConversion, [this]);
  }
  generateTickLabels(ticks) {
    const tickOpts = this.options.ticks;
    let i, ilen, tick;
    for (i = 0, ilen = ticks.length; i < ilen; i++) {
      tick = ticks[i];
      tick.label = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(tickOpts.callback, [tick.value, i, ticks], this);
    }
  }
  afterTickToLabelConversion() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterTickToLabelConversion, [this]);
  }
  beforeCalculateLabelRotation() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeCalculateLabelRotation, [this]);
  }
  calculateLabelRotation() {
    const options = this.options;
    const tickOpts = options.ticks;
    const numTicks = getTicksLimit(this.ticks.length, options.ticks.maxTicksLimit);
    const minRotation = tickOpts.minRotation || 0;
    const maxRotation = tickOpts.maxRotation;
    let labelRotation = minRotation;
    let tickWidth, maxHeight, maxLabelDiagonal;
    if (!this._isVisible() || !tickOpts.display || minRotation >= maxRotation || numTicks <= 1 || !this.isHorizontal()) {
      this.labelRotation = minRotation;
      return;
    }
    const labelSizes = this._getLabelSizes();
    const maxLabelWidth = labelSizes.widest.width;
    const maxLabelHeight = labelSizes.highest.height;
    const maxWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(this.chart.width - maxLabelWidth, 0, this.maxWidth);
    tickWidth = options.offset ? this.maxWidth / numTicks : maxWidth / (numTicks - 1);
    if (maxLabelWidth + 6 > tickWidth) {
      tickWidth = maxWidth / (numTicks - (options.offset ? 0.5 : 1));
      maxHeight = this.maxHeight - getTickMarkLength(options.grid) - tickOpts.padding - getTitleHeight(options.title, this.chart.options.font);
      maxLabelDiagonal = Math.sqrt(maxLabelWidth * maxLabelWidth + maxLabelHeight * maxLabelHeight);
      labelRotation = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)(Math.min(Math.asin((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)((labelSizes.highest.height + 6) / tickWidth, -1, 1)), Math.asin((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(maxHeight / maxLabelDiagonal, -1, 1)) - Math.asin((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(maxLabelHeight / maxLabelDiagonal, -1, 1))));
      labelRotation = Math.max(minRotation, Math.min(maxRotation, labelRotation));
    }
    this.labelRotation = labelRotation;
  }
  afterCalculateLabelRotation() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterCalculateLabelRotation, [this]);
  }
  afterAutoSkip() {}
  beforeFit() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.beforeFit, [this]);
  }
  fit() {
    const minSize = {
      width: 0,
      height: 0
    };
    const {
      chart,
      options: {
        ticks: tickOpts,
        title: titleOpts,
        grid: gridOpts
      }
    } = this;
    const display = this._isVisible();
    const isHorizontal = this.isHorizontal();
    if (display) {
      const titleHeight = getTitleHeight(titleOpts, chart.options.font);
      if (isHorizontal) {
        minSize.width = this.maxWidth;
        minSize.height = getTickMarkLength(gridOpts) + titleHeight;
      } else {
        minSize.height = this.maxHeight;
        minSize.width = getTickMarkLength(gridOpts) + titleHeight;
      }
      if (tickOpts.display && this.ticks.length) {
        const {
          first,
          last,
          widest,
          highest
        } = this._getLabelSizes();
        const tickPadding = tickOpts.padding * 2;
        const angleRadians = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);
        const cos = Math.cos(angleRadians);
        const sin = Math.sin(angleRadians);
        if (isHorizontal) {
          const labelHeight = tickOpts.mirror ? 0 : sin * widest.width + cos * highest.height;
          minSize.height = Math.min(this.maxHeight, minSize.height + labelHeight + tickPadding);
        } else {
          const labelWidth = tickOpts.mirror ? 0 : cos * widest.width + sin * highest.height;
          minSize.width = Math.min(this.maxWidth, minSize.width + labelWidth + tickPadding);
        }
        this._calculatePadding(first, last, sin, cos);
      }
    }
    this._handleMargins();
    if (isHorizontal) {
      this.width = this._length = chart.width - this._margins.left - this._margins.right;
      this.height = minSize.height;
    } else {
      this.width = minSize.width;
      this.height = this._length = chart.height - this._margins.top - this._margins.bottom;
    }
  }
  _calculatePadding(first, last, sin, cos) {
    const {
      ticks: {
        align,
        padding
      },
      position
    } = this.options;
    const isRotated = this.labelRotation !== 0;
    const labelsBelowTicks = position !== 'top' && this.axis === 'x';
    if (this.isHorizontal()) {
      const offsetLeft = this.getPixelForTick(0) - this.left;
      const offsetRight = this.right - this.getPixelForTick(this.ticks.length - 1);
      let paddingLeft = 0;
      let paddingRight = 0;
      if (isRotated) {
        if (labelsBelowTicks) {
          paddingLeft = cos * first.width;
          paddingRight = sin * last.height;
        } else {
          paddingLeft = sin * first.height;
          paddingRight = cos * last.width;
        }
      } else if (align === 'start') {
        paddingRight = last.width;
      } else if (align === 'end') {
        paddingLeft = first.width;
      } else if (align !== 'inner') {
        paddingLeft = first.width / 2;
        paddingRight = last.width / 2;
      }
      this.paddingLeft = Math.max((paddingLeft - offsetLeft + padding) * this.width / (this.width - offsetLeft), 0);
      this.paddingRight = Math.max((paddingRight - offsetRight + padding) * this.width / (this.width - offsetRight), 0);
    } else {
      let paddingTop = last.height / 2;
      let paddingBottom = first.height / 2;
      if (align === 'start') {
        paddingTop = 0;
        paddingBottom = first.height;
      } else if (align === 'end') {
        paddingTop = last.height;
        paddingBottom = 0;
      }
      this.paddingTop = paddingTop + padding;
      this.paddingBottom = paddingBottom + padding;
    }
  }
  _handleMargins() {
    if (this._margins) {
      this._margins.left = Math.max(this.paddingLeft, this._margins.left);
      this._margins.top = Math.max(this.paddingTop, this._margins.top);
      this._margins.right = Math.max(this.paddingRight, this._margins.right);
      this._margins.bottom = Math.max(this.paddingBottom, this._margins.bottom);
    }
  }
  afterFit() {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.afterFit, [this]);
  }
  isHorizontal() {
    const {
      axis,
      position
    } = this.options;
    return position === 'top' || position === 'bottom' || axis === 'x';
  }
  isFullSize() {
    return this.options.fullSize;
  }
  _convertTicksToLabels(ticks) {
    this.beforeTickToLabelConversion();
    this.generateTickLabels(ticks);
    let i, ilen;
    for (i = 0, ilen = ticks.length; i < ilen; i++) {
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(ticks[i].label)) {
        ticks.splice(i, 1);
        ilen--;
        i--;
      }
    }
    this.afterTickToLabelConversion();
  }
  _getLabelSizes() {
    let labelSizes = this._labelSizes;
    if (!labelSizes) {
      const sampleSize = this.options.ticks.sampleSize;
      let ticks = this.ticks;
      if (sampleSize < ticks.length) {
        ticks = sample(ticks, sampleSize);
      }
      this._labelSizes = labelSizes = this._computeLabelSizes(ticks, ticks.length, this.options.ticks.maxTicksLimit);
    }
    return labelSizes;
  }
  _computeLabelSizes(ticks, length, maxTicksLimit) {
    const {
      ctx,
      _longestTextCache: caches
    } = this;
    const widths = [];
    const heights = [];
    const increment = Math.floor(length / getTicksLimit(length, maxTicksLimit));
    let widestLabelSize = 0;
    let highestLabelSize = 0;
    let i, j, jlen, label, tickFont, fontString, cache, lineHeight, width, height, nestedLabel;
    for (i = 0; i < length; i += increment) {
      label = ticks[i].label;
      tickFont = this._resolveTickFontOptions(i);
      ctx.font = fontString = tickFont.string;
      cache = caches[fontString] = caches[fontString] || {
        data: {},
        gc: []
      };
      lineHeight = tickFont.lineHeight;
      width = height = 0;
      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(label) && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label)) {
        width = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, cache.data, cache.gc, width, label);
        height = lineHeight;
      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label)) {
        for (j = 0, jlen = label.length; j < jlen; ++j) {
          nestedLabel = label[j];
          if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(nestedLabel) && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(nestedLabel)) {
            width = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.V)(ctx, cache.data, cache.gc, width, nestedLabel);
            height += lineHeight;
          }
        }
      }
      widths.push(width);
      heights.push(height);
      widestLabelSize = Math.max(width, widestLabelSize);
      highestLabelSize = Math.max(height, highestLabelSize);
    }
    garbageCollect(caches, length);
    const widest = widths.indexOf(widestLabelSize);
    const highest = heights.indexOf(highestLabelSize);
    const valueAt = idx => ({
      width: widths[idx] || 0,
      height: heights[idx] || 0
    });
    return {
      first: valueAt(0),
      last: valueAt(length - 1),
      widest: valueAt(widest),
      highest: valueAt(highest),
      widths,
      heights
    };
  }
  getLabelForValue(value) {
    return value;
  }
  getPixelForValue(value, index) {
    return NaN;
  }
  getValueForPixel(pixel) {}
  getPixelForTick(index) {
    const ticks = this.ticks;
    if (index < 0 || index > ticks.length - 1) {
      return null;
    }
    return this.getPixelForValue(ticks[index].value);
  }
  getPixelForDecimal(decimal) {
    if (this._reversePixels) {
      decimal = 1 - decimal;
    }
    const pixel = this._startPixel + decimal * this._length;
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.W)(this._alignToPixels ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(this.chart, pixel, 0) : pixel);
  }
  getDecimalForPixel(pixel) {
    const decimal = (pixel - this._startPixel) / this._length;
    return this._reversePixels ? 1 - decimal : decimal;
  }
  getBasePixel() {
    return this.getPixelForValue(this.getBaseValue());
  }
  getBaseValue() {
    const {
      min,
      max
    } = this;
    return min < 0 && max < 0 ? max : min > 0 && max > 0 ? min : 0;
  }
  getContext(index) {
    const ticks = this.ticks || [];
    if (index >= 0 && index < ticks.length) {
      const tick = ticks[index];
      return tick.$context || (tick.$context = createTickContext(this.getContext(), index, tick));
    }
    return this.$context || (this.$context = createScaleContext(this.chart.getContext(), this));
  }
  _tickSize() {
    const optionTicks = this.options.ticks;
    const rot = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);
    const cos = Math.abs(Math.cos(rot));
    const sin = Math.abs(Math.sin(rot));
    const labelSizes = this._getLabelSizes();
    const padding = optionTicks.autoSkipPadding || 0;
    const w = labelSizes ? labelSizes.widest.width + padding : 0;
    const h = labelSizes ? labelSizes.highest.height + padding : 0;
    return this.isHorizontal() ? h * cos > w * sin ? w / cos : h / sin : h * sin < w * cos ? h / cos : w / sin;
  }
  _isVisible() {
    const display = this.options.display;
    if (display !== 'auto') {
      return !!display;
    }
    return this.getMatchingVisibleMetas().length > 0;
  }
  _computeGridLineItems(chartArea) {
    const axis = this.axis;
    const chart = this.chart;
    const options = this.options;
    const {
      grid,
      position,
      border
    } = options;
    const offset = grid.offset;
    const isHorizontal = this.isHorizontal();
    const ticks = this.ticks;
    const ticksLength = ticks.length + (offset ? 1 : 0);
    const tl = getTickMarkLength(grid);
    const items = [];
    const borderOpts = border.setContext(this.getContext());
    const axisWidth = borderOpts.display ? borderOpts.width : 0;
    const axisHalfWidth = axisWidth / 2;
    const alignBorderValue = function (pixel) {
      return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, pixel, axisWidth);
    };
    let borderValue, i, lineValue, alignedLineValue;
    let tx1, ty1, tx2, ty2, x1, y1, x2, y2;
    if (position === 'top') {
      borderValue = alignBorderValue(this.bottom);
      ty1 = this.bottom - tl;
      ty2 = borderValue - axisHalfWidth;
      y1 = alignBorderValue(chartArea.top) + axisHalfWidth;
      y2 = chartArea.bottom;
    } else if (position === 'bottom') {
      borderValue = alignBorderValue(this.top);
      y1 = chartArea.top;
      y2 = alignBorderValue(chartArea.bottom) - axisHalfWidth;
      ty1 = borderValue + axisHalfWidth;
      ty2 = this.top + tl;
    } else if (position === 'left') {
      borderValue = alignBorderValue(this.right);
      tx1 = this.right - tl;
      tx2 = borderValue - axisHalfWidth;
      x1 = alignBorderValue(chartArea.left) + axisHalfWidth;
      x2 = chartArea.right;
    } else if (position === 'right') {
      borderValue = alignBorderValue(this.left);
      x1 = chartArea.left;
      x2 = alignBorderValue(chartArea.right) - axisHalfWidth;
      tx1 = borderValue + axisHalfWidth;
      tx2 = this.left + tl;
    } else if (axis === 'x') {
      if (position === 'center') {
        borderValue = alignBorderValue((chartArea.top + chartArea.bottom) / 2 + 0.5);
      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        borderValue = alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value));
      }
      y1 = chartArea.top;
      y2 = chartArea.bottom;
      ty1 = borderValue + axisHalfWidth;
      ty2 = ty1 + tl;
    } else if (axis === 'y') {
      if (position === 'center') {
        borderValue = alignBorderValue((chartArea.left + chartArea.right) / 2);
      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        borderValue = alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value));
      }
      tx1 = borderValue - axisHalfWidth;
      tx2 = tx1 - tl;
      x1 = chartArea.left;
      x2 = chartArea.right;
    }
    const limit = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.ticks.maxTicksLimit, ticksLength);
    const step = Math.max(1, Math.ceil(ticksLength / limit));
    for (i = 0; i < ticksLength; i += step) {
      const context = this.getContext(i);
      const optsAtIndex = grid.setContext(context);
      const optsAtIndexBorder = border.setContext(context);
      const lineWidth = optsAtIndex.lineWidth;
      const lineColor = optsAtIndex.color;
      const borderDash = optsAtIndexBorder.dash || [];
      const borderDashOffset = optsAtIndexBorder.dashOffset;
      const tickWidth = optsAtIndex.tickWidth;
      const tickColor = optsAtIndex.tickColor;
      const tickBorderDash = optsAtIndex.tickBorderDash || [];
      const tickBorderDashOffset = optsAtIndex.tickBorderDashOffset;
      lineValue = getPixelForGridLine(this, i, offset);
      if (lineValue === undefined) {
        continue;
      }
      alignedLineValue = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, lineValue, lineWidth);
      if (isHorizontal) {
        tx1 = tx2 = x1 = x2 = alignedLineValue;
      } else {
        ty1 = ty2 = y1 = y2 = alignedLineValue;
      }
      items.push({
        tx1,
        ty1,
        tx2,
        ty2,
        x1,
        y1,
        x2,
        y2,
        width: lineWidth,
        color: lineColor,
        borderDash,
        borderDashOffset,
        tickWidth,
        tickColor,
        tickBorderDash,
        tickBorderDashOffset
      });
    }
    this._ticksLength = ticksLength;
    this._borderValue = borderValue;
    return items;
  }
  _computeLabelItems(chartArea) {
    const axis = this.axis;
    const options = this.options;
    const {
      position,
      ticks: optionTicks
    } = options;
    const isHorizontal = this.isHorizontal();
    const ticks = this.ticks;
    const {
      align,
      crossAlign,
      padding,
      mirror
    } = optionTicks;
    const tl = getTickMarkLength(options.grid);
    const tickAndPadding = tl + padding;
    const hTickAndPadding = mirror ? -padding : tickAndPadding;
    const rotation = -(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);
    const items = [];
    let i, ilen, tick, label, x, y, textAlign, pixel, font, lineHeight, lineCount, textOffset;
    let textBaseline = 'middle';
    if (position === 'top') {
      y = this.bottom - hTickAndPadding;
      textAlign = this._getXAxisLabelAlignment();
    } else if (position === 'bottom') {
      y = this.top + hTickAndPadding;
      textAlign = this._getXAxisLabelAlignment();
    } else if (position === 'left') {
      const ret = this._getYAxisLabelAlignment(tl);
      textAlign = ret.textAlign;
      x = ret.x;
    } else if (position === 'right') {
      const ret = this._getYAxisLabelAlignment(tl);
      textAlign = ret.textAlign;
      x = ret.x;
    } else if (axis === 'x') {
      if (position === 'center') {
        y = (chartArea.top + chartArea.bottom) / 2 + tickAndPadding;
      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        y = this.chart.scales[positionAxisID].getPixelForValue(value) + tickAndPadding;
      }
      textAlign = this._getXAxisLabelAlignment();
    } else if (axis === 'y') {
      if (position === 'center') {
        x = (chartArea.left + chartArea.right) / 2 - tickAndPadding;
      } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        x = this.chart.scales[positionAxisID].getPixelForValue(value);
      }
      textAlign = this._getYAxisLabelAlignment(tl).textAlign;
    }
    if (axis === 'y') {
      if (align === 'start') {
        textBaseline = 'top';
      } else if (align === 'end') {
        textBaseline = 'bottom';
      }
    }
    const labelSizes = this._getLabelSizes();
    for (i = 0, ilen = ticks.length; i < ilen; ++i) {
      tick = ticks[i];
      label = tick.label;
      const optsAtIndex = optionTicks.setContext(this.getContext(i));
      pixel = this.getPixelForTick(i) + optionTicks.labelOffset;
      font = this._resolveTickFontOptions(i);
      lineHeight = font.lineHeight;
      lineCount = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label) ? label.length : 1;
      const halfCount = lineCount / 2;
      const color = optsAtIndex.color;
      const strokeColor = optsAtIndex.textStrokeColor;
      const strokeWidth = optsAtIndex.textStrokeWidth;
      let tickTextAlign = textAlign;
      if (isHorizontal) {
        x = pixel;
        if (textAlign === 'inner') {
          if (i === ilen - 1) {
            tickTextAlign = !this.options.reverse ? 'right' : 'left';
          } else if (i === 0) {
            tickTextAlign = !this.options.reverse ? 'left' : 'right';
          } else {
            tickTextAlign = 'center';
          }
        }
        if (position === 'top') {
          if (crossAlign === 'near' || rotation !== 0) {
            textOffset = -lineCount * lineHeight + lineHeight / 2;
          } else if (crossAlign === 'center') {
            textOffset = -labelSizes.highest.height / 2 - halfCount * lineHeight + lineHeight;
          } else {
            textOffset = -labelSizes.highest.height + lineHeight / 2;
          }
        } else {
          if (crossAlign === 'near' || rotation !== 0) {
            textOffset = lineHeight / 2;
          } else if (crossAlign === 'center') {
            textOffset = labelSizes.highest.height / 2 - halfCount * lineHeight;
          } else {
            textOffset = labelSizes.highest.height - lineCount * lineHeight;
          }
        }
        if (mirror) {
          textOffset *= -1;
        }
        if (rotation !== 0 && !optsAtIndex.showLabelBackdrop) {
          x += lineHeight / 2 * Math.sin(rotation);
        }
      } else {
        y = pixel;
        textOffset = (1 - lineCount) * lineHeight / 2;
      }
      let backdrop;
      if (optsAtIndex.showLabelBackdrop) {
        const labelPadding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(optsAtIndex.backdropPadding);
        const height = labelSizes.heights[i];
        const width = labelSizes.widths[i];
        let top = textOffset - labelPadding.top;
        let left = 0 - labelPadding.left;
        switch (textBaseline) {
          case 'middle':
            top -= height / 2;
            break;
          case 'bottom':
            top -= height;
            break;
        }
        switch (textAlign) {
          case 'center':
            left -= width / 2;
            break;
          case 'right':
            left -= width;
            break;
          case 'inner':
            if (i === ilen - 1) {
              left -= width;
            } else if (i > 0) {
              left -= width / 2;
            }
            break;
        }
        backdrop = {
          left,
          top,
          width: width + labelPadding.width,
          height: height + labelPadding.height,
          color: optsAtIndex.backdropColor
        };
      }
      items.push({
        label,
        font,
        textOffset,
        options: {
          rotation,
          color,
          strokeColor,
          strokeWidth,
          textAlign: tickTextAlign,
          textBaseline,
          translation: [x, y],
          backdrop
        }
      });
    }
    return items;
  }
  _getXAxisLabelAlignment() {
    const {
      position,
      ticks
    } = this.options;
    const rotation = -(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.labelRotation);
    if (rotation) {
      return position === 'top' ? 'left' : 'right';
    }
    let align = 'center';
    if (ticks.align === 'start') {
      align = 'left';
    } else if (ticks.align === 'end') {
      align = 'right';
    } else if (ticks.align === 'inner') {
      align = 'inner';
    }
    return align;
  }
  _getYAxisLabelAlignment(tl) {
    const {
      position,
      ticks: {
        crossAlign,
        mirror,
        padding
      }
    } = this.options;
    const labelSizes = this._getLabelSizes();
    const tickAndPadding = tl + padding;
    const widest = labelSizes.widest.width;
    let textAlign;
    let x;
    if (position === 'left') {
      if (mirror) {
        x = this.right + padding;
        if (crossAlign === 'near') {
          textAlign = 'left';
        } else if (crossAlign === 'center') {
          textAlign = 'center';
          x += widest / 2;
        } else {
          textAlign = 'right';
          x += widest;
        }
      } else {
        x = this.right - tickAndPadding;
        if (crossAlign === 'near') {
          textAlign = 'right';
        } else if (crossAlign === 'center') {
          textAlign = 'center';
          x -= widest / 2;
        } else {
          textAlign = 'left';
          x = this.left;
        }
      }
    } else if (position === 'right') {
      if (mirror) {
        x = this.left + padding;
        if (crossAlign === 'near') {
          textAlign = 'right';
        } else if (crossAlign === 'center') {
          textAlign = 'center';
          x -= widest / 2;
        } else {
          textAlign = 'left';
          x -= widest;
        }
      } else {
        x = this.left + tickAndPadding;
        if (crossAlign === 'near') {
          textAlign = 'left';
        } else if (crossAlign === 'center') {
          textAlign = 'center';
          x += widest / 2;
        } else {
          textAlign = 'right';
          x = this.right;
        }
      }
    } else {
      textAlign = 'right';
    }
    return {
      textAlign,
      x
    };
  }
  _computeLabelArea() {
    if (this.options.ticks.mirror) {
      return;
    }
    const chart = this.chart;
    const position = this.options.position;
    if (position === 'left' || position === 'right') {
      return {
        top: 0,
        left: this.left,
        bottom: chart.height,
        right: this.right
      };
    }
    if (position === 'top' || position === 'bottom') {
      return {
        top: this.top,
        left: 0,
        bottom: this.bottom,
        right: chart.width
      };
    }
  }
  drawBackground() {
    const {
      ctx,
      options: {
        backgroundColor
      },
      left,
      top,
      width,
      height
    } = this;
    if (backgroundColor) {
      ctx.save();
      ctx.fillStyle = backgroundColor;
      ctx.fillRect(left, top, width, height);
      ctx.restore();
    }
  }
  getLineWidthForValue(value) {
    const grid = this.options.grid;
    if (!this._isVisible() || !grid.display) {
      return 0;
    }
    const ticks = this.ticks;
    const index = ticks.findIndex(t => t.value === value);
    if (index >= 0) {
      const opts = grid.setContext(this.getContext(index));
      return opts.lineWidth;
    }
    return 0;
  }
  drawGrid(chartArea) {
    const grid = this.options.grid;
    const ctx = this.ctx;
    const items = this._gridLineItems || (this._gridLineItems = this._computeGridLineItems(chartArea));
    let i, ilen;
    const drawLine = (p1, p2, style) => {
      if (!style.width || !style.color) {
        return;
      }
      ctx.save();
      ctx.lineWidth = style.width;
      ctx.strokeStyle = style.color;
      ctx.setLineDash(style.borderDash || []);
      ctx.lineDashOffset = style.borderDashOffset;
      ctx.beginPath();
      ctx.moveTo(p1.x, p1.y);
      ctx.lineTo(p2.x, p2.y);
      ctx.stroke();
      ctx.restore();
    };
    if (grid.display) {
      for (i = 0, ilen = items.length; i < ilen; ++i) {
        const item = items[i];
        if (grid.drawOnChartArea) {
          drawLine({
            x: item.x1,
            y: item.y1
          }, {
            x: item.x2,
            y: item.y2
          }, item);
        }
        if (grid.drawTicks) {
          drawLine({
            x: item.tx1,
            y: item.ty1
          }, {
            x: item.tx2,
            y: item.ty2
          }, {
            color: item.tickColor,
            width: item.tickWidth,
            borderDash: item.tickBorderDash,
            borderDashOffset: item.tickBorderDashOffset
          });
        }
      }
    }
  }
  drawBorder() {
    const {
      chart,
      ctx,
      options: {
        border,
        grid
      }
    } = this;
    const borderOpts = border.setContext(this.getContext());
    const axisWidth = border.display ? borderOpts.width : 0;
    if (!axisWidth) {
      return;
    }
    const lastLineWidth = grid.setContext(this.getContext(0)).lineWidth;
    const borderValue = this._borderValue;
    let x1, x2, y1, y2;
    if (this.isHorizontal()) {
      x1 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.left, axisWidth) - axisWidth / 2;
      x2 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.right, lastLineWidth) + lastLineWidth / 2;
      y1 = y2 = borderValue;
    } else {
      y1 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.top, axisWidth) - axisWidth / 2;
      y2 = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.X)(chart, this.bottom, lastLineWidth) + lastLineWidth / 2;
      x1 = x2 = borderValue;
    }
    ctx.save();
    ctx.lineWidth = borderOpts.width;
    ctx.strokeStyle = borderOpts.color;
    ctx.beginPath();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x2, y2);
    ctx.stroke();
    ctx.restore();
  }
  drawLabels(chartArea) {
    const optionTicks = this.options.ticks;
    if (!optionTicks.display) {
      return;
    }
    const ctx = this.ctx;
    const area = this._computeLabelArea();
    if (area) {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, area);
    }
    const items = this.getLabelItems(chartArea);
    for (const item of items) {
      const renderTextOptions = item.options;
      const tickFont = item.font;
      const label = item.label;
      const y = item.textOffset;
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, label, 0, y, tickFont, renderTextOptions);
    }
    if (area) {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);
    }
  }
  drawTitle() {
    const {
      ctx,
      options: {
        position,
        title,
        reverse
      }
    } = this;
    if (!title.display) {
      return;
    }
    const font = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(title.font);
    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(title.padding);
    const align = title.align;
    let offset = font.lineHeight / 2;
    if (position === 'bottom' || position === 'center' || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(position)) {
      offset += padding.bottom;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(title.text)) {
        offset += font.lineHeight * (title.text.length - 1);
      }
    } else {
      offset += padding.top;
    }
    const {
      titleX,
      titleY,
      maxWidth,
      rotation
    } = titleArgs(this, offset, position, align);
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, title.text, 0, 0, font, {
      color: title.color,
      maxWidth,
      rotation,
      textAlign: titleAlign(align, position, reverse),
      textBaseline: 'middle',
      translation: [titleX, titleY]
    });
  }
  draw(chartArea) {
    if (!this._isVisible()) {
      return;
    }
    this.drawBackground();
    this.drawGrid(chartArea);
    this.drawBorder();
    this.drawTitle();
    this.drawLabels(chartArea);
  }
  _layers() {
    const opts = this.options;
    const tz = opts.ticks && opts.ticks.z || 0;
    const gz = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(opts.grid && opts.grid.z, -1);
    const bz = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(opts.border && opts.border.z, 0);
    if (!this._isVisible() || this.draw !== Scale.prototype.draw) {
      return [{
        z: tz,
        draw: chartArea => {
          this.draw(chartArea);
        }
      }];
    }
    return [{
      z: gz,
      draw: chartArea => {
        this.drawBackground();
        this.drawGrid(chartArea);
        this.drawTitle();
      }
    }, {
      z: bz,
      draw: () => {
        this.drawBorder();
      }
    }, {
      z: tz,
      draw: chartArea => {
        this.drawLabels(chartArea);
      }
    }];
  }
  getMatchingVisibleMetas(type) {
    const metas = this.chart.getSortedVisibleDatasetMetas();
    const axisID = this.axis + 'AxisID';
    const result = [];
    let i, ilen;
    for (i = 0, ilen = metas.length; i < ilen; ++i) {
      const meta = metas[i];
      if (meta[axisID] === this.id && (!type || meta.type === type)) {
        result.push(meta);
      }
    }
    return result;
  }
  _resolveTickFontOptions(index) {
    const opts = this.options.ticks.setContext(this.getContext(index));
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font);
  }
  _maxDigits() {
    const fontSize = this._resolveTickFontOptions(0).lineHeight;
    return (this.isHorizontal() ? this.width : this.height) / fontSize;
  }
}
class TypedRegistry {
  constructor(type, scope, override) {
    this.type = type;
    this.scope = scope;
    this.override = override;
    this.items = Object.create(null);
  }
  isForType(type) {
    return Object.prototype.isPrototypeOf.call(this.type.prototype, type.prototype);
  }
  register(item) {
    const proto = Object.getPrototypeOf(item);
    let parentScope;
    if (isIChartComponent(proto)) {
      parentScope = this.register(proto);
    }
    const items = this.items;
    const id = item.id;
    const scope = this.scope + '.' + id;
    if (!id) {
      throw new Error('class does not have id: ' + item);
    }
    if (id in items) {
      return scope;
    }
    items[id] = item;
    registerDefaults(item, scope, parentScope);
    if (this.override) {
      _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.override(item.id, item.overrides);
    }
    return scope;
  }
  get(id) {
    return this.items[id];
  }
  unregister(item) {
    const items = this.items;
    const id = item.id;
    const scope = this.scope;
    if (id in items) {
      delete items[id];
    }
    if (scope && id in _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d[scope]) {
      delete _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d[scope][id];
      if (this.override) {
        delete _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3[id];
      }
    }
  }
}
function registerDefaults(item, scope, parentScope) {
  const itemDefaults = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a4)(Object.create(null), [parentScope ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.get(parentScope) : {}, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.get(scope), item.defaults]);
  _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.set(scope, itemDefaults);
  if (item.defaultRoutes) {
    routeDefaults(scope, item.defaultRoutes);
  }
  if (item.descriptors) {
    _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.describe(scope, item.descriptors);
  }
}
function routeDefaults(scope, routes) {
  Object.keys(routes).forEach(property => {
    const propertyParts = property.split('.');
    const sourceName = propertyParts.pop();
    const sourceScope = [scope].concat(propertyParts).join('.');
    const parts = routes[property].split('.');
    const targetName = parts.pop();
    const targetScope = parts.join('.');
    _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.route(sourceScope, sourceName, targetScope, targetName);
  });
}
function isIChartComponent(proto) {
  return 'id' in proto && 'defaults' in proto;
}
class Registry {
  constructor() {
    this.controllers = new TypedRegistry(DatasetController, 'datasets', true);
    this.elements = new TypedRegistry(Element, 'elements');
    this.plugins = new TypedRegistry(Object, 'plugins');
    this.scales = new TypedRegistry(Scale, 'scales');
    this._typedRegistries = [this.controllers, this.scales, this.elements];
  }
  add(...args) {
    this._each('register', args);
  }
  remove(...args) {
    this._each('unregister', args);
  }
  addControllers(...args) {
    this._each('register', args, this.controllers);
  }
  addElements(...args) {
    this._each('register', args, this.elements);
  }
  addPlugins(...args) {
    this._each('register', args, this.plugins);
  }
  addScales(...args) {
    this._each('register', args, this.scales);
  }
  getController(id) {
    return this._get(id, this.controllers, 'controller');
  }
  getElement(id) {
    return this._get(id, this.elements, 'element');
  }
  getPlugin(id) {
    return this._get(id, this.plugins, 'plugin');
  }
  getScale(id) {
    return this._get(id, this.scales, 'scale');
  }
  removeControllers(...args) {
    this._each('unregister', args, this.controllers);
  }
  removeElements(...args) {
    this._each('unregister', args, this.elements);
  }
  removePlugins(...args) {
    this._each('unregister', args, this.plugins);
  }
  removeScales(...args) {
    this._each('unregister', args, this.scales);
  }
  _each(method, args, typedRegistry) {
    [...args].forEach(arg => {
      const reg = typedRegistry || this._getRegistryForType(arg);
      if (typedRegistry || reg.isForType(arg) || reg === this.plugins && arg.id) {
        this._exec(method, reg, arg);
      } else {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(arg, item => {
          const itemReg = typedRegistry || this._getRegistryForType(item);
          this._exec(method, itemReg, item);
        });
      }
    });
  }
  _exec(method, registry, component) {
    const camelMethod = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a5)(method);
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(component['before' + camelMethod], [], component);
    registry[method](component);
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(component['after' + camelMethod], [], component);
  }
  _getRegistryForType(type) {
    for (let i = 0; i < this._typedRegistries.length; i++) {
      const reg = this._typedRegistries[i];
      if (reg.isForType(type)) {
        return reg;
      }
    }
    return this.plugins;
  }
  _get(id, typedRegistry, type) {
    const item = typedRegistry.get(id);
    if (item === undefined) {
      throw new Error('"' + id + '" is not a registered ' + type + '.');
    }
    return item;
  }
}
var registry = /* #__PURE__ */new Registry();
class PluginService {
  constructor() {
    this._init = [];
  }
  notify(chart, hook, args, filter) {
    if (hook === 'beforeInit') {
      this._init = this._createDescriptors(chart, true);
      this._notify(this._init, chart, 'install');
    }
    const descriptors = filter ? this._descriptors(chart).filter(filter) : this._descriptors(chart);
    const result = this._notify(descriptors, chart, hook, args);
    if (hook === 'afterDestroy') {
      this._notify(descriptors, chart, 'stop');
      this._notify(this._init, chart, 'uninstall');
    }
    return result;
  }
  _notify(descriptors, chart, hook, args) {
    args = args || {};
    for (const descriptor of descriptors) {
      const plugin = descriptor.plugin;
      const method = plugin[hook];
      const params = [chart, args, descriptor.options];
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(method, params, plugin) === false && args.cancelable) {
        return false;
      }
    }
    return true;
  }
  invalidate() {
    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(this._cache)) {
      this._oldCache = this._cache;
      this._cache = undefined;
    }
  }
  _descriptors(chart) {
    if (this._cache) {
      return this._cache;
    }
    const descriptors = this._cache = this._createDescriptors(chart);
    this._notifyStateChanges(chart);
    return descriptors;
  }
  _createDescriptors(chart, all) {
    const config = chart && chart.config;
    const options = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(config.options && config.options.plugins, {});
    const plugins = allPlugins(config);
    return options === false && !all ? [] : createDescriptors(chart, plugins, options, all);
  }
  _notifyStateChanges(chart) {
    const previousDescriptors = this._oldCache || [];
    const descriptors = this._cache;
    const diff = (a, b) => a.filter(x => !b.some(y => x.plugin.id === y.plugin.id));
    this._notify(diff(previousDescriptors, descriptors), chart, 'stop');
    this._notify(diff(descriptors, previousDescriptors), chart, 'start');
  }
}
function allPlugins(config) {
  const localIds = {};
  const plugins = [];
  const keys = Object.keys(registry.plugins.items);
  for (let i = 0; i < keys.length; i++) {
    plugins.push(registry.getPlugin(keys[i]));
  }
  const local = config.plugins || [];
  for (let i = 0; i < local.length; i++) {
    const plugin = local[i];
    if (plugins.indexOf(plugin) === -1) {
      plugins.push(plugin);
      localIds[plugin.id] = true;
    }
  }
  return {
    plugins,
    localIds
  };
}
function getOpts(options, all) {
  if (!all && options === false) {
    return null;
  }
  if (options === true) {
    return {};
  }
  return options;
}
function createDescriptors(chart, {
  plugins,
  localIds
}, options, all) {
  const result = [];
  const context = chart.getContext();
  for (const plugin of plugins) {
    const id = plugin.id;
    const opts = getOpts(options[id], all);
    if (opts === null) {
      continue;
    }
    result.push({
      plugin,
      options: pluginOpts(chart.config, {
        plugin,
        local: localIds[id]
      }, opts, context)
    });
  }
  return result;
}
function pluginOpts(config, {
  plugin,
  local
}, opts, context) {
  const keys = config.pluginScopeKeys(plugin);
  const scopes = config.getOptionScopes(opts, keys);
  if (local && plugin.defaults) {
    scopes.push(plugin.defaults);
  }
  return config.createResolver(scopes, context, [''], {
    scriptable: false,
    indexable: false,
    allKeys: true
  });
}
function getIndexAxis(type, options) {
  const datasetDefaults = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type] || {};
  const datasetOptions = (options.datasets || {})[type] || {};
  return datasetOptions.indexAxis || options.indexAxis || datasetDefaults.indexAxis || 'x';
}
function getAxisFromDefaultScaleID(id, indexAxis) {
  let axis = id;
  if (id === '_index_') {
    axis = indexAxis;
  } else if (id === '_value_') {
    axis = indexAxis === 'x' ? 'y' : 'x';
  }
  return axis;
}
function getDefaultScaleIDFromAxis(axis, indexAxis) {
  return axis === indexAxis ? '_index_' : '_value_';
}
function idMatchesAxis(id) {
  if (id === 'x' || id === 'y' || id === 'r') {
    return id;
  }
}
function axisFromPosition(position) {
  if (position === 'top' || position === 'bottom') {
    return 'x';
  }
  if (position === 'left' || position === 'right') {
    return 'y';
  }
}
function determineAxis(id, ...scaleOptions) {
  if (idMatchesAxis(id)) {
    return id;
  }
  for (const opts of scaleOptions) {
    const axis = opts.axis || axisFromPosition(opts.position) || id.length > 1 && idMatchesAxis(id[0].toLowerCase());
    if (axis) {
      return axis;
    }
  }
  throw new Error(`Cannot determine type of '${id}' axis. Please provide 'axis' or 'position' option.`);
}
function getAxisFromDataset(id, axis, dataset) {
  if (dataset[axis + 'AxisID'] === id) {
    return {
      axis
    };
  }
}
function retrieveAxisFromDatasets(id, config) {
  if (config.data && config.data.datasets) {
    const boundDs = config.data.datasets.filter(d => d.xAxisID === id || d.yAxisID === id);
    if (boundDs.length) {
      return getAxisFromDataset(id, 'x', boundDs[0]) || getAxisFromDataset(id, 'y', boundDs[0]);
    }
  }
  return {};
}
function mergeScaleConfig(config, options) {
  const chartDefaults = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3[config.type] || {
    scales: {}
  };
  const configScales = options.scales || {};
  const chartIndexAxis = getIndexAxis(config.type, options);
  const scales = Object.create(null);
  Object.keys(configScales).forEach(id => {
    const scaleConf = configScales[id];
    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(scaleConf)) {
      return console.error(`Invalid scale configuration for scale: ${id}`);
    }
    if (scaleConf._proxy) {
      return console.warn(`Ignoring resolver passed as options for scale: ${id}`);
    }
    const axis = determineAxis(id, scaleConf, retrieveAxisFromDatasets(id, config), _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.scales[scaleConf.type]);
    const defaultId = getDefaultScaleIDFromAxis(axis, chartIndexAxis);
    const defaultScaleOptions = chartDefaults.scales || {};
    scales[id] = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ab)(Object.create(null), [{
      axis
    }, scaleConf, defaultScaleOptions[axis], defaultScaleOptions[defaultId]]);
  });
  config.data.datasets.forEach(dataset => {
    const type = dataset.type || config.type;
    const indexAxis = dataset.indexAxis || getIndexAxis(type, options);
    const datasetDefaults = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3[type] || {};
    const defaultScaleOptions = datasetDefaults.scales || {};
    Object.keys(defaultScaleOptions).forEach(defaultID => {
      const axis = getAxisFromDefaultScaleID(defaultID, indexAxis);
      const id = dataset[axis + 'AxisID'] || axis;
      scales[id] = scales[id] || Object.create(null);
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ab)(scales[id], [{
        axis
      }, configScales[id], defaultScaleOptions[defaultID]]);
    });
  });
  Object.keys(scales).forEach(key => {
    const scale = scales[key];
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ab)(scale, [_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.scales[scale.type], _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.scale]);
  });
  return scales;
}
function initOptions(config) {
  const options = config.options || (config.options = {});
  options.plugins = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.plugins, {});
  options.scales = mergeScaleConfig(config, options);
}
function initData(data) {
  data = data || {};
  data.datasets = data.datasets || [];
  data.labels = data.labels || [];
  return data;
}
function initConfig(config) {
  config = config || {};
  config.data = initData(config.data);
  initOptions(config);
  return config;
}
const keyCache = new Map();
const keysCached = new Set();
function cachedKeys(cacheKey, generate) {
  let keys = keyCache.get(cacheKey);
  if (!keys) {
    keys = generate();
    keyCache.set(cacheKey, keys);
    keysCached.add(keys);
  }
  return keys;
}
const addIfFound = (set, obj, key) => {
  const opts = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.f)(obj, key);
  if (opts !== undefined) {
    set.add(opts);
  }
};
class Config {
  constructor(config) {
    this._config = initConfig(config);
    this._scopeCache = new Map();
    this._resolverCache = new Map();
  }
  get platform() {
    return this._config.platform;
  }
  get type() {
    return this._config.type;
  }
  set type(type) {
    this._config.type = type;
  }
  get data() {
    return this._config.data;
  }
  set data(data) {
    this._config.data = initData(data);
  }
  get options() {
    return this._config.options;
  }
  set options(options) {
    this._config.options = options;
  }
  get plugins() {
    return this._config.plugins;
  }
  update() {
    const config = this._config;
    this.clearCache();
    initOptions(config);
  }
  clearCache() {
    this._scopeCache.clear();
    this._resolverCache.clear();
  }
  datasetScopeKeys(datasetType) {
    return cachedKeys(datasetType, () => [[`datasets.${datasetType}`, '']]);
  }
  datasetAnimationScopeKeys(datasetType, transition) {
    return cachedKeys(`${datasetType}.transition.${transition}`, () => [[`datasets.${datasetType}.transitions.${transition}`, `transitions.${transition}`], [`datasets.${datasetType}`, '']]);
  }
  datasetElementScopeKeys(datasetType, elementType) {
    return cachedKeys(`${datasetType}-${elementType}`, () => [[`datasets.${datasetType}.elements.${elementType}`, `datasets.${datasetType}`, `elements.${elementType}`, '']]);
  }
  pluginScopeKeys(plugin) {
    const id = plugin.id;
    const type = this.type;
    return cachedKeys(`${type}-plugin-${id}`, () => [[`plugins.${id}`, ...(plugin.additionalOptionScopes || [])]]);
  }
  _cachedScopes(mainScope, resetCache) {
    const _scopeCache = this._scopeCache;
    let cache = _scopeCache.get(mainScope);
    if (!cache || resetCache) {
      cache = new Map();
      _scopeCache.set(mainScope, cache);
    }
    return cache;
  }
  getOptionScopes(mainScope, keyLists, resetCache) {
    const {
      options,
      type
    } = this;
    const cache = this._cachedScopes(mainScope, resetCache);
    const cached = cache.get(keyLists);
    if (cached) {
      return cached;
    }
    const scopes = new Set();
    keyLists.forEach(keys => {
      if (mainScope) {
        scopes.add(mainScope);
        keys.forEach(key => addIfFound(scopes, mainScope, key));
      }
      keys.forEach(key => addIfFound(scopes, options, key));
      keys.forEach(key => addIfFound(scopes, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3[type] || {}, key));
      keys.forEach(key => addIfFound(scopes, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d, key));
      keys.forEach(key => addIfFound(scopes, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a6, key));
    });
    const array = Array.from(scopes);
    if (array.length === 0) {
      array.push(Object.create(null));
    }
    if (keysCached.has(keyLists)) {
      cache.set(keyLists, array);
    }
    return array;
  }
  chartOptionScopes() {
    const {
      options,
      type
    } = this;
    return [options, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3[type] || {}, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type] || {}, {
      type
    }, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a6];
  }
  resolveNamedOptions(scopes, names, context, prefixes = ['']) {
    const result = {
      $shared: true
    };
    const {
      resolver,
      subPrefixes
    } = getResolver(this._resolverCache, scopes, prefixes);
    let options = resolver;
    if (needContext(resolver, names)) {
      result.$shared = false;
      context = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(context) ? context() : context;
      const subResolver = this.createResolver(scopes, context, subPrefixes);
      options = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a8)(resolver, context, subResolver);
    }
    for (const prop of names) {
      result[prop] = options[prop];
    }
    return result;
  }
  createResolver(scopes, context, prefixes = [''], descriptorDefaults) {
    const {
      resolver
    } = getResolver(this._resolverCache, scopes, prefixes);
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(context) ? (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a8)(resolver, context, undefined, descriptorDefaults) : resolver;
  }
}
function getResolver(resolverCache, scopes, prefixes) {
  let cache = resolverCache.get(scopes);
  if (!cache) {
    cache = new Map();
    resolverCache.set(scopes, cache);
  }
  const cacheKey = prefixes.join();
  let cached = cache.get(cacheKey);
  if (!cached) {
    const resolver = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a9)(scopes, prefixes);
    cached = {
      resolver,
      subPrefixes: prefixes.filter(p => !p.toLowerCase().includes('hover'))
    };
    cache.set(cacheKey, cached);
  }
  return cached;
}
const hasFunction = value => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(value) && Object.getOwnPropertyNames(value).some(key => (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(value[key]));
function needContext(proxy, names) {
  const {
    isScriptable,
    isIndexable
  } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aa)(proxy);
  for (const prop of names) {
    const scriptable = isScriptable(prop);
    const indexable = isIndexable(prop);
    const value = (indexable || scriptable) && proxy[prop];
    if (scriptable && ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(value) || hasFunction(value)) || indexable && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(value)) {
      return true;
    }
  }
  return false;
}
var version = "4.4.6";
const KNOWN_POSITIONS = ['top', 'bottom', 'left', 'right', 'chartArea'];
function positionIsHorizontal(position, axis) {
  return position === 'top' || position === 'bottom' || KNOWN_POSITIONS.indexOf(position) === -1 && axis === 'x';
}
function compare2Level(l1, l2) {
  return function (a, b) {
    return a[l1] === b[l1] ? a[l2] - b[l2] : a[l1] - b[l1];
  };
}
function onAnimationsComplete(context) {
  const chart = context.chart;
  const animationOptions = chart.options.animation;
  chart.notifyPlugins('afterRender');
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(animationOptions && animationOptions.onComplete, [context], chart);
}
function onAnimationProgress(context) {
  const chart = context.chart;
  const animationOptions = chart.options.animation;
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(animationOptions && animationOptions.onProgress, [context], chart);
}
function getCanvas(item) {
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.M)() && typeof item === 'string') {
    item = document.getElementById(item);
  } else if (item && item.length) {
    item = item[0];
  }
  if (item && item.canvas) {
    item = item.canvas;
  }
  return item;
}
const instances = {};
const getChart = key => {
  const canvas = getCanvas(key);
  return Object.values(instances).filter(c => c.canvas === canvas).pop();
};
function moveNumericKeys(obj, start, move) {
  const keys = Object.keys(obj);
  for (const key of keys) {
    const intKey = +key;
    if (intKey >= start) {
      const value = obj[key];
      delete obj[key];
      if (move > 0 || intKey > start) {
        obj[intKey + move] = value;
      }
    }
  }
}
function determineLastEvent(e, lastEvent, inChartArea, isClick) {
  if (!inChartArea || e.type === 'mouseout') {
    return null;
  }
  if (isClick) {
    return lastEvent;
  }
  return e;
}
function getSizeForArea(scale, chartArea, field) {
  return scale.options.clip ? scale[field] : chartArea[field];
}
function getDatasetArea(meta, chartArea) {
  const {
    xScale,
    yScale
  } = meta;
  if (xScale && yScale) {
    return {
      left: getSizeForArea(xScale, chartArea, 'left'),
      right: getSizeForArea(xScale, chartArea, 'right'),
      top: getSizeForArea(yScale, chartArea, 'top'),
      bottom: getSizeForArea(yScale, chartArea, 'bottom')
    };
  }
  return chartArea;
}
let Chart = /*#__PURE__*/(() => {
  class Chart {
    static defaults = (() => _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d)();
    static instances = (() => instances)();
    static overrides = (() => _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a3)();
    static registry = (() => registry)();
    static version = (() => version)();
    static getChart = (() => getChart)();
    static register(...items) {
      registry.add(...items);
      invalidatePlugins();
    }
    static unregister(...items) {
      registry.remove(...items);
      invalidatePlugins();
    }
    constructor(item, userConfig) {
      const config = this.config = new Config(userConfig);
      const initialCanvas = getCanvas(item);
      const existingChart = getChart(initialCanvas);
      if (existingChart) {
        throw new Error('Canvas is already in use. Chart with ID \'' + existingChart.id + '\'' + ' must be destroyed before the canvas with ID \'' + existingChart.canvas.id + '\' can be reused.');
      }
      const options = config.createResolver(config.chartOptionScopes(), this.getContext());
      this.platform = new (config.platform || _detectPlatform(initialCanvas))();
      this.platform.updateConfig(config);
      const context = this.platform.acquireContext(initialCanvas, options.aspectRatio);
      const canvas = context && context.canvas;
      const height = canvas && canvas.height;
      const width = canvas && canvas.width;
      this.id = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ac)();
      this.ctx = context;
      this.canvas = canvas;
      this.width = width;
      this.height = height;
      this._options = options;
      this._aspectRatio = this.aspectRatio;
      this._layers = [];
      this._metasets = [];
      this._stacks = undefined;
      this.boxes = [];
      this.currentDevicePixelRatio = undefined;
      this.chartArea = undefined;
      this._active = [];
      this._lastEvent = undefined;
      this._listeners = {};
      this._responsiveListeners = undefined;
      this._sortedMetasets = [];
      this.scales = {};
      this._plugins = new PluginService();
      this.$proxies = {};
      this._hiddenIndices = {};
      this.attached = false;
      this._animationsDisabled = undefined;
      this.$context = undefined;
      this._doResize = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ad)(mode => this.update(mode), options.resizeDelay || 0);
      this._dataChanges = [];
      instances[this.id] = this;
      if (!context || !canvas) {
        console.error("Failed to create chart: can't acquire context from the given item");
        return;
      }
      animator.listen(this, 'complete', onAnimationsComplete);
      animator.listen(this, 'progress', onAnimationProgress);
      this._initialize();
      if (this.attached) {
        this.update();
      }
    }
    get aspectRatio() {
      const {
        options: {
          aspectRatio,
          maintainAspectRatio
        },
        width,
        height,
        _aspectRatio
      } = this;
      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(aspectRatio)) {
        return aspectRatio;
      }
      if (maintainAspectRatio && _aspectRatio) {
        return _aspectRatio;
      }
      return height ? width / height : null;
    }
    get data() {
      return this.config.data;
    }
    set data(data) {
      this.config.data = data;
    }
    get options() {
      return this._options;
    }
    set options(options) {
      this.config.options = options;
    }
    get registry() {
      return registry;
    }
    _initialize() {
      this.notifyPlugins('beforeInit');
      if (this.options.responsive) {
        this.resize();
      } else {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ae)(this, this.options.devicePixelRatio);
      }
      this.bindEvents();
      this.notifyPlugins('afterInit');
      return this;
    }
    clear() {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.af)(this.canvas, this.ctx);
      return this;
    }
    stop() {
      animator.stop(this);
      return this;
    }
    resize(width, height) {
      if (!animator.running(this)) {
        this._resize(width, height);
      } else {
        this._resizeBeforeDraw = {
          width,
          height
        };
      }
    }
    _resize(width, height) {
      const options = this.options;
      const canvas = this.canvas;
      const aspectRatio = options.maintainAspectRatio && this.aspectRatio;
      const newSize = this.platform.getMaximumSize(canvas, width, height, aspectRatio);
      const newRatio = options.devicePixelRatio || this.platform.getDevicePixelRatio();
      const mode = this.width ? 'resize' : 'attach';
      this.width = newSize.width;
      this.height = newSize.height;
      this._aspectRatio = this.aspectRatio;
      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ae)(this, newRatio, true)) {
        return;
      }
      this.notifyPlugins('resize', {
        size: newSize
      });
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(options.onResize, [this, newSize], this);
      if (this.attached) {
        if (this._doResize(mode)) {
          this.render();
        }
      }
    }
    ensureScalesHaveIDs() {
      const options = this.options;
      const scalesOptions = options.scales || {};
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(scalesOptions, (axisOptions, axisID) => {
        axisOptions.id = axisID;
      });
    }
    buildOrUpdateScales() {
      const options = this.options;
      const scaleOpts = options.scales;
      const scales = this.scales;
      const updated = Object.keys(scales).reduce((obj, id) => {
        obj[id] = false;
        return obj;
      }, {});
      let items = [];
      if (scaleOpts) {
        items = items.concat(Object.keys(scaleOpts).map(id => {
          const scaleOptions = scaleOpts[id];
          const axis = determineAxis(id, scaleOptions);
          const isRadial = axis === 'r';
          const isHorizontal = axis === 'x';
          return {
            options: scaleOptions,
            dposition: isRadial ? 'chartArea' : isHorizontal ? 'bottom' : 'left',
            dtype: isRadial ? 'radialLinear' : isHorizontal ? 'category' : 'linear'
          };
        }));
      }
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(items, item => {
        const scaleOptions = item.options;
        const id = scaleOptions.id;
        const axis = determineAxis(id, scaleOptions);
        const scaleType = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(scaleOptions.type, item.dtype);
        if (scaleOptions.position === undefined || positionIsHorizontal(scaleOptions.position, axis) !== positionIsHorizontal(item.dposition)) {
          scaleOptions.position = item.dposition;
        }
        updated[id] = true;
        let scale = null;
        if (id in scales && scales[id].type === scaleType) {
          scale = scales[id];
        } else {
          const scaleClass = registry.getScale(scaleType);
          scale = new scaleClass({
            id,
            type: scaleType,
            ctx: this.ctx,
            chart: this
          });
          scales[scale.id] = scale;
        }
        scale.init(scaleOptions, options);
      });
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(updated, (hasUpdated, id) => {
        if (!hasUpdated) {
          delete scales[id];
        }
      });
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(scales, scale => {
        layouts.configure(this, scale, scale.options);
        layouts.addBox(this, scale);
      });
    }
    _updateMetasets() {
      const metasets = this._metasets;
      const numData = this.data.datasets.length;
      const numMeta = metasets.length;
      metasets.sort((a, b) => a.index - b.index);
      if (numMeta > numData) {
        for (let i = numData; i < numMeta; ++i) {
          this._destroyDatasetMeta(i);
        }
        metasets.splice(numData, numMeta - numData);
      }
      this._sortedMetasets = metasets.slice(0).sort(compare2Level('order', 'index'));
    }
    _removeUnreferencedMetasets() {
      const {
        _metasets: metasets,
        data: {
          datasets
        }
      } = this;
      if (metasets.length > datasets.length) {
        delete this._stacks;
      }
      metasets.forEach((meta, index) => {
        if (datasets.filter(x => x === meta._dataset).length === 0) {
          this._destroyDatasetMeta(index);
        }
      });
    }
    buildOrUpdateControllers() {
      const newControllers = [];
      const datasets = this.data.datasets;
      let i, ilen;
      this._removeUnreferencedMetasets();
      for (i = 0, ilen = datasets.length; i < ilen; i++) {
        const dataset = datasets[i];
        let meta = this.getDatasetMeta(i);
        const type = dataset.type || this.config.type;
        if (meta.type && meta.type !== type) {
          this._destroyDatasetMeta(i);
          meta = this.getDatasetMeta(i);
        }
        meta.type = type;
        meta.indexAxis = dataset.indexAxis || getIndexAxis(type, this.options);
        meta.order = dataset.order || 0;
        meta.index = i;
        meta.label = '' + dataset.label;
        meta.visible = this.isDatasetVisible(i);
        if (meta.controller) {
          meta.controller.updateIndex(i);
          meta.controller.linkScales();
        } else {
          const ControllerClass = registry.getController(type);
          const {
            datasetElementType,
            dataElementType
          } = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.datasets[type];
          Object.assign(ControllerClass, {
            dataElementType: registry.getElement(dataElementType),
            datasetElementType: datasetElementType && registry.getElement(datasetElementType)
          });
          meta.controller = new ControllerClass(this, i);
          newControllers.push(meta.controller);
        }
      }
      this._updateMetasets();
      return newControllers;
    }
    _resetElements() {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.data.datasets, (dataset, datasetIndex) => {
        this.getDatasetMeta(datasetIndex).controller.reset();
      }, this);
    }
    reset() {
      this._resetElements();
      this.notifyPlugins('reset');
    }
    update(mode) {
      const config = this.config;
      config.update();
      const options = this._options = config.createResolver(config.chartOptionScopes(), this.getContext());
      const animsDisabled = this._animationsDisabled = !options.animation;
      this._updateScales();
      this._checkEventBindings();
      this._updateHiddenIndices();
      this._plugins.invalidate();
      if (this.notifyPlugins('beforeUpdate', {
        mode,
        cancelable: true
      }) === false) {
        return;
      }
      const newControllers = this.buildOrUpdateControllers();
      this.notifyPlugins('beforeElementsUpdate');
      let minPadding = 0;
      for (let i = 0, ilen = this.data.datasets.length; i < ilen; i++) {
        const {
          controller
        } = this.getDatasetMeta(i);
        const reset = !animsDisabled && newControllers.indexOf(controller) === -1;
        controller.buildOrUpdateElements(reset);
        minPadding = Math.max(+controller.getMaxOverflow(), minPadding);
      }
      minPadding = this._minPadding = options.layout.autoPadding ? minPadding : 0;
      this._updateLayout(minPadding);
      if (!animsDisabled) {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(newControllers, controller => {
          controller.reset();
        });
      }
      this._updateDatasets(mode);
      this.notifyPlugins('afterUpdate', {
        mode
      });
      this._layers.sort(compare2Level('z', '_idx'));
      const {
        _active,
        _lastEvent
      } = this;
      if (_lastEvent) {
        this._eventHandler(_lastEvent, true);
      } else if (_active.length) {
        this._updateHoverStyles(_active, _active, true);
      }
      this.render();
    }
    _updateScales() {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.scales, scale => {
        layouts.removeBox(this, scale);
      });
      this.ensureScalesHaveIDs();
      this.buildOrUpdateScales();
    }
    _checkEventBindings() {
      const options = this.options;
      const existingEvents = new Set(Object.keys(this._listeners));
      const newEvents = new Set(options.events);
      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ag)(existingEvents, newEvents) || !!this._responsiveListeners !== options.responsive) {
        this.unbindEvents();
        this.bindEvents();
      }
    }
    _updateHiddenIndices() {
      const {
        _hiddenIndices
      } = this;
      const changes = this._getUniformDataChanges() || [];
      for (const {
        method,
        start,
        count
      } of changes) {
        const move = method === '_removeElements' ? -count : count;
        moveNumericKeys(_hiddenIndices, start, move);
      }
    }
    _getUniformDataChanges() {
      const _dataChanges = this._dataChanges;
      if (!_dataChanges || !_dataChanges.length) {
        return;
      }
      this._dataChanges = [];
      const datasetCount = this.data.datasets.length;
      const makeSet = idx => new Set(_dataChanges.filter(c => c[0] === idx).map((c, i) => i + ',' + c.splice(1).join(',')));
      const changeSet = makeSet(0);
      for (let i = 1; i < datasetCount; i++) {
        if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ag)(changeSet, makeSet(i))) {
          return;
        }
      }
      return Array.from(changeSet).map(c => c.split(',')).map(a => ({
        method: a[1],
        start: +a[2],
        count: +a[3]
      }));
    }
    _updateLayout(minPadding) {
      if (this.notifyPlugins('beforeLayout', {
        cancelable: true
      }) === false) {
        return;
      }
      layouts.update(this, this.width, this.height, minPadding);
      const area = this.chartArea;
      const noArea = area.width <= 0 || area.height <= 0;
      this._layers = [];
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.boxes, box => {
        if (noArea && box.position === 'chartArea') {
          return;
        }
        if (box.configure) {
          box.configure();
        }
        this._layers.push(...box._layers());
      }, this);
      this._layers.forEach((item, index) => {
        item._idx = index;
      });
      this.notifyPlugins('afterLayout');
    }
    _updateDatasets(mode) {
      if (this.notifyPlugins('beforeDatasetsUpdate', {
        mode,
        cancelable: true
      }) === false) {
        return;
      }
      for (let i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
        this.getDatasetMeta(i).controller.configure();
      }
      for (let i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
        this._updateDataset(i, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a7)(mode) ? mode({
          datasetIndex: i
        }) : mode);
      }
      this.notifyPlugins('afterDatasetsUpdate', {
        mode
      });
    }
    _updateDataset(index, mode) {
      const meta = this.getDatasetMeta(index);
      const args = {
        meta,
        index,
        mode,
        cancelable: true
      };
      if (this.notifyPlugins('beforeDatasetUpdate', args) === false) {
        return;
      }
      meta.controller._update(mode);
      args.cancelable = false;
      this.notifyPlugins('afterDatasetUpdate', args);
    }
    render() {
      if (this.notifyPlugins('beforeRender', {
        cancelable: true
      }) === false) {
        return;
      }
      if (animator.has(this)) {
        if (this.attached && !animator.running(this)) {
          animator.start(this);
        }
      } else {
        this.draw();
        onAnimationsComplete({
          chart: this
        });
      }
    }
    draw() {
      let i;
      if (this._resizeBeforeDraw) {
        const {
          width,
          height
        } = this._resizeBeforeDraw;
        this._resizeBeforeDraw = null;
        this._resize(width, height);
      }
      this.clear();
      if (this.width <= 0 || this.height <= 0) {
        return;
      }
      if (this.notifyPlugins('beforeDraw', {
        cancelable: true
      }) === false) {
        return;
      }
      const layers = this._layers;
      for (i = 0; i < layers.length && layers[i].z <= 0; ++i) {
        layers[i].draw(this.chartArea);
      }
      this._drawDatasets();
      for (; i < layers.length; ++i) {
        layers[i].draw(this.chartArea);
      }
      this.notifyPlugins('afterDraw');
    }
    _getSortedDatasetMetas(filterVisible) {
      const metasets = this._sortedMetasets;
      const result = [];
      let i, ilen;
      for (i = 0, ilen = metasets.length; i < ilen; ++i) {
        const meta = metasets[i];
        if (!filterVisible || meta.visible) {
          result.push(meta);
        }
      }
      return result;
    }
    getSortedVisibleDatasetMetas() {
      return this._getSortedDatasetMetas(true);
    }
    _drawDatasets() {
      if (this.notifyPlugins('beforeDatasetsDraw', {
        cancelable: true
      }) === false) {
        return;
      }
      const metasets = this.getSortedVisibleDatasetMetas();
      for (let i = metasets.length - 1; i >= 0; --i) {
        this._drawDataset(metasets[i]);
      }
      this.notifyPlugins('afterDatasetsDraw');
    }
    _drawDataset(meta) {
      const ctx = this.ctx;
      const clip = meta._clip;
      const useClip = !clip.disabled;
      const area = getDatasetArea(meta, this.chartArea);
      const args = {
        meta,
        index: meta.index,
        cancelable: true
      };
      if (this.notifyPlugins('beforeDatasetDraw', args) === false) {
        return;
      }
      if (useClip) {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, {
          left: clip.left === false ? 0 : area.left - clip.left,
          right: clip.right === false ? this.width : area.right + clip.right,
          top: clip.top === false ? 0 : area.top - clip.top,
          bottom: clip.bottom === false ? this.height : area.bottom + clip.bottom
        });
      }
      meta.controller.draw();
      if (useClip) {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);
      }
      args.cancelable = false;
      this.notifyPlugins('afterDatasetDraw', args);
    }
    isPointInArea(point) {
      return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)(point, this.chartArea, this._minPadding);
    }
    getElementsAtEventForMode(e, mode, options, useFinalPosition) {
      const method = Interaction.modes[mode];
      if (typeof method === 'function') {
        return method(this, e, options, useFinalPosition);
      }
      return [];
    }
    getDatasetMeta(datasetIndex) {
      const dataset = this.data.datasets[datasetIndex];
      const metasets = this._metasets;
      let meta = metasets.filter(x => x && x._dataset === dataset).pop();
      if (!meta) {
        meta = {
          type: null,
          data: [],
          dataset: null,
          controller: null,
          hidden: null,
          xAxisID: null,
          yAxisID: null,
          order: dataset && dataset.order || 0,
          index: datasetIndex,
          _dataset: dataset,
          _parsed: [],
          _sorted: false
        };
        metasets.push(meta);
      }
      return meta;
    }
    getContext() {
      return this.$context || (this.$context = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(null, {
        chart: this,
        type: 'chart'
      }));
    }
    getVisibleDatasetCount() {
      return this.getSortedVisibleDatasetMetas().length;
    }
    isDatasetVisible(datasetIndex) {
      const dataset = this.data.datasets[datasetIndex];
      if (!dataset) {
        return false;
      }
      const meta = this.getDatasetMeta(datasetIndex);
      return typeof meta.hidden === 'boolean' ? !meta.hidden : !dataset.hidden;
    }
    setDatasetVisibility(datasetIndex, visible) {
      const meta = this.getDatasetMeta(datasetIndex);
      meta.hidden = !visible;
    }
    toggleDataVisibility(index) {
      this._hiddenIndices[index] = !this._hiddenIndices[index];
    }
    getDataVisibility(index) {
      return !this._hiddenIndices[index];
    }
    _updateVisibility(datasetIndex, dataIndex, visible) {
      const mode = visible ? 'show' : 'hide';
      const meta = this.getDatasetMeta(datasetIndex);
      const anims = meta.controller._resolveAnimations(undefined, mode);
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.h)(dataIndex)) {
        meta.data[dataIndex].hidden = !visible;
        this.update();
      } else {
        this.setDatasetVisibility(datasetIndex, visible);
        anims.update(meta, {
          visible
        });
        this.update(ctx => ctx.datasetIndex === datasetIndex ? mode : undefined);
      }
    }
    hide(datasetIndex, dataIndex) {
      this._updateVisibility(datasetIndex, dataIndex, false);
    }
    show(datasetIndex, dataIndex) {
      this._updateVisibility(datasetIndex, dataIndex, true);
    }
    _destroyDatasetMeta(datasetIndex) {
      const meta = this._metasets[datasetIndex];
      if (meta && meta.controller) {
        meta.controller._destroy();
      }
      delete this._metasets[datasetIndex];
    }
    _stop() {
      let i, ilen;
      this.stop();
      animator.remove(this);
      for (i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
        this._destroyDatasetMeta(i);
      }
    }
    destroy() {
      this.notifyPlugins('beforeDestroy');
      const {
        canvas,
        ctx
      } = this;
      this._stop();
      this.config.clearCache();
      if (canvas) {
        this.unbindEvents();
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.af)(canvas, ctx);
        this.platform.releaseContext(ctx);
        this.canvas = null;
        this.ctx = null;
      }
      delete instances[this.id];
      this.notifyPlugins('afterDestroy');
    }
    toBase64Image(...args) {
      return this.canvas.toDataURL(...args);
    }
    bindEvents() {
      this.bindUserEvents();
      if (this.options.responsive) {
        this.bindResponsiveEvents();
      } else {
        this.attached = true;
      }
    }
    bindUserEvents() {
      const listeners = this._listeners;
      const platform = this.platform;
      const _add = (type, listener) => {
        platform.addEventListener(this, type, listener);
        listeners[type] = listener;
      };
      const listener = (e, x, y) => {
        e.offsetX = x;
        e.offsetY = y;
        this._eventHandler(e);
      };
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.options.events, type => _add(type, listener));
    }
    bindResponsiveEvents() {
      if (!this._responsiveListeners) {
        this._responsiveListeners = {};
      }
      const listeners = this._responsiveListeners;
      const platform = this.platform;
      const _add = (type, listener) => {
        platform.addEventListener(this, type, listener);
        listeners[type] = listener;
      };
      const _remove = (type, listener) => {
        if (listeners[type]) {
          platform.removeEventListener(this, type, listener);
          delete listeners[type];
        }
      };
      const listener = (width, height) => {
        if (this.canvas) {
          this.resize(width, height);
        }
      };
      let detached;
      const attached = () => {
        _remove('attach', attached);
        this.attached = true;
        this.resize();
        _add('resize', listener);
        _add('detach', detached);
      };
      detached = () => {
        this.attached = false;
        _remove('resize', listener);
        this._stop();
        this._resize(0, 0);
        _add('attach', attached);
      };
      if (platform.isAttached(this.canvas)) {
        attached();
      } else {
        detached();
      }
    }
    unbindEvents() {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this._listeners, (listener, type) => {
        this.platform.removeEventListener(this, type, listener);
      });
      this._listeners = {};
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this._responsiveListeners, (listener, type) => {
        this.platform.removeEventListener(this, type, listener);
      });
      this._responsiveListeners = undefined;
    }
    updateHoverStyle(items, mode, enabled) {
      const prefix = enabled ? 'set' : 'remove';
      let meta, item, i, ilen;
      if (mode === 'dataset') {
        meta = this.getDatasetMeta(items[0].datasetIndex);
        meta.controller['_' + prefix + 'DatasetHoverStyle']();
      }
      for (i = 0, ilen = items.length; i < ilen; ++i) {
        item = items[i];
        const controller = item && this.getDatasetMeta(item.datasetIndex).controller;
        if (controller) {
          controller[prefix + 'HoverStyle'](item.element, item.datasetIndex, item.index);
        }
      }
    }
    getActiveElements() {
      return this._active || [];
    }
    setActiveElements(activeElements) {
      const lastActive = this._active || [];
      const active = activeElements.map(({
        datasetIndex,
        index
      }) => {
        const meta = this.getDatasetMeta(datasetIndex);
        if (!meta) {
          throw new Error('No dataset found at index ' + datasetIndex);
        }
        return {
          datasetIndex,
          element: meta.data[index],
          index
        };
      });
      const changed = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ah)(active, lastActive);
      if (changed) {
        this._active = active;
        this._lastEvent = null;
        this._updateHoverStyles(active, lastActive);
      }
    }
    notifyPlugins(hook, args, filter) {
      return this._plugins.notify(this, hook, args, filter);
    }
    isPluginEnabled(pluginId) {
      return this._plugins._cache.filter(p => p.plugin.id === pluginId).length === 1;
    }
    _updateHoverStyles(active, lastActive, replay) {
      const hoverOptions = this.options.hover;
      const diff = (a, b) => a.filter(x => !b.some(y => x.datasetIndex === y.datasetIndex && x.index === y.index));
      const deactivated = diff(lastActive, active);
      const activated = replay ? active : diff(active, lastActive);
      if (deactivated.length) {
        this.updateHoverStyle(deactivated, hoverOptions.mode, false);
      }
      if (activated.length && hoverOptions.mode) {
        this.updateHoverStyle(activated, hoverOptions.mode, true);
      }
    }
    _eventHandler(e, replay) {
      const args = {
        event: e,
        replay,
        cancelable: true,
        inChartArea: this.isPointInArea(e)
      };
      const eventFilter = plugin => (plugin.options.events || this.options.events).includes(e.native.type);
      if (this.notifyPlugins('beforeEvent', args, eventFilter) === false) {
        return;
      }
      const changed = this._handleEvent(e, replay, args.inChartArea);
      args.cancelable = false;
      this.notifyPlugins('afterEvent', args, eventFilter);
      if (changed || args.changed) {
        this.render();
      }
      return this;
    }
    _handleEvent(e, replay, inChartArea) {
      const {
        _active: lastActive = [],
        options
      } = this;
      const useFinalPosition = replay;
      const active = this._getActiveElements(e, lastActive, inChartArea, useFinalPosition);
      const isClick = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ai)(e);
      const lastEvent = determineLastEvent(e, this._lastEvent, inChartArea, isClick);
      if (inChartArea) {
        this._lastEvent = null;
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(options.onHover, [e, active, this], this);
        if (isClick) {
          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(options.onClick, [e, active, this], this);
        }
      }
      const changed = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ah)(active, lastActive);
      if (changed || replay) {
        this._active = active;
        this._updateHoverStyles(active, lastActive, replay);
      }
      this._lastEvent = lastEvent;
      return changed;
    }
    _getActiveElements(e, lastActive, inChartArea, useFinalPosition) {
      if (e.type === 'mouseout') {
        return [];
      }
      if (!inChartArea) {
        return lastActive;
      }
      const hoverOptions = this.options.hover;
      return this.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions, useFinalPosition);
    }
  }
  return Chart;
})();
function invalidatePlugins() {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(Chart.instances, chart => chart._plugins.invalidate());
}
function clipArc(ctx, element, endAngle) {
  const {
    startAngle,
    pixelMargin,
    x,
    y,
    outerRadius,
    innerRadius
  } = element;
  let angleMargin = pixelMargin / outerRadius;
  // Draw an inner border by clipping the arc and drawing a double-width border
  // Enlarge the clipping arc by 0.33 pixels to eliminate glitches between borders
  ctx.beginPath();
  ctx.arc(x, y, outerRadius, startAngle - angleMargin, endAngle + angleMargin);
  if (innerRadius > pixelMargin) {
    angleMargin = pixelMargin / innerRadius;
    ctx.arc(x, y, innerRadius, endAngle + angleMargin, startAngle - angleMargin, true);
  } else {
    ctx.arc(x, y, pixelMargin, endAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, startAngle - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H);
  }
  ctx.closePath();
  ctx.clip();
}
function toRadiusCorners(value) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ak)(value, ['outerStart', 'outerEnd', 'innerStart', 'innerEnd']);
}
/**
 * Parse border radius from the provided options
 */
function parseBorderRadius$1(arc, innerRadius, outerRadius, angleDelta) {
  const o = toRadiusCorners(arc.options.borderRadius);
  const halfThickness = (outerRadius - innerRadius) / 2;
  const innerLimit = Math.min(halfThickness, angleDelta * innerRadius / 2);
  // Outer limits are complicated. We want to compute the available angular distance at
  // a radius of outerRadius - borderRadius because for small angular distances, this term limits.
  // We compute at r = outerRadius - borderRadius because this circle defines the center of the border corners.
  //
  // If the borderRadius is large, that value can become negative.
  // This causes the outer borders to lose their radius entirely, which is rather unexpected. To solve that, if borderRadius > outerRadius
  // we know that the thickness term will dominate and compute the limits at that point
  const computeOuterLimit = val => {
    const outerArcLimit = (outerRadius - Math.min(halfThickness, val)) * angleDelta / 2;
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(val, 0, Math.min(halfThickness, outerArcLimit));
  };
  return {
    outerStart: computeOuterLimit(o.outerStart),
    outerEnd: computeOuterLimit(o.outerEnd),
    innerStart: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(o.innerStart, 0, innerLimit),
    innerEnd: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(o.innerEnd, 0, innerLimit)
  };
}
/**
 * Convert (r, 𝜃) to (x, y)
 */
function rThetaToXY(r, theta, x, y) {
  return {
    x: x + r * Math.cos(theta),
    y: y + r * Math.sin(theta)
  };
}
/**
 * Path the arc, respecting border radius by separating into left and right halves.
 *
 *   Start      End
 *
 *    1--->a--->2    Outer
 *   /           \
 *   8           3
 *   |           |
 *   |           |
 *   7           4
 *   \           /
 *    6<---b<---5    Inner
 */
function pathArc(ctx, element, offset, spacing, end, circular) {
  const {
    x,
    y,
    startAngle: start,
    pixelMargin,
    innerRadius: innerR
  } = element;
  const outerRadius = Math.max(element.outerRadius + spacing + offset - pixelMargin, 0);
  const innerRadius = innerR > 0 ? innerR + spacing + offset + pixelMargin : 0;
  let spacingOffset = 0;
  const alpha = end - start;
  if (spacing) {
    // When spacing is present, it is the same for all items
    // So we adjust the start and end angle of the arc such that
    // the distance is the same as it would be without the spacing
    const noSpacingInnerRadius = innerR > 0 ? innerR - spacing : 0;
    const noSpacingOuterRadius = outerRadius > 0 ? outerRadius - spacing : 0;
    const avNogSpacingRadius = (noSpacingInnerRadius + noSpacingOuterRadius) / 2;
    const adjustedAngle = avNogSpacingRadius !== 0 ? alpha * avNogSpacingRadius / (avNogSpacingRadius + spacing) : alpha;
    spacingOffset = (alpha - adjustedAngle) / 2;
  }
  const beta = Math.max(0.001, alpha * outerRadius - offset / _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P) / outerRadius;
  const angleOffset = (alpha - beta) / 2;
  const startAngle = start + angleOffset + spacingOffset;
  const endAngle = end - angleOffset - spacingOffset;
  const {
    outerStart,
    outerEnd,
    innerStart,
    innerEnd
  } = parseBorderRadius$1(element, innerRadius, outerRadius, endAngle - startAngle);
  const outerStartAdjustedRadius = outerRadius - outerStart;
  const outerEndAdjustedRadius = outerRadius - outerEnd;
  const outerStartAdjustedAngle = startAngle + outerStart / outerStartAdjustedRadius;
  const outerEndAdjustedAngle = endAngle - outerEnd / outerEndAdjustedRadius;
  const innerStartAdjustedRadius = innerRadius + innerStart;
  const innerEndAdjustedRadius = innerRadius + innerEnd;
  const innerStartAdjustedAngle = startAngle + innerStart / innerStartAdjustedRadius;
  const innerEndAdjustedAngle = endAngle - innerEnd / innerEndAdjustedRadius;
  ctx.beginPath();
  if (circular) {
    // The first arc segments from point 1 to point a to point 2
    const outerMidAdjustedAngle = (outerStartAdjustedAngle + outerEndAdjustedAngle) / 2;
    ctx.arc(x, y, outerRadius, outerStartAdjustedAngle, outerMidAdjustedAngle);
    ctx.arc(x, y, outerRadius, outerMidAdjustedAngle, outerEndAdjustedAngle);
    // The corner segment from point 2 to point 3
    if (outerEnd > 0) {
      const pCenter = rThetaToXY(outerEndAdjustedRadius, outerEndAdjustedAngle, x, y);
      ctx.arc(pCenter.x, pCenter.y, outerEnd, outerEndAdjustedAngle, endAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H);
    }
    // The line from point 3 to point 4
    const p4 = rThetaToXY(innerEndAdjustedRadius, endAngle, x, y);
    ctx.lineTo(p4.x, p4.y);
    // The corner segment from point 4 to point 5
    if (innerEnd > 0) {
      const pCenter = rThetaToXY(innerEndAdjustedRadius, innerEndAdjustedAngle, x, y);
      ctx.arc(pCenter.x, pCenter.y, innerEnd, endAngle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, innerEndAdjustedAngle + Math.PI);
    }
    // The inner arc from point 5 to point b to point 6
    const innerMidAdjustedAngle = (endAngle - innerEnd / innerRadius + (startAngle + innerStart / innerRadius)) / 2;
    ctx.arc(x, y, innerRadius, endAngle - innerEnd / innerRadius, innerMidAdjustedAngle, true);
    ctx.arc(x, y, innerRadius, innerMidAdjustedAngle, startAngle + innerStart / innerRadius, true);
    // The corner segment from point 6 to point 7
    if (innerStart > 0) {
      const pCenter = rThetaToXY(innerStartAdjustedRadius, innerStartAdjustedAngle, x, y);
      ctx.arc(pCenter.x, pCenter.y, innerStart, innerStartAdjustedAngle + Math.PI, startAngle - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H);
    }
    // The line from point 7 to point 8
    const p8 = rThetaToXY(outerStartAdjustedRadius, startAngle, x, y);
    ctx.lineTo(p8.x, p8.y);
    // The corner segment from point 8 to point 1
    if (outerStart > 0) {
      const pCenter = rThetaToXY(outerStartAdjustedRadius, outerStartAdjustedAngle, x, y);
      ctx.arc(pCenter.x, pCenter.y, outerStart, startAngle - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H, outerStartAdjustedAngle);
    }
  } else {
    ctx.moveTo(x, y);
    const outerStartX = Math.cos(outerStartAdjustedAngle) * outerRadius + x;
    const outerStartY = Math.sin(outerStartAdjustedAngle) * outerRadius + y;
    ctx.lineTo(outerStartX, outerStartY);
    const outerEndX = Math.cos(outerEndAdjustedAngle) * outerRadius + x;
    const outerEndY = Math.sin(outerEndAdjustedAngle) * outerRadius + y;
    ctx.lineTo(outerEndX, outerEndY);
  }
  ctx.closePath();
}
function drawArc(ctx, element, offset, spacing, circular) {
  const {
    fullCircles,
    startAngle,
    circumference
  } = element;
  let endAngle = element.endAngle;
  if (fullCircles) {
    pathArc(ctx, element, offset, spacing, endAngle, circular);
    for (let i = 0; i < fullCircles; ++i) {
      ctx.fill();
    }
    if (!isNaN(circumference)) {
      endAngle = startAngle + (circumference % _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T || _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);
    }
  }
  pathArc(ctx, element, offset, spacing, endAngle, circular);
  ctx.fill();
  return endAngle;
}
function drawBorder(ctx, element, offset, spacing, circular) {
  const {
    fullCircles,
    startAngle,
    circumference,
    options
  } = element;
  const {
    borderWidth,
    borderJoinStyle,
    borderDash,
    borderDashOffset
  } = options;
  const inner = options.borderAlign === 'inner';
  if (!borderWidth) {
    return;
  }
  ctx.setLineDash(borderDash || []);
  ctx.lineDashOffset = borderDashOffset;
  if (inner) {
    ctx.lineWidth = borderWidth * 2;
    ctx.lineJoin = borderJoinStyle || 'round';
  } else {
    ctx.lineWidth = borderWidth;
    ctx.lineJoin = borderJoinStyle || 'bevel';
  }
  let endAngle = element.endAngle;
  if (fullCircles) {
    pathArc(ctx, element, offset, spacing, endAngle, circular);
    for (let i = 0; i < fullCircles; ++i) {
      ctx.stroke();
    }
    if (!isNaN(circumference)) {
      endAngle = startAngle + (circumference % _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T || _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);
    }
  }
  if (inner) {
    clipArc(ctx, element, endAngle);
  }
  if (!fullCircles) {
    pathArc(ctx, element, offset, spacing, endAngle, circular);
    ctx.stroke();
  }
}
class ArcElement extends Element {
  static id = 'arc';
  static defaults = (() => ({
    borderAlign: 'center',
    borderColor: '#fff',
    borderDash: [],
    borderDashOffset: 0,
    borderJoinStyle: undefined,
    borderRadius: 0,
    borderWidth: 2,
    offset: 0,
    spacing: 0,
    angle: undefined,
    circular: true
  }))();
  static defaultRoutes = {
    backgroundColor: 'backgroundColor'
  };
  static descriptors = {
    _scriptable: true,
    _indexable: name => name !== 'borderDash'
  };
  circumference;
  endAngle;
  fullCircles;
  innerRadius;
  outerRadius;
  pixelMargin;
  startAngle;
  constructor(cfg) {
    super();
    this.options = undefined;
    this.circumference = undefined;
    this.startAngle = undefined;
    this.endAngle = undefined;
    this.innerRadius = undefined;
    this.outerRadius = undefined;
    this.pixelMargin = 0;
    this.fullCircles = 0;
    if (cfg) {
      Object.assign(this, cfg);
    }
  }
  inRange(chartX, chartY, useFinalPosition) {
    const point = this.getProps(['x', 'y'], useFinalPosition);
    const {
      angle,
      distance
    } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.D)(point, {
      x: chartX,
      y: chartY
    });
    const {
      startAngle,
      endAngle,
      innerRadius,
      outerRadius,
      circumference
    } = this.getProps(['startAngle', 'endAngle', 'innerRadius', 'outerRadius', 'circumference'], useFinalPosition);
    const rAdjust = (this.options.spacing + this.options.borderWidth) / 2;
    const _circumference = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(circumference, endAngle - startAngle);
    const nonZeroBetween = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.p)(angle, startAngle, endAngle) && startAngle !== endAngle;
    const betweenAngles = _circumference >= _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T || nonZeroBetween;
    const withinRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(distance, innerRadius + rAdjust, outerRadius + rAdjust);
    return betweenAngles && withinRadius;
  }
  getCenterPoint(useFinalPosition) {
    const {
      x,
      y,
      startAngle,
      endAngle,
      innerRadius,
      outerRadius
    } = this.getProps(['x', 'y', 'startAngle', 'endAngle', 'innerRadius', 'outerRadius'], useFinalPosition);
    const {
      offset,
      spacing
    } = this.options;
    const halfAngle = (startAngle + endAngle) / 2;
    const halfRadius = (innerRadius + outerRadius + spacing + offset) / 2;
    return {
      x: x + Math.cos(halfAngle) * halfRadius,
      y: y + Math.sin(halfAngle) * halfRadius
    };
  }
  tooltipPosition(useFinalPosition) {
    return this.getCenterPoint(useFinalPosition);
  }
  draw(ctx) {
    const {
      options,
      circumference
    } = this;
    const offset = (options.offset || 0) / 4;
    const spacing = (options.spacing || 0) / 2;
    const circular = options.circular;
    this.pixelMargin = options.borderAlign === 'inner' ? 0.33 : 0;
    this.fullCircles = circumference > _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T ? Math.floor(circumference / _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T) : 0;
    if (circumference === 0 || this.innerRadius < 0 || this.outerRadius < 0) {
      return;
    }
    ctx.save();
    const halfAngle = (this.startAngle + this.endAngle) / 2;
    ctx.translate(Math.cos(halfAngle) * offset, Math.sin(halfAngle) * offset);
    const fix = 1 - Math.sin(Math.min(_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P, circumference || 0));
    const radiusOffset = offset * fix;
    ctx.fillStyle = options.backgroundColor;
    ctx.strokeStyle = options.borderColor;
    drawArc(ctx, this, radiusOffset, spacing, circular);
    drawBorder(ctx, this, radiusOffset, spacing, circular);
    ctx.restore();
  }
}
function setStyle(ctx, options, style = options) {
  ctx.lineCap = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderCapStyle, options.borderCapStyle);
  ctx.setLineDash((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderDash, options.borderDash));
  ctx.lineDashOffset = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderDashOffset, options.borderDashOffset);
  ctx.lineJoin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderJoinStyle, options.borderJoinStyle);
  ctx.lineWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderWidth, options.borderWidth);
  ctx.strokeStyle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(style.borderColor, options.borderColor);
}
function lineTo(ctx, previous, target) {
  ctx.lineTo(target.x, target.y);
}
function getLineMethod(options) {
  if (options.stepped) {
    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ar;
  }
  if (options.tension || options.cubicInterpolationMode === 'monotone') {
    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.as;
  }
  return lineTo;
}
function pathVars(points, segment, params = {}) {
  const count = points.length;
  const {
    start: paramsStart = 0,
    end: paramsEnd = count - 1
  } = params;
  const {
    start: segmentStart,
    end: segmentEnd
  } = segment;
  const start = Math.max(paramsStart, segmentStart);
  const end = Math.min(paramsEnd, segmentEnd);
  const outside = paramsStart < segmentStart && paramsEnd < segmentStart || paramsStart > segmentEnd && paramsEnd > segmentEnd;
  return {
    count,
    start,
    loop: segment.loop,
    ilen: end < start && !outside ? count + end - start : end - start
  };
}
function pathSegment(ctx, line, segment, params) {
  const {
    points,
    options
  } = line;
  const {
    count,
    start,
    loop,
    ilen
  } = pathVars(points, segment, params);
  const lineMethod = getLineMethod(options);
  let {
    move = true,
    reverse
  } = params || {};
  let i, point, prev;
  for (i = 0; i <= ilen; ++i) {
    point = points[(start + (reverse ? ilen - i : i)) % count];
    if (point.skip) {
      continue;
    } else if (move) {
      ctx.moveTo(point.x, point.y);
      move = false;
    } else {
      lineMethod(ctx, prev, point, reverse, options.stepped);
    }
    prev = point;
  }
  if (loop) {
    point = points[(start + (reverse ? ilen : 0)) % count];
    lineMethod(ctx, prev, point, reverse, options.stepped);
  }
  return !!loop;
}
function fastPathSegment(ctx, line, segment, params) {
  const points = line.points;
  const {
    count,
    start,
    ilen
  } = pathVars(points, segment, params);
  const {
    move = true,
    reverse
  } = params || {};
  let avgX = 0;
  let countX = 0;
  let i, point, prevX, minY, maxY, lastY;
  const pointIndex = index => (start + (reverse ? ilen - index : index)) % count;
  const drawX = () => {
    if (minY !== maxY) {
      ctx.lineTo(avgX, maxY);
      ctx.lineTo(avgX, minY);
      ctx.lineTo(avgX, lastY);
    }
  };
  if (move) {
    point = points[pointIndex(0)];
    ctx.moveTo(point.x, point.y);
  }
  for (i = 0; i <= ilen; ++i) {
    point = points[pointIndex(i)];
    if (point.skip) {
      continue;
    }
    const x = point.x;
    const y = point.y;
    const truncX = x | 0;
    if (truncX === prevX) {
      if (y < minY) {
        minY = y;
      } else if (y > maxY) {
        maxY = y;
      }
      avgX = (countX * avgX + x) / ++countX;
    } else {
      drawX();
      ctx.lineTo(x, y);
      prevX = truncX;
      countX = 0;
      minY = maxY = y;
    }
    lastY = y;
  }
  drawX();
}
function _getSegmentMethod(line) {
  const opts = line.options;
  const borderDash = opts.borderDash && opts.borderDash.length;
  const useFastPath = !line._decimated && !line._loop && !opts.tension && opts.cubicInterpolationMode !== 'monotone' && !opts.stepped && !borderDash;
  return useFastPath ? fastPathSegment : pathSegment;
}
function _getInterpolationMethod(options) {
  if (options.stepped) {
    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ao;
  }
  if (options.tension || options.cubicInterpolationMode === 'monotone') {
    return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ap;
  }
  return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aq;
}
function strokePathWithCache(ctx, line, start, count) {
  let path = line._path;
  if (!path) {
    path = line._path = new Path2D();
    if (line.path(path, start, count)) {
      path.closePath();
    }
  }
  setStyle(ctx, line.options);
  ctx.stroke(path);
}
function strokePathDirect(ctx, line, start, count) {
  const {
    segments,
    options
  } = line;
  const segmentMethod = _getSegmentMethod(line);
  for (const segment of segments) {
    setStyle(ctx, options, segment.style);
    ctx.beginPath();
    if (segmentMethod(ctx, line, segment, {
      start,
      end: start + count - 1
    })) {
      ctx.closePath();
    }
    ctx.stroke();
  }
}
const usePath2D = typeof Path2D === 'function';
function draw(ctx, line, start, count) {
  if (usePath2D && !line.options.segment) {
    strokePathWithCache(ctx, line, start, count);
  } else {
    strokePathDirect(ctx, line, start, count);
  }
}
let LineElement = /*#__PURE__*/(() => {
  class LineElement extends Element {
    static id = 'line';
    static defaults = {
      borderCapStyle: 'butt',
      borderDash: [],
      borderDashOffset: 0,
      borderJoinStyle: 'miter',
      borderWidth: 3,
      capBezierPoints: true,
      cubicInterpolationMode: 'default',
      fill: false,
      spanGaps: false,
      stepped: false,
      tension: 0
    };
    static defaultRoutes = {
      backgroundColor: 'backgroundColor',
      borderColor: 'borderColor'
    };
    static descriptors = {
      _scriptable: true,
      _indexable: name => name !== 'borderDash' && name !== 'fill'
    };
    constructor(cfg) {
      super();
      this.animated = true;
      this.options = undefined;
      this._chart = undefined;
      this._loop = undefined;
      this._fullLoop = undefined;
      this._path = undefined;
      this._points = undefined;
      this._segments = undefined;
      this._decimated = false;
      this._pointsUpdated = false;
      this._datasetIndex = undefined;
      if (cfg) {
        Object.assign(this, cfg);
      }
    }
    updateControlPoints(chartArea, indexAxis) {
      const options = this.options;
      if ((options.tension || options.cubicInterpolationMode === 'monotone') && !options.stepped && !this._pointsUpdated) {
        const loop = options.spanGaps ? this._loop : this._fullLoop;
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.al)(this._points, options, chartArea, loop, indexAxis);
        this._pointsUpdated = true;
      }
    }
    set points(points) {
      this._points = points;
      delete this._segments;
      delete this._path;
      this._pointsUpdated = false;
    }
    get points() {
      return this._points;
    }
    get segments() {
      return this._segments || (this._segments = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.am)(this, this.options.segment));
    }
    first() {
      const segments = this.segments;
      const points = this.points;
      return segments.length && points[segments[0].start];
    }
    last() {
      const segments = this.segments;
      const points = this.points;
      const count = segments.length;
      return count && points[segments[count - 1].end];
    }
    interpolate(point, property) {
      const options = this.options;
      const value = point[property];
      const points = this.points;
      const segments = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.an)(this, {
        property,
        start: value,
        end: value
      });
      if (!segments.length) {
        return;
      }
      const result = [];
      const _interpolate = _getInterpolationMethod(options);
      let i, ilen;
      for (i = 0, ilen = segments.length; i < ilen; ++i) {
        const {
          start,
          end
        } = segments[i];
        const p1 = points[start];
        const p2 = points[end];
        if (p1 === p2) {
          result.push(p1);
          continue;
        }
        const t = Math.abs((value - p1[property]) / (p2[property] - p1[property]));
        const interpolated = _interpolate(p1, p2, t, options.stepped);
        interpolated[property] = point[property];
        result.push(interpolated);
      }
      return result.length === 1 ? result[0] : result;
    }
    pathSegment(ctx, segment, params) {
      const segmentMethod = _getSegmentMethod(this);
      return segmentMethod(ctx, this, segment, params);
    }
    path(ctx, start, count) {
      const segments = this.segments;
      const segmentMethod = _getSegmentMethod(this);
      let loop = this._loop;
      start = start || 0;
      count = count || this.points.length - start;
      for (const segment of segments) {
        loop &= segmentMethod(ctx, this, segment, {
          start,
          end: start + count - 1
        });
      }
      return !!loop;
    }
    draw(ctx, chartArea, start, count) {
      const options = this.options || {};
      const points = this.points || [];
      if (points.length && options.borderWidth) {
        ctx.save();
        draw(ctx, this, start, count);
        ctx.restore();
      }
      if (this.animated) {
        this._pointsUpdated = false;
        this._path = undefined;
      }
    }
  }
  return LineElement;
})();
function inRange$1(el, pos, axis, useFinalPosition) {
  const options = el.options;
  const {
    [axis]: value
  } = el.getProps([axis], useFinalPosition);
  return Math.abs(pos - value) < options.radius + options.hitRadius;
}
let PointElement = /*#__PURE__*/(() => {
  class PointElement extends Element {
    static id = 'point';
    parsed;
    skip;
    stop;
    /**
    * @type {any}
    */
    static defaults = {
      borderWidth: 1,
      hitRadius: 1,
      hoverBorderWidth: 1,
      hoverRadius: 4,
      pointStyle: 'circle',
      radius: 3,
      rotation: 0
    };
    /**
    * @type {any}
    */
    static defaultRoutes = {
      backgroundColor: 'backgroundColor',
      borderColor: 'borderColor'
    };
    constructor(cfg) {
      super();
      this.options = undefined;
      this.parsed = undefined;
      this.skip = undefined;
      this.stop = undefined;
      if (cfg) {
        Object.assign(this, cfg);
      }
    }
    inRange(mouseX, mouseY, useFinalPosition) {
      const options = this.options;
      const {
        x,
        y
      } = this.getProps(['x', 'y'], useFinalPosition);
      return Math.pow(mouseX - x, 2) + Math.pow(mouseY - y, 2) < Math.pow(options.hitRadius + options.radius, 2);
    }
    inXRange(mouseX, useFinalPosition) {
      return inRange$1(this, mouseX, 'x', useFinalPosition);
    }
    inYRange(mouseY, useFinalPosition) {
      return inRange$1(this, mouseY, 'y', useFinalPosition);
    }
    getCenterPoint(useFinalPosition) {
      const {
        x,
        y
      } = this.getProps(['x', 'y'], useFinalPosition);
      return {
        x,
        y
      };
    }
    size(options) {
      options = options || this.options || {};
      let radius = options.radius || 0;
      radius = Math.max(radius, radius && options.hoverRadius || 0);
      const borderWidth = radius && options.borderWidth || 0;
      return (radius + borderWidth) * 2;
    }
    draw(ctx, area) {
      const options = this.options;
      if (this.skip || options.radius < 0.1 || !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)(this, area, this.size(options) / 2)) {
        return;
      }
      ctx.strokeStyle = options.borderColor;
      ctx.lineWidth = options.borderWidth;
      ctx.fillStyle = options.backgroundColor;
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.at)(ctx, options, this.x, this.y);
    }
    getRange() {
      const options = this.options || {};
      // @ts-expect-error Fallbacks should never be hit in practice
      return options.radius + options.hitRadius;
    }
  }
  return PointElement;
})();
function getBarBounds(bar, useFinalPosition) {
  const {
    x,
    y,
    base,
    width,
    height
  } = bar.getProps(['x', 'y', 'base', 'width', 'height'], useFinalPosition);
  let left, right, top, bottom, half;
  if (bar.horizontal) {
    half = height / 2;
    left = Math.min(x, base);
    right = Math.max(x, base);
    top = y - half;
    bottom = y + half;
  } else {
    half = width / 2;
    left = x - half;
    right = x + half;
    top = Math.min(y, base);
    bottom = Math.max(y, base);
  }
  return {
    left,
    top,
    right,
    bottom
  };
}
function skipOrLimit(skip, value, min, max) {
  return skip ? 0 : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(value, min, max);
}
function parseBorderWidth(bar, maxW, maxH) {
  const value = bar.options.borderWidth;
  const skip = bar.borderSkipped;
  const o = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.av)(value);
  return {
    t: skipOrLimit(skip.top, o.top, 0, maxH),
    r: skipOrLimit(skip.right, o.right, 0, maxW),
    b: skipOrLimit(skip.bottom, o.bottom, 0, maxH),
    l: skipOrLimit(skip.left, o.left, 0, maxW)
  };
}
function parseBorderRadius(bar, maxW, maxH) {
  const {
    enableBorderRadius
  } = bar.getProps(['enableBorderRadius']);
  const value = bar.options.borderRadius;
  const o = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(value);
  const maxR = Math.min(maxW, maxH);
  const skip = bar.borderSkipped;
  const enableBorder = enableBorderRadius || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(value);
  return {
    topLeft: skipOrLimit(!enableBorder || skip.top || skip.left, o.topLeft, 0, maxR),
    topRight: skipOrLimit(!enableBorder || skip.top || skip.right, o.topRight, 0, maxR),
    bottomLeft: skipOrLimit(!enableBorder || skip.bottom || skip.left, o.bottomLeft, 0, maxR),
    bottomRight: skipOrLimit(!enableBorder || skip.bottom || skip.right, o.bottomRight, 0, maxR)
  };
}
function boundingRects(bar) {
  const bounds = getBarBounds(bar);
  const width = bounds.right - bounds.left;
  const height = bounds.bottom - bounds.top;
  const border = parseBorderWidth(bar, width / 2, height / 2);
  const radius = parseBorderRadius(bar, width / 2, height / 2);
  return {
    outer: {
      x: bounds.left,
      y: bounds.top,
      w: width,
      h: height,
      radius
    },
    inner: {
      x: bounds.left + border.l,
      y: bounds.top + border.t,
      w: width - border.l - border.r,
      h: height - border.t - border.b,
      radius: {
        topLeft: Math.max(0, radius.topLeft - Math.max(border.t, border.l)),
        topRight: Math.max(0, radius.topRight - Math.max(border.t, border.r)),
        bottomLeft: Math.max(0, radius.bottomLeft - Math.max(border.b, border.l)),
        bottomRight: Math.max(0, radius.bottomRight - Math.max(border.b, border.r))
      }
    }
  };
}
function inRange(bar, x, y, useFinalPosition) {
  const skipX = x === null;
  const skipY = y === null;
  const skipBoth = skipX && skipY;
  const bounds = bar && !skipBoth && getBarBounds(bar, useFinalPosition);
  return bounds && (skipX || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(x, bounds.left, bounds.right)) && (skipY || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(y, bounds.top, bounds.bottom));
}
function hasRadius(radius) {
  return radius.topLeft || radius.topRight || radius.bottomLeft || radius.bottomRight;
}
function addNormalRectPath(ctx, rect) {
  ctx.rect(rect.x, rect.y, rect.w, rect.h);
}
function inflateRect(rect, amount, refRect = {}) {
  const x = rect.x !== refRect.x ? -amount : 0;
  const y = rect.y !== refRect.y ? -amount : 0;
  const w = (rect.x + rect.w !== refRect.x + refRect.w ? amount : 0) - x;
  const h = (rect.y + rect.h !== refRect.y + refRect.h ? amount : 0) - y;
  return {
    x: rect.x + x,
    y: rect.y + y,
    w: rect.w + w,
    h: rect.h + h,
    radius: rect.radius
  };
}
class BarElement extends Element {
  static id = 'bar';
  static defaults = (() => ({
    borderSkipped: 'start',
    borderWidth: 0,
    borderRadius: 0,
    inflateAmount: 'auto',
    pointStyle: undefined
  }))();
  static defaultRoutes = {
    backgroundColor: 'backgroundColor',
    borderColor: 'borderColor'
  };
  constructor(cfg) {
    super();
    this.options = undefined;
    this.horizontal = undefined;
    this.base = undefined;
    this.width = undefined;
    this.height = undefined;
    this.inflateAmount = undefined;
    if (cfg) {
      Object.assign(this, cfg);
    }
  }
  draw(ctx) {
    const {
      inflateAmount,
      options: {
        borderColor,
        backgroundColor
      }
    } = this;
    const {
      inner,
      outer
    } = boundingRects(this);
    const addRectPath = hasRadius(outer.radius) ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au : addNormalRectPath;
    ctx.save();
    if (outer.w !== inner.w || outer.h !== inner.h) {
      ctx.beginPath();
      addRectPath(ctx, inflateRect(outer, inflateAmount, inner));
      ctx.clip();
      addRectPath(ctx, inflateRect(inner, -inflateAmount, outer));
      ctx.fillStyle = borderColor;
      ctx.fill('evenodd');
    }
    ctx.beginPath();
    addRectPath(ctx, inflateRect(inner, inflateAmount));
    ctx.fillStyle = backgroundColor;
    ctx.fill();
    ctx.restore();
  }
  inRange(mouseX, mouseY, useFinalPosition) {
    return inRange(this, mouseX, mouseY, useFinalPosition);
  }
  inXRange(mouseX, useFinalPosition) {
    return inRange(this, mouseX, null, useFinalPosition);
  }
  inYRange(mouseY, useFinalPosition) {
    return inRange(this, null, mouseY, useFinalPosition);
  }
  getCenterPoint(useFinalPosition) {
    const {
      x,
      y,
      base,
      horizontal
    } = this.getProps(['x', 'y', 'base', 'horizontal'], useFinalPosition);
    return {
      x: horizontal ? (x + base) / 2 : x,
      y: horizontal ? y : (y + base) / 2
    };
  }
  getRange(axis) {
    return axis === 'x' ? this.width / 2 : this.height / 2;
  }
}
var elements = /*#__PURE__*/Object.freeze({
  __proto__: null,
  ArcElement: ArcElement,
  BarElement: BarElement,
  LineElement: LineElement,
  PointElement: PointElement
});
const BORDER_COLORS = ['rgb(54, 162, 235)', 'rgb(255, 99, 132)', 'rgb(255, 159, 64)', 'rgb(255, 205, 86)', 'rgb(75, 192, 192)', 'rgb(153, 102, 255)', 'rgb(201, 203, 207)' // grey
];
// Border colors with 50% transparency
const BACKGROUND_COLORS = /* #__PURE__ */BORDER_COLORS.map(color => color.replace('rgb(', 'rgba(').replace(')', ', 0.5)'));
function getBorderColor(i) {
  return BORDER_COLORS[i % BORDER_COLORS.length];
}
function getBackgroundColor(i) {
  return BACKGROUND_COLORS[i % BACKGROUND_COLORS.length];
}
function colorizeDefaultDataset(dataset, i) {
  dataset.borderColor = getBorderColor(i);
  dataset.backgroundColor = getBackgroundColor(i);
  return ++i;
}
function colorizeDoughnutDataset(dataset, i) {
  dataset.backgroundColor = dataset.data.map(() => getBorderColor(i++));
  return i;
}
function colorizePolarAreaDataset(dataset, i) {
  dataset.backgroundColor = dataset.data.map(() => getBackgroundColor(i++));
  return i;
}
function getColorizer(chart) {
  let i = 0;
  return (dataset, datasetIndex) => {
    const controller = chart.getDatasetMeta(datasetIndex).controller;
    if (controller instanceof DoughnutController) {
      i = colorizeDoughnutDataset(dataset, i);
    } else if (controller instanceof PolarAreaController) {
      i = colorizePolarAreaDataset(dataset, i);
    } else if (controller) {
      i = colorizeDefaultDataset(dataset, i);
    }
  };
}
function containsColorsDefinitions(descriptors) {
  let k;
  for (k in descriptors) {
    if (descriptors[k].borderColor || descriptors[k].backgroundColor) {
      return true;
    }
  }
  return false;
}
function containsColorsDefinition(descriptor) {
  return descriptor && (descriptor.borderColor || descriptor.backgroundColor);
}
function containsDefaultColorsDefenitions() {
  return _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.borderColor !== 'rgba(0,0,0,0.1)' || _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.backgroundColor !== 'rgba(0,0,0,0.1)';
}
var plugin_colors = {
  id: 'colors',
  defaults: {
    enabled: true,
    forceOverride: false
  },
  beforeLayout(chart, _args, options) {
    if (!options.enabled) {
      return;
    }
    const {
      data: {
        datasets
      },
      options: chartOptions
    } = chart.config;
    const {
      elements
    } = chartOptions;
    const containsColorDefenition = containsColorsDefinitions(datasets) || containsColorsDefinition(chartOptions) || elements && containsColorsDefinitions(elements) || containsDefaultColorsDefenitions();
    if (!options.forceOverride && containsColorDefenition) {
      return;
    }
    const colorizer = getColorizer(chart);
    datasets.forEach(colorizer);
  }
};
function lttbDecimation(data, start, count, availableWidth, options) {
  const samples = options.samples || availableWidth;
  if (samples >= count) {
    return data.slice(start, start + count);
  }
  const decimated = [];
  const bucketWidth = (count - 2) / (samples - 2);
  let sampledIndex = 0;
  const endIndex = start + count - 1;
  let a = start;
  let i, maxAreaPoint, maxArea, area, nextA;
  decimated[sampledIndex++] = data[a];
  for (i = 0; i < samples - 2; i++) {
    let avgX = 0;
    let avgY = 0;
    let j;
    const avgRangeStart = Math.floor((i + 1) * bucketWidth) + 1 + start;
    const avgRangeEnd = Math.min(Math.floor((i + 2) * bucketWidth) + 1, count) + start;
    const avgRangeLength = avgRangeEnd - avgRangeStart;
    for (j = avgRangeStart; j < avgRangeEnd; j++) {
      avgX += data[j].x;
      avgY += data[j].y;
    }
    avgX /= avgRangeLength;
    avgY /= avgRangeLength;
    const rangeOffs = Math.floor(i * bucketWidth) + 1 + start;
    const rangeTo = Math.min(Math.floor((i + 1) * bucketWidth) + 1, count) + start;
    const {
      x: pointAx,
      y: pointAy
    } = data[a];
    maxArea = area = -1;
    for (j = rangeOffs; j < rangeTo; j++) {
      area = 0.5 * Math.abs((pointAx - avgX) * (data[j].y - pointAy) - (pointAx - data[j].x) * (avgY - pointAy));
      if (area > maxArea) {
        maxArea = area;
        maxAreaPoint = data[j];
        nextA = j;
      }
    }
    decimated[sampledIndex++] = maxAreaPoint;
    a = nextA;
  }
  decimated[sampledIndex++] = data[endIndex];
  return decimated;
}
function minMaxDecimation(data, start, count, availableWidth) {
  let avgX = 0;
  let countX = 0;
  let i, point, x, y, prevX, minIndex, maxIndex, startIndex, minY, maxY;
  const decimated = [];
  const endIndex = start + count - 1;
  const xMin = data[start].x;
  const xMax = data[endIndex].x;
  const dx = xMax - xMin;
  for (i = start; i < start + count; ++i) {
    point = data[i];
    x = (point.x - xMin) / dx * availableWidth;
    y = point.y;
    const truncX = x | 0;
    if (truncX === prevX) {
      if (y < minY) {
        minY = y;
        minIndex = i;
      } else if (y > maxY) {
        maxY = y;
        maxIndex = i;
      }
      avgX = (countX * avgX + point.x) / ++countX;
    } else {
      const lastIndex = i - 1;
      if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(minIndex) && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(maxIndex)) {
        const intermediateIndex1 = Math.min(minIndex, maxIndex);
        const intermediateIndex2 = Math.max(minIndex, maxIndex);
        if (intermediateIndex1 !== startIndex && intermediateIndex1 !== lastIndex) {
          decimated.push({
            ...data[intermediateIndex1],
            x: avgX
          });
        }
        if (intermediateIndex2 !== startIndex && intermediateIndex2 !== lastIndex) {
          decimated.push({
            ...data[intermediateIndex2],
            x: avgX
          });
        }
      }
      if (i > 0 && lastIndex !== startIndex) {
        decimated.push(data[lastIndex]);
      }
      decimated.push(point);
      prevX = truncX;
      countX = 0;
      minY = maxY = y;
      minIndex = maxIndex = startIndex = i;
    }
  }
  return decimated;
}
function cleanDecimatedDataset(dataset) {
  if (dataset._decimated) {
    const data = dataset._data;
    delete dataset._decimated;
    delete dataset._data;
    Object.defineProperty(dataset, 'data', {
      configurable: true,
      enumerable: true,
      writable: true,
      value: data
    });
  }
}
function cleanDecimatedData(chart) {
  chart.data.datasets.forEach(dataset => {
    cleanDecimatedDataset(dataset);
  });
}
function getStartAndCountOfVisiblePointsSimplified(meta, points) {
  const pointCount = points.length;
  let start = 0;
  let count;
  const {
    iScale
  } = meta;
  const {
    min,
    max,
    minDefined,
    maxDefined
  } = iScale.getUserBounds();
  if (minDefined) {
    start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(points, iScale.axis, min).lo, 0, pointCount - 1);
  }
  if (maxDefined) {
    count = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(points, iScale.axis, max).hi + 1, start, pointCount) - start;
  } else {
    count = pointCount - start;
  }
  return {
    start,
    count
  };
}
var plugin_decimation = {
  id: 'decimation',
  defaults: {
    algorithm: 'min-max',
    enabled: false
  },
  beforeElementsUpdate: (chart, args, options) => {
    if (!options.enabled) {
      cleanDecimatedData(chart);
      return;
    }
    const availableWidth = chart.width;
    chart.data.datasets.forEach((dataset, datasetIndex) => {
      const {
        _data,
        indexAxis
      } = dataset;
      const meta = chart.getDatasetMeta(datasetIndex);
      const data = _data || dataset.data;
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a)([indexAxis, chart.options.indexAxis]) === 'y') {
        return;
      }
      if (!meta.controller.supportsDecimation) {
        return;
      }
      const xAxis = chart.scales[meta.xAxisID];
      if (xAxis.type !== 'linear' && xAxis.type !== 'time') {
        return;
      }
      if (chart.options.parsing) {
        return;
      }
      let {
        start,
        count
      } = getStartAndCountOfVisiblePointsSimplified(meta, data);
      const threshold = options.threshold || 4 * availableWidth;
      if (count <= threshold) {
        cleanDecimatedDataset(dataset);
        return;
      }
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(_data)) {
        dataset._data = data;
        delete dataset.data;
        Object.defineProperty(dataset, 'data', {
          configurable: true,
          enumerable: true,
          get: function () {
            return this._decimated;
          },
          set: function (d) {
            this._data = d;
          }
        });
      }
      let decimated;
      switch (options.algorithm) {
        case 'lttb':
          decimated = lttbDecimation(data, start, count, availableWidth, options);
          break;
        case 'min-max':
          decimated = minMaxDecimation(data, start, count, availableWidth);
          break;
        default:
          throw new Error(`Unsupported decimation algorithm '${options.algorithm}'`);
      }
      dataset._decimated = decimated;
    });
  },
  destroy(chart) {
    cleanDecimatedData(chart);
  }
};
function _segments(line, target, property) {
  const segments = line.segments;
  const points = line.points;
  const tpoints = target.points;
  const parts = [];
  for (const segment of segments) {
    let {
      start,
      end
    } = segment;
    end = _findSegmentEnd(start, end, points);
    const bounds = _getBounds(property, points[start], points[end], segment.loop);
    if (!target.segments) {
      parts.push({
        source: segment,
        target: bounds,
        start: points[start],
        end: points[end]
      });
      continue;
    }
    const targetSegments = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.an)(target, bounds);
    for (const tgt of targetSegments) {
      const subBounds = _getBounds(property, tpoints[tgt.start], tpoints[tgt.end], tgt.loop);
      const fillSources = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ax)(segment, points, subBounds);
      for (const fillSource of fillSources) {
        parts.push({
          source: fillSource,
          target: tgt,
          start: {
            [property]: _getEdge(bounds, subBounds, 'start', Math.max)
          },
          end: {
            [property]: _getEdge(bounds, subBounds, 'end', Math.min)
          }
        });
      }
    }
  }
  return parts;
}
function _getBounds(property, first, last, loop) {
  if (loop) {
    return;
  }
  let start = first[property];
  let end = last[property];
  if (property === 'angle') {
    start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay)(start);
    end = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay)(end);
  }
  return {
    property,
    start,
    end
  };
}
function _pointsFromSegments(boundary, line) {
  const {
    x = null,
    y = null
  } = boundary || {};
  const linePoints = line.points;
  const points = [];
  line.segments.forEach(({
    start,
    end
  }) => {
    end = _findSegmentEnd(start, end, linePoints);
    const first = linePoints[start];
    const last = linePoints[end];
    if (y !== null) {
      points.push({
        x: first.x,
        y
      });
      points.push({
        x: last.x,
        y
      });
    } else if (x !== null) {
      points.push({
        x,
        y: first.y
      });
      points.push({
        x,
        y: last.y
      });
    }
  });
  return points;
}
function _findSegmentEnd(start, end, points) {
  for (; end > start; end--) {
    const point = points[end];
    if (!isNaN(point.x) && !isNaN(point.y)) {
      break;
    }
  }
  return end;
}
function _getEdge(a, b, prop, fn) {
  if (a && b) {
    return fn(a[prop], b[prop]);
  }
  return a ? a[prop] : b ? b[prop] : 0;
}
function _createBoundaryLine(boundary, line) {
  let points = [];
  let _loop = false;
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(boundary)) {
    _loop = true;
    points = boundary;
  } else {
    points = _pointsFromSegments(boundary, line);
  }
  return points.length ? new LineElement({
    points,
    options: {
      tension: 0
    },
    _loop,
    _fullLoop: _loop
  }) : null;
}
function _shouldApplyFill(source) {
  return source && source.fill !== false;
}
function _resolveTarget(sources, index, propagate) {
  const source = sources[index];
  let fill = source.fill;
  const visited = [index];
  let target;
  if (!propagate) {
    return fill;
  }
  while (fill !== false && visited.indexOf(fill) === -1) {
    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(fill)) {
      return fill;
    }
    target = sources[fill];
    if (!target) {
      return false;
    }
    if (target.visible) {
      return fill;
    }
    visited.push(fill);
    fill = target.fill;
  }
  return false;
}
function _decodeFill(line, index, count) {
  const fill = parseFillOption(line);
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {
    return isNaN(fill.value) ? false : fill;
  }
  let target = parseFloat(fill);
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(target) && Math.floor(target) === target) {
    return decodeTargetIndex(fill[0], index, target, count);
  }
  return ['origin', 'start', 'end', 'stack', 'shape'].indexOf(fill) >= 0 && fill;
}
function decodeTargetIndex(firstCh, index, target, count) {
  if (firstCh === '-' || firstCh === '+') {
    target = index + target;
  }
  if (target === index || target < 0 || target >= count) {
    return false;
  }
  return target;
}
function _getTargetPixel(fill, scale) {
  let pixel = null;
  if (fill === 'start') {
    pixel = scale.bottom;
  } else if (fill === 'end') {
    pixel = scale.top;
  } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {
    pixel = scale.getPixelForValue(fill.value);
  } else if (scale.getBasePixel) {
    pixel = scale.getBasePixel();
  }
  return pixel;
}
function _getTargetValue(fill, scale, startValue) {
  let value;
  if (fill === 'start') {
    value = startValue;
  } else if (fill === 'end') {
    value = scale.options.reverse ? scale.min : scale.max;
  } else if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(fill)) {
    value = fill.value;
  } else {
    value = scale.getBaseValue();
  }
  return value;
}
function parseFillOption(line) {
  const options = line.options;
  const fillOption = options.fill;
  let fill = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(fillOption && fillOption.target, fillOption);
  if (fill === undefined) {
    fill = !!options.backgroundColor;
  }
  if (fill === false || fill === null) {
    return false;
  }
  if (fill === true) {
    return 'origin';
  }
  return fill;
}
function _buildStackLine(source) {
  const {
    scale,
    index,
    line
  } = source;
  const points = [];
  const segments = line.segments;
  const sourcePoints = line.points;
  const linesBelow = getLinesBelow(scale, index);
  linesBelow.push(_createBoundaryLine({
    x: null,
    y: scale.bottom
  }, line));
  for (let i = 0; i < segments.length; i++) {
    const segment = segments[i];
    for (let j = segment.start; j <= segment.end; j++) {
      addPointsBelow(points, sourcePoints[j], linesBelow);
    }
  }
  return new LineElement({
    points,
    options: {}
  });
}
function getLinesBelow(scale, index) {
  const below = [];
  const metas = scale.getMatchingVisibleMetas('line');
  for (let i = 0; i < metas.length; i++) {
    const meta = metas[i];
    if (meta.index === index) {
      break;
    }
    if (!meta.hidden) {
      below.unshift(meta.dataset);
    }
  }
  return below;
}
function addPointsBelow(points, sourcePoint, linesBelow) {
  const postponed = [];
  for (let j = 0; j < linesBelow.length; j++) {
    const line = linesBelow[j];
    const {
      first,
      last,
      point
    } = findPoint(line, sourcePoint, 'x');
    if (!point || first && last) {
      continue;
    }
    if (first) {
      postponed.unshift(point);
    } else {
      points.push(point);
      if (!last) {
        break;
      }
    }
  }
  points.push(...postponed);
}
function findPoint(line, sourcePoint, property) {
  const point = line.interpolate(sourcePoint, property);
  if (!point) {
    return {};
  }
  const pointValue = point[property];
  const segments = line.segments;
  const linePoints = line.points;
  let first = false;
  let last = false;
  for (let i = 0; i < segments.length; i++) {
    const segment = segments[i];
    const firstValue = linePoints[segment.start][property];
    const lastValue = linePoints[segment.end][property];
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(pointValue, firstValue, lastValue)) {
      first = pointValue === firstValue;
      last = pointValue === lastValue;
      break;
    }
  }
  return {
    first,
    last,
    point
  };
}
class simpleArc {
  constructor(opts) {
    this.x = opts.x;
    this.y = opts.y;
    this.radius = opts.radius;
  }
  pathSegment(ctx, bounds, opts) {
    const {
      x,
      y,
      radius
    } = this;
    bounds = bounds || {
      start: 0,
      end: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T
    };
    ctx.arc(x, y, radius, bounds.end, bounds.start, true);
    return !opts.bounds;
  }
  interpolate(point) {
    const {
      x,
      y,
      radius
    } = this;
    const angle = point.angle;
    return {
      x: x + Math.cos(angle) * radius,
      y: y + Math.sin(angle) * radius,
      angle
    };
  }
}
function _getTarget(source) {
  const {
    chart,
    fill,
    line
  } = source;
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(fill)) {
    return getLineByIndex(chart, fill);
  }
  if (fill === 'stack') {
    return _buildStackLine(source);
  }
  if (fill === 'shape') {
    return true;
  }
  const boundary = computeBoundary(source);
  if (boundary instanceof simpleArc) {
    return boundary;
  }
  return _createBoundaryLine(boundary, line);
}
function getLineByIndex(chart, index) {
  const meta = chart.getDatasetMeta(index);
  const visible = meta && chart.isDatasetVisible(index);
  return visible ? meta.dataset : null;
}
function computeBoundary(source) {
  const scale = source.scale || {};
  if (scale.getPointPositionForValue) {
    return computeCircularBoundary(source);
  }
  return computeLinearBoundary(source);
}
function computeLinearBoundary(source) {
  const {
    scale = {},
    fill
  } = source;
  const pixel = _getTargetPixel(fill, scale);
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(pixel)) {
    const horizontal = scale.isHorizontal();
    return {
      x: horizontal ? pixel : null,
      y: horizontal ? null : pixel
    };
  }
  return null;
}
function computeCircularBoundary(source) {
  const {
    scale,
    fill
  } = source;
  const options = scale.options;
  const length = scale.getLabels().length;
  const start = options.reverse ? scale.max : scale.min;
  const value = _getTargetValue(fill, scale, start);
  const target = [];
  if (options.grid.circular) {
    const center = scale.getPointPositionForValue(0, start);
    return new simpleArc({
      x: center.x,
      y: center.y,
      radius: scale.getDistanceFromCenterForValue(value)
    });
  }
  for (let i = 0; i < length; ++i) {
    target.push(scale.getPointPositionForValue(i, value));
  }
  return target;
}
function _drawfill(ctx, source, area) {
  const target = _getTarget(source);
  const {
    line,
    scale,
    axis
  } = source;
  const lineOpts = line.options;
  const fillOption = lineOpts.fill;
  const color = lineOpts.backgroundColor;
  const {
    above = color,
    below = color
  } = fillOption || {};
  if (target && line.points.length) {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, area);
    doFill(ctx, {
      line,
      target,
      above,
      below,
      area,
      scale,
      axis
    });
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);
  }
}
function doFill(ctx, cfg) {
  const {
    line,
    target,
    above,
    below,
    area,
    scale
  } = cfg;
  const property = line._loop ? 'angle' : cfg.axis;
  ctx.save();
  if (property === 'x' && below !== above) {
    clipVertical(ctx, target, area.top);
    fill(ctx, {
      line,
      target,
      color: above,
      scale,
      property
    });
    ctx.restore();
    ctx.save();
    clipVertical(ctx, target, area.bottom);
  }
  fill(ctx, {
    line,
    target,
    color: below,
    scale,
    property
  });
  ctx.restore();
}
function clipVertical(ctx, target, clipY) {
  const {
    segments,
    points
  } = target;
  let first = true;
  let lineLoop = false;
  ctx.beginPath();
  for (const segment of segments) {
    const {
      start,
      end
    } = segment;
    const firstPoint = points[start];
    const lastPoint = points[_findSegmentEnd(start, end, points)];
    if (first) {
      ctx.moveTo(firstPoint.x, firstPoint.y);
      first = false;
    } else {
      ctx.lineTo(firstPoint.x, clipY);
      ctx.lineTo(firstPoint.x, firstPoint.y);
    }
    lineLoop = !!target.pathSegment(ctx, segment, {
      move: lineLoop
    });
    if (lineLoop) {
      ctx.closePath();
    } else {
      ctx.lineTo(lastPoint.x, clipY);
    }
  }
  ctx.lineTo(target.first().x, clipY);
  ctx.closePath();
  ctx.clip();
}
function fill(ctx, cfg) {
  const {
    line,
    target,
    property,
    color,
    scale
  } = cfg;
  const segments = _segments(line, target, property);
  for (const {
    source: src,
    target: tgt,
    start,
    end
  } of segments) {
    const {
      style: {
        backgroundColor = color
      } = {}
    } = src;
    const notShape = target !== true;
    ctx.save();
    ctx.fillStyle = backgroundColor;
    clipBounds(ctx, scale, notShape && _getBounds(property, start, end));
    ctx.beginPath();
    const lineLoop = !!line.pathSegment(ctx, src);
    let loop;
    if (notShape) {
      if (lineLoop) {
        ctx.closePath();
      } else {
        interpolatedLineTo(ctx, target, end, property);
      }
      const targetLoop = !!target.pathSegment(ctx, tgt, {
        move: lineLoop,
        reverse: true
      });
      loop = lineLoop && targetLoop;
      if (!loop) {
        interpolatedLineTo(ctx, target, start, property);
      }
    }
    ctx.closePath();
    ctx.fill(loop ? 'evenodd' : 'nonzero');
    ctx.restore();
  }
}
function clipBounds(ctx, scale, bounds) {
  const {
    top,
    bottom
  } = scale.chart.chartArea;
  const {
    property,
    start,
    end
  } = bounds || {};
  if (property === 'x') {
    ctx.beginPath();
    ctx.rect(start, top, end - start, bottom - top);
    ctx.clip();
  }
}
function interpolatedLineTo(ctx, target, point, property) {
  const interpolatedPoint = target.interpolate(point, property);
  if (interpolatedPoint) {
    ctx.lineTo(interpolatedPoint.x, interpolatedPoint.y);
  }
}
var index = {
  id: 'filler',
  afterDatasetsUpdate(chart, _args, options) {
    const count = (chart.data.datasets || []).length;
    const sources = [];
    let meta, i, line, source;
    for (i = 0; i < count; ++i) {
      meta = chart.getDatasetMeta(i);
      line = meta.dataset;
      source = null;
      if (line && line.options && line instanceof LineElement) {
        source = {
          visible: chart.isDatasetVisible(i),
          index: i,
          fill: _decodeFill(line, i, count),
          chart,
          axis: meta.controller.options.indexAxis,
          scale: meta.vScale,
          line
        };
      }
      meta.$filler = source;
      sources.push(source);
    }
    for (i = 0; i < count; ++i) {
      source = sources[i];
      if (!source || source.fill === false) {
        continue;
      }
      source.fill = _resolveTarget(sources, i, options.propagate);
    }
  },
  beforeDraw(chart, _args, options) {
    const draw = options.drawTime === 'beforeDraw';
    const metasets = chart.getSortedVisibleDatasetMetas();
    const area = chart.chartArea;
    for (let i = metasets.length - 1; i >= 0; --i) {
      const source = metasets[i].$filler;
      if (!source) {
        continue;
      }
      source.line.updateControlPoints(area, source.axis);
      if (draw && source.fill) {
        _drawfill(chart.ctx, source, area);
      }
    }
  },
  beforeDatasetsDraw(chart, _args, options) {
    if (options.drawTime !== 'beforeDatasetsDraw') {
      return;
    }
    const metasets = chart.getSortedVisibleDatasetMetas();
    for (let i = metasets.length - 1; i >= 0; --i) {
      const source = metasets[i].$filler;
      if (_shouldApplyFill(source)) {
        _drawfill(chart.ctx, source, chart.chartArea);
      }
    }
  },
  beforeDatasetDraw(chart, args, options) {
    const source = args.meta.$filler;
    if (!_shouldApplyFill(source) || options.drawTime !== 'beforeDatasetDraw') {
      return;
    }
    _drawfill(chart.ctx, source, chart.chartArea);
  },
  defaults: {
    propagate: true,
    drawTime: 'beforeDatasetDraw'
  }
};
const getBoxSize = (labelOpts, fontSize) => {
  let {
    boxHeight = fontSize,
    boxWidth = fontSize
  } = labelOpts;
  if (labelOpts.usePointStyle) {
    boxHeight = Math.min(boxHeight, fontSize);
    boxWidth = labelOpts.pointStyleWidth || Math.min(boxWidth, fontSize);
  }
  return {
    boxWidth,
    boxHeight,
    itemHeight: Math.max(fontSize, boxHeight)
  };
};
const itemsEqual = (a, b) => a !== null && b !== null && a.datasetIndex === b.datasetIndex && a.index === b.index;
class Legend extends Element {
  constructor(config) {
    super();
    this._added = false;
    this.legendHitBoxes = [];
    this._hoveredItem = null;
    this.doughnutMode = false;
    this.chart = config.chart;
    this.options = config.options;
    this.ctx = config.ctx;
    this.legendItems = undefined;
    this.columnSizes = undefined;
    this.lineWidths = undefined;
    this.maxHeight = undefined;
    this.maxWidth = undefined;
    this.top = undefined;
    this.bottom = undefined;
    this.left = undefined;
    this.right = undefined;
    this.height = undefined;
    this.width = undefined;
    this._margins = undefined;
    this.position = undefined;
    this.weight = undefined;
    this.fullSize = undefined;
  }
  update(maxWidth, maxHeight, margins) {
    this.maxWidth = maxWidth;
    this.maxHeight = maxHeight;
    this._margins = margins;
    this.setDimensions();
    this.buildLabels();
    this.fit();
  }
  setDimensions() {
    if (this.isHorizontal()) {
      this.width = this.maxWidth;
      this.left = this._margins.left;
      this.right = this.width;
    } else {
      this.height = this.maxHeight;
      this.top = this._margins.top;
      this.bottom = this.height;
    }
  }
  buildLabels() {
    const labelOpts = this.options.labels || {};
    let legendItems = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(labelOpts.generateLabels, [this.chart], this) || [];
    if (labelOpts.filter) {
      legendItems = legendItems.filter(item => labelOpts.filter(item, this.chart.data));
    }
    if (labelOpts.sort) {
      legendItems = legendItems.sort((a, b) => labelOpts.sort(a, b, this.chart.data));
    }
    if (this.options.reverse) {
      legendItems.reverse();
    }
    this.legendItems = legendItems;
  }
  fit() {
    const {
      options,
      ctx
    } = this;
    if (!options.display) {
      this.width = this.height = 0;
      return;
    }
    const labelOpts = options.labels;
    const labelFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(labelOpts.font);
    const fontSize = labelFont.size;
    const titleHeight = this._computeTitleHeight();
    const {
      boxWidth,
      itemHeight
    } = getBoxSize(labelOpts, fontSize);
    let width, height;
    ctx.font = labelFont.string;
    if (this.isHorizontal()) {
      width = this.maxWidth;
      height = this._fitRows(titleHeight, fontSize, boxWidth, itemHeight) + 10;
    } else {
      height = this.maxHeight;
      width = this._fitCols(titleHeight, labelFont, boxWidth, itemHeight) + 10;
    }
    this.width = Math.min(width, options.maxWidth || this.maxWidth);
    this.height = Math.min(height, options.maxHeight || this.maxHeight);
  }
  _fitRows(titleHeight, fontSize, boxWidth, itemHeight) {
    const {
      ctx,
      maxWidth,
      options: {
        labels: {
          padding
        }
      }
    } = this;
    const hitboxes = this.legendHitBoxes = [];
    const lineWidths = this.lineWidths = [0];
    const lineHeight = itemHeight + padding;
    let totalHeight = titleHeight;
    ctx.textAlign = 'left';
    ctx.textBaseline = 'middle';
    let row = -1;
    let top = -lineHeight;
    this.legendItems.forEach((legendItem, i) => {
      const itemWidth = boxWidth + fontSize / 2 + ctx.measureText(legendItem.text).width;
      if (i === 0 || lineWidths[lineWidths.length - 1] + itemWidth + 2 * padding > maxWidth) {
        totalHeight += lineHeight;
        lineWidths[lineWidths.length - (i > 0 ? 0 : 1)] = 0;
        top += lineHeight;
        row++;
      }
      hitboxes[i] = {
        left: 0,
        top,
        row,
        width: itemWidth,
        height: itemHeight
      };
      lineWidths[lineWidths.length - 1] += itemWidth + padding;
    });
    return totalHeight;
  }
  _fitCols(titleHeight, labelFont, boxWidth, _itemHeight) {
    const {
      ctx,
      maxHeight,
      options: {
        labels: {
          padding
        }
      }
    } = this;
    const hitboxes = this.legendHitBoxes = [];
    const columnSizes = this.columnSizes = [];
    const heightLimit = maxHeight - titleHeight;
    let totalWidth = padding;
    let currentColWidth = 0;
    let currentColHeight = 0;
    let left = 0;
    let col = 0;
    this.legendItems.forEach((legendItem, i) => {
      const {
        itemWidth,
        itemHeight
      } = calculateItemSize(boxWidth, labelFont, ctx, legendItem, _itemHeight);
      if (i > 0 && currentColHeight + itemHeight + 2 * padding > heightLimit) {
        totalWidth += currentColWidth + padding;
        columnSizes.push({
          width: currentColWidth,
          height: currentColHeight
        });
        left += currentColWidth + padding;
        col++;
        currentColWidth = currentColHeight = 0;
      }
      hitboxes[i] = {
        left,
        top: currentColHeight,
        col,
        width: itemWidth,
        height: itemHeight
      };
      currentColWidth = Math.max(currentColWidth, itemWidth);
      currentColHeight += itemHeight + padding;
    });
    totalWidth += currentColWidth;
    columnSizes.push({
      width: currentColWidth,
      height: currentColHeight
    });
    return totalWidth;
  }
  adjustHitBoxes() {
    if (!this.options.display) {
      return;
    }
    const titleHeight = this._computeTitleHeight();
    const {
      legendHitBoxes: hitboxes,
      options: {
        align,
        labels: {
          padding
        },
        rtl
      }
    } = this;
    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(rtl, this.left, this.width);
    if (this.isHorizontal()) {
      let row = 0;
      let left = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - this.lineWidths[row]);
      for (const hitbox of hitboxes) {
        if (row !== hitbox.row) {
          row = hitbox.row;
          left = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - this.lineWidths[row]);
        }
        hitbox.top += this.top + titleHeight + padding;
        hitbox.left = rtlHelper.leftForLtr(rtlHelper.x(left), hitbox.width);
        left += hitbox.width + padding;
      }
    } else {
      let col = 0;
      let top = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - this.columnSizes[col].height);
      for (const hitbox of hitboxes) {
        if (hitbox.col !== col) {
          col = hitbox.col;
          top = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - this.columnSizes[col].height);
        }
        hitbox.top = top;
        hitbox.left += this.left + padding;
        hitbox.left = rtlHelper.leftForLtr(rtlHelper.x(hitbox.left), hitbox.width);
        top += hitbox.height + padding;
      }
    }
  }
  isHorizontal() {
    return this.options.position === 'top' || this.options.position === 'bottom';
  }
  draw() {
    if (this.options.display) {
      const ctx = this.ctx;
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Y)(ctx, this);
      this._draw();
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.$)(ctx);
    }
  }
  _draw() {
    const {
      options: opts,
      columnSizes,
      lineWidths,
      ctx
    } = this;
    const {
      align,
      labels: labelOpts
    } = opts;
    const defaultColor = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.color;
    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(opts.rtl, this.left, this.width);
    const labelFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(labelOpts.font);
    const {
      padding
    } = labelOpts;
    const fontSize = labelFont.size;
    const halfFontSize = fontSize / 2;
    let cursor;
    this.drawTitle();
    ctx.textAlign = rtlHelper.textAlign('left');
    ctx.textBaseline = 'middle';
    ctx.lineWidth = 0.5;
    ctx.font = labelFont.string;
    const {
      boxWidth,
      boxHeight,
      itemHeight
    } = getBoxSize(labelOpts, fontSize);
    const drawLegendBox = function (x, y, legendItem) {
      if (isNaN(boxWidth) || boxWidth <= 0 || isNaN(boxHeight) || boxHeight < 0) {
        return;
      }
      ctx.save();
      const lineWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineWidth, 1);
      ctx.fillStyle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.fillStyle, defaultColor);
      ctx.lineCap = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineCap, 'butt');
      ctx.lineDashOffset = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineDashOffset, 0);
      ctx.lineJoin = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineJoin, 'miter');
      ctx.lineWidth = lineWidth;
      ctx.strokeStyle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.strokeStyle, defaultColor);
      ctx.setLineDash((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(legendItem.lineDash, []));
      if (labelOpts.usePointStyle) {
        const drawOptions = {
          radius: boxHeight * Math.SQRT2 / 2,
          pointStyle: legendItem.pointStyle,
          rotation: legendItem.rotation,
          borderWidth: lineWidth
        };
        const centerX = rtlHelper.xPlus(x, boxWidth / 2);
        const centerY = y + halfFontSize;
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aD)(ctx, drawOptions, centerX, centerY, labelOpts.pointStyleWidth && boxWidth);
      } else {
        const yBoxTop = y + Math.max((fontSize - boxHeight) / 2, 0);
        const xBoxLeft = rtlHelper.leftForLtr(x, boxWidth);
        const borderRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(legendItem.borderRadius);
        ctx.beginPath();
        if (Object.values(borderRadius).some(v => v !== 0)) {
          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, {
            x: xBoxLeft,
            y: yBoxTop,
            w: boxWidth,
            h: boxHeight,
            radius: borderRadius
          });
        } else {
          ctx.rect(xBoxLeft, yBoxTop, boxWidth, boxHeight);
        }
        ctx.fill();
        if (lineWidth !== 0) {
          ctx.stroke();
        }
      }
      ctx.restore();
    };
    const fillText = function (x, y, legendItem) {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, legendItem.text, x, y + itemHeight / 2, labelFont, {
        strikethrough: legendItem.hidden,
        textAlign: rtlHelper.textAlign(legendItem.textAlign)
      });
    };
    const isHorizontal = this.isHorizontal();
    const titleHeight = this._computeTitleHeight();
    if (isHorizontal) {
      cursor = {
        x: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - lineWidths[0]),
        y: this.top + padding + titleHeight,
        line: 0
      };
    } else {
      cursor = {
        x: this.left + padding,
        y: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - columnSizes[0].height),
        line: 0
      };
    }
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aA)(this.ctx, opts.textDirection);
    const lineHeight = itemHeight + padding;
    this.legendItems.forEach((legendItem, i) => {
      ctx.strokeStyle = legendItem.fontColor;
      ctx.fillStyle = legendItem.fontColor;
      const textWidth = ctx.measureText(legendItem.text).width;
      const textAlign = rtlHelper.textAlign(legendItem.textAlign || (legendItem.textAlign = labelOpts.textAlign));
      const width = boxWidth + halfFontSize + textWidth;
      let x = cursor.x;
      let y = cursor.y;
      rtlHelper.setWidth(this.width);
      if (isHorizontal) {
        if (i > 0 && x + width + padding > this.right) {
          y = cursor.y += lineHeight;
          cursor.line++;
          x = cursor.x = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.left + padding, this.right - lineWidths[cursor.line]);
        }
      } else if (i > 0 && y + lineHeight > this.bottom) {
        x = cursor.x = x + columnSizes[cursor.line].width + padding;
        cursor.line++;
        y = cursor.y = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, this.top + titleHeight + padding, this.bottom - columnSizes[cursor.line].height);
      }
      const realX = rtlHelper.x(x);
      drawLegendBox(realX, y, legendItem);
      x = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aB)(textAlign, x + boxWidth + halfFontSize, isHorizontal ? x + width : this.right, opts.rtl);
      fillText(rtlHelper.x(x), y, legendItem);
      if (isHorizontal) {
        cursor.x += width + padding;
      } else if (typeof legendItem.text !== 'string') {
        const fontLineHeight = labelFont.lineHeight;
        cursor.y += calculateLegendItemHeight(legendItem, fontLineHeight) + padding;
      } else {
        cursor.y += lineHeight;
      }
    });
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aC)(this.ctx, opts.textDirection);
  }
  drawTitle() {
    const opts = this.options;
    const titleOpts = opts.title;
    const titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(titleOpts.font);
    const titlePadding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(titleOpts.padding);
    if (!titleOpts.display) {
      return;
    }
    const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(opts.rtl, this.left, this.width);
    const ctx = this.ctx;
    const position = titleOpts.position;
    const halfFontSize = titleFont.size / 2;
    const topPaddingPlusHalfFontSize = titlePadding.top + halfFontSize;
    let y;
    let left = this.left;
    let maxWidth = this.width;
    if (this.isHorizontal()) {
      maxWidth = Math.max(...this.lineWidths);
      y = this.top + topPaddingPlusHalfFontSize;
      left = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(opts.align, left, this.right - maxWidth);
    } else {
      const maxHeight = this.columnSizes.reduce((acc, size) => Math.max(acc, size.height), 0);
      y = topPaddingPlusHalfFontSize + (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(opts.align, this.top, this.bottom - maxHeight - opts.labels.padding - this._computeTitleHeight());
    }
    const x = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(position, left, left + maxWidth);
    ctx.textAlign = rtlHelper.textAlign((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a1)(position));
    ctx.textBaseline = 'middle';
    ctx.strokeStyle = titleOpts.color;
    ctx.fillStyle = titleOpts.color;
    ctx.font = titleFont.string;
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, titleOpts.text, x, y, titleFont);
  }
  _computeTitleHeight() {
    const titleOpts = this.options.title;
    const titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(titleOpts.font);
    const titlePadding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(titleOpts.padding);
    return titleOpts.display ? titleFont.lineHeight + titlePadding.height : 0;
  }
  _getLegendItemAt(x, y) {
    let i, hitBox, lh;
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(x, this.left, this.right) && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(y, this.top, this.bottom)) {
      lh = this.legendHitBoxes;
      for (i = 0; i < lh.length; ++i) {
        hitBox = lh[i];
        if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(x, hitBox.left, hitBox.left + hitBox.width) && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aj)(y, hitBox.top, hitBox.top + hitBox.height)) {
          return this.legendItems[i];
        }
      }
    }
    return null;
  }
  handleEvent(e) {
    const opts = this.options;
    if (!isListened(e.type, opts)) {
      return;
    }
    const hoveredItem = this._getLegendItemAt(e.x, e.y);
    if (e.type === 'mousemove' || e.type === 'mouseout') {
      const previous = this._hoveredItem;
      const sameItem = itemsEqual(previous, hoveredItem);
      if (previous && !sameItem) {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(opts.onLeave, [e, previous, this], this);
      }
      this._hoveredItem = hoveredItem;
      if (hoveredItem && !sameItem) {
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(opts.onHover, [e, hoveredItem, this], this);
      }
    } else if (hoveredItem) {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(opts.onClick, [e, hoveredItem, this], this);
    }
  }
}
function calculateItemSize(boxWidth, labelFont, ctx, legendItem, _itemHeight) {
  const itemWidth = calculateItemWidth(legendItem, boxWidth, labelFont, ctx);
  const itemHeight = calculateItemHeight(_itemHeight, legendItem, labelFont.lineHeight);
  return {
    itemWidth,
    itemHeight
  };
}
function calculateItemWidth(legendItem, boxWidth, labelFont, ctx) {
  let legendItemText = legendItem.text;
  if (legendItemText && typeof legendItemText !== 'string') {
    legendItemText = legendItemText.reduce((a, b) => a.length > b.length ? a : b);
  }
  return boxWidth + labelFont.size / 2 + ctx.measureText(legendItemText).width;
}
function calculateItemHeight(_itemHeight, legendItem, fontLineHeight) {
  let itemHeight = _itemHeight;
  if (typeof legendItem.text !== 'string') {
    itemHeight = calculateLegendItemHeight(legendItem, fontLineHeight);
  }
  return itemHeight;
}
function calculateLegendItemHeight(legendItem, fontLineHeight) {
  const labelHeight = legendItem.text ? legendItem.text.length : 0;
  return fontLineHeight * labelHeight;
}
function isListened(type, opts) {
  if ((type === 'mousemove' || type === 'mouseout') && (opts.onHover || opts.onLeave)) {
    return true;
  }
  if (opts.onClick && (type === 'click' || type === 'mouseup')) {
    return true;
  }
  return false;
}
var plugin_legend = {
  id: 'legend',
  _element: Legend,
  start(chart, _args, options) {
    const legend = chart.legend = new Legend({
      ctx: chart.ctx,
      options,
      chart
    });
    layouts.configure(chart, legend, options);
    layouts.addBox(chart, legend);
  },
  stop(chart) {
    layouts.removeBox(chart, chart.legend);
    delete chart.legend;
  },
  beforeUpdate(chart, _args, options) {
    const legend = chart.legend;
    layouts.configure(chart, legend, options);
    legend.options = options;
  },
  afterUpdate(chart) {
    const legend = chart.legend;
    legend.buildLabels();
    legend.adjustHitBoxes();
  },
  afterEvent(chart, args) {
    if (!args.replay) {
      chart.legend.handleEvent(args.event);
    }
  },
  defaults: {
    display: true,
    position: 'top',
    align: 'center',
    fullSize: true,
    reverse: false,
    weight: 1000,
    onClick(e, legendItem, legend) {
      const index = legendItem.datasetIndex;
      const ci = legend.chart;
      if (ci.isDatasetVisible(index)) {
        ci.hide(index);
        legendItem.hidden = true;
      } else {
        ci.show(index);
        legendItem.hidden = false;
      }
    },
    onHover: null,
    onLeave: null,
    labels: {
      color: ctx => ctx.chart.options.color,
      boxWidth: 40,
      padding: 10,
      generateLabels(chart) {
        const datasets = chart.data.datasets;
        const {
          labels: {
            usePointStyle,
            pointStyle,
            textAlign,
            color,
            useBorderRadius,
            borderRadius
          }
        } = chart.legend.options;
        return chart._getSortedDatasetMetas().map(meta => {
          const style = meta.controller.getStyle(usePointStyle ? 0 : undefined);
          const borderWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(style.borderWidth);
          return {
            text: datasets[meta.index].label,
            fillStyle: style.backgroundColor,
            fontColor: color,
            hidden: !meta.visible,
            lineCap: style.borderCapStyle,
            lineDash: style.borderDash,
            lineDashOffset: style.borderDashOffset,
            lineJoin: style.borderJoinStyle,
            lineWidth: (borderWidth.width + borderWidth.height) / 4,
            strokeStyle: style.borderColor,
            pointStyle: pointStyle || style.pointStyle,
            rotation: style.rotation,
            textAlign: textAlign || style.textAlign,
            borderRadius: useBorderRadius && (borderRadius || style.borderRadius),
            datasetIndex: meta.index
          };
        }, this);
      }
    },
    title: {
      color: ctx => ctx.chart.options.color,
      display: false,
      position: 'center',
      text: ''
    }
  },
  descriptors: {
    _scriptable: name => !name.startsWith('on'),
    labels: {
      _scriptable: name => !['generateLabels', 'filter', 'sort'].includes(name)
    }
  }
};
class Title extends Element {
  constructor(config) {
    super();
    this.chart = config.chart;
    this.options = config.options;
    this.ctx = config.ctx;
    this._padding = undefined;
    this.top = undefined;
    this.bottom = undefined;
    this.left = undefined;
    this.right = undefined;
    this.width = undefined;
    this.height = undefined;
    this.position = undefined;
    this.weight = undefined;
    this.fullSize = undefined;
  }
  update(maxWidth, maxHeight) {
    const opts = this.options;
    this.left = 0;
    this.top = 0;
    if (!opts.display) {
      this.width = this.height = this.right = this.bottom = 0;
      return;
    }
    this.width = this.right = maxWidth;
    this.height = this.bottom = maxHeight;
    const lineCount = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(opts.text) ? opts.text.length : 1;
    this._padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(opts.padding);
    const textSize = lineCount * (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font).lineHeight + this._padding.height;
    if (this.isHorizontal()) {
      this.height = textSize;
    } else {
      this.width = textSize;
    }
  }
  isHorizontal() {
    const pos = this.options.position;
    return pos === 'top' || pos === 'bottom';
  }
  _drawArgs(offset) {
    const {
      top,
      left,
      bottom,
      right,
      options
    } = this;
    const align = options.align;
    let rotation = 0;
    let maxWidth, titleX, titleY;
    if (this.isHorizontal()) {
      titleX = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, left, right);
      titleY = top + offset;
      maxWidth = right - left;
    } else {
      if (options.position === 'left') {
        titleX = left + offset;
        titleY = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, bottom, top);
        rotation = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P * -0.5;
      } else {
        titleX = right - offset;
        titleY = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a2)(align, top, bottom);
        rotation = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P * 0.5;
      }
      maxWidth = bottom - top;
    }
    return {
      titleX,
      titleY,
      maxWidth,
      rotation
    };
  }
  draw() {
    const ctx = this.ctx;
    const opts = this.options;
    if (!opts.display) {
      return;
    }
    const fontOpts = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font);
    const lineHeight = fontOpts.lineHeight;
    const offset = lineHeight / 2 + this._padding.top;
    const {
      titleX,
      titleY,
      maxWidth,
      rotation
    } = this._drawArgs(offset);
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, opts.text, 0, 0, fontOpts, {
      color: opts.color,
      maxWidth,
      rotation,
      textAlign: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a1)(opts.align),
      textBaseline: 'middle',
      translation: [titleX, titleY]
    });
  }
}
function createTitle(chart, titleOpts) {
  const title = new Title({
    ctx: chart.ctx,
    options: titleOpts,
    chart
  });
  layouts.configure(chart, title, titleOpts);
  layouts.addBox(chart, title);
  chart.titleBlock = title;
}
var plugin_title = {
  id: 'title',
  _element: Title,
  start(chart, _args, options) {
    createTitle(chart, options);
  },
  stop(chart) {
    const titleBlock = chart.titleBlock;
    layouts.removeBox(chart, titleBlock);
    delete chart.titleBlock;
  },
  beforeUpdate(chart, _args, options) {
    const title = chart.titleBlock;
    layouts.configure(chart, title, options);
    title.options = options;
  },
  defaults: {
    align: 'center',
    display: false,
    font: {
      weight: 'bold'
    },
    fullSize: true,
    padding: 10,
    position: 'top',
    text: '',
    weight: 2000
  },
  defaultRoutes: {
    color: 'color'
  },
  descriptors: {
    _scriptable: true,
    _indexable: false
  }
};
const map = new WeakMap();
var plugin_subtitle = {
  id: 'subtitle',
  start(chart, _args, options) {
    const title = new Title({
      ctx: chart.ctx,
      options,
      chart
    });
    layouts.configure(chart, title, options);
    layouts.addBox(chart, title);
    map.set(chart, title);
  },
  stop(chart) {
    layouts.removeBox(chart, map.get(chart));
    map.delete(chart);
  },
  beforeUpdate(chart, _args, options) {
    const title = map.get(chart);
    layouts.configure(chart, title, options);
    title.options = options;
  },
  defaults: {
    align: 'center',
    display: false,
    font: {
      weight: 'normal'
    },
    fullSize: true,
    padding: 0,
    position: 'top',
    text: '',
    weight: 1500
  },
  defaultRoutes: {
    color: 'color'
  },
  descriptors: {
    _scriptable: true,
    _indexable: false
  }
};
const positioners = {
  average(items) {
    if (!items.length) {
      return false;
    }
    let i, len;
    let xSet = new Set();
    let y = 0;
    let count = 0;
    for (i = 0, len = items.length; i < len; ++i) {
      const el = items[i].element;
      if (el && el.hasValue()) {
        const pos = el.tooltipPosition();
        xSet.add(pos.x);
        y += pos.y;
        ++count;
      }
    }
    if (count === 0 || xSet.size === 0) {
      return false;
    }
    const xAverage = [...xSet].reduce((a, b) => a + b) / xSet.size;
    return {
      x: xAverage,
      y: y / count
    };
  },
  nearest(items, eventPosition) {
    if (!items.length) {
      return false;
    }
    let x = eventPosition.x;
    let y = eventPosition.y;
    let minDistance = Number.POSITIVE_INFINITY;
    let i, len, nearestElement;
    for (i = 0, len = items.length; i < len; ++i) {
      const el = items[i].element;
      if (el && el.hasValue()) {
        const center = el.getCenterPoint();
        const d = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aE)(eventPosition, center);
        if (d < minDistance) {
          minDistance = d;
          nearestElement = el;
        }
      }
    }
    if (nearestElement) {
      const tp = nearestElement.tooltipPosition();
      x = tp.x;
      y = tp.y;
    }
    return {
      x,
      y
    };
  }
};
function pushOrConcat(base, toPush) {
  if (toPush) {
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(toPush)) {
      Array.prototype.push.apply(base, toPush);
    } else {
      base.push(toPush);
    }
  }
  return base;
}
function splitNewlines(str) {
  if ((typeof str === 'string' || str instanceof String) && str.indexOf('\n') > -1) {
    return str.split('\n');
  }
  return str;
}
function createTooltipItem(chart, item) {
  const {
    element,
    datasetIndex,
    index
  } = item;
  const controller = chart.getDatasetMeta(datasetIndex).controller;
  const {
    label,
    value
  } = controller.getLabelAndValue(index);
  return {
    chart,
    label,
    parsed: controller.getParsed(index),
    raw: chart.data.datasets[datasetIndex].data[index],
    formattedValue: value,
    dataset: controller.getDataset(),
    dataIndex: index,
    datasetIndex,
    element
  };
}
function getTooltipSize(tooltip, options) {
  const ctx = tooltip.chart.ctx;
  const {
    body,
    footer,
    title
  } = tooltip;
  const {
    boxWidth,
    boxHeight
  } = options;
  const bodyFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.bodyFont);
  const titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.titleFont);
  const footerFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.footerFont);
  const titleLineCount = title.length;
  const footerLineCount = footer.length;
  const bodyLineItemCount = body.length;
  const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);
  let height = padding.height;
  let width = 0;
  let combinedBodyLength = body.reduce((count, bodyItem) => count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length, 0);
  combinedBodyLength += tooltip.beforeBody.length + tooltip.afterBody.length;
  if (titleLineCount) {
    height += titleLineCount * titleFont.lineHeight + (titleLineCount - 1) * options.titleSpacing + options.titleMarginBottom;
  }
  if (combinedBodyLength) {
    const bodyLineHeight = options.displayColors ? Math.max(boxHeight, bodyFont.lineHeight) : bodyFont.lineHeight;
    height += bodyLineItemCount * bodyLineHeight + (combinedBodyLength - bodyLineItemCount) * bodyFont.lineHeight + (combinedBodyLength - 1) * options.bodySpacing;
  }
  if (footerLineCount) {
    height += options.footerMarginTop + footerLineCount * footerFont.lineHeight + (footerLineCount - 1) * options.footerSpacing;
  }
  let widthPadding = 0;
  const maxLineWidth = function (line) {
    width = Math.max(width, ctx.measureText(line).width + widthPadding);
  };
  ctx.save();
  ctx.font = titleFont.string;
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltip.title, maxLineWidth);
  ctx.font = bodyFont.string;
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltip.beforeBody.concat(tooltip.afterBody), maxLineWidth);
  widthPadding = options.displayColors ? boxWidth + 2 + options.boxPadding : 0;
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(body, bodyItem => {
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.before, maxLineWidth);
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.lines, maxLineWidth);
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.after, maxLineWidth);
  });
  widthPadding = 0;
  ctx.font = footerFont.string;
  (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltip.footer, maxLineWidth);
  ctx.restore();
  width += padding.width;
  return {
    width,
    height
  };
}
function determineYAlign(chart, size) {
  const {
    y,
    height
  } = size;
  if (y < height / 2) {
    return 'top';
  } else if (y > chart.height - height / 2) {
    return 'bottom';
  }
  return 'center';
}
function doesNotFitWithAlign(xAlign, chart, options, size) {
  const {
    x,
    width
  } = size;
  const caret = options.caretSize + options.caretPadding;
  if (xAlign === 'left' && x + width + caret > chart.width) {
    return true;
  }
  if (xAlign === 'right' && x - width - caret < 0) {
    return true;
  }
}
function determineXAlign(chart, options, size, yAlign) {
  const {
    x,
    width
  } = size;
  const {
    width: chartWidth,
    chartArea: {
      left,
      right
    }
  } = chart;
  let xAlign = 'center';
  if (yAlign === 'center') {
    xAlign = x <= (left + right) / 2 ? 'left' : 'right';
  } else if (x <= width / 2) {
    xAlign = 'left';
  } else if (x >= chartWidth - width / 2) {
    xAlign = 'right';
  }
  if (doesNotFitWithAlign(xAlign, chart, options, size)) {
    xAlign = 'center';
  }
  return xAlign;
}
function determineAlignment(chart, options, size) {
  const yAlign = size.yAlign || options.yAlign || determineYAlign(chart, size);
  return {
    xAlign: size.xAlign || options.xAlign || determineXAlign(chart, options, size, yAlign),
    yAlign
  };
}
function alignX(size, xAlign) {
  let {
    x,
    width
  } = size;
  if (xAlign === 'right') {
    x -= width;
  } else if (xAlign === 'center') {
    x -= width / 2;
  }
  return x;
}
function alignY(size, yAlign, paddingAndSize) {
  let {
    y,
    height
  } = size;
  if (yAlign === 'top') {
    y += paddingAndSize;
  } else if (yAlign === 'bottom') {
    y -= height + paddingAndSize;
  } else {
    y -= height / 2;
  }
  return y;
}
function getBackgroundPoint(options, size, alignment, chart) {
  const {
    caretSize,
    caretPadding,
    cornerRadius
  } = options;
  const {
    xAlign,
    yAlign
  } = alignment;
  const paddingAndSize = caretSize + caretPadding;
  const {
    topLeft,
    topRight,
    bottomLeft,
    bottomRight
  } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(cornerRadius);
  let x = alignX(size, xAlign);
  const y = alignY(size, yAlign, paddingAndSize);
  if (yAlign === 'center') {
    if (xAlign === 'left') {
      x += paddingAndSize;
    } else if (xAlign === 'right') {
      x -= paddingAndSize;
    }
  } else if (xAlign === 'left') {
    x -= Math.max(topLeft, bottomLeft) + caretSize;
  } else if (xAlign === 'right') {
    x += Math.max(topRight, bottomRight) + caretSize;
  }
  return {
    x: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(x, 0, chart.width - size.width),
    y: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(y, 0, chart.height - size.height)
  };
}
function getAlignedX(tooltip, align, options) {
  const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);
  return align === 'center' ? tooltip.x + tooltip.width / 2 : align === 'right' ? tooltip.x + tooltip.width - padding.right : tooltip.x + padding.left;
}
function getBeforeAfterBodyLines(callback) {
  return pushOrConcat([], splitNewlines(callback));
}
function createTooltipContext(parent, tooltip, tooltipItems) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {
    tooltip,
    tooltipItems,
    type: 'tooltip'
  });
}
function overrideCallbacks(callbacks, context) {
  const override = context && context.dataset && context.dataset.tooltip && context.dataset.tooltip.callbacks;
  return override ? callbacks.override(override) : callbacks;
}
const defaultCallbacks = {
  beforeTitle: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  title(tooltipItems) {
    if (tooltipItems.length > 0) {
      const item = tooltipItems[0];
      const labels = item.chart.data.labels;
      const labelCount = labels ? labels.length : 0;
      if (this && this.options && this.options.mode === 'dataset') {
        return item.dataset.label || '';
      } else if (item.label) {
        return item.label;
      } else if (labelCount > 0 && item.dataIndex < labelCount) {
        return labels[item.dataIndex];
      }
    }
    return '';
  },
  afterTitle: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  beforeBody: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  beforeLabel: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  label(tooltipItem) {
    if (this && this.options && this.options.mode === 'dataset') {
      return tooltipItem.label + ': ' + tooltipItem.formattedValue || tooltipItem.formattedValue;
    }
    let label = tooltipItem.dataset.label || '';
    if (label) {
      label += ': ';
    }
    const value = tooltipItem.formattedValue;
    if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(value)) {
      label += value;
    }
    return label;
  },
  labelColor(tooltipItem) {
    const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);
    const options = meta.controller.getStyle(tooltipItem.dataIndex);
    return {
      borderColor: options.borderColor,
      backgroundColor: options.backgroundColor,
      borderWidth: options.borderWidth,
      borderDash: options.borderDash,
      borderDashOffset: options.borderDashOffset,
      borderRadius: 0
    };
  },
  labelTextColor() {
    return this.options.bodyColor;
  },
  labelPointStyle(tooltipItem) {
    const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);
    const options = meta.controller.getStyle(tooltipItem.dataIndex);
    return {
      pointStyle: options.pointStyle,
      rotation: options.rotation
    };
  },
  afterLabel: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  afterBody: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  beforeFooter: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  footer: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF,
  afterFooter: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aF
};
function invokeCallbackWithFallback(callbacks, name, ctx, arg) {
  const result = callbacks[name].call(ctx, arg);
  if (typeof result === 'undefined') {
    return defaultCallbacks[name].call(ctx, arg);
  }
  return result;
}
let Tooltip = /*#__PURE__*/(() => {
  class Tooltip extends Element {
    static positioners = (() => positioners)();
    constructor(config) {
      super();
      this.opacity = 0;
      this._active = [];
      this._eventPosition = undefined;
      this._size = undefined;
      this._cachedAnimations = undefined;
      this._tooltipItems = [];
      this.$animations = undefined;
      this.$context = undefined;
      this.chart = config.chart;
      this.options = config.options;
      this.dataPoints = undefined;
      this.title = undefined;
      this.beforeBody = undefined;
      this.body = undefined;
      this.afterBody = undefined;
      this.footer = undefined;
      this.xAlign = undefined;
      this.yAlign = undefined;
      this.x = undefined;
      this.y = undefined;
      this.height = undefined;
      this.width = undefined;
      this.caretX = undefined;
      this.caretY = undefined;
      this.labelColors = undefined;
      this.labelPointStyles = undefined;
      this.labelTextColors = undefined;
    }
    initialize(options) {
      this.options = options;
      this._cachedAnimations = undefined;
      this.$context = undefined;
    }
    _resolveAnimations() {
      const cached = this._cachedAnimations;
      if (cached) {
        return cached;
      }
      const chart = this.chart;
      const options = this.options.setContext(this.getContext());
      const opts = options.enabled && chart.options.animation && options.animations;
      const animations = new Animations(this.chart, opts);
      if (opts._cacheable) {
        this._cachedAnimations = Object.freeze(animations);
      }
      return animations;
    }
    getContext() {
      return this.$context || (this.$context = createTooltipContext(this.chart.getContext(), this, this._tooltipItems));
    }
    getTitle(context, options) {
      const {
        callbacks
      } = options;
      const beforeTitle = invokeCallbackWithFallback(callbacks, 'beforeTitle', this, context);
      const title = invokeCallbackWithFallback(callbacks, 'title', this, context);
      const afterTitle = invokeCallbackWithFallback(callbacks, 'afterTitle', this, context);
      let lines = [];
      lines = pushOrConcat(lines, splitNewlines(beforeTitle));
      lines = pushOrConcat(lines, splitNewlines(title));
      lines = pushOrConcat(lines, splitNewlines(afterTitle));
      return lines;
    }
    getBeforeBody(tooltipItems, options) {
      return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks, 'beforeBody', this, tooltipItems));
    }
    getBody(tooltipItems, options) {
      const {
        callbacks
      } = options;
      const bodyItems = [];
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltipItems, context => {
        const bodyItem = {
          before: [],
          lines: [],
          after: []
        };
        const scoped = overrideCallbacks(callbacks, context);
        pushOrConcat(bodyItem.before, splitNewlines(invokeCallbackWithFallback(scoped, 'beforeLabel', this, context)));
        pushOrConcat(bodyItem.lines, invokeCallbackWithFallback(scoped, 'label', this, context));
        pushOrConcat(bodyItem.after, splitNewlines(invokeCallbackWithFallback(scoped, 'afterLabel', this, context)));
        bodyItems.push(bodyItem);
      });
      return bodyItems;
    }
    getAfterBody(tooltipItems, options) {
      return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks, 'afterBody', this, tooltipItems));
    }
    getFooter(tooltipItems, options) {
      const {
        callbacks
      } = options;
      const beforeFooter = invokeCallbackWithFallback(callbacks, 'beforeFooter', this, tooltipItems);
      const footer = invokeCallbackWithFallback(callbacks, 'footer', this, tooltipItems);
      const afterFooter = invokeCallbackWithFallback(callbacks, 'afterFooter', this, tooltipItems);
      let lines = [];
      lines = pushOrConcat(lines, splitNewlines(beforeFooter));
      lines = pushOrConcat(lines, splitNewlines(footer));
      lines = pushOrConcat(lines, splitNewlines(afterFooter));
      return lines;
    }
    _createItems(options) {
      const active = this._active;
      const data = this.chart.data;
      const labelColors = [];
      const labelPointStyles = [];
      const labelTextColors = [];
      let tooltipItems = [];
      let i, len;
      for (i = 0, len = active.length; i < len; ++i) {
        tooltipItems.push(createTooltipItem(this.chart, active[i]));
      }
      if (options.filter) {
        tooltipItems = tooltipItems.filter((element, index, array) => options.filter(element, index, array, data));
      }
      if (options.itemSort) {
        tooltipItems = tooltipItems.sort((a, b) => options.itemSort(a, b, data));
      }
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(tooltipItems, context => {
        const scoped = overrideCallbacks(options.callbacks, context);
        labelColors.push(invokeCallbackWithFallback(scoped, 'labelColor', this, context));
        labelPointStyles.push(invokeCallbackWithFallback(scoped, 'labelPointStyle', this, context));
        labelTextColors.push(invokeCallbackWithFallback(scoped, 'labelTextColor', this, context));
      });
      this.labelColors = labelColors;
      this.labelPointStyles = labelPointStyles;
      this.labelTextColors = labelTextColors;
      this.dataPoints = tooltipItems;
      return tooltipItems;
    }
    update(changed, replay) {
      const options = this.options.setContext(this.getContext());
      const active = this._active;
      let properties;
      let tooltipItems = [];
      if (!active.length) {
        if (this.opacity !== 0) {
          properties = {
            opacity: 0
          };
        }
      } else {
        const position = positioners[options.position].call(this, active, this._eventPosition);
        tooltipItems = this._createItems(options);
        this.title = this.getTitle(tooltipItems, options);
        this.beforeBody = this.getBeforeBody(tooltipItems, options);
        this.body = this.getBody(tooltipItems, options);
        this.afterBody = this.getAfterBody(tooltipItems, options);
        this.footer = this.getFooter(tooltipItems, options);
        const size = this._size = getTooltipSize(this, options);
        const positionAndSize = Object.assign({}, position, size);
        const alignment = determineAlignment(this.chart, options, positionAndSize);
        const backgroundPoint = getBackgroundPoint(options, positionAndSize, alignment, this.chart);
        this.xAlign = alignment.xAlign;
        this.yAlign = alignment.yAlign;
        properties = {
          opacity: 1,
          x: backgroundPoint.x,
          y: backgroundPoint.y,
          width: size.width,
          height: size.height,
          caretX: position.x,
          caretY: position.y
        };
      }
      this._tooltipItems = tooltipItems;
      this.$context = undefined;
      if (properties) {
        this._resolveAnimations().update(this, properties);
      }
      if (changed && options.external) {
        options.external.call(this, {
          chart: this.chart,
          tooltip: this,
          replay
        });
      }
    }
    drawCaret(tooltipPoint, ctx, size, options) {
      const caretPosition = this.getCaretPosition(tooltipPoint, size, options);
      ctx.lineTo(caretPosition.x1, caretPosition.y1);
      ctx.lineTo(caretPosition.x2, caretPosition.y2);
      ctx.lineTo(caretPosition.x3, caretPosition.y3);
    }
    getCaretPosition(tooltipPoint, size, options) {
      const {
        xAlign,
        yAlign
      } = this;
      const {
        caretSize,
        cornerRadius
      } = options;
      const {
        topLeft,
        topRight,
        bottomLeft,
        bottomRight
      } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(cornerRadius);
      const {
        x: ptX,
        y: ptY
      } = tooltipPoint;
      const {
        width,
        height
      } = size;
      let x1, x2, x3, y1, y2, y3;
      if (yAlign === 'center') {
        y2 = ptY + height / 2;
        if (xAlign === 'left') {
          x1 = ptX;
          x2 = x1 - caretSize;
          y1 = y2 + caretSize;
          y3 = y2 - caretSize;
        } else {
          x1 = ptX + width;
          x2 = x1 + caretSize;
          y1 = y2 - caretSize;
          y3 = y2 + caretSize;
        }
        x3 = x1;
      } else {
        if (xAlign === 'left') {
          x2 = ptX + Math.max(topLeft, bottomLeft) + caretSize;
        } else if (xAlign === 'right') {
          x2 = ptX + width - Math.max(topRight, bottomRight) - caretSize;
        } else {
          x2 = this.caretX;
        }
        if (yAlign === 'top') {
          y1 = ptY;
          y2 = y1 - caretSize;
          x1 = x2 - caretSize;
          x3 = x2 + caretSize;
        } else {
          y1 = ptY + height;
          y2 = y1 + caretSize;
          x1 = x2 + caretSize;
          x3 = x2 - caretSize;
        }
        y3 = y1;
      }
      return {
        x1,
        x2,
        x3,
        y1,
        y2,
        y3
      };
    }
    drawTitle(pt, ctx, options) {
      const title = this.title;
      const length = title.length;
      let titleFont, titleSpacing, i;
      if (length) {
        const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(options.rtl, this.x, this.width);
        pt.x = getAlignedX(this, options.titleAlign, options);
        ctx.textAlign = rtlHelper.textAlign(options.titleAlign);
        ctx.textBaseline = 'middle';
        titleFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.titleFont);
        titleSpacing = options.titleSpacing;
        ctx.fillStyle = options.titleColor;
        ctx.font = titleFont.string;
        for (i = 0; i < length; ++i) {
          ctx.fillText(title[i], rtlHelper.x(pt.x), pt.y + titleFont.lineHeight / 2);
          pt.y += titleFont.lineHeight + titleSpacing;
          if (i + 1 === length) {
            pt.y += options.titleMarginBottom - titleSpacing;
          }
        }
      }
    }
    _drawColorBox(ctx, pt, i, rtlHelper, options) {
      const labelColor = this.labelColors[i];
      const labelPointStyle = this.labelPointStyles[i];
      const {
        boxHeight,
        boxWidth
      } = options;
      const bodyFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.bodyFont);
      const colorX = getAlignedX(this, 'left', options);
      const rtlColorX = rtlHelper.x(colorX);
      const yOffSet = boxHeight < bodyFont.lineHeight ? (bodyFont.lineHeight - boxHeight) / 2 : 0;
      const colorY = pt.y + yOffSet;
      if (options.usePointStyle) {
        const drawOptions = {
          radius: Math.min(boxWidth, boxHeight) / 2,
          pointStyle: labelPointStyle.pointStyle,
          rotation: labelPointStyle.rotation,
          borderWidth: 1
        };
        const centerX = rtlHelper.leftForLtr(rtlColorX, boxWidth) + boxWidth / 2;
        const centerY = colorY + boxHeight / 2;
        ctx.strokeStyle = options.multiKeyBackground;
        ctx.fillStyle = options.multiKeyBackground;
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.at)(ctx, drawOptions, centerX, centerY);
        ctx.strokeStyle = labelColor.borderColor;
        ctx.fillStyle = labelColor.backgroundColor;
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.at)(ctx, drawOptions, centerX, centerY);
      } else {
        ctx.lineWidth = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.i)(labelColor.borderWidth) ? Math.max(...Object.values(labelColor.borderWidth)) : labelColor.borderWidth || 1;
        ctx.strokeStyle = labelColor.borderColor;
        ctx.setLineDash(labelColor.borderDash || []);
        ctx.lineDashOffset = labelColor.borderDashOffset || 0;
        const outerX = rtlHelper.leftForLtr(rtlColorX, boxWidth);
        const innerX = rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX, 1), boxWidth - 2);
        const borderRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(labelColor.borderRadius);
        if (Object.values(borderRadius).some(v => v !== 0)) {
          ctx.beginPath();
          ctx.fillStyle = options.multiKeyBackground;
          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, {
            x: outerX,
            y: colorY,
            w: boxWidth,
            h: boxHeight,
            radius: borderRadius
          });
          ctx.fill();
          ctx.stroke();
          ctx.fillStyle = labelColor.backgroundColor;
          ctx.beginPath();
          (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, {
            x: innerX,
            y: colorY + 1,
            w: boxWidth - 2,
            h: boxHeight - 2,
            radius: borderRadius
          });
          ctx.fill();
        } else {
          ctx.fillStyle = options.multiKeyBackground;
          ctx.fillRect(outerX, colorY, boxWidth, boxHeight);
          ctx.strokeRect(outerX, colorY, boxWidth, boxHeight);
          ctx.fillStyle = labelColor.backgroundColor;
          ctx.fillRect(innerX, colorY + 1, boxWidth - 2, boxHeight - 2);
        }
      }
      ctx.fillStyle = this.labelTextColors[i];
    }
    drawBody(pt, ctx, options) {
      const {
        body
      } = this;
      const {
        bodySpacing,
        bodyAlign,
        displayColors,
        boxHeight,
        boxWidth,
        boxPadding
      } = options;
      const bodyFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.bodyFont);
      let bodyLineHeight = bodyFont.lineHeight;
      let xLinePadding = 0;
      const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(options.rtl, this.x, this.width);
      const fillLineOfText = function (line) {
        ctx.fillText(line, rtlHelper.x(pt.x + xLinePadding), pt.y + bodyLineHeight / 2);
        pt.y += bodyLineHeight + bodySpacing;
      };
      const bodyAlignForCalculation = rtlHelper.textAlign(bodyAlign);
      let bodyItem, textColor, lines, i, j, ilen, jlen;
      ctx.textAlign = bodyAlign;
      ctx.textBaseline = 'middle';
      ctx.font = bodyFont.string;
      pt.x = getAlignedX(this, bodyAlignForCalculation, options);
      ctx.fillStyle = options.bodyColor;
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.beforeBody, fillLineOfText);
      xLinePadding = displayColors && bodyAlignForCalculation !== 'right' ? bodyAlign === 'center' ? boxWidth / 2 + boxPadding : boxWidth + 2 + boxPadding : 0;
      for (i = 0, ilen = body.length; i < ilen; ++i) {
        bodyItem = body[i];
        textColor = this.labelTextColors[i];
        ctx.fillStyle = textColor;
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.before, fillLineOfText);
        lines = bodyItem.lines;
        if (displayColors && lines.length) {
          this._drawColorBox(ctx, pt, i, rtlHelper, options);
          bodyLineHeight = Math.max(bodyFont.lineHeight, boxHeight);
        }
        for (j = 0, jlen = lines.length; j < jlen; ++j) {
          fillLineOfText(lines[j]);
          bodyLineHeight = bodyFont.lineHeight;
        }
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(bodyItem.after, fillLineOfText);
      }
      xLinePadding = 0;
      bodyLineHeight = bodyFont.lineHeight;
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.F)(this.afterBody, fillLineOfText);
      pt.y -= bodySpacing;
    }
    drawFooter(pt, ctx, options) {
      const footer = this.footer;
      const length = footer.length;
      let footerFont, i;
      if (length) {
        const rtlHelper = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.az)(options.rtl, this.x, this.width);
        pt.x = getAlignedX(this, options.footerAlign, options);
        pt.y += options.footerMarginTop;
        ctx.textAlign = rtlHelper.textAlign(options.footerAlign);
        ctx.textBaseline = 'middle';
        footerFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(options.footerFont);
        ctx.fillStyle = options.footerColor;
        ctx.font = footerFont.string;
        for (i = 0; i < length; ++i) {
          ctx.fillText(footer[i], rtlHelper.x(pt.x), pt.y + footerFont.lineHeight / 2);
          pt.y += footerFont.lineHeight + options.footerSpacing;
        }
      }
    }
    drawBackground(pt, ctx, tooltipSize, options) {
      const {
        xAlign,
        yAlign
      } = this;
      const {
        x,
        y
      } = pt;
      const {
        width,
        height
      } = tooltipSize;
      const {
        topLeft,
        topRight,
        bottomLeft,
        bottomRight
      } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(options.cornerRadius);
      ctx.fillStyle = options.backgroundColor;
      ctx.strokeStyle = options.borderColor;
      ctx.lineWidth = options.borderWidth;
      ctx.beginPath();
      ctx.moveTo(x + topLeft, y);
      if (yAlign === 'top') {
        this.drawCaret(pt, ctx, tooltipSize, options);
      }
      ctx.lineTo(x + width - topRight, y);
      ctx.quadraticCurveTo(x + width, y, x + width, y + topRight);
      if (yAlign === 'center' && xAlign === 'right') {
        this.drawCaret(pt, ctx, tooltipSize, options);
      }
      ctx.lineTo(x + width, y + height - bottomRight);
      ctx.quadraticCurveTo(x + width, y + height, x + width - bottomRight, y + height);
      if (yAlign === 'bottom') {
        this.drawCaret(pt, ctx, tooltipSize, options);
      }
      ctx.lineTo(x + bottomLeft, y + height);
      ctx.quadraticCurveTo(x, y + height, x, y + height - bottomLeft);
      if (yAlign === 'center' && xAlign === 'left') {
        this.drawCaret(pt, ctx, tooltipSize, options);
      }
      ctx.lineTo(x, y + topLeft);
      ctx.quadraticCurveTo(x, y, x + topLeft, y);
      ctx.closePath();
      ctx.fill();
      if (options.borderWidth > 0) {
        ctx.stroke();
      }
    }
    _updateAnimationTarget(options) {
      const chart = this.chart;
      const anims = this.$animations;
      const animX = anims && anims.x;
      const animY = anims && anims.y;
      if (animX || animY) {
        const position = positioners[options.position].call(this, this._active, this._eventPosition);
        if (!position) {
          return;
        }
        const size = this._size = getTooltipSize(this, options);
        const positionAndSize = Object.assign({}, position, this._size);
        const alignment = determineAlignment(chart, options, positionAndSize);
        const point = getBackgroundPoint(options, positionAndSize, alignment, chart);
        if (animX._to !== point.x || animY._to !== point.y) {
          this.xAlign = alignment.xAlign;
          this.yAlign = alignment.yAlign;
          this.width = size.width;
          this.height = size.height;
          this.caretX = position.x;
          this.caretY = position.y;
          this._resolveAnimations().update(this, point);
        }
      }
    }
    _willRender() {
      return !!this.opacity;
    }
    draw(ctx) {
      const options = this.options.setContext(this.getContext());
      let opacity = this.opacity;
      if (!opacity) {
        return;
      }
      this._updateAnimationTarget(options);
      const tooltipSize = {
        width: this.width,
        height: this.height
      };
      const pt = {
        x: this.x,
        y: this.y
      };
      opacity = Math.abs(opacity) < 1e-3 ? 0 : opacity;
      const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(options.padding);
      const hasTooltipContent = this.title.length || this.beforeBody.length || this.body.length || this.afterBody.length || this.footer.length;
      if (options.enabled && hasTooltipContent) {
        ctx.save();
        ctx.globalAlpha = opacity;
        this.drawBackground(pt, ctx, tooltipSize, options);
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aA)(ctx, options.textDirection);
        pt.y += padding.top;
        this.drawTitle(pt, ctx, options);
        this.drawBody(pt, ctx, options);
        this.drawFooter(pt, ctx, options);
        (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aC)(ctx, options.textDirection);
        ctx.restore();
      }
    }
    getActiveElements() {
      return this._active || [];
    }
    setActiveElements(activeElements, eventPosition) {
      const lastActive = this._active;
      const active = activeElements.map(({
        datasetIndex,
        index
      }) => {
        const meta = this.chart.getDatasetMeta(datasetIndex);
        if (!meta) {
          throw new Error('Cannot find a dataset at index ' + datasetIndex);
        }
        return {
          datasetIndex,
          element: meta.data[index],
          index
        };
      });
      const changed = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ah)(lastActive, active);
      const positionChanged = this._positionChanged(active, eventPosition);
      if (changed || positionChanged) {
        this._active = active;
        this._eventPosition = eventPosition;
        this._ignoreReplayEvents = true;
        this.update(true);
      }
    }
    handleEvent(e, replay, inChartArea = true) {
      if (replay && this._ignoreReplayEvents) {
        return false;
      }
      this._ignoreReplayEvents = false;
      const options = this.options;
      const lastActive = this._active || [];
      const active = this._getActiveElements(e, lastActive, replay, inChartArea);
      const positionChanged = this._positionChanged(active, e);
      const changed = replay || !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ah)(active, lastActive) || positionChanged;
      if (changed) {
        this._active = active;
        if (options.enabled || options.external) {
          this._eventPosition = {
            x: e.x,
            y: e.y
          };
          this.update(true, replay);
        }
      }
      return changed;
    }
    _getActiveElements(e, lastActive, replay, inChartArea) {
      const options = this.options;
      if (e.type === 'mouseout') {
        return [];
      }
      if (!inChartArea) {
        return lastActive.filter(i => this.chart.data.datasets[i.datasetIndex] && this.chart.getDatasetMeta(i.datasetIndex).controller.getParsed(i.index) !== undefined);
      }
      const active = this.chart.getElementsAtEventForMode(e, options.mode, options, replay);
      if (options.reverse) {
        active.reverse();
      }
      return active;
    }
    _positionChanged(active, e) {
      const {
        caretX,
        caretY,
        options
      } = this;
      const position = positioners[options.position].call(this, active, e);
      return position !== false && (caretX !== position.x || caretY !== position.y);
    }
  }
  return Tooltip;
})();
var plugin_tooltip = {
  id: 'tooltip',
  _element: Tooltip,
  positioners,
  afterInit(chart, _args, options) {
    if (options) {
      chart.tooltip = new Tooltip({
        chart,
        options
      });
    }
  },
  beforeUpdate(chart, _args, options) {
    if (chart.tooltip) {
      chart.tooltip.initialize(options);
    }
  },
  reset(chart, _args, options) {
    if (chart.tooltip) {
      chart.tooltip.initialize(options);
    }
  },
  afterDraw(chart) {
    const tooltip = chart.tooltip;
    if (tooltip && tooltip._willRender()) {
      const args = {
        tooltip
      };
      if (chart.notifyPlugins('beforeTooltipDraw', {
        ...args,
        cancelable: true
      }) === false) {
        return;
      }
      tooltip.draw(chart.ctx);
      chart.notifyPlugins('afterTooltipDraw', args);
    }
  },
  afterEvent(chart, args) {
    if (chart.tooltip) {
      const useFinalPosition = args.replay;
      if (chart.tooltip.handleEvent(args.event, useFinalPosition, args.inChartArea)) {
        args.changed = true;
      }
    }
  },
  defaults: {
    enabled: true,
    external: null,
    position: 'average',
    backgroundColor: 'rgba(0,0,0,0.8)',
    titleColor: '#fff',
    titleFont: {
      weight: 'bold'
    },
    titleSpacing: 2,
    titleMarginBottom: 6,
    titleAlign: 'left',
    bodyColor: '#fff',
    bodySpacing: 2,
    bodyFont: {},
    bodyAlign: 'left',
    footerColor: '#fff',
    footerSpacing: 2,
    footerMarginTop: 6,
    footerFont: {
      weight: 'bold'
    },
    footerAlign: 'left',
    padding: 6,
    caretPadding: 2,
    caretSize: 5,
    cornerRadius: 6,
    boxHeight: (ctx, opts) => opts.bodyFont.size,
    boxWidth: (ctx, opts) => opts.bodyFont.size,
    multiKeyBackground: '#fff',
    displayColors: true,
    boxPadding: 0,
    borderColor: 'rgba(0,0,0,0)',
    borderWidth: 0,
    animation: {
      duration: 400,
      easing: 'easeOutQuart'
    },
    animations: {
      numbers: {
        type: 'number',
        properties: ['x', 'y', 'width', 'height', 'caretX', 'caretY']
      },
      opacity: {
        easing: 'linear',
        duration: 200
      }
    },
    callbacks: defaultCallbacks
  },
  defaultRoutes: {
    bodyFont: 'font',
    footerFont: 'font',
    titleFont: 'font'
  },
  descriptors: {
    _scriptable: name => name !== 'filter' && name !== 'itemSort' && name !== 'external',
    _indexable: false,
    callbacks: {
      _scriptable: false,
      _indexable: false
    },
    animation: {
      _fallback: false
    },
    animations: {
      _fallback: 'animation'
    }
  },
  additionalOptionScopes: ['interaction']
};
var plugins = /*#__PURE__*/Object.freeze({
  __proto__: null,
  Colors: plugin_colors,
  Decimation: plugin_decimation,
  Filler: index,
  Legend: plugin_legend,
  SubTitle: plugin_subtitle,
  Title: plugin_title,
  Tooltip: plugin_tooltip
});
const addIfString = (labels, raw, index, addedLabels) => {
  if (typeof raw === 'string') {
    index = labels.push(raw) - 1;
    addedLabels.unshift({
      index,
      label: raw
    });
  } else if (isNaN(raw)) {
    index = null;
  }
  return index;
};
function findOrAddLabel(labels, raw, index, addedLabels) {
  const first = labels.indexOf(raw);
  if (first === -1) {
    return addIfString(labels, raw, index, addedLabels);
  }
  const last = labels.lastIndexOf(raw);
  return first !== last ? index : first;
}
const validIndex = (index, max) => index === null ? null : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(Math.round(index), 0, max);
function _getLabelForValue(value) {
  const labels = this.getLabels();
  if (value >= 0 && value < labels.length) {
    return labels[value];
  }
  return value;
}
let CategoryScale = /*#__PURE__*/(() => {
  class CategoryScale extends Scale {
    static id = 'category';
    static defaults = (() => ({
      ticks: {
        callback: _getLabelForValue
      }
    }))();
    constructor(cfg) {
      super(cfg);
      this._startValue = undefined;
      this._valueRange = 0;
      this._addedLabels = [];
    }
    init(scaleOptions) {
      const added = this._addedLabels;
      if (added.length) {
        const labels = this.getLabels();
        for (const {
          index,
          label
        } of added) {
          if (labels[index] === label) {
            labels.splice(index, 1);
          }
        }
        this._addedLabels = [];
      }
      super.init(scaleOptions);
    }
    parse(raw, index) {
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(raw)) {
        return null;
      }
      const labels = this.getLabels();
      index = isFinite(index) && labels[index] === raw ? index : findOrAddLabel(labels, raw, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(index, raw), this._addedLabels);
      return validIndex(index, labels.length - 1);
    }
    determineDataLimits() {
      const {
        minDefined,
        maxDefined
      } = this.getUserBounds();
      let {
        min,
        max
      } = this.getMinMax(true);
      if (this.options.bounds === 'ticks') {
        if (!minDefined) {
          min = 0;
        }
        if (!maxDefined) {
          max = this.getLabels().length - 1;
        }
      }
      this.min = min;
      this.max = max;
    }
    buildTicks() {
      const min = this.min;
      const max = this.max;
      const offset = this.options.offset;
      const ticks = [];
      let labels = this.getLabels();
      labels = min === 0 && max === labels.length - 1 ? labels : labels.slice(min, max + 1);
      this._valueRange = Math.max(labels.length - (offset ? 0 : 1), 1);
      this._startValue = this.min - (offset ? 0.5 : 0);
      for (let value = min; value <= max; value++) {
        ticks.push({
          value
        });
      }
      return ticks;
    }
    getLabelForValue(value) {
      return _getLabelForValue.call(this, value);
    }
    configure() {
      super.configure();
      if (!this.isHorizontal()) {
        this._reversePixels = !this._reversePixels;
      }
    }
    getPixelForValue(value) {
      if (typeof value !== 'number') {
        value = this.parse(value);
      }
      return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);
    }
    getPixelForTick(index) {
      const ticks = this.ticks;
      if (index < 0 || index > ticks.length - 1) {
        return null;
      }
      return this.getPixelForValue(ticks[index].value);
    }
    getValueForPixel(pixel) {
      return Math.round(this._startValue + this.getDecimalForPixel(pixel) * this._valueRange);
    }
    getBasePixel() {
      return this.bottom;
    }
  }
  return CategoryScale;
})();
function generateTicks$1(generationOptions, dataRange) {
  const ticks = [];
  const MIN_SPACING = 1e-14;
  const {
    bounds,
    step,
    min,
    max,
    precision,
    count,
    maxTicks,
    maxDigits,
    includeBounds
  } = generationOptions;
  const unit = step || 1;
  const maxSpaces = maxTicks - 1;
  const {
    min: rmin,
    max: rmax
  } = dataRange;
  const minDefined = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(min);
  const maxDefined = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(max);
  const countDefined = !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(count);
  const minSpacing = (rmax - rmin) / (maxDigits + 1);
  let spacing = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aH)((rmax - rmin) / maxSpaces / unit) * unit;
  let factor, niceMin, niceMax, numSpaces;
  if (spacing < MIN_SPACING && !minDefined && !maxDefined) {
    return [{
      value: rmin
    }, {
      value: rmax
    }];
  }
  numSpaces = Math.ceil(rmax / spacing) - Math.floor(rmin / spacing);
  if (numSpaces > maxSpaces) {
    spacing = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aH)(numSpaces * spacing / maxSpaces / unit) * unit;
  }
  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(precision)) {
    factor = Math.pow(10, precision);
    spacing = Math.ceil(spacing * factor) / factor;
  }
  if (bounds === 'ticks') {
    niceMin = Math.floor(rmin / spacing) * spacing;
    niceMax = Math.ceil(rmax / spacing) * spacing;
  } else {
    niceMin = rmin;
    niceMax = rmax;
  }
  if (minDefined && maxDefined && step && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aI)((max - min) / step, spacing / 1000)) {
    numSpaces = Math.round(Math.min((max - min) / spacing, maxTicks));
    spacing = (max - min) / numSpaces;
    niceMin = min;
    niceMax = max;
  } else if (countDefined) {
    niceMin = minDefined ? min : niceMin;
    niceMax = maxDefined ? max : niceMax;
    numSpaces = count - 1;
    spacing = (niceMax - niceMin) / numSpaces;
  } else {
    numSpaces = (niceMax - niceMin) / spacing;
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aJ)(numSpaces, Math.round(numSpaces), spacing / 1000)) {
      numSpaces = Math.round(numSpaces);
    } else {
      numSpaces = Math.ceil(numSpaces);
    }
  }
  const decimalPlaces = Math.max((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aK)(spacing), (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aK)(niceMin));
  factor = Math.pow(10, (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(precision) ? decimalPlaces : precision);
  niceMin = Math.round(niceMin * factor) / factor;
  niceMax = Math.round(niceMax * factor) / factor;
  let j = 0;
  if (minDefined) {
    if (includeBounds && niceMin !== min) {
      ticks.push({
        value: min
      });
      if (niceMin < min) {
        j++;
      }
      if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aJ)(Math.round((niceMin + j * spacing) * factor) / factor, min, relativeLabelSize(min, minSpacing, generationOptions))) {
        j++;
      }
    } else if (niceMin < min) {
      j++;
    }
  }
  for (; j < numSpaces; ++j) {
    const tickValue = Math.round((niceMin + j * spacing) * factor) / factor;
    if (maxDefined && tickValue > max) {
      break;
    }
    ticks.push({
      value: tickValue
    });
  }
  if (maxDefined && includeBounds && niceMax !== max) {
    if (ticks.length && (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aJ)(ticks[ticks.length - 1].value, max, relativeLabelSize(max, minSpacing, generationOptions))) {
      ticks[ticks.length - 1].value = max;
    } else {
      ticks.push({
        value: max
      });
    }
  } else if (!maxDefined || niceMax === max) {
    ticks.push({
      value: niceMax
    });
  }
  return ticks;
}
function relativeLabelSize(value, minSpacing, {
  horizontal,
  minRotation
}) {
  const rad = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(minRotation);
  const ratio = (horizontal ? Math.sin(rad) : Math.cos(rad)) || 0.001;
  const length = 0.75 * minSpacing * ('' + value).length;
  return Math.min(minSpacing / ratio, length);
}
class LinearScaleBase extends Scale {
  constructor(cfg) {
    super(cfg);
    this.start = undefined;
    this.end = undefined;
    this._startValue = undefined;
    this._endValue = undefined;
    this._valueRange = 0;
  }
  parse(raw, index) {
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(raw)) {
      return null;
    }
    if ((typeof raw === 'number' || raw instanceof Number) && !isFinite(+raw)) {
      return null;
    }
    return +raw;
  }
  handleTickRangeOptions() {
    const {
      beginAtZero
    } = this.options;
    const {
      minDefined,
      maxDefined
    } = this.getUserBounds();
    let {
      min,
      max
    } = this;
    const setMin = v => min = minDefined ? min : v;
    const setMax = v => max = maxDefined ? max : v;
    if (beginAtZero) {
      const minSign = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(min);
      const maxSign = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.s)(max);
      if (minSign < 0 && maxSign < 0) {
        setMax(0);
      } else if (minSign > 0 && maxSign > 0) {
        setMin(0);
      }
    }
    if (min === max) {
      let offset = max === 0 ? 1 : Math.abs(max * 0.05);
      setMax(max + offset);
      if (!beginAtZero) {
        setMin(min - offset);
      }
    }
    this.min = min;
    this.max = max;
  }
  getTickLimit() {
    const tickOpts = this.options.ticks;
    let {
      maxTicksLimit,
      stepSize
    } = tickOpts;
    let maxTicks;
    if (stepSize) {
      maxTicks = Math.ceil(this.max / stepSize) - Math.floor(this.min / stepSize) + 1;
      if (maxTicks > 1000) {
        console.warn(`scales.${this.id}.ticks.stepSize: ${stepSize} would result generating up to ${maxTicks} ticks. Limiting to 1000.`);
        maxTicks = 1000;
      }
    } else {
      maxTicks = this.computeTickLimit();
      maxTicksLimit = maxTicksLimit || 11;
    }
    if (maxTicksLimit) {
      maxTicks = Math.min(maxTicksLimit, maxTicks);
    }
    return maxTicks;
  }
  computeTickLimit() {
    return Number.POSITIVE_INFINITY;
  }
  buildTicks() {
    const opts = this.options;
    const tickOpts = opts.ticks;
    let maxTicks = this.getTickLimit();
    maxTicks = Math.max(2, maxTicks);
    const numericGeneratorOptions = {
      maxTicks,
      bounds: opts.bounds,
      min: opts.min,
      max: opts.max,
      precision: tickOpts.precision,
      step: tickOpts.stepSize,
      count: tickOpts.count,
      maxDigits: this._maxDigits(),
      horizontal: this.isHorizontal(),
      minRotation: tickOpts.minRotation || 0,
      includeBounds: tickOpts.includeBounds !== false
    };
    const dataRange = this._range || this;
    const ticks = generateTicks$1(numericGeneratorOptions, dataRange);
    if (opts.bounds === 'ticks') {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aG)(ticks, this, 'value');
    }
    if (opts.reverse) {
      ticks.reverse();
      this.start = this.max;
      this.end = this.min;
    } else {
      this.start = this.min;
      this.end = this.max;
    }
    return ticks;
  }
  configure() {
    const ticks = this.ticks;
    let start = this.min;
    let end = this.max;
    super.configure();
    if (this.options.offset && ticks.length) {
      const offset = (end - start) / Math.max(ticks.length - 1, 1) / 2;
      start -= offset;
      end += offset;
    }
    this._startValue = start;
    this._endValue = end;
    this._valueRange = end - start;
  }
  getLabelForValue(value) {
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(value, this.chart.options.locale, this.options.ticks.format);
  }
}
class LinearScale extends LinearScaleBase {
  static id = 'linear';
  static defaults = (() => ({
    ticks: {
      callback: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aL.formatters.numeric
    }
  }))();
  determineDataLimits() {
    const {
      min,
      max
    } = this.getMinMax(true);
    this.min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) ? min : 0;
    this.max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) ? max : 1;
    this.handleTickRangeOptions();
  }
  computeTickLimit() {
    const horizontal = this.isHorizontal();
    const length = horizontal ? this.width : this.height;
    const minRotation = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.options.ticks.minRotation);
    const ratio = (horizontal ? Math.sin(minRotation) : Math.cos(minRotation)) || 0.001;
    const tickFont = this._resolveTickFontOptions(0);
    return Math.ceil(length / Math.min(40, tickFont.lineHeight / ratio));
  }
  getPixelForValue(value) {
    return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);
  }
  getValueForPixel(pixel) {
    return this._startValue + this.getDecimalForPixel(pixel) * this._valueRange;
  }
}
const log10Floor = v => Math.floor((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aM)(v));
const changeExponent = (v, m) => Math.pow(10, log10Floor(v) + m);
function isMajor(tickVal) {
  const remain = tickVal / Math.pow(10, log10Floor(tickVal));
  return remain === 1;
}
function steps(min, max, rangeExp) {
  const rangeStep = Math.pow(10, rangeExp);
  const start = Math.floor(min / rangeStep);
  const end = Math.ceil(max / rangeStep);
  return end - start;
}
function startExp(min, max) {
  const range = max - min;
  let rangeExp = log10Floor(range);
  while (steps(min, max, rangeExp) > 10) {
    rangeExp++;
  }
  while (steps(min, max, rangeExp) < 10) {
    rangeExp--;
  }
  return Math.min(rangeExp, log10Floor(min));
}
function generateTicks(generationOptions, {
  min,
  max
}) {
  min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(generationOptions.min, min);
  const ticks = [];
  const minExp = log10Floor(min);
  let exp = startExp(min, max);
  let precision = exp < 0 ? Math.pow(10, Math.abs(exp)) : 1;
  const stepSize = Math.pow(10, exp);
  const base = minExp > exp ? Math.pow(10, minExp) : 0;
  const start = Math.round((min - base) * precision) / precision;
  const offset = Math.floor((min - base) / stepSize / 10) * stepSize * 10;
  let significand = Math.floor((start - offset) / Math.pow(10, exp));
  let value = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(generationOptions.min, Math.round((base + offset + significand * Math.pow(10, exp)) * precision) / precision);
  while (value < max) {
    ticks.push({
      value,
      major: isMajor(value),
      significand
    });
    if (significand >= 10) {
      significand = significand < 15 ? 15 : 20;
    } else {
      significand++;
    }
    if (significand >= 20) {
      exp++;
      significand = 2;
      precision = exp >= 0 ? 1 : precision;
    }
    value = Math.round((base + offset + significand * Math.pow(10, exp)) * precision) / precision;
  }
  const lastTick = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.O)(generationOptions.max, value);
  ticks.push({
    value: lastTick,
    major: isMajor(lastTick),
    significand
  });
  return ticks;
}
class LogarithmicScale extends Scale {
  static id = 'logarithmic';
  static defaults = (() => ({
    ticks: {
      callback: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aL.formatters.logarithmic,
      major: {
        enabled: true
      }
    }
  }))();
  constructor(cfg) {
    super(cfg);
    this.start = undefined;
    this.end = undefined;
    this._startValue = undefined;
    this._valueRange = 0;
  }
  parse(raw, index) {
    const value = LinearScaleBase.prototype.parse.apply(this, [raw, index]);
    if (value === 0) {
      this._zero = true;
      return undefined;
    }
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value) && value > 0 ? value : null;
  }
  determineDataLimits() {
    const {
      min,
      max
    } = this.getMinMax(true);
    this.min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) ? Math.max(0, min) : null;
    this.max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) ? Math.max(0, max) : null;
    if (this.options.beginAtZero) {
      this._zero = true;
    }
    if (this._zero && this.min !== this._suggestedMin && !(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(this._userMin)) {
      this.min = min === changeExponent(this.min, 0) ? changeExponent(this.min, -1) : changeExponent(this.min, 0);
    }
    this.handleTickRangeOptions();
  }
  handleTickRangeOptions() {
    const {
      minDefined,
      maxDefined
    } = this.getUserBounds();
    let min = this.min;
    let max = this.max;
    const setMin = v => min = minDefined ? min : v;
    const setMax = v => max = maxDefined ? max : v;
    if (min === max) {
      if (min <= 0) {
        setMin(1);
        setMax(10);
      } else {
        setMin(changeExponent(min, -1));
        setMax(changeExponent(max, +1));
      }
    }
    if (min <= 0) {
      setMin(changeExponent(max, -1));
    }
    if (max <= 0) {
      setMax(changeExponent(min, +1));
    }
    this.min = min;
    this.max = max;
  }
  buildTicks() {
    const opts = this.options;
    const generationOptions = {
      min: this._userMin,
      max: this._userMax
    };
    const ticks = generateTicks(generationOptions, this);
    if (opts.bounds === 'ticks') {
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aG)(ticks, this, 'value');
    }
    if (opts.reverse) {
      ticks.reverse();
      this.start = this.max;
      this.end = this.min;
    } else {
      this.start = this.min;
      this.end = this.max;
    }
    return ticks;
  }
  getLabelForValue(value) {
    return value === undefined ? '0' : (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.o)(value, this.chart.options.locale, this.options.ticks.format);
  }
  configure() {
    const start = this.min;
    super.configure();
    this._startValue = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aM)(start);
    this._valueRange = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aM)(this.max) - (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aM)(start);
  }
  getPixelForValue(value) {
    if (value === undefined || value === 0) {
      value = this.min;
    }
    if (value === null || isNaN(value)) {
      return NaN;
    }
    return this.getPixelForDecimal(value === this.min ? 0 : ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aM)(value) - this._startValue) / this._valueRange);
  }
  getValueForPixel(pixel) {
    const decimal = this.getDecimalForPixel(pixel);
    return Math.pow(10, this._startValue + decimal * this._valueRange);
  }
}
function getTickBackdropHeight(opts) {
  const tickOpts = opts.ticks;
  if (tickOpts.display && opts.display) {
    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(tickOpts.backdropPadding);
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(tickOpts.font && tickOpts.font.size, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.d.font.size) + padding.height;
  }
  return 0;
}
function measureLabelSize(ctx, font, label) {
  label = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.b)(label) ? label : [label];
  return {
    w: (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aN)(ctx, font.string, label),
    h: label.length * font.lineHeight
  };
}
function determineLimits(angle, pos, size, min, max) {
  if (angle === min || angle === max) {
    return {
      start: pos - size / 2,
      end: pos + size / 2
    };
  } else if (angle < min || angle > max) {
    return {
      start: pos - size,
      end: pos
    };
  }
  return {
    start: pos,
    end: pos + size
  };
}
function fitWithPointLabels(scale) {
  const orig = {
    l: scale.left + scale._padding.left,
    r: scale.right - scale._padding.right,
    t: scale.top + scale._padding.top,
    b: scale.bottom - scale._padding.bottom
  };
  const limits = Object.assign({}, orig);
  const labelSizes = [];
  const padding = [];
  const valueCount = scale._pointLabels.length;
  const pointLabelOpts = scale.options.pointLabels;
  const additionalAngle = pointLabelOpts.centerPointLabels ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P / valueCount : 0;
  for (let i = 0; i < valueCount; i++) {
    const opts = pointLabelOpts.setContext(scale.getPointLabelContext(i));
    padding[i] = opts.padding;
    const pointPosition = scale.getPointPosition(i, scale.drawingArea + padding[i], additionalAngle);
    const plFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(opts.font);
    const textSize = measureLabelSize(scale.ctx, plFont, scale._pointLabels[i]);
    labelSizes[i] = textSize;
    const angleRadians = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay)(scale.getIndexAngle(i) + additionalAngle);
    const angle = Math.round((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)(angleRadians));
    const hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);
    const vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);
    updateLimits(limits, orig, angleRadians, hLimits, vLimits);
  }
  scale.setCenterPoint(orig.l - limits.l, limits.r - orig.r, orig.t - limits.t, limits.b - orig.b);
  scale._pointLabelItems = buildPointLabelItems(scale, labelSizes, padding);
}
function updateLimits(limits, orig, angle, hLimits, vLimits) {
  const sin = Math.abs(Math.sin(angle));
  const cos = Math.abs(Math.cos(angle));
  let x = 0;
  let y = 0;
  if (hLimits.start < orig.l) {
    x = (orig.l - hLimits.start) / sin;
    limits.l = Math.min(limits.l, orig.l - x);
  } else if (hLimits.end > orig.r) {
    x = (hLimits.end - orig.r) / sin;
    limits.r = Math.max(limits.r, orig.r + x);
  }
  if (vLimits.start < orig.t) {
    y = (orig.t - vLimits.start) / cos;
    limits.t = Math.min(limits.t, orig.t - y);
  } else if (vLimits.end > orig.b) {
    y = (vLimits.end - orig.b) / cos;
    limits.b = Math.max(limits.b, orig.b + y);
  }
}
function createPointLabelItem(scale, index, itemOpts) {
  const outerDistance = scale.drawingArea;
  const {
    extra,
    additionalAngle,
    padding,
    size
  } = itemOpts;
  const pointLabelPosition = scale.getPointPosition(index, outerDistance + extra + padding, additionalAngle);
  const angle = Math.round((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.U)((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay)(pointLabelPosition.angle + _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H)));
  const y = yForAngle(pointLabelPosition.y, size.h, angle);
  const textAlign = getTextAlignForAngle(angle);
  const left = leftForTextAlign(pointLabelPosition.x, size.w, textAlign);
  return {
    visible: true,
    x: pointLabelPosition.x,
    y,
    textAlign,
    left,
    top: y,
    right: left + size.w,
    bottom: y + size.h
  };
}
function isNotOverlapped(item, area) {
  if (!area) {
    return true;
  }
  const {
    left,
    top,
    right,
    bottom
  } = item;
  const apexesInArea = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)({
    x: left,
    y: top
  }, area) || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)({
    x: left,
    y: bottom
  }, area) || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)({
    x: right,
    y: top
  }, area) || (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.C)({
    x: right,
    y: bottom
  }, area);
  return !apexesInArea;
}
function buildPointLabelItems(scale, labelSizes, padding) {
  const items = [];
  const valueCount = scale._pointLabels.length;
  const opts = scale.options;
  const {
    centerPointLabels,
    display
  } = opts.pointLabels;
  const itemOpts = {
    extra: getTickBackdropHeight(opts) / 2,
    additionalAngle: centerPointLabels ? _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.P / valueCount : 0
  };
  let area;
  for (let i = 0; i < valueCount; i++) {
    itemOpts.padding = padding[i];
    itemOpts.size = labelSizes[i];
    const item = createPointLabelItem(scale, i, itemOpts);
    items.push(item);
    if (display === 'auto') {
      item.visible = isNotOverlapped(item, area);
      if (item.visible) {
        area = item;
      }
    }
  }
  return items;
}
function getTextAlignForAngle(angle) {
  if (angle === 0 || angle === 180) {
    return 'center';
  } else if (angle < 180) {
    return 'left';
  }
  return 'right';
}
function leftForTextAlign(x, w, align) {
  if (align === 'right') {
    x -= w;
  } else if (align === 'center') {
    x -= w / 2;
  }
  return x;
}
function yForAngle(y, h, angle) {
  if (angle === 90 || angle === 270) {
    y -= h / 2;
  } else if (angle > 270 || angle < 90) {
    y -= h;
  }
  return y;
}
function drawPointLabelBox(ctx, opts, item) {
  const {
    left,
    top,
    right,
    bottom
  } = item;
  const {
    backdropColor
  } = opts;
  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(backdropColor)) {
    const borderRadius = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aw)(opts.borderRadius);
    const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(opts.backdropPadding);
    ctx.fillStyle = backdropColor;
    const backdropLeft = left - padding.left;
    const backdropTop = top - padding.top;
    const backdropWidth = right - left + padding.width;
    const backdropHeight = bottom - top + padding.height;
    if (Object.values(borderRadius).some(v => v !== 0)) {
      ctx.beginPath();
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.au)(ctx, {
        x: backdropLeft,
        y: backdropTop,
        w: backdropWidth,
        h: backdropHeight,
        radius: borderRadius
      });
      ctx.fill();
    } else {
      ctx.fillRect(backdropLeft, backdropTop, backdropWidth, backdropHeight);
    }
  }
}
function drawPointLabels(scale, labelCount) {
  const {
    ctx,
    options: {
      pointLabels
    }
  } = scale;
  for (let i = labelCount - 1; i >= 0; i--) {
    const item = scale._pointLabelItems[i];
    if (!item.visible) {
      continue;
    }
    const optsAtIndex = pointLabels.setContext(scale.getPointLabelContext(i));
    drawPointLabelBox(ctx, optsAtIndex, item);
    const plFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(optsAtIndex.font);
    const {
      x,
      y,
      textAlign
    } = item;
    (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, scale._pointLabels[i], x, y + plFont.lineHeight / 2, plFont, {
      color: optsAtIndex.color,
      textAlign: textAlign,
      textBaseline: 'middle'
    });
  }
}
function pathRadiusLine(scale, radius, circular, labelCount) {
  const {
    ctx
  } = scale;
  if (circular) {
    ctx.arc(scale.xCenter, scale.yCenter, radius, 0, _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T);
  } else {
    let pointPosition = scale.getPointPosition(0, radius);
    ctx.moveTo(pointPosition.x, pointPosition.y);
    for (let i = 1; i < labelCount; i++) {
      pointPosition = scale.getPointPosition(i, radius);
      ctx.lineTo(pointPosition.x, pointPosition.y);
    }
  }
}
function drawRadiusLine(scale, gridLineOpts, radius, labelCount, borderOpts) {
  const ctx = scale.ctx;
  const circular = gridLineOpts.circular;
  const {
    color,
    lineWidth
  } = gridLineOpts;
  if (!circular && !labelCount || !color || !lineWidth || radius < 0) {
    return;
  }
  ctx.save();
  ctx.strokeStyle = color;
  ctx.lineWidth = lineWidth;
  ctx.setLineDash(borderOpts.dash || []);
  ctx.lineDashOffset = borderOpts.dashOffset;
  ctx.beginPath();
  pathRadiusLine(scale, radius, circular, labelCount);
  ctx.closePath();
  ctx.stroke();
  ctx.restore();
}
function createPointLabelContext(parent, index, label) {
  return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.j)(parent, {
    label,
    index,
    type: 'pointLabel'
  });
}
class RadialLinearScale extends LinearScaleBase {
  static id = 'radialLinear';
  static defaults = (() => ({
    display: true,
    animate: true,
    position: 'chartArea',
    angleLines: {
      display: true,
      lineWidth: 1,
      borderDash: [],
      borderDashOffset: 0.0
    },
    grid: {
      circular: false
    },
    startAngle: 0,
    ticks: {
      showLabelBackdrop: true,
      callback: _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aL.formatters.numeric
    },
    pointLabels: {
      backdropColor: undefined,
      backdropPadding: 2,
      display: true,
      font: {
        size: 10
      },
      callback(label) {
        return label;
      },
      padding: 5,
      centerPointLabels: false
    }
  }))();
  static defaultRoutes = {
    'angleLines.color': 'borderColor',
    'pointLabels.color': 'color',
    'ticks.color': 'color'
  };
  static descriptors = {
    angleLines: {
      _fallback: 'grid'
    }
  };
  constructor(cfg) {
    super(cfg);
    this.xCenter = undefined;
    this.yCenter = undefined;
    this.drawingArea = undefined;
    this._pointLabels = [];
    this._pointLabelItems = [];
  }
  setDimensions() {
    const padding = this._padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(getTickBackdropHeight(this.options) / 2);
    const w = this.width = this.maxWidth - padding.width;
    const h = this.height = this.maxHeight - padding.height;
    this.xCenter = Math.floor(this.left + w / 2 + padding.left);
    this.yCenter = Math.floor(this.top + h / 2 + padding.top);
    this.drawingArea = Math.floor(Math.min(w, h) / 2);
  }
  determineDataLimits() {
    const {
      min,
      max
    } = this.getMinMax(false);
    this.min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) && !isNaN(min) ? min : 0;
    this.max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) && !isNaN(max) ? max : 0;
    this.handleTickRangeOptions();
  }
  computeTickLimit() {
    return Math.ceil(this.drawingArea / getTickBackdropHeight(this.options));
  }
  generateTickLabels(ticks) {
    LinearScaleBase.prototype.generateTickLabels.call(this, ticks);
    this._pointLabels = this.getLabels().map((value, index) => {
      const label = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(this.options.pointLabels.callback, [value, index], this);
      return label || label === 0 ? label : '';
    }).filter((v, i) => this.chart.getDataVisibility(i));
  }
  fit() {
    const opts = this.options;
    if (opts.display && opts.pointLabels.display) {
      fitWithPointLabels(this);
    } else {
      this.setCenterPoint(0, 0, 0, 0);
    }
  }
  setCenterPoint(leftMovement, rightMovement, topMovement, bottomMovement) {
    this.xCenter += Math.floor((leftMovement - rightMovement) / 2);
    this.yCenter += Math.floor((topMovement - bottomMovement) / 2);
    this.drawingArea -= Math.min(this.drawingArea / 2, Math.max(leftMovement, rightMovement, topMovement, bottomMovement));
  }
  getIndexAngle(index) {
    const angleMultiplier = _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.T / (this._pointLabels.length || 1);
    const startAngle = this.options.startAngle || 0;
    return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ay)(index * angleMultiplier + (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(startAngle));
  }
  getDistanceFromCenterForValue(value) {
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(value)) {
      return NaN;
    }
    const scalingFactor = this.drawingArea / (this.max - this.min);
    if (this.options.reverse) {
      return (this.max - value) * scalingFactor;
    }
    return (value - this.min) * scalingFactor;
  }
  getValueForDistanceFromCenter(distance) {
    if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(distance)) {
      return NaN;
    }
    const scaledDistance = distance / (this.drawingArea / (this.max - this.min));
    return this.options.reverse ? this.max - scaledDistance : this.min + scaledDistance;
  }
  getPointLabelContext(index) {
    const pointLabels = this._pointLabels || [];
    if (index >= 0 && index < pointLabels.length) {
      const pointLabel = pointLabels[index];
      return createPointLabelContext(this.getContext(), index, pointLabel);
    }
  }
  getPointPosition(index, distanceFromCenter, additionalAngle = 0) {
    const angle = this.getIndexAngle(index) - _chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.H + additionalAngle;
    return {
      x: Math.cos(angle) * distanceFromCenter + this.xCenter,
      y: Math.sin(angle) * distanceFromCenter + this.yCenter,
      angle
    };
  }
  getPointPositionForValue(index, value) {
    return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));
  }
  getBasePosition(index) {
    return this.getPointPositionForValue(index || 0, this.getBaseValue());
  }
  getPointLabelPosition(index) {
    const {
      left,
      top,
      right,
      bottom
    } = this._pointLabelItems[index];
    return {
      left,
      top,
      right,
      bottom
    };
  }
  drawBackground() {
    const {
      backgroundColor,
      grid: {
        circular
      }
    } = this.options;
    if (backgroundColor) {
      const ctx = this.ctx;
      ctx.save();
      ctx.beginPath();
      pathRadiusLine(this, this.getDistanceFromCenterForValue(this._endValue), circular, this._pointLabels.length);
      ctx.closePath();
      ctx.fillStyle = backgroundColor;
      ctx.fill();
      ctx.restore();
    }
  }
  drawGrid() {
    const ctx = this.ctx;
    const opts = this.options;
    const {
      angleLines,
      grid,
      border
    } = opts;
    const labelCount = this._pointLabels.length;
    let i, offset, position;
    if (opts.pointLabels.display) {
      drawPointLabels(this, labelCount);
    }
    if (grid.display) {
      this.ticks.forEach((tick, index) => {
        if (index !== 0 || index === 0 && this.min < 0) {
          offset = this.getDistanceFromCenterForValue(tick.value);
          const context = this.getContext(index);
          const optsAtIndex = grid.setContext(context);
          const optsAtIndexBorder = border.setContext(context);
          drawRadiusLine(this, optsAtIndex, offset, labelCount, optsAtIndexBorder);
        }
      });
    }
    if (angleLines.display) {
      ctx.save();
      for (i = labelCount - 1; i >= 0; i--) {
        const optsAtIndex = angleLines.setContext(this.getPointLabelContext(i));
        const {
          color,
          lineWidth
        } = optsAtIndex;
        if (!lineWidth || !color) {
          continue;
        }
        ctx.lineWidth = lineWidth;
        ctx.strokeStyle = color;
        ctx.setLineDash(optsAtIndex.borderDash);
        ctx.lineDashOffset = optsAtIndex.borderDashOffset;
        offset = this.getDistanceFromCenterForValue(opts.reverse ? this.min : this.max);
        position = this.getPointPosition(i, offset);
        ctx.beginPath();
        ctx.moveTo(this.xCenter, this.yCenter);
        ctx.lineTo(position.x, position.y);
        ctx.stroke();
      }
      ctx.restore();
    }
  }
  drawBorder() {}
  drawLabels() {
    const ctx = this.ctx;
    const opts = this.options;
    const tickOpts = opts.ticks;
    if (!tickOpts.display) {
      return;
    }
    const startAngle = this.getIndexAngle(0);
    let offset, width;
    ctx.save();
    ctx.translate(this.xCenter, this.yCenter);
    ctx.rotate(startAngle);
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    this.ticks.forEach((tick, index) => {
      if (index === 0 && this.min >= 0 && !opts.reverse) {
        return;
      }
      const optsAtIndex = tickOpts.setContext(this.getContext(index));
      const tickFont = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.a0)(optsAtIndex.font);
      offset = this.getDistanceFromCenterForValue(this.ticks[index].value);
      if (optsAtIndex.showLabelBackdrop) {
        ctx.font = tickFont.string;
        width = ctx.measureText(tick.label).width;
        ctx.fillStyle = optsAtIndex.backdropColor;
        const padding = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.E)(optsAtIndex.backdropPadding);
        ctx.fillRect(-width / 2 - padding.left, -offset - tickFont.size / 2 - padding.top, width + padding.width, tickFont.size + padding.height);
      }
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Z)(ctx, tick.label, 0, -offset, tickFont, {
        color: optsAtIndex.color,
        strokeColor: optsAtIndex.textStrokeColor,
        strokeWidth: optsAtIndex.textStrokeWidth
      });
    });
    ctx.restore();
  }
  drawTitle() {}
}
const INTERVALS = {
  millisecond: {
    common: true,
    size: 1,
    steps: 1000
  },
  second: {
    common: true,
    size: 1000,
    steps: 60
  },
  minute: {
    common: true,
    size: 60000,
    steps: 60
  },
  hour: {
    common: true,
    size: 3600000,
    steps: 24
  },
  day: {
    common: true,
    size: 86400000,
    steps: 30
  },
  week: {
    common: false,
    size: 604800000,
    steps: 4
  },
  month: {
    common: true,
    size: 2.628e9,
    steps: 12
  },
  quarter: {
    common: false,
    size: 7.884e9,
    steps: 4
  },
  year: {
    common: true,
    size: 3.154e10
  }
};
const UNITS = /* #__PURE__ */Object.keys(INTERVALS);
function sorter(a, b) {
  return a - b;
}
function parse(scale, input) {
  if ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.k)(input)) {
    return null;
  }
  const adapter = scale._adapter;
  const {
    parser,
    round,
    isoWeekday
  } = scale._parseOpts;
  let value = input;
  if (typeof parser === 'function') {
    value = parser(value);
  }
  if (!(0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(value)) {
    value = typeof parser === 'string' ? adapter.parse(value, parser) : adapter.parse(value);
  }
  if (value === null) {
    return null;
  }
  if (round) {
    value = round === 'week' && ((0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(isoWeekday) || isoWeekday === true) ? adapter.startOf(value, 'isoWeek', isoWeekday) : adapter.startOf(value, round);
  }
  return +value;
}
function determineUnitForAutoTicks(minUnit, min, max, capacity) {
  const ilen = UNITS.length;
  for (let i = UNITS.indexOf(minUnit); i < ilen - 1; ++i) {
    const interval = INTERVALS[UNITS[i]];
    const factor = interval.steps ? interval.steps : Number.MAX_SAFE_INTEGER;
    if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {
      return UNITS[i];
    }
  }
  return UNITS[ilen - 1];
}
function determineUnitForFormatting(scale, numTicks, minUnit, min, max) {
  for (let i = UNITS.length - 1; i >= UNITS.indexOf(minUnit); i--) {
    const unit = UNITS[i];
    if (INTERVALS[unit].common && scale._adapter.diff(max, min, unit) >= numTicks - 1) {
      return unit;
    }
  }
  return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];
}
function determineMajorUnit(unit) {
  for (let i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i) {
    if (INTERVALS[UNITS[i]].common) {
      return UNITS[i];
    }
  }
}
function addTick(ticks, time, timestamps) {
  if (!timestamps) {
    ticks[time] = true;
  } else if (timestamps.length) {
    const {
      lo,
      hi
    } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aP)(timestamps, time);
    const timestamp = timestamps[lo] >= time ? timestamps[lo] : timestamps[hi];
    ticks[timestamp] = true;
  }
}
function setMajorTicks(scale, ticks, map, majorUnit) {
  const adapter = scale._adapter;
  const first = +adapter.startOf(ticks[0].value, majorUnit);
  const last = ticks[ticks.length - 1].value;
  let major, index;
  for (major = first; major <= last; major = +adapter.add(major, 1, majorUnit)) {
    index = map[major];
    if (index >= 0) {
      ticks[index].major = true;
    }
  }
  return ticks;
}
function ticksFromTimestamps(scale, values, majorUnit) {
  const ticks = [];
  const map = {};
  const ilen = values.length;
  let i, value;
  for (i = 0; i < ilen; ++i) {
    value = values[i];
    map[value] = i;
    ticks.push({
      value,
      major: false
    });
  }
  return ilen === 0 || !majorUnit ? ticks : setMajorTicks(scale, ticks, map, majorUnit);
}
let TimeScale = /*#__PURE__*/(() => {
  class TimeScale extends Scale {
    static id = 'time';
    static defaults = {
      bounds: 'data',
      adapters: {},
      time: {
        parser: false,
        unit: false,
        round: false,
        isoWeekday: false,
        minUnit: 'millisecond',
        displayFormats: {}
      },
      ticks: {
        source: 'auto',
        callback: false,
        major: {
          enabled: false
        }
      }
    };
    constructor(props) {
      super(props);
      this._cache = {
        data: [],
        labels: [],
        all: []
      };
      this._unit = 'day';
      this._majorUnit = undefined;
      this._offsets = {};
      this._normalized = false;
      this._parseOpts = undefined;
    }
    init(scaleOpts, opts = {}) {
      const time = scaleOpts.time || (scaleOpts.time = {});
      const adapter = this._adapter = new adapters._date(scaleOpts.adapters.date);
      adapter.init(opts);
      (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.ab)(time.displayFormats, adapter.formats());
      this._parseOpts = {
        parser: time.parser,
        round: time.round,
        isoWeekday: time.isoWeekday
      };
      super.init(scaleOpts);
      this._normalized = opts.normalized;
    }
    parse(raw, index) {
      if (raw === undefined) {
        return null;
      }
      return parse(this, raw);
    }
    beforeLayout() {
      super.beforeLayout();
      this._cache = {
        data: [],
        labels: [],
        all: []
      };
    }
    determineDataLimits() {
      const options = this.options;
      const adapter = this._adapter;
      const unit = options.time.unit || 'day';
      let {
        min,
        max,
        minDefined,
        maxDefined
      } = this.getUserBounds();
      function _applyBounds(bounds) {
        if (!minDefined && !isNaN(bounds.min)) {
          min = Math.min(min, bounds.min);
        }
        if (!maxDefined && !isNaN(bounds.max)) {
          max = Math.max(max, bounds.max);
        }
      }
      if (!minDefined || !maxDefined) {
        _applyBounds(this._getLabelBounds());
        if (options.bounds !== 'ticks' || options.ticks.source !== 'labels') {
          _applyBounds(this.getMinMax(false));
        }
      }
      min = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(min) && !isNaN(min) ? min : +adapter.startOf(Date.now(), unit);
      max = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.g)(max) && !isNaN(max) ? max : +adapter.endOf(Date.now(), unit) + 1;
      this.min = Math.min(min, max - 1);
      this.max = Math.max(min + 1, max);
    }
    _getLabelBounds() {
      const arr = this.getLabelTimestamps();
      let min = Number.POSITIVE_INFINITY;
      let max = Number.NEGATIVE_INFINITY;
      if (arr.length) {
        min = arr[0];
        max = arr[arr.length - 1];
      }
      return {
        min,
        max
      };
    }
    buildTicks() {
      const options = this.options;
      const timeOpts = options.time;
      const tickOpts = options.ticks;
      const timestamps = tickOpts.source === 'labels' ? this.getLabelTimestamps() : this._generate();
      if (options.bounds === 'ticks' && timestamps.length) {
        this.min = this._userMin || timestamps[0];
        this.max = this._userMax || timestamps[timestamps.length - 1];
      }
      const min = this.min;
      const max = this.max;
      const ticks = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.aO)(timestamps, min, max);
      this._unit = timeOpts.unit || (tickOpts.autoSkip ? determineUnitForAutoTicks(timeOpts.minUnit, this.min, this.max, this._getLabelCapacity(min)) : determineUnitForFormatting(this, ticks.length, timeOpts.minUnit, this.min, this.max));
      this._majorUnit = !tickOpts.major.enabled || this._unit === 'year' ? undefined : determineMajorUnit(this._unit);
      this.initOffsets(timestamps);
      if (options.reverse) {
        ticks.reverse();
      }
      return ticksFromTimestamps(this, ticks, this._majorUnit);
    }
    afterAutoSkip() {
      if (this.options.offsetAfterAutoskip) {
        this.initOffsets(this.ticks.map(tick => +tick.value));
      }
    }
    initOffsets(timestamps = []) {
      let start = 0;
      let end = 0;
      let first, last;
      if (this.options.offset && timestamps.length) {
        first = this.getDecimalForValue(timestamps[0]);
        if (timestamps.length === 1) {
          start = 1 - first;
        } else {
          start = (this.getDecimalForValue(timestamps[1]) - first) / 2;
        }
        last = this.getDecimalForValue(timestamps[timestamps.length - 1]);
        if (timestamps.length === 1) {
          end = last;
        } else {
          end = (last - this.getDecimalForValue(timestamps[timestamps.length - 2])) / 2;
        }
      }
      const limit = timestamps.length < 3 ? 0.5 : 0.25;
      start = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(start, 0, limit);
      end = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.S)(end, 0, limit);
      this._offsets = {
        start,
        end,
        factor: 1 / (start + 1 + end)
      };
    }
    _generate() {
      const adapter = this._adapter;
      const min = this.min;
      const max = this.max;
      const options = this.options;
      const timeOpts = options.time;
      const minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, this._getLabelCapacity(min));
      const stepSize = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.v)(options.ticks.stepSize, 1);
      const weekday = minor === 'week' ? timeOpts.isoWeekday : false;
      const hasWeekday = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.x)(weekday) || weekday === true;
      const ticks = {};
      let first = min;
      let time, count;
      if (hasWeekday) {
        first = +adapter.startOf(first, 'isoWeek', weekday);
      }
      first = +adapter.startOf(first, hasWeekday ? 'day' : minor);
      if (adapter.diff(max, min, minor) > 100000 * stepSize) {
        throw new Error(min + ' and ' + max + ' are too far apart with stepSize of ' + stepSize + ' ' + minor);
      }
      const timestamps = options.ticks.source === 'data' && this.getDataTimestamps();
      for (time = first, count = 0; time < max; time = +adapter.add(time, stepSize, minor), count++) {
        addTick(ticks, time, timestamps);
      }
      if (time === max || options.bounds === 'ticks' || count === 1) {
        addTick(ticks, time, timestamps);
      }
      return Object.keys(ticks).sort(sorter).map(x => +x);
    }
    getLabelForValue(value) {
      const adapter = this._adapter;
      const timeOpts = this.options.time;
      if (timeOpts.tooltipFormat) {
        return adapter.format(value, timeOpts.tooltipFormat);
      }
      return adapter.format(value, timeOpts.displayFormats.datetime);
    }
    format(value, format) {
      const options = this.options;
      const formats = options.time.displayFormats;
      const unit = this._unit;
      const fmt = format || formats[unit];
      return this._adapter.format(value, fmt);
    }
    _tickFormatFunction(time, index, ticks, format) {
      const options = this.options;
      const formatter = options.ticks.callback;
      if (formatter) {
        return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.Q)(formatter, [time, index, ticks], this);
      }
      const formats = options.time.displayFormats;
      const unit = this._unit;
      const majorUnit = this._majorUnit;
      const minorFormat = unit && formats[unit];
      const majorFormat = majorUnit && formats[majorUnit];
      const tick = ticks[index];
      const major = majorUnit && majorFormat && tick && tick.major;
      return this._adapter.format(time, format || (major ? majorFormat : minorFormat));
    }
    generateTickLabels(ticks) {
      let i, ilen, tick;
      for (i = 0, ilen = ticks.length; i < ilen; ++i) {
        tick = ticks[i];
        tick.label = this._tickFormatFunction(tick.value, i, ticks);
      }
    }
    getDecimalForValue(value) {
      return value === null ? NaN : (value - this.min) / (this.max - this.min);
    }
    getPixelForValue(value) {
      const offsets = this._offsets;
      const pos = this.getDecimalForValue(value);
      return this.getPixelForDecimal((offsets.start + pos) * offsets.factor);
    }
    getValueForPixel(pixel) {
      const offsets = this._offsets;
      const pos = this.getDecimalForPixel(pixel) / offsets.factor - offsets.end;
      return this.min + pos * (this.max - this.min);
    }
    _getLabelSize(label) {
      const ticksOpts = this.options.ticks;
      const tickLabelWidth = this.ctx.measureText(label).width;
      const angle = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.t)(this.isHorizontal() ? ticksOpts.maxRotation : ticksOpts.minRotation);
      const cosRotation = Math.cos(angle);
      const sinRotation = Math.sin(angle);
      const tickFontSize = this._resolveTickFontOptions(0).size;
      return {
        w: tickLabelWidth * cosRotation + tickFontSize * sinRotation,
        h: tickLabelWidth * sinRotation + tickFontSize * cosRotation
      };
    }
    _getLabelCapacity(exampleTime) {
      const timeOpts = this.options.time;
      const displayFormats = timeOpts.displayFormats;
      const format = displayFormats[timeOpts.unit] || displayFormats.millisecond;
      const exampleLabel = this._tickFormatFunction(exampleTime, 0, ticksFromTimestamps(this, [exampleTime], this._majorUnit), format);
      const size = this._getLabelSize(exampleLabel);
      const capacity = Math.floor(this.isHorizontal() ? this.width / size.w : this.height / size.h) - 1;
      return capacity > 0 ? capacity : 1;
    }
    getDataTimestamps() {
      let timestamps = this._cache.data || [];
      let i, ilen;
      if (timestamps.length) {
        return timestamps;
      }
      const metas = this.getMatchingVisibleMetas();
      if (this._normalized && metas.length) {
        return this._cache.data = metas[0].controller.getAllParsedValues(this);
      }
      for (i = 0, ilen = metas.length; i < ilen; ++i) {
        timestamps = timestamps.concat(metas[i].controller.getAllParsedValues(this));
      }
      return this._cache.data = this.normalize(timestamps);
    }
    getLabelTimestamps() {
      const timestamps = this._cache.labels || [];
      let i, ilen;
      if (timestamps.length) {
        return timestamps;
      }
      const labels = this.getLabels();
      for (i = 0, ilen = labels.length; i < ilen; ++i) {
        timestamps.push(parse(this, labels[i]));
      }
      return this._cache.labels = this._normalized ? timestamps : this.normalize(timestamps);
    }
    normalize(values) {
      return (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__._)(values.sort(sorter));
    }
  }
  return TimeScale;
})();
function interpolate(table, val, reverse) {
  let lo = 0;
  let hi = table.length - 1;
  let prevSource, nextSource, prevTarget, nextTarget;
  if (reverse) {
    if (val >= table[lo].pos && val <= table[hi].pos) {
      ({
        lo,
        hi
      } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(table, 'pos', val));
    }
    ({
      pos: prevSource,
      time: prevTarget
    } = table[lo]);
    ({
      pos: nextSource,
      time: nextTarget
    } = table[hi]);
  } else {
    if (val >= table[lo].time && val <= table[hi].time) {
      ({
        lo,
        hi
      } = (0,_chunks_helpers_segment_js__WEBPACK_IMPORTED_MODULE_0__.B)(table, 'time', val));
    }
    ({
      time: prevSource,
      pos: prevTarget
    } = table[lo]);
    ({
      time: nextSource,
      pos: nextTarget
    } = table[hi]);
  }
  const span = nextSource - prevSource;
  return span ? prevTarget + (nextTarget - prevTarget) * (val - prevSource) / span : prevTarget;
}
class TimeSeriesScale extends TimeScale {
  static id = 'timeseries';
  static defaults = (() => TimeScale.defaults)();
  constructor(props) {
    super(props);
    this._table = [];
    this._minPos = undefined;
    this._tableRange = undefined;
  }
  initOffsets() {
    const timestamps = this._getTimestampsForTable();
    const table = this._table = this.buildLookupTable(timestamps);
    this._minPos = interpolate(table, this.min);
    this._tableRange = interpolate(table, this.max) - this._minPos;
    super.initOffsets(timestamps);
  }
  buildLookupTable(timestamps) {
    const {
      min,
      max
    } = this;
    const items = [];
    const table = [];
    let i, ilen, prev, curr, next;
    for (i = 0, ilen = timestamps.length; i < ilen; ++i) {
      curr = timestamps[i];
      if (curr >= min && curr <= max) {
        items.push(curr);
      }
    }
    if (items.length < 2) {
      return [{
        time: min,
        pos: 0
      }, {
        time: max,
        pos: 1
      }];
    }
    for (i = 0, ilen = items.length; i < ilen; ++i) {
      next = items[i + 1];
      prev = items[i - 1];
      curr = items[i];
      if (Math.round((next + prev) / 2) !== curr) {
        table.push({
          time: curr,
          pos: i / (ilen - 1)
        });
      }
    }
    return table;
  }
  _generate() {
    const min = this.min;
    const max = this.max;
    let timestamps = super.getDataTimestamps();
    if (!timestamps.includes(min) || !timestamps.length) {
      timestamps.splice(0, 0, min);
    }
    if (!timestamps.includes(max) || timestamps.length === 1) {
      timestamps.push(max);
    }
    return timestamps.sort((a, b) => a - b);
  }
  _getTimestampsForTable() {
    let timestamps = this._cache.all || [];
    if (timestamps.length) {
      return timestamps;
    }
    const data = this.getDataTimestamps();
    const label = this.getLabelTimestamps();
    if (data.length && label.length) {
      timestamps = this.normalize(data.concat(label));
    } else {
      timestamps = data.length ? data : label;
    }
    timestamps = this._cache.all = timestamps;
    return timestamps;
  }
  getDecimalForValue(value) {
    return (interpolate(this._table, value) - this._minPos) / this._tableRange;
  }
  getValueForPixel(pixel) {
    const offsets = this._offsets;
    const decimal = this.getDecimalForPixel(pixel) / offsets.factor - offsets.end;
    return interpolate(this._table, decimal * this._tableRange + this._minPos, true);
  }
}
var scales = /*#__PURE__*/Object.freeze({
  __proto__: null,
  CategoryScale: CategoryScale,
  LinearScale: LinearScale,
  LogarithmicScale: LogarithmicScale,
  RadialLinearScale: RadialLinearScale,
  TimeScale: TimeScale,
  TimeSeriesScale: TimeSeriesScale
});
const registerables = [controllers, elements, plugins, scales];


/***/ }),

/***/ 3348:
/*!************************************************************************************************!*\
  !*** ./node_modules/.pnpm/chart.js@4.4.6/node_modules/chart.js/dist/chunks/helpers.segment.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   $: () => (/* binding */ unclipArea),
/* harmony export */   A: () => (/* binding */ _rlookupByKey),
/* harmony export */   B: () => (/* binding */ _lookupByKey),
/* harmony export */   C: () => (/* binding */ _isPointInArea),
/* harmony export */   D: () => (/* binding */ getAngleFromPoint),
/* harmony export */   E: () => (/* binding */ toPadding),
/* harmony export */   F: () => (/* binding */ each),
/* harmony export */   G: () => (/* binding */ getMaximumSize),
/* harmony export */   H: () => (/* binding */ HALF_PI),
/* harmony export */   I: () => (/* binding */ _getParentNode),
/* harmony export */   J: () => (/* binding */ readUsedSize),
/* harmony export */   K: () => (/* binding */ supportsEventListenerOptions),
/* harmony export */   L: () => (/* binding */ throttled),
/* harmony export */   M: () => (/* binding */ _isDomSupported),
/* harmony export */   N: () => (/* binding */ _factorize),
/* harmony export */   O: () => (/* binding */ finiteOrDefault),
/* harmony export */   P: () => (/* binding */ PI),
/* harmony export */   Q: () => (/* binding */ callback),
/* harmony export */   R: () => (/* binding */ _addGrace),
/* harmony export */   S: () => (/* binding */ _limitValue),
/* harmony export */   T: () => (/* binding */ TAU),
/* harmony export */   U: () => (/* binding */ toDegrees),
/* harmony export */   V: () => (/* binding */ _measureText),
/* harmony export */   W: () => (/* binding */ _int16Range),
/* harmony export */   X: () => (/* binding */ _alignPixel),
/* harmony export */   Y: () => (/* binding */ clipArea),
/* harmony export */   Z: () => (/* binding */ renderText),
/* harmony export */   _: () => (/* binding */ _arrayUnique),
/* harmony export */   a: () => (/* binding */ resolve),
/* harmony export */   a$: () => (/* binding */ fontString),
/* harmony export */   a0: () => (/* binding */ toFont),
/* harmony export */   a1: () => (/* binding */ _toLeftRightCenter),
/* harmony export */   a2: () => (/* binding */ _alignStartEnd),
/* harmony export */   a3: () => (/* binding */ overrides),
/* harmony export */   a4: () => (/* binding */ merge),
/* harmony export */   a5: () => (/* binding */ _capitalize),
/* harmony export */   a6: () => (/* binding */ descriptors),
/* harmony export */   a7: () => (/* binding */ isFunction),
/* harmony export */   a8: () => (/* binding */ _attachContext),
/* harmony export */   a9: () => (/* binding */ _createResolver),
/* harmony export */   aA: () => (/* binding */ overrideTextDirection),
/* harmony export */   aB: () => (/* binding */ _textX),
/* harmony export */   aC: () => (/* binding */ restoreTextDirection),
/* harmony export */   aD: () => (/* binding */ drawPointLegend),
/* harmony export */   aE: () => (/* binding */ distanceBetweenPoints),
/* harmony export */   aF: () => (/* binding */ noop),
/* harmony export */   aG: () => (/* binding */ _setMinAndMaxByKey),
/* harmony export */   aH: () => (/* binding */ niceNum),
/* harmony export */   aI: () => (/* binding */ almostWhole),
/* harmony export */   aJ: () => (/* binding */ almostEquals),
/* harmony export */   aK: () => (/* binding */ _decimalPlaces),
/* harmony export */   aL: () => (/* binding */ Ticks),
/* harmony export */   aM: () => (/* binding */ log10),
/* harmony export */   aN: () => (/* binding */ _longestText),
/* harmony export */   aO: () => (/* binding */ _filterBetween),
/* harmony export */   aP: () => (/* binding */ _lookup),
/* harmony export */   aQ: () => (/* binding */ isPatternOrGradient),
/* harmony export */   aR: () => (/* binding */ getHoverColor),
/* harmony export */   aS: () => (/* binding */ clone),
/* harmony export */   aT: () => (/* binding */ _merger),
/* harmony export */   aU: () => (/* binding */ _mergerIf),
/* harmony export */   aV: () => (/* binding */ _deprecated),
/* harmony export */   aW: () => (/* binding */ _splitKey),
/* harmony export */   aX: () => (/* binding */ toFontString),
/* harmony export */   aY: () => (/* binding */ splineCurve),
/* harmony export */   aZ: () => (/* binding */ splineCurveMonotone),
/* harmony export */   a_: () => (/* binding */ getStyle),
/* harmony export */   aa: () => (/* binding */ _descriptors),
/* harmony export */   ab: () => (/* binding */ mergeIf),
/* harmony export */   ac: () => (/* binding */ uid),
/* harmony export */   ad: () => (/* binding */ debounce),
/* harmony export */   ae: () => (/* binding */ retinaScale),
/* harmony export */   af: () => (/* binding */ clearCanvas),
/* harmony export */   ag: () => (/* binding */ setsEqual),
/* harmony export */   ah: () => (/* binding */ _elementsEqual),
/* harmony export */   ai: () => (/* binding */ _isClickEvent),
/* harmony export */   aj: () => (/* binding */ _isBetween),
/* harmony export */   ak: () => (/* binding */ _readValueToProps),
/* harmony export */   al: () => (/* binding */ _updateBezierControlPoints),
/* harmony export */   am: () => (/* binding */ _computeSegments),
/* harmony export */   an: () => (/* binding */ _boundSegments),
/* harmony export */   ao: () => (/* binding */ _steppedInterpolation),
/* harmony export */   ap: () => (/* binding */ _bezierInterpolation),
/* harmony export */   aq: () => (/* binding */ _pointInLine),
/* harmony export */   ar: () => (/* binding */ _steppedLineTo),
/* harmony export */   as: () => (/* binding */ _bezierCurveTo),
/* harmony export */   at: () => (/* binding */ drawPoint),
/* harmony export */   au: () => (/* binding */ addRoundedRectPath),
/* harmony export */   av: () => (/* binding */ toTRBL),
/* harmony export */   aw: () => (/* binding */ toTRBLCorners),
/* harmony export */   ax: () => (/* binding */ _boundSegment),
/* harmony export */   ay: () => (/* binding */ _normalizeAngle),
/* harmony export */   az: () => (/* binding */ getRtlAdapter),
/* harmony export */   b: () => (/* binding */ isArray),
/* harmony export */   b0: () => (/* binding */ toLineHeight),
/* harmony export */   b1: () => (/* binding */ PITAU),
/* harmony export */   b2: () => (/* binding */ INFINITY),
/* harmony export */   b3: () => (/* binding */ RAD_PER_DEG),
/* harmony export */   b4: () => (/* binding */ QUARTER_PI),
/* harmony export */   b5: () => (/* binding */ TWO_THIRDS_PI),
/* harmony export */   b6: () => (/* binding */ _angleDiff),
/* harmony export */   c: () => (/* binding */ color),
/* harmony export */   d: () => (/* binding */ defaults),
/* harmony export */   e: () => (/* binding */ effects),
/* harmony export */   f: () => (/* binding */ resolveObjectKey),
/* harmony export */   g: () => (/* binding */ isNumberFinite),
/* harmony export */   h: () => (/* binding */ defined),
/* harmony export */   i: () => (/* binding */ isObject),
/* harmony export */   j: () => (/* binding */ createContext),
/* harmony export */   k: () => (/* binding */ isNullOrUndef),
/* harmony export */   l: () => (/* binding */ listenArrayEvents),
/* harmony export */   m: () => (/* binding */ toPercentage),
/* harmony export */   n: () => (/* binding */ toDimension),
/* harmony export */   o: () => (/* binding */ formatNumber),
/* harmony export */   p: () => (/* binding */ _angleBetween),
/* harmony export */   q: () => (/* binding */ _getStartAndCountOfVisiblePoints),
/* harmony export */   r: () => (/* binding */ requestAnimFrame),
/* harmony export */   s: () => (/* binding */ sign),
/* harmony export */   t: () => (/* binding */ toRadians),
/* harmony export */   u: () => (/* binding */ unlistenArrayEvents),
/* harmony export */   v: () => (/* binding */ valueOrDefault),
/* harmony export */   w: () => (/* binding */ _scaleRangesChanged),
/* harmony export */   x: () => (/* binding */ isNumber),
/* harmony export */   y: () => (/* binding */ _parseObjectDataRadialScale),
/* harmony export */   z: () => (/* binding */ getRelativePosition)
/* harmony export */ });
/* harmony import */ var _kurkle_color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @kurkle/color */ 9804);
/*!
 * Chart.js v4.4.6
 * https://www.chartjs.org
 * (c) 2024 Chart.js Contributors
 * Released under the MIT License
 */


/**
 * @namespace Chart.helpers
 */ /**
    * An empty function that can be used, for example, for optional callback.
    */
function noop() {
  /* noop */}
/**
 * Returns a unique id, sequentially generated from a global variable.
 */
const uid = (() => {
  let id = 0;
  return () => id++;
})();
/**
 * Returns true if `value` is neither null nor undefined, else returns false.
 * @param value - The value to test.
 * @since 2.7.0
 */
function isNullOrUndef(value) {
  return value === null || typeof value === 'undefined';
}
/**
 * Returns true if `value` is an array (including typed arrays), else returns false.
 * @param value - The value to test.
 * @function
 */
function isArray(value) {
  if (Array.isArray && Array.isArray(value)) {
    return true;
  }
  const type = Object.prototype.toString.call(value);
  if (type.slice(0, 7) === '[object' && type.slice(-6) === 'Array]') {
    return true;
  }
  return false;
}
/**
 * Returns true if `value` is an object (excluding null), else returns false.
 * @param value - The value to test.
 * @since 2.7.0
 */
function isObject(value) {
  return value !== null && Object.prototype.toString.call(value) === '[object Object]';
}
/**
 * Returns true if `value` is a finite number, else returns false
 * @param value  - The value to test.
 */
function isNumberFinite(value) {
  return (typeof value === 'number' || value instanceof Number) && isFinite(+value);
}
/**
 * Returns `value` if finite, else returns `defaultValue`.
 * @param value - The value to return if defined.
 * @param defaultValue - The value to return if `value` is not finite.
 */
function finiteOrDefault(value, defaultValue) {
  return isNumberFinite(value) ? value : defaultValue;
}
/**
 * Returns `value` if defined, else returns `defaultValue`.
 * @param value - The value to return if defined.
 * @param defaultValue - The value to return if `value` is undefined.
 */
function valueOrDefault(value, defaultValue) {
  return typeof value === 'undefined' ? defaultValue : value;
}
const toPercentage = (value, dimension) => typeof value === 'string' && value.endsWith('%') ? parseFloat(value) / 100 : +value / dimension;
const toDimension = (value, dimension) => typeof value === 'string' && value.endsWith('%') ? parseFloat(value) / 100 * dimension : +value;
/**
 * Calls `fn` with the given `args` in the scope defined by `thisArg` and returns the
 * value returned by `fn`. If `fn` is not a function, this method returns undefined.
 * @param fn - The function to call.
 * @param args - The arguments with which `fn` should be called.
 * @param [thisArg] - The value of `this` provided for the call to `fn`.
 */
function callback(fn, args, thisArg) {
  if (fn && typeof fn.call === 'function') {
    return fn.apply(thisArg, args);
  }
}
function each(loopable, fn, thisArg, reverse) {
  let i, len, keys;
  if (isArray(loopable)) {
    len = loopable.length;
    if (reverse) {
      for (i = len - 1; i >= 0; i--) {
        fn.call(thisArg, loopable[i], i);
      }
    } else {
      for (i = 0; i < len; i++) {
        fn.call(thisArg, loopable[i], i);
      }
    }
  } else if (isObject(loopable)) {
    keys = Object.keys(loopable);
    len = keys.length;
    for (i = 0; i < len; i++) {
      fn.call(thisArg, loopable[keys[i]], keys[i]);
    }
  }
}
/**
 * Returns true if the `a0` and `a1` arrays have the same content, else returns false.
 * @param a0 - The array to compare
 * @param a1 - The array to compare
 * @private
 */
function _elementsEqual(a0, a1) {
  let i, ilen, v0, v1;
  if (!a0 || !a1 || a0.length !== a1.length) {
    return false;
  }
  for (i = 0, ilen = a0.length; i < ilen; ++i) {
    v0 = a0[i];
    v1 = a1[i];
    if (v0.datasetIndex !== v1.datasetIndex || v0.index !== v1.index) {
      return false;
    }
  }
  return true;
}
/**
 * Returns a deep copy of `source` without keeping references on objects and arrays.
 * @param source - The value to clone.
 */
function clone(source) {
  if (isArray(source)) {
    return source.map(clone);
  }
  if (isObject(source)) {
    const target = Object.create(null);
    const keys = Object.keys(source);
    const klen = keys.length;
    let k = 0;
    for (; k < klen; ++k) {
      target[keys[k]] = clone(source[keys[k]]);
    }
    return target;
  }
  return source;
}
function isValidKey(key) {
  return ['__proto__', 'prototype', 'constructor'].indexOf(key) === -1;
}
/**
 * The default merger when Chart.helpers.merge is called without merger option.
 * Note(SB): also used by mergeConfig and mergeScaleConfig as fallback.
 * @private
 */
function _merger(key, target, source, options) {
  if (!isValidKey(key)) {
    return;
  }
  const tval = target[key];
  const sval = source[key];
  if (isObject(tval) && isObject(sval)) {
    // eslint-disable-next-line @typescript-eslint/no-use-before-define
    merge(tval, sval, options);
  } else {
    target[key] = clone(sval);
  }
}
function merge(target, source, options) {
  const sources = isArray(source) ? source : [source];
  const ilen = sources.length;
  if (!isObject(target)) {
    return target;
  }
  options = options || {};
  const merger = options.merger || _merger;
  let current;
  for (let i = 0; i < ilen; ++i) {
    current = sources[i];
    if (!isObject(current)) {
      continue;
    }
    const keys = Object.keys(current);
    for (let k = 0, klen = keys.length; k < klen; ++k) {
      merger(keys[k], target, current, options);
    }
  }
  return target;
}
function mergeIf(target, source) {
  // eslint-disable-next-line @typescript-eslint/no-use-before-define
  return merge(target, source, {
    merger: _mergerIf
  });
}
/**
 * Merges source[key] in target[key] only if target[key] is undefined.
 * @private
 */
function _mergerIf(key, target, source) {
  if (!isValidKey(key)) {
    return;
  }
  const tval = target[key];
  const sval = source[key];
  if (isObject(tval) && isObject(sval)) {
    mergeIf(tval, sval);
  } else if (!Object.prototype.hasOwnProperty.call(target, key)) {
    target[key] = clone(sval);
  }
}
/**
 * @private
 */
function _deprecated(scope, value, previous, current) {
  if (value !== undefined) {
    console.warn(scope + ': "' + previous + '" is deprecated. Please use "' + current + '" instead');
  }
}
// resolveObjectKey resolver cache
const keyResolvers = {
  // Chart.helpers.core resolveObjectKey should resolve empty key to root object
  '': v => v,
  // default resolvers
  x: o => o.x,
  y: o => o.y
};
/**
 * @private
 */
function _splitKey(key) {
  const parts = key.split('.');
  const keys = [];
  let tmp = '';
  for (const part of parts) {
    tmp += part;
    if (tmp.endsWith('\\')) {
      tmp = tmp.slice(0, -1) + '.';
    } else {
      keys.push(tmp);
      tmp = '';
    }
  }
  return keys;
}
function _getKeyResolver(key) {
  const keys = _splitKey(key);
  return obj => {
    for (const k of keys) {
      if (k === '') {
        break;
      }
      obj = obj && obj[k];
    }
    return obj;
  };
}
function resolveObjectKey(obj, key) {
  const resolver = keyResolvers[key] || (keyResolvers[key] = _getKeyResolver(key));
  return resolver(obj);
}
/**
 * @private
 */
function _capitalize(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}
const defined = value => typeof value !== 'undefined';
const isFunction = value => typeof value === 'function';
// Adapted from https://stackoverflow.com/questions/31128855/comparing-ecma6-sets-for-equality#31129384
const setsEqual = (a, b) => {
  if (a.size !== b.size) {
    return false;
  }
  for (const item of a) {
    if (!b.has(item)) {
      return false;
    }
  }
  return true;
};
/**
 * @param e - The event
 * @private
 */
function _isClickEvent(e) {
  return e.type === 'mouseup' || e.type === 'click' || e.type === 'contextmenu';
}

/**
 * @alias Chart.helpers.math
 * @namespace
 */
const PI = Math.PI;
const TAU = 2 * PI;
const PITAU = TAU + PI;
const INFINITY = Number.POSITIVE_INFINITY;
const RAD_PER_DEG = PI / 180;
const HALF_PI = PI / 2;
const QUARTER_PI = PI / 4;
const TWO_THIRDS_PI = PI * 2 / 3;
const log10 = Math.log10;
const sign = Math.sign;
function almostEquals(x, y, epsilon) {
  return Math.abs(x - y) < epsilon;
}
/**
 * Implementation of the nice number algorithm used in determining where axis labels will go
 */
function niceNum(range) {
  const roundedRange = Math.round(range);
  range = almostEquals(range, roundedRange, range / 1000) ? roundedRange : range;
  const niceRange = Math.pow(10, Math.floor(log10(range)));
  const fraction = range / niceRange;
  const niceFraction = fraction <= 1 ? 1 : fraction <= 2 ? 2 : fraction <= 5 ? 5 : 10;
  return niceFraction * niceRange;
}
/**
 * Returns an array of factors sorted from 1 to sqrt(value)
 * @private
 */
function _factorize(value) {
  const result = [];
  const sqrt = Math.sqrt(value);
  let i;
  for (i = 1; i < sqrt; i++) {
    if (value % i === 0) {
      result.push(i);
      result.push(value / i);
    }
  }
  if (sqrt === (sqrt | 0)) {
    result.push(sqrt);
  }
  result.sort((a, b) => a - b).pop();
  return result;
}
function isNumber(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}
function almostWhole(x, epsilon) {
  const rounded = Math.round(x);
  return rounded - epsilon <= x && rounded + epsilon >= x;
}
/**
 * @private
 */
function _setMinAndMaxByKey(array, target, property) {
  let i, ilen, value;
  for (i = 0, ilen = array.length; i < ilen; i++) {
    value = array[i][property];
    if (!isNaN(value)) {
      target.min = Math.min(target.min, value);
      target.max = Math.max(target.max, value);
    }
  }
}
function toRadians(degrees) {
  return degrees * (PI / 180);
}
function toDegrees(radians) {
  return radians * (180 / PI);
}
/**
 * Returns the number of decimal places
 * i.e. the number of digits after the decimal point, of the value of this Number.
 * @param x - A number.
 * @returns The number of decimal places.
 * @private
 */
function _decimalPlaces(x) {
  if (!isNumberFinite(x)) {
    return;
  }
  let e = 1;
  let p = 0;
  while (Math.round(x * e) / e !== x) {
    e *= 10;
    p++;
  }
  return p;
}
// Gets the angle from vertical upright to the point about a centre.
function getAngleFromPoint(centrePoint, anglePoint) {
  const distanceFromXCenter = anglePoint.x - centrePoint.x;
  const distanceFromYCenter = anglePoint.y - centrePoint.y;
  const radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);
  let angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);
  if (angle < -0.5 * PI) {
    angle += TAU; // make sure the returned angle is in the range of (-PI/2, 3PI/2]
  }
  return {
    angle,
    distance: radialDistanceFromCenter
  };
}
function distanceBetweenPoints(pt1, pt2) {
  return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));
}
/**
 * Shortest distance between angles, in either direction.
 * @private
 */
function _angleDiff(a, b) {
  return (a - b + PITAU) % TAU - PI;
}
/**
 * Normalize angle to be between 0 and 2*PI
 * @private
 */
function _normalizeAngle(a) {
  return (a % TAU + TAU) % TAU;
}
/**
 * @private
 */
function _angleBetween(angle, start, end, sameAngleIsFullCircle) {
  const a = _normalizeAngle(angle);
  const s = _normalizeAngle(start);
  const e = _normalizeAngle(end);
  const angleToStart = _normalizeAngle(s - a);
  const angleToEnd = _normalizeAngle(e - a);
  const startToAngle = _normalizeAngle(a - s);
  const endToAngle = _normalizeAngle(a - e);
  return a === s || a === e || sameAngleIsFullCircle && s === e || angleToStart > angleToEnd && startToAngle < endToAngle;
}
/**
 * Limit `value` between `min` and `max`
 * @param value
 * @param min
 * @param max
 * @private
 */
function _limitValue(value, min, max) {
  return Math.max(min, Math.min(max, value));
}
/**
 * @param {number} value
 * @private
 */
function _int16Range(value) {
  return _limitValue(value, -32768, 32767);
}
/**
 * @param value
 * @param start
 * @param end
 * @param [epsilon]
 * @private
 */
function _isBetween(value, start, end, epsilon = 1e-6) {
  return value >= Math.min(start, end) - epsilon && value <= Math.max(start, end) + epsilon;
}
function _lookup(table, value, cmp) {
  cmp = cmp || (index => table[index] < value);
  let hi = table.length - 1;
  let lo = 0;
  let mid;
  while (hi - lo > 1) {
    mid = lo + hi >> 1;
    if (cmp(mid)) {
      lo = mid;
    } else {
      hi = mid;
    }
  }
  return {
    lo,
    hi
  };
}
/**
 * Binary search
 * @param table - the table search. must be sorted!
 * @param key - property name for the value in each entry
 * @param value - value to find
 * @param last - lookup last index
 * @private
 */
const _lookupByKey = (table, key, value, last) => _lookup(table, value, last ? index => {
  const ti = table[index][key];
  return ti < value || ti === value && table[index + 1][key] === value;
} : index => table[index][key] < value);
/**
 * Reverse binary search
 * @param table - the table search. must be sorted!
 * @param key - property name for the value in each entry
 * @param value - value to find
 * @private
 */
const _rlookupByKey = (table, key, value) => _lookup(table, value, index => table[index][key] >= value);
/**
 * Return subset of `values` between `min` and `max` inclusive.
 * Values are assumed to be in sorted order.
 * @param values - sorted array of values
 * @param min - min value
 * @param max - max value
 */
function _filterBetween(values, min, max) {
  let start = 0;
  let end = values.length;
  while (start < end && values[start] < min) {
    start++;
  }
  while (end > start && values[end - 1] > max) {
    end--;
  }
  return start > 0 || end < values.length ? values.slice(start, end) : values;
}
const arrayEvents = ['push', 'pop', 'shift', 'splice', 'unshift'];
function listenArrayEvents(array, listener) {
  if (array._chartjs) {
    array._chartjs.listeners.push(listener);
    return;
  }
  Object.defineProperty(array, '_chartjs', {
    configurable: true,
    enumerable: false,
    value: {
      listeners: [listener]
    }
  });
  arrayEvents.forEach(key => {
    const method = '_onData' + _capitalize(key);
    const base = array[key];
    Object.defineProperty(array, key, {
      configurable: true,
      enumerable: false,
      value(...args) {
        const res = base.apply(this, args);
        array._chartjs.listeners.forEach(object => {
          if (typeof object[method] === 'function') {
            object[method](...args);
          }
        });
        return res;
      }
    });
  });
}
function unlistenArrayEvents(array, listener) {
  const stub = array._chartjs;
  if (!stub) {
    return;
  }
  const listeners = stub.listeners;
  const index = listeners.indexOf(listener);
  if (index !== -1) {
    listeners.splice(index, 1);
  }
  if (listeners.length > 0) {
    return;
  }
  arrayEvents.forEach(key => {
    delete array[key];
  });
  delete array._chartjs;
}
/**
 * @param items
 */
function _arrayUnique(items) {
  const set = new Set(items);
  if (set.size === items.length) {
    return items;
  }
  return Array.from(set);
}
function fontString(pixelSize, fontStyle, fontFamily) {
  return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;
}
/**
* Request animation polyfill
*/
const requestAnimFrame = function () {
  if (typeof window === 'undefined') {
    return function (callback) {
      return callback();
    };
  }
  return window.requestAnimationFrame;
}();
/**
 * Throttles calling `fn` once per animation frame
 * Latest arguments are used on the actual call
 */
function throttled(fn, thisArg) {
  let argsToUse = [];
  let ticking = false;
  return function (...args) {
    // Save the args for use later
    argsToUse = args;
    if (!ticking) {
      ticking = true;
      requestAnimFrame.call(window, () => {
        ticking = false;
        fn.apply(thisArg, argsToUse);
      });
    }
  };
}
/**
 * Debounces calling `fn` for `delay` ms
 */
function debounce(fn, delay) {
  let timeout;
  return function (...args) {
    if (delay) {
      clearTimeout(timeout);
      timeout = setTimeout(fn, delay, args);
    } else {
      fn.apply(this, args);
    }
    return delay;
  };
}
/**
 * Converts 'start' to 'left', 'end' to 'right' and others to 'center'
 * @private
 */
const _toLeftRightCenter = align => align === 'start' ? 'left' : align === 'end' ? 'right' : 'center';
/**
 * Returns `start`, `end` or `(start + end) / 2` depending on `align`. Defaults to `center`
 * @private
 */
const _alignStartEnd = (align, start, end) => align === 'start' ? start : align === 'end' ? end : (start + end) / 2;
/**
 * Returns `left`, `right` or `(left + right) / 2` depending on `align`. Defaults to `left`
 * @private
 */
const _textX = (align, left, right, rtl) => {
  const check = rtl ? 'left' : 'right';
  return align === check ? right : align === 'center' ? (left + right) / 2 : left;
};
/**
 * Return start and count of visible points.
 * @private
 */
function _getStartAndCountOfVisiblePoints(meta, points, animationsDisabled) {
  const pointCount = points.length;
  let start = 0;
  let count = pointCount;
  if (meta._sorted) {
    const {
      iScale,
      _parsed
    } = meta;
    const axis = iScale.axis;
    const {
      min,
      max,
      minDefined,
      maxDefined
    } = iScale.getUserBounds();
    if (minDefined) {
      start = _limitValue(Math.min(
      // @ts-expect-error Need to type _parsed
      _lookupByKey(_parsed, axis, min).lo,
      // @ts-expect-error Need to fix types on _lookupByKey
      animationsDisabled ? pointCount : _lookupByKey(points, axis, iScale.getPixelForValue(min)).lo), 0, pointCount - 1);
    }
    if (maxDefined) {
      count = _limitValue(Math.max(
      // @ts-expect-error Need to type _parsed
      _lookupByKey(_parsed, iScale.axis, max, true).hi + 1,
      // @ts-expect-error Need to fix types on _lookupByKey
      animationsDisabled ? 0 : _lookupByKey(points, axis, iScale.getPixelForValue(max), true).hi + 1), start, pointCount) - start;
    } else {
      count = pointCount - start;
    }
  }
  return {
    start,
    count
  };
}
/**
 * Checks if the scale ranges have changed.
 * @param {object} meta - dataset meta.
 * @returns {boolean}
 * @private
 */
function _scaleRangesChanged(meta) {
  const {
    xScale,
    yScale,
    _scaleRanges
  } = meta;
  const newRanges = {
    xmin: xScale.min,
    xmax: xScale.max,
    ymin: yScale.min,
    ymax: yScale.max
  };
  if (!_scaleRanges) {
    meta._scaleRanges = newRanges;
    return true;
  }
  const changed = _scaleRanges.xmin !== xScale.min || _scaleRanges.xmax !== xScale.max || _scaleRanges.ymin !== yScale.min || _scaleRanges.ymax !== yScale.max;
  Object.assign(_scaleRanges, newRanges);
  return changed;
}
const atEdge = t => t === 0 || t === 1;
const elasticIn = (t, s, p) => -(Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * TAU / p));
const elasticOut = (t, s, p) => Math.pow(2, -10 * t) * Math.sin((t - s) * TAU / p) + 1;
/**
 * Easing functions adapted from Robert Penner's easing equations.
 * @namespace Chart.helpers.easing.effects
 * @see http://www.robertpenner.com/easing/
 */
const effects = {
  linear: t => t,
  easeInQuad: t => t * t,
  easeOutQuad: t => -t * (t - 2),
  easeInOutQuad: t => (t /= 0.5) < 1 ? 0.5 * t * t : -0.5 * (--t * (t - 2) - 1),
  easeInCubic: t => t * t * t,
  easeOutCubic: t => (t -= 1) * t * t + 1,
  easeInOutCubic: t => (t /= 0.5) < 1 ? 0.5 * t * t * t : 0.5 * ((t -= 2) * t * t + 2),
  easeInQuart: t => t * t * t * t,
  easeOutQuart: t => -((t -= 1) * t * t * t - 1),
  easeInOutQuart: t => (t /= 0.5) < 1 ? 0.5 * t * t * t * t : -0.5 * ((t -= 2) * t * t * t - 2),
  easeInQuint: t => t * t * t * t * t,
  easeOutQuint: t => (t -= 1) * t * t * t * t + 1,
  easeInOutQuint: t => (t /= 0.5) < 1 ? 0.5 * t * t * t * t * t : 0.5 * ((t -= 2) * t * t * t * t + 2),
  easeInSine: t => -Math.cos(t * HALF_PI) + 1,
  easeOutSine: t => Math.sin(t * HALF_PI),
  easeInOutSine: t => -0.5 * (Math.cos(PI * t) - 1),
  easeInExpo: t => t === 0 ? 0 : Math.pow(2, 10 * (t - 1)),
  easeOutExpo: t => t === 1 ? 1 : -Math.pow(2, -10 * t) + 1,
  easeInOutExpo: t => atEdge(t) ? t : t < 0.5 ? 0.5 * Math.pow(2, 10 * (t * 2 - 1)) : 0.5 * (-Math.pow(2, -10 * (t * 2 - 1)) + 2),
  easeInCirc: t => t >= 1 ? t : -(Math.sqrt(1 - t * t) - 1),
  easeOutCirc: t => Math.sqrt(1 - (t -= 1) * t),
  easeInOutCirc: t => (t /= 0.5) < 1 ? -0.5 * (Math.sqrt(1 - t * t) - 1) : 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1),
  easeInElastic: t => atEdge(t) ? t : elasticIn(t, 0.075, 0.3),
  easeOutElastic: t => atEdge(t) ? t : elasticOut(t, 0.075, 0.3),
  easeInOutElastic(t) {
    const s = 0.1125;
    const p = 0.45;
    return atEdge(t) ? t : t < 0.5 ? 0.5 * elasticIn(t * 2, s, p) : 0.5 + 0.5 * elasticOut(t * 2 - 1, s, p);
  },
  easeInBack(t) {
    const s = 1.70158;
    return t * t * ((s + 1) * t - s);
  },
  easeOutBack(t) {
    const s = 1.70158;
    return (t -= 1) * t * ((s + 1) * t + s) + 1;
  },
  easeInOutBack(t) {
    let s = 1.70158;
    if ((t /= 0.5) < 1) {
      return 0.5 * (t * t * (((s *= 1.525) + 1) * t - s));
    }
    return 0.5 * ((t -= 2) * t * (((s *= 1.525) + 1) * t + s) + 2);
  },
  easeInBounce: t => 1 - effects.easeOutBounce(1 - t),
  easeOutBounce(t) {
    const m = 7.5625;
    const d = 2.75;
    if (t < 1 / d) {
      return m * t * t;
    }
    if (t < 2 / d) {
      return m * (t -= 1.5 / d) * t + 0.75;
    }
    if (t < 2.5 / d) {
      return m * (t -= 2.25 / d) * t + 0.9375;
    }
    return m * (t -= 2.625 / d) * t + 0.984375;
  },
  easeInOutBounce: t => t < 0.5 ? effects.easeInBounce(t * 2) * 0.5 : effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5
};
function isPatternOrGradient(value) {
  if (value && typeof value === 'object') {
    const type = value.toString();
    return type === '[object CanvasPattern]' || type === '[object CanvasGradient]';
  }
  return false;
}
function color(value) {
  return isPatternOrGradient(value) ? value : new _kurkle_color__WEBPACK_IMPORTED_MODULE_0__.Color(value);
}
function getHoverColor(value) {
  return isPatternOrGradient(value) ? value : new _kurkle_color__WEBPACK_IMPORTED_MODULE_0__.Color(value).saturate(0.5).darken(0.1).hexString();
}
const numbers = ['x', 'y', 'borderWidth', 'radius', 'tension'];
const colors = ['color', 'borderColor', 'backgroundColor'];
function applyAnimationsDefaults(defaults) {
  defaults.set('animation', {
    delay: undefined,
    duration: 1000,
    easing: 'easeOutQuart',
    fn: undefined,
    from: undefined,
    loop: undefined,
    to: undefined,
    type: undefined
  });
  defaults.describe('animation', {
    _fallback: false,
    _indexable: false,
    _scriptable: name => name !== 'onProgress' && name !== 'onComplete' && name !== 'fn'
  });
  defaults.set('animations', {
    colors: {
      type: 'color',
      properties: colors
    },
    numbers: {
      type: 'number',
      properties: numbers
    }
  });
  defaults.describe('animations', {
    _fallback: 'animation'
  });
  defaults.set('transitions', {
    active: {
      animation: {
        duration: 400
      }
    },
    resize: {
      animation: {
        duration: 0
      }
    },
    show: {
      animations: {
        colors: {
          from: 'transparent'
        },
        visible: {
          type: 'boolean',
          duration: 0
        }
      }
    },
    hide: {
      animations: {
        colors: {
          to: 'transparent'
        },
        visible: {
          type: 'boolean',
          easing: 'linear',
          fn: v => v | 0
        }
      }
    }
  });
}
function applyLayoutsDefaults(defaults) {
  defaults.set('layout', {
    autoPadding: true,
    padding: {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    }
  });
}
const intlCache = new Map();
function getNumberFormat(locale, options) {
  options = options || {};
  const cacheKey = locale + JSON.stringify(options);
  let formatter = intlCache.get(cacheKey);
  if (!formatter) {
    formatter = new Intl.NumberFormat(locale, options);
    intlCache.set(cacheKey, formatter);
  }
  return formatter;
}
function formatNumber(num, locale, options) {
  return getNumberFormat(locale, options).format(num);
}
const formatters = {
  values(value) {
    return isArray(value) ? value : '' + value;
  },
  numeric(tickValue, index, ticks) {
    if (tickValue === 0) {
      return '0';
    }
    const locale = this.chart.options.locale;
    let notation;
    let delta = tickValue;
    if (ticks.length > 1) {
      const maxTick = Math.max(Math.abs(ticks[0].value), Math.abs(ticks[ticks.length - 1].value));
      if (maxTick < 1e-4 || maxTick > 1e+15) {
        notation = 'scientific';
      }
      delta = calculateDelta(tickValue, ticks);
    }
    const logDelta = log10(Math.abs(delta));
    const numDecimal = isNaN(logDelta) ? 1 : Math.max(Math.min(-1 * Math.floor(logDelta), 20), 0);
    const options = {
      notation,
      minimumFractionDigits: numDecimal,
      maximumFractionDigits: numDecimal
    };
    Object.assign(options, this.options.ticks.format);
    return formatNumber(tickValue, locale, options);
  },
  logarithmic(tickValue, index, ticks) {
    if (tickValue === 0) {
      return '0';
    }
    const remain = ticks[index].significand || tickValue / Math.pow(10, Math.floor(log10(tickValue)));
    if ([1, 2, 3, 5, 10, 15].includes(remain) || index > 0.8 * ticks.length) {
      return formatters.numeric.call(this, tickValue, index, ticks);
    }
    return '';
  }
};
function calculateDelta(tickValue, ticks) {
  let delta = ticks.length > 3 ? ticks[2].value - ticks[1].value : ticks[1].value - ticks[0].value;
  if (Math.abs(delta) >= 1 && tickValue !== Math.floor(tickValue)) {
    delta = tickValue - Math.floor(tickValue);
  }
  return delta;
}
var Ticks = {
  formatters
};
function applyScaleDefaults(defaults) {
  defaults.set('scale', {
    display: true,
    offset: false,
    reverse: false,
    beginAtZero: false,
    bounds: 'ticks',
    clip: true,
    grace: 0,
    grid: {
      display: true,
      lineWidth: 1,
      drawOnChartArea: true,
      drawTicks: true,
      tickLength: 8,
      tickWidth: (_ctx, options) => options.lineWidth,
      tickColor: (_ctx, options) => options.color,
      offset: false
    },
    border: {
      display: true,
      dash: [],
      dashOffset: 0.0,
      width: 1
    },
    title: {
      display: false,
      text: '',
      padding: {
        top: 4,
        bottom: 4
      }
    },
    ticks: {
      minRotation: 0,
      maxRotation: 50,
      mirror: false,
      textStrokeWidth: 0,
      textStrokeColor: '',
      padding: 3,
      display: true,
      autoSkip: true,
      autoSkipPadding: 3,
      labelOffset: 0,
      callback: Ticks.formatters.values,
      minor: {},
      major: {},
      align: 'center',
      crossAlign: 'near',
      showLabelBackdrop: false,
      backdropColor: 'rgba(255, 255, 255, 0.75)',
      backdropPadding: 2
    }
  });
  defaults.route('scale.ticks', 'color', '', 'color');
  defaults.route('scale.grid', 'color', '', 'borderColor');
  defaults.route('scale.border', 'color', '', 'borderColor');
  defaults.route('scale.title', 'color', '', 'color');
  defaults.describe('scale', {
    _fallback: false,
    _scriptable: name => !name.startsWith('before') && !name.startsWith('after') && name !== 'callback' && name !== 'parser',
    _indexable: name => name !== 'borderDash' && name !== 'tickBorderDash' && name !== 'dash'
  });
  defaults.describe('scales', {
    _fallback: 'scale'
  });
  defaults.describe('scale.ticks', {
    _scriptable: name => name !== 'backdropPadding' && name !== 'callback',
    _indexable: name => name !== 'backdropPadding'
  });
}
const overrides = Object.create(null);
const descriptors = Object.create(null);
function getScope$1(node, key) {
  if (!key) {
    return node;
  }
  const keys = key.split('.');
  for (let i = 0, n = keys.length; i < n; ++i) {
    const k = keys[i];
    node = node[k] || (node[k] = Object.create(null));
  }
  return node;
}
function set(root, scope, values) {
  if (typeof scope === 'string') {
    return merge(getScope$1(root, scope), values);
  }
  return merge(getScope$1(root, ''), scope);
}
class Defaults {
  constructor(_descriptors, _appliers) {
    this.animation = undefined;
    this.backgroundColor = 'rgba(0,0,0,0.1)';
    this.borderColor = 'rgba(0,0,0,0.1)';
    this.color = '#666';
    this.datasets = {};
    this.devicePixelRatio = context => context.chart.platform.getDevicePixelRatio();
    this.elements = {};
    this.events = ['mousemove', 'mouseout', 'click', 'touchstart', 'touchmove'];
    this.font = {
      family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
      size: 12,
      style: 'normal',
      lineHeight: 1.2,
      weight: null
    };
    this.hover = {};
    this.hoverBackgroundColor = (ctx, options) => getHoverColor(options.backgroundColor);
    this.hoverBorderColor = (ctx, options) => getHoverColor(options.borderColor);
    this.hoverColor = (ctx, options) => getHoverColor(options.color);
    this.indexAxis = 'x';
    this.interaction = {
      mode: 'nearest',
      intersect: true,
      includeInvisible: false
    };
    this.maintainAspectRatio = true;
    this.onHover = null;
    this.onClick = null;
    this.parsing = true;
    this.plugins = {};
    this.responsive = true;
    this.scale = undefined;
    this.scales = {};
    this.showLine = true;
    this.drawActiveElementsOnTop = true;
    this.describe(_descriptors);
    this.apply(_appliers);
  }
  set(scope, values) {
    return set(this, scope, values);
  }
  get(scope) {
    return getScope$1(this, scope);
  }
  describe(scope, values) {
    return set(descriptors, scope, values);
  }
  override(scope, values) {
    return set(overrides, scope, values);
  }
  route(scope, name, targetScope, targetName) {
    const scopeObject = getScope$1(this, scope);
    const targetScopeObject = getScope$1(this, targetScope);
    const privateName = '_' + name;
    Object.defineProperties(scopeObject, {
      [privateName]: {
        value: scopeObject[name],
        writable: true
      },
      [name]: {
        enumerable: true,
        get() {
          const local = this[privateName];
          const target = targetScopeObject[targetName];
          if (isObject(local)) {
            return Object.assign({}, target, local);
          }
          return valueOrDefault(local, target);
        },
        set(value) {
          this[privateName] = value;
        }
      }
    });
  }
  apply(appliers) {
    appliers.forEach(apply => apply(this));
  }
}
var defaults = /* #__PURE__ */new Defaults({
  _scriptable: name => !name.startsWith('on'),
  _indexable: name => name !== 'events',
  hover: {
    _fallback: 'interaction'
  },
  interaction: {
    _scriptable: false,
    _indexable: false
  }
}, [applyAnimationsDefaults, applyLayoutsDefaults, applyScaleDefaults]);

/**
 * Converts the given font object into a CSS font string.
 * @param font - A font object.
 * @return The CSS font string. See https://developer.mozilla.org/en-US/docs/Web/CSS/font
 * @private
 */
function toFontString(font) {
  if (!font || isNullOrUndef(font.size) || isNullOrUndef(font.family)) {
    return null;
  }
  return (font.style ? font.style + ' ' : '') + (font.weight ? font.weight + ' ' : '') + font.size + 'px ' + font.family;
}
/**
 * @private
 */
function _measureText(ctx, data, gc, longest, string) {
  let textWidth = data[string];
  if (!textWidth) {
    textWidth = data[string] = ctx.measureText(string).width;
    gc.push(string);
  }
  if (textWidth > longest) {
    longest = textWidth;
  }
  return longest;
}
/**
 * @private
 */ // eslint-disable-next-line complexity
function _longestText(ctx, font, arrayOfThings, cache) {
  cache = cache || {};
  let data = cache.data = cache.data || {};
  let gc = cache.garbageCollect = cache.garbageCollect || [];
  if (cache.font !== font) {
    data = cache.data = {};
    gc = cache.garbageCollect = [];
    cache.font = font;
  }
  ctx.save();
  ctx.font = font;
  let longest = 0;
  const ilen = arrayOfThings.length;
  let i, j, jlen, thing, nestedThing;
  for (i = 0; i < ilen; i++) {
    thing = arrayOfThings[i];
    // Undefined strings and arrays should not be measured
    if (thing !== undefined && thing !== null && !isArray(thing)) {
      longest = _measureText(ctx, data, gc, longest, thing);
    } else if (isArray(thing)) {
      // if it is an array lets measure each element
      // to do maybe simplify this function a bit so we can do this more recursively?
      for (j = 0, jlen = thing.length; j < jlen; j++) {
        nestedThing = thing[j];
        // Undefined strings and arrays should not be measured
        if (nestedThing !== undefined && nestedThing !== null && !isArray(nestedThing)) {
          longest = _measureText(ctx, data, gc, longest, nestedThing);
        }
      }
    }
  }
  ctx.restore();
  const gcLen = gc.length / 2;
  if (gcLen > arrayOfThings.length) {
    for (i = 0; i < gcLen; i++) {
      delete data[gc[i]];
    }
    gc.splice(0, gcLen);
  }
  return longest;
}
/**
 * Returns the aligned pixel value to avoid anti-aliasing blur
 * @param chart - The chart instance.
 * @param pixel - A pixel value.
 * @param width - The width of the element.
 * @returns The aligned pixel value.
 * @private
 */
function _alignPixel(chart, pixel, width) {
  const devicePixelRatio = chart.currentDevicePixelRatio;
  const halfWidth = width !== 0 ? Math.max(width / 2, 0.5) : 0;
  return Math.round((pixel - halfWidth) * devicePixelRatio) / devicePixelRatio + halfWidth;
}
/**
 * Clears the entire canvas.
 */
function clearCanvas(canvas, ctx) {
  if (!ctx && !canvas) {
    return;
  }
  ctx = ctx || canvas.getContext('2d');
  ctx.save();
  // canvas.width and canvas.height do not consider the canvas transform,
  // while clearRect does
  ctx.resetTransform();
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.restore();
}
function drawPoint(ctx, options, x, y) {
  // eslint-disable-next-line @typescript-eslint/no-use-before-define
  drawPointLegend(ctx, options, x, y, null);
}
// eslint-disable-next-line complexity
function drawPointLegend(ctx, options, x, y, w) {
  let type, xOffset, yOffset, size, cornerRadius, width, xOffsetW, yOffsetW;
  const style = options.pointStyle;
  const rotation = options.rotation;
  const radius = options.radius;
  let rad = (rotation || 0) * RAD_PER_DEG;
  if (style && typeof style === 'object') {
    type = style.toString();
    if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {
      ctx.save();
      ctx.translate(x, y);
      ctx.rotate(rad);
      ctx.drawImage(style, -style.width / 2, -style.height / 2, style.width, style.height);
      ctx.restore();
      return;
    }
  }
  if (isNaN(radius) || radius <= 0) {
    return;
  }
  ctx.beginPath();
  switch (style) {
    // Default includes circle
    default:
      if (w) {
        ctx.ellipse(x, y, w / 2, radius, 0, 0, TAU);
      } else {
        ctx.arc(x, y, radius, 0, TAU);
      }
      ctx.closePath();
      break;
    case 'triangle':
      width = w ? w / 2 : radius;
      ctx.moveTo(x + Math.sin(rad) * width, y - Math.cos(rad) * radius);
      rad += TWO_THIRDS_PI;
      ctx.lineTo(x + Math.sin(rad) * width, y - Math.cos(rad) * radius);
      rad += TWO_THIRDS_PI;
      ctx.lineTo(x + Math.sin(rad) * width, y - Math.cos(rad) * radius);
      ctx.closePath();
      break;
    case 'rectRounded':
      // NOTE: the rounded rect implementation changed to use `arc` instead of
      // `quadraticCurveTo` since it generates better results when rect is
      // almost a circle. 0.516 (instead of 0.5) produces results with visually
      // closer proportion to the previous impl and it is inscribed in the
      // circle with `radius`. For more details, see the following PRs:
      // https://github.com/chartjs/Chart.js/issues/5597
      // https://github.com/chartjs/Chart.js/issues/5858
      cornerRadius = radius * 0.516;
      size = radius - cornerRadius;
      xOffset = Math.cos(rad + QUARTER_PI) * size;
      xOffsetW = Math.cos(rad + QUARTER_PI) * (w ? w / 2 - cornerRadius : size);
      yOffset = Math.sin(rad + QUARTER_PI) * size;
      yOffsetW = Math.sin(rad + QUARTER_PI) * (w ? w / 2 - cornerRadius : size);
      ctx.arc(x - xOffsetW, y - yOffset, cornerRadius, rad - PI, rad - HALF_PI);
      ctx.arc(x + yOffsetW, y - xOffset, cornerRadius, rad - HALF_PI, rad);
      ctx.arc(x + xOffsetW, y + yOffset, cornerRadius, rad, rad + HALF_PI);
      ctx.arc(x - yOffsetW, y + xOffset, cornerRadius, rad + HALF_PI, rad + PI);
      ctx.closePath();
      break;
    case 'rect':
      if (!rotation) {
        size = Math.SQRT1_2 * radius;
        width = w ? w / 2 : size;
        ctx.rect(x - width, y - size, 2 * width, 2 * size);
        break;
      }
      rad += QUARTER_PI;
    /* falls through */
    case 'rectRot':
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      ctx.closePath();
      break;
    case 'crossRot':
      rad += QUARTER_PI;
    /* falls through */
    case 'cross':
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.moveTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      break;
    case 'star':
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.moveTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      rad += QUARTER_PI;
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.moveTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      break;
    case 'line':
      xOffset = w ? w / 2 : Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      ctx.moveTo(x - xOffset, y - yOffset);
      ctx.lineTo(x + xOffset, y + yOffset);
      break;
    case 'dash':
      ctx.moveTo(x, y);
      ctx.lineTo(x + Math.cos(rad) * (w ? w / 2 : radius), y + Math.sin(rad) * radius);
      break;
    case false:
      ctx.closePath();
      break;
  }
  ctx.fill();
  if (options.borderWidth > 0) {
    ctx.stroke();
  }
}
/**
 * Returns true if the point is inside the rectangle
 * @param point - The point to test
 * @param area - The rectangle
 * @param margin - allowed margin
 * @private
 */
function _isPointInArea(point, area, margin) {
  margin = margin || 0.5; // margin - default is to match rounded decimals
  return !area || point && point.x > area.left - margin && point.x < area.right + margin && point.y > area.top - margin && point.y < area.bottom + margin;
}
function clipArea(ctx, area) {
  ctx.save();
  ctx.beginPath();
  ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);
  ctx.clip();
}
function unclipArea(ctx) {
  ctx.restore();
}
/**
 * @private
 */
function _steppedLineTo(ctx, previous, target, flip, mode) {
  if (!previous) {
    return ctx.lineTo(target.x, target.y);
  }
  if (mode === 'middle') {
    const midpoint = (previous.x + target.x) / 2.0;
    ctx.lineTo(midpoint, previous.y);
    ctx.lineTo(midpoint, target.y);
  } else if (mode === 'after' !== !!flip) {
    ctx.lineTo(previous.x, target.y);
  } else {
    ctx.lineTo(target.x, previous.y);
  }
  ctx.lineTo(target.x, target.y);
}
/**
 * @private
 */
function _bezierCurveTo(ctx, previous, target, flip) {
  if (!previous) {
    return ctx.lineTo(target.x, target.y);
  }
  ctx.bezierCurveTo(flip ? previous.cp1x : previous.cp2x, flip ? previous.cp1y : previous.cp2y, flip ? target.cp2x : target.cp1x, flip ? target.cp2y : target.cp1y, target.x, target.y);
}
function setRenderOpts(ctx, opts) {
  if (opts.translation) {
    ctx.translate(opts.translation[0], opts.translation[1]);
  }
  if (!isNullOrUndef(opts.rotation)) {
    ctx.rotate(opts.rotation);
  }
  if (opts.color) {
    ctx.fillStyle = opts.color;
  }
  if (opts.textAlign) {
    ctx.textAlign = opts.textAlign;
  }
  if (opts.textBaseline) {
    ctx.textBaseline = opts.textBaseline;
  }
}
function decorateText(ctx, x, y, line, opts) {
  if (opts.strikethrough || opts.underline) {
    /**
    * Now that IE11 support has been dropped, we can use more
    * of the TextMetrics object. The actual bounding boxes
    * are unflagged in Chrome, Firefox, Edge, and Safari so they
    * can be safely used.
    * See https://developer.mozilla.org/en-US/docs/Web/API/TextMetrics#Browser_compatibility
    */
    const metrics = ctx.measureText(line);
    const left = x - metrics.actualBoundingBoxLeft;
    const right = x + metrics.actualBoundingBoxRight;
    const top = y - metrics.actualBoundingBoxAscent;
    const bottom = y + metrics.actualBoundingBoxDescent;
    const yDecoration = opts.strikethrough ? (top + bottom) / 2 : bottom;
    ctx.strokeStyle = ctx.fillStyle;
    ctx.beginPath();
    ctx.lineWidth = opts.decorationWidth || 2;
    ctx.moveTo(left, yDecoration);
    ctx.lineTo(right, yDecoration);
    ctx.stroke();
  }
}
function drawBackdrop(ctx, opts) {
  const oldColor = ctx.fillStyle;
  ctx.fillStyle = opts.color;
  ctx.fillRect(opts.left, opts.top, opts.width, opts.height);
  ctx.fillStyle = oldColor;
}
/**
 * Render text onto the canvas
 */
function renderText(ctx, text, x, y, font, opts = {}) {
  const lines = isArray(text) ? text : [text];
  const stroke = opts.strokeWidth > 0 && opts.strokeColor !== '';
  let i, line;
  ctx.save();
  ctx.font = font.string;
  setRenderOpts(ctx, opts);
  for (i = 0; i < lines.length; ++i) {
    line = lines[i];
    if (opts.backdrop) {
      drawBackdrop(ctx, opts.backdrop);
    }
    if (stroke) {
      if (opts.strokeColor) {
        ctx.strokeStyle = opts.strokeColor;
      }
      if (!isNullOrUndef(opts.strokeWidth)) {
        ctx.lineWidth = opts.strokeWidth;
      }
      ctx.strokeText(line, x, y, opts.maxWidth);
    }
    ctx.fillText(line, x, y, opts.maxWidth);
    decorateText(ctx, x, y, line, opts);
    y += Number(font.lineHeight);
  }
  ctx.restore();
}
/**
 * Add a path of a rectangle with rounded corners to the current sub-path
 * @param ctx - Context
 * @param rect - Bounding rect
 */
function addRoundedRectPath(ctx, rect) {
  const {
    x,
    y,
    w,
    h,
    radius
  } = rect;
  // top left arc
  ctx.arc(x + radius.topLeft, y + radius.topLeft, radius.topLeft, 1.5 * PI, PI, true);
  // line from top left to bottom left
  ctx.lineTo(x, y + h - radius.bottomLeft);
  // bottom left arc
  ctx.arc(x + radius.bottomLeft, y + h - radius.bottomLeft, radius.bottomLeft, PI, HALF_PI, true);
  // line from bottom left to bottom right
  ctx.lineTo(x + w - radius.bottomRight, y + h);
  // bottom right arc
  ctx.arc(x + w - radius.bottomRight, y + h - radius.bottomRight, radius.bottomRight, HALF_PI, 0, true);
  // line from bottom right to top right
  ctx.lineTo(x + w, y + radius.topRight);
  // top right arc
  ctx.arc(x + w - radius.topRight, y + radius.topRight, radius.topRight, 0, -HALF_PI, true);
  // line from top right to top left
  ctx.lineTo(x + radius.topLeft, y);
}
const LINE_HEIGHT = /^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/;
const FONT_STYLE = /^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/;
/**
 * @alias Chart.helpers.options
 * @namespace
 */ /**
    * Converts the given line height `value` in pixels for a specific font `size`.
    * @param value - The lineHeight to parse (eg. 1.6, '14px', '75%', '1.6em').
    * @param size - The font size (in pixels) used to resolve relative `value`.
    * @returns The effective line height in pixels (size * 1.2 if value is invalid).
    * @see https://developer.mozilla.org/en-US/docs/Web/CSS/line-height
    * @since 2.7.0
    */
function toLineHeight(value, size) {
  const matches = ('' + value).match(LINE_HEIGHT);
  if (!matches || matches[1] === 'normal') {
    return size * 1.2;
  }
  value = +matches[2];
  switch (matches[3]) {
    case 'px':
      return value;
    case '%':
      value /= 100;
      break;
  }
  return size * value;
}
const numberOrZero = v => +v || 0;
function _readValueToProps(value, props) {
  const ret = {};
  const objProps = isObject(props);
  const keys = objProps ? Object.keys(props) : props;
  const read = isObject(value) ? objProps ? prop => valueOrDefault(value[prop], value[props[prop]]) : prop => value[prop] : () => value;
  for (const prop of keys) {
    ret[prop] = numberOrZero(read(prop));
  }
  return ret;
}
/**
 * Converts the given value into a TRBL object.
 * @param value - If a number, set the value to all TRBL component,
 *  else, if an object, use defined properties and sets undefined ones to 0.
 *  x / y are shorthands for same value for left/right and top/bottom.
 * @returns The padding values (top, right, bottom, left)
 * @since 3.0.0
 */
function toTRBL(value) {
  return _readValueToProps(value, {
    top: 'y',
    right: 'x',
    bottom: 'y',
    left: 'x'
  });
}
/**
 * Converts the given value into a TRBL corners object (similar with css border-radius).
 * @param value - If a number, set the value to all TRBL corner components,
 *  else, if an object, use defined properties and sets undefined ones to 0.
 * @returns The TRBL corner values (topLeft, topRight, bottomLeft, bottomRight)
 * @since 3.0.0
 */
function toTRBLCorners(value) {
  return _readValueToProps(value, ['topLeft', 'topRight', 'bottomLeft', 'bottomRight']);
}
/**
 * Converts the given value into a padding object with pre-computed width/height.
 * @param value - If a number, set the value to all TRBL component,
 *  else, if an object, use defined properties and sets undefined ones to 0.
 *  x / y are shorthands for same value for left/right and top/bottom.
 * @returns The padding values (top, right, bottom, left, width, height)
 * @since 2.7.0
 */
function toPadding(value) {
  const obj = toTRBL(value);
  obj.width = obj.left + obj.right;
  obj.height = obj.top + obj.bottom;
  return obj;
}
/**
 * Parses font options and returns the font object.
 * @param options - A object that contains font options to be parsed.
 * @param fallback - A object that contains fallback font options.
 * @return The font object.
 * @private
 */
function toFont(options, fallback) {
  options = options || {};
  fallback = fallback || defaults.font;
  let size = valueOrDefault(options.size, fallback.size);
  if (typeof size === 'string') {
    size = parseInt(size, 10);
  }
  let style = valueOrDefault(options.style, fallback.style);
  if (style && !('' + style).match(FONT_STYLE)) {
    console.warn('Invalid font style specified: "' + style + '"');
    style = undefined;
  }
  const font = {
    family: valueOrDefault(options.family, fallback.family),
    lineHeight: toLineHeight(valueOrDefault(options.lineHeight, fallback.lineHeight), size),
    size,
    style,
    weight: valueOrDefault(options.weight, fallback.weight),
    string: ''
  };
  font.string = toFontString(font);
  return font;
}
/**
 * Evaluates the given `inputs` sequentially and returns the first defined value.
 * @param inputs - An array of values, falling back to the last value.
 * @param context - If defined and the current value is a function, the value
 * is called with `context` as first argument and the result becomes the new input.
 * @param index - If defined and the current value is an array, the value
 * at `index` become the new input.
 * @param info - object to return information about resolution in
 * @param info.cacheable - Will be set to `false` if option is not cacheable.
 * @since 2.7.0
 */
function resolve(inputs, context, index, info) {
  let cacheable = true;
  let i, ilen, value;
  for (i = 0, ilen = inputs.length; i < ilen; ++i) {
    value = inputs[i];
    if (value === undefined) {
      continue;
    }
    if (context !== undefined && typeof value === 'function') {
      value = value(context);
      cacheable = false;
    }
    if (index !== undefined && isArray(value)) {
      value = value[index % value.length];
      cacheable = false;
    }
    if (value !== undefined) {
      if (info && !cacheable) {
        info.cacheable = false;
      }
      return value;
    }
  }
}
/**
 * @param minmax
 * @param grace
 * @param beginAtZero
 * @private
 */
function _addGrace(minmax, grace, beginAtZero) {
  const {
    min,
    max
  } = minmax;
  const change = toDimension(grace, (max - min) / 2);
  const keepZero = (value, add) => beginAtZero && value === 0 ? 0 : value + add;
  return {
    min: keepZero(min, -Math.abs(change)),
    max: keepZero(max, change)
  };
}
function createContext(parentContext, context) {
  return Object.assign(Object.create(parentContext), context);
}

/**
 * Creates a Proxy for resolving raw values for options.
 * @param scopes - The option scopes to look for values, in resolution order
 * @param prefixes - The prefixes for values, in resolution order.
 * @param rootScopes - The root option scopes
 * @param fallback - Parent scopes fallback
 * @param getTarget - callback for getting the target for changed values
 * @returns Proxy
 * @private
 */
function _createResolver(scopes, prefixes = [''], rootScopes, fallback, getTarget = () => scopes[0]) {
  const finalRootScopes = rootScopes || scopes;
  if (typeof fallback === 'undefined') {
    fallback = _resolve('_fallback', scopes);
  }
  const cache = {
    [Symbol.toStringTag]: 'Object',
    _cacheable: true,
    _scopes: scopes,
    _rootScopes: finalRootScopes,
    _fallback: fallback,
    _getTarget: getTarget,
    override: scope => _createResolver([scope, ...scopes], prefixes, finalRootScopes, fallback)
  };
  return new Proxy(cache, {
    /**
    * A trap for the delete operator.
    */
    deleteProperty(target, prop) {
      delete target[prop]; // remove from cache
      delete target._keys; // remove cached keys
      delete scopes[0][prop]; // remove from top level scope
      return true;
    },
    /**
    * A trap for getting property values.
    */
    get(target, prop) {
      return _cached(target, prop, () => _resolveWithPrefixes(prop, prefixes, scopes, target));
    },
    /**
    * A trap for Object.getOwnPropertyDescriptor.
    * Also used by Object.hasOwnProperty.
    */
    getOwnPropertyDescriptor(target, prop) {
      return Reflect.getOwnPropertyDescriptor(target._scopes[0], prop);
    },
    /**
    * A trap for Object.getPrototypeOf.
    */
    getPrototypeOf() {
      return Reflect.getPrototypeOf(scopes[0]);
    },
    /**
    * A trap for the in operator.
    */
    has(target, prop) {
      return getKeysFromAllScopes(target).includes(prop);
    },
    /**
    * A trap for Object.getOwnPropertyNames and Object.getOwnPropertySymbols.
    */
    ownKeys(target) {
      return getKeysFromAllScopes(target);
    },
    /**
    * A trap for setting property values.
    */
    set(target, prop, value) {
      const storage = target._storage || (target._storage = getTarget());
      target[prop] = storage[prop] = value; // set to top level scope + cache
      delete target._keys; // remove cached keys
      return true;
    }
  });
}
/**
 * Returns an Proxy for resolving option values with context.
 * @param proxy - The Proxy returned by `_createResolver`
 * @param context - Context object for scriptable/indexable options
 * @param subProxy - The proxy provided for scriptable options
 * @param descriptorDefaults - Defaults for descriptors
 * @private
 */
function _attachContext(proxy, context, subProxy, descriptorDefaults) {
  const cache = {
    _cacheable: false,
    _proxy: proxy,
    _context: context,
    _subProxy: subProxy,
    _stack: new Set(),
    _descriptors: _descriptors(proxy, descriptorDefaults),
    setContext: ctx => _attachContext(proxy, ctx, subProxy, descriptorDefaults),
    override: scope => _attachContext(proxy.override(scope), context, subProxy, descriptorDefaults)
  };
  return new Proxy(cache, {
    /**
    * A trap for the delete operator.
    */
    deleteProperty(target, prop) {
      delete target[prop]; // remove from cache
      delete proxy[prop]; // remove from proxy
      return true;
    },
    /**
    * A trap for getting property values.
    */
    get(target, prop, receiver) {
      return _cached(target, prop, () => _resolveWithContext(target, prop, receiver));
    },
    /**
    * A trap for Object.getOwnPropertyDescriptor.
    * Also used by Object.hasOwnProperty.
    */
    getOwnPropertyDescriptor(target, prop) {
      return target._descriptors.allKeys ? Reflect.has(proxy, prop) ? {
        enumerable: true,
        configurable: true
      } : undefined : Reflect.getOwnPropertyDescriptor(proxy, prop);
    },
    /**
    * A trap for Object.getPrototypeOf.
    */
    getPrototypeOf() {
      return Reflect.getPrototypeOf(proxy);
    },
    /**
    * A trap for the in operator.
    */
    has(target, prop) {
      return Reflect.has(proxy, prop);
    },
    /**
    * A trap for Object.getOwnPropertyNames and Object.getOwnPropertySymbols.
    */
    ownKeys() {
      return Reflect.ownKeys(proxy);
    },
    /**
    * A trap for setting property values.
    */
    set(target, prop, value) {
      proxy[prop] = value; // set to proxy
      delete target[prop]; // remove from cache
      return true;
    }
  });
}
/**
 * @private
 */
function _descriptors(proxy, defaults = {
  scriptable: true,
  indexable: true
}) {
  const {
    _scriptable = defaults.scriptable,
    _indexable = defaults.indexable,
    _allKeys = defaults.allKeys
  } = proxy;
  return {
    allKeys: _allKeys,
    scriptable: _scriptable,
    indexable: _indexable,
    isScriptable: isFunction(_scriptable) ? _scriptable : () => _scriptable,
    isIndexable: isFunction(_indexable) ? _indexable : () => _indexable
  };
}
const readKey = (prefix, name) => prefix ? prefix + _capitalize(name) : name;
const needsSubResolver = (prop, value) => isObject(value) && prop !== 'adapters' && (Object.getPrototypeOf(value) === null || value.constructor === Object);
function _cached(target, prop, resolve) {
  if (Object.prototype.hasOwnProperty.call(target, prop) || prop === 'constructor') {
    return target[prop];
  }
  const value = resolve();
  // cache the resolved value
  target[prop] = value;
  return value;
}
function _resolveWithContext(target, prop, receiver) {
  const {
    _proxy,
    _context,
    _subProxy,
    _descriptors: descriptors
  } = target;
  let value = _proxy[prop]; // resolve from proxy
  // resolve with context
  if (isFunction(value) && descriptors.isScriptable(prop)) {
    value = _resolveScriptable(prop, value, target, receiver);
  }
  if (isArray(value) && value.length) {
    value = _resolveArray(prop, value, target, descriptors.isIndexable);
  }
  if (needsSubResolver(prop, value)) {
    // if the resolved value is an object, create a sub resolver for it
    value = _attachContext(value, _context, _subProxy && _subProxy[prop], descriptors);
  }
  return value;
}
function _resolveScriptable(prop, getValue, target, receiver) {
  const {
    _proxy,
    _context,
    _subProxy,
    _stack
  } = target;
  if (_stack.has(prop)) {
    throw new Error('Recursion detected: ' + Array.from(_stack).join('->') + '->' + prop);
  }
  _stack.add(prop);
  let value = getValue(_context, _subProxy || receiver);
  _stack.delete(prop);
  if (needsSubResolver(prop, value)) {
    // When scriptable option returns an object, create a resolver on that.
    value = createSubResolver(_proxy._scopes, _proxy, prop, value);
  }
  return value;
}
function _resolveArray(prop, value, target, isIndexable) {
  const {
    _proxy,
    _context,
    _subProxy,
    _descriptors: descriptors
  } = target;
  if (typeof _context.index !== 'undefined' && isIndexable(prop)) {
    return value[_context.index % value.length];
  } else if (isObject(value[0])) {
    // Array of objects, return array or resolvers
    const arr = value;
    const scopes = _proxy._scopes.filter(s => s !== arr);
    value = [];
    for (const item of arr) {
      const resolver = createSubResolver(scopes, _proxy, prop, item);
      value.push(_attachContext(resolver, _context, _subProxy && _subProxy[prop], descriptors));
    }
  }
  return value;
}
function resolveFallback(fallback, prop, value) {
  return isFunction(fallback) ? fallback(prop, value) : fallback;
}
const getScope = (key, parent) => key === true ? parent : typeof key === 'string' ? resolveObjectKey(parent, key) : undefined;
function addScopes(set, parentScopes, key, parentFallback, value) {
  for (const parent of parentScopes) {
    const scope = getScope(key, parent);
    if (scope) {
      set.add(scope);
      const fallback = resolveFallback(scope._fallback, key, value);
      if (typeof fallback !== 'undefined' && fallback !== key && fallback !== parentFallback) {
        // When we reach the descriptor that defines a new _fallback, return that.
        // The fallback will resume to that new scope.
        return fallback;
      }
    } else if (scope === false && typeof parentFallback !== 'undefined' && key !== parentFallback) {
      // Fallback to `false` results to `false`, when falling back to different key.
      // For example `interaction` from `hover` or `plugins.tooltip` and `animation` from `animations`
      return null;
    }
  }
  return false;
}
function createSubResolver(parentScopes, resolver, prop, value) {
  const rootScopes = resolver._rootScopes;
  const fallback = resolveFallback(resolver._fallback, prop, value);
  const allScopes = [...parentScopes, ...rootScopes];
  const set = new Set();
  set.add(value);
  let key = addScopesFromKey(set, allScopes, prop, fallback || prop, value);
  if (key === null) {
    return false;
  }
  if (typeof fallback !== 'undefined' && fallback !== prop) {
    key = addScopesFromKey(set, allScopes, fallback, key, value);
    if (key === null) {
      return false;
    }
  }
  return _createResolver(Array.from(set), [''], rootScopes, fallback, () => subGetTarget(resolver, prop, value));
}
function addScopesFromKey(set, allScopes, key, fallback, item) {
  while (key) {
    key = addScopes(set, allScopes, key, fallback, item);
  }
  return key;
}
function subGetTarget(resolver, prop, value) {
  const parent = resolver._getTarget();
  if (!(prop in parent)) {
    parent[prop] = {};
  }
  const target = parent[prop];
  if (isArray(target) && isObject(value)) {
    // For array of objects, the object is used to store updated values
    return value;
  }
  return target || {};
}
function _resolveWithPrefixes(prop, prefixes, scopes, proxy) {
  let value;
  for (const prefix of prefixes) {
    value = _resolve(readKey(prefix, prop), scopes);
    if (typeof value !== 'undefined') {
      return needsSubResolver(prop, value) ? createSubResolver(scopes, proxy, prop, value) : value;
    }
  }
}
function _resolve(key, scopes) {
  for (const scope of scopes) {
    if (!scope) {
      continue;
    }
    const value = scope[key];
    if (typeof value !== 'undefined') {
      return value;
    }
  }
}
function getKeysFromAllScopes(target) {
  let keys = target._keys;
  if (!keys) {
    keys = target._keys = resolveKeysFromAllScopes(target._scopes);
  }
  return keys;
}
function resolveKeysFromAllScopes(scopes) {
  const set = new Set();
  for (const scope of scopes) {
    for (const key of Object.keys(scope).filter(k => !k.startsWith('_'))) {
      set.add(key);
    }
  }
  return Array.from(set);
}
function _parseObjectDataRadialScale(meta, data, start, count) {
  const {
    iScale
  } = meta;
  const {
    key = 'r'
  } = this._parsing;
  const parsed = new Array(count);
  let i, ilen, index, item;
  for (i = 0, ilen = count; i < ilen; ++i) {
    index = i + start;
    item = data[index];
    parsed[i] = {
      r: iScale.parse(resolveObjectKey(item, key), index)
    };
  }
  return parsed;
}
const EPSILON = Number.EPSILON || 1e-14;
const getPoint = (points, i) => i < points.length && !points[i].skip && points[i];
const getValueAxis = indexAxis => indexAxis === 'x' ? 'y' : 'x';
function splineCurve(firstPoint, middlePoint, afterPoint, t) {
  // Props to Rob Spencer at scaled innovation for his post on splining between points
  // http://scaledinnovation.com/analytics/splines/aboutSplines.html
  // This function must also respect "skipped" points
  const previous = firstPoint.skip ? middlePoint : firstPoint;
  const current = middlePoint;
  const next = afterPoint.skip ? middlePoint : afterPoint;
  const d01 = distanceBetweenPoints(current, previous);
  const d12 = distanceBetweenPoints(next, current);
  let s01 = d01 / (d01 + d12);
  let s12 = d12 / (d01 + d12);
  // If all points are the same, s01 & s02 will be inf
  s01 = isNaN(s01) ? 0 : s01;
  s12 = isNaN(s12) ? 0 : s12;
  const fa = t * s01; // scaling factor for triangle Ta
  const fb = t * s12;
  return {
    previous: {
      x: current.x - fa * (next.x - previous.x),
      y: current.y - fa * (next.y - previous.y)
    },
    next: {
      x: current.x + fb * (next.x - previous.x),
      y: current.y + fb * (next.y - previous.y)
    }
  };
}
/**
 * Adjust tangents to ensure monotonic properties
 */
function monotoneAdjust(points, deltaK, mK) {
  const pointsLen = points.length;
  let alphaK, betaK, tauK, squaredMagnitude, pointCurrent;
  let pointAfter = getPoint(points, 0);
  for (let i = 0; i < pointsLen - 1; ++i) {
    pointCurrent = pointAfter;
    pointAfter = getPoint(points, i + 1);
    if (!pointCurrent || !pointAfter) {
      continue;
    }
    if (almostEquals(deltaK[i], 0, EPSILON)) {
      mK[i] = mK[i + 1] = 0;
      continue;
    }
    alphaK = mK[i] / deltaK[i];
    betaK = mK[i + 1] / deltaK[i];
    squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);
    if (squaredMagnitude <= 9) {
      continue;
    }
    tauK = 3 / Math.sqrt(squaredMagnitude);
    mK[i] = alphaK * tauK * deltaK[i];
    mK[i + 1] = betaK * tauK * deltaK[i];
  }
}
function monotoneCompute(points, mK, indexAxis = 'x') {
  const valueAxis = getValueAxis(indexAxis);
  const pointsLen = points.length;
  let delta, pointBefore, pointCurrent;
  let pointAfter = getPoint(points, 0);
  for (let i = 0; i < pointsLen; ++i) {
    pointBefore = pointCurrent;
    pointCurrent = pointAfter;
    pointAfter = getPoint(points, i + 1);
    if (!pointCurrent) {
      continue;
    }
    const iPixel = pointCurrent[indexAxis];
    const vPixel = pointCurrent[valueAxis];
    if (pointBefore) {
      delta = (iPixel - pointBefore[indexAxis]) / 3;
      pointCurrent[`cp1${indexAxis}`] = iPixel - delta;
      pointCurrent[`cp1${valueAxis}`] = vPixel - delta * mK[i];
    }
    if (pointAfter) {
      delta = (pointAfter[indexAxis] - iPixel) / 3;
      pointCurrent[`cp2${indexAxis}`] = iPixel + delta;
      pointCurrent[`cp2${valueAxis}`] = vPixel + delta * mK[i];
    }
  }
}
/**
 * This function calculates Bézier control points in a similar way than |splineCurve|,
 * but preserves monotonicity of the provided data and ensures no local extremums are added
 * between the dataset discrete points due to the interpolation.
 * See : https://en.wikipedia.org/wiki/Monotone_cubic_interpolation
 */
function splineCurveMonotone(points, indexAxis = 'x') {
  const valueAxis = getValueAxis(indexAxis);
  const pointsLen = points.length;
  const deltaK = Array(pointsLen).fill(0);
  const mK = Array(pointsLen);
  // Calculate slopes (deltaK) and initialize tangents (mK)
  let i, pointBefore, pointCurrent;
  let pointAfter = getPoint(points, 0);
  for (i = 0; i < pointsLen; ++i) {
    pointBefore = pointCurrent;
    pointCurrent = pointAfter;
    pointAfter = getPoint(points, i + 1);
    if (!pointCurrent) {
      continue;
    }
    if (pointAfter) {
      const slopeDelta = pointAfter[indexAxis] - pointCurrent[indexAxis];
      // In the case of two points that appear at the same x pixel, slopeDeltaX is 0
      deltaK[i] = slopeDelta !== 0 ? (pointAfter[valueAxis] - pointCurrent[valueAxis]) / slopeDelta : 0;
    }
    mK[i] = !pointBefore ? deltaK[i] : !pointAfter ? deltaK[i - 1] : sign(deltaK[i - 1]) !== sign(deltaK[i]) ? 0 : (deltaK[i - 1] + deltaK[i]) / 2;
  }
  monotoneAdjust(points, deltaK, mK);
  monotoneCompute(points, mK, indexAxis);
}
function capControlPoint(pt, min, max) {
  return Math.max(Math.min(pt, max), min);
}
function capBezierPoints(points, area) {
  let i, ilen, point, inArea, inAreaPrev;
  let inAreaNext = _isPointInArea(points[0], area);
  for (i = 0, ilen = points.length; i < ilen; ++i) {
    inAreaPrev = inArea;
    inArea = inAreaNext;
    inAreaNext = i < ilen - 1 && _isPointInArea(points[i + 1], area);
    if (!inArea) {
      continue;
    }
    point = points[i];
    if (inAreaPrev) {
      point.cp1x = capControlPoint(point.cp1x, area.left, area.right);
      point.cp1y = capControlPoint(point.cp1y, area.top, area.bottom);
    }
    if (inAreaNext) {
      point.cp2x = capControlPoint(point.cp2x, area.left, area.right);
      point.cp2y = capControlPoint(point.cp2y, area.top, area.bottom);
    }
  }
}
/**
 * @private
 */
function _updateBezierControlPoints(points, options, area, loop, indexAxis) {
  let i, ilen, point, controlPoints;
  // Only consider points that are drawn in case the spanGaps option is used
  if (options.spanGaps) {
    points = points.filter(pt => !pt.skip);
  }
  if (options.cubicInterpolationMode === 'monotone') {
    splineCurveMonotone(points, indexAxis);
  } else {
    let prev = loop ? points[points.length - 1] : points[0];
    for (i = 0, ilen = points.length; i < ilen; ++i) {
      point = points[i];
      controlPoints = splineCurve(prev, point, points[Math.min(i + 1, ilen - (loop ? 0 : 1)) % ilen], options.tension);
      point.cp1x = controlPoints.previous.x;
      point.cp1y = controlPoints.previous.y;
      point.cp2x = controlPoints.next.x;
      point.cp2y = controlPoints.next.y;
      prev = point;
    }
  }
  if (options.capBezierPoints) {
    capBezierPoints(points, area);
  }
}

/**
 * Note: typedefs are auto-exported, so use a made-up `dom` namespace where
 * necessary to avoid duplicates with `export * from './helpers`; see
 * https://github.com/microsoft/TypeScript/issues/46011
 * @typedef { import('../core/core.controller.js').default } dom.Chart
 * @typedef { import('../../types').ChartEvent } ChartEvent
 */ /**
    * @private
    */
function _isDomSupported() {
  return typeof window !== 'undefined' && typeof document !== 'undefined';
}
/**
 * @private
 */
function _getParentNode(domNode) {
  let parent = domNode.parentNode;
  if (parent && parent.toString() === '[object ShadowRoot]') {
    parent = parent.host;
  }
  return parent;
}
/**
 * convert max-width/max-height values that may be percentages into a number
 * @private
 */
function parseMaxStyle(styleValue, node, parentProperty) {
  let valueInPixels;
  if (typeof styleValue === 'string') {
    valueInPixels = parseInt(styleValue, 10);
    if (styleValue.indexOf('%') !== -1) {
      // percentage * size in dimension
      valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];
    }
  } else {
    valueInPixels = styleValue;
  }
  return valueInPixels;
}
const getComputedStyle = element => element.ownerDocument.defaultView.getComputedStyle(element, null);
function getStyle(el, property) {
  return getComputedStyle(el).getPropertyValue(property);
}
const positions = ['top', 'right', 'bottom', 'left'];
function getPositionedStyle(styles, style, suffix) {
  const result = {};
  suffix = suffix ? '-' + suffix : '';
  for (let i = 0; i < 4; i++) {
    const pos = positions[i];
    result[pos] = parseFloat(styles[style + '-' + pos + suffix]) || 0;
  }
  result.width = result.left + result.right;
  result.height = result.top + result.bottom;
  return result;
}
const useOffsetPos = (x, y, target) => (x > 0 || y > 0) && (!target || !target.shadowRoot);
/**
 * @param e
 * @param canvas
 * @returns Canvas position
 */
function getCanvasPosition(e, canvas) {
  const touches = e.touches;
  const source = touches && touches.length ? touches[0] : e;
  const {
    offsetX,
    offsetY
  } = source;
  let box = false;
  let x, y;
  if (useOffsetPos(offsetX, offsetY, e.target)) {
    x = offsetX;
    y = offsetY;
  } else {
    const rect = canvas.getBoundingClientRect();
    x = source.clientX - rect.left;
    y = source.clientY - rect.top;
    box = true;
  }
  return {
    x,
    y,
    box
  };
}
/**
 * Gets an event's x, y coordinates, relative to the chart area
 * @param event
 * @param chart
 * @returns x and y coordinates of the event
 */
function getRelativePosition(event, chart) {
  if ('native' in event) {
    return event;
  }
  const {
    canvas,
    currentDevicePixelRatio
  } = chart;
  const style = getComputedStyle(canvas);
  const borderBox = style.boxSizing === 'border-box';
  const paddings = getPositionedStyle(style, 'padding');
  const borders = getPositionedStyle(style, 'border', 'width');
  const {
    x,
    y,
    box
  } = getCanvasPosition(event, canvas);
  const xOffset = paddings.left + (box && borders.left);
  const yOffset = paddings.top + (box && borders.top);
  let {
    width,
    height
  } = chart;
  if (borderBox) {
    width -= paddings.width + borders.width;
    height -= paddings.height + borders.height;
  }
  return {
    x: Math.round((x - xOffset) / width * canvas.width / currentDevicePixelRatio),
    y: Math.round((y - yOffset) / height * canvas.height / currentDevicePixelRatio)
  };
}
function getContainerSize(canvas, width, height) {
  let maxWidth, maxHeight;
  if (width === undefined || height === undefined) {
    const container = canvas && _getParentNode(canvas);
    if (!container) {
      width = canvas.clientWidth;
      height = canvas.clientHeight;
    } else {
      const rect = container.getBoundingClientRect(); // this is the border box of the container
      const containerStyle = getComputedStyle(container);
      const containerBorder = getPositionedStyle(containerStyle, 'border', 'width');
      const containerPadding = getPositionedStyle(containerStyle, 'padding');
      width = rect.width - containerPadding.width - containerBorder.width;
      height = rect.height - containerPadding.height - containerBorder.height;
      maxWidth = parseMaxStyle(containerStyle.maxWidth, container, 'clientWidth');
      maxHeight = parseMaxStyle(containerStyle.maxHeight, container, 'clientHeight');
    }
  }
  return {
    width,
    height,
    maxWidth: maxWidth || INFINITY,
    maxHeight: maxHeight || INFINITY
  };
}
const round1 = v => Math.round(v * 10) / 10;
// eslint-disable-next-line complexity
function getMaximumSize(canvas, bbWidth, bbHeight, aspectRatio) {
  const style = getComputedStyle(canvas);
  const margins = getPositionedStyle(style, 'margin');
  const maxWidth = parseMaxStyle(style.maxWidth, canvas, 'clientWidth') || INFINITY;
  const maxHeight = parseMaxStyle(style.maxHeight, canvas, 'clientHeight') || INFINITY;
  const containerSize = getContainerSize(canvas, bbWidth, bbHeight);
  let {
    width,
    height
  } = containerSize;
  if (style.boxSizing === 'content-box') {
    const borders = getPositionedStyle(style, 'border', 'width');
    const paddings = getPositionedStyle(style, 'padding');
    width -= paddings.width + borders.width;
    height -= paddings.height + borders.height;
  }
  width = Math.max(0, width - margins.width);
  height = Math.max(0, aspectRatio ? width / aspectRatio : height - margins.height);
  width = round1(Math.min(width, maxWidth, containerSize.maxWidth));
  height = round1(Math.min(height, maxHeight, containerSize.maxHeight));
  if (width && !height) {
    // https://github.com/chartjs/Chart.js/issues/4659
    // If the canvas has width, but no height, default to aspectRatio of 2 (canvas default)
    height = round1(width / 2);
  }
  const maintainHeight = bbWidth !== undefined || bbHeight !== undefined;
  if (maintainHeight && aspectRatio && containerSize.height && height > containerSize.height) {
    height = containerSize.height;
    width = round1(Math.floor(height * aspectRatio));
  }
  return {
    width,
    height
  };
}
/**
 * @param chart
 * @param forceRatio
 * @param forceStyle
 * @returns True if the canvas context size or transformation has changed.
 */
function retinaScale(chart, forceRatio, forceStyle) {
  const pixelRatio = forceRatio || 1;
  const deviceHeight = Math.floor(chart.height * pixelRatio);
  const deviceWidth = Math.floor(chart.width * pixelRatio);
  chart.height = Math.floor(chart.height);
  chart.width = Math.floor(chart.width);
  const canvas = chart.canvas;
  // If no style has been set on the canvas, the render size is used as display size,
  // making the chart visually bigger, so let's enforce it to the "correct" values.
  // See https://github.com/chartjs/Chart.js/issues/3575
  if (canvas.style && (forceStyle || !canvas.style.height && !canvas.style.width)) {
    canvas.style.height = `${chart.height}px`;
    canvas.style.width = `${chart.width}px`;
  }
  if (chart.currentDevicePixelRatio !== pixelRatio || canvas.height !== deviceHeight || canvas.width !== deviceWidth) {
    chart.currentDevicePixelRatio = pixelRatio;
    canvas.height = deviceHeight;
    canvas.width = deviceWidth;
    chart.ctx.setTransform(pixelRatio, 0, 0, pixelRatio, 0, 0);
    return true;
  }
  return false;
}
/**
 * Detects support for options object argument in addEventListener.
 * https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Safely_detecting_option_support
 * @private
 */
const supportsEventListenerOptions = function () {
  let passiveSupported = false;
  try {
    const options = {
      get passive() {
        passiveSupported = true;
        return false;
      }
    };
    if (_isDomSupported()) {
      window.addEventListener('test', null, options);
      window.removeEventListener('test', null, options);
    }
  } catch (e) {
    // continue regardless of error
  }
  return passiveSupported;
}();
/**
 * The "used" size is the final value of a dimension property after all calculations have
 * been performed. This method uses the computed style of `element` but returns undefined
 * if the computed style is not expressed in pixels. That can happen in some cases where
 * `element` has a size relative to its parent and this last one is not yet displayed,
 * for example because of `display: none` on a parent node.
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/used_value
 * @returns Size in pixels or undefined if unknown.
 */
function readUsedSize(element, property) {
  const value = getStyle(element, property);
  const matches = value && value.match(/^(\d+)(\.\d+)?px$/);
  return matches ? +matches[1] : undefined;
}

/**
 * @private
 */
function _pointInLine(p1, p2, t, mode) {
  return {
    x: p1.x + t * (p2.x - p1.x),
    y: p1.y + t * (p2.y - p1.y)
  };
}
/**
 * @private
 */
function _steppedInterpolation(p1, p2, t, mode) {
  return {
    x: p1.x + t * (p2.x - p1.x),
    y: mode === 'middle' ? t < 0.5 ? p1.y : p2.y : mode === 'after' ? t < 1 ? p1.y : p2.y : t > 0 ? p2.y : p1.y
  };
}
/**
 * @private
 */
function _bezierInterpolation(p1, p2, t, mode) {
  const cp1 = {
    x: p1.cp2x,
    y: p1.cp2y
  };
  const cp2 = {
    x: p2.cp1x,
    y: p2.cp1y
  };
  const a = _pointInLine(p1, cp1, t);
  const b = _pointInLine(cp1, cp2, t);
  const c = _pointInLine(cp2, p2, t);
  const d = _pointInLine(a, b, t);
  const e = _pointInLine(b, c, t);
  return _pointInLine(d, e, t);
}
const getRightToLeftAdapter = function (rectX, width) {
  return {
    x(x) {
      return rectX + rectX + width - x;
    },
    setWidth(w) {
      width = w;
    },
    textAlign(align) {
      if (align === 'center') {
        return align;
      }
      return align === 'right' ? 'left' : 'right';
    },
    xPlus(x, value) {
      return x - value;
    },
    leftForLtr(x, itemWidth) {
      return x - itemWidth;
    }
  };
};
const getLeftToRightAdapter = function () {
  return {
    x(x) {
      return x;
    },
    setWidth(w) {},
    textAlign(align) {
      return align;
    },
    xPlus(x, value) {
      return x + value;
    },
    leftForLtr(x, _itemWidth) {
      return x;
    }
  };
};
function getRtlAdapter(rtl, rectX, width) {
  return rtl ? getRightToLeftAdapter(rectX, width) : getLeftToRightAdapter();
}
function overrideTextDirection(ctx, direction) {
  let style, original;
  if (direction === 'ltr' || direction === 'rtl') {
    style = ctx.canvas.style;
    original = [style.getPropertyValue('direction'), style.getPropertyPriority('direction')];
    style.setProperty('direction', direction, 'important');
    ctx.prevTextDirection = original;
  }
}
function restoreTextDirection(ctx, original) {
  if (original !== undefined) {
    delete ctx.prevTextDirection;
    ctx.canvas.style.setProperty('direction', original[0], original[1]);
  }
}
function propertyFn(property) {
  if (property === 'angle') {
    return {
      between: _angleBetween,
      compare: _angleDiff,
      normalize: _normalizeAngle
    };
  }
  return {
    between: _isBetween,
    compare: (a, b) => a - b,
    normalize: x => x
  };
}
function normalizeSegment({
  start,
  end,
  count,
  loop,
  style
}) {
  return {
    start: start % count,
    end: end % count,
    loop: loop && (end - start + 1) % count === 0,
    style
  };
}
function getSegment(segment, points, bounds) {
  const {
    property,
    start: startBound,
    end: endBound
  } = bounds;
  const {
    between,
    normalize
  } = propertyFn(property);
  const count = points.length;
  let {
    start,
    end,
    loop
  } = segment;
  let i, ilen;
  if (loop) {
    start += count;
    end += count;
    for (i = 0, ilen = count; i < ilen; ++i) {
      if (!between(normalize(points[start % count][property]), startBound, endBound)) {
        break;
      }
      start--;
      end--;
    }
    start %= count;
    end %= count;
  }
  if (end < start) {
    end += count;
  }
  return {
    start,
    end,
    loop,
    style: segment.style
  };
}
function _boundSegment(segment, points, bounds) {
  if (!bounds) {
    return [segment];
  }
  const {
    property,
    start: startBound,
    end: endBound
  } = bounds;
  const count = points.length;
  const {
    compare,
    between,
    normalize
  } = propertyFn(property);
  const {
    start,
    end,
    loop,
    style
  } = getSegment(segment, points, bounds);
  const result = [];
  let inside = false;
  let subStart = null;
  let value, point, prevValue;
  const startIsBefore = () => between(startBound, prevValue, value) && compare(startBound, prevValue) !== 0;
  const endIsBefore = () => compare(endBound, value) === 0 || between(endBound, prevValue, value);
  const shouldStart = () => inside || startIsBefore();
  const shouldStop = () => !inside || endIsBefore();
  for (let i = start, prev = start; i <= end; ++i) {
    point = points[i % count];
    if (point.skip) {
      continue;
    }
    value = normalize(point[property]);
    if (value === prevValue) {
      continue;
    }
    inside = between(value, startBound, endBound);
    if (subStart === null && shouldStart()) {
      subStart = compare(value, startBound) === 0 ? i : prev;
    }
    if (subStart !== null && shouldStop()) {
      result.push(normalizeSegment({
        start: subStart,
        end: i,
        loop,
        count,
        style
      }));
      subStart = null;
    }
    prev = i;
    prevValue = value;
  }
  if (subStart !== null) {
    result.push(normalizeSegment({
      start: subStart,
      end,
      loop,
      count,
      style
    }));
  }
  return result;
}
function _boundSegments(line, bounds) {
  const result = [];
  const segments = line.segments;
  for (let i = 0; i < segments.length; i++) {
    const sub = _boundSegment(segments[i], line.points, bounds);
    if (sub.length) {
      result.push(...sub);
    }
  }
  return result;
}
function findStartAndEnd(points, count, loop, spanGaps) {
  let start = 0;
  let end = count - 1;
  if (loop && !spanGaps) {
    while (start < count && !points[start].skip) {
      start++;
    }
  }
  while (start < count && points[start].skip) {
    start++;
  }
  start %= count;
  if (loop) {
    end += start;
  }
  while (end > start && points[end % count].skip) {
    end--;
  }
  end %= count;
  return {
    start,
    end
  };
}
function solidSegments(points, start, max, loop) {
  const count = points.length;
  const result = [];
  let last = start;
  let prev = points[start];
  let end;
  for (end = start + 1; end <= max; ++end) {
    const cur = points[end % count];
    if (cur.skip || cur.stop) {
      if (!prev.skip) {
        loop = false;
        result.push({
          start: start % count,
          end: (end - 1) % count,
          loop
        });
        start = last = cur.stop ? end : null;
      }
    } else {
      last = end;
      if (prev.skip) {
        start = end;
      }
    }
    prev = cur;
  }
  if (last !== null) {
    result.push({
      start: start % count,
      end: last % count,
      loop
    });
  }
  return result;
}
function _computeSegments(line, segmentOptions) {
  const points = line.points;
  const spanGaps = line.options.spanGaps;
  const count = points.length;
  if (!count) {
    return [];
  }
  const loop = !!line._loop;
  const {
    start,
    end
  } = findStartAndEnd(points, count, loop, spanGaps);
  if (spanGaps === true) {
    return splitByStyles(line, [{
      start,
      end,
      loop
    }], points, segmentOptions);
  }
  const max = end < start ? end + count : end;
  const completeLoop = !!line._fullLoop && start === 0 && end === count - 1;
  return splitByStyles(line, solidSegments(points, start, max, completeLoop), points, segmentOptions);
}
function splitByStyles(line, segments, points, segmentOptions) {
  if (!segmentOptions || !segmentOptions.setContext || !points) {
    return segments;
  }
  return doSplitByStyles(line, segments, points, segmentOptions);
}
function doSplitByStyles(line, segments, points, segmentOptions) {
  const chartContext = line._chart.getContext();
  const baseStyle = readStyle(line.options);
  const {
    _datasetIndex: datasetIndex,
    options: {
      spanGaps
    }
  } = line;
  const count = points.length;
  const result = [];
  let prevStyle = baseStyle;
  let start = segments[0].start;
  let i = start;
  function addStyle(s, e, l, st) {
    const dir = spanGaps ? -1 : 1;
    if (s === e) {
      return;
    }
    s += count;
    while (points[s % count].skip) {
      s -= dir;
    }
    while (points[e % count].skip) {
      e += dir;
    }
    if (s % count !== e % count) {
      result.push({
        start: s % count,
        end: e % count,
        loop: l,
        style: st
      });
      prevStyle = st;
      start = e % count;
    }
  }
  for (const segment of segments) {
    start = spanGaps ? start : segment.start;
    let prev = points[start % count];
    let style;
    for (i = start + 1; i <= segment.end; i++) {
      const pt = points[i % count];
      style = readStyle(segmentOptions.setContext(createContext(chartContext, {
        type: 'segment',
        p0: prev,
        p1: pt,
        p0DataIndex: (i - 1) % count,
        p1DataIndex: i % count,
        datasetIndex
      })));
      if (styleChanged(style, prevStyle)) {
        addStyle(start, i - 1, segment.loop, prevStyle);
      }
      prev = pt;
      prevStyle = style;
    }
    if (start < i - 1) {
      addStyle(start, i - 1, segment.loop, prevStyle);
    }
  }
  return result;
}
function readStyle(options) {
  return {
    backgroundColor: options.backgroundColor,
    borderCapStyle: options.borderCapStyle,
    borderDash: options.borderDash,
    borderDashOffset: options.borderDashOffset,
    borderJoinStyle: options.borderJoinStyle,
    borderWidth: options.borderWidth,
    borderColor: options.borderColor
  };
}
function styleChanged(style, prevStyle) {
  if (!prevStyle) {
    return false;
  }
  const cache = [];
  const replacer = function (key, value) {
    if (!isPatternOrGradient(value)) {
      return value;
    }
    if (!cache.includes(value)) {
      cache.push(value);
    }
    return cache.indexOf(value);
  };
  return JSON.stringify(style, replacer) !== JSON.stringify(prevStyle, replacer);
}


/***/ })

}]);
//# sourceMappingURL=65.js.map