"use strict";
(self["webpackChunkproject"] = self["webpackChunkproject"] || []).push([[247],{

/***/ 8792:
/*!*****************************************************************************!*\
  !*** ./src/app/appointment/documents/components/layout/layout.component.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DocumentsLayoutComponent: () => (/* binding */ DocumentsLayoutComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! rxjs */ 2714);
/* harmony import */ var src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/appointments/models/appointment */ 8723);
/* harmony import */ var src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/documents/models/document */ 735);
/* harmony import */ var src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/ui/pipes/order-by.pipe */ 9093);
/* harmony import */ var src_app_main_models_navigation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/main/models/navigation */ 821);
/* harmony import */ var src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/shared/contact-information/models/contact-information */ 904);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/shared/ui/services/ui.service */ 345);
/* harmony import */ var src_app_shared_documents_services_document_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! src/app/shared/documents/services/document.service */ 3040);
/* harmony import */ var src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! src/app/shared/navigation/services/device-route.service */ 2405);
/* harmony import */ var src_app_appointment_services_appointment_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! src/app/appointment/services/appointment.service */ 7427);
/* harmony import */ var src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! src/app/shared/appointments/services/appointment.service */ 8036);
/* harmony import */ var _shared_documents_components_appointment_document_appointment_document_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../../shared/documents/components/appointment-document/appointment-document.component */ 6488);
/* harmony import */ var _shared_documents_components_consent_consent_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../../shared/documents/components/consent/consent.component */ 3528);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/common */ 6216);

/* Models */


/* Pipes */













const _c0 = ["componentElm"];
function DocumentsLayoutComponent_ng_container_2_appointment_document_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "appointment-document", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("changed", function DocumentsLayoutComponent_ng_container_2_appointment_document_1_Template_appointment_document_changed_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵrestoreView"](_r1);
      const document_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]().$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵresetView"](ctx_r2.documentChanged(document_r2));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const document_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]().$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("appointmentContent", ctx_r2.content)("document", document_r2);
  }
}
function DocumentsLayoutComponent_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerStart"](0);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](1, DocumentsLayoutComponent_ng_container_2_appointment_document_1_Template, 1, 2, "appointment-document", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementContainerEnd"]();
  }
  if (rf & 2) {
    const document_r2 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", document_r2.active);
  }
}
let DocumentsLayoutComponent = /*#__PURE__*/(() => {
  class DocumentsLayoutComponent {
    constructor(uiService, documentService, deviceRouteService, localAppointmentService, appointmentService, orderByPipe) {
      this.uiService = uiService;
      this.documentService = documentService;
      this.deviceRouteService = deviceRouteService;
      this.localAppointmentService = localAppointmentService;
      this.appointmentService = appointmentService;
      this.orderByPipe = orderByPipe;
      // #endregion
      // #region Documents
      this.retrievingDocuments = false;
      this.activeDocumentIndex = 0;
      this.displayDocuments = [];
      // #endregion
      // #region Consent
      this.consenting = false;
      this.consenters = new rxjs__WEBPACK_IMPORTED_MODULE_13__.Subject();
      // #endregion
      // #region Navigation
      this.backLabel = "Previous Document";
      this.forwardLabel = "Next Document";
      this.back = new rxjs__WEBPACK_IMPORTED_MODULE_13__.Subject();
      this.complete = new rxjs__WEBPACK_IMPORTED_MODULE_13__.Subject();
      this.canGoBack = false;
      this.canGoForward = false;
    }
    generatePrice() {
      if (this.appointment?.price) {
        return {
          details: this.appointment.price.details,
          customItems: this.appointment.price.customItems,
          price: this.appointment.price.finalPrice
        };
      }
      return undefined;
    }
    generatePayments() {
      const payments = [];
      if (this.appointment?.paymentSetting != null) {
        const details = this.orderByPipe.transform(this.appointment.paymentSetting.details, "priority", false);
        details.forEach(detail => {
          const payment = {
            description: detail.name,
            amount: detail.amount
          };
          payments.push(payment);
        });
      }
      return payments;
    }
    generateContent() {
      if (this.appointment != null) {
        const content = {
          appointmentId: this.appointment.id,
          created_Utc: this.appointment.scheduled_Utc,
          lastUpdated_Utc: new Date(),
          scheduled_Utc: this.appointment.scheduled_Utc,
          property: this.appointment.property,
          jobId: this.appointment.jobId?.toString(),
          job: this.appointment.job,
          consultant: this.appointment.assignedTo,
          customer: this.appointment.customer,
          price: this.generatePrice(),
          documents: this.displayDocuments,
          payments: this.generatePayments(),
          recipient: undefined,
          completed: false
        };
        this.content = content;
      }
    }
    documentChanged(document) {
      this.appointment?.changed$.next();
      this.updateSigners();
      this.setNavigation();
    }
    updateSigners() {
      window.clearTimeout(this.signerDebounce);
      this.signerDebounce = window.setTimeout(() => {
        const signers = [];
        for (var i = 0, len = this.displayDocuments.length; i < len; i++) {
          const document = this.displayDocuments[i];
          for (var j = 0, jlen = document.signers.length; j < jlen; j++) {
            const signer = document.signers[j];
            const existingSigner = signers.find(x => x.fullName == signer.fullName);
            if (existingSigner == null) {
              signers.push(signer);
            } else {
              if (existingSigner.initials_B64 == null && signer.initials_B64 == null) {
                existingSigner.initials_B64 = signer.initials_B64;
              }
              if (existingSigner.signature_B64 == null && signer.signature_B64 == null) {
                existingSigner.signature_B64 = signer.signature_B64;
              }
            }
          }
          document.signers = signers;
        }
      }, 500);
    }
    generateSigners(document) {
      const signers = [];
      let customerAdded = false;
      let consultantAdded = false;
      if (document.mapping != null) {
        for (var i = 0, len = document.mapping.pages.length; i < len; i++) {
          const page = document.mapping.pages[i];
          for (var j = 0, jlen = page.fields.length; j < jlen; j++) {
            const field = page.fields[j];
            if ((field.id?.includes("initial.customer") || field.id?.includes("signature.customer")) && !customerAdded) {
              if (this.appointment?.customer != null) {
                const fullName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
                const email = this.appointment.customer.contactInformation.find(x => x.type == src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_4__.ContactInformationType.Email);
                const phone = this.appointment.customer.contactInformation.find(x => x.type == src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_4__.ContactInformationType.CellPhone);
                const signer = new src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSigner(fullName, phone?.value, email?.value, src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSignerType.Customer);
                signers.push(signer);
                customerAdded = true;
              }
            }
            if ((field.id?.includes("initial.consultant") || field.id?.includes("signature.consultant")) && !consultantAdded) {
              if (this.appointment?.assignedTo != null) {
                const fullName = `${this.appointment.assignedTo.firstName} ${this.appointment.assignedTo.lastName}`;
                const email = this.appointment.assignedTo.emailAddress;
                const phone = this.appointment.assignedTo.phone;
                const signer = new src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSigner(fullName, phone, email, src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSignerType.Consultant);
                signers.push(signer);
                consultantAdded = true;
              }
            }
          }
        }
      }
      if (document.content != null) {
        if ((document.content.includes("initial.customer") || document.content.includes("signature.customer")) && !customerAdded) {
          if (this.appointment?.customer != null) {
            const fullName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
            const email = this.appointment.customer.contactInformation.find(x => x.type == src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_4__.ContactInformationType.Email);
            const phone = this.appointment.customer.contactInformation.find(x => x.type == src_app_shared_contact_information_models_contact_information__WEBPACK_IMPORTED_MODULE_4__.ContactInformationType.CellPhone);
            const signer = new src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSigner(fullName, phone?.value, email?.value, src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSignerType.Customer);
            signers.push(signer);
            customerAdded = true;
          }
        }
        if ((document.content.includes("initial.consultant") || document.content.includes("signature.consultant")) && !consultantAdded) {
          if (this.appointment?.assignedTo != null) {
            const fullName = `${this.appointment.assignedTo.firstName} ${this.appointment.assignedTo.lastName}`;
            const email = this.appointment.assignedTo.emailAddress;
            const phone = this.appointment.assignedTo.phone;
            const signer = new src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSigner(fullName, phone, email, src_app_shared_documents_models_document__WEBPACK_IMPORTED_MODULE_1__.DocumentSignerType.Consultant);
            signers.push(signer);
            consultantAdded = true;
          }
        }
      }
      return signers;
    }
    initDocuments() {
      if (this.appointment != null) {
        let documents = [];
        for (var i = 0, len = this.appointment.documents.length; i < len; i++) {
          const document = this.appointment.documents[i];
          document.active = false;
          document.executedDocument = undefined;
          document.executedDocument_B64 = undefined;
          document.executedHash = undefined;
          // document.generatedContent = undefined;
          if (document.customerFacing) {
            if (document.executedDocument_B64 == null && document.signers.length == 0) {
              document.signers = this.generateSigners(document);
            }
            documents.push(document);
          }
        }
        documents = this.orderByPipe.transform(documents, "displayOrder", false);
        this.displayDocuments = documents;
        this.setActiveDocument(0);
        this.verifyConsent();
      }
    }
    setActiveDocument(index) {
      const document = this.displayDocuments[index];
      this.displayDocuments.forEach(document => {
        document.active = false;
      });
      if (document != null) {
        document.active = true;
      }
      this.activeDocument = document;
      this.activeDocumentIndex = index;
      setTimeout(() => {
        this.setNavigation();
      }, 500);
    }
    finalizeConsent(consenters) {
      if (consenters.length > 0) {
        this.appointment?.documents.forEach(document => {
          document.signers = consenters;
        });
      }
      this.consenting = false;
      this.appointment?.changed$.next();
    }
    verifyConsent() {
      const consenters = [];
      for (var i = 0, len = this.displayDocuments.length; i < len; i++) {
        const document = this.displayDocuments[i];
        for (var j = 0, jlen = document.signers.length; j < jlen; j++) {
          const signer = document.signers[j];
          if (signer.consent == null) {
            const existingConsenter = consenters.find(x => x.fullName == signer.fullName);
            if (existingConsenter == null) {
              consenters.push(signer);
            }
          }
        }
      }
      this.consenters.next(consenters);
      if (consenters.length > 0) {
        this.consenting = true;
      } else {
        this.consenting = false;
      }
    }
    setNavigation() {
      window.clearTimeout(this.navigationDebounce);
      this.navigationDebounce = window.setTimeout(() => {
        const missingDocuments = null; // this.displayDocuments.find(x => x.executedHash == null);
        const nextDocument = this.displayDocuments[this.activeDocumentIndex + 1];
        if (nextDocument != null) {
          this.forwardLabel = "Next Document";
          this.canGoForward = true;
        } else if (missingDocuments == null) {
          this.forwardLabel = "Finish & Leave Appointment";
          this.canGoForward = true;
        } else {
          this.canGoForward = false;
        }
        if (this.activeDocument != null) {
          const previousDocument = this.displayDocuments[this.activeDocumentIndex - 1];
          if (previousDocument != null) {
            this.canGoBack = true;
          } else {
            this.canGoBack = false;
          }
        }
      }, 150);
    }
    goBack() {
      const previousDocument = this.displayDocuments[this.activeDocumentIndex - 1];
      if (previousDocument != null) {
        this.setActiveDocument(this.activeDocumentIndex - 1);
      } else {
        this.back.next();
      }
    }
    goForward() {
      const nextDocument = this.displayDocuments[this.activeDocumentIndex + 1];
      if (nextDocument != null) {
        this.setActiveDocument(this.activeDocumentIndex + 1);
        this.canGoForward = false;
      } else {
        this.uiService.prompt("Ready to Leave the Appointment?", "", "Yes", "No, Go Back").subscribe({
          next: confirmed => {
            if (confirmed) {
              if (this.appointment != null) {
                this.appointment.dispositionStatus = undefined;
                this.appointment.status = src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__.AppointmentStatus.PendingSubmission;
                this.appointment.changed$.next();
              }
              this.deviceRouteService.viewRouteByType(src_app_main_models_navigation__WEBPACK_IMPORTED_MODULE_3__.MainRouteType.Dashboard, [], true);
            }
          }
        });
      }
    }
    init() {
      this.generateContent();
      this.initDocuments();
    }
    // #endregion
    ngAfterViewInit() {
      setTimeout(() => {
        this.init();
        setTimeout(() => {
          if (this.route != null) {
            this.route.initialized.next();
          }
        }, 32);
      }, 16);
    }
    ngOnDestroy() {}
    static #_ = (() => this.ɵfac = function DocumentsLayoutComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DocumentsLayoutComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_5__.UiService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_documents_services_document_service__WEBPACK_IMPORTED_MODULE_6__.DocumentService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_navigation_services_device_route_service__WEBPACK_IMPORTED_MODULE_7__.DeviceRouteService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_appointment_services_appointment_service__WEBPACK_IMPORTED_MODULE_8__.LocalAppointmentService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_9__.AppointmentService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByPipe));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdefineComponent"]({
      type: DocumentsLayoutComponent,
      selectors: [["ng-component"]],
      viewQuery: function DocumentsLayoutComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        appointment: "appointment",
        route: "route"
      },
      outputs: {
        back: "back",
        complete: "complete"
      },
      standalone: false,
      features: [_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵProvidersFeature"]([src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByPipe])],
      decls: 17,
      vars: 7,
      consts: [["id", "documentsLayout"], [1, "documents"], [4, "ngFor", "ngForOf"], ["id", "consent"], [1, "bg"], [3, "close", "consenters"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], [3, "appointmentContent", "document", "changed", 4, "ngIf"], [3, "changed", "appointmentContent", "document"]],
      template: function DocumentsLayoutComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "main", 0)(1, "div", 1);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](2, DocumentsLayoutComponent_ng_container_2_Template, 2, 1, "ng-container", 2);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](3, "aside", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](4, "div", 4);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](5, "signing-consent", 5);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("close", function DocumentsLayoutComponent_Template_signing_consent_close_5_listener($event) {
            return ctx.finalizeConsent($event);
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](6, "nav", 6)(7, "div", 7)(8, "div", 8)(9, "button", 9);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("click", function DocumentsLayoutComponent_Template_button_click_9_listener() {
            return ctx.goBack();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](10, "i", 10);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](11, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](12);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](13, "button", 11);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵlistener"]("click", function DocumentsLayoutComponent_Template_button_click_13_listener() {
            return ctx.goForward();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](14, "i", 12);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](15, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtext"](16);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]()()()()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngForOf", ctx.displayDocuments);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵclassProp"]("active", ctx.consenting);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("consenters", ctx.consenters);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](7);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](ctx.backLabel);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("disabled", !ctx.canGoForward);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](3);
          _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtextInterpolate"](ctx.forwardLabel);
        }
      },
      dependencies: [_shared_documents_components_appointment_document_appointment_document_component__WEBPACK_IMPORTED_MODULE_10__.AppointmentDocumentComponent, _shared_documents_components_consent_consent_component__WEBPACK_IMPORTED_MODULE_11__.ConsentComponent, _angular_common__WEBPACK_IMPORTED_MODULE_14__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_14__.NgIf],
      styles: ["@keyframes _ngcontent-%COMP%_documentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n#documentsLayout[_ngcontent-%COMP%] {\n  z-index: 0;\n  font-size: 0;\n}\n#documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]   appointment-document[_ngcontent-%COMP%]     .document {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: calc(var(--systemOffset-bottom) + 7vw);\n  border: 0.2vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  display: block;\n  overflow-x: hidden;\n}\n\n#consent[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#consent[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: var(--sideNav-layer);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  transition: opacity 0.2s linear;\n}\n#consent[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 2);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  transition: opacity 0.2s linear;\n}\n#consent.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#consent.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#consent.active[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  opacity: 1;\n  transition: opacity 0.25s 0.25s;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  transition: opacity 0.25s linear;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return DocumentsLayoutComponent;
})();

/***/ }),

/***/ 1247:
/*!***********************************************************!*\
  !*** ./src/app/appointment/documents/documents.module.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DocumentsModule: () => (/* binding */ DocumentsModule)
/* harmony export */ });
/* harmony import */ var _angular_elements__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/elements */ 3440);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 8335);
/* harmony import */ var _components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/layout/layout.component */ 8792);
/* harmony import */ var src_app_shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/ui/ui.module */ 663);
/* harmony import */ var src_app_shared_documents_documents_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/documents/documents.module */ 3749);
/* harmony import */ var src_app_shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/navigation/services/internal-route.service */ 8858);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 4380);




/* Components */

/* Shared Modules */


/* Services */


let DocumentsModule = /*#__PURE__*/(() => {
  class DocumentsModule {
    constructor(injector) {
      this.injector = injector;
      this.ngDoBootstrap();
    }
    ngDoBootstrap() {
      const el = (0,_angular_elements__WEBPACK_IMPORTED_MODULE_4__.createCustomElement)(_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.DocumentsLayoutComponent, {
        injector: this.injector
      });
      customElements.define('appointment-documents', el);
    }
    static #_ = (() => this.ɵfac = function DocumentsModule_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || DocumentsModule)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injector));
    })();
    static #_2 = (() => this.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineNgModule"]({
      type: DocumentsModule
    }))();
    static #_3 = (() => this.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineInjector"]({
      providers: [src_app_shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_3__.InternalRouteService, (0,_angular_common_http__WEBPACK_IMPORTED_MODULE_6__.provideHttpClient)((0,_angular_common_http__WEBPACK_IMPORTED_MODULE_6__.withInterceptorsFromDi)())],
      imports: [src_app_shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_1__.UiModule, src_app_shared_documents_documents_module__WEBPACK_IMPORTED_MODULE_2__.SharedDocumentsModule, _angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.ReactiveFormsModule]
    }))();
  }
  return DocumentsModule;
})();
(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵsetNgModuleScope"](DocumentsModule, {
    declarations: [_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.DocumentsLayoutComponent],
    imports: [src_app_shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_1__.UiModule, src_app_shared_documents_documents_module__WEBPACK_IMPORTED_MODULE_2__.SharedDocumentsModule, _angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.ReactiveFormsModule]
  });
})();

/***/ })

}]);
//# sourceMappingURL=247.js.map