"use strict";
(self["webpackChunkproject"] = self["webpackChunkproject"] || []).push([[643],{

/***/ 6643:
/*!*****************************************************!*\
  !*** ./src/app/appointments/appointments.module.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentsModule: () => (/* binding */ AppointmentsModule)
/* harmony export */ });
/* harmony import */ var _angular_elements__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/elements */ 3440);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ 8335);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common/http */ 8143);
/* harmony import */ var _components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/layout/layout.component */ 9996);
/* harmony import */ var _components_all_all_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/all/all.component */ 54);
/* harmony import */ var _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../shared/ui/ui.module */ 663);
/* harmony import */ var _services_appointments_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./services/appointments.service */ 1653);
/* harmony import */ var _shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../shared/navigation/services/internal-route.service */ 8858);
/* harmony import */ var _shared_appointments_appointments_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../shared/appointments/appointments.module */ 7215);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 4380);




/* Components */


/* Modules */

/* Services */




let AppointmentsModule = /*#__PURE__*/(() => {
  class AppointmentsModule {
    constructor(injector) {
      this.injector = injector;
      this.ngDoBootstrap();
    }
    ngDoBootstrap() {
      const el = (0,_angular_elements__WEBPACK_IMPORTED_MODULE_6__.createCustomElement)(_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.AppointmentsLayoutComponent, {
        injector: this.injector
      });
      customElements.define('global-appointments', el);
    }
    static #_ = (() => this.ɵfac = function AppointmentsModule_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || AppointmentsModule)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_7__.Injector));
    })();
    static #_2 = (() => this.ɵmod = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineNgModule"]({
      type: AppointmentsModule
    }))();
    static #_3 = (() => this.ɵinj = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineInjector"]({
      providers: [_services_appointments_service__WEBPACK_IMPORTED_MODULE_3__.AppointmentsService, _shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_4__.InternalRouteService, (0,_angular_common_http__WEBPACK_IMPORTED_MODULE_8__.provideHttpClient)((0,_angular_common_http__WEBPACK_IMPORTED_MODULE_8__.withInterceptorsFromDi)())],
      imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_2__.UiModule, _shared_appointments_appointments_module__WEBPACK_IMPORTED_MODULE_5__.SharedAppointmentsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.ReactiveFormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.FormsModule]
    }))();
  }
  return AppointmentsModule;
})();
(function () {
  (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵsetNgModuleScope"](AppointmentsModule, {
    declarations: [_components_layout_layout_component__WEBPACK_IMPORTED_MODULE_0__.AppointmentsLayoutComponent, _components_all_all_component__WEBPACK_IMPORTED_MODULE_1__.AllComponent],
    imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, _shared_ui_ui_module__WEBPACK_IMPORTED_MODULE_2__.UiModule, _shared_appointments_appointments_module__WEBPACK_IMPORTED_MODULE_5__.SharedAppointmentsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.ReactiveFormsModule, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.FormsModule]
  });
})();

/***/ }),

/***/ 54:
/*!**************************************************************!*\
  !*** ./src/app/appointments/components/all/all.component.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AllComponent: () => (/* binding */ AllComponent)
/* harmony export */ });
/* harmony import */ var src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/appointments/models/appointment */ 8723);
/* harmony import */ var src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/helpers/models/searching */ 3945);
/* harmony import */ var src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/ui/pipes/order-by.pipe */ 9093);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/router */ 4947);
/* harmony import */ var _services_appointments_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/appointments.service */ 1653);
/* harmony import */ var src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/shared/data/services/db.service */ 1235);
/* harmony import */ var src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/shared/ui/services/ui.service */ 345);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _shared_appointments_components_appointment_summary_appointment_summary_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../shared/appointments/components/appointment-summary/appointment-summary.component */ 2814);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ 8335);
/* Models */


/* Pipes */










const _c0 = ["componentElm"];
function AllComponent_option_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "option", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const option_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngValue", option_r1.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate"](option_r1.name);
  }
}
function AllComponent_option_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "option", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const option_r2 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngValue", option_r2.id);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate"](option_r2.name);
  }
}
function AllComponent_div_18_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](1, "appointment-summary", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const appointment_r3 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("appointment", appointment_r3);
  }
}
function AllComponent_div_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 13)(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](2, "No appointments available.");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
  }
}
let AllComponent = /*#__PURE__*/(() => {
  class AllComponent {
    constructor(router, appointmentsService, dbService, orderByPipe, uiService) {
      this.router = router;
      this.appointmentsService = appointmentsService;
      this.dbService = dbService;
      this.orderByPipe = orderByPipe;
      this.uiService = uiService;
      // #region Appointments
      this.retrievingAppointments = false;
      this.appointments = [];
      this.visibleAppointments = [];
      // #endregion
      // #region Searching
      this.searchInput = "";
      this.sortOptions = [];
      this.statusOptions = [];
    }
    get hasVisibileAppointments() {
      return this.visibleAppointments.length > 0;
    }
    validateAppointments(appointments) {
      const today = new Date();
      const month = today.getMonth();
      const date = today.getDate();
      const year = today.getFullYear();
      for (var i = 0, len = appointments.length; i < len; i++) {
        const appointment = appointments[i];
        const nextAppointment = appointments[i + 1];
        const scheduled_Utc = appointment.scheduled_Utc != null ? new Date(appointment.scheduled_Utc) : new Date();
        const appMonth = scheduled_Utc.getMonth();
        const appDate = scheduled_Utc.getDate();
        const appYear = scheduled_Utc.getFullYear();
        const isInPast = appMonth < month && appYear == year || appDate < date && appMonth == month && appYear == year || appYear < year;
        if (appointment.status == src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__.AppointmentStatus.Open && !isInPast && nextAppointment != null) {
          nextAppointment.available = false;
        }
      }
    }
    getAppointments() {
      this.retrievingAppointments = true;
      this.appointmentsService.getAppointments().subscribe({
        next: appointments => {
          if (appointments.length != this.appointments.length) {
            this.appointments = appointments;
            this.filterAppointments();
            this.validateAppointments(appointments);
            this.watchAppointments();
          }
          this.retrievingAppointments = false;
        },
        error: () => {
          this.retrievingAppointments = false;
        }
      });
    }
    watchAppointments() {
      if (this.appointmentSubscription == null) {
        this.appointmentSubscription = this.dbService.appointmentsRetrieved.subscribe({
          next: () => {
            this.getAppointments();
          }
        });
      }
    }
    filterAppointments() {
      const visibleAppointments = [];
      const searchInput = this.searchInput.toLocaleLowerCase();
      this.appointments.forEach(appointment => {
        let matched = false;
        if (searchInput.length <= 0) {
          matched = true;
        } else {
          if (appointment.customer != null) {
            const customerName = `${appointment.customer.firstName.toLocaleLowerCase()} ${appointment.customer.lastName.toLocaleLowerCase()}`;
            if (customerName.includes(searchInput)) {
              matched = true;
            }
            const matchingContact = appointment.customer.contactInformation.find(x => x.value.includes(searchInput));
            if (matchingContact != null) {
              matched = true;
            }
          }
          if (appointment.property?.address?.friendlyAddress != null) {
            const friendlyAddress = appointment.property.address.friendlyAddress.toLocaleLowerCase();
            if (friendlyAddress.includes(searchInput)) {
              matched = true;
            }
          }
          if (appointment.jobId != null && appointment.jobId.toString().includes(searchInput)) {
            matched = true;
          }
        }
        if (matched && (this.activeStatus == null || appointment.status == this.activeStatus)) {
          visibleAppointments.push(appointment);
        }
      });
      this.visibleAppointments = visibleAppointments;
      if (this.activeSort != null) {
        this.sortAppointments(this.activeSort, true);
      }
    }
    sortAppointments(property, descending = false) {
      this.visibleAppointments = this.orderByPipe.transform(this.visibleAppointments, property, descending);
    }
    initSortOptions() {
      const sortOptions = [];
      const statusOptions = [];
      sortOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption("scheduled_Utc", "Scheduled"));
      sortOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption("lastUpdated_Utc", "Last Updated"));
      this.activeSort = sortOptions[0].id;
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption(undefined, "All"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__.AppointmentStatus.Open, "Open"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__.AppointmentStatus.Dispositioned, "Dispositioned"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__.AppointmentStatus.InProgress, "In Progress"));
      statusOptions.push(new src_app_shared_helpers_models_searching__WEBPACK_IMPORTED_MODULE_1__.SortOption(src_app_shared_appointments_models_appointment__WEBPACK_IMPORTED_MODULE_0__.AppointmentStatus.Sold, "Sold"));
      this.activeStatus = undefined;
      this.sortOptions = sortOptions;
      this.statusOptions = statusOptions;
    }
    init() {
      this.initSortOptions();
      this.getAppointments();
    }
    // #endregion
    ngAfterViewInit() {
      setTimeout(() => {
        this.init();
        setTimeout(() => {
          if (this.route != null) {
            this.route.initialized.next();
          }
        }, 32);
      }, 16);
    }
    ngOnDestroy() {
      this.appointmentSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function AllComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || AllComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_8__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_services_appointments_service__WEBPACK_IMPORTED_MODULE_3__.AppointmentsService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_data_services_db_service__WEBPACK_IMPORTED_MODULE_4__.DbService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByPipe), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](src_app_shared_ui_services_ui_service__WEBPACK_IMPORTED_MODULE_5__.UiService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
      type: AllComponent,
      selectors: [["all"]],
      viewQuery: function AllComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        route: "route"
      },
      standalone: false,
      features: [_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵProvidersFeature"]([src_app_shared_ui_pipes_order_by_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByPipe])],
      decls: 20,
      vars: 7,
      consts: [["id", "allAppointments"], [1, "search"], [1, "input"], ["type", "text", "placeholder", "Search appointments...", 3, "ngModelChange", "input", "ngModel"], [1, "sorting"], [1, "control"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue", 4, "ngFor", "ngForOf"], ["class", "appointment", 4, "ngFor", "ngForOf"], ["class", "message", 4, "ngIf"], [3, "ngValue"], [1, "appointment"], [3, "appointment"], [1, "message"]],
      template: function AllComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "section", 0)(1, "header")(2, "div", 1)(3, "div", 2)(4, "input", 3);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayListener"]("ngModelChange", function AllComponent_Template_input_ngModelChange_4_listener($event) {
            _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayBindingSet"](ctx.searchInput, $event) || (ctx.searchInput = $event);
            return $event;
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("input", function AllComponent_Template_input_input_4_listener() {
            return ctx.filterAppointments();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "div", 4)(6, "div", 5)(7, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](8, "Sorting By");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](9, "div", 2)(10, "select", 6);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayListener"]("ngModelChange", function AllComponent_Template_select_ngModelChange_10_listener($event) {
            _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayBindingSet"](ctx.activeSort, $event) || (ctx.activeSort = $event);
            return $event;
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("change", function AllComponent_Template_select_change_10_listener() {
            return ctx.filterAppointments();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](11, AllComponent_option_11_Template, 2, 2, "option", 7);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](12, "div", 5)(13, "label");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](14, "Status");
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](15, "div", 2)(16, "select", 6);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayListener"]("ngModelChange", function AllComponent_Template_select_ngModelChange_16_listener($event) {
            _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayBindingSet"](ctx.activeStatus, $event) || (ctx.activeStatus = $event);
            return $event;
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("change", function AllComponent_Template_select_change_16_listener() {
            return ctx.filterAppointments();
          });
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](17, AllComponent_option_17_Template, 2, 2, "option", 7);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](18, AllComponent_div_18_Template, 2, 1, "div", 8)(19, AllComponent_div_19_Template, 3, 0, "div", 9);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayProperty"]("ngModel", ctx.searchInput);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](6);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayProperty"]("ngModel", ctx.activeSort);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngForOf", ctx.sortOptions);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](5);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtwoWayProperty"]("ngModel", ctx.activeStatus);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngForOf", ctx.statusOptions);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngForOf", ctx.visibleAppointments);
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"]();
          _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", !ctx.hasVisibileAppointments);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_9__.NgIf, _shared_appointments_components_appointment_summary_appointment_summary_component__WEBPACK_IMPORTED_MODULE_6__.AppointmentSummaryComponent, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.NgSelectOption, _angular_forms__WEBPACK_IMPORTED_MODULE_10__["ɵNgSelectMultipleOption"], _angular_forms__WEBPACK_IMPORTED_MODULE_10__.DefaultValueAccessor, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.SelectControlValueAccessor, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.NgModel],
      styles: ["#allAppointments[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  padding: calc(6vw + var(--systemOffset-top)) 5vw 5vw 5vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%] {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%] {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#allAppointments[_ngcontent-%COMP%]    > .appointment[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#allAppointments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 4vw;\n  top: calc(20vh + var(--systemOffset-top));\n  position: fixed;\n  left: 50%;\n  transform: translate3d(-50%, 0, 0);\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return AllComponent;
})();

/***/ }),

/***/ 9996:
/*!********************************************************************!*\
  !*** ./src/app/appointments/components/layout/layout.component.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentsLayoutComponent: () => (/* binding */ AppointmentsLayoutComponent)
/* harmony export */ });
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/shared/navigation/models/navigation */ 9518);
/* harmony import */ var _models_navigation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/navigation */ 8222);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var _services_appointments_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/appointments.service */ 1653);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/common */ 6216);
/* harmony import */ var _all_all_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../all/all.component */ 54);







const _c0 = ["componentElm"];
function AppointmentsLayoutComponent_all_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "all", 6);
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassMapInterpolate1"]("route ", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.loadDirection, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵclassProp"]("animate", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.animating)("closing", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.closing)("rendered", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.rendered);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("route", ctx_r0.allRoute);
  }
}
let AppointmentsLayoutComponent = /*#__PURE__*/(() => {
  class AppointmentsLayoutComponent {
    constructor(appointmentsService) {
      this.appointmentsService = appointmentsService;
      // #region Routes
      this.params = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject([]);
      this.routeParams = new rxjs__WEBPACK_IMPORTED_MODULE_5__.BehaviorSubject([]);
      this.routeLabel = "Appointments";
    }
    get routesInitialized() {
      return this.appointmentsService.routesInitialized;
    }
    get routes() {
      return this.appointmentsService.routeService.routes;
    }
    watchParams() {
      this.paramsSubscription = this.params.subscribe({
        next: params => {
          const componentElm = this.componentElm?.nativeElement;
          if (componentElm != null) {
            let route = params[0]?.toLowerCase();
            if (route != null) {
              const routeMatches = Object.values(_models_navigation__WEBPACK_IMPORTED_MODULE_1__.AppointmentsRouteType).includes(route);
              const routeParams = params.slice(1);
              this.routeParams.next(routeParams);
              if (routeMatches) {
                if (!this.routesInitialized) {
                  this.appointmentsService.initRoutes(route, componentElm);
                } else {
                  this.viewRoute(route);
                }
              } else {
                if (!this.routesInitialized) {
                  this.appointmentsService.initRoutes(undefined, componentElm);
                }
              }
            } else {
              if (!this.routesInitialized) {
                this.appointmentsService.initRoutes(undefined, componentElm);
              }
            }
          }
        }
      });
    }
    viewRoute(name) {
      if (name != null) {
        this.appointmentsService.routeService.viewRoute(name, src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_0__.RouteLoadDirection.Forward, true);
      }
    }
    watchRoute() {
      this.routeSubscription = this.appointmentsService.routeService.activeRoute.subscribe({
        next: route => {
          if (route != null) {
            switch (route.type) {
              case _models_navigation__WEBPACK_IMPORTED_MODULE_1__.AppointmentsRouteType.all:
                {
                  this.routeLabel = "Appointments";
                }
                break;
            }
          }
        }
      });
    }
    initRouting() {
      setTimeout(() => {
        this.watchParams();
        this.watchRoute();
      }, 0);
    }
    // #endregion
    // #region All
    get allRoute() {
      return this.routes[_models_navigation__WEBPACK_IMPORTED_MODULE_1__.AppointmentsRouteType.all];
    }
    init() {
      this.initRouting();
    }
    // #endregion
    ngOnInit() {
      this.init();
    }
    ngOnDestroy() {
      this.paramsSubscription?.unsubscribe();
      this.routeSubscription?.unsubscribe();
    }
    static #_ = (() => this.ɵfac = function AppointmentsLayoutComponent_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || AppointmentsLayoutComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_services_appointments_service__WEBPACK_IMPORTED_MODULE_2__.AppointmentsService));
    })();
    static #_2 = (() => this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
      type: AppointmentsLayoutComponent,
      selectors: [["ng-component"]],
      viewQuery: function AppointmentsLayoutComponent_Query(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_c0, 5);
        }
        if (rf & 2) {
          let _t;
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.componentElm = _t.first);
        }
      },
      inputs: {
        params: "params"
      },
      standalone: false,
      decls: 11,
      vars: 2,
      consts: [["componentElm", ""], ["id", "appointmentsLayout"], [1, "primary"], [1, "secondary"], [1, "routes"], [3, "class", "animate", "closing", "rendered", "route", 4, "ngIf"], [3, "route"]],
      template: function AppointmentsLayoutComponent_Template(rf, ctx) {
        if (rf & 1) {
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h1");
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "Book of Business");
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "h2");
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8);
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "div", 4);
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, AppointmentsLayoutComponent_all_10_Template, 1, 10, "all", 5);
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        }
        if (rf & 2) {
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](8);
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](ctx.routeLabel);
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
          _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.allRoute == null ? null : ctx.allRoute.active);
        }
      },
      dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_6__.NgIf, _all_all_component__WEBPACK_IMPORTED_MODULE_3__.AllComponent],
      styles: ["@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    transform: translateY(100%);\n  }\n  100% {\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    transform: translateY(100%);\n  }\n  100% {\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#appointmentsLayout[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-iteration-count: 1;\n  animation-timing-function: var(--easeInOutQuad);\n  animation-duration: var(--routeTransition);\n  animation-direction: normal;\n  animation-delay: 0s;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  transition: opacity 0.2s linear;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .loader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
    }))();
  }
  return AppointmentsLayoutComponent;
})();

/***/ }),

/***/ 8222:
/*!***************************************************!*\
  !*** ./src/app/appointments/models/navigation.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentsRouteType: () => (/* binding */ AppointmentsRouteType)
/* harmony export */ });
var AppointmentsRouteType = /*#__PURE__*/function (AppointmentsRouteType) {
  AppointmentsRouteType["all"] = "all";
  return AppointmentsRouteType;
}(AppointmentsRouteType || {});

/***/ }),

/***/ 1653:
/*!***************************************************************!*\
  !*** ./src/app/appointments/services/appointments.service.ts ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AppointmentsService: () => (/* binding */ AppointmentsService)
/* harmony export */ });
/* harmony import */ var _models_navigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/navigation */ 8222);
/* harmony import */ var src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/shared/navigation/models/navigation */ 9518);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/shared/appointments/services/appointment.service */ 8036);
/* harmony import */ var src_app_shared_data_services_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/shared/data/services/storage.service */ 1490);
/* harmony import */ var src_app_shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/shared/navigation/services/internal-route.service */ 8858);






let AppointmentsService = /*#__PURE__*/(() => {
  class AppointmentsService {
    constructor(appointmentService, storageService, routeService) {
      this.appointmentService = appointmentService;
      this.storageService = storageService;
      this.routeService = routeService;
      // #endregion
      // #region Routes
      this.routesInitialized = false;
    }
    // #region Appointments
    getAppointments() {
      return this.appointmentService.getAppointments();
    }
    initRoutes(initialRouteType = undefined, componentElm) {
      setTimeout(() => {
        if (componentElm != null) {
          const routes = {
            [_models_navigation__WEBPACK_IMPORTED_MODULE_0__.AppointmentsRouteType.all]: new src_app_shared_navigation_models_navigation__WEBPACK_IMPORTED_MODULE_1__.InternalRoute(_models_navigation__WEBPACK_IMPORTED_MODULE_0__.AppointmentsRouteType.all)
          };
          const initialRoute = initialRouteType != null ? initialRouteType : _models_navigation__WEBPACK_IMPORTED_MODULE_0__.AppointmentsRouteType.all;
          this.routeService.init(routes, initialRoute, 250, componentElm);
          this.routesInitialized = true;
        }
      }, 0);
    }
    static #_ = (() => this.ɵfac = function AppointmentsService_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || AppointmentsService)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](src_app_shared_appointments_services_appointment_service__WEBPACK_IMPORTED_MODULE_2__.AppointmentService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](src_app_shared_data_services_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](src_app_shared_navigation_services_internal_route_service__WEBPACK_IMPORTED_MODULE_4__.InternalRouteService));
    })();
    static #_2 = (() => this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineInjectable"]({
      token: AppointmentsService,
      factory: AppointmentsService.ɵfac,
      providedIn: 'root'
    }))();
  }
  return AppointmentsService;
})();

/***/ }),

/***/ 8858:
/*!**********************************************************************!*\
  !*** ./src/app/shared/navigation/services/internal-route.service.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InternalRouteService: () => (/* binding */ InternalRouteService)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 4380);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ 2836);
/* harmony import */ var _models_navigation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/navigation */ 9518);


/* Models */


/* Services */
let InternalRouteService = /*#__PURE__*/(() => {
  class InternalRouteService {
    constructor(renderFactory) {
      this.renderFactory = renderFactory;
      // #region UI
      this.transitionInMs = 250;
      // #endregion
      // #region Routes
      this.routes = {};
      this.routeChanging = false;
      this.activeRoute = new rxjs__WEBPACK_IMPORTED_MODULE_1__.BehaviorSubject(undefined);
      this.renderer = renderFactory.createRenderer(null, null);
    }
    setCssVariable(nativeElement, name, value) {
      this.renderer.setStyle(nativeElement, name, value, _angular_core__WEBPACK_IMPORTED_MODULE_2__.RendererStyleFlags2.DashCase);
    }
    viewRoute(type, direction, animate = false, activeDirection = _models_navigation__WEBPACK_IMPORTED_MODULE_0__.RouteLoadDirection.Forward, params = []) {
      const route = this.routes[type];
      if (route != null) {
        route.params.next(params);
        const activeRoute = this.activeRoute.getValue();
        if (activeRoute?.type != type) {
          this.closeActiveRoute(activeDirection, animate);
        }
        this.routeChanging = true;
        route.loadDirection = direction;
        route.active = true;
        this.activeRoute.next(route);
        const transitionInMs = animate ? this.transitionInMs : 0;
        const initSubscription = route.initialized.subscribe({
          next: () => {
            route.animating = animate;
            setTimeout(() => {
              this.routeChanging = false;
              route.animating = false;
              route.rendered = true;
            }, transitionInMs);
            initSubscription.unsubscribe();
          }
        });
      }
    }
    closeActiveRoute(direction, animate = false) {
      const route = this.activeRoute.getValue();
      if (route != null) {
        route.loadDirection = direction;
        route.closing = true;
        route.animating = animate;
        setTimeout(() => {
          route.active = false;
          route.closing = false;
          route.animating = false;
          route.rendered = false;
        }, this.transitionInMs);
      }
    }
    // #endregion
    // #region Bootstrapping
    init(routes, defaultRoute = null, transitionInMs = 250, componentElm) {
      this.routes = routes;
      this.transitionInMs = transitionInMs;
      this.setCssVariable(componentElm, "--routeTransition", `${transitionInMs}ms`);
      if (defaultRoute != null) {
        this.defaultRoute = this.routes[defaultRoute];
        this.viewRoute(defaultRoute, this.defaultRoute.loadDirection);
      }
    }
    // #endregion
    ngOnDestroy() {}
    static #_ = (() => this.ɵfac = function InternalRouteService_Factory(__ngFactoryType__) {
      return new (__ngFactoryType__ || InternalRouteService)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](_angular_core__WEBPACK_IMPORTED_MODULE_2__.RendererFactory2));
    })();
    static #_2 = (() => this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
      token: InternalRouteService,
      factory: InternalRouteService.ɵfac
    }))();
  }
  return InternalRouteService;
})();

/***/ })

}]);
//# sourceMappingURL=643.js.map