import {
  require_leaflet_src
} from "./chunk-ZIGK756M.js";
import {
  OpportunityUiService
} from "./chunk-LTPLV4TX.js";
import {
  DeviceRouteService,
  ReminderPriority,
  ReminderReferenceType,
  ReminderService
} from "./chunk-ZEKYPX2O.js";
import {
  ConsentComponent,
  DocumentService,
  OpportunityDocumentComponent,
  SharedDocumentsModule
} from "./chunk-N6TRD5KM.js";
import {
  ContactInformationType
} from "./chunk-HJJU6GQE.js";
import {
  SystemService
} from "./chunk-NX4GNOJ2.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  LogService,
  OpportunityLedgerEntrySubType,
  OpportunityLedgerEntryType,
  OpportunityService
} from "./chunk-55OJRHBT.js";
import {
  ContentService,
  Filesystem,
  Share
} from "./chunk-GYQ34QPN.js";
import {
  Directory
} from "./chunk-BN54ET2Y.js";
import {
  Browser
} from "./chunk-IVJ6NEFT.js";
import {
  ApiService
} from "./chunk-XNCHXMYV.js";
import {
  AuthRefService,
  ExportedOpportunity,
  Opportunity,
  OpportunityStatus,
  StorageService
} from "./chunk-M3LFBN7N.js";
import {
  DocumentSigner,
  DocumentSignerType,
  Payment,
  PaymentMethodType,
  PaymentStatus,
  deepClone,
  generateId,
  getDateOnly,
  safeEquivalentPrice,
  safePrice
} from "./chunk-N36JE2BE.js";
import {
  ApplicationRef,
  AsyncPipe,
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  CommonModule,
  Component,
  ConnectableObservable,
  CurrencyInputComponent,
  CurrencyPipe,
  DOCUMENT,
  DatePipe,
  DefaultValueAccessor,
  DestroyRef,
  Directive,
  DomSanitizer,
  ElementRef,
  EventEmitter,
  FormsModule,
  HttpClient,
  Injectable,
  InjectionToken,
  Injector,
  Input,
  IterableDiffers,
  LoaderComponent,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  NgZone,
  Observable,
  OrderByPipe,
  Output,
  PLATFORM_ID,
  PhoneFormatPipe,
  PhoneInputComponent,
  QueryList,
  ReactiveFormsModule,
  Renderer2,
  RendererFactory2,
  RouterModule,
  SelectControlValueAccessor,
  Subject,
  Subscription,
  TemplateRef,
  UiModule,
  ViewChild,
  ViewChildren,
  ViewContainerRef,
  ViewEncapsulation,
  afterNextRender,
  animationFrameScheduler,
  asapScheduler,
  auditTime,
  booleanAttribute,
  distinctUntilChanged,
  effect,
  filter,
  forwardRef,
  inject,
  isObservable,
  isPlatformBrowser,
  map,
  of,
  pairwise,
  parsePhoneNumber,
  setClassMetadata,
  shareReplay,
  signal,
  startWith,
  switchMap,
  takeUntil,
  untracked,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵInheritDefinitionFeature,
  ɵɵNgOnChangesFeature,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵattribute,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineDirective,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵdomElement,
  ɵɵdomElementEnd,
  ɵɵdomElementStart,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵpipeBind2,
  ɵɵprojection,
  ɵɵprojectionDef,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeHtml,
  ɵɵstyleProp,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtextInterpolate2,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import {
  Capacitor
} from "./chunk-IT26RCSL.js";
import {
  __async,
  __spreadProps,
  __spreadValues,
  __toESM
} from "./chunk-RVA4KI76.js";

// src/app/shared/payments/services/payments.service.ts
var _PaymentsService = class _PaymentsService {
  constructor(http, systemService, uiService, sanitizer) {
    this.http = http;
    this.systemService = systemService;
    this.uiService = uiService;
    this.sanitizer = sanitizer;
    this.applyingForExternalLender = false;
    this.closingExternalLender = false;
    this.makingManualPayment = false;
    this.closingManualPayment = false;
    this.manualPaymentMethods = [];
    this.manualPayment = new Subject();
  }
  generateGreenSkyPayload(data) {
    if (data?.customer != null && data.property?.address != null && data.assignedTo != null && data.price?.finalPrice != null) {
      const customerPhone = data.customer.contactInformation.find((x) => x.type == ContactInformationType.Phone);
      const customerEmail = data.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
      return {
        merchant: {
          sc_last_name: data.assignedTo.lastName ?? "",
          sc_email: data.assignedTo.emailAddress ?? "",
          sc_phone: void 0
        },
        order: {
          orderId: data.id,
          totalAmount: data.price.finalPrice
        },
        applicant: {
          firstName: data.customer.firstName,
          lastname: data.customer.lastName,
          streetaddress: data.property.address.streetAddress1 ?? "",
          city: data.property.address.city ?? "",
          state: data.property.address.regionIso3166 ?? "",
          zip: data.property.address.postalCode ?? "",
          country: "US",
          phone: customerPhone?.value ?? "",
          email: customerEmail?.value ?? ""
        }
      };
    }
    return void 0;
  }
  completeGreenSky(e, data) {
    if (e.detail.data.appointmentId != null && data.price?.finalPrice && data?.paymentSetting != null) {
      const method = data.paymentSetting.methods.find((x) => x.type == PaymentMethodType.Financing);
      if (method != null) {
        const payment = new Payment(generateId(), method, PaymentStatus.Completed, data.price.finalPrice);
        payment.paymentMethodId = data.paymentSetting?.methods.find((x) => x.type == PaymentMethodType.Financing)?.id;
        payment.source = "GreenSky Financing";
        payment.status = PaymentStatus.Completed;
        payment.timeStamp_Utc = new Date(Date.UTC((/* @__PURE__ */ new Date()).getUTCFullYear(), (/* @__PURE__ */ new Date()).getUTCMonth(), (/* @__PURE__ */ new Date()).getUTCDate(), (/* @__PURE__ */ new Date()).getUTCHours(), (/* @__PURE__ */ new Date()).getUTCMinutes(), (/* @__PURE__ */ new Date()).getUTCSeconds()));
        return payment;
      }
    }
    return void 0;
  }
  destroyGreenSky() {
    document.getElementById("gs_modal_blocker")?.remove();
    const scripts = document.getElementsByTagName("script");
    Array.from(scripts).forEach((script) => {
      if (script.src && (script.src.includes("iovation") || script.src.includes("greensky"))) {
        script.parentNode?.removeChild(script);
      }
    });
  }
  initGreenSky(componentElm, data) {
    return new Observable((o) => {
      const payload = this.generateGreenSkyPayload(data);
      if (payload != null) {
        window.GS_DEALER = "80000130";
        window.GS_BASE_PLAN = "4128";
        window.GS_PROGRAM = "GreenSky Consumer Projects";
        window.GS_API_KEY = "bWVyY2hhbnQxMDI6bWVyY2hhbnQxMDI=";
        window.GS_EXPERIENCE = 8;
        window.GS_ENV = 7;
        let script = document.getElementById("greenskyScript");
        if (script == null) {
          script = document.createElement("script");
          script.id = "greenskyScript";
          script.src = "https://www.greensky.com/ecommerce/aslowas/gs-api-min.js";
          script.async = true;
          componentElm.appendChild(script);
          script.onload = () => {
            if (window.greensky != null) {
              window.greensky.checkout(payload).then(() => {
                window.addEventListener("greensky.closemodal", (e) => {
                  const payment = this.completeGreenSky(e, data);
                  o.next(payment);
                  o.complete();
                });
              }).catch(() => {
                this.destroyGreenSky();
                o.error();
                o.complete();
              });
            }
          };
        } else {
          if (window.greensky != null) {
            window.greensky.checkout(payload).then(() => {
              window.addEventListener("greensky.closemodal", (e) => {
                const payment = this.completeGreenSky(e, data);
                o.next(payment);
                o.complete();
              });
            }).error(() => {
              this.destroyGreenSky();
              o.error();
              o.complete();
            });
          }
        }
      }
    });
  }
  startApplyingForExternalLender(lenderUrl) {
    Browser.open({
      url: lenderUrl
    });
  }
  stopApplyingForExternalLender() {
    window.clearTimeout(this.externalLenderTimer);
    this.closingExternalLender = true;
    this.externalLenderTimer = window.setTimeout(() => {
      this.applyingForExternalLender = false;
      this.closingExternalLender = false;
      this.externalLenderUrl = void 0;
    }, 250);
  }
  startMakingManualPayment(methods, tip = void 0) {
    window.clearTimeout(this.manualPaymentTimer);
    this.closingManualPayment = false;
    this.makingManualPayment = true;
    this.manualPaymentMethods = methods;
    this.manualPaymentTip = tip;
  }
  stopMakingManualPayment() {
    window.clearTimeout(this.manualPaymentTimer);
    this.closingManualPayment = true;
    this.manualPayment.next(void 0);
    this.manualPaymentTimer = window.setTimeout(() => {
      this.makingManualPayment = false;
      this.closingManualPayment = false;
      this.manualPaymentTip = void 0;
    }, 250);
  }
  submitManualPayment(method, amount) {
    const payment = new Payment(generateId(), method, PaymentStatus.Completed, amount, "USD", true);
    this.manualPayment.next(payment);
  }
  // #endregion
  ngOnDestroy() {
  }
};
_PaymentsService.\u0275fac = function PaymentsService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PaymentsService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(SystemService), \u0275\u0275inject(UiService), \u0275\u0275inject(DomSanitizer));
};
_PaymentsService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _PaymentsService, factory: _PaymentsService.\u0275fac });
var PaymentsService = _PaymentsService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PaymentsService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: SystemService }, { type: UiService }, { type: DomSanitizer }], null);
})();

// src/app/shared/users/services/user.service.ts
var _UserService = class _UserService {
  constructor(http) {
    this.http = http;
  }
  getRepipeUsers() {
    const url = `{{api}}/users/all`;
    return this.http.get(url);
  }
};
_UserService.\u0275fac = function UserService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _UserService)(\u0275\u0275inject(HttpClient));
};
_UserService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _UserService, factory: _UserService.\u0275fac, providedIn: "root" });
var UserService = _UserService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(UserService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }], null);
})();

// src/app/shared/opportunities/components/estimate-submission/estimate-submission.component.ts
var _c0 = ["previewElm"];
var _c1 = ["exportElm"];
var _c2 = ["documentElm"];
function EstimateSubmissionComponent_Conditional_0_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 12);
    \u0275\u0275element(1, "div", 43, 0);
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13);
    \u0275\u0275element(1, "loader", 44);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Preparing Documents");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("fill", false);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "p");
    \u0275\u0275text(2, " Please complete your documents before submitting the job. ");
    \u0275\u0275elementEnd()();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 17)(1, "h3");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate2("", ctx_r1.customer.firstName, " ", ctx_r1.customer.lastName);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r1.address.friendlyAddress);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_24_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("E-Mail: ", ctx_r1.customerEmail);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "phone");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Phone: ", \u0275\u0275pipeBind1(3, 1, ctx_r1.customerPhone));
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 20)(1, "header")(2, "div", 6)(3, "h4");
    \u0275\u0275text(4, "Final Sales Price");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(5, "div", 10)(6, "span", 32);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "currency");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(8, 1, ctx_r1.price.finalPrice, "USD"), " ");
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_49_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 14);
    \u0275\u0275text(1, " You have designated an invalid install date. ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_For_58_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0);
    \u0275\u0275pipe(1, "phone");
  }
  if (rf & 2) {
    const shop_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275textInterpolate1(" - ", \u0275\u0275pipeBind1(1, 1, shop_r3.phoneNumber), " ");
  }
}
function EstimateSubmissionComponent_Conditional_0_For_58_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 29);
    \u0275\u0275text(1);
    \u0275\u0275conditionalCreate(2, EstimateSubmissionComponent_Conditional_0_For_58_Conditional_2_Template, 2, 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const shop_r3 = ctx.$implicit;
    \u0275\u0275property("ngValue", shop_r3.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", shop_r3.name, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(shop_r3.phoneNumber != null ? 2 : -1);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_59_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 14);
    \u0275\u0275text(1, " You must specify a preferred shop. ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_67_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Missing Payment Information ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_68_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 32);
    \u0275\u0275text(1, " Ready to Submit ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_71_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 45);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_71_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.managePayments());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Manage Payments");
    \u0275\u0275elementEnd()();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_80_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Please Complete Payment Information ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_81_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Awaiting Signatures ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_82_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Awaiting Customer Signatures ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_83_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 32);
    \u0275\u0275text(1, " Ready to Submit ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_86_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 46);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_86_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.sendDocumentsForSignature());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Send for e-Signature");
    \u0275\u0275elementEnd()();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_87_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 42);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_87_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.reviewSignedDocuments());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Save or Send Signed Copies");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("disabled", !ctx_r1.canSendDocumentsToCustomer);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_88_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_88_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r7);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startSigningForCustomer());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Sign for Customer");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("disabled", !ctx_r1.canReviewDocuments);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_89_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_89_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startSigningForConsultant());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Sign for Consultant");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("disabled", !ctx_r1.canReviewDocuments);
  }
}
function EstimateSubmissionComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 3)(1, "header")(2, "div", 6)(3, "h3");
    \u0275\u0275text(4, " Submit Job ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 7)(6, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeView());
    });
    \u0275\u0275element(7, "i", 9);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 10)(9, "div", 6)(10, "header")(11, "h4");
    \u0275\u0275text(12, "Review Final Job Documents");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(13, "div", 11);
    \u0275\u0275conditionalCreate(14, EstimateSubmissionComponent_Conditional_0_Conditional_14_Template, 3, 0, "div", 12);
    \u0275\u0275conditionalCreate(15, EstimateSubmissionComponent_Conditional_0_Conditional_15_Template, 4, 1, "div", 13);
    \u0275\u0275conditionalCreate(16, EstimateSubmissionComponent_Conditional_0_Conditional_16_Template, 3, 0, "div", 14);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(17, "div", 15)(18, "div", 16);
    \u0275\u0275conditionalCreate(19, EstimateSubmissionComponent_Conditional_0_Conditional_19_Template, 3, 2, "div", 17);
    \u0275\u0275elementStart(20, "div", 18)(21, "h4");
    \u0275\u0275text(22);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(23, EstimateSubmissionComponent_Conditional_0_Conditional_23_Template, 3, 1, "div", 19);
    \u0275\u0275conditionalCreate(24, EstimateSubmissionComponent_Conditional_0_Conditional_24_Template, 3, 1, "div", 19);
    \u0275\u0275conditionalCreate(25, EstimateSubmissionComponent_Conditional_0_Conditional_25_Template, 4, 3, "div", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(26, EstimateSubmissionComponent_Conditional_0_Conditional_26_Template, 9, 4, "div", 20);
    \u0275\u0275elementStart(27, "div", 21)(28, "header")(29, "div", 6)(30, "H4");
    \u0275\u0275text(31, "Operation Notes");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(32, "div", 10)(33, "div", 22)(34, "div", 23)(35, "div", 24)(36, "textarea", 25);
    \u0275\u0275twoWayListener("ngModelChange", function EstimateSubmissionComponent_Conditional_0_Template_textarea_ngModelChange_36_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.operationsNote, $event) || (ctx_r1.operationsNote = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(37, "div", 26)(38, "header")(39, "div", 6)(40, "h4");
    \u0275\u0275text(41, "Shop Information");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(42, "div", 10)(43, "div", 22)(44, "div", 23)(45, "label");
    \u0275\u0275text(46, "Preferred Install Date");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(47, "div", 24)(48, "input", 27);
    \u0275\u0275twoWayListener("ngModelChange", function EstimateSubmissionComponent_Conditional_0_Template_input_ngModelChange_48_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.preferredInstallDateTimestamp, $event) || (ctx_r1.preferredInstallDateTimestamp = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("blur", function EstimateSubmissionComponent_Conditional_0_Template_input_blur_48_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateInstallDate());
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(49, EstimateSubmissionComponent_Conditional_0_Conditional_49_Template, 2, 0, "p", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(50, "div", 23)(51, "label");
    \u0275\u0275text(52, "Preferred Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(53, "div", 24)(54, "select", 28);
    \u0275\u0275twoWayListener("ngModelChange", function EstimateSubmissionComponent_Conditional_0_Template_select_ngModelChange_54_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.preferredShopId, $event) || (ctx_r1.preferredShopId = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("change", function EstimateSubmissionComponent_Conditional_0_Template_select_change_54_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateShop());
    });
    \u0275\u0275elementStart(55, "option", 29);
    \u0275\u0275text(56, "-- Select a Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275repeaterCreate(57, EstimateSubmissionComponent_Conditional_0_For_58_Template, 3, 3, "option", 29, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(59, EstimateSubmissionComponent_Conditional_0_Conditional_59_Template, 2, 0, "p", 14);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(60, "div", 30)(61, "header")(62, "div", 6)(63, "h4");
    \u0275\u0275text(64, "Payments");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(65, "h5");
    \u0275\u0275text(66, " Status: ");
    \u0275\u0275conditionalCreate(67, EstimateSubmissionComponent_Conditional_0_Conditional_67_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(68, EstimateSubmissionComponent_Conditional_0_Conditional_68_Template, 2, 0, "span", 32);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(69, "div", 15)(70, "div", 7);
    \u0275\u0275conditionalCreate(71, EstimateSubmissionComponent_Conditional_0_Conditional_71_Template, 3, 0, "button", 33);
    \u0275\u0275elementEnd()()();
    \u0275\u0275element(72, "div", 10);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(73, "div", 34)(74, "header")(75, "div", 6)(76, "h4");
    \u0275\u0275text(77, "Document Review");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(78, "h5");
    \u0275\u0275text(79, " Status: ");
    \u0275\u0275conditionalCreate(80, EstimateSubmissionComponent_Conditional_0_Conditional_80_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(81, EstimateSubmissionComponent_Conditional_0_Conditional_81_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(82, EstimateSubmissionComponent_Conditional_0_Conditional_82_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(83, EstimateSubmissionComponent_Conditional_0_Conditional_83_Template, 2, 0, "span", 32);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(84, "div", 15)(85, "div", 7);
    \u0275\u0275conditionalCreate(86, EstimateSubmissionComponent_Conditional_0_Conditional_86_Template, 3, 0, "button", 35);
    \u0275\u0275conditionalCreate(87, EstimateSubmissionComponent_Conditional_0_Conditional_87_Template, 3, 1, "button", 36);
    \u0275\u0275conditionalCreate(88, EstimateSubmissionComponent_Conditional_0_Conditional_88_Template, 3, 1, "button", 37);
    \u0275\u0275conditionalCreate(89, EstimateSubmissionComponent_Conditional_0_Conditional_89_Template, 3, 1, "button", 37);
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(90, "div", 38)(91, "div", 39);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_div_click_91_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.toggleConfirmation());
    });
    \u0275\u0275elementStart(92, "div", 24);
    \u0275\u0275element(93, "i", 40)(94, "i", 41);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(95, "label");
    \u0275\u0275text(96, "Tap to confirm you have verified all information is accurate before submitting.");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(97, "div", 7)(98, "button", 42);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_button_click_98_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeView());
    });
    \u0275\u0275elementStart(99, "label");
    \u0275\u0275text(100, "Cancel");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(101, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_button_click_101_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.submitEstimate());
    });
    \u0275\u0275elementStart(102, "label");
    \u0275\u0275text(103, "Submit Job");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", ctx_r1.submittingEstimate);
    \u0275\u0275advance(8);
    \u0275\u0275conditional(ctx_r1.hasDocumentsToPreview ? 14 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showDocumentsLoader ? 15 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.hasDocumentsToPreview ? 16 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.customer != null ? 19 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("Job ", ctx_r1.opportunity.jobId);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.address != null ? 23 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.customerEmail != null ? 24 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.customerPhone != null ? 25 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.price != null ? 26 : -1);
    \u0275\u0275advance(10);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.operationsNote);
    \u0275\u0275advance(8);
    \u0275\u0275classProp("invalid", !ctx_r1.shopDateValid);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.preferredInstallDateTimestamp);
    \u0275\u0275property("min", ctx_r1.minInstallDate);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.shopDateValid ? 49 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.preferredShopId);
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", void 0);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r1.shops);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx_r1.shopValid ? 59 : -1);
    \u0275\u0275advance(8);
    \u0275\u0275conditional(!ctx_r1.canSubmitPayments ? 67 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSubmitPayments ? 68 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.canManagePayments ? 71 : -1);
    \u0275\u0275advance(9);
    \u0275\u0275conditional(!ctx_r1.canReviewDocuments ? 80 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showDocumentSignaturesMessage ? 81 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showCustomerSignaturesMessage ? 82 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSubmitDocuments ? 83 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.canSendForSignature ? 86 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSubmitDocuments ? 87 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSignDocuments ? 88 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSignDocuments ? 89 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("checked", ctx_r1.confirmed);
    \u0275\u0275advance(7);
    \u0275\u0275property("disabled", ctx_r1.submittingEstimate);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx_r1.canSubmitEstimate);
  }
}
function EstimateSubmissionComponent_Conditional_1_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 49);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(2, 1, ctx_r1.estimateProgress), "%");
  }
}
function EstimateSubmissionComponent_Conditional_1_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 50);
    \u0275\u0275text(1, "Estimate Processing");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "aside", 4);
    \u0275\u0275element(1, "div", 47);
    \u0275\u0275elementStart(2, "div", 48)(3, "button", 45);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_1_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.promptToStopSendingEstimate());
    });
    \u0275\u0275element(4, "i", 9);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 13);
    \u0275\u0275conditionalCreate(6, EstimateSubmissionComponent_Conditional_1_Conditional_6_Template, 3, 3, "span", 49);
    \u0275\u0275conditionalCreate(7, EstimateSubmissionComponent_Conditional_1_Conditional_7_Template, 2, 0, "span", 50);
    \u0275\u0275element(8, "loader", 51);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Preparing & Sending Estimate");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275conditional(!ctx_r1.showEstimateProcessing ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showEstimateProcessing ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("progress", true)("percent", ctx_r1.estimateProgress);
  }
}
function EstimateSubmissionComponent_Conditional_2_For_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "opportunity-document", 54, 2);
    \u0275\u0275listener("rendered", function EstimateSubmissionComponent_Conditional_2_For_4_Template_opportunity_document_rendered_0_listener() {
      const document_r11 = \u0275\u0275restoreView(_r10).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.renderDocument(document_r11));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const document_r11 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("content", ctx_r1.content)("opportunity", ctx_r1.opportunity)("signing", true)("document", document_r11);
  }
}
function EstimateSubmissionComponent_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 5)(1, "div", 52, 1);
    \u0275\u0275repeaterCreate(3, EstimateSubmissionComponent_Conditional_2_For_4_Template, 2, 4, "opportunity-document", 53, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx_r1.documents);
  }
}
var _EstimateSubmissionComponent = class _EstimateSubmissionComponent {
  constructor(opportunityService, opportunityUiService, authRefService, contentService, logService, uiService, orderByPipe) {
    this.opportunityService = opportunityService;
    this.opportunityUiService = opportunityUiService;
    this.authRefService = authRefService;
    this.contentService = contentService;
    this.logService = logService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.activeUser = null;
    this.paymentDetails = [];
    this.documentElms = new QueryList();
    this.consultantValid = false;
    this.customerValid = false;
    this.sendingDocuments = false;
    this.closingSendDocuments = false;
    this.renderingDocuments = true;
    this.renderedDocuments = [];
    this.documents = [];
    this.minInstallDate = getDateOnly(/* @__PURE__ */ new Date());
    this.submittingEstimate = false;
    this.canStopSendingEstimate = false;
    this.estimateProgress = new BehaviorSubject(0);
    this.confirmed = false;
    this.today = /* @__PURE__ */ new Date();
  }
  initOpportunity() {
    if (this.opportunity != null) {
      this.initShop();
      this.initPaymentDetails();
      this.initDocuments();
    }
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Customer
  get customer() {
    return this.opportunity?.customer;
  }
  get customerName() {
    if (this.customer != null) {
      return `${this.customer.firstName} ${this.customer.lastName}`;
    }
    return "";
  }
  get customerEmail() {
    const email = this.customer?.contactInformation.find((x) => x.type == ContactInformationType.Email);
    return email?.value;
  }
  get customerPhone() {
    const phone = this.customer?.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
    return phone?.value;
  }
  get payments() {
    return this.opportunity?.payments ?? [];
  }
  get canSubmitPayments() {
    return this.opportunity?.paymentsValidForEstimate ?? false;
  }
  get canManagePayments() {
    return this.opportunity != null && !this.opportunity.documentsValidForEstimate && this.opportunity.paymentsValidForEstimate;
  }
  managePayments() {
    if (this.opportunity != null) {
      this.opportunityUiService.startMakingPayments(this.opportunity);
    }
  }
  initPaymentDetails() {
    if (this.opportunity?.paymentSetting != null) {
      for (var i = 0, len = this.opportunity.paymentSetting.details.length; i < len; i++) {
        const detail = this.opportunity.paymentSetting.details[i];
        detail.updatedAmount$ = new Subject();
        if (i == 1 && this.opportunity.paymentSetting.details.length > 2) {
          detail.canEditAmount = false;
        } else {
          detail.canEditAmount = true;
        }
        this.paymentDetails.push(detail);
      }
      this.paymentDetails = this.orderByPipe.transform(this.paymentDetails, "priority", false);
    }
  }
  get hasDocumentsToPreview() {
    return this.opportunity?.documentsValidForEstimate ?? false;
  }
  get canSend() {
    return !this.sendingDocuments && !this.renderingDocuments;
  }
  get showDocumentsLoader() {
    return this.renderingDocuments && this.hasDocumentsToPreview;
  }
  get canSubmitDocuments() {
    return this.canReviewDocuments && (this.opportunity?.documentsValidForEstimate ?? false);
  }
  get canReviewDocuments() {
    return this.opportunity?.paymentsValidForEstimate ?? false;
  }
  get canSendDocumentsToCustomer() {
    return this.opportunity?.documentsValidForEstimate ?? false;
  }
  get canSendForSignature() {
    return this.consultantValid && this.opportunity != null && this.opportunity?.paymentsValidForEstimate && !this.opportunity?.documentsValidForEstimate;
  }
  get canSignDocuments() {
    return this.opportunity != null && !this.opportunity.documentsValidForEstimate;
  }
  get showDocumentSignaturesMessage() {
    return !this.canSubmitDocuments && this.canReviewDocuments && this.opportunity != null && !this.opportunity.documentsValidForEstimate && !this.showCustomerSignaturesMessage;
  }
  get showCustomerSignaturesMessage() {
    return !this.canSubmitDocuments && this.canReviewDocuments && this.consultantValid && !this.customerValid;
  }
  watchDocumentSigning() {
    this.documentSigningSubscription = this.opportunityUiService.signingDocuments.subscribe({
      next: (appointment) => {
        if (appointment == null) {
          this.initDocuments();
        }
      }
    });
  }
  generatePrice() {
    const price = this.opportunity?.customPrice ?? this.opportunity?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.opportunity?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.opportunity != null) {
      const content = {
        opportunityId: this.opportunity.id,
        created_Utc: this.opportunity.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.opportunity.scheduled_Utc,
        property: this.opportunity.property,
        jobId: this.opportunity.jobId?.toString(),
        job: this.opportunity.job,
        consultant: this.opportunity.assignedTo,
        customer: this.opportunity.customer,
        price: this.generatePrice(),
        documents: this.opportunity.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  checkSigningValidity() {
    if (this.opportunity != null) {
      let consultantValid = true;
      let customerValid = true;
      for (var i = 0, len = this.opportunity.documents.length; i < len; i++) {
        const document2 = this.opportunity.documents[i];
        document2.checkSigningValidity();
        if (!document2.consultantValid) {
          consultantValid = false;
        }
        if (!document2.customerValid) {
          customerValid = false;
        }
      }
      this.consultantValid = consultantValid;
      this.customerValid = customerValid;
    }
  }
  initDocuments() {
    this.checkSigningValidity();
    if (this.opportunity?.documentsValidForEstimate) {
      this.generateContent();
      this.opportunity.documents.forEach((document2) => {
        const name = document2.name.toLowerCase();
        if (name != "repipe info sheet" && !name.includes("sample warranty")) {
          this.documents.push(document2);
        }
      });
      this.documents = this.orderByPipe.transform(this.documents, "displayOrder", false);
    } else {
      if (this.documentSigningSubscription == null) {
        this.watchDocumentSigning();
      }
    }
  }
  sortRenderedDocuments() {
    if (this.renderedDocuments != null && this.renderedDocuments.length > 0) {
      this.renderedDocuments = this.orderByPipe.transform(this.renderedDocuments, "displayOrder", false);
    }
  }
  checkFinalizeRender() {
    if (this.renderedDocuments.length == this.documents.length) {
      this.sortRenderedDocuments();
      this.renderDocuments();
    }
  }
  renderDocuments() {
    const previewElm = this.previewElm?.nativeElement;
    if (previewElm != null) {
      this.renderedDocuments.forEach((document2) => {
        if (document2.image != null) {
          previewElm.appendChild(document2.image);
        } else if (document2.canvas != null) {
          previewElm.appendChild(document2.canvas);
        }
      });
    }
    this.renderingDocuments = false;
  }
  renderDocument(document2) {
    const documentElm = this.documentElms.find((x) => x.document?.id == document2.id);
    if (documentElm != null) {
      documentElm.exportDocument(1, 1).then((canvas) => {
        const renderedDocument = {
          displayOrder: document2.displayOrder,
          name: document2.name,
          canvas,
          image: void 0
        };
        if (this.renderedDocuments != null) {
          this.renderedDocuments.push(renderedDocument);
        } else {
          this.renderedDocuments = [renderedDocument];
        }
        this.checkFinalizeRender();
      }).catch((e) => {
        this.logService.log(JSON.stringify(e), `Failed to render estimate documents ${document2.id} for opportunity ${this.opportunity?.id}.`).subscribe();
      });
    }
  }
  reviewSignedDocuments() {
    if (this.opportunity != null) {
      this.opportunityUiService.startSendingExecutedDocuments(this.opportunity);
    }
  }
  sendDocumentsForSignature() {
    if (this.opportunity != null) {
      this.opportunityUiService.startSendingDocuments(this.opportunity);
    }
  }
  startSigningForCustomer() {
    if (this.opportunity?.customer != null) {
      const customerName = `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
      this.opportunityUiService.startSigningDocuments(this.opportunity, customerName, true);
    }
  }
  startSigningForConsultant() {
    if (this.opportunity?.assignedTo != null) {
      const consultantName = `${this.opportunity.assignedTo.firstName} ${this.opportunity.assignedTo.lastName}`;
      this.opportunityUiService.startSigningDocuments(this.opportunity, consultantName, true);
    }
  }
  get shops() {
    return this.opportunity?.availableShops ?? [];
  }
  get shopValid() {
    return this.preferredShopId != null;
  }
  get shopDateValid() {
    return this.preferredInstallDateTimestamp == null || this.preferredInstallDateTimestamp > this.minInstallDate;
  }
  initShop() {
    this.preferredShopId = this.opportunity?.selectedShopId;
    this.preferredInstallDateTimestamp = this.opportunity?.preferredInstallDate;
  }
  updateShop() {
    return __async(this, null, function* () {
      if (this.opportunity != null && this.activeUser != null) {
        if (this.preferredShopId != null) {
          yield this.opportunityService.updateShop(this.opportunity, this.preferredShopId, this.activeUser);
        } else {
          yield this.opportunityService.removeShop(this.opportunity, this.activeUser);
        }
      }
    });
  }
  updateInstallDate() {
    return __async(this, null, function* () {
      if (this.opportunity != null && this.activeUser != null) {
        if (this.preferredInstallDateTimestamp != null) {
          yield this.opportunityService.updateInstallDate(this.opportunity, this.preferredInstallDateTimestamp, this.activeUser);
        } else {
          yield this.opportunityService.removeInstallDate(this.opportunity, this.activeUser);
        }
      }
    });
  }
  // #endregion
  // #region Address
  get address() {
    return this.opportunity?.property?.address;
  }
  // #endregion
  // #region Price
  get price() {
    return this.opportunity?.customPrice ?? this.opportunity?.price;
  }
  get showEstimateProcessing() {
    const progress = this.estimateProgress.getValue();
    return progress == 100;
  }
  get canSubmitEstimate() {
    return this.opportunity != null && !this.submittingEstimate && this.canSubmitDocuments && this.canSubmitPayments && this.shopDateValid && this.shopValid && this.confirmed;
  }
  promptToStopSendingEstimate() {
    this.uiService.prompt("Don't Want to Wait?", "Your estimate may still be submitted. Are you sure you want to stop waiting?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.submittingEstimate = false;
          window.clearTimeout(this.estimateTimeout);
        }
      }
    });
  }
  submitEstimate() {
    return __async(this, null, function* () {
      if (!this.submittingEstimate && this.opportunity != null && this.activeUser != null && this.opportunity.documentsValidForEstimate) {
        const opportunity = this.opportunity;
        const activeUser = this.activeUser;
        this.submittingEstimate = true;
        setTimeout(() => __async(this, null, function* () {
          const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
          this.estimateTimeout = window.setTimeout(() => {
            this.canStopSendingEstimate = true;
            this.uiService.prompt("Taking a While?", "Submitting the estimate seems to be taking a while. You may be on a poor connection or experiencing other issues. Do you want to cancel and try again later?", "Yes, Try Later", "No, Keep Waiting").subscribe({
              next: (confirmed) => {
                if (confirmed) {
                  this.submittingEstimate = false;
                }
              }
            });
          }, 45e3);
          this.estimateProgress.next(0);
          this.opportunityService.submitEstimate(opportunity, pdfRender.pdf, pdfRender.documents, this.operationsNote, this.preferredShopId, this.preferredInstallDateTimestamp).subscribe({
            next: (e) => {
              if ("progress" in e) {
                this.estimateProgress.next(e.progress);
              } else {
                window.clearTimeout(this.estimateTimeout);
                this.uiService.prompt("Estimate Submitted", `You successfully submitted your estimate for Job ${opportunity.jobId}. Thank you!`, "Ok").subscribe({
                  next: () => __async(this, null, function* () {
                    this.opportunityService.updateStatus(opportunity, OpportunityStatus.Submitted, activeUser);
                    this.closeView();
                    this.submittingEstimate = false;
                  })
                });
              }
            },
            error: () => {
              window.clearTimeout(this.estimateTimeout);
              this.uiService.prompt("Failed to Submit Estimate", "There was a problem submitting the estimate to NetSuite. Please try again later.", "Okay").subscribe({
                next: (confirmed) => {
                  this.submittingEstimate = false;
                  window.clearTimeout(this.estimateTimeout);
                }
              });
            }
          });
        }), 0);
      }
    });
  }
  toggleConfirmation() {
    this.confirmed = !this.confirmed;
  }
  closeView() {
    this.opportunityUiService.stopPreparingEstimate();
  }
  init() {
    this.watchUser();
    if (this.opportunity != null) {
      this.initOpportunity();
    }
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.appointmentSubscription?.unsubscribe();
    this.documentSigningSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_EstimateSubmissionComponent.\u0275fac = function EstimateSubmissionComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _EstimateSubmissionComponent)(\u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_EstimateSubmissionComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _EstimateSubmissionComponent, selectors: [["estimate-submission"]], viewQuery: function EstimateSubmissionComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
    \u0275\u0275viewQuery(_c1, 5);
    \u0275\u0275viewQuery(_c2, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.previewElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.exportElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.documentElms = _t);
  }
}, inputs: { opportunity: "opportunity" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 3, vars: 3, consts: [["previewElm", ""], ["exportElm", ""], ["documentElm", ""], ["id", "estimateSubmission"], ["id", "submittingEstimate"], ["id", "renderingDocuments"], [1, "primary"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "preview-wrap"], [1, "render-wrap"], [1, "loader"], [1, "message"], [1, "secondary"], [1, "meta", "section"], [1, "customer"], [1, "job"], [1, "info"], [1, "price", "section"], [1, "operation-notes", "section"], [1, "form"], [1, "input-wrap"], [1, "input"], ["rows", "3", "placeholder", "Notes to Operations", 3, "ngModelChange", "ngModel"], [1, "shop", "section"], ["type", "date", 3, "ngModelChange", "blur", "ngModel", "min"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [1, "payments", "section"], [1, "value", "warning"], [1, "value"], [1, "control"], [1, "documents", "section"], [1, "control", "alternate"], [1, "control", "alternate", 3, "disabled"], [1, "control", 3, "disabled"], [1, "confirmation"], [1, "input-wrap", 3, "click"], [1, "fa-regular", "fa-circle", "unchecked"], [1, "fa-solid", "fa-circle-check", "checked"], [1, "control", "alternate", 3, "click", "disabled"], [1, "render"], [3, "fill"], [1, "control", 3, "click"], [1, "control", "alternate", 3, "click"], [1, "bg"], [1, "modal"], [1, "progress"], [1, "processing"], [3, "progress", "percent"], [1, "document"], [3, "content", "opportunity", "signing", "document"], [3, "rendered", "content", "opportunity", "signing", "document"]], template: function EstimateSubmissionComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, EstimateSubmissionComponent_Conditional_0_Template, 104, 34, "div", 3);
    \u0275\u0275conditionalCreate(1, EstimateSubmissionComponent_Conditional_1_Template, 11, 4, "aside", 4);
    \u0275\u0275conditionalCreate(2, EstimateSubmissionComponent_Conditional_2_Template, 5, 0, "aside", 5);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.opportunity != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.submittingEstimate ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.opportunity != null ? 2 : -1);
  }
}, dependencies: [OpportunityDocumentComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, LoaderComponent, NgModel, AsyncPipe, CurrencyPipe, PhoneFormatPipe], styles: ["\n\n#estimateSubmission[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 1.3vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color4Alt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%]    > .value.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  border-color: var(--color5);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus, \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.price[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 3vw;\n  color: var(--success);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 100%;\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  flex: 1;\n  display: block;\n  font-size: 1.1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  text-align: right;\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--stronger);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.documents[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  width: calc(60% - 1vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 1;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     canvas, \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     img {\n  display: block;\n  width: 100%;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2-raw), 0.8);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 60%;\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  width: 40%;\n  margin-left: 1vw;\n  padding-left: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt3) solid;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  width: 3vw;\n  text-align: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 2.6vw;\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.unchecked[_ngcontent-%COMP%] {\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.checked[_ngcontent-%COMP%] {\n  display: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  flex: 1;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n  line-height: 1;\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.unchecked[_ngcontent-%COMP%] {\n  display: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.checked[_ngcontent-%COMP%] {\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding-bottom: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#loader[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: center;\n  margin: 2vw 0;\n}\n#loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 1s;\n}\n@-webkit-keyframes _ngcontent-%COMP%_estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: estimateModalLoadIn;\n  -ms-animation-name: estimateModalLoadIn;\n  -o-animation-name: estimateModalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_estimateModalLoadIn;\n  animation-name: _ngcontent-%COMP%_estimateModalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%] {\n  font-size: 4vw;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#renderingDocuments[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%]   opportunity-document[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=estimate-submission.component.css.map */"] });
var EstimateSubmissionComponent = _EstimateSubmissionComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(EstimateSubmissionComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "estimate-submission", providers: [OrderByPipe], template: `@if (opportunity != null) {
  <div id="estimateSubmission">
    <header>
      <div class="primary">
        <h3>
          Submit Job
        </h3>
      </div>
      <div class="controls">
        <button class="control" [disabled]="submittingEstimate" (click)="closeView()">
          <i class="fa-solid fa-xmark"></i>
        </button>
      </div>
    </header>
    <div class="content">
      <div class="primary">
        <header>
          <h4>Review Final Job Documents</h4>
        </header>
        <div class="preview-wrap">
          @if (hasDocumentsToPreview) {
            <div class="render-wrap">
              <div class="render" #previewElm></div>
            </div>
          }
          @if (showDocumentsLoader) {
            <div class="loader">
              <loader [fill]="false"></loader>
              <label>Preparing Documents</label>
            </div>
          }
          @if (!hasDocumentsToPreview) {
            <div class="message">
              <p>
                Please complete your documents before submitting the job.
              </p>
            </div>
          }
        </div>
      </div>
      <div class="secondary">
        <div class="meta section">
          @if (customer != null) {
            <div class="customer">
              <h3>{{customer.firstName}} {{customer.lastName}}</h3>
            </div>
          }
          <div class="job">
            <h4>Job {{opportunity.jobId}}</h4>
          </div>
          @if (address != null) {
            <div class="info">
              <h4>{{address.friendlyAddress}}</h4>
            </div>
          }
          @if (customerEmail != null) {
            <div class="info">
              <h4>E-Mail: {{customerEmail}}</h4>
            </div>
          }
          @if (customerPhone != null) {
            <div class="info">
              <h4>Phone: {{customerPhone | phone}}</h4>
            </div>
          }
        </div>
        @if (price != null) {
          <div class="price section">
            <header>
              <div class="primary">
                <h4>Final Sales Price</h4>
              </div>
            </header>
            <div class="content">
              <span class="value">
                {{price.finalPrice | currency:'USD'}}
              </span>
            </div>
          </div>
        }
        <div class="operation-notes section">
          <header>
            <div class="primary">
              <H4>Operation Notes</H4>
            </div>
          </header>
          <div class="content">
            <div class="form">
              <div class="input-wrap">
                <div class="input">
                  <textarea rows="3" [(ngModel)]="operationsNote" placeholder="Notes to Operations"></textarea>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="shop section">
          <header>
            <div class="primary">
              <h4>Shop Information</h4>
            </div>
          </header>
          <div class="content">
            <div class="form">
              <div class="input-wrap" [class.invalid]="!shopDateValid">
                <label>Preferred Install Date</label>
                <div class="input">
                  <input
                    [(ngModel)]="preferredInstallDateTimestamp"
                    (blur)="updateInstallDate()"
                    [min]="minInstallDate" type="date" />
                </div>
                @if (!shopDateValid) {
                  <p class="message">
                    You have designated an invalid install date.
                  </p>
                }
              </div>
              <div class="input-wrap">
                <label>Preferred Shop</label>
                <div class="input">
                  <select [(ngModel)]="preferredShopId" (change)="updateShop()">
                    <option [ngValue]="undefined">-- Select a Shop</option>
                    @for (shop of shops; track shop) {
                      <option [ngValue]="shop.id">
                        {{shop.name}}
                        @if (shop.phoneNumber != null) {
                          - {{shop.phoneNumber | phone}}
                        }
                      </option>
                    }
                  </select>
                </div>
                @if (!shopValid) {
                  <p class="message">
                    You must specify a preferred shop.
                  </p>
                }
              </div>
            </div>
          </div>
        </div>
        <div class="payments section">
          <header>
            <div class="primary">
              <h4>Payments</h4>
              <h5>
                Status:
                @if (!canSubmitPayments) {
                  <span class="value warning">
                    Missing Payment Information
                  </span>
                }
                @if (canSubmitPayments) {
                  <span class="value">
                    Ready to Submit
                  </span>
                }
              </h5>
            </div>
            <div class="secondary">
              <div class="controls">
                @if (canManagePayments) {
                  <button class="control" (click)="managePayments()">
                    <label>Manage Payments</label>
                  </button>
                }
              </div>
            </div>
          </header>
          <div class="content">
          </div>
        </div>
        <div class="documents section">
          <header>
            <div class="primary">
              <h4>Document Review</h4>
              <h5>
                Status:
                @if (!canReviewDocuments) {
                  <span class="value warning">
                    Please Complete Payment Information
                  </span>
                }
                @if (showDocumentSignaturesMessage) {
                  <span class="value warning">
                    Awaiting Signatures
                  </span>
                }
                @if (showCustomerSignaturesMessage) {
                  <span class="value warning">
                    Awaiting Customer Signatures
                  </span>
                }
                @if (canSubmitDocuments) {
                  <span class="value">
                    Ready to Submit
                  </span>
                }
              </h5>
            </div>
            <div class="secondary">
              <div class="controls">
                @if (canSendForSignature) {
                  <button class="control alternate"
                    (click)="sendDocumentsForSignature()">
                    <label>Send for e-Signature</label>
                  </button>
                }
                @if (canSubmitDocuments) {
                  <button class="control alternate" [disabled]="!canSendDocumentsToCustomer" (click)="reviewSignedDocuments()">
                    <label>Save or Send Signed Copies</label>
                  </button>
                }
                @if (canSignDocuments) {
                  <button class="control" [disabled]="!canReviewDocuments" (click)="startSigningForCustomer()">
                    <label>Sign for Customer</label>
                  </button>
                }
                @if (canSignDocuments) {
                  <button class="control" [disabled]="!canReviewDocuments" (click)="startSigningForConsultant()">
                    <label>Sign for Consultant</label>
                  </button>
                }
              </div>
            </div>
          </header>
        </div>
      </div>
    </div>
    <div class="confirmation">
      <div class="input-wrap" [class.checked]="confirmed" (click)="toggleConfirmation()">
        <div class="input">
          <i class="fa-regular fa-circle unchecked"></i>
          <i class="fa-solid fa-circle-check checked"></i>
        </div>
        <label>Tap to confirm you have verified all information is accurate before submitting.</label>
      </div>
    </div>
    <div class="controls">
      <button class="control alternate" [disabled]="submittingEstimate" (click)="closeView()">
        <label>Cancel</label>
      </button>
      <button class="control" [disabled]="!canSubmitEstimate" (click)="submitEstimate()">
        <label>Submit Job</label>
      </button>
    </div>
  </div>
}

@if (submittingEstimate) {
  <aside id="submittingEstimate">
    <div class="bg"></div>
    <div class="modal">
      <button class="control" (click)="promptToStopSendingEstimate()">
        <i class="fa-solid fa-xmark"></i>
      </button>
      <div class="loader">
        @if (!showEstimateProcessing) {
          <span class="progress">{{estimateProgress | async}}%</span>
        }
        @if (showEstimateProcessing) {
          <span class="processing">Estimate Processing</span>
        }
        <loader [progress]="true" [percent]="estimateProgress"></loader>
      </div>
      <label>Preparing & Sending Estimate</label>
    </div>
  </aside>
}

@if (opportunity != null) {
  <aside id="renderingDocuments">
    <div class="document" #exportElm>
      @for (document of documents; track document) {
        <opportunity-document
          #documentElm
          [content]="content"
          [opportunity]="opportunity"
          [signing]="true"
          (rendered)="renderDocument(document)"
        [document]="document"></opportunity-document>
      }
    </div>
  </aside>
}`, styles: ["/* src/app/shared/opportunities/components/estimate-submission/estimate-submission.component.scss */\n#estimateSubmission {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#estimateSubmission > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#estimateSubmission > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission > header > .primary > h3 > .job {\n  color: var(--color5);\n}\n#estimateSubmission > header > .controls > .control {\n  cursor: pointer;\n}\n#estimateSubmission > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#estimateSubmission > .content {\n  flex: 1;\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#estimateSubmission > .content .section {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section > header {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#estimateSubmission > .content .section > header > .primary {\n  flex: 1;\n}\n#estimateSubmission > .content .section > header > .primary h4 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .content .section > header > .primary h5 {\n  line-height: 1;\n  font-size: 1.3vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#estimateSubmission > .content .section > header > .primary h5 > .value {\n  color: var(--color4Alt4);\n}\n#estimateSubmission > .content .section > header > .primary h5 > .value.warning {\n  color: var(--error);\n}\n#estimateSubmission > .content .section > header > .secondary > .controls {\n  display: flex;\n  flex-direction: column;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control > label {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control.alternate {\n  border-color: var(--color5);\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control.alternate > label {\n  color: var(--color5);\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control:first-child {\n  margin-top: 0;\n}\n#estimateSubmission > .content .section > .content {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap {\n  margin-top: 0.5vw;\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input input,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input select,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input textarea {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input input:focus,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input select:focus,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input textarea:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#estimateSubmission > .content .section.meta > .customer h3 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.meta > .info {\n  margin-top: 0.25vw;\n}\n#estimateSubmission > .content .section.meta > .info h4 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.meta > .job {\n  margin-top: 0.25vw;\n}\n#estimateSubmission > .content .section.meta > .job h4 {\n  font-size: 1.6vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.price > .content > .value {\n  display: block;\n  font-size: 3vw;\n  color: var(--success);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.payments {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission > .content .section.payments > .content {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .content {\n  width: 100%;\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .content > label {\n  flex: 1;\n  display: block;\n  font-size: 1.1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .content > .amount > .value {\n  display: block;\n  text-align: right;\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--stronger);\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail:first-child {\n  margin-top: 0;\n}\n#estimateSubmission > .content .section.documents {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission > .content .section:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#estimateSubmission > .content > .primary {\n  width: calc(60% - 1vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission > .content > .primary > header {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 1;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#estimateSubmission > .content > .primary > header h4 {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#estimateSubmission > .content > .primary > .preview-wrap {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap > .render {\n  width: 100%;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap > .render ::ng-deep canvas,\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap > .render ::ng-deep img {\n  display: block;\n  width: 100%;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .message {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2-raw), 0.8);\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .message > p {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 60%;\n  display: block;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .loader {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .loader > label {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#estimateSubmission > .content > .secondary {\n  width: 40%;\n  margin-left: 1vw;\n  padding-left: 1vw;\n}\n#estimateSubmission > .confirmation {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt3) solid;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission > .confirmation > .input-wrap {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#estimateSubmission > .confirmation > .input-wrap > .input {\n  width: 3vw;\n  text-align: center;\n}\n#estimateSubmission > .confirmation > .input-wrap > .input i {\n  font-size: 2.6vw;\n  color: var(--color1);\n}\n#estimateSubmission > .confirmation > .input-wrap > .input i.unchecked {\n  display: block;\n}\n#estimateSubmission > .confirmation > .input-wrap > .input i.checked {\n  display: none;\n}\n#estimateSubmission > .confirmation > .input-wrap > label {\n  flex: 1;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n  line-height: 1;\n  display: block;\n}\n#estimateSubmission > .confirmation > .input-wrap.checked > .input i {\n  font-size: 2vw;\n  color: var(--color1);\n}\n#estimateSubmission > .confirmation > .input-wrap.checked > .input i.unchecked {\n  display: none;\n}\n#estimateSubmission > .confirmation > .input-wrap.checked > .input i.checked {\n  display: block;\n}\n#estimateSubmission > .controls {\n  margin-top: 1vw;\n  padding-bottom: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#estimateSubmission > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#estimateSubmission > .controls > .control.success {\n  background-color: var(--success);\n}\n#estimateSubmission > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#estimateSubmission > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#estimateSubmission > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#estimateSubmission > .controls > .control:first-child {\n  margin-left: 0;\n}\n#loader {\n  display: flex;\n  justify-content: center;\n  margin: 2vw 0;\n}\n#loader > loader {\n  display: block;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 1s;\n}\n@-webkit-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n#submittingEstimate > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate > .modal {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: estimateModalLoadIn;\n  -ms-animation-name: estimateModalLoadIn;\n  -o-animation-name: estimateModalLoadIn;\n  -webkit-animation-name: estimateModalLoadIn;\n  animation-name: estimateModalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate > .modal > .control {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#submittingEstimate > .modal > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#submittingEstimate > .modal > .loader {\n  position: relative;\n}\n#submittingEstimate > .modal > .loader > .progress,\n#submittingEstimate > .modal > .loader > .processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#submittingEstimate > .modal > .loader > .progress {\n  font-size: 4vw;\n}\n#submittingEstimate > .modal > .loader > .processing {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#submittingEstimate > .modal > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#submittingEstimate > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#renderingDocuments {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments > .document {\n  width: 100%;\n}\n#renderingDocuments > .document opportunity-document {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=estimate-submission.component.css.map */\n"] }]
  }], () => [{ type: OpportunityService }, { type: OpportunityUiService }, { type: AuthRefService }, { type: ContentService }, { type: LogService }, { type: UiService }, { type: OrderByPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], documentElms: [{
    type: ViewChildren,
    args: ["documentElm"]
  }], previewElm: [{
    type: ViewChild,
    args: ["previewElm"]
  }], exportElm: [{
    type: ViewChild,
    args: ["exportElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(EstimateSubmissionComponent, { className: "EstimateSubmissionComponent" });
})();

// src/app/shared/opportunities/components/signing/signing.component.ts
var _c02 = ["componentElm"];
function OpportunitySigningComponent_For_15_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div")(1, "opportunity-document", 18);
    \u0275\u0275listener("changed", function OpportunitySigningComponent_For_15_Conditional_0_Template_opportunity_document_changed_1_listener() {
      \u0275\u0275restoreView(_r2);
      const document_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.documentChanged(document_r3));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const document_r3 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("document-wrap ", document_r3.uiDirection));
    \u0275\u0275classProp("rendering", ctx_r3.finalizingDocument);
    \u0275\u0275advance();
    \u0275\u0275property("content", ctx_r3.content)("opportunity", ctx_r3.opportunity)("signer", ctx_r3.signer)("execute", false)("document", document_r3);
  }
}
function OpportunitySigningComponent_For_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, OpportunitySigningComponent_For_15_Conditional_0_Template, 2, 10, "div", 17);
  }
  if (rf & 2) {
    const document_r3 = ctx.$implicit;
    \u0275\u0275conditional(document_r3.active ? 0 : -1);
  }
}
function OpportunitySigningComponent_Conditional_18_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 8)(1, "label");
    \u0275\u0275text(2, " Document is missing signatures. ");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySigningComponent_Conditional_30_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "signing-consent", 19);
    \u0275\u0275listener("close", function OpportunitySigningComponent_Conditional_30_Template_signing_consent_close_0_listener($event) {
      \u0275\u0275restoreView(_r5);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.finalizeConsent($event));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("consenters", ctx_r3.consenters);
  }
}
var _OpportunitySigningComponent = class _OpportunitySigningComponent {
  constructor(uiService, documentService, opportunityUiService, opportunityService, authRefService, orderByPipe, changeDetector) {
    this.uiService = uiService;
    this.documentService = documentService;
    this.opportunityUiService = opportunityUiService;
    this.opportunityService = opportunityService;
    this.authRefService = authRefService;
    this.orderByPipe = orderByPipe;
    this.changeDetector = changeDetector;
    this.activeUser = null;
    this.activeDocumentIndex = 0;
    this.finalizingDocument = false;
    this.customerFacing = false;
    this.retrievingDocuments = false;
    this.documents = [];
    this.consenting = false;
    this.consenters = new BehaviorSubject([]);
    this.backLabel = "Previous Document";
    this.forwardLabel = "Next Document";
    this.back = new Subject();
    this.previousDocumentAvailable = false;
    this.navigating = false;
    this.rendering = false;
    this.close = new Subject();
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  get customerName() {
    if (this.opportunity?.customer != null) {
      return `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
    }
    return "";
  }
  generatePrice() {
    const price = this.opportunity?.customPrice ?? this.opportunity?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.opportunity?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.opportunity != null) {
      const content = {
        opportunityId: this.opportunity.id,
        created_Utc: this.opportunity.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.opportunity.scheduled_Utc,
        property: this.opportunity.property,
        jobId: this.opportunity.jobId?.toString(),
        job: this.opportunity.job,
        consultant: this.opportunity.assignedTo,
        customer: this.opportunity.customer,
        price: this.generatePrice(),
        documents: this.opportunity.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  get canFinalizeDocument() {
    return this.activeDocument != null && this.activeDocument.validForExecution;
  }
  get canSendForSignature() {
    return this.activeDocument != null && !this.activeDocument.validForExecution;
  }
  get showMissingSignaturesWarning() {
    return !this.navigating && this.activeDocument != null && this.activeDocument.rendered && !this.activeDocument.validForExecution && this.activeDocument.checkedValidation;
  }
  finalizeDocument(promptOnSuccess = true) {
    return new Promise((res, rej) => {
      this.finalizingDocument = true;
      setTimeout(() => {
        const componentElm = this.componentElm?.nativeElement;
        if (this.activeDocument != null && componentElm != null) {
          const viewerElm = componentElm.querySelector(".render");
          if (viewerElm != null) {
            this.activeDocument.renderCanvas(viewerElm).then((b64) => {
              if (promptOnSuccess) {
                this.uiService.prompt("Document Finalized", "A finalized copy of the document was rendered and exported for storage.", "Ok").subscribe({
                  next: () => {
                    this.finalizingDocument = false;
                    res();
                  }
                });
              } else {
                this.finalizingDocument = false;
                res();
              }
            }).catch((e) => {
              this.uiService.prompt("Failed to Finalize", "There was an issue finalizing the document. Please try again or contact support.", "Ok").subscribe({
                next: () => {
                  this.finalizingDocument = false;
                  rej();
                }
              });
            });
          } else {
            rej();
          }
        }
      }, 32);
    });
  }
  promptToFinalizeDocument() {
    return new Promise((res, rej) => {
      if (this.canFinalizeDocument) {
        this.uiService.prompt("Finalize Document", `Finalizing the document will render an executed copy for storage with the appointment
                        and overwrite any previously finalized copy. Are you sure you want to continue?`, "Yes", "No").subscribe({
          next: (confirmed) => {
            if (confirmed) {
              this.finalizeDocument().then(() => res()).catch(() => rej());
            } else {
              rej();
            }
          }
        });
      }
    });
  }
  setActiveDocument(index, direction = "forward") {
    window.clearTimeout(this.documentTimer);
    this.navigating = true;
    if (this.activeDocument != null) {
      switch (direction) {
        case "forward":
          {
            this.activeDocument.uiDirection = "loading-out";
          }
          break;
        case "reverse":
          {
            this.activeDocument.uiDirection = "loading-out-reverse";
          }
          break;
      }
    }
    const nextDocument = this.documents[index];
    if (nextDocument != null) {
      switch (direction) {
        case "forward":
          {
            nextDocument.uiDirection = "loading-in";
          }
          break;
        case "reverse":
          {
            nextDocument.uiDirection = "loading-in-reverse";
          }
          break;
      }
      nextDocument.active = true;
    }
    this.documentTimer = window.setTimeout(() => {
      this.documents.forEach((document2) => {
        if (document2.id != nextDocument.id) {
          document2.active = false;
          document2.uiDirection = "";
        }
      });
      nextDocument.uiDirection = "loaded";
      this.activeDocument = nextDocument;
      this.activeDocumentIndex = index;
      this.navigating = false;
      this.setNavigation();
    }, 500);
  }
  // #endregion
  // #region Send Final
  get showSendFinal() {
    return this.opportunity?.documentsValidForEstimate ?? false;
  }
  promptToSendFinal() {
    if (this.opportunity != null) {
      const clone = deepClone(this.opportunity);
      if (clone != null) {
        this.opportunityUiService.startSendingExecutedDocuments(clone);
      }
    }
  }
  // #endregion
  // #region Send for Signatures
  get showSendSignatures() {
    return !this.opportunity?.documentsValidForEstimate;
  }
  promptToSendToCustomer() {
    if (this.opportunity != null) {
      const clone = deepClone(this.opportunity);
      if (clone != null) {
        this.opportunityUiService.startSendingExecutedDocuments(clone);
      }
    }
  }
  get showDocumentLoader() {
    return this.finalizingDocument;
  }
  documentChanged(document2) {
    this.documentService.updateSigners(this.documents);
    this.setNavigation();
  }
  generateSigners(document2) {
    const signers = [];
    let customerAdded = false;
    let consultantAdded = false;
    if (document2.mapping != null) {
      for (var i = 0, len = document2.mapping.pages.length; i < len; i++) {
        const page = document2.mapping.pages[i];
        for (var j = 0, jlen = page.fields.length; j < jlen; j++) {
          const field = page.fields[j];
          if ((field.id?.includes("initial.customer") || field.id?.includes("signature.customer")) && !customerAdded) {
            if (this.opportunity?.customer != null) {
              const fullName = `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
              const email = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
              const phone = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
              const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
              signers.push(signer);
              customerAdded = true;
            }
          }
          if ((field.id?.includes("initial.consultant") || field.id?.includes("signature.consultant")) && !consultantAdded) {
            if (this.opportunity?.assignedTo != null) {
              const fullName = `${this.opportunity.assignedTo.firstName} ${this.opportunity.assignedTo.lastName}`;
              const email = this.opportunity.assignedTo.emailAddress;
              const phone = this.opportunity.assignedTo.phone;
              const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
              signers.push(signer);
              consultantAdded = true;
            }
          }
        }
      }
    }
    if (document2.content != null) {
      if ((document2.content.includes("initial.customer") || document2.content.includes("signature.customer")) && !customerAdded) {
        if (this.opportunity?.customer != null) {
          const fullName = `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
          const email = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
          const phone = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
          const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
          signers.push(signer);
          customerAdded = true;
        }
      }
      if ((document2.content.includes("initial.consultant") || document2.content.includes("signature.consultant")) && !consultantAdded) {
        if (this.opportunity?.assignedTo != null) {
          const fullName = `${this.opportunity.assignedTo.firstName} ${this.opportunity.assignedTo.lastName}`;
          const email = this.opportunity.assignedTo.emailAddress;
          const phone = this.opportunity.assignedTo.phone;
          const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
          signers.push(signer);
          consultantAdded = true;
        }
      }
    }
    return signers;
  }
  initDocuments() {
    if (this.opportunity != null) {
      let documents = [];
      for (var i = 0, len = this.opportunity.documents.length; i < len; i++) {
        const document2 = this.opportunity.documents[i];
        document2.active = false;
        if (document2.displayInSigning && (!this.customerFacing || document2.customerFacing)) {
          if (!document2.executed && document2.signers.length == 0) {
            document2.signers = this.generateSigners(document2);
          }
          documents.push(document2);
        }
      }
      documents = this.orderByPipe.transform(documents, "displayOrder", false);
      this.documents = documents;
      this.setActiveDocument(0);
      setTimeout(() => {
        this.verifyConsent();
      }, 0);
    }
  }
  finalizeConsent(signers) {
    return __async(this, null, function* () {
      if (this.opportunity != null && this.activeUser != null) {
        for (var i = 0, len = signers.length; i < len; i++) {
          const signer = signers[i];
          if (signer.consented) {
            for (var j = 0, jlen = this.opportunity.documents.length; j < jlen; j++) {
              const document2 = this.opportunity.documents[j];
              const existingSigner = document2.signers.find((x) => x.fullName == signer.fullName);
            }
            yield this.opportunityService.addSigner(this.opportunity, signer, this.activeUser);
          }
        }
      }
      this.consenting = false;
      const activeConsenter = signers.find((x) => x.fullName == this.signer);
      if (activeConsenter != null && !activeConsenter.consented) {
        this.closeView();
      }
    });
  }
  verifyConsent() {
    const consenters = [];
    for (var i = 0, len = this.documents.length; i < len; i++) {
      const document2 = this.documents[i];
      for (var j = 0, jlen = document2.signers.length; j < jlen; j++) {
        const signer = document2.signers[j];
        if (signer.consent == null) {
          const existingConsenter = consenters.find((x) => x.fullName == signer.fullName);
          if (existingConsenter == null && signer.fullName == this.signer) {
            consenters.push(signer);
          }
        }
      }
    }
    this.consenters.next(consenters);
    if (consenters.length > 0) {
      this.consenting = true;
    } else {
      this.consenting = false;
    }
  }
  // #endregion
  // #region Completion
  promptToCompleteDocuments() {
    if (this.opportunity?.customer != null) {
      this.opportunity.checkDocumentValidity();
      this.closeView();
    }
  }
  get canGoForward() {
    return !this.navigating && !this.finalizingDocument && (this.activeDocument == null || this.activeDocument.rendered);
  }
  get canGoBack() {
    return !this.navigating && !this.finalizingDocument && this.previousDocumentAvailable;
  }
  setNavigation() {
    window.clearTimeout(this.navigationDebounce);
    this.navigationDebounce = window.setTimeout(() => {
      const nextDocument = this.documents[this.activeDocumentIndex + 1];
      if (nextDocument != null) {
        this.forwardLabel = "Next Document";
      } else {
        this.forwardLabel = "Complete Documents";
      }
      if (this.activeDocument != null) {
        const previousDocument = this.documents[this.activeDocumentIndex - 1];
        if (previousDocument != null) {
          this.previousDocumentAvailable = true;
        } else {
          this.previousDocumentAvailable = false;
        }
      }
    }, 0);
  }
  goBack() {
    const previousDocument = this.documents[this.activeDocumentIndex - 1];
    if (previousDocument != null) {
      this.setActiveDocument(this.activeDocumentIndex - 1, "reverse");
    } else {
      this.back.next();
    }
  }
  goForward() {
    const nextDocument = this.documents[this.activeDocumentIndex + 1];
    if (nextDocument != null) {
      if (this.activeDocument?.validForExecution) {
        this.finalizeDocument(false).then(() => {
          this.setActiveDocument(this.activeDocumentIndex + 1, "forward");
        });
      } else {
        this.setActiveDocument(this.activeDocumentIndex + 1, "forward");
      }
    } else {
      if (this.activeDocument?.validForExecution) {
        this.finalizeDocument(false).then(() => {
          this.promptToCompleteDocuments();
        });
      } else {
        this.promptToCompleteDocuments();
      }
    }
  }
  promptToCloseView() {
    if (this.opportunity != null) {
      this.opportunity.checkDocumentValidity();
      if (this.opportunity.documentsValidForEstimate) {
        this.closeView();
      } else {
        this.uiService.prompt("Unfinished Documents", `There are still documents needing signatures. Are you sure you want to go back?`, "Yes", "No").subscribe({
          next: (confirmed) => {
            if (confirmed) {
              this.closeView();
            }
          }
        });
      }
    }
  }
  closeView() {
    this.opportunityUiService.stopSigningDocuments();
  }
  init() {
    this.watchUser();
    this.generateContent();
    this.initDocuments();
    this.setNavigation();
    setTimeout(() => {
      this.changeDetector.detectChanges();
    }, 0);
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
  }
};
_OpportunitySigningComponent.\u0275fac = function OpportunitySigningComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunitySigningComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService), \u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(ChangeDetectorRef));
};
_OpportunitySigningComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunitySigningComponent, selectors: [["opportunity-signing"]], viewQuery: function OpportunitySigningComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity", signer: "signer", customerFacing: "customerFacing" }, outputs: { back: "back", close: "close" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 31, vars: 13, consts: [["componentElm", ""], ["id", "opportunityDocuments"], [1, "primary"], [1, "secondary"], [1, "close-control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "documents"], [1, "meta"], [1, "validation"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], ["id", "consent"], [1, "bg"], [3, "consenters"], [3, "class", "rendering"], [3, "changed", "content", "opportunity", "signer", "execute", "document"], [3, "close", "consenters"]], template: function OpportunitySigningComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "main", 1, 0)(2, "header")(3, "div", 2)(4, "h3");
    \u0275\u0275text(5, " Signing Documents for ");
    \u0275\u0275elementStart(6, "em");
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(8, "h4");
    \u0275\u0275text(9);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "div", 3)(11, "button", 4);
    \u0275\u0275listener("click", function OpportunitySigningComponent_Template_button_click_11_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.promptToCloseView());
    });
    \u0275\u0275element(12, "i", 5);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(13, "div", 6);
    \u0275\u0275repeaterCreate(14, OpportunitySigningComponent_For_15_Template, 1, 1, null, null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(16, "div", 7)(17, "div", 2);
    \u0275\u0275conditionalCreate(18, OpportunitySigningComponent_Conditional_18_Template, 3, 0, "div", 8);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(19, "div", 9)(20, "button", 10);
    \u0275\u0275listener("click", function OpportunitySigningComponent_Template_button_click_20_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goBack());
    });
    \u0275\u0275element(21, "i", 11);
    \u0275\u0275elementStart(22, "label");
    \u0275\u0275text(23);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "button", 12);
    \u0275\u0275listener("click", function OpportunitySigningComponent_Template_button_click_24_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goForward());
    });
    \u0275\u0275element(25, "i", 13);
    \u0275\u0275elementStart(26, "label");
    \u0275\u0275text(27);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(28, "aside", 14);
    \u0275\u0275element(29, "div", 15);
    \u0275\u0275conditionalCreate(30, OpportunitySigningComponent_Conditional_30_Template, 1, 1, "signing-consent", 16);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate2("", ctx.opportunity == null ? null : ctx.opportunity.jobId, " - ", ctx.customerName);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" Signer: ", ctx.signer, " ");
    \u0275\u0275advance(4);
    \u0275\u0275classProp("rendering", ctx.finalizingDocument);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.documents);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx.showMissingSignaturesWarning ? 18 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canGoBack);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.backLabel);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canGoForward);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.forwardLabel);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.consenting);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.consenting ? 30 : -1);
  }
}, dependencies: [OpportunityDocumentComponent, ConsentComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-moz-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-o-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-moz-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-o-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n#opportunityDocuments[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: 0 1vw 1vw;\n  display: flex;\n  flex-direction: column;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2Alt1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%]    > em[_ngcontent-%COMP%] {\n  font-style: normal;\n  color: var(--color5Alt1);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  line-height: 1;\n  font-weight: var(--ltweight);\n  color: var(--color4Alt2);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  position: relative;\n  display: flex;\n  align-items: center;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  border: 0.1vw var(--color2) solid;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls.execution[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 100%;\n  right: 0;\n  margin-top: 0.25vw;\n  width: 100%;\n  color: var(--color2Alt2);\n  font-size: 0.6vw;\n  pointer-events: none;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .close-control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .close-control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%] {\n  flex: 1;\n  position: relative;\n  border: 0.1vw var(--color1Alt1) solid;\n  border-radius: 0.25vw;\n  background-color: var(--color1Alt5);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 2vw;\n  right: 2vw;\n  bottom: 0;\n  overflow-x: hidden;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-in[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadIn;\n  -ms-animation-name: documentLoadIn;\n  -o-animation-name: documentLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadIn;\n  animation-name: _ngcontent-%COMP%_documentLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-out[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadOut;\n  -ms-animation-name: documentLoadOut;\n  -o-animation-name: documentLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadOut;\n  animation-name: _ngcontent-%COMP%_documentLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-in-reverse[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadInReverse;\n  -ms-animation-name: documentLoadInReverse;\n  -o-animation-name: documentLoadInReverse;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadInReverse;\n  animation-name: _ngcontent-%COMP%_documentLoadInReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-out-reverse[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadOutReverse;\n  -ms-animation-name: documentLoadOutReverse;\n  -o-animation-name: documentLoadOutReverse;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadOutReverse;\n  animation-name: _ngcontent-%COMP%_documentLoadOutReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap[_ngcontent-%COMP%]     .document {\n  opacity: 1;\n  background-color: var(--color2);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents.rendering[_ngcontent-%COMP%]     .document {\n  opacity: 0.4;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents.rendering[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  pointer-events: none;\n  display: block;\n  position: absolute;\n  right: 1vw;\n  bottom: 1vw;\n  z-index: 1;\n  width: 5vw;\n  height: 5vw;\n  --fillSpeed: 1s;\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 0 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .validation[_ngcontent-%COMP%] {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.35vw 0.75vw;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .validation[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#opportunityDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n#consent[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#consent[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#consent.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#consent.active[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#consent.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#consent.closing[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=signing.component.css.map */"] });
var OpportunitySigningComponent = _OpportunitySigningComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunitySigningComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-signing", providers: [OrderByPipe], template: '<main id="opportunityDocuments" #componentElm>\n  <header>\n    <div class="primary">\n      <h3>\n        Signing Documents for <em>{{opportunity?.jobId}} - {{customerName}}</em>\n      </h3>\n      <h4>\n        Signer: {{signer}}\n      </h4>\n    </div>\n    <div class="secondary">\n      <button class="close-control" (click)="promptToCloseView()">\n        <i class="fa-solid fa-xmark"></i>\n      </button>\n    </div>\n  </header>\n  <div class="documents"\n    [class.rendering]="finalizingDocument">\n    @for (document of documents; track document) {\n      @if (document.active) {\n        <div\n          class="document-wrap {{document.uiDirection}}"\n          [class.rendering]="finalizingDocument"\n          >\n          <opportunity-document\n            (changed)="documentChanged(document)"\n            [content]="content"\n            [opportunity]="opportunity"\n            [signer]="signer"\n            [execute]="false"\n          [document]="document"></opportunity-document>\n        </div>\n      }\n    }\n  </div>\n  <div class="meta">\n    <div class="primary">\n      @if (showMissingSignaturesWarning) {\n        <div class="validation">\n          <label>\n            Document is missing signatures.\n          </label>\n        </div>\n      }\n    </div>\n    <div class="controls">\n      <button class="control" [disabled]="!canGoBack" (click)="goBack()">\n        <i class="fa-solid fa-arrow-left-long"></i>\n        <label>{{backLabel}}</label>\n      </button>\n      <button class="control success" [disabled]="!canGoForward" (click)="goForward()">\n        <i class="fa-solid fa-arrow-right-long"></i>\n        <label>{{forwardLabel}}</label>\n      </button>\n    </div>\n  </div>\n</main>\n\n<aside id="consent" [class.active]="consenting">\n  <div class="bg"></div>\n  @if (consenting) {\n    <signing-consent\n      [consenters]="consenters"\n    (close)="finalizeConsent($event)"></signing-consent>\n  }\n</aside>', styles: ["/* src/app/shared/opportunities/components/signing/signing.component.scss */\n@-webkit-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-moz-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-o-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-webkit-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-moz-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-o-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-webkit-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n#opportunityDocuments {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: 0 1vw 1vw;\n  display: flex;\n  flex-direction: column;\n}\n#opportunityDocuments > header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#opportunityDocuments > header > .primary h3 {\n  font-size: 1.2vw;\n  color: var(--color2Alt1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n#opportunityDocuments > header > .primary h3 > em {\n  font-style: normal;\n  color: var(--color5Alt1);\n}\n#opportunityDocuments > header > .primary h4 {\n  font-size: 2vw;\n  line-height: 1;\n  font-weight: var(--ltweight);\n  color: var(--color4Alt2);\n}\n#opportunityDocuments > header > .secondary {\n  display: flex;\n  align-items: center;\n}\n#opportunityDocuments > header > .secondary > .controls {\n  margin-left: 1vw;\n  position: relative;\n  display: flex;\n  align-items: center;\n}\n#opportunityDocuments > header > .secondary > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  border: 0.1vw var(--color2) solid;\n}\n#opportunityDocuments > header > .secondary > .controls > .control > i:last-child,\n#opportunityDocuments > header > .secondary > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#opportunityDocuments > header > .secondary > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#opportunityDocuments > header > .secondary > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityDocuments > header > .secondary > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityDocuments > header > .secondary > .controls > .control:first-child {\n  margin-left: 0;\n}\n#opportunityDocuments > header > .secondary > .controls.execution > .meta {\n  position: absolute;\n  top: 100%;\n  right: 0;\n  margin-top: 0.25vw;\n  width: 100%;\n  color: var(--color2Alt2);\n  font-size: 0.6vw;\n  pointer-events: none;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#opportunityDocuments > header > .secondary > .controls:first-child {\n  margin-left: 0;\n}\n#opportunityDocuments > header > .secondary > .close-control {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#opportunityDocuments > header > .secondary > .close-control > i {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#opportunityDocuments > .documents {\n  flex: 1;\n  position: relative;\n  border: 0.1vw var(--color1Alt1) solid;\n  border-radius: 0.25vw;\n  background-color: var(--color1Alt5);\n}\n#opportunityDocuments > .documents > .document-wrap {\n  position: absolute;\n  top: 0;\n  left: 2vw;\n  right: 2vw;\n  bottom: 0;\n  overflow-x: hidden;\n}\n#opportunityDocuments > .documents > .document-wrap.loading-in {\n  -moz-animation-name: documentLoadIn;\n  -ms-animation-name: documentLoadIn;\n  -o-animation-name: documentLoadIn;\n  -webkit-animation-name: documentLoadIn;\n  animation-name: documentLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments > .documents > .document-wrap.loading-out {\n  -moz-animation-name: documentLoadOut;\n  -ms-animation-name: documentLoadOut;\n  -o-animation-name: documentLoadOut;\n  -webkit-animation-name: documentLoadOut;\n  animation-name: documentLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments > .documents > .document-wrap.loading-in-reverse {\n  -moz-animation-name: documentLoadInReverse;\n  -ms-animation-name: documentLoadInReverse;\n  -o-animation-name: documentLoadInReverse;\n  -webkit-animation-name: documentLoadInReverse;\n  animation-name: documentLoadInReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments > .documents > .document-wrap.loading-out-reverse {\n  -moz-animation-name: documentLoadOutReverse;\n  -ms-animation-name: documentLoadOutReverse;\n  -o-animation-name: documentLoadOutReverse;\n  -webkit-animation-name: documentLoadOutReverse;\n  animation-name: documentLoadOutReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#opportunityDocuments > .documents > .document-wrap ::ng-deep .document {\n  opacity: 1;\n  background-color: var(--color2);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#opportunityDocuments > .documents.rendering ::ng-deep .document {\n  opacity: 0.4;\n}\n#opportunityDocuments > .documents.rendering > loader {\n  opacity: 1;\n}\n#opportunityDocuments > .documents > loader {\n  pointer-events: none;\n  display: block;\n  position: absolute;\n  right: 1vw;\n  bottom: 1vw;\n  z-index: 1;\n  width: 5vw;\n  height: 5vw;\n  --fillSpeed: 1s;\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#opportunityDocuments > .meta {\n  margin-top: 1vw;\n  padding: 0 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#opportunityDocuments > .meta > .primary > .validation {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.35vw 0.75vw;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#opportunityDocuments > .meta > .primary > .validation label {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#opportunityDocuments > .meta > .controls {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#opportunityDocuments > .meta > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityDocuments > .meta > .controls > .control > i:last-child,\n#opportunityDocuments > .meta > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#opportunityDocuments > .meta > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#opportunityDocuments > .meta > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityDocuments > .meta > .controls > .control.success {\n  background-color: var(--success);\n}\n#opportunityDocuments > .meta > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#opportunityDocuments > .meta > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#opportunityDocuments > .meta > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityDocuments > .meta > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#opportunityDocuments > .meta > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#opportunityDocuments > .meta > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#opportunityDocuments > .meta > .controls > .control:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n#consent {\n  pointer-events: none;\n}\n#consent > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent > signing-consent {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent.active {\n  pointer-events: initial;\n}\n#consent.active > .bg {\n  opacity: 1;\n}\n#consent.active > signing-consent {\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#consent.closing > .bg {\n  opacity: 0;\n}\n#consent.closing > signing-consent {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=signing.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: DocumentService }, { type: OpportunityUiService }, { type: OpportunityService }, { type: AuthRefService }, { type: OrderByPipe }, { type: ChangeDetectorRef }], { opportunity: [{
    type: Input
  }], signer: [{
    type: Input,
    args: ["signer"]
  }], customerFacing: [{
    type: Input,
    args: ["customerFacing"]
  }], back: [{
    type: Output,
    args: ["back"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunitySigningComponent, { className: "OpportunitySigningComponent" });
})();

// src/app/shared/opportunities/components/summary/summary.component.ts
var import_leaflet = __toESM(require_leaflet_src());
var _c03 = ["componentElm"];
function OpportunitySummaryComponent_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 28);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("active", ctx_r1.mapRendered);
    \u0275\u0275attribute("id", ctx_r1.mapElmId);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 9)(1, "h3");
    \u0275\u0275text(2, "Emergency");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 12);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate2(" ", ctx_r1.address.city, ", ", ctx_r1.address.regionIso3166, " ");
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 16)(1, "label");
    \u0275\u0275text(2, "Price:");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 15);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "currency");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(5, 1, ctx_r1.displayPrice, "USD"), " ");
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1, " Accepted ");
    \u0275\u0275elementEnd();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_24_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1, " Not Accepted ");
    \u0275\u0275elementEnd();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 18);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "date");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" on ", \u0275\u0275pipeBind2(2, 1, ctx_r1.opportunity.accepted_Utc, "MMM dd, yyyy h:mm a"), " ");
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_26_For_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 30);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r3 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", item_r3, " ");
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "label");
    \u0275\u0275text(2, " Attachment Items: ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 29);
    \u0275\u0275repeaterCreate(4, OpportunitySummaryComponent_Conditional_0_Conditional_26_For_5_Template, 2, 1, "span", 30, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx_r1.attachmentItems);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_27_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 32)(1, "p", 15);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r1.dispositionStatus.note);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_27_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 20)(1, "label");
    \u0275\u0275text(2, " Disposition Status ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 31)(4, "span", 15);
    \u0275\u0275text(5);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(6, OpportunitySummaryComponent_Conditional_0_Conditional_27_Conditional_6_Template, 3, 1, "div", 32);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(ctx_r1.dispositionStatus.name);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.dispositionStatus.note != null ? 6 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 35);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.acceptOpportunity());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Accept");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(4);
    \u0275\u0275property("disabled", ctx_r1.accepting);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.goToOpportunity(ctx_r1.opportunity.id));
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Open");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 34)(1, "p");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_3_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.promptToGoToOpportunity(ctx_r1.outstandingOpportunityId));
    });
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, "Go to Appointment");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(4);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r1.openStatus, " ");
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 22);
    \u0275\u0275conditionalCreate(1, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_1_Template, 3, 1, "button", 33);
    \u0275\u0275conditionalCreate(2, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_2_Template, 3, 0, "button", 24);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(3, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Conditional_3_Template, 6, 1, "div", 34);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canAccept ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canOpen ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showOpenWarning ? 3 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_1_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_1_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r7);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.promptToReopenOpportunity());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Reopen");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 22);
    \u0275\u0275conditionalCreate(1, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_1_Conditional_1_Template, 3, 0, "button", 36);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canReopoen ? 1 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_2_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_2_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.promptToReopenOpportunity());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Reopen");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 22);
    \u0275\u0275conditionalCreate(1, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_2_Conditional_1_Template, 3, 0, "button", 36);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canReopoen ? 1 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 22)(1, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_3_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.viewDetails());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "View Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_3_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.promptToReopenOpportunity());
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Reopen");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_3_Template_button_click_7_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.sendDocumentsForSignature());
    });
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Send for E-Signature");
    \u0275\u0275elementEnd()()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Conditional_7_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.promptToPrepareEstimate());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Submit Job");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 22)(1, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.viewDetails());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "View Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.promptToReopenOpportunity());
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Reopen");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(7, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Conditional_7_Template, 3, 0, "button", 36);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(7);
    \u0275\u0275conditional(ctx_r1.canPrepareEstimate ? 7 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_5_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_5_Conditional_4_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r13);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.promptToPrepareEstimate());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Prepare Estimate");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 22)(1, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_5_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r12);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.viewDetails());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "View Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(4, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_5_Conditional_4_Template, 3, 0, "button", 36);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx_r1.canPrepareEstimate ? 4 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_32_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_0_Template, 4, 3);
    \u0275\u0275conditionalCreate(1, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_1_Template, 2, 1, "div", 22);
    \u0275\u0275conditionalCreate(2, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_2_Template, 2, 1, "div", 22);
    \u0275\u0275conditionalCreate(3, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_3_Template, 10, 0, "div", 22);
    \u0275\u0275conditionalCreate(4, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_4_Template, 8, 1, "div", 22);
    \u0275\u0275conditionalCreate(5, OpportunitySummaryComponent_Conditional_0_Conditional_32_Conditional_5_Template, 5, 1, "div", 22);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.Open || ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.InProgress ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.Dispositioned ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.Canceled ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.PendingSignatures ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.PendingSubmission ? 4 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.Submitted ? 5 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.viewDetails());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "View Details");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r16 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r16);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.sendDocumentsForSignature());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Send for E-Signature");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_3_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 37);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_3_Conditional_0_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r17);
      const ctx_r1 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r1.promptToPrepareEstimate());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Submit Job");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_3_Conditional_0_Template, 3, 0, "button", 36);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275conditional(ctx_r1.canPrepareEstimate ? 0 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_33_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 22);
    \u0275\u0275conditionalCreate(1, OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_1_Template, 3, 0, "button", 24);
    \u0275\u0275conditionalCreate(2, OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_2_Template, 3, 0, "button", 36);
    \u0275\u0275conditionalCreate(3, OpportunitySummaryComponent_Conditional_0_Conditional_33_Conditional_3_Template, 1, 1);
    \u0275\u0275elementStart(4, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_33_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.goToOpportunity(ctx_r1.opportunity.id));
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Open");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.Submitted || ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.PendingSignatures || ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.PendingSubmission ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.PendingSignatures ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.status == ctx_r1.OpportunityStatus.PendingSubmission ? 3 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_35_Template(rf, ctx) {
  if (rf & 1) {
    const _r18 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_35_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r18);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.viewLedger());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "View History");
    \u0275\u0275elementEnd()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Conditional_37_Template(rf, ctx) {
  if (rf & 1) {
    const _r19 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 26)(1, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Conditional_37_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r19);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.restoreFromServer());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Restore from Server");
    \u0275\u0275elementEnd()()();
  }
}
function OpportunitySummaryComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 4);
    \u0275\u0275element(2, "canvas", 5);
    \u0275\u0275conditionalCreate(3, OpportunitySummaryComponent_Conditional_0_Conditional_3_Template, 1, 3, "div", 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "div", 7)(5, "div", 8);
    \u0275\u0275conditionalCreate(6, OpportunitySummaryComponent_Conditional_0_Conditional_6_Template, 3, 0, "div", 9);
    \u0275\u0275elementStart(7, "div", 10)(8, "h2");
    \u0275\u0275text(9);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "div", 11);
    \u0275\u0275conditionalCreate(11, OpportunitySummaryComponent_Conditional_0_Conditional_11_Template, 2, 2, "span", 12);
    \u0275\u0275text(12, " on ");
    \u0275\u0275elementStart(13, "span", 13);
    \u0275\u0275text(14);
    \u0275\u0275pipe(15, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "div", 14)(17, "label");
    \u0275\u0275text(18, "Job:");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(19, "span", 15);
    \u0275\u0275text(20);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(21, OpportunitySummaryComponent_Conditional_0_Conditional_21_Template, 6, 4, "div", 16);
    \u0275\u0275elementStart(22, "div", 17);
    \u0275\u0275conditionalCreate(23, OpportunitySummaryComponent_Conditional_0_Conditional_23_Template, 2, 0, "label");
    \u0275\u0275conditionalCreate(24, OpportunitySummaryComponent_Conditional_0_Conditional_24_Template, 2, 0, "label");
    \u0275\u0275conditionalCreate(25, OpportunitySummaryComponent_Conditional_0_Conditional_25_Template, 3, 4, "span", 18);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(26, OpportunitySummaryComponent_Conditional_0_Conditional_26_Template, 6, 0, "div", 19);
    \u0275\u0275conditionalCreate(27, OpportunitySummaryComponent_Conditional_0_Conditional_27_Template, 7, 2, "div", 20);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "div", 21)(29, "div")(30, "span", 15);
    \u0275\u0275text(31);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(32, OpportunitySummaryComponent_Conditional_0_Conditional_32_Template, 6, 6);
    \u0275\u0275conditionalCreate(33, OpportunitySummaryComponent_Conditional_0_Conditional_33_Template, 7, 3, "div", 22);
    \u0275\u0275elementStart(34, "div", 23);
    \u0275\u0275conditionalCreate(35, OpportunitySummaryComponent_Conditional_0_Conditional_35_Template, 3, 0, "button", 24);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(36, "div", 25);
    \u0275\u0275conditionalCreate(37, OpportunitySummaryComponent_Conditional_0_Conditional_37_Template, 4, 0, "div", 26);
    \u0275\u0275elementStart(38, "div", 26)(39, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Template_button_click_39_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.remoteExportOpportunity());
    });
    \u0275\u0275elementStart(40, "label");
    \u0275\u0275text(41, "Export to Server");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(42, "div", 26)(43, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_0_Template_button_click_43_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.exportOpportunity());
    });
    \u0275\u0275elementStart(44, "label");
    \u0275\u0275text(45, "Export to Device");
    \u0275\u0275elementEnd()()()()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.showMapRender ? 3 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.opportunity.isEmergency ? 6 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate2("", ctx_r1.customer == null ? null : ctx_r1.customer.firstName, " ", ctx_r1.customer == null ? null : ctx_r1.customer.lastName);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.address != null ? 11 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(15, 23, ctx_r1.opportunity.scheduled_Utc, "MMM dd, yyyy h:mm a"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", ctx_r1.opportunity.jobId, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.hasPrice ? 21 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("accepted", ctx_r1.accepted);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.accepted ? 23 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.accepted ? 24 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.opportunity.accepted_Utc != null && ctx_r1.accepted ? 25 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.hasAttachmentItems ? 26 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.dispositionStatus != null ? 27 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("status ", ctx_r1.opportunity.status));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r1.status, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.management ? 32 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.management ? 33 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.isAdmin || ctx_r1.management ? 35 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.isAdmin ? 37 : -1);
  }
}
function OpportunitySummaryComponent_Conditional_1_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 43);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(2, 1, ctx_r1.exportProgress), "%");
  }
}
function OpportunitySummaryComponent_Conditional_1_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 44);
    \u0275\u0275text(1, "Processing");
    \u0275\u0275elementEnd();
  }
}
function OpportunitySummaryComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "aside", 38);
    \u0275\u0275element(1, "div", 39);
    \u0275\u0275elementStart(2, "div", 40)(3, "button", 27);
    \u0275\u0275listener("click", function OpportunitySummaryComponent_Conditional_1_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r20);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.promptToStopExporting());
    });
    \u0275\u0275element(4, "i", 41);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 42);
    \u0275\u0275conditionalCreate(6, OpportunitySummaryComponent_Conditional_1_Conditional_6_Template, 3, 3, "span", 43);
    \u0275\u0275conditionalCreate(7, OpportunitySummaryComponent_Conditional_1_Conditional_7_Template, 2, 0, "span", 44);
    \u0275\u0275element(8, "loader", 45);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Preparing & Exporting Appointment");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingExport);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx_r1.showExportProgress ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.showExportProgress ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("progress", true)("percent", ctx_r1.exportProgress);
  }
}
function OpportunitySummaryComponent_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 46);
    \u0275\u0275element(1, "div", 39);
    \u0275\u0275elementStart(2, "div", 40)(3, "div", 42);
    \u0275\u0275element(4, "loader", 47);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Restoring Appointment");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingRestore);
    \u0275\u0275advance(4);
    \u0275\u0275property("fill", true);
  }
}
function OpportunitySummaryComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 48);
    \u0275\u0275element(1, "div", 39);
    \u0275\u0275elementStart(2, "div", 40)(3, "div", 42);
    \u0275\u0275element(4, "loader", 47);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Updating Appointment");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingSyncLedger);
    \u0275\u0275advance(4);
    \u0275\u0275property("fill", true);
  }
}
var _OpportunitySummaryComponent = class _OpportunitySummaryComponent {
  constructor(uiService, opportunityService, opportunityUiService, storageService, authRefService, deviceRouteService, orderByPipe, datePipe, contentService, reminderService) {
    this.uiService = uiService;
    this.opportunityService = opportunityService;
    this.opportunityUiService = opportunityUiService;
    this.storageService = storageService;
    this.authRefService = authRefService;
    this.deviceRouteService = deviceRouteService;
    this.orderByPipe = orderByPipe;
    this.datePipe = datePipe;
    this.contentService = contentService;
    this.reminderService = reminderService;
    this.OpportunityStatus = OpportunityStatus;
    this.exporting = false;
    this.closingExport = false;
    this.exportProgress = new BehaviorSubject(0);
    this.showExportProgress = true;
    this.restoringFromServer = false;
    this.closingRestore = false;
    this.activeUser = null;
    this.syncingLedger = false;
    this.closingSyncLedger = false;
    this.displayPrice = 0;
    this.mapRendered = false;
    this.accepting = false;
    this.canOpen = false;
    this.initializedOpen = false;
    this.attachmentItems = [];
    this.management = false;
  }
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  get status() {
    return this.opportunity?.friendlyStatus;
  }
  checkStatus() {
    this.checkIsSubmitted();
    this.checkShouldDisposition();
    this.checkShouldComplete();
  }
  get canRestoreFromServer() {
    return !this.restoringFromServer;
  }
  stopRestoringFromServer() {
    window.clearTimeout(this.restoringTimeout);
    this.closingRestore = true;
    this.exportingTimer = window.setTimeout(() => {
      this.restoringFromServer = false;
      this.closingRestore = false;
    }, 250);
  }
  restoreFromServer() {
    if (this.opportunity != null && !this.restoringFromServer) {
      const opportunity = this.opportunity;
      this.uiService.prompt("Caution!", `Restoring an Appointment will overwrite all unsaved changes to
                    your appointment with the latest information from the server.
                    This is not recoverable. Are you sure you want to continue?`, "Yes", "No, Go Back").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.restoringFromServer = true;
            this.opportunityService.restoreOpportunity(opportunity.id).subscribe({
              next: (opportunity2) => {
                this.opportunity = opportunity2;
                this.initOpportunity();
                this.stopRestoringFromServer();
              },
              error: () => {
                this.uiService.prompt("Unable to Restore", "There was an issue restoring the Appointment from the server. Your local data has not been overwritten.", "Okay").subscribe({
                  next: (confirmed2) => {
                    this.stopRestoringFromServer();
                  }
                });
              }
            });
          }
        }
      });
    }
  }
  remoteExportOpportunity() {
    if (this.opportunity != null) {
      const opportunity = this.opportunity;
      if (!this.exporting) {
        this.uiService.prompt("Export Appointment to Server?", "Manually exporting an appointment is intended for support situations and may take a moment to complete. Are you sure you want to manually sync?", "Yes", "No").subscribe({
          next: (confirmed) => {
            if (confirmed) {
              this.exporting = true;
              this.exportingTimeout = window.setTimeout(() => {
                this.uiService.prompt("Taking a While?", "Sending the quote seems to be taking a while. You may be on a poor connection or experiencing other issues. Do you want to cancel and try again later?", "Yes, Try Later", "No, Keep Waiting").subscribe({
                  next: (confirmed2) => {
                    if (confirmed2) {
                      this.stopExportingOpportunity();
                    }
                  }
                });
              }, 45e3);
              setTimeout(() => {
                const jobId = `${opportunity.jobId}`;
                const fileName = `${jobId}-${(/* @__PURE__ */ new Date()).toISOString()}`;
                this.opportunityService.getLedgerEntries(opportunity.id).subscribe({
                  next: (entries) => {
                    this.contentService.compressData(new ExportedOpportunity(opportunity, entries), `${fileName}.json`).then((compressedAppointment) => {
                      this.opportunityService.remoteExportOpportunity(jobId, compressedAppointment).subscribe({
                        next: (e) => {
                          if ("progress" in e) {
                            this.exportProgress.next(e.progress);
                            if (e.progress == 100) {
                              this.showExportProgress = false;
                            } else {
                              this.showExportProgress = true;
                            }
                          } else {
                            window.clearTimeout(this.exportingTimeout);
                            this.stopExportingOpportunity();
                            this.uiService.prompt("Appointment Synced", "The appointment data was successfully synced.", "Okay").subscribe({
                              next: () => {
                              }
                            });
                          }
                        },
                        error: () => {
                          window.clearTimeout(this.exportingTimeout);
                          this.uiService.prompt("Failed to Sync", "There was an issue syncing your appointment. Please try again or to contact support.", "Okay").subscribe({
                            next: () => {
                              this.stopExportingOpportunity();
                            }
                          });
                        }
                      });
                    });
                  }
                });
              }, 16);
            } else {
              this.stopExportingOpportunity();
            }
          }
        });
      }
    }
  }
  promptToStopExporting() {
    this.uiService.prompt("Don't Want to Wait?", "Your appointment export may stillb e sent. Are you sure you want to stop waiting?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.stopExportingOpportunity();
        }
      }
    });
  }
  stopExportingOpportunity() {
    window.clearTimeout(this.exportingTimer);
    this.closingExport = true;
    this.exportingTimer = window.setTimeout(() => {
      this.exporting = false;
      this.closingExport = false;
      this.showExportProgress = true;
      this.exportProgress.next(0);
    }, 250);
  }
  exportOpportunity() {
    return __async(this, null, function* () {
      if (this.opportunity != null && !this.exporting) {
        const opportunity = this.opportunity;
        this.uiService.prompt("Export Appointment to Device?", "Exporting the raw appointment data is intended for support scenarios. Are you sure you want to export the appointment data to your device?", "Yes", "No").subscribe({
          next: (confirmed) => __async(this, null, function* () {
            if (confirmed) {
              this.exporting = true;
              setTimeout(() => {
                this.opportunityService.exportOppotunity(opportunity).then(() => {
                  this.stopExportingOpportunity();
                  this.uiService.prompt("Appointment Data Exported", `Your appointment data has been saved. Please contact support for futher instructions.`, "Okay").subscribe({ next: () => {
                  } });
                }).catch(() => {
                  this.stopExportingOpportunity();
                  this.uiService.prompt("Failed to Export", `There was an issue exporting your appointment data. Please try again or contact support.`, "Okay").subscribe({ next: () => {
                  } });
                });
              }, 16);
            } else {
              this.stopExportingOpportunity();
            }
          })
        });
      }
    });
  }
  initOpportunity() {
    if (this.opportunity != null) {
      this.checkStatus();
      this.initMap();
      this.initPricing();
      this.initAttachmentItems();
      this.initCanOpen();
    }
  }
  // #endregion
  // #region Documents
  sendDocumentsForSignature() {
    if (this.opportunity != null) {
      this.opportunityUiService.startSendingDocuments(this.opportunity);
    }
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
        if (this.activeUser != null) {
          this.activeUser.phone = "+18014997396";
        }
        this.initOpportunity();
      }
    });
  }
  // #endregion
  // #region Dispositioning
  get isDispositioned() {
    return this.opportunity?.dispositionStatus != null;
  }
  get dispositionStatus() {
    return this.opportunity?.dispositionStatus;
  }
  get canReopoen() {
    return this.opportunity?.status == OpportunityStatus.Dispositioned;
  }
  promptToReopenOpportunity() {
    if (this.opportunity != null && this.activeUser != null) {
      const opportunity = this.opportunity;
      const activeUser = this.activeUser;
      switch (this.opportunity.status) {
        case OpportunityStatus.Dispositioned:
          {
            const dispositionStatus = this.opportunity.dispositionStatus?.name ?? "Other";
            this.uiService.prompt("Reopen Appointment?", `This appointment was previously dispositioned as ${dispositionStatus}. Are you sure you want to reopen it?`, "Yes", "No").subscribe({
              next: (confirmed) => {
                if (confirmed) {
                  this.opportunityService.updateStatus(opportunity, OpportunityStatus.Open, activeUser).then(() => {
                    this.initCanOpen();
                  });
                }
              }
            });
          }
          break;
        case OpportunityStatus.PendingSignatures:
        case OpportunityStatus.PendingSubmission:
          {
            this.uiService.prompt("Reopen Appointment?", `This is in a completed state. If you reopen it, any previously entered information, negotiated price, or signed documents
                            may be invalidated. Are you sure you want to reopen the appointment?`, "Yes", "No").subscribe({
              next: (confirmed) => {
                if (confirmed) {
                  this.opportunityService.updateStatus(opportunity, OpportunityStatus.Open, activeUser).then(() => {
                    this.initCanOpen();
                  });
                }
              }
            });
          }
          break;
        case OpportunityStatus.Canceled:
          {
            this.uiService.prompt("Reopen Appointment?", `This appointment was previously canceled. Are you sure you want to reopen it?`, "Yes", "No").subscribe({
              next: (confirmed) => {
                if (confirmed) {
                  this.opportunityService.updateStatus(opportunity, OpportunityStatus.Open, activeUser).then(() => {
                    this.initCanOpen();
                  });
                }
              }
            });
          }
          break;
      }
    }
  }
  get canSyncLedger() {
    return !this.syncingLedger;
  }
  stopSyncingLedger() {
    window.clearTimeout(this.syncingLedgerTimeout);
    this.closingSyncLedger = true;
    this.syncingLedgerTimeout = window.setTimeout(() => {
      this.syncingLedger = false;
      this.closingSyncLedger = false;
    }, 250);
  }
  syncLedger() {
    if (this.opportunity != null && !this.syncingLedger) {
      const opportunity = this.opportunity;
      this.uiService.prompt("Check for Updates?", "Would you like to check for any updates to this appointment that aren't yet on your device? This may take some time for larger appointments.", "Yes", "No, Go Back").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.syncingLedger = true;
            this.opportunityService.syncOpportunity(opportunity).subscribe({
              next: (opportunity2) => {
                this.opportunity = opportunity2;
                this.initOpportunity();
                this.stopSyncingLedger();
              },
              error: () => {
                this.uiService.prompt("Unable to Sync", "There was an issue checking for updates. Please try again or contact support.", "Okay").subscribe({
                  next: (confirmed2) => {
                    this.stopSyncingLedger();
                  }
                });
              }
            });
          }
        }
      });
    }
  }
  viewLedger() {
    if (this.opportunity != null) {
      this.opportunityUiService.startViewingLedger(this.opportunity);
    }
  }
  // #endregion
  // #region Details
  viewDetails() {
    if (this.opportunity != null) {
      this.opportunityUiService.viewDetails(this.opportunity);
    }
  }
  // #endregion
  // #region Estimates
  get canPrepareEstimate() {
    return this.opportunity != null && this.opportunity.status == OpportunityStatus.PendingSubmission && this.opportunity.customPrice?.finalPrice != null && this.opportunity.customPrice?.finalPrice > 0;
  }
  checkIsSubmitted() {
    if (this.opportunity != null) {
      const opportunity = this.opportunity;
      this.storageService.getOpportunityLedgerEntriesByType(this.opportunity.id, OpportunityLedgerEntryType.Status).then((entries) => {
        for (var i = 0, len = entries.length; i < len; i++) {
          const entry = entries[i];
          if (entry.body == "Submitted") {
            opportunity.status = OpportunityStatus.Submitted;
          }
        }
      });
    }
  }
  checkShouldComplete() {
    if (this.opportunity != null && this.opportunity.status != OpportunityStatus.PendingSubmission && this.opportunity.status != OpportunityStatus.Submitted) {
      this.opportunity.checkPaymentsValidity();
      this.opportunity.checkDocumentValidity();
      if (this.opportunity.paymentsValidForEstimate && this.opportunity.documentsValidForEstimate) {
        this.opportunity.status = OpportunityStatus.PendingSubmission;
      }
    }
  }
  promptToPrepareEstimate() {
    if (this.opportunity != null) {
      this.opportunityUiService.startPreparingEstimate(this.opportunity);
    }
  }
  // #endregion
  // #region Customer
  get customer() {
    return this.opportunity?.customer;
  }
  get hasPrice() {
    return this.displayPrice != 0;
  }
  initPricing() {
    this.displayPrice = this.opportunity?.customPrice?.finalPrice ?? this.opportunity?.price?.finalPrice ?? 0;
  }
  // #endregion
  // #region Address
  get address() {
    return this.opportunity?.property?.address;
  }
  // #endregion
  // #region Issues
  get hasIssues() {
    return this.opportunity?.opportunityPlumbingIssues != null && this.opportunity.opportunityPlumbingIssues.length > 0;
  }
  // #endregion
  // #region Contact
  get email() {
    const contactInfo = this.opportunity?.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Email) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasEmail() {
    return this.email != null;
  }
  get phone() {
    const contactInfo = this.opportunity?.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Phone) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasPhone() {
    return this.email != null;
  }
  get mapElmId() {
    return `map${this.opportunity?.id}`;
  }
  get mapLink() {
    return `https://www.google.com/maps/dir/?api=1&destination=${this.mappingAddress}`;
  }
  get friendlyAddress() {
    return this.address?.friendlyAddress;
  }
  get mappingAddress() {
    return this.address?.mappingAddress;
  }
  get showMapRender() {
    return !this.restoringFromServer;
  }
  initMap() {
    setTimeout(() => {
      if (this.mappingAddress != null && this.mapElmId != null) {
        this.map = new import_leaflet.Map(this.mapElmId, {
          zoomControl: false,
          dragging: false,
          attributionControl: false
        }).setView([37.7749, -122.4194], 13);
        (0, import_leaflet.tileLayer)("https://{s}.basemaps.cartocdn.com/rastertiles/voyager/{z}/{x}/{y}{r}.png", {
          subdomains: "abcd",
          maxZoom: 13
        }).addTo(this.map);
        this.mapAddress(this.mappingAddress);
      }
    }, 300);
  }
  mapAddress(address, retries = 0) {
    this.opportunityService.getCoordinatesForAddress(address).subscribe({
      next: (coords) => {
        if (this.map != null) {
          const coordinates = new import_leaflet.LatLng(coords.lat, coords.lon);
          this.map.setView(coordinates, 15);
          (0, import_leaflet.marker)(coordinates, {
            icon: (0, import_leaflet.icon)({
              iconSize: [25, 41],
              iconAnchor: [13, 41],
              iconUrl: "assets/images/maps/marker.svg"
            })
          }).bindPopup(`<b>${address}</b>`).addTo(this.map);
          this.mapRendered = true;
        }
      },
      error: () => {
        if (retries < 3) {
          setTimeout(() => {
            this.mapAddress(address, retries + 1);
          }, 500);
        } else {
          this.mapRendered = false;
        }
      }
    });
  }
  get accepted() {
    return this.opportunity?.accepted ?? false;
  }
  acceptOpportunity() {
    if (this.opportunity != null && !this.accepting && this.activeUser != null) {
      this.accepting = true;
      this.opportunityService.acceptOpportunity(this.opportunity, this.activeUser).then(() => {
        this.accepting = false;
        this.initCanOpen();
      }).catch(() => {
        this.accepting = false;
      });
    }
  }
  get canAccept() {
    return this.opportunity != null && !this.opportunity.accepted && !this.management;
  }
  get showOpenWarning() {
    return !this.canOpen && this.opportunity != null && this.initializedOpen && this.outstandingOpportunityId != null && this.opportunity.accepted;
  }
  goToOpportunity(id) {
    this.deviceRouteService.viewRouteByType("Opportunity", [id], true);
  }
  promptToGoToOpportunity(id) {
    if (id != null) {
      this.uiService.prompt("Open Outstanding Appointment?", "Do you want to go to your outstanding appointment?", "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.goToOpportunity(id);
          }
        }
      });
    }
  }
  /* TEMPORARY TO AVOID CONSULTANT CONFUSION */
  checkShouldDisposition() {
    if (this.opportunity != null && (this.opportunity.status == OpportunityStatus.InProgress || this.opportunity.status == OpportunityStatus.Open) && this.opportunity.scheduled_Utc != null && this.opportunity.assignedTo != null && this.opportunity.assignedTo?.id == this.activeUser?.id && this.activeUser != null) {
      const opportunity = this.opportunity;
      const activeUser = this.activeUser;
      const assignedTo = this.opportunity.assignedTo;
      const delta = /* @__PURE__ */ new Date("2025-12-28");
      if (this.opportunity.scheduled_Utc <= delta) {
        const otherDisposition = this.opportunity.availableDispositionStatuses.find((x) => x.name == "Other");
        if (otherDisposition != null) {
          const dispositionStatus = {
            statusId: otherDisposition.id,
            name: otherDisposition.name,
            followUp: false,
            followUp_Utc: void 0,
            note: "Auto-dispositioned previously left appointment.",
            created_Utc: /* @__PURE__ */ new Date(),
            lastUpdated_Utc: /* @__PURE__ */ new Date()
          };
          this.opportunityService.addDispositionStatus(opportunity, dispositionStatus, activeUser).then(() => {
            this.opportunityService.updateStatus(opportunity, OpportunityStatus.Dispositioned, activeUser);
            this.reminderService.createReminder(assignedTo, assignedTo, `Job ${opportunity.jobId} - ${dispositionStatus.name}`, "Auto-dispositioned previously left appointment.", ReminderPriority.Critical, /* @__PURE__ */ new Date(), opportunity.id, ReminderReferenceType.Appointment);
          });
        }
      }
    }
  }
  initCanOpen() {
    return __async(this, null, function* () {
      if (this.opportunity?.scheduled_Utc != null) {
        if (this.management || this.opportunity.status == OpportunityStatus.InProgress && this.opportunity.accepted) {
          this.canOpen = true;
        } else {
          const price = this.opportunity.customPrice ?? this.opportunity.price;
          if (price?.finalPrice != null && price.finalPrice > 0) {
            this.canOpen = true;
          } else {
            const activeUser = this.authRefService.user.getValue();
            if (activeUser != null) {
              const startDate = "2020-01-01";
              const scheduled = new Date(this.opportunity.scheduled_Utc);
              const endYear = scheduled.getFullYear();
              const endMonth = scheduled.getMonth() + 1;
              let endMonthStr = `${endMonth}`;
              if (endMonth < 10) {
                endMonthStr = `0${endMonth}`;
              }
              const endDate = scheduled.getDate();
              let endDateStr = `${endDate}`;
              if (endDate < 10) {
                endDateStr = `0${endDate}`;
              }
              const mergedEndDate = `${endYear}-${endMonthStr}-${endDateStr}`;
              this.opportunityService.getOpportunitiesForDateRange(startDate, mergedEndDate, activeUser.id).subscribe({
                next: (opportunities) => {
                  if (this.opportunity != null) {
                    const sorted = this.orderByPipe.transform(opportunities, "scheduled_Utc", true);
                    let hasUnfinishedAppointment = false;
                    for (var i = 0, len = sorted.length; i < len; i++) {
                      const prev = sorted[i];
                      if (prev.id != this.opportunity.id && prev.scheduled_Utc != null && this.opportunity.scheduled_Utc != null && prev.scheduled_Utc < this.opportunity.scheduled_Utc) {
                        if (prev.status == OpportunityStatus.Open) {
                          const scheduled2 = this.datePipe.transform(prev.scheduled_Utc, "MMMM dd");
                          const customerName = prev.customer?.lastName;
                          this.openStatus = `Unavailable. Your appointment on ${scheduled2} (${prev.jobId} ${customerName}) has not been dispositioned.`;
                          this.outstandingOpportunityId = prev.id;
                          hasUnfinishedAppointment = true;
                          break;
                        }
                      }
                    }
                    if (!hasUnfinishedAppointment && this.opportunity.status == OpportunityStatus.Open && this.opportunity.accepted) {
                      this.canOpen = true;
                    }
                  }
                }
              });
            }
          }
        }
      }
      this.initializedOpen = true;
    });
  }
  get hasAttachmentItems() {
    return this.attachmentItems.length > 0;
  }
  initAttachmentItems() {
    if (this.opportunity?.price != null) {
      this.opportunity.price.details.forEach((detail) => {
        detail.lineItems.forEach((lineItem) => {
          if (lineItem.isAttachment) {
            if (!this.attachmentItems.includes(lineItem.skuCategory)) {
              this.attachmentItems.push(lineItem.skuCategory);
            }
          }
        });
      });
    }
  }
  // #endregion
  // #region Summary
  get showSummary() {
    return this.opportunity != null && this.opportunity.status == OpportunityStatus.Submitted;
  }
  // #endregion
  // #region Admin
  get isAdmin() {
    return this.activeUser != null && this.activeUser.emailAddress == "jeffrey.wilbur@repipespecialists.com";
  }
  init() {
    this.watchUser();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
  }
};
_OpportunitySummaryComponent.\u0275fac = function OpportunitySummaryComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunitySummaryComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(StorageService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(ReminderService));
};
_OpportunitySummaryComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunitySummaryComponent, selectors: [["opportunity-summary"]], viewQuery: function OpportunitySummaryComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity", management: "management" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe,
  DatePipe
])], decls: 4, vars: 4, consts: [[1, "opportunity"], ["id", "exportingOpportunity", 3, "closing"], ["id", "restoringOpportunity", 3, "closing"], ["id", "syncingOpportunity", 3, "closing"], [1, "map"], ["width", "5", "height", "3"], [1, "render", 3, "active"], [1, "content"], [1, "primary"], [1, "emergency"], [1, "customer"], [1, "meta"], [1, "address"], [1, "time"], [1, "job"], [1, "value"], [1, "price"], [1, "acceptance"], [1, "date"], [1, "attachments"], [1, "disposition"], [1, "secondary"], [1, "controls"], [1, "sub-controls"], [1, "control"], [1, "data-export"], [1, "export"], [1, "control", 3, "click"], [1, "render"], [1, "items"], [1, "item"], [1, "status"], [1, "note"], [1, "control", "alternate", 3, "disabled"], [1, "warning"], [1, "control", "alternate", 3, "click", "disabled"], [1, "control", "alternate"], [1, "control", "alternate", 3, "click"], ["id", "exportingOpportunity"], [1, "bg"], [1, "modal"], [1, "fa-solid", "fa-xmark"], [1, "loader"], [1, "progress"], [1, "processing"], [3, "progress", "percent"], ["id", "restoringOpportunity"], [3, "fill"], ["id", "syncingOpportunity"]], template: function OpportunitySummaryComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, OpportunitySummaryComponent_Conditional_0_Template, 46, 26, "div", 0);
    \u0275\u0275conditionalCreate(1, OpportunitySummaryComponent_Conditional_1_Template, 11, 6, "aside", 1);
    \u0275\u0275conditionalCreate(2, OpportunitySummaryComponent_Conditional_2_Template, 7, 3, "aside", 2);
    \u0275\u0275conditionalCreate(3, OpportunitySummaryComponent_Conditional_3_Template, 7, 3, "aside", 3);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.opportunity != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.exporting ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.restoringFromServer ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.syncingLedger ? 3 : -1);
  }
}, dependencies: [LoaderComponent, AsyncPipe, CurrencyPipe, DatePipe], styles: ['\n\n.opportunity[_ngcontent-%COMP%] {\n  display: flex;\n  position: relative;\n  z-index: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%] {\n  position: relative;\n  width: 25%;\n  z-index: 0;\n  background-color: var(--color6);\n}\n.opportunity[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.3s linear;\n  -o-transition: opacity 0.3s linear;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear;\n}\n.opportunity[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%]    > .render.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 1vw;\n  flex: 1;\n  display: flex;\n  align-items: flex-start;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  flex: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .emergency[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color3) solid;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.Canceled[_ngcontent-%COMP%] {\n  border-left-color: var(--color1);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.Canceled[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.Canceled[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--color1Alt4);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%] {\n  border-left-color: var(--color5);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--color5Alt4);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .address[_ngcontent-%COMP%] {\n  color: var(--color3Alt4);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .time[_ngcontent-%COMP%] {\n  color: var(--color3Alt4);\n  white-space: nowrap;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .emergency[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color1) solid;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--errorAlt3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance.accepted[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--successAlt3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%] {\n  margin-right: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n  position: relative;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:after {\n  content: ", ";\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:last-of-type {\n  margin-right: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:last-of-type:after {\n  content: "";\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-weight: var(--stronger);\n  font-size: 1.2vw;\n  color: var(--color5);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-weight: var(--stdweight);\n  font-size: 1.2vw;\n  font-style: italic;\n  color: var(--color1);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  width: 15vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%] {\n  margin-bottom: 2vw;\n  text-align: right;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .total[_ngcontent-%COMP%] {\n  display: inline-block;\n  font-size: 2vw;\n  line-height: 1;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--color3);\n  border-radius: 999px;\n  border: 0.1vw var(--color3Alt3) solid;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.open[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.open[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%] {\n  background-color: rgba(var(--error-raw), 0.1);\n  border: 0.125vw var(--error) solid;\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  color: var(--errorAlt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n  text-align: center;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--error);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  padding: 0.25vw 1vw;\n  border-radius: 0.5vw;\n  background-color: rgba(var(--success-raw), 0.2);\n  border: 0.125vw var(--color1) solid;\n  margin-bottom: 1vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  text-align: center;\n  display: block;\n  font-size: 1.1vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-align: center;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Open[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Open[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Dispositioned[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-color: var(--color5);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Dispositioned[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Submitted[_ngcontent-%COMP%] {\n  background-color: rgba(var(--success-raw), 0.1);\n  border-color: var(--success);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Submitted[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--successAlt4);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .sub-controls[_ngcontent-%COMP%] {\n  margin-top: 3vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .sub-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  background-color: var(--color4Alt4);\n  border-radius: 999px;\n  border: 0.1vw var(--color3Alt3) solid;\n  padding: 0.2vw 2vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .sub-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .sub-controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .sub-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .sub-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1Alt2);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  text-align: right;\n  display: flex;\n  align-items: center;\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.opportunity[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  font-size: 1vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n}\n@-webkit-keyframes _ngcontent-%COMP%_exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: exportLoadIn;\n  -ms-animation-name: exportLoadIn;\n  -o-animation-name: exportLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_exportLoadIn;\n  animation-name: _ngcontent-%COMP%_exportLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%] {\n  font-size: 4vw;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#exportingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#restoringOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#syncingOpportunity[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#exportingOpportunity.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#restoringOpportunity.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#syncingOpportunity.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingOpportunity.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#restoringOpportunity.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#syncingOpportunity.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  -moz-animation-name: exportLoadOut;\n  -ms-animation-name: exportLoadOut;\n  -o-animation-name: exportLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_exportLoadOut;\n  animation-name: _ngcontent-%COMP%_exportLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=summary.component.css.map */'] });
var OpportunitySummaryComponent = _OpportunitySummaryComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunitySummaryComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-summary", providers: [
      OrderByPipe,
      DatePipe
    ], template: '@if (opportunity != null) {\n  <div class="opportunity">\n    <div class="map">\n      <canvas width="5" height="3"></canvas>\n      @if (showMapRender) {\n        <div\n          class="render"\n          [class.active]="mapRendered"\n          [attr.id]="mapElmId"\n        ></div>\n      }\n    </div>\n    <div class="content">\n      <div class="primary">\n        @if (opportunity.isEmergency) {\n          <div class="emergency">\n            <h3>Emergency</h3>\n          </div>\n        }\n        <div class="customer">\n          <h2>{{ customer?.firstName }} {{ customer?.lastName }}</h2>\n        </div>\n        <div class="meta">\n          @if (address != null) {\n            <span class="address">\n              {{ address.city }}, {{ address.regionIso3166 }}\n            </span>\n          }\n          on\n          <span class="time">\n            {{ opportunity.scheduled_Utc | date: "MMM dd, yyyy h:mm a" }}\n          </span>\n        </div>\n        <div class="job">\n          <label>Job:</label>\n          <span class="value">\n            {{ opportunity.jobId }}\n          </span>\n        </div>\n        @if (hasPrice) {\n          <div class="price">\n            <label>Price:</label>\n            <span class="value">\n              {{ displayPrice | currency: "USD" }}\n            </span>\n          </div>\n        }\n        <div class="acceptance" [class.accepted]="accepted">\n          @if (accepted) {\n            <label> Accepted </label>\n          }\n          @if (!accepted) {\n            <label> Not Accepted </label>\n          }\n          @if (opportunity.accepted_Utc != null && accepted) {\n            <span class="date">\n              on {{ opportunity.accepted_Utc | date: "MMM dd, yyyy h:mm a" }}\n            </span>\n          }\n        </div>\n        @if (hasAttachmentItems) {\n          <div class="attachments">\n            <label> Attachment Items: </label>\n            <div class="items">\n              @for (item of attachmentItems; track item) {\n                <span class="item">\n                  {{ item }}\n                </span>\n              }\n            </div>\n          </div>\n        }\n        @if (dispositionStatus != null) {\n          <div class="disposition">\n            <label> Disposition Status </label>\n            <div class="status">\n              <span class="value">{{ dispositionStatus.name }}</span>\n            </div>\n            @if (dispositionStatus.note != null) {\n              <div class="note">\n                <p class="value">{{ dispositionStatus.note }}</p>\n              </div>\n            }\n          </div>\n        }\n      </div>\n      <div class="secondary">\n        <div class="status {{ opportunity.status }}">\n          <span class="value">\n            {{ status }}\n          </span>\n        </div>\n        @if (!management) {\n          @if (\n            opportunity.status == OpportunityStatus.Open ||\n            opportunity.status == OpportunityStatus.InProgress\n          ) {\n            <div class="controls">\n              @if (canAccept) {\n                <button\n                  class="control alternate"\n                  [disabled]="accepting"\n                  (click)="acceptOpportunity()"\n                >\n                  <label>Accept</label>\n                </button>\n              }\n              @if (canOpen) {\n                <button\n                  class="control"\n                  (click)="goToOpportunity(opportunity.id)"\n                >\n                  <label>Open</label>\n                </button>\n              }\n            </div>\n            @if (showOpenWarning) {\n              <div class="warning">\n                <p>\n                  {{ openStatus }}\n                </p>\n                <button\n                  class="control"\n                  (click)="promptToGoToOpportunity(outstandingOpportunityId)"\n                >\n                  <label>Go to Appointment</label>\n                </button>\n              </div>\n            }\n          }\n          @if (opportunity.status == OpportunityStatus.Dispositioned) {\n            <div class="controls">\n              @if (canReopoen) {\n                <button\n                  class="control alternate"\n                  (click)="promptToReopenOpportunity()"\n                >\n                  <label>Reopen</label>\n                </button>\n              }\n            </div>\n          }\n          @if (opportunity.status == OpportunityStatus.Canceled) {\n            <div class="controls">\n              @if (canReopoen) {\n                <button\n                  class="control alternate"\n                  (click)="promptToReopenOpportunity()"\n                >\n                  <label>Reopen</label>\n                </button>\n              }\n            </div>\n          }\n          @if (opportunity.status == OpportunityStatus.PendingSignatures) {\n            <div class="controls">\n              <button class="control" (click)="viewDetails()">\n                <label>View Details</label>\n              </button>\n              <button\n                class="control alternate"\n                (click)="promptToReopenOpportunity()"\n              >\n                <label>Reopen</label>\n              </button>\n              <button\n                class="control alternate"\n                (click)="sendDocumentsForSignature()"\n              >\n                <label>Send for E-Signature</label>\n              </button>\n            </div>\n          }\n          @if (opportunity.status == OpportunityStatus.PendingSubmission) {\n            <div class="controls">\n              <button class="control" (click)="viewDetails()">\n                <label>View Details</label>\n              </button>\n              <button\n                class="control alternate"\n                (click)="promptToReopenOpportunity()"\n              >\n                <label>Reopen</label>\n              </button>\n              @if (canPrepareEstimate) {\n                <button\n                  class="control alternate"\n                  (click)="promptToPrepareEstimate()"\n                >\n                  <label>Submit Job</label>\n                </button>\n              }\n            </div>\n          }\n          @if (opportunity.status == OpportunityStatus.Submitted) {\n            <div class="controls">\n              <button class="control" (click)="viewDetails()">\n                <label>View Details</label>\n              </button>\n              @if (canPrepareEstimate) {\n                <button\n                  class="control alternate"\n                  (click)="promptToPrepareEstimate()"\n                >\n                  <label>Prepare Estimate</label>\n                </button>\n              }\n            </div>\n          }\n        }\n        @if (management) {\n          <div class="controls">\n            @if (\n              opportunity.status == OpportunityStatus.Submitted ||\n              opportunity.status == OpportunityStatus.PendingSignatures ||\n              opportunity.status == OpportunityStatus.PendingSubmission\n            ) {\n              <button class="control" (click)="viewDetails()">\n                <label>View Details</label>\n              </button>\n            }\n            @if (\n              opportunity.status == OpportunityStatus.PendingSignatures\n            ) {\n              <button\n                class="control alternate"\n                (click)="sendDocumentsForSignature()"\n              >\n                <label>Send for E-Signature</label>\n              </button>\n            }\n            @if (\n              opportunity.status == OpportunityStatus.PendingSubmission\n            ) {\n                @if (canPrepareEstimate) {\n                  <button\n                    class="control alternate"\n                    (click)="promptToPrepareEstimate()"\n                  >\n                    <label>Submit Job</label>\n                  </button>\n                }\n            }\n            <button class="control" (click)="goToOpportunity(opportunity.id)">\n              <label>Open</label>\n            </button>\n          </div>\n        }\n\n        <div class="sub-controls">\n          @if (isAdmin || management) {\n            <button class="control" (click)="viewLedger()">\n              <label>View History</label>\n            </button>\n          }\n        </div>\n\n        <div class="data-export">\n          @if (isAdmin) {\n            <div class="export">\n              <button class="control" (click)="restoreFromServer()">\n                <label>Restore from Server</label>\n              </button>\n            </div>\n          }\n          <div class="export">\n            <button class="control" (click)="remoteExportOpportunity()">\n              <label>Export to Server</label>\n            </button>\n          </div>\n          <div class="export">\n            <button class="control" (click)="exportOpportunity()">\n              <label>Export to Device</label>\n            </button>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n}\n\n@if (exporting) {\n  <aside id="exportingOpportunity" [class.closing]="closingExport">\n    <div class="bg"></div>\n    <div class="modal">\n      <button class="control" (click)="promptToStopExporting()">\n        <i class="fa-solid fa-xmark"></i>\n      </button>\n      <div class="loader">\n        @if (showExportProgress) {\n          <span class="progress">{{ exportProgress | async }}%</span>\n        }\n        @if (!showExportProgress) {\n          <span class="processing">Processing</span>\n        }\n        <loader [progress]="true" [percent]="exportProgress"></loader>\n      </div>\n      <label>Preparing & Exporting Appointment</label>\n    </div>\n  </aside>\n}\n\n@if (restoringFromServer) {\n  <aside id="restoringOpportunity" [class.closing]="closingRestore">\n    <div class="bg"></div>\n    <div class="modal">\n      <div class="loader">\n        <loader [fill]="true"></loader>\n      </div>\n      <label>Restoring Appointment</label>\n    </div>\n  </aside>\n}\n\n@if (syncingLedger) {\n  <aside id="syncingOpportunity" [class.closing]="closingSyncLedger">\n    <div class="bg"></div>\n    <div class="modal">\n      <div class="loader">\n        <loader [fill]="true"></loader>\n      </div>\n      <label>Updating Appointment</label>\n    </div>\n  </aside>\n}\n', styles: ['/* src/app/shared/opportunities/components/summary/summary.component.scss */\n.opportunity {\n  display: flex;\n  position: relative;\n  z-index: 0;\n}\n.opportunity > .map {\n  position: relative;\n  width: 25%;\n  z-index: 0;\n  background-color: var(--color6);\n}\n.opportunity > .map > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.3s linear;\n  -o-transition: opacity 0.3s linear;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear;\n}\n.opportunity > .map > .render.active {\n  opacity: 1;\n}\n.opportunity > .content {\n  position: relative;\n  padding: 1vw;\n  flex: 1;\n  display: flex;\n  align-items: flex-start;\n}\n.opportunity > .content > .primary {\n  flex: 1;\n}\n.opportunity > .content > .primary > .emergency {\n  font-size: 1.4vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.opportunity > .content > .primary > .status {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color3) solid;\n}\n.opportunity > .content > .primary > .status > label {\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.opportunity > .content > .primary > .status .value {\n  font-size: 1.2vw;\n  color: var(--color3Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.opportunity > .content > .primary > .status.Canceled {\n  border-left-color: var(--color1);\n}\n.opportunity > .content > .primary > .status.Canceled h3 {\n  color: var(--color1);\n}\n.opportunity > .content > .primary > .status.Canceled p {\n  color: var(--color1Alt4);\n}\n.opportunity > .content > .primary > .status.InProgress {\n  border-left-color: var(--color5);\n}\n.opportunity > .content > .primary > .status.InProgress h3 {\n  color: var(--color5);\n}\n.opportunity > .content > .primary > .status.InProgress p {\n  color: var(--color5Alt4);\n}\n.opportunity > .content > .primary > .status:first-child {\n  margin-top: 0;\n}\n.opportunity > .content > .primary > .customer h2 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity > .content > .primary > .meta {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n.opportunity > .content > .primary > .meta > .address {\n  color: var(--color3Alt4);\n}\n.opportunity > .content > .primary > .meta > .time {\n  color: var(--color3Alt4);\n  white-space: nowrap;\n}\n.opportunity > .content > .primary > .emergency {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.opportunity > .content > .primary > .canceled {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color1) solid;\n}\n.opportunity > .content > .primary > .canceled h3 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.opportunity > .content > .primary > .canceled p {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.opportunity > .content > .primary > .canceled:first-child {\n  margin-top: 0;\n}\n.opportunity > .content > .primary > .job {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.opportunity > .content > .primary > .job label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity > .content > .primary > .job > .value {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n}\n.opportunity > .content > .primary > .price {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.opportunity > .content > .primary > .price label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity > .content > .primary > .price > .value {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.opportunity > .content > .primary > .acceptance {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.opportunity > .content > .primary > .acceptance label {\n  font-size: 1.2vw;\n  color: var(--errorAlt3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n.opportunity > .content > .primary > .acceptance > .date {\n  margin-left: 0.25vw;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.opportunity > .content > .primary > .acceptance.accepted > label {\n  color: var(--successAlt3);\n}\n.opportunity > .content > .primary > .attachments {\n  margin-top: 0.5vw;\n}\n.opportunity > .content > .primary > .attachments label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity > .content > .primary > .attachments > .items {\n  margin-top: 0.25vw;\n}\n.opportunity > .content > .primary > .attachments > .items > .item {\n  margin-right: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n  position: relative;\n}\n.opportunity > .content > .primary > .attachments > .items > .item:after {\n  content: ", ";\n}\n.opportunity > .content > .primary > .attachments > .items > .item:last-of-type {\n  margin-right: 0;\n}\n.opportunity > .content > .primary > .attachments > .items > .item:last-of-type:after {\n  content: "";\n}\n.opportunity > .content > .primary > .disposition {\n  margin-top: 0.5vw;\n}\n.opportunity > .content > .primary > .disposition label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.opportunity > .content > .primary > .disposition > .status {\n  margin-top: 0.25vw;\n}\n.opportunity > .content > .primary > .disposition > .status > .value {\n  font-weight: var(--stronger);\n  font-size: 1.2vw;\n  color: var(--color5);\n}\n.opportunity > .content > .primary > .disposition > .status > .timestamp {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.opportunity > .content > .primary > .disposition > .note {\n  margin-top: 0;\n}\n.opportunity > .content > .primary > .disposition > .note > .value {\n  font-weight: var(--stdweight);\n  font-size: 1.2vw;\n  font-style: italic;\n  color: var(--color1);\n}\n.opportunity > .content > .secondary {\n  margin-left: 1vw;\n  width: 15vw;\n}\n.opportunity > .content > .secondary > .pricing {\n  margin-bottom: 2vw;\n  text-align: right;\n}\n.opportunity > .content > .secondary > .pricing > .total {\n  display: inline-block;\n  font-size: 2vw;\n  line-height: 1;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.opportunity > .content > .secondary > .controls > .control {\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--color3);\n  border-radius: 999px;\n  border: 0.1vw var(--color3Alt3) solid;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.opportunity > .content > .secondary > .controls > .control > label {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.opportunity > .content > .secondary > .controls > .control.alternate {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n.opportunity > .content > .secondary > .controls > .control.open {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.opportunity > .content > .secondary > .controls > .control.open > label {\n  color: var(--color3);\n}\n.opportunity > .content > .secondary > .controls > .control[disabled] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.opportunity > .content > .secondary > .controls > .control:active {\n  border-color: transparent;\n}\n.opportunity > .content > .secondary > .controls > .control:first-child {\n  margin-top: 0;\n}\n.opportunity > .content > .secondary > .warning {\n  background-color: rgba(var(--error-raw), 0.1);\n  border: 0.125vw var(--error) solid;\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n}\n.opportunity > .content > .secondary > .warning > p {\n  color: var(--errorAlt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n  text-align: center;\n}\n.opportunity > .content > .secondary > .warning > .control {\n  display: block;\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--error);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.opportunity > .content > .secondary > .warning > .control > label {\n  font-size: 1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.opportunity > .content > .secondary > .status {\n  padding: 0.25vw 1vw;\n  border-radius: 0.5vw;\n  background-color: rgba(var(--success-raw), 0.2);\n  border: 0.125vw var(--color1) solid;\n  margin-bottom: 1vw;\n}\n.opportunity > .content > .secondary > .status > .value {\n  text-align: center;\n  display: block;\n  font-size: 1.1vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.opportunity > .content > .secondary > .status > .timestamp {\n  display: block;\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-align: center;\n}\n.opportunity > .content > .secondary > .status.Open {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.opportunity > .content > .secondary > .status.Open > .value {\n  color: var(--color3);\n}\n.opportunity > .content > .secondary > .status.Dispositioned {\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-color: var(--color5);\n}\n.opportunity > .content > .secondary > .status.Dispositioned > .value {\n  color: var(--color5);\n}\n.opportunity > .content > .secondary > .status.InProgress {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.opportunity > .content > .secondary > .status.InProgress > .value {\n  color: var(--color3);\n}\n.opportunity > .content > .secondary > .status.Submitted {\n  background-color: rgba(var(--success-raw), 0.1);\n  border-color: var(--success);\n}\n.opportunity > .content > .secondary > .status.Submitted > .value {\n  color: var(--successAlt4);\n}\n.opportunity > .content > .secondary > .sub-controls {\n  margin-top: 3vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.opportunity > .content > .secondary > .sub-controls > .control {\n  margin-top: 0.5vw;\n  background-color: var(--color4Alt4);\n  border-radius: 999px;\n  border: 0.1vw var(--color3Alt3) solid;\n  padding: 0.2vw 2vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.opportunity > .content > .secondary > .sub-controls > .control > label {\n  font-size: 1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.opportunity > .content > .secondary > .sub-controls > .control[disabled] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.opportunity > .content > .secondary > .sub-controls > .control:active {\n  border-color: transparent;\n}\n.opportunity > .content > .secondary > .sub-controls > .control:first-child {\n  margin-top: 0;\n}\n.opportunity > .content > .secondary > .data-export {\n  margin-top: 0.5vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.opportunity > .content > .secondary > .data-export > .export {\n  margin-top: 0.5vw;\n}\n.opportunity > .content > .secondary > .data-export > .export > .control {\n  cursor: pointer;\n}\n.opportunity > .content > .secondary > .data-export > .export > .control > label {\n  color: var(--color1Alt2);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n.opportunity > .content > .secondary > .data-export > .export > .timestamp {\n  text-align: right;\n  display: flex;\n  align-items: center;\n}\n.opportunity > .content > .secondary > .data-export > .export > .timestamp > label {\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.opportunity > .content > .secondary > .data-export > .export > .timestamp > .value {\n  margin-left: 0.25vw;\n  font-size: 1vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n}\n@-webkit-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#exportingOpportunity > .bg,\n#restoringOpportunity > .bg,\n#syncingOpportunity > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingOpportunity > .modal,\n#restoringOpportunity > .modal,\n#syncingOpportunity > .modal {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: exportLoadIn;\n  -ms-animation-name: exportLoadIn;\n  -o-animation-name: exportLoadIn;\n  -webkit-animation-name: exportLoadIn;\n  animation-name: exportLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingOpportunity > .modal > .control,\n#restoringOpportunity > .modal > .control,\n#syncingOpportunity > .modal > .control {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#exportingOpportunity > .modal > .control > i,\n#restoringOpportunity > .modal > .control > i,\n#syncingOpportunity > .modal > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#exportingOpportunity > .modal > .loader,\n#restoringOpportunity > .modal > .loader,\n#syncingOpportunity > .modal > .loader {\n  position: relative;\n}\n#exportingOpportunity > .modal > .loader > .progress,\n#exportingOpportunity > .modal > .loader > .processing,\n#restoringOpportunity > .modal > .loader > .progress,\n#restoringOpportunity > .modal > .loader > .processing,\n#syncingOpportunity > .modal > .loader > .progress,\n#syncingOpportunity > .modal > .loader > .processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#exportingOpportunity > .modal > .loader > .progress,\n#restoringOpportunity > .modal > .loader > .progress,\n#syncingOpportunity > .modal > .loader > .progress {\n  font-size: 4vw;\n}\n#exportingOpportunity > .modal > .loader > .processing,\n#restoringOpportunity > .modal > .loader > .processing,\n#syncingOpportunity > .modal > .loader > .processing {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#exportingOpportunity > .modal > .loader > loader,\n#restoringOpportunity > .modal > .loader > loader,\n#syncingOpportunity > .modal > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#exportingOpportunity > .modal label,\n#restoringOpportunity > .modal label,\n#syncingOpportunity > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#exportingOpportunity.closing > .bg,\n#restoringOpportunity.closing > .bg,\n#syncingOpportunity.closing > .bg {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingOpportunity.closing > .modal,\n#restoringOpportunity.closing > .modal,\n#syncingOpportunity.closing > .modal {\n  -moz-animation-name: exportLoadOut;\n  -ms-animation-name: exportLoadOut;\n  -o-animation-name: exportLoadOut;\n  -webkit-animation-name: exportLoadOut;\n  animation-name: exportLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=summary.component.css.map */\n'] }]
  }], () => [{ type: UiService }, { type: OpportunityService }, { type: OpportunityUiService }, { type: StorageService }, { type: AuthRefService }, { type: DeviceRouteService }, { type: OrderByPipe }, { type: DatePipe }, { type: ContentService }, { type: ReminderService }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], management: [{
    type: Input,
    args: ["management"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunitySummaryComponent, { className: "OpportunitySummaryComponent" });
})();

// src/app/shared/payments/models/financing.ts
var LenderApplicationStatus;
(function(LenderApplicationStatus2) {
  LenderApplicationStatus2[LenderApplicationStatus2["Pending"] = 0] = "Pending";
  LenderApplicationStatus2[LenderApplicationStatus2["Approved"] = 1] = "Approved";
})(LenderApplicationStatus || (LenderApplicationStatus = {}));

// src/app/shared/opportunities/components/payments/payments.component.ts
var _c04 = ["componentElm"];
function OpportunityPaymentsComponent_Conditional_18_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 12)(1, "label");
    \u0275\u0275text(2, "Phone:");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 14);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "phone");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(5, 1, ctx_r1.phone));
  }
}
function OpportunityPaymentsComponent_Conditional_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 12)(1, "label");
    \u0275\u0275text(2, "Email:");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 14);
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(ctx_r1.email);
  }
}
function OpportunityPaymentsComponent_Conditional_29_For_2_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 19);
    \u0275\u0275text(1, " You must indicate an approval amount greater than $0.00 to include this lender on the job. ");
    \u0275\u0275elementEnd();
  }
}
function OpportunityPaymentsComponent_Conditional_29_For_2_Conditional_20_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 19);
    \u0275\u0275text(1, " You must indicate an application Id. ");
    \u0275\u0275elementEnd();
  }
}
function OpportunityPaymentsComponent_Conditional_29_For_2_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 32)(1, "label");
    \u0275\u0275text(2, "Applied On");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 14);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "date");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const lender_r4 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(5, 1, lender_r4.applied_Utc, "MM/dd/yyyy hh:mm a z"), " ");
  }
}
function OpportunityPaymentsComponent_Conditional_29_For_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 25)(1, "button", 5);
    \u0275\u0275listener("click", function OpportunityPaymentsComponent_Conditional_29_For_2_Template_button_click_1_listener() {
      const lender_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.promptToRemoveLender(lender_r4));
    });
    \u0275\u0275element(2, "i", 26);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 27)(4, "div", 10)(5, "label");
    \u0275\u0275text(6, "Lender");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "span", 14);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "div", 24)(10, "label");
    \u0275\u0275text(11, "Approved Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "div", 28)(13, "currency-input", 29);
    \u0275\u0275listener("currencyOutput", function OpportunityPaymentsComponent_Conditional_29_For_2_Template_currency_input_currencyOutput_13_listener($event) {
      const lender_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.updateLenderAmount(lender_r4, $event));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(14, OpportunityPaymentsComponent_Conditional_29_For_2_Conditional_14_Template, 2, 0, "p", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "div", 30)(16, "label");
    \u0275\u0275text(17, "Application Id");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "div", 28)(19, "input", 31);
    \u0275\u0275twoWayListener("ngModelChange", function OpportunityPaymentsComponent_Conditional_29_For_2_Template_input_ngModelChange_19_listener($event) {
      const lender_r4 = \u0275\u0275restoreView(_r3).$implicit;
      \u0275\u0275twoWayBindingSet(lender_r4.applicationId, $event) || (lender_r4.applicationId = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(20, OpportunityPaymentsComponent_Conditional_29_For_2_Conditional_20_Template, 2, 0, "p", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(21, OpportunityPaymentsComponent_Conditional_29_For_2_Conditional_21_Template, 6, 4, "div", 32);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const lender_r4 = ctx.$implicit;
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate1(" ", lender_r4.name, " ");
    \u0275\u0275advance(5);
    \u0275\u0275property("currencyInput", lender_r4.amountFinanced);
    \u0275\u0275advance();
    \u0275\u0275conditional(lender_r4.amountFinanced != null && lender_r4.amountFinanced <= 0 ? 14 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", lender_r4.applicationId);
    \u0275\u0275advance();
    \u0275\u0275conditional(lender_r4.applicationId == null ? 20 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(lender_r4.applied_Utc != null ? 21 : -1);
  }
}
function OpportunityPaymentsComponent_Conditional_29_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 17);
    \u0275\u0275repeaterCreate(1, OpportunityPaymentsComponent_Conditional_29_For_2_Template, 22, 6, "div", 25, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r1.lenders);
  }
}
function OpportunityPaymentsComponent_Conditional_31_For_1_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 5);
    \u0275\u0275listener("click", function OpportunityPaymentsComponent_Conditional_31_For_1_Conditional_0_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const method_r6 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.addLender(method_r6));
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const method_r6 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" Add ", method_r6.name, " ");
  }
}
function OpportunityPaymentsComponent_Conditional_31_For_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, OpportunityPaymentsComponent_Conditional_31_For_1_Conditional_0_Template, 3, 1, "button", 33);
  }
  if (rf & 2) {
    const method_r6 = ctx.$implicit;
    \u0275\u0275conditional(!method_r6.added ? 0 : -1);
  }
}
function OpportunityPaymentsComponent_Conditional_31_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275repeaterCreate(0, OpportunityPaymentsComponent_Conditional_31_For_1_Template, 1, 1, null, null, \u0275\u0275repeaterTrackByIdentity);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275repeater(ctx_r1.financeMethods);
  }
}
function OpportunityPaymentsComponent_Conditional_36_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "p");
    \u0275\u0275text(2, "A payment is required to finalize the job.");
    \u0275\u0275elementEnd()();
  }
}
function OpportunityPaymentsComponent_Conditional_37_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "p");
    \u0275\u0275text(2, "Your total payments must at least meet the deposit amount to finalize the job.");
    \u0275\u0275elementEnd()();
  }
}
function OpportunityPaymentsComponent_For_40_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 20)(1, "button", 34);
    \u0275\u0275listener("click", function OpportunityPaymentsComponent_For_40_Template_button_click_1_listener() {
      const \u0275$index_154_r8 = \u0275\u0275restoreView(_r7).$index;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.removePayment(\u0275$index_154_r8));
    });
    \u0275\u0275element(2, "i", 26);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 27)(4, "div", 35)(5, "label");
    \u0275\u0275text(6, "Payment Method");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "span", 14);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "div", 24)(10, "label");
    \u0275\u0275text(11, "Payment Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "span", 14);
    \u0275\u0275text(13);
    \u0275\u0275pipe(14, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(15, "div", 36)(16, "label");
    \u0275\u0275text(17, "Timestamp");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "span", 14);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "date");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const payment_r9 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !payment_r9.appliedManually);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", payment_r9.paymentMethod == null ? null : payment_r9.paymentMethod.name, " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(14, 4, payment_r9.amount, payment_r9.iso4217), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(20, 7, payment_r9.timeStamp_Utc, "MM/dd/yyyy hh:mm a"), " ");
  }
}
function OpportunityPaymentsComponent_Conditional_41_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "p");
    \u0275\u0275text(2, " No payments have yet been recorded on this appointment. ");
    \u0275\u0275elementEnd()();
  }
}
function OpportunityPaymentsComponent_Conditional_46_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "p");
    \u0275\u0275text(2, "Your recorded payments don't match the deposit amount. Are you sure your payment details are correct?");
    \u0275\u0275elementEnd()();
  }
}
function OpportunityPaymentsComponent_Conditional_47_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "p");
    \u0275\u0275text(2, "Your payment details don't match the total price of the job.");
    \u0275\u0275elementEnd()();
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 37);
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 28)(1, "currency-input", 40);
    \u0275\u0275listener("currencyOutput", function OpportunityPaymentsComponent_For_50_Conditional_6_Template_currency_input_currencyOutput_1_listener($event) {
      \u0275\u0275restoreView(_r10);
      const detail_r11 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateDetail($event, detail_r11));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("maxAmount", detail_r11.maximumAmount)("minAmount", detail_r11.minimumAmount)("update", detail_r11.updatedAmount$)("currencyInput", detail_r11.amount);
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 14);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "currency");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(2, 1, detail_r11.amount, "USD"), " ");
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 19);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "currency");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" The specified amount must be lower than ", \u0275\u0275pipeBind2(2, 1, detail_r11.maximumAmount, "USD"), ". ");
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 19);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "currency");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" The specified amount must be higher than ", \u0275\u0275pipeBind2(2, 1, detail_r11.minimumAmount, "USD"), ". ");
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_11_For_2_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 19);
    \u0275\u0275text(1, " You must enter an amount, even if it's $0.00. ");
    \u0275\u0275elementEnd();
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_11_For_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 24)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 28)(4, "currency-input", 29);
    \u0275\u0275listener("currencyOutput", function OpportunityPaymentsComponent_For_50_Conditional_11_For_2_Template_currency_input_currencyOutput_4_listener($event) {
      const amount_r13 = \u0275\u0275restoreView(_r12).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.updateDetailLenderAmount($event, amount_r13));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(5, OpportunityPaymentsComponent_For_50_Conditional_11_For_2_Conditional_5_Template, 2, 0, "p", 19);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const amount_r13 = ctx.$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" Amount Financed by ", amount_r13.name, " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("currencyInput", amount_r13.amount);
    \u0275\u0275advance();
    \u0275\u0275conditional(amount_r13.amount == null ? 5 : -1);
  }
}
function OpportunityPaymentsComponent_For_50_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 39);
    \u0275\u0275repeaterCreate(1, OpportunityPaymentsComponent_For_50_Conditional_11_For_2_Template, 6, 3, "div", 24, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275repeater(detail_r11.lenderAmounts);
  }
}
function OpportunityPaymentsComponent_For_50_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 22)(1, "div", 7)(2, "label");
    \u0275\u0275conditionalCreate(3, OpportunityPaymentsComponent_For_50_Conditional_3_Template, 1, 0, "i", 37);
    \u0275\u0275text(4);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 24);
    \u0275\u0275conditionalCreate(6, OpportunityPaymentsComponent_For_50_Conditional_6_Template, 2, 4, "div", 28);
    \u0275\u0275conditionalCreate(7, OpportunityPaymentsComponent_For_50_Conditional_7_Template, 3, 4, "span", 14);
    \u0275\u0275elementStart(8, "div", 38);
    \u0275\u0275conditionalCreate(9, OpportunityPaymentsComponent_For_50_Conditional_9_Template, 3, 4, "p", 19);
    \u0275\u0275conditionalCreate(10, OpportunityPaymentsComponent_For_50_Conditional_10_Template, 3, 4, "p", 19);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(11, OpportunityPaymentsComponent_For_50_Conditional_11_Template, 3, 0, "div", 39);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const detail_r11 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275classProp("editable", detail_r11.canEditAmount);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(detail_r11.canEditAmount ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", detail_r11.name, " ");
    \u0275\u0275advance(2);
    \u0275\u0275conditional(detail_r11.canEditAmount ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!detail_r11.canEditAmount ? 7 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(detail_r11.maximumAmount != null && detail_r11.amount > detail_r11.maximumAmount ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(detail_r11.amount < detail_r11.minimumAmount ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(detail_r11.lenderAmounts.length > 0 ? 11 : -1);
  }
}
function OpportunityPaymentsComponent_Conditional_60_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 34);
    \u0275\u0275listener("click", function OpportunityPaymentsComponent_Conditional_60_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.makePayment());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Record an External Payment");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(3, "button", 41);
    \u0275\u0275listener("click", function OpportunityPaymentsComponent_Conditional_60_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.save());
    });
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, "Save & Close");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("disabled", !ctx_r1.canMakePayment);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx_r1.canSave);
  }
}
var _OpportunityPaymentsComponent = class _OpportunityPaymentsComponent {
  constructor(opportunityService, opportunityUiService, paymentsService, authRefService, uiService, orderByPipe, currencyPipe) {
    this.opportunityService = opportunityService;
    this.opportunityUiService = opportunityUiService;
    this.paymentsService = paymentsService;
    this.authRefService = authRefService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.currencyPipe = currencyPipe;
    this.activeUser = null;
    this.details = [];
    this.totalDetailAmount = 0;
    this.showMismatchedTotalWarning = false;
    this.paymentsMatchDeposit = false;
    this.LenderApplicationStatus = LenderApplicationStatus;
    this.lenders = [];
    this.PaymentMethodType = PaymentMethodType;
    this.transactMethods = [];
    this.paymentMethods = [];
    this.financeMethods = [];
    this.makingPayment = false;
    this.totalPaid = 0;
    this.payments = [];
    this.canSave = false;
  }
  // #endregion
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  // #endregion
  // #region Customer
  get customer() {
    return this.opportunity?.customer;
  }
  get customerName() {
    return `${this.customer?.firstName} ${this.customer?.lastName}`;
  }
  // #endregion
  // #region Contact
  get email() {
    const contactInfo = this.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Email) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasEmail() {
    return this.email != null;
  }
  get phone() {
    const contactInfo = this.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Phone) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasPhone() {
    return this.phone != null;
  }
  // #endregion
  // #region Address
  get address() {
    return this.opportunity?.property?.address;
  }
  get friendlyAddress() {
    return this.address?.friendlyAddress;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Price
  get price() {
    return this.opportunity?.customPrice ?? this.opportunity?.price;
  }
  get finalPrice() {
    return this.price?.finalPrice ?? 0;
  }
  get remainingAmount() {
    return this.finalPrice - this.totalPaid;
  }
  checkPaymentsMatchDeposit() {
    this.paymentsMatchDeposit = safeEquivalentPrice(this.totalPaid) == safeEquivalentPrice(this.depositAmount);
  }
  checkMismatchedTotalWarning() {
    this.showMismatchedTotalWarning = Math.ceil(this.totalDetailAmount) != Math.ceil(this.finalPrice);
  }
  updateTotalDetailAmount() {
    this.totalDetailAmount = 0;
    this.details.forEach((detail) => {
      this.totalDetailAmount = this.totalDetailAmount + detail.amount;
    });
  }
  updateDetail(result, detail) {
    if (this.opportunity?.paymentSetting != null && result.amount != null) {
      if (this.finalPrice > 0 && result.amount != null) {
        if (detail.canEditAmount) {
          const totalDetails = this.details.length;
          detail.amount = result.amount;
          switch (totalDetails) {
            case 2:
              {
                const firstDetail = this.details[0];
                const secondDetail = this.details[1];
                if (firstDetail.id == detail.id) {
                  secondDetail.amount = this.finalPrice - detail.amount;
                  secondDetail.updatedAmount$.next(secondDetail.amount);
                }
              }
              break;
            case 3: {
              const firstDetail = this.details[0];
              const secondDetail = this.details[1];
              const thirdDetail = this.details[2];
              if (firstDetail.id == detail.id) {
                secondDetail.amount = this.finalPrice - detail.amount - thirdDetail.amount;
              } else if (thirdDetail.id == detail.id) {
                secondDetail.amount = this.finalPrice - detail.amount - firstDetail.amount;
              }
              secondDetail.updatedAmount$.next(secondDetail.amount);
            }
          }
        } else {
          detail.updatedAmount$.next(detail.amount);
        }
        this.updateTotalDetailAmount();
        this.updateValidation();
      }
    }
  }
  updateDetailLenderAmount(result, lenderAmount) {
    lenderAmount.amount = result.amount;
    this.updateValidation();
  }
  initDetails() {
    if (this.opportunity?.paymentSetting != null) {
      let details = this.opportunity.paymentSetting.details;
      let clonedDetails = [];
      details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const clonedDetail = structuredClone(detail);
        clonedDetail.updatedAmount$ = new Subject();
        clonedDetail.updatedAmount$.next(clonedDetail.amount);
        if (this.hasLenders) {
          for (var i = 0, len = this.lenders.length; i < len; i++) {
            const lender = this.lenders[i];
            const matchingLender = clonedDetail.lenderAmounts.find((x) => x.name == lender.name);
            if (matchingLender == null) {
              clonedDetail.lenderAmounts.push({
                name: lender.name,
                amount: void 0
              });
            }
          }
        } else {
          clonedDetail.lenderAmounts = [];
        }
        clonedDetails.push(clonedDetail);
      });
      const totalDetails = clonedDetails.length;
      switch (totalDetails) {
        case 2:
          {
            const firstDetail = clonedDetails[0];
            const secondDetail = clonedDetails[1];
            secondDetail.amount = this.finalPrice - firstDetail.amount;
            secondDetail.updatedAmount$.next(secondDetail.amount);
            firstDetail.canEditAmount = true;
            secondDetail.canEditAmount = false;
          }
          break;
        case 3:
          {
            const firstDetail = clonedDetails[0];
            const secondDetail = clonedDetails[1];
            const thirdDetail = clonedDetails[2];
            secondDetail.amount = this.finalPrice - firstDetail.amount - thirdDetail.amount;
            firstDetail.canEditAmount = true;
            secondDetail.canEditAmount = false;
            thirdDetail.canEditAmount = true;
          }
          break;
      }
      this.details = clonedDetails;
      this.updateTotalDetailAmount();
      this.updateValidation();
    }
  }
  get hasLenders() {
    return this.lenders.length > 0;
  }
  addLender(method) {
    const lender = {
      name: method.name,
      applicationId: void 0,
      applied_Utc: void 0,
      applicationStatus: void 0,
      amountRequested: 0,
      amountFinanced: 0,
      applied: false
    };
    this.lenders.push(lender);
    method.added = true;
    this.details.forEach((detail) => {
      if (detail.lenderAmounts.length > 0) {
        const matchingLender = detail.lenderAmounts.find((x) => x.name == lender.name);
        if (matchingLender == null) {
          detail.lenderAmounts.push({
            name: lender.name,
            amount: void 0
          });
        } else {
          matchingLender.amount = void 0;
        }
      } else {
        detail.lenderAmounts = [
          {
            name: lender.name,
            amount: void 0
          }
        ];
      }
    });
    this.updateValidation();
  }
  promptToRemoveLender(lender) {
    this.uiService.prompt(`Remove ${lender.name}`, `Are you sure you want to remove ${lender.name} as a lender on the job?`, "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.removeLender(lender);
        }
      }
    });
  }
  updateLenderAmount(lender, result) {
    window.clearTimeout(this.lenderAmountDebounce);
    lender.amountFinanced = result.amount;
    this.updateValidation();
  }
  removeLender(lender) {
    const method = this.financeMethods.find((x) => x.name == lender.name);
    if (method != null) {
      method.added = false;
    }
    const index = this.lenders.findIndex((x) => x.name == lender.name);
    this.lenders.splice(index, 1);
    this.details.forEach((detail) => {
      const matchingLenderIndex = detail.lenderAmounts.findIndex((x) => x.name == lender.name);
      detail.lenderAmounts.splice(matchingLenderIndex, 1);
    });
    this.updateValidation();
  }
  applyForFinancing(lender) {
    const lenderName = lender.name.toLowerCase();
    const componentElm = this.componentElm?.nativeElement;
    if (componentElm != null && this.opportunity != null) {
      switch (lenderName) {
        case "greensky finance":
          {
            this.paymentsService.initGreenSky(componentElm, this.opportunity).subscribe({
              next: (payment) => {
                if (payment != null) {
                  this.registerPayment(payment);
                }
                this.makingPayment = false;
                lender.applied = true;
                lender.applied_Utc = /* @__PURE__ */ new Date();
              },
              error: () => {
                this.uiService.prompt("GreenSky Unavailable", "We were unable to load the GreenSky application. Please try again or apply in the GreenSky app.", "Ok").subscribe({
                  next: (confirmed) => {
                    this.makingPayment = false;
                    lender.applied = true;
                    lender.applied_Utc = /* @__PURE__ */ new Date();
                  }
                });
              }
            });
          }
          break;
        case "ftl":
          {
            this.paymentsService.startApplyingForExternalLender("https://beta.apptracker.ftlfinance.com/C220703");
            lender.applied = true;
            lender.applied_Utc = /* @__PURE__ */ new Date();
          }
          break;
      }
    }
  }
  initLenders() {
    if (this.opportunity?.paymentSetting != null) {
      let lenders = this.opportunity.lenders;
      let clonedLenders = [];
      lenders.forEach((lender) => {
        const matchingPaymentMethod = this.financeMethods.find((x) => x.name == lender.name);
        if (matchingPaymentMethod != null) {
          const clonedLender = structuredClone(lender);
          clonedLender.applied = true;
          matchingPaymentMethod.added = true;
          clonedLenders.push(clonedLender);
        }
      });
      this.lenders = clonedLenders;
      this.updateValidation();
    }
  }
  findPaymentMethod(id) {
    return this.paymentMethods.find((x) => x.id == id);
  }
  initMethods() {
    const financeMethods = [];
    const transactMethods = [];
    const paymentMethods = this.opportunity?.paymentSetting?.methods ?? [];
    const clonedPaymentMehods = [];
    paymentMethods.forEach((method) => {
      const clonedMethod = structuredClone(method);
      clonedPaymentMehods.push(clonedMethod);
    });
    clonedPaymentMehods.forEach((method) => {
      if (method.type == PaymentMethodType.Financing) {
        financeMethods.push(method);
      } else if (method.type == PaymentMethodType.EPayment && method.name != "Bluepay") {
        transactMethods.push(method);
      }
    });
    this.financeMethods = financeMethods;
    this.transactMethods = transactMethods;
    this.paymentMethods = clonedPaymentMehods;
  }
  get hasPayments() {
    return this.payments.length > 0;
  }
  get canMakePayment() {
    return !this.makingPayment;
  }
  get depositAmount() {
    const deposit = this.details.find((x) => x.name.toLowerCase().includes("deposit"));
    const amount = deposit?.amount ?? 0;
    return safePrice(amount);
  }
  get depositAmountRemaining() {
    const remaining = this.depositAmount - this.totalPaid;
    if (remaining >= 0) {
      return remaining;
    } else {
      return 0;
    }
  }
  get showPaymentsWarning() {
    return this.depositAmount > 0 && !this.hasPayments;
  }
  get showInsufficientPaymentsWarning() {
    return this.totalPaid < this.depositAmount;
  }
  calcTotalPaid() {
    let totalPaid = 0;
    this.payments.forEach((payment) => {
      totalPaid = totalPaid + payment.amount;
    });
    this.totalPaid = totalPaid;
  }
  removePayment(i) {
    this.uiService.prompt("Remove Manual Payment?", "Are you sure you wish to remove this manual payment?", "Yes", "No, Cancel").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          if (this.opportunity != null) {
            this.payments.splice(i, 1);
            this.updateValidation();
          }
        }
      }
    });
  }
  registerPayment(payment) {
    if (payment.paymentMethodId != null) {
      payment.paymentMethod = this.findPaymentMethod(payment.paymentMethodId);
    }
    if (this.payments != null) {
      this.payments.push(payment);
    } else {
      this.payments = [payment];
    }
    this.calcTotalPaid();
    this.updateValidation();
  }
  makePayment(method = void 0) {
    const componentElm = this.componentElm?.nativeElement;
    if (this.canMakePayment && componentElm != null && this.opportunity != null) {
      this.makingPayment = true;
      if (method != null) {
        const methodName = method.name.toLowerCase();
        switch (methodName) {
          case "ebiz charge":
            {
              setTimeout(() => {
                this.uiService.prompt("EBiz Charge Unavailable", "We encountered an issue loading Ebiz Charge. You can capture the payment elsewhere and record it as an external payment, instead.", "Okay").subscribe({
                  next: (confirmed) => {
                    this.makingPayment = false;
                  }
                });
              }, 1e3);
            }
            break;
        }
      } else {
        this.manualPaymentSubscription = this.paymentsService.manualPayment.subscribe({
          next: (payment) => {
            if (payment != null) {
              this.registerPayment(payment);
            }
            this.makingPayment = false;
            this.manualPaymentSubscription?.unsubscribe();
          }
        });
        const paymentTip = `REMAINING DEPOSIT AMOUNT: ${this.currencyPipe.transform(this.depositAmountRemaining, "USD")}`;
        this.paymentsService.startMakingManualPayment(this.paymentMethods, paymentTip);
      }
    }
  }
  initPayments() {
    const payments = this.opportunity?.payments ?? [];
    const clonedPayments = [];
    payments.forEach((payment) => {
      const clonedPayment = structuredClone(payment);
      if (clonedPayment.paymentMethodId != null) {
        clonedPayment.paymentMethod = this.findPaymentMethod(clonedPayment.paymentMethodId);
        if (clonedPayment.paymentMethod != null) {
          clonedPayments.push(clonedPayment);
        }
      }
    });
    this.payments = clonedPayments;
    this.updateValidation();
  }
  updateValidation() {
    if (this.opportunity?.paymentSetting != null) {
      const data = new Opportunity();
      data.price = structuredClone(this.price);
      data.lenders = structuredClone(this.lenders);
      data.payments = structuredClone(this.payments);
      data.paymentSetting = structuredClone(this.opportunity.paymentSetting);
      data.paymentSetting.details = this.details;
      data.paymentSetting.methods = this.paymentMethods;
      const detailsValid = this.opportunity.validatePaymentDetails(true, data, this.hasLenders);
      const lendersValid = this.opportunity.validateLenders(true, data);
      this.calcTotalPaid();
      this.checkMismatchedTotalWarning();
      this.checkPaymentsMatchDeposit();
      this.canSave = this.paymentsMatchDeposit && lendersValid && detailsValid;
    }
  }
  promptToSave() {
    this.uiService.prompt("Caution!", `Your changes will overwrite any existing payment information on the appointment and generate new documents which will need to be signed.
                Any existing signed documents will be deleted.
                Are you sure you wish to save payment information?`, "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed && this.opportunity?.paymentSetting != null && this.activeUser != null && this.canSave) {
          const opportunity = this.opportunity;
          const activeUser = this.activeUser;
          const paymentSetting = deepClone(this.opportunity.paymentSetting);
          if (paymentSetting != null) {
            paymentSetting.details = deepClone(this.details) ?? [];
            paymentSetting.methods = deepClone(this.paymentMethods) ?? [];
            this.opportunityService.updatePaymentSetting(this.opportunity, paymentSetting, this.activeUser).then(() => __async(this, null, function* () {
              const lenders = deepClone(this.lenders) ?? [];
              const existingLenders = deepClone(opportunity.lenders) ?? [];
              for (var i = 0, len = lenders.length; i < len; i++) {
                const lender = lenders[i];
                const existingLender = existingLenders.find((x) => x.name == lender.name);
                if (existingLender == null) {
                  yield this.opportunityService.addLender(opportunity, lender, activeUser);
                } else {
                  yield this.opportunityService.updateLender(opportunity, lender, activeUser);
                }
              }
              for (var i = 0, len = existingLenders.length; i < len; i++) {
                const existingLender = existingLenders[i];
                const newLender = lenders.find((x) => x.name == existingLender.name);
                if (newLender == null) {
                  yield this.opportunityService.removeLender(opportunity, existingLender.name, activeUser);
                }
              }
              const payments = deepClone(this.payments) ?? [];
              const existingPayments = deepClone(opportunity.payments) ?? [];
              for (var i = 0, len = payments.length; i < len; i++) {
                const payment = payments[i];
                const existingPayment = existingPayments.find((x) => x.id == payment.id);
                if (existingPayment == null) {
                  yield this.opportunityService.addPayment(opportunity, payment, activeUser);
                } else {
                  yield this.opportunityService.updatePayment(opportunity, payment, activeUser);
                }
              }
              for (var i = 0, len = existingPayments.length; i < len; i++) {
                const existingPayment = existingPayments[i];
                const newPayment = payments.find((x) => x.id == existingPayment.id);
                if (newPayment == null) {
                  yield this.opportunityService.removePayment(opportunity, existingPayment.id, activeUser);
                }
              }
              opportunity.checkPaymentsValidity();
              const newDocuments = opportunity.generateDocuments();
              this.opportunityService.updateDocuments(opportunity, newDocuments, activeUser).then(() => {
                this.opportunityUiService.stopMakingPayments();
              });
            }));
          }
        }
      }
    });
  }
  save() {
    if (this.opportunity?.paymentSetting != null && this.canSave) {
      this.promptToSave();
    }
  }
  isNaN(value) {
    return window.isNaN(value);
  }
  closeView() {
    if (this.canModifyOpportunity) {
      this.uiService.prompt("Are you sure?", "Any unsaved changes to payment information will be lost. Are you sure you want to stop managing payments on the appointment?", "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.opportunityUiService.stopMakingPayments();
          }
        }
      });
    } else {
      this.opportunityUiService.stopMakingPayments();
    }
  }
  init() {
    this.watchUser();
    this.initMethods();
    this.initPayments();
    this.initLenders();
    this.initDetails();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.manualPaymentSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_OpportunityPaymentsComponent.\u0275fac = function OpportunityPaymentsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityPaymentsComponent)(\u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(PaymentsService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(CurrencyPipe));
};
_OpportunityPaymentsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunityPaymentsComponent, selectors: [["opportunity-payments"]], viewQuery: function OpportunityPaymentsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe,
  CurrencyPipe
])], decls: 61, vars: 17, consts: [["componentElm", ""], ["id", "opportunityPayments"], [1, "primary"], [1, "job"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "meta"], [1, "customer"], [1, "name"], [1, "contact-info"], [1, "contact"], [1, "address"], [1, "value"], [1, "form"], [1, "financing", "section"], [1, "lenders"], [1, "payments", "section"], [1, "message"], [1, "payment"], [1, "details", "section"], [1, "detail"], [1, "detail", "total"], [1, "amount"], [1, "lender"], [1, "fa-solid", "fa-trash"], [1, "details"], [1, "input"], [3, "currencyOutput", "currencyInput"], [1, "application"], ["type", "text", 3, "ngModelChange", "ngModel"], [1, "applied"], [1, "control"], [1, "control", 3, "click", "disabled"], [1, "method"], [1, "timestamp"], [1, "fa-solid", "fa-pencil"], [1, "messages"], [1, "lender-amounts"], [3, "currencyOutput", "maxAmount", "minAmount", "update", "currencyInput"], [1, "control", "success", 3, "click", "disabled"]], template: function OpportunityPaymentsComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h3");
    \u0275\u0275text(5, " Manage Payments for ");
    \u0275\u0275elementStart(6, "span", 3);
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 4)(9, "button", 5);
    \u0275\u0275listener("click", function OpportunityPaymentsComponent_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275element(10, "i", 6);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(11, "div", 7)(12, "div", 8)(13, "div", 9)(14, "div", 10)(15, "h5");
    \u0275\u0275text(16);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(17, "div", 11);
    \u0275\u0275conditionalCreate(18, OpportunityPaymentsComponent_Conditional_18_Template, 6, 3, "div", 12);
    \u0275\u0275conditionalCreate(19, OpportunityPaymentsComponent_Conditional_19_Template, 5, 1, "div", 12);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(20, "div", 13)(21, "span", 14);
    \u0275\u0275text(22);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(23, "div", 15)(24, "div", 16)(25, "header")(26, "h2");
    \u0275\u0275text(27, "Financing");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(28, "div", 7);
    \u0275\u0275conditionalCreate(29, OpportunityPaymentsComponent_Conditional_29_Template, 3, 0, "div", 17);
    \u0275\u0275elementStart(30, "div", 4);
    \u0275\u0275conditionalCreate(31, OpportunityPaymentsComponent_Conditional_31_Template, 2, 0);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(32, "div", 18)(33, "header")(34, "h2");
    \u0275\u0275text(35, "Payments Received");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(36, OpportunityPaymentsComponent_Conditional_36_Template, 3, 0, "div", 19);
    \u0275\u0275conditionalCreate(37, OpportunityPaymentsComponent_Conditional_37_Template, 3, 0, "div", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(38, "div", 7);
    \u0275\u0275repeaterCreate(39, OpportunityPaymentsComponent_For_40_Template, 21, 10, "div", 20, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(41, OpportunityPaymentsComponent_Conditional_41_Template, 3, 0, "div", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(42, "div", 21)(43, "header")(44, "h2");
    \u0275\u0275text(45, "Payment Details");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(46, OpportunityPaymentsComponent_Conditional_46_Template, 3, 0, "div", 19);
    \u0275\u0275conditionalCreate(47, OpportunityPaymentsComponent_Conditional_47_Template, 3, 0, "div", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(48, "div", 7);
    \u0275\u0275repeaterCreate(49, OpportunityPaymentsComponent_For_50_Template, 12, 9, "div", 22, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementStart(51, "div", 23)(52, "div", 7)(53, "label");
    \u0275\u0275text(54, "Total Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(55, "div", 24)(56, "span", 14);
    \u0275\u0275text(57);
    \u0275\u0275pipe(58, "currency");
    \u0275\u0275elementEnd()()()()()()()();
    \u0275\u0275elementStart(59, "div", 4);
    \u0275\u0275conditionalCreate(60, OpportunityPaymentsComponent_Conditional_60_Template, 6, 2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" Job ", ctx.opportunity == null ? null : ctx.opportunity.jobId, " ");
    \u0275\u0275advance(9);
    \u0275\u0275textInterpolate(ctx.customerName);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.hasPhone ? 18 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.hasEmail ? 19 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", ctx.friendlyAddress, " ");
    \u0275\u0275advance(7);
    \u0275\u0275conditional(ctx.hasLenders ? 29 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.canModifyOpportunity ? 31 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx.showPaymentsWarning ? 36 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showInsufficientPaymentsWarning ? 37 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.payments);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.hasPayments ? 41 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx.paymentsMatchDeposit ? 46 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showMismatchedTotalWarning ? 47 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.details);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(58, 14, ctx.finalPrice, "USD"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.canModifyOpportunity ? 60 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, CurrencyInputComponent, NgModel, CurrencyPipe, DatePipe, PhoneFormatPipe], styles: ["\n\n#opportunityPayments[_ngcontent-%COMP%] {\n  position: relative;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  padding: 0 1vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]    > .contact-info[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]    > .contact-info[_ngcontent-%COMP%]    > .contact[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]    > .contact-info[_ngcontent-%COMP%]    > .contact[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]    > .contact-info[_ngcontent-%COMP%]    > .contact[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .address[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 1vw 0;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%] {\n  width: 50%;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  max-height: 50vw;\n  overflow-x: hidden;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color2-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  position: sticky;\n  padding: 1vw;\n  top: 0;\n  z-index: 1;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message.warning[_ngcontent-%COMP%] {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 0 1vw;\n  z-index: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]:last-child {\n  border-right: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.3vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .tips[_ngcontent-%COMP%]   .tip[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: block;\n  width: 100%;\n  font-size: 1.2vw;\n  color: var(--color4Alt4);\n  font-weight: var(--stdweight);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   currency-input[_ngcontent-%COMP%]     input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stronger);\n  text-align: right;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .messages[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: flex-end;\n  flex-direction: column;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  width: 90%;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   currency-input[_ngcontent-%COMP%]     input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content.editable[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .messages[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  margin-left: 5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-bottom-style: solid;\n  border-bottom-color: var(--color2Alt3);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--successAlt3);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%] {\n  margin-left: 5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-bottom-color: var(--color2Alt3);\n  border-bottom-style: solid;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.1vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--errorAlt4);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  padding: 0.25vw 0.5vw;\n  border-radius: 0.5vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s;\n  -o-transition: border-color 0.2s;\n  -webkit-transition: border-color 0.2s;\n  transition: border-color 0.2s;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus {\n  border-color: var(--color3);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--strong);\n  text-align: justify;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]:first-child, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]:first-child, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]:first-child, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]:first-child, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  width: 100%;\n  position: relative;\n  margin-top: 1vw;\n  padding: 1.25vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--successAlt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n  display: block;\n  width: 100%;\n  text-align: center;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]:only-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%]:first-child, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]:first-child, \n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 0 2vw;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color1);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.EPayment[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.Financing[_ngcontent-%COMP%] {\n  background-color: var(--successAlt3);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.Cash[_ngcontent-%COMP%], \n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.Check[_ngcontent-%COMP%] {\n  background-color: var(--color1);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=payments.component.css.map */"] });
var OpportunityPaymentsComponent = _OpportunityPaymentsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityPaymentsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-payments", providers: [
      OrderByPipe,
      CurrencyPipe
    ], template: `<section id="opportunityPayments" #componentElm>
  <header>
    <div class="primary">
      <h3>
        Manage Payments for
        <span class="job">
          Job {{opportunity?.jobId}}
        </span>
      </h3>
    </div>
    <div class="controls">
      <button class="control" (click)="closeView()">
        <i class="fa-solid fa-xmark"></i>
      </button>
    </div>
  </header>

  <div class="content">
    <div class="meta">
      <div class="customer">
        <div class="name">
          <h5>{{customerName}}</h5>
        </div>
        <div class="contact-info">
          @if (hasPhone) {
          <div class="contact">
            <label>Phone:</label>
            <span class="value">{{phone | phone}}</span>
          </div>
          }
          @if (hasEmail) {
          <div class="contact">
            <label>Email:</label>
            <span class="value">{{email}}</span>
          </div>
          }
        </div>
      </div>
      <div class="address">
        <span class="value">
          {{friendlyAddress}}
        </span>
      </div>
    </div>
    <div class="form">
      <div class="financing section">
        <header>
          <h2>Financing</h2>
        </header>

        <div class="content">
          @if (hasLenders) {
          <div class="lenders">
            @for (lender of lenders; track lender) {
            <div class="lender">
              <button class="control" (click)="promptToRemoveLender(lender)">
                <i class="fa-solid fa-trash"></i>
              </button>
              <div class="details">
                <div class="name">
                  <label>Lender</label>
                  <span class="value">
                    {{lender.name}}
                  </span>
                </div>
                <div class="amount">
                  <label>Approved Amount</label>
                  <div class="input">
                    <currency-input (currencyOutput)="updateLenderAmount(lender,$event)"
                      [currencyInput]="lender.amountFinanced"></currency-input>
                  </div>
                  @if (lender.amountFinanced != null && lender.amountFinanced <= 0) { <p class="message">
                    You must indicate an approval amount greater than $0.00 to include this lender on
                    the job.
                    </p>
                    }
                </div>
                <div class="application">
                  <label>Application Id</label>
                  <div class="input">
                    <input [(ngModel)]="lender.applicationId" type="text" />
                  </div>
                  @if (lender.applicationId == null) {
                  <p class="message">
                    You must indicate an application Id.
                  </p>
                  }
                </div>
                @if (lender.applied_Utc != null) {
                <div class="applied">
                  <label>Applied On</label>
                  <span class="value">
                    {{lender.applied_Utc | date: 'MM/dd/yyyy hh:mm a z'}}
                  </span>
                </div>
                }
                <!-- <div class="controls">
                  <button class="control" (click)="applyForFinancing(lender)" *ngIf="!lender.applied">
                    <label>Apply for Financing</label>
                  </button>
                </div> -->
              </div>
            </div>
            }
          </div>
          }
          <div class="controls">
            @if (canModifyOpportunity) {
              @for (method of financeMethods; track method) {
                @if (!method.added) {
                  <button class="control" (click)="addLender(method)">
                    <label>
                      Add {{method.name}}
                    </label>
                  </button>
                }
              }
            }
          </div>
        </div>
      </div>
      <div class="payments section">
        <header>
          <h2>Payments Received</h2>

          @if (showPaymentsWarning) {
          <div class="message">
            <p>A payment is required to finalize the job.</p>
          </div>
          }

          @if (showInsufficientPaymentsWarning) {
          <div class="message">
            <p>Your total payments must at least meet the deposit amount to finalize the job.</p>
          </div>
          }
        </header>

        <div class="content">
          @for (payment of payments; track payment; let i = $index) {
          <div class="payment">
            <button class="control" [disabled]="!payment.appliedManually" (click)="removePayment(i)">
              <i class="fa-solid fa-trash"></i>
            </button>
            <div class="details">
              <div class="method">
                <label>Payment Method</label>
                <span class="value">
                  {{payment.paymentMethod?.name}}
                </span>
              </div>
              <div class="amount">
                <label>Payment Amount</label>
                <span class="value">
                  {{payment.amount | currency:payment.iso4217}}
                </span>
              </div>
              <div class="timestamp">
                <label>Timestamp</label>
                <span class="value">
                  {{payment.timeStamp_Utc | date: 'MM/dd/yyyy hh:mm a'}}
                </span>
              </div>
            </div>
          </div>
          }
        </div>

        @if (!hasPayments) {
        <div class="message">
          <p>
            No payments have yet been recorded on this appointment.
          </p>
        </div>
        }
      </div>
      <div class="details section">
        <header>
          <h2>Payment Details</h2>

          @if (!paymentsMatchDeposit) {
          <div class="message">
            <p>Your recorded payments don't match the deposit amount. Are you sure your payment details are correct?</p>
          </div>
          }

          @if (showMismatchedTotalWarning) {
          <div class="message">
            <p>Your payment details don't match the total price of the job.</p>
          </div>
          }
        </header>

        <div class="content">
          @for (detail of details; track detail) {
          <div class="detail">
            <div class="content" [class.editable]="detail.canEditAmount">
              <label>
                @if (detail.canEditAmount) {
                <i class="fa-solid fa-pencil"></i>
                }
                {{detail.name}}
              </label>
              <div class="amount">
                @if (detail.canEditAmount) {
                <div class="input">
                  <currency-input [maxAmount]="detail.maximumAmount" [minAmount]="detail.minimumAmount"
                    [update]="detail.updatedAmount$" (currencyOutput)="updateDetail($event,detail)"
                    [currencyInput]="detail.amount"></currency-input>
                </div>
                }
                @if (!detail.canEditAmount) {
                <span class="value">
                  {{detail.amount | currency:'USD'}}
                </span>
                }
                <div class="messages">
                  @if (detail.maximumAmount != null && detail.amount > detail.maximumAmount) {
                  <p class="message">
                    The specified amount must be lower than {{detail.maximumAmount | currency:'USD'}}.
                  </p>
                  }
                  @if (detail.amount < detail.minimumAmount) { <p class="message">
                    The specified amount must be higher than {{detail.minimumAmount | currency:'USD'}}.
                    </p>
                    }
                </div>
              </div>
              @if (detail.lenderAmounts.length > 0) {
              <div class="lender-amounts">
                @for (amount of detail.lenderAmounts; track amount) {
                <div class="amount">
                  <label>
                    Amount Financed by {{amount.name}}
                  </label>
                  <div class="input">
                    <currency-input (currencyOutput)="updateDetailLenderAmount($event,amount)"
                      [currencyInput]="amount.amount"></currency-input>
                  </div>
                  @if (amount.amount == null) {
                  <p class="message">
                    You must enter an amount, even if it's $0.00.
                  </p>
                  }
                </div>
                }
              </div>
              }
            </div>
          </div>
          }
          <div class="detail total">
            <div class="content">
              <label>Total Amount</label>
              <div class="amount">
                <span class="value">
                  {{finalPrice | currency:'USD'}}
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="controls">
    <!-- <button class="control {{method.type}}" *ngFor="let method of transactMethods" [disabled]="!canMakePayment"
  (click)="makePayment(method)">
  <label *ngIf="method.type == PaymentMethodType.Financing">
    Apply for {{method.name}}
  </label>
  <label *ngIf="method.type == PaymentMethodType.EPayment">Pay by {{method.name}}</label>
</button> -->
    @if (canModifyOpportunity) {
      <button class="control" [disabled]="!canMakePayment" (click)="makePayment()">
        <label>Record an External Payment</label>
      </button>
      <button class="control success" [disabled]="!canSave" (click)="save()">
        <label>Save & Close</label>
      </button>
    }
  </div>
</section>`, styles: ["/* src/app/shared/opportunities/components/payments/payments.component.scss */\n#opportunityPayments {\n  position: relative;\n}\n#opportunityPayments > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#opportunityPayments > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#opportunityPayments > header > .primary > h3 > .job {\n  color: var(--color5);\n}\n#opportunityPayments > header > .controls > .control {\n  cursor: pointer;\n}\n#opportunityPayments > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#opportunityPayments > .content > .meta {\n  padding: 0 1vw;\n}\n#opportunityPayments > .content > .meta > .customer > .name h5 {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .meta > .customer > .contact-info {\n  margin-top: 0.5vw;\n}\n#opportunityPayments > .content > .meta > .customer > .contact-info > .contact {\n  display: flex;\n  align-items: center;\n}\n#opportunityPayments > .content > .meta > .customer > .contact-info > .contact > label {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .meta > .customer > .contact-info > .contact > .value {\n  margin-left: 0.5vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#opportunityPayments > .content > .meta > .address > .value {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .form {\n  margin-top: 1vw;\n  padding: 1vw 0;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#opportunityPayments > .content > .form > .section {\n  width: 50%;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  max-height: 50vw;\n  overflow-x: hidden;\n}\n#opportunityPayments > .content > .form > .section > header {\n  background-color: rgba(var(--color2-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  position: sticky;\n  padding: 1vw;\n  top: 0;\n  z-index: 1;\n}\n#opportunityPayments > .content > .form > .section > header h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityPayments > .content > .form > .section > header > .message {\n  margin-top: 0.5vw;\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#opportunityPayments > .content > .form > .section > header > .message p {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#opportunityPayments > .content > .form > .section > header > .message.warning {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#opportunityPayments > .content > .form > .section > .content {\n  position: relative;\n  padding: 0 1vw;\n  z-index: 0;\n}\n#opportunityPayments > .content > .form > .section:last-child {\n  border-right: none;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail {\n  margin-top: 1vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content {\n  width: 100%;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > label {\n  display: block;\n  width: 100%;\n  font-size: 1.3vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .tips .tip {\n  margin-top: 0.25vw;\n  display: block;\n  width: 100%;\n  font-size: 1.2vw;\n  color: var(--color4Alt4);\n  font-weight: var(--stdweight);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .amount {\n  margin-top: 0.25vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .amount > .input {\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .amount > .input currency-input ::ng-deep input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .amount > .value {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stronger);\n  text-align: right;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .amount > .messages > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts {\n  margin-top: 0.25vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts > .amount {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: flex-end;\n  flex-direction: column;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts > .amount > label {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts > .amount > .input {\n  width: 90%;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts > .amount > .input currency-input ::ng-deep input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts > .amount > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content > .lender-amounts > .amount:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .content.editable > label {\n  color: var(--color1);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail > .messages > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.total {\n  margin-top: 2vw;\n  margin-left: 5vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.total > .content {\n  border-bottom-style: solid;\n  border-bottom-color: var(--color2Alt3);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.total > .content > label {\n  font-size: 1.2vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.total > .content > .amount > .value {\n  font-size: 1.4vw;\n  color: var(--successAlt3);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.remaining {\n  margin-left: 5vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.remaining > .content {\n  border-bottom-color: var(--color2Alt3);\n  border-bottom-style: solid;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.remaining > .content > label {\n  font-size: 1.1vw;\n}\n#opportunityPayments > .content > .form > .details > .content > .detail.remaining > .content > .amount > .value {\n  font-size: 1.2vw;\n  color: var(--errorAlt4);\n}\n#opportunityPayments > .content > .form > .details > .content > .detail:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application {\n  margin-top: 0.5vw;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name label,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount label,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp label,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied label,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application label {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name > .value,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount > .value,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp > .value,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied > .value,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application > .value {\n  display: block;\n  font-size: 1.2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name > .input ::ng-deep input,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount > .input ::ng-deep input,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp > .input ::ng-deep input,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied > .input ::ng-deep input,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application > .input ::ng-deep input {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  padding: 0.25vw 0.5vw;\n  border-radius: 0.5vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s;\n  -o-transition: border-color 0.2s;\n  -webkit-transition: border-color 0.2s;\n  transition: border-color 0.2s;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name > .input ::ng-deep input:focus,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount > .input ::ng-deep input:focus,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp > .input ::ng-deep input:focus,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied > .input ::ng-deep input:focus,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application > .input ::ng-deep input:focus {\n  border-color: var(--color3);\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name > .message,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount > .message,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp > .message,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied > .message,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application > .message {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--strong);\n  text-align: justify;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name:first-child,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .amount:first-child,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .timestamp:first-child,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .applied:first-child,\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .application:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .name label {\n  font-size: 1.4vw;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .controls {\n  margin-top: 1vw;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .controls > .control {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .controls > .control > label {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .details > .controls > .control:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#opportunityPayments > .content > .form > .financing > .content > .lenders > .lender:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .financing > .content > .controls {\n  margin-top: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#opportunityPayments > .content > .form > .financing > .content > .controls > .control {\n  width: 100%;\n  position: relative;\n  margin-top: 1vw;\n  padding: 1.25vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--successAlt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityPayments > .content > .form > .financing > .content > .controls > .control > label {\n  font-size: 1.8vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n  display: block;\n  width: 100%;\n  text-align: center;\n}\n#opportunityPayments > .content > .form > .financing > .content > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityPayments > .content > .form > .financing > .content > .controls > .control:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .financing > .content > .controls:only-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .method,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .amount,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .timestamp {\n  margin-top: 0.5vw;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .method label,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .amount label,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .timestamp label {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .method > .value,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .amount > .value,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .timestamp > .value {\n  display: block;\n  font-size: 1.2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .method:first-child,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .amount:first-child,\n#opportunityPayments > .content > .form > .payments > .content > .payment > .details > .timestamp:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#opportunityPayments > .content > .form > .payments > .content > .payment:first-child {\n  margin-top: 0;\n}\n#opportunityPayments > .content > .form > .payments > .message {\n  margin-top: 1vw;\n  padding: 0 2vw;\n}\n#opportunityPayments > .content > .form > .payments > .message p {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#opportunityPayments > .controls {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#opportunityPayments > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color1);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#opportunityPayments > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#opportunityPayments > .controls > .control.EPayment {\n  background-color: var(--color5);\n}\n#opportunityPayments > .controls > .control.Financing {\n  background-color: var(--successAlt3);\n}\n#opportunityPayments > .controls > .control.Cash,\n#opportunityPayments > .controls > .control.Check {\n  background-color: var(--color1);\n}\n#opportunityPayments > .controls > .control.success {\n  background-color: var(--success);\n}\n#opportunityPayments > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#opportunityPayments > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=payments.component.css.map */\n"] }]
  }], () => [{ type: OpportunityService }, { type: OpportunityUiService }, { type: PaymentsService }, { type: AuthRefService }, { type: UiService }, { type: OrderByPipe }, { type: CurrencyPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunityPaymentsComponent, { className: "OpportunityPaymentsComponent" });
})();

// src/app/shared/helpers/models/responses.ts
var GeneralResponseState;
(function(GeneralResponseState2) {
  GeneralResponseState2["Successful"] = "Successful";
  GeneralResponseState2["GeneralFailure"] = "GeneralFailure";
  GeneralResponseState2["StorageFailure"] = "StorageFailure";
  GeneralResponseState2["DataConflict"] = "DataConflict";
  GeneralResponseState2["IncorrectInput"] = "IncorrectInput";
  GeneralResponseState2["MissingData"] = "MissingData";
})(GeneralResponseState || (GeneralResponseState = {}));

// src/app/shared/opportunities/components/send-for-signing/send-for-signing.component.ts
var _SendDocumentsForSigningComponent = class _SendDocumentsForSigningComponent {
  constructor(opportunityUiService, opportunityService, authRefService, uiService, orderByPipe) {
    this.opportunityUiService = opportunityUiService;
    this.opportunityService = opportunityService;
    this.authRefService = authRefService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.activeUser = null;
    this.validPhone = false;
    this.sendingDocuments = false;
    this.sentDocuments = false;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  get validEmail() {
    return this.email != null && this.email.length > 1 && this.email.includes("@");
  }
  updatePhone(result) {
    this.phone = result.sanitizedNumber;
    const validation = parsePhoneNumber(result.sanitizedNumber, { regionCode: "US" });
    this.sanitizedPhone = validation.number?.national;
    this.validPhone = validation.valid;
  }
  get validRecipient() {
    return this.recipientName != null && this.recipientName.length > 0;
  }
  get recipientText() {
    if (this.email != null && this.email.length > 0 && this.sanitizedPhone != null) {
      return `${this.email} and ${this.sanitizedPhone}`;
    } else if (this.email != null && this.email.length > 0) {
      return this.email;
    } else if (this.sanitizedPhone != null) {
      return this.sanitizedPhone;
    }
    return "";
  }
  initRecipient() {
    if (this.opportunity?.customer != null) {
      this.email = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.Email)?.value;
      this.phone = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone)?.value;
      this.recipientName = `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
    }
  }
  get canSendDocuments() {
    return !this.sendingDocuments && (this.email != null && this.email.length > 0 && this.email.includes("@") || this.phone != null && this.phone.length >= 7);
  }
  generatePrice() {
    const price = this.opportunity?.customPrice ?? this.opportunity?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.opportunity?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  /* TEMP: For performance reasons. Revert if photos become required for customer signing */
  stripPhotosFromContent(entities) {
    entities.forEach((entity) => {
      entity.photos = [];
      entity.photos_B64 = [];
      entity.fixtures.forEach((fixture) => {
        fixture.photos = [];
        fixture.photos_B64 = [];
      });
      this.stripPhotosFromContent(entity.entities);
    });
  }
  generateContent() {
    if (this.opportunity?.property != null && this.recipientName != null) {
      const property = deepClone(this.opportunity.property);
      if (property?.entity != null) {
        this.stripPhotosFromContent(property.entity.entities);
      }
      const recipient = new DocumentSigner(this.opportunity.id, this.recipientName, false, this.phone, this.email, DocumentSignerType.Customer);
      const documents = [];
      this.opportunity.documents.forEach((document2) => {
        if (document2.displayInSigning && document2.customerFacing) {
          documents.push(document2);
        }
      });
      if (recipient != null) {
        const content = {
          opportunityId: this.opportunity.id,
          created_Utc: this.opportunity.scheduled_Utc,
          lastUpdated_Utc: /* @__PURE__ */ new Date(),
          scheduled_Utc: this.opportunity.scheduled_Utc,
          property,
          jobId: this.opportunity.jobId?.toString(),
          job: this.opportunity.job,
          consultant: this.opportunity.assignedTo,
          customer: this.opportunity.customer,
          price: this.generatePrice(),
          documents,
          payments: this.generatePayments(),
          recipient,
          completed: false
        };
        return content;
      }
    }
    return void 0;
  }
  sendDocumentsToCustomer() {
    const content = this.generateContent();
    if (content != null && this.opportunity != null && this.activeUser != null && !this.sendingDocuments && (this.email != null || this.phone != null) && this.recipientName != null) {
      const opportunity = this.opportunity;
      const activeUser = this.activeUser;
      this.sendingDocuments = true;
      this.uiService.prompt("Send Documents to Customer?", `An e-mail containing all the customer facing documents will be sent to ${this.recipientName} at ${this.recipientText}.`, "Send Documents", "Cancel").subscribe({
        next: (confirmed) => {
          if (confirmed && this.opportunity != null && this.recipientName != null) {
            this.opportunityService.sendDocumentsToCustomer(opportunity, content, this.recipientName, activeUser, this.email, this.phone).subscribe({
              next: (response) => {
                if (response.state == GeneralResponseState.Successful && response.data != null) {
                  var signingKey = response.data;
                  this.uiService.prompt("Documents Sent", "The job documents were successfully sent to the customer.", "Okay").subscribe({
                    next: (confirmed2) => {
                      this.sentDocuments = true;
                      this.sendingDocuments = false;
                    }
                  });
                }
                this.sendingDocuments = false;
              },
              error: () => {
                this.uiService.prompt("Failed to Send Documents", "There was an issue sending the job documents to the customer. Please try again.", "Okay").subscribe({
                  next: (confirmed2) => {
                    this.sendingDocuments = false;
                  }
                });
              }
            });
          } else {
            this.sendingDocuments = false;
          }
        }
      });
    }
  }
  // #endregion
  // #region Bootstrapping
  closeView() {
    if (this.sentDocuments) {
      this.opportunityUiService.stopSendingDocuments(this.opportunity?.id);
    } else {
      this.opportunityUiService.stopSendingDocuments();
    }
  }
  init() {
    this.watchUser();
    this.initRecipient();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
  }
};
_SendDocumentsForSigningComponent.\u0275fac = function SendDocumentsForSigningComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SendDocumentsForSigningComponent)(\u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_SendDocumentsForSigningComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SendDocumentsForSigningComponent, selectors: [["send-for-signing"]], inputs: { opportunity: "opportunity", email: "email", phone: "phone" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe
])], decls: 29, vars: 4, consts: [["id", "sendDocuments"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "form"], [1, "input-wrap"], [1, "input"], ["disabled", "", "type", "text", 3, "ngModelChange", "ngModel"], ["type", "email", 3, "ngModelChange", "ngModel"], [3, "numberOutput", "numberInput"], [1, "control", "success", 3, "click", "disabled"]], template: function SendDocumentsForSigningComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "h3");
    \u0275\u0275text(4, "Send Documents for Signing");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 2)(6, "button", 3);
    \u0275\u0275listener("click", function SendDocumentsForSigningComponent_Template_button_click_6_listener() {
      return ctx.closeView();
    });
    \u0275\u0275element(7, "i", 4);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 5)(9, "div", 6)(10, "div", 7)(11, "label");
    \u0275\u0275text(12, "Recipient");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "div", 8)(14, "input", 9);
    \u0275\u0275twoWayListener("ngModelChange", function SendDocumentsForSigningComponent_Template_input_ngModelChange_14_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.recipientName, $event) || (ctx.recipientName = $event);
      return $event;
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(15, "div", 7)(16, "label");
    \u0275\u0275text(17, "E-mail Address");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "div", 8)(19, "input", 10);
    \u0275\u0275twoWayListener("ngModelChange", function SendDocumentsForSigningComponent_Template_input_ngModelChange_19_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.email, $event) || (ctx.email = $event);
      return $event;
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(20, "div", 7)(21, "label");
    \u0275\u0275text(22, "Phone Number");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(23, "div", 8)(24, "phone-input", 11);
    \u0275\u0275listener("numberOutput", function SendDocumentsForSigningComponent_Template_phone_input_numberOutput_24_listener($event) {
      return ctx.updatePhone($event);
    });
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(25, "div", 2)(26, "button", 12);
    \u0275\u0275listener("click", function SendDocumentsForSigningComponent_Template_button_click_26_listener() {
      return ctx.sendDocumentsToCustomer();
    });
    \u0275\u0275elementStart(27, "label");
    \u0275\u0275text(28, "Send for Signing");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(14);
    \u0275\u0275twoWayProperty("ngModel", ctx.recipientName);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.email);
    \u0275\u0275advance(5);
    \u0275\u0275property("numberInput", ctx.phone);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canSendDocuments);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, PhoneInputComponent, NgModel], styles: ["\n\n#sendDocuments[_ngcontent-%COMP%] {\n  position: relative;\n}\n#sendDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#sendDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#sendDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  max-height: 60vw;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .tip[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select, \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 2.6vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select:focus, \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[disabled][_ngcontent-%COMP%], \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input[disabled], \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select[disabled], \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[disabled][_ngcontent-%COMP%] {\n  color: var(--color1Alt3);\n  opacity: 0.8;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  align-items: center;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     input, \n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     select {\n  border: none;\n  border-radius: 0;\n  background-color: transparent;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     input {\n  flex: 1;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     select {\n  width: 25%;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]:focus-within {\n  border-color: var(--color3);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#sendDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=send-for-signing.component.css.map */"] });
var SendDocumentsForSigningComponent = _SendDocumentsForSigningComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SendDocumentsForSigningComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "send-for-signing", providers: [
      OrderByPipe
    ], template: '<section id="sendDocuments">\n  <header>\n    <div class="primary">\n      <h3>Send Documents for Signing</h3>\n    </div>\n    <div class="controls">\n      <button class="control" (click)="closeView()">\n        <i class="fa-solid fa-xmark"></i>\n      </button>\n    </div>\n  </header>\n  <div class="content">\n    <div class="form">\n      <div class="input-wrap">\n        <label>Recipient</label>\n        <div class="input">\n          <input disabled [(ngModel)]="recipientName" type="text" />\n        </div>\n      </div>\n      <div class="input-wrap">\n        <label>E-mail Address</label>\n        <div class="input">\n          <input [(ngModel)]="email" type="email" />\n        </div>\n      </div>\n      <div class="input-wrap">\n        <label>Phone Number</label>\n        <div class="input">\n          <phone-input [numberInput]="phone" (numberOutput)="updatePhone($event)"></phone-input>\n        </div>\n      </div>\n    </div>\n  </div>\n  <div class="controls">\n    <button class="control success" [disabled]="!canSendDocuments" (click)="sendDocumentsToCustomer()">\n      <label>Send for Signing</label>\n    </button>\n  </div>\n</section>', styles: ["/* src/app/shared/opportunities/components/send-for-signing/send-for-signing.component.scss */\n#sendDocuments {\n  position: relative;\n}\n#sendDocuments > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#sendDocuments > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendDocuments > header > .controls > .control {\n  cursor: pointer;\n}\n#sendDocuments > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendDocuments > .content {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  max-height: 60vw;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#sendDocuments > .content > .form > .input-wrap {\n  margin-top: 1vw;\n}\n#sendDocuments > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendDocuments > .content > .form > .input-wrap > .tip {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#sendDocuments > .content > .form > .input-wrap > .input {\n  margin-top: 0.5vw;\n}\n#sendDocuments > .content > .form > .input-wrap > .input input,\n#sendDocuments > .content > .form > .input-wrap > .input ::ng-deep input,\n#sendDocuments > .content > .form > .input-wrap > .input ::ng-deep select,\n#sendDocuments > .content > .form > .input-wrap > .input select {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 2.6vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#sendDocuments > .content > .form > .input-wrap > .input input:focus,\n#sendDocuments > .content > .form > .input-wrap > .input ::ng-deep input:focus,\n#sendDocuments > .content > .form > .input-wrap > .input ::ng-deep select:focus,\n#sendDocuments > .content > .form > .input-wrap > .input select:focus {\n  border-color: var(--color3);\n}\n#sendDocuments > .content > .form > .input-wrap > .input input[disabled],\n#sendDocuments > .content > .form > .input-wrap > .input ::ng-deep input[disabled],\n#sendDocuments > .content > .form > .input-wrap > .input ::ng-deep select[disabled],\n#sendDocuments > .content > .form > .input-wrap > .input select[disabled] {\n  color: var(--color1Alt3);\n  opacity: 0.8;\n}\n#sendDocuments > .content > .form > .input-wrap > .input > phone-input {\n  display: flex;\n  width: 100%;\n  align-items: center;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#sendDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep input,\n#sendDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep select {\n  border: none;\n  border-radius: 0;\n  background-color: transparent;\n}\n#sendDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep input {\n  flex: 1;\n}\n#sendDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep select {\n  width: 25%;\n}\n#sendDocuments > .content > .form > .input-wrap > .input > phone-input:focus-within {\n  border-color: var(--color3);\n}\n#sendDocuments > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#sendDocuments > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#sendDocuments > .controls {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#sendDocuments > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#sendDocuments > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#sendDocuments > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#sendDocuments > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#sendDocuments > .controls > .control.success {\n  background-color: var(--success);\n}\n#sendDocuments > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#sendDocuments > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#sendDocuments > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#sendDocuments > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#sendDocuments > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=send-for-signing.component.css.map */\n"] }]
  }], () => [{ type: OpportunityUiService }, { type: OpportunityService }, { type: AuthRefService }, { type: UiService }, { type: OrderByPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], email: [{
    type: Input,
    args: ["email"]
  }], phone: [{
    type: Input,
    args: ["phone"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SendDocumentsForSigningComponent, { className: "SendDocumentsForSigningComponent" });
})();

// src/app/shared/opportunities/components/send-executed-documents/send-executed-documents.component.ts
var _c05 = ["previewElm"];
var _c12 = ["exportElm"];
var _c22 = ["documentElm"];
function SendExecutedDocumentsComponent_Conditional_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13);
    \u0275\u0275element(1, "loader", 27);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Preparing Documents");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("fill", false);
  }
}
function SendExecutedDocumentsComponent_Conditional_22_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 15)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("You are currently offline. Please try sending signed documents when you're back online, or you can save and share the quote from your ", ctx_r1.deviceStr, ".");
  }
}
function SendExecutedDocumentsComponent_Conditional_40_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 28);
    \u0275\u0275element(1, "div", 29);
    \u0275\u0275elementStart(2, "div", 30);
    \u0275\u0275element(3, "loader", 27);
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, "Preparing & Saving Documents");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingExportingDocuments);
    \u0275\u0275advance(3);
    \u0275\u0275property("fill", true);
  }
}
function SendExecutedDocumentsComponent_Conditional_41_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 32);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(2, 1, ctx_r1.sendDocumentsProgress), "%");
  }
}
function SendExecutedDocumentsComponent_Conditional_41_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 33);
    \u0275\u0275text(1, "E-Mail Processing");
    \u0275\u0275elementEnd();
  }
}
function SendExecutedDocumentsComponent_Conditional_41_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "aside", 31);
    \u0275\u0275element(1, "div", 29);
    \u0275\u0275elementStart(2, "div", 30)(3, "button", 6);
    \u0275\u0275listener("click", function SendExecutedDocumentsComponent_Conditional_41_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.promptToStopSendingDocuments());
    });
    \u0275\u0275element(4, "i", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 13);
    \u0275\u0275conditionalCreate(6, SendExecutedDocumentsComponent_Conditional_41_Conditional_6_Template, 3, 3, "span", 32);
    \u0275\u0275conditionalCreate(7, SendExecutedDocumentsComponent_Conditional_41_Conditional_7_Template, 2, 0, "span", 33);
    \u0275\u0275element(8, "loader", 34);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Preparing & Sending Documents");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingSendDocuments);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(!ctx_r1.showDocumentsProcessing ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showDocumentsProcessing ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("progress", true)("percent", ctx_r1.sendDocumentsProgress);
  }
}
function SendExecutedDocumentsComponent_For_46_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "opportunity-document", 35, 2);
    \u0275\u0275listener("rendered", function SendExecutedDocumentsComponent_For_46_Template_opportunity_document_rendered_0_listener() {
      const document_r5 = \u0275\u0275restoreView(_r4).$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.renderDocument(document_r5));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const document_r5 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("content", ctx_r1.content)("opportunity", ctx_r1.opportunity)("signing", true)("document", document_r5);
  }
}
var _SendExecutedDocumentsComponent = class _SendExecutedDocumentsComponent {
  constructor(opportunityUiService, opportunityService, contentService, authRefService, logService, apiService, uiService, orderByPipe) {
    this.opportunityUiService = opportunityUiService;
    this.opportunityService = opportunityService;
    this.contentService = contentService;
    this.authRefService = authRefService;
    this.logService = logService;
    this.apiService = apiService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.online = false;
    this.activeUser = null;
    this.exportingDocuments = false;
    this.closingExportingDocuments = false;
    this.documentElms = new QueryList();
    this.sendingDocuments = false;
    this.closingSendDocuments = false;
    this.renderingDocuments = true;
    this.renderedDocuments = [];
    this.documents = [];
    this.sendDocumentsProgress = new BehaviorSubject(0);
    this.close = new Subject();
  }
  watchOnline() {
    this.apiService.online.subscribe({
      next: (online) => {
        this.online = online;
      }
    });
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  get validEmail() {
    return this.email != null && this.email.length > 1 && this.email.includes("@");
  }
  get validRecipient() {
    return this.recipientName != null && this.recipientName.length > 0;
  }
  initRecipient() {
    if (this.opportunity?.customer != null) {
      this.email = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.Email)?.value;
      this.recipientName = `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
    }
  }
  get canExport() {
    return !this.exportingDocuments && !this.renderingDocuments;
  }
  get deviceStr() {
    if (Capacitor.isNativePlatform()) {
      return "iPad";
    } else {
      return "Device";
    }
  }
  stopExportingDocuments() {
    window.clearTimeout(this.exportingDocumentsTimer);
    this.closingExportingDocuments = true;
    this.exportingDocumentsTimer = window.setTimeout(() => {
      this.exportingDocuments = false;
      this.closingExportingDocuments = false;
    }, 250);
  }
  renderForExport() {
    const opportunity = this.opportunity;
    const customer = opportunity?.customer;
    if (opportunity != null && customer != null) {
      this.exportingDocuments = true;
      setTimeout(() => __async(this, null, function* () {
        const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
        const fileName = `Signed Documents - Job ${opportunity.jobId} ${customer.lastName} - ${(/* @__PURE__ */ new Date()).toISOString()}.pdf`;
        setTimeout(() => __async(this, null, function* () {
          if (Capacitor.isNativePlatform()) {
            const base64 = this.contentService.convertBytesToBase64(pdfRender.pdf);
            yield Filesystem.writeFile({
              path: fileName,
              data: base64,
              directory: Directory.Cache
            }).then((writeResult) => __async(this, null, function* () {
              yield Share.share({
                title: "Save Documents",
                url: writeResult.uri,
                dialogTitle: "Save Documents to Files"
              });
              this.uiService.prompt("Documents Saved", `Your documents have been saved to your ${this.deviceStr}.`, "Okay").subscribe({ next: () => this.stopExportingDocuments() });
            })).catch(() => {
              this.uiService.prompt("Failed to Save", "There was an issue saving the documents. Please try again.", "Okay").subscribe({ next: () => this.stopExportingDocuments() });
            });
          } else {
            const pdfBlob = this.contentService.convertBytesToBlob(pdfRender.pdf, "application/pdf");
            const url = window.URL.createObjectURL(pdfBlob);
            const link = document.createElement("a");
            link.href = url;
            link.download = fileName;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            window.URL.revokeObjectURL(url);
            this.uiService.prompt("Documents Saved", "The documents were successfully downloaded to your device.", "Okay").subscribe({
              next: () => {
                this.stopExportingDocuments();
              }
            });
          }
        }), 0);
      }), 2e3);
    }
  }
  get showDocumentsProcessing() {
    const progress = this.sendDocumentsProgress.getValue();
    return progress == 100;
  }
  get canSend() {
    return !this.sendingDocuments && !this.renderingDocuments && this.validRecipient && this.validEmail && this.online;
  }
  initDocuments() {
    if (this.opportunity != null) {
      this.opportunity.documents.forEach((document2) => {
        if (document2.customerFacing) {
          this.documents.push(document2);
        }
      });
      this.documents = this.orderByPipe.transform(this.documents, "displayOrder", false);
    }
  }
  sortRenderedDocuments() {
    if (this.renderedDocuments != null && this.renderedDocuments.length > 0) {
      this.renderedDocuments = this.orderByPipe.transform(this.renderedDocuments, "displayOrder", false);
    }
  }
  checkFinalizeRender() {
    if (this.renderedDocuments.length == this.documents.length) {
      this.sortRenderedDocuments();
      this.renderDocuments();
    }
  }
  renderDocuments() {
    const previewElm = this.previewElm?.nativeElement;
    if (previewElm != null) {
      this.renderedDocuments.forEach((document2) => {
        if (document2.image != null) {
          previewElm.appendChild(document2.image);
        } else if (document2.canvas != null) {
          previewElm.appendChild(document2.canvas);
        }
      });
    }
    this.renderingDocuments = false;
  }
  renderDocument(document2) {
    const documentElm = this.documentElms.find((x) => x.document?.id == document2.id);
    if (documentElm != null) {
      documentElm.exportDocument(1, 1).then((canvas) => {
        const renderedDocument = {
          displayOrder: document2.displayOrder,
          name: document2.name,
          canvas,
          image: void 0
        };
        if (this.renderedDocuments != null) {
          this.renderedDocuments.push(renderedDocument);
        } else {
          this.renderedDocuments = [renderedDocument];
        }
        this.checkFinalizeRender();
      }).catch((e) => {
        this.logService.log(JSON.stringify(e), `Failed to render executed documents ${document2.id} for opportunity ${this.opportunity?.id}.`).subscribe();
      });
    }
  }
  startSendingDocuments() {
    if (!this.sendingDocuments && this.validRecipient && this.validEmail && this.online) {
      this.uiService.prompt("Send Documents?", `A digital copy of the executed documents will be prepared and sent to ${this.recipientName} at ${this.email}.
                    Are you sure you want to send the documents?`, "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.sendingDocuments = true;
            this.renderAndSend();
          }
        }
      });
    }
  }
  stopSendingDocuments() {
    window.clearTimeout(this.documentsTimer);
    this.closingSendDocuments = true;
    this.documentsTimer = window.setTimeout(() => {
      this.sendingDocuments = false;
      this.closingSendDocuments = false;
    }, 250);
  }
  promptToStopSendingDocuments() {
    this.uiService.prompt("Don't Want to Wait?", "Your documents may still be sent. Are you sure you want to stop waiting?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.stopSendingDocuments();
        }
      }
    });
  }
  renderAndSend() {
    const recipientName = this.recipientName;
    const recipientEmail = this.email;
    if (this.opportunity != null && this.activeUser != null && recipientEmail != null && recipientName != null) {
      const opportunity = this.opportunity;
      const activeUser = this.activeUser;
      setTimeout(() => __async(this, null, function* () {
        const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
        this.sendingDocumentsTimeout = window.setTimeout(() => {
          this.uiService.prompt("Taking a While?", "Sending the documents seems to be taking a while. You may be on a poor connection or experiencing other issues. Do you want to cancel and try again later?", "Yes, Try Later", "No, Keep Waiting").subscribe({
            next: (confirmed) => {
              if (confirmed) {
                this.stopSendingDocuments();
              }
            }
          });
        }, 45e3);
        this.opportunityService.sendFinalDocuments(opportunity, pdfRender.pdf, recipientName, recipientEmail, activeUser).subscribe({
          next: (e) => {
            if ("progress" in e) {
              this.sendDocumentsProgress.next(e.progress);
            } else {
              window.clearTimeout(this.sendingDocumentsTimeout);
              this.uiService.prompt("Documents Sent Successfully", `The documents were successfully sent to ${recipientName}`, "Okay").subscribe({
                next: () => {
                  this.stopSendingDocuments();
                  this.opportunityUiService.stopSendingExecutedDocuments();
                }
              });
            }
          },
          error: (e) => {
            window.clearTimeout(this.sendingDocumentsTimeout);
            this.uiService.prompt("Failed to Send Documents", "There was an issue sending the documents. Please try again or contact support.", "Okay").subscribe({
              next: () => {
                this.stopSendingDocuments();
              }
            });
          }
        });
      }), 2e3);
    } else {
      this.stopSendingDocuments();
    }
  }
  initQuoting() {
    this.generateContent();
    this.initDocuments();
  }
  generatePrice() {
    const price = this.opportunity?.customPrice ?? this.opportunity?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.opportunity?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.opportunity != null) {
      const content = {
        opportunityId: this.opportunity.id,
        created_Utc: this.opportunity.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.opportunity.scheduled_Utc,
        property: this.opportunity.property,
        jobId: this.opportunity.jobId?.toString(),
        job: this.opportunity.job,
        consultant: this.opportunity.assignedTo,
        customer: this.opportunity.customer,
        price: this.generatePrice(),
        documents: this.opportunity.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  closeView() {
    this.close.next();
  }
  init() {
    this.watchUser();
    this.watchOnline();
    this.initRecipient();
    this.initQuoting();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.onlineSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_SendExecutedDocumentsComponent.\u0275fac = function SendExecutedDocumentsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SendExecutedDocumentsComponent)(\u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_SendExecutedDocumentsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SendExecutedDocumentsComponent, selectors: [["send-executed-documents"]], viewQuery: function SendExecutedDocumentsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c05, 5);
    \u0275\u0275viewQuery(_c12, 5);
    \u0275\u0275viewQuery(_c22, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.previewElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.exportElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.documentElms = _t);
  }
}, inputs: { opportunity: "opportunity", email: "email" }, outputs: { close: "close" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe
])], decls: 47, vars: 9, consts: [["previewElm", ""], ["exportElm", ""], ["documentElm", ""], ["id", "sendExecutedDocuments"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "preview"], [1, "preview-wrap"], [1, "render-wrap"], [1, "render"], [1, "loader"], [1, "form"], [1, "message", "warning"], [1, "input-wrap"], [1, "input"], ["type", "text", 3, "ngModelChange", "ngModel"], ["type", "email", 3, "ngModelChange", "ngModel"], [1, "control", 3, "click", "disabled"], [1, "control", "success", 3, "click", "disabled"], ["id", "exportingDocuments", 3, "closing"], ["id", "sendingDocuments", 3, "closing"], ["id", "renderingDocuments"], [1, "document"], [3, "content", "opportunity", "signing", "document"], [3, "fill"], ["id", "exportingDocuments"], [1, "bg"], [1, "modal"], ["id", "sendingDocuments"], [1, "progress"], [1, "processing"], [3, "progress", "percent"], [3, "rendered", "content", "opportunity", "signing", "document"]], template: function SendExecutedDocumentsComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 3)(1, "header")(2, "div", 4)(3, "h3");
    \u0275\u0275text(4, "Review Signed Documents");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 5)(6, "button", 6);
    \u0275\u0275listener("click", function SendExecutedDocumentsComponent_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275element(7, "i", 7);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 8)(9, "div", 9)(10, "header")(11, "h4");
    \u0275\u0275text(12, "Previewing Documents");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(13, "div", 10)(14, "div", 11);
    \u0275\u0275element(15, "div", 12, 0);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(17, SendExecutedDocumentsComponent_Conditional_17_Template, 4, 1, "div", 13);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 14)(19, "header")(20, "h3");
    \u0275\u0275text(21, "E-Mail to Customer");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(22, SendExecutedDocumentsComponent_Conditional_22_Template, 3, 1, "div", 15);
    \u0275\u0275elementStart(23, "div", 16)(24, "label");
    \u0275\u0275text(25, "Recipient");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "div", 17)(27, "input", 18);
    \u0275\u0275twoWayListener("ngModelChange", function SendExecutedDocumentsComponent_Template_input_ngModelChange_27_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.recipientName, $event) || (ctx.recipientName = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(28, "div", 16)(29, "label");
    \u0275\u0275text(30, "E-mail Address");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(31, "div", 17)(32, "input", 19);
    \u0275\u0275twoWayListener("ngModelChange", function SendExecutedDocumentsComponent_Template_input_ngModelChange_32_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.email, $event) || (ctx.email = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(33, "div", 5)(34, "button", 20);
    \u0275\u0275listener("click", function SendExecutedDocumentsComponent_Template_button_click_34_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.renderForExport());
    });
    \u0275\u0275elementStart(35, "label");
    \u0275\u0275text(36);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(37, "button", 21);
    \u0275\u0275listener("click", function SendExecutedDocumentsComponent_Template_button_click_37_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.startSendingDocuments());
    });
    \u0275\u0275elementStart(38, "label");
    \u0275\u0275text(39, "Send Documents");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275conditionalCreate(40, SendExecutedDocumentsComponent_Conditional_40_Template, 6, 3, "aside", 22);
    \u0275\u0275conditionalCreate(41, SendExecutedDocumentsComponent_Conditional_41_Template, 11, 6, "aside", 23);
    \u0275\u0275elementStart(42, "aside", 24)(43, "div", 25, 1);
    \u0275\u0275repeaterCreate(45, SendExecutedDocumentsComponent_For_46_Template, 2, 4, "opportunity-document", 26, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(17);
    \u0275\u0275conditional(ctx.renderingDocuments ? 17 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx.online ? 22 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.recipientName);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.email);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canExport);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Save to ", ctx.deviceStr, " or Share");
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canSend);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.exportingDocuments ? 40 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.sendingDocuments ? 41 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx.documents);
  }
}, dependencies: [OpportunityDocumentComponent, DefaultValueAccessor, NgControlStatus, LoaderComponent, NgModel, AsyncPipe], styles: ["\n\n#sendExecutedDocuments[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  flex: 1;\n  display: flex;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%] {\n  width: calc(60% - 0.5vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-top-right-radius: 0.5vw;\n  border-bottom-right-radius: 0.5vw;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 2;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     canvas, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     img {\n  display: block;\n  width: 100%;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%] {\n  width: calc(40% - 0.5vw);\n  margin-left: 1vw;\n  padding: 1vw;\n  overflow-x: hidden;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  margin-bottom: 1vw;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .message.warning[_ngcontent-%COMP%] {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .tip[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 2.6vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select:focus, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  align-items: center;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     input, \n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     select {\n  border: none;\n  border-radius: 0;\n  background-color: transparent;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     input {\n  flex: 1;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     select {\n  width: 25%;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]:focus-within {\n  border-color: var(--color3);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#sendExecutedDocuments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes _ngcontent-%COMP%_quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: quoteLoadIn;\n  -ms-animation-name: quoteLoadIn;\n  -o-animation-name: quoteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_quoteLoadIn;\n  animation-name: _ngcontent-%COMP%_quoteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%] {\n  font-size: 4vw;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#sendingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#sendingDocuments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#exportingDocuments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingDocuments.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#exportingDocuments.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  -moz-animation-name: quoteLoadOut;\n  -ms-animation-name: quoteLoadOut;\n  -o-animation-name: quoteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_quoteLoadOut;\n  animation-name: _ngcontent-%COMP%_quoteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#renderingDocuments[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%]   opportunity-document[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=send-executed-documents.component.css.map */"] });
var SendExecutedDocumentsComponent = _SendExecutedDocumentsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SendExecutedDocumentsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "send-executed-documents", providers: [
      OrderByPipe
    ], template: `<section id="sendExecutedDocuments">
  <header>
    <div class="primary">
      <h3>Review Signed Documents</h3>
    </div>
    <div class="controls">
      <button class="control" (click)="closeView()">
        <i class="fa-solid fa-xmark"></i>
      </button>
    </div>
  </header>
  <div class="content">
    <div class="preview">
      <header>
        <h4>Previewing Documents</h4>
      </header>
      <div class="preview-wrap">
        <div class="render-wrap">
          <div class="render" #previewElm></div>
        </div>


        @if (renderingDocuments) {
          <div class="loader">
            <loader [fill]="false"></loader>
            <label>Preparing Documents</label>
          </div>
        }
      </div>
    </div>
    <div class="form">
      <header>
        <h3>E-Mail to Customer</h3>
      </header>

      @if (!online) {
        <div class="message warning">
          <h4>You are currently offline. Please try sending signed documents when you're back online, or you can save and share the quote from your {{deviceStr}}.</h4>
        </div>
      }

      <div class="input-wrap">
        <label>Recipient</label>
        <div class="input">
          <input [(ngModel)]="recipientName" type="text" />
        </div>
      </div>
      <div class="input-wrap">
        <label>E-mail Address</label>
        <div class="input">
          <input [(ngModel)]="email" type="email" />
        </div>
      </div>
    </div>
  </div>
  <div class="controls">
    <button class="control" [disabled]="!canExport" (click)="renderForExport()">
      <label>Save to {{deviceStr}} or Share</label>
    </button>
    <button class="control success" [disabled]="!canSend" (click)="startSendingDocuments()">
      <label>Send Documents</label>
    </button>
  </div>
</section>

@if (exportingDocuments) {
  <aside id="exportingDocuments" [class.closing]="closingExportingDocuments">
    <div class="bg"></div>
    <div class="modal">
      <loader [fill]="true"></loader>
      <label>Preparing & Saving Documents</label>
    </div>
  </aside>
}

@if (sendingDocuments) {
  <aside id="sendingDocuments" [class.closing]="closingSendDocuments">
    <div class="bg"></div>
    <div class="modal">
      <button class="control" (click)="promptToStopSendingDocuments()">
        <i class="fa-solid fa-xmark"></i>
      </button>
      <div class="loader">
        @if (!showDocumentsProcessing) {
          <span class="progress">{{sendDocumentsProgress | async}}%</span>
        }
        @if (showDocumentsProcessing) {
          <span class="processing">E-Mail Processing</span>
        }
        <loader [progress]="true" [percent]="sendDocumentsProgress"></loader>
      </div>
      <label>Preparing & Sending Documents</label>
    </div>
  </aside>
}

<aside id="renderingDocuments">
  <div class="document" #exportElm>
    @for (document of documents; track document) {
      <opportunity-document
        #documentElm
        [content]="content"
        [opportunity]="opportunity"
        [signing]="true"
        (rendered)="renderDocument(document)"
      [document]="document"></opportunity-document>
    }
  </div>
</aside>`, styles: ["/* src/app/shared/opportunities/components/send-executed-documents/send-executed-documents.component.scss */\n#sendExecutedDocuments {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#sendExecutedDocuments > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#sendExecutedDocuments > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments > header > .controls > .control {\n  cursor: pointer;\n}\n#sendExecutedDocuments > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendExecutedDocuments > .content {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  flex: 1;\n  display: flex;\n}\n#sendExecutedDocuments > .content > .preview {\n  width: calc(60% - 0.5vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-top-right-radius: 0.5vw;\n  border-bottom-right-radius: 0.5vw;\n}\n#sendExecutedDocuments > .content > .preview > header {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 2;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#sendExecutedDocuments > .content > .preview > header h4 {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .render-wrap {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .render-wrap > .render {\n  width: 100%;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .render-wrap > .render ::ng-deep canvas,\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .render-wrap > .render ::ng-deep img {\n  display: block;\n  width: 100%;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .loader {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#sendExecutedDocuments > .content > .preview > .preview-wrap > .loader > label {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#sendExecutedDocuments > .content > .form {\n  width: calc(40% - 0.5vw);\n  margin-left: 1vw;\n  padding: 1vw;\n  overflow-x: hidden;\n}\n#sendExecutedDocuments > .content > .form > header {\n  margin-bottom: 1vw;\n}\n#sendExecutedDocuments > .content > .form > header h3 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments > .content > .form > .message {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#sendExecutedDocuments > .content > .form > .message h4 {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#sendExecutedDocuments > .content > .form > .message.warning {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#sendExecutedDocuments > .content > .form > .input-wrap {\n  margin-top: 1vw;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .tip {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input {\n  margin-top: 0.5vw;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input input,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input ::ng-deep input,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input ::ng-deep select,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input select {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 2.6vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input input:focus,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input ::ng-deep input:focus,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input ::ng-deep select:focus,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input select:focus {\n  border-color: var(--color3);\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input > phone-input {\n  display: flex;\n  width: 100%;\n  align-items: center;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep input,\n#sendExecutedDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep select {\n  border: none;\n  border-radius: 0;\n  background-color: transparent;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep input {\n  flex: 1;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input > phone-input ::ng-deep select {\n  width: 25%;\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .input > phone-input:focus-within {\n  border-color: var(--color3);\n}\n#sendExecutedDocuments > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#sendExecutedDocuments > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#sendExecutedDocuments > .controls {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#sendExecutedDocuments > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#sendExecutedDocuments > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#sendExecutedDocuments > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#sendExecutedDocuments > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#sendExecutedDocuments > .controls > .control.success {\n  background-color: var(--success);\n}\n#sendExecutedDocuments > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#sendExecutedDocuments > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#sendExecutedDocuments > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#sendExecutedDocuments > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#sendExecutedDocuments > .controls > .control:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#sendingDocuments > .bg,\n#exportingDocuments > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingDocuments > .modal,\n#exportingDocuments > .modal {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: quoteLoadIn;\n  -ms-animation-name: quoteLoadIn;\n  -o-animation-name: quoteLoadIn;\n  -webkit-animation-name: quoteLoadIn;\n  animation-name: quoteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingDocuments > .modal > .control,\n#exportingDocuments > .modal > .control {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#sendingDocuments > .modal > .control > i,\n#exportingDocuments > .modal > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendingDocuments > .modal > .loader,\n#exportingDocuments > .modal > .loader {\n  position: relative;\n}\n#sendingDocuments > .modal > .loader > .progress,\n#sendingDocuments > .modal > .loader > .processing,\n#exportingDocuments > .modal > .loader > .progress,\n#exportingDocuments > .modal > .loader > .processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#sendingDocuments > .modal > .loader > .progress,\n#exportingDocuments > .modal > .loader > .progress {\n  font-size: 4vw;\n}\n#sendingDocuments > .modal > .loader > .processing,\n#exportingDocuments > .modal > .loader > .processing {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#sendingDocuments > .modal > .loader > loader,\n#exportingDocuments > .modal > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#sendingDocuments > .modal label,\n#exportingDocuments > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#sendingDocuments.closing > .bg,\n#exportingDocuments.closing > .bg {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingDocuments.closing > .modal,\n#exportingDocuments.closing > .modal {\n  -moz-animation-name: quoteLoadOut;\n  -ms-animation-name: quoteLoadOut;\n  -o-animation-name: quoteLoadOut;\n  -webkit-animation-name: quoteLoadOut;\n  animation-name: quoteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#renderingDocuments {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments > .document {\n  width: 100%;\n}\n#renderingDocuments > .document opportunity-document {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=send-executed-documents.component.css.map */\n"] }]
  }], () => [{ type: OpportunityUiService }, { type: OpportunityService }, { type: ContentService }, { type: AuthRefService }, { type: LogService }, { type: ApiService }, { type: UiService }, { type: OrderByPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], email: [{
    type: Input,
    args: ["email"]
  }], documentElms: [{
    type: ViewChildren,
    args: ["documentElm"]
  }], previewElm: [{
    type: ViewChild,
    args: ["previewElm"]
  }], exportElm: [{
    type: ViewChild,
    args: ["exportElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SendExecutedDocumentsComponent, { className: "SendExecutedDocumentsComponent" });
})();

// src/app/shared/opportunities/components/send-quote/send-quote.component.ts
var _c06 = ["previewElm"];
var _c13 = ["exportElm"];
var _c23 = ["documentElm"];
function SendQuoteComponent_Conditional_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13);
    \u0275\u0275element(1, "loader", 28);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Preparing Quote");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("fill", false);
  }
}
function SendQuoteComponent_Conditional_22_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 16)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("You are currently offline. You can save and share the quote from your ", ctx_r1.deviceStr, ", or try sending the quote when you're back online.");
  }
}
function SendQuoteComponent_Conditional_40_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 29);
    \u0275\u0275element(1, "div", 30);
    \u0275\u0275elementStart(2, "div", 31);
    \u0275\u0275element(3, "loader", 28);
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, "Preparing & Saving Documents");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingExportingDocuments);
    \u0275\u0275advance(3);
    \u0275\u0275property("fill", true);
  }
}
function SendQuoteComponent_Conditional_41_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 33);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(2, 1, ctx_r1.quoteProgress), "%");
  }
}
function SendQuoteComponent_Conditional_41_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 34);
    \u0275\u0275text(1, "E-Mail Processing");
    \u0275\u0275elementEnd();
  }
}
function SendQuoteComponent_Conditional_41_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "aside", 32);
    \u0275\u0275element(1, "div", 30);
    \u0275\u0275elementStart(2, "div", 31)(3, "button", 6);
    \u0275\u0275listener("click", function SendQuoteComponent_Conditional_41_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.promptToStopSendingQuote());
    });
    \u0275\u0275element(4, "i", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 13);
    \u0275\u0275conditionalCreate(6, SendQuoteComponent_Conditional_41_Conditional_6_Template, 3, 3, "span", 33);
    \u0275\u0275conditionalCreate(7, SendQuoteComponent_Conditional_41_Conditional_7_Template, 2, 0, "span", 34);
    \u0275\u0275element(8, "loader", 35);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Preparing & Sending Quote");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingSendQuote);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx_r1.showQuoteProgress ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.showQuoteProgress ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("progress", true)("percent", ctx_r1.quoteProgress);
  }
}
function SendQuoteComponent_For_46_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "opportunity-document", 36, 2);
    \u0275\u0275listener("rendered", function SendQuoteComponent_For_46_Template_opportunity_document_rendered_0_listener() {
      const document_r5 = \u0275\u0275restoreView(_r4).$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.renderDocument(document_r5));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const document_r5 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("content", ctx_r1.content)("opportunity", ctx_r1.opportunity)("signing", false)("document", document_r5);
  }
}
var _SendQuoteComponent = class _SendQuoteComponent {
  constructor(opportunityUiService, opportunityService, sanitizer, logService, contentService, apiService, authRefService, uiService, orderByPipe) {
    this.opportunityUiService = opportunityUiService;
    this.opportunityService = opportunityService;
    this.sanitizer = sanitizer;
    this.logService = logService;
    this.contentService = contentService;
    this.apiService = apiService;
    this.authRefService = authRefService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.online = false;
    this.activeUser = null;
    this.exportingDocuments = false;
    this.closingExportingDocuments = false;
    this.documentElms = new QueryList();
    this.sendingQuote = false;
    this.closingSendQuote = false;
    this.renderingDocuments = true;
    this.renderedDocuments = [];
    this.quoteDocuments = [];
    this.quoteProgress = new BehaviorSubject(0);
    this.showQuoteProgress = true;
    this.close = new Subject();
  }
  watchOnline() {
    this.apiService.online.subscribe({
      next: (online) => {
        this.online = online;
      }
    });
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  get validEmail() {
    return this.email != null && this.email.length > 1 && this.email.includes("@");
  }
  get validRecipient() {
    return this.recipientName != null && this.recipientName.length > 0;
  }
  initRecipient() {
    if (this.opportunity?.customer != null) {
      this.email = this.opportunity.customer.contactInformation.find((x) => x.type == ContactInformationType.Email)?.value;
      this.recipientName = `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
    }
  }
  get deviceStr() {
    if (Capacitor.isNativePlatform()) {
      return "iPad";
    } else {
      return "Device";
    }
  }
  get canExport() {
    return !this.exportingDocuments && !this.renderingDocuments;
  }
  stopExportingDocuments() {
    window.clearTimeout(this.exportingDocumentsTimer);
    this.closingExportingDocuments = true;
    this.exportingDocumentsTimer = window.setTimeout(() => {
      this.exportingDocuments = false;
      this.closingExportingDocuments = false;
    }, 250);
  }
  renderForExport() {
    const opportunity = this.opportunity;
    const customer = opportunity?.customer;
    if (opportunity != null && customer != null) {
      this.exportingDocuments = true;
      setTimeout(() => __async(this, null, function* () {
        const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
        const fileName = `Quote - Job ${opportunity.jobId} ${customer.lastName} - ${(/* @__PURE__ */ new Date()).toISOString()}.pdf`;
        setTimeout(() => __async(this, null, function* () {
          if (Capacitor.isNativePlatform()) {
            const base64 = this.contentService.convertBytesToBase64(pdfRender.pdf);
            yield Filesystem.writeFile({
              path: fileName,
              data: base64,
              directory: Directory.Cache
            }).then((writeResult) => __async(this, null, function* () {
              yield Share.share({
                title: "Save Quote",
                url: writeResult.uri,
                dialogTitle: "Save Quote to Files"
              });
              this.uiService.prompt("Quote Saved", `Your quote has been saved to your ${this.deviceStr}.`, "Okay").subscribe({ next: () => this.stopExportingDocuments() });
            })).catch(() => {
              this.uiService.prompt("Failed to Save", "There was an issue saving the quote. Please try again.", "Okay").subscribe({ next: () => this.stopExportingDocuments() });
            });
          } else {
            const pdfBlob = this.contentService.convertBytesToBlob(pdfRender.pdf, "application/pdf");
            const url = window.URL.createObjectURL(pdfBlob);
            const link = document.createElement("a");
            link.href = url;
            link.download = fileName;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            window.URL.revokeObjectURL(url);
            this.uiService.prompt("Quote Saved", "The quote was successfully downloaded to your device.", "Okay").subscribe({
              next: () => {
                this.stopExportingDocuments();
              }
            });
          }
        }), 0);
      }), 2e3);
    }
  }
  get canSendQuote() {
    return !this.sendingQuote && !this.renderingDocuments && this.validRecipient && this.validEmail && this.online;
  }
  initQuoteDocuments() {
    if (this.opportunity != null) {
      this.opportunity.documents.forEach((document2) => {
        if (document2.customerFacing) {
          this.quoteDocuments.push(document2);
        }
      });
      this.quoteDocuments = this.orderByPipe.transform(this.quoteDocuments, "displayOrder", false);
    }
  }
  sortRenderedDocuments() {
    if (this.renderedDocuments != null && this.renderedDocuments.length > 0) {
      this.renderedDocuments = this.orderByPipe.transform(this.renderedDocuments, "displayOrder", false);
    }
  }
  checkFinalizeRender() {
    if (this.renderedDocuments.length == this.quoteDocuments.length) {
      this.sortRenderedDocuments();
      this.renderDocuments();
    }
  }
  renderDocuments() {
    const previewElm = this.previewElm?.nativeElement;
    if (previewElm != null) {
      this.renderedDocuments.forEach((document2) => {
        if (document2.image != null) {
          previewElm.appendChild(document2.image);
        } else if (document2.canvas != null) {
          previewElm.appendChild(document2.canvas);
        }
      });
    }
    this.renderingDocuments = false;
  }
  renderDocument(document2) {
    const documentElm = this.documentElms.find((x) => x.document?.id == document2.id);
    if (documentElm != null) {
      documentElm.exportDocument(1, 1).then((canvas) => {
        const renderedDocument = {
          displayOrder: document2.displayOrder,
          name: document2.name,
          canvas,
          image: void 0
        };
        if (this.renderedDocuments != null) {
          this.renderedDocuments.push(renderedDocument);
        } else {
          this.renderedDocuments = [renderedDocument];
        }
        this.checkFinalizeRender();
      }).catch((e) => {
        this.logService.log(JSON.stringify(e), `Failed to render quote document ${document2.id} for opportunity ${this.opportunity?.id}.`).subscribe();
      });
    }
  }
  startSendingQuote() {
    if (!this.sendingQuote && this.validRecipient && this.validEmail && this.online) {
      this.uiService.prompt("Send Quote?", `A digital copy of the job documents will be prepared and sent to ${this.recipientName} at ${this.email}.
                    Are you sure you want to send the quote?`, "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.sendingQuote = true;
            this.renderAndSendQuote();
          }
        }
      });
    }
  }
  stopSendingQuote() {
    window.clearTimeout(this.quoteTimer);
    this.closingSendQuote = true;
    this.quoteTimer = window.setTimeout(() => {
      this.showQuoteProgress = true;
      this.sendingQuote = false;
      this.closingSendQuote = false;
    }, 250);
  }
  promptToStopSendingQuote() {
    this.uiService.prompt("Don't Want to Wait?", "Your quote may still be sent. Are you sure you want to stop waiting?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.stopSendingQuote();
        }
      }
    });
  }
  renderAndSendQuote() {
    const recipientName = this.recipientName;
    const recipientEmail = this.email;
    if (this.opportunity != null && recipientEmail != null && recipientName != null && this.activeUser != null) {
      const opportunity = this.opportunity;
      const activeUser = this.activeUser;
      setTimeout(() => __async(this, null, function* () {
        const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
        this.sendingQuoteTimeout = window.setTimeout(() => {
          this.uiService.prompt("Taking a While?", "Sending the quote seems to be taking a while. You may be on a poor connection or experiencing other issues. Do you want to cancel and try again later?", "Yes, Try Later", "No, Keep Waiting").subscribe({
            next: (confirmed) => {
              if (confirmed) {
                this.stopSendingQuote();
              }
            }
          });
        }, 45e3);
        this.quoteProgress.next(0);
        this.opportunityService.sendQuote(opportunity, pdfRender.pdf, recipientName, recipientEmail, activeUser).subscribe({
          next: (e) => {
            if ("progress" in e) {
              this.quoteProgress.next(e.progress);
            } else {
              this.showQuoteProgress = false;
              window.clearTimeout(this.sendingQuoteTimeout);
              this.uiService.prompt("Quote Sent Successfully", `The quote was successfully sent to ${recipientName}`, "Okay").subscribe({
                next: () => {
                  this.stopSendingQuote();
                  this.opportunityUiService.stopSendingQuote();
                }
              });
            }
          },
          error: (e) => {
            window.clearTimeout(this.sendingQuoteTimeout);
            this.uiService.prompt("Failed to Send Quote", "There was an issue sending the quote. Please try again or contact support.", "Okay").subscribe({
              next: () => {
                this.stopSendingQuote();
              }
            });
          }
        });
      }), 0);
    } else {
      this.stopSendingQuote();
    }
  }
  initQuoting() {
    this.generateContent();
    this.initQuoteDocuments();
  }
  generatePrice() {
    const price = this.opportunity?.customPrice ?? this.opportunity?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.opportunity?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.opportunity != null) {
      const content = {
        opportunityId: this.opportunity.id,
        created_Utc: this.opportunity.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.opportunity.scheduled_Utc,
        property: this.opportunity.property,
        jobId: this.opportunity.jobId?.toString(),
        job: this.opportunity.job,
        consultant: this.opportunity.assignedTo,
        customer: this.opportunity.customer,
        price: this.generatePrice(),
        documents: this.opportunity.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  closeView() {
    this.close.next();
  }
  init() {
    setTimeout(() => {
      this.watchUser();
      this.watchOnline();
      this.initRecipient();
      this.initQuoting();
    }, 32);
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.onlineSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_SendQuoteComponent.\u0275fac = function SendQuoteComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SendQuoteComponent)(\u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(DomSanitizer), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_SendQuoteComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SendQuoteComponent, selectors: [["send-quote"]], viewQuery: function SendQuoteComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c06, 5);
    \u0275\u0275viewQuery(_c13, 5);
    \u0275\u0275viewQuery(_c23, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.previewElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.exportElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.documentElms = _t);
  }
}, inputs: { opportunity: "opportunity", email: "email" }, outputs: { close: "close" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe
])], decls: 47, vars: 9, consts: [["previewElm", ""], ["exportElm", ""], ["documentElm", ""], ["id", "sendQuote"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "preview"], [1, "preview-wrap"], [1, "render-wrap"], [1, "render"], [1, "loader"], [1, "form"], [1, "message"], [1, "message", "warning"], [1, "input-wrap"], [1, "input"], ["type", "text", 3, "ngModelChange", "ngModel"], ["type", "email", 3, "ngModelChange", "ngModel"], [1, "control", 3, "click", "disabled"], [1, "control", "success", 3, "click", "disabled"], ["id", "exportingDocuments", 3, "closing"], ["id", "sendingQuote", 3, "closing"], ["id", "renderingDocuments"], [1, "document"], [3, "content", "opportunity", "signing", "document"], [3, "fill"], ["id", "exportingDocuments"], [1, "bg"], [1, "modal"], ["id", "sendingQuote"], [1, "progress"], [1, "processing"], [3, "progress", "percent"], [3, "rendered", "content", "opportunity", "signing", "document"]], template: function SendQuoteComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 3)(1, "header")(2, "div", 4)(3, "h3");
    \u0275\u0275text(4, "Send Quote");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 5)(6, "button", 6);
    \u0275\u0275listener("click", function SendQuoteComponent_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275element(7, "i", 7);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 8)(9, "div", 9)(10, "header")(11, "h4");
    \u0275\u0275text(12, "Previewing Quote");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(13, "div", 10)(14, "div", 11);
    \u0275\u0275element(15, "div", 12, 0);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(17, SendQuoteComponent_Conditional_17_Template, 4, 1, "div", 13);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 14)(19, "div", 15)(20, "h4");
    \u0275\u0275text(21, "These documents are not considered final until signed.");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(22, SendQuoteComponent_Conditional_22_Template, 3, 1, "div", 16);
    \u0275\u0275elementStart(23, "div", 17)(24, "label");
    \u0275\u0275text(25, "Recipient");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "div", 18)(27, "input", 19);
    \u0275\u0275twoWayListener("ngModelChange", function SendQuoteComponent_Template_input_ngModelChange_27_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.recipientName, $event) || (ctx.recipientName = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(28, "div", 17)(29, "label");
    \u0275\u0275text(30, "E-mail Address");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(31, "div", 18)(32, "input", 20);
    \u0275\u0275twoWayListener("ngModelChange", function SendQuoteComponent_Template_input_ngModelChange_32_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.email, $event) || (ctx.email = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(33, "div", 5)(34, "button", 21);
    \u0275\u0275listener("click", function SendQuoteComponent_Template_button_click_34_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.renderForExport());
    });
    \u0275\u0275elementStart(35, "label");
    \u0275\u0275text(36);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(37, "button", 22);
    \u0275\u0275listener("click", function SendQuoteComponent_Template_button_click_37_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.startSendingQuote());
    });
    \u0275\u0275elementStart(38, "label");
    \u0275\u0275text(39, "Send Quote");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275conditionalCreate(40, SendQuoteComponent_Conditional_40_Template, 6, 3, "aside", 23);
    \u0275\u0275conditionalCreate(41, SendQuoteComponent_Conditional_41_Template, 11, 6, "aside", 24);
    \u0275\u0275elementStart(42, "aside", 25)(43, "div", 26, 1);
    \u0275\u0275repeaterCreate(45, SendQuoteComponent_For_46_Template, 2, 4, "opportunity-document", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(17);
    \u0275\u0275conditional(ctx.renderingDocuments ? 17 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx.online ? 22 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.recipientName);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.email);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canExport);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Save to ", ctx.deviceStr);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canSendQuote);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.exportingDocuments ? 40 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.sendingQuote ? 41 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx.quoteDocuments);
  }
}, dependencies: [OpportunityDocumentComponent, DefaultValueAccessor, NgControlStatus, LoaderComponent, NgModel, AsyncPipe], styles: ["\n\n#sendQuote[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#sendQuote[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#sendQuote[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendQuote[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#sendQuote[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  flex: 1;\n  display: flex;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%] {\n  width: calc(60% - 0.5vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-top-right-radius: 0.5vw;\n  border-bottom-right-radius: 0.5vw;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 2;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     canvas, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     img {\n  display: block;\n  width: 100%;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%] {\n  width: calc(40% - 0.5vw);\n  margin-left: 1vw;\n  padding: 1vw;\n  overflow-x: hidden;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  background-color: var(--color5Alt3);\n  border: 0.2vw var(--color5Alt4) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .message.warning[_ngcontent-%COMP%] {\n  background-color: var(--error);\n  border-color: var(--errorAlt3);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .tip[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 2.6vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     select:focus, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%] {\n  display: flex;\n  width: 100%;\n  align-items: center;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     input, \n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     select {\n  border: none;\n  border-radius: 0;\n  background-color: transparent;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     input {\n  flex: 1;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]     select {\n  width: 25%;\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > phone-input[_ngcontent-%COMP%]:focus-within {\n  border-color: var(--color3);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#sendQuote[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#sendQuote[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes _ngcontent-%COMP%_quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#sendingQuote[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: quoteLoadIn;\n  -ms-animation-name: quoteLoadIn;\n  -o-animation-name: quoteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_quoteLoadIn;\n  animation-name: _ngcontent-%COMP%_quoteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%] {\n  font-size: 4vw;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#sendingQuote.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#exportingDocuments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%], \n#exportingDocuments.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  -moz-animation-name: quoteLoadOut;\n  -ms-animation-name: quoteLoadOut;\n  -o-animation-name: quoteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_quoteLoadOut;\n  animation-name: _ngcontent-%COMP%_quoteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#renderingDocuments[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%]   opportunity-document[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=send-quote.component.css.map */"] });
var SendQuoteComponent = _SendQuoteComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SendQuoteComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "send-quote", providers: [
      OrderByPipe
    ], template: `<section id="sendQuote">
  <header>
    <div class="primary">
      <h3>Send Quote</h3>
    </div>
    <div class="controls">
      <button class="control" (click)="closeView()">
        <i class="fa-solid fa-xmark"></i>
      </button>
    </div>
  </header>
  <div class="content">
    <div class="preview">
      <header>
        <h4>Previewing Quote</h4>
      </header>
      <div class="preview-wrap">
        <div class="render-wrap">
          <div class="render" #previewElm></div>
        </div>

        @if (renderingDocuments) {
          <div class="loader">
            <loader [fill]="false"></loader>
            <label>Preparing Quote</label>
          </div>
        }
      </div>
    </div>
    <div class="form">
      <div class="message">
        <h4>These documents are not considered final until signed.</h4>
      </div>

      @if (!online) {
        <div class="message warning">
          <h4>You are currently offline. You can save and share the quote from your {{deviceStr}}, or try sending the quote when you're back online.</h4>
        </div>
      }

      <div class="input-wrap">
        <label>Recipient</label>
        <div class="input">
          <input [(ngModel)]="recipientName" type="text" />
        </div>
      </div>
      <div class="input-wrap">
        <label>E-mail Address</label>
        <div class="input">
          <input [(ngModel)]="email" type="email" />
        </div>
      </div>
    </div>
  </div>
  <div class="controls">
    <button class="control" [disabled]="!canExport" (click)="renderForExport()">
      <label>Save to {{deviceStr}}</label>
    </button>
    <button class="control success" [disabled]="!canSendQuote" (click)="startSendingQuote()">
      <label>Send Quote</label>
    </button>
  </div>
</section>

@if (exportingDocuments) {
  <aside id="exportingDocuments" [class.closing]="closingExportingDocuments">
    <div class="bg"></div>
    <div class="modal">
      <loader [fill]="true"></loader>
      <label>Preparing & Saving Documents</label>
    </div>
  </aside>
}

@if (sendingQuote) {
  <aside id="sendingQuote" [class.closing]="closingSendQuote">
    <div class="bg"></div>
    <div class="modal">
      <button class="control" (click)="promptToStopSendingQuote()">
        <i class="fa-solid fa-xmark"></i>
      </button>
      <div class="loader">
        @if (showQuoteProgress) {
          <span class="progress">{{quoteProgress | async}}%</span>
        }
        @if (!showQuoteProgress) {
          <span class="processing">E-Mail Processing</span>
        }
        <loader [progress]="true" [percent]="quoteProgress"></loader>
      </div>
      <label>Preparing & Sending Quote</label>
    </div>
  </aside>
}

<aside id="renderingDocuments">
  <div class="document" #exportElm>
    @for (document of quoteDocuments; track document) {
      <opportunity-document
        #documentElm
        [content]="content"
        [opportunity]="opportunity"
        [signing]="false"
        (rendered)="renderDocument(document)"
      [document]="document"></opportunity-document>
    }
  </div>
</aside>`, styles: ["/* src/app/shared/opportunities/components/send-quote/send-quote.component.scss */\n#sendQuote {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#sendQuote > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#sendQuote > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendQuote > header > .controls > .control {\n  cursor: pointer;\n}\n#sendQuote > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendQuote > .content {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  flex: 1;\n  display: flex;\n}\n#sendQuote > .content > .preview {\n  width: calc(60% - 0.5vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-top-right-radius: 0.5vw;\n  border-bottom-right-radius: 0.5vw;\n}\n#sendQuote > .content > .preview > header {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 2;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#sendQuote > .content > .preview > header h4 {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#sendQuote > .content > .preview > .preview-wrap {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#sendQuote > .content > .preview > .preview-wrap > .render-wrap {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#sendQuote > .content > .preview > .preview-wrap > .render-wrap > .render {\n  width: 100%;\n}\n#sendQuote > .content > .preview > .preview-wrap > .render-wrap > .render ::ng-deep canvas,\n#sendQuote > .content > .preview > .preview-wrap > .render-wrap > .render ::ng-deep img {\n  display: block;\n  width: 100%;\n}\n#sendQuote > .content > .preview > .preview-wrap > .loader {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n}\n#sendQuote > .content > .preview > .preview-wrap > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#sendQuote > .content > .preview > .preview-wrap > .loader > label {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#sendQuote > .content > .form {\n  width: calc(40% - 0.5vw);\n  margin-left: 1vw;\n  padding: 1vw;\n  overflow-x: hidden;\n}\n#sendQuote > .content > .form > .message {\n  background-color: var(--color5Alt3);\n  border: 0.2vw var(--color5Alt4) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#sendQuote > .content > .form > .message h4 {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#sendQuote > .content > .form > .message.warning {\n  background-color: var(--error);\n  border-color: var(--errorAlt3);\n}\n#sendQuote > .content > .form > .input-wrap {\n  margin-top: 1vw;\n}\n#sendQuote > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#sendQuote > .content > .form > .input-wrap > .tip {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#sendQuote > .content > .form > .input-wrap > .input {\n  margin-top: 0.5vw;\n}\n#sendQuote > .content > .form > .input-wrap > .input input,\n#sendQuote > .content > .form > .input-wrap > .input ::ng-deep input,\n#sendQuote > .content > .form > .input-wrap > .input ::ng-deep select,\n#sendQuote > .content > .form > .input-wrap > .input select {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 2.6vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#sendQuote > .content > .form > .input-wrap > .input input:focus,\n#sendQuote > .content > .form > .input-wrap > .input ::ng-deep input:focus,\n#sendQuote > .content > .form > .input-wrap > .input ::ng-deep select:focus,\n#sendQuote > .content > .form > .input-wrap > .input select:focus {\n  border-color: var(--color3);\n}\n#sendQuote > .content > .form > .input-wrap > .input > phone-input {\n  display: flex;\n  width: 100%;\n  align-items: center;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#sendQuote > .content > .form > .input-wrap > .input > phone-input ::ng-deep input,\n#sendQuote > .content > .form > .input-wrap > .input > phone-input ::ng-deep select {\n  border: none;\n  border-radius: 0;\n  background-color: transparent;\n}\n#sendQuote > .content > .form > .input-wrap > .input > phone-input ::ng-deep input {\n  flex: 1;\n}\n#sendQuote > .content > .form > .input-wrap > .input > phone-input ::ng-deep select {\n  width: 25%;\n}\n#sendQuote > .content > .form > .input-wrap > .input > phone-input:focus-within {\n  border-color: var(--color3);\n}\n#sendQuote > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#sendQuote > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#sendQuote > .controls {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#sendQuote > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#sendQuote > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#sendQuote > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#sendQuote > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#sendQuote > .controls > .control.success {\n  background-color: var(--success);\n}\n#sendQuote > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#sendQuote > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#sendQuote > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#sendQuote > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#sendQuote > .controls > .control:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#sendingQuote > .bg,\n#exportingDocuments > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote > .modal,\n#exportingDocuments > .modal {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: quoteLoadIn;\n  -ms-animation-name: quoteLoadIn;\n  -o-animation-name: quoteLoadIn;\n  -webkit-animation-name: quoteLoadIn;\n  animation-name: quoteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote > .modal > .control,\n#exportingDocuments > .modal > .control {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#sendingQuote > .modal > .control > i,\n#exportingDocuments > .modal > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#sendingQuote > .modal > .loader,\n#exportingDocuments > .modal > .loader {\n  position: relative;\n}\n#sendingQuote > .modal > .loader > .progress,\n#sendingQuote > .modal > .loader > .processing,\n#exportingDocuments > .modal > .loader > .progress,\n#exportingDocuments > .modal > .loader > .processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#sendingQuote > .modal > .loader > .progress,\n#exportingDocuments > .modal > .loader > .progress {\n  font-size: 4vw;\n}\n#sendingQuote > .modal > .loader > .processing,\n#exportingDocuments > .modal > .loader > .processing {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#sendingQuote > .modal > .loader > loader,\n#exportingDocuments > .modal > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#sendingQuote > .modal label,\n#exportingDocuments > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#sendingQuote.closing > .bg,\n#exportingDocuments.closing > .bg {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote.closing > .modal,\n#exportingDocuments.closing > .modal {\n  -moz-animation-name: quoteLoadOut;\n  -ms-animation-name: quoteLoadOut;\n  -o-animation-name: quoteLoadOut;\n  -webkit-animation-name: quoteLoadOut;\n  animation-name: quoteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#renderingDocuments {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments > .document {\n  width: 100%;\n}\n#renderingDocuments > .document opportunity-document {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=send-quote.component.css.map */\n"] }]
  }], () => [{ type: OpportunityUiService }, { type: OpportunityService }, { type: DomSanitizer }, { type: LogService }, { type: ContentService }, { type: ApiService }, { type: AuthRefService }, { type: UiService }, { type: OrderByPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], email: [{
    type: Input,
    args: ["email"]
  }], documentElms: [{
    type: ViewChildren,
    args: ["documentElm"]
  }], previewElm: [{
    type: ViewChild,
    args: ["previewElm"]
  }], exportElm: [{
    type: ViewChild,
    args: ["exportElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SendQuoteComponent, { className: "SendQuoteComponent" });
})();

// src/app/shared/opportunities/components/details/details.component.ts
var _c07 = ["previewElm"];
var _c14 = ["exportElm"];
var _c24 = ["componentElm"];
var _c3 = ["documentElm"];
function OpportunityDetailsComponent_Conditional_0_Conditional_20_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 18);
    \u0275\u0275element(1, "loader", 35);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Preparing Documents");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("fill", false);
  }
}
function OpportunityDetailsComponent_Conditional_0_For_65_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 32)(1, "div", 36)(2, "div", 37);
    \u0275\u0275text(3);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "div", 38);
    \u0275\u0275text(5);
    \u0275\u0275pipe(6, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "div", 39)(8, "span", 23);
    \u0275\u0275text(9);
    \u0275\u0275pipe(10, "currency");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const payment_r3 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", payment_r3.paymentMethod == null ? null : payment_r3.paymentMethod.name, " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" on ", \u0275\u0275pipeBind2(6, 3, payment_r3.timeStamp_Utc, "MM/dd/yyyy @ hh:mm a"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(10, 6, payment_r3.amount, payment_r3.iso4217), " ");
  }
}
function OpportunityDetailsComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 4, 1)(2, "header")(3, "div", 9)(4, "h3");
    \u0275\u0275text(5, " Appointment Details ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "h4");
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(8, "div", 10)(9, "button", 11);
    \u0275\u0275listener("click", function OpportunityDetailsComponent_Conditional_0_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.promptToCloseView());
    });
    \u0275\u0275element(10, "i", 12);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(11, "div", 13)(12, "div", 14)(13, "header")(14, "h4");
    \u0275\u0275text(15, "Job Documents");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "div", 15)(17, "div", 16);
    \u0275\u0275element(18, "div", 17, 2);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(20, OpportunityDetailsComponent_Conditional_0_Conditional_20_Template, 4, 1, "div", 18);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(21, "div", 19)(22, "div", 20)(23, "header")(24, "h4");
    \u0275\u0275text(25, "Price Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(26, "div", 13)(27, "div", 21)(28, "div", 22)(29, "header")(30, "h3");
    \u0275\u0275text(31, "Target Price");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(32, "div", 23);
    \u0275\u0275element(33, "currency-input", 24);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(34, "div", 25)(35, "header")(36, "h3");
    \u0275\u0275text(37, "Including 20%");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(38, "div", 23);
    \u0275\u0275element(39, "currency-input", 24);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(40, "div", 26)(41, "header")(42, "h3");
    \u0275\u0275text(43, "PAR");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(44, "div", 23);
    \u0275\u0275element(45, "currency-input", 24);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(46, "div", 27)(47, "header")(48, "h3");
    \u0275\u0275text(49, "ABL");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(50, "div", 23);
    \u0275\u0275element(51, "currency-input", 24);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(52, "div", 28)(53, "header")(54, "h2");
    \u0275\u0275text(55, " Your Price to the Customer ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(56, "div", 13)(57, "div", 29);
    \u0275\u0275element(58, "currency-input", 30);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(59, "div", 31)(60, "header")(61, "h4");
    \u0275\u0275text(62, "Payments");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(63, "div", 13);
    \u0275\u0275repeaterCreate(64, OpportunityDetailsComponent_Conditional_0_For_65_Template, 11, 9, "div", 32, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(66, "div", 33)(67, "button", 34);
    \u0275\u0275listener("click", function OpportunityDetailsComponent_Conditional_0_Template_button_click_67_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.renderForExport());
    });
    \u0275\u0275elementStart(68, "label");
    \u0275\u0275text(69, "Save or Share Documents");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate2(" Job ", ctx_r1.opportunity.jobId, " - ", ctx_r1.customerName, " ");
    \u0275\u0275advance(13);
    \u0275\u0275conditional(ctx_r1.renderingDocuments ? 20 : -1);
    \u0275\u0275advance(13);
    \u0275\u0275property("currencyInput", ctx_r1.targetPrice)("enabled", false);
    \u0275\u0275advance(6);
    \u0275\u0275property("currencyInput", ctx_r1.targetPromoPrice)("enabled", false);
    \u0275\u0275advance(6);
    \u0275\u0275property("currencyInput", ctx_r1.parPrice)("enabled", false);
    \u0275\u0275advance(6);
    \u0275\u0275property("currencyInput", ctx_r1.ablPrice)("enabled", false);
    \u0275\u0275advance(7);
    \u0275\u0275property("enabled", false)("currencyInput", ctx_r1.finalPrice);
    \u0275\u0275advance(6);
    \u0275\u0275repeater(ctx_r1.payments);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx_r1.canExport);
  }
}
function OpportunityDetailsComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 40);
    \u0275\u0275element(1, "div", 41);
    \u0275\u0275elementStart(2, "div", 42);
    \u0275\u0275element(3, "loader", 35);
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, "Preparing & Saving Documents");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r1.closingExportingDocuments);
    \u0275\u0275advance(3);
    \u0275\u0275property("fill", true);
  }
}
function OpportunityDetailsComponent_For_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "opportunity-document", 43, 3);
    \u0275\u0275listener("rendered", function OpportunityDetailsComponent_For_6_Template_opportunity_document_rendered_0_listener() {
      const document_r5 = \u0275\u0275restoreView(_r4).$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.renderDocument(document_r5));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const document_r5 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("content", ctx_r1.content)("opportunity", ctx_r1.opportunity)("signing", true)("document", document_r5);
  }
}
var _OpportunityDetailsComponent = class _OpportunityDetailsComponent {
  constructor(opportunityUiService, contentService, logService, uiService, orderByPipe) {
    this.opportunityUiService = opportunityUiService;
    this.contentService = contentService;
    this.logService = logService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.payments = [];
    this.documentElms = new QueryList();
    this.renderingDocuments = true;
    this.renderedDocuments = [];
    this.documents = [];
    this.exportingDocuments = false;
    this.closingExportingDocuments = false;
  }
  // #endregion
  // #region Customer
  get customerName() {
    if (this.opportunity?.customer != null) {
      return `${this.opportunity.customer.firstName} ${this.opportunity.customer.lastName}`;
    }
    return void 0;
  }
  // #endregion
  // #region Pricing
  get price() {
    return this.opportunity?.customPrice ?? this.opportunity?.price;
  }
  get targetPrice() {
    return this.price?.targetPrice ?? 0;
  }
  get targetPromoPrice() {
    return this.price?.targetPromoPrice ?? 0;
  }
  get parPrice() {
    return this.price?.parPrice ?? 0;
  }
  get ablPrice() {
    return this.price?.ablPrice ?? 0;
  }
  get finalPrice() {
    return this.price?.finalPrice ?? 0;
  }
  initPayments() {
    if (this.opportunity != null) {
      for (var i = 0, len = this.opportunity.payments.length; i < len; i++) {
        const payment = this.opportunity.payments[i];
        if (payment.paymentMethodId != null) {
          const matchingMethod = this.opportunity.paymentSetting?.methods.find((x) => x.id == payment.paymentMethodId);
          payment.paymentMethod = matchingMethod;
          this.payments.push(payment);
        }
      }
    }
  }
  generatePrice() {
    const price = this.opportunity?.customPrice ?? this.opportunity?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.opportunity?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.opportunity.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.opportunity != null) {
      const content = {
        opportunityId: this.opportunity.id,
        created_Utc: this.opportunity.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.opportunity.scheduled_Utc,
        property: this.opportunity.property,
        jobId: this.opportunity.jobId?.toString(),
        job: this.opportunity.job,
        consultant: this.opportunity.assignedTo,
        customer: this.opportunity.customer,
        price: this.generatePrice(),
        documents: this.opportunity.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  initDocuments() {
    if (this.opportunity != null) {
      this.generateContent();
      this.opportunity.documents.forEach((document2) => {
        const name = document2.name.toLowerCase();
        if (name != "repipe info sheet" && !name.includes("sample warranty")) {
          this.documents.push(document2);
        }
      });
      this.documents = this.orderByPipe.transform(this.documents, "displayOrder", false);
    }
  }
  sortRenderedDocuments() {
    if (this.renderedDocuments != null && this.renderedDocuments.length > 0) {
      this.renderedDocuments = this.orderByPipe.transform(this.renderedDocuments, "displayOrder", false);
    }
  }
  checkFinalizeRender() {
    if (this.renderedDocuments.length == this.documents.length) {
      this.sortRenderedDocuments();
      this.renderDocuments();
    }
  }
  renderDocuments() {
    const previewElm = this.previewElm?.nativeElement;
    if (previewElm != null) {
      this.renderedDocuments.forEach((document2) => {
        if (document2.image != null) {
          previewElm.appendChild(document2.image);
        } else if (document2.canvas != null) {
          previewElm.appendChild(document2.canvas);
        }
      });
    }
    this.renderingDocuments = false;
  }
  renderDocument(document2) {
    const documentElm = this.documentElms.find((x) => x.document?.id == document2.id);
    if (documentElm != null) {
      documentElm.exportDocument(1, 1).then((canvas) => {
        const renderedDocument = {
          displayOrder: document2.displayOrder,
          name: document2.name,
          canvas,
          image: void 0
        };
        if (this.renderedDocuments != null) {
          this.renderedDocuments.push(renderedDocument);
        } else {
          this.renderedDocuments = [renderedDocument];
        }
        this.checkFinalizeRender();
      }).catch((e) => {
        this.logService.log(JSON.stringify(e), `Failed to render details documents ${document2.id} for opportunity ${this.opportunity?.id}.`).subscribe();
      });
    }
  }
  get canExport() {
    return !this.exportingDocuments && !this.renderingDocuments;
  }
  get deviceStr() {
    if (Capacitor.isNativePlatform()) {
      return "iPad";
    } else {
      return "Device";
    }
  }
  stopExportingDocuments() {
    window.clearTimeout(this.exportingDocumentsTimer);
    this.closingExportingDocuments = true;
    this.exportingDocumentsTimer = window.setTimeout(() => {
      this.exportingDocuments = false;
      this.closingExportingDocuments = false;
    }, 250);
  }
  renderForExport() {
    const opportunity = this.opportunity;
    const customer = opportunity?.customer;
    if (opportunity != null && customer != null) {
      this.exportingDocuments = true;
      setTimeout(() => __async(this, null, function* () {
        const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
        const fileName = `Signed Documents - Job ${opportunity.jobId} ${customer.lastName} - ${(/* @__PURE__ */ new Date()).toISOString()}.pdf`;
        setTimeout(() => __async(this, null, function* () {
          if (Capacitor.isNativePlatform()) {
            const base64 = this.contentService.convertBytesToBase64(pdfRender.pdf);
            yield Filesystem.writeFile({
              path: fileName,
              data: base64,
              directory: Directory.Cache
            }).then((writeResult) => __async(this, null, function* () {
              yield Share.share({
                title: "Save Documents",
                url: writeResult.uri,
                dialogTitle: "Save Documents to Files"
              });
              this.uiService.prompt("Documents Saved", `Your documents have been saved to your ${this.deviceStr}.`, "Okay").subscribe({ next: () => this.stopExportingDocuments() });
            })).catch(() => {
              this.uiService.prompt("Failed to Save", "There was an issue saving the documents. Please try again.", "Okay").subscribe({ next: () => this.stopExportingDocuments() });
            });
          } else {
            const pdfBlob = this.contentService.convertBytesToBlob(pdfRender.pdf, "application/pdf");
            const url = window.URL.createObjectURL(pdfBlob);
            const link = document.createElement("a");
            link.href = url;
            link.download = fileName;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            window.URL.revokeObjectURL(url);
            this.uiService.prompt("Documents Saved", "The documents were successfully downloaded to your device.", "Okay").subscribe({
              next: () => {
                this.stopExportingDocuments();
              }
            });
          }
        }), 0);
      }), 2e3);
    }
  }
  promptToCloseView() {
    this.opportunityUiService.stopViewingDetails();
  }
  init() {
    this.initDocuments();
    this.initPayments();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_OpportunityDetailsComponent.\u0275fac = function OpportunityDetailsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityDetailsComponent)(\u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_OpportunityDetailsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunityDetailsComponent, selectors: [["opportunity-details"]], viewQuery: function OpportunityDetailsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c07, 5);
    \u0275\u0275viewQuery(_c14, 5);
    \u0275\u0275viewQuery(_c24, 5);
    \u0275\u0275viewQuery(_c3, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.previewElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.exportElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.documentElms = _t);
  }
}, inputs: { opportunity: "opportunity" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe
])], decls: 7, vars: 2, consts: [["exportElm", ""], ["componentElm", ""], ["previewElm", ""], ["documentElm", ""], ["id", "appointmentDetails"], ["id", "exportingDocuments", 3, "closing"], ["id", "renderingDocuments"], [1, "document"], [3, "content", "opportunity", "signing", "document"], [1, "primary"], [1, "secondary"], [1, "close-control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "document-preview"], [1, "preview-wrap"], [1, "render-wrap"], [1, "render"], [1, "loader"], [1, "meta"], [1, "pricing", "section"], [1, "auto-prices"], [1, "auto-price", "retail"], [1, "value"], [3, "currencyInput", "enabled"], [1, "auto-price", "promotional"], [1, "auto-price", "par"], [1, "auto-price", "abl"], [1, "price", "tile"], [1, "input"], [3, "enabled", "currencyInput"], [1, "payments", "section"], [1, "payment"], [1, "controls"], [1, "control", 3, "click", "disabled"], [3, "fill"], [1, "detail"], [1, "method"], [1, "timestamp"], [1, "amount"], ["id", "exportingDocuments"], [1, "bg"], [1, "modal"], [3, "rendered", "content", "opportunity", "signing", "document"]], template: function OpportunityDetailsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, OpportunityDetailsComponent_Conditional_0_Template, 70, 14, "section", 4);
    \u0275\u0275conditionalCreate(1, OpportunityDetailsComponent_Conditional_1_Template, 6, 3, "aside", 5);
    \u0275\u0275elementStart(2, "aside", 6)(3, "div", 7, 0);
    \u0275\u0275repeaterCreate(5, OpportunityDetailsComponent_For_6_Template, 2, 4, "opportunity-document", 8, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.opportunity != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.exportingDocuments ? 1 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx.documents);
  }
}, dependencies: [OpportunityDocumentComponent, CurrencyInputComponent, LoaderComponent, CurrencyPipe, DatePipe], styles: ["\n\n#appointmentDetails[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: 0 1vw 1vw;\n  display: flex;\n  flex-direction: column;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  line-height: 1;\n  font-weight: var(--ltweight);\n  color: var(--color4Alt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .close-control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .close-control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  display: flex;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%] {\n  width: calc(60% - 1vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 1;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     canvas, \n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     img {\n  display: block;\n  width: 100%;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .document-preview[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  width: 40%;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  margin-left: 1vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  width: calc(25% - 0.75vw);\n  display: flex;\n  flex-direction: column;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0 0.5vw 0.25vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.1vw;\n  font-weight: var(--strong);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  padding: 0.25vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  font-size: 1.3vw;\n  font-weight: var(--strong);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%] {\n  border-color: var(--color3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3Alt4-raw), 0.05);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--color3Alt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%] {\n  border-color: var(--success);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--successAlt4-raw), 0.05);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--successAlt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%] {\n  border-color: var(--color4Alt3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color4Alt3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color4Alt4-raw), 0.05);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--color4Alt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%] {\n  border-color: var(--errorAlt3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--errorAlt3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--errorAlt4-raw), 0.05);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--errorAlt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  overflow-x: hidden;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0 1vw;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input {\n  font-size: 6vw;\n  color: var(--success);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  border-bottom: 0.1vw var(--color1) dotted;\n  padding-bottom: 0.25vw;\n  display: flex;\n  align-items: flex-end;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  width: 60%;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1);\n  text-transform: uppercase;\n  font-weight: var(--stdweight);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%] {\n  width: 40%;\n  text-align: right;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--strong);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#appointmentDetails[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes _ngcontent-%COMP%_quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#exportingDocuments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: quoteLoadIn;\n  -ms-animation-name: quoteLoadIn;\n  -o-animation-name: quoteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_quoteLoadIn;\n  animation-name: _ngcontent-%COMP%_quoteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#exportingDocuments[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#exportingDocuments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingDocuments.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  -moz-animation-name: quoteLoadOut;\n  -ms-animation-name: quoteLoadOut;\n  -o-animation-name: quoteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_quoteLoadOut;\n  animation-name: _ngcontent-%COMP%_quoteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#renderingDocuments[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%]   appointment-document[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=details.component.css.map */"] });
var OpportunityDetailsComponent = _OpportunityDetailsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityDetailsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-details", providers: [
      OrderByPipe
    ], template: `@if (opportunity != null) {
  <section id="appointmentDetails" #componentElm>
    <header>
      <div class="primary">
        <h3>
          Appointment Details
        </h3>
        <h4>
          Job {{opportunity.jobId}} - {{customerName}}
        </h4>
      </div>
      <div class="secondary">
        <button class="close-control" (click)="promptToCloseView()">
          <i class="fa-solid fa-xmark"></i>
        </button>
      </div>
    </header>
    <div class="content">
      <div class="document-preview">
        <header>
          <h4>Job Documents</h4>
        </header>
        <div class="preview-wrap">
          <div class="render-wrap">
            <div class="render" #previewElm></div>
          </div>
          @if (renderingDocuments) {
            <div class="loader">
              <loader [fill]="false"></loader>
              <label>Preparing Documents</label>
            </div>
          }
        </div>
      </div>
      <div class="meta">
        <div class="pricing section">
          <header>
            <h4>Price Details</h4>
          </header>
          <div class="content">
            <div class="auto-prices">
              <div class="auto-price retail">
                <header>
                  <h3>Target Price</h3>
                </header>
                <div class="value">
                  <currency-input [currencyInput]="targetPrice" [enabled]="false"></currency-input>
                </div>
              </div>
              <div class="auto-price promotional">
                <header>
                  <h3>Including 20%</h3>
                </header>
                <div class="value">
                  <currency-input [currencyInput]="targetPromoPrice" [enabled]="false"></currency-input>
                </div>
              </div>
              <div class="auto-price par">
                <header>
                  <h3>PAR</h3>
                </header>
                <div class="value">
                  <currency-input [currencyInput]="parPrice" [enabled]="false"></currency-input>
                </div>
              </div>
              <div class="auto-price abl">
                <header>
                  <h3>ABL</h3>
                </header>
                <div class="value">
                  <currency-input [currencyInput]="ablPrice" [enabled]="false"></currency-input>
                </div>
              </div>
            </div>
            <div class="price tile">
              <header>
                <h2>
                  Your Price to the Customer
                </h2>
              </header>
              <div class="content">
                <div class="input">
                  <currency-input [enabled]="false" [currencyInput]="finalPrice"></currency-input>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="payments section">
          <header>
            <h4>Payments</h4>
          </header>
          <div class="content">
            @for (payment of payments; track payment) {
              <div class="payment">
                <div class="detail">
                  <div class="method">
                    {{payment.paymentMethod?.name}}
                  </div>
                  <div class="timestamp">
                    on {{payment.timeStamp_Utc | date: 'MM/dd/yyyy @ hh:mm a'}}
                  </div>
                </div>
                <div class="amount">
                  <span class="value">
                    {{payment.amount | currency:payment.iso4217}}
                  </span>
                </div>
              </div>
            }
          </div>
        </div>
      </div>
    </div>
    <div class="controls">
      <button class="control" [disabled]="!canExport" (click)="renderForExport()">
        <label>Save or Share Documents</label>
      </button>
    </div>
  </section>
}

@if (exportingDocuments) {
  <aside id="exportingDocuments" [class.closing]="closingExportingDocuments">
    <div class="bg"></div>
    <div class="modal">
      <loader [fill]="true"></loader>
      <label>Preparing & Saving Documents</label>
    </div>
  </aside>
}

<aside id="renderingDocuments">
  <div class="document" #exportElm>
    @for (document of documents; track document) {
      <opportunity-document
        #documentElm
        [content]="content"
        [opportunity]="opportunity"
        [signing]="true"
        (rendered)="renderDocument(document)"
      [document]="document"></opportunity-document>
    }
  </div>
</aside>`, styles: ["/* src/app/shared/opportunities/components/details/details.component.scss */\n#appointmentDetails {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: 0 1vw 1vw;\n  display: flex;\n  flex-direction: column;\n}\n#appointmentDetails > header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#appointmentDetails > header > .primary h3 {\n  font-size: 1.2vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n#appointmentDetails > header > .primary h4 {\n  font-size: 2vw;\n  line-height: 1;\n  font-weight: var(--ltweight);\n  color: var(--color4Alt4);\n}\n#appointmentDetails > header > .secondary {\n  display: flex;\n  align-items: center;\n}\n#appointmentDetails > header > .secondary > .close-control {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#appointmentDetails > header > .secondary > .close-control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#appointmentDetails > .content {\n  flex: 1;\n  display: flex;\n}\n#appointmentDetails > .content > .document-preview {\n  width: calc(60% - 1vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#appointmentDetails > .content > .document-preview > header {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 1;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#appointmentDetails > .content > .document-preview > header h4 {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap > .render-wrap {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap > .render-wrap > .render {\n  width: 100%;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap > .render-wrap > .render ::ng-deep canvas,\n#appointmentDetails > .content > .document-preview > .preview-wrap > .render-wrap > .render ::ng-deep img {\n  display: block;\n  width: 100%;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap > .loader {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#appointmentDetails > .content > .document-preview > .preview-wrap > .loader > label {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#appointmentDetails > .content > .meta {\n  width: 40%;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  margin-left: 1vw;\n}\n#appointmentDetails > .content > .meta > .section {\n  margin-top: 2vw;\n}\n#appointmentDetails > .content > .meta > .section > header h4 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDetails > .content > .meta > .section > .content {\n  margin-top: 1vw;\n}\n#appointmentDetails > .content > .meta > .section:first-child {\n  margin-top: 0;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices {\n  display: flex;\n  align-items: flex-start;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price {\n  margin-left: 1vw;\n  width: calc(25% - 0.75vw);\n  display: flex;\n  flex-direction: column;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price > header {\n  padding: 0 0.5vw 0.25vw;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price > header h3 {\n  font-size: 1.1vw;\n  font-weight: var(--strong);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price > .value {\n  padding: 0.25vw;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price > .value ::ng-deep input {\n  font-size: 1.3vw;\n  font-weight: var(--strong);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price:first-child {\n  margin-top: 0;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.retail {\n  border-color: var(--color3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.retail > header {\n  background-color: var(--color3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.retail > header h3 {\n  color: var(--color2);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.retail > .value {\n  background-color: rgba(var(--color3Alt4-raw), 0.05);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.retail > .value ::ng-deep input {\n  color: var(--color3Alt4);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.promotional {\n  border-color: var(--success);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.promotional > header {\n  background-color: var(--success);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.promotional > header h3 {\n  color: var(--color2);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.promotional > .value {\n  background-color: rgba(var(--successAlt4-raw), 0.05);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.promotional > .value ::ng-deep input {\n  color: var(--successAlt4);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.par {\n  border-color: var(--color4Alt3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.par > header {\n  background-color: var(--color4Alt3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.par > header h3 {\n  color: var(--color2);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.par > .value {\n  background-color: rgba(var(--color4Alt4-raw), 0.05);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.par > .value ::ng-deep input {\n  color: var(--color4Alt4);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.abl {\n  border-color: var(--errorAlt3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.abl > header {\n  background-color: var(--errorAlt3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.abl > header h3 {\n  color: var(--color2);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.abl > .value {\n  background-color: rgba(var(--errorAlt4-raw), 0.05);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price.abl > .value ::ng-deep input {\n  color: var(--errorAlt4);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .auto-prices > .auto-price:first-child {\n  margin-left: 0;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  overflow-x: hidden;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > header {\n  padding: 0.5vw 1vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > header h2 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > header > .controls > .control {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > header > .controls > .control i {\n  font-size: 1.2vw;\n  color: var(--color3);\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > header > .controls > .control label {\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > .content {\n  padding: 0 1vw;\n}\n#appointmentDetails > .content > .meta > .pricing > .content > .price > .content > .input ::ng-deep input {\n  font-size: 6vw;\n  color: var(--success);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#appointmentDetails > .content > .meta > .payments {\n  flex: 1;\n}\n#appointmentDetails > .content > .meta > .payments > .content > .payment {\n  margin-top: 0.5vw;\n  border-bottom: 0.1vw var(--color1) dotted;\n  padding-bottom: 0.25vw;\n  display: flex;\n  align-items: flex-end;\n}\n#appointmentDetails > .content > .meta > .payments > .content > .payment > .detail {\n  width: 60%;\n}\n#appointmentDetails > .content > .meta > .payments > .content > .payment > .detail > .method {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n}\n#appointmentDetails > .content > .meta > .payments > .content > .payment > .detail > .timestamp {\n  font-size: 1vw;\n  color: var(--color1);\n  text-transform: uppercase;\n  font-weight: var(--stdweight);\n}\n#appointmentDetails > .content > .meta > .payments > .content > .payment > .amount {\n  width: 40%;\n  text-align: right;\n}\n#appointmentDetails > .content > .meta > .payments > .content > .payment > .amount > .value {\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--strong);\n}\n#appointmentDetails > .controls {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#appointmentDetails > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentDetails > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDetails > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#appointmentDetails > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#appointmentDetails > .controls > .control.success {\n  background-color: var(--success);\n}\n#appointmentDetails > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentDetails > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#appointmentDetails > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#appointmentDetails > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#appointmentDetails > .controls > .control:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes quoteLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes quoteLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#exportingDocuments > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingDocuments > .modal {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: quoteLoadIn;\n  -ms-animation-name: quoteLoadIn;\n  -o-animation-name: quoteLoadIn;\n  -webkit-animation-name: quoteLoadIn;\n  animation-name: quoteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingDocuments > .modal > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#exportingDocuments > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#exportingDocuments.closing > .bg {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingDocuments.closing > .modal {\n  -moz-animation-name: quoteLoadOut;\n  -ms-animation-name: quoteLoadOut;\n  -o-animation-name: quoteLoadOut;\n  -webkit-animation-name: quoteLoadOut;\n  animation-name: quoteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#renderingDocuments {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments > .document {\n  width: 100%;\n}\n#renderingDocuments > .document appointment-document {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=details.component.css.map */\n"] }]
  }], () => [{ type: OpportunityUiService }, { type: ContentService }, { type: LogService }, { type: UiService }, { type: OrderByPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], documentElms: [{
    type: ViewChildren,
    args: ["documentElm"]
  }], previewElm: [{
    type: ViewChild,
    args: ["previewElm"]
  }], exportElm: [{
    type: ViewChild,
    args: ["exportElm"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunityDetailsComponent, { className: "OpportunityDetailsComponent" });
})();

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/_element-chunk.mjs
function coerceNumberProperty(value, fallbackValue = 0) {
  if (_isNumberValue(value)) {
    return Number(value);
  }
  return arguments.length === 2 ? fallbackValue : 0;
}
function _isNumberValue(value) {
  return !isNaN(parseFloat(value)) && !isNaN(Number(value));
}
function coerceElement(elementOrRef) {
  return elementOrRef instanceof ElementRef ? elementOrRef.nativeElement : elementOrRef;
}

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/_platform-chunk.mjs
var hasV8BreakIterator;
try {
  hasV8BreakIterator = typeof Intl !== "undefined" && Intl.v8BreakIterator;
} catch {
  hasV8BreakIterator = false;
}
var Platform = class _Platform {
  _platformId = inject(PLATFORM_ID);
  isBrowser = this._platformId ? isPlatformBrowser(this._platformId) : typeof document === "object" && !!document;
  EDGE = this.isBrowser && /(edge)/i.test(navigator.userAgent);
  TRIDENT = this.isBrowser && /(msie|trident)/i.test(navigator.userAgent);
  BLINK = this.isBrowser && !!(window.chrome || hasV8BreakIterator) && typeof CSS !== "undefined" && !this.EDGE && !this.TRIDENT;
  WEBKIT = this.isBrowser && /AppleWebKit/i.test(navigator.userAgent) && !this.BLINK && !this.EDGE && !this.TRIDENT;
  IOS = this.isBrowser && /iPad|iPhone|iPod/.test(navigator.userAgent) && !("MSStream" in window);
  FIREFOX = this.isBrowser && /(firefox|minefield)/i.test(navigator.userAgent);
  ANDROID = this.isBrowser && /android/i.test(navigator.userAgent) && !this.TRIDENT;
  SAFARI = this.isBrowser && /safari/i.test(navigator.userAgent) && this.WEBKIT;
  constructor() {
  }
  static \u0275fac = function Platform_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _Platform)();
  };
  static \u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
    token: _Platform,
    factory: _Platform.\u0275fac,
    providedIn: "root"
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(Platform, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [], null);
})();

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/_directionality-chunk.mjs
var DIR_DOCUMENT = new InjectionToken("cdk-dir-doc", {
  providedIn: "root",
  factory: () => inject(DOCUMENT)
});
var RTL_LOCALE_PATTERN = /^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Adlm|Arab|Hebr|Nkoo|Rohg|Thaa))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)/i;
function _resolveDirectionality(rawValue) {
  const value = rawValue?.toLowerCase() || "";
  if (value === "auto" && typeof navigator !== "undefined" && navigator?.language) {
    return RTL_LOCALE_PATTERN.test(navigator.language) ? "rtl" : "ltr";
  }
  return value === "rtl" ? "rtl" : "ltr";
}
var Directionality = class _Directionality {
  get value() {
    return this.valueSignal();
  }
  valueSignal = signal("ltr", ...ngDevMode ? [{
    debugName: "valueSignal"
  }] : []);
  change = new EventEmitter();
  constructor() {
    const _document = inject(DIR_DOCUMENT, {
      optional: true
    });
    if (_document) {
      const bodyDir = _document.body ? _document.body.dir : null;
      const htmlDir = _document.documentElement ? _document.documentElement.dir : null;
      this.valueSignal.set(_resolveDirectionality(bodyDir || htmlDir || "ltr"));
    }
  }
  ngOnDestroy() {
    this.change.complete();
  }
  static \u0275fac = function Directionality_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _Directionality)();
  };
  static \u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
    token: _Directionality,
    factory: _Directionality.\u0275fac,
    providedIn: "root"
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(Directionality, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [], null);
})();

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/_scrolling-chunk.mjs
var RtlScrollAxisType;
(function(RtlScrollAxisType2) {
  RtlScrollAxisType2[RtlScrollAxisType2["NORMAL"] = 0] = "NORMAL";
  RtlScrollAxisType2[RtlScrollAxisType2["NEGATED"] = 1] = "NEGATED";
  RtlScrollAxisType2[RtlScrollAxisType2["INVERTED"] = 2] = "INVERTED";
})(RtlScrollAxisType || (RtlScrollAxisType = {}));
var rtlScrollAxisType;
var scrollBehaviorSupported;
function supportsScrollBehavior() {
  if (scrollBehaviorSupported == null) {
    if (typeof document !== "object" || !document || typeof Element !== "function" || !Element) {
      scrollBehaviorSupported = false;
      return scrollBehaviorSupported;
    }
    if (document.documentElement?.style && "scrollBehavior" in document.documentElement.style) {
      scrollBehaviorSupported = true;
    } else {
      const scrollToFunction = Element.prototype.scrollTo;
      if (scrollToFunction) {
        scrollBehaviorSupported = !/\{\s*\[native code\]\s*\}/.test(scrollToFunction.toString());
      } else {
        scrollBehaviorSupported = false;
      }
    }
  }
  return scrollBehaviorSupported;
}
function getRtlScrollAxisType() {
  if (typeof document !== "object" || !document) {
    return RtlScrollAxisType.NORMAL;
  }
  if (rtlScrollAxisType == null) {
    const scrollContainer = document.createElement("div");
    const containerStyle = scrollContainer.style;
    scrollContainer.dir = "rtl";
    containerStyle.width = "1px";
    containerStyle.overflow = "auto";
    containerStyle.visibility = "hidden";
    containerStyle.pointerEvents = "none";
    containerStyle.position = "absolute";
    const content = document.createElement("div");
    const contentStyle = content.style;
    contentStyle.width = "2px";
    contentStyle.height = "1px";
    scrollContainer.appendChild(content);
    document.body.appendChild(scrollContainer);
    rtlScrollAxisType = RtlScrollAxisType.NORMAL;
    if (scrollContainer.scrollLeft === 0) {
      scrollContainer.scrollLeft = 1;
      rtlScrollAxisType = scrollContainer.scrollLeft === 0 ? RtlScrollAxisType.NEGATED : RtlScrollAxisType.INVERTED;
    }
    scrollContainer.remove();
  }
  return rtlScrollAxisType;
}

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/bidi.mjs
var Dir = class _Dir {
  _isInitialized = false;
  _rawDir;
  change = new EventEmitter();
  get dir() {
    return this.valueSignal();
  }
  set dir(value) {
    const previousValue = this.valueSignal();
    this.valueSignal.set(_resolveDirectionality(value));
    this._rawDir = value;
    if (previousValue !== this.valueSignal() && this._isInitialized) {
      this.change.emit(this.valueSignal());
    }
  }
  get value() {
    return this.dir;
  }
  valueSignal = signal("ltr", ...ngDevMode ? [{
    debugName: "valueSignal"
  }] : []);
  ngAfterContentInit() {
    this._isInitialized = true;
  }
  ngOnDestroy() {
    this.change.complete();
  }
  static \u0275fac = function Dir_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _Dir)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _Dir,
    selectors: [["", "dir", ""]],
    hostVars: 1,
    hostBindings: function Dir_HostBindings(rf, ctx) {
      if (rf & 2) {
        \u0275\u0275attribute("dir", ctx._rawDir);
      }
    },
    inputs: {
      dir: "dir"
    },
    outputs: {
      change: "dirChange"
    },
    exportAs: ["dir"],
    features: [\u0275\u0275ProvidersFeature([{
      provide: Directionality,
      useExisting: _Dir
    }])]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(Dir, [{
    type: Directive,
    args: [{
      selector: "[dir]",
      providers: [{
        provide: Directionality,
        useExisting: Dir
      }],
      host: {
        "[attr.dir]": "_rawDir"
      },
      exportAs: "dir"
    }]
  }], null, {
    change: [{
      type: Output,
      args: ["dirChange"]
    }],
    dir: [{
      type: Input
    }]
  });
})();
var BidiModule = class _BidiModule {
  static \u0275fac = function BidiModule_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _BidiModule)();
  };
  static \u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
    type: _BidiModule,
    imports: [Dir],
    exports: [Dir]
  });
  static \u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({});
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(BidiModule, [{
    type: NgModule,
    args: [{
      imports: [Dir],
      exports: [Dir]
    }]
  }], null, null);
})();

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/_data-source-chunk.mjs
var DataSource = class {
};
function isDataSource(value) {
  return value && typeof value.connect === "function" && !(value instanceof ConnectableObservable);
}

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/_recycle-view-repeater-strategy-chunk.mjs
var ArrayDataSource = class extends DataSource {
  _data;
  constructor(_data) {
    super();
    this._data = _data;
  }
  connect() {
    return isObservable(this._data) ? this._data : of(this._data);
  }
  disconnect() {
  }
};
var _ViewRepeaterOperation;
(function(_ViewRepeaterOperation2) {
  _ViewRepeaterOperation2[_ViewRepeaterOperation2["REPLACED"] = 0] = "REPLACED";
  _ViewRepeaterOperation2[_ViewRepeaterOperation2["INSERTED"] = 1] = "INSERTED";
  _ViewRepeaterOperation2[_ViewRepeaterOperation2["MOVED"] = 2] = "MOVED";
  _ViewRepeaterOperation2[_ViewRepeaterOperation2["REMOVED"] = 3] = "REMOVED";
})(_ViewRepeaterOperation || (_ViewRepeaterOperation = {}));
var _VIEW_REPEATER_STRATEGY = new InjectionToken("_ViewRepeater");
var _RecycleViewRepeaterStrategy = class {
  viewCacheSize = 20;
  _viewCache = [];
  applyChanges(changes, viewContainerRef, itemContextFactory, itemValueResolver, itemViewChanged) {
    changes.forEachOperation((record, adjustedPreviousIndex, currentIndex) => {
      let view;
      let operation;
      if (record.previousIndex == null) {
        const viewArgsFactory = () => itemContextFactory(record, adjustedPreviousIndex, currentIndex);
        view = this._insertView(viewArgsFactory, currentIndex, viewContainerRef, itemValueResolver(record));
        operation = view ? _ViewRepeaterOperation.INSERTED : _ViewRepeaterOperation.REPLACED;
      } else if (currentIndex == null) {
        this._detachAndCacheView(adjustedPreviousIndex, viewContainerRef);
        operation = _ViewRepeaterOperation.REMOVED;
      } else {
        view = this._moveView(adjustedPreviousIndex, currentIndex, viewContainerRef, itemValueResolver(record));
        operation = _ViewRepeaterOperation.MOVED;
      }
      if (itemViewChanged) {
        itemViewChanged({
          context: view?.context,
          operation,
          record
        });
      }
    });
  }
  detach() {
    for (const view of this._viewCache) {
      view.destroy();
    }
    this._viewCache = [];
  }
  _insertView(viewArgsFactory, currentIndex, viewContainerRef, value) {
    const cachedView = this._insertViewFromCache(currentIndex, viewContainerRef);
    if (cachedView) {
      cachedView.context.$implicit = value;
      return void 0;
    }
    const viewArgs = viewArgsFactory();
    return viewContainerRef.createEmbeddedView(viewArgs.templateRef, viewArgs.context, viewArgs.index);
  }
  _detachAndCacheView(index, viewContainerRef) {
    const detachedView = viewContainerRef.detach(index);
    this._maybeCacheView(detachedView, viewContainerRef);
  }
  _moveView(adjustedPreviousIndex, currentIndex, viewContainerRef, value) {
    const view = viewContainerRef.get(adjustedPreviousIndex);
    viewContainerRef.move(view, currentIndex);
    view.context.$implicit = value;
    return view;
  }
  _maybeCacheView(view, viewContainerRef) {
    if (this._viewCache.length < this.viewCacheSize) {
      this._viewCache.push(view);
    } else {
      const index = viewContainerRef.indexOf(view);
      if (index === -1) {
        view.destroy();
      } else {
        viewContainerRef.remove(index);
      }
    }
  }
  _insertViewFromCache(index, viewContainerRef) {
    const cachedView = this._viewCache.pop();
    if (cachedView) {
      viewContainerRef.insert(cachedView, index);
    }
    return cachedView || null;
  }
};

// node_modules/.pnpm/@angular+cdk@21.0.5_@angular+common@21.0.3_@angular+core@21.0.3_@angular+compiler@21.0._f0eef4e7d4a019f534169406b8265e46/node_modules/@angular/cdk/fesm2022/scrolling.mjs
var _c08 = ["contentWrapper"];
var _c15 = ["*"];
var VIRTUAL_SCROLL_STRATEGY = new InjectionToken("VIRTUAL_SCROLL_STRATEGY");
var FixedSizeVirtualScrollStrategy = class {
  _scrolledIndexChange = new Subject();
  scrolledIndexChange = this._scrolledIndexChange.pipe(distinctUntilChanged());
  _viewport = null;
  _itemSize;
  _minBufferPx;
  _maxBufferPx;
  constructor(itemSize, minBufferPx, maxBufferPx) {
    this._itemSize = itemSize;
    this._minBufferPx = minBufferPx;
    this._maxBufferPx = maxBufferPx;
  }
  attach(viewport) {
    this._viewport = viewport;
    this._updateTotalContentSize();
    this._updateRenderedRange();
  }
  detach() {
    this._scrolledIndexChange.complete();
    this._viewport = null;
  }
  updateItemAndBufferSize(itemSize, minBufferPx, maxBufferPx) {
    if (maxBufferPx < minBufferPx && (typeof ngDevMode === "undefined" || ngDevMode)) {
      throw Error("CDK virtual scroll: maxBufferPx must be greater than or equal to minBufferPx");
    }
    this._itemSize = itemSize;
    this._minBufferPx = minBufferPx;
    this._maxBufferPx = maxBufferPx;
    this._updateTotalContentSize();
    this._updateRenderedRange();
  }
  onContentScrolled() {
    this._updateRenderedRange();
  }
  onDataLengthChanged() {
    this._updateTotalContentSize();
    this._updateRenderedRange();
  }
  onContentRendered() {
  }
  onRenderedOffsetChanged() {
  }
  scrollToIndex(index, behavior) {
    if (this._viewport) {
      this._viewport.scrollToOffset(index * this._itemSize, behavior);
    }
  }
  _updateTotalContentSize() {
    if (!this._viewport) {
      return;
    }
    this._viewport.setTotalContentSize(this._viewport.getDataLength() * this._itemSize);
  }
  _updateRenderedRange() {
    if (!this._viewport) {
      return;
    }
    const renderedRange = this._viewport.getRenderedRange();
    const newRange = {
      start: renderedRange.start,
      end: renderedRange.end
    };
    const viewportSize = this._viewport.getViewportSize();
    const dataLength = this._viewport.getDataLength();
    let scrollOffset = this._viewport.measureScrollOffset();
    let firstVisibleIndex = this._itemSize > 0 ? scrollOffset / this._itemSize : 0;
    if (newRange.end > dataLength) {
      const maxVisibleItems = Math.ceil(viewportSize / this._itemSize);
      const newVisibleIndex = Math.max(0, Math.min(firstVisibleIndex, dataLength - maxVisibleItems));
      if (firstVisibleIndex != newVisibleIndex) {
        firstVisibleIndex = newVisibleIndex;
        scrollOffset = newVisibleIndex * this._itemSize;
        newRange.start = Math.floor(firstVisibleIndex);
      }
      newRange.end = Math.max(0, Math.min(dataLength, newRange.start + maxVisibleItems));
    }
    const startBuffer = scrollOffset - newRange.start * this._itemSize;
    if (startBuffer < this._minBufferPx && newRange.start != 0) {
      const expandStart = Math.ceil((this._maxBufferPx - startBuffer) / this._itemSize);
      newRange.start = Math.max(0, newRange.start - expandStart);
      newRange.end = Math.min(dataLength, Math.ceil(firstVisibleIndex + (viewportSize + this._minBufferPx) / this._itemSize));
    } else {
      const endBuffer = newRange.end * this._itemSize - (scrollOffset + viewportSize);
      if (endBuffer < this._minBufferPx && newRange.end != dataLength) {
        const expandEnd = Math.ceil((this._maxBufferPx - endBuffer) / this._itemSize);
        if (expandEnd > 0) {
          newRange.end = Math.min(dataLength, newRange.end + expandEnd);
          newRange.start = Math.max(0, Math.floor(firstVisibleIndex - this._minBufferPx / this._itemSize));
        }
      }
    }
    this._viewport.setRenderedRange(newRange);
    this._viewport.setRenderedContentOffset(Math.round(this._itemSize * newRange.start));
    this._scrolledIndexChange.next(Math.floor(firstVisibleIndex));
  }
};
function _fixedSizeVirtualScrollStrategyFactory(fixedSizeDir) {
  return fixedSizeDir._scrollStrategy;
}
var CdkFixedSizeVirtualScroll = class _CdkFixedSizeVirtualScroll {
  get itemSize() {
    return this._itemSize;
  }
  set itemSize(value) {
    this._itemSize = coerceNumberProperty(value);
  }
  _itemSize = 20;
  get minBufferPx() {
    return this._minBufferPx;
  }
  set minBufferPx(value) {
    this._minBufferPx = coerceNumberProperty(value);
  }
  _minBufferPx = 100;
  get maxBufferPx() {
    return this._maxBufferPx;
  }
  set maxBufferPx(value) {
    this._maxBufferPx = coerceNumberProperty(value);
  }
  _maxBufferPx = 200;
  _scrollStrategy = new FixedSizeVirtualScrollStrategy(this.itemSize, this.minBufferPx, this.maxBufferPx);
  ngOnChanges() {
    this._scrollStrategy.updateItemAndBufferSize(this.itemSize, this.minBufferPx, this.maxBufferPx);
  }
  static \u0275fac = function CdkFixedSizeVirtualScroll_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkFixedSizeVirtualScroll)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _CdkFixedSizeVirtualScroll,
    selectors: [["cdk-virtual-scroll-viewport", "itemSize", ""]],
    inputs: {
      itemSize: "itemSize",
      minBufferPx: "minBufferPx",
      maxBufferPx: "maxBufferPx"
    },
    features: [\u0275\u0275ProvidersFeature([{
      provide: VIRTUAL_SCROLL_STRATEGY,
      useFactory: _fixedSizeVirtualScrollStrategyFactory,
      deps: [forwardRef(() => _CdkFixedSizeVirtualScroll)]
    }]), \u0275\u0275NgOnChangesFeature]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkFixedSizeVirtualScroll, [{
    type: Directive,
    args: [{
      selector: "cdk-virtual-scroll-viewport[itemSize]",
      providers: [{
        provide: VIRTUAL_SCROLL_STRATEGY,
        useFactory: _fixedSizeVirtualScrollStrategyFactory,
        deps: [forwardRef(() => CdkFixedSizeVirtualScroll)]
      }]
    }]
  }], null, {
    itemSize: [{
      type: Input
    }],
    minBufferPx: [{
      type: Input
    }],
    maxBufferPx: [{
      type: Input
    }]
  });
})();
var DEFAULT_SCROLL_TIME = 20;
var ScrollDispatcher = class _ScrollDispatcher {
  _ngZone = inject(NgZone);
  _platform = inject(Platform);
  _renderer = inject(RendererFactory2).createRenderer(null, null);
  _cleanupGlobalListener;
  constructor() {
  }
  _scrolled = new Subject();
  _scrolledCount = 0;
  scrollContainers = /* @__PURE__ */ new Map();
  register(scrollable) {
    if (!this.scrollContainers.has(scrollable)) {
      this.scrollContainers.set(scrollable, scrollable.elementScrolled().subscribe(() => this._scrolled.next(scrollable)));
    }
  }
  deregister(scrollable) {
    const scrollableReference = this.scrollContainers.get(scrollable);
    if (scrollableReference) {
      scrollableReference.unsubscribe();
      this.scrollContainers.delete(scrollable);
    }
  }
  scrolled(auditTimeInMs = DEFAULT_SCROLL_TIME) {
    if (!this._platform.isBrowser) {
      return of();
    }
    return new Observable((observer) => {
      if (!this._cleanupGlobalListener) {
        this._cleanupGlobalListener = this._ngZone.runOutsideAngular(() => this._renderer.listen("document", "scroll", () => this._scrolled.next()));
      }
      const subscription = auditTimeInMs > 0 ? this._scrolled.pipe(auditTime(auditTimeInMs)).subscribe(observer) : this._scrolled.subscribe(observer);
      this._scrolledCount++;
      return () => {
        subscription.unsubscribe();
        this._scrolledCount--;
        if (!this._scrolledCount) {
          this._cleanupGlobalListener?.();
          this._cleanupGlobalListener = void 0;
        }
      };
    });
  }
  ngOnDestroy() {
    this._cleanupGlobalListener?.();
    this._cleanupGlobalListener = void 0;
    this.scrollContainers.forEach((_, container) => this.deregister(container));
    this._scrolled.complete();
  }
  ancestorScrolled(elementOrElementRef, auditTimeInMs) {
    const ancestors = this.getAncestorScrollContainers(elementOrElementRef);
    return this.scrolled(auditTimeInMs).pipe(filter((target) => !target || ancestors.indexOf(target) > -1));
  }
  getAncestorScrollContainers(elementOrElementRef) {
    const scrollingContainers = [];
    this.scrollContainers.forEach((_subscription, scrollable) => {
      if (this._scrollableContainsElement(scrollable, elementOrElementRef)) {
        scrollingContainers.push(scrollable);
      }
    });
    return scrollingContainers;
  }
  _scrollableContainsElement(scrollable, elementOrElementRef) {
    let element = coerceElement(elementOrElementRef);
    let scrollableElement = scrollable.getElementRef().nativeElement;
    do {
      if (element == scrollableElement) {
        return true;
      }
    } while (element = element.parentElement);
    return false;
  }
  static \u0275fac = function ScrollDispatcher_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _ScrollDispatcher)();
  };
  static \u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
    token: _ScrollDispatcher,
    factory: _ScrollDispatcher.\u0275fac,
    providedIn: "root"
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ScrollDispatcher, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [], null);
})();
var CdkScrollable = class _CdkScrollable {
  elementRef = inject(ElementRef);
  scrollDispatcher = inject(ScrollDispatcher);
  ngZone = inject(NgZone);
  dir = inject(Directionality, {
    optional: true
  });
  _scrollElement = this.elementRef.nativeElement;
  _destroyed = new Subject();
  _renderer = inject(Renderer2);
  _cleanupScroll;
  _elementScrolled = new Subject();
  constructor() {
  }
  ngOnInit() {
    this._cleanupScroll = this.ngZone.runOutsideAngular(() => this._renderer.listen(this._scrollElement, "scroll", (event) => this._elementScrolled.next(event)));
    this.scrollDispatcher.register(this);
  }
  ngOnDestroy() {
    this._cleanupScroll?.();
    this._elementScrolled.complete();
    this.scrollDispatcher.deregister(this);
    this._destroyed.next();
    this._destroyed.complete();
  }
  elementScrolled() {
    return this._elementScrolled;
  }
  getElementRef() {
    return this.elementRef;
  }
  scrollTo(options) {
    const el = this.elementRef.nativeElement;
    const isRtl = this.dir && this.dir.value == "rtl";
    if (options.left == null) {
      options.left = isRtl ? options.end : options.start;
    }
    if (options.right == null) {
      options.right = isRtl ? options.start : options.end;
    }
    if (options.bottom != null) {
      options.top = el.scrollHeight - el.clientHeight - options.bottom;
    }
    if (isRtl && getRtlScrollAxisType() != RtlScrollAxisType.NORMAL) {
      if (options.left != null) {
        options.right = el.scrollWidth - el.clientWidth - options.left;
      }
      if (getRtlScrollAxisType() == RtlScrollAxisType.INVERTED) {
        options.left = options.right;
      } else if (getRtlScrollAxisType() == RtlScrollAxisType.NEGATED) {
        options.left = options.right ? -options.right : options.right;
      }
    } else {
      if (options.right != null) {
        options.left = el.scrollWidth - el.clientWidth - options.right;
      }
    }
    this._applyScrollToOptions(options);
  }
  _applyScrollToOptions(options) {
    const el = this.elementRef.nativeElement;
    if (supportsScrollBehavior()) {
      el.scrollTo(options);
    } else {
      if (options.top != null) {
        el.scrollTop = options.top;
      }
      if (options.left != null) {
        el.scrollLeft = options.left;
      }
    }
  }
  measureScrollOffset(from) {
    const LEFT = "left";
    const RIGHT = "right";
    const el = this.elementRef.nativeElement;
    if (from == "top") {
      return el.scrollTop;
    }
    if (from == "bottom") {
      return el.scrollHeight - el.clientHeight - el.scrollTop;
    }
    const isRtl = this.dir && this.dir.value == "rtl";
    if (from == "start") {
      from = isRtl ? RIGHT : LEFT;
    } else if (from == "end") {
      from = isRtl ? LEFT : RIGHT;
    }
    if (isRtl && getRtlScrollAxisType() == RtlScrollAxisType.INVERTED) {
      if (from == LEFT) {
        return el.scrollWidth - el.clientWidth - el.scrollLeft;
      } else {
        return el.scrollLeft;
      }
    } else if (isRtl && getRtlScrollAxisType() == RtlScrollAxisType.NEGATED) {
      if (from == LEFT) {
        return el.scrollLeft + el.scrollWidth - el.clientWidth;
      } else {
        return -el.scrollLeft;
      }
    } else {
      if (from == LEFT) {
        return el.scrollLeft;
      } else {
        return el.scrollWidth - el.clientWidth - el.scrollLeft;
      }
    }
  }
  static \u0275fac = function CdkScrollable_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkScrollable)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _CdkScrollable,
    selectors: [["", "cdk-scrollable", ""], ["", "cdkScrollable", ""]]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkScrollable, [{
    type: Directive,
    args: [{
      selector: "[cdk-scrollable], [cdkScrollable]"
    }]
  }], () => [], null);
})();
var DEFAULT_RESIZE_TIME = 20;
var ViewportRuler = class _ViewportRuler {
  _platform = inject(Platform);
  _listeners;
  _viewportSize;
  _change = new Subject();
  _document = inject(DOCUMENT);
  constructor() {
    const ngZone = inject(NgZone);
    const renderer = inject(RendererFactory2).createRenderer(null, null);
    ngZone.runOutsideAngular(() => {
      if (this._platform.isBrowser) {
        const changeListener = (event) => this._change.next(event);
        this._listeners = [renderer.listen("window", "resize", changeListener), renderer.listen("window", "orientationchange", changeListener)];
      }
      this.change().subscribe(() => this._viewportSize = null);
    });
  }
  ngOnDestroy() {
    this._listeners?.forEach((cleanup) => cleanup());
    this._change.complete();
  }
  getViewportSize() {
    if (!this._viewportSize) {
      this._updateViewportSize();
    }
    const output = {
      width: this._viewportSize.width,
      height: this._viewportSize.height
    };
    if (!this._platform.isBrowser) {
      this._viewportSize = null;
    }
    return output;
  }
  getViewportRect() {
    const scrollPosition = this.getViewportScrollPosition();
    const {
      width,
      height
    } = this.getViewportSize();
    return {
      top: scrollPosition.top,
      left: scrollPosition.left,
      bottom: scrollPosition.top + height,
      right: scrollPosition.left + width,
      height,
      width
    };
  }
  getViewportScrollPosition() {
    if (!this._platform.isBrowser) {
      return {
        top: 0,
        left: 0
      };
    }
    const document2 = this._document;
    const window2 = this._getWindow();
    const documentElement = document2.documentElement;
    const documentRect = documentElement.getBoundingClientRect();
    const top = -documentRect.top || document2.body.scrollTop || window2.scrollY || documentElement.scrollTop || 0;
    const left = -documentRect.left || document2.body.scrollLeft || window2.scrollX || documentElement.scrollLeft || 0;
    return {
      top,
      left
    };
  }
  change(throttleTime = DEFAULT_RESIZE_TIME) {
    return throttleTime > 0 ? this._change.pipe(auditTime(throttleTime)) : this._change;
  }
  _getWindow() {
    return this._document.defaultView || window;
  }
  _updateViewportSize() {
    const window2 = this._getWindow();
    this._viewportSize = this._platform.isBrowser ? {
      width: window2.innerWidth,
      height: window2.innerHeight
    } : {
      width: 0,
      height: 0
    };
  }
  static \u0275fac = function ViewportRuler_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _ViewportRuler)();
  };
  static \u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({
    token: _ViewportRuler,
    factory: _ViewportRuler.\u0275fac,
    providedIn: "root"
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ViewportRuler, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [], null);
})();
var VIRTUAL_SCROLLABLE = new InjectionToken("VIRTUAL_SCROLLABLE");
var CdkVirtualScrollable = class _CdkVirtualScrollable extends CdkScrollable {
  constructor() {
    super();
  }
  measureViewportSize(orientation) {
    const viewportEl = this.elementRef.nativeElement;
    return orientation === "horizontal" ? viewportEl.clientWidth : viewportEl.clientHeight;
  }
  static \u0275fac = function CdkVirtualScrollable_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkVirtualScrollable)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _CdkVirtualScrollable,
    features: [\u0275\u0275InheritDefinitionFeature]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkVirtualScrollable, [{
    type: Directive
  }], () => [], null);
})();
function rangesEqual(r1, r2) {
  return r1.start == r2.start && r1.end == r2.end;
}
var SCROLL_SCHEDULER = typeof requestAnimationFrame !== "undefined" ? animationFrameScheduler : asapScheduler;
var CdkVirtualScrollViewport = class _CdkVirtualScrollViewport extends CdkVirtualScrollable {
  elementRef = inject(ElementRef);
  _changeDetectorRef = inject(ChangeDetectorRef);
  _scrollStrategy = inject(VIRTUAL_SCROLL_STRATEGY, {
    optional: true
  });
  scrollable = inject(VIRTUAL_SCROLLABLE, {
    optional: true
  });
  _platform = inject(Platform);
  _detachedSubject = new Subject();
  _renderedRangeSubject = new Subject();
  get orientation() {
    return this._orientation;
  }
  set orientation(orientation) {
    if (this._orientation !== orientation) {
      this._orientation = orientation;
      this._calculateSpacerSize();
    }
  }
  _orientation = "vertical";
  appendOnly = false;
  scrolledIndexChange = new Observable((observer) => this._scrollStrategy.scrolledIndexChange.subscribe((index) => Promise.resolve().then(() => this.ngZone.run(() => observer.next(index)))));
  _contentWrapper;
  renderedRangeStream = this._renderedRangeSubject;
  _totalContentSize = 0;
  _totalContentWidth = signal("", ...ngDevMode ? [{
    debugName: "_totalContentWidth"
  }] : []);
  _totalContentHeight = signal("", ...ngDevMode ? [{
    debugName: "_totalContentHeight"
  }] : []);
  _renderedContentTransform;
  _renderedRange = {
    start: 0,
    end: 0
  };
  _dataLength = 0;
  _viewportSize = 0;
  _forOf;
  _renderedContentOffset = 0;
  _renderedContentOffsetNeedsRewrite = false;
  _changeDetectionNeeded = signal(false, ...ngDevMode ? [{
    debugName: "_changeDetectionNeeded"
  }] : []);
  _runAfterChangeDetection = [];
  _viewportChanges = Subscription.EMPTY;
  _injector = inject(Injector);
  _isDestroyed = false;
  constructor() {
    super();
    const viewportRuler = inject(ViewportRuler);
    if (!this._scrollStrategy && (typeof ngDevMode === "undefined" || ngDevMode)) {
      throw Error('Error: cdk-virtual-scroll-viewport requires the "itemSize" property to be set.');
    }
    this._viewportChanges = viewportRuler.change().subscribe(() => {
      this.checkViewportSize();
    });
    if (!this.scrollable) {
      this.elementRef.nativeElement.classList.add("cdk-virtual-scrollable");
      this.scrollable = this;
    }
    const ref = effect(() => {
      if (this._changeDetectionNeeded()) {
        this._doChangeDetection();
      }
    }, __spreadProps(__spreadValues({}, ngDevMode ? {
      debugName: "ref"
    } : {}), {
      injector: inject(ApplicationRef).injector
    }));
    inject(DestroyRef).onDestroy(() => void ref.destroy());
  }
  ngOnInit() {
    if (!this._platform.isBrowser) {
      return;
    }
    if (this.scrollable === this) {
      super.ngOnInit();
    }
    this.ngZone.runOutsideAngular(() => Promise.resolve().then(() => {
      this._measureViewportSize();
      this._scrollStrategy.attach(this);
      this.scrollable.elementScrolled().pipe(startWith(null), auditTime(0, SCROLL_SCHEDULER), takeUntil(this._destroyed)).subscribe(() => this._scrollStrategy.onContentScrolled());
      this._markChangeDetectionNeeded();
    }));
  }
  ngOnDestroy() {
    this.detach();
    this._scrollStrategy.detach();
    this._renderedRangeSubject.complete();
    this._detachedSubject.complete();
    this._viewportChanges.unsubscribe();
    this._isDestroyed = true;
    super.ngOnDestroy();
  }
  attach(forOf) {
    if (this._forOf && (typeof ngDevMode === "undefined" || ngDevMode)) {
      throw Error("CdkVirtualScrollViewport is already attached.");
    }
    this.ngZone.runOutsideAngular(() => {
      this._forOf = forOf;
      this._forOf.dataStream.pipe(takeUntil(this._detachedSubject)).subscribe((data) => {
        const newLength = data.length;
        if (newLength !== this._dataLength) {
          this._dataLength = newLength;
          this._scrollStrategy.onDataLengthChanged();
        }
        this._doChangeDetection();
      });
    });
  }
  detach() {
    this._forOf = null;
    this._detachedSubject.next();
  }
  getDataLength() {
    return this._dataLength;
  }
  getViewportSize() {
    return this._viewportSize;
  }
  getRenderedRange() {
    return this._renderedRange;
  }
  measureBoundingClientRectWithScrollOffset(from) {
    return this.getElementRef().nativeElement.getBoundingClientRect()[from];
  }
  setTotalContentSize(size) {
    if (this._totalContentSize !== size) {
      this._totalContentSize = size;
      this._calculateSpacerSize();
      this._markChangeDetectionNeeded();
    }
  }
  setRenderedRange(range) {
    if (!rangesEqual(this._renderedRange, range)) {
      if (this.appendOnly) {
        range = {
          start: 0,
          end: Math.max(this._renderedRange.end, range.end)
        };
      }
      this._renderedRangeSubject.next(this._renderedRange = range);
      this._markChangeDetectionNeeded(() => this._scrollStrategy.onContentRendered());
    }
  }
  getOffsetToRenderedContentStart() {
    return this._renderedContentOffsetNeedsRewrite ? null : this._renderedContentOffset;
  }
  setRenderedContentOffset(offset, to = "to-start") {
    offset = this.appendOnly && to === "to-start" ? 0 : offset;
    const isRtl = this.dir && this.dir.value == "rtl";
    const isHorizontal = this.orientation == "horizontal";
    const axis = isHorizontal ? "X" : "Y";
    const axisDirection = isHorizontal && isRtl ? -1 : 1;
    let transform = `translate${axis}(${Number(axisDirection * offset)}px)`;
    this._renderedContentOffset = offset;
    if (to === "to-end") {
      transform += ` translate${axis}(-100%)`;
      this._renderedContentOffsetNeedsRewrite = true;
    }
    if (this._renderedContentTransform != transform) {
      this._renderedContentTransform = transform;
      this._markChangeDetectionNeeded(() => {
        if (this._renderedContentOffsetNeedsRewrite) {
          this._renderedContentOffset -= this.measureRenderedContentSize();
          this._renderedContentOffsetNeedsRewrite = false;
          this.setRenderedContentOffset(this._renderedContentOffset);
        } else {
          this._scrollStrategy.onRenderedOffsetChanged();
        }
      });
    }
  }
  scrollToOffset(offset, behavior = "auto") {
    const options = {
      behavior
    };
    if (this.orientation === "horizontal") {
      options.start = offset;
    } else {
      options.top = offset;
    }
    this.scrollable.scrollTo(options);
  }
  scrollToIndex(index, behavior = "auto") {
    this._scrollStrategy.scrollToIndex(index, behavior);
  }
  measureScrollOffset(from) {
    let measureScrollOffset;
    if (this.scrollable == this) {
      measureScrollOffset = (_from) => super.measureScrollOffset(_from);
    } else {
      measureScrollOffset = (_from) => this.scrollable.measureScrollOffset(_from);
    }
    return Math.max(0, measureScrollOffset(from ?? (this.orientation === "horizontal" ? "start" : "top")) - this.measureViewportOffset());
  }
  measureViewportOffset(from) {
    let fromRect;
    const LEFT = "left";
    const RIGHT = "right";
    const isRtl = this.dir?.value == "rtl";
    if (from == "start") {
      fromRect = isRtl ? RIGHT : LEFT;
    } else if (from == "end") {
      fromRect = isRtl ? LEFT : RIGHT;
    } else if (from) {
      fromRect = from;
    } else {
      fromRect = this.orientation === "horizontal" ? "left" : "top";
    }
    const scrollerClientRect = this.scrollable.measureBoundingClientRectWithScrollOffset(fromRect);
    const viewportClientRect = this.elementRef.nativeElement.getBoundingClientRect()[fromRect];
    return viewportClientRect - scrollerClientRect;
  }
  measureRenderedContentSize() {
    const contentEl = this._contentWrapper.nativeElement;
    return this.orientation === "horizontal" ? contentEl.offsetWidth : contentEl.offsetHeight;
  }
  measureRangeSize(range) {
    if (!this._forOf) {
      return 0;
    }
    return this._forOf.measureRangeSize(range, this.orientation);
  }
  checkViewportSize() {
    this._measureViewportSize();
    this._scrollStrategy.onDataLengthChanged();
  }
  _measureViewportSize() {
    this._viewportSize = this.scrollable.measureViewportSize(this.orientation);
  }
  _markChangeDetectionNeeded(runAfter) {
    if (runAfter) {
      this._runAfterChangeDetection.push(runAfter);
    }
    if (untracked(this._changeDetectionNeeded)) {
      return;
    }
    this.ngZone.runOutsideAngular(() => {
      Promise.resolve().then(() => {
        this.ngZone.run(() => {
          this._changeDetectionNeeded.set(true);
        });
      });
    });
  }
  _doChangeDetection() {
    if (this._isDestroyed) {
      return;
    }
    this.ngZone.run(() => {
      this._changeDetectorRef.markForCheck();
      this._contentWrapper.nativeElement.style.transform = this._renderedContentTransform;
      afterNextRender(() => {
        this._changeDetectionNeeded.set(false);
        const runAfterChangeDetection = this._runAfterChangeDetection;
        this._runAfterChangeDetection = [];
        for (const fn of runAfterChangeDetection) {
          fn();
        }
      }, {
        injector: this._injector
      });
    });
  }
  _calculateSpacerSize() {
    this._totalContentHeight.set(this.orientation === "horizontal" ? "" : `${this._totalContentSize}px`);
    this._totalContentWidth.set(this.orientation === "horizontal" ? `${this._totalContentSize}px` : "");
  }
  static \u0275fac = function CdkVirtualScrollViewport_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkVirtualScrollViewport)();
  };
  static \u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({
    type: _CdkVirtualScrollViewport,
    selectors: [["cdk-virtual-scroll-viewport"]],
    viewQuery: function CdkVirtualScrollViewport_Query(rf, ctx) {
      if (rf & 1) {
        \u0275\u0275viewQuery(_c08, 7);
      }
      if (rf & 2) {
        let _t;
        \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx._contentWrapper = _t.first);
      }
    },
    hostAttrs: [1, "cdk-virtual-scroll-viewport"],
    hostVars: 4,
    hostBindings: function CdkVirtualScrollViewport_HostBindings(rf, ctx) {
      if (rf & 2) {
        \u0275\u0275classProp("cdk-virtual-scroll-orientation-horizontal", ctx.orientation === "horizontal")("cdk-virtual-scroll-orientation-vertical", ctx.orientation !== "horizontal");
      }
    },
    inputs: {
      orientation: "orientation",
      appendOnly: [2, "appendOnly", "appendOnly", booleanAttribute]
    },
    outputs: {
      scrolledIndexChange: "scrolledIndexChange"
    },
    features: [\u0275\u0275ProvidersFeature([{
      provide: CdkScrollable,
      useFactory: () => inject(VIRTUAL_SCROLLABLE, {
        optional: true
      }) || inject(_CdkVirtualScrollViewport)
    }]), \u0275\u0275InheritDefinitionFeature],
    ngContentSelectors: _c15,
    decls: 4,
    vars: 4,
    consts: [["contentWrapper", ""], [1, "cdk-virtual-scroll-content-wrapper"], [1, "cdk-virtual-scroll-spacer"]],
    template: function CdkVirtualScrollViewport_Template(rf, ctx) {
      if (rf & 1) {
        \u0275\u0275projectionDef();
        \u0275\u0275domElementStart(0, "div", 1, 0);
        \u0275\u0275projection(2);
        \u0275\u0275domElementEnd();
        \u0275\u0275domElement(3, "div", 2);
      }
      if (rf & 2) {
        \u0275\u0275advance(3);
        \u0275\u0275styleProp("width", ctx._totalContentWidth())("height", ctx._totalContentHeight());
      }
    },
    styles: ["cdk-virtual-scroll-viewport{display:block;position:relative;transform:translateZ(0)}.cdk-virtual-scrollable{overflow:auto;will-change:scroll-position;contain:strict}.cdk-virtual-scroll-content-wrapper{position:absolute;top:0;left:0;contain:content}[dir=rtl] .cdk-virtual-scroll-content-wrapper{right:0;left:auto}.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper{min-height:100%}.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>dl:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>ol:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>table:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>ul:not([cdkVirtualFor]){padding-left:0;padding-right:0;margin-left:0;margin-right:0;border-left-width:0;border-right-width:0;outline:none}.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper{min-width:100%}.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>dl:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>ol:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>table:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>ul:not([cdkVirtualFor]){padding-top:0;padding-bottom:0;margin-top:0;margin-bottom:0;border-top-width:0;border-bottom-width:0;outline:none}.cdk-virtual-scroll-spacer{height:1px;transform-origin:0 0;flex:0 0 auto}[dir=rtl] .cdk-virtual-scroll-spacer{transform-origin:100% 0}\n"],
    encapsulation: 2,
    changeDetection: 0
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkVirtualScrollViewport, [{
    type: Component,
    args: [{
      selector: "cdk-virtual-scroll-viewport",
      host: {
        "class": "cdk-virtual-scroll-viewport",
        "[class.cdk-virtual-scroll-orientation-horizontal]": 'orientation === "horizontal"',
        "[class.cdk-virtual-scroll-orientation-vertical]": 'orientation !== "horizontal"'
      },
      encapsulation: ViewEncapsulation.None,
      changeDetection: ChangeDetectionStrategy.OnPush,
      providers: [{
        provide: CdkScrollable,
        useFactory: () => inject(VIRTUAL_SCROLLABLE, {
          optional: true
        }) || inject(CdkVirtualScrollViewport)
      }],
      template: '<!--\n  Wrap the rendered content in an element that will be used to offset it based on the scroll\n  position.\n-->\n<div #contentWrapper class="cdk-virtual-scroll-content-wrapper">\n  <ng-content></ng-content>\n</div>\n<!--\n  Spacer used to force the scrolling container to the correct size for the *total* number of items\n  so that the scrollbar captures the size of the entire data set.\n-->\n<div class="cdk-virtual-scroll-spacer"\n     [style.width]="_totalContentWidth()" [style.height]="_totalContentHeight()"></div>\n',
      styles: ["cdk-virtual-scroll-viewport{display:block;position:relative;transform:translateZ(0)}.cdk-virtual-scrollable{overflow:auto;will-change:scroll-position;contain:strict}.cdk-virtual-scroll-content-wrapper{position:absolute;top:0;left:0;contain:content}[dir=rtl] .cdk-virtual-scroll-content-wrapper{right:0;left:auto}.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper{min-height:100%}.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>dl:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>ol:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>table:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>ul:not([cdkVirtualFor]){padding-left:0;padding-right:0;margin-left:0;margin-right:0;border-left-width:0;border-right-width:0;outline:none}.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper{min-width:100%}.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>dl:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>ol:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>table:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>ul:not([cdkVirtualFor]){padding-top:0;padding-bottom:0;margin-top:0;margin-bottom:0;border-top-width:0;border-bottom-width:0;outline:none}.cdk-virtual-scroll-spacer{height:1px;transform-origin:0 0;flex:0 0 auto}[dir=rtl] .cdk-virtual-scroll-spacer{transform-origin:100% 0}\n"]
    }]
  }], () => [], {
    orientation: [{
      type: Input
    }],
    appendOnly: [{
      type: Input,
      args: [{
        transform: booleanAttribute
      }]
    }],
    scrolledIndexChange: [{
      type: Output
    }],
    _contentWrapper: [{
      type: ViewChild,
      args: ["contentWrapper", {
        static: true
      }]
    }]
  });
})();
function getOffset(orientation, direction, node) {
  const el = node;
  if (!el.getBoundingClientRect) {
    return 0;
  }
  const rect = el.getBoundingClientRect();
  if (orientation === "horizontal") {
    return direction === "start" ? rect.left : rect.right;
  }
  return direction === "start" ? rect.top : rect.bottom;
}
var CdkVirtualForOf = class _CdkVirtualForOf {
  _viewContainerRef = inject(ViewContainerRef);
  _template = inject(TemplateRef);
  _differs = inject(IterableDiffers);
  _viewRepeater = inject(_VIEW_REPEATER_STRATEGY);
  _viewport = inject(CdkVirtualScrollViewport, {
    skipSelf: true
  });
  viewChange = new Subject();
  _dataSourceChanges = new Subject();
  get cdkVirtualForOf() {
    return this._cdkVirtualForOf;
  }
  set cdkVirtualForOf(value) {
    this._cdkVirtualForOf = value;
    if (isDataSource(value)) {
      this._dataSourceChanges.next(value);
    } else {
      this._dataSourceChanges.next(new ArrayDataSource(isObservable(value) ? value : Array.from(value || [])));
    }
  }
  _cdkVirtualForOf;
  get cdkVirtualForTrackBy() {
    return this._cdkVirtualForTrackBy;
  }
  set cdkVirtualForTrackBy(fn) {
    this._needsUpdate = true;
    this._cdkVirtualForTrackBy = fn ? (index, item) => fn(index + (this._renderedRange ? this._renderedRange.start : 0), item) : void 0;
  }
  _cdkVirtualForTrackBy;
  set cdkVirtualForTemplate(value) {
    if (value) {
      this._needsUpdate = true;
      this._template = value;
    }
  }
  get cdkVirtualForTemplateCacheSize() {
    return this._viewRepeater.viewCacheSize;
  }
  set cdkVirtualForTemplateCacheSize(size) {
    this._viewRepeater.viewCacheSize = coerceNumberProperty(size);
  }
  dataStream = this._dataSourceChanges.pipe(startWith(null), pairwise(), switchMap(([prev, cur]) => this._changeDataSource(prev, cur)), shareReplay(1));
  _differ = null;
  _data;
  _renderedItems;
  _renderedRange;
  _needsUpdate = false;
  _destroyed = new Subject();
  constructor() {
    const ngZone = inject(NgZone);
    this.dataStream.subscribe((data) => {
      this._data = data;
      this._onRenderedDataChange();
    });
    this._viewport.renderedRangeStream.pipe(takeUntil(this._destroyed)).subscribe((range) => {
      this._renderedRange = range;
      if (this.viewChange.observers.length) {
        ngZone.run(() => this.viewChange.next(this._renderedRange));
      }
      this._onRenderedDataChange();
    });
    this._viewport.attach(this);
  }
  measureRangeSize(range, orientation) {
    if (range.start >= range.end) {
      return 0;
    }
    if ((range.start < this._renderedRange.start || range.end > this._renderedRange.end) && (typeof ngDevMode === "undefined" || ngDevMode)) {
      throw Error(`Error: attempted to measure an item that isn't rendered.`);
    }
    const renderedStartIndex = range.start - this._renderedRange.start;
    const rangeLen = range.end - range.start;
    let firstNode;
    let lastNode;
    for (let i = 0; i < rangeLen; i++) {
      const view = this._viewContainerRef.get(i + renderedStartIndex);
      if (view && view.rootNodes.length) {
        firstNode = lastNode = view.rootNodes[0];
        break;
      }
    }
    for (let i = rangeLen - 1; i > -1; i--) {
      const view = this._viewContainerRef.get(i + renderedStartIndex);
      if (view && view.rootNodes.length) {
        lastNode = view.rootNodes[view.rootNodes.length - 1];
        break;
      }
    }
    return firstNode && lastNode ? getOffset(orientation, "end", lastNode) - getOffset(orientation, "start", firstNode) : 0;
  }
  ngDoCheck() {
    if (this._differ && this._needsUpdate) {
      const changes = this._differ.diff(this._renderedItems);
      if (!changes) {
        this._updateContext();
      } else {
        this._applyChanges(changes);
      }
      this._needsUpdate = false;
    }
  }
  ngOnDestroy() {
    this._viewport.detach();
    this._dataSourceChanges.next(void 0);
    this._dataSourceChanges.complete();
    this.viewChange.complete();
    this._destroyed.next();
    this._destroyed.complete();
    this._viewRepeater.detach();
  }
  _onRenderedDataChange() {
    if (!this._renderedRange) {
      return;
    }
    this._renderedItems = this._data.slice(this._renderedRange.start, this._renderedRange.end);
    if (!this._differ) {
      this._differ = this._differs.find(this._renderedItems).create((index, item) => {
        return this.cdkVirtualForTrackBy ? this.cdkVirtualForTrackBy(index, item) : item;
      });
    }
    this._needsUpdate = true;
  }
  _changeDataSource(oldDs, newDs) {
    if (oldDs) {
      oldDs.disconnect(this);
    }
    this._needsUpdate = true;
    return newDs ? newDs.connect(this) : of();
  }
  _updateContext() {
    const count = this._data.length;
    let i = this._viewContainerRef.length;
    while (i--) {
      const view = this._viewContainerRef.get(i);
      view.context.index = this._renderedRange.start + i;
      view.context.count = count;
      this._updateComputedContextProperties(view.context);
      view.detectChanges();
    }
  }
  _applyChanges(changes) {
    this._viewRepeater.applyChanges(changes, this._viewContainerRef, (record, _adjustedPreviousIndex, currentIndex) => this._getEmbeddedViewArgs(record, currentIndex), (record) => record.item);
    changes.forEachIdentityChange((record) => {
      const view = this._viewContainerRef.get(record.currentIndex);
      view.context.$implicit = record.item;
    });
    const count = this._data.length;
    let i = this._viewContainerRef.length;
    while (i--) {
      const view = this._viewContainerRef.get(i);
      view.context.index = this._renderedRange.start + i;
      view.context.count = count;
      this._updateComputedContextProperties(view.context);
    }
  }
  _updateComputedContextProperties(context) {
    context.first = context.index === 0;
    context.last = context.index === context.count - 1;
    context.even = context.index % 2 === 0;
    context.odd = !context.even;
  }
  _getEmbeddedViewArgs(record, index) {
    return {
      templateRef: this._template,
      context: {
        $implicit: record.item,
        cdkVirtualForOf: this._cdkVirtualForOf,
        index: -1,
        count: -1,
        first: false,
        last: false,
        odd: false,
        even: false
      },
      index
    };
  }
  static ngTemplateContextGuard(directive, context) {
    return true;
  }
  static \u0275fac = function CdkVirtualForOf_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkVirtualForOf)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _CdkVirtualForOf,
    selectors: [["", "cdkVirtualFor", "", "cdkVirtualForOf", ""]],
    inputs: {
      cdkVirtualForOf: "cdkVirtualForOf",
      cdkVirtualForTrackBy: "cdkVirtualForTrackBy",
      cdkVirtualForTemplate: "cdkVirtualForTemplate",
      cdkVirtualForTemplateCacheSize: "cdkVirtualForTemplateCacheSize"
    },
    features: [\u0275\u0275ProvidersFeature([{
      provide: _VIEW_REPEATER_STRATEGY,
      useClass: _RecycleViewRepeaterStrategy
    }])]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkVirtualForOf, [{
    type: Directive,
    args: [{
      selector: "[cdkVirtualFor][cdkVirtualForOf]",
      providers: [{
        provide: _VIEW_REPEATER_STRATEGY,
        useClass: _RecycleViewRepeaterStrategy
      }]
    }]
  }], () => [], {
    cdkVirtualForOf: [{
      type: Input
    }],
    cdkVirtualForTrackBy: [{
      type: Input
    }],
    cdkVirtualForTemplate: [{
      type: Input
    }],
    cdkVirtualForTemplateCacheSize: [{
      type: Input
    }]
  });
})();
var CdkVirtualScrollableElement = class _CdkVirtualScrollableElement extends CdkVirtualScrollable {
  constructor() {
    super();
  }
  measureBoundingClientRectWithScrollOffset(from) {
    return this.getElementRef().nativeElement.getBoundingClientRect()[from] - this.measureScrollOffset(from);
  }
  static \u0275fac = function CdkVirtualScrollableElement_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkVirtualScrollableElement)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _CdkVirtualScrollableElement,
    selectors: [["", "cdkVirtualScrollingElement", ""]],
    hostAttrs: [1, "cdk-virtual-scrollable"],
    features: [\u0275\u0275ProvidersFeature([{
      provide: VIRTUAL_SCROLLABLE,
      useExisting: _CdkVirtualScrollableElement
    }]), \u0275\u0275InheritDefinitionFeature]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkVirtualScrollableElement, [{
    type: Directive,
    args: [{
      selector: "[cdkVirtualScrollingElement]",
      providers: [{
        provide: VIRTUAL_SCROLLABLE,
        useExisting: CdkVirtualScrollableElement
      }],
      host: {
        "class": "cdk-virtual-scrollable"
      }
    }]
  }], () => [], null);
})();
var CdkVirtualScrollableWindow = class _CdkVirtualScrollableWindow extends CdkVirtualScrollable {
  constructor() {
    super();
    const document2 = inject(DOCUMENT);
    this.elementRef = new ElementRef(document2.documentElement);
    this._scrollElement = document2;
  }
  measureBoundingClientRectWithScrollOffset(from) {
    return this.getElementRef().nativeElement.getBoundingClientRect()[from];
  }
  static \u0275fac = function CdkVirtualScrollableWindow_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkVirtualScrollableWindow)();
  };
  static \u0275dir = /* @__PURE__ */ \u0275\u0275defineDirective({
    type: _CdkVirtualScrollableWindow,
    selectors: [["cdk-virtual-scroll-viewport", "scrollWindow", ""]],
    features: [\u0275\u0275ProvidersFeature([{
      provide: VIRTUAL_SCROLLABLE,
      useExisting: _CdkVirtualScrollableWindow
    }]), \u0275\u0275InheritDefinitionFeature]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkVirtualScrollableWindow, [{
    type: Directive,
    args: [{
      selector: "cdk-virtual-scroll-viewport[scrollWindow]",
      providers: [{
        provide: VIRTUAL_SCROLLABLE,
        useExisting: CdkVirtualScrollableWindow
      }]
    }]
  }], () => [], null);
})();
var CdkScrollableModule = class _CdkScrollableModule {
  static \u0275fac = function CdkScrollableModule_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _CdkScrollableModule)();
  };
  static \u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
    type: _CdkScrollableModule,
    imports: [CdkScrollable],
    exports: [CdkScrollable]
  });
  static \u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({});
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CdkScrollableModule, [{
    type: NgModule,
    args: [{
      exports: [CdkScrollable],
      imports: [CdkScrollable]
    }]
  }], null, null);
})();
var ScrollingModule = class _ScrollingModule {
  static \u0275fac = function ScrollingModule_Factory(__ngFactoryType__) {
    return new (__ngFactoryType__ || _ScrollingModule)();
  };
  static \u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({
    type: _ScrollingModule,
    imports: [BidiModule, CdkScrollableModule, CdkVirtualScrollViewport, CdkFixedSizeVirtualScroll, CdkVirtualForOf, CdkVirtualScrollableWindow, CdkVirtualScrollableElement],
    exports: [BidiModule, CdkScrollableModule, CdkFixedSizeVirtualScroll, CdkVirtualForOf, CdkVirtualScrollViewport, CdkVirtualScrollableWindow, CdkVirtualScrollableElement]
  });
  static \u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({
    imports: [BidiModule, CdkScrollableModule, BidiModule, CdkScrollableModule]
  });
};
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ScrollingModule, [{
    type: NgModule,
    args: [{
      imports: [BidiModule, CdkScrollableModule, CdkVirtualScrollViewport, CdkFixedSizeVirtualScroll, CdkVirtualForOf, CdkVirtualScrollableWindow, CdkVirtualScrollableElement],
      exports: [BidiModule, CdkScrollableModule, CdkFixedSizeVirtualScroll, CdkVirtualForOf, CdkVirtualScrollViewport, CdkVirtualScrollableWindow, CdkVirtualScrollableElement]
    }]
  }], null, null);
})();

// src/app/shared/opportunities/components/ledger/ledger.component.ts
var _c09 = ["detailsElm"];
var _c16 = ["componentElm"];
function OpportunityLedgerComponent_Conditional_10_div_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "header")(2, "h4");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "h5");
    \u0275\u0275text(5);
    \u0275\u0275pipe(6, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "div", 12);
    \u0275\u0275element(8, "p", 13);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const detail_r4 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(detail_r4.entry.type);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind2(6, 3, detail_r4.entry.timeStamp_Utc, "MMM dd, yyyy @ h:mm:ss a"));
    \u0275\u0275advance(3);
    \u0275\u0275property("innerHTML", detail_r4.detail, \u0275\u0275sanitizeHtml);
  }
}
function OpportunityLedgerComponent_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "cdk-virtual-scroll-viewport", 9);
    \u0275\u0275listener("scrolledIndexChange", function OpportunityLedgerComponent_Conditional_10_Template_cdk_virtual_scroll_viewport_scrolledIndexChange_0_listener($event) {
      \u0275\u0275restoreView(_r2);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.scrollCheck($event));
    });
    \u0275\u0275template(1, OpportunityLedgerComponent_Conditional_10_div_1_Template, 9, 6, "div", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("cdkVirtualForOf", ctx_r2.details)("cdkVirtualForTrackBy", ctx_r2.scrollTrack);
  }
}
function OpportunityLedgerComponent_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 8)(1, "p", 14);
    \u0275\u0275text(2, "No appointment history available.");
    \u0275\u0275elementEnd()();
  }
}
var _OpportunityLedgerComponent = class _OpportunityLedgerComponent {
  constructor(opportunityUiService, opportunityService, apiService, userService, orderByPipe) {
    this.opportunityUiService = opportunityUiService;
    this.opportunityService = opportunityService;
    this.apiService = apiService;
    this.userService = userService;
    this.orderByPipe = orderByPipe;
    this.users = [];
    this.details = [];
    this.retrievingLedger = false;
    this.syncingLatestLedger = false;
  }
  getUsers() {
    return this.userService.getRepipeUsers().pipe(map((users) => {
      this.users = users;
      return users;
    }));
  }
  scrollCheck(index) {
    window.clearTimeout(this.scrollTimeout);
    this.scrollTimeout = window.setTimeout(() => {
      if (index > this.details.length - 20) {
        this.syncLatestLedger();
      }
    }, 300);
  }
  scrollTrack(index, detail) {
    return detail.entry.id || index;
  }
  get hasDetails() {
    return this.details.length > 0;
  }
  syncLatestLedger(count = 30) {
    if (this.opportunity != null && !this.syncingLatestLedger) {
      this.syncingLatestLedger = true;
      const lastDetail = this.details[this.details.length - 1];
      let lastEntryId;
      if (lastDetail != null) {
        lastEntryId = lastDetail.entry.id;
      }
      this.opportunityService.syncLedgerEntries(this.opportunity, count, lastEntryId).subscribe({
        next: (entries) => {
          this.updateLedger(entries);
          this.syncingLatestLedger = false;
        },
        error: () => {
          this.syncingLatestLedger = false;
        }
      });
    }
  }
  getLedger() {
    if (!this.retrievingLedger && this.opportunity != null) {
      this.retrievingLedger = true;
      this.opportunityService.getLedgerEntries(this.opportunity.id).subscribe({
        next: (entries) => {
          this.updateLedger(entries);
          this.retrievingLedger = false;
          this.syncLatestLedger(30);
        },
        error: () => {
          this.retrievingLedger = false;
        }
      });
    }
  }
  updateLedger(entries) {
    entries = this.orderByPipe.transform(entries, "timeStamp_Utc");
    const newDetails = [];
    for (let i = 0, len = entries.length; i < len; i++) {
      const entry = entries[i];
      const user = this.users.find((x) => x.id === entry.userId);
      const detail = new LedgerDetail(entry, user);
      newDetails.push(detail);
    }
    this.details = [...this.details, ...newDetails];
    setTimeout(() => {
      if (this.detailsElm != null) {
        this.detailsElm.checkViewportSize();
      }
    }, 0);
  }
  initLedger() {
    const online = this.apiService.online.getValue();
    if (online) {
      this.getUsers().subscribe({
        next: () => {
          this.getLedger();
        }
      });
    } else {
      this.getLedger();
    }
  }
  closeView() {
    this.opportunityUiService.stopViewingLedger();
  }
  init() {
    this.initLedger();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_OpportunityLedgerComponent.\u0275fac = function OpportunityLedgerComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityLedgerComponent)(\u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(UserService), \u0275\u0275directiveInject(OrderByPipe));
};
_OpportunityLedgerComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunityLedgerComponent, selectors: [["opportunity-ledger"]], viewQuery: function OpportunityLedgerComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c09, 5);
    \u0275\u0275viewQuery(_c16, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.detailsElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe
])], decls: 12, vars: 1, consts: [["contentElm", ""], ["id", "ledger"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], ["itemSize", "100", 1, "details"], [1, "details"], ["itemSize", "100", 1, "details", 3, "scrolledIndexChange"], ["class", "detail", 4, "cdkVirtualFor", "cdkVirtualForOf", "cdkVirtualForTrackBy"], [1, "detail"], [1, "description"], [3, "innerHTML"], [1, "message"]], template: function OpportunityLedgerComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1)(1, "header")(2, "div", 2)(3, "h3");
    \u0275\u0275text(4, "Appointment Ledger");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 3)(6, "button", 4);
    \u0275\u0275listener("click", function OpportunityLedgerComponent_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275element(7, "i", 5);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 6, 0);
    \u0275\u0275conditionalCreate(10, OpportunityLedgerComponent_Conditional_10_Template, 2, 2, "cdk-virtual-scroll-viewport", 7)(11, OpportunityLedgerComponent_Conditional_11_Template, 3, 0, "div", 8);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(10);
    \u0275\u0275conditional(ctx.hasDetails ? 10 : 11);
  }
}, dependencies: [CdkFixedSizeVirtualScroll, CdkVirtualForOf, CdkVirtualScrollViewport, DatePipe], styles: ["\n\n#ledger[_ngcontent-%COMP%] {\n  position: relative;\n}\n#ledger[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#ledger[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#ledger[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#ledger[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  padding: 0 1vw;\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  height: 60vw;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%] {\n  height: 100px;\n  margin-top: 1vw;\n  padding-left: 1vw;\n  border-left: 0.2vw var(--color5) solid;\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%]     .user {\n  color: var(--color4Alt4);\n  font-weight: var(--stronger);\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%]     .user   img {\n  height: 3vw;\n  width: 3vw;\n  border-radius: 1vw;\n  margin-right: 0.5vw;\n  display: inline-block;\n  vertical-align: middle;\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%]    > strong[_ngcontent-%COMP%] {\n  font-weight: var(--stronger);\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]   .detail[_ngcontent-%COMP%]:last-child {\n  margin-bottom: 5vh;\n}\n#ledger[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  text-align: center;\n  font-size: 1.8vw;\n  font-weight: var(--mdweight);\n  color: var(--color1Alt2);\n}\n/*# sourceMappingURL=ledger.component.css.map */"] });
var OpportunityLedgerComponent = _OpportunityLedgerComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityLedgerComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-ledger", providers: [
      OrderByPipe
    ], template: `<section id="ledger">
    <header>
        <div class="primary">
            <h3>Appointment Ledger</h3>
        </div>
        <div class="controls">
            <button class="control" (click)="closeView()">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
    </header>
    <div class="content" #contentElm>
        @if (hasDetails) {
            <cdk-virtual-scroll-viewport itemSize="100" class="details" (scrolledIndexChange)="scrollCheck($event)">
                <div class="detail" *cdkVirtualFor="let detail of details, trackBy: scrollTrack">
                    <header>
                        <h4>{{detail.entry.type}}</h4>
                        <h5>{{detail.entry.timeStamp_Utc | date:'MMM dd, yyyy @ h:mm:ss a'}}</h5>
                    </header>
                    <div class="description">
                        <p [innerHTML]="detail.detail"></p>
                    </div>
                </div>
            </cdk-virtual-scroll-viewport>
        } @else {
            <div class="details">
                <p class="message">No appointment history available.</p>
            </div>
        }
    </div>
</section>`, styles: ["/* src/app/shared/opportunities/components/ledger/ledger.component.scss */\n#ledger {\n  position: relative;\n}\n#ledger > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#ledger > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#ledger > header > .controls > .control {\n  cursor: pointer;\n}\n#ledger > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#ledger > .content {\n  border-top: 0.1vw var(--color2Alt2) solid;\n  padding: 0 1vw;\n}\n#ledger > .content > .details {\n  height: 60vw;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#ledger > .content > .details .detail {\n  height: 100px;\n  margin-top: 1vw;\n  padding-left: 1vw;\n  border-left: 0.2vw var(--color5) solid;\n}\n#ledger > .content > .details .detail > header h4 {\n  font-size: 1.4vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#ledger > .content > .details .detail > header h5 {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#ledger > .content > .details .detail > .description {\n  margin-top: 0.5vw;\n}\n#ledger > .content > .details .detail > .description > p {\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n#ledger > .content > .details .detail > .description > p ::ng-deep .user {\n  color: var(--color4Alt4);\n  font-weight: var(--stronger);\n}\n#ledger > .content > .details .detail > .description > p ::ng-deep .user ::ng-deep img {\n  height: 3vw;\n  width: 3vw;\n  border-radius: 1vw;\n  margin-right: 0.5vw;\n  display: inline-block;\n  vertical-align: middle;\n}\n#ledger > .content > .details .detail > .description > p > strong {\n  font-weight: var(--stronger);\n}\n#ledger > .content > .details .detail:last-child {\n  margin-bottom: 5vh;\n}\n#ledger > .content > .details > .message {\n  text-align: center;\n  font-size: 1.8vw;\n  font-weight: var(--mdweight);\n  color: var(--color1Alt2);\n}\n/*# sourceMappingURL=ledger.component.css.map */\n"] }]
  }], () => [{ type: OpportunityUiService }, { type: OpportunityService }, { type: ApiService }, { type: UserService }, { type: OrderByPipe }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], detailsElm: [{
    type: ViewChild,
    args: ["detailsElm"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunityLedgerComponent, { className: "OpportunityLedgerComponent" });
})();
var LedgerDetail = class {
  constructor(entry, repipeUser) {
    this.entry = entry;
    this.timeStamp_Utc = new Date(entry.timeStamp_Utc);
    let user = entry.device;
    if (entry.userId != null) {
      user = `<span class='user'>User ${entry.userId}</span>`;
      if (repipeUser?.profileImage_B64 != null) {
        `<span class='user'><span class='avatar'><img src="${repipeUser.profileImage_B64}" /></span><span class='name'>${repipeUser.fullName}</span></span>`;
      } else if (repipeUser != null) {
        `<span class='user'><span class='name'>${repipeUser.fullName}</span></span>`;
      }
    }
    switch (entry.type) {
      case OpportunityLedgerEntryType.Acceptance:
        {
          this.detail = `${user} accepted the opportunity.`;
        }
        break;
      case OpportunityLedgerEntryType.Assignment:
        {
          this.detail = `${user} was assigned the opportunity.`;
        }
        break;
      case OpportunityLedgerEntryType.Status:
        {
          this.detail = `${user} changed the Status to <strong>${entry.body}</strong>`;
        }
        break;
      case OpportunityLedgerEntryType.Scheduling:
        {
          const scheduled_Utc = new Date(entry.body);
          this.detail = `Scheduled time was changed to ${scheduled_Utc}`;
        }
        break;
      case OpportunityLedgerEntryType.Job:
        {
          this.detail = `${user} modified the Job information.`;
        }
        break;
      case OpportunityLedgerEntryType.Property:
        {
          this.detail = `${user} modified the Property information.`;
        }
        break;
      case OpportunityLedgerEntryType.Shop:
        {
          this.detail = `${user} ${entry.subType} the Shop.`;
        }
        break;
      case OpportunityLedgerEntryType.InstallDate:
        {
          this.detail = `${user} ${entry.subType} the Install Date to <strong>${entry.body}</strong>.`;
        }
        break;
      case OpportunityLedgerEntryType.Fixture:
        {
          this.detail = `${user} ${entry.subType} a Fixture.`;
        }
        break;
      case OpportunityLedgerEntryType.FixturePhoto:
        {
          this.detail = `${user} ${entry.subType} a Photo on a Fixture.`;
        }
        break;
      case OpportunityLedgerEntryType.Entity:
        {
          this.detail = `${user} ${entry.subType} an Entity.`;
        }
        break;
      case OpportunityLedgerEntryType.EntityPhoto:
        {
          const body = entry.body;
          this.detail = `${user} ${entry.subType} a Photo on ${body.entityName}.`;
        }
        break;
      case OpportunityLedgerEntryType.EntityAttribute:
        {
          const body = entry.body;
          this.detail = `${user} changed <strong>${body.attributeName}</strong> on ${body.entityName} to <strong>${body.values}</strong>.`;
        }
        break;
      case OpportunityLedgerEntryType.EntityRender:
        {
          const body = entry.body;
          this.detail = `${user} rendered a diagram for ${body.entityName}`;
        }
        break;
      case OpportunityLedgerEntryType.EntityRenderDimensions:
        {
          const body = entry.body;
          this.detail = `${user} moved ${body.entityName} on the diagram.`;
        }
        break;
      case OpportunityLedgerEntryType.EntityNote:
        {
          const body = entry.body;
          this.detail = `${user} updated the ${body.key} note on ${body.entityName}.`;
        }
        break;
      case OpportunityLedgerEntryType.CustomerNeed:
        {
          const body = entry.body;
          this.detail = `${user} changed the answer for <strong>${body.key}</strong> to <strong>${body.value}</strong>`;
        }
        break;
      case OpportunityLedgerEntryType.PaymentSetting:
        {
          this.detail = `${user} ${entry.subType} the Payment Setting.`;
        }
        break;
      case OpportunityLedgerEntryType.Lender:
        {
          this.detail = `${user} ${entry.subType} a Lender.`;
        }
        break;
      case OpportunityLedgerEntryType.Payment:
        {
          this.detail = `${user} ${entry.subType} a Payment.`;
        }
        break;
      case OpportunityLedgerEntryType.Price:
        {
          this.detail = `${user} calculated a new Price.`;
        }
        break;
      case OpportunityLedgerEntryType.CustomPrice:
        {
          this.detail = `${user} negotiated a new Custom Price.`;
        }
        break;
      case OpportunityLedgerEntryType.Disposition:
        {
          this.detail = `${user} ${entry.subType} a Disposition Status.`;
        }
        break;
      case OpportunityLedgerEntryType.Documents:
        {
          this.detail = `${user} generated new Documents.`;
        }
        break;
      case OpportunityLedgerEntryType.Signer:
        {
          const body = entry.body;
          this.detail = `<strong>${body.fullName}</strong> consented to sign electronically.`;
        }
        break;
      case OpportunityLedgerEntryType.Signature:
        {
          if (entry.subType == OpportunityLedgerEntrySubType.Removed) {
            const body = entry.body;
            this.detail = `${user} removed a signature for ${body.signerName} on ${body.documentName}.`;
          } else {
            const body = entry.body;
            this.detail = `<strong>${body.signature.signerName}</strong> signed on Document <strong>${body.documentName}</strong>.`;
          }
        }
        break;
      case OpportunityLedgerEntryType.RouteChange:
        {
          this.detail = `${user} viewed the <strong>${entry.body}</strong> screen on the Appointment.`;
        }
        break;
      case OpportunityLedgerEntryType.EstimateSubmitted:
        {
          this.detail = `<strong>${entry.device}</strong> submitted an estimate with <strong>ID ${entry.body}</strong> to NetSuite.`;
        }
        break;
      default: {
        this.detail = ``;
      }
    }
  }
};

// src/app/shared/opportunities/opportunity.module.ts
var _SharedOpportunityModule = class _SharedOpportunityModule {
};
_SharedOpportunityModule.\u0275fac = function SharedOpportunityModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SharedOpportunityModule)();
};
_SharedOpportunityModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _SharedOpportunityModule });
_SharedOpportunityModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [
  CommonModule,
  RouterModule,
  SharedDocumentsModule,
  ReactiveFormsModule,
  UiModule,
  FormsModule,
  ScrollingModule
] });
var SharedOpportunityModule = _SharedOpportunityModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SharedOpportunityModule, [{
    type: NgModule,
    args: [{
      declarations: [
        EstimateSubmissionComponent,
        OpportunitySigningComponent,
        OpportunitySummaryComponent,
        OpportunityPaymentsComponent,
        SendDocumentsForSigningComponent,
        SendQuoteComponent,
        SendExecutedDocumentsComponent,
        OpportunityDetailsComponent,
        OpportunityLedgerComponent
      ],
      imports: [
        CommonModule,
        RouterModule,
        SharedDocumentsModule,
        ReactiveFormsModule,
        UiModule,
        FormsModule,
        ScrollingModule
      ],
      /* Do not put any services in the Shared Module which need to share an instance across multiple modules
          Those should go in the app.module instead */
      providers: [],
      exports: [
        EstimateSubmissionComponent,
        OpportunitySigningComponent,
        OpportunitySummaryComponent,
        OpportunityPaymentsComponent,
        SendDocumentsForSigningComponent,
        SendQuoteComponent,
        SendExecutedDocumentsComponent,
        OpportunityDetailsComponent,
        OpportunityLedgerComponent
      ],
      schemas: [CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

export {
  PaymentsService,
  EstimateSubmissionComponent,
  OpportunitySigningComponent,
  LenderApplicationStatus,
  OpportunityPaymentsComponent,
  GeneralResponseState,
  SendDocumentsForSigningComponent,
  SendQuoteComponent,
  SendExecutedDocumentsComponent,
  OpportunityDetailsComponent,
  UserService,
  OpportunityLedgerComponent,
  OpportunitySummaryComponent,
  SharedOpportunityModule
};
//# sourceMappingURL=chunk-GIEGNZQH.js.map
