import {
  SideNavService
} from "./chunk-MG4UNSAD.js";
import {
  AppointmentRouteType,
  LocalAppointmentService
} from "./chunk-Y3KLEZGS.js";
import {
  PresentationContentType,
  PresentationService
} from "./chunk-HKPPSG2L.js";
import {
  require_leaflet_src
} from "./chunk-ZIGK756M.js";
import {
  AppointmentUiService
} from "./chunk-JUJBVXIJ.js";
import {
  Draggable,
  gsapWithCSS
} from "./chunk-DZY2UUHE.js";
import {
  DeviceRouteService,
  ReminderPriority,
  ReminderReferenceType,
  ReminderService
} from "./chunk-ZEKYPX2O.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  AppointmentService
} from "./chunk-APCDHWBD.js";
import {
  ContactInformationType
} from "./chunk-HJJU6GQE.js";
import "./chunk-NX4GNOJ2.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  ContentService
} from "./chunk-GYQ34QPN.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import {
  ApiService
} from "./chunk-XNCHXMYV.js";
import {
  AuthRefService
} from "./chunk-M3LFBN7N.js";
import {
  AppointmentStatus,
  PropertyEntityType
} from "./chunk-N36JE2BE.js";
import "./chunk-IDX2GQCZ.js";
import {
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  CurrencyInputComponent,
  DatePipe,
  DefaultValueAccessor,
  DomSanitizer,
  FormsModule,
  Injector,
  Input,
  LoaderComponent,
  MaxLengthValidator,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  NumberValueAccessor,
  ReactiveFormsModule,
  Router,
  SelectControlValueAccessor,
  Subject,
  UiModule,
  ViewChild,
  createNgModule,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind2,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵreference,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeUrl,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtextInterpolate2,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-IT26RCSL.js";
import {
  __async,
  __toESM
} from "./chunk-RVA4KI76.js";

// src/app/appointment/components/summary/summary.component.ts
var import_leaflet = __toESM(require_leaflet_src());
var _c0 = ["componentElm"];
function SummaryComponent_For_24_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 12);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const type_r2 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", type_r2, " ");
  }
}
function SummaryComponent_Conditional_25_For_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 12);
    \u0275\u0275text(1);
    \u0275\u0275elementStart(2, "span", 31);
    \u0275\u0275text(3, ", ");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const issue_r3 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", issue_r3);
  }
}
function SummaryComponent_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13)(1, "header")(2, "h3");
    \u0275\u0275text(3, "Plumbing Issues");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "div", 30);
    \u0275\u0275repeaterCreate(5, SummaryComponent_Conditional_25_For_6_Template, 4, 1, "span", 12, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(5);
    \u0275\u0275repeater(ctx_r3.appointment == null ? null : ctx_r3.appointment.opportunityPlumbingIssues);
  }
}
function SummaryComponent_For_50_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const type_r5 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", type_r5, " ");
  }
}
function SummaryComponent_Conditional_51_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 22)(1, "h4");
    \u0275\u0275text(2, "Notes");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", ctx_r3.appointment == null ? null : ctx_r3.appointment.opportunityNotes, " ");
  }
}
function SummaryComponent_Conditional_53_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 24)(1, "div", 7)(2, "h3");
    \u0275\u0275text(3, "Appointment Canceled");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "p");
    \u0275\u0275text(5);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1("Reason: ", ctx_r3.appointment == null ? null : ctx_r3.appointment.statusDescription);
  }
}
function SummaryComponent_Conditional_63_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "nav", 28)(1, "div", 32)(2, "div", 25)(3, "button", 33);
    \u0275\u0275listener("click", function SummaryComponent_Conditional_63_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.goForward());
    });
    \u0275\u0275element(4, "i", 34);
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Continue to Check-In");
    \u0275\u0275elementEnd()()()()();
  }
}
function SummaryComponent_Conditional_64_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 29)(1, "h3");
    \u0275\u0275text(2, "Tip: Ready to check in?");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4, ' Tap "Continue to Check-In" to proceed with the appointment ');
    \u0275\u0275elementEnd()();
  }
}
var _SummaryComponent = class _SummaryComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.requestingDirections = false;
    this.directionsCooldown = false;
    this.AppointmentStatus = AppointmentStatus;
  }
  // #region Authentication
  get activeUser() {
    return this.localAppointmentService.activeUser;
  }
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  // #endregion
  // #region Contact
  get email() {
    const contactInfo = this.appointment?.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Email) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasEmail() {
    return this.email != null;
  }
  get phone() {
    const contactInfo = this.appointment?.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Phone) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasPhone() {
    return this.email != null;
  }
  get canGetDirections() {
    return this.activeUser != null && !this.requestingDirections && !this.directionsCooldown && this.activeUser.phone != null;
  }
  cooldownDirections() {
    this.directionsCooldown = true;
    setTimeout(() => {
      this.directionsCooldown = false;
    }, 1e4);
  }
  getDirections() {
    return __async(this, null, function* () {
      if (this.address != null) {
        const directions = this.appointmentService.getDirections(this.address);
        window.open(directions, "_blank")?.focus();
      }
      return void 0;
    });
  }
  sendDirections() {
    if (this.appointment != null && this.activeUser != null && !this.requestingDirections) {
      this.requestingDirections = true;
      this.appointmentService.sendDirections(this.appointment.id, this.activeUser.phone).subscribe({
        next: () => {
          this.uiService.prompt("Directions Sent", "A link for directions to the appointment has been texted to your phone.", "Okay").subscribe({
            next: () => {
              this.cooldownDirections();
              this.requestingDirections = false;
            }
          });
        },
        error: () => {
          this.requestingDirections = false;
        }
      });
    }
  }
  get mapLink() {
    return `https://www.google.com/maps/dir/?api=1&destination=${this.mappingAddress}`;
  }
  get property() {
    return this.appointment?.property;
  }
  get friendlyStoriesLabel() {
    if (this.property != null) {
      return this.property.listedStories == 1 ? "story" : "stories";
    }
    return "";
  }
  get address() {
    return this.property?.address;
  }
  get friendlyAddress() {
    return this.appointment?.property?.address?.friendlyAddress;
  }
  get mappingAddress() {
    return this.appointment?.property?.address?.mappingAddress;
  }
  initMap() {
    if (this.mappingAddress != null) {
      this.map = new import_leaflet.Map("map", {
        zoomControl: false,
        attributionControl: false,
        dragging: false
      }).setView([37.7749, -122.4194], 13);
      (0, import_leaflet.tileLayer)("https://{s}.basemaps.cartocdn.com/rastertiles/voyager/{z}/{x}/{y}{r}.png", {
        subdomains: "abcd",
        maxZoom: 19
      }).addTo(this.map);
      this.mapAddress(this.mappingAddress);
    }
  }
  mapAddress(address) {
    this.appointmentService.getCoordinatesForAddress(address).subscribe({
      next: (coords) => {
        if (this.map != null) {
          const coordinates = new import_leaflet.LatLng(coords.lat, coords.lon);
          this.map.setView(coordinates, 15);
          (0, import_leaflet.marker)(coordinates, {
            icon: (0, import_leaflet.icon)({
              iconSize: [25, 41],
              iconAnchor: [13, 41],
              iconUrl: "assets/images/maps/marker.svg"
            })
          }).bindPopup(`<b>${address}</b>`).addTo(this.map);
        }
      }
    });
  }
  // #endregion
  // #region Notes
  get hasNotes() {
    return this.appointment?.opportunityNotes != null && this.appointment.opportunityNotes.length > 0;
  }
  // #endregion
  // #region Navigation
  get showMainNav() {
    return this.canModifyAppointment;
  }
  goForward() {
    if (this.appointment?.customer != null) {
      const appointment = this.appointment;
      const customerName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
      this.uiService.prompt(`Check In for ${customerName}`, `Are you sure you want to check-in to the appointment for ${customerName}?`, "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.localAppointmentService.completeSummary(appointment);
          }
        }
      });
    }
  }
  reopenAppointment() {
    if (this.appointment != null && this.appointment.status != AppointmentStatus.PendingSubmission && this.appointment.status != AppointmentStatus.Submitted) {
      this.uiService.prompt("Reopen the Appointment?", "Reopening the appointment will make it possible to change or add any of its information. Are you sure you want to re-open it?", "Yes", "No, Cancel").subscribe({
        next: (confirmed) => {
          if (confirmed && this.appointment != null) {
            this.appointment.status = AppointmentStatus.InProgress;
            this.appointment.statusDescription = "";
            this.appointment.dispositionStatus = void 0;
            this.appointment.changed$.next();
          }
        }
      });
    }
  }
  init() {
    this.initMap();
    if (this.appointment != null) {
      this.appointment.changed$.next();
    }
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_SummaryComponent.\u0275fac = function SummaryComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SummaryComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_SummaryComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SummaryComponent, selectors: [["summary"]], viewQuery: function SummaryComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 65, vars: 25, consts: [["mapElm", ""], ["id", "summary"], [1, "map"], ["id", "map"], [1, "accent"], [1, "content"], [1, "info"], [1, "meta"], [1, "name"], [1, "address"], [1, "properties"], [1, "item", "type"], [1, "value"], [1, "meta", "issues"], [1, "property-details"], [1, "detail"], [1, "fa-duotone", "fa-thin", "fa-house"], [1, "fa-duotone", "fa-thin", "fa-hammer"], [1, "fa-duotone", "fa-thin", "fa-ruler-triangle"], [1, "fa-duotone", "fa-thin", "fa-bath"], [1, "fa-duotone", "fa-thin", "fa-stairs"], [1, "fa-duotone", "fa-thin", "fa-pipe-valve"], [1, "notes"], [1, "secondary"], [1, "canceled"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-map-location-dot"], ["id", "mainNav"], [1, "tooltip", "checkin", "active"], [1, "values"], [1, "delineator"], [1, "island"], [1, "control", "success", 3, "click"], [1, "fa-solid", "fa-arrow-right-long"]], template: function SummaryComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1)(1, "div", 2, 0);
    \u0275\u0275element(3, "div", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275element(4, "div", 4);
    \u0275\u0275elementStart(5, "div", 5)(6, "div", 6)(7, "header")(8, "div", 7)(9, "h3");
    \u0275\u0275text(10);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(11, "h2");
    \u0275\u0275text(12);
    \u0275\u0275pipe(13, "date");
    \u0275\u0275pipe(14, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(15, "div", 8)(16, "h1");
    \u0275\u0275text(17);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 9)(19, "h3");
    \u0275\u0275text(20);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(21, "div", 10)(22, "div", 11);
    \u0275\u0275repeaterCreate(23, SummaryComponent_For_24_Template, 2, 1, "span", 12, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(25, SummaryComponent_Conditional_25_Template, 7, 0, "div", 13);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "div", 14)(27, "div", 15);
    \u0275\u0275element(28, "i", 16);
    \u0275\u0275elementStart(29, "label");
    \u0275\u0275text(30);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(31, "div", 15);
    \u0275\u0275element(32, "i", 17);
    \u0275\u0275elementStart(33, "label");
    \u0275\u0275text(34);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(35, "div", 15);
    \u0275\u0275element(36, "i", 18);
    \u0275\u0275elementStart(37, "label");
    \u0275\u0275text(38);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(39, "div", 15);
    \u0275\u0275element(40, "i", 19);
    \u0275\u0275elementStart(41, "label");
    \u0275\u0275text(42);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(43, "div", 15);
    \u0275\u0275element(44, "i", 20);
    \u0275\u0275elementStart(45, "label");
    \u0275\u0275text(46);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(47, "div", 15);
    \u0275\u0275element(48, "i", 21);
    \u0275\u0275repeaterCreate(49, SummaryComponent_For_50_Template, 2, 1, "label", null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(51, SummaryComponent_Conditional_51_Template, 5, 1, "div", 22);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(52, "div", 23);
    \u0275\u0275conditionalCreate(53, SummaryComponent_Conditional_53_Template, 6, 1, "div", 24);
    \u0275\u0275elementStart(54, "div", 25)(55, "button", 26);
    \u0275\u0275listener("click", function SummaryComponent_Template_button_click_55_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.getDirections());
    });
    \u0275\u0275element(56, "i", 27);
    \u0275\u0275elementStart(57, "label");
    \u0275\u0275text(58, "Get Directions");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(59, "button", 26);
    \u0275\u0275listener("click", function SummaryComponent_Template_button_click_59_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.sendDirections());
    });
    \u0275\u0275element(60, "i", 27);
    \u0275\u0275elementStart(61, "label");
    \u0275\u0275text(62, "Text Me Directions");
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275conditionalCreate(63, SummaryComponent_Conditional_63_Template, 7, 0, "nav", 28);
    \u0275\u0275conditionalCreate(64, SummaryComponent_Conditional_64_Template, 5, 0, "div", 29);
  }
  if (rf & 2) {
    \u0275\u0275advance(10);
    \u0275\u0275textInterpolate1(" Job ID: ", ctx.appointment == null ? null : ctx.appointment.jobId, " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate2(" ", \u0275\u0275pipeBind2(13, 19, ctx.appointment == null ? null : ctx.appointment.scheduled_Utc, "EEE, MMM d, yyyy"), " at ", \u0275\u0275pipeBind2(14, 22, ctx.appointment == null ? null : ctx.appointment.scheduled_Utc, "h:mm a"), " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate2(" ", ctx.appointment == null ? null : ctx.appointment.customer == null ? null : ctx.appointment.customer.firstName, " ", ctx.appointment == null ? null : ctx.appointment.customer == null ? null : ctx.appointment.customer.lastName, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", ctx.friendlyAddress, " ");
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx.appointment == null ? null : ctx.appointment.opportunityTypes);
    \u0275\u0275advance(2);
    \u0275\u0275conditional((ctx.appointment == null ? null : ctx.appointment.hasPlumbingIssues) ? 25 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", ctx.property == null ? null : ctx.property.type, " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" Built in ", ctx.property == null ? null : ctx.property.yearBuilt, " ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", ctx.property == null ? null : ctx.property.listedSquareDimensions, " sq. ft. ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", ctx.property == null ? null : ctx.property.listedBathrooms, " bathrooms ");
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate2(" ", ctx.property == null ? null : ctx.property.listedStories, " ", ctx.friendlyStoriesLabel, " ");
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx.property == null ? null : ctx.property.existingPipeTypes);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.hasNotes ? 51 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional((ctx.appointment == null ? null : ctx.appointment.status) == ctx.AppointmentStatus.Canceled ? 53 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canGetDirections);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx.canGetDirections);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx.showMainNav ? 63 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canModifyAppointment ? 64 : -1);
  }
}, dependencies: [DatePipe], styles: ["\n\n.tooltip[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */", "\n\n#summary[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#summary[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 50%;\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  z-index: 0;\n}\n#summary[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%]   #map[_ngcontent-%COMP%] {\n  height: 100%;\n  position: relative;\n  z-index: 0;\n}\n#summary[_ngcontent-%COMP%]    > .accent[_ngcontent-%COMP%] {\n  position: absolute;\n  top: auto;\n  left: 15%;\n  right: 15%;\n  bottom: 50vh;\n  height: 10vw;\n  z-index: 1;\n  background-color: var(--color2Alt1);\n  border-top-left-radius: 1vw;\n  border-top-right-radius: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-bottom: none;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: auto;\n  left: 15%;\n  right: 15%;\n  bottom: 0;\n  height: calc(50vh + 10vw);\n  z-index: 1;\n  padding: 2vw;\n  overflow-x: hidden;\n  display: flex;\n  align-items: flex-start;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  color: var(--color1);\n  font-size: 1.8vw;\n  font-weight: var(--strong);\n  line-height: 0.9;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .address[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .address[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%] {\n  display: inline-block;\n  border-radius: 0.5vw;\n  padding: 0.4vw 1vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .item.type[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.1);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .values[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .values[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  position: relative;\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .properties[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .values[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]:last-child    > .delineator[_ngcontent-%COMP%] {\n  display: none;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .property-details[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  align-items: flex-start;\n  flex-wrap: wrap;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .property-details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  width: calc(50% - 1vw);\n  margin-left: 1vw;\n  margin-top: 1vw;\n  background-color: var(--color2Alt2);\n  padding: 0.5vw 1vw;\n  border-radius: 999px;\n  padding: 1vw;\n  display: flex;\n  align-items: ceter;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .property-details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .property-details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .property-details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:nth-of-type(odd) {\n  margin-left: 0;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .property-details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:nth-of-type(-n+2) {\n  margin-top: 0;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt3) solid;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  font-weight: var(--stdweight);\n  color: var(--color1Alt1);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  width: 35%;\n  margin-left: 2vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%] {\n  background-color: rgba(var(--error-raw), 0.1);\n  padding: 1vw;\n  border-radius: 0.5vw;\n  border: var(--error) 0.1vw solid;\n  margin-bottom: 2vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border-radius: 999px;\n  background-color: var(--color2);\n  border: 0.1vw var(--success) solid;\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 0.5vw 1vw;\n  cursor: pointer;\n  text-decoration: none;\n  -moz-transition: background-color 0.1s;\n  -o-transition: background-color 0.1s;\n  -webkit-transition: background-color 0.1s;\n  transition: background-color 0.1s;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--success);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  font-size: 1.4vw;\n  color: var(--success);\n  font-weight: var(--strong);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color2Alt2);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border-radius: 999px;\n  background-color: var(--color2);\n  border: 0.1vw var(--color3) solid;\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 0.5vw 1vw;\n  cursor: pointer;\n  text-decoration: none;\n  -moz-transition: background-color 0.1s;\n  -o-transition: background-color 0.1s;\n  -webkit-transition: background-color 0.1s;\n  transition: background-color 0.1s;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color2Alt2);\n}\n#summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n.tooltip.directions[_ngcontent-%COMP%] {\n  top: 34vw;\n  right: 16vw;\n}\n.tooltip.directions.adjust[_ngcontent-%COMP%] {\n  top: 46vw;\n}\n.tooltip.checkin[_ngcontent-%COMP%] {\n  bottom: 6vw;\n  right: 2vw;\n}\n/*# sourceMappingURL=summary.component.css.map */"] });
var SummaryComponent = _SummaryComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SummaryComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "summary", template: `<section id="summary">
  <div class="map" #mapElm>
    <div id="map"></div>
  </div>

  <div class="accent"></div>

  <div class="content">
    <div class="info">
      <header>
        <div class="meta">
          <h3>
            Job ID: {{appointment?.jobId}}
          </h3>
          <h2>
            {{appointment?.scheduled_Utc | date:'EEE, MMM d, yyyy'}}
            at {{appointment?.scheduled_Utc | date:'h:mm a'}}
          </h2>
        </div>
        <div class="name">
          <h1>
            {{appointment?.customer?.firstName}} {{appointment?.customer?.lastName}}
          </h1>
        </div>
        <div class="address">
          <h3>
            {{friendlyAddress}}
          </h3>
        </div>
      </header>
      <div class="properties">
        <div class="item type">
          @for (type of appointment?.opportunityTypes; track type) {
            <span class="value">
              {{type}}
            </span>
          }
        </div>
        @if (appointment?.hasPlumbingIssues) {
          <div class="meta issues">
            <header>
              <h3>Plumbing Issues</h3>
            </header>
            <div class="values">
              @for (issue of appointment?.opportunityPlumbingIssues; track issue) {
                <span class="value">
                  {{issue}}<span class="delineator">, </span>
                </span>
              }
            </div>
          </div>
        }
      </div>
      <div class="property-details">
        <div class="detail">
          <i class="fa-duotone fa-thin fa-house"></i>
          <label>
            {{property?.type}}
          </label>
        </div>
        <div class="detail">
          <i class="fa-duotone fa-thin fa-hammer"></i>
          <label>
            Built in {{property?.yearBuilt}}
          </label>
        </div>
        <div class="detail">
          <i class="fa-duotone fa-thin fa-ruler-triangle"></i>
          <label>
            {{property?.listedSquareDimensions}} sq. ft.
          </label>
        </div>
        <div class="detail">
          <i class="fa-duotone fa-thin fa-bath"></i>
          <label>
            {{property?.listedBathrooms}} bathrooms
          </label>
        </div>
        <div class="detail">
          <i class="fa-duotone fa-thin fa-stairs"></i>
          <label>
            {{property?.listedStories}} {{friendlyStoriesLabel}}
          </label>
        </div>
        <div class="detail">
          <i class="fa-duotone fa-thin fa-pipe-valve"></i>
          @for (type of property?.existingPipeTypes; track type) {
            <label>
              {{type}}
            </label>
          }
        </div>
      </div>
      @if (hasNotes) {
        <div class="notes">
          <h4>Notes</h4>
          <p>
            {{appointment?.opportunityNotes}}
          </p>
        </div>
      }
    </div>
    <div class="secondary">
      @if (appointment?.status == AppointmentStatus.Canceled) {
        <div class="canceled">
          <div class="meta">
            <h3>Appointment Canceled</h3>
            <p>Reason: {{appointment?.statusDescription}}</p>
          </div>
        </div>
      }
      <div class="controls">
        <button class="control" [disabled]="!canGetDirections" (click)="getDirections()">
          <i class="fa-solid fa-map-location-dot"></i>
          <label>Get Directions</label>
        </button>
        <button class="control" [disabled]="!canGetDirections" (click)="sendDirections()">
          <i class="fa-solid fa-map-location-dot"></i>
          <label>Text Me Directions</label>
        </button>
      </div>
    </div>
  </div>
</section>

@if (showMainNav) {
  <nav id="mainNav">
    <div class="island">
      <div class="controls">
        <button class="control success" (click)="goForward()">
          <i class="fa-solid fa-arrow-right-long"></i>
          <label>Continue to Check-In</label>
        </button>
      </div>
    </div>
  </nav>
}

@if (canModifyAppointment) {
  <div class="tooltip checkin active">
    <h3>Tip: Ready to check in?</h3>
    <p>
      Tap "Continue to Check-In" to proceed with the appointment
    </p>
  </div>
}`, styles: ["/* src/app/shared/ui/components/tooltips/tooltips.component.scss */\n.tooltip {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip > .control {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip > h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip > p {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip > .controls {\n  margin-top: 0.5vw;\n}\n.tooltip > .controls > .control {\n  cursor: pointer;\n  display: block;\n}\n.tooltip > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */\n", "/* src/app/appointment/components/summary/summary.component.scss */\n#summary {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#summary > .map {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 50%;\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  z-index: 0;\n}\n#summary > .map #map {\n  height: 100%;\n  position: relative;\n  z-index: 0;\n}\n#summary > .accent {\n  position: absolute;\n  top: auto;\n  left: 15%;\n  right: 15%;\n  bottom: 50vh;\n  height: 10vw;\n  z-index: 1;\n  background-color: var(--color2Alt1);\n  border-top-left-radius: 1vw;\n  border-top-right-radius: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-bottom: none;\n}\n#summary > .content {\n  position: absolute;\n  top: auto;\n  left: 15%;\n  right: 15%;\n  bottom: 0;\n  height: calc(50vh + 10vw);\n  z-index: 1;\n  padding: 2vw;\n  overflow-x: hidden;\n  display: flex;\n  align-items: flex-start;\n}\n#summary > .content > .info {\n  flex: 1;\n  width: 100%;\n}\n#summary > .content > .info > header > .meta h3 {\n  font-size: 1vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#summary > .content > .info > header > .meta h2 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#summary > .content > .info > header > .name {\n  margin-top: 0.25vw;\n}\n#summary > .content > .info > header > .name h1 {\n  color: var(--color1);\n  font-size: 1.8vw;\n  font-weight: var(--strong);\n  line-height: 0.9;\n}\n#summary > .content > .info > header > .address {\n  margin-top: 0.5vw;\n}\n#summary > .content > .info > header > .address h3 {\n  font-size: 1.3vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n}\n#summary > .content > .info > .properties {\n  margin-top: 1vw;\n}\n#summary > .content > .info > .properties > .item {\n  display: inline-block;\n  border-radius: 0.5vw;\n  padding: 0.4vw 1vw;\n}\n#summary > .content > .info > .properties > .item.type {\n  background-color: rgba(var(--color3-raw), 0.1);\n}\n#summary > .content > .info > .properties > .item > .value {\n  font-size: 1vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#summary > .content > .info > .properties > .meta {\n  margin-top: 1vw;\n}\n#summary > .content > .info > .properties > .meta > header h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#summary > .content > .info > .properties > .meta > .values {\n  margin-top: 0.5vw;\n}\n#summary > .content > .info > .properties > .meta > .values > .value {\n  position: relative;\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#summary > .content > .info > .properties > .meta > .values > .value:last-child > .delineator {\n  display: none;\n}\n#summary > .content > .info > .property-details {\n  margin-top: 2vw;\n  display: flex;\n  align-items: flex-start;\n  flex-wrap: wrap;\n}\n#summary > .content > .info > .property-details > .detail {\n  width: calc(50% - 1vw);\n  margin-left: 1vw;\n  margin-top: 1vw;\n  background-color: var(--color2Alt2);\n  padding: 0.5vw 1vw;\n  border-radius: 999px;\n  padding: 1vw;\n  display: flex;\n  align-items: ceter;\n}\n#summary > .content > .info > .property-details > .detail i {\n  font-size: 1.6vw;\n}\n#summary > .content > .info > .property-details > .detail label {\n  margin-left: 1vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#summary > .content > .info > .property-details > .detail:nth-of-type(odd) {\n  margin-left: 0;\n}\n#summary > .content > .info > .property-details > .detail:nth-of-type(-n+2) {\n  margin-top: 0;\n}\n#summary > .content > .info > .notes {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt3) solid;\n}\n#summary > .content > .info > .notes h4 {\n  font-size: 1.3vw;\n  font-weight: var(--stdweight);\n  color: var(--color1Alt1);\n}\n#summary > .content > .info > .notes p {\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n}\n#summary > .content > .secondary {\n  width: 35%;\n  margin-left: 2vw;\n}\n#summary > .content > .secondary > .canceled {\n  background-color: rgba(var(--error-raw), 0.1);\n  padding: 1vw;\n  border-radius: 0.5vw;\n  border: var(--error) 0.1vw solid;\n  margin-bottom: 2vw;\n}\n#summary > .content > .secondary > .canceled > .meta h3 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#summary > .content > .secondary > .canceled > .meta p {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#summary > .content > .secondary > .canceled > .controls {\n  margin-top: 1vw;\n}\n#summary > .content > .secondary > .canceled > .controls > .control {\n  display: block;\n  width: 100%;\n  border-radius: 999px;\n  background-color: var(--color2);\n  border: 0.1vw var(--success) solid;\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 0.5vw 1vw;\n  cursor: pointer;\n  text-decoration: none;\n  -moz-transition: background-color 0.1s;\n  -o-transition: background-color 0.1s;\n  -webkit-transition: background-color 0.1s;\n  transition: background-color 0.1s;\n}\n#summary > .content > .secondary > .canceled > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--success);\n}\n#summary > .content > .secondary > .canceled > .controls > .control > label {\n  margin-left: 0.5vw;\n  font-size: 1.4vw;\n  color: var(--success);\n  font-weight: var(--strong);\n}\n#summary > .content > .secondary > .canceled > .controls > .control:first-child {\n  margin-top: 0;\n}\n#summary > .content > .secondary > .canceled > .controls > .control:active {\n  background-color: var(--color2Alt2);\n}\n#summary > .content > .secondary > .controls > .control {\n  display: block;\n  width: 100%;\n  border-radius: 999px;\n  background-color: var(--color2);\n  border: 0.1vw var(--color3) solid;\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: 0.5vw 1vw;\n  cursor: pointer;\n  text-decoration: none;\n  -moz-transition: background-color 0.1s;\n  -o-transition: background-color 0.1s;\n  -webkit-transition: background-color 0.1s;\n  transition: background-color 0.1s;\n}\n#summary > .content > .secondary > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color3);\n}\n#summary > .content > .secondary > .controls > .control > label {\n  margin-left: 0.5vw;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#summary > .content > .secondary > .controls > .control:first-child {\n  margin-top: 0;\n}\n#summary > .content > .secondary > .controls > .control:active {\n  background-color: var(--color2Alt2);\n}\n#summary > .content > .secondary > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n.tooltip.directions {\n  top: 34vw;\n  right: 16vw;\n}\n.tooltip.directions.adjust {\n  top: 46vw;\n}\n.tooltip.checkin {\n  bottom: 6vw;\n  right: 2vw;\n}\n/*# sourceMappingURL=summary.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SummaryComponent, { className: "SummaryComponent" });
})();

// src/app/appointment/components/check-in/check-in.component.ts
var _c02 = ["fileInputElm"];
var _c1 = ["renderCanvasElm"];
var _c2 = ["componentElm"];
var _CheckInComponent = class _CheckInComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.rendering = false;
    this.renderWidth = 1600;
    this.renderHeight = 1200;
    this.acceptFileTypes = "*.jpg,*.png,*.webp";
    this.acceptMimeTypes = ["image/jpeg", "image/jpg", "image/png", "image/webp"];
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  selectMedia() {
    const fileInputElm = this.fileInputElm?.nativeElement;
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  setFile(deviceBlob) {
    if (deviceBlob != null && this.matchesMimeType(deviceBlob.type)) {
      this.mimeType = deviceBlob.type;
      this.workingFile = deviceBlob;
      this.renderImage();
    }
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.setFile(file);
    } else {
      this.setFile(void 0);
    }
  }
  matchesMimeType(mimeType) {
    let i = this.acceptMimeTypes.length;
    while (i--) {
      const acceptMimeType = this.acceptMimeTypes[i];
      if (acceptMimeType == mimeType) {
        return true;
      }
    }
    return false;
  }
  exportImage(canvas) {
    return canvas.toDataURL("image/jpeg", 0.6);
  }
  renderExistingImage() {
    const photoSrc = this.appointment?.property?.photo?.src ?? this.appointment?.property?.photo_B64;
    if (photoSrc != null) {
      const srcImage = new Image();
      srcImage.onload = () => {
        this.renderWidth = srcImage.width;
        this.renderHeight = srcImage.height;
        const canvas = this.renderCanvasElm?.nativeElement;
        const ctx = canvas.getContext("2d", { willReadFrequently: true, alpha: true });
        setTimeout(() => {
          if (ctx != null) {
            ctx.drawImage(srcImage, 0, 0, this.renderWidth, this.renderHeight);
            this.rendering = true;
          }
        }, 0);
      };
      srcImage.src = photoSrc;
    }
  }
  renderImage() {
    setTimeout(() => {
      if (this.workingFile != null) {
        const url = URL.createObjectURL(this.workingFile);
        const srcImage = new Image();
        srcImage.onload = () => {
          URL.revokeObjectURL(url);
          const ratio = srcImage.width / 1024;
          this.renderWidth = ratio > 1 ? srcImage.width / ratio : srcImage.width;
          this.renderHeight = ratio > 1 ? srcImage.height / ratio : srcImage.height;
          const canvas = this.renderCanvasElm?.nativeElement;
          const ctx = canvas.getContext("2d", { willReadFrequently: true, alpha: true });
          setTimeout(() => {
            if (ctx != null) {
              ctx.drawImage(srcImage, 0, 0, this.renderWidth, this.renderHeight);
              if (this.appointment?.property != null) {
                this.appointment.property.photo_B64 = this.exportImage(canvas);
                this.appointment.changed$.next();
              }
              this.rendering = true;
            }
          }, 0);
        };
        srcImage.src = url;
      }
    }, 0);
  }
  // #endregion
  // #region Navigation
  get canGoForward() {
    return this.appointment?.property?.photo_B64 != null || this.appointment?.property?.photo != null;
  }
  goBack() {
    if (this.appointment != null) {
      this.localAppointmentService.goToSummary(this.appointment);
    }
  }
  goForward() {
    if (this.appointment != null) {
      this.localAppointmentService.checkIn(this.appointment);
    }
  }
  init() {
    if (this.appointment != null) {
      this.localAppointmentService.startCheckIn(this.appointment);
      this.renderExistingImage();
    }
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_CheckInComponent.\u0275fac = function CheckInComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _CheckInComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_CheckInComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _CheckInComponent, selectors: [["check-in"]], viewQuery: function CheckInComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
    \u0275\u0275viewQuery(_c1, 5);
    \u0275\u0275viewQuery(_c2, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.fileInputElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.renderCanvasElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 27, vars: 7, consts: [["fileInputElm", ""], ["renderCanvasElm", ""], ["id", "checkIn"], [1, "photo"], [1, "bg"], ["type", "file", 3, "input", "disabled", "accept"], [3, "width", "height"], [1, "control-bar"], [1, "controls"], [1, "icon-control", 3, "click", "disabled"], [1, "fa-solid", "fa-camera"], ["id", "mainNav"], [1, "island"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], [1, "tooltip", "active"]], template: function CheckInComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 2)(1, "div", 3);
    \u0275\u0275element(2, "div", 4);
    \u0275\u0275elementStart(3, "input", 5, 0);
    \u0275\u0275listener("input", function CheckInComponent_Template_input_input_3_listener() {
      \u0275\u0275restoreView(_r1);
      const fileInputElm_r2 = \u0275\u0275reference(4);
      return \u0275\u0275resetView(ctx.selectFile(fileInputElm_r2));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275element(5, "canvas", 6, 1);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "div", 7)(8, "div", 8)(9, "button", 9);
    \u0275\u0275listener("click", function CheckInComponent_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.selectMedia());
    });
    \u0275\u0275element(10, "i", 10);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(11, "nav", 11)(12, "div", 12)(13, "div", 8)(14, "button", 13);
    \u0275\u0275listener("click", function CheckInComponent_Template_button_click_14_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goBack());
    });
    \u0275\u0275element(15, "i", 14);
    \u0275\u0275elementStart(16, "label");
    \u0275\u0275text(17, "Back to Summary");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "button", 15);
    \u0275\u0275listener("click", function CheckInComponent_Template_button_click_18_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goForward());
    });
    \u0275\u0275element(19, "i", 16);
    \u0275\u0275elementStart(20, "label");
    \u0275\u0275text(21, "Continue to Needs Assessment");
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(22, "div", 17)(23, "h3");
    \u0275\u0275text(24, "Tip: At the appointment?");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(25, "p");
    \u0275\u0275text(26, " Take a photo of the front of the property to complete check-in and begin the appointment. ");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275property("accept", \u0275\u0275interpolate(ctx.acceptFileTypes))("disabled", !ctx.canModifyAppointment);
    \u0275\u0275advance(2);
    \u0275\u0275property("width", ctx.renderWidth)("height", ctx.renderHeight);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx.canModifyAppointment);
    \u0275\u0275advance(9);
    \u0275\u0275property("disabled", !ctx.canGoForward);
  }
}, styles: ["\n\n.tooltip[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */", `

#checkIn[_ngcontent-%COMP%] {
  position: absolute;
  top: calc(var(--systemOffset-top) + 6vw);
  left: 6vw;
  right: 6vw;
  bottom: 6vw;
}
#checkIn[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%] {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  border-radius: 2vw;
  overflow: hidden;
  border: 0.2vw var(--color2Alt3) solid;
}
#checkIn[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 0;
  opacity: 0.2;
  background-color: #DCDCDC;
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1600 900'%3E%3Cpolygon fill='%23b5b5b5' points='957 450 539 900 1396 900'/%3E%3Cpolygon fill='%23aaaaaa' points='957 450 872.9 900 1396 900'/%3E%3Cpolygon fill='%23bababa' points='-60 900 398 662 816 900'/%3E%3Cpolygon fill='%23a3a3a3' points='337 900 398 662 816 900'/%3E%3Cpolygon fill='%23bfbfbf' points='1203 546 1552 900 876 900'/%3E%3Cpolygon fill='%239c9c9c' points='1203 546 1552 900 1162 900'/%3E%3Cpolygon fill='%23c3c3c3' points='641 695 886 900 367 900'/%3E%3Cpolygon fill='%23959595' points='587 900 641 695 886 900'/%3E%3Cpolygon fill='%23c8c8c8' points='1710 900 1401 632 1096 900'/%3E%3Cpolygon fill='%238f8f8f' points='1710 900 1401 632 1365 900'/%3E%3Cpolygon fill='%23cdcdcd' points='1210 900 971 687 725 900'/%3E%3Cpolygon fill='%23888888' points='943 900 1210 900 971 687'/%3E%3C/svg%3E");
  background-attachment: fixed;
  background-size: cover;
}
#checkIn[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {
  position: absolute;
  visibility: hidden;
}
#checkIn[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {
  width: 100%;
  height: 100%;
  -webkit-object-fit: cover;
  -moz-object-fit: cover;
  -o-background-size: cover;
  object-fit: cover;
}
#checkIn[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {
  position: absolute;
  top: 1vw;
  right: 1vw;
  pointer-events: none;
  width: 25%;
  padding: 1vw;
  border-radius: 0.5vw;
  background-color: var(--color3Alt3);
  -webkit-backdrop-filter: blur(0.5vw);
  -moz-backdrop-filter: blur(0.5vw);
  -o-backdrop-filter: blur(0.5vw);
  -ms-backdrop-filter: blur(0.5vw);
  backdrop-filter: blur(0.5vw);
}
#checkIn[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {
  font-size: 1.8vw;
  color: var(--color2);
  font-weight: var(--stronger);
  font-style: italic;
  text-align: center;
}
#checkIn[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {
  margin-top: 0.5vw;
  font-size: 1.4vw;
  color: var(--color2);
  font-weight: var(--stdweight);
  text-align: center;
}
#checkIn[_ngcontent-%COMP%]    > .control-bar[_ngcontent-%COMP%] {
  position: absolute;
  left: 50%;
  -moz-transform: translate3d(-50%, 0, 0);
  -ms-transform: translate3d(-50%, 0, 0);
  -o-transform: translate3d(-50%, 0, 0);
  -webkit-transform: translate3d(-50%, 0, 0);
  transform: translate3d(-50%, 0, 0);
  bottom: 2vw;
  display: inline-block;
}
#checkIn[_ngcontent-%COMP%]    > .control-bar[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {
  display: flex;
  align-items: center;
}
#checkIn[_ngcontent-%COMP%]    > .control-bar[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-control[_ngcontent-%COMP%] {
  height: 8vw;
  width: 8vw;
  border-radius: 100%;
  position: relative;
  background-color: var(--color2);
  border: 0.3vw var(--color2Alt4) solid;
  -moz-transition: background-color 0.1s linear;
  -o-transition: background-color 0.1s linear;
  -webkit-transition: background-color 0.1s linear;
  transition: background-color 0.1s linear;
}
#checkIn[_ngcontent-%COMP%]    > .control-bar[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {
  position: absolute;
  top: 50%;
  left: 50%;
  -moz-transform: translate(-50%, -50%);
  -ms-transform: translate(-50%, -50%);
  -o-transform: translate(-50%, -50%);
  -webkit-transform: translate(-50%, -50%);
  transform: translate(-50%, -50%);
  font-size: 3.6vw;
  color: var(--color1);
}
#checkIn[_ngcontent-%COMP%]    > .control-bar[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .icon-control[_ngcontent-%COMP%]:active {
  background-color: var(--color2Alt3);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {
  position: absolute;
  bottom: 1vw;
  right: 1vw;
  z-index: calc(var(--navLayer) + 1);
  background-color: var(--color2);
  border-radius: 999px;
  padding: 0.5vw 1vw;
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {
  display: flex;
  align-items: center;
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {
  position: relative;
  margin-left: 1vw;
  padding: 0.8vw 2vw;
  border-radius: 999px;
  cursor: pointer;
  margin-left: 1vw;
  display: flex;
  align-items: center;
  background-color: var(--color3);
  border: 0.1vw transparent solid;
  -moz-transition: background-color 0.1s linear;
  -o-transition: background-color 0.1s linear;
  -webkit-transition: background-color 0.1s linear;
  transition: background-color 0.1s linear;
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, 
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {
  margin-left: 0.5vw;
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {
  font-size: 1.2vw;
  color: var(--color2);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {
  font-size: 1.2vw;
  color: var(--color2);
  font-weight: var(--strong);
  line-height: 1;
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {
  background-color: var(--success);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {
  background-color: var(--color2);
  border-color: var(--color1);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {
  color: var(--color1);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {
  opacity: 0.6;
  pointer-events: none;
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {
  background-color: var(--color3Alt4);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {
  background-color: var(--successAlt4);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {
  background-color: var(--color2Alt2);
}
#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {
  margin-left: 0;
}
.tooltip[_ngcontent-%COMP%] {
  top: 8vw;
  right: 8vw;
}
/*# sourceMappingURL=check-in.component.css.map */`] });
var CheckInComponent = _CheckInComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CheckInComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "check-in", template: '<section id="checkIn">\n    <div class="photo">\n        <div class="bg"></div>\n        <input #fileInputElm [disabled]="!canModifyAppointment" (input)="selectFile(fileInputElm)" type="file" accept="{{acceptFileTypes}}" />\n        <canvas #renderCanvasElm [width]="renderWidth" [height]="renderHeight"></canvas>\n    </div>\n\n    <div class="control-bar">\n        <div class="controls">\n            <button class="icon-control" [disabled]="!canModifyAppointment" (click)="selectMedia()">\n                <i class="fa-solid fa-camera"></i>\n            </button>\n        </div>\n    </div>\n</section>\n\n<nav id="mainNav">\n    <div class="island">\n        <div class="controls">\n            <button class="control" (click)="goBack()">\n                <i class="fa-solid fa-arrow-left-long"></i>\n                <label>Back to Summary</label>\n            </button>\n            <button class="control success" [disabled]="!canGoForward" (click)="goForward()">\n                <i class="fa-solid fa-arrow-right-long"></i>\n                <label>Continue to Needs Assessment</label>\n            </button>\n        </div>\n    </div>\n</nav>\n\n<div class="tooltip active">\n    <h3>Tip: At the appointment?</h3>\n    <p>\n        Take a photo of the front of the property to complete check-in and begin the appointment.\n    </p>\n</div>', styles: ["/* src/app/shared/ui/components/tooltips/tooltips.component.scss */\n.tooltip {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip > .control {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip > h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip > p {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip > .controls {\n  margin-top: 0.5vw;\n}\n.tooltip > .controls > .control {\n  cursor: pointer;\n  display: block;\n}\n.tooltip > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */\n", `/* src/app/appointment/components/check-in/check-in.component.scss */
#checkIn {
  position: absolute;
  top: calc(var(--systemOffset-top) + 6vw);
  left: 6vw;
  right: 6vw;
  bottom: 6vw;
}
#checkIn > .photo {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  border-radius: 2vw;
  overflow: hidden;
  border: 0.2vw var(--color2Alt3) solid;
}
#checkIn > .photo > .bg {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 0;
  opacity: 0.2;
  background-color: #DCDCDC;
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1600 900'%3E%3Cpolygon fill='%23b5b5b5' points='957 450 539 900 1396 900'/%3E%3Cpolygon fill='%23aaaaaa' points='957 450 872.9 900 1396 900'/%3E%3Cpolygon fill='%23bababa' points='-60 900 398 662 816 900'/%3E%3Cpolygon fill='%23a3a3a3' points='337 900 398 662 816 900'/%3E%3Cpolygon fill='%23bfbfbf' points='1203 546 1552 900 876 900'/%3E%3Cpolygon fill='%239c9c9c' points='1203 546 1552 900 1162 900'/%3E%3Cpolygon fill='%23c3c3c3' points='641 695 886 900 367 900'/%3E%3Cpolygon fill='%23959595' points='587 900 641 695 886 900'/%3E%3Cpolygon fill='%23c8c8c8' points='1710 900 1401 632 1096 900'/%3E%3Cpolygon fill='%238f8f8f' points='1710 900 1401 632 1365 900'/%3E%3Cpolygon fill='%23cdcdcd' points='1210 900 971 687 725 900'/%3E%3Cpolygon fill='%23888888' points='943 900 1210 900 971 687'/%3E%3C/svg%3E");
  background-attachment: fixed;
  background-size: cover;
}
#checkIn > .photo input {
  position: absolute;
  visibility: hidden;
}
#checkIn > .photo canvas {
  width: 100%;
  height: 100%;
  -webkit-object-fit: cover;
  -moz-object-fit: cover;
  -o-background-size: cover;
  object-fit: cover;
}
#checkIn > .meta {
  position: absolute;
  top: 1vw;
  right: 1vw;
  pointer-events: none;
  width: 25%;
  padding: 1vw;
  border-radius: 0.5vw;
  background-color: var(--color3Alt3);
  -webkit-backdrop-filter: blur(0.5vw);
  -moz-backdrop-filter: blur(0.5vw);
  -o-backdrop-filter: blur(0.5vw);
  -ms-backdrop-filter: blur(0.5vw);
  backdrop-filter: blur(0.5vw);
}
#checkIn > .meta h2 {
  font-size: 1.8vw;
  color: var(--color2);
  font-weight: var(--stronger);
  font-style: italic;
  text-align: center;
}
#checkIn > .meta > p {
  margin-top: 0.5vw;
  font-size: 1.4vw;
  color: var(--color2);
  font-weight: var(--stdweight);
  text-align: center;
}
#checkIn > .control-bar {
  position: absolute;
  left: 50%;
  -moz-transform: translate3d(-50%, 0, 0);
  -ms-transform: translate3d(-50%, 0, 0);
  -o-transform: translate3d(-50%, 0, 0);
  -webkit-transform: translate3d(-50%, 0, 0);
  transform: translate3d(-50%, 0, 0);
  bottom: 2vw;
  display: inline-block;
}
#checkIn > .control-bar > .controls {
  display: flex;
  align-items: center;
}
#checkIn > .control-bar > .controls > .icon-control {
  height: 8vw;
  width: 8vw;
  border-radius: 100%;
  position: relative;
  background-color: var(--color2);
  border: 0.3vw var(--color2Alt4) solid;
  -moz-transition: background-color 0.1s linear;
  -o-transition: background-color 0.1s linear;
  -webkit-transition: background-color 0.1s linear;
  transition: background-color 0.1s linear;
}
#checkIn > .control-bar > .controls > .icon-control > i {
  position: absolute;
  top: 50%;
  left: 50%;
  -moz-transform: translate(-50%, -50%);
  -ms-transform: translate(-50%, -50%);
  -o-transform: translate(-50%, -50%);
  -webkit-transform: translate(-50%, -50%);
  transform: translate(-50%, -50%);
  font-size: 3.6vw;
  color: var(--color1);
}
#checkIn > .control-bar > .controls > .icon-control:active {
  background-color: var(--color2Alt3);
}
#mainNav > .island {
  position: absolute;
  bottom: 1vw;
  right: 1vw;
  z-index: calc(var(--navLayer) + 1);
  background-color: var(--color2);
  border-radius: 999px;
  padding: 0.5vw 1vw;
}
#mainNav > .island > .controls {
  display: flex;
  align-items: center;
}
#mainNav > .island > .controls > .control {
  position: relative;
  margin-left: 1vw;
  padding: 0.8vw 2vw;
  border-radius: 999px;
  cursor: pointer;
  margin-left: 1vw;
  display: flex;
  align-items: center;
  background-color: var(--color3);
  border: 0.1vw transparent solid;
  -moz-transition: background-color 0.1s linear;
  -o-transition: background-color 0.1s linear;
  -webkit-transition: background-color 0.1s linear;
  transition: background-color 0.1s linear;
}
#mainNav > .island > .controls > .control > i:last-child,
#mainNav > .island > .controls > .control > label:last-child {
  margin-left: 0.5vw;
}
#mainNav > .island > .controls > .control > i {
  font-size: 1.2vw;
  color: var(--color2);
}
#mainNav > .island > .controls > .control > label {
  font-size: 1.2vw;
  color: var(--color2);
  font-weight: var(--strong);
  line-height: 1;
}
#mainNav > .island > .controls > .control.success {
  background-color: var(--success);
}
#mainNav > .island > .controls > .control.alternate {
  background-color: var(--color2);
  border-color: var(--color1);
}
#mainNav > .island > .controls > .control.alternate > label {
  color: var(--color1);
}
#mainNav > .island > .controls > .control[disabled] {
  opacity: 0.6;
  pointer-events: none;
}
#mainNav > .island > .controls > .control:active {
  background-color: var(--color3Alt4);
}
#mainNav > .island > .controls > .control:active.success {
  background-color: var(--successAlt4);
}
#mainNav > .island > .controls > .control:active.alternate {
  background-color: var(--color2Alt2);
}
#mainNav > .island > .controls > .control:first-child {
  margin-left: 0;
}
.tooltip {
  top: 8vw;
  right: 8vw;
}
/*# sourceMappingURL=check-in.component.css.map */
`] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], fileInputElm: [{
    type: ViewChild,
    args: ["fileInputElm"]
  }], renderCanvasElm: [{
    type: ViewChild,
    args: ["renderCanvasElm"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(CheckInComponent, { className: "CheckInComponent" });
})();

// src/app/appointment/components/customer-needs/customer-needs.component.ts
function CustomerNeedsComponent_For_8_For_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 17);
    \u0275\u0275listener("click", function CustomerNeedsComponent_For_8_For_6_Template_button_click_0_listener() {
      const possibleAnswer_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const question_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.toggleOption(question_r3, possibleAnswer_r2.answer));
    });
    \u0275\u0275element(1, "i", 18)(2, "i", 19);
    \u0275\u0275elementStart(3, "label");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const possibleAnswer_r2 = ctx.$implicit;
    const question_r3 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("checked", question_r3.answers.indexOf(possibleAnswer_r2.answer) > -1);
    \u0275\u0275property("disabled", !ctx_r3.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(possibleAnswer_r2.title);
  }
}
function CustomerNeedsComponent_For_8_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 14)(1, "input", 20);
    \u0275\u0275listener("change", function CustomerNeedsComponent_For_8_Conditional_7_Template_input_change_1_listener() {
      \u0275\u0275restoreView(_r5);
      const question_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.storeOtherAnswer(question_r3));
    });
    \u0275\u0275twoWayListener("ngModelChange", function CustomerNeedsComponent_For_8_Conditional_7_Template_input_ngModelChange_1_listener($event) {
      \u0275\u0275restoreView(_r5);
      const question_r3 = \u0275\u0275nextContext().$implicit;
      \u0275\u0275twoWayBindingSet(question_r3.otherAnswer, $event) || (question_r3.otherAnswer = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const question_r3 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r3.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", question_r3.otherAnswer);
  }
}
function CustomerNeedsComponent_For_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 14)(4, "div", 15);
    \u0275\u0275repeaterCreate(5, CustomerNeedsComponent_For_8_For_6_Template, 5, 4, "button", 16, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(7, CustomerNeedsComponent_For_8_Conditional_7_Template, 2, 2, "div", 14);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const question_r3 = ctx.$implicit;
    const \u0275$index_14_r6 = ctx.$index;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("active", (ctx_r3.activeQuestion == null ? null : ctx_r3.activeQuestion.question) == question_r3.question)("previous", ctx_r3.activeQuestionIndex > \u0275$index_14_r6);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(question_r3.question);
    \u0275\u0275advance(3);
    \u0275\u0275repeater(question_r3.possibleAnswers);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(question_r3.answers.indexOf("other") > -1 ? 7 : -1);
  }
}
function CustomerNeedsComponent_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "h3");
    \u0275\u0275text(1, "Tip: Ready to Inspect?");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(2, "p");
    \u0275\u0275text(3, " When you've answered all your customer's needs, you can Continue to the property inspection. ");
    \u0275\u0275elementEnd();
  }
}
function CustomerNeedsComponent_Conditional_22_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "h3");
    \u0275\u0275text(1, "Tip: Multiple answers apply?");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(2, "p");
    \u0275\u0275text(3, " You can tap as many anwers as necesssary to capture your customer's needs. ");
    \u0275\u0275elementEnd();
  }
}
gsapWithCSS.registerPlugin(Draggable);
var _CustomerNeedsComponent = class _CustomerNeedsComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.activeQuestionIndex = 0;
    this.forwardLabel = "Next Question";
    this.backLabel = "Back to Check-In";
    this.canGoForward = false;
    this.onLastPage = false;
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get activeQuestion() {
    return this.questions[this.activeQuestionIndex];
  }
  get questions() {
    return this.appointment?.questions ?? [];
  }
  toggleOption(question, answer) {
    let answerFound = false;
    let foundIndex = 0;
    for (var i = 0, len = question.answers.length; i < len; i++) {
      const existingAnswer = question.answers[i];
      if (existingAnswer == answer) {
        answerFound = true;
        foundIndex = i;
        break;
      }
    }
    if (answerFound) {
      question.answers.splice(foundIndex, 1);
      if (answer == "other") {
        question.otherAnswer = void 0;
      }
    } else {
      question.answers.push(answer);
    }
    this.storeCustomerNeed(question);
  }
  storeOtherAnswer(question) {
    if (question.otherAnswer != null) {
      let answerFound = false;
      let foundIndex = 0;
      for (var i = 0, len = question.answers.length; i < len; i++) {
        const existingAnswer = question.answers[i];
        if (existingAnswer == question.otherAnswer) {
          answerFound = true;
          foundIndex = i;
          break;
        }
      }
      if (answerFound) {
        question.answers.splice(foundIndex, 1);
      } else {
        question.answers.push(question.otherAnswer);
      }
      this.storeCustomerNeed(question);
    }
  }
  mapCustomerNeeds(needs) {
    for (const key in needs) {
      const answers = needs[key];
      const question = this.questions.find((x) => x.question == key);
      if (question != null) {
        for (var i = 0, len = answers.length; i < len; i++) {
          const answer = answers[i];
          const existingAnswer = question.possibleAnswers.find((x) => x.answer == answer);
          if (existingAnswer != null) {
            question.answers.push(answer);
          } else {
            question.otherAnswer = answer;
          }
        }
      }
    }
    this.activeQuestionIndex = 0;
    this.setPreviousLabel();
    this.setCanGoForward();
  }
  getCustomerNeeds() {
    if (this.appointment != null) {
      const needs = this.appointment.customerNeeds;
      this.mapCustomerNeeds(needs);
    }
  }
  storeCustomerNeed(question) {
    if (this.appointment != null) {
      this.appointment.customerNeeds[question.question] = question.answers;
      this.appointment.changed$.next();
      this.setCanGoForward();
    }
  }
  setCanGoForward() {
    const nextIndex = this.activeQuestionIndex + 1;
    const nextQuestion = this.questions[nextIndex];
    if (nextQuestion != null) {
      this.canGoForward = true;
      this.forwardLabel = "Next Question";
      if (this.activeQuestion != null && this.activeQuestion.answers.length > 0) {
        this.canGoForward = true;
      } else {
        this.canGoForward = false;
        this.forwardLabel = "Please answer the question.";
      }
    } else {
      let missingAnswers = false;
      for (var i = 0, len = this.questions.length; i < len; i++) {
        const question = this.questions[i];
        if (question.answers.length <= 0) {
          missingAnswers = true;
          break;
        }
      }
      if (!missingAnswers) {
        this.canGoForward = true;
        this.forwardLabel = "Please answer the question.";
        this.forwardLabel = "Continue to Inspection";
        this.onLastPage = true;
      } else {
        this.canGoForward = false;
        this.forwardLabel = "Please answer the question.";
        this.onLastPage = false;
      }
    }
  }
  retreatAppointment() {
    if (this.appointment != null) {
      this.localAppointmentService.goToCheckIn(this.appointment);
    }
  }
  goBack() {
    const prevIndex = this.activeQuestionIndex - 1;
    const previousQuestion = this.questions[prevIndex];
    if (previousQuestion != null) {
      this.activeQuestionIndex = prevIndex;
      this.setPreviousLabel();
      this.setCanGoForward();
    } else {
      this.retreatAppointment();
    }
  }
  goForward() {
    const nextIndex = this.activeQuestionIndex + 1;
    let nextQuestion = this.questions[nextIndex];
    if (nextQuestion != null) {
      this.activeQuestionIndex = nextIndex;
      this.setCanGoForward();
      this.setPreviousLabel();
    } else {
      this.advanceAppointment();
    }
  }
  advanceAppointment() {
    if (this.appointment != null) {
      this.localAppointmentService.submitCustomerNeeds(this.appointment);
    }
  }
  setPreviousLabel() {
    const prevIndex = this.activeQuestionIndex - 1;
    const previousQuestion = this.questions[prevIndex];
    if (previousQuestion != null) {
      this.backLabel = "Previous Question";
    } else {
      this.backLabel = "Back to Check-In";
    }
  }
  init() {
    if (this.appointment != null) {
      this.getCustomerNeeds();
      this.appointment.changed$.next();
    }
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_CustomerNeedsComponent.\u0275fac = function CustomerNeedsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _CustomerNeedsComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_CustomerNeedsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _CustomerNeedsComponent, selectors: [["customer-needs"]], inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 23, vars: 5, consts: [["id", "customerNeeds"], [1, "content"], [1, "form"], [1, "questions"], [1, "question", 3, "active", "previous"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], [1, "tooltip", "next", "active"], [1, "question"], [1, "input"], [1, "selection"], [1, "option", 3, "disabled", "checked"], [1, "option", 3, "click", "disabled"], [1, "fa-regular", "fa-circle", "unchecked"], [1, "fa-solid", "fa-circle-check", "checked"], ["type", "text", "placeholder", "Other answer...", 3, "change", "ngModelChange", "disabled", "ngModel"]], template: function CustomerNeedsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1)(2, "header")(3, "h1");
    \u0275\u0275text(4, "How can we help today?");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 2)(6, "div", 3);
    \u0275\u0275repeaterCreate(7, CustomerNeedsComponent_For_8_Template, 8, 6, "div", 4, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(9, "nav", 5)(10, "div", 6)(11, "div", 7)(12, "button", 8);
    \u0275\u0275listener("click", function CustomerNeedsComponent_Template_button_click_12_listener() {
      return ctx.goBack();
    });
    \u0275\u0275element(13, "i", 9);
    \u0275\u0275elementStart(14, "label");
    \u0275\u0275text(15);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "button", 10);
    \u0275\u0275listener("click", function CustomerNeedsComponent_Template_button_click_16_listener() {
      return ctx.goForward();
    });
    \u0275\u0275element(17, "i", 11);
    \u0275\u0275elementStart(18, "label");
    \u0275\u0275text(19);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(20, "div", 12);
    \u0275\u0275conditionalCreate(21, CustomerNeedsComponent_Conditional_21_Template, 4, 0);
    \u0275\u0275conditionalCreate(22, CustomerNeedsComponent_Conditional_22_Template, 4, 0);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275repeater(ctx.questions);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx.backLabel);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canGoForward);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.forwardLabel);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.onLastPage ? 21 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.onLastPage ? 22 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel], styles: ["\n\n.tooltip[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */", "\n\n#customerNeeds[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: relative;\n  overflow: hidden;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 1;\n  text-align: center;\n  font-size: 4vw;\n  color: var(--color1);\n  font-weight: var(--strongest);\n  font-style: italic;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 2vw;\n  margin-top: 2vw;\n  position: relative;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-bottom: 2vw;\n  pointer-events: none;\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n  -moz-transition: transform 0.25s linear;\n  -o-transition: transform 0.25s linear;\n  -webkit-transition: transform 0.25s linear;\n  transition: transform 0.25s linear;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 2.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  background-color: var(--color3Alt4);\n  padding: 0.75vw 2vw;\n  display: block;\n  width: 100%;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%] {\n  padding: 0 2vw;\n  margin-top: 1.25vw;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  margin-top: 1.25vw;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 2.8vw;\n  color: var(--color1);\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[_ngcontent-%COMP%]   i.unchecked[_ngcontent-%COMP%] {\n  display: block;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[_ngcontent-%COMP%]   i.checked[_ngcontent-%COMP%] {\n  display: none;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  margin-left: 1.5vw;\n  font-size: 2.2vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option.checked[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--success);\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option.checked[_ngcontent-%COMP%]   i.unchecked[_ngcontent-%COMP%] {\n  display: none;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option.checked[_ngcontent-%COMP%]   i.checked[_ngcontent-%COMP%] {\n  display: block;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[disabled][_ngcontent-%COMP%] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   .selection[_ngcontent-%COMP%]   .option[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  resize: none;\n  display: block;\n  width: 100%;\n  font-size: 2.2vw;\n  padding: 1vw 2vw;\n  color: var(--color1);\n  border: 0.3vw var(--color1) solid;\n  border-radius: 0.5vw;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question[_ngcontent-%COMP%]   .input[_ngcontent-%COMP%]:first-of-type {\n  margin-top: 2vw;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question.active[_ngcontent-%COMP%] {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n  pointer-events: initial;\n}\n#customerNeeds[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .questions[_ngcontent-%COMP%]    > .question.previous[_ngcontent-%COMP%] {\n  -moz-transform: translateX(-100%);\n  -ms-transform: translateX(-100%);\n  -o-transform: translateX(-100%);\n  -webkit-transform: translateX(-100%);\n  transform: translateX(-100%);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n.tooltip.next[_ngcontent-%COMP%] {\n  bottom: 7vw;\n  right: 3vw;\n}\n/*# sourceMappingURL=customer-needs.component.css.map */"] });
var CustomerNeedsComponent = _CustomerNeedsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CustomerNeedsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "customer-needs", template: `<section id="customerNeeds">
  <div class="content">
    <header>
      <h1>How can we help today?</h1>
    </header>

    <div class="form">
      <div class="questions">
        @for (question of questions; track question; let i = $index) {
          <div class="question"
            [class.active]="activeQuestion?.question == question.question"
            [class.previous]="activeQuestionIndex > i"
            >
            <label>{{question.question}}</label>
            <div class="input">
              <div class="selection">
                @for (possibleAnswer of question.possibleAnswers; track possibleAnswer) {
                  <button class="option"
                    [disabled]="!canModifyAppointment"
                    [class.checked]="question.answers.indexOf(possibleAnswer.answer) > -1"
                    (click)="toggleOption(question,possibleAnswer.answer)">
                    <i class="fa-regular fa-circle unchecked"></i>
                    <i class="fa-solid fa-circle-check checked"></i>
                    <label>{{possibleAnswer.title}}</label>
                  </button>
                }
              </div>
            </div>
            @if (question.answers.indexOf('other') > -1) {
              <div class="input">
                <input type="text" [disabled]="!canModifyAppointment" placeholder="Other answer..." (change)="storeOtherAnswer(question)" [(ngModel)]="question.otherAnswer" />
              </div>
            }
          </div>
        }
      </div>
    </div>
  </div>
</section>

<nav id="mainNav">
  <div class="island">
    <div class="controls">
      <button class="control" (click)="goBack()">
        <i class="fa-solid fa-arrow-left-long"></i>
        <label>{{backLabel}}</label>
      </button>
      <button class="control success"
        [disabled]="!canGoForward"
        (click)="goForward()">
        <i class="fa-solid fa-arrow-right-long"></i>
        <label>{{forwardLabel}}</label>
      </button>
    </div>
  </div>
</nav>

<div class="tooltip next active">
  @if (onLastPage) {
    <h3>Tip: Ready to Inspect?</h3>
    <p>
      When you've answered all your customer's needs, you can Continue to the property inspection.
    </p>
  }
  @if (!onLastPage) {
    <h3>Tip: Multiple answers apply?</h3>
    <p>
      You can tap as many anwers as necesssary to capture your customer's needs.
    </p>
  }
</div>`, styles: ["/* src/app/shared/ui/components/tooltips/tooltips.component.scss */\n.tooltip {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip > .control {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip > h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip > p {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip > .controls {\n  margin-top: 0.5vw;\n}\n.tooltip > .controls > .control {\n  cursor: pointer;\n  display: block;\n}\n.tooltip > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */\n", "/* src/app/appointment/components/customer-needs/customer-needs.component.scss */\n#customerNeeds {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n}\n#customerNeeds > .content {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#customerNeeds > .content > header {\n  position: relative;\n  overflow: hidden;\n}\n#customerNeeds > .content > header h1 {\n  position: relative;\n  z-index: 1;\n  text-align: center;\n  font-size: 4vw;\n  color: var(--color1);\n  font-weight: var(--strongest);\n  font-style: italic;\n}\n#customerNeeds > .content > .form {\n  flex: 1;\n  padding: 2vw;\n  margin-top: 2vw;\n  position: relative;\n}\n#customerNeeds > .content > .form > .questions {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#customerNeeds > .content > .form > .questions > .question {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-bottom: 2vw;\n  pointer-events: none;\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n  -moz-transition: transform 0.25s linear;\n  -o-transition: transform 0.25s linear;\n  -webkit-transition: transform 0.25s linear;\n  transition: transform 0.25s linear;\n}\n#customerNeeds > .content > .form > .questions > .question > label {\n  font-size: 2.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  background-color: var(--color3Alt4);\n  padding: 0.75vw 2vw;\n  display: block;\n  width: 100%;\n}\n#customerNeeds > .content > .form > .questions > .question .input {\n  padding: 0 2vw;\n  margin-top: 1.25vw;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  margin-top: 1.25vw;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option i {\n  font-size: 2.8vw;\n  color: var(--color1);\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option i.unchecked {\n  display: block;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option i.checked {\n  display: none;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option label {\n  margin-left: 1.5vw;\n  font-size: 2.2vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option.checked i {\n  color: var(--success);\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option.checked i.unchecked {\n  display: none;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option.checked i.checked {\n  display: block;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option[disabled] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#customerNeeds > .content > .form > .questions > .question .input .selection .option:first-child {\n  margin-top: 0;\n}\n#customerNeeds > .content > .form > .questions > .question .input input,\n#customerNeeds > .content > .form > .questions > .question .input select,\n#customerNeeds > .content > .form > .questions > .question .input textarea {\n  margin-top: 0.5vw;\n  resize: none;\n  display: block;\n  width: 100%;\n  font-size: 2.2vw;\n  padding: 1vw 2vw;\n  color: var(--color1);\n  border: 0.3vw var(--color1) solid;\n  border-radius: 0.5vw;\n}\n#customerNeeds > .content > .form > .questions > .question .input:first-of-type {\n  margin-top: 2vw;\n}\n#customerNeeds > .content > .form > .questions > .question.active {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n  pointer-events: initial;\n}\n#customerNeeds > .content > .form > .questions > .question.previous {\n  -moz-transform: translateX(-100%);\n  -ms-transform: translateX(-100%);\n  -o-transform: translateX(-100%);\n  -webkit-transform: translateX(-100%);\n  transform: translateX(-100%);\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n.tooltip.next {\n  bottom: 7vw;\n  right: 3vw;\n}\n/*# sourceMappingURL=customer-needs.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], route: [{
    type: Input,
    args: ["route"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(CustomerNeedsComponent, { className: "CustomerNeedsComponent" });
})();

// src/app/appointment/components/presentation/page/page.component.ts
var _c03 = ["componentElm"];
function PresentationPageComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1);
    \u0275\u0275element(2, "img", 2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275property("src", ctx_r0.contentSrc, \u0275\u0275sanitizeUrl);
  }
}
var _PresentationPageComponent = class _PresentationPageComponent {
  constructor(apiService, contentService, uiService, sanitizer) {
    this.apiService = apiService;
    this.contentService = contentService;
    this.uiService = uiService;
    this.sanitizer = sanitizer;
    this.PresentationContentType = PresentationContentType;
  }
  get content() {
    return this.page?.content;
  }
  initPage() {
    if (this.content != null) {
      switch (this.content.type) {
        case PresentationContentType.Image:
          {
            let url = "";
            if (this.content.source != null) {
              url = this.apiService.getContentUrl(this.content.source.fileName);
            } else if (this.content.source_Url != null) {
              url = this.content.source_Url;
            }
            this.contentService.getImage(url).then((image) => {
              this.contentSrc = image.localSrc;
            }).catch(() => {
              this.contentSrc = url;
            });
          }
          break;
      }
    }
  }
  init() {
    this.initPage();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_PresentationPageComponent.\u0275fac = function PresentationPageComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationPageComponent)(\u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DomSanitizer));
};
_PresentationPageComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PresentationPageComponent, selectors: [["page"]], viewQuery: function PresentationPageComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { page: "page" }, standalone: false, decls: 1, vars: 1, consts: [[1, "page"], [1, "image"], [3, "src"]], template: function PresentationPageComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, PresentationPageComponent_Conditional_0_Template, 3, 1, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.contentSrc != null ? 0 : -1);
  }
}, styles: ["\n\n.page[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.page[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n}\n.page[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n/*# sourceMappingURL=page.component.css.map */"] });
var PresentationPageComponent = _PresentationPageComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationPageComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "page", template: '@if (contentSrc != null) {\n  <div class="page">\n    <div class="image">\n      <img [src]="contentSrc" />\n    </div>\n  </div>\n}', styles: ["/* src/app/appointment/components/presentation/page/page.component.scss */\n.page {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.page > .image {\n  height: 100%;\n  width: 100%;\n}\n.page > .image img {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n/*# sourceMappingURL=page.component.css.map */\n"] }]
  }], () => [{ type: ApiService }, { type: ContentService }, { type: UiService }, { type: DomSanitizer }], { page: [{
    type: Input,
    args: ["page"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PresentationPageComponent, { className: "PresentationPageComponent" });
})();

// src/app/appointment/components/presentation/content-thumb/content-thumb.component.ts
var _c04 = ["componentElm"];
function ContentThumbComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "img", 3);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("src", ctx_r0.source, \u0275\u0275sanitizeUrl);
  }
}
var _ContentThumbComponent = class _ContentThumbComponent {
  constructor(apiService) {
    this.apiService = apiService;
    this.PresentationContentType = PresentationContentType;
  }
  initContent() {
    if (this.content != null) {
      if (this.content.thumb != null) {
        this.source = this.apiService.getContentUrl(this.content.thumb.fileName);
      } else {
        this.source = this.content.thumb_Url;
      }
    } else {
      this.source = void 0;
    }
  }
  init() {
    this.initContent();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_ContentThumbComponent.\u0275fac = function ContentThumbComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ContentThumbComponent)(\u0275\u0275directiveInject(ApiService));
};
_ContentThumbComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ContentThumbComponent, selectors: [["content-thumb"]], viewQuery: function ContentThumbComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { content: "content" }, standalone: false, decls: 4, vars: 1, consts: [[1, "content-thumb"], ["height", "3", "width", "4"], [1, "thumb"], ["draggable", "false", 3, "src"]], template: function ContentThumbComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0);
    \u0275\u0275element(1, "canvas", 1);
    \u0275\u0275elementStart(2, "div", 2);
    \u0275\u0275conditionalCreate(3, ContentThumbComponent_Conditional_3_Template, 1, 1, "img", 3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.source != null ? 3 : -1);
  }
}, styles: ["\n\n.content-thumb[_ngcontent-%COMP%] {\n  position: relative;\n}\n.content-thumb[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.content-thumb[_ngcontent-%COMP%]    > .thumb[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.content-thumb[_ngcontent-%COMP%]    > .thumb[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n/*# sourceMappingURL=content-thumb.component.css.map */"] });
var ContentThumbComponent = _ContentThumbComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ContentThumbComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "content-thumb", template: '<div class="content-thumb">\n  <canvas height="3" width="4"></canvas>\n  <div class="thumb">\n    @if (source != null) {\n      <img draggable="false" [src]="source" />\n    }\n  </div>\n</div>', styles: ["/* src/app/appointment/components/presentation/content-thumb/content-thumb.component.scss */\n.content-thumb {\n  position: relative;\n}\n.content-thumb > canvas {\n  width: 100%;\n}\n.content-thumb > .thumb {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.content-thumb > .thumb img {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n/*# sourceMappingURL=content-thumb.component.css.map */\n"] }]
  }], () => [{ type: ApiService }], { content: [{
    type: Input,
    args: ["content"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ContentThumbComponent, { className: "ContentThumbComponent" });
})();

// src/app/appointment/components/presentation/presentation.component.ts
var _c05 = ["componentElm"];
function PresentationComponent_For_14_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "page", 25);
  }
  if (rf & 2) {
    const page_r2 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("page", page_r2);
  }
}
function PresentationComponent_For_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, PresentationComponent_For_14_Conditional_0_Template, 1, 1, "page", 25);
  }
  if (rf & 2) {
    const page_r2 = ctx.$implicit;
    \u0275\u0275conditional(page_r2.active ? 0 : -1);
  }
}
function PresentationComponent_For_25_For_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 28);
    \u0275\u0275listener("click", function PresentationComponent_For_25_For_6_Template_div_click_0_listener() {
      const photo_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r4 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r4.viewPhoto(photo_r4));
    });
    \u0275\u0275element(1, "canvas", 29)(2, "img", 30);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const photo_r4 = ctx.$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("src", photo_r4, \u0275\u0275sanitizeUrl);
  }
}
function PresentationComponent_For_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 16)(1, "header")(2, "h3");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "div", 26);
    \u0275\u0275repeaterCreate(5, PresentationComponent_For_25_For_6_Template, 3, 1, "div", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const collection_r6 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(collection_r6.name);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(collection_r6.photos);
  }
}
function PresentationComponent_Conditional_34_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 18)(1, "p");
    \u0275\u0275text(2, "No presentation content.");
    \u0275\u0275elementEnd()();
  }
}
function PresentationComponent_For_36_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 19, 1)(2, "content-thumb", 31);
    \u0275\u0275listener("click", function PresentationComponent_For_36_Template_content_thumb_click_2_listener() {
      const contentItem_r8 = \u0275\u0275restoreView(_r7).$implicit;
      const ctx_r4 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r4.viewContent(contentItem_r8));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const contentItem_r8 = ctx.$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("content", contentItem_r8);
  }
}
var _PresentationComponent = class _PresentationComponent {
  constructor(localAppointmentService, apiService, presentationService) {
    this.localAppointmentService = localAppointmentService;
    this.apiService = apiService;
    this.presentationService = presentationService;
    this.pages = [];
    this.activePageIndex = 0;
    this.viewingContent = false;
    this.viewingGallery = false;
    this.photoCollections = [];
    this.targetPrice = "";
    this.forwardLabel = "Next Page";
    this.backLabel = "Back to Inspection";
  }
  get isFirstPage() {
    return this.activePageIndex == 0;
  }
  get isLastPage() {
    return this.activePageIndex == this.pages.length - 1;
  }
  setActivePage(page) {
    const index = this.pages.findIndex((x) => x.content?.id == page.content?.id);
    if (index != null) {
      this.pages.forEach((existingPage) => {
        if (existingPage.content?.id != page.content?.id) {
          existingPage.active = false;
        }
      });
      this.activePageIndex = index;
      page.active = true;
    }
  }
  initPresentationPages() {
    this.pageCollection = this.presentation?.pageCollection;
    this.pages = this.pageCollection?.pages ?? [];
    if (this.pages[0] != null) {
      this.setActivePage(this.pages[0]);
    }
  }
  initPresentation() {
    if (this.appointment?.assignedTo != null) {
      this.presentationService.getPresentationByName(this.appointment.assignedTo.id, "Default").subscribe({
        next: (presentation) => {
          if (presentation != null) {
            this.presentation = presentation;
          } else {
            this.presentation = this.appointment?.presentation;
          }
          this.initPresentationPages();
        },
        error: () => {
          this.presentation = this.appointment?.presentation;
          this.initPresentationPages();
        }
      });
    } else {
      this.presentation = this.appointment?.presentation;
      this.initPresentationPages();
    }
  }
  get availableContent() {
    return this.activeCollection?.content ?? [];
  }
  get collections() {
    return this.appointment?.availablePresentationContent ?? [];
  }
  get hasContent() {
    return this.availableContent.length > 0;
  }
  stopViewingContent() {
    this.viewingContent = false;
  }
  viewContent(content) {
    if (content.source_Url != null) {
      this.localAppointmentService.viewPhoto(content.source_Url);
    }
  }
  toggleContent() {
    this.viewingContent = !this.viewingContent;
    this.viewingGallery = false;
  }
  initContent() {
    this.activeCollection = this.collections[0];
  }
  toggleGallery() {
    this.viewingGallery = !this.viewingGallery;
    this.viewingContent = false;
  }
  stopViewingGallery() {
    this.viewingGallery = false;
  }
  viewPhoto(src) {
    this.localAppointmentService.viewPhoto(src);
  }
  findPhotos(entities) {
    entities.forEach((entity) => {
      if (entity.name != null) {
        const photos = [];
        entity.photos.forEach((photo) => {
          photos.push(this.apiService.getContentUrl(photo.fileName));
        });
        photos.push(...entity.photos_B64);
        entity.fixtures.forEach((fixture) => {
          fixture.photos.forEach((photo) => {
            photos.push(this.apiService.getContentUrl(photo.fileName));
          });
          photos.push(...fixture.photos_B64);
        });
        if (photos.length > 0) {
          let name = `${entity.name} Photos`;
          if (entity.type == PropertyEntityType.Room) {
            name = `${entity.name} ${entity.number} Photos`;
          }
          const collection = {
            name,
            photos
          };
          this.photoCollections.push(collection);
        }
        this.findPhotos(entity.entities);
      }
    });
  }
  initGallery() {
    if (this.appointment?.property != null) {
      const photos = [];
      if (this.appointment.property.photo?.fileName != null) {
        photos.push(this.apiService.getContentUrl(this.appointment.property.photo.fileName));
      } else if (this.appointment.property.photo_B64 != null) {
        photos.push(this.appointment.property.photo_B64);
      }
      const collection = {
        name: "Property Photos",
        photos
      };
      this.photoCollections.push(collection);
      if (this.appointment.property.entity != null) {
        photos.push(...this.appointment.property.entity.photos_B64);
        this.findPhotos(this.appointment.property.entity.entities);
      }
    }
  }
  watchPrice() {
    if (this.appointment != null) {
      this.generateTargetPrice();
      this.appointment.calcPricing();
    }
  }
  generateTargetPrice() {
    const price = this.appointment?.customPrice ?? this.appointment?.price;
    if (price != null) {
      const targetPrice = Math.round(price.targetPrice ?? 0);
      const prefixes = ["hx", "zx", "qr", "bn"];
      const suffixes = ["a", "b", "x", "z"];
      const randomPrefix = prefixes[Math.floor(Math.random() * prefixes.length)];
      const randomSuffix = suffixes[Math.floor(Math.random() * suffixes.length)];
      this.targetPrice = `${randomPrefix}-${Math.floor(Math.random() * 100)}${randomSuffix}-${targetPrice.toString().replace(/(\d)/g, "$1")}-a5`;
    }
  }
  get routeService() {
    return this.localAppointmentService.routeService;
  }
  get canGoForward() {
    return !this.viewingGallery && !this.viewingContent;
  }
  goPrev() {
    const prevPage = this.pages[this.activePageIndex - 1];
    if (prevPage != null) {
      this.setActivePage(prevPage);
      this.setNavLabels();
    } else {
      this.routeService.viewRoute(AppointmentRouteType.Inspection, RouteLoadDirection.Reverse, true);
    }
    this.setNavLabels();
  }
  goNext() {
    const nextPage = this.pages[this.activePageIndex + 1];
    if (nextPage != null) {
      this.setActivePage(nextPage);
      this.setNavLabels();
    } else {
      this.routeService.viewRoute(AppointmentRouteType.JobSummary, RouteLoadDirection.Forward, true);
    }
  }
  setNavLabels() {
    this.forwardLabel = "Next Page";
    if (this.isFirstPage) {
      this.backLabel = "Back to Inspection";
    } else {
      this.backLabel = "Previous Page";
    }
    if (this.isLastPage) {
      this.forwardLabel = "Go to Job Summary";
    } else {
      this.forwardLabel = "Next Page";
    }
  }
  init() {
    this.initPresentation();
    this.initGallery();
    this.initContent();
    this.watchPrice();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
    this.priceSubscription?.unsubscribe();
  }
};
_PresentationComponent.\u0275fac = function PresentationComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(PresentationService));
};
_PresentationComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PresentationComponent, selectors: [["presentation"]], viewQuery: function PresentationComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c05, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 48, vars: 15, consts: [["componentElm", ""], ["contentItemElm", ""], ["id", "presentation"], [1, "bg"], ["id", "presentationNav"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-images"], [1, "fa-solid", "fa-tv"], [1, "price"], [1, "value"], [1, "pages"], [1, "gallery"], [1, "primary"], [1, "fa-solid", "fa-xmark"], [1, "collections"], [1, "collection"], [1, "additional-content"], [1, "message"], [1, "content-item"], ["id", "mainNav"], [1, "island"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], [3, "page"], [1, "photos"], [1, "photo"], [1, "photo", 3, "click"], ["width", "4", "height", "3"], [3, "src"], [3, "click", "content"]], template: function PresentationComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 2, 0);
    \u0275\u0275element(2, "div", 3);
    \u0275\u0275elementStart(3, "nav", 4)(4, "div", 5)(5, "button", 6);
    \u0275\u0275listener("click", function PresentationComponent_Template_button_click_5_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.toggleGallery());
    });
    \u0275\u0275element(6, "i", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "button", 6);
    \u0275\u0275listener("click", function PresentationComponent_Template_button_click_7_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.toggleContent());
    });
    \u0275\u0275element(8, "i", 8);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "div", 9)(10, "span", 10);
    \u0275\u0275text(11);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(12, "div", 11);
    \u0275\u0275repeaterCreate(13, PresentationComponent_For_14_Template, 1, 1, null, null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "div", 12)(16, "header")(17, "div", 13)(18, "h3");
    \u0275\u0275text(19, "Photos from Your Home");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(20, "div", 5)(21, "button", 6);
    \u0275\u0275listener("click", function PresentationComponent_Template_button_click_21_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.stopViewingGallery());
    });
    \u0275\u0275element(22, "i", 14);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(23, "div", 15);
    \u0275\u0275repeaterCreate(24, PresentationComponent_For_25_Template, 7, 1, "div", 16, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(26, "div", 17)(27, "header")(28, "div", 13)(29, "h3");
    \u0275\u0275text(30, "More Great Content");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(31, "div", 5)(32, "button", 6);
    \u0275\u0275listener("click", function PresentationComponent_Template_button_click_32_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.stopViewingContent());
    });
    \u0275\u0275element(33, "i", 14);
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(34, PresentationComponent_Conditional_34_Template, 3, 0, "div", 18);
    \u0275\u0275repeaterCreate(35, PresentationComponent_For_36_Template, 3, 1, "div", 19, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(37, "nav", 20)(38, "div", 21)(39, "div", 5)(40, "button", 6);
    \u0275\u0275listener("click", function PresentationComponent_Template_button_click_40_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goPrev());
    });
    \u0275\u0275element(41, "i", 22);
    \u0275\u0275elementStart(42, "label");
    \u0275\u0275text(43);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(44, "button", 23);
    \u0275\u0275listener("click", function PresentationComponent_Template_button_click_44_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goNext());
    });
    \u0275\u0275element(45, "i", 24);
    \u0275\u0275elementStart(46, "label");
    \u0275\u0275text(47);
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(5);
    \u0275\u0275classProp("active", ctx.viewingGallery);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("active", ctx.viewingContent);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", ctx.targetPrice, " ");
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.pages);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("active", ctx.viewingGallery);
    \u0275\u0275advance(9);
    \u0275\u0275repeater(ctx.photoCollections);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("active", ctx.viewingContent)("no-content", !ctx.hasContent);
    \u0275\u0275advance(8);
    \u0275\u0275conditional(!ctx.hasContent ? 34 : -1);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.availableContent);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx.backLabel);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canGoForward);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.forwardLabel);
  }
}, dependencies: [PresentationPageComponent, ContentThumbComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-moz-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-o-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-moz-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-o-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-moz-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-o-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-moz-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-o-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n#presentation[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color3Alt5);\n  overflow: hidden;\n}\n#presentation[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: -100%;\n  left: -100%;\n  right: -100%;\n  bottom: -100%;\n  background-image: url(/assets/images/logo.svg);\n  background-position: center center;\n  background-size: 15vw 10vw;\n  opacity: 0.3;\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n  -webkit-filter: grayscale(100%);\n  -moz-filter: grayscale(100%);\n  -o-filter: grayscale(100%);\n  -ms-filter: grayscale(100%);\n  filter: grayscale(100%);\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%] {\n  position: absolute;\n  top: auto;\n  left: 2vw;\n  right: 2vw;\n  bottom: 1vw;\n  z-index: 2;\n  display: flex;\n  align-items: center;\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  margin-left: 1.5vw;\n  opacity: 0.6;\n  -moz-transition: opacity 0.2s, background-color 0.2s;\n  -o-transition: opacity 0.2s, background-color 0.2s;\n  -webkit-transition: opacity 0.2s, background-color 0.2s;\n  transition: opacity 0.2s, background-color 0.2s;\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color2);\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--color4);\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-left: 1.5vw;\n}\n#presentation[_ngcontent-%COMP%]    > nav[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n#presentation[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 0;\n  top: calc(7vw + var(--systemOffset-top));\n  left: 0;\n  right: 0;\n  bottom: 10vh;\n  padding: 0 5vw;\n}\n#presentation[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > page[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 5vw;\n  right: 5vw;\n  bottom: 0;\n  border: 0.5vw var(--color2) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n  background-color: var(--color1);\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 0;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 5vw;\n  right: 5vw;\n  bottom: 7vw;\n  border: 0.5vw rgba(var(--color1Alt4-raw), 0.8) solid;\n  border-radius: 1vw;\n  background-color: var(--color1);\n  overflow-x: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: transform 0.2s, opacity 0.2s;\n  -o-transition: transform 0.2s, opacity 0.2s;\n  -webkit-transition: transform 0.2s, opacity 0.2s;\n  transition: transform 0.2s, opacity 0.2s;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  background-color: rgba(var(--color1Alt4-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: 1vw;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 0 2vw 5vw;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding-bottom: 0.5vw;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  color: var(--color2Alt1);\n  font-weight: var(--stdweight);\n  font-size: 1.8vw;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  margin-top: 1vw;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%] {\n  position: relative;\n  width: calc(25% - 0.75vw);\n  margin-left: 1vw;\n  margin-top: 1vw;\n  border-radius: 1vw;\n  border: 0.2vw var(--color2) solid;\n  overflow: hidden;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:first-child, \n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:nth-child(4n+1) {\n  margin-left: 0;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]    > .photos[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:nth-child(-n+5) {\n  margin-top: 0;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .collections[_ngcontent-%COMP%]    > .collection[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#presentation[_ngcontent-%COMP%]    > .gallery.active[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 0;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 5vw;\n  right: 5vw;\n  bottom: 7vw;\n  border: 0.5vw rgba(var(--color1Alt4-raw), 0.8) solid;\n  border-radius: 1vw;\n  background-color: var(--color1);\n  padding-bottom: 5vw;\n  overflow-x: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: transform 0.2s, opacity 0.2s;\n  -o-transition: transform 0.2s, opacity 0.2s;\n  -webkit-transition: transform 0.2s, opacity 0.2s;\n  transition: transform 0.2s, opacity 0.2s;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  background-color: rgba(var(--color1Alt4-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 1vw;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  height: 50vh;\n  position: relative;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 3vw;\n  font-weight: var(--ltweight);\n  color: var(--color2Alt4);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content.no-content[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 0;\n  display: inline-block;\n  vertical-align: top;\n  width: calc(20% - 2vw - 0.4vw);\n  margin-top: 2vw;\n  margin-left: 2vw;\n  cursor: pointer;\n  -moz-transition: filter 0.1s linear;\n  -o-transition: filter 0.1s linear;\n  -webkit-transition: filter 0.1s linear;\n  transition: filter 0.1s linear;\n  -webkit-filter: brightness(100%);\n  -moz-filter: brightness(100%);\n  -o-filter: brightness(100%);\n  -ms-filter: brightness(100%);\n  filter: brightness(100%);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  display: block;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  -moz-transition: transform 0.1s linear;\n  -o-transition: transform 0.1s linear;\n  -webkit-transition: transform 0.1s linear;\n  transition: transform 0.1s linear;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]:nth-of-type(5n+1) {\n  margin-left: 2vw;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]:nth-of-type(5n) {\n  margin-right: 2vw;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item.dragging[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  -moz-transform: scale(1.2);\n  -ms-transform: scale(1.2);\n  -o-transform: scale(1.2);\n  -webkit-transform: scale(1.2);\n  transform: scale(1.2);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item.dragging[_ngcontent-%COMP%] {\n  z-index: 1;\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item.hovering[_ngcontent-%COMP%] {\n  -webkit-filter: brightness(90%);\n  -moz-filter: brightness(90%);\n  -o-filter: brightness(90%);\n  -ms-filter: brightness(90%);\n  filter: brightness(90%);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item.dropping[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content[_ngcontent-%COMP%]    > .content-item.dropping[_ngcontent-%COMP%] {\n  -webkit-filter: brightness(50%);\n  -moz-filter: brightness(50%);\n  -o-filter: brightness(50%);\n  -ms-filter: brightness(50%);\n  filter: brightness(50%);\n}\n#presentation[_ngcontent-%COMP%]    > .additional-content.active[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=presentation.component.css.map */"] });
var PresentationComponent = _PresentationComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "presentation", template: '<section id="presentation" #componentElm>\n  <div class="bg"></div>\n  <nav id="presentationNav">\n    <div class="controls">\n      <button class="control"\n        [class.active]="viewingGallery"\n        (click)="toggleGallery()">\n        <i class="fa-solid fa-images"></i>\n      </button>\n      <button class="control"\n        [class.active]="viewingContent"\n        (click)="toggleContent()">\n        <i class="fa-solid fa-tv"></i>\n      </button>\n    </div>\n    <div class="price">\n      <span class="value">\n        {{targetPrice}}\n      </span>\n    </div>\n  </nav>\n\n  <div class="pages">\n    @for (page of pages; track page) {\n      @if (page.active) {\n        <page\n          [page]="page"\n        ></page>\n      }\n    }\n  </div>\n\n  <div class="gallery" [class.active]="viewingGallery">\n    <header>\n      <div class="primary">\n        <h3>Photos from Your Home</h3>\n      </div>\n\n      <div class="controls">\n        <button class="control" (click)="stopViewingGallery()">\n          <i class="fa-solid fa-xmark"></i>\n        </button>\n      </div>\n    </header>\n    <div class="collections">\n      @for (collection of photoCollections; track collection) {\n        <div class="collection">\n          <header>\n            <h3>{{collection.name}}</h3>\n          </header>\n          <div class="photos">\n            @for (photo of collection.photos; track photo) {\n              <div class="photo"\n                (click)="viewPhoto(photo)">\n                <canvas width="4" height="3"></canvas>\n                <img [src]="photo" />\n              </div>\n            }\n          </div>\n        </div>\n      }\n    </div>\n  </div>\n\n  <div class="additional-content"\n    [class.active]="viewingContent"\n    [class.no-content]="!hasContent">\n    <header>\n      <div class="primary">\n        <h3>More Great Content</h3>\n      </div>\n\n      <div class="controls">\n        <button class="control" (click)="stopViewingContent()">\n          <i class="fa-solid fa-xmark"></i>\n        </button>\n      </div>\n    </header>\n    @if (!hasContent) {\n      <div class="message">\n        <p>No presentation content.</p>\n      </div>\n    }\n    @for (contentItem of availableContent; track contentItem) {\n      <div class="content-item"\n        #contentItemElm\n        >\n        <content-thumb\n          [content]="contentItem"\n        (click)="viewContent(contentItem)"></content-thumb>\n      </div>\n    }\n  </div>\n</section>\n\n<nav id="mainNav">\n  <div class="island">\n    <div class="controls">\n      <button class="control" (click)="goPrev()">\n        <i class="fa-solid fa-arrow-left-long"></i>\n        <label>{{backLabel}}</label>\n      </button>\n      <button class="control success" [disabled]="!canGoForward" (click)="goNext()">\n        <i class="fa-solid fa-arrow-right-long"></i>\n        <label>{{forwardLabel}}</label>\n      </button>\n    </div>\n  </div>\n</nav>', styles: ["/* src/app/appointment/components/presentation/presentation.component.scss */\n@-webkit-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-moz-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-o-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-webkit-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-moz-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-o-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-webkit-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-moz-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-o-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-webkit-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-moz-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-o-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-webkit-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n#presentation {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color3Alt5);\n  overflow: hidden;\n}\n#presentation > .bg {\n  position: absolute;\n  top: -100%;\n  left: -100%;\n  right: -100%;\n  bottom: -100%;\n  background-image: url(/assets/images/logo.svg);\n  background-position: center center;\n  background-size: 15vw 10vw;\n  opacity: 0.3;\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n  -webkit-filter: grayscale(100%);\n  -moz-filter: grayscale(100%);\n  -o-filter: grayscale(100%);\n  -ms-filter: grayscale(100%);\n  filter: grayscale(100%);\n}\n#presentation > nav {\n  position: absolute;\n  top: auto;\n  left: 2vw;\n  right: 2vw;\n  bottom: 1vw;\n  z-index: 2;\n  display: flex;\n  align-items: center;\n}\n#presentation > nav > .controls {\n  display: flex;\n  align-items: center;\n}\n#presentation > nav > .controls > .control {\n  cursor: pointer;\n  margin-left: 1.5vw;\n  opacity: 0.6;\n  -moz-transition: opacity 0.2s, background-color 0.2s;\n  -o-transition: opacity 0.2s, background-color 0.2s;\n  -webkit-transition: opacity 0.2s, background-color 0.2s;\n  transition: opacity 0.2s, background-color 0.2s;\n}\n#presentation > nav > .controls > .control i {\n  font-size: 2vw;\n  color: var(--color2);\n}\n#presentation > nav > .controls > .control.active {\n  opacity: 1;\n}\n#presentation > nav > .controls > .control.active i {\n  color: var(--color4);\n}\n#presentation > nav > .price {\n  margin-left: 1.5vw;\n}\n#presentation > nav > .price > .value {\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n#presentation > .pages {\n  position: absolute;\n  z-index: 0;\n  top: calc(7vw + var(--systemOffset-top));\n  left: 0;\n  right: 0;\n  bottom: 10vh;\n  padding: 0 5vw;\n}\n#presentation > .pages > page {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 5vw;\n  right: 5vw;\n  bottom: 0;\n  border: 0.5vw var(--color2) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n  background-color: var(--color1);\n}\n#presentation > .gallery {\n  position: absolute;\n  z-index: 0;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 5vw;\n  right: 5vw;\n  bottom: 7vw;\n  border: 0.5vw rgba(var(--color1Alt4-raw), 0.8) solid;\n  border-radius: 1vw;\n  background-color: var(--color1);\n  overflow-x: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: transform 0.2s, opacity 0.2s;\n  -o-transition: transform 0.2s, opacity 0.2s;\n  -webkit-transition: transform 0.2s, opacity 0.2s;\n  transition: transform 0.2s, opacity 0.2s;\n}\n#presentation > .gallery > header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  background-color: rgba(var(--color1Alt4-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: 1vw;\n}\n#presentation > .gallery > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#presentation > .gallery > header > .controls > .control {\n  cursor: pointer;\n}\n#presentation > .gallery > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#presentation > .gallery > .collections {\n  margin-top: 1vw;\n  padding: 0 2vw 5vw;\n}\n#presentation > .gallery > .collections > .collection {\n  margin-top: 2vw;\n}\n#presentation > .gallery > .collections > .collection > header {\n  padding-bottom: 0.5vw;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#presentation > .gallery > .collections > .collection > header > h3 {\n  color: var(--color2Alt1);\n  font-weight: var(--stdweight);\n  font-size: 1.8vw;\n}\n#presentation > .gallery > .collections > .collection > .photos {\n  display: flex;\n  flex-wrap: wrap;\n  margin-top: 1vw;\n}\n#presentation > .gallery > .collections > .collection > .photos > .photo {\n  position: relative;\n  width: calc(25% - 0.75vw);\n  margin-left: 1vw;\n  margin-top: 1vw;\n  border-radius: 1vw;\n  border: 0.2vw var(--color2) solid;\n  overflow: hidden;\n}\n#presentation > .gallery > .collections > .collection > .photos > .photo > canvas {\n  width: 100%;\n}\n#presentation > .gallery > .collections > .collection > .photos > .photo img {\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#presentation > .gallery > .collections > .collection > .photos > .photo:first-child,\n#presentation > .gallery > .collections > .collection > .photos > .photo:nth-child(4n+1) {\n  margin-left: 0;\n}\n#presentation > .gallery > .collections > .collection > .photos > .photo:nth-child(-n+5) {\n  margin-top: 0;\n}\n#presentation > .gallery > .collections > .collection:first-child {\n  margin-top: 0;\n}\n#presentation > .gallery.active {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n#presentation > .additional-content {\n  position: absolute;\n  z-index: 0;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 5vw;\n  right: 5vw;\n  bottom: 7vw;\n  border: 0.5vw rgba(var(--color1Alt4-raw), 0.8) solid;\n  border-radius: 1vw;\n  background-color: var(--color1);\n  padding-bottom: 5vw;\n  overflow-x: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: transform 0.2s, opacity 0.2s;\n  -o-transition: transform 0.2s, opacity 0.2s;\n  -webkit-transition: transform 0.2s, opacity 0.2s;\n  transition: transform 0.2s, opacity 0.2s;\n}\n#presentation > .additional-content > header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  background-color: rgba(var(--color1Alt4-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 1vw;\n}\n#presentation > .additional-content > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#presentation > .additional-content > header > .controls > .control {\n  cursor: pointer;\n}\n#presentation > .additional-content > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#presentation > .additional-content > .message {\n  height: 50vh;\n  position: relative;\n}\n#presentation > .additional-content > .message > p {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 3vw;\n  font-weight: var(--ltweight);\n  color: var(--color2Alt4);\n}\n#presentation > .additional-content.no-content {\n  overflow: hidden;\n}\n#presentation > .additional-content > .content-item {\n  position: relative;\n  z-index: 0;\n  display: inline-block;\n  vertical-align: top;\n  width: calc(20% - 2vw - 0.4vw);\n  margin-top: 2vw;\n  margin-left: 2vw;\n  cursor: pointer;\n  -moz-transition: filter 0.1s linear;\n  -o-transition: filter 0.1s linear;\n  -webkit-transition: filter 0.1s linear;\n  transition: filter 0.1s linear;\n  -webkit-filter: brightness(100%);\n  -moz-filter: brightness(100%);\n  -o-filter: brightness(100%);\n  -ms-filter: brightness(100%);\n  filter: brightness(100%);\n}\n#presentation > .additional-content > .content-item > content-thumb {\n  display: block;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  -moz-transition: transform 0.1s linear;\n  -o-transition: transform 0.1s linear;\n  -webkit-transition: transform 0.1s linear;\n  transition: transform 0.1s linear;\n}\n#presentation > .additional-content > .content-item:nth-of-type(5n+1) {\n  margin-left: 2vw;\n}\n#presentation > .additional-content > .content-item:nth-of-type(5n) {\n  margin-right: 2vw;\n}\n#presentation > .additional-content > .content-item.dragging > content-thumb {\n  -moz-transform: scale(1.2);\n  -ms-transform: scale(1.2);\n  -o-transform: scale(1.2);\n  -webkit-transform: scale(1.2);\n  transform: scale(1.2);\n}\n#presentation > .additional-content > .content-item.dragging {\n  z-index: 1;\n}\n#presentation > .additional-content > .content-item.hovering {\n  -webkit-filter: brightness(90%);\n  -moz-filter: brightness(90%);\n  -o-filter: brightness(90%);\n  -ms-filter: brightness(90%);\n  filter: brightness(90%);\n}\n#presentation > .additional-content > .content-item.dropping > content-thumb {\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n}\n#presentation > .additional-content > .content-item.dropping {\n  -webkit-filter: brightness(50%);\n  -moz-filter: brightness(50%);\n  -o-filter: brightness(50%);\n  -ms-filter: brightness(50%);\n  filter: brightness(50%);\n}\n#presentation > .additional-content.active {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=presentation.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: ApiService }, { type: PresentationService }], { appointment: [{
    type: Input
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PresentationComponent, { className: "PresentationComponent" });
})();

// src/app/appointment/components/additional-considerations/additional-considerations.component.ts
var _c06 = ["componentElm"];
function AdditionalConsiderationsComponent_For_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 5);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const sku_r1 = ctx.$implicit;
    \u0275\u0275property("ngValue", sku_r1.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(sku_r1.name);
  }
}
function AdditionalConsiderationsComponent_For_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 5);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const sku_r2 = ctx.$implicit;
    \u0275\u0275property("ngValue", sku_r2.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(sku_r2.name);
  }
}
function AdditionalConsiderationsComponent_Conditional_19_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 11)(1, "currency-input", 17);
    \u0275\u0275listener("currencyOutput", function AdditionalConsiderationsComponent_Conditional_19_Template_currency_input_currencyOutput_1_listener($event) {
      \u0275\u0275restoreView(_r3);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.updateItemPrice($event));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("enabled", ctx_r3.canModifyAppointment)("currencyInput", ctx_r3.customSkuPrice);
  }
}
function AdditionalConsiderationsComponent_For_26_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6)(1, "label");
    \u0275\u0275text(2, "Description");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 20);
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const item_r7 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(item_r7.description);
  }
}
function AdditionalConsiderationsComponent_For_26_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 11)(1, "label");
    \u0275\u0275text(2, "Price");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "currency-input", 21);
    \u0275\u0275listener("currencyOutput", function AdditionalConsiderationsComponent_For_26_Conditional_15_Template_currency_input_currencyOutput_3_listener($event) {
      \u0275\u0275restoreView(_r8);
      const item_r7 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.updateItemPrice($event, item_r7));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const item_r7 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275property("currencyInput", item_r7.price);
  }
}
function AdditionalConsiderationsComponent_For_26_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 15)(1, "button", 13);
    \u0275\u0275listener("click", function AdditionalConsiderationsComponent_For_26_Template_button_click_1_listener() {
      const \u0275$index_51_r6 = \u0275\u0275restoreView(_r5).$index;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.removeItem(\u0275$index_51_r6));
    });
    \u0275\u0275element(2, "i", 18);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 19)(4, "div", 3)(5, "label");
    \u0275\u0275text(6, "Type");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "span", 20);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(9, AdditionalConsiderationsComponent_For_26_Conditional_9_Template, 5, 1, "div", 6);
    \u0275\u0275elementStart(10, "div", 9)(11, "label");
    \u0275\u0275text(12, "Quantity");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "span", 20);
    \u0275\u0275text(14);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(15, AdditionalConsiderationsComponent_For_26_Conditional_15_Template, 4, 1, "div", 11);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const item_r7 = ctx.$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r3.canRemoveConsideration);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", item_r7.name, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(item_r7.description != null && item_r7.description.length > 0 ? 9 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", item_r7.quantity, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r3.showPrice ? 15 : -1);
  }
}
function AdditionalConsiderationsComponent_Conditional_28_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 22);
    \u0275\u0275listener("click", function AdditionalConsiderationsComponent_Conditional_28_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.stopManagingConsiderations());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Save & Close");
    \u0275\u0275elementEnd()();
  }
}
function AdditionalConsiderationsComponent_Conditional_29_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 22);
    \u0275\u0275listener("click", function AdditionalConsiderationsComponent_Conditional_29_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.stopManagingConsiderations());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Close");
    \u0275\u0275elementEnd()();
  }
}
var _AdditionalConsiderationsComponent = class _AdditionalConsiderationsComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.availableDtsSkus = [];
    this.availableWriteInSkus = [];
    this.customSkuQuantity = 1;
    this.customSkuPriceUpdated = new Subject();
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get considerations() {
    return this.appointment?.price?.customItems ?? [];
  }
  get hasConsiderations() {
    return this.considerations.length > 0;
  }
  get canAddConsideration() {
    return this.customSkuId != null && this.customSkuQuantity != null && this.customSkuQuantity > 0 && this.canModifyAppointment;
  }
  get canRemoveConsideration() {
    return this.canModifyAppointment;
  }
  initAvailableDtsSkus() {
    this.availableDtsSkus = [];
    if (this.appointment != null) {
      this.appointment.availableSkus.forEach((sku) => {
        const category = sku.category.toLocaleLowerCase();
        if (category.toLocaleLowerCase() == "dts") {
          this.availableDtsSkus.push(sku);
        } else if (category == "write in") {
          this.availableWriteInSkus.push(sku);
        }
      });
    }
  }
  stopManagingConsiderations() {
    this.resetItem();
    this.localAppointmentService.stopManagingAdditionalConsiderations();
  }
  resetItem() {
    this.customSkuId = this.customSkuDescription = this.customSkuPrice = void 0;
    this.customSkuQuantity = 1;
    this.customSkuPriceUpdated.next(0);
  }
  removeItem(index) {
    if (this.appointment?.price != null) {
      this.appointment.price.customItems.splice(index, 1);
      this.appointment.changed$.next();
    }
  }
  addItem() {
    if (this.canAddConsideration && this.appointment?.price != null) {
      let sku = this.availableDtsSkus.find((x) => x.id == this.customSkuId);
      if (sku == null) {
        sku = this.availableWriteInSkus.find((x) => x.id == this.customSkuId);
      }
      if (sku != null) {
        const newItem = {
          entityId: sku.id,
          entity: void 0,
          skuId: sku.id,
          skuCategory: sku.category,
          name: sku.name,
          customerFacing: sku.customerFacing,
          isAttachment: sku.isAttachment,
          description: this.customSkuDescription ?? "",
          price: this.customSkuPrice,
          quantity: this.customSkuQuantity
        };
        this.appointment.price.customItems.push(newItem);
        this.appointment.changed$.next();
        this.resetItem();
      }
    }
  }
  get showPrice() {
    return this.localAppointmentService.showConsiderationPrices;
  }
  updateItemPrice(price, item = void 0) {
    if (price.amount != null) {
      if (item != null) {
        item.price = price.amount;
      } else {
        this.customSkuPrice = price.amount;
      }
    }
  }
  init() {
    this.initAvailableDtsSkus();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_AdditionalConsiderationsComponent.\u0275fac = function AdditionalConsiderationsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AdditionalConsiderationsComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_AdditionalConsiderationsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AdditionalConsiderationsComponent, selectors: [["additional-considerations"]], viewQuery: function AdditionalConsiderationsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c06, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 30, vars: 11, consts: [["id", "additionalConsiderations"], [1, "primary"], [1, "custom-line-item"], [1, "item"], [3, "ngModelChange", "ngModel", "disabled"], [3, "ngValue"], [1, "description"], ["type", "text", "placeholder", "Custom Description", 3, "ngModelChange", "disabled", "ngModel"], [1, "meta"], [1, "quantity"], ["type", "number", "placeholder", "Quantity", 3, "ngModelChange", "disabled", "ngModel"], [1, "price"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "considerations"], [1, "line-item"], [1, "control"], [3, "currencyOutput", "enabled", "currencyInput"], [1, "fa-solid", "fa-trash"], [1, "details"], [1, "value"], [3, "currencyOutput", "currencyInput"], [1, "control", 3, "click"]], template: function AdditionalConsiderationsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "header")(2, "div", 1)(3, "h3");
    \u0275\u0275text(4, "Additional Considerations");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 2)(6, "div", 3)(7, "select", 4);
    \u0275\u0275twoWayListener("ngModelChange", function AdditionalConsiderationsComponent_Template_select_ngModelChange_7_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.customSkuId, $event) || (ctx.customSkuId = $event);
      return $event;
    });
    \u0275\u0275elementStart(8, "option", 5);
    \u0275\u0275text(9, "-- Select Item");
    \u0275\u0275elementEnd();
    \u0275\u0275repeaterCreate(10, AdditionalConsiderationsComponent_For_11_Template, 2, 2, "option", 5, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275repeaterCreate(12, AdditionalConsiderationsComponent_For_13_Template, 2, 2, "option", 5, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(14, "div", 6)(15, "input", 7);
    \u0275\u0275twoWayListener("ngModelChange", function AdditionalConsiderationsComponent_Template_input_ngModelChange_15_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.customSkuDescription, $event) || (ctx.customSkuDescription = $event);
      return $event;
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "div", 8)(17, "div", 9)(18, "input", 10);
    \u0275\u0275twoWayListener("ngModelChange", function AdditionalConsiderationsComponent_Template_input_ngModelChange_18_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.customSkuQuantity, $event) || (ctx.customSkuQuantity = $event);
      return $event;
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(19, AdditionalConsiderationsComponent_Conditional_19_Template, 2, 2, "div", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(20, "div", 12)(21, "button", 13);
    \u0275\u0275listener("click", function AdditionalConsiderationsComponent_Template_button_click_21_listener() {
      return ctx.addItem();
    });
    \u0275\u0275elementStart(22, "label");
    \u0275\u0275text(23, "Add Consideration");
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(24, "div", 14);
    \u0275\u0275repeaterCreate(25, AdditionalConsiderationsComponent_For_26_Template, 16, 5, "div", 15, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(27, "div", 12);
    \u0275\u0275conditionalCreate(28, AdditionalConsiderationsComponent_Conditional_28_Template, 3, 0, "button", 16);
    \u0275\u0275conditionalCreate(29, AdditionalConsiderationsComponent_Conditional_29_Template, 3, 0, "button", 16);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275twoWayProperty("ngModel", ctx.customSkuId);
    \u0275\u0275property("disabled", !ctx.canModifyAppointment);
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", void 0);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.availableDtsSkus);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.availableWriteInSkus);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx.customSkuDescription);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx.customSkuQuantity);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showPrice ? 19 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canAddConsideration);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx.considerations);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.canModifyAppointment ? 28 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.canModifyAppointment ? 29 : -1);
  }
}, dependencies: [CurrencyInputComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, NumberValueAccessor, SelectControlValueAccessor, NgControlStatus, NgModel], styles: ["\n\n#additionalConsiderations[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]     input {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2);\n  border-radius: 0.5vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 0.5vw 1vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%] {\n  flex: 1;\n  margin-left: 0.5vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  margin-left: 0.5vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .quantity[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: var(--color3);\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  flex: 1;\n  width: 100%;\n  text-align: center;\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]    + label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .custom-line-item[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%] {\n  flex: 1;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  margin-left: 4vw;\n  display: flex;\n  align-items: flex-start;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .quantity[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .quantity[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .quantity[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.6vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:first-child, \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%]:first-child, \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .quantity[_ngcontent-%COMP%]:first-child, \n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .description[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .considerations[_ngcontent-%COMP%]    > .line-item[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--success);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=additional-considerations.component.css.map */"] });
var AdditionalConsiderationsComponent = _AdditionalConsiderationsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AdditionalConsiderationsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "additional-considerations", template: '<div id="additionalConsiderations">\n  <header>\n    <div class="primary">\n      <h3>Additional Considerations</h3>\n    </div>\n    <div class="custom-line-item">\n      <div class="item">\n        <select [(ngModel)]="customSkuId" [disabled]="!canModifyAppointment">\n          <option [ngValue]="undefined">-- Select Item</option>\n          @for (sku of availableDtsSkus; track sku) {\n            <option [ngValue]="sku.id">{{sku.name}}</option>\n          }\n          @for (sku of availableWriteInSkus; track sku) {\n            <option [ngValue]="sku.id">{{sku.name}}</option>\n          }\n        </select>\n      </div>\n      <div class="description">\n        <input type="text" [disabled]="!canModifyAppointment" placeholder="Custom Description" [(ngModel)]="customSkuDescription" />\n      </div>\n      <div class="meta">\n        <div class="quantity">\n          <input type="number" [disabled]="!canModifyAppointment" placeholder="Quantity" [(ngModel)]="customSkuQuantity" />\n        </div>\n        @if (showPrice) {\n          <div class="price">\n            <currency-input\n              [enabled]="canModifyAppointment"\n              [currencyInput]="customSkuPrice"\n            (currencyOutput)="updateItemPrice($event)"></currency-input>\n          </div>\n        }\n      </div>\n      <div class="controls">\n        <button class="control" [disabled]="!canAddConsideration" (click)="addItem()">\n          <label>Add Consideration</label>\n        </button>\n      </div>\n    </div>\n  </header>\n  <div class="considerations">\n    @for (item of considerations; track item; let i = $index) {\n      <div class="line-item">\n        <button class="control" [disabled]="!canRemoveConsideration" (click)="removeItem(i)">\n          <i class="fa-solid fa-trash"></i>\n        </button>\n        <div class="details">\n          <div class="item">\n            <label>Type</label>\n            <span class="value">\n              {{item.name}}\n            </span>\n          </div>\n          @if (item.description != null && item.description.length > 0) {\n            <div class="description">\n              <label>Description</label>\n              <span class="value">{{item.description}}</span>\n            </div>\n          }\n          <div class="quantity">\n            <label>Quantity</label>\n            <span class="value">\n              {{item.quantity}}\n            </span>\n          </div>\n          @if (showPrice) {\n            <div class="price">\n              <label>Price</label>\n              <currency-input [currencyInput]="item.price"\n              (currencyOutput)="updateItemPrice($event,item)"></currency-input>\n            </div>\n          }\n        </div>\n      </div>\n    }\n  </div>\n  <div class="controls">\n    @if (canModifyAppointment) {\n      <button class="control" (click)="stopManagingConsiderations()">\n        <label>Save & Close</label>\n      </button>\n    }\n    @if (!canModifyAppointment) {\n      <button class="control" (click)="stopManagingConsiderations()">\n        <label>Close</label>\n      </button>\n    }\n  </div>\n</div>', styles: ["/* src/app/appointment/components/additional-considerations/additional-considerations.component.scss */\n#additionalConsiderations {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n}\n#additionalConsiderations > header {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#additionalConsiderations > header > .primary {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#additionalConsiderations > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#additionalConsiderations > header > .custom-line-item {\n  padding: 0.5vw 1vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n}\n#additionalConsiderations > header > .custom-line-item input,\n#additionalConsiderations > header > .custom-line-item select,\n#additionalConsiderations > header > .custom-line-item ::ng-deep input {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2);\n  border-radius: 0.5vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 0.5vw 1vw;\n}\n#additionalConsiderations > header > .custom-line-item > .description {\n  flex: 1;\n  margin-left: 0.5vw;\n}\n#additionalConsiderations > header > .custom-line-item > .meta {\n  display: flex;\n  align-items: center;\n  margin-left: 0.5vw;\n}\n#additionalConsiderations > header > .custom-line-item > .meta > .quantity {\n  flex: 1;\n}\n#additionalConsiderations > header > .custom-line-item > .meta > .price {\n  margin-left: 0.5vw;\n}\n#additionalConsiderations > header > .custom-line-item > .controls {\n  margin-left: 0.5vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#additionalConsiderations > header > .custom-line-item > .controls > .control {\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: var(--color3);\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#additionalConsiderations > header > .custom-line-item > .controls > .control > label {\n  display: block;\n  flex: 1;\n  width: 100%;\n  text-align: center;\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n}\n#additionalConsiderations > header > .custom-line-item > .controls > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n#additionalConsiderations > header > .custom-line-item > .controls > .control > i + label {\n  margin-left: 0.5vw;\n}\n#additionalConsiderations > header > .custom-line-item > .controls > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#additionalConsiderations > header > .custom-line-item:first-child {\n  margin-top: 0;\n}\n#additionalConsiderations > .considerations {\n  flex: 1;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#additionalConsiderations > .considerations > .line-item {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#additionalConsiderations > .considerations > .line-item > .details {\n  margin-left: 4vw;\n  display: flex;\n  align-items: flex-start;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#additionalConsiderations > .considerations > .line-item > .details > .item,\n#additionalConsiderations > .considerations > .line-item > .details > .description,\n#additionalConsiderations > .considerations > .line-item > .details > .quantity,\n#additionalConsiderations > .considerations > .line-item > .details > .price {\n  margin-left: 1vw;\n}\n#additionalConsiderations > .considerations > .line-item > .details > .item label,\n#additionalConsiderations > .considerations > .line-item > .details > .description label,\n#additionalConsiderations > .considerations > .line-item > .details > .quantity label,\n#additionalConsiderations > .considerations > .line-item > .details > .price label {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#additionalConsiderations > .considerations > .line-item > .details > .item > .value,\n#additionalConsiderations > .considerations > .line-item > .details > .description > .value,\n#additionalConsiderations > .considerations > .line-item > .details > .quantity > .value,\n#additionalConsiderations > .considerations > .line-item > .details > .price > .value {\n  display: block;\n  font-size: 1.6vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#additionalConsiderations > .considerations > .line-item > .details > .item:first-child,\n#additionalConsiderations > .considerations > .line-item > .details > .description:first-child,\n#additionalConsiderations > .considerations > .line-item > .details > .quantity:first-child,\n#additionalConsiderations > .considerations > .line-item > .details > .price:first-child {\n  margin-left: 0;\n}\n#additionalConsiderations > .considerations > .line-item > .details > .description {\n  flex: 1;\n}\n#additionalConsiderations > .considerations > .line-item > .control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#additionalConsiderations > .considerations > .line-item > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#additionalConsiderations > .considerations > .line-item > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#additionalConsiderations > .considerations > .line-item:first-child {\n  margin-top: 0;\n}\n#additionalConsiderations > .controls {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#additionalConsiderations > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--success);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#additionalConsiderations > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#additionalConsiderations > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#additionalConsiderations > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=additional-considerations.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AdditionalConsiderationsComponent, { className: "AdditionalConsiderationsComponent" });
})();

// src/app/appointment/components/manage-photos/manage-photos.component.ts
var _c07 = ["componentElm"];
function ManagePhotosComponent_Conditional_9_For_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 15)(1, "button", 11);
    \u0275\u0275listener("click", function ManagePhotosComponent_Conditional_9_For_1_Template_button_click_1_listener() {
      const photo_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.deletePhoto(photo_r3));
    });
    \u0275\u0275element(2, "i", 16);
    \u0275\u0275elementEnd();
    \u0275\u0275element(3, "canvas", 8);
    \u0275\u0275elementStart(4, "img", 17);
    \u0275\u0275listener("click", function ManagePhotosComponent_Conditional_9_For_1_Template_img_click_4_listener() {
      const photo_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.viewPhoto(photo_r3));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const photo_r3 = ctx.$implicit;
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r3.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275property("src", photo_r3, \u0275\u0275sanitizeUrl);
  }
}
function ManagePhotosComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275repeaterCreate(0, ManagePhotosComponent_Conditional_9_For_1_Template, 5, 2, "div", 15, \u0275\u0275repeaterTrackByIdentity);
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275repeater(ctx_r3.photos);
  }
}
var _ManagePhotosComponent = class _ManagePhotosComponent {
  constructor(localAppointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.uiService = uiService;
    this.acceptFileTypes = "*.jpg,*.png,*.webp";
    this.acceptMimeTypes = ["image/jpeg", "image/jpg", "image/png", "image/webp"];
    this.photos = [];
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get title() {
    if (this.entity != null) {
      return `Manage ${this.entity.name} Photos`;
    } else {
      return "Manage Photos";
    }
  }
  get photosCount() {
    return this.photos.length;
  }
  get hasPhotos() {
    return this.photos.length > 0;
  }
  get viewingPhoto() {
    return this.localAppointmentService.viewingPhoto;
  }
  get photoSrc() {
    return this.localAppointmentService.photoSrc;
  }
  matchesMimeType(mimeType) {
    let i = this.acceptMimeTypes.length;
    while (i--) {
      const acceptMimeType = this.acceptMimeTypes[i];
      if (acceptMimeType == mimeType) {
        return true;
      }
    }
    return false;
  }
  setFile(deviceBlob, photos) {
    if (deviceBlob != null && this.matchesMimeType(deviceBlob.type)) {
      const url = URL.createObjectURL(deviceBlob);
      const srcImage = new Image();
      srcImage.onload = () => {
        URL.revokeObjectURL(url);
        const offscreenCanvas = document.createElement("canvas");
        const ctx = offscreenCanvas.getContext("2d");
        if (ctx != null) {
          const ratio = srcImage.width / 1024;
          let width = srcImage.width;
          let height = srcImage.height;
          if (ratio > 1) {
            width = 1024;
            height = Math.round(srcImage.height / ratio);
          }
          offscreenCanvas.width = width;
          offscreenCanvas.height = height;
          ctx.drawImage(srcImage, 0, 0, width, height);
          const base64Image = offscreenCanvas.toDataURL("image/jpeg");
          this.entity?.photos_B64.push(base64Image);
          this.initPhotos();
          if (this.appointment != null) {
            this.appointment.changed$.next();
          }
          this.initPhotos();
        }
      };
      srcImage.src = url;
    }
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.setFile(file, this.photos);
    } else {
      this.setFile(void 0, this.photos);
    }
  }
  selectMedia(fileInputElm) {
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  deletePhoto(src) {
    if (this.entity != null) {
      this.uiService.prompt("Delete Photo?", "Are you sure you want to delete this photo?", "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed && this.entity != null) {
            for (var i = 0, len = this.entity.photos.length; i < len; i++) {
              const photo = this.entity.photos[i];
              if (photo.src == src) {
                this.entity.photos.splice(i, 1);
                break;
              }
            }
            for (var i = 0, len = this.entity.photos_B64.length; i < len; i++) {
              const photo = this.entity.photos_B64[i];
              if (photo == src) {
                this.entity.photos_B64.splice(i, 1);
                break;
              }
            }
            this.initPhotos();
            this.appointment?.changed$.next();
          }
        }
      });
    }
  }
  viewPhoto(photo) {
    this.localAppointmentService.viewPhoto(photo);
  }
  stopViewingPhoto() {
    this.localAppointmentService.stopViewingPhoto();
  }
  storePhotoMeta() {
    if (this.activePhoto != null) {
      if (this.photoName != null) {
        this.activePhoto.name = this.photoName;
      }
      if (this.photoNotes != null) {
        this.activePhoto.notes = this.photoNotes;
      }
    }
  }
  initPhotos() {
    if (this.entity != null) {
      const photos = [];
      photos.push(...this.entity.photos_B64);
      this.entity.photos.forEach((photo) => {
        photos.push(photo.src);
      });
      this.photos = photos;
    }
  }
  closeView() {
    this.localAppointmentService.stopManagingPhotos();
  }
  init() {
    this.initPhotos();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_ManagePhotosComponent.\u0275fac = function ManagePhotosComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ManagePhotosComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(UiService));
};
_ManagePhotosComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ManagePhotosComponent, selectors: [["manage-photos"]], viewQuery: function ManagePhotosComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c07, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { entity: "entity", appointment: "appointment", route: "route" }, standalone: false, decls: 26, vars: 5, consts: [["photoElm", ""], ["id", "managePhotos"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-close"], [1, "gallery"], [1, "add-photo", 3, "click"], ["height", "3", "width", "4"], [1, "content"], [1, "fa-light", "fa-circle-plus"], [1, "control", 3, "click", "disabled"], [1, "fa-regular", "fa-camera"], [1, "control", "success", 3, "click"], ["type", "file", 3, "input", "accept"], [1, "photo"], [1, "fa-solid", "fa-trash-can"], [3, "click", "src"]], template: function ManagePhotosComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1)(1, "header")(2, "div", 2)(3, "h3");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 3)(6, "button", 4);
    \u0275\u0275listener("click", function ManagePhotosComponent_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275element(7, "i", 5);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 6);
    \u0275\u0275conditionalCreate(9, ManagePhotosComponent_Conditional_9_Template, 2, 0);
    \u0275\u0275elementStart(10, "button", 7);
    \u0275\u0275listener("click", function ManagePhotosComponent_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r5 = \u0275\u0275reference(25);
      return \u0275\u0275resetView(ctx.selectMedia(photoElm_r5));
    });
    \u0275\u0275element(11, "canvas", 8);
    \u0275\u0275elementStart(12, "div", 9);
    \u0275\u0275element(13, "i", 10);
    \u0275\u0275elementStart(14, "label");
    \u0275\u0275text(15, "Add Photo");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(16, "div", 3)(17, "button", 11);
    \u0275\u0275listener("click", function ManagePhotosComponent_Template_button_click_17_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r5 = \u0275\u0275reference(25);
      return \u0275\u0275resetView(ctx.selectMedia(photoElm_r5));
    });
    \u0275\u0275element(18, "i", 12);
    \u0275\u0275elementStart(19, "label");
    \u0275\u0275text(20, "Add Photo(s)");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(21, "button", 13);
    \u0275\u0275listener("click", function ManagePhotosComponent_Template_button_click_21_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275elementStart(22, "label");
    \u0275\u0275text(23, "Save & Close");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "input", 14, 0);
    \u0275\u0275listener("input", function ManagePhotosComponent_Template_input_input_24_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r5 = \u0275\u0275reference(25);
      return \u0275\u0275resetView(ctx.selectFile(photoElm_r5));
    });
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(ctx.title);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx.hasPhotos ? 9 : -1);
    \u0275\u0275advance(8);
    \u0275\u0275property("disabled", !ctx.canModifyAppointment);
    \u0275\u0275advance(7);
    \u0275\u0275property("accept", \u0275\u0275interpolate(ctx.acceptFileTypes));
  }
}, styles: ["\n\n#managePhotos[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n}\n#managePhotos[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  justify-content: space-between;\n}\n#managePhotos[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#managePhotos[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#managePhotos[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#managePhotos[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#managePhotos[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 2vw;\n  overflow-x: hidden;\n  background-color: var(--color2Alt1);\n  font-size: 0;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%], \n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: top;\n  font-size: initial;\n  width: calc(25% - 1.5vw);\n  margin-left: 2vw;\n  margin-top: 2vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  position: relative;\n  cursor: pointer;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%], \n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > img[_ngcontent-%COMP%], \n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]    > img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:nth-child(-n+4), \n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]:nth-child(-n+4) {\n  margin-top: 0;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:nth-child(4n+1), \n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]:nth-child(4n+1) {\n  margin-left: 0;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--color2);\n  overflow: hidden;\n  border-radius: 100%;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%] {\n  border: 0.1vw var(--color2Alt4) dashed;\n  background-color: var(--color2Alt2);\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 3vw;\n  color: var(--color1);\n}\n#managePhotos[_ngcontent-%COMP%]    > .gallery[_ngcontent-%COMP%]    > .add-photo[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.1vw;\n  color: var(--color1);\n  margin-top: 0.75vw;\n  text-transform: uppercase;\n  font-weight: var(--stdweight);\n  letter-spacing: 0.2vw;\n  margin-right: -0.2vw;\n  display: block;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  position: absolute;\n  visibility: hidden;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  margin-right: 0.5vw;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#managePhotos[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=manage-photos.component.css.map */"] });
var ManagePhotosComponent = _ManagePhotosComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ManagePhotosComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "manage-photos", template: '<section id="managePhotos">\n  <header>\n    <div class="primary">\n      <h3>{{title}}</h3>\n    </div>\n    <div class="controls">\n      <button class="control" (click)="closeView()">\n        <i class="fa-solid fa-close"></i>\n      </button>\n    </div>\n  </header>\n  <div class="gallery">\n    @if (hasPhotos) {\n      @for (photo of photos; track photo) {\n        <div class="photo">\n          <button class="control" [disabled]="!canModifyAppointment" (click)="deletePhoto(photo)">\n            <i class="fa-solid fa-trash-can"></i>\n          </button>\n          <canvas height="3" width="4"></canvas>\n          <img [src]="photo" (click)="viewPhoto(photo)" />\n        </div>\n      }\n    }\n    <button class="add-photo" (click)="selectMedia(photoElm)">\n      <canvas height="3" width="4"></canvas>\n      <div class="content">\n        <i class="fa-light fa-circle-plus"></i>\n        <label>Add Photo</label>\n      </div>\n    </button>\n  </div>\n  <div class="controls">\n    <button class="control" [disabled]="!canModifyAppointment" (click)="selectMedia(photoElm)">\n      <i class="fa-regular fa-camera"></i>\n      <label>Add Photo(s)</label>\n    </button>\n    <button class="control success" (click)="closeView()">\n      <label>Save & Close</label>\n    </button>\n    <input #photoElm (input)="selectFile(photoElm)" type="file" accept="{{acceptFileTypes}}" />\n  </div>\n</section>', styles: ["/* src/app/appointment/components/manage-photos/manage-photos.component.scss */\n#managePhotos {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n}\n#managePhotos > header {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  justify-content: space-between;\n}\n#managePhotos > header > .primary {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#managePhotos > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#managePhotos > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#managePhotos > header > .controls > .control {\n  background-color: var(--color2);\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#managePhotos > header > .controls > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#managePhotos > .gallery {\n  flex: 1;\n  padding: 2vw;\n  overflow-x: hidden;\n  background-color: var(--color2Alt1);\n  font-size: 0;\n}\n#managePhotos > .gallery > .photo,\n#managePhotos > .gallery > .add-photo {\n  display: inline-block;\n  vertical-align: top;\n  font-size: initial;\n  width: calc(25% - 1.5vw);\n  margin-left: 2vw;\n  margin-top: 2vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  position: relative;\n  cursor: pointer;\n}\n#managePhotos > .gallery > .photo > canvas,\n#managePhotos > .gallery > .add-photo > canvas {\n  width: 100%;\n}\n#managePhotos > .gallery > .photo > img,\n#managePhotos > .gallery > .add-photo > img {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#managePhotos > .gallery > .photo:nth-child(-n+4),\n#managePhotos > .gallery > .add-photo:nth-child(-n+4) {\n  margin-top: 0;\n}\n#managePhotos > .gallery > .photo:nth-child(4n+1),\n#managePhotos > .gallery > .add-photo:nth-child(4n+1) {\n  margin-left: 0;\n}\n#managePhotos > .gallery > .photo > .control {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--color2);\n  overflow: hidden;\n  border-radius: 100%;\n}\n#managePhotos > .gallery > .photo > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n}\n#managePhotos > .gallery > .add-photo {\n  border: 0.1vw var(--color2Alt4) dashed;\n  background-color: var(--color2Alt2);\n}\n#managePhotos > .gallery > .add-photo > .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n}\n#managePhotos > .gallery > .add-photo > .content > i {\n  font-size: 3vw;\n  color: var(--color1);\n}\n#managePhotos > .gallery > .add-photo > .content > label {\n  font-size: 1.1vw;\n  color: var(--color1);\n  margin-top: 0.75vw;\n  text-transform: uppercase;\n  font-weight: var(--stdweight);\n  letter-spacing: 0.2vw;\n  margin-right: -0.2vw;\n  display: block;\n}\n#managePhotos > .controls {\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#managePhotos > .controls > input {\n  position: absolute;\n  visibility: hidden;\n}\n#managePhotos > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#managePhotos > .controls > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n  margin-right: 0.5vw;\n}\n#managePhotos > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#managePhotos > .controls > .control.success {\n  background-color: var(--success);\n}\n#managePhotos > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#managePhotos > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=manage-photos.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: UiService }], { entity: [{
    type: Input,
    args: ["entity"]
  }], appointment: [{
    type: Input
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ManagePhotosComponent, { className: "ManagePhotosComponent" });
})();

// src/app/appointment/components/layout/layout.component.ts
var _c08 = ["componentElm"];
function AppointmentLayoutComponent_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 30)(1, "h2");
    \u0275\u0275text(2, " Read Only Mode ");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 31)(1, "h2");
    \u0275\u0275text(2, " Pending Submission ");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 32)(1, "h1");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r0.routeTitle, " ");
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_6_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 6);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_0_Conditional_6_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.promptToSendQuote());
    });
    \u0275\u0275element(1, "i", 42);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Send Quote");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_6_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 6);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_0_Conditional_6_Conditional_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.toggleLeaveAppointment());
    });
    \u0275\u0275element(1, "i", 43);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Leave Appointment");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275classProp("active", ctx_r0.leavingAppointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 5);
    \u0275\u0275conditionalCreate(1, AppointmentLayoutComponent_Conditional_0_Conditional_6_Conditional_1_Template, 4, 0, "button", 36);
    \u0275\u0275conditionalCreate(2, AppointmentLayoutComponent_Conditional_0_Conditional_6_Conditional_2_Template, 4, 2, "button", 37);
    \u0275\u0275elementStart(3, "button", 6);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_0_Conditional_6_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r2);
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.toggleAdditionalConsiderations());
    });
    \u0275\u0275elementStart(4, "span", 38)(5, "span", 39);
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "label");
    \u0275\u0275text(8, "Additional Considerations");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "button", 40);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_0_Conditional_6_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r2);
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.toggleNav());
    });
    \u0275\u0275element(10, "i", 41);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showQuoteControl ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showLeaveAppointmentControl ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r0.managingAdditionalConsiderations);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", ctx_r0.considerationCount, " ");
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "summary", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.summaryRoute == null ? null : ctx_r0.summaryRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.summaryRoute == null ? null : ctx_r0.summaryRoute.animating)("closing", ctx_r0.summaryRoute == null ? null : ctx_r0.summaryRoute.closing)("rendered", ctx_r0.summaryRoute == null ? null : ctx_r0.summaryRoute.rendered);
    \u0275\u0275property("route", ctx_r0.summaryRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "check-in", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.checkInRoute == null ? null : ctx_r0.checkInRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.checkInRoute == null ? null : ctx_r0.checkInRoute.animating)("closing", ctx_r0.checkInRoute == null ? null : ctx_r0.checkInRoute.closing)("rendered", ctx_r0.checkInRoute == null ? null : ctx_r0.checkInRoute.rendered);
    \u0275\u0275property("route", ctx_r0.checkInRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "customer-needs", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.needsRoute == null ? null : ctx_r0.needsRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.needsRoute == null ? null : ctx_r0.needsRoute.animating)("closing", ctx_r0.needsRoute == null ? null : ctx_r0.needsRoute.closing)("rendered", ctx_r0.needsRoute == null ? null : ctx_r0.needsRoute.rendered);
    \u0275\u0275property("route", ctx_r0.needsRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "appointment-inspection", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.inspectionRoute == null ? null : ctx_r0.inspectionRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.inspectionRoute == null ? null : ctx_r0.inspectionRoute.animating)("closing", ctx_r0.inspectionRoute == null ? null : ctx_r0.inspectionRoute.closing)("rendered", ctx_r0.inspectionRoute == null ? null : ctx_r0.inspectionRoute.rendered);
    \u0275\u0275property("route", ctx_r0.inspectionRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "presentation", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.animating)("closing", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.closing)("rendered", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.rendered);
    \u0275\u0275property("route", ctx_r0.presentationRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "job-summary", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.jobSummaryRoute == null ? null : ctx_r0.jobSummaryRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.jobSummaryRoute == null ? null : ctx_r0.jobSummaryRoute.animating)("closing", ctx_r0.jobSummaryRoute == null ? null : ctx_r0.jobSummaryRoute.closing)("rendered", ctx_r0.jobSummaryRoute == null ? null : ctx_r0.jobSummaryRoute.rendered);
    \u0275\u0275property("route", ctx_r0.jobSummaryRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "appointment-internal-pricing", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.pricingRoute == null ? null : ctx_r0.pricingRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.pricingRoute == null ? null : ctx_r0.pricingRoute.animating)("closing", ctx_r0.pricingRoute == null ? null : ctx_r0.pricingRoute.closing)("rendered", ctx_r0.pricingRoute == null ? null : ctx_r0.pricingRoute.rendered);
    \u0275\u0275property("route", ctx_r0.pricingRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "appointment-price-negotiation", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.negotiationRoute == null ? null : ctx_r0.negotiationRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.negotiationRoute == null ? null : ctx_r0.negotiationRoute.animating)("closing", ctx_r0.negotiationRoute == null ? null : ctx_r0.negotiationRoute.closing)("rendered", ctx_r0.negotiationRoute == null ? null : ctx_r0.negotiationRoute.rendered);
    \u0275\u0275property("route", ctx_r0.negotiationRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Conditional_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "appointment-completion", 44);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.animating)("closing", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.closing)("rendered", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.rendered);
    \u0275\u0275property("route", ctx_r0.completionRoute)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "main", 1, 0)(2, "header");
    \u0275\u0275conditionalCreate(3, AppointmentLayoutComponent_Conditional_0_Conditional_3_Template, 3, 0, "div", 30);
    \u0275\u0275conditionalCreate(4, AppointmentLayoutComponent_Conditional_0_Conditional_4_Template, 3, 0, "div", 31);
    \u0275\u0275conditionalCreate(5, AppointmentLayoutComponent_Conditional_0_Conditional_5_Template, 3, 1, "div", 32);
    \u0275\u0275conditionalCreate(6, AppointmentLayoutComponent_Conditional_0_Conditional_6_Template, 11, 5, "div", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "div", 33);
    \u0275\u0275conditionalCreate(8, AppointmentLayoutComponent_Conditional_0_Conditional_8_Template, 1, 11, "summary", 34);
    \u0275\u0275conditionalCreate(9, AppointmentLayoutComponent_Conditional_0_Conditional_9_Template, 1, 11, "check-in", 34);
    \u0275\u0275conditionalCreate(10, AppointmentLayoutComponent_Conditional_0_Conditional_10_Template, 1, 11, "customer-needs", 34);
    \u0275\u0275conditionalCreate(11, AppointmentLayoutComponent_Conditional_0_Conditional_11_Template, 1, 11, "appointment-inspection", 34);
    \u0275\u0275conditionalCreate(12, AppointmentLayoutComponent_Conditional_0_Conditional_12_Template, 1, 11, "presentation", 34);
    \u0275\u0275conditionalCreate(13, AppointmentLayoutComponent_Conditional_0_Conditional_13_Template, 1, 11, "job-summary", 34);
    \u0275\u0275conditionalCreate(14, AppointmentLayoutComponent_Conditional_0_Conditional_14_Template, 1, 11, "appointment-internal-pricing", 34);
    \u0275\u0275conditionalCreate(15, AppointmentLayoutComponent_Conditional_0_Conditional_15_Template, 1, 11, "appointment-price-negotiation", 34);
    \u0275\u0275conditionalCreate(16, AppointmentLayoutComponent_Conditional_0_Conditional_16_Template, 1, 11, "appointment-completion", 34);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(17, "div", 35);
    \u0275\u0275element(18, "loader");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275classProp("nav-active", ctx_r0.navActive);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showEditWarning ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showPendingWarning ? 4 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.routeTitle != null ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showMainNavControls ? 6 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r0.showSummaryRoute ? 8 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showCheckInRoute ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showNeedsRoute ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showInspectionRoute ? 11 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showPresentationRoute ? 12 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showJobSummaryRoute ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showPricingRoute ? 14 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showNegotiationRoute ? 15 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showCompletionRoute ? 16 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r0.showLoader);
  }
}
function AppointmentLayoutComponent_For_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 11);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const status_r5 = ctx.$implicit;
    \u0275\u0275property("ngValue", status_r5);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", status_r5.name, " ");
  }
}
function AppointmentLayoutComponent_Conditional_59_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 24);
    \u0275\u0275element(1, "img", 45);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r0.photoSrc, \u0275\u0275sanitizeUrl);
  }
}
function AppointmentLayoutComponent_Conditional_62_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "additional-considerations", 26);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_65_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "manage-photos", 28);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("entity", ctx_r0.managingPhotosEntity)("appointment", ctx_r0.appointment);
  }
}
function AppointmentLayoutComponent_Conditional_66_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "nav", 46)(1, "div", 47);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_div_click_1_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.closeNav());
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(2, "div", 48)(3, "div", 49);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_div_click_3_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.closeNav());
    });
    \u0275\u0275elementStart(4, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToSummary());
    });
    \u0275\u0275elementStart(5, "span", 51);
    \u0275\u0275element(6, "i", 52)(7, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Summary");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToCheckIn());
    });
    \u0275\u0275elementStart(11, "span", 51);
    \u0275\u0275element(12, "i", 52)(13, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "label");
    \u0275\u0275text(15, "Check-In");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_16_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToNeeds());
    });
    \u0275\u0275elementStart(17, "span", 51);
    \u0275\u0275element(18, "i", 52)(19, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(20, "label");
    \u0275\u0275text(21, "Needs Assessment");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(22, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_22_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToInspection());
    });
    \u0275\u0275elementStart(23, "span", 51);
    \u0275\u0275element(24, "i", 52)(25, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "label");
    \u0275\u0275text(27, "Inspection");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(28, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_28_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToPresentation());
    });
    \u0275\u0275elementStart(29, "span", 51);
    \u0275\u0275element(30, "i", 52)(31, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "label");
    \u0275\u0275text(33, "The Repipe Value");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(34, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_34_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToJobSummary());
    });
    \u0275\u0275elementStart(35, "span", 51);
    \u0275\u0275element(36, "i", 52)(37, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(38, "label");
    \u0275\u0275text(39, "Job Summary");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(40, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_40_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToPricing());
    });
    \u0275\u0275elementStart(41, "span", 51);
    \u0275\u0275element(42, "i", 52)(43, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(44, "label");
    \u0275\u0275text(45, "Calculated Price");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(46, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_46_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToNegotiation());
    });
    \u0275\u0275elementStart(47, "span", 51);
    \u0275\u0275element(48, "i", 52)(49, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(50, "label");
    \u0275\u0275text(51, "Price Finalization");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(52, "button", 50);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Conditional_66_Template_button_click_52_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToCompletion());
    });
    \u0275\u0275elementStart(53, "span", 51);
    \u0275\u0275element(54, "i", 52)(55, "i", 53);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(56, "label");
    \u0275\u0275text(57, "Completion");
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classProp("active", ctx_r0.navActive);
    \u0275\u0275advance(4);
    \u0275\u0275classProp("active", ctx_r0.summaryRoute == null ? null : ctx_r0.summaryRoute.active)("completed", ctx_r0.appointment.summaryCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToSummary);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.checkInRoute == null ? null : ctx_r0.checkInRoute.active)("completed", ctx_r0.appointment.checkInCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToCheckIn);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.needsRoute == null ? null : ctx_r0.needsRoute.active)("completed", ctx_r0.appointment.needsCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToNeeds);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.inspectionRoute == null ? null : ctx_r0.inspectionRoute.active)("completed", ctx_r0.appointment.inspectionCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToInspection);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.active)("completed", ctx_r0.appointment.presentationCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToPresentation);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.jobSummaryRoute == null ? null : ctx_r0.jobSummaryRoute.active)("completed", ctx_r0.appointment.jobSummaryCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToJobSummary);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.pricingRoute == null ? null : ctx_r0.pricingRoute.active)("completed", ctx_r0.appointment.pricingCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToPricing);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.negotiationRoute == null ? null : ctx_r0.negotiationRoute.active)("completed", ctx_r0.appointment.negotiationCompleted);
    \u0275\u0275property("disabled", !ctx_r0.canGoToNegotiation);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.active)("completed", ctx_r0.appointment.completed);
    \u0275\u0275property("disabled", !ctx_r0.canGoToCompletion);
  }
}
var _AppointmentLayoutComponent = class _AppointmentLayoutComponent {
  constructor(router, injector, authRefService, localAppointmentService, appointmentUiService, appointmentService, deviceRouteService, sideNavService, reminderService, uiService) {
    this.router = router;
    this.injector = injector;
    this.authRefService = authRefService;
    this.localAppointmentService = localAppointmentService;
    this.appointmentUiService = appointmentUiService;
    this.appointmentService = appointmentService;
    this.deviceRouteService = deviceRouteService;
    this.sideNavService = sideNavService;
    this.reminderService = reminderService;
    this.uiService = uiService;
    this.AppointmentRouteType = AppointmentRouteType;
    this.leavingAppointment = false;
    this.followUp = false;
    this.followUpToday = /* @__PURE__ */ new Date();
    this.followUpTimestamp = this.uiService.getDateAsString(this.followUpToday);
    this.minFollowUpDate = this.uiService.getDateAsString(this.followUpToday);
    this.AppointmentStatus = AppointmentStatus;
    this.appointmentId = "";
    this.navActive = false;
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  // #endregion
  calcPricing() {
    if (this.appointment != null) {
      this.appointment.calcPricing(true);
    }
  }
  // #region Authentication
  get activeUser() {
    return this.localAppointmentService.activeUser;
  }
  watchAuth() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.localAppointmentService.setActiveUser(user);
        if (user != null) {
          this.watchParentRoute();
        }
      }
    });
  }
  get routeService() {
    return this.localAppointmentService.routeService;
  }
  get routes() {
    return this.routeService.routes;
  }
  initRoutes() {
    setTimeout(() => {
      if (this.appointment != null && this.componentElm != null) {
        this.localAppointmentService.initRoutes(this.appointment, this.componentElm.nativeElement);
        this.routeSubscription = this.routeService.activeRoute.subscribe({
          next: (route) => {
            this.localAppointmentService.showQuoteControl = false;
            if (route != null) {
              this.routeTitle = void 0;
              switch (route.type) {
                case AppointmentRouteType.CheckIn:
                  {
                    this.routeTitle = "Check In";
                  }
                  break;
                case AppointmentRouteType.Needs:
                  {
                    this.routeTitle = "Needs Assessment";
                    if (this.canModifyAppointment) {
                      this.sideNavService.watchForAppointmentDispostionChange = true;
                    }
                  }
                  break;
                case AppointmentRouteType.Summary:
                  {
                  }
                  break;
                case AppointmentRouteType.Inspection:
                  {
                    this.routeTitle = "Inspection";
                    if (this.canModifyAppointment) {
                      this.sideNavService.watchForAppointmentDispostionChange = true;
                    }
                    this.loadInspection();
                  }
                  break;
                case AppointmentRouteType.JobSummary:
                  {
                    this.routeTitle = "Job Summary";
                    if (this.canModifyAppointment) {
                      this.sideNavService.watchForAppointmentDispostionChange = true;
                    }
                    this.loadJobSummary();
                  }
                  break;
                case AppointmentRouteType.Pricing:
                  {
                    this.routeTitle = "Pricing";
                    if (this.canModifyAppointment) {
                      this.sideNavService.watchForAppointmentDispostionChange = true;
                    }
                    this.loadPricing();
                  }
                  break;
                case AppointmentRouteType.Negotiation:
                  {
                    this.routeTitle = "Finalization";
                    if (this.canModifyAppointment) {
                      this.sideNavService.watchForAppointmentDispostionChange = true;
                    }
                    this.loadNegotiation();
                  }
                  break;
                case AppointmentRouteType.Completion:
                  {
                    this.routeTitle = "Completion";
                    if (this.canModifyAppointment) {
                      this.sideNavService.watchForAppointmentDispostionChange = true;
                    }
                    this.loadCompletion();
                  }
                  break;
              }
            }
          }
        });
      }
    }, 0);
  }
  // #endregion
  // #region Quoting
  get showQuoteControl() {
    return this.localAppointmentService.showQuoteControl && this.canGoToPricing;
  }
  promptToSendQuote() {
    if (this.appointment != null) {
      this.appointmentUiService.startSendingQuote(this.appointment);
    }
  }
  get dispositionStatuses() {
    return this.appointment?.availableDispositionStatuses ?? [];
  }
  get canLeaveAppointment() {
    return this.selectedDispositionStatus != null && (!this.followUp || this.followUpTimestamp != null);
  }
  get showLeaveAppointmentControl() {
    return this.localAppointmentService.canModifyAppointment;
  }
  toggleLeaveAppointment() {
    this.leavingAppointment = !this.leavingAppointment;
    if (this.leavingAppointment) {
      this.stopManagingAdditionalConsiderations();
    }
  }
  createDispositionReminder(status, note = "") {
    if (this.appointment?.jobId != null && this.appointment.assignedTo != null) {
      this.reminderService.createReminder(this.appointment.assignedTo, this.appointment.assignedTo, `Job ${this.appointment.jobId} - ${status.name}`, note, ReminderPriority.Critical, /* @__PURE__ */ new Date(), this.appointment.id, ReminderReferenceType.Appointment);
    }
  }
  leaveAppointment() {
    if (this.appointment != null && this.selectedDispositionStatus != null) {
      const dispositionStatus = {
        statusId: this.selectedDispositionStatus.id,
        name: this.selectedDispositionStatus.name,
        followUp: this.followUp,
        followUp_Utc: new Date(this.followUpTimestamp),
        note: this.followUpNote,
        created_Utc: /* @__PURE__ */ new Date(),
        lastUpdated_Utc: /* @__PURE__ */ new Date()
      };
      this.createDispositionReminder(dispositionStatus, this.followUpNote);
      this.appointment.dispositionStatus = dispositionStatus;
      this.appointment.status = AppointmentStatus.Dispositioned;
      this.updateAppointment(this.appointment, true);
      this.deviceRouteService.viewRouteByType("Dashboard", [], true);
    }
  }
  setFollowUp(followUp) {
    this.followUp = followUp;
  }
  setDispositionStatus() {
    if (this.selectedDispositionStatus != null) {
      this.followUp = this.selectedDispositionStatus.followUpByDefault;
      if (!this.followUp) {
        this.followUpTimestamp = this.uiService.getDateAsString(this.followUpToday);
      }
    } else {
      this.followUp = false;
      this.followUpNote = void 0;
      this.followUpTimestamp = this.uiService.getDateAsString(this.followUpToday);
    }
  }
  cancelLeavingAppointment() {
    this.leavingAppointment = false;
  }
  get showEditWarning() {
    return !this.canModifyAppointment;
  }
  get showPendingWarning() {
    return this.appointment != null && this.appointment.status == AppointmentStatus.PendingSubmission;
  }
  getAppointment(id) {
    this.appointmentId = id;
    this.appointmentService.getAppointment(id).subscribe({
      next: (appointment) => {
        if (appointment != null) {
          this.appointment = appointment;
          appointment.applyAttributeRules();
          appointment.checkProgression();
          this.initRoutes();
          this.openAppointment();
          if (this.activeUser != null) {
            if (this.activeUser.id == appointment.assignedTo?.id) {
              this.localAppointmentService.isAssignedUser = true;
              this.watchChanges(appointment);
            }
          }
          this.localAppointmentService.appointment = appointment;
        } else {
          setTimeout(() => {
            this.deviceRouteService.viewRouteByType("Dashboard", [], true);
          }, 1e3);
        }
      },
      error: () => {
        setTimeout(() => {
          this.deviceRouteService.viewRouteByType("Dashboard", [], true);
        }, 1e3);
      }
    });
  }
  openAppointment() {
    if (this.appointment != null) {
      this.sideNavService.storeAppointment(this.appointment, true);
    }
  }
  initAppointment(params) {
    const id = params[0];
    if (id != null) {
      if (id != this.appointmentId) {
        this.getAppointment(id);
      }
    } else {
      this.deviceRouteService.viewRouteByType("Dashboard", [], true);
    }
  }
  // #endregion
  // #region Additional Considerations
  get considerationCount() {
    if (this.appointment?.price != null) {
      return this.appointment.price.customItems.length;
    }
    return 0;
  }
  get managingAdditionalConsiderations() {
    return this.localAppointmentService.managingAdditionalConsiderations;
  }
  toggleAdditionalConsiderations() {
    if (this.managingAdditionalConsiderations) {
      this.stopManagingAdditionalConsiderations();
    } else {
      this.localAppointmentService.manageAdditionalConsiderations();
      this.cancelLeavingAppointment();
    }
  }
  stopManagingAdditionalConsiderations() {
    this.localAppointmentService.stopManagingAdditionalConsiderations();
  }
  // #endregion
  // #region Inspection
  get inspectionRoute() {
    return this.routes[AppointmentRouteType.Inspection];
  }
  get canGoToInspection() {
    return this.appointment != null && this.appointment.needsCompleted && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  get showInspectionRoute() {
    return this.inspectionRoute != null && this.inspectionRoute.active && this.appointment != null;
  }
  loadInspection() {
    if (!customElements.get("appointment-inspection")) {
      import("./chunk-GXCWRA47.js").then((mod) => mod.InspectionModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToInspection() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Inspection, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Job Summary
  get jobSummaryRoute() {
    return this.routes[AppointmentRouteType.JobSummary];
  }
  get canGoToJobSummary() {
    return this.appointment != null && this.canGoToPricing && this.appointment.presentationCompleted;
  }
  get showJobSummaryRoute() {
    return this.jobSummaryRoute != null && this.jobSummaryRoute.active && this.appointment != null;
  }
  loadJobSummary() {
    if (!customElements.get("job-summary")) {
      import("./chunk-EILHJLU5.js").then((mod) => mod.JobSummaryModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToJobSummary() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.JobSummary, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Summary
  get summaryRoute() {
    return this.routes[AppointmentRouteType.Summary];
  }
  get showSummaryRoute() {
    return this.summaryRoute != null && this.summaryRoute.active && this.appointment != null;
  }
  get canGoToSummary() {
    return this.appointment != null && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  goToSummary() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Summary, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region CheckIn
  get checkInRoute() {
    return this.routes[AppointmentRouteType.CheckIn];
  }
  get showCheckInRoute() {
    return this.checkInRoute != null && this.checkInRoute.active && this.appointment != null;
  }
  get canGoToCheckIn() {
    return this.appointment != null && this.appointment.summaryCompleted && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  goToCheckIn() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.CheckIn, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Needs
  get needsRoute() {
    return this.routes[AppointmentRouteType.Needs];
  }
  get canGoToNeeds() {
    return this.appointment != null && this.appointment.checkInCompleted && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  get showNeedsRoute() {
    return this.needsRoute != null && this.needsRoute.active && this.appointment != null;
  }
  goToNeeds() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Needs, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Presentation
  get presentationRoute() {
    return this.routes[AppointmentRouteType.Presentation];
  }
  get canGoToPresentation() {
    return this.appointment != null && this.appointment.inspectionCompleted && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  get showPresentationRoute() {
    return this.presentationRoute != null && this.presentationRoute.active && this.appointment != null;
  }
  goToPresentation() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Presentation, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Internal Pricing
  get pricingRoute() {
    return this.routes[AppointmentRouteType.Pricing];
  }
  get canGoToPricing() {
    return this.appointment != null && this.appointment.inspectionCompleted && this.appointment.price?.finalPrice != null && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  get showPricingRoute() {
    return this.pricingRoute != null && this.pricingRoute.active && this.appointment != null;
  }
  loadPricing() {
    if (!customElements.get("appointment-internal-pricing")) {
      import("./chunk-G3FWSKWZ.js").then((mod) => mod.InternalPricingModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToPricing() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Pricing, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Price Negotiation
  get negotiationRoute() {
    return this.routes[AppointmentRouteType.Negotiation];
  }
  get canGoToNegotiation() {
    return this.appointment != null && this.canGoToPricing && this.appointment.inspectionCompleted && this.appointment?.customPrice?.finalPrice != null && this.appointment.status != AppointmentStatus.PendingSubmission;
  }
  get showNegotiationRoute() {
    return this.negotiationRoute != null && this.negotiationRoute.active && this.appointment != null;
  }
  loadNegotiation() {
    if (!customElements.get("appointment-price-negotiation")) {
      import("./chunk-NUUOQBP4.js").then((mod) => mod.PriceNegotiationModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToNegotiation() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Negotiation, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Completion
  get completionRoute() {
    return this.routes[AppointmentRouteType.Completion];
  }
  get canGoToCompletion() {
    return this.canGoToNegotiation;
  }
  get showCompletionRoute() {
    return this.completionRoute != null && this.completionRoute.active && this.appointment != null;
  }
  loadCompletion() {
    if (!customElements.get("appointment-completion")) {
      import("./chunk-ZJJKPTIC.js").then((mod) => mod.CompletionModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToCompletion() {
    if (this.appointment != null) {
      this.routeService.viewRoute(AppointmentRouteType.Completion, RouteLoadDirection.Forward, true);
    }
  }
  get deviceRoute() {
    return this.deviceRouteService.routes["Appointment"];
  }
  watchParentRoute() {
    if (this.deviceRoute != null) {
      this.paramsSubscription = this.deviceRoute.params.subscribe({
        next: (params) => {
          this.initAppointment(params);
        }
      });
    }
  }
  watchChanges(appointment) {
    this.changeSubscription = appointment.changed$.subscribe({
      next: () => __async(this, null, function* () {
        this.updateAppointment(appointment);
      })
    });
    this.priceChangeSubscription = appointment.priceChanged$.subscribe({
      next: () => {
        if (this.appointment != null) {
          this.appointment.generatePaymentSetting();
          this.appointment.changed$.next();
        }
      }
    });
    this.customPriceChangeSubscription = appointment.customPriceChanged$.subscribe({
      next: () => {
        if (this.appointment != null) {
          this.appointment.generatePaymentSetting();
          this.appointment.changed$.next();
        }
      }
    });
  }
  updateAppointment(appointment, force = false) {
    if (this.canModifyAppointment || force) {
      if (appointment.status == AppointmentStatus.Open) {
        appointment.status = AppointmentStatus.InProgress;
      }
      appointment.updateAttributes();
      appointment.applyAttributeRules();
      appointment.renumberRooms();
      appointment.renumberFixtures();
      appointment.calcPricing();
      this.appointmentService.storeAppointment(appointment);
    }
  }
  // #endregion
  // #region Photos
  get viewingPhoto() {
    return this.localAppointmentService.viewingPhoto;
  }
  get photoSrc() {
    return this.localAppointmentService.photoSrc;
  }
  get otherPhotosCount() {
    if (this.appointment?.job != null) {
      const b64Count = this.appointment.job.photos_B64.length;
      const count = this.appointment.job.photos.length;
      return b64Count + count;
    }
    return 0;
  }
  stopViewingPhoto() {
    this.localAppointmentService.stopViewingPhoto();
  }
  // #endregion
  // #region Managin Photos
  get managingPhotos() {
    return this.localAppointmentService.managingPhotos;
  }
  get managingPhotosEntity() {
    return this.localAppointmentService.managingPhotosEntity;
  }
  get closingManagePhotos() {
    return this.localAppointmentService.closingManagePhotos;
  }
  get showMainNavControls() {
    return true;
  }
  closeNav() {
    this.navActive = false;
  }
  toggleNav() {
    this.navActive = !this.navActive;
    if (this.navActive) {
      this.cancelLeavingAppointment();
      this.stopManagingAdditionalConsiderations();
    }
  }
  // #endregion
  // #region UI
  get showLoader() {
    return false;
  }
  init() {
    this.watchAuth();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
    this.paramsSubscription?.unsubscribe();
    this.changeSubscription?.unsubscribe();
  }
};
_AppointmentLayoutComponent.\u0275fac = function AppointmentLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentLayoutComponent)(\u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(Injector), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentUiService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(SideNavService), \u0275\u0275directiveInject(ReminderService), \u0275\u0275directiveInject(UiService));
};
_AppointmentLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentLayoutComponent, selectors: [["ng-component"]], viewQuery: function AppointmentLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c08, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, standalone: false, decls: 67, vars: 27, consts: [["componentElm", ""], ["id", "appointmentLayout"], ["id", "leavingAppointment"], [1, "bg"], [1, "content"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "input-wrap"], [1, "input"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [1, "inputs"], [1, "option-wrap"], [1, "options"], [1, "option", 3, "click"], [1, "fa-regular", "fa-circle", "unchecked"], [1, "fa-solid", "fa-circle-check", "checked"], ["type", "datetime-local", 3, "ngModelChange", "ngModel", "min"], ["rows", "2", "maxlength", "128", 3, "ngModelChange", "ngModel"], [1, "control", "alternate", 3, "click"], [1, "control", 3, "click", "disabled"], ["id", "photoViewer"], [1, "fa-solid", "fa-close"], [1, "image"], ["id", "additionalConsiderations"], [3, "appointment"], ["id", "managePhotos"], [3, "entity", "appointment"], ["id", "routeNav", 3, "active"], [1, "warning"], [1, "warning", "alternate"], [1, "route"], [1, "routes"], [3, "class", "animate", "closing", "rendered", "route", "appointment"], [1, "loader"], [1, "control"], [1, "control", 3, "active"], [1, "indicator"], [1, "value"], [1, "nav-control", 3, "click"], [1, "fa-light", "fa-ellipsis-stroke-vertical"], [1, "fa-regular", "fa-file-contract"], [1, "fa-regular", "fa-person-walking-dashed-line-arrow-right"], [3, "route", "appointment"], [3, "src"], ["id", "routeNav"], [1, "bg", 3, "click"], [1, "island"], [1, "routes", 3, "click"], [1, "route", 3, "click", "disabled"], [1, "icon"], [1, "fa-regular", "fa-circle"], [1, "fa-solid", "fa-circle-check", "completed"]], template: function AppointmentLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, AppointmentLayoutComponent_Conditional_0_Template, 19, 17, "main", 1);
    \u0275\u0275elementStart(1, "aside", 2);
    \u0275\u0275element(2, "div", 3);
    \u0275\u0275elementStart(3, "div", 4)(4, "header")(5, "h2");
    \u0275\u0275text(6, "Leave Appointment?");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "div", 5)(8, "button", 6);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Template_button_click_8_listener() {
      return ctx.cancelLeavingAppointment();
    });
    \u0275\u0275element(9, "i", 7);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(10, "div", 4)(11, "div", 8)(12, "label");
    \u0275\u0275text(13, "Disposition Reason");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "div", 9)(15, "select", 10);
    \u0275\u0275twoWayListener("ngModelChange", function AppointmentLayoutComponent_Template_select_ngModelChange_15_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.selectedDispositionStatus, $event) || (ctx.selectedDispositionStatus = $event);
      return $event;
    });
    \u0275\u0275listener("change", function AppointmentLayoutComponent_Template_select_change_15_listener() {
      return ctx.setDispositionStatus();
    });
    \u0275\u0275elementStart(16, "option", 11);
    \u0275\u0275text(17, "-- Select a Disposition Reason");
    \u0275\u0275elementEnd();
    \u0275\u0275repeaterCreate(18, AppointmentLayoutComponent_For_19_Template, 2, 2, "option", 11, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(20, "div", 12)(21, "div", 13)(22, "label");
    \u0275\u0275text(23, " Follow Up? ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(24, "div", 14)(25, "button", 15);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Template_button_click_25_listener() {
      return ctx.setFollowUp(false);
    });
    \u0275\u0275element(26, "i", 16)(27, "i", 17);
    \u0275\u0275elementStart(28, "label");
    \u0275\u0275text(29, "No");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(30, "button", 15);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Template_button_click_30_listener() {
      return ctx.setFollowUp(true);
    });
    \u0275\u0275element(31, "i", 16)(32, "i", 17);
    \u0275\u0275elementStart(33, "label");
    \u0275\u0275text(34, " Yes ");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(35, "div", 8)(36, "label");
    \u0275\u0275text(37, "Follow Up Date & Time");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(38, "div", 9)(39, "input", 18);
    \u0275\u0275twoWayListener("ngModelChange", function AppointmentLayoutComponent_Template_input_ngModelChange_39_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.followUpTimestamp, $event) || (ctx.followUpTimestamp = $event);
      return $event;
    });
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(40, "div", 8)(41, "label");
    \u0275\u0275text(42, "Note");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(43, "div", 9)(44, "textarea", 19);
    \u0275\u0275twoWayListener("ngModelChange", function AppointmentLayoutComponent_Template_textarea_ngModelChange_44_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.followUpNote, $event) || (ctx.followUpNote = $event);
      return $event;
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(45, "div", 5)(46, "button", 20);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Template_button_click_46_listener() {
      return ctx.cancelLeavingAppointment();
    });
    \u0275\u0275elementStart(47, "label");
    \u0275\u0275text(48, "Return to Appointment");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(49, "button", 21);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Template_button_click_49_listener() {
      return ctx.leaveAppointment();
    });
    \u0275\u0275elementStart(50, "label");
    \u0275\u0275text(51, "Leave Appointment");
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(52, "aside", 22);
    \u0275\u0275element(53, "div", 3);
    \u0275\u0275elementStart(54, "div", 4)(55, "header")(56, "div", 5)(57, "button", 6);
    \u0275\u0275listener("click", function AppointmentLayoutComponent_Template_button_click_57_listener() {
      return ctx.stopViewingPhoto();
    });
    \u0275\u0275element(58, "i", 23);
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(59, AppointmentLayoutComponent_Conditional_59_Template, 2, 1, "div", 24);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(60, "aside", 25);
    \u0275\u0275element(61, "div", 3);
    \u0275\u0275conditionalCreate(62, AppointmentLayoutComponent_Conditional_62_Template, 1, 1, "additional-considerations", 26);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(63, "aside", 27);
    \u0275\u0275element(64, "div", 3);
    \u0275\u0275conditionalCreate(65, AppointmentLayoutComponent_Conditional_65_Template, 1, 2, "manage-photos", 28);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(66, AppointmentLayoutComponent_Conditional_66_Template, 58, 47, "nav", 29);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.appointment != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.leavingAppointment);
    \u0275\u0275advance(14);
    \u0275\u0275twoWayProperty("ngModel", ctx.selectedDispositionStatus);
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", void 0);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.dispositionStatuses);
    \u0275\u0275advance(7);
    \u0275\u0275classProp("active", !ctx.followUp);
    \u0275\u0275advance(5);
    \u0275\u0275classProp("active", ctx.followUp);
    \u0275\u0275advance(5);
    \u0275\u0275classProp("active", ctx.followUp);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx.followUpTimestamp);
    \u0275\u0275property("min", ctx.minFollowUpDate);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.followUpNote);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx.canLeaveAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx.viewingPhoto);
    \u0275\u0275advance(7);
    \u0275\u0275conditional(ctx.photoSrc != null ? 59 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.managingAdditionalConsiderations);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.appointment != null ? 62 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.managingPhotos)("closing", ctx.closingManagePhotos);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.managingPhotos ? 65 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.appointment != null ? 66 : -1);
  }
}, dependencies: [LoaderComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, MaxLengthValidator, NgModel, SummaryComponent, CheckInComponent, CustomerNeedsComponent, PresentationComponent, AdditionalConsiderationsComponent, ManagePhotosComponent], styles: ['\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#appointmentLayout[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  --navLayer: calc(var(--sideNav-layer) + 10);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: calc(var(--navLayer) + 1);\n  top: calc(1.1vw + var(--systemOffset-top));\n  right: 1vw;\n  display: flex;\n  align-items: center;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  margin-right: 1vw;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%] {\n  margin-right: 1vw;\n  border-radius: 999px;\n  background-color: rgba(var(--yellow-raw), 0.8);\n  border: 0.1vw var(--warningAlt4) solid;\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 0.5vw 2vw;\n  pointer-events: none;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  text-transform: uppercase;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .warning.alternate[_ngcontent-%COMP%] {\n  background-color: rgba(var(--successAlt2-raw), 0.8);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  display: flex;\n  align-items: center;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n  -o-transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n  -webkit-transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n  transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  -moz-transition: color 0.1s linear;\n  -o-transition: color 0.1s linear;\n  -webkit-transition: color 0.1s linear;\n  transition: color 0.1s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%] {\n  height: 1.4vw;\n  width: 1.4vw;\n  border: 0.1vw var(--color1) solid;\n  border-radius: 100%;\n  position: relative;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transition: color 0.1s linear;\n  -o-transition: color 0.1s linear;\n  -webkit-transition: color 0.1s linear;\n  transition: color 0.1s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%], \n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%] {\n  border-color: var(--color2);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%] {\n  height: 3.5vw;\n  width: 3.5vw;\n  border-radius: 100%;\n  position: relative;\n  cursor: pointer;\n  display: block;\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: translateX(0) translateY(0);\n  -ms-transform: translateX(0) translateY(0);\n  -o-transform: translateX(0) translateY(0);\n  -webkit-transform: translateX(0) translateY(0);\n  transform: translateX(0) translateY(0);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control.active[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header.nav-active[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header.nav-active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  background-color: transparent;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header.nav-active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > header.nav-active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  -ms-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  -o-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  -webkit-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  will-change: transform;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10;\n  background-color: rgba(var(--color1-raw), 0.2);\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#appointmentLayout[_ngcontent-%COMP%]    > .loader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#leavingAppointment[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 11;\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 35vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  -moz-transform: translate(-50%, -50%) scale(0.8);\n  -ms-transform: translate(-50%, -50%) scale(0.8);\n  -o-transform: translate(-50%, -50%) scale(0.8);\n  -webkit-transform: translate(-50%, -50%) scale(0.8);\n  transform: translate(-50%, -50%) scale(0.8);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0 1vw 1vw;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]:first-child, \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%] {\n  margin-top: 0.75vw;\n  display: flex;\n  align-items: center;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  display: inline-block;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%]    > i.checked[_ngcontent-%COMP%] {\n  display: none;\n  color: var(--success);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  margin-left: 0.5vw;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option.active[_ngcontent-%COMP%]    > i.unchecked[_ngcontent-%COMP%] {\n  display: none;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option.active[_ngcontent-%COMP%]    > i.checked[_ngcontent-%COMP%] {\n  display: inline-block;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]    > .options[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%], \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%] {\n  margin-top: 0;\n  margin-left: 1vw;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%]:first-child, \n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%]   .option-wrap[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%]   .input-wrap[_ngcontent-%COMP%] {\n  flex: 1;\n  opacity: 0;\n  pointer-events: none;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .inputs[_ngcontent-%COMP%]   .input-wrap.active[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#leavingAppointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#leavingAppointment.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#leavingAppointment.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#leavingAppointment.active[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: translate(-50%, -50%) scale(1);\n  -ms-transform: translate(-50%, -50%) scale(1);\n  -o-transform: translate(-50%, -50%) scale(1);\n  -webkit-transform: translate(-50%, -50%) scale(1);\n  transform: translate(-50%, -50%) scale(1);\n}\n#routeNav[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) - 1);\n  background-color: rgba(var(--color1-raw), 0.7);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: fixed;\n  z-index: var(--sideNav-layer);\n  top: calc(1.5vw + var(--systemOffset-top));\n  right: 2vw;\n  background-color: var(--color2);\n  padding: 3vw 0 1vw;\n  border-radius: 999px;\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transform-origin: top right;\n  -ms-transform-origin: top right;\n  -o-transform-origin: top right;\n  -webkit-transform-origin: top right;\n  transform-origin: top right;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%] {\n  display: flex;\n  padding: 1vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  cursor: pointer;\n  position: relative;\n  margin-top: 1vw;\n  display: flex;\n  width: 100%;\n  align-items: center;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  height: 4.2vw;\n  width: 4.2vw;\n  background-color: var(--color2);\n  border-radius: 100%;\n  -moz-transition: border-color 0.2s, background-color 0.2s;\n  -o-transition: border-color 0.2s, background-color 0.2s;\n  -webkit-transition: border-color 0.2s, background-color 0.2s;\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  color: var(--color1Alt1);\n  font-size: 2vw;\n  display: block;\n  -moz-transition: color 0.2s;\n  -o-transition: color 0.2s;\n  -webkit-transition: color 0.2s;\n  transition: color 0.2s;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i.completed[_ngcontent-%COMP%] {\n  display: none;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  right: 100%;\n  margin-right: 2vw;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color2);\n  white-space: nowrap;\n  display: block;\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n  -moz-transform: scale(0) translateY(-50%);\n  -ms-transform: scale(0) translateY(-50%);\n  -o-transform: scale(0) translateY(-50%);\n  -webkit-transform: scale(0) translateY(-50%);\n  transform: scale(0) translateY(-50%);\n  -moz-transform-origin: right center;\n  -ms-transform-origin: right center;\n  -o-transform-origin: right center;\n  -webkit-transform-origin: right center;\n  transform-origin: right center;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.active[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.active[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--color3Alt1);\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.completed[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:not(.completed) {\n  display: none;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.completed[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i.completed[_ngcontent-%COMP%] {\n  display: block;\n  color: var(--success);\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[disabled][_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--color2Alt4);\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[disabled][_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2Alt4);\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#routeNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]:first-child {\n  border-top: none;\n}\n#routeNav.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#routeNav.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  -moz-transform: translateX(2.75vw) translateY(1vw);\n  -ms-transform: translateX(2.75vw) translateY(1vw);\n  -o-transform: translateX(2.75vw) translateY(1vw);\n  -webkit-transform: translateX(2.75vw) translateY(1vw);\n  transform: translateX(2.75vw) translateY(1vw);\n}\n#routeNav.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]:before {\n  background-color: var(--color2);\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n#routeNav.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%] {\n  -moz-transform: translate(-50%, -50%) translateX(25%);\n  -ms-transform: translate(-50%, -50%) translateX(25%);\n  -o-transform: translate(-50%, -50%) translateX(25%);\n  -webkit-transform: translate(-50%, -50%) translateX(25%);\n  transform: translate(-50%, -50%) translateX(25%);\n}\n#routeNav.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(1) {\n  -moz-transform: rotate(45deg);\n  -ms-transform: rotate(45deg);\n  -o-transform: rotate(45deg);\n  -webkit-transform: rotate(45deg);\n  transform: rotate(45deg);\n}\n#routeNav.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(2) {\n  opacity: 0;\n}\n#routeNav.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(3) {\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n}\n#routeNav.active[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#routeNav.active[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  -moz-transform: scale(1) translateY(-50%);\n  -ms-transform: scale(1) translateY(-50%);\n  -o-transform: scale(1) translateY(-50%);\n  -webkit-transform: scale(1) translateY(-50%);\n  transform: scale(1) translateY(-50%);\n  -moz-transition: transform 0.5s 0.3s;\n  -o-transition: transform 0.5s 0.3s;\n  -webkit-transition: transform 0.5s 0.3s;\n  transition: transform 0.5s 0.3s;\n}\n#photoViewer[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#photoViewer[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 10);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: fixed;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 7vw;\n  z-index: calc(var(--sideNav-layer) + 11);\n  opacity: 0;\n  -moz-transform: scale(0.5);\n  -ms-transform: scale(0.5);\n  -o-transform: scale(0.5);\n  -webkit-transform: scale(0.5);\n  transform: scale(0.5);\n  pointer-events: none;\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  -moz-transform-origin: center center;\n  -ms-transform-origin: center center;\n  -o-transform-origin: center center;\n  -webkit-transform-origin: center center;\n  transform-origin: center center;\n  background-color: var(--color1);\n  border: 1vw var(--color2) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  z-index: 1;\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  text-align: center;\n  position: relative;\n  z-index: 0;\n}\n#photoViewer[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#photoViewer.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#photoViewer.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#photoViewer.active[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n@-webkit-keyframes _ngcontent-%COMP%_otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#managePhotos[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#managePhotos[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#managePhotos[_ngcontent-%COMP%]    > manage-photos[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 10vh;\n  left: 10vw;\n  right: 10vw;\n  bottom: 10vh;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 8);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: otherPhotosLoadIn;\n  -ms-animation-name: otherPhotosLoadIn;\n  -o-animation-name: otherPhotosLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_otherPhotosLoadIn;\n  animation-name: _ngcontent-%COMP%_otherPhotosLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#managePhotos.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#managePhotos.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#managePhotos.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#managePhotos.closing[_ngcontent-%COMP%]    > manage-photos[_ngcontent-%COMP%] {\n  -moz-animation-name: otherPhotosLoadOut;\n  -ms-animation-name: otherPhotosLoadOut;\n  -o-animation-name: otherPhotosLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_otherPhotosLoadOut;\n  animation-name: _ngcontent-%COMP%_otherPhotosLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#additionalConsiderations[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: var(--sideNav-layer);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#additionalConsiderations[_ngcontent-%COMP%]    > additional-considerations[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 70vw;\n  height: 60vh;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#additionalConsiderations.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#additionalConsiderations.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#additionalConsiderations.active[_ngcontent-%COMP%]    > additional-considerations[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=layout.component.css.map */'] });
var AppointmentLayoutComponent = _AppointmentLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '@if (appointment != null) {\n  <main id="appointmentLayout" #componentElm>\n    <header [class.nav-active]="navActive">\n      @if (showEditWarning) {\n        <div class="warning">\n          <h2>\n            Read Only Mode\n          </h2>\n        </div>\n      }\n      @if (showPendingWarning) {\n        <div class="warning alternate">\n          <h2>\n            Pending Submission\n          </h2>\n        </div>\n      }\n      @if (routeTitle != null) {\n        <div class="route">\n          <h1>\n            {{routeTitle}}\n          </h1>\n        </div>\n      }\n      @if (showMainNavControls) {\n        <div class="controls">\n          @if (showQuoteControl) {\n            <button class="control"\n              (click)="promptToSendQuote()">\n              <i class="fa-regular fa-file-contract"></i>\n              <label>Send Quote</label>\n            </button>\n          }\n          @if (showLeaveAppointmentControl) {\n            <button class="control"\n              [class.active]="leavingAppointment"\n              (click)="toggleLeaveAppointment()">\n              <i class="fa-regular fa-person-walking-dashed-line-arrow-right"></i>\n              <label>Leave Appointment</label>\n            </button>\n          }\n          <button class="control"\n            [class.active]="managingAdditionalConsiderations"\n            (click)="toggleAdditionalConsiderations()">\n            <span class="indicator">\n              <span class="value">\n                {{considerationCount}}\n              </span>\n            </span>\n            <label>Additional Considerations</label>\n          </button>\n          <button class="nav-control" (click)="toggleNav()">\n            <i class="fa-light fa-ellipsis-stroke-vertical"></i>\n          </button>\n        </div>\n      }\n    </header>\n    <div class="routes">\n      @if (showSummaryRoute) {\n        <summary class="route {{summaryRoute?.loadDirection}}"\n          [class.animate]="summaryRoute?.animating"\n          [class.closing]="summaryRoute?.closing"\n          [class.rendered]="summaryRoute?.rendered"\n          [route]="summaryRoute"\n        [appointment]="appointment"></summary>\n      }\n      @if (showCheckInRoute) {\n        <check-in class="route {{checkInRoute?.loadDirection}}"\n          [class.animate]="checkInRoute?.animating"\n          [class.closing]="checkInRoute?.closing"\n          [class.rendered]="checkInRoute?.rendered"\n          [route]="checkInRoute"\n        [appointment]="appointment"></check-in>\n      }\n      @if (showNeedsRoute) {\n        <customer-needs class="route {{needsRoute?.loadDirection}}"\n          [class.animate]="needsRoute?.animating"\n          [class.closing]="needsRoute?.closing"\n          [class.rendered]="needsRoute?.rendered"\n          [route]="needsRoute"\n        [appointment]="appointment"></customer-needs>\n      }\n      @if (showInspectionRoute) {\n        <appointment-inspection\n          class="route {{inspectionRoute?.loadDirection}}"\n          [class.animate]="inspectionRoute?.animating"\n          [class.closing]="inspectionRoute?.closing"\n          [class.rendered]="inspectionRoute?.rendered"\n          [route]="inspectionRoute"\n        [appointment]="appointment"></appointment-inspection>\n      }\n      @if (showPresentationRoute) {\n        <presentation class="route {{presentationRoute?.loadDirection}}"\n          [class.animate]="presentationRoute?.animating"\n          [class.closing]="presentationRoute?.closing"\n          [class.rendered]="presentationRoute?.rendered"\n          [route]="presentationRoute"\n          [appointment]="appointment">\n        </presentation>\n      }\n      @if (showJobSummaryRoute) {\n        <job-summary class="route {{jobSummaryRoute?.loadDirection}}"\n          [class.animate]="jobSummaryRoute?.animating"\n          [class.closing]="jobSummaryRoute?.closing"\n          [class.rendered]="jobSummaryRoute?.rendered"\n          [route]="jobSummaryRoute"\n          [appointment]="appointment">\n        </job-summary>\n      }\n      @if (showPricingRoute) {\n        <appointment-internal-pricing class="route {{pricingRoute?.loadDirection}}"\n          [class.animate]="pricingRoute?.animating"\n          [class.closing]="pricingRoute?.closing"\n          [class.rendered]="pricingRoute?.rendered"\n          [route]="pricingRoute"\n          [appointment]="appointment">\n        </appointment-internal-pricing>\n      }\n      @if (showNegotiationRoute) {\n        <appointment-price-negotiation class="route {{negotiationRoute?.loadDirection}}"\n          [class.animate]="negotiationRoute?.animating"\n          [class.closing]="negotiationRoute?.closing"\n          [class.rendered]="negotiationRoute?.rendered"\n          [route]="negotiationRoute"\n          [appointment]="appointment">\n        </appointment-price-negotiation>\n      }\n      @if (showCompletionRoute) {\n        <appointment-completion class="route {{completionRoute?.loadDirection}}"\n          [class.animate]="completionRoute?.animating"\n          [class.closing]="completionRoute?.closing"\n          [class.rendered]="completionRoute?.rendered"\n          [route]="completionRoute"\n          [appointment]="appointment">\n        </appointment-completion>\n      }\n    </div>\n    <div class="loader" [class.active]="showLoader">\n      <loader></loader>\n    </div>\n  </main>\n}\n\n<aside id="leavingAppointment" [class.active]="leavingAppointment">\n  <div class="bg"></div>\n  <div class="content">\n    <header>\n      <h2>Leave Appointment?</h2>\n      <div class="controls">\n        <button class="control" (click)="cancelLeavingAppointment()">\n          <i class="fa-solid fa-xmark"></i>\n        </button>\n      </div>\n    </header>\n    <div class="content">\n      <div class="input-wrap">\n        <label>Disposition Reason</label>\n        <div class="input">\n          <select [(ngModel)]="selectedDispositionStatus" (change)="setDispositionStatus()">\n            <option [ngValue]="undefined">-- Select a Disposition Reason</option>\n            @for (status of dispositionStatuses; track status) {\n              <option [ngValue]="status">\n                {{status.name}}\n              </option>\n            }\n          </select>\n        </div>\n      </div>\n      <div class="inputs">\n        <div class="option-wrap">\n          <label>\n            Follow Up?\n          </label>\n          <div class="options">\n            <button class="option" (click)="setFollowUp(false)" [class.active]="!followUp">\n              <i class="fa-regular fa-circle unchecked"></i>\n              <i class="fa-solid fa-circle-check checked"></i>\n              <label>No</label>\n            </button>\n            <button class="option" (click)="setFollowUp(true)" [class.active]="followUp">\n              <i class="fa-regular fa-circle unchecked"></i>\n              <i class="fa-solid fa-circle-check checked"></i>\n              <label>\n                Yes\n              </label>\n            </button>\n          </div>\n        </div>\n        <div class="input-wrap" [class.active]="followUp">\n          <label>Follow Up Date & Time</label>\n          <div class="input">\n            <input [(ngModel)]="followUpTimestamp" [min]="minFollowUpDate" type="datetime-local" />\n          </div>\n        </div>\n      </div>\n      <div class="input-wrap">\n        <label>Note</label>\n        <div class="input">\n          <textarea rows="2" maxlength="128" [(ngModel)]="followUpNote"></textarea>\n        </div>\n      </div>\n      <div class="controls">\n        <button class="control alternate" (click)="cancelLeavingAppointment()">\n          <label>Return to Appointment</label>\n        </button>\n        <button class="control" [disabled]="!canLeaveAppointment" (click)="leaveAppointment()">\n          <label>Leave Appointment</label>\n        </button>\n      </div>\n    </div>\n  </div>\n</aside>\n\n<aside id="photoViewer" [class.active]="viewingPhoto">\n  <div class="bg"></div>\n\n  <div class="content">\n    <header>\n      <div class="controls">\n        <button class="control" (click)="stopViewingPhoto()">\n          <i class="fa-solid fa-close"></i>\n        </button>\n      </div>\n    </header>\n    @if (photoSrc != null) {\n      <div class="image">\n        <img [src]="photoSrc" />\n      </div>\n    }\n  </div>\n</aside>\n\n<aside id="additionalConsiderations" [class.active]="managingAdditionalConsiderations">\n  <div class="bg"></div>\n  @if (appointment != null) {\n    <additional-considerations\n    [appointment]="appointment"></additional-considerations>\n  }\n</aside>\n\n<aside id="managePhotos" [class.active]="managingPhotos" [class.closing]="closingManagePhotos">\n  <div class="bg"></div>\n  @if (managingPhotos) {\n    <manage-photos\n      [entity]="managingPhotosEntity"\n    [appointment]="appointment"></manage-photos>\n  }\n</aside>\n\n@if (appointment != null) {\n  <nav id="routeNav" [class.active]="navActive">\n    <div class="bg" (click)="closeNav()"></div>\n    <div class="island">\n      <div class="routes" (click)="closeNav()">\n        <button class="route"\n          [class.active]="summaryRoute?.active"\n          [class.completed]="appointment.summaryCompleted"\n          [disabled]="!canGoToSummary"\n          (click)="goToSummary()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Summary</label>\n        </button>\n        <button class="route"\n          [class.active]="checkInRoute?.active"\n          [class.completed]="appointment.checkInCompleted"\n          [disabled]="!canGoToCheckIn"\n          (click)="goToCheckIn()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Check-In</label>\n        </button>\n        <button class="route"\n          [class.active]="needsRoute?.active"\n          [class.completed]="appointment.needsCompleted"\n          [disabled]="!canGoToNeeds"\n          (click)="goToNeeds()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Needs Assessment</label>\n        </button>\n        <button class="route"\n          [class.active]="inspectionRoute?.active"\n          [class.completed]="appointment.inspectionCompleted"\n          [disabled]="!canGoToInspection"\n          (click)="goToInspection()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Inspection</label>\n        </button>\n        <button class="route"\n          [class.active]="presentationRoute?.active"\n          [class.completed]="appointment.presentationCompleted"\n          [disabled]="!canGoToPresentation"\n          (click)="goToPresentation()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>The Repipe Value</label>\n        </button>\n        <button class="route"\n          [class.active]="jobSummaryRoute?.active"\n          [class.completed]="appointment.jobSummaryCompleted"\n          [disabled]="!canGoToJobSummary"\n          (click)="goToJobSummary()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Job Summary</label>\n        </button>\n        <button class="route"\n          [class.active]="pricingRoute?.active"\n          [disabled]="!canGoToPricing"\n          [class.completed]="appointment.pricingCompleted"\n          (click)="goToPricing()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Calculated Price</label>\n        </button>\n        <button class="route"\n          [class.active]="negotiationRoute?.active"\n          [disabled]="!canGoToNegotiation"\n          [class.completed]="appointment.negotiationCompleted"\n          (click)="goToNegotiation()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Price Finalization</label>\n        </button>\n        <button class="route"\n          [class.active]="completionRoute?.active"\n          [disabled]="!canGoToCompletion"\n          [class.completed]="appointment.completed"\n          (click)="goToCompletion()">\n          <span class="icon">\n            <i class="fa-regular fa-circle"></i>\n            <i class="fa-solid fa-circle-check completed"></i>\n          </span>\n          <label>Completion</label>\n        </button>\n      </div>\n    </div>\n  </nav>\n}', styles: ['/* src/app/appointment/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#appointmentLayout {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  --navLayer: calc(var(--sideNav-layer) + 10);\n}\n#appointmentLayout > header {\n  position: absolute;\n  z-index: calc(var(--navLayer) + 1);\n  top: calc(1.1vw + var(--systemOffset-top));\n  right: 1vw;\n  display: flex;\n  align-items: center;\n}\n#appointmentLayout > header > .route {\n  margin-right: 1vw;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentLayout > header > .route h1 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#appointmentLayout > header > .warning {\n  margin-right: 1vw;\n  border-radius: 999px;\n  background-color: rgba(var(--yellow-raw), 0.8);\n  border: 0.1vw var(--warningAlt4) solid;\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 0.5vw 2vw;\n  pointer-events: none;\n}\n#appointmentLayout > header > .warning > h2 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  text-transform: uppercase;\n}\n#appointmentLayout > header > .warning.alternate {\n  background-color: rgba(var(--successAlt2-raw), 0.8);\n}\n#appointmentLayout > header > .controls {\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  display: flex;\n  align-items: center;\n}\n#appointmentLayout > header > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n  -o-transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n  -webkit-transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n  transition:\n    opacity 0.1s,\n    background-color 0.1s,\n    border-color 0.1s;\n}\n#appointmentLayout > header > .controls > .control > i,\n#appointmentLayout > header > .controls > .control > label {\n  -moz-transition: color 0.1s linear;\n  -o-transition: color 0.1s linear;\n  -webkit-transition: color 0.1s linear;\n  transition: color 0.1s linear;\n}\n#appointmentLayout > header > .controls > .control > i:last-child,\n#appointmentLayout > header > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#appointmentLayout > header > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#appointmentLayout > header > .controls > .control > .indicator {\n  height: 1.4vw;\n  width: 1.4vw;\n  border: 0.1vw var(--color1) solid;\n  border-radius: 100%;\n  position: relative;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#appointmentLayout > header > .controls > .control > .indicator > .value {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transition: color 0.1s linear;\n  -o-transition: color 0.1s linear;\n  -webkit-transition: color 0.1s linear;\n  transition: color 0.1s linear;\n}\n#appointmentLayout > header > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentLayout > header > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentLayout > header > .controls > .control.active {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n#appointmentLayout > header > .controls > .control.active > label,\n#appointmentLayout > header > .controls > .control.active > i {\n  color: var(--color2);\n}\n#appointmentLayout > header > .controls > .control.active > .indicator {\n  border-color: var(--color2);\n}\n#appointmentLayout > header > .controls > .control.active > .indicator > .value {\n  color: var(--color2);\n}\n#appointmentLayout > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#appointmentLayout > header > .controls > .nav-control {\n  height: 3.5vw;\n  width: 3.5vw;\n  border-radius: 100%;\n  position: relative;\n  cursor: pointer;\n  display: block;\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: translateX(0) translateY(0);\n  -ms-transform: translateX(0) translateY(0);\n  -o-transform: translateX(0) translateY(0);\n  -webkit-transform: translateX(0) translateY(0);\n  transform: translateX(0) translateY(0);\n}\n#appointmentLayout > header > .controls > .nav-control i {\n  font-size: 1.6vw;\n  color: var(--color1);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n#appointmentLayout > header > .controls > .nav-control.active i {\n  color: var(--color3);\n}\n#appointmentLayout > header.nav-active > .route {\n  opacity: 0;\n}\n#appointmentLayout > header.nav-active > .controls {\n  background-color: transparent;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentLayout > header.nav-active > .controls > .control {\n  opacity: 0;\n  pointer-events: none;\n}\n#appointmentLayout > header.nav-active > .controls > .nav-control {\n  opacity: 1;\n  -moz-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  -ms-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  -o-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  -webkit-transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n  transform: translateX(-1.5vw) translateY(1vw) rotate(90deg);\n}\n#appointmentLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  will-change: transform;\n}\n#appointmentLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#appointmentLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentLayout > .routes > .route:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10;\n  background-color: rgba(var(--color1-raw), 0.2);\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#appointmentLayout > .loader {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentLayout > .loader > loader {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#appointmentLayout > .loader.active {\n  opacity: 1;\n}\n#leavingAppointment {\n  pointer-events: none;\n}\n#leavingAppointment > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 11;\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#leavingAppointment > .content {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 35vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  -moz-transform: translate(-50%, -50%) scale(0.8);\n  -ms-transform: translate(-50%, -50%) scale(0.8);\n  -o-transform: translate(-50%, -50%) scale(0.8);\n  -webkit-transform: translate(-50%, -50%) scale(0.8);\n  transform: translate(-50%, -50%) scale(0.8);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n}\n#leavingAppointment > .content > header {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#leavingAppointment > .content > header h2 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#leavingAppointment > .content > header > .controls > .control {\n  cursor: pointer;\n}\n#leavingAppointment > .content > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#leavingAppointment > .content > .content {\n  padding: 0 1vw 1vw;\n}\n#leavingAppointment > .content > .content .input-wrap,\n#leavingAppointment > .content > .content .option-wrap {\n  margin-top: 1vw;\n}\n#leavingAppointment > .content > .content .input-wrap > label,\n#leavingAppointment > .content > .content .option-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#leavingAppointment > .content > .content .input-wrap > .input,\n#leavingAppointment > .content > .content .option-wrap > .input {\n  margin-top: 0.5vw;\n}\n#leavingAppointment > .content > .content .input-wrap > .input select,\n#leavingAppointment > .content > .content .input-wrap > .input input,\n#leavingAppointment > .content > .content .input-wrap > .input textarea,\n#leavingAppointment > .content > .content .option-wrap > .input select,\n#leavingAppointment > .content > .content .option-wrap > .input input,\n#leavingAppointment > .content > .content .option-wrap > .input textarea {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#leavingAppointment > .content > .content .input-wrap:first-child,\n#leavingAppointment > .content > .content .option-wrap:first-child {\n  margin-top: 0;\n}\n#leavingAppointment > .content > .content .option-wrap > .options {\n  margin-top: 0.75vw;\n  display: flex;\n  align-items: center;\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option > i {\n  font-size: 2vw;\n  color: var(--color1);\n  display: inline-block;\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option > i.checked {\n  display: none;\n  color: var(--success);\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option > label {\n  font-size: 1.4vw;\n  color: var(--color1);\n  margin-left: 0.5vw;\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option.active > i.unchecked {\n  display: none;\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option.active > i.checked {\n  display: inline-block;\n}\n#leavingAppointment > .content > .content .option-wrap > .options > .option:first-child {\n  margin-left: 0;\n}\n#leavingAppointment > .content > .content > .inputs {\n  margin-top: 1vw;\n  display: flex;\n}\n#leavingAppointment > .content > .content > .inputs .input-wrap,\n#leavingAppointment > .content > .content > .inputs .option-wrap {\n  margin-top: 0;\n  margin-left: 1vw;\n}\n#leavingAppointment > .content > .content > .inputs .input-wrap:first-child,\n#leavingAppointment > .content > .content > .inputs .option-wrap:first-child {\n  margin-left: 0;\n}\n#leavingAppointment > .content > .content > .inputs .input-wrap {\n  flex: 1;\n  opacity: 0;\n  pointer-events: none;\n}\n#leavingAppointment > .content > .content > .inputs .input-wrap.active {\n  opacity: 1;\n  pointer-events: initial;\n}\n#leavingAppointment > .content > .content > .controls {\n  margin-top: 2vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#leavingAppointment > .content > .content > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#leavingAppointment > .content > .content > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#leavingAppointment > .content > .content > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#leavingAppointment > .content > .content > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#leavingAppointment > .content > .content > .controls > .control.success {\n  background-color: var(--success);\n}\n#leavingAppointment > .content > .content > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#leavingAppointment > .content > .content > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#leavingAppointment > .content > .content > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#leavingAppointment > .content > .content > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#leavingAppointment > .content > .content > .controls > .control:first-child {\n  margin-left: 0;\n}\n#leavingAppointment.active {\n  pointer-events: initial;\n}\n#leavingAppointment.active > .bg {\n  opacity: 1;\n}\n#leavingAppointment.active > .content {\n  opacity: 1;\n  -moz-transform: translate(-50%, -50%) scale(1);\n  -ms-transform: translate(-50%, -50%) scale(1);\n  -o-transform: translate(-50%, -50%) scale(1);\n  -webkit-transform: translate(-50%, -50%) scale(1);\n  transform: translate(-50%, -50%) scale(1);\n}\n#routeNav > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) - 1);\n  background-color: rgba(var(--color1-raw), 0.7);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#routeNav > .island {\n  position: fixed;\n  z-index: var(--sideNav-layer);\n  top: calc(1.5vw + var(--systemOffset-top));\n  right: 2vw;\n  background-color: var(--color2);\n  padding: 3vw 0 1vw;\n  border-radius: 999px;\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transform-origin: top right;\n  -ms-transform-origin: top right;\n  -o-transform-origin: top right;\n  -webkit-transform-origin: top right;\n  transform-origin: top right;\n}\n#routeNav > .island > .routes {\n  display: flex;\n  padding: 1vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#routeNav > .island > .routes > .route {\n  cursor: pointer;\n  position: relative;\n  margin-top: 1vw;\n  display: flex;\n  width: 100%;\n  align-items: center;\n}\n#routeNav > .island > .routes > .route > .icon {\n  display: block;\n  position: relative;\n  height: 4.2vw;\n  width: 4.2vw;\n  background-color: var(--color2);\n  border-radius: 100%;\n  -moz-transition: border-color 0.2s, background-color 0.2s;\n  -o-transition: border-color 0.2s, background-color 0.2s;\n  -webkit-transition: border-color 0.2s, background-color 0.2s;\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#routeNav > .island > .routes > .route > .icon i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  color: var(--color1Alt1);\n  font-size: 2vw;\n  display: block;\n  -moz-transition: color 0.2s;\n  -o-transition: color 0.2s;\n  -webkit-transition: color 0.2s;\n  transition: color 0.2s;\n}\n#routeNav > .island > .routes > .route > .icon i.completed {\n  display: none;\n}\n#routeNav > .island > .routes > .route > label {\n  position: absolute;\n  top: 50%;\n  right: 100%;\n  margin-right: 2vw;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color2);\n  white-space: nowrap;\n  display: block;\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n  -moz-transform: scale(0) translateY(-50%);\n  -ms-transform: scale(0) translateY(-50%);\n  -o-transform: scale(0) translateY(-50%);\n  -webkit-transform: scale(0) translateY(-50%);\n  transform: scale(0) translateY(-50%);\n  -moz-transform-origin: right center;\n  -ms-transform-origin: right center;\n  -o-transform-origin: right center;\n  -webkit-transform-origin: right center;\n  transform-origin: right center;\n}\n#routeNav > .island > .routes > .route.active > .icon {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n#routeNav > .island > .routes > .route.active > .icon > i {\n  color: var(--color3Alt1);\n}\n#routeNav > .island > .routes > .route.completed > .icon > i:not(.completed) {\n  display: none;\n}\n#routeNav > .island > .routes > .route.completed > .icon > i.completed {\n  display: block;\n  color: var(--success);\n}\n#routeNav > .island > .routes > .route[disabled] > .icon > i {\n  color: var(--color2Alt4);\n}\n#routeNav > .island > .routes > .route[disabled] > label {\n  color: var(--color2Alt4);\n}\n#routeNav > .island > .routes > .route:first-child {\n  margin-top: 0;\n}\n#routeNav > .island > .routes:first-child {\n  border-top: none;\n}\n#routeNav.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#routeNav.active > .control {\n  -moz-transform: translateX(2.75vw) translateY(1vw);\n  -ms-transform: translateX(2.75vw) translateY(1vw);\n  -o-transform: translateX(2.75vw) translateY(1vw);\n  -webkit-transform: translateX(2.75vw) translateY(1vw);\n  transform: translateX(2.75vw) translateY(1vw);\n}\n#routeNav.active > .control > .icon:before {\n  background-color: var(--color2);\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n#routeNav.active > .control > .icon > .bars {\n  -moz-transform: translate(-50%, -50%) translateX(25%);\n  -ms-transform: translate(-50%, -50%) translateX(25%);\n  -o-transform: translate(-50%, -50%) translateX(25%);\n  -webkit-transform: translate(-50%, -50%) translateX(25%);\n  transform: translate(-50%, -50%) translateX(25%);\n}\n#routeNav.active > .control > .icon > .bars > .bar:nth-child(1) {\n  -moz-transform: rotate(45deg);\n  -ms-transform: rotate(45deg);\n  -o-transform: rotate(45deg);\n  -webkit-transform: rotate(45deg);\n  transform: rotate(45deg);\n}\n#routeNav.active > .control > .icon > .bars > .bar:nth-child(2) {\n  opacity: 0;\n}\n#routeNav.active > .control > .icon > .bars > .bar:nth-child(3) {\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n}\n#routeNav.active > .island {\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#routeNav.active > .island > .routes > .route > label {\n  -moz-transform: scale(1) translateY(-50%);\n  -ms-transform: scale(1) translateY(-50%);\n  -o-transform: scale(1) translateY(-50%);\n  -webkit-transform: scale(1) translateY(-50%);\n  transform: scale(1) translateY(-50%);\n  -moz-transition: transform 0.5s 0.3s;\n  -o-transition: transform 0.5s 0.3s;\n  -webkit-transition: transform 0.5s 0.3s;\n  transition: transform 0.5s 0.3s;\n}\n#photoViewer {\n  pointer-events: none;\n}\n#photoViewer > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 10);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#photoViewer > .content {\n  position: fixed;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 7vw;\n  z-index: calc(var(--sideNav-layer) + 11);\n  opacity: 0;\n  -moz-transform: scale(0.5);\n  -ms-transform: scale(0.5);\n  -o-transform: scale(0.5);\n  -webkit-transform: scale(0.5);\n  transform: scale(0.5);\n  pointer-events: none;\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  -moz-transform-origin: center center;\n  -ms-transform-origin: center center;\n  -o-transform-origin: center center;\n  -webkit-transform-origin: center center;\n  transform-origin: center center;\n  background-color: var(--color1);\n  border: 1vw var(--color2) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#photoViewer > .content > header {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  z-index: 1;\n}\n#photoViewer > .content > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#photoViewer > .content > header > .controls > .control {\n  background-color: var(--color2);\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#photoViewer > .content > header > .controls > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#photoViewer > .content > .image {\n  width: 100%;\n  height: 100%;\n  text-align: center;\n  position: relative;\n  z-index: 0;\n}\n#photoViewer > .content > .image img {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#photoViewer.active {\n  pointer-events: initial;\n}\n#photoViewer.active > .bg {\n  opacity: 1;\n}\n#photoViewer.active > .content {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n@-webkit-keyframes otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes otherPhotosLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes otherPhotosLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#managePhotos {\n  pointer-events: none;\n}\n#managePhotos > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#managePhotos > manage-photos {\n  display: block;\n  position: fixed;\n  top: 10vh;\n  left: 10vw;\n  right: 10vw;\n  bottom: 10vh;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 8);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: otherPhotosLoadIn;\n  -ms-animation-name: otherPhotosLoadIn;\n  -o-animation-name: otherPhotosLoadIn;\n  -webkit-animation-name: otherPhotosLoadIn;\n  animation-name: otherPhotosLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#managePhotos.active {\n  pointer-events: initial;\n}\n#managePhotos.active > .bg {\n  opacity: 1;\n}\n#managePhotos.closing > .bg {\n  opacity: 0;\n}\n#managePhotos.closing > manage-photos {\n  -moz-animation-name: otherPhotosLoadOut;\n  -ms-animation-name: otherPhotosLoadOut;\n  -o-animation-name: otherPhotosLoadOut;\n  -webkit-animation-name: otherPhotosLoadOut;\n  animation-name: otherPhotosLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#additionalConsiderations {\n  pointer-events: none;\n}\n#additionalConsiderations > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: var(--sideNav-layer);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#additionalConsiderations > additional-considerations {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 70vw;\n  height: 60vh;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#additionalConsiderations.active {\n  pointer-events: initial;\n}\n#additionalConsiderations.active > .bg {\n  opacity: 1;\n}\n#additionalConsiderations.active > additional-considerations {\n  opacity: 1;\n}\n/*# sourceMappingURL=layout.component.css.map */\n'] }]
  }], () => [{ type: Router }, { type: Injector }, { type: AuthRefService }, { type: LocalAppointmentService }, { type: AppointmentUiService }, { type: AppointmentService }, { type: DeviceRouteService }, { type: SideNavService }, { type: ReminderService }, { type: UiService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AppointmentLayoutComponent, { className: "AppointmentLayoutComponent" });
})();

// src/app/appointment/appointment.module.ts
var _AppointmentModule = class _AppointmentModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(AppointmentLayoutComponent, { injector: this.injector });
    customElements.define("global-appointment", el);
  }
};
_AppointmentModule.\u0275fac = function AppointmentModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentModule)(\u0275\u0275inject(Injector));
};
_AppointmentModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _AppointmentModule });
_AppointmentModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  LocalAppointmentService,
  InternalRouteService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var AppointmentModule = _AppointmentModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentModule, [{
    type: NgModule,
    args: [{
      declarations: [
        AppointmentLayoutComponent,
        SummaryComponent,
        CheckInComponent,
        CustomerNeedsComponent,
        PresentationComponent,
        PresentationPageComponent,
        ContentThumbComponent,
        AdditionalConsiderationsComponent,
        ManagePhotosComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        LocalAppointmentService,
        InternalRouteService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  AppointmentModule
};
//# sourceMappingURL=chunk-GXE2EOZM.js.map
