import {
  SystemService
} from "./chunk-NX4GNOJ2.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  BehaviorSubject,
  HttpClient,
  Injectable,
  Subject,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/appointments/services/appointment-ui.service.ts
var _AppointmentUiService = class _AppointmentUiService {
  constructor(http, systemService, uiService) {
    this.http = http;
    this.systemService = systemService;
    this.uiService = uiService;
    this.sendingForQuote = new BehaviorSubject(void 0);
    this.stoppedSendingForQuote = new Subject();
    this.sendingExecutedDocuments = new BehaviorSubject(void 0);
    this.stoppedSendingExecutedDocuments = new Subject();
    this.documentsSentForSigning = new BehaviorSubject(void 0);
    this.sendingDocuments = new BehaviorSubject(void 0);
    this.stoppedSendingDocuments = new Subject();
    this.signingDocuments = new BehaviorSubject(void 0);
    this.stoppedSigningDocuments = new Subject();
    this.preparingEstimate = new BehaviorSubject(void 0);
    this.viewingDetails = new BehaviorSubject(void 0);
    this.managingPayments = new BehaviorSubject(void 0);
  }
  startSendingQuote(appointment) {
    if (appointment.documents.length <= 0) {
      appointment.generateDocuments();
    }
    this.sendingForQuote.next(appointment);
  }
  stopSendingQuote() {
    this.sendingForQuote.next(void 0);
    this.stoppedSendingForQuote.next();
  }
  startSendingExecutedDocuments(appointment) {
    this.sendingExecutedDocuments.next(appointment);
  }
  stopSendingExecutedDocuments() {
    this.sendingExecutedDocuments.next(void 0);
    this.stoppedSendingExecutedDocuments.next();
  }
  startSendingDocuments(appointment) {
    this.sendingDocuments.next(appointment);
  }
  stopSendingDocuments(sent = void 0) {
    this.documentsSentForSigning.next(sent);
    this.sendingDocuments.next(void 0);
    this.stoppedSendingDocuments.next();
  }
  startSigningDocuments(appointment, signer, onlyCustomerFacing = false) {
    this.signingDocuments.next({
      appointment,
      onlyCustomerFacing,
      signer
    });
  }
  stopSigningDocuments() {
    this.signingDocuments.next(void 0);
    this.stoppedSigningDocuments.next();
  }
  startPreparingEstimate(appointment) {
    this.preparingEstimate.next(appointment);
  }
  stopPreparingEstimate() {
    this.preparingEstimate.next(void 0);
  }
  viewDetails(appointment) {
    this.viewingDetails.next(appointment);
  }
  stopViewingDetails() {
    this.viewingDetails.next(void 0);
  }
  startMakingPayments(appointment) {
    this.managingPayments.next(appointment);
  }
  stopMakingPayments() {
    this.managingPayments.next(void 0);
  }
  // #endregion
  ngOnDestroy() {
  }
};
_AppointmentUiService.\u0275fac = function AppointmentUiService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentUiService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(SystemService), \u0275\u0275inject(UiService));
};
_AppointmentUiService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _AppointmentUiService, factory: _AppointmentUiService.\u0275fac });
var AppointmentUiService = _AppointmentUiService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentUiService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: SystemService }, { type: UiService }], null);
})();

export {
  AppointmentUiService
};
//# sourceMappingURL=chunk-JUJBVXIJ.js.map
