import {
  DeviceRouteService
} from "./chunk-ZEKYPX2O.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  BehaviorSubject,
  Injectable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/navigation/services/side-nav.service.ts
var _SideNavService = class _SideNavService {
  constructor(deviceRouteService, uiService) {
    this.deviceRouteService = deviceRouteService;
    this.uiService = uiService;
    this.openAppointments = [];
    this.watchForAppointmentDispostionChange = false;
    this.trainingActive = false;
    this.closingTraining = false;
    this.initializing = new BehaviorSubject(false);
    this.active = new BehaviorSubject(false);
    this.init();
  }
  storeAppointment(appointment, setActive = false) {
    const existingAppoitnment = this.openAppointments.find((x) => x.id == appointment.id);
    if (existingAppoitnment == null) {
      this.openAppointments.push(appointment);
    }
    if (setActive) {
      this.activeAppointment = appointment;
    }
  }
  removeAppointment(id) {
    for (var i = 0, len = this.openAppointments.length; i < len; i++) {
      const appointment = this.openAppointments[i];
      if (appointment.id == id) {
        this.openAppointments.splice(i, 1);
        break;
      }
    }
  }
  goToAppointment(id) {
    this.deviceRouteService.viewRouteByType("Appointment", [id], true);
  }
  closeTraining() {
    window.clearTimeout(this.trainingTimeout);
    this.closingTraining = true;
    this.trainingTimeout = window.setTimeout(() => {
      this.trainingActive = false;
      this.closingTraining = false;
    }, 250);
  }
  goToTraining() {
    window.clearTimeout(this.trainingTimeout);
    this.trainingActive = true;
  }
  goToRoute(type, params = []) {
    this.activeAppointment = void 0;
    this.deviceRouteService.viewRouteByType(type, params, true);
  }
  watchRoutes() {
    this.routeSubscription = this.deviceRouteService.activeRoute.subscribe({
      next: (route) => {
        this.activeRoute = route;
      }
    });
  }
  open() {
    this.active.next(true);
  }
  close() {
    this.active.next(false);
  }
  toggleActive() {
    const active = this.active.getValue();
    if (active) {
      this.close();
    } else {
      this.open();
    }
  }
  init() {
    this.watchRoutes();
  }
  // #endregion
  ngOnDestroy() {
    this.routeSubscription?.unsubscribe();
    this.stateSubscription?.unsubscribe();
  }
};
_SideNavService.\u0275fac = function SideNavService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SideNavService)(\u0275\u0275inject(DeviceRouteService), \u0275\u0275inject(UiService));
};
_SideNavService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _SideNavService, factory: _SideNavService.\u0275fac });
var SideNavService = _SideNavService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SideNavService, [{
    type: Injectable
  }], () => [{ type: DeviceRouteService }, { type: UiService }], null);
})();

export {
  SideNavService
};
//# sourceMappingURL=chunk-MG4UNSAD.js.map
