import {
  DatePipe,
  Injectable,
  Subject,
  setClassMetadata,
  take,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/ui/services/ui.service.ts
var _UiService = class _UiService {
  constructor(datePipe) {
    this.datePipe = datePipe;
    this.showPrompt = false;
    this.promptHandled = new Subject();
    this.isMobileDevice = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    this.isSafari = /Safari/.test(navigator.userAgent) && !/Chrome/.test(navigator.userAgent);
    this.isLegacySafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent) && parseInt((navigator.userAgent.match(/version\/(\d+)/i) || [])[1]) <= 17;
    this.isPWA = window.matchMedia("(display-mode: standalone)").matches;
  }
  // #region IDs
  generateId() {
    const guid = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
      const r = Math.random() * 16 | 0;
      const v = c === "x" ? r : r & 3 | 8;
      return v.toString(16);
    });
    return guid;
  }
  // #endregion
  // #region Shims
  deepClone(obj, seen = /* @__PURE__ */ new WeakMap()) {
    if (obj === null || typeof obj !== "object") {
      return obj;
    }
    if (Array.isArray(obj) && obj.every((item) => typeof item !== "object" && typeof item !== "function")) {
      return [...obj];
    }
    if (seen.has(obj)) {
      return seen.get(obj);
    }
    if (obj instanceof Date) {
      return new Date(obj.getTime());
    }
    if (obj instanceof Map) {
      const clone2 = /* @__PURE__ */ new Map();
      seen.set(obj, clone2);
      obj.forEach((value, key) => {
        if (typeof value !== "function") {
          clone2.set(this.deepClone(key, seen), this.deepClone(value, seen));
        }
      });
      return clone2;
    }
    if (obj instanceof Set) {
      const clone2 = /* @__PURE__ */ new Set();
      seen.set(obj, clone2);
      obj.forEach((value) => {
        if (typeof value !== "function") {
          clone2.add(this.deepClone(value, seen));
        }
      });
      return clone2;
    }
    if (Array.isArray(obj)) {
      const clone2 = [];
      seen.set(obj, clone2);
      for (let i = 0; i < obj.length; i++) {
        if (typeof obj[i] !== "function") {
          clone2[i] = this.deepClone(obj[i], seen);
        }
      }
      return clone2;
    }
    const clone = {};
    seen.set(obj, clone);
    for (const key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        const value = obj[key];
        if (typeof value !== "function") {
          clone[key] = this.deepClone(value, seen);
        }
      }
    }
    return clone;
  }
  base64UrlEncode(input) {
    const base64 = btoa(input);
    return base64.replace(/\+/g, "-").replace(/\//g, "_").replace(/=+$/, "");
  }
  // #endregion
  // #region Dates
  transformDate(date, format) {
    return this.datePipe.transform(date, format);
  }
  getDateAsString(date, local = true) {
    if (local) {
      return `${date.getFullYear()}-${String(date.getMonth() + 1).padStart(2, "0")}-${String(date.getDate()).padStart(2, "0")}T${String(date.getHours()).padStart(2, "0")}:${String(date.getMinutes()).padStart(2, "0")}`;
    } else {
      return date.toISOString().slice(0, 16);
    }
  }
  prompt(header, description, confirmLabel, cancelLabel = void 0) {
    this.resetPrompt();
    this.promptHeader = header;
    this.promptDescription = description;
    this.promptConfirmLabel = confirmLabel;
    this.promptCancelLabel = cancelLabel;
    this.showPrompt = true;
    return this.promptHandled.pipe(take(1));
  }
  resetPrompt() {
    this.promptHandled = new Subject();
  }
  cancelPrompt() {
    this.promptHandled.next(false);
    this.showPrompt = false;
  }
  confirmPrompt() {
    this.promptHandled.next(true);
    this.showPrompt = false;
  }
};
_UiService.\u0275fac = function UiService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _UiService)(\u0275\u0275inject(DatePipe));
};
_UiService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _UiService, factory: _UiService.\u0275fac });
var UiService = _UiService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(UiService, [{
    type: Injectable
  }], () => [{ type: DatePipe }], null);
})();

export {
  UiService
};
//# sourceMappingURL=chunk-WUILV27O.js.map
