import {
  AuthRefService
} from "./chunk-M3LFBN7N.js";
import {
  environment
} from "./chunk-IDX2GQCZ.js";
import {
  BehaviorSubject,
  HttpClient,
  Injectable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/system/services/api.service.ts
var _ApiService = class _ApiService {
  constructor(http, authRefService) {
    this.http = http;
    this.authRefService = authRefService;
    this.onlineCheckInitialized = false;
    this.checkingOnlineStatus = true;
    this.online = new BehaviorSubject(false);
    this.checkOnlineStatus(true);
  }
  setOnlineStatus(status) {
    this.online.next(status);
  }
  scheduleNextOnlineCheck() {
    this.onlineTimer = window.setTimeout(() => {
      this.checkOnlineStatus();
    }, 2500);
  }
  checkOnlineStatus(override = false) {
    if (!this.checkingOnlineStatus || override) {
      window.clearTimeout(this.onlineTimer);
      this.checkingOnlineStatus = true;
      const url = `${environment.API_URL}/helpers/talk-to-me-goose`;
      this.http.get(url).subscribe({
        next: () => {
          this.checkingOnlineStatus = false;
          this.setOnlineStatus(true);
          this.scheduleNextOnlineCheck();
        },
        error: (e) => {
          this.checkingOnlineStatus = false;
          if (!e.message.includes("NG0200")) {
            this.setOnlineStatus(false);
          }
          this.scheduleNextOnlineCheck();
        }
      });
    }
  }
  stopOnlineCheck() {
    window.clearTimeout(this.onlineTimer);
    this.onlineCheckInitialized = false;
  }
  initOnlineCheck() {
    if (!this.onlineCheckInitialized) {
      this.checkOnlineStatus();
      this.onlineCheckInitialized = true;
    }
  }
  // #endregion
  // #region API
  get apiUrl() {
    return environment.API_URL;
  }
  getContentUrl(fileName) {
    const b64 = btoa(fileName).replace(/\+/g, "-").replace(/\//g, "_").replace(/=+$/, "");
    return `${environment.CONTENT_URL}/${b64}`;
  }
  // #endregion
  ngOnDestroy() {
    window.clearTimeout(this.onlineTimer);
  }
};
_ApiService.\u0275fac = function ApiService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ApiService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(AuthRefService));
};
_ApiService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _ApiService, factory: _ApiService.\u0275fac });
var ApiService = _ApiService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ApiService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: AuthRefService }], null);
})();

export {
  ApiService
};
//# sourceMappingURL=chunk-XNCHXMYV.js.map
