import {
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  BehaviorSubject,
  Injectable,
  RendererFactory2,
  RendererStyleFlags2,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/navigation/services/internal-route.service.ts
var _InternalRouteService = class _InternalRouteService {
  constructor(renderFactory) {
    this.renderFactory = renderFactory;
    this.transitionInMs = 250;
    this.routes = {};
    this.routeChanging = false;
    this.activeRoute = new BehaviorSubject(void 0);
    this.renderer = renderFactory.createRenderer(null, null);
  }
  setCssVariable(nativeElement, name, value) {
    this.renderer.setStyle(nativeElement, name, value, RendererStyleFlags2.DashCase);
  }
  viewRoute(type, direction, animate = false, activeDirection = RouteLoadDirection.Forward, params = []) {
    const route = this.routes[type];
    if (route != null) {
      route.params.next(params);
      const activeRoute = this.activeRoute.getValue();
      if (activeRoute?.type != type) {
        this.closeActiveRoute(activeDirection, animate);
      }
      this.routeChanging = true;
      route.loadDirection = direction;
      route.active = true;
      this.activeRoute.next(route);
      const transitionInMs = animate ? this.transitionInMs : 0;
      const initSubscription = route.initialized.subscribe({
        next: () => {
          route.animating = animate;
          setTimeout(() => {
            this.routeChanging = false;
            route.animating = false;
            route.rendered = true;
          }, transitionInMs);
          initSubscription.unsubscribe();
        }
      });
    }
  }
  closeActiveRoute(direction, animate = false) {
    const route = this.activeRoute.getValue();
    if (route != null) {
      route.loadDirection = direction;
      route.closing = true;
      route.animating = animate;
      setTimeout(() => {
        route.active = false;
        route.closing = false;
        route.animating = false;
        route.rendered = false;
      }, this.transitionInMs);
    }
  }
  // #endregion
  // #region Bootstrapping
  init(routes, defaultRoute = null, transitionInMs = 250, componentElm) {
    this.routes = routes;
    this.transitionInMs = transitionInMs;
    this.setCssVariable(componentElm, "--routeTransition", `${transitionInMs}ms`);
    if (defaultRoute != null) {
      this.defaultRoute = this.routes[defaultRoute];
      this.viewRoute(defaultRoute, this.defaultRoute.loadDirection);
    }
  }
  // #endregion
  ngOnDestroy() {
  }
};
_InternalRouteService.\u0275fac = function InternalRouteService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _InternalRouteService)(\u0275\u0275inject(RendererFactory2));
};
_InternalRouteService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _InternalRouteService, factory: _InternalRouteService.\u0275fac });
var InternalRouteService = _InternalRouteService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(InternalRouteService, [{
    type: Injectable
  }], () => [{ type: RendererFactory2 }], null);
})();

export {
  InternalRouteService
};
//# sourceMappingURL=chunk-B4U6NSGR.js.map
