import {
  ContactInformationType
} from "./chunk-HJJU6GQE.js";
import {
  SystemService
} from "./chunk-CEWZNQA5.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  LogService,
  OpportunityService
} from "./chunk-TJ5F7MJ2.js";
import {
  Address,
  ContentBinary,
  ContentService
} from "./chunk-QKEQQVYW.js";
import {
  ApiService
} from "./chunk-EBH7MLJT.js";
import {
  AuthRefService,
  NoteAudience as NoteAudience2
} from "./chunk-M3LFBN7N.js";
import {
  DocumentFieldMapping,
  DocumentSignature,
  DocumentSigner,
  DocumentSignerType,
  DocumentSigningConsent,
  DocumentUserContent,
  NoteAudience,
  PropertyEntityType,
  deepClone,
  generateDeterministicId,
  hashString,
  require_hmac_sha256,
  toCanvas
} from "./chunk-N36JE2BE.js";
import {
  environment
} from "./chunk-VWQQS2KV.js";
import {
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  CurrencyPipe,
  DomSanitizer,
  FormsModule,
  HttpClient,
  Injectable,
  Input,
  LoaderComponent,
  NgModule,
  OrderByPipe,
  Output,
  ReactiveFormsModule,
  RouterModule,
  Subject,
  UiModule,
  ViewChild,
  setClassMetadata,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵrepeaterTrackByIndex,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeHtml,
  ɵɵsanitizeUrl,
  ɵɵstyleProp,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import {
  __async,
  __toESM
} from "./chunk-RVA4KI76.js";

// node_modules/.pnpm/signature_pad@5.0.4/node_modules/signature_pad/dist/signature_pad.js
var Point = class {
  constructor(x, y, pressure, time) {
    if (isNaN(x) || isNaN(y)) {
      throw new Error(`Point is invalid: (${x}, ${y})`);
    }
    this.x = +x;
    this.y = +y;
    this.pressure = pressure || 0;
    this.time = time || Date.now();
  }
  distanceTo(start) {
    return Math.sqrt(Math.pow(this.x - start.x, 2) + Math.pow(this.y - start.y, 2));
  }
  equals(other) {
    return this.x === other.x && this.y === other.y && this.pressure === other.pressure && this.time === other.time;
  }
  velocityFrom(start) {
    return this.time !== start.time ? this.distanceTo(start) / (this.time - start.time) : 0;
  }
};
var Bezier = class _Bezier {
  static fromPoints(points, widths) {
    const c2 = this.calculateControlPoints(points[0], points[1], points[2]).c2;
    const c3 = this.calculateControlPoints(points[1], points[2], points[3]).c1;
    return new _Bezier(points[1], c2, c3, points[2], widths.start, widths.end);
  }
  static calculateControlPoints(s1, s2, s3) {
    const dx1 = s1.x - s2.x;
    const dy1 = s1.y - s2.y;
    const dx2 = s2.x - s3.x;
    const dy2 = s2.y - s3.y;
    const m1 = { x: (s1.x + s2.x) / 2, y: (s1.y + s2.y) / 2 };
    const m2 = { x: (s2.x + s3.x) / 2, y: (s2.y + s3.y) / 2 };
    const l1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
    const l2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
    const dxm = m1.x - m2.x;
    const dym = m1.y - m2.y;
    const k = l1 + l2 == 0 ? 0 : l2 / (l1 + l2);
    const cm = { x: m2.x + dxm * k, y: m2.y + dym * k };
    const tx = s2.x - cm.x;
    const ty = s2.y - cm.y;
    return {
      c1: new Point(m1.x + tx, m1.y + ty),
      c2: new Point(m2.x + tx, m2.y + ty)
    };
  }
  constructor(startPoint, control2, control1, endPoint, startWidth, endWidth) {
    this.startPoint = startPoint;
    this.control2 = control2;
    this.control1 = control1;
    this.endPoint = endPoint;
    this.startWidth = startWidth;
    this.endWidth = endWidth;
  }
  length() {
    const steps = 10;
    let length = 0;
    let px;
    let py;
    for (let i = 0; i <= steps; i += 1) {
      const t = i / steps;
      const cx = this.point(t, this.startPoint.x, this.control1.x, this.control2.x, this.endPoint.x);
      const cy = this.point(t, this.startPoint.y, this.control1.y, this.control2.y, this.endPoint.y);
      if (i > 0) {
        const xdiff = cx - px;
        const ydiff = cy - py;
        length += Math.sqrt(xdiff * xdiff + ydiff * ydiff);
      }
      px = cx;
      py = cy;
    }
    return length;
  }
  point(t, start, c1, c2, end) {
    return start * (1 - t) * (1 - t) * (1 - t) + 3 * c1 * (1 - t) * (1 - t) * t + 3 * c2 * (1 - t) * t * t + end * t * t * t;
  }
};
var SignatureEventTarget = class {
  constructor() {
    try {
      this._et = new EventTarget();
    } catch (_a) {
      this._et = document;
    }
  }
  addEventListener(type, listener, options) {
    this._et.addEventListener(type, listener, options);
  }
  dispatchEvent(event) {
    return this._et.dispatchEvent(event);
  }
  removeEventListener(type, callback, options) {
    this._et.removeEventListener(type, callback, options);
  }
};
function throttle(fn, wait = 250) {
  let previous = 0;
  let timeout = null;
  let result;
  let storedContext;
  let storedArgs;
  const later = () => {
    previous = Date.now();
    timeout = null;
    result = fn.apply(storedContext, storedArgs);
    if (!timeout) {
      storedContext = null;
      storedArgs = [];
    }
  };
  return function wrapper(...args) {
    const now = Date.now();
    const remaining = wait - (now - previous);
    storedContext = this;
    storedArgs = args;
    if (remaining <= 0 || remaining > wait) {
      if (timeout) {
        clearTimeout(timeout);
        timeout = null;
      }
      previous = now;
      result = fn.apply(storedContext, storedArgs);
      if (!timeout) {
        storedContext = null;
        storedArgs = [];
      }
    } else if (!timeout) {
      timeout = window.setTimeout(later, remaining);
    }
    return result;
  };
}
var SignaturePad = class _SignaturePad extends SignatureEventTarget {
  constructor(canvas, options = {}) {
    var _a, _b, _c;
    super();
    this.canvas = canvas;
    this._drawingStroke = false;
    this._isEmpty = true;
    this._lastPoints = [];
    this._data = [];
    this._lastVelocity = 0;
    this._lastWidth = 0;
    this._handleMouseDown = (event) => {
      if (!this._isLeftButtonPressed(event, true) || this._drawingStroke) {
        return;
      }
      this._strokeBegin(this._pointerEventToSignatureEvent(event));
    };
    this._handleMouseMove = (event) => {
      if (!this._isLeftButtonPressed(event, true) || !this._drawingStroke) {
        this._strokeEnd(this._pointerEventToSignatureEvent(event), false);
        return;
      }
      this._strokeMoveUpdate(this._pointerEventToSignatureEvent(event));
    };
    this._handleMouseUp = (event) => {
      if (this._isLeftButtonPressed(event)) {
        return;
      }
      this._strokeEnd(this._pointerEventToSignatureEvent(event));
    };
    this._handleTouchStart = (event) => {
      if (event.targetTouches.length !== 1 || this._drawingStroke) {
        return;
      }
      if (event.cancelable) {
        event.preventDefault();
      }
      this._strokeBegin(this._touchEventToSignatureEvent(event));
    };
    this._handleTouchMove = (event) => {
      if (event.targetTouches.length !== 1) {
        return;
      }
      if (event.cancelable) {
        event.preventDefault();
      }
      if (!this._drawingStroke) {
        this._strokeEnd(this._touchEventToSignatureEvent(event), false);
        return;
      }
      this._strokeMoveUpdate(this._touchEventToSignatureEvent(event));
    };
    this._handleTouchEnd = (event) => {
      if (event.targetTouches.length !== 0) {
        return;
      }
      if (event.cancelable) {
        event.preventDefault();
      }
      this.canvas.removeEventListener("touchmove", this._handleTouchMove);
      this._strokeEnd(this._touchEventToSignatureEvent(event));
    };
    this._handlePointerDown = (event) => {
      if (!event.isPrimary || !this._isLeftButtonPressed(event) || this._drawingStroke) {
        return;
      }
      event.preventDefault();
      this._strokeBegin(this._pointerEventToSignatureEvent(event));
    };
    this._handlePointerMove = (event) => {
      if (!event.isPrimary) {
        return;
      }
      if (!this._isLeftButtonPressed(event, true) || !this._drawingStroke) {
        this._strokeEnd(this._pointerEventToSignatureEvent(event), false);
        return;
      }
      event.preventDefault();
      this._strokeMoveUpdate(this._pointerEventToSignatureEvent(event));
    };
    this._handlePointerUp = (event) => {
      if (!event.isPrimary || this._isLeftButtonPressed(event)) {
        return;
      }
      event.preventDefault();
      this._strokeEnd(this._pointerEventToSignatureEvent(event));
    };
    this.velocityFilterWeight = options.velocityFilterWeight || 0.7;
    this.minWidth = options.minWidth || 0.5;
    this.maxWidth = options.maxWidth || 2.5;
    this.throttle = (_a = options.throttle) !== null && _a !== void 0 ? _a : 16;
    this.minDistance = (_b = options.minDistance) !== null && _b !== void 0 ? _b : 5;
    this.dotSize = options.dotSize || 0;
    this.penColor = options.penColor || "black";
    this.backgroundColor = options.backgroundColor || "rgba(0,0,0,0)";
    this.compositeOperation = options.compositeOperation || "source-over";
    this.canvasContextOptions = (_c = options.canvasContextOptions) !== null && _c !== void 0 ? _c : {};
    this._strokeMoveUpdate = this.throttle ? throttle(_SignaturePad.prototype._strokeUpdate, this.throttle) : _SignaturePad.prototype._strokeUpdate;
    this._ctx = canvas.getContext("2d", this.canvasContextOptions);
    this.clear();
    this.on();
  }
  clear() {
    const { _ctx: ctx, canvas } = this;
    ctx.fillStyle = this.backgroundColor;
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    this._data = [];
    this._reset(this._getPointGroupOptions());
    this._isEmpty = true;
  }
  fromDataURL(dataUrl, options = {}) {
    return new Promise((resolve, reject) => {
      const image = new Image();
      const ratio = options.ratio || window.devicePixelRatio || 1;
      const width = options.width || this.canvas.width / ratio;
      const height = options.height || this.canvas.height / ratio;
      const xOffset = options.xOffset || 0;
      const yOffset = options.yOffset || 0;
      this._reset(this._getPointGroupOptions());
      image.onload = () => {
        this._ctx.drawImage(image, xOffset, yOffset, width, height);
        resolve();
      };
      image.onerror = (error) => {
        reject(error);
      };
      image.crossOrigin = "anonymous";
      image.src = dataUrl;
      this._isEmpty = false;
    });
  }
  toDataURL(type = "image/png", encoderOptions) {
    switch (type) {
      case "image/svg+xml":
        if (typeof encoderOptions !== "object") {
          encoderOptions = void 0;
        }
        return `data:image/svg+xml;base64,${btoa(this.toSVG(encoderOptions))}`;
      default:
        if (typeof encoderOptions !== "number") {
          encoderOptions = void 0;
        }
        return this.canvas.toDataURL(type, encoderOptions);
    }
  }
  on() {
    this.canvas.style.touchAction = "none";
    this.canvas.style.msTouchAction = "none";
    this.canvas.style.userSelect = "none";
    const isIOS = /Macintosh/.test(navigator.userAgent) && "ontouchstart" in document;
    if (window.PointerEvent && !isIOS) {
      this._handlePointerEvents();
    } else {
      this._handleMouseEvents();
      if ("ontouchstart" in window) {
        this._handleTouchEvents();
      }
    }
  }
  off() {
    this.canvas.style.touchAction = "auto";
    this.canvas.style.msTouchAction = "auto";
    this.canvas.style.userSelect = "auto";
    this.canvas.removeEventListener("pointerdown", this._handlePointerDown);
    this.canvas.removeEventListener("mousedown", this._handleMouseDown);
    this.canvas.removeEventListener("touchstart", this._handleTouchStart);
    this._removeMoveUpEventListeners();
  }
  _getListenerFunctions() {
    var _a;
    const canvasWindow = window.document === this.canvas.ownerDocument ? window : (_a = this.canvas.ownerDocument.defaultView) !== null && _a !== void 0 ? _a : this.canvas.ownerDocument;
    return {
      addEventListener: canvasWindow.addEventListener.bind(canvasWindow),
      removeEventListener: canvasWindow.removeEventListener.bind(canvasWindow)
    };
  }
  _removeMoveUpEventListeners() {
    const { removeEventListener } = this._getListenerFunctions();
    removeEventListener("pointermove", this._handlePointerMove);
    removeEventListener("pointerup", this._handlePointerUp);
    removeEventListener("mousemove", this._handleMouseMove);
    removeEventListener("mouseup", this._handleMouseUp);
    removeEventListener("touchmove", this._handleTouchMove);
    removeEventListener("touchend", this._handleTouchEnd);
  }
  isEmpty() {
    return this._isEmpty;
  }
  fromData(pointGroups, { clear = true } = {}) {
    if (clear) {
      this.clear();
    }
    this._fromData(pointGroups, this._drawCurve.bind(this), this._drawDot.bind(this));
    this._data = this._data.concat(pointGroups);
  }
  toData() {
    return this._data;
  }
  _isLeftButtonPressed(event, only) {
    if (only) {
      return event.buttons === 1;
    }
    return (event.buttons & 1) === 1;
  }
  _pointerEventToSignatureEvent(event) {
    return {
      event,
      type: event.type,
      x: event.clientX,
      y: event.clientY,
      pressure: "pressure" in event ? event.pressure : 0
    };
  }
  _touchEventToSignatureEvent(event) {
    const touch = event.changedTouches[0];
    return {
      event,
      type: event.type,
      x: touch.clientX,
      y: touch.clientY,
      pressure: touch.force
    };
  }
  _getPointGroupOptions(group) {
    return {
      penColor: group && "penColor" in group ? group.penColor : this.penColor,
      dotSize: group && "dotSize" in group ? group.dotSize : this.dotSize,
      minWidth: group && "minWidth" in group ? group.minWidth : this.minWidth,
      maxWidth: group && "maxWidth" in group ? group.maxWidth : this.maxWidth,
      velocityFilterWeight: group && "velocityFilterWeight" in group ? group.velocityFilterWeight : this.velocityFilterWeight,
      compositeOperation: group && "compositeOperation" in group ? group.compositeOperation : this.compositeOperation
    };
  }
  _strokeBegin(event) {
    const cancelled = !this.dispatchEvent(new CustomEvent("beginStroke", { detail: event, cancelable: true }));
    if (cancelled) {
      return;
    }
    const { addEventListener } = this._getListenerFunctions();
    switch (event.event.type) {
      case "mousedown":
        addEventListener("mousemove", this._handleMouseMove);
        addEventListener("mouseup", this._handleMouseUp);
        break;
      case "touchstart":
        addEventListener("touchmove", this._handleTouchMove);
        addEventListener("touchend", this._handleTouchEnd);
        break;
      case "pointerdown":
        addEventListener("pointermove", this._handlePointerMove);
        addEventListener("pointerup", this._handlePointerUp);
        break;
    }
    this._drawingStroke = true;
    const pointGroupOptions = this._getPointGroupOptions();
    const newPointGroup = Object.assign(Object.assign({}, pointGroupOptions), { points: [] });
    this._data.push(newPointGroup);
    this._reset(pointGroupOptions);
    this._strokeUpdate(event);
  }
  _strokeUpdate(event) {
    if (!this._drawingStroke) {
      return;
    }
    if (this._data.length === 0) {
      this._strokeBegin(event);
      return;
    }
    this.dispatchEvent(new CustomEvent("beforeUpdateStroke", { detail: event }));
    const point = this._createPoint(event.x, event.y, event.pressure);
    const lastPointGroup = this._data[this._data.length - 1];
    const lastPoints = lastPointGroup.points;
    const lastPoint = lastPoints.length > 0 && lastPoints[lastPoints.length - 1];
    const isLastPointTooClose = lastPoint ? point.distanceTo(lastPoint) <= this.minDistance : false;
    const pointGroupOptions = this._getPointGroupOptions(lastPointGroup);
    if (!lastPoint || !(lastPoint && isLastPointTooClose)) {
      const curve = this._addPoint(point, pointGroupOptions);
      if (!lastPoint) {
        this._drawDot(point, pointGroupOptions);
      } else if (curve) {
        this._drawCurve(curve, pointGroupOptions);
      }
      lastPoints.push({
        time: point.time,
        x: point.x,
        y: point.y,
        pressure: point.pressure
      });
    }
    this.dispatchEvent(new CustomEvent("afterUpdateStroke", { detail: event }));
  }
  _strokeEnd(event, shouldUpdate = true) {
    this._removeMoveUpEventListeners();
    if (!this._drawingStroke) {
      return;
    }
    if (shouldUpdate) {
      this._strokeUpdate(event);
    }
    this._drawingStroke = false;
    this.dispatchEvent(new CustomEvent("endStroke", { detail: event }));
  }
  _handlePointerEvents() {
    this._drawingStroke = false;
    this.canvas.addEventListener("pointerdown", this._handlePointerDown);
  }
  _handleMouseEvents() {
    this._drawingStroke = false;
    this.canvas.addEventListener("mousedown", this._handleMouseDown);
  }
  _handleTouchEvents() {
    this.canvas.addEventListener("touchstart", this._handleTouchStart);
  }
  _reset(options) {
    this._lastPoints = [];
    this._lastVelocity = 0;
    this._lastWidth = (options.minWidth + options.maxWidth) / 2;
    this._ctx.fillStyle = options.penColor;
    this._ctx.globalCompositeOperation = options.compositeOperation;
  }
  _createPoint(x, y, pressure) {
    const rect = this.canvas.getBoundingClientRect();
    return new Point(x - rect.left, y - rect.top, pressure, (/* @__PURE__ */ new Date()).getTime());
  }
  _addPoint(point, options) {
    const { _lastPoints } = this;
    _lastPoints.push(point);
    if (_lastPoints.length > 2) {
      if (_lastPoints.length === 3) {
        _lastPoints.unshift(_lastPoints[0]);
      }
      const widths = this._calculateCurveWidths(_lastPoints[1], _lastPoints[2], options);
      const curve = Bezier.fromPoints(_lastPoints, widths);
      _lastPoints.shift();
      return curve;
    }
    return null;
  }
  _calculateCurveWidths(startPoint, endPoint, options) {
    const velocity = options.velocityFilterWeight * endPoint.velocityFrom(startPoint) + (1 - options.velocityFilterWeight) * this._lastVelocity;
    const newWidth = this._strokeWidth(velocity, options);
    const widths = {
      end: newWidth,
      start: this._lastWidth
    };
    this._lastVelocity = velocity;
    this._lastWidth = newWidth;
    return widths;
  }
  _strokeWidth(velocity, options) {
    return Math.max(options.maxWidth / (velocity + 1), options.minWidth);
  }
  _drawCurveSegment(x, y, width) {
    const ctx = this._ctx;
    ctx.moveTo(x, y);
    ctx.arc(x, y, width, 0, 2 * Math.PI, false);
    this._isEmpty = false;
  }
  _drawCurve(curve, options) {
    const ctx = this._ctx;
    const widthDelta = curve.endWidth - curve.startWidth;
    const drawSteps = Math.ceil(curve.length()) * 2;
    ctx.beginPath();
    ctx.fillStyle = options.penColor;
    for (let i = 0; i < drawSteps; i += 1) {
      const t = i / drawSteps;
      const tt = t * t;
      const ttt = tt * t;
      const u = 1 - t;
      const uu = u * u;
      const uuu = uu * u;
      let x = uuu * curve.startPoint.x;
      x += 3 * uu * t * curve.control1.x;
      x += 3 * u * tt * curve.control2.x;
      x += ttt * curve.endPoint.x;
      let y = uuu * curve.startPoint.y;
      y += 3 * uu * t * curve.control1.y;
      y += 3 * u * tt * curve.control2.y;
      y += ttt * curve.endPoint.y;
      const width = Math.min(curve.startWidth + ttt * widthDelta, options.maxWidth);
      this._drawCurveSegment(x, y, width);
    }
    ctx.closePath();
    ctx.fill();
  }
  _drawDot(point, options) {
    const ctx = this._ctx;
    const width = options.dotSize > 0 ? options.dotSize : (options.minWidth + options.maxWidth) / 2;
    ctx.beginPath();
    this._drawCurveSegment(point.x, point.y, width);
    ctx.closePath();
    ctx.fillStyle = options.penColor;
    ctx.fill();
  }
  _fromData(pointGroups, drawCurve, drawDot) {
    for (const group of pointGroups) {
      const { points } = group;
      const pointGroupOptions = this._getPointGroupOptions(group);
      if (points.length > 1) {
        for (let j = 0; j < points.length; j += 1) {
          const basicPoint = points[j];
          const point = new Point(basicPoint.x, basicPoint.y, basicPoint.pressure, basicPoint.time);
          if (j === 0) {
            this._reset(pointGroupOptions);
          }
          const curve = this._addPoint(point, pointGroupOptions);
          if (curve) {
            drawCurve(curve, pointGroupOptions);
          }
        }
      } else {
        this._reset(pointGroupOptions);
        drawDot(points[0], pointGroupOptions);
      }
    }
  }
  toSVG({ includeBackgroundColor = false } = {}) {
    const pointGroups = this._data;
    const ratio = Math.max(window.devicePixelRatio || 1, 1);
    const minX = 0;
    const minY = 0;
    const maxX = this.canvas.width / ratio;
    const maxY = this.canvas.height / ratio;
    const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
    svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
    svg.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
    svg.setAttribute("viewBox", `${minX} ${minY} ${maxX} ${maxY}`);
    svg.setAttribute("width", maxX.toString());
    svg.setAttribute("height", maxY.toString());
    if (includeBackgroundColor && this.backgroundColor) {
      const rect = document.createElement("rect");
      rect.setAttribute("width", "100%");
      rect.setAttribute("height", "100%");
      rect.setAttribute("fill", this.backgroundColor);
      svg.appendChild(rect);
    }
    this._fromData(pointGroups, (curve, { penColor }) => {
      const path = document.createElement("path");
      if (!isNaN(curve.control1.x) && !isNaN(curve.control1.y) && !isNaN(curve.control2.x) && !isNaN(curve.control2.y)) {
        const attr = `M ${curve.startPoint.x.toFixed(3)},${curve.startPoint.y.toFixed(3)} C ${curve.control1.x.toFixed(3)},${curve.control1.y.toFixed(3)} ${curve.control2.x.toFixed(3)},${curve.control2.y.toFixed(3)} ${curve.endPoint.x.toFixed(3)},${curve.endPoint.y.toFixed(3)}`;
        path.setAttribute("d", attr);
        path.setAttribute("stroke-width", (curve.endWidth * 2.25).toFixed(3));
        path.setAttribute("stroke", penColor);
        path.setAttribute("fill", "none");
        path.setAttribute("stroke-linecap", "round");
        svg.appendChild(path);
      }
    }, (point, { penColor, dotSize, minWidth, maxWidth }) => {
      const circle = document.createElement("circle");
      const size = dotSize > 0 ? dotSize : (minWidth + maxWidth) / 2;
      circle.setAttribute("r", size.toString());
      circle.setAttribute("cx", point.x.toString());
      circle.setAttribute("cy", point.y.toString());
      circle.setAttribute("fill", penColor);
      svg.appendChild(circle);
    });
    return svg.outerHTML;
  }
};

// src/app/shared/documents/services/document.service.ts
var import_hmac_sha256 = __toESM(require_hmac_sha256());
var _DocumentService = class _DocumentService {
  constructor(http, systemService, uiService) {
    this.http = http;
    this.systemService = systemService;
    this.uiService = uiService;
    this.initialingFieldId = null;
    this.initialingDocumentId = null;
    this.initialing = false;
    this.initials = new Subject();
    this.signingDocumentId = null;
    this.signingFieldId = null;
    this.signing = false;
    this.signature = new Subject();
  }
  ngOnDestroy() {
  }
  // #region Appointments
  getAppointmentContent(key) {
    let url = `${environment.API_URL}/documents/signing/content/${key}`;
    return this.http.get(url);
  }
  // ONLY USE IF CUSTOMER FACING, OTHERWISE STORE APPOINTMENT
  completeAppointmentDocuments(signingKey, signerName, appointmentId, documents) {
    let url = `${environment.API_URL}/documents/signing/complete/${appointmentId}`;
    const headers = { "Content-Type": "application/json" };
    const signatures = [];
    const consents = [];
    for (var i = 0, len = documents.length; i < len; i++) {
      const document2 = documents[i];
      for (var j = 0, jlen = document2.signatures.length; j < jlen; j++) {
        const signature = document2.signatures[j];
        if (signature.signerName == signerName) {
          signature.documentId = document2.id;
          signatures.push(signature);
        }
      }
      for (var j = 0, jlen = document2.signers.length; j < jlen; j++) {
        const signer = document2.signers[j];
        const existingConsent = consents.find((x) => x.hashedId == signer.consent?.hashedId);
        if (signer.consent?.hashedId != null && existingConsent == null) {
          consents.push(signer.consent);
        }
      }
    }
    const request = {
      signingKey,
      appointmentId,
      signatures,
      consents
    };
    return this.http.post(url, JSON.stringify(request), { headers });
  }
  generateAppointmentSigners(document2, content) {
    const signers = [];
    let customerAdded = false;
    let consultantAdded = false;
    if (document2.mapping != null) {
      for (var i = 0, len = document2.mapping.pages.length; i < len; i++) {
        const page = document2.mapping.pages[i];
        for (var j = 0, jlen = page.fields.length; j < jlen; j++) {
          const field = page.fields[j];
          if ((field.id?.includes("initial.customer") || field.id?.includes("signature.customer")) && !customerAdded) {
            if (content?.customer != null) {
              const fullName = `${content.customer.firstName} ${content.customer.lastName}`;
              const email = content.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
              const phone = content.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
              const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
              signers.push(signer);
              customerAdded = true;
            }
          }
          if ((field.id?.includes("initial.consultant") || field.id?.includes("signature.consultant")) && !consultantAdded) {
            if (content?.consultant != null) {
              const fullName = `${content.consultant.firstName} ${content.consultant.lastName}`;
              const email = content.consultant.emailAddress;
              const phone = content.consultant.phone;
              const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
              signers.push(signer);
              consultantAdded = true;
            }
          }
        }
      }
    }
    if (document2.content != null) {
      if ((document2.content.includes("initial.customer") || document2.content.includes("signature.customer")) && !customerAdded) {
        if (content.customer != null) {
          const fullName = `${content.customer.firstName} ${content.customer.lastName}`;
          const email = content.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
          const phone = content.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
          const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
          signers.push(signer);
          customerAdded = true;
        }
      }
      if ((document2.content.includes("initial.consultant") || document2.content.includes("signature.consultant")) && !consultantAdded) {
        if (content.consultant != null) {
          const fullName = `${content.consultant.firstName} ${content.consultant.lastName}`;
          const email = content.consultant.emailAddress;
          const phone = content.consultant.phone;
          const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
          signers.push(signer);
          consultantAdded = true;
        }
      }
    }
    return signers;
  }
  // #endregion
  // #region Opportunities
  getOpportunityContent(key) {
    let url = `${environment.API_URL}/documents/signing/o/content/${key}`;
    return this.http.get(url);
  }
  // ONLY USE IF CUSTOMER FACING, OTHERWISE STORE APPOINTMENT
  completeOpportunityDocuments(signingKey, signerName, opportunityId, documents) {
    let url = `${environment.API_URL}/documents/signing/o/complete/${opportunityId}`;
    const headers = { "Content-Type": "application/json" };
    const signatures = [];
    const consents = [];
    for (var i = 0, len = documents.length; i < len; i++) {
      const document2 = documents[i];
      for (var j = 0, jlen = document2.signatures.length; j < jlen; j++) {
        const signature = document2.signatures[j];
        if (signature.signerName == signerName) {
          signature.documentId = document2.id;
          signatures.push(signature);
        }
      }
      for (var j = 0, jlen = document2.signers.length; j < jlen; j++) {
        const signer = document2.signers[j];
        const existingConsent = consents.find((x) => x.hashedId == signer.consent?.hashedId);
        if (signer.consent?.hashedId != null && existingConsent == null) {
          consents.push(signer.consent);
        }
      }
    }
    const request = {
      signingKey,
      opportunityId,
      signatures,
      consents
    };
    return this.http.post(url, JSON.stringify(request), { headers });
  }
  generateOpportunitySigners(document2, content) {
    const signers = [];
    let customerAdded = false;
    let consultantAdded = false;
    if (document2.mapping != null) {
      for (var i = 0, len = document2.mapping.pages.length; i < len; i++) {
        const page = document2.mapping.pages[i];
        for (var j = 0, jlen = page.fields.length; j < jlen; j++) {
          const field = page.fields[j];
          if ((field.id?.includes("initial.customer") || field.id?.includes("signature.customer")) && !customerAdded) {
            if (content?.customer != null) {
              const fullName = `${content.customer.firstName} ${content.customer.lastName}`;
              const email = content.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
              const phone = content.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
              const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
              signers.push(signer);
              customerAdded = true;
            }
          }
          if ((field.id?.includes("initial.consultant") || field.id?.includes("signature.consultant")) && !consultantAdded) {
            if (content?.consultant != null) {
              const fullName = `${content.consultant.firstName} ${content.consultant.lastName}`;
              const email = content.consultant.emailAddress;
              const phone = content.consultant.phone;
              const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
              signers.push(signer);
              consultantAdded = true;
            }
          }
        }
      }
    }
    if (document2.content != null) {
      if ((document2.content.includes("initial.customer") || document2.content.includes("signature.customer")) && !customerAdded) {
        if (content.customer != null) {
          const fullName = `${content.customer.firstName} ${content.customer.lastName}`;
          const email = content.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
          const phone = content.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
          const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
          signers.push(signer);
          customerAdded = true;
        }
      }
      if ((document2.content.includes("initial.consultant") || document2.content.includes("signature.consultant")) && !consultantAdded) {
        if (content.consultant != null) {
          const fullName = `${content.consultant.firstName} ${content.consultant.lastName}`;
          const email = content.consultant.emailAddress;
          const phone = content.consultant.phone;
          const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
          signers.push(signer);
          consultantAdded = true;
        }
      }
    }
    return signers;
  }
  updateSigners(documents) {
    window.clearTimeout(this.signerDebounce);
    this.signerDebounce = window.setTimeout(() => {
      const signers = [];
      for (var i = 0, len = documents.length; i < len; i++) {
        const document2 = documents[i];
        for (var j = 0, jlen = document2.signers.length; j < jlen; j++) {
          const signer = document2.signers[j];
          const existingSigner = signers.find((x) => x.fullName == signer.fullName);
          if (existingSigner == null) {
            signers.push(signer);
          } else {
            if (existingSigner.initials_B64 == null && signer.initials_B64 == null) {
              existingSigner.initials_B64 = signer.initials_B64;
            }
            if (existingSigner.signature_B64 == null && signer.signature_B64 == null) {
              existingSigner.signature_B64 = signer.signature_B64;
            }
          }
        }
        document2.signers = signers;
      }
    }, 500);
  }
  // #endregion
  // #region Crypto
  signSignature(signature) {
    const signingKey = environment.DOCUMENT_KEY;
    if (signingKey != null) {
      const payloadString = JSON.stringify(signature);
      const hmac = (0, import_hmac_sha256.default)("sha256", payloadString).toString();
      signature.hash_SHA256 = hmac;
      return signature;
    } else {
      throw "Signature could not be signed.";
    }
  }
  // #endregion
  // #region Consent
  initConsent(signerName) {
    const id = this.uiService.generateId();
    const hashedId = hashString(id);
    const appVersion = environment.APP_VERSION;
    const device = navigator.userAgent;
    const ip = this.systemService.ip.getValue();
    const position = this.systemService.location.getValue();
    const latlng = position != null ? `${position.coords.latitude},${position.coords.longitude}` : void 0;
    return new DocumentSigningConsent(id, hashedId, device, ip, signerName, latlng, appVersion.toString(), /* @__PURE__ */ new Date());
  }
  closeInitials(initials) {
    const event = {
      signature: initials,
      signer: this.initialer
    };
    this.initials.next(event);
    this.initialer = void 0;
    this.initialingFieldId = null;
    this.initialing = false;
  }
  startInitialing(initialer, fieldId, documentId) {
    this.initialer = initialer;
    this.initialingFieldId = fieldId;
    this.initialingDocumentId = documentId;
    this.initialing = true;
  }
  closeSignature(signature) {
    const event = {
      signature,
      signer: this.signer
    };
    this.signature.next(event);
    this.signer = void 0;
    this.signingFieldId = null;
    this.signing = false;
  }
  startSigning(signer, fieldId, documentId) {
    this.signer = signer;
    this.signingDocumentId = documentId;
    this.signingFieldId = fieldId;
    this.signing = true;
  }
  initSignature(signerName, fieldId = void 0, documentId = void 0) {
    const id = this.uiService.generateId();
    const hashedId = hashString(id);
    const appVersion = environment.APP_VERSION;
    const device = navigator.userAgent;
    const ip = this.systemService.ip.getValue();
    const position = this.systemService.location.getValue();
    const latlng = position != null ? `${position.coords.latitude},${position.coords.longitude}` : void 0;
    return new DocumentSignature(id, hashedId, fieldId, documentId, signerName, device, ip, latlng, appVersion.toString(), /* @__PURE__ */ new Date());
  }
  // #endregion
  // #region User Content
  initUserContent(signerName, fieldId = void 0, documentId = void 0) {
    const id = this.uiService.generateId();
    const hashedId = hashString(id);
    const appVersion = environment.APP_VERSION;
    const device = navigator.userAgent;
    const ip = this.systemService.ip.getValue();
    const position = this.systemService.location.getValue();
    const latlng = position != null ? `${position.coords.latitude},${position.coords.longitude}` : void 0;
    return new DocumentUserContent(id, hashedId, fieldId, documentId, signerName, device, ip, latlng, appVersion.toString(), /* @__PURE__ */ new Date());
  }
};
_DocumentService.\u0275fac = function DocumentService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DocumentService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(SystemService), \u0275\u0275inject(UiService));
};
_DocumentService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _DocumentService, factory: _DocumentService.\u0275fac });
var DocumentService = _DocumentService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DocumentService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: SystemService }, { type: UiService }], null);
})();

// src/app/shared/documents/components/signature-pad/signature-pad.component.ts
var _c0 = ["signaturePadElm"];
var _c1 = ["componentElm"];
function SignaturePadComponent_Conditional_0_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "h3");
    \u0275\u0275text(1, " Signatory: ");
    \u0275\u0275elementStart(2, "span", 10);
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r1.name);
  }
}
function SignaturePadComponent_Conditional_0_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275element(1, "canvas", 11, 0);
    \u0275\u0275elementStart(3, "div", 7)(4, "button", 8);
    \u0275\u0275listener("click", function SignaturePadComponent_Conditional_0_Conditional_13_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.clearSignature());
    });
    \u0275\u0275element(5, "i", 12);
    \u0275\u0275elementEnd()()();
  }
}
function SignaturePadComponent_Conditional_0_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6);
    \u0275\u0275element(1, "canvas", 13)(2, "img", 14);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("width", \u0275\u0275interpolate(ctx_r1.padWidth))("height", \u0275\u0275interpolate(ctx_r1.padHeight));
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r1.signer == null ? null : ctx_r1.signer.signature_B64, \u0275\u0275sanitizeUrl);
  }
}
function SignaturePadComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 1)(1, "div", 2)(2, "header")(3, "h2");
    \u0275\u0275text(4, "Sign Here");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(5, SignaturePadComponent_Conditional_0_Conditional_5_Template, 4, 1, "h3");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 3)(7, "button", 4);
    \u0275\u0275listener("click", function SignaturePadComponent_Conditional_0_Template_button_click_7_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.drawSignature());
    });
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Sign New Signature");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 5);
    \u0275\u0275listener("click", function SignaturePadComponent_Conditional_0_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.useSignature());
    });
    \u0275\u0275elementStart(11, "label");
    \u0275\u0275text(12, "Use My Signature");
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(13, SignaturePadComponent_Conditional_0_Conditional_13_Template, 6, 0, "div", 2);
    \u0275\u0275conditionalCreate(14, SignaturePadComponent_Conditional_0_Conditional_14_Template, 3, 5, "div", 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "div", 7)(16, "button", 8);
    \u0275\u0275listener("click", function SignaturePadComponent_Conditional_0_Template_button_click_16_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeView());
    });
    \u0275\u0275elementStart(17, "label");
    \u0275\u0275text(18, "Cancel");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "button", 9);
    \u0275\u0275listener("click", function SignaturePadComponent_Conditional_0_Template_button_click_19_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.save());
    });
    \u0275\u0275elementStart(20, "label");
    \u0275\u0275text(21, "Save Signature");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx_r1.name != null ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("drawing", ctx_r1.drawingNew)("using", !ctx_r1.drawingNew);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", (ctx_r1.signer == null ? null : ctx_r1.signer.signature_B64) == null);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.drawingNew ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.drawingNew ? 14 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx_r1.canSaveSignature);
  }
}
var _SignaturePadComponent = class _SignaturePadComponent {
  constructor(apiService, uiService, documentService) {
    this.apiService = apiService;
    this.uiService = uiService;
    this.documentService = documentService;
    this.canSaveSignature = false;
    this.drawingNew = true;
    this.padWidth = 1990;
    this.padHeight = 600;
    this.fieldId = null;
    this.documentId = null;
    this.close = new Subject();
    this.initialized = false;
  }
  clearSignature() {
    if (this.signaturePad != null) {
      this.signaturePad.clear();
      this.canSaveSignature = false;
    }
  }
  drawSignature() {
    this.drawingNew = true;
    this.initPad();
  }
  useSignature() {
    this.drawingNew = false;
    this.canSaveSignature = this.signer?.signature_B64 != null;
  }
  resizeSignature() {
    const signaturePadElm = this.signaturePadElm?.nativeElement;
    if (this.signaturePad != null && signaturePadElm != null) {
      const ratio = Math.max(window.devicePixelRatio || 1, 1);
      signaturePadElm.width = signaturePadElm.offsetWidth * ratio;
      signaturePadElm.height = signaturePadElm.offsetHeight * ratio;
      signaturePadElm.getContext("2d")?.scale(ratio, ratio);
      this.signaturePad.clear();
    }
  }
  initSignature() {
    return __async(this, null, function* () {
      return new Promise((res, rej) => __async(this, null, function* () {
        if (this.fieldId != null && this.documentId != null && this.name != null) {
          this.signature = yield this.documentService.initSignature(this.name, this.fieldId, this.documentId);
          res();
        } else {
          rej();
        }
      }));
    });
  }
  initPad() {
    setTimeout(() => {
      const signaturePadElm = this.signaturePadElm?.nativeElement;
      if (signaturePadElm != null) {
        this.signaturePad = new SignaturePad(signaturePadElm, {
          minWidth: 1.5,
          maxWidth: 4,
          penColor: "rgb(0,0,0)"
        });
        this.signaturePad.addEventListener("endStroke", () => {
          this.timestamp = /* @__PURE__ */ new Date();
          this.canSaveSignature = true;
        });
        this.resizeSignature();
      }
    }, 0);
  }
  exportSignature() {
    if (this.signaturePad != null) {
      return this.signaturePad.toDataURL("image/svg+xml");
    }
    return void 0;
  }
  updateDocumentSignature() {
    if (this.signature != null) {
      if (this.drawingNew) {
        const signature_B64 = this.exportSignature();
        this.signature.signature_B64 = signature_B64;
      } else if (this.signer?.signature_B64 != null) {
        this.signature.signature_B64 = this.signer.signature_B64;
      }
      this.signature = this.documentService.signSignature(this.signature);
    }
  }
  get name() {
    return this.signer?.fullName;
  }
  reset() {
    this.clearSignature();
    this.timestamp = void 0;
    this.canSaveSignature = false;
    if (this.signer?.signature_B64 != null) {
      this.drawingNew = false;
      this.canSaveSignature = true;
    }
  }
  closeView() {
    this.reset();
    this.close.next(void 0);
  }
  save() {
    if (this.drawingNew) {
      const signature_B64 = this.exportSignature();
      if (signature_B64 != null) {
        this.updateDocumentSignature();
        this.close.next(this.signature);
      } else {
        this.close.next(void 0);
      }
    } else if (this.signer?.signature_B64 != null) {
      this.updateDocumentSignature();
      this.close.next(this.signature);
    } else {
      this.close.next(void 0);
    }
  }
  init() {
    this.reset();
    this.initSignature().then((e) => {
      this.initialized = true;
      this.initPad();
    });
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_SignaturePadComponent.\u0275fac = function SignaturePadComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SignaturePadComponent)(\u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService));
};
_SignaturePadComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SignaturePadComponent, selectors: [["signature-pad"]], viewQuery: function SignaturePadComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
    \u0275\u0275viewQuery(_c1, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.signaturePadElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { fieldId: "fieldId", documentId: "documentId", signer: "signer" }, outputs: { close: "close" }, standalone: false, decls: 1, vars: 1, consts: [["signaturePadElm", ""], [1, "signature-pad"], [1, "pad"], [1, "tabs"], [1, "tab", "drawing", 3, "click"], [1, "tab", "using", 3, "click", "disabled"], [1, "using"], [1, "controls"], [1, "control", 3, "click"], [1, "control", "success", 3, "click", "disabled"], [1, "value"], ["id", "signaturePad", "width", "1990", "height", "600"], [1, "fa-solid", "fa-eraser"], [3, "width", "height"], [3, "src"]], template: function SignaturePadComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, SignaturePadComponent_Conditional_0_Template, 22, 9, "div", 1);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.initialized ? 0 : -1);
  }
}, styles: ['\n\n.signature-pad[_ngcontent-%COMP%] {\n  position: relative;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  padding: 1vw;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt1);\n  font-weight: var(--strong);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  background-color: var(--color2Alt3);\n  border-radius: 999px;\n  padding: 0.5vw;\n  position: relative;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]:before {\n  content: "";\n  position: absolute;\n  top: 0.5vw;\n  left: 0.5vw;\n  right: auto;\n  bottom: 0.5vw;\n  width: calc(50% - 0.5vw);\n  background-color: var(--color2);\n  border-radius: 999px;\n  -moz-transition: transform 0.25s linear;\n  -o-transition: transform 0.25s linear;\n  -webkit-transition: transform 0.25s linear;\n  transition: transform 0.25s linear;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%] {\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  cursor: pointer;\n  padding: 0.5vw;\n  text-align: center;\n  position: relative;\n  z-index: 1;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.drawing[_ngcontent-%COMP%]:before {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.drawing[_ngcontent-%COMP%]    > .drawing[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.using[_ngcontent-%COMP%]:before {\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.using[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 0.5vw;\n  right: 0.5vw;\n  border-radius: 100%;\n  padding: 0.25vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  height: 2vw;\n  width: 2vw;\n  border-radius: 100%;\n  position: relative;\n  background-color: var(--color2);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color2Alt1);\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2Alt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color2Alt4);\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n.signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@media only screen and (max-width: 768px) {\n  .signature-pad[_ngcontent-%COMP%] {\n    padding: 2vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    font-size: 4vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%] {\n    margin-top: 2vw;\n    border-radius: 999px;\n    padding: 1vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]:before {\n    width: calc(50% - 1vw);\n    top: 1vw;\n    left: 1vw;\n    right: auto;\n    bottom: 1vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%] {\n    padding: 1vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n    margin-top: 2vw;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n    margin-left: 2vw;\n    padding: 1.4vw 3vw;\n    border: 0.2vw transparent solid;\n  }\n  .signature-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n}\n/*# sourceMappingURL=signature-pad.component.css.map */'] });
var SignaturePadComponent = _SignaturePadComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SignaturePadComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "signature-pad", template: '@if (initialized) {\n  <div class="signature-pad">\n    <div class="pad">\n      <header>\n        <h2>Sign Here</h2>\n        @if (name != null) {\n          <h3>\n            Signatory: <span class="value">{{name}}</span>\n          </h3>\n        }\n      </header>\n      <div class="tabs" [class.drawing]="drawingNew" [class.using]="!drawingNew">\n        <button class="tab drawing" (click)="drawSignature()">\n          <label>Sign New Signature</label>\n        </button>\n        <button class="tab using"\n          (click)="useSignature()"\n          [disabled]="signer?.signature_B64 == null">\n          <label>Use My Signature</label>\n        </button>\n      </div>\n      @if (drawingNew) {\n        <div class="pad">\n          <canvas id="signaturePad" #signaturePadElm width="1990" height="600"></canvas>\n          <div class="controls">\n            <button class="control" (click)="clearSignature()">\n              <i class="fa-solid fa-eraser"></i>\n            </button>\n          </div>\n        </div>\n      }\n      @if (!drawingNew) {\n        <div class="using">\n          <canvas width="{{padWidth}}" height="{{padHeight}}"></canvas>\n          <img [src]="signer?.signature_B64" />\n        </div>\n      }\n    </div>\n    <div class="controls">\n      <button class="control" (click)="closeView()">\n        <label>Cancel</label>\n      </button>\n      <button class="control success" [disabled]="!canSaveSignature" (click)="save()">\n        <label>Save Signature</label>\n      </button>\n    </div>\n  </div>\n}', styles: ['/* src/app/shared/documents/components/signature-pad/signature-pad.component.scss */\n.signature-pad {\n  position: relative;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  padding: 1vw;\n}\n.signature-pad > .pad header h2 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.signature-pad > .pad header h3 {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt1);\n  font-weight: var(--strong);\n}\n.signature-pad > .pad > .tabs {\n  margin-top: 1vw;\n  display: flex;\n  background-color: var(--color2Alt3);\n  border-radius: 999px;\n  padding: 0.5vw;\n  position: relative;\n}\n.signature-pad > .pad > .tabs:before {\n  content: "";\n  position: absolute;\n  top: 0.5vw;\n  left: 0.5vw;\n  right: auto;\n  bottom: 0.5vw;\n  width: calc(50% - 0.5vw);\n  background-color: var(--color2);\n  border-radius: 999px;\n  -moz-transition: transform 0.25s linear;\n  -o-transition: transform 0.25s linear;\n  -webkit-transition: transform 0.25s linear;\n  transition: transform 0.25s linear;\n}\n.signature-pad > .pad > .tabs > .tab {\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  cursor: pointer;\n  padding: 0.5vw;\n  text-align: center;\n  position: relative;\n  z-index: 1;\n}\n.signature-pad > .pad > .tabs > .tab > label {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n.signature-pad > .pad > .tabs > .tab[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.signature-pad > .pad > .tabs > .tab:first-child {\n  margin-left: 0;\n}\n.signature-pad > .pad > .tabs.drawing:before {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n.signature-pad > .pad > .tabs.drawing > .drawing > label {\n  color: var(--color1);\n}\n.signature-pad > .pad > .tabs.using:before {\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n}\n.signature-pad > .pad > .tabs.using > .using > label {\n  color: var(--color1);\n}\n.signature-pad > .pad > .pad {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.signature-pad > .pad > .pad canvas {\n  width: 100%;\n}\n.signature-pad > .pad > .pad > .controls {\n  position: absolute;\n  bottom: 0.5vw;\n  right: 0.5vw;\n  border-radius: 100%;\n  padding: 0.25vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n}\n.signature-pad > .pad > .pad > .controls > .control {\n  height: 2vw;\n  width: 2vw;\n  border-radius: 100%;\n  position: relative;\n  background-color: var(--color2);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.signature-pad > .pad > .pad > .controls > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.signature-pad > .pad > .pad > .controls > .control:active {\n  background-color: var(--color2Alt1);\n}\n.signature-pad > .pad > .using {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.signature-pad > .pad > .using canvas {\n  width: 100%;\n}\n.signature-pad > .pad > .using img {\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.signature-pad > .controls {\n  margin-top: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n.signature-pad > .controls > .control {\n  margin-left: 0.5vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2Alt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.signature-pad > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.signature-pad > .controls > .control.success {\n  background-color: var(--success);\n}\n.signature-pad > .controls > .control.success > label {\n  color: var(--color2);\n}\n.signature-pad > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.signature-pad > .controls > .control:active {\n  background-color: var(--color2Alt4);\n}\n.signature-pad > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n.signature-pad > .controls > .control:first-child {\n  margin-left: 0;\n}\n@media only screen and (max-width: 768px) {\n  .signature-pad {\n    padding: 2vw;\n  }\n  .signature-pad > .pad > header h2 {\n    font-size: 4vw;\n  }\n  .signature-pad > .pad > header h3 {\n    font-size: 3vw;\n  }\n  .signature-pad > .pad > .tabs {\n    margin-top: 2vw;\n    border-radius: 999px;\n    padding: 1vw;\n  }\n  .signature-pad > .pad > .tabs:before {\n    width: calc(50% - 1vw);\n    top: 1vw;\n    left: 1vw;\n    right: auto;\n    bottom: 1vw;\n  }\n  .signature-pad > .pad > .tabs > .tab {\n    padding: 1vw;\n  }\n  .signature-pad > .pad > .tabs > .tab > label {\n    font-size: 3vw;\n  }\n  .signature-pad > .controls {\n    margin-top: 2vw;\n  }\n  .signature-pad > .controls > .control {\n    margin-left: 2vw;\n    padding: 1.4vw 3vw;\n    border: 0.2vw transparent solid;\n  }\n  .signature-pad > .controls > .control > label {\n    font-size: 3vw;\n  }\n}\n/*# sourceMappingURL=signature-pad.component.css.map */\n'] }]
  }], () => [{ type: ApiService }, { type: UiService }, { type: DocumentService }], { signaturePadElm: [{
    type: ViewChild,
    args: ["signaturePadElm"]
  }], fieldId: [{
    type: Input,
    args: ["fieldId"]
  }], documentId: [{
    type: Input,
    args: ["documentId"]
  }], signer: [{
    type: Input,
    args: ["signer"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SignaturePadComponent, { className: "SignaturePadComponent" });
})();

// src/app/shared/documents/components/initial-pad/initial-pad.component.ts
var _c02 = ["initialPadElm"];
var _c12 = ["componentElm"];
function InitialPadComponent_Conditional_0_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "h3");
    \u0275\u0275text(1, " Signatory: ");
    \u0275\u0275elementStart(2, "span", 10);
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r1.name);
  }
}
function InitialPadComponent_Conditional_0_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275element(1, "canvas", 11, 0);
    \u0275\u0275elementStart(3, "div", 7)(4, "button", 8);
    \u0275\u0275listener("click", function InitialPadComponent_Conditional_0_Conditional_13_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.clearInitials());
    });
    \u0275\u0275element(5, "i", 12);
    \u0275\u0275elementEnd()()();
  }
}
function InitialPadComponent_Conditional_0_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6);
    \u0275\u0275element(1, "canvas", 13)(2, "img", 14);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("width", \u0275\u0275interpolate(ctx_r1.padWidth))("height", \u0275\u0275interpolate(ctx_r1.padHeight));
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r1.signer == null ? null : ctx_r1.signer.initials_B64, \u0275\u0275sanitizeUrl);
  }
}
function InitialPadComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 1)(1, "div", 2)(2, "header")(3, "h2");
    \u0275\u0275text(4, "Initial Here");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(5, InitialPadComponent_Conditional_0_Conditional_5_Template, 4, 1, "h3");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 3)(7, "button", 4);
    \u0275\u0275listener("click", function InitialPadComponent_Conditional_0_Template_button_click_7_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.drawInitials());
    });
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Sign New Initials");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 5);
    \u0275\u0275listener("click", function InitialPadComponent_Conditional_0_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.useInitials());
    });
    \u0275\u0275elementStart(11, "label");
    \u0275\u0275text(12, "Use My Initials");
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(13, InitialPadComponent_Conditional_0_Conditional_13_Template, 6, 0, "div", 2);
    \u0275\u0275conditionalCreate(14, InitialPadComponent_Conditional_0_Conditional_14_Template, 3, 5, "div", 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "div", 7)(16, "button", 8);
    \u0275\u0275listener("click", function InitialPadComponent_Conditional_0_Template_button_click_16_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeView());
    });
    \u0275\u0275elementStart(17, "label");
    \u0275\u0275text(18, "Cancel");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "button", 9);
    \u0275\u0275listener("click", function InitialPadComponent_Conditional_0_Template_button_click_19_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.save());
    });
    \u0275\u0275elementStart(20, "label");
    \u0275\u0275text(21, "Save Initials");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx_r1.name != null ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("drawing", ctx_r1.drawingNew)("using", !ctx_r1.drawingNew);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", (ctx_r1.signer == null ? null : ctx_r1.signer.initials_B64) == null);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.drawingNew ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.drawingNew ? 14 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx_r1.canSaveSignature);
  }
}
var _InitialPadComponent = class _InitialPadComponent {
  constructor(systemService, uiService, documentService) {
    this.systemService = systemService;
    this.uiService = uiService;
    this.documentService = documentService;
    this.canSaveSignature = false;
    this.drawingNew = true;
    this.padWidth = 1200;
    this.padHeight = 900;
    this.fieldId = null;
    this.documentId = null;
    this.close = new Subject();
    this.initialized = false;
  }
  clearInitials() {
    if (this.initialPad != null) {
      this.initialPad.clear();
      this.canSaveSignature = false;
    }
  }
  drawInitials() {
    this.drawingNew = true;
    this.initPad();
  }
  useInitials() {
    this.drawingNew = false;
    this.canSaveSignature = this.signer?.initials_B64 != null;
  }
  resizeInitials() {
    const initialPadElm = this.initialPadElm?.nativeElement;
    if (this.initialPad != null && initialPadElm != null) {
      const ratio = Math.max(window.devicePixelRatio || 1, 1);
      this.padWidth = initialPadElm.offsetWidth * ratio;
      this.padHeight = initialPadElm.offsetHeight * ratio;
      initialPadElm.width = this.padWidth;
      initialPadElm.height = this.padHeight;
      initialPadElm.getContext("2d")?.scale(ratio, ratio);
      this.clearInitials();
    }
  }
  initPad() {
    setTimeout(() => {
      const initialPadElm = this.initialPadElm?.nativeElement;
      if (initialPadElm != null) {
        this.initialPad = new SignaturePad(initialPadElm, {
          minWidth: 1.5,
          maxWidth: 4,
          penColor: "rgb(0,0,0)"
        });
        this.initialPad.addEventListener("endStroke", () => {
          this.timestamp = /* @__PURE__ */ new Date();
          this.canSaveSignature = true;
        });
        this.resizeInitials();
      }
    }, 0);
  }
  initInitials() {
    return __async(this, null, function* () {
      return new Promise((res, rej) => __async(this, null, function* () {
        if (this.fieldId != null && this.documentId != null && this.signer != null) {
          this.initials = yield this.documentService.initSignature(this.name, this.fieldId, this.documentId);
          res();
        } else {
          res();
        }
      }));
    });
  }
  exportInitials() {
    if (this.initialPad != null) {
      return this.initialPad.toDataURL("image/svg+xml");
    }
    return void 0;
  }
  updateDocumentInitials() {
    if (this.initials != null) {
      if (this.drawingNew) {
        const signature_B64 = this.exportInitials();
        this.initials.signature_B64 = signature_B64;
      } else if (this.signer?.initials_B64 != null) {
        this.initials.signature_B64 = this.signer.initials_B64;
      }
      this.initials = this.documentService.signSignature(this.initials);
    }
  }
  get name() {
    return this.signer?.fullName;
  }
  reset() {
    this.clearInitials();
    this.timestamp = void 0;
    this.canSaveSignature = false;
    if (this.signer?.initials_B64 != null) {
      this.drawingNew = false;
      this.canSaveSignature = true;
    }
  }
  closeView() {
    this.reset();
    this.close.next(void 0);
  }
  save() {
    if (this.drawingNew) {
      const signature_B64 = this.exportInitials();
      if (signature_B64 != null) {
        this.updateDocumentInitials();
        this.close.next(this.initials);
      } else {
        this.close.next(void 0);
      }
    } else if (this.signer?.initials_B64 != null) {
      this.updateDocumentInitials();
      this.close.next(this.initials);
    } else {
      this.close.next(void 0);
    }
  }
  init() {
    this.reset();
    this.initInitials().then(() => {
      this.initialized = true;
      this.initPad();
    });
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_InitialPadComponent.\u0275fac = function InitialPadComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _InitialPadComponent)(\u0275\u0275directiveInject(SystemService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService));
};
_InitialPadComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _InitialPadComponent, selectors: [["initial-pad"]], viewQuery: function InitialPadComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
    \u0275\u0275viewQuery(_c12, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.initialPadElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { fieldId: "fieldId", documentId: "documentId", signer: "signer" }, outputs: { close: "close" }, standalone: false, decls: 1, vars: 1, consts: [["initialPadElm", ""], [1, "initial-pad"], [1, "pad"], [1, "tabs"], [1, "tab", "drawing", 3, "click"], [1, "tab", "using", 3, "click", "disabled"], [1, "using"], [1, "controls"], [1, "control", 3, "click"], [1, "control", "success", 3, "click", "disabled"], [1, "value"], ["id", "initialPad", "width", "1200", "height", "900"], [1, "fa-solid", "fa-eraser"], [3, "width", "height"], [3, "src"]], template: function InitialPadComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, InitialPadComponent_Conditional_0_Template, 22, 9, "div", 1);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.initialized ? 0 : -1);
  }
}, styles: ['\n\n.initial-pad[_ngcontent-%COMP%] {\n  position: relative;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  padding: 1vw;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]   header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt1);\n  font-weight: var(--strong);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  background-color: var(--color2Alt3);\n  border-radius: 999px;\n  padding: 0.5vw;\n  position: relative;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]:before {\n  content: "";\n  position: absolute;\n  top: 0.5vw;\n  left: 0.5vw;\n  right: auto;\n  bottom: 0.5vw;\n  width: calc(50% - 0.5vw);\n  background-color: var(--color2);\n  border-radius: 999px;\n  -moz-transition: transform 0.25s linear;\n  -o-transition: transform 0.25s linear;\n  -webkit-transition: transform 0.25s linear;\n  transition: transform 0.25s linear;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%] {\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  cursor: pointer;\n  padding: 0.5vw;\n  text-align: center;\n  position: relative;\n  z-index: 1;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.drawing[_ngcontent-%COMP%]:before {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.drawing[_ngcontent-%COMP%]    > .drawing[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.using[_ngcontent-%COMP%]:before {\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs.using[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 0.5vw;\n  right: 0.5vw;\n  border-radius: 100%;\n  padding: 0.25vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  height: 2vw;\n  width: 2vw;\n  border-radius: 100%;\n  position: relative;\n  background-color: var(--color2);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color2Alt1);\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .using[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2Alt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color2Alt4);\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n.initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@media only screen and (max-width: 768px) {\n  .initial-pad[_ngcontent-%COMP%] {\n    padding: 2vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    font-size: 4vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%] {\n    margin-top: 2vw;\n    border-radius: 999px;\n    padding: 1vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]:before {\n    width: calc(50% - 1vw);\n    top: 1vw;\n    left: 1vw;\n    right: auto;\n    bottom: 1vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%] {\n    padding: 1vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .pad[_ngcontent-%COMP%]    > .tabs[_ngcontent-%COMP%]    > .tab[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n    margin-top: 2vw;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n    margin-left: 2vw;\n    padding: 1.4vw 3vw;\n    border: 0.2vw transparent solid;\n  }\n  .initial-pad[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n}\n/*# sourceMappingURL=initial-pad.component.css.map */'] });
var InitialPadComponent = _InitialPadComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(InitialPadComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "initial-pad", template: '@if (initialized) {\n  <div class="initial-pad">\n    <div class="pad">\n      <header>\n        <h2>Initial Here</h2>\n        @if (name != null) {\n          <h3>\n            Signatory: <span class="value">{{name}}</span>\n          </h3>\n        }\n      </header>\n      <div class="tabs" [class.drawing]="drawingNew" [class.using]="!drawingNew">\n        <button class="tab drawing" (click)="drawInitials()">\n          <label>Sign New Initials</label>\n        </button>\n        <button class="tab using"\n          (click)="useInitials()"\n          [disabled]="signer?.initials_B64 == null">\n          <label>Use My Initials</label>\n        </button>\n      </div>\n      @if (drawingNew) {\n        <div class="pad">\n          <canvas id="initialPad" #initialPadElm width="1200" height="900"></canvas>\n          <div class="controls">\n            <button class="control" (click)="clearInitials()">\n              <i class="fa-solid fa-eraser"></i>\n            </button>\n          </div>\n        </div>\n      }\n      @if (!drawingNew) {\n        <div class="using">\n          <canvas width="{{padWidth}}" height="{{padHeight}}"></canvas>\n          <img [src]="signer?.initials_B64" />\n        </div>\n      }\n    </div>\n    <div class="controls">\n      <button class="control" (click)="closeView()">\n        <label>Cancel</label>\n      </button>\n      <button class="control success" [disabled]="!canSaveSignature" (click)="save()">\n        <label>Save Initials</label>\n      </button>\n    </div>\n  </div>\n}', styles: ['/* src/app/shared/documents/components/initial-pad/initial-pad.component.scss */\n.initial-pad {\n  position: relative;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  padding: 1vw;\n}\n.initial-pad > .pad header h2 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.initial-pad > .pad header h3 {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt1);\n  font-weight: var(--strong);\n}\n.initial-pad > .pad > .tabs {\n  margin-top: 1vw;\n  display: flex;\n  background-color: var(--color2Alt3);\n  border-radius: 999px;\n  padding: 0.5vw;\n  position: relative;\n}\n.initial-pad > .pad > .tabs:before {\n  content: "";\n  position: absolute;\n  top: 0.5vw;\n  left: 0.5vw;\n  right: auto;\n  bottom: 0.5vw;\n  width: calc(50% - 0.5vw);\n  background-color: var(--color2);\n  border-radius: 999px;\n  -moz-transition: transform 0.25s linear;\n  -o-transition: transform 0.25s linear;\n  -webkit-transition: transform 0.25s linear;\n  transition: transform 0.25s linear;\n}\n.initial-pad > .pad > .tabs > .tab {\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  cursor: pointer;\n  padding: 0.5vw;\n  text-align: center;\n  position: relative;\n  z-index: 1;\n}\n.initial-pad > .pad > .tabs > .tab > label {\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n.initial-pad > .pad > .tabs > .tab[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.initial-pad > .pad > .tabs > .tab:first-child {\n  margin-left: 0;\n}\n.initial-pad > .pad > .tabs.drawing:before {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n.initial-pad > .pad > .tabs.drawing > .drawing > label {\n  color: var(--color1);\n}\n.initial-pad > .pad > .tabs.using:before {\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n}\n.initial-pad > .pad > .tabs.using > .using > label {\n  color: var(--color1);\n}\n.initial-pad > .pad > .pad {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.initial-pad > .pad > .pad canvas {\n  width: 100%;\n}\n.initial-pad > .pad > .pad > .controls {\n  position: absolute;\n  bottom: 0.5vw;\n  right: 0.5vw;\n  border-radius: 100%;\n  padding: 0.25vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n}\n.initial-pad > .pad > .pad > .controls > .control {\n  height: 2vw;\n  width: 2vw;\n  border-radius: 100%;\n  position: relative;\n  background-color: var(--color2);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.initial-pad > .pad > .pad > .controls > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.initial-pad > .pad > .pad > .controls > .control:active {\n  background-color: var(--color2Alt1);\n}\n.initial-pad > .pad > .using {\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  position: relative;\n}\n.initial-pad > .pad > .using canvas {\n  width: 100%;\n}\n.initial-pad > .pad > .using img {\n  position: absolute;\n  top: 0;\n  left: 0;\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.initial-pad > .controls {\n  margin-top: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n.initial-pad > .controls > .control {\n  margin-left: 0.5vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2Alt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n.initial-pad > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.initial-pad > .controls > .control.success {\n  background-color: var(--success);\n}\n.initial-pad > .controls > .control.success > label {\n  color: var(--color2);\n}\n.initial-pad > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n.initial-pad > .controls > .control:active {\n  background-color: var(--color2Alt4);\n}\n.initial-pad > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n.initial-pad > .controls > .control:first-child {\n  margin-left: 0;\n}\n@media only screen and (max-width: 768px) {\n  .initial-pad {\n    padding: 2vw;\n  }\n  .initial-pad > .pad > header h2 {\n    font-size: 4vw;\n  }\n  .initial-pad > .pad > header h3 {\n    font-size: 3vw;\n  }\n  .initial-pad > .pad > .tabs {\n    margin-top: 2vw;\n    border-radius: 999px;\n    padding: 1vw;\n  }\n  .initial-pad > .pad > .tabs:before {\n    width: calc(50% - 1vw);\n    top: 1vw;\n    left: 1vw;\n    right: auto;\n    bottom: 1vw;\n  }\n  .initial-pad > .pad > .tabs > .tab {\n    padding: 1vw;\n  }\n  .initial-pad > .pad > .tabs > .tab > label {\n    font-size: 3vw;\n  }\n  .initial-pad > .controls {\n    margin-top: 2vw;\n  }\n  .initial-pad > .controls > .control {\n    margin-left: 2vw;\n    padding: 1.4vw 3vw;\n    border: 0.2vw transparent solid;\n  }\n  .initial-pad > .controls > .control > label {\n    font-size: 3vw;\n  }\n}\n/*# sourceMappingURL=initial-pad.component.css.map */\n'] }]
  }], () => [{ type: SystemService }, { type: UiService }, { type: DocumentService }], { initialPadElm: [{
    type: ViewChild,
    args: ["initialPadElm"]
  }], fieldId: [{
    type: Input,
    args: ["fieldId"]
  }], documentId: [{
    type: Input,
    args: ["documentId"]
  }], signer: [{
    type: Input,
    args: ["signer"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(InitialPadComponent, { className: "InitialPadComponent" });
})();

// src/app/shared/documents/components/consent/consent.component.ts
var _ConsentComponent = class _ConsentComponent {
  constructor(uiService, documentService) {
    this.uiService = uiService;
    this.documentService = documentService;
    this.consenters = new BehaviorSubject([]);
    this.currentConsenters = [];
    this.close = new Subject();
  }
  watchConsenters() {
    this.consenterSubscription = this.consenters.subscribe({
      next: (consenters) => {
        this.initConsenters(consenters);
      }
    });
  }
  toggleConsent() {
    if (this.activeConsenter != null) {
      this.activeConsenter.consented = !this.activeConsenter.consented;
    }
  }
  findUnconsented() {
    return this.currentConsenters.find((x) => x.consent == null);
  }
  setActiveConsenter(consenter) {
    this.activeConsenter = consenter;
  }
  cancel() {
    this.uiService.prompt("Are you sure?", "You will not be able to complete your documents until you consent to electronic signature. Are you sure you want to go back?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.closeView();
        }
      }
    });
  }
  continue() {
    if (this.activeConsenter != null) {
      this.activeConsenter.consent = this.documentService.initConsent(this.activeConsenter.fullName);
      const unconsented = this.findUnconsented();
      if (unconsented == null) {
        this.closeView();
      } else {
        this.setActiveConsenter(unconsented);
      }
    }
  }
  initConsenters(consenters) {
    this.currentConsenters = consenters;
    const unconsented = this.findUnconsented();
    if (unconsented == null) {
      this.closeView();
    } else {
      this.setActiveConsenter(unconsented);
    }
  }
  closeView() {
    this.close.next(this.currentConsenters);
  }
  init() {
    this.watchConsenters();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.consenterSubscription?.unsubscribe();
  }
};
_ConsentComponent.\u0275fac = function ConsentComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ConsentComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService));
};
_ConsentComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ConsentComponent, selectors: [["signing-consent"]], inputs: { consenters: "consenters" }, outputs: { close: "close" }, standalone: false, decls: 22, vars: 4, consts: [["id", "consent"], [1, "logo"], ["src", "/assets/images/logo.svg"], [1, "content"], [1, "input-wrap", 3, "click"], [1, "checkbox"], [1, "fa-regular", "fa-square", "unchecked"], [1, "fa-regular", "fa-square-check", "checked"], [1, "consenter"], [1, "controls"], [1, "control", "alternate", 3, "click"], [1, "control", 3, "click", "disabled"]], template: function ConsentComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1);
    \u0275\u0275element(2, "img", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 3)(4, "p");
    \u0275\u0275text(5, " By agreeing to use electronic records and signatures, I acknowledge that my electronic signature is legally enforceable and has the same legal effect as a handwritten signature in all applicable transactions, as permitted under the Electronic Signatures in Global and National Commerce Act (E-SIGN) and the Uniform Electronic Transactions Act (UETA). ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 4);
    \u0275\u0275listener("click", function ConsentComponent_Template_div_click_6_listener() {
      return ctx.toggleConsent();
    });
    \u0275\u0275elementStart(7, "div", 5);
    \u0275\u0275element(8, "i", 6)(9, "i", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "label");
    \u0275\u0275text(11, " I, ");
    \u0275\u0275elementStart(12, "span", 8);
    \u0275\u0275text(13);
    \u0275\u0275elementEnd();
    \u0275\u0275text(14, ", agree to use electronic records and signatures. ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(15, "div", 9)(16, "button", 10);
    \u0275\u0275listener("click", function ConsentComponent_Template_button_click_16_listener() {
      return ctx.cancel();
    });
    \u0275\u0275elementStart(17, "label");
    \u0275\u0275text(18, "Go Back");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "button", 11);
    \u0275\u0275listener("click", function ConsentComponent_Template_button_click_19_listener() {
      return ctx.continue();
    });
    \u0275\u0275elementStart(20, "label");
    \u0275\u0275text(21, "Continue");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(6);
    \u0275\u0275classProp("checked", ctx.activeConsenter == null ? null : ctx.activeConsenter.consented);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate(ctx.activeConsenter == null ? null : ctx.activeConsenter.fullName);
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", !(ctx.activeConsenter == null ? null : ctx.activeConsenter.consented));
  }
}, styles: ['\n\n#consent[_ngcontent-%COMP%] {\n  padding: 2vw;\n}\n#consent[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 10vh;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  text-decoration: underline;\n  font-weight: var(--strong);\n  cursor: pointer;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .checkbox[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .checkbox[_ngcontent-%COMP%]    > i.checked[_ngcontent-%COMP%] {\n  display: none;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]    > .consenter[_ngcontent-%COMP%] {\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strongest);\n  text-transform: uppercase;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .checkbox[_ngcontent-%COMP%]    > i.checked[_ngcontent-%COMP%] {\n  display: block;\n}\n#consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .checkbox[_ngcontent-%COMP%]    > i.unchecked[_ngcontent-%COMP%] {\n  display: none;\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--success);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@media only screen and (max-width: 768px) {\n  #consent[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n    height: 7vh;\n  }\n  #consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n    margin-top: 4vw;\n  }\n  #consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n    font-size: 4vw;\n  }\n  #consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n    margin-top: 4vw;\n  }\n  #consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .checkbox[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n    font-size: 6vw;\n  }\n  #consent[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    margin-left: 2vw;\n    font-size: 4vw;\n  }\n  #consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n    margin-top: 2vw;\n  }\n  #consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n    margin-left: 2vw;\n    padding: 1.4vw 3vw;\n    border: 0.2vw transparent solid;\n  }\n  #consent[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n}\n/*# sourceMappingURL=consent.component.css.map */'] });
var ConsentComponent = _ConsentComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ConsentComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "signing-consent", template: `<section id="consent">
    <div class="logo">
        <img src="/assets/images/logo.svg" />
    </div>

    <div class="content">
        <p>
            By agreeing to use electronic records and signatures, I acknowledge that my electronic signature is
            legally enforceable and has the same legal effect as a handwritten signature in all applicable
            transactions, as permitted under the Electronic Signatures in Global and National Commerce Act
            (E-SIGN) and the Uniform Electronic Transactions Act (UETA).
        </p>
        <div class="input-wrap" (click)="toggleConsent()" [class.checked]="activeConsenter?.consented">
            <div class="checkbox">
                <i class="fa-regular fa-square unchecked"></i>
                <i class="fa-regular fa-square-check checked"></i>
            </div>
            <label>
                I, <span class='consenter'>{{activeConsenter?.fullName}}</span>, agree to use electronic records and signatures.
            </label>
        </div>
    </div>
    <div class="controls">
        <button class="control alternate" (click)="cancel()">
            <label>Go Back</label>
        </button>
        <button class="control" [disabled]="!activeConsenter?.consented" (click)="continue()">
            <label>Continue</label>
        </button>
    </div>
</section>`, styles: ['/* src/app/shared/documents/components/consent/consent.component.scss */\n#consent {\n  padding: 2vw;\n}\n#consent > .logo img {\n  height: 10vh;\n}\n#consent > .content {\n  margin-top: 2vw;\n}\n#consent > .content > p {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n}\n#consent > .content > p > .control {\n  text-decoration: underline;\n  font-weight: var(--strong);\n  cursor: pointer;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n}\n#consent > .content > .input-wrap {\n  margin-top: 2vw;\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#consent > .content > .input-wrap > .checkbox > i {\n  font-size: 2.4vw;\n}\n#consent > .content > .input-wrap > .checkbox > i.checked {\n  display: none;\n}\n#consent > .content > .input-wrap > label {\n  margin-left: 1vw;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n}\n#consent > .content > .input-wrap > label > .consenter {\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strongest);\n  text-transform: uppercase;\n}\n#consent > .content > .input-wrap.checked > .checkbox > i.checked {\n  display: block;\n}\n#consent > .content > .input-wrap.checked > .checkbox > i.unchecked {\n  display: none;\n}\n#consent > .controls {\n  margin-top: 2vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#consent > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--success);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#consent > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#consent > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#consent > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#consent > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#consent > .controls > .control:first-child {\n  margin-left: 0;\n}\n@media only screen and (max-width: 768px) {\n  #consent > .logo img {\n    height: 7vh;\n  }\n  #consent > .content {\n    margin-top: 4vw;\n  }\n  #consent > .content > p {\n    font-size: 4vw;\n  }\n  #consent > .content > .input-wrap {\n    margin-top: 4vw;\n  }\n  #consent > .content > .input-wrap > .checkbox > i {\n    font-size: 6vw;\n  }\n  #consent > .content > .input-wrap > label {\n    margin-left: 2vw;\n    font-size: 4vw;\n  }\n  #consent > .controls {\n    margin-top: 2vw;\n  }\n  #consent > .controls > .control {\n    margin-left: 2vw;\n    padding: 1.4vw 3vw;\n    border: 0.2vw transparent solid;\n  }\n  #consent > .controls > .control > label {\n    font-size: 3vw;\n  }\n}\n/*# sourceMappingURL=consent.component.css.map */\n'] }]
  }], () => [{ type: UiService }, { type: DocumentService }], { consenters: [{
    type: Input,
    args: ["consenters"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ConsentComponent, { className: "ConsentComponent" });
})();

// src/app/shared/documents/components/appointment-document/appointment-document.component.ts
var _c03 = ["viewerElm"];
var _c13 = ["staticElm"];
var _c2 = ["componentElm"];
function AppointmentDocumentComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 3);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", false);
  }
}
function AppointmentDocumentComponent_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 5);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("innerHtml", ctx_r0.documentContent, \u0275\u0275sanitizeHtml);
  }
}
function AppointmentDocumentComponent_Conditional_6_For_3_For_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 11);
  }
  if (rf & 2) {
    const field_r2 = ctx.$implicit;
    \u0275\u0275styleProp("left", field_r2.displayX)("top", field_r2.displayY)("width", field_r2.displayWidth)("height", field_r2.displayHeight);
    \u0275\u0275property("innerHTML", field_r2.contentHtml, \u0275\u0275sanitizeHtml);
  }
}
function AppointmentDocumentComponent_Conditional_6_For_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 7);
    \u0275\u0275element(1, "img", 8);
    \u0275\u0275elementStart(2, "div", 9);
    \u0275\u0275repeaterCreate(3, AppointmentDocumentComponent_Conditional_6_For_3_For_4_Template, 1, 9, "div", 10, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const page_r3 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("src", page_r3.src, \u0275\u0275sanitizeUrl);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(page_r3.fields);
  }
}
function AppointmentDocumentComponent_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6, 1);
    \u0275\u0275repeaterCreate(2, AppointmentDocumentComponent_Conditional_6_For_3_Template, 5, 1, "div", 7, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r0.activePages);
  }
}
var _AppointmentDocumentComponent = class _AppointmentDocumentComponent {
  constructor(uiService, documentService, contentService, currencyPipe, orderByPipe, sanitizer) {
    this.uiService = uiService;
    this.documentService = documentService;
    this.contentService = contentService;
    this.currencyPipe = currencyPipe;
    this.orderByPipe = orderByPipe;
    this.sanitizer = sanitizer;
    this.activePages = [];
    this.userContentValid = false;
    this.numberOfCheckboxes = {};
    this.numberOfTextboxes = {};
    this.initialCount = 0;
    this.numberOfInitials = {};
    this.signatureCount = 0;
    this.signaturesValid = false;
    this.numberOfSignatures = {};
    this.execute = true;
    this.rendered$ = new Subject();
    this.signing = true;
    this.changed$ = new Subject();
  }
  replaceJobId(content) {
    if (this.appointmentContent != null) {
      const labelRegex = /{{appointment.jobid.label}}/gi;
      const labelReplacement = `Estimate #`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.jobid}}/gi;
      const replacement = `${this.appointmentContent.jobId}`;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  get documents() {
    return this.appointmentContent?.documents ?? [];
  }
  get isDynamic() {
    if (this.document != null && this.document.dynamic && this.document.content != null) {
      return true;
    }
    return false;
  }
  calcStaticRatio(pageWidth) {
    const staticElm = this.staticElm?.nativeElement;
    if (staticElm != null) {
      const width = staticElm.offsetWidth;
      return width / pageWidth;
    }
    return 1;
  }
  initMapping(document2) {
    return new Promise((res, rej) => {
      setTimeout(() => __async(this, null, function* () {
        if (document2.mapping != null) {
          const mappedPages = [];
          for (var i = 0, len = document2.mapping.pages.length; i < len; i++) {
            const page = document2.mapping.pages[i];
            if (page.binary != null) {
              const binary = new ContentBinary(page.binary);
              const ratio = binary.width != null ? this.calcStaticRatio(binary.width) : 1;
              const mappedFields = [];
              page.fields.forEach((field) => __async(this, null, function* () {
                const mappedField = new DocumentFieldMapping(field, ratio);
                if (field.fieldId == null || field.content == null) {
                  if (mappedField.id != null) {
                    mappedField.content = yield this.replaceVariables(document2, mappedField.id);
                  }
                  if (mappedField.content != null) {
                    mappedField.fieldId = mappedField.content.match(/field='([0-9a-f-]{36})'/)?.[1] ?? void 0;
                  }
                }
                if (mappedField.content != null) {
                  mappedField.contentHtml = this.sanitizer.bypassSecurityTrustHtml(mappedField.content);
                }
                mappedFields.push(mappedField);
              }));
              const image = yield this.contentService.getImage(binary.src);
              let mappedPage;
              if (image != null) {
                mappedPage = {
                  fields: mappedFields,
                  binary,
                  src: image.localSrc
                };
                mappedPages.push(mappedPage);
              } else {
                mappedPage = {
                  fields: mappedFields,
                  binary,
                  src: binary.src
                };
                mappedPages.push(mappedPage);
              }
            }
          }
          this.activePages = mappedPages;
          document2.mapping.pages = mappedPages;
          setTimeout(() => {
            this.initSignatureElms();
            this.initIntialElms();
            res();
          }, 0);
        }
      }), 0);
    });
  }
  // #endregion
  // #region Additional Considerations
  replaceAdditionalConsiderations(content) {
    if (this.price != null && this.price.customItems.length > 0) {
      let markup = `
                <h3>Additional Considerations to Scope:</h3>
                <table class='additional-considerations'>
                <thead>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Quantity</th>
                </thead>
                <tbody>`;
      this.price.customItems.forEach((item) => {
        if (item.customerFacing) {
          markup = markup + `<tr class='consideration'>
                            <td>${item.name}</td>
                            <td>${item.description}</td>
                            <td>${item.quantity}</td>
                        </tr>`;
        }
      });
      markup = markup + "</tbody></table>";
      const acRegex = /{{price.customItems.customer}}/gi;
      content = content.replace(acRegex, markup);
    } else {
      const acRegex = /{{price.customItems.customer}}/gi;
      content = content.replace(acRegex, "");
    }
    return content;
  }
  // #endregion
  // #region Entity Details
  renderEntityDetailAttribute(entity, index, onlyCustomerFacing = false, parentEntity = null) {
    const customerFacingAttribute = entity.attributes.find((x) => x.customerFacing);
    if (!onlyCustomerFacing && entity.attributes.length > 0 || onlyCustomerFacing && customerFacingAttribute != null) {
      let markup = "";
      if (entity.type == PropertyEntityType.Unit) {
        markup = markup + "<tr class='spacer'><td></td></tr>";
      }
      if (parentEntity != null && parentEntity.type != PropertyEntityType.Property) {
        if (entity.type == PropertyEntityType.Room) {
          markup = markup + `<tr class='type ${entity.type}'>
                        <td>
                        <span class='parent'>${parentEntity.name}</span>
                        <span class='entity'>${entity.name} ${entity.number} Details</span>
                        </td>
                        </tr>`;
        } else {
          markup = markup + `<tr class='type ${entity.type}'>
                        <td>
                        <span class='parent'>${parentEntity.name}</span>
                        <span class='entity'>${entity.name} Details</span>
                        </td>
                        </tr>`;
        }
      } else if (entity.type == PropertyEntityType.Room) {
        markup = markup + `<tr class='type ${entity.type}'>
                    <td>
                    <span class='entity'>${entity.name} ${entity.number} Details</span>
                    </td>
                    </tr>`;
      } else {
        markup = markup + `<tr class='type ${entity.type}'>
                    <td>
                    <span class='entity'>${entity.name} Details</span>
                    </td>
                    </tr>`;
      }
      markup = markup + "<tr class='details'><td>";
      markup = markup + "<span class='attributes'>";
      entity.attributes.forEach((attribute) => {
        if ((!onlyCustomerFacing || attribute.customerFacing) && attribute.values.length > 0) {
          markup = markup + `<span class='attribute'>
                        <span class='name'>${attribute.name}</span>`;
          attribute.values.forEach((value) => {
            const sanitizedValue = value.toLowerCase();
            switch (sanitizedValue) {
              case "false":
                value = "No";
                break;
              case "true":
                value = "Yes";
                break;
            }
            markup = markup + `<span class='value'>${value}</span>`;
          });
          markup = markup + "</span>";
        }
      });
      markup = markup + "</span>";
      if (entity.fixtures.length > 0) {
        markup = markup + "<span class='fixtures'>";
        for (var j = 0, jlen = entity.fixtures.length; j < jlen; j++) {
          const fixture = entity.fixtures[j];
          markup = markup + `<span class='fixture'><span class='name'>${fixture.name} ${fixture.number} -</span>`;
          fixture.attributes.forEach((attribute) => {
            if ((!onlyCustomerFacing || attribute.customerFacing) && attribute.values.length > 0) {
              markup = markup + `<span class='attribute'>
                                <span class='name'>${attribute.name}</span>`;
              attribute.values.forEach((value) => {
                const sanitizedValue = value.toLowerCase();
                switch (sanitizedValue) {
                  case "false":
                    value = "No";
                    break;
                  case "true":
                    value = "Yes";
                    break;
                }
                markup = markup + `<span class='value'>${value}</span>`;
              });
              markup = markup + "</span>";
            }
          });
          markup = markup + "</span>";
        }
        markup = markup + "</span>";
      }
      markup = markup + "</td></tr>";
      return markup;
    }
    return "";
  }
  getEntityDetailsAttributes(entity = null, entities = [], parentEntity = null, onlyCustomerFacing = false, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderEntityDetailAttribute(entity, index, onlyCustomerFacing, parentEntity);
      note = note + this.getEntityDetailsAttributes(null, entity.entities, entity, onlyCustomerFacing, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        let note = this.renderEntityDetailAttribute(childEntity, index, onlyCustomerFacing, parentEntity);
        index = index + 1;
        note = note + this.getEntityDetailsAttributes(null, childEntity.entities, childEntity, onlyCustomerFacing, index);
        entityNotes = entityNotes + note;
      }
    }
    return entityNotes;
  }
  replaceEntityDetails(matchText, content, onlyCustomerFacing = false) {
    if (this.appointmentContent?.property?.entity != null) {
      let markup = `<table class="entity-details">`;
      markup = markup + this.getEntityDetailsAttributes(this.appointmentContent.job, [], null, onlyCustomerFacing, 1);
      markup = markup + this.getEntityDetailsAttributes(this.appointmentContent.property.entity, [], null, onlyCustomerFacing, 1) + "</table>";
      const regex = new RegExp(matchText, "g");
      const replacement = markup;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Attributes
  renderAttribute(entity, index, onlyCustomerFacing = false, parentEntity = null) {
    const customerFacingAttribute = entity.attributes.find((x) => x.customerFacing);
    if (!onlyCustomerFacing && entity.attributes.length > 0 || onlyCustomerFacing && customerFacingAttribute != null) {
      let markup = "";
      if (parentEntity != null) {
        if (parentEntity.type != PropertyEntityType.Property && parentEntity.type != PropertyEntityType.Structure && parentEntity.type != PropertyEntityType.Floor) {
          markup = `<div class='inspection-attribute'>
                        <h3>${parentEntity.name} ${parentEntity.number}</h3>
                        <h4>${entity.name} ${entity.number} Details</h4>`;
        } else {
          markup = `<div class='inspection-attribute'>
                        <h3>${parentEntity.name}</h3>
                        <h4>${entity.name} Details</h4>`;
        }
      } else {
        markup = `<div class='inspection-attribute'>
                    <h3>${entity.name} Details</h3>`;
      }
      entity.attributes.forEach((attribute) => {
        if (!onlyCustomerFacing || attribute.customerFacing) {
          markup = markup + `<div class='attribute'>
                        <label>${attribute.name}</label>`;
          attribute.values.forEach((value) => {
            markup = markup + `<span class='value'>${value}</span>`;
          });
          markup = markup + "</div>";
        }
      });
      markup = markup + "</div>";
      return markup;
    }
    return "";
  }
  getAttributes(entity = null, entities = [], parentEntity = null, onlyCustomerFacing = false, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderAttribute(entity, index, onlyCustomerFacing, parentEntity);
      note = note + this.getAttributes(null, entity.entities, entity, onlyCustomerFacing, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        if (childEntity.type != PropertyEntityType.Structure && childEntity.type != PropertyEntityType.Room) {
          let note = this.renderAttribute(childEntity, index, onlyCustomerFacing, parentEntity);
          index = index + 1;
          for (var j = 0, jlen = childEntity.fixtures.length; j < jlen; j++) {
            const fixture = childEntity.fixtures[j];
            note = note + this.renderAttribute(fixture, index, onlyCustomerFacing, childEntity);
          }
          note = note + this.getAttributes(null, childEntity.entities, childEntity, onlyCustomerFacing, index);
          entityNotes = entityNotes + note;
        } else if (childEntity.type != PropertyEntityType.Room) {
          index = index + 1;
          const note = this.getAttributes(null, childEntity.entities, childEntity, onlyCustomerFacing, index);
          entityNotes = entityNotes + note;
        }
      }
    }
    return entityNotes;
  }
  replaceAttributes(matchText, content, onlyCustomerFacing = false) {
    if (this.appointmentContent?.property?.entity != null) {
      let attributes = `<div class='inspection-attributes'>
                <div class='attributes'>`;
      attributes = attributes + this.getAttributes(this.appointmentContent.property.entity, [], null, onlyCustomerFacing, 1) + "</div></div>";
      const regex = new RegExp(matchText, "g");
      const replacement = attributes;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Photos
  renderPhoto(entity, index, parentEntity = null) {
    if (entity.photos_B64.length > 0 || entity.photos.length > 0) {
      let diagram = "";
      if (parentEntity != null) {
        if (parentEntity.type != PropertyEntityType.Property && parentEntity.type != PropertyEntityType.Structure && parentEntity.type != PropertyEntityType.Floor) {
          diagram = `<div class='inspection-photos'>
                        <h3>${parentEntity.name} ${parentEntity.number}</h3>
                        <h4>${entity.name} ${entity.number}</h4>
                        <div class='images'>`;
        } else {
          diagram = `<div class='inspection-photos'>
                        <h3>${parentEntity.name}</h3>
                        <h4>${entity.name} Photos</h4>
                        <div class='images'>`;
        }
      } else {
        diagram = `<div class='inspection-photos'>
                    <h3>${entity.name}</h3>`;
      }
      entity.photos.forEach((photo) => __async(null, null, function* () {
        const mappedPhoto = new ContentBinary(photo);
        diagram = diagram + `<div class='image'><img class="static" crossorigin="anonymous" src='${mappedPhoto.src}' /></div>`;
      }));
      entity.photos_B64.forEach((photo) => __async(null, null, function* () {
        diagram = diagram + `<div class='image'><img class="static" crossorigin="anonymous" src='${photo}' /></div>`;
      }));
      diagram = diagram + "</div></div>";
      return diagram;
    }
    return "";
  }
  renderPhotos(entity = null, entities = [], parentEntity = null, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderPhoto(entity, index, parentEntity);
      note = note + this.renderPhotos(null, entity.entities, entity, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        let note = this.renderPhoto(childEntity, index, parentEntity);
        index = index + 1;
        for (var j = 0, jlen = childEntity.fixtures.length; j < jlen; j++) {
          const fixture = childEntity.fixtures[j];
          note = note + this.renderPhoto(fixture, index, childEntity);
        }
        note = note + this.renderPhotos(null, childEntity.entities, childEntity, index);
        entityNotes = entityNotes + note;
      }
    }
    return entityNotes;
  }
  replacePhotos(matchText, content) {
    if (this.appointmentContent?.property?.entity != null) {
      let photos = `<div class='inspection-photos'>
                <h2>Property Photos</h2>
                <div class='photos'>`;
      photos = photos + this.renderPhotos(this.appointmentContent.job, [], null, 1) + "</div></div>";
      photos = photos + this.renderPhotos(this.appointmentContent.property.entity, [], null, 1) + "</div></div>";
      const regex = new RegExp(matchText, "g");
      const replacement = photos;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Diagrams
  renderDiagram(entity, index, parentEntity = null) {
    if (entity.localRender != null) {
      let diagram = "";
      if (parentEntity != null) {
        if (parentEntity.type != PropertyEntityType.Property && parentEntity.type != PropertyEntityType.Structure && parentEntity.type != PropertyEntityType.Floor) {
          diagram = `<div class='inspection-diagram'>
                        <h3>${parentEntity.name} ${parentEntity.number}</h3>
                        <h4>${entity.name} ${entity.number} Details</h4>
                        <div class='image'><img class='static' src='${entity.localRender}' /></div>`;
        } else {
          diagram = `<div class='inspection-diagram'>
                        <h3>${parentEntity.name}</h3>
                        <h4>${entity.name} Diagram</h4>
                        <div class='image'><img class='static' src='${entity.localRender}' /></div>`;
        }
      } else {
        diagram = `<div class='inspection-diagram'>
                    <h3>${entity.name}</h3>
                    <div class='image'><img class='static' src='${entity.localRender}' /></div>`;
      }
      diagram = diagram + "</div>";
      return diagram;
    }
    return "";
  }
  getDiagrams(entity = null, entities = [], parentEntity = null, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderDiagram(entity, index, parentEntity);
      note = note + this.getDiagrams(null, entity.entities, entity, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        if (childEntity.type != PropertyEntityType.Structure && childEntity.type != PropertyEntityType.Room) {
          let note = this.renderDiagram(childEntity, index, parentEntity);
          index = index + 1;
          note = note + this.getDiagrams(null, childEntity.entities, childEntity, index);
          entityNotes = entityNotes + note;
        } else if (childEntity.type != PropertyEntityType.Room) {
          index = index + 1;
          const note = this.getDiagrams(null, childEntity.entities, childEntity, index);
          entityNotes = entityNotes + note;
        }
      }
    }
    return entityNotes;
  }
  replaceDiagrams(matchText, content) {
    if (this.appointmentContent?.property?.entity != null) {
      let diagrams = `<div class='inspection-diagrams'>
                <h2>Property Diagrams</h2>
                <div class='diagrams'>`;
      diagrams = diagrams + this.getDiagrams(this.appointmentContent.property.entity, [], null, 1) + "</div></div>";
      const regex = new RegExp(matchText, "g");
      const replacement = diagrams;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Notes
  renderNote(precursor = "", entity, index, type) {
    let entityName = entity.name;
    if (entity.type != PropertyEntityType.Property && entity.type != PropertyEntityType.Unit && entity.type != PropertyEntityType.Structure && entity.type != PropertyEntityType.Floor) {
      entityName = `${entity.name} ${entity.number}`;
    }
    switch (type) {
      case "customer":
        {
          const customerNote = entity.notes[NoteAudience.Customer];
          if (customerNote != null && customerNote.length > 0) {
            if (this.document?.customerFacing) {
              const useSignatureRef = /* @__PURE__ */ new Date("2025-11-17T00:00:00");
              if (this.appointmentContent?.scheduled_Utc != null && this.appointmentContent.scheduled_Utc >= useSignatureRef) {
                return `<div class='customer-note'>
                            <label>${index}) ${precursor}${entityName} Note</label>
                            <span class='value'>${entity.notes[NoteAudience.Customer]}</span>
                            </div>
                            {{signature.customer.mandatory}}`;
              } else {
                return `<div class='customer-note'>
                            <label>${index}) ${precursor}${entityName} Note</label>
                            <span class='value'>${entity.notes[NoteAudience.Customer]}</span>
                            </div>
                            {{initial.customer.mandatory}}`;
              }
            } else {
              return `<div class='customer-note'>
                        <label>${index}) ${precursor}${entityName} Note</label>
                        <span class='value'>${entity.notes[NoteAudience.Customer]}</span>
                        </div>`;
            }
          }
        }
        break;
      case "shop":
        {
          const shopNote = entity.notes[NoteAudience.Shop];
          if (shopNote != null && shopNote.length > 0) {
            return `<div class='shop-note'>
                    <label>${index}) ${precursor}${entityName} Note</label>
                    <span class='value'>${entity.notes[NoteAudience.Shop]}</span>
                    </div>`;
          }
        }
        break;
    }
    return "";
  }
  getNotes(entity = null, entities = [], index = 1, type) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderNote("", entity, index, type);
      for (var j = 0, jlen = entity.fixtures.length; j < jlen; j++) {
        const fixture = entity.fixtures[j];
        index = index + 1;
        note = note + this.renderNote(`${entity.name} `, fixture, index, type);
      }
      note = note + this.getNotes(null, entity.entities, index + 1, type);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const entity2 = entities[i];
        let note = this.renderNote("", entity2, index, type);
        index = index + 1;
        for (var j = 0, jlen = entity2.fixtures.length; j < jlen; j++) {
          const fixture = entity2.fixtures[j];
          note = note + this.renderNote(`${entity2.name} `, fixture, index, type);
          index = index + 1;
        }
        note = note + this.getNotes(null, entity2.entities, index, type);
        entityNotes = entityNotes + note;
      }
    }
    return entityNotes;
  }
  replaceNotes(matchText, content, type) {
    let notes = "";
    if (this.appointmentContent?.property?.entity != null) {
      notes = this.getNotes(this.appointmentContent.property.entity, [], 1, type);
    }
    const regex = new RegExp(matchText, "g");
    let replacement = notes;
    if (replacement == "") {
      if (this.document?.customerFacing && type == "customer") {
        replacement = "<p>No verbal agreements have been made outside of this contract.</p>{{initial.customer.mandatory}}";
      }
    }
    content = content.replace(regex, replacement);
    return content;
  }
  generateCheckboxHtml(signer, mandatory = false) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const checkboxCount = this.numberOfCheckboxes[customerName] ?? 0;
            const fieldStr = `checkbox-${this.document.id}-${customerName}-${checkboxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='checkbox mandatory customer' field='${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='checkbox optional customer' field='${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: ${customerName}</label>
                            </div>`;
            }
            this.numberOfCheckboxes[customerName] = checkboxCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const checkboxCount = this.numberOfCheckboxes[consultantName] ?? 0;
            const fieldStr = `checkbox-${this.document.id}-${consultantName}-${checkboxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='checkbox mandatory customer' field='${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='checkbox optional customer' field='$${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: Repipe Consultant</label>
                            </div>`;
            }
            this.numberOfCheckboxes[consultantName] = checkboxCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceCheckboxes(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateCheckboxHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  generateTextboxHtml(signer, mandatory) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const textBoxCount = this.numberOfTextboxes[customerName] ?? 0;
            const fieldStr = `textbox-${this.document.id}-${customerName}-${textBoxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='input mandatory customer' field='${fieldId}'>
                            <textarea maxlength='100' rows='3' required='true'></textarea>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='input optional customer' field='${fieldId}'>
                            <textbox maxlength='100' rows='3' required='false'></textarea>
                            <label>Signatory: ${customerName}</label>
                        </div>`;
            }
            this.numberOfTextboxes[customerName] = textBoxCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const textBoxCount = this.numberOfTextboxes[consultantName] ?? 0;
            const fieldStr = `textbox-${this.document.id}-${consultantName}-${textBoxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='input mandatory consultant' field='${fieldId}'>
                            <textarea maxlength='100' rows='3' required='true'></textarea>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='input optional consultant' field='${fieldId}'>
                            <textarea maxlength='100' rows='3' required='false'></textarea>
                            <label>Signatory: Repipe Consultant</label>
                        </div>`;
            }
            this.numberOfTextboxes[consultantName] = textBoxCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceTextbox(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateTextboxHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  initInputElms() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      const checkboxElms = viewerElm.querySelectorAll(`.checkbox`);
      checkboxElms.forEach((checkboxElm) => {
        checkboxElm.addEventListener("click", () => {
          const signer = checkboxElm.getAttribute("signer");
          const fieldId = checkboxElm.getAttribute("field");
          if (signer != null && (this.signer == null || signer == this.signer) && fieldId != null && this.document != null) {
            const checked = checkboxElm.classList.contains("checked");
            const checkboxContent = this.documentService.initUserContent(signer, fieldId, this.document.id);
            if (checked) {
              checkboxElm.classList.remove("checked");
              checkboxContent.content = "false";
              if (checkboxElm.classList.contains("mandatory")) {
                checkboxElm.classList.remove("valid");
              }
            } else {
              checkboxElm.classList.add("checked");
              checkboxElm.classList.add("valid");
              checkboxContent.content = "true";
            }
            this.storeUserContent(checkboxContent);
          }
        });
      });
      const inputElms = viewerElm.querySelectorAll(".input");
      inputElms.forEach((inputElm) => {
        const input = inputElm.querySelector("input,textarea");
        if (input != null) {
          input.addEventListener("input", () => {
            const signer = inputElm.getAttribute("signer");
            const fieldId = inputElm.getAttribute("field");
            if (signer != null && (this.signer == null || signer == this.signer) && fieldId != null && this.document != null) {
              const inputContent = this.documentService.initUserContent(signer, fieldId, this.document.id);
              inputContent.content = input.value;
              if (input.value.length > 0) {
                inputElm.classList.add("valid");
              } else {
                inputElm.classList.remove("valid");
              }
              this.storeUserContent(inputContent);
            }
          });
        }
      });
    }
  }
  storeUserContent(userContent) {
    if (this.document != null) {
      const existingIndex = this.document.userContent.findIndex((x) => x.fieldId == userContent.fieldId);
      if (existingIndex > 0) {
        this.document.userContent[existingIndex] = userContent;
      } else {
        this.document.userContent.push(userContent);
      }
      this.changed$.next();
    }
  }
  restoreUserContent() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (this.document != null && viewerElm != null) {
      const missingContent = [];
      for (var i = 0, len = this.document.userContent.length; i < len; i++) {
        const userContent = this.document.userContent[i];
        const fieldElm = viewerElm.querySelector(`[field="${userContent.fieldId}"]`);
        let missing = fieldElm == null;
        if (fieldElm != null) {
          if (fieldElm.classList.contains("checkbox")) {
            if (userContent.content == "true") {
              fieldElm.classList.add("checked");
              fieldElm.classList.add("valid");
            } else {
              fieldElm.classList.remove("checked");
              if (fieldElm.classList.contains("mandatory")) {
                fieldElm.classList.remove("valid");
              }
            }
          } else if (fieldElm.classList.contains("input")) {
            const input = fieldElm.querySelector("input,textarea");
            if (input != null) {
              input.value = userContent.content ?? "";
              if (input.value.length > 0) {
                fieldElm.classList.add("valid");
              }
            }
          }
          fieldElm.classList.add("valid");
        }
        if (missing) {
          missingContent.push(i);
        }
      }
      missingContent.forEach((i2) => {
        if (this.document != null) {
          this.document.userContent = this.document.userContent.splice(i2, 1);
          this.changed$.next();
        }
      });
      this.setDocumentValidity();
    }
  }
  validateUserContent() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      let valid = true;
      const checkboxElms = viewerElm.querySelectorAll(`.checkbox`);
      checkboxElms.forEach((elm) => {
        if (elm.classList.contains("mandatory") && !elm.classList.contains("valid")) {
          valid = false;
        }
      });
      const inputElms = viewerElm.querySelectorAll(`.input`);
      inputElms.forEach((elm) => {
        if (elm.classList.contains("mandatory") && !elm.classList.contains("valid")) {
          valid = false;
        }
      });
      this.userContentValid = valid;
    }
  }
  watchInitials() {
    this.initialSubscription = this.documentService.initials.subscribe({
      next: (update) => {
        if (update.signature?.signature_B64 != null && update.signer != null) {
          this.renderInitials(update.signature, update.signer);
        }
      }
    });
  }
  storeSignerInitials(signer, initials_B64) {
    signer.initials_B64 = initials_B64;
  }
  renderInitials(initials, signer) {
    const viewerElm = this.viewerElm?.nativeElement;
    if (initials?.signature_B64 != null && viewerElm != null) {
      this.storeSignerInitials(signer, initials.signature_B64);
      this.storeSignature(initials);
      const fieldElm = viewerElm.querySelector(`.initials[field='${initials.fieldId}']`);
      const renderElm = fieldElm?.querySelector(".render");
      if (fieldElm != null && renderElm != null) {
        const html = `
                    <canvas width='4' height='3'></canvas>
                    <img src='${initials.signature_B64}' />
                    <div class='hash'>
                        ${initials.hash_SHA256}
                    </div>
                    <div class='timestamp'>
                        ${initials.timeStamp_Utc}
                    </div>
                `;
        renderElm.innerHTML = html;
        fieldElm.classList.add("valid");
      }
    }
    this.setDocumentValidity();
  }
  startInitialing(fieldId = null, name = null) {
    const signer = this.document?.signers.find((x) => x.fullName == name);
    if (signer != null && fieldId != null && this.document != null) {
      this.documentService.startInitialing(signer, fieldId, this.document.id);
    }
  }
  generateInitialHtml(signer, mandatory) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const initialCount = this.numberOfInitials[customerName] ?? 0;
            const fieldStr = `initial-${this.document.id}-${customerName}-${initialCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='initials mandatory customer' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='initials optional customer' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            }
            this.numberOfInitials[customerName] = initialCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const initialCount = this.numberOfInitials[consultantName] ?? 0;
            const fieldStr = `initial-${this.document.id}-${consultantName}-${initialCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='initials mandatory consultant' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='initials optional consultant' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            }
            this.numberOfInitials[consultantName] = initialCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceInitials(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateInitialHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  initIntialElms() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      const initialElms = viewerElm.querySelectorAll(`.initials`);
      this.initialCount = initialElms.length;
      initialElms.forEach((initialElm) => {
        const signer = initialElm.getAttribute("signer");
        if (this.appointmentContent?.recipient == null || this.appointmentContent.recipient.fullName == signer) {
          const renderElm = initialElm.querySelector(".render");
          if (renderElm != null) {
            renderElm.addEventListener("click", () => {
              const signer2 = initialElm.getAttribute("signer");
              const fieldId = initialElm.getAttribute("field");
              if (this.signer == null || signer2 == this.signer) {
                this.startInitialing(fieldId, signer2);
              }
            });
          }
        } else {
          initialElm.classList.add("disabled");
        }
      });
    }
  }
  watchSignatures() {
    this.signatureSubscription = this.documentService.signature.subscribe({
      next: (update) => {
        if (update.signature?.signature_B64 != null && update.signer != null) {
          this.renderSignature(update.signature, update.signer);
        }
      }
    });
  }
  storeSignerSignature(signer, signature_B64) {
    signer.signature_B64 = signature_B64;
  }
  renderSignature(signature, signer) {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null && signature.signature_B64 != null) {
      this.storeSignerSignature(signer, signature.signature_B64);
      this.storeSignature(signature);
      const signatureElm = viewerElm.querySelector(`.signature[field='${signature.fieldId}']`);
      const renderElm = signatureElm?.querySelector(".render");
      if (signatureElm != null && renderElm != null) {
        const html = `
                    <canvas width='16' height='6'></canvas>
                    <img src='${signature.signature_B64}' />
                    <div class='hash'>
                        ${signature.hash_SHA256}
                    </div>
                    <div class='timestamp'>
                        ${signature.timeStamp_Utc}
                    </div>
                `;
        renderElm.innerHTML = html;
        signatureElm.classList.add("valid");
      }
    }
    this.setDocumentValidity();
  }
  startSigning(fieldId = null, name) {
    const signer = this.document?.signers.find((x) => x.fullName == name);
    if (signer != null && fieldId != null && this.document != null) {
      this.documentService.startSigning(signer, fieldId, this.document.id);
    }
  }
  generateSignatureHtml(signer, mandatory) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const signatureCount = this.numberOfSignatures[customerName] ?? 0;
            const name = this.document.name.toLowerCase();
            let fieldStr = `signature-${this.document.id}-${customerName}-${signatureCount}`;
            if (name.includes("contract notes") && customerName.includes("Andrew")) {
              fieldStr = `initial-${this.document.id}-${customerName}-${signatureCount}`;
            }
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='signature mandatory customer' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='signature optional customer' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            }
            this.numberOfSignatures[customerName] = signatureCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const signatureCount = this.numberOfSignatures[consultantName] ?? 0;
            const fieldStr = `signature-${this.document.id}-${consultantName}-${signatureCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='signature mandatory consultant' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='signature optional consultant' field='${fieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            }
            this.numberOfSignatures[consultantName] = signatureCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceSignature(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    let counter = 1;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateSignatureHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  initSignatureElms() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      const signatureElms = viewerElm.querySelectorAll(`.signature`);
      this.signatureCount = signatureElms.length;
      signatureElms.forEach((signatureElm) => {
        const signer = signatureElm.getAttribute("signer");
        if (this.appointmentContent?.recipient == null || this.appointmentContent.recipient.fullName == signer) {
          const renderElm = signatureElm.querySelector(".render");
          if (renderElm != null) {
            renderElm.addEventListener("click", () => {
              const name = signatureElm.getAttribute("signer");
              const fieldId = signatureElm.getAttribute("field");
              if (this.signer == null || signer == this.signer) {
                this.startSigning(fieldId, name);
              }
            });
          }
        } else {
          signatureElm.classList.add("disabled");
        }
      });
    }
  }
  restoreSignatures() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (this.document != null && viewerElm != null) {
      const missingSignatures = [];
      for (var i = 0, len = this.document.signatures.length; i < len; i++) {
        const signature = this.document.signatures[i];
        const fieldElm = viewerElm.querySelector(`[field="${signature.fieldId}"]`);
        const renderElm = fieldElm?.querySelector(".render");
        if (fieldElm != null && renderElm != null) {
          let html = "";
          if (fieldElm.classList.contains("initials")) {
            html = `
                            <canvas width='4' height='3'></canvas>
                            <img src='${signature.signature_B64}' />
                            <div class='hash'>
                                ${signature.hash_SHA256}
                            </div>
                            <div class='timestamp'>
                                ${signature.timeStamp_Utc}
                            </div>
                        `;
          } else {
            html = `
                            <canvas width='16' height='6'></canvas>
                            <img src='${signature.signature_B64}' />
                            <div class='hash'>
                                ${signature.hash_SHA256}
                            </div>
                            <div class='timestamp'>
                                ${signature.timeStamp_Utc}
                            </div>
                        `;
          }
          renderElm.innerHTML = html;
          fieldElm.classList.add("valid");
        } else {
          missingSignatures.push(i);
        }
      }
      this.setDocumentValidity();
    }
  }
  storeSignature(signature) {
    if (this.document != null) {
      const existingSignatureIndex = this.document.signatures.findIndex((x) => x.fieldId == signature.fieldId);
      if (existingSignatureIndex > 0) {
        this.document.signatures[existingSignatureIndex] = signature;
      } else {
        this.document.signatures.push(signature);
      }
      this.changed$.next();
    }
  }
  validateSignatures() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      let valid = true;
      const signatureElms = viewerElm.querySelectorAll(".signature,.initials");
      signatureElms.forEach((elm) => {
        if (elm.classList.contains("mandatory") && !elm.classList.contains("valid")) {
          valid = false;
        }
      });
      this.signaturesValid = valid;
    }
  }
  // #endregion
  // #region Headers
  replaceHeaders(content) {
    content = this.replaceH1(content);
    content = this.replaceH2(content);
    content = this.replaceH3(content);
    content = this.replaceH4(content);
    content = this.replaceH5(content);
    return content;
  }
  replaceH1(content) {
    const openH2Regex = /(&lt;h1&gt;)/gi;
    const closeH2Regex = /(&lt;\/h1&gt;)/gi;
    content = content.replace(openH2Regex, "<h1>");
    content = content.replace(closeH2Regex, "</h1>");
    return content;
  }
  replaceH2(content) {
    const openH2Regex = /(&lt;h2&gt;)/gi;
    const closeH2Regex = /(&lt;\/h2&gt;)/gi;
    content = content.replace(openH2Regex, "<h2>");
    content = content.replace(closeH2Regex, "</h2>");
    return content;
  }
  replaceH3(content) {
    const openH2Regex = /(&lt;h3&gt;)/gi;
    const closeH2Regex = /(&lt;\/h3&gt;)/gi;
    content = content.replace(openH2Regex, "<h3>");
    content = content.replace(closeH2Regex, "</h3>");
    return content;
  }
  replaceH4(content) {
    const openH2Regex = /(&lt;h4&gt;)/gi;
    const closeH2Regex = /(&lt;\/h4&gt;)/gi;
    content = content.replace(openH2Regex, "<h4>");
    content = content.replace(closeH2Regex, "</h4>");
    return content;
  }
  replaceH5(content) {
    const openH2Regex = /(&lt;h5&gt;)/gi;
    const closeH2Regex = /(&lt;\/h5&gt;)/gi;
    content = content.replace(openH2Regex, "<h5>");
    content = content.replace(closeH2Regex, "</h5>");
    return content;
  }
  // #endregion
  // #region Text Styling
  replaceTextTags(content) {
    const openH2Regex = /(&lt;strong&gt;)/gi;
    const closeH2Regex = /(&lt;\/strong&gt;)/gi;
    content = content.replace(openH2Regex, "<strong>");
    content = content.replace(closeH2Regex, "</strong>");
    return content;
  }
  replaceTextSizes(content) {
    const applyClassToParent = (variable, size) => {
      const parser = new DOMParser();
      const doc = parser.parseFromString(`<div>${content}</div>`, "text/html");
      const walker = doc.createTreeWalker(doc.body, NodeFilter.SHOW_TEXT);
      let nodesToProcess = [];
      while (walker.nextNode()) {
        const node = walker.currentNode;
        if (node.nodeValue?.includes(variable)) {
          nodesToProcess.push(node);
        }
      }
      nodesToProcess.forEach((node) => {
        node.nodeValue = node.nodeValue?.replace(/\[\[fontSize\.large\]\]/gi, "") ?? null;
        const parent = node.parentElement;
        const grandParent = parent?.parentElement;
        if (grandParent) {
          const existingClass = grandParent.getAttribute("class") || "";
          grandParent.setAttribute("class", existingClass ? `${existingClass} font-${size}` : `font-${size}`);
          parent.remove();
        }
      });
      return doc.body.innerHTML;
    };
    content = applyClassToParent("[[fontSize.small]]", "small");
    content = applyClassToParent("[[fontSize.medium]]", "medium");
    content = applyClassToParent("[[fontSize.large]]", "large");
    return content;
  }
  // #endregion
  // #region Horizontal Rows
  replaceHr(content) {
    const hrRegex = /{{hr}}/gi;
    content = content.replace(hrRegex, "<hr />");
    return content;
  }
  // #endregion
  // #region Labels
  replaceLabels(content) {
    const labelRegex = /(&lt;label&gt;)/gi;
    content = content.replace(labelRegex, "<label>");
    const endLabelRegex = /(&lt;\/label&gt;)/gi;
    content = content.replace(endLabelRegex, "</label>");
    return content;
  }
  // #endregion
  // #region Lists
  replaceLists(content) {
    content = this.replaceListVariables(content);
    const startRegex = /\[\[startList\]\]/gi;
    const startReplacement = `<div class='list'>`;
    const endRegex = /\[\[endList\]\]/gi;
    const endReplacement = `</div>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  replaceListVariables(content) {
    const tableRegex = /\[\[startList\]\]([\s\S]*?)\[\[endList\]\]/;
    const match = content.match(tableRegex);
    if (match != null && match[1] != null) {
      const tableContent = this.removeEmptyTags(match[1]);
      const replacedContent = tableContent.replace(/\{\{(.*?)\}\}/g, (match2, variable) => {
        return `<div class='list-item'>{{${variable}}}</div>`;
      });
      return content.replace(tableRegex, `[[startList]]${replacedContent}[[endList]]`);
    }
    return content;
  }
  // #endregion
  // #region Rows
  replaceRows(content) {
    const startRegex = /\[\[startRow\]\]/gi;
    const startReplacement = `<div class='row'>`;
    const endRegex = /\[\[endRow\]\]/gi;
    const endReplacement = `</div>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  // #endregion
  // #region Alignment
  replaceAlignment(content) {
    if (content.includes("startAlign.right")) {
      const startRegex = /\[\[startAlign.right\]\]/gi;
      const startReplacement = `<div class='align-right'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.right\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    if (content.includes("startAlign.left")) {
      const startRegex = /\[\[startAlign.left\]\]/gi;
      const startReplacement = `<div class='align-left'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.left\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    if (content.includes("startAlign.centered")) {
      const startRegex = /\[\[startAlign.center\]\]/gi;
      const startReplacement = `<div class='align-center'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.center\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    if (content.includes("startAlign.justified")) {
      const startRegex = /\[\[startAlign.justify\]\]/gi;
      const startReplacement = `<div class='align-justify'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.justify\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    return content;
  }
  // #endregion
  // #region Blocks
  replaceBlocks(content) {
    const startRegex = /\[\[startBlock\]\]/gi;
    const startReplacement = `<div class='block'>`;
    const endRegex = /\[\[endBlock\]\]/gi;
    const endReplacement = `</div>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  // #endregion
  // #region Tables
  replaceTables(content) {
    content = this.replaceTableVariables(content);
    const startRegex = /\[\[startTable\]\]/gi;
    const startReplacement = `<table class='standard'><tbody>`;
    const endRegex = /\[\[endTable\]\]/gi;
    const endReplacement = `</tbody></table>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  replaceTableVariables(content) {
    const tableRegex = /\[\[startTable\]\]([\s\S]*?)\[\[endTable\]\]/g;
    const matches = Array.from(content.matchAll(tableRegex)).map((match) => match[1]);
    for (var i = 0, len = matches.length; i < len; i++) {
      const match = matches[i];
      const replacedContent = match.replace(/\{\{(.*?)\}\}/gi, (m, variable) => {
        if (variable.indexOf("initial") < 0 && variable.indexOf("signature") < 0) {
          return `<tr><td class='label'>{{${variable}.label}}</td><td>{{${variable}}}</td></td>`;
        }
        return `{{${variable}}}`;
      });
      content = content.replace(match, replacedContent);
    }
    return content;
  }
  // #endregion
  // #region Payments
  get payments() {
    return this.appointmentContent?.payments ?? [];
  }
  replacePayments(content) {
    const firstPayment = this.payments[0];
    if (firstPayment != null) {
      const labelRegex = /{{appointment.payments.first.amount.label}}/gi;
      const labelReplacement = `${firstPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.first.amount}}/gi;
      const amount = this.currencyPipe.transform(firstPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment1Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.first.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.first.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    const secondPayment = this.payments[1];
    if (secondPayment != null) {
      const labelRegex = /{{appointment.payments.second.amount.label}}/gi;
      const labelReplacement = `${secondPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.second.amount}}/gi;
      const amount = this.currencyPipe.transform(secondPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment2Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.second.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.second.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    const thirdPayment = this.payments[2];
    if (thirdPayment != null) {
      const labelRegex = /{{appointment.payments.third.amount.label}}/gi;
      const labelReplacement = `${thirdPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.third.amount}}/gi;
      const amount = this.currencyPipe.transform(thirdPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment3Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.third.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.third.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    const fourthPayment = this.payments[4];
    if (fourthPayment != null) {
      const labelRegex = /{{appointment.payments.fourth.amount.label}}/gi;
      const labelReplacement = `${fourthPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.fourth.amount}}/gi;
      const amount = this.currencyPipe.transform(fourthPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment4Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.fourth.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.fourth.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  updatePaymentAmount(name, amount) {
    if (this.appointment?.paymentSetting != null) {
      const detail = this.appointment.paymentSetting.details.find((x) => x.name == name);
      if (detail != null) {
        detail.amount = amount;
        this.appointment.changed$.next();
      }
    }
  }
  // #endregion
  // #region Pricing
  get price() {
    return this.appointmentContent?.price;
  }
  replaceFinalPrice(content) {
    const labelRegex = /{{appointment.price.final.label}}/gi;
    const labelReplacement = `Contract Price`;
    content = content.replace(labelRegex, labelReplacement);
    const priceRegex = /{{appointment.price.final}}/gi;
    if (this.price != null) {
      const price = this.currencyPipe.transform(this.price.price, "USD", "symbol", "1.2-2") || "";
      content = content.replace(priceRegex, `${price}`);
    } else {
      content = content.replace(priceRegex, ``);
    }
    return content;
  }
  // #endregion   
  // #region Customer
  get customer() {
    return this.appointmentContent?.customer;
  }
  get email() {
    if (this.customer != null) {
      for (var i = 0, len = this.customer.contactInformation.length; i < len; i++) {
        const contactInfo = this.customer.contactInformation[i];
        if (contactInfo.type == ContactInformationType.Email) {
          return contactInfo.value;
        }
      }
    }
    return "";
  }
  get cellPhone() {
    if (this.customer != null) {
      for (var i = 0, len = this.customer.contactInformation.length; i < len; i++) {
        const contactInfo = this.customer.contactInformation[i];
        if (contactInfo.type == ContactInformationType.CellPhone) {
          return contactInfo.value;
        }
      }
    }
    return "";
  }
  get homePhone() {
    if (this.customer != null) {
      for (var i = 0, len = this.customer.contactInformation.length; i < len; i++) {
        const contactInfo = this.customer.contactInformation[i];
        if (contactInfo.type == ContactInformationType.HomePhone) {
          return contactInfo.value;
        }
      }
    }
    return "";
  }
  replaceCustomerName(content) {
    if (this.customer != null) {
      const labelRegex = /{{customer.name.label}}/gi;
      const labelReplacement = `Customer Name`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{customer.name}}/gi;
      const replacement = `${this.customer.firstName} ${this.customer.lastName}`;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  replaceCustomerEmail(content) {
    if (this.customer != null) {
      const labelRegex = /{{customer.email.label}}/gi;
      const labelReplacement = `Customer E-Mail`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{customer.email}}/gi;
      const replacement = this.email;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  replaceCustomerPhone(content) {
    if (this.customer != null) {
      const cellLabelRegex = /{{customer.phone.cell.label}}/gi;
      const cellLabelReplacement = `Customer Cell Phone`;
      content = content.replace(cellLabelRegex, cellLabelReplacement);
      const cellRegex = /{{customer.phone.cell}}/gi;
      const cellReplacement = this.cellPhone;
      content = content.replace(cellRegex, cellReplacement);
      const homeLabelRegex = /{{customer.phone.home.label}}/gi;
      const homeLabelReplacement = `Customer Home Phone`;
      content = content.replace(homeLabelRegex, homeLabelReplacement);
      const homeRegex = /{{customer.phone.home}}/gi;
      const homeReplacement = this.homePhone;
      content = content.replace(homeRegex, homeReplacement);
      const workLabelRegex = /{{customer.phone.work.label}}/gi;
      const workLabelReplacement = `Customer Work Phone`;
      content = content.replace(workLabelRegex, workLabelReplacement);
      const workRegex = /{{customer.phone.work}}/gi;
      const workReplacement = this.homePhone;
      content = content.replace(workRegex, workReplacement);
    }
    return content;
  }
  // #endregion
  // #region Consultant
  get consultant() {
    var consultant = this.appointmentContent?.consultant;
    return consultant;
  }
  replaceConsultantName(content) {
    if (this.consultant != null) {
      const labelRegex = /{{consultant.name.label}}/gi;
      const labelReplacement = `Consultant Name`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{consultant.name}}/gi;
      const replacement = `${this.consultant.firstName} ${this.consultant.lastName}`;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  replaceConsultantPhone(content) {
    if (this.consultant != null) {
      const labelRegex = /{{consultant.phone.label}}/gi;
      const labelReplacement = `Consultant Phone`;
      content = content.replace(labelRegex, labelReplacement);
      if (this.consultant.phone != null) {
        const regex = /{{consultant.phone}}/gi;
        const replacement = `${this.consultant.phone}`;
        content = content.replace(regex, replacement);
      } else {
        const regex = /{{consultant.phone}}/gi;
        content = content.replace(regex, "");
      }
    }
    return content;
  }
  replaceConsultantEmail(content) {
    if (this.consultant != null) {
      const labelRegex = /{{consultant.email.label}}/gi;
      const labelReplacement = `Consultant E-mail`;
      content = content.replace(labelRegex, labelReplacement);
      if (this.consultant.emailAddress) {
        const regex = /{{consultant.email}}/gi;
        const replacement = `${this.consultant.emailAddress}`;
        content = content.replace(regex, replacement);
      } else {
        const regex = /{{consultant.email}}/gi;
        content = content.replace(regex, "");
      }
    }
    return content;
  }
  // #endregion
  // #region Property
  get property() {
    return this.appointmentContent?.property;
  }
  get address() {
    if (this.property?.address != null) {
      return Object.assign(new Address(), this.property.address);
    }
    return void 0;
  }
  get billingAddress() {
    if (this.property?.address != null) {
      return Object.assign(new Address(), this.property.billingAddress);
    }
    return void 0;
  }
  get mailingAddress() {
    if (this.property?.address != null) {
      return Object.assign(new Address(), this.property.mailingAddress);
    }
    return void 0;
  }
  replaceAddresses(content) {
    if (this.property?.address != null) {
      const labelRegex = /{{property.address.label}}/gi;
      const labelReplacement = `Property Address`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{property.address}}/gi;
      const replacement = this.address?.friendlyAddress ?? "";
      content = content.replace(regex, replacement);
    }
    if (this.property?.billingAddress != null) {
      const labelRegex = /{{property.billingaddress.label}}/gi;
      const labelReplacement = `Billing Address`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{property.billingaddress}}/gi;
      const replacement = this.billingAddress?.friendlyAddress ?? "";
      content = content.replace(regex, replacement);
    }
    if (this.property?.mailingAddress != null) {
      const labelRegex = /{{property.mailingaddress.label}}/gi;
      const labelReplacement = `Mailing Address`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{property.mailingaddress}}/gi;
      const replacement = this.mailingAddress?.friendlyAddress ?? "";
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Content
  replaceLogo(content) {
    return new Promise((res, rej) => {
      const regex = /{{logo}}/gi;
      this.getImage(`/assets/images/logo.svg`).then((image) => {
        const replacement = `<div class="logo"><img class="static" crossorigin="anonymous" src="${image}" /></div>`;
        res(content.replace(regex, replacement));
      }).catch(() => {
        res("");
      });
    });
  }
  replaceDocumentName(name, content) {
    const regex = /{{document.name}}/gi;
    const replacement = `<h2>${name}</h2>`;
    return content.replace(regex, replacement);
  }
  replaceCustomerDocumentsReceived(content) {
    const regex = /{{customer.documentsReceived}}/gi;
    let replacement = "<span class='note'>Documents received by Customer: ";
    for (var i = 0, len = this.documents.length; i < len; i++) {
      const document2 = this.documents[i];
      if (document2.customerFacing) {
        if (i == 0) {
          replacement = replacement + `${document2.name}`;
        } else {
          replacement = replacement + `, ${document2.name}`;
        }
      }
    }
    replacement = replacement + "</span>";
    return content.replace(regex, replacement);
  }
  replaceAppointmentDates(content) {
    if (this.appointmentContent?.scheduled_Utc != null) {
      const labelRegex = /{{appointment.date.scheduled.label}}/gi;
      const labelReplacement = `Estimate Date`;
      content = content.replace(labelRegex, labelReplacement);
      const scheduledRegex = /{{appointment.date.scheduled}}/gi;
      const scheduledDate = new Date(this.appointmentContent.scheduled_Utc);
      const scheduledDateStr = `${scheduledDate.getUTCFullYear()}-${String(scheduledDate.getUTCMonth() + 1).padStart(2, "0")}-${String(scheduledDate.getUTCDate()).padStart(2, "0")} at ${String(scheduledDate.getUTCHours()).padStart(2, "0")}:${String(scheduledDate.getUTCMinutes()).padStart(2, "0")}:${String(scheduledDate.getUTCSeconds()).padStart(2, "0")} UTC`;
      content = content.replace(scheduledRegex, scheduledDateStr);
    }
    return content;
  }
  replaceTimestamp(content) {
    const labelRegex = /{{timestamp.label}}/gi;
    const labelReplacement = `Date`;
    content = content.replace(labelRegex, labelReplacement);
    const now = /* @__PURE__ */ new Date();
    const utcDate = new Date(now.toISOString());
    const year = utcDate.getUTCFullYear();
    const month = String(utcDate.getUTCMonth() + 1).padStart(2, "0");
    const day = String(utcDate.getUTCDate()).padStart(2, "0");
    const hours = String(utcDate.getUTCHours()).padStart(2, "0");
    const minutes = String(utcDate.getUTCMinutes()).padStart(2, "0");
    const seconds = String(utcDate.getUTCSeconds()).padStart(2, "0");
    const tsRegex = /{{timestamp}}/gi;
    const tsReplacement = `${year}-${month}-${day} at ${hours}:${minutes}:${seconds} UTC`;
    content = content.replace(tsRegex, tsReplacement);
    const tsdRegex = /{{timestamp.date}}/gi;
    const tsdreplacement = `${day}`;
    content = content.replace(tsdRegex, tsdreplacement);
    const tsmRegex = /{{timestamp.month}}/gi;
    const tsmReplacement = `${month}`;
    content = content.replace(tsmRegex, tsmReplacement);
    const tsyRegex = /{{timestamp.year}}/gi;
    const tsyReplacement = `${year}`;
    content = content.replace(tsyRegex, tsyReplacement);
    return content;
  }
  replaceVariables(document2, content) {
    return new Promise((res, rej) => __async(this, null, function* () {
      const regex = /\{\{(.*?)\}\}/gi;
      const variables = [];
      let match;
      while ((match = regex.exec(content)) !== null) {
        variables.push(match[0]);
      }
      for (var i = 0, len = variables.length; i < len; i++) {
        const variable = variables[i];
        if (variable.indexOf("customer.phone") > -1) {
          content = this.replaceCustomerPhone(content);
        }
        const sanitizedVariable = variable.toLowerCase();
        switch (sanitizedVariable) {
          case "{{logo}}":
            {
              content = yield this.replaceLogo(content);
            }
            break;
          case "{{document.name}}":
            {
              content = this.replaceDocumentName(document2.name, content);
            }
            break;
          case "{{inspection.diagrams}}":
            {
              content = this.replaceDiagrams("{{inspection.diagrams}}", content);
            }
            break;
          case "{{inspection.photos}}":
            {
              content = this.replacePhotos("{{inspection.photos}}", content);
            }
            break;
          case "{{inspection.attributes}}":
            {
              content = this.replaceAttributes("{{inspection.attributes}}", content, false);
            }
            break;
          case "{{inspection.attributes.customer}}":
            {
              content = this.replaceAttributes("{{inspection.attributes.customer}}", content, true);
            }
            break;
          case "{{entity.details.label}}":
            {
              content = content.replaceAll("{{entity.details.label}}", "Property Details");
            }
            break;
          case "{{entity.details}}":
            {
              content = this.replaceEntityDetails("{{entity.details}}", content, false);
            }
            break;
          case "{{entity.details.shop}}":
            {
              content = this.replaceEntityDetails("{{entity.details.shop}}", content, false);
            }
            break;
          case "{{entity.details.customer}}":
            {
              content = this.replaceEntityDetails("{{entity.details.customer}}", content, true);
            }
            break;
          case "{{customer.name}}":
            {
              content = this.replaceCustomerName(content);
            }
            break;
          case "{{checkbox.customer.optional}}":
            {
              content = this.replaceCheckboxes("{{checkbox.customer.optional}}", content, "customer", false);
            }
            break;
          case "{{checkbox.customer.mandatory}}":
            {
              content = this.replaceCheckboxes("{{checkbox.customer.mandatory}}", content, "customer", true);
            }
            break;
          case "{{checkbox.consultant.optional}}":
            {
              content = this.replaceCheckboxes("{{checkbox.consultant.optional}}", content, "consultant", false);
            }
            break;
          case "{{checkbox.consultant.mandatory}}":
            {
              content = this.replaceCheckboxes("{{checkbox.consultant.mandatory}}", content, "consultant", true);
            }
            break;
          case "{{textbox.consultant.optional}}":
            {
              content = this.replaceTextbox("{{textbox.consultant.optional}}", content, "consultant", false);
            }
            break;
          case "{{textbox.customer.optional}}":
            {
              content = this.replaceTextbox("{{textbox.customer.optional}}", content, "customer", false);
            }
            break;
          case "{{customer.email}}":
            {
              content = this.replaceCustomerEmail(content);
            }
            break;
          case "{{appointment.price.final}}":
            {
              content = this.replaceFinalPrice(content);
            }
            break;
          case "{{property.address}}":
            {
              content = this.replaceAddresses(content);
            }
            break;
          case "{{property.billingaddress}}":
            {
              content = this.replaceAddresses(content);
            }
            break;
          case "{{property.mailingaddress}}":
            {
              content = this.replaceAddresses(content);
            }
            break;
          case "{{consultant.name}}":
            {
              content = this.replaceConsultantName(content);
            }
            break;
          case "{{consultant.phone}}":
            {
              content = this.replaceConsultantPhone(content);
            }
            break;
          case "{{consultant.email}}":
            {
              content = this.replaceConsultantEmail(content);
            }
            break;
          case "{{appointment.jobid}}":
            {
              content = this.replaceJobId(content);
            }
            break;
          case "{{timestamp}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{timestamp.date}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{timestamp.month}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{timestamp.year}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{customer.documentsreceived}}":
            {
              content = this.replaceCustomerDocumentsReceived(content);
            }
            break;
          case "{{inspection.customernotes}}":
            {
              content = this.replaceNotes(variable, content, "customer");
            }
            break;
          case "{{inspection.shopnotes}}":
            {
              content = this.replaceNotes(variable, content, "shop");
            }
            break;
          case "{{signature.consultant.mandatory}}":
            {
              content = this.replaceSignature(variable, content, "consultant", true);
            }
            break;
          case "{{signature.consultant.optional}}":
            {
              content = this.replaceSignature(variable, content, "consultant", false);
            }
            break;
          case "{{initial.consultant.mandatory}}":
            {
              content = this.replaceInitials(variable, content, "consultant", true);
            }
            break;
          case "{{initial.consultant.optional}}":
            {
              content = this.replaceInitials(variable, content, "consultant", false);
            }
            break;
          case "{{signature.customer.mandatory}}":
            {
              content = this.replaceSignature(variable, content, "customer", true);
            }
            break;
          case "{{signature.customer.optional}}":
            {
              content = this.replaceSignature(variable, content, "customer", false);
            }
            break;
          case "{{initial.customer.mandatory}}":
            {
              content = this.replaceInitials(variable, content, "customer", true);
            }
            break;
          case "{{initial.customer.optional}}":
            {
              content = this.replaceInitials(variable, content, "customer", false);
            }
            break;
        }
      }
      res(content);
    }));
  }
  removeEmptyTags(content) {
    const regex = /<\/?p>/gi;
    return content.replace(regex, "");
  }
  removeEmptyLines(content) {
    const pRegex = /<p>\s*(<[^>]+>[\s\S]*?)<\/p>|<p>\s*<\/p>/gi;
    content = content.replace(pRegex, (match, innerContent) => innerContent || "");
    const bRegex = /<br\s*\/?>(\s*(?=<[^>]+>))/gi;
    content = content.replace(bRegex, "");
    return content;
  }
  replaceParagraphs(content) {
    const pRegex = /<p>/gi;
    content = content.replace(pRegex, '<div class="paragraph">');
    const pCloseRegex = /<\/p>/gi;
    content = content.replace(pCloseRegex, "</div>");
    return content;
  }
  generateContent(document2) {
    return __async(this, null, function* () {
      if (document2.content != null) {
        let generatedContent = this.replaceLabels(document2.content);
        generatedContent = this.replaceH2(generatedContent);
        generatedContent = this.replaceHr(generatedContent);
        generatedContent = this.replaceAlignment(generatedContent);
        generatedContent = this.replaceBlocks(generatedContent);
        generatedContent = this.replaceTables(generatedContent);
        generatedContent = this.replaceLists(generatedContent);
        generatedContent = this.replaceRows(generatedContent);
        generatedContent = yield this.replaceVariables(document2, generatedContent);
        generatedContent = yield this.replaceVariables(document2, generatedContent);
        generatedContent = this.replaceAppointmentDates(generatedContent);
        generatedContent = this.replacePayments(generatedContent);
        generatedContent = this.replaceAdditionalConsiderations(generatedContent);
        generatedContent = this.replaceHeaders(generatedContent);
        generatedContent = this.removeEmptyLines(generatedContent);
        generatedContent = this.replaceParagraphs(generatedContent);
        generatedContent = this.replaceTextTags(generatedContent);
        generatedContent = this.replaceTextSizes(generatedContent);
        generatedContent = generatedContent.replace(`<div class="paragraph">&nbsp;</div>`, "");
        return generatedContent;
      }
      return "";
    });
  }
  processContent(document2) {
    return __async(this, null, function* () {
      return new Promise((res, rej) => __async(this, null, function* () {
        if (document2.content != null) {
          let generatedContent = yield this.generateContent(document2);
          if (document2.documents != null) {
            for (var i = 0, len = document2.documents.length; i < len; i++) {
              const childDoc = document2.documents[i];
              generatedContent = generatedContent + (yield this.generateContent(childDoc));
            }
          }
          this.documentContent = this.sanitizer.bypassSecurityTrustHtml(generatedContent);
          document2.generatedContent = generatedContent;
          document2.originalHash = document2.hash;
        }
        setTimeout(() => {
          this.initSignatureElms();
          this.initIntialElms();
          this.initInputElms();
          this.changed$.next();
        }, 0);
        res();
      }));
    });
  }
  getImage(src) {
    return __async(this, null, function* () {
      const image = yield this.contentService.getImage(src);
      return image.localSrc;
    });
  }
  get rendered() {
    return this.document?.rendered ?? false;
  }
  renderDocument() {
    return new Promise((res, rej) => {
      setTimeout(() => __async(this, null, function* () {
        const viewerElm = this.viewerElm?.nativeElement;
        if (viewerElm != null) {
          const imgElms = viewerElm.querySelectorAll("img.static");
          let imagesRendered = 0;
          if (imgElms.length > 0) {
            for (var i = 0, len = imgElms.length; i < len; i++) {
              const imgElm = imgElms[i];
              const parentElm = imgElm.parentElement;
              const src = imgElm.src;
              const canvas = document.createElement("canvas");
              const ctx = canvas.getContext("2d", { willReadFrequently: true });
              if (src != null && parentElm != null && ctx != null) {
                const img = new Image();
                img.crossOrigin = "anonymous";
                img.onload = () => {
                  canvas.width = imgElm.offsetWidth;
                  canvas.height = imgElm.offsetHeight;
                  canvas.classList.add("no-render");
                  canvas.classList.add("local");
                  ctx.drawImage(img, 0, 0, imgElm.offsetWidth, imgElm.offsetHeight);
                  imgElm.remove();
                  parentElm.appendChild(canvas);
                  imagesRendered = imagesRendered + 1;
                  if (imagesRendered == imgElms.length) {
                    if (this.document != null) {
                      this.document.rendered = true;
                    }
                    setTimeout(() => {
                      res();
                    }, 256);
                  }
                };
                img.onerror = (e) => {
                  rej();
                };
                img.src = src;
              }
            }
          } else {
            if (this.document != null) {
              this.document.rendered = true;
            }
            res();
          }
        }
      }), 0);
    });
  }
  shimExport(viewerElm, count = 1) {
    return __async(this, null, function* () {
      if (this.document != null) {
        for (var i = 0; i < count; i++) {
          yield this.document.renderCanvas(viewerElm);
        }
      }
    });
  }
  exportDocument(quality = 1, pixelRatio = 1, count = 0) {
    return new Promise((res, rej) => {
      setTimeout(() => __async(this, null, function* () {
        if (this.document != null) {
          const viewerElm = this.viewerElm?.nativeElement;
          if (viewerElm != null) {
            toCanvas(viewerElm, {
              quality,
              pixelRatio,
              backgroundColor: "#ffffff",
              skipFonts: true,
              filter: (renderElm) => !renderElm.classList?.contains("no-render")
            }).then((finalRenderCanvas) => {
              const output = document.createElement("canvas");
              output.width = finalRenderCanvas.width;
              output.height = finalRenderCanvas.height;
              const ctx = output.getContext("2d", { willReadFrequently: true });
              const viewerRect = viewerElm.getBoundingClientRect();
              const renderRatio = viewerRect.width / finalRenderCanvas.width;
              ctx.fillStyle = "#ffffff";
              ctx.fillRect(0, 0, output.width, output.height);
              const localCanvases = Array.from(viewerElm.querySelectorAll("canvas"));
              for (const canvas of localCanvases) {
                const rect = canvas.getBoundingClientRect();
                const viewerRect2 = viewerElm.getBoundingClientRect();
                const x = (rect.left - viewerRect2.left) / renderRatio;
                const y = (rect.top - viewerRect2.top) / renderRatio;
                const width = canvas.width / renderRatio;
                const height = canvas.height / renderRatio;
                ctx.drawImage(canvas, x, y, width, height);
              }
              const temp = document.createElement("canvas");
              temp.width = finalRenderCanvas.width;
              temp.height = finalRenderCanvas.height;
              const tctx = temp.getContext("2d", { willReadFrequently: true });
              tctx.drawImage(finalRenderCanvas, 0, 0);
              const imgData = tctx.getImageData(0, 0, temp.width, temp.height);
              const data = imgData.data;
              for (let i = 0; i < data.length; i += 4) {
                if (data[i] === 255 && data[i + 1] === 255 && data[i + 2] === 255) {
                  data[i + 3] = 0;
                }
              }
              tctx.clearRect(0, 0, temp.width, temp.height);
              tctx.putImageData(imgData, 0, 0);
              ctx.drawImage(temp, 0, 0);
              res(output);
            }).catch(rej);
          }
        }
      }), 128);
    });
  }
  setDocumentValidity() {
    window.clearTimeout(this.documentValidityDebounce);
    this.documentValidityDebounce = window.setTimeout(() => {
      if (this.document != null) {
        this.validateSignatures();
        this.validateUserContent();
        if (this.signaturesValid && this.userContentValid && this.document.rendered) {
          this.document.validForExecution = true;
          this.document.executed = true;
        } else {
          this.document.validForExecution = false;
          this.document.executed = false;
          this.changed$.next();
        }
        this.document.checkedValidation = true;
      }
    }, 500);
  }
  initDocument() {
    return __async(this, null, function* () {
      if (this.document != null) {
        const document2 = this.document;
        document2.rendered = false;
        if (document2.dynamic) {
          yield this.processContent(document2);
        } else if (document2.mapping != null) {
          yield this.initMapping(document2);
        }
        setTimeout(() => __async(this, null, function* () {
          yield this.renderDocument();
          if (!document2.rendered) {
            this.uiService.prompt("Failed to Render", "There was an issue rendering this document. Please contact support for assistance.", "Ok").subscribe({
              next: (confirmed) => {
              }
            });
          }
          if (this.signing) {
            this.watchSignatures();
            this.watchInitials();
          }
          setTimeout(() => {
            if (this.signing) {
              this.restoreSignatures();
              this.restoreUserContent();
              this.setDocumentValidity();
            }
            this.rendered$.next();
            this.changed$.next();
          }, 256);
        }), 0);
      }
    });
  }
  get showLoader() {
    return true;
  }
  init() {
    this.initDocument();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.initialSubscription?.unsubscribe();
    this.signatureSubscription?.unsubscribe();
  }
};
_AppointmentDocumentComponent.\u0275fac = function AppointmentDocumentComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentDocumentComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(CurrencyPipe), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(DomSanitizer));
};
_AppointmentDocumentComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentDocumentComponent, selectors: [["appointment-document"]], viewQuery: function AppointmentDocumentComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
    \u0275\u0275viewQuery(_c13, 5);
    \u0275\u0275viewQuery(_c2, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.viewerElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.staticElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", appointmentContent: "appointmentContent", execute: "execute", document: "document", signer: "signer", signing: "signing" }, outputs: { rendered$: "rendered", changed$: "changed" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe,
  CurrencyPipe
])], decls: 7, vars: 5, consts: [["viewerElm", ""], ["staticElm", ""], [1, "document", "previewing"], [3, "fill"], ["id", "viewerElm", 1, "content", "render"], [1, "dynamic-content", 3, "innerHtml"], [1, "static-content"], [1, "page"], ["crossorigin", "anonymous", 1, "static", 3, "src"], [1, "fields"], [1, "field", 3, "left", "top", "width", "height", "innerHTML"], [1, "field", 3, "innerHTML"]], template: function AppointmentDocumentComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275conditionalCreate(1, AppointmentDocumentComponent_Conditional_1_Template, 1, 1, "loader", 3);
    \u0275\u0275elementStart(2, "div", 4, 0);
    \u0275\u0275elementContainerStart(4);
    \u0275\u0275conditionalCreate(5, AppointmentDocumentComponent_Conditional_5_Template, 1, 1, "div", 5);
    \u0275\u0275conditionalCreate(6, AppointmentDocumentComponent_Conditional_6_Template, 4, 0, "div", 6);
    \u0275\u0275elementContainerEnd();
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.rendered ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("rendered", ctx.rendered);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.isDynamic ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.isDynamic ? 6 : -1);
  }
}, dependencies: [LoaderComponent], styles: ['\n\n.document[_ngcontent-%COMP%] {\n  min-height: 100%;\n}\n.document[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 25%;\n  z-index: 0;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 2s;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  font-size: 1.6vw;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  opacity: 0;\n  pointer-events: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]     *:not(i) {\n  font-family:\n    "Times New Roman",\n    Times,\n    serif !important;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%] {\n  padding: 1vw;\n  background-color: var(--color2);\n  min-height: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo {\n  width: 24vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo img {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .paragraph {\n  margin-top: 2vw;\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     hr {\n  margin: 2vw 0;\n  height: 0.3vw;\n  box-shadow: none;\n  border: none;\n  background-color: var(--color1Alt3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h2 {\n  font-size: 3.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 1vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h3 {\n  font-size: 2.8vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 0.5vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small {\n  font-size: 1.2vw;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small * {\n  font-size: 1.2vw !important;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium {\n  font-size: 1.8vw;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium * {\n  font-size: 1.8vw !important;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large {\n  font-size: 2.4vw;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large * {\n  font-size: 2.4vw !important;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .note {\n  font-size: 1.6vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n  margin: 1ch 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .row {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .block {\n  display: block;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note {\n  position: relative;\n  padding-right: 40vw;\n  min-height: 10vw;\n  margin: 1ch 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > label {\n  display: block;\n  line-height: 1;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > .value {\n  display: block;\n  line-height: 1;\n  margin-top: 1ch;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams {\n  margin-top: 2vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > h2 {\n  font-size: 2.8vw;\n  font-weight: var(--stronger);\n  color: var(--color1);\n  margin-bottom: 1vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams {\n  margin-top: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram {\n  margin-top: 1vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n  font-size: 1.8vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > .image {\n  margin-top: 0.5vw;\n  border: 0.5vw var(--color4Alt4) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  font-size: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > .image img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > .image canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram:first-child {\n  margin-top: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos {\n  margin-top: 1vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h4 {\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images {\n  margin-top: 0.5vw;\n  font-size: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image {\n  display: inline-block;\n  vertical-align: top;\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  border: 0.5vw var(--color5Alt4) solid;\n  border-radius: 2vw;\n  overflow: hidden;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image canvas {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image:nth-child(odd) {\n  margin-left: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos:first-child {\n  margin-top: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .list {\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .list > .list-item {\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .spacer {\n  clear: both;\n  margin-top: 10vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials {\n  position: relative;\n  display: flex;\n  width: 100%;\n  justify-content: flex-end;\n  margin-bottom: 5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n  position: relative;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render canvas, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .hash, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .timestamp, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > label, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.mandatory > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.mandatory.consultant > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.valid > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.disabled, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.disabled {\n  pointer-events: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.disabled > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.disabled > .render {\n  background-color: var(--color2) !important;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render {\n  width: 20vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n  width: 10vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-left {\n  text-align: left;\n  display: flex;\n  justify-content: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-left > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-left * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-right {\n  text-align: right;\n  display: flex;\n  justify-content: flex-end;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-right > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-right * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-center {\n  text-align: center;\n  display: flex;\n  justify-content: center;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-center > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-center * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify {\n  text-align: justify;\n  display: flex;\n  justify-content: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard {\n  table-layout: auto;\n  max-width: 100%;\n  margin: 0.5vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr {\n  border-top: 0.2vw var(--color1Alt1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  border-left: 0.2vw var(--color1Alt1) solid;\n  padding: 0.5vw 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td.label {\n  background-color: var(--color3Alt3);\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td:first-child {\n  border-left-color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td:last-child {\n  border-right: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr:first-child {\n  border-top-color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr:last-child {\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr:nth-child(odd) {\n  background-color: var(--color2Alt1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details {\n  table-layout: fixed;\n  width: 100%;\n  margin: 0.5vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type {\n  border-top: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n  background-color: var(--color2Alt2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td {\n  padding: 0.5vw 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .parent {\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  text-transform: uppercase;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .entity {\n  font-size: 1.6vw;\n  color: var(--color1);\n  text-transform: uppercase;\n  font-weight: var(--strongest);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Structure {\n  background-color: rgba(var(--color4-raw), 0.25);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Structure > .type {\n  background-color: var(--color4);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Floor {\n  background-color: rgba(var(--color4Alt4-raw), 0.5);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Room {\n  background-color: rgba(var(--color3Alt1-raw), 0.5);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details {\n  background-color: var(--color2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td {\n  padding: 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  padding-right: 0.5vw;\n  border-right: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n  display: inline-block;\n  vertical-align: bottom;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n  margin-left: 0.5vw;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute:last-child {\n  border-right: none;\n  margin-right: 0;\n  padding-right: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .attributes {\n  display: block;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures {\n  display: block;\n  margin-top: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture {\n  display: block;\n  margin-top: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-left: 0.5vw var(--color5) solid;\n  border-right: 0.5vw var(--color5) solid;\n  border-radius: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  font-size: 2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--stronger);\n  text-transform: uppercase;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.spacer {\n  border: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.spacer > td {\n  padding: 2vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations {\n  table-layout: fixed;\n  width: 100%;\n  border: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead {\n  background-color: var(--color2Alt2);\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead th {\n  padding: 0.5vw;\n  text-align: left;\n  font-size: 1.6vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > tbody > tr {\n  border-bottom: 0.1vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > tbody > tr td {\n  padding: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > tbody > tr:nth-child(even) {\n  background-color: var(--color2Alt1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox i {\n  font-size: 3.2vw;\n  margin-right: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox i.checked {\n  display: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox.checked i.checked {\n  display: block;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox.checked i.unchecked {\n  display: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     input, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  border: 0.2vw var(--color1) solid;\n  color: var(--color3);\n  background-color: var(--color2);\n  border-radius: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     input:focus, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input textarea {\n  display: block;\n  width: 400px;\n  max-width: 100%;\n  font-size: 1.6vw;\n  font-weight: var(--stdweight);\n  padding: 0.5vw;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  resize: none;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input:focus-within textarea {\n  border-color: var(--color3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%] {\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]     canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  white-space: nowrap;\n  display: flex;\n  align-items: flex-end;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials {\n  position: absolute;\n  left: 0;\n  top: 0;\n  height: 100%;\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render canvas, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .hash, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .timestamp, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > label, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 0.7vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature.mandatory > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature.mandatory.consultant > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature.valid > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > img[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content.rendered[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n.float[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 10px;\n  right: 10px;\n  height: 10px;\n  width: 10px;\n  z-index: 9999999;\n  cursor: pointer;\n}\n@media only screen and (max-width: 768px) {\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%] {\n    padding: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo {\n    width: 24vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h2 {\n    font-size: 4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h3 {\n    font-size: 3.2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small * {\n    font-size: 1.6vw !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium {\n    font-size: 3.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium * {\n    font-size: 3.6vw !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large {\n    font-size: 4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large * {\n    font-size: 4vw !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .note {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > label {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > .value {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > h2 {\n    font-size: 3vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h3 {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h4 {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > label {\n    font-size: 1.4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render {\n    width: 20vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n    width: 10vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify > .block {\n    max-width: 50%;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify * {\n    text-align: initial;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 2.4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead th {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input textarea {\n    font-size: 2.4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%] {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render {\n    border-radius: 0.5vw;\n    padding: 0.5vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > label {\n    font-size: 0.7vw;\n  }\n}\n@media only screen and (min-width: 1201px) and (hover: hover) and (pointer: fine) {\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%] {\n    padding: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo {\n    width: 250px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h2 {\n    font-size: 36px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h3 {\n    font-size: 28px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small * {\n    font-size: 20px !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium {\n    font-size: 32px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium * {\n    font-size: 32px !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large {\n    font-size: 40px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large * {\n    font-size: 40px !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .note {\n    font-size: 26px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > label {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > .value {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > h2 {\n    font-size: 36px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h3 {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h4 {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > label {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render {\n    width: 260px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n    width: 150px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify > .block {\n    max-width: 50%;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify * {\n    text-align: initial;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead th {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input textarea {\n    font-size: 32px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%] {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render {\n    border-radius: 8px;\n    padding: 8px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > label {\n    font-size: 10px;\n  }\n}\n/*# sourceMappingURL=appointment-document.component.css.map */'] });
var AppointmentDocumentComponent = _AppointmentDocumentComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentDocumentComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "appointment-document", providers: [
      OrderByPipe,
      CurrencyPipe
    ], template: '<div class="document previewing">\n  @if (!rendered) {\n    <loader [fill]="false"></loader>\n  }\n  <div id="viewerElm" class="content render" #viewerElm [class.rendered]="rendered">\n    <ng-container>\n      @if (isDynamic) {\n        <div class="dynamic-content" [innerHtml]="documentContent"></div>\n      }\n      @if (!isDynamic) {\n        <div class="static-content" #staticElm>\n          @for (page of activePages; track page) {\n            <div class="page">\n              <img class="static" crossorigin="anonymous" [src]="page.src" />\n              <div class="fields">\n                @for (field of page.fields; track field) {\n                  <div class="field"\n                    [style.left]="field.displayX"\n                    [style.top]="field.displayY"\n                    [style.width]="field.displayWidth"\n                    [style.height]="field.displayHeight"\n                    [innerHTML]="field.contentHtml">\n                  </div>\n                }\n              </div>\n            </div>\n          }\n        </div>\n      }\n    </ng-container>\n  </div>\n</div>', styles: ['/* src/app/shared/documents/components/appointment-document/appointment-document.component.scss */\n.document {\n  min-height: 100%;\n}\n.document > loader {\n  display: block;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 25%;\n  z-index: 0;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 2s;\n}\n.document > .content {\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  font-size: 1.6vw;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  opacity: 0;\n  pointer-events: none;\n}\n.document > .content ::ng-deep *:not(i) {\n  font-family:\n    "Times New Roman",\n    Times,\n    serif !important;\n}\n.document > .content > .dynamic-content {\n  padding: 1vw;\n  background-color: var(--color2);\n  min-height: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .logo {\n  width: 24vw;\n}\n.document > .content > .dynamic-content ::ng-deep .logo img {\n  width: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .paragraph {\n  margin-top: 2vw;\n  position: relative;\n}\n.document > .content > .dynamic-content ::ng-deep hr {\n  margin: 2vw 0;\n  height: 0.3vw;\n  box-shadow: none;\n  border: none;\n  background-color: var(--color1Alt3);\n}\n.document > .content > .dynamic-content ::ng-deep h2 {\n  font-size: 3.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 1vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep h3 {\n  font-size: 2.8vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 0.5vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep .font-small {\n  font-size: 1.2vw;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-small * {\n  font-size: 1.2vw !important;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-medium {\n  font-size: 1.8vw;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-medium * {\n  font-size: 1.8vw !important;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-large {\n  font-size: 2.4vw;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-large * {\n  font-size: 2.4vw !important;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .note {\n  font-size: 1.6vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n  margin: 1ch 0;\n}\n.document > .content > .dynamic-content ::ng-deep .row {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n.document > .content > .dynamic-content ::ng-deep .block {\n  display: block;\n}\n.document > .content > .dynamic-content ::ng-deep .customer-note {\n  position: relative;\n  padding-right: 40vw;\n  min-height: 10vw;\n  margin: 1ch 0;\n}\n.document > .content > .dynamic-content ::ng-deep .customer-note > label {\n  display: block;\n  line-height: 1;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.document > .content > .dynamic-content ::ng-deep .customer-note > .value {\n  display: block;\n  line-height: 1;\n  margin-top: 1ch;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams {\n  margin-top: 2vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > h2 {\n  font-size: 2.8vw;\n  font-weight: var(--stronger);\n  color: var(--color1);\n  margin-bottom: 1vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams {\n  margin-top: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram {\n  margin-top: 1vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n  font-size: 1.8vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > .image {\n  margin-top: 0.5vw;\n  border: 0.5vw var(--color4Alt4) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  font-size: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > .image img,\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > .image canvas {\n  width: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram:first-child {\n  margin-top: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos {\n  margin-top: 1vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > h4 {\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images {\n  margin-top: 0.5vw;\n  font-size: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image {\n  display: inline-block;\n  vertical-align: top;\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  border: 0.5vw var(--color5Alt4) solid;\n  border-radius: 2vw;\n  overflow: hidden;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image img,\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image canvas {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image:nth-child(odd) {\n  margin-left: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos:first-child {\n  margin-top: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .list {\n  position: relative;\n}\n.document > .content > .dynamic-content ::ng-deep .list > .list-item {\n  position: relative;\n}\n.document > .content > .dynamic-content ::ng-deep .spacer {\n  clear: both;\n  margin-top: 10vw;\n}\n.document > .content > .dynamic-content ::ng-deep .signature,\n.document > .content > .dynamic-content ::ng-deep .initials {\n  position: relative;\n  display: flex;\n  width: 100%;\n  justify-content: flex-end;\n  margin-bottom: 5vw;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render,\n.document > .content > .dynamic-content ::ng-deep .initials > .render {\n  position: relative;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render canvas,\n.document > .content > .dynamic-content ::ng-deep .initials > .render canvas {\n  width: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render img,\n.document > .content > .dynamic-content ::ng-deep .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render .hash,\n.document > .content > .dynamic-content ::ng-deep .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render .timestamp,\n.document > .content > .dynamic-content ::ng-deep .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > label,\n.document > .content > .dynamic-content ::ng-deep .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .signature.mandatory > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document > .content > .dynamic-content ::ng-deep .signature.mandatory.consultant > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document > .content > .dynamic-content ::ng-deep .signature.valid > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document > .content > .dynamic-content ::ng-deep .signature.disabled,\n.document > .content > .dynamic-content ::ng-deep .initials.disabled {\n  pointer-events: none;\n}\n.document > .content > .dynamic-content ::ng-deep .signature.disabled > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.disabled > .render {\n  background-color: var(--color2) !important;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render {\n  width: 20vw;\n}\n.document > .content > .dynamic-content ::ng-deep .initials > .render {\n  width: 10vw;\n}\n.document > .content > .dynamic-content ::ng-deep .align-left {\n  text-align: left;\n  display: flex;\n  justify-content: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-left > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-left * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep .align-right {\n  text-align: right;\n  display: flex;\n  justify-content: flex-end;\n}\n.document > .content > .dynamic-content ::ng-deep .align-right > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.document > .content > .dynamic-content ::ng-deep .align-right * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep .align-center {\n  text-align: center;\n  display: flex;\n  justify-content: center;\n}\n.document > .content > .dynamic-content ::ng-deep .align-center > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.document > .content > .dynamic-content ::ng-deep .align-center * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep .align-justify {\n  text-align: justify;\n  display: flex;\n  justify-content: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-justify > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-justify * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard {\n  table-layout: auto;\n  max-width: 100%;\n  margin: 0.5vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr {\n  border-top: 0.2vw var(--color1Alt1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  border-left: 0.2vw var(--color1Alt1) solid;\n  padding: 0.5vw 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td.label {\n  background-color: var(--color3Alt3);\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td:first-child {\n  border-left-color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td:last-child {\n  border-right: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr:first-child {\n  border-top-color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr:last-child {\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr:nth-child(odd) {\n  background-color: var(--color2Alt1);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details {\n  table-layout: fixed;\n  width: 100%;\n  margin: 0.5vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type {\n  border-top: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n  background-color: var(--color2Alt2);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td {\n  padding: 0.5vw 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .parent {\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  text-transform: uppercase;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .entity {\n  font-size: 1.6vw;\n  color: var(--color1);\n  text-transform: uppercase;\n  font-weight: var(--strongest);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Structure {\n  background-color: rgba(var(--color4-raw), 0.25);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Structure > .type {\n  background-color: var(--color4);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Floor {\n  background-color: rgba(var(--color4Alt4-raw), 0.5);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Room {\n  background-color: rgba(var(--color3Alt1-raw), 0.5);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details {\n  background-color: var(--color2);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td {\n  padding: 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  padding-right: 0.5vw;\n  border-right: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name,\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n  display: inline-block;\n  vertical-align: bottom;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n  margin-left: 0.5vw;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute:last-child {\n  border-right: none;\n  margin-right: 0;\n  padding-right: 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .attributes {\n  display: block;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures {\n  display: block;\n  margin-top: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture {\n  display: block;\n  margin-top: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-left: 0.5vw var(--color5) solid;\n  border-right: 0.5vw var(--color5) solid;\n  border-radius: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  font-size: 2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--stronger);\n  text-transform: uppercase;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.spacer {\n  border: none;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.spacer > td {\n  padding: 2vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations {\n  table-layout: fixed;\n  width: 100%;\n  border: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead {\n  background-color: var(--color2Alt2);\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead th {\n  padding: 0.5vw;\n  text-align: left;\n  font-size: 1.6vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > tbody > tr {\n  border-bottom: 0.1vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > tbody > tr td {\n  padding: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > tbody > tr:nth-child(even) {\n  background-color: var(--color2Alt1);\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox i {\n  font-size: 3.2vw;\n  margin-right: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox i.checked {\n  display: none;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox.checked i.checked {\n  display: block;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox.checked i.unchecked {\n  display: none;\n}\n.document > .content > .dynamic-content ::ng-deep input,\n.document > .content > .dynamic-content textarea {\n  border: 0.2vw var(--color1) solid;\n  color: var(--color3);\n  background-color: var(--color2);\n  border-radius: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep input:focus,\n.document > .content > .dynamic-content textarea:focus {\n  border-color: var(--color3);\n}\n.document > .content > .dynamic-content ::ng-deep .input textarea {\n  display: block;\n  width: 400px;\n  max-width: 100%;\n  font-size: 1.6vw;\n  font-weight: var(--stdweight);\n  padding: 0.5vw;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  resize: none;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n.document > .content > .dynamic-content ::ng-deep .input:focus-within textarea {\n  border-color: var(--color3);\n}\n.document > .content > .static-content .page {\n  position: relative;\n}\n.document > .content > .static-content .page img {\n  width: 100%;\n}\n.document > .content > .static-content .page ::ng-deep canvas {\n  width: 100%;\n}\n.document > .content > .static-content .page .fields .field {\n  position: absolute;\n  z-index: 1;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  white-space: nowrap;\n  display: flex;\n  align-items: flex-end;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials {\n  position: absolute;\n  left: 0;\n  top: 0;\n  height: 100%;\n  width: 100%;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render canvas,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render canvas {\n  width: 100%;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render img,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .hash,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .timestamp,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > label,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 0.7vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature.mandatory > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature.mandatory.consultant > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature.valid > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document > .content > img {\n  width: 100%;\n}\n.document > .content.rendered {\n  opacity: 1;\n  pointer-events: initial;\n}\n.float {\n  position: fixed;\n  bottom: 10px;\n  right: 10px;\n  height: 10px;\n  width: 10px;\n  z-index: 9999999;\n  cursor: pointer;\n}\n@media only screen and (max-width: 768px) {\n  .document > .content {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content {\n    padding: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .logo {\n    width: 24vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep h2 {\n    font-size: 4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep h3 {\n    font-size: 3.2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small * {\n    font-size: 1.6vw !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium {\n    font-size: 3.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium * {\n    font-size: 3.6vw !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large {\n    font-size: 4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large * {\n    font-size: 4vw !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .note {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > label {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > .value {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > h2 {\n    font-size: 3vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h3 {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h4 {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .hash,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .timestamp,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > label,\n  .document > .content > .dynamic-content ::ng-deep .initials > label {\n    font-size: 1.4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render {\n    width: 20vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .initials > .render {\n    width: 10vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify > .block {\n    max-width: 50%;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify * {\n    text-align: initial;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.standard tbody tr td {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 2.4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead th {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .input textarea {\n    font-size: 2.4vw;\n  }\n  .document > .content > .static-content .page .fields .field {\n    font-size: 1.6vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render {\n    border-radius: 0.5vw;\n    padding: 0.5vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .hash,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .timestamp,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > label,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > label {\n    font-size: 0.7vw;\n  }\n}\n@media only screen and (min-width: 1201px) and (hover: hover) and (pointer: fine) {\n  .document > .content {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content {\n    padding: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .logo {\n    width: 250px;\n  }\n  .document > .content > .dynamic-content ::ng-deep h2 {\n    font-size: 36px;\n  }\n  .document > .content > .dynamic-content ::ng-deep h3 {\n    font-size: 28px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small * {\n    font-size: 20px !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium {\n    font-size: 32px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium * {\n    font-size: 32px !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large {\n    font-size: 40px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large * {\n    font-size: 40px !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .note {\n    font-size: 26px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > label {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > .value {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > h2 {\n    font-size: 36px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h3 {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h4 {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .hash,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .timestamp,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > label,\n  .document > .content > .dynamic-content ::ng-deep .initials > label {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render {\n    width: 260px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .initials > .render {\n    width: 150px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify > .block {\n    max-width: 50%;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify * {\n    text-align: initial;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.standard tbody tr td {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead th {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .input textarea {\n    font-size: 32px;\n  }\n  .document > .content > .static-content .page .fields .field {\n    font-size: 24px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render {\n    border-radius: 8px;\n    padding: 8px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .hash,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .timestamp,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > label,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > label {\n    font-size: 10px;\n  }\n}\n/*# sourceMappingURL=appointment-document.component.css.map */\n'] }]
  }], () => [{ type: UiService }, { type: DocumentService }, { type: ContentService }, { type: CurrencyPipe }, { type: OrderByPipe }, { type: DomSanitizer }], { appointment: [{
    type: Input
  }], appointmentContent: [{
    type: Input
  }], viewerElm: [{
    type: ViewChild,
    args: ["viewerElm"]
  }], staticElm: [{
    type: ViewChild,
    args: ["staticElm"]
  }], execute: [{
    type: Input,
    args: ["execute"]
  }], rendered$: [{
    type: Output,
    args: ["rendered"]
  }], document: [{
    type: Input,
    args: ["document"]
  }], signer: [{
    type: Input,
    args: ["signer"]
  }], signing: [{
    type: Input,
    args: ["signing"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], changed$: [{
    type: Output,
    args: ["changed"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AppointmentDocumentComponent, { className: "AppointmentDocumentComponent" });
})();

// src/app/shared/documents/components/opportunity-document/opportunity-document.component.ts
var _c04 = ["viewerElm"];
var _c14 = ["staticElm"];
var _c22 = ["componentElm"];
function OpportunityDocumentComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 3);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", false);
  }
}
function OpportunityDocumentComponent_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 5);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("innerHtml", ctx_r0.documentContent, \u0275\u0275sanitizeHtml);
  }
}
function OpportunityDocumentComponent_Conditional_6_For_3_For_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 11);
  }
  if (rf & 2) {
    const field_r2 = ctx.$implicit;
    \u0275\u0275styleProp("left", field_r2.displayX)("top", field_r2.displayY)("width", field_r2.displayWidth)("height", field_r2.displayHeight);
    \u0275\u0275property("innerHTML", field_r2.contentHtml, \u0275\u0275sanitizeHtml);
  }
}
function OpportunityDocumentComponent_Conditional_6_For_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 7);
    \u0275\u0275element(1, "img", 8);
    \u0275\u0275elementStart(2, "div", 9);
    \u0275\u0275repeaterCreate(3, OpportunityDocumentComponent_Conditional_6_For_3_For_4_Template, 1, 9, "div", 10, \u0275\u0275repeaterTrackByIndex);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const page_r3 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("src", page_r3.src, \u0275\u0275sanitizeUrl);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(page_r3.fields);
  }
}
function OpportunityDocumentComponent_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6, 1);
    \u0275\u0275repeaterCreate(2, OpportunityDocumentComponent_Conditional_6_For_3_Template, 5, 1, "div", 7, \u0275\u0275repeaterTrackByIndex);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r0.activePages);
  }
}
var _OpportunityDocumentComponent = class _OpportunityDocumentComponent {
  constructor(uiService, opportunityService, documentService, contentService, authRefService, currencyPipe, logService, orderByPipe, sanitizer) {
    this.uiService = uiService;
    this.opportunityService = opportunityService;
    this.documentService = documentService;
    this.contentService = contentService;
    this.authRefService = authRefService;
    this.currencyPipe = currencyPipe;
    this.logService = logService;
    this.orderByPipe = orderByPipe;
    this.sanitizer = sanitizer;
    this.activeUser = null;
    this.activePages = [];
    this.userContentValid = false;
    this.numberOfCheckboxes = {};
    this.numberOfTextboxes = {};
    this.initialCount = 0;
    this.signatureCount = 0;
    this.signaturesValid = false;
    this.numberOfSignatures = {};
    this.execute = true;
    this.rendered$ = new Subject();
    this.signing = true;
    this.changed$ = new Subject();
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  replaceJobId(content) {
    if (this.content != null) {
      const labelRegex = /{{appointment.jobid.label}}/gi;
      const labelReplacement = `Estimate #`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.jobid}}/gi;
      const replacement = `${this.content.jobId}`;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  get documents() {
    return this.content?.documents ?? [];
  }
  get isDynamic() {
    if (this.document != null && this.document.dynamic && this.document.content != null) {
      return true;
    }
    return false;
  }
  calcStaticRatio(pageWidth) {
    const staticElm = this.staticElm?.nativeElement;
    if (staticElm != null) {
      const width = staticElm.offsetWidth;
      return width / pageWidth;
    }
    return 1;
  }
  initMapping(document2) {
    return new Promise((res, rej) => {
      setTimeout(() => __async(this, null, function* () {
        if (document2.mapping != null) {
          const mappedPages = [];
          for (var i = 0, len = document2.mapping.pages.length; i < len; i++) {
            const page = document2.mapping.pages[i];
            if (page.binary != null) {
              const binary = new ContentBinary(page.binary);
              const ratio = binary.width != null ? this.calcStaticRatio(binary.width) : 1;
              const mappedFields = [];
              page.fields.forEach((field) => __async(this, null, function* () {
                const mappedField = new DocumentFieldMapping(field, ratio);
                if (field.fieldId == null || field.content == null) {
                  if (mappedField.id != null) {
                    mappedField.content = yield this.replaceVariables(document2, mappedField.id);
                  }
                  if (mappedField.content != null) {
                    mappedField.fieldId = mappedField.content.match(/field='([0-9a-f-]{36})'/)?.[1] ?? void 0;
                  }
                }
                if (mappedField.content != null) {
                  mappedField.contentHtml = this.sanitizer.bypassSecurityTrustHtml(mappedField.content);
                }
                mappedFields.push(mappedField);
              }));
              const image = yield this.contentService.getImage(binary.src);
              let mappedPage;
              if (image != null) {
                mappedPage = {
                  fields: mappedFields,
                  binary,
                  src: image.localSrc
                };
                mappedPages.push(mappedPage);
              } else {
                mappedPage = {
                  fields: mappedFields,
                  binary,
                  src: binary.src
                };
                mappedPages.push(mappedPage);
              }
            }
          }
          this.activePages = mappedPages;
          document2.mapping.pages = mappedPages;
          setTimeout(() => {
            this.initSignatureElms();
            this.initIntialElms();
            res();
          }, 0);
        }
      }), 0);
    });
  }
  // #endregion
  // #region Additional Considerations
  replaceAdditionalConsiderations(content) {
    if (this.price != null && this.price.customItems.length > 0) {
      let markup = `
                <h3>Additional Considerations to Scope:</h3>
                <table class='additional-considerations'>
                <thead>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Quantity</th>
                </thead>
                <tbody>`;
      this.price.customItems.forEach((item) => {
        if (item.customerFacing) {
          markup = markup + `<tr class='consideration'>
                            <td>${item.name}</td>
                            <td>${item.description}</td>
                            <td>${item.quantity}</td>
                        </tr>`;
        }
      });
      markup = markup + "</tbody></table>";
      const acRegex = /{{price.customItems.customer}}/gi;
      content = content.replace(acRegex, markup);
    } else {
      const acRegex = /{{price.customItems.customer}}/gi;
      content = content.replace(acRegex, "");
    }
    return content;
  }
  // #endregion
  // #region Entity Details
  renderEntityDetailAttribute(entity, index, onlyCustomerFacing = false, parentEntity = null) {
    const customerFacingAttribute = entity.attributes.find((x) => x.customerFacing);
    if (!onlyCustomerFacing && entity.attributes.length > 0 || onlyCustomerFacing && customerFacingAttribute != null) {
      let markup = "";
      if (entity.type == PropertyEntityType.Unit) {
        markup = markup + "<tr class='spacer'><td></td></tr>";
      }
      if (parentEntity != null && parentEntity.type != PropertyEntityType.Property) {
        if (entity.type == PropertyEntityType.Room) {
          markup = markup + `<tr class='type ${entity.type}'>
                        <td>
                        <span class='parent'>${parentEntity.name}</span>
                        <span class='entity'>${entity.name} ${entity.number} Details</span>
                        </td>
                        </tr>`;
        } else {
          markup = markup + `<tr class='type ${entity.type}'>
                        <td>
                        <span class='parent'>${parentEntity.name}</span>
                        <span class='entity'>${entity.name} Details</span>
                        </td>
                        </tr>`;
        }
      } else if (entity.type == PropertyEntityType.Room) {
        markup = markup + `<tr class='type ${entity.type}'>
                    <td>
                    <span class='entity'>${entity.name} ${entity.number} Details</span>
                    </td>
                    </tr>`;
      } else {
        markup = markup + `<tr class='type ${entity.type}'>
                    <td>
                    <span class='entity'>${entity.name} Details</span>
                    </td>
                    </tr>`;
      }
      markup = markup + "<tr class='details'><td>";
      markup = markup + "<span class='attributes'>";
      entity.attributes.forEach((attribute) => {
        if ((!onlyCustomerFacing || attribute.customerFacing) && attribute.values.length > 0) {
          markup = markup + `<span class='attribute'>
                        <span class='name'>${attribute.name}</span>`;
          attribute.values.forEach((value) => {
            const sanitizedValue = value.toLowerCase();
            switch (sanitizedValue) {
              case "false":
                value = "No";
                break;
              case "true":
                value = "Yes";
                break;
            }
            markup = markup + `<span class='value'>${value}</span>`;
          });
          markup = markup + "</span>";
        }
      });
      markup = markup + "</span>";
      if (entity.fixtures.length > 0) {
        markup = markup + "<span class='fixtures'>";
        for (var j = 0, jlen = entity.fixtures.length; j < jlen; j++) {
          const fixture = entity.fixtures[j];
          markup = markup + `<span class='fixture'><span class='name'>${fixture.name} ${fixture.number} -</span>`;
          fixture.attributes.forEach((attribute) => {
            if ((!onlyCustomerFacing || attribute.customerFacing) && attribute.values.length > 0) {
              markup = markup + `<span class='attribute'>
                                <span class='name'>${attribute.name}</span>`;
              attribute.values.forEach((value) => {
                const sanitizedValue = value.toLowerCase();
                switch (sanitizedValue) {
                  case "false":
                    value = "No";
                    break;
                  case "true":
                    value = "Yes";
                    break;
                }
                markup = markup + `<span class='value'>${value}</span>`;
              });
              markup = markup + "</span>";
            }
          });
          markup = markup + "</span>";
        }
        markup = markup + "</span>";
      }
      markup = markup + "</td></tr>";
      return markup;
    }
    return "";
  }
  getEntityDetailsAttributes(entity = null, entities = [], parentEntity = null, onlyCustomerFacing = false, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderEntityDetailAttribute(entity, index, onlyCustomerFacing, parentEntity);
      note = note + this.getEntityDetailsAttributes(null, entity.entities, entity, onlyCustomerFacing, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        let note = this.renderEntityDetailAttribute(childEntity, index, onlyCustomerFacing, parentEntity);
        index = index + 1;
        note = note + this.getEntityDetailsAttributes(null, childEntity.entities, childEntity, onlyCustomerFacing, index);
        entityNotes = entityNotes + note;
      }
    }
    return entityNotes;
  }
  replaceEntityDetails(matchText, content, onlyCustomerFacing = false) {
    if (this.content?.property?.entity != null) {
      let markup = `<table class="entity-details">`;
      markup = markup + this.getEntityDetailsAttributes(this.content.job, [], null, onlyCustomerFacing, 1);
      markup = markup + this.getEntityDetailsAttributes(this.content.property.entity, [], null, onlyCustomerFacing, 1) + "</table>";
      const regex = new RegExp(matchText, "g");
      const replacement = markup;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Attributes
  renderAttribute(entity, index, onlyCustomerFacing = false, parentEntity = null) {
    const customerFacingAttribute = entity.attributes.find((x) => x.customerFacing);
    if (!onlyCustomerFacing && entity.attributes.length > 0 || onlyCustomerFacing && customerFacingAttribute != null) {
      let markup = "";
      if (parentEntity != null) {
        if (parentEntity.type != PropertyEntityType.Property && parentEntity.type != PropertyEntityType.Structure && parentEntity.type != PropertyEntityType.Floor) {
          markup = `<div class='inspection-attribute'>
                        <h3>${parentEntity.name} ${parentEntity.number}</h3>
                        <h4>${entity.name} ${entity.number} Details</h4>`;
        } else {
          markup = `<div class='inspection-attribute'>
                        <h3>${parentEntity.name}</h3>
                        <h4>${entity.name} Details</h4>`;
        }
      } else {
        markup = `<div class='inspection-attribute'>
                    <h3>${entity.name} Details</h3>`;
      }
      entity.attributes.forEach((attribute) => {
        if (!onlyCustomerFacing || attribute.customerFacing) {
          markup = markup + `<div class='attribute'>
                        <label>${attribute.name}</label>`;
          attribute.values.forEach((value) => {
            markup = markup + `<span class='value'>${value}</span>`;
          });
          markup = markup + "</div>";
        }
      });
      markup = markup + "</div>";
      return markup;
    }
    return "";
  }
  getAttributes(entity = null, entities = [], parentEntity = null, onlyCustomerFacing = false, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderAttribute(entity, index, onlyCustomerFacing, parentEntity);
      note = note + this.getAttributes(null, entity.entities, entity, onlyCustomerFacing, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        if (childEntity.type != PropertyEntityType.Structure && childEntity.type != PropertyEntityType.Room) {
          let note = this.renderAttribute(childEntity, index, onlyCustomerFacing, parentEntity);
          index = index + 1;
          for (var j = 0, jlen = childEntity.fixtures.length; j < jlen; j++) {
            const fixture = childEntity.fixtures[j];
            note = note + this.renderAttribute(fixture, index, onlyCustomerFacing, childEntity);
          }
          note = note + this.getAttributes(null, childEntity.entities, childEntity, onlyCustomerFacing, index);
          entityNotes = entityNotes + note;
        } else if (childEntity.type != PropertyEntityType.Room) {
          index = index + 1;
          const note = this.getAttributes(null, childEntity.entities, childEntity, onlyCustomerFacing, index);
          entityNotes = entityNotes + note;
        }
      }
    }
    return entityNotes;
  }
  replaceAttributes(matchText, content, onlyCustomerFacing = false) {
    if (this.content?.property?.entity != null) {
      let attributes = `<div class='inspection-attributes'>
                <div class='attributes'>`;
      attributes = attributes + this.getAttributes(this.content.property.entity, [], null, onlyCustomerFacing, 1) + "</div></div>";
      const regex = new RegExp(matchText, "g");
      const replacement = attributes;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Photos
  renderPhoto(entity, index, parentEntity = null) {
    if (entity.photos_B64.length > 0 || entity.photos.length > 0) {
      let diagram = "";
      if (parentEntity != null) {
        if (parentEntity.type != PropertyEntityType.Property && parentEntity.type != PropertyEntityType.Structure && parentEntity.type != PropertyEntityType.Floor) {
          diagram = `<div class='inspection-photos'>
                        <h3>${parentEntity.name} ${parentEntity.number}</h3>
                        <h4>${entity.name} ${entity.number}</h4>
                        <div class='images'>`;
        } else {
          diagram = `<div class='inspection-photos'>
                        <h3>${parentEntity.name}</h3>
                        <h4>${entity.name} Photos</h4>
                        <div class='images'>`;
        }
      } else {
        diagram = `<div class='inspection-photos'>
                    <h3>${entity.name}</h3>`;
      }
      entity.photos.forEach((photo) => __async(null, null, function* () {
        const mappedPhoto = new ContentBinary(photo);
        diagram = diagram + `<div class='image'><img class="static" crossorigin="anonymous" src='${mappedPhoto.src}' /></div>`;
      }));
      entity.photos_B64.forEach((photo) => __async(null, null, function* () {
        diagram = diagram + `<div class='image'><img class="static" crossorigin="anonymous" src='${photo}' /></div>`;
      }));
      diagram = diagram + "</div></div>";
      return diagram;
    }
    return "";
  }
  renderPhotos(entity = null, entities = [], parentEntity = null, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderPhoto(entity, index, parentEntity);
      note = note + this.renderPhotos(null, entity.entities, entity, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        let note = this.renderPhoto(childEntity, index, parentEntity);
        index = index + 1;
        for (var j = 0, jlen = childEntity.fixtures.length; j < jlen; j++) {
          const fixture = childEntity.fixtures[j];
          note = note + this.renderPhoto(fixture, index, childEntity);
        }
        note = note + this.renderPhotos(null, childEntity.entities, childEntity, index);
        entityNotes = entityNotes + note;
      }
    }
    return entityNotes;
  }
  replacePhotos(matchText, content) {
    if (this.content?.property?.entity != null) {
      let photos = `<div class='inspection-photos'>
                <h2>Property Photos</h2>
                <div class='photos'>`;
      photos = photos + this.renderPhotos(this.content.job, [], null, 1) + "</div></div>";
      photos = photos + this.renderPhotos(this.content.property.entity, [], null, 1) + "</div></div>";
      const regex = new RegExp(matchText, "g");
      const replacement = photos;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Diagrams
  renderDiagram(entity, index, parentEntity = null) {
    const render = entity.render?.src ?? entity.localRender;
    if (render != null) {
      let diagram = "";
      if (parentEntity != null) {
        if (parentEntity.type != PropertyEntityType.Property && parentEntity.type != PropertyEntityType.Structure && parentEntity.type != PropertyEntityType.Floor) {
          diagram = `<div class='inspection-diagram'>
                        <h3>${parentEntity.name} ${parentEntity.number}</h3>
                        <h4>${entity.name} ${entity.number} Details</h4>
                        <div class='image'><img class='static' src='${render}' /></div>`;
        } else {
          diagram = `<div class='inspection-diagram'>
                        <h3>${parentEntity.name}</h3>
                        <h4>${entity.name} Diagram</h4>
                        <div class='image'><img class='static' src='${render}' /></div>`;
        }
      } else {
        diagram = `<div class='inspection-diagram'>
                    <h3>${entity.name}</h3>
                    <div class='image'><img class='static' src='${render}' /></div>`;
      }
      diagram = diagram + "</div>";
      return diagram;
    }
    return "";
  }
  getDiagrams(entity = null, entities = [], parentEntity = null, index = 1) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderDiagram(entity, index, parentEntity);
      note = note + this.getDiagrams(null, entity.entities, entity, index + 1);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const childEntity = entities[i];
        if (childEntity.type != PropertyEntityType.Structure && childEntity.type != PropertyEntityType.Room) {
          let note = this.renderDiagram(childEntity, index, parentEntity);
          index = index + 1;
          note = note + this.getDiagrams(null, childEntity.entities, childEntity, index);
          entityNotes = entityNotes + note;
        } else if (childEntity.type != PropertyEntityType.Room) {
          index = index + 1;
          const note = this.getDiagrams(null, childEntity.entities, childEntity, index);
          entityNotes = entityNotes + note;
        }
      }
    }
    return entityNotes;
  }
  replaceDiagrams(matchText, content) {
    if (this.content?.property?.entity != null) {
      let diagrams = `<div class='inspection-diagrams'>
                <h2>Property Diagrams</h2>
                <div class='diagrams'>`;
      diagrams = diagrams + this.getDiagrams(this.content.property.entity, [], null, 1) + "</div></div>";
      const regex = new RegExp(matchText, "g");
      const replacement = diagrams;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Notes
  renderNote(precursor = "", entity, index, type) {
    let entityName = entity.name;
    if (entity.type != PropertyEntityType.Property && entity.type != PropertyEntityType.Unit && entity.type != PropertyEntityType.Structure && entity.type != PropertyEntityType.Floor) {
      entityName = `${entity.name} ${entity.number}`;
    }
    switch (type) {
      case "customer":
        {
          const customerNote = entity.notes[NoteAudience2.Customer];
          if (customerNote != null && customerNote.length > 0) {
            if (this.document?.customerFacing) {
              const useSignatureRef = /* @__PURE__ */ new Date("2025-11-17T00:00:00");
              if (this.content?.scheduled_Utc != null && this.content.scheduled_Utc >= useSignatureRef) {
                return `<div class='customer-note'>
                            <label>${index}) ${precursor}${entityName} Note</label>
                            <span class='value'>${entity.notes[NoteAudience2.Customer]}</span>
                            </div>
                            {{signature.customer.mandatory}}`;
              } else {
                return `<div class='customer-note'>
                            <label>${index}) ${precursor}${entityName} Note</label>
                            <span class='value'>${entity.notes[NoteAudience2.Customer]}</span>
                            </div>
                            {{initial.customer.mandatory}}`;
              }
            } else {
              return `<div class='customer-note'>
                        <label>${index}) ${precursor}${entityName} Note</label>
                        <span class='value'>${entity.notes[NoteAudience2.Customer]}</span>
                        </div>`;
            }
          }
        }
        break;
      case "shop":
        {
          const shopNote = entity.notes[NoteAudience2.Shop];
          if (shopNote != null && shopNote.length > 0) {
            return `<div class='shop-note'>
                    <label>${index}) ${precursor}${entityName} Note</label>
                    <span class='value'>${entity.notes[NoteAudience2.Shop]}</span>
                    </div>`;
          }
        }
        break;
    }
    return "";
  }
  getNotes(entity = null, entities = [], index = 1, type) {
    let entityNotes = "";
    if (entity != null) {
      let note = this.renderNote("", entity, index, type);
      for (var j = 0, jlen = entity.fixtures.length; j < jlen; j++) {
        const fixture = entity.fixtures[j];
        index = index + 1;
        note = note + this.renderNote(`${entity.name} `, fixture, index, type);
      }
      note = note + this.getNotes(null, entity.entities, index + 1, type);
      entityNotes = entityNotes + note;
    } else {
      for (var i = 0, len = entities.length; i < len; i++) {
        const entity2 = entities[i];
        let note = this.renderNote("", entity2, index, type);
        index = index + 1;
        for (var j = 0, jlen = entity2.fixtures.length; j < jlen; j++) {
          const fixture = entity2.fixtures[j];
          note = note + this.renderNote(`${entity2.name} `, fixture, index, type);
          index = index + 1;
        }
        note = note + this.getNotes(null, entity2.entities, index, type);
        entityNotes = entityNotes + note;
      }
    }
    return entityNotes;
  }
  replaceNotes(matchText, content, type) {
    let notes = "";
    if (this.content?.property?.entity != null) {
      notes = this.getNotes(this.content.property.entity, [], 1, type);
    }
    const regex = new RegExp(matchText, "g");
    let replacement = notes;
    if (replacement == "") {
      if (this.document?.customerFacing && type == "customer") {
        replacement = "<p>No verbal agreements have been made outside of this contract.</p>{{initial.customer.mandatory}}";
      }
    }
    content = content.replace(regex, replacement);
    return content;
  }
  generateCheckboxHtml(signer, mandatory = false) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const checkboxCount = this.numberOfCheckboxes[customerName] ?? 0;
            const fieldStr = `checkbox-${this.document.id}-${customerName}-${checkboxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='checkbox mandatory customer' field='${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='checkbox optional customer' field='${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: ${customerName}</label>
                            </div>`;
            }
            this.numberOfCheckboxes[customerName] = checkboxCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const checkboxCount = this.numberOfCheckboxes[consultantName] ?? 0;
            const fieldStr = `checkbox-${this.document.id}-${consultantName}-${checkboxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='checkbox mandatory customer' field='${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='checkbox optional customer' field='$${fieldId}'>
                                <i class="fa-regular fa-square unchecked"></i>
                                <i class="fa-regular fa-square-check checked"></i>
                                <label>Signatory: Repipe Consultant</label>
                            </div>`;
            }
            this.numberOfCheckboxes[consultantName] = checkboxCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceCheckboxes(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateCheckboxHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  generateTextboxHtml(signer, mandatory) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const textBoxCount = this.numberOfTextboxes[customerName] ?? 0;
            const fieldStr = `textbox-${this.document.id}-${customerName}-${textBoxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='input mandatory customer' field='${fieldId}'>
                            <textarea maxlength='100' rows='3' required='true'></textarea>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='input optional customer' field='${fieldId}'>
                            <textbox maxlength='100' rows='3' required='false'></textarea>
                            <label>Signatory: ${customerName}</label>
                        </div>`;
            }
            this.numberOfTextboxes[customerName] = textBoxCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const textBoxCount = this.numberOfTextboxes[consultantName] ?? 0;
            const fieldStr = `textbox-${this.document.id}-${consultantName}-${textBoxCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='input mandatory consultant' field='${fieldId}'>
                            <textarea maxlength='100' rows='3' required='true'></textarea>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='input optional consultant' field='${fieldId}'>
                            <textarea maxlength='100' rows='3' required='false'></textarea>
                            <label>Signatory: Repipe Consultant</label>
                        </div>`;
            }
            this.numberOfTextboxes[consultantName] = textBoxCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceTextbox(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateTextboxHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  initInputElms() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      const checkboxElms = viewerElm.querySelectorAll(`.checkbox`);
      checkboxElms.forEach((checkboxElm) => {
        checkboxElm.addEventListener("click", () => {
          const signer = checkboxElm.getAttribute("signer");
          const fieldId = checkboxElm.getAttribute("field");
          if (signer != null && (this.signer == null || signer == this.signer) && fieldId != null && this.document != null) {
            const checked = checkboxElm.classList.contains("checked");
            const checkboxContent = this.documentService.initUserContent(signer, fieldId, this.document.id);
            if (checked) {
              checkboxElm.classList.remove("checked");
              checkboxContent.content = "false";
              if (checkboxElm.classList.contains("mandatory")) {
                checkboxElm.classList.remove("valid");
              }
            } else {
              checkboxElm.classList.add("checked");
              checkboxElm.classList.add("valid");
              checkboxContent.content = "true";
            }
            this.storeUserContent(checkboxContent);
          }
        });
      });
      const inputElms = viewerElm.querySelectorAll(".input");
      inputElms.forEach((inputElm) => {
        const input = inputElm.querySelector("input,textarea");
        if (input != null) {
          input.addEventListener("input", () => {
            const signer = inputElm.getAttribute("signer");
            const fieldId = inputElm.getAttribute("field");
            if (signer != null && (this.signer == null || signer == this.signer) && fieldId != null && this.document != null) {
              const inputContent = this.documentService.initUserContent(signer, fieldId, this.document.id);
              inputContent.content = input.value;
              if (input.value.length > 0) {
                inputElm.classList.add("valid");
              } else {
                inputElm.classList.remove("valid");
              }
              this.storeUserContent(inputContent);
            }
          });
        }
      });
    }
  }
  storeUserContent(userContent) {
    if (this.document != null) {
      const existingIndex = this.document.userContent.findIndex((x) => x.fieldId == userContent.fieldId);
      if (existingIndex > 0) {
        this.document.userContent[existingIndex] = userContent;
      } else {
        this.document.userContent.push(userContent);
      }
      this.changed$.next();
    }
  }
  restoreUserContent() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (this.document != null && viewerElm != null) {
      const missingContent = [];
      for (var i = 0, len = this.document.userContent.length; i < len; i++) {
        const userContent = this.document.userContent[i];
        const fieldElm = viewerElm.querySelector(`[field="${userContent.fieldId}"]`);
        let missing = fieldElm == null;
        if (fieldElm != null) {
          if (fieldElm.classList.contains("checkbox")) {
            if (userContent.content == "true") {
              fieldElm.classList.add("checked");
              fieldElm.classList.add("valid");
            } else {
              fieldElm.classList.remove("checked");
              if (fieldElm.classList.contains("mandatory")) {
                fieldElm.classList.remove("valid");
              }
            }
          } else if (fieldElm.classList.contains("input")) {
            const input = fieldElm.querySelector("input,textarea");
            if (input != null) {
              input.value = userContent.content ?? "";
              if (input.value.length > 0) {
                fieldElm.classList.add("valid");
              }
            }
          }
          fieldElm.classList.add("valid");
        }
        if (missing) {
          missingContent.push(i);
        }
      }
      missingContent.forEach((i2) => {
        if (this.document != null) {
          this.document.userContent = this.document.userContent.splice(i2, 1);
          this.changed$.next();
        }
      });
      this.setDocumentValidity();
    }
  }
  validateUserContent() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      let valid = true;
      const checkboxElms = viewerElm.querySelectorAll(`.checkbox`);
      checkboxElms.forEach((elm) => {
        if (elm.classList.contains("mandatory") && !elm.classList.contains("valid")) {
          valid = false;
        }
      });
      const inputElms = viewerElm.querySelectorAll(`.input`);
      inputElms.forEach((elm) => {
        if (elm.classList.contains("mandatory") && !elm.classList.contains("valid")) {
          valid = false;
        }
      });
      this.userContentValid = valid;
    }
  }
  watchInitials() {
    this.initialSubscription = this.documentService.initials.subscribe({
      next: (update) => {
        if (update.signature?.signature_B64 != null && update.signer != null) {
          this.renderInitials(update.signature, update.signer);
        }
      }
    });
  }
  storeSignerInitials(signer, initials_B64) {
    signer.initials_B64 = initials_B64;
  }
  renderInitials(initials, signer) {
    const viewerElm = this.viewerElm?.nativeElement;
    if (initials?.signature_B64 != null && viewerElm != null) {
      this.storeSignerInitials(signer, initials.signature_B64);
      this.storeSignature(initials);
      const fieldElm = viewerElm.querySelector(`.initials[field='${initials.fieldId}']`);
      const renderElm = fieldElm?.querySelector(".render");
      if (fieldElm != null && renderElm != null) {
        const html = `
                    <canvas width='4' height='3'></canvas>
                    <img src='${initials.signature_B64}' />
                    <div class='hash'>
                        ${initials.hash_SHA256}
                    </div>
                    <div class='timestamp'>
                        ${initials.timeStamp_Utc}
                    </div>
                `;
        renderElm.innerHTML = html;
        fieldElm.classList.add("valid");
      }
    }
    this.setDocumentValidity();
  }
  startInitialing(fieldId = null, name = null) {
    const signer = this.document?.signers.find((x) => x.fullName == name);
    if (signer != null && fieldId != null && this.document != null) {
      this.documentService.startInitialing(signer, fieldId, this.document.id);
    }
  }
  generateInitialHtml(signer, mandatory) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const initialCount = this.numberOfSignatures[customerName] ?? 0;
            const fieldStr = `${this.document.id}-${customerName}-${initialCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            const oldFieldStr = `initial-${this.document.id}-${customerName}-${initialCount}`;
            const oldFieldId = generateDeterministicId(oldFieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='initials mandatory customer' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='initials optional customer' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            }
            this.numberOfSignatures[customerName] = initialCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const initialCount = this.numberOfSignatures[consultantName] ?? 0;
            const fieldStr = `${this.document.id}-${consultantName}-${initialCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            const oldFieldStr = `initial-${this.document.id}-${consultantName}-${initialCount}`;
            const oldFieldId = generateDeterministicId(oldFieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='initials mandatory consultant' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='initials optional consultant' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='4' height='3'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            }
            this.numberOfSignatures[consultantName] = initialCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceInitials(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateInitialHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  initIntialElms() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      const initialElms = viewerElm.querySelectorAll(`.initials`);
      this.initialCount = initialElms.length;
      initialElms.forEach((initialElm) => {
        const signer = initialElm.getAttribute("signer");
        if (this.content?.recipient == null || this.content.recipient.fullName == signer) {
          const renderElm = initialElm.querySelector(".render");
          if (renderElm != null) {
            renderElm.addEventListener("click", () => {
              const signer2 = initialElm.getAttribute("signer");
              const fieldId = initialElm.getAttribute("field");
              if (this.signer == null || signer2 == this.signer) {
                this.startInitialing(fieldId, signer2);
              }
            });
          }
        } else {
          initialElm.classList.add("disabled");
        }
      });
    }
  }
  watchSignatures() {
    this.signatureSubscription = this.documentService.signature.subscribe({
      next: (update) => {
        if (update.signature?.signature_B64 != null && update.signer != null) {
          this.renderSignature(update.signature, update.signer);
        }
      }
    });
  }
  storeSignerSignature(signer, signature_B64) {
    signer.signature_B64 = signature_B64;
  }
  renderSignature(signature, signer) {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null && signature.signature_B64 != null) {
      this.storeSignerSignature(signer, signature.signature_B64);
      this.storeSignature(signature);
      const signatureElm = viewerElm.querySelector(`.signature[field='${signature.fieldId}']`);
      const renderElm = signatureElm?.querySelector(".render");
      if (signatureElm != null && renderElm != null) {
        const html = `
                    <canvas width='16' height='6'></canvas>
                    <img src='${signature.signature_B64}' />
                    <div class='hash'>
                        ${signature.hash_SHA256}
                    </div>
                    <div class='timestamp'>
                        ${signature.timeStamp_Utc}
                    </div>
                `;
        renderElm.innerHTML = html;
        signatureElm.classList.add("valid");
      }
    }
    this.setDocumentValidity();
  }
  startSigning(fieldId = null, name) {
    const signer = this.document?.signers.find((x) => x.fullName == name);
    if (signer != null && fieldId != null && this.document != null) {
      this.documentService.startSigning(signer, fieldId, this.document.id);
    }
  }
  generateSignatureHtml(signer, mandatory) {
    let replacement = "";
    if (this.document != null) {
      switch (signer) {
        case "customer":
          {
            const customerName = `${this.customer?.firstName} ${this.customer?.lastName}`;
            const signatureCount = this.numberOfSignatures[customerName] ?? 0;
            const name = this.document.name.toLowerCase();
            let fieldStr = `${this.document.id}-${customerName}-${signatureCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            const oldFieldStr = `signature-${this.document.id}-${customerName}-${signatureCount}`;
            const oldFieldId = generateDeterministicId(oldFieldStr);
            if (mandatory) {
              replacement = `<div signer='${customerName}' class='signature mandatory customer' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            } else {
              replacement = `<div signer='${customerName}' class='signature optional customer' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: ${customerName}</label>
                            </div>`;
            }
            this.numberOfSignatures[customerName] = signatureCount + 1;
          }
          break;
        case "consultant":
          {
            const consultantName = this.consultant?.fullName ?? "consultant";
            const signatureCount = this.numberOfSignatures[consultantName] ?? 0;
            const fieldStr = `${this.document.id}-${consultantName}-${signatureCount}`;
            const fieldId = generateDeterministicId(fieldStr);
            const oldFieldStr = `signature-${this.document.id}-${consultantName}-${signatureCount}`;
            const oldFieldId = generateDeterministicId(oldFieldStr);
            if (mandatory) {
              replacement = `<div signer='${consultantName}' class='signature mandatory consultant' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            } else {
              replacement = `<div signer='${consultantName}' class='signature optional consultant' field='${fieldId}' ofid='${oldFieldId}'>
                            <div class='render'>
                                <canvas width='2' height='1'></canvas>
                            </div>
                            <label>Signatory: Repipe Consultant</label>
                            </div>`;
            }
            this.numberOfSignatures[consultantName] = signatureCount + 1;
          }
          break;
      }
    }
    return replacement;
  }
  replaceSignature(matchText, content, signer, mandatory = false) {
    const pattern = new RegExp(matchText, "g");
    let match;
    let counter = 1;
    while ((match = pattern.exec(content)) !== null) {
      const replacement = this.generateSignatureHtml(signer, mandatory);
      content = content.replace(match[0], replacement);
    }
    return content;
  }
  initSignatureElms() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      const signatureElms = viewerElm.querySelectorAll(`.signature`);
      this.signatureCount = signatureElms.length;
      signatureElms.forEach((signatureElm) => {
        const signer = signatureElm.getAttribute("signer");
        if (this.content?.recipient == null || this.content.recipient.fullName == signer) {
          const renderElm = signatureElm.querySelector(".render");
          if (renderElm != null) {
            renderElm.addEventListener("click", () => {
              const name = signatureElm.getAttribute("signer");
              const fieldId = signatureElm.getAttribute("field");
              if (this.signer == null || signer == this.signer) {
                this.startSigning(fieldId, name);
              }
            });
          }
        } else {
          signatureElm.classList.add("disabled");
        }
      });
    }
  }
  restoreSignatures() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (this.document != null && viewerElm != null) {
      const missingSignatures = [];
      const rawHtml = viewerElm.outerHTML;
      for (var i = 0, len = this.document.signatures.length; i < len; i++) {
        const signature = this.document.signatures[i];
        let fieldElm = viewerElm.querySelector(`[field="${signature.fieldId}"]`) ?? viewerElm.querySelector(`[ofid="${signature.fieldId}"]`);
        if (fieldElm == null) {
          for (var j = 0; j < 10; j++) {
            const dynamicFieldId = generateDeterministicId(`signature-${this.document.id}-${signature.signerName}-${i}`);
            if (rawHtml.includes(dynamicFieldId)) {
              fieldElm = viewerElm.querySelector(`[field="${dynamicFieldId}"]`) ?? viewerElm.querySelector(`[ofid="${dynamicFieldId}"]`);
              break;
            }
          }
        }
        const renderElm = fieldElm?.querySelector(".render");
        if (fieldElm != null && renderElm != null) {
          let html = "";
          if (fieldElm.classList.contains("initials")) {
            html = `
                            <canvas width='4' height='3'></canvas>
                            <img src='${signature.signature_B64}' />
                            <div class='hash'>
                                ${signature.hash_SHA256}
                            </div>
                            <div class='timestamp'>
                                ${signature.timeStamp_Utc}
                            </div>
                        `;
          } else {
            html = `
                            <canvas width='16' height='6'></canvas>
                            <img src='${signature.signature_B64}' />
                            <div class='hash'>
                                ${signature.hash_SHA256}
                            </div>
                            <div class='timestamp'>
                                ${signature.timeStamp_Utc}
                            </div>
                        `;
          }
          renderElm.innerHTML = html;
          fieldElm.classList.add("valid");
        } else {
          missingSignatures.push(i);
        }
      }
      this.setDocumentValidity();
    }
  }
  storeSignature(signature) {
    return __async(this, null, function* () {
      if (this.document != null) {
        const existingSignatureIndex = this.document.signatures.findIndex((x) => x.fieldId == signature.fieldId);
        if (existingSignatureIndex > 0) {
          this.document.signatures[existingSignatureIndex] = signature;
          if (this.opportunity != null && this.activeUser != null) {
            yield this.opportunityService.updateSignature(this.opportunity, signature, this.document.name, this.activeUser);
          }
        } else {
          this.document.signatures.push(signature);
          if (this.opportunity != null && this.activeUser != null) {
            yield this.opportunityService.addSignature(this.opportunity, signature, this.document.name, this.activeUser);
          }
        }
        this.changed$.next();
      }
    });
  }
  validateSignatures() {
    const viewerElm = this.viewerElm?.nativeElement;
    if (viewerElm != null) {
      let valid = true;
      const signatureElms = viewerElm.querySelectorAll(".signature,.initials");
      signatureElms.forEach((elm) => {
        if (elm.classList.contains("mandatory") && !elm.classList.contains("valid")) {
          valid = false;
        }
      });
      this.signaturesValid = valid;
    }
  }
  // #endregion
  // #region Headers
  replaceHeaders(content) {
    content = this.replaceH1(content);
    content = this.replaceH2(content);
    content = this.replaceH3(content);
    content = this.replaceH4(content);
    content = this.replaceH5(content);
    return content;
  }
  replaceH1(content) {
    const openH2Regex = /(&lt;h1&gt;)/gi;
    const closeH2Regex = /(&lt;\/h1&gt;)/gi;
    content = content.replace(openH2Regex, "<h1>");
    content = content.replace(closeH2Regex, "</h1>");
    return content;
  }
  replaceH2(content) {
    const openH2Regex = /(&lt;h2&gt;)/gi;
    const closeH2Regex = /(&lt;\/h2&gt;)/gi;
    content = content.replace(openH2Regex, "<h2>");
    content = content.replace(closeH2Regex, "</h2>");
    return content;
  }
  replaceH3(content) {
    const openH2Regex = /(&lt;h3&gt;)/gi;
    const closeH2Regex = /(&lt;\/h3&gt;)/gi;
    content = content.replace(openH2Regex, "<h3>");
    content = content.replace(closeH2Regex, "</h3>");
    return content;
  }
  replaceH4(content) {
    const openH2Regex = /(&lt;h4&gt;)/gi;
    const closeH2Regex = /(&lt;\/h4&gt;)/gi;
    content = content.replace(openH2Regex, "<h4>");
    content = content.replace(closeH2Regex, "</h4>");
    return content;
  }
  replaceH5(content) {
    const openH2Regex = /(&lt;h5&gt;)/gi;
    const closeH2Regex = /(&lt;\/h5&gt;)/gi;
    content = content.replace(openH2Regex, "<h5>");
    content = content.replace(closeH2Regex, "</h5>");
    return content;
  }
  // #endregion
  // #region Text Styling
  replaceTextTags(content) {
    const openH2Regex = /(&lt;strong&gt;)/gi;
    const closeH2Regex = /(&lt;\/strong&gt;)/gi;
    content = content.replace(openH2Regex, "<strong>");
    content = content.replace(closeH2Regex, "</strong>");
    return content;
  }
  replaceTextSizes(content) {
    const applyClassToParent = (variable, size) => {
      const parser = new DOMParser();
      const doc = parser.parseFromString(`<div>${content}</div>`, "text/html");
      const walker = doc.createTreeWalker(doc.body, NodeFilter.SHOW_TEXT);
      let nodesToProcess = [];
      while (walker.nextNode()) {
        const node = walker.currentNode;
        if (node.nodeValue?.includes(variable)) {
          nodesToProcess.push(node);
        }
      }
      nodesToProcess.forEach((node) => {
        node.nodeValue = node.nodeValue?.replace(/\[\[fontSize\.large\]\]/gi, "") ?? null;
        const parent = node.parentElement;
        const grandParent = parent?.parentElement;
        if (grandParent) {
          const existingClass = grandParent.getAttribute("class") || "";
          grandParent.setAttribute("class", existingClass ? `${existingClass} font-${size}` : `font-${size}`);
          parent.remove();
        }
      });
      return doc.body.innerHTML;
    };
    content = applyClassToParent("[[fontSize.small]]", "small");
    content = applyClassToParent("[[fontSize.medium]]", "medium");
    content = applyClassToParent("[[fontSize.large]]", "large");
    return content;
  }
  // #endregion
  // #region Horizontal Rows
  replaceHr(content) {
    const hrRegex = /{{hr}}/gi;
    content = content.replace(hrRegex, "<hr />");
    return content;
  }
  // #endregion
  // #region Labels
  replaceLabels(content) {
    const labelRegex = /(&lt;label&gt;)/gi;
    content = content.replace(labelRegex, "<label>");
    const endLabelRegex = /(&lt;\/label&gt;)/gi;
    content = content.replace(endLabelRegex, "</label>");
    return content;
  }
  // #endregion
  // #region Lists
  replaceLists(content) {
    content = this.replaceListVariables(content);
    const startRegex = /\[\[startList\]\]/gi;
    const startReplacement = `<div class='list'>`;
    const endRegex = /\[\[endList\]\]/gi;
    const endReplacement = `</div>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  replaceListVariables(content) {
    const tableRegex = /\[\[startList\]\]([\s\S]*?)\[\[endList\]\]/;
    const match = content.match(tableRegex);
    if (match != null && match[1] != null) {
      const tableContent = this.removeEmptyTags(match[1]);
      const replacedContent = tableContent.replace(/\{\{(.*?)\}\}/g, (match2, variable) => {
        return `<div class='list-item'>{{${variable}}}</div>`;
      });
      return content.replace(tableRegex, `[[startList]]${replacedContent}[[endList]]`);
    }
    return content;
  }
  // #endregion
  // #region Rows
  replaceRows(content) {
    const startRegex = /\[\[startRow\]\]/gi;
    const startReplacement = `<div class='row'>`;
    const endRegex = /\[\[endRow\]\]/gi;
    const endReplacement = `</div>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  // #endregion
  // #region Alignment
  replaceAlignment(content) {
    if (content.includes("startAlign.right")) {
      const startRegex = /\[\[startAlign.right\]\]/gi;
      const startReplacement = `<div class='align-right'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.right\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    if (content.includes("startAlign.left")) {
      const startRegex = /\[\[startAlign.left\]\]/gi;
      const startReplacement = `<div class='align-left'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.left\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    if (content.includes("startAlign.centered")) {
      const startRegex = /\[\[startAlign.center\]\]/gi;
      const startReplacement = `<div class='align-center'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.center\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    if (content.includes("startAlign.justified")) {
      const startRegex = /\[\[startAlign.justify\]\]/gi;
      const startReplacement = `<div class='align-justify'>`;
      content = content.replace(startRegex, startReplacement);
      const endRegex = /\[\[endAlign.justify\]\]/gi;
      const endReplacement = `</div>`;
      content = content.replace(endRegex, endReplacement);
    }
    return content;
  }
  // #endregion
  // #region Blocks
  replaceBlocks(content) {
    const startRegex = /\[\[startBlock\]\]/gi;
    const startReplacement = `<div class='block'>`;
    const endRegex = /\[\[endBlock\]\]/gi;
    const endReplacement = `</div>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  // #endregion
  // #region Tables
  replaceTables(content) {
    content = this.replaceTableVariables(content);
    const startRegex = /\[\[startTable\]\]/gi;
    const startReplacement = `<table class='standard'><tbody>`;
    const endRegex = /\[\[endTable\]\]/gi;
    const endReplacement = `</tbody></table>`;
    content = content.replace(startRegex, startReplacement);
    return content.replace(endRegex, endReplacement);
  }
  replaceTableVariables(content) {
    const tableRegex = /\[\[startTable\]\]([\s\S]*?)\[\[endTable\]\]/g;
    const matches = Array.from(content.matchAll(tableRegex)).map((match) => match[1]);
    for (var i = 0, len = matches.length; i < len; i++) {
      const match = matches[i];
      const replacedContent = match.replace(/\{\{(.*?)\}\}/gi, (m, variable) => {
        if (variable.indexOf("initial") < 0 && variable.indexOf("signature") < 0) {
          return `<tr><td class='label'>{{${variable}.label}}</td><td>{{${variable}}}</td></td>`;
        }
        return `{{${variable}}}`;
      });
      content = content.replace(match, replacedContent);
    }
    return content;
  }
  // #endregion
  // #region Payments
  get payments() {
    return this.content?.payments ?? [];
  }
  replacePayments(content) {
    const firstPayment = this.payments[0];
    if (firstPayment != null) {
      const labelRegex = /{{appointment.payments.first.amount.label}}/gi;
      const labelReplacement = `${firstPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.first.amount}}/gi;
      const amount = this.currencyPipe.transform(firstPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment1Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.first.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.first.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    const secondPayment = this.payments[1];
    if (secondPayment != null) {
      const labelRegex = /{{appointment.payments.second.amount.label}}/gi;
      const labelReplacement = `${secondPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.second.amount}}/gi;
      const amount = this.currencyPipe.transform(secondPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment2Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.second.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.second.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    const thirdPayment = this.payments[2];
    if (thirdPayment != null) {
      const labelRegex = /{{appointment.payments.third.amount.label}}/gi;
      const labelReplacement = `${thirdPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.third.amount}}/gi;
      const amount = this.currencyPipe.transform(thirdPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment3Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.third.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.third.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    const fourthPayment = this.payments[4];
    if (fourthPayment != null) {
      const labelRegex = /{{appointment.payments.fourth.amount.label}}/gi;
      const labelReplacement = `${fourthPayment.description}`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.fourth.amount}}/gi;
      const amount = this.currencyPipe.transform(fourthPayment.amount, "USD", "symbol", "1.2-2") || "";
      let replacement = `<span id='payment4Amount'>${amount}</span>`;
      content = content.replace(regex, replacement);
    } else {
      const labelRegex = /{{appointment.payments.fourth.amount.label}}/gi;
      const labelReplacement = ``;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{appointment.payments.fourth.amount}}/gi;
      const replacement = ``;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  updatePaymentAmount(name, amount) {
    return __async(this, null, function* () {
      const paymentSetting = deepClone(this.opportunity?.paymentSetting);
      if (this.opportunity != null && paymentSetting != null && this.activeUser != null) {
        const detail = paymentSetting.details.find((x) => x.name == name);
        if (detail != null) {
          detail.amount = amount;
          yield this.opportunityService.updatePaymentSetting(this.opportunity, paymentSetting, this.activeUser);
        }
      }
    });
  }
  // #endregion
  // #region Pricing
  get price() {
    return this.content?.price;
  }
  replaceFinalPrice(content) {
    const labelRegex = /{{appointment.price.final.label}}/gi;
    const labelReplacement = `Contract Price`;
    content = content.replace(labelRegex, labelReplacement);
    const priceRegex = /{{appointment.price.final}}/gi;
    if (this.price != null) {
      const price = this.currencyPipe.transform(this.price.price, "USD", "symbol", "1.2-2") || "";
      content = content.replace(priceRegex, `${price}`);
    } else {
      content = content.replace(priceRegex, ``);
    }
    return content;
  }
  // #endregion   
  // #region Customer
  get customer() {
    return this.content?.customer;
  }
  get email() {
    if (this.customer != null) {
      for (var i = 0, len = this.customer.contactInformation.length; i < len; i++) {
        const contactInfo = this.customer.contactInformation[i];
        if (contactInfo.type == ContactInformationType.Email) {
          return contactInfo.value;
        }
      }
    }
    return "";
  }
  get cellPhone() {
    if (this.customer != null) {
      for (var i = 0, len = this.customer.contactInformation.length; i < len; i++) {
        const contactInfo = this.customer.contactInformation[i];
        if (contactInfo.type == ContactInformationType.CellPhone) {
          return contactInfo.value;
        }
      }
    }
    return "";
  }
  get homePhone() {
    if (this.customer != null) {
      for (var i = 0, len = this.customer.contactInformation.length; i < len; i++) {
        const contactInfo = this.customer.contactInformation[i];
        if (contactInfo.type == ContactInformationType.HomePhone) {
          return contactInfo.value;
        }
      }
    }
    return "";
  }
  replaceCustomerName(content) {
    if (this.customer != null) {
      const labelRegex = /{{customer.name.label}}/gi;
      const labelReplacement = `Customer Name`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{customer.name}}/gi;
      const replacement = `${this.customer.firstName} ${this.customer.lastName}`;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  replaceCustomerEmail(content) {
    if (this.customer != null) {
      const labelRegex = /{{customer.email.label}}/gi;
      const labelReplacement = `Customer E-Mail`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{customer.email}}/gi;
      const replacement = this.email;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  replaceCustomerPhone(content) {
    if (this.customer != null) {
      const cellLabelRegex = /{{customer.phone.cell.label}}/gi;
      const cellLabelReplacement = `Customer Cell Phone`;
      content = content.replace(cellLabelRegex, cellLabelReplacement);
      const cellRegex = /{{customer.phone.cell}}/gi;
      const cellReplacement = this.cellPhone;
      content = content.replace(cellRegex, cellReplacement);
      const homeLabelRegex = /{{customer.phone.home.label}}/gi;
      const homeLabelReplacement = `Customer Home Phone`;
      content = content.replace(homeLabelRegex, homeLabelReplacement);
      const homeRegex = /{{customer.phone.home}}/gi;
      const homeReplacement = this.homePhone;
      content = content.replace(homeRegex, homeReplacement);
      const workLabelRegex = /{{customer.phone.work.label}}/gi;
      const workLabelReplacement = `Customer Work Phone`;
      content = content.replace(workLabelRegex, workLabelReplacement);
      const workRegex = /{{customer.phone.work}}/gi;
      const workReplacement = this.homePhone;
      content = content.replace(workRegex, workReplacement);
    }
    return content;
  }
  // #endregion
  // #region Consultant
  get consultant() {
    var consultant = this.content?.consultant;
    return consultant;
  }
  replaceConsultantName(content) {
    if (this.consultant != null) {
      const labelRegex = /{{consultant.name.label}}/gi;
      const labelReplacement = `Consultant Name`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{consultant.name}}/gi;
      const replacement = `${this.consultant.firstName} ${this.consultant.lastName}`;
      content = content.replace(regex, replacement);
    }
    return content;
  }
  replaceConsultantPhone(content) {
    if (this.consultant != null) {
      const labelRegex = /{{consultant.phone.label}}/gi;
      const labelReplacement = `Consultant Phone`;
      content = content.replace(labelRegex, labelReplacement);
      if (this.consultant.phone != null) {
        const regex = /{{consultant.phone}}/gi;
        const replacement = `${this.consultant.phone}`;
        content = content.replace(regex, replacement);
      } else {
        const regex = /{{consultant.phone}}/gi;
        content = content.replace(regex, "");
      }
    }
    return content;
  }
  replaceConsultantEmail(content) {
    if (this.consultant != null) {
      const labelRegex = /{{consultant.email.label}}/gi;
      const labelReplacement = `Consultant E-mail`;
      content = content.replace(labelRegex, labelReplacement);
      if (this.consultant.emailAddress) {
        const regex = /{{consultant.email}}/gi;
        const replacement = `${this.consultant.emailAddress}`;
        content = content.replace(regex, replacement);
      } else {
        const regex = /{{consultant.email}}/gi;
        content = content.replace(regex, "");
      }
    }
    return content;
  }
  // #endregion
  // #region Property
  get property() {
    return this.content?.property;
  }
  get address() {
    if (this.property?.address != null) {
      return Object.assign(new Address(), this.property.address);
    }
    return void 0;
  }
  get billingAddress() {
    if (this.property?.address != null) {
      return Object.assign(new Address(), this.property.billingAddress);
    }
    return void 0;
  }
  get mailingAddress() {
    if (this.property?.address != null) {
      return Object.assign(new Address(), this.property.mailingAddress);
    }
    return void 0;
  }
  replaceAddresses(content) {
    if (this.property?.address != null) {
      const labelRegex = /{{property.address.label}}/gi;
      const labelReplacement = `Property Address`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{property.address}}/gi;
      const replacement = this.address?.friendlyAddress ?? "";
      content = content.replace(regex, replacement);
    }
    if (this.property?.billingAddress != null) {
      const labelRegex = /{{property.billingaddress.label}}/gi;
      const labelReplacement = `Billing Address`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{property.billingaddress}}/gi;
      const replacement = this.billingAddress?.friendlyAddress ?? "";
      content = content.replace(regex, replacement);
    }
    if (this.property?.mailingAddress != null) {
      const labelRegex = /{{property.mailingaddress.label}}/gi;
      const labelReplacement = `Mailing Address`;
      content = content.replace(labelRegex, labelReplacement);
      const regex = /{{property.mailingaddress}}/gi;
      const replacement = this.mailingAddress?.friendlyAddress ?? "";
      content = content.replace(regex, replacement);
    }
    return content;
  }
  // #endregion
  // #region Content
  replaceLogo(content) {
    return new Promise((res, rej) => {
      const regex = /{{logo}}/gi;
      this.getImage(`/assets/images/logo.svg`).then((image) => {
        const replacement = `<div class="logo"><img class="static" crossorigin="anonymous" src="${image}" /></div>`;
        res(content.replace(regex, replacement));
      }).catch(() => {
        res("");
      });
    });
  }
  replaceDocumentName(name, content) {
    const regex = /{{document.name}}/gi;
    const replacement = `<h2>${name}</h2>`;
    return content.replace(regex, replacement);
  }
  replaceCustomerDocumentsReceived(content) {
    const regex = /{{customer.documentsReceived}}/gi;
    let replacement = "<span class='note'>Documents received by Customer: ";
    for (var i = 0, len = this.documents.length; i < len; i++) {
      const document2 = this.documents[i];
      if (document2.customerFacing) {
        if (i == 0) {
          replacement = replacement + `${document2.name}`;
        } else {
          replacement = replacement + `, ${document2.name}`;
        }
      }
    }
    replacement = replacement + "</span>";
    return content.replace(regex, replacement);
  }
  replaceAppointmentDates(content) {
    if (this.content?.scheduled_Utc != null) {
      const labelRegex = /{{appointment.date.scheduled.label}}/gi;
      const labelReplacement = `Estimate Date`;
      content = content.replace(labelRegex, labelReplacement);
      const scheduledRegex = /{{appointment.date.scheduled}}/gi;
      const scheduledDate = new Date(this.content.scheduled_Utc);
      const scheduledDateStr = `${scheduledDate.getUTCFullYear()}-${String(scheduledDate.getUTCMonth() + 1).padStart(2, "0")}-${String(scheduledDate.getUTCDate()).padStart(2, "0")} at ${String(scheduledDate.getUTCHours()).padStart(2, "0")}:${String(scheduledDate.getUTCMinutes()).padStart(2, "0")}:${String(scheduledDate.getUTCSeconds()).padStart(2, "0")} UTC`;
      content = content.replace(scheduledRegex, scheduledDateStr);
    }
    return content;
  }
  replaceTimestamp(content) {
    const labelRegex = /{{timestamp.label}}/gi;
    const labelReplacement = `Date`;
    content = content.replace(labelRegex, labelReplacement);
    const now = /* @__PURE__ */ new Date();
    const utcDate = new Date(now.toISOString());
    const year = utcDate.getUTCFullYear();
    const month = String(utcDate.getUTCMonth() + 1).padStart(2, "0");
    const day = String(utcDate.getUTCDate()).padStart(2, "0");
    const hours = String(utcDate.getUTCHours()).padStart(2, "0");
    const minutes = String(utcDate.getUTCMinutes()).padStart(2, "0");
    const seconds = String(utcDate.getUTCSeconds()).padStart(2, "0");
    const tsRegex = /{{timestamp}}/gi;
    const tsReplacement = `${year}-${month}-${day} at ${hours}:${minutes}:${seconds} UTC`;
    content = content.replace(tsRegex, tsReplacement);
    const tsdRegex = /{{timestamp.date}}/gi;
    const tsdreplacement = `${day}`;
    content = content.replace(tsdRegex, tsdreplacement);
    const tsmRegex = /{{timestamp.month}}/gi;
    const tsmReplacement = `${month}`;
    content = content.replace(tsmRegex, tsmReplacement);
    const tsyRegex = /{{timestamp.year}}/gi;
    const tsyReplacement = `${year}`;
    content = content.replace(tsyRegex, tsyReplacement);
    return content;
  }
  replaceVariables(document2, content) {
    return new Promise((res, rej) => __async(this, null, function* () {
      const regex = /\{\{(.*?)\}\}/gi;
      const variables = [];
      let match;
      while ((match = regex.exec(content)) !== null) {
        variables.push(match[0]);
      }
      for (var i = 0, len = variables.length; i < len; i++) {
        const variable = variables[i];
        if (variable.indexOf("customer.phone") > -1) {
          content = this.replaceCustomerPhone(content);
        }
        const sanitizedVariable = variable.toLowerCase();
        switch (sanitizedVariable) {
          case "{{logo}}":
            {
              content = yield this.replaceLogo(content);
            }
            break;
          case "{{document.name}}":
            {
              content = this.replaceDocumentName(document2.name, content);
            }
            break;
          case "{{inspection.diagrams}}":
            {
              content = this.replaceDiagrams("{{inspection.diagrams}}", content);
            }
            break;
          case "{{inspection.photos}}":
            {
              content = this.replacePhotos("{{inspection.photos}}", content);
            }
            break;
          case "{{inspection.attributes}}":
            {
              content = this.replaceAttributes("{{inspection.attributes}}", content, false);
            }
            break;
          case "{{inspection.attributes.customer}}":
            {
              content = this.replaceAttributes("{{inspection.attributes.customer}}", content, true);
            }
            break;
          case "{{entity.details.label}}":
            {
              content = content.replaceAll("{{entity.details.label}}", "Property Details");
            }
            break;
          case "{{entity.details}}":
            {
              content = this.replaceEntityDetails("{{entity.details}}", content, false);
            }
            break;
          case "{{entity.details.shop}}":
            {
              content = this.replaceEntityDetails("{{entity.details.shop}}", content, false);
            }
            break;
          case "{{entity.details.customer}}":
            {
              content = this.replaceEntityDetails("{{entity.details.customer}}", content, true);
            }
            break;
          case "{{customer.name}}":
            {
              content = this.replaceCustomerName(content);
            }
            break;
          case "{{checkbox.customer.optional}}":
            {
              content = this.replaceCheckboxes("{{checkbox.customer.optional}}", content, "customer", false);
            }
            break;
          case "{{checkbox.customer.mandatory}}":
            {
              content = this.replaceCheckboxes("{{checkbox.customer.mandatory}}", content, "customer", true);
            }
            break;
          case "{{checkbox.consultant.optional}}":
            {
              content = this.replaceCheckboxes("{{checkbox.consultant.optional}}", content, "consultant", false);
            }
            break;
          case "{{checkbox.consultant.mandatory}}":
            {
              content = this.replaceCheckboxes("{{checkbox.consultant.mandatory}}", content, "consultant", true);
            }
            break;
          case "{{textbox.consultant.optional}}":
            {
              content = this.replaceTextbox("{{textbox.consultant.optional}}", content, "consultant", false);
            }
            break;
          case "{{textbox.customer.optional}}":
            {
              content = this.replaceTextbox("{{textbox.customer.optional}}", content, "customer", false);
            }
            break;
          case "{{customer.email}}":
            {
              content = this.replaceCustomerEmail(content);
            }
            break;
          case "{{appointment.price.final}}":
            {
              content = this.replaceFinalPrice(content);
            }
            break;
          case "{{property.address}}":
            {
              content = this.replaceAddresses(content);
            }
            break;
          case "{{property.billingaddress}}":
            {
              content = this.replaceAddresses(content);
            }
            break;
          case "{{property.mailingaddress}}":
            {
              content = this.replaceAddresses(content);
            }
            break;
          case "{{consultant.name}}":
            {
              content = this.replaceConsultantName(content);
            }
            break;
          case "{{consultant.phone}}":
            {
              content = this.replaceConsultantPhone(content);
            }
            break;
          case "{{consultant.email}}":
            {
              content = this.replaceConsultantEmail(content);
            }
            break;
          case "{{appointment.jobid}}":
            {
              content = this.replaceJobId(content);
            }
            break;
          case "{{timestamp}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{timestamp.date}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{timestamp.month}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{timestamp.year}}":
            {
              content = this.replaceTimestamp(content);
            }
            break;
          case "{{customer.documentsreceived}}":
            {
              content = this.replaceCustomerDocumentsReceived(content);
            }
            break;
          case "{{inspection.customernotes}}":
            {
              content = this.replaceNotes(variable, content, "customer");
            }
            break;
          case "{{inspection.shopnotes}}":
            {
              content = this.replaceNotes(variable, content, "shop");
            }
            break;
          case "{{signature.consultant.mandatory}}":
            {
              content = this.replaceSignature(variable, content, "consultant", true);
            }
            break;
          case "{{signature.consultant.optional}}":
            {
              content = this.replaceSignature(variable, content, "consultant", false);
            }
            break;
          case "{{initial.consultant.mandatory}}":
            {
              content = this.replaceInitials(variable, content, "consultant", true);
            }
            break;
          case "{{initial.consultant.optional}}":
            {
              content = this.replaceInitials(variable, content, "consultant", false);
            }
            break;
          case "{{signature.customer.mandatory}}":
            {
              content = this.replaceSignature(variable, content, "customer", true);
            }
            break;
          case "{{signature.customer.optional}}":
            {
              content = this.replaceSignature(variable, content, "customer", false);
            }
            break;
          case "{{initial.customer.mandatory}}":
            {
              content = this.replaceInitials(variable, content, "customer", true);
            }
            break;
          case "{{initial.customer.optional}}":
            {
              content = this.replaceInitials(variable, content, "customer", false);
            }
            break;
        }
      }
      res(content);
    }));
  }
  removeEmptyTags(content) {
    const regex = /<\/?p>/gi;
    return content.replace(regex, "");
  }
  removeEmptyLines(content) {
    const pRegex = /<p>\s*(<[^>]+>[\s\S]*?)<\/p>|<p>\s*<\/p>/gi;
    content = content.replace(pRegex, (match, innerContent) => innerContent || "");
    const bRegex = /<br\s*\/?>(\s*(?=<[^>]+>))/gi;
    content = content.replace(bRegex, "");
    return content;
  }
  replaceParagraphs(content) {
    const pRegex = /<p>/gi;
    content = content.replace(pRegex, '<div class="paragraph">');
    const pCloseRegex = /<\/p>/gi;
    content = content.replace(pCloseRegex, "</div>");
    return content;
  }
  generateContent(document2) {
    return __async(this, null, function* () {
      if (document2.content != null) {
        let generatedContent = this.replaceLabels(document2.content);
        generatedContent = this.replaceH2(generatedContent);
        generatedContent = this.replaceHr(generatedContent);
        generatedContent = this.replaceAlignment(generatedContent);
        generatedContent = this.replaceBlocks(generatedContent);
        generatedContent = this.replaceTables(generatedContent);
        generatedContent = this.replaceLists(generatedContent);
        generatedContent = this.replaceRows(generatedContent);
        generatedContent = yield this.replaceVariables(document2, generatedContent);
        generatedContent = yield this.replaceVariables(document2, generatedContent);
        generatedContent = this.replaceAppointmentDates(generatedContent);
        generatedContent = this.replacePayments(generatedContent);
        generatedContent = this.replaceAdditionalConsiderations(generatedContent);
        generatedContent = this.replaceHeaders(generatedContent);
        generatedContent = this.removeEmptyLines(generatedContent);
        generatedContent = this.replaceParagraphs(generatedContent);
        generatedContent = this.replaceTextTags(generatedContent);
        generatedContent = this.replaceTextSizes(generatedContent);
        generatedContent = generatedContent.replace(`<div class="paragraph">&nbsp;</div>`, "");
        return generatedContent;
      }
      return "";
    });
  }
  processContent(document2) {
    return __async(this, null, function* () {
      return new Promise((res, rej) => __async(this, null, function* () {
        if (document2.content != null) {
          let generatedContent = yield this.generateContent(document2);
          if (document2.documents != null) {
            for (var i = 0, len = document2.documents.length; i < len; i++) {
              const childDoc = document2.documents[i];
              generatedContent = generatedContent + (yield this.generateContent(childDoc));
            }
          }
          this.documentContent = this.sanitizer.bypassSecurityTrustHtml(generatedContent);
          document2.generatedContent = generatedContent;
          document2.originalHash = document2.hash;
        }
        setTimeout(() => {
          this.initSignatureElms();
          this.initIntialElms();
          this.initInputElms();
          this.changed$.next();
        }, 0);
        res();
      }));
    });
  }
  getImage(src) {
    return __async(this, null, function* () {
      const image = yield this.contentService.getImage(src);
      return image.localSrc;
    });
  }
  get rendered() {
    return this.document?.rendered ?? false;
  }
  renderDocument() {
    return new Promise((res, rej) => {
      if (this.document != null) {
        this.document.rendered = true;
        res();
      } else {
        rej();
      }
    });
  }
  shimExport(viewerElm, count = 1) {
    return __async(this, null, function* () {
      if (this.document != null) {
        for (var i = 0; i < count; i++) {
          yield this.document.renderCanvas(viewerElm);
        }
      }
    });
  }
  exportDocument(quality = 1, pixelRatio = 1, count = 0) {
    return new Promise((res, rej) => {
      setTimeout(() => __async(this, null, function* () {
        if (this.document != null) {
          const viewerElm = this.viewerElm?.nativeElement;
          if (viewerElm != null) {
            toCanvas(viewerElm, {
              quality,
              pixelRatio,
              backgroundColor: "#ffffff",
              skipFonts: true,
              filter: (renderElm) => !renderElm.classList?.contains("no-render")
            }).then((finalRenderCanvas) => {
              try {
                const output = document.createElement("canvas");
                output.width = finalRenderCanvas.width;
                output.height = finalRenderCanvas.height;
                const ctx = output.getContext("2d", { willReadFrequently: true });
                const viewerRect = viewerElm.getBoundingClientRect();
                const renderRatio = viewerRect.width / finalRenderCanvas.width;
                ctx.fillStyle = "#ffffff";
                ctx.fillRect(0, 0, output.width, output.height);
                const localCanvases = Array.from(viewerElm.querySelectorAll("canvas"));
                for (const canvas of localCanvases) {
                  const rect = canvas.getBoundingClientRect();
                  const viewerRect2 = viewerElm.getBoundingClientRect();
                  const x = (rect.left - viewerRect2.left) / renderRatio;
                  const y = (rect.top - viewerRect2.top) / renderRatio;
                  const width = canvas.width / renderRatio;
                  const height = canvas.height / renderRatio;
                  ctx.drawImage(canvas, x, y, width, height);
                }
                const temp = document.createElement("canvas");
                temp.width = finalRenderCanvas.width;
                temp.height = finalRenderCanvas.height;
                const tctx = temp.getContext("2d", { willReadFrequently: true });
                tctx.drawImage(finalRenderCanvas, 0, 0);
                const imgData = tctx.getImageData(0, 0, temp.width, temp.height);
                const data = imgData.data;
                for (let i = 0; i < data.length; i += 4) {
                  if (data[i] === 255 && data[i + 1] === 255 && data[i + 2] === 255) {
                    data[i + 3] = 0;
                  }
                }
                tctx.clearRect(0, 0, temp.width, temp.height);
                tctx.putImageData(imgData, 0, 0);
                ctx.drawImage(temp, 0, 0);
                res(output);
              } catch (e) {
                this.logService.log(JSON.stringify(e), `Failed to export document ${this.document?.id} for opportunity ${this.opportunity?.id}.`).subscribe();
                rej();
              }
            }).catch(rej);
          }
        }
      }), 128);
    });
  }
  setDocumentValidity() {
    window.clearTimeout(this.documentValidityDebounce);
    this.documentValidityDebounce = window.setTimeout(() => {
      if (this.document != null) {
        this.validateSignatures();
        this.validateUserContent();
        if (this.signaturesValid && this.userContentValid && this.document.rendered) {
          this.document.validForExecution = true;
          this.document.executed = true;
        } else {
          this.document.validForExecution = false;
          this.document.executed = false;
          this.changed$.next();
        }
        this.document.checkedValidation = true;
      }
    }, 500);
  }
  initDocument() {
    return __async(this, null, function* () {
      if (this.document != null) {
        const document2 = this.document;
        document2.rendered = false;
        if (document2.dynamic) {
          yield this.processContent(document2);
        } else if (document2.mapping != null) {
          yield this.initMapping(document2);
        }
        setTimeout(() => {
          this.renderDocument().then(() => {
            if (!document2.rendered) {
              this.uiService.prompt("Failed to Render", "There was an issue rendering this document. Please contact support for assistance.", "Ok").subscribe({
                next: (confirmed) => {
                }
              });
            }
            if (this.signing) {
              this.watchSignatures();
              this.watchInitials();
            }
            setTimeout(() => {
              if (this.signing) {
                this.restoreSignatures();
                this.restoreUserContent();
                this.setDocumentValidity();
              }
              setTimeout(() => {
                this.rendered$.next();
                this.changed$.next();
              }, 768);
            }, 0);
          });
        }, 16);
      }
    });
  }
  get showLoader() {
    return true;
  }
  init() {
    this.watchUser();
    this.initDocument();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
    this.initialSubscription?.unsubscribe();
    this.signatureSubscription?.unsubscribe();
  }
};
_OpportunityDocumentComponent.\u0275fac = function OpportunityDocumentComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityDocumentComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(DocumentService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(CurrencyPipe), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(DomSanitizer));
};
_OpportunityDocumentComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunityDocumentComponent, selectors: [["opportunity-document"]], viewQuery: function OpportunityDocumentComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
    \u0275\u0275viewQuery(_c14, 5);
    \u0275\u0275viewQuery(_c22, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.viewerElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.staticElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity", content: "content", execute: "execute", document: "document", signer: "signer", signing: "signing" }, outputs: { rendered$: "rendered", changed$: "changed" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe,
  CurrencyPipe
])], decls: 7, vars: 5, consts: [["viewerElm", ""], ["staticElm", ""], [1, "document", "previewing"], [3, "fill"], ["id", "viewerElm", 1, "content", "render"], [1, "dynamic-content", 3, "innerHtml"], [1, "static-content"], [1, "page"], ["crossorigin", "anonymous", 1, "static", 3, "src"], [1, "fields"], [1, "field", 3, "left", "top", "width", "height", "innerHTML"], [1, "field", 3, "innerHTML"]], template: function OpportunityDocumentComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275conditionalCreate(1, OpportunityDocumentComponent_Conditional_1_Template, 1, 1, "loader", 3);
    \u0275\u0275elementStart(2, "div", 4, 0);
    \u0275\u0275elementContainerStart(4);
    \u0275\u0275conditionalCreate(5, OpportunityDocumentComponent_Conditional_5_Template, 1, 1, "div", 5);
    \u0275\u0275conditionalCreate(6, OpportunityDocumentComponent_Conditional_6_Template, 4, 0, "div", 6);
    \u0275\u0275elementContainerEnd();
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.rendered ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("rendered", ctx.rendered);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.isDynamic ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.isDynamic ? 6 : -1);
  }
}, dependencies: [LoaderComponent], styles: ['\n\n.document[_ngcontent-%COMP%] {\n  min-height: 100%;\n}\n.document[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 25%;\n  z-index: 0;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 2s;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  font-size: 1.6vw;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  opacity: 0;\n  pointer-events: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]     *:not(i) {\n  font-family:\n    "Times New Roman",\n    Times,\n    serif !important;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%] {\n  padding: 1vw;\n  background-color: var(--color2);\n  min-height: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo {\n  width: 24vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo img {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .paragraph {\n  margin-top: 2vw;\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     hr {\n  margin: 2vw 0;\n  height: 0.3vw;\n  box-shadow: none;\n  border: none;\n  background-color: var(--color1Alt3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h2 {\n  font-size: 3.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 1vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h3 {\n  font-size: 2.8vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 0.5vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small {\n  font-size: 1.2vw;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small * {\n  font-size: 1.2vw !important;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium {\n  font-size: 1.8vw;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium * {\n  font-size: 1.8vw !important;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large {\n  font-size: 2.4vw;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large * {\n  font-size: 2.4vw !important;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .note {\n  font-size: 1.6vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n  margin: 1ch 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .row {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .block {\n  display: block;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note {\n  position: relative;\n  padding-right: 40vw;\n  min-height: 10vw;\n  margin: 1ch 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > label {\n  display: block;\n  line-height: 1;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > .value {\n  display: block;\n  line-height: 1;\n  margin-top: 1ch;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams {\n  margin-top: 2vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > h2 {\n  font-size: 2.8vw;\n  font-weight: var(--stronger);\n  color: var(--color1);\n  margin-bottom: 1vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams {\n  margin-top: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram {\n  margin-top: 1vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n  font-size: 1.8vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > .image {\n  margin-top: 0.5vw;\n  border: 0.5vw var(--color4Alt4) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  font-size: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > .image img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > .image canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram:first-child {\n  margin-top: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos {\n  margin-top: 1vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h4 {\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images {\n  margin-top: 0.5vw;\n  font-size: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image {\n  display: inline-block;\n  vertical-align: top;\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  border: 0.5vw var(--color5Alt4) solid;\n  border-radius: 2vw;\n  overflow: hidden;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image canvas {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > .images > .image:nth-child(odd) {\n  margin-left: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos:first-child {\n  margin-top: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .list {\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .list > .list-item {\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .spacer {\n  clear: both;\n  margin-top: 10vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials {\n  position: relative;\n  display: flex;\n  width: 100%;\n  justify-content: flex-end;\n  margin-bottom: 5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n  position: relative;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render canvas, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .hash, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .timestamp, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > label, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.mandatory > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.mandatory.consultant > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.valid > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.disabled, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.disabled {\n  pointer-events: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature.disabled > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials.disabled > .render {\n  background-color: var(--color2) !important;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render {\n  width: 20vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n  width: 10vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-left {\n  text-align: left;\n  display: flex;\n  justify-content: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-left > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-left * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-right {\n  text-align: right;\n  display: flex;\n  justify-content: flex-end;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-right > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-right * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-center {\n  text-align: center;\n  display: flex;\n  justify-content: center;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-center > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-center * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify {\n  text-align: justify;\n  display: flex;\n  justify-content: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify * {\n  text-align: initial;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard {\n  table-layout: auto;\n  max-width: 100%;\n  margin: 0.5vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr {\n  border-top: 0.2vw var(--color1Alt1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  border-left: 0.2vw var(--color1Alt1) solid;\n  padding: 0.5vw 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td.label {\n  background-color: var(--color3Alt3);\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td:first-child {\n  border-left-color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td:last-child {\n  border-right: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr:first-child {\n  border-top-color: var(--color1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr:last-child {\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr:nth-child(odd) {\n  background-color: var(--color2Alt1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details {\n  table-layout: fixed;\n  width: 100%;\n  margin: 0.5vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type {\n  border-top: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n  background-color: var(--color2Alt2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td {\n  padding: 0.5vw 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .parent {\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  text-transform: uppercase;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .entity {\n  font-size: 1.6vw;\n  color: var(--color1);\n  text-transform: uppercase;\n  font-weight: var(--strongest);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Structure {\n  background-color: rgba(var(--color4-raw), 0.25);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Structure > .type {\n  background-color: var(--color4);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Floor {\n  background-color: rgba(var(--color4Alt4-raw), 0.5);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type.Room {\n  background-color: rgba(var(--color3Alt1-raw), 0.5);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details {\n  background-color: var(--color2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td {\n  padding: 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  padding-right: 0.5vw;\n  border-right: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n  display: inline-block;\n  vertical-align: bottom;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n  margin-left: 0.5vw;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute:last-child {\n  border-right: none;\n  margin-right: 0;\n  padding-right: 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .attributes {\n  display: block;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures {\n  display: block;\n  margin-top: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture {\n  display: block;\n  margin-top: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-left: 0.5vw var(--color5) solid;\n  border-right: 0.5vw var(--color5) solid;\n  border-radius: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  font-size: 2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--stronger);\n  text-transform: uppercase;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.spacer {\n  border: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.spacer > td {\n  padding: 2vw 0;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations {\n  table-layout: fixed;\n  width: 100%;\n  border: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead {\n  background-color: var(--color2Alt2);\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead th {\n  padding: 0.5vw;\n  text-align: left;\n  font-size: 1.6vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > tbody > tr {\n  border-bottom: 0.1vw var(--color1) solid;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > tbody > tr td {\n  padding: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > tbody > tr:nth-child(even) {\n  background-color: var(--color2Alt1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox i {\n  font-size: 3.2vw;\n  margin-right: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox i.checked {\n  display: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox.checked i.checked {\n  display: block;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .checkbox.checked i.unchecked {\n  display: none;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     input, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  border: 0.2vw var(--color1) solid;\n  color: var(--color3);\n  background-color: var(--color2);\n  border-radius: 0.5vw;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     input:focus, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input textarea {\n  display: block;\n  width: 400px;\n  max-width: 100%;\n  font-size: 1.6vw;\n  font-weight: var(--stdweight);\n  padding: 0.5vw;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  resize: none;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input:focus-within textarea {\n  border-color: var(--color3);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%] {\n  position: relative;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]     canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  white-space: nowrap;\n  display: flex;\n  align-items: flex-end;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials {\n  position: absolute;\n  left: 0;\n  top: 0;\n  height: 100%;\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render canvas, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render canvas {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render img, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .hash, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .timestamp, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > label, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 0.7vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature.mandatory > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature.mandatory.consultant > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature.valid > .render, \n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > img[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.document[_ngcontent-%COMP%]    > .content.rendered[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n.float[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 10px;\n  right: 10px;\n  height: 10px;\n  width: 10px;\n  z-index: 9999999;\n  cursor: pointer;\n}\n@media only screen and (max-width: 768px) {\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%] {\n    padding: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo {\n    width: 24vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h2 {\n    font-size: 4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h3 {\n    font-size: 3.2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small * {\n    font-size: 1.6vw !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium {\n    font-size: 3.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium * {\n    font-size: 3.6vw !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large {\n    font-size: 4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large * {\n    font-size: 4vw !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .note {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > label {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > .value {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > h2 {\n    font-size: 3vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h3 {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h4 {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > label {\n    font-size: 1.4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render {\n    width: 20vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n    width: 10vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify > .block {\n    max-width: 50%;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify * {\n    text-align: initial;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 2.4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead th {\n    font-size: 2vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input textarea {\n    font-size: 2.4vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%] {\n    font-size: 1.6vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render {\n    border-radius: 0.5vw;\n    padding: 0.5vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > label {\n    font-size: 0.7vw;\n  }\n}\n@media only screen and (min-width: 1201px) and (hover: hover) and (pointer: fine) {\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%] {\n    padding: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .logo {\n    width: 250px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h2 {\n    font-size: 36px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     h3 {\n    font-size: 28px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-small * {\n    font-size: 20px !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium {\n    font-size: 32px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-medium * {\n    font-size: 32px !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large {\n    font-size: 40px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .font-large * {\n    font-size: 40px !important;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .note {\n    font-size: 26px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > label {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .customer-note > .value {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > h2 {\n    font-size: 36px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h3 {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .inspection-photos > h4 {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > label {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .signature > .render {\n    width: 260px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .initials > .render {\n    width: 150px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify > .block {\n    max-width: 50%;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .align-justify * {\n    text-align: initial;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.standard tbody tr td {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 20px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     table.additional-considerations > thead th {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dynamic-content[_ngcontent-%COMP%]     .input textarea {\n    font-size: 32px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%] {\n    font-size: 24px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render {\n    border-radius: 8px;\n    padding: 8px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .hash, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > .render .timestamp, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .signature > label, \n   .document[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .static-content[_ngcontent-%COMP%]   .page[_ngcontent-%COMP%]   .fields[_ngcontent-%COMP%]   .field[_ngcontent-%COMP%]     .initials > label {\n    font-size: 10px;\n  }\n}\n/*# sourceMappingURL=opportunity-document.component.css.map */'] });
var OpportunityDocumentComponent = _OpportunityDocumentComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityDocumentComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-document", providers: [
      OrderByPipe,
      CurrencyPipe
    ], template: '<div class="document previewing">\n  @if (!rendered) {\n    <loader [fill]="false"></loader>\n  }\n  <div id="viewerElm" class="content render" #viewerElm [class.rendered]="rendered">\n    <ng-container>\n      @if (isDynamic) {\n        <div class="dynamic-content" [innerHtml]="documentContent"></div>\n      }\n      @if (!isDynamic) {\n        <div class="static-content" #staticElm>\n          @for (page of activePages; track $index) {\n            <div class="page">\n              <img class="static" crossorigin="anonymous" [src]="page.src" />\n              <div class="fields">\n                @for (field of page.fields; track $index) {\n                  <div class="field"\n                    [style.left]="field.displayX"\n                    [style.top]="field.displayY"\n                    [style.width]="field.displayWidth"\n                    [style.height]="field.displayHeight"\n                    [innerHTML]="field.contentHtml">\n                  </div>\n                }\n              </div>\n            </div>\n          }\n        </div>\n      }\n    </ng-container>\n  </div>\n</div>', styles: ['/* src/app/shared/documents/components/opportunity-document/opportunity-document.component.scss */\n.document {\n  min-height: 100%;\n}\n.document > loader {\n  display: block;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 25%;\n  z-index: 0;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 2s;\n}\n.document > .content {\n  height: 100%;\n  position: relative;\n  z-index: 1;\n  font-size: 1.6vw;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  opacity: 0;\n  pointer-events: none;\n}\n.document > .content ::ng-deep *:not(i) {\n  font-family:\n    "Times New Roman",\n    Times,\n    serif !important;\n}\n.document > .content > .dynamic-content {\n  padding: 1vw;\n  background-color: var(--color2);\n  min-height: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .logo {\n  width: 24vw;\n}\n.document > .content > .dynamic-content ::ng-deep .logo img {\n  width: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .paragraph {\n  margin-top: 2vw;\n  position: relative;\n}\n.document > .content > .dynamic-content ::ng-deep hr {\n  margin: 2vw 0;\n  height: 0.3vw;\n  box-shadow: none;\n  border: none;\n  background-color: var(--color1Alt3);\n}\n.document > .content > .dynamic-content ::ng-deep h2 {\n  font-size: 3.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 1vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep h3 {\n  font-size: 2.8vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  margin: 0.5vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep .font-small {\n  font-size: 1.2vw;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-small * {\n  font-size: 1.2vw !important;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-medium {\n  font-size: 1.8vw;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-medium * {\n  font-size: 1.8vw !important;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-large {\n  font-size: 2.4vw;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .font-large * {\n  font-size: 2.4vw !important;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .note {\n  font-size: 1.6vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n  margin: 1ch 0;\n}\n.document > .content > .dynamic-content ::ng-deep .row {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n.document > .content > .dynamic-content ::ng-deep .block {\n  display: block;\n}\n.document > .content > .dynamic-content ::ng-deep .customer-note {\n  position: relative;\n  padding-right: 40vw;\n  min-height: 10vw;\n  margin: 1ch 0;\n}\n.document > .content > .dynamic-content ::ng-deep .customer-note > label {\n  display: block;\n  line-height: 1;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.document > .content > .dynamic-content ::ng-deep .customer-note > .value {\n  display: block;\n  line-height: 1;\n  margin-top: 1ch;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams {\n  margin-top: 2vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > h2 {\n  font-size: 2.8vw;\n  font-weight: var(--stronger);\n  color: var(--color1);\n  margin-bottom: 1vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams {\n  margin-top: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram {\n  margin-top: 1vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n  font-size: 1.8vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > .image {\n  margin-top: 0.5vw;\n  border: 0.5vw var(--color4Alt4) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  font-size: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > .image img,\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > .image canvas {\n  width: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram:first-child {\n  margin-top: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos {\n  margin-top: 1vw;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > h3 {\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n  color: var(--color1Alt3);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > h4 {\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images {\n  margin-top: 0.5vw;\n  font-size: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image {\n  display: inline-block;\n  vertical-align: top;\n  width: calc(50% - 0.5vw);\n  margin-left: 1vw;\n  border: 0.5vw var(--color5Alt4) solid;\n  border-radius: 2vw;\n  overflow: hidden;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image img,\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image canvas {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos > .images > .image:nth-child(odd) {\n  margin-left: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .inspection-photos:first-child {\n  margin-top: 0;\n}\n.document > .content > .dynamic-content ::ng-deep .list {\n  position: relative;\n}\n.document > .content > .dynamic-content ::ng-deep .list > .list-item {\n  position: relative;\n}\n.document > .content > .dynamic-content ::ng-deep .spacer {\n  clear: both;\n  margin-top: 10vw;\n}\n.document > .content > .dynamic-content ::ng-deep .signature,\n.document > .content > .dynamic-content ::ng-deep .initials {\n  position: relative;\n  display: flex;\n  width: 100%;\n  justify-content: flex-end;\n  margin-bottom: 5vw;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render,\n.document > .content > .dynamic-content ::ng-deep .initials > .render {\n  position: relative;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render canvas,\n.document > .content > .dynamic-content ::ng-deep .initials > .render canvas {\n  width: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render img,\n.document > .content > .dynamic-content ::ng-deep .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render .hash,\n.document > .content > .dynamic-content ::ng-deep .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render .timestamp,\n.document > .content > .dynamic-content ::ng-deep .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > label,\n.document > .content > .dynamic-content ::ng-deep .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 1.4vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document > .content > .dynamic-content ::ng-deep .signature.mandatory > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document > .content > .dynamic-content ::ng-deep .signature.mandatory.consultant > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document > .content > .dynamic-content ::ng-deep .signature.valid > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document > .content > .dynamic-content ::ng-deep .signature.disabled,\n.document > .content > .dynamic-content ::ng-deep .initials.disabled {\n  pointer-events: none;\n}\n.document > .content > .dynamic-content ::ng-deep .signature.disabled > .render,\n.document > .content > .dynamic-content ::ng-deep .initials.disabled > .render {\n  background-color: var(--color2) !important;\n}\n.document > .content > .dynamic-content ::ng-deep .signature > .render {\n  width: 20vw;\n}\n.document > .content > .dynamic-content ::ng-deep .initials > .render {\n  width: 10vw;\n}\n.document > .content > .dynamic-content ::ng-deep .align-left {\n  text-align: left;\n  display: flex;\n  justify-content: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-left > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-left * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep .align-right {\n  text-align: right;\n  display: flex;\n  justify-content: flex-end;\n}\n.document > .content > .dynamic-content ::ng-deep .align-right > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.document > .content > .dynamic-content ::ng-deep .align-right * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep .align-center {\n  text-align: center;\n  display: flex;\n  justify-content: center;\n}\n.document > .content > .dynamic-content ::ng-deep .align-center > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.document > .content > .dynamic-content ::ng-deep .align-center * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep .align-justify {\n  text-align: justify;\n  display: flex;\n  justify-content: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-justify > .block {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n}\n.document > .content > .dynamic-content ::ng-deep .align-justify * {\n  text-align: initial;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard {\n  table-layout: auto;\n  max-width: 100%;\n  margin: 0.5vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr {\n  border-top: 0.2vw var(--color1Alt1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  font-weight: var(--strong);\n  border-left: 0.2vw var(--color1Alt1) solid;\n  padding: 0.5vw 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td.label {\n  background-color: var(--color3Alt3);\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td:first-child {\n  border-left-color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr td:last-child {\n  border-right: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr:first-child {\n  border-top-color: var(--color1);\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr:last-child {\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.standard tbody tr:nth-child(odd) {\n  background-color: var(--color2Alt1);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details {\n  table-layout: fixed;\n  width: 100%;\n  margin: 0.5vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type {\n  border-top: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n  background-color: var(--color2Alt2);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td {\n  padding: 0.5vw 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .parent {\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  text-transform: uppercase;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .entity {\n  font-size: 1.6vw;\n  color: var(--color1);\n  text-transform: uppercase;\n  font-weight: var(--strongest);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Structure {\n  background-color: rgba(var(--color4-raw), 0.25);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Structure > .type {\n  background-color: var(--color4);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Floor {\n  background-color: rgba(var(--color4Alt4-raw), 0.5);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type.Room {\n  background-color: rgba(var(--color3Alt1-raw), 0.5);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details {\n  background-color: var(--color2);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td {\n  padding: 0.5vw 0.5vw;\n  border-left: 0.2vw var(--color1) solid;\n  border-right: 0.2vw var(--color1) solid;\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  padding-right: 0.5vw;\n  border-right: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name,\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n  display: inline-block;\n  vertical-align: bottom;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n  margin-left: 0.5vw;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute:last-child {\n  border-right: none;\n  margin-right: 0;\n  padding-right: 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .attributes {\n  display: block;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures {\n  display: block;\n  margin-top: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture {\n  display: block;\n  margin-top: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-left: 0.5vw var(--color5) solid;\n  border-right: 0.5vw var(--color5) solid;\n  border-radius: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n  display: inline-block;\n  vertical-align: bottom;\n  margin-right: 0.5vw;\n  font-size: 2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--stronger);\n  text-transform: uppercase;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.spacer {\n  border: none;\n}\n.document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.spacer > td {\n  padding: 2vw 0;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations {\n  table-layout: fixed;\n  width: 100%;\n  border: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead {\n  background-color: var(--color2Alt2);\n  border-bottom: 0.2vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead th {\n  padding: 0.5vw;\n  text-align: left;\n  font-size: 1.6vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > tbody > tr {\n  border-bottom: 0.1vw var(--color1) solid;\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > tbody > tr td {\n  padding: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.document > .content > .dynamic-content ::ng-deep table.additional-considerations > tbody > tr:nth-child(even) {\n  background-color: var(--color2Alt1);\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox i {\n  font-size: 3.2vw;\n  margin-right: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox i.checked {\n  display: none;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox.checked i.checked {\n  display: block;\n}\n.document > .content > .dynamic-content ::ng-deep .checkbox.checked i.unchecked {\n  display: none;\n}\n.document > .content > .dynamic-content ::ng-deep input,\n.document > .content > .dynamic-content textarea {\n  border: 0.2vw var(--color1) solid;\n  color: var(--color3);\n  background-color: var(--color2);\n  border-radius: 0.5vw;\n}\n.document > .content > .dynamic-content ::ng-deep input:focus,\n.document > .content > .dynamic-content textarea:focus {\n  border-color: var(--color3);\n}\n.document > .content > .dynamic-content ::ng-deep .input textarea {\n  display: block;\n  width: 400px;\n  max-width: 100%;\n  font-size: 1.6vw;\n  font-weight: var(--stdweight);\n  padding: 0.5vw;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  resize: none;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n.document > .content > .dynamic-content ::ng-deep .input:focus-within textarea {\n  border-color: var(--color3);\n}\n.document > .content > .static-content .page {\n  position: relative;\n}\n.document > .content > .static-content .page img {\n  width: 100%;\n}\n.document > .content > .static-content .page ::ng-deep canvas {\n  width: 100%;\n}\n.document > .content > .static-content .page .fields .field {\n  position: absolute;\n  z-index: 1;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  white-space: nowrap;\n  display: flex;\n  align-items: flex-end;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials {\n  position: absolute;\n  left: 0;\n  top: 0;\n  height: 100%;\n  width: 100%;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border: 0.2vw var(--color1) dotted;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  cursor: pointer;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render canvas,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render canvas {\n  width: 100%;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render img,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .hash,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .hash {\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  position: absolute;\n  top: calc(100% + 2vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .timestamp,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .timestamp {\n  position: absolute;\n  top: calc(100% + 3vw);\n  left: auto;\n  right: 0;\n  bottom: auto;\n  font-size: 0.7vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature > label,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials > label {\n  text-align: right;\n  display: block;\n  font-size: 0.7vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n  position: absolute;\n  right: 0;\n  top: 100%;\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature.mandatory > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials.mandatory > .render {\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature.mandatory.consultant > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials.mandatory.consultant > .render {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n.document > .content > .static-content .page .fields .field ::ng-deep .signature.valid > .render,\n.document > .content > .static-content .page .fields .field ::ng-deep .initials.valid > .render {\n  background-color: rgba(var(--success-raw), 0.1);\n}\n.document > .content > img {\n  width: 100%;\n}\n.document > .content.rendered {\n  opacity: 1;\n  pointer-events: initial;\n}\n.float {\n  position: fixed;\n  bottom: 10px;\n  right: 10px;\n  height: 10px;\n  width: 10px;\n  z-index: 9999999;\n  cursor: pointer;\n}\n@media only screen and (max-width: 768px) {\n  .document > .content {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content {\n    padding: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .logo {\n    width: 24vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep h2 {\n    font-size: 4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep h3 {\n    font-size: 3.2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small * {\n    font-size: 1.6vw !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium {\n    font-size: 3.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium * {\n    font-size: 3.6vw !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large {\n    font-size: 4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large * {\n    font-size: 4vw !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .note {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > label {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > .value {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > h2 {\n    font-size: 3vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h3 {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h4 {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .hash,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .timestamp,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > label,\n  .document > .content > .dynamic-content ::ng-deep .initials > label {\n    font-size: 1.4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render {\n    width: 20vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .initials > .render {\n    width: 10vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify > .block {\n    max-width: 50%;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify * {\n    text-align: initial;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.standard tbody tr td {\n    font-size: 1.6vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 2.4vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead th {\n    font-size: 2vw;\n  }\n  .document > .content > .dynamic-content ::ng-deep .input textarea {\n    font-size: 2.4vw;\n  }\n  .document > .content > .static-content .page .fields .field {\n    font-size: 1.6vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render {\n    border-radius: 0.5vw;\n    padding: 0.5vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .hash,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .hash {\n    top: calc(100% + 2vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .timestamp,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 3vw);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 0.7vw;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > label,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > label {\n    font-size: 0.7vw;\n  }\n}\n@media only screen and (min-width: 1201px) and (hover: hover) and (pointer: fine) {\n  .document > .content {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content {\n    padding: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .logo {\n    width: 250px;\n  }\n  .document > .content > .dynamic-content ::ng-deep h2 {\n    font-size: 36px;\n  }\n  .document > .content > .dynamic-content ::ng-deep h3 {\n    font-size: 28px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-small * {\n    font-size: 20px !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium {\n    font-size: 32px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-medium * {\n    font-size: 32px !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large {\n    font-size: 40px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .font-large * {\n    font-size: 40px !important;\n  }\n  .document > .content > .dynamic-content ::ng-deep .note {\n    font-size: 26px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > label {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .customer-note > .value {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > h2 {\n    font-size: 36px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h3 {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-diagrams > .diagrams > .inspection-diagram > h4 {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h3 {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .inspection-photos > h4 {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .hash,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render .timestamp,\n  .document > .content > .dynamic-content ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 12px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > label,\n  .document > .content > .dynamic-content ::ng-deep .initials > label {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .signature > .render {\n    width: 260px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .initials > .render {\n    width: 150px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify > .block {\n    max-width: 50%;\n  }\n  .document > .content > .dynamic-content ::ng-deep .align-justify * {\n    text-align: initial;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.standard tbody tr td {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .parent {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.type > td > .entity {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .name {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td .attribute > .value {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.entity-details > tbody > tr.details > td > .fixtures > .fixture > .name {\n    font-size: 20px;\n  }\n  .document > .content > .dynamic-content ::ng-deep table.additional-considerations > thead th {\n    font-size: 24px;\n  }\n  .document > .content > .dynamic-content ::ng-deep .input textarea {\n    font-size: 32px;\n  }\n  .document > .content > .static-content .page .fields .field {\n    font-size: 24px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render {\n    border-radius: 8px;\n    padding: 8px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .hash,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .hash {\n    top: calc(100% + 26px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > .render .timestamp,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > .render .timestamp {\n    top: calc(100% + 36px);\n    left: auto;\n    right: 0;\n    bottom: auto;\n    font-size: 10px;\n  }\n  .document > .content > .static-content .page .fields .field ::ng-deep .signature > label,\n  .document > .content > .static-content .page .fields .field ::ng-deep .initials > label {\n    font-size: 10px;\n  }\n}\n/*# sourceMappingURL=opportunity-document.component.css.map */\n'] }]
  }], () => [{ type: UiService }, { type: OpportunityService }, { type: DocumentService }, { type: ContentService }, { type: AuthRefService }, { type: CurrencyPipe }, { type: LogService }, { type: OrderByPipe }, { type: DomSanitizer }], { opportunity: [{
    type: Input
  }], content: [{
    type: Input
  }], viewerElm: [{
    type: ViewChild,
    args: ["viewerElm"]
  }], staticElm: [{
    type: ViewChild,
    args: ["staticElm"]
  }], execute: [{
    type: Input,
    args: ["execute"]
  }], rendered$: [{
    type: Output,
    args: ["rendered"]
  }], document: [{
    type: Input,
    args: ["document"]
  }], signer: [{
    type: Input,
    args: ["signer"]
  }], signing: [{
    type: Input,
    args: ["signing"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], changed$: [{
    type: Output,
    args: ["changed"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunityDocumentComponent, { className: "OpportunityDocumentComponent" });
})();

// src/app/shared/documents/documents.module.ts
var _SharedDocumentsModule = class _SharedDocumentsModule {
};
_SharedDocumentsModule.\u0275fac = function SharedDocumentsModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SharedDocumentsModule)();
};
_SharedDocumentsModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _SharedDocumentsModule });
_SharedDocumentsModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [
  CommonModule,
  RouterModule,
  UiModule,
  ReactiveFormsModule,
  FormsModule
] });
var SharedDocumentsModule = _SharedDocumentsModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SharedDocumentsModule, [{
    type: NgModule,
    args: [{
      declarations: [
        SignaturePadComponent,
        InitialPadComponent,
        ConsentComponent,
        AppointmentDocumentComponent,
        OpportunityDocumentComponent
      ],
      imports: [
        CommonModule,
        RouterModule,
        UiModule,
        ReactiveFormsModule,
        FormsModule
      ],
      /* Do not put any services in the Shared Module which need to share an instance across multiple modules
          Those should go in the app.module instead */
      providers: [],
      exports: [
        SignaturePadComponent,
        AppointmentDocumentComponent,
        OpportunityDocumentComponent,
        ConsentComponent,
        InitialPadComponent
      ],
      schemas: [CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

export {
  DocumentService,
  OpportunityDocumentComponent,
  ConsentComponent,
  SignaturePadComponent,
  InitialPadComponent,
  AppointmentDocumentComponent,
  SharedDocumentsModule
};
/*! Bundled license information:

signature_pad/dist/signature_pad.js:
  (*!
   * Signature Pad v5.0.4 | https://github.com/szimek/signature_pad
   * (c) 2024 Szymon Nowak | Released under the MIT license
   *)
*/
//# sourceMappingURL=chunk-NS3ZOTKG.js.map
