import {
  SortOption
} from "./chunk-HY3MWTYR.js";
import {
  AiService
} from "./chunk-ACY4QHGY.js";
import {
  GeneralResponseState,
  LenderApplicationStatus,
  OpportunitySummaryComponent,
  PaymentsService,
  SharedOpportunityModule
} from "./chunk-NFWTEPRF.js";
import {
  require_leaflet_src
} from "./chunk-ZIGK756M.js";
import {
  AppointmentUiService
} from "./chunk-VXFTO3NJ.js";
import {
  OpportunityUiService
} from "./chunk-MKT5ZNAF.js";
import {
  DeviceRouteService,
  ReminderPriority,
  ReminderReferenceType,
  ReminderService,
  ReminderStatus
} from "./chunk-ZEKYPX2O.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  AppService
} from "./chunk-I3C723JV.js";
import {
  AppointmentService
} from "./chunk-YTSB4N6U.js";
import {
  AppointmentDocumentComponent,
  ConsentComponent,
  DocumentService,
  SharedDocumentsModule
} from "./chunk-NS3ZOTKG.js";
import {
  ContactInformationType
} from "./chunk-HJJU6GQE.js";
import "./chunk-CEWZNQA5.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  LogService,
  OpportunityService
} from "./chunk-TJ5F7MJ2.js";
import {
  ContentService,
  Filesystem,
  Share
} from "./chunk-QKEQQVYW.js";
import {
  Directory
} from "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import "./chunk-IVJ6NEFT.js";
import {
  ApiService
} from "./chunk-EBH7MLJT.js";
import {
  AuthRefService,
  OpportunityStatus,
  StorageService
} from "./chunk-M3LFBN7N.js";
import {
  Appointment,
  AppointmentStatus,
  DocumentSigner,
  DocumentSignerType,
  PaymentMethodType,
  deepClone,
  getDateOnly,
  safeEquivalentPrice,
  safePrice
} from "./chunk-N36JE2BE.js";
import {
  environment
} from "./chunk-VWQQS2KV.js";
import {
  AsyncPipe,
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  ChangeDetectorRef,
  CommonModule,
  Component,
  CurrencyInputComponent,
  CurrencyPipe,
  DatePipe,
  DefaultValueAccessor,
  DomSanitizer,
  FormsModule,
  HttpClient,
  Injectable,
  Injector,
  Input,
  LoaderComponent,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  Observable,
  OrderByPipe,
  Output,
  PhoneFormatPipe,
  PhoneInputComponent,
  QueryList,
  ReactiveFormsModule,
  RouterModule,
  SelectControlValueAccessor,
  Subject,
  UiModule,
  ViewChild,
  ViewChildren,
  parsePhoneNumber,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵattribute,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵpipeBind2,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeUrl,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtextInterpolate2,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import {
  Capacitor
} from "./chunk-IT26RCSL.js";
import {
  __async,
  __spreadProps,
  __spreadValues,
  __toESM
} from "./chunk-RVA4KI76.js";

// src/app/dashboard/models/navigation.ts
var DashboardRouteType;
(function(DashboardRouteType2) {
  DashboardRouteType2["today"] = "today";
  DashboardRouteType2["team"] = "team";
})(DashboardRouteType || (DashboardRouteType = {}));

// src/app/dashboard/services/dashboard.service.ts
var _DashboardService = class _DashboardService {
  constructor(http, opportunityService, routeService) {
    this.http = http;
    this.opportunityService = opportunityService;
    this.routeService = routeService;
    this.routesInitialized = false;
  }
  initRoutes(initialRouteType = void 0, componentElm) {
    setTimeout(() => {
      if (componentElm != null) {
        const routes = {
          [DashboardRouteType.today]: new InternalRoute(DashboardRouteType.today),
          [DashboardRouteType.team]: new InternalRoute(DashboardRouteType.team)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : DashboardRouteType.today;
        this.routeService.init(routes, initialRoute, 250, componentElm);
        this.routesInitialized = true;
      }
    }, 0);
  }
  // #endregion
  // #region Reporting
  getClosestMonday() {
    const today = /* @__PURE__ */ new Date();
    const dayOfWeek = today.getDay();
    if (dayOfWeek === 1) {
      return new Date(today.getFullYear(), today.getMonth(), today.getDate(), 0, 0, 0, 0);
    }
    const daysToMonday = dayOfWeek === 0 ? 6 : dayOfWeek - 1;
    const closestMonday = new Date(today);
    closestMonday.setDate(today.getDate() - daysToMonday);
    closestMonday.setHours(0, 0, 0, 0);
    return closestMonday;
  }
  getClosestSunday() {
    const today = /* @__PURE__ */ new Date();
    const dayOfWeek = today.getDay();
    if (dayOfWeek === 0) {
      return new Date(today.getFullYear(), today.getMonth(), today.getDate(), 23, 59, 0, 0);
    }
    const daysToSunday = 7 - dayOfWeek;
    const closestSunday = new Date(today);
    closestSunday.setDate(today.getDate() + daysToSunday);
    closestSunday.setHours(23, 59, 0, 0);
    return closestSunday;
  }
  calcClosePercentage(user) {
    return new Promise((res, rej) => {
      const closestStartDay = this.getClosestMonday();
      const startDayYear = closestStartDay.getFullYear();
      const startDayMonth = closestStartDay.getMonth() + 1;
      let closestStartDayMonthStr = `${startDayMonth}`;
      if (startDayMonth < 10) {
        closestStartDayMonthStr = `0${startDayMonth}`;
      }
      const startDayDate = closestStartDay.getDate();
      let closestStartDayDateStr = `${startDayDate}`;
      if (startDayDate < 10) {
        closestStartDayDateStr = `0${startDayDate}`;
      }
      const startDayStr = `${startDayYear}-${closestStartDayMonthStr}-${closestStartDayDateStr}`;
      const closestEndDay = this.getClosestSunday();
      const endDayYear = closestEndDay.getFullYear();
      const endDayMonth = closestEndDay.getMonth() + 1;
      let closestEndDayMonthStr = `${endDayMonth}`;
      if (endDayMonth < 10) {
        closestEndDayMonthStr = `0${endDayMonth}`;
      }
      const endDayDate = closestEndDay.getDate();
      let closestEndDayDateStr = `${endDayDate}`;
      if (endDayDate < 10) {
        closestEndDayDateStr = `0${endDayDate}`;
      }
      const endDayStr = `${endDayYear}-${closestEndDayMonthStr}-${closestEndDayDateStr}`;
      let totalAppointmentsForWeek = 0;
      let totalClosedAppointments = 0;
      this.opportunityService.getOpportunitiesForDateRange(startDayStr, endDayStr, user.id).subscribe({
        next: (opportunities) => {
          for (var i = 0, len = opportunities.length; i < len; i++) {
            const opportunity = opportunities[i];
            if (opportunity.scheduled_Utc != null && opportunity.scheduled_Utc >= closestStartDay && opportunity.scheduled_Utc <= closestEndDay) {
              totalAppointmentsForWeek = totalAppointmentsForWeek + 1;
              if (opportunity.status == OpportunityStatus.PendingSubmission || opportunity.status == OpportunityStatus.Submitted) {
                totalClosedAppointments = totalClosedAppointments + 1;
              }
            }
          }
          if (totalAppointmentsForWeek > 0) {
            const closePercentage = Math.round(totalClosedAppointments / totalAppointmentsForWeek * 100);
            res(closePercentage);
          } else {
            res(0);
          }
        }
      });
    });
  }
  // #endregion
  // #region Reminders
  // {{api}}/reminders/latest 
  // {{api}}/reminders/store
  getReminders() {
    return new Observable((o) => {
    });
  }
};
_DashboardService.\u0275fac = function DashboardService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DashboardService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(OpportunityService), \u0275\u0275inject(InternalRouteService));
};
_DashboardService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _DashboardService, factory: _DashboardService.\u0275fac, providedIn: "root" });
var DashboardService = _DashboardService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DashboardService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }, { type: OpportunityService }, { type: InternalRouteService }], null);
})();

// node_modules/.pnpm/@kurkle+color@0.3.2/node_modules/@kurkle/color/dist/color.esm.js
function round(v) {
  return v + 0.5 | 0;
}
var lim = (v, l, h) => Math.max(Math.min(v, h), l);
function p2b(v) {
  return lim(round(v * 2.55), 0, 255);
}
function n2b(v) {
  return lim(round(v * 255), 0, 255);
}
function b2n(v) {
  return lim(round(v / 2.55) / 100, 0, 1);
}
function n2p(v) {
  return lim(round(v * 100), 0, 100);
}
var map$1 = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, A: 10, B: 11, C: 12, D: 13, E: 14, F: 15, a: 10, b: 11, c: 12, d: 13, e: 14, f: 15 };
var hex = [..."0123456789ABCDEF"];
var h1 = (b) => hex[b & 15];
var h2 = (b) => hex[(b & 240) >> 4] + hex[b & 15];
var eq = (b) => (b & 240) >> 4 === (b & 15);
var isShort = (v) => eq(v.r) && eq(v.g) && eq(v.b) && eq(v.a);
function hexParse(str) {
  var len = str.length;
  var ret;
  if (str[0] === "#") {
    if (len === 4 || len === 5) {
      ret = {
        r: 255 & map$1[str[1]] * 17,
        g: 255 & map$1[str[2]] * 17,
        b: 255 & map$1[str[3]] * 17,
        a: len === 5 ? map$1[str[4]] * 17 : 255
      };
    } else if (len === 7 || len === 9) {
      ret = {
        r: map$1[str[1]] << 4 | map$1[str[2]],
        g: map$1[str[3]] << 4 | map$1[str[4]],
        b: map$1[str[5]] << 4 | map$1[str[6]],
        a: len === 9 ? map$1[str[7]] << 4 | map$1[str[8]] : 255
      };
    }
  }
  return ret;
}
var alpha = (a, f) => a < 255 ? f(a) : "";
function hexString(v) {
  var f = isShort(v) ? h1 : h2;
  return v ? "#" + f(v.r) + f(v.g) + f(v.b) + alpha(v.a, f) : void 0;
}
var HUE_RE = /^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;
function hsl2rgbn(h, s, l) {
  const a = s * Math.min(l, 1 - l);
  const f = (n, k = (n + h / 30) % 12) => l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);
  return [f(0), f(8), f(4)];
}
function hsv2rgbn(h, s, v) {
  const f = (n, k = (n + h / 60) % 6) => v - v * s * Math.max(Math.min(k, 4 - k, 1), 0);
  return [f(5), f(3), f(1)];
}
function hwb2rgbn(h, w, b) {
  const rgb = hsl2rgbn(h, 1, 0.5);
  let i;
  if (w + b > 1) {
    i = 1 / (w + b);
    w *= i;
    b *= i;
  }
  for (i = 0; i < 3; i++) {
    rgb[i] *= 1 - w - b;
    rgb[i] += w;
  }
  return rgb;
}
function hueValue(r, g, b, d, max) {
  if (r === max) {
    return (g - b) / d + (g < b ? 6 : 0);
  }
  if (g === max) {
    return (b - r) / d + 2;
  }
  return (r - g) / d + 4;
}
function rgb2hsl(v) {
  const range = 255;
  const r = v.r / range;
  const g = v.g / range;
  const b = v.b / range;
  const max = Math.max(r, g, b);
  const min = Math.min(r, g, b);
  const l = (max + min) / 2;
  let h, s, d;
  if (max !== min) {
    d = max - min;
    s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
    h = hueValue(r, g, b, d, max);
    h = h * 60 + 0.5;
  }
  return [h | 0, s || 0, l];
}
function calln(f, a, b, c) {
  return (Array.isArray(a) ? f(a[0], a[1], a[2]) : f(a, b, c)).map(n2b);
}
function hsl2rgb(h, s, l) {
  return calln(hsl2rgbn, h, s, l);
}
function hwb2rgb(h, w, b) {
  return calln(hwb2rgbn, h, w, b);
}
function hsv2rgb(h, s, v) {
  return calln(hsv2rgbn, h, s, v);
}
function hue(h) {
  return (h % 360 + 360) % 360;
}
function hueParse(str) {
  const m = HUE_RE.exec(str);
  let a = 255;
  let v;
  if (!m) {
    return;
  }
  if (m[5] !== v) {
    a = m[6] ? p2b(+m[5]) : n2b(+m[5]);
  }
  const h = hue(+m[2]);
  const p1 = +m[3] / 100;
  const p2 = +m[4] / 100;
  if (m[1] === "hwb") {
    v = hwb2rgb(h, p1, p2);
  } else if (m[1] === "hsv") {
    v = hsv2rgb(h, p1, p2);
  } else {
    v = hsl2rgb(h, p1, p2);
  }
  return {
    r: v[0],
    g: v[1],
    b: v[2],
    a
  };
}
function rotate(v, deg) {
  var h = rgb2hsl(v);
  h[0] = hue(h[0] + deg);
  h = hsl2rgb(h);
  v.r = h[0];
  v.g = h[1];
  v.b = h[2];
}
function hslString(v) {
  if (!v) {
    return;
  }
  const a = rgb2hsl(v);
  const h = a[0];
  const s = n2p(a[1]);
  const l = n2p(a[2]);
  return v.a < 255 ? `hsla(${h}, ${s}%, ${l}%, ${b2n(v.a)})` : `hsl(${h}, ${s}%, ${l}%)`;
}
var map = {
  x: "dark",
  Z: "light",
  Y: "re",
  X: "blu",
  W: "gr",
  V: "medium",
  U: "slate",
  A: "ee",
  T: "ol",
  S: "or",
  B: "ra",
  C: "lateg",
  D: "ights",
  R: "in",
  Q: "turquois",
  E: "hi",
  P: "ro",
  O: "al",
  N: "le",
  M: "de",
  L: "yello",
  F: "en",
  K: "ch",
  G: "arks",
  H: "ea",
  I: "ightg",
  J: "wh"
};
var names$1 = {
  OiceXe: "f0f8ff",
  antiquewEte: "faebd7",
  aqua: "ffff",
  aquamarRe: "7fffd4",
  azuY: "f0ffff",
  beige: "f5f5dc",
  bisque: "ffe4c4",
  black: "0",
  blanKedOmond: "ffebcd",
  Xe: "ff",
  XeviTet: "8a2be2",
  bPwn: "a52a2a",
  burlywood: "deb887",
  caMtXe: "5f9ea0",
  KartYuse: "7fff00",
  KocTate: "d2691e",
  cSO: "ff7f50",
  cSnflowerXe: "6495ed",
  cSnsilk: "fff8dc",
  crimson: "dc143c",
  cyan: "ffff",
  xXe: "8b",
  xcyan: "8b8b",
  xgTMnPd: "b8860b",
  xWay: "a9a9a9",
  xgYF: "6400",
  xgYy: "a9a9a9",
  xkhaki: "bdb76b",
  xmagFta: "8b008b",
  xTivegYF: "556b2f",
  xSange: "ff8c00",
  xScEd: "9932cc",
  xYd: "8b0000",
  xsOmon: "e9967a",
  xsHgYF: "8fbc8f",
  xUXe: "483d8b",
  xUWay: "2f4f4f",
  xUgYy: "2f4f4f",
  xQe: "ced1",
  xviTet: "9400d3",
  dAppRk: "ff1493",
  dApskyXe: "bfff",
  dimWay: "696969",
  dimgYy: "696969",
  dodgerXe: "1e90ff",
  fiYbrick: "b22222",
  flSOwEte: "fffaf0",
  foYstWAn: "228b22",
  fuKsia: "ff00ff",
  gaRsbSo: "dcdcdc",
  ghostwEte: "f8f8ff",
  gTd: "ffd700",
  gTMnPd: "daa520",
  Way: "808080",
  gYF: "8000",
  gYFLw: "adff2f",
  gYy: "808080",
  honeyMw: "f0fff0",
  hotpRk: "ff69b4",
  RdianYd: "cd5c5c",
  Rdigo: "4b0082",
  ivSy: "fffff0",
  khaki: "f0e68c",
  lavFMr: "e6e6fa",
  lavFMrXsh: "fff0f5",
  lawngYF: "7cfc00",
  NmoncEffon: "fffacd",
  ZXe: "add8e6",
  ZcSO: "f08080",
  Zcyan: "e0ffff",
  ZgTMnPdLw: "fafad2",
  ZWay: "d3d3d3",
  ZgYF: "90ee90",
  ZgYy: "d3d3d3",
  ZpRk: "ffb6c1",
  ZsOmon: "ffa07a",
  ZsHgYF: "20b2aa",
  ZskyXe: "87cefa",
  ZUWay: "778899",
  ZUgYy: "778899",
  ZstAlXe: "b0c4de",
  ZLw: "ffffe0",
  lime: "ff00",
  limegYF: "32cd32",
  lRF: "faf0e6",
  magFta: "ff00ff",
  maPon: "800000",
  VaquamarRe: "66cdaa",
  VXe: "cd",
  VScEd: "ba55d3",
  VpurpN: "9370db",
  VsHgYF: "3cb371",
  VUXe: "7b68ee",
  VsprRggYF: "fa9a",
  VQe: "48d1cc",
  VviTetYd: "c71585",
  midnightXe: "191970",
  mRtcYam: "f5fffa",
  mistyPse: "ffe4e1",
  moccasR: "ffe4b5",
  navajowEte: "ffdead",
  navy: "80",
  Tdlace: "fdf5e6",
  Tive: "808000",
  TivedBb: "6b8e23",
  Sange: "ffa500",
  SangeYd: "ff4500",
  ScEd: "da70d6",
  pOegTMnPd: "eee8aa",
  pOegYF: "98fb98",
  pOeQe: "afeeee",
  pOeviTetYd: "db7093",
  papayawEp: "ffefd5",
  pHKpuff: "ffdab9",
  peru: "cd853f",
  pRk: "ffc0cb",
  plum: "dda0dd",
  powMrXe: "b0e0e6",
  purpN: "800080",
  YbeccapurpN: "663399",
  Yd: "ff0000",
  Psybrown: "bc8f8f",
  PyOXe: "4169e1",
  saddNbPwn: "8b4513",
  sOmon: "fa8072",
  sandybPwn: "f4a460",
  sHgYF: "2e8b57",
  sHshell: "fff5ee",
  siFna: "a0522d",
  silver: "c0c0c0",
  skyXe: "87ceeb",
  UXe: "6a5acd",
  UWay: "708090",
  UgYy: "708090",
  snow: "fffafa",
  sprRggYF: "ff7f",
  stAlXe: "4682b4",
  tan: "d2b48c",
  teO: "8080",
  tEstN: "d8bfd8",
  tomato: "ff6347",
  Qe: "40e0d0",
  viTet: "ee82ee",
  JHt: "f5deb3",
  wEte: "ffffff",
  wEtesmoke: "f5f5f5",
  Lw: "ffff00",
  LwgYF: "9acd32"
};
function unpack() {
  const unpacked = {};
  const keys = Object.keys(names$1);
  const tkeys = Object.keys(map);
  let i, j, k, ok, nk;
  for (i = 0; i < keys.length; i++) {
    ok = nk = keys[i];
    for (j = 0; j < tkeys.length; j++) {
      k = tkeys[j];
      nk = nk.replace(k, map[k]);
    }
    k = parseInt(names$1[ok], 16);
    unpacked[nk] = [k >> 16 & 255, k >> 8 & 255, k & 255];
  }
  return unpacked;
}
var names;
function nameParse(str) {
  if (!names) {
    names = unpack();
    names.transparent = [0, 0, 0, 0];
  }
  const a = names[str.toLowerCase()];
  return a && {
    r: a[0],
    g: a[1],
    b: a[2],
    a: a.length === 4 ? a[3] : 255
  };
}
var RGB_RE = /^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/;
function rgbParse(str) {
  const m = RGB_RE.exec(str);
  let a = 255;
  let r, g, b;
  if (!m) {
    return;
  }
  if (m[7] !== r) {
    const v = +m[7];
    a = m[8] ? p2b(v) : lim(v * 255, 0, 255);
  }
  r = +m[1];
  g = +m[3];
  b = +m[5];
  r = 255 & (m[2] ? p2b(r) : lim(r, 0, 255));
  g = 255 & (m[4] ? p2b(g) : lim(g, 0, 255));
  b = 255 & (m[6] ? p2b(b) : lim(b, 0, 255));
  return {
    r,
    g,
    b,
    a
  };
}
function rgbString(v) {
  return v && (v.a < 255 ? `rgba(${v.r}, ${v.g}, ${v.b}, ${b2n(v.a)})` : `rgb(${v.r}, ${v.g}, ${v.b})`);
}
var to = (v) => v <= 31308e-7 ? v * 12.92 : Math.pow(v, 1 / 2.4) * 1.055 - 0.055;
var from = (v) => v <= 0.04045 ? v / 12.92 : Math.pow((v + 0.055) / 1.055, 2.4);
function interpolate(rgb1, rgb2, t) {
  const r = from(b2n(rgb1.r));
  const g = from(b2n(rgb1.g));
  const b = from(b2n(rgb1.b));
  return {
    r: n2b(to(r + t * (from(b2n(rgb2.r)) - r))),
    g: n2b(to(g + t * (from(b2n(rgb2.g)) - g))),
    b: n2b(to(b + t * (from(b2n(rgb2.b)) - b))),
    a: rgb1.a + t * (rgb2.a - rgb1.a)
  };
}
function modHSL(v, i, ratio) {
  if (v) {
    let tmp = rgb2hsl(v);
    tmp[i] = Math.max(0, Math.min(tmp[i] + tmp[i] * ratio, i === 0 ? 360 : 1));
    tmp = hsl2rgb(tmp);
    v.r = tmp[0];
    v.g = tmp[1];
    v.b = tmp[2];
  }
}
function clone(v, proto) {
  return v ? Object.assign(proto || {}, v) : v;
}
function fromObject(input) {
  var v = { r: 0, g: 0, b: 0, a: 255 };
  if (Array.isArray(input)) {
    if (input.length >= 3) {
      v = { r: input[0], g: input[1], b: input[2], a: 255 };
      if (input.length > 3) {
        v.a = n2b(input[3]);
      }
    }
  } else {
    v = clone(input, { r: 0, g: 0, b: 0, a: 1 });
    v.a = n2b(v.a);
  }
  return v;
}
function functionParse(str) {
  if (str.charAt(0) === "r") {
    return rgbParse(str);
  }
  return hueParse(str);
}
var Color = class _Color {
  constructor(input) {
    if (input instanceof _Color) {
      return input;
    }
    const type = typeof input;
    let v;
    if (type === "object") {
      v = fromObject(input);
    } else if (type === "string") {
      v = hexParse(input) || nameParse(input) || functionParse(input);
    }
    this._rgb = v;
    this._valid = !!v;
  }
  get valid() {
    return this._valid;
  }
  get rgb() {
    var v = clone(this._rgb);
    if (v) {
      v.a = b2n(v.a);
    }
    return v;
  }
  set rgb(obj) {
    this._rgb = fromObject(obj);
  }
  rgbString() {
    return this._valid ? rgbString(this._rgb) : void 0;
  }
  hexString() {
    return this._valid ? hexString(this._rgb) : void 0;
  }
  hslString() {
    return this._valid ? hslString(this._rgb) : void 0;
  }
  mix(color2, weight) {
    if (color2) {
      const c1 = this.rgb;
      const c2 = color2.rgb;
      let w2;
      const p = weight === w2 ? 0.5 : weight;
      const w = 2 * p - 1;
      const a = c1.a - c2.a;
      const w1 = ((w * a === -1 ? w : (w + a) / (1 + w * a)) + 1) / 2;
      w2 = 1 - w1;
      c1.r = 255 & w1 * c1.r + w2 * c2.r + 0.5;
      c1.g = 255 & w1 * c1.g + w2 * c2.g + 0.5;
      c1.b = 255 & w1 * c1.b + w2 * c2.b + 0.5;
      c1.a = p * c1.a + (1 - p) * c2.a;
      this.rgb = c1;
    }
    return this;
  }
  interpolate(color2, t) {
    if (color2) {
      this._rgb = interpolate(this._rgb, color2._rgb, t);
    }
    return this;
  }
  clone() {
    return new _Color(this.rgb);
  }
  alpha(a) {
    this._rgb.a = n2b(a);
    return this;
  }
  clearer(ratio) {
    const rgb = this._rgb;
    rgb.a *= 1 - ratio;
    return this;
  }
  greyscale() {
    const rgb = this._rgb;
    const val = round(rgb.r * 0.3 + rgb.g * 0.59 + rgb.b * 0.11);
    rgb.r = rgb.g = rgb.b = val;
    return this;
  }
  opaquer(ratio) {
    const rgb = this._rgb;
    rgb.a *= 1 + ratio;
    return this;
  }
  negate() {
    const v = this._rgb;
    v.r = 255 - v.r;
    v.g = 255 - v.g;
    v.b = 255 - v.b;
    return this;
  }
  lighten(ratio) {
    modHSL(this._rgb, 2, ratio);
    return this;
  }
  darken(ratio) {
    modHSL(this._rgb, 2, -ratio);
    return this;
  }
  saturate(ratio) {
    modHSL(this._rgb, 1, ratio);
    return this;
  }
  desaturate(ratio) {
    modHSL(this._rgb, 1, -ratio);
    return this;
  }
  rotate(deg) {
    rotate(this._rgb, deg);
    return this;
  }
};

// node_modules/.pnpm/chart.js@4.4.6/node_modules/chart.js/dist/chunks/helpers.segment.js
function noop() {
}
var uid = /* @__PURE__ */ (() => {
  let id = 0;
  return () => id++;
})();
function isNullOrUndef(value) {
  return value === null || typeof value === "undefined";
}
function isArray(value) {
  if (Array.isArray && Array.isArray(value)) {
    return true;
  }
  const type = Object.prototype.toString.call(value);
  if (type.slice(0, 7) === "[object" && type.slice(-6) === "Array]") {
    return true;
  }
  return false;
}
function isObject(value) {
  return value !== null && Object.prototype.toString.call(value) === "[object Object]";
}
function isNumberFinite(value) {
  return (typeof value === "number" || value instanceof Number) && isFinite(+value);
}
function finiteOrDefault(value, defaultValue) {
  return isNumberFinite(value) ? value : defaultValue;
}
function valueOrDefault(value, defaultValue) {
  return typeof value === "undefined" ? defaultValue : value;
}
var toDimension = (value, dimension) => typeof value === "string" && value.endsWith("%") ? parseFloat(value) / 100 * dimension : +value;
function callback(fn, args, thisArg) {
  if (fn && typeof fn.call === "function") {
    return fn.apply(thisArg, args);
  }
}
function each(loopable, fn, thisArg, reverse) {
  let i, len, keys;
  if (isArray(loopable)) {
    len = loopable.length;
    if (reverse) {
      for (i = len - 1; i >= 0; i--) {
        fn.call(thisArg, loopable[i], i);
      }
    } else {
      for (i = 0; i < len; i++) {
        fn.call(thisArg, loopable[i], i);
      }
    }
  } else if (isObject(loopable)) {
    keys = Object.keys(loopable);
    len = keys.length;
    for (i = 0; i < len; i++) {
      fn.call(thisArg, loopable[keys[i]], keys[i]);
    }
  }
}
function _elementsEqual(a0, a1) {
  let i, ilen, v0, v1;
  if (!a0 || !a1 || a0.length !== a1.length) {
    return false;
  }
  for (i = 0, ilen = a0.length; i < ilen; ++i) {
    v0 = a0[i];
    v1 = a1[i];
    if (v0.datasetIndex !== v1.datasetIndex || v0.index !== v1.index) {
      return false;
    }
  }
  return true;
}
function clone2(source) {
  if (isArray(source)) {
    return source.map(clone2);
  }
  if (isObject(source)) {
    const target = /* @__PURE__ */ Object.create(null);
    const keys = Object.keys(source);
    const klen = keys.length;
    let k = 0;
    for (; k < klen; ++k) {
      target[keys[k]] = clone2(source[keys[k]]);
    }
    return target;
  }
  return source;
}
function isValidKey(key) {
  return [
    "__proto__",
    "prototype",
    "constructor"
  ].indexOf(key) === -1;
}
function _merger(key, target, source, options) {
  if (!isValidKey(key)) {
    return;
  }
  const tval = target[key];
  const sval = source[key];
  if (isObject(tval) && isObject(sval)) {
    merge(tval, sval, options);
  } else {
    target[key] = clone2(sval);
  }
}
function merge(target, source, options) {
  const sources = isArray(source) ? source : [
    source
  ];
  const ilen = sources.length;
  if (!isObject(target)) {
    return target;
  }
  options = options || {};
  const merger = options.merger || _merger;
  let current;
  for (let i = 0; i < ilen; ++i) {
    current = sources[i];
    if (!isObject(current)) {
      continue;
    }
    const keys = Object.keys(current);
    for (let k = 0, klen = keys.length; k < klen; ++k) {
      merger(keys[k], target, current, options);
    }
  }
  return target;
}
function mergeIf(target, source) {
  return merge(target, source, {
    merger: _mergerIf
  });
}
function _mergerIf(key, target, source) {
  if (!isValidKey(key)) {
    return;
  }
  const tval = target[key];
  const sval = source[key];
  if (isObject(tval) && isObject(sval)) {
    mergeIf(tval, sval);
  } else if (!Object.prototype.hasOwnProperty.call(target, key)) {
    target[key] = clone2(sval);
  }
}
var keyResolvers = {
  // Chart.helpers.core resolveObjectKey should resolve empty key to root object
  "": (v) => v,
  // default resolvers
  x: (o) => o.x,
  y: (o) => o.y
};
function _splitKey(key) {
  const parts = key.split(".");
  const keys = [];
  let tmp = "";
  for (const part of parts) {
    tmp += part;
    if (tmp.endsWith("\\")) {
      tmp = tmp.slice(0, -1) + ".";
    } else {
      keys.push(tmp);
      tmp = "";
    }
  }
  return keys;
}
function _getKeyResolver(key) {
  const keys = _splitKey(key);
  return (obj) => {
    for (const k of keys) {
      if (k === "") {
        break;
      }
      obj = obj && obj[k];
    }
    return obj;
  };
}
function resolveObjectKey(obj, key) {
  const resolver = keyResolvers[key] || (keyResolvers[key] = _getKeyResolver(key));
  return resolver(obj);
}
function _capitalize(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}
var defined = (value) => typeof value !== "undefined";
var isFunction = (value) => typeof value === "function";
var setsEqual = (a, b) => {
  if (a.size !== b.size) {
    return false;
  }
  for (const item of a) {
    if (!b.has(item)) {
      return false;
    }
  }
  return true;
};
function _isClickEvent(e) {
  return e.type === "mouseup" || e.type === "click" || e.type === "contextmenu";
}
var PI = Math.PI;
var TAU = 2 * PI;
var PITAU = TAU + PI;
var INFINITY = Number.POSITIVE_INFINITY;
var RAD_PER_DEG = PI / 180;
var HALF_PI = PI / 2;
var QUARTER_PI = PI / 4;
var TWO_THIRDS_PI = PI * 2 / 3;
var log10 = Math.log10;
var sign = Math.sign;
function almostEquals(x, y, epsilon) {
  return Math.abs(x - y) < epsilon;
}
function niceNum(range) {
  const roundedRange = Math.round(range);
  range = almostEquals(range, roundedRange, range / 1e3) ? roundedRange : range;
  const niceRange = Math.pow(10, Math.floor(log10(range)));
  const fraction = range / niceRange;
  const niceFraction = fraction <= 1 ? 1 : fraction <= 2 ? 2 : fraction <= 5 ? 5 : 10;
  return niceFraction * niceRange;
}
function _factorize(value) {
  const result = [];
  const sqrt = Math.sqrt(value);
  let i;
  for (i = 1; i < sqrt; i++) {
    if (value % i === 0) {
      result.push(i);
      result.push(value / i);
    }
  }
  if (sqrt === (sqrt | 0)) {
    result.push(sqrt);
  }
  result.sort((a, b) => a - b).pop();
  return result;
}
function isNumber(n) {
  return !isNaN(parseFloat(n)) && isFinite(n);
}
function almostWhole(x, epsilon) {
  const rounded = Math.round(x);
  return rounded - epsilon <= x && rounded + epsilon >= x;
}
function _setMinAndMaxByKey(array, target, property) {
  let i, ilen, value;
  for (i = 0, ilen = array.length; i < ilen; i++) {
    value = array[i][property];
    if (!isNaN(value)) {
      target.min = Math.min(target.min, value);
      target.max = Math.max(target.max, value);
    }
  }
}
function toRadians(degrees) {
  return degrees * (PI / 180);
}
function toDegrees(radians) {
  return radians * (180 / PI);
}
function _decimalPlaces(x) {
  if (!isNumberFinite(x)) {
    return;
  }
  let e = 1;
  let p = 0;
  while (Math.round(x * e) / e !== x) {
    e *= 10;
    p++;
  }
  return p;
}
function getAngleFromPoint(centrePoint, anglePoint) {
  const distanceFromXCenter = anglePoint.x - centrePoint.x;
  const distanceFromYCenter = anglePoint.y - centrePoint.y;
  const radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);
  let angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);
  if (angle < -0.5 * PI) {
    angle += TAU;
  }
  return {
    angle,
    distance: radialDistanceFromCenter
  };
}
function distanceBetweenPoints(pt1, pt2) {
  return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));
}
function _angleDiff(a, b) {
  return (a - b + PITAU) % TAU - PI;
}
function _normalizeAngle(a) {
  return (a % TAU + TAU) % TAU;
}
function _angleBetween(angle, start, end, sameAngleIsFullCircle) {
  const a = _normalizeAngle(angle);
  const s = _normalizeAngle(start);
  const e = _normalizeAngle(end);
  const angleToStart = _normalizeAngle(s - a);
  const angleToEnd = _normalizeAngle(e - a);
  const startToAngle = _normalizeAngle(a - s);
  const endToAngle = _normalizeAngle(a - e);
  return a === s || a === e || sameAngleIsFullCircle && s === e || angleToStart > angleToEnd && startToAngle < endToAngle;
}
function _limitValue(value, min, max) {
  return Math.max(min, Math.min(max, value));
}
function _int16Range(value) {
  return _limitValue(value, -32768, 32767);
}
function _isBetween(value, start, end, epsilon = 1e-6) {
  return value >= Math.min(start, end) - epsilon && value <= Math.max(start, end) + epsilon;
}
function _lookup(table, value, cmp) {
  cmp = cmp || ((index2) => table[index2] < value);
  let hi = table.length - 1;
  let lo = 0;
  let mid;
  while (hi - lo > 1) {
    mid = lo + hi >> 1;
    if (cmp(mid)) {
      lo = mid;
    } else {
      hi = mid;
    }
  }
  return {
    lo,
    hi
  };
}
var _lookupByKey = (table, key, value, last) => _lookup(table, value, last ? (index2) => {
  const ti = table[index2][key];
  return ti < value || ti === value && table[index2 + 1][key] === value;
} : (index2) => table[index2][key] < value);
var _rlookupByKey = (table, key, value) => _lookup(table, value, (index2) => table[index2][key] >= value);
function _filterBetween(values, min, max) {
  let start = 0;
  let end = values.length;
  while (start < end && values[start] < min) {
    start++;
  }
  while (end > start && values[end - 1] > max) {
    end--;
  }
  return start > 0 || end < values.length ? values.slice(start, end) : values;
}
var arrayEvents = [
  "push",
  "pop",
  "shift",
  "splice",
  "unshift"
];
function listenArrayEvents(array, listener) {
  if (array._chartjs) {
    array._chartjs.listeners.push(listener);
    return;
  }
  Object.defineProperty(array, "_chartjs", {
    configurable: true,
    enumerable: false,
    value: {
      listeners: [
        listener
      ]
    }
  });
  arrayEvents.forEach((key) => {
    const method = "_onData" + _capitalize(key);
    const base = array[key];
    Object.defineProperty(array, key, {
      configurable: true,
      enumerable: false,
      value(...args) {
        const res = base.apply(this, args);
        array._chartjs.listeners.forEach((object) => {
          if (typeof object[method] === "function") {
            object[method](...args);
          }
        });
        return res;
      }
    });
  });
}
function unlistenArrayEvents(array, listener) {
  const stub = array._chartjs;
  if (!stub) {
    return;
  }
  const listeners = stub.listeners;
  const index2 = listeners.indexOf(listener);
  if (index2 !== -1) {
    listeners.splice(index2, 1);
  }
  if (listeners.length > 0) {
    return;
  }
  arrayEvents.forEach((key) => {
    delete array[key];
  });
  delete array._chartjs;
}
function _arrayUnique(items) {
  const set2 = new Set(items);
  if (set2.size === items.length) {
    return items;
  }
  return Array.from(set2);
}
var requestAnimFrame = (function() {
  if (typeof window === "undefined") {
    return function(callback2) {
      return callback2();
    };
  }
  return window.requestAnimationFrame;
})();
function throttled(fn, thisArg) {
  let argsToUse = [];
  let ticking = false;
  return function(...args) {
    argsToUse = args;
    if (!ticking) {
      ticking = true;
      requestAnimFrame.call(window, () => {
        ticking = false;
        fn.apply(thisArg, argsToUse);
      });
    }
  };
}
function debounce(fn, delay) {
  let timeout;
  return function(...args) {
    if (delay) {
      clearTimeout(timeout);
      timeout = setTimeout(fn, delay, args);
    } else {
      fn.apply(this, args);
    }
    return delay;
  };
}
var _toLeftRightCenter = (align) => align === "start" ? "left" : align === "end" ? "right" : "center";
var _alignStartEnd = (align, start, end) => align === "start" ? start : align === "end" ? end : (start + end) / 2;
function _getStartAndCountOfVisiblePoints(meta, points, animationsDisabled) {
  const pointCount = points.length;
  let start = 0;
  let count = pointCount;
  if (meta._sorted) {
    const { iScale, _parsed } = meta;
    const axis = iScale.axis;
    const { min, max, minDefined, maxDefined } = iScale.getUserBounds();
    if (minDefined) {
      start = _limitValue(Math.min(
        // @ts-expect-error Need to type _parsed
        _lookupByKey(_parsed, axis, min).lo,
        // @ts-expect-error Need to fix types on _lookupByKey
        animationsDisabled ? pointCount : _lookupByKey(points, axis, iScale.getPixelForValue(min)).lo
      ), 0, pointCount - 1);
    }
    if (maxDefined) {
      count = _limitValue(Math.max(
        // @ts-expect-error Need to type _parsed
        _lookupByKey(_parsed, iScale.axis, max, true).hi + 1,
        // @ts-expect-error Need to fix types on _lookupByKey
        animationsDisabled ? 0 : _lookupByKey(points, axis, iScale.getPixelForValue(max), true).hi + 1
      ), start, pointCount) - start;
    } else {
      count = pointCount - start;
    }
  }
  return {
    start,
    count
  };
}
function _scaleRangesChanged(meta) {
  const { xScale, yScale, _scaleRanges } = meta;
  const newRanges = {
    xmin: xScale.min,
    xmax: xScale.max,
    ymin: yScale.min,
    ymax: yScale.max
  };
  if (!_scaleRanges) {
    meta._scaleRanges = newRanges;
    return true;
  }
  const changed = _scaleRanges.xmin !== xScale.min || _scaleRanges.xmax !== xScale.max || _scaleRanges.ymin !== yScale.min || _scaleRanges.ymax !== yScale.max;
  Object.assign(_scaleRanges, newRanges);
  return changed;
}
var atEdge = (t) => t === 0 || t === 1;
var elasticIn = (t, s, p) => -(Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * TAU / p));
var elasticOut = (t, s, p) => Math.pow(2, -10 * t) * Math.sin((t - s) * TAU / p) + 1;
var effects = {
  linear: (t) => t,
  easeInQuad: (t) => t * t,
  easeOutQuad: (t) => -t * (t - 2),
  easeInOutQuad: (t) => (t /= 0.5) < 1 ? 0.5 * t * t : -0.5 * (--t * (t - 2) - 1),
  easeInCubic: (t) => t * t * t,
  easeOutCubic: (t) => (t -= 1) * t * t + 1,
  easeInOutCubic: (t) => (t /= 0.5) < 1 ? 0.5 * t * t * t : 0.5 * ((t -= 2) * t * t + 2),
  easeInQuart: (t) => t * t * t * t,
  easeOutQuart: (t) => -((t -= 1) * t * t * t - 1),
  easeInOutQuart: (t) => (t /= 0.5) < 1 ? 0.5 * t * t * t * t : -0.5 * ((t -= 2) * t * t * t - 2),
  easeInQuint: (t) => t * t * t * t * t,
  easeOutQuint: (t) => (t -= 1) * t * t * t * t + 1,
  easeInOutQuint: (t) => (t /= 0.5) < 1 ? 0.5 * t * t * t * t * t : 0.5 * ((t -= 2) * t * t * t * t + 2),
  easeInSine: (t) => -Math.cos(t * HALF_PI) + 1,
  easeOutSine: (t) => Math.sin(t * HALF_PI),
  easeInOutSine: (t) => -0.5 * (Math.cos(PI * t) - 1),
  easeInExpo: (t) => t === 0 ? 0 : Math.pow(2, 10 * (t - 1)),
  easeOutExpo: (t) => t === 1 ? 1 : -Math.pow(2, -10 * t) + 1,
  easeInOutExpo: (t) => atEdge(t) ? t : t < 0.5 ? 0.5 * Math.pow(2, 10 * (t * 2 - 1)) : 0.5 * (-Math.pow(2, -10 * (t * 2 - 1)) + 2),
  easeInCirc: (t) => t >= 1 ? t : -(Math.sqrt(1 - t * t) - 1),
  easeOutCirc: (t) => Math.sqrt(1 - (t -= 1) * t),
  easeInOutCirc: (t) => (t /= 0.5) < 1 ? -0.5 * (Math.sqrt(1 - t * t) - 1) : 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1),
  easeInElastic: (t) => atEdge(t) ? t : elasticIn(t, 0.075, 0.3),
  easeOutElastic: (t) => atEdge(t) ? t : elasticOut(t, 0.075, 0.3),
  easeInOutElastic(t) {
    const s = 0.1125;
    const p = 0.45;
    return atEdge(t) ? t : t < 0.5 ? 0.5 * elasticIn(t * 2, s, p) : 0.5 + 0.5 * elasticOut(t * 2 - 1, s, p);
  },
  easeInBack(t) {
    const s = 1.70158;
    return t * t * ((s + 1) * t - s);
  },
  easeOutBack(t) {
    const s = 1.70158;
    return (t -= 1) * t * ((s + 1) * t + s) + 1;
  },
  easeInOutBack(t) {
    let s = 1.70158;
    if ((t /= 0.5) < 1) {
      return 0.5 * (t * t * (((s *= 1.525) + 1) * t - s));
    }
    return 0.5 * ((t -= 2) * t * (((s *= 1.525) + 1) * t + s) + 2);
  },
  easeInBounce: (t) => 1 - effects.easeOutBounce(1 - t),
  easeOutBounce(t) {
    const m = 7.5625;
    const d = 2.75;
    if (t < 1 / d) {
      return m * t * t;
    }
    if (t < 2 / d) {
      return m * (t -= 1.5 / d) * t + 0.75;
    }
    if (t < 2.5 / d) {
      return m * (t -= 2.25 / d) * t + 0.9375;
    }
    return m * (t -= 2.625 / d) * t + 0.984375;
  },
  easeInOutBounce: (t) => t < 0.5 ? effects.easeInBounce(t * 2) * 0.5 : effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5
};
function isPatternOrGradient(value) {
  if (value && typeof value === "object") {
    const type = value.toString();
    return type === "[object CanvasPattern]" || type === "[object CanvasGradient]";
  }
  return false;
}
function color(value) {
  return isPatternOrGradient(value) ? value : new Color(value);
}
function getHoverColor(value) {
  return isPatternOrGradient(value) ? value : new Color(value).saturate(0.5).darken(0.1).hexString();
}
var numbers = [
  "x",
  "y",
  "borderWidth",
  "radius",
  "tension"
];
var colors = [
  "color",
  "borderColor",
  "backgroundColor"
];
function applyAnimationsDefaults(defaults2) {
  defaults2.set("animation", {
    delay: void 0,
    duration: 1e3,
    easing: "easeOutQuart",
    fn: void 0,
    from: void 0,
    loop: void 0,
    to: void 0,
    type: void 0
  });
  defaults2.describe("animation", {
    _fallback: false,
    _indexable: false,
    _scriptable: (name) => name !== "onProgress" && name !== "onComplete" && name !== "fn"
  });
  defaults2.set("animations", {
    colors: {
      type: "color",
      properties: colors
    },
    numbers: {
      type: "number",
      properties: numbers
    }
  });
  defaults2.describe("animations", {
    _fallback: "animation"
  });
  defaults2.set("transitions", {
    active: {
      animation: {
        duration: 400
      }
    },
    resize: {
      animation: {
        duration: 0
      }
    },
    show: {
      animations: {
        colors: {
          from: "transparent"
        },
        visible: {
          type: "boolean",
          duration: 0
        }
      }
    },
    hide: {
      animations: {
        colors: {
          to: "transparent"
        },
        visible: {
          type: "boolean",
          easing: "linear",
          fn: (v) => v | 0
        }
      }
    }
  });
}
function applyLayoutsDefaults(defaults2) {
  defaults2.set("layout", {
    autoPadding: true,
    padding: {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    }
  });
}
var intlCache = /* @__PURE__ */ new Map();
function getNumberFormat(locale, options) {
  options = options || {};
  const cacheKey = locale + JSON.stringify(options);
  let formatter = intlCache.get(cacheKey);
  if (!formatter) {
    formatter = new Intl.NumberFormat(locale, options);
    intlCache.set(cacheKey, formatter);
  }
  return formatter;
}
function formatNumber(num, locale, options) {
  return getNumberFormat(locale, options).format(num);
}
var formatters = {
  values(value) {
    return isArray(value) ? value : "" + value;
  },
  numeric(tickValue, index2, ticks) {
    if (tickValue === 0) {
      return "0";
    }
    const locale = this.chart.options.locale;
    let notation;
    let delta = tickValue;
    if (ticks.length > 1) {
      const maxTick = Math.max(Math.abs(ticks[0].value), Math.abs(ticks[ticks.length - 1].value));
      if (maxTick < 1e-4 || maxTick > 1e15) {
        notation = "scientific";
      }
      delta = calculateDelta(tickValue, ticks);
    }
    const logDelta = log10(Math.abs(delta));
    const numDecimal = isNaN(logDelta) ? 1 : Math.max(Math.min(-1 * Math.floor(logDelta), 20), 0);
    const options = {
      notation,
      minimumFractionDigits: numDecimal,
      maximumFractionDigits: numDecimal
    };
    Object.assign(options, this.options.ticks.format);
    return formatNumber(tickValue, locale, options);
  },
  logarithmic(tickValue, index2, ticks) {
    if (tickValue === 0) {
      return "0";
    }
    const remain = ticks[index2].significand || tickValue / Math.pow(10, Math.floor(log10(tickValue)));
    if ([
      1,
      2,
      3,
      5,
      10,
      15
    ].includes(remain) || index2 > 0.8 * ticks.length) {
      return formatters.numeric.call(this, tickValue, index2, ticks);
    }
    return "";
  }
};
function calculateDelta(tickValue, ticks) {
  let delta = ticks.length > 3 ? ticks[2].value - ticks[1].value : ticks[1].value - ticks[0].value;
  if (Math.abs(delta) >= 1 && tickValue !== Math.floor(tickValue)) {
    delta = tickValue - Math.floor(tickValue);
  }
  return delta;
}
var Ticks = {
  formatters
};
function applyScaleDefaults(defaults2) {
  defaults2.set("scale", {
    display: true,
    offset: false,
    reverse: false,
    beginAtZero: false,
    bounds: "ticks",
    clip: true,
    grace: 0,
    grid: {
      display: true,
      lineWidth: 1,
      drawOnChartArea: true,
      drawTicks: true,
      tickLength: 8,
      tickWidth: (_ctx, options) => options.lineWidth,
      tickColor: (_ctx, options) => options.color,
      offset: false
    },
    border: {
      display: true,
      dash: [],
      dashOffset: 0,
      width: 1
    },
    title: {
      display: false,
      text: "",
      padding: {
        top: 4,
        bottom: 4
      }
    },
    ticks: {
      minRotation: 0,
      maxRotation: 50,
      mirror: false,
      textStrokeWidth: 0,
      textStrokeColor: "",
      padding: 3,
      display: true,
      autoSkip: true,
      autoSkipPadding: 3,
      labelOffset: 0,
      callback: Ticks.formatters.values,
      minor: {},
      major: {},
      align: "center",
      crossAlign: "near",
      showLabelBackdrop: false,
      backdropColor: "rgba(255, 255, 255, 0.75)",
      backdropPadding: 2
    }
  });
  defaults2.route("scale.ticks", "color", "", "color");
  defaults2.route("scale.grid", "color", "", "borderColor");
  defaults2.route("scale.border", "color", "", "borderColor");
  defaults2.route("scale.title", "color", "", "color");
  defaults2.describe("scale", {
    _fallback: false,
    _scriptable: (name) => !name.startsWith("before") && !name.startsWith("after") && name !== "callback" && name !== "parser",
    _indexable: (name) => name !== "borderDash" && name !== "tickBorderDash" && name !== "dash"
  });
  defaults2.describe("scales", {
    _fallback: "scale"
  });
  defaults2.describe("scale.ticks", {
    _scriptable: (name) => name !== "backdropPadding" && name !== "callback",
    _indexable: (name) => name !== "backdropPadding"
  });
}
var overrides = /* @__PURE__ */ Object.create(null);
var descriptors = /* @__PURE__ */ Object.create(null);
function getScope$1(node, key) {
  if (!key) {
    return node;
  }
  const keys = key.split(".");
  for (let i = 0, n = keys.length; i < n; ++i) {
    const k = keys[i];
    node = node[k] || (node[k] = /* @__PURE__ */ Object.create(null));
  }
  return node;
}
function set(root, scope, values) {
  if (typeof scope === "string") {
    return merge(getScope$1(root, scope), values);
  }
  return merge(getScope$1(root, ""), scope);
}
var Defaults = class {
  constructor(_descriptors2, _appliers) {
    this.animation = void 0;
    this.backgroundColor = "rgba(0,0,0,0.1)";
    this.borderColor = "rgba(0,0,0,0.1)";
    this.color = "#666";
    this.datasets = {};
    this.devicePixelRatio = (context) => context.chart.platform.getDevicePixelRatio();
    this.elements = {};
    this.events = [
      "mousemove",
      "mouseout",
      "click",
      "touchstart",
      "touchmove"
    ];
    this.font = {
      family: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
      size: 12,
      style: "normal",
      lineHeight: 1.2,
      weight: null
    };
    this.hover = {};
    this.hoverBackgroundColor = (ctx, options) => getHoverColor(options.backgroundColor);
    this.hoverBorderColor = (ctx, options) => getHoverColor(options.borderColor);
    this.hoverColor = (ctx, options) => getHoverColor(options.color);
    this.indexAxis = "x";
    this.interaction = {
      mode: "nearest",
      intersect: true,
      includeInvisible: false
    };
    this.maintainAspectRatio = true;
    this.onHover = null;
    this.onClick = null;
    this.parsing = true;
    this.plugins = {};
    this.responsive = true;
    this.scale = void 0;
    this.scales = {};
    this.showLine = true;
    this.drawActiveElementsOnTop = true;
    this.describe(_descriptors2);
    this.apply(_appliers);
  }
  set(scope, values) {
    return set(this, scope, values);
  }
  get(scope) {
    return getScope$1(this, scope);
  }
  describe(scope, values) {
    return set(descriptors, scope, values);
  }
  override(scope, values) {
    return set(overrides, scope, values);
  }
  route(scope, name, targetScope, targetName) {
    const scopeObject = getScope$1(this, scope);
    const targetScopeObject = getScope$1(this, targetScope);
    const privateName = "_" + name;
    Object.defineProperties(scopeObject, {
      [privateName]: {
        value: scopeObject[name],
        writable: true
      },
      [name]: {
        enumerable: true,
        get() {
          const local = this[privateName];
          const target = targetScopeObject[targetName];
          if (isObject(local)) {
            return Object.assign({}, target, local);
          }
          return valueOrDefault(local, target);
        },
        set(value) {
          this[privateName] = value;
        }
      }
    });
  }
  apply(appliers) {
    appliers.forEach((apply) => apply(this));
  }
};
var defaults = /* @__PURE__ */ new Defaults({
  _scriptable: (name) => !name.startsWith("on"),
  _indexable: (name) => name !== "events",
  hover: {
    _fallback: "interaction"
  },
  interaction: {
    _scriptable: false,
    _indexable: false
  }
}, [
  applyAnimationsDefaults,
  applyLayoutsDefaults,
  applyScaleDefaults
]);
function toFontString(font) {
  if (!font || isNullOrUndef(font.size) || isNullOrUndef(font.family)) {
    return null;
  }
  return (font.style ? font.style + " " : "") + (font.weight ? font.weight + " " : "") + font.size + "px " + font.family;
}
function _measureText(ctx, data, gc, longest, string) {
  let textWidth = data[string];
  if (!textWidth) {
    textWidth = data[string] = ctx.measureText(string).width;
    gc.push(string);
  }
  if (textWidth > longest) {
    longest = textWidth;
  }
  return longest;
}
function _longestText(ctx, font, arrayOfThings, cache) {
  cache = cache || {};
  let data = cache.data = cache.data || {};
  let gc = cache.garbageCollect = cache.garbageCollect || [];
  if (cache.font !== font) {
    data = cache.data = {};
    gc = cache.garbageCollect = [];
    cache.font = font;
  }
  ctx.save();
  ctx.font = font;
  let longest = 0;
  const ilen = arrayOfThings.length;
  let i, j, jlen, thing, nestedThing;
  for (i = 0; i < ilen; i++) {
    thing = arrayOfThings[i];
    if (thing !== void 0 && thing !== null && !isArray(thing)) {
      longest = _measureText(ctx, data, gc, longest, thing);
    } else if (isArray(thing)) {
      for (j = 0, jlen = thing.length; j < jlen; j++) {
        nestedThing = thing[j];
        if (nestedThing !== void 0 && nestedThing !== null && !isArray(nestedThing)) {
          longest = _measureText(ctx, data, gc, longest, nestedThing);
        }
      }
    }
  }
  ctx.restore();
  const gcLen = gc.length / 2;
  if (gcLen > arrayOfThings.length) {
    for (i = 0; i < gcLen; i++) {
      delete data[gc[i]];
    }
    gc.splice(0, gcLen);
  }
  return longest;
}
function _alignPixel(chart, pixel, width) {
  const devicePixelRatio = chart.currentDevicePixelRatio;
  const halfWidth = width !== 0 ? Math.max(width / 2, 0.5) : 0;
  return Math.round((pixel - halfWidth) * devicePixelRatio) / devicePixelRatio + halfWidth;
}
function clearCanvas(canvas, ctx) {
  if (!ctx && !canvas) {
    return;
  }
  ctx = ctx || canvas.getContext("2d");
  ctx.save();
  ctx.resetTransform();
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.restore();
}
function drawPoint(ctx, options, x, y) {
  drawPointLegend(ctx, options, x, y, null);
}
function drawPointLegend(ctx, options, x, y, w) {
  let type, xOffset, yOffset, size, cornerRadius, width, xOffsetW, yOffsetW;
  const style = options.pointStyle;
  const rotation = options.rotation;
  const radius = options.radius;
  let rad = (rotation || 0) * RAD_PER_DEG;
  if (style && typeof style === "object") {
    type = style.toString();
    if (type === "[object HTMLImageElement]" || type === "[object HTMLCanvasElement]") {
      ctx.save();
      ctx.translate(x, y);
      ctx.rotate(rad);
      ctx.drawImage(style, -style.width / 2, -style.height / 2, style.width, style.height);
      ctx.restore();
      return;
    }
  }
  if (isNaN(radius) || radius <= 0) {
    return;
  }
  ctx.beginPath();
  switch (style) {
    // Default includes circle
    default:
      if (w) {
        ctx.ellipse(x, y, w / 2, radius, 0, 0, TAU);
      } else {
        ctx.arc(x, y, radius, 0, TAU);
      }
      ctx.closePath();
      break;
    case "triangle":
      width = w ? w / 2 : radius;
      ctx.moveTo(x + Math.sin(rad) * width, y - Math.cos(rad) * radius);
      rad += TWO_THIRDS_PI;
      ctx.lineTo(x + Math.sin(rad) * width, y - Math.cos(rad) * radius);
      rad += TWO_THIRDS_PI;
      ctx.lineTo(x + Math.sin(rad) * width, y - Math.cos(rad) * radius);
      ctx.closePath();
      break;
    case "rectRounded":
      cornerRadius = radius * 0.516;
      size = radius - cornerRadius;
      xOffset = Math.cos(rad + QUARTER_PI) * size;
      xOffsetW = Math.cos(rad + QUARTER_PI) * (w ? w / 2 - cornerRadius : size);
      yOffset = Math.sin(rad + QUARTER_PI) * size;
      yOffsetW = Math.sin(rad + QUARTER_PI) * (w ? w / 2 - cornerRadius : size);
      ctx.arc(x - xOffsetW, y - yOffset, cornerRadius, rad - PI, rad - HALF_PI);
      ctx.arc(x + yOffsetW, y - xOffset, cornerRadius, rad - HALF_PI, rad);
      ctx.arc(x + xOffsetW, y + yOffset, cornerRadius, rad, rad + HALF_PI);
      ctx.arc(x - yOffsetW, y + xOffset, cornerRadius, rad + HALF_PI, rad + PI);
      ctx.closePath();
      break;
    case "rect":
      if (!rotation) {
        size = Math.SQRT1_2 * radius;
        width = w ? w / 2 : size;
        ctx.rect(x - width, y - size, 2 * width, 2 * size);
        break;
      }
      rad += QUARTER_PI;
    /* falls through */
    case "rectRot":
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      ctx.closePath();
      break;
    case "crossRot":
      rad += QUARTER_PI;
    /* falls through */
    case "cross":
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.moveTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      break;
    case "star":
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.moveTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      rad += QUARTER_PI;
      xOffsetW = Math.cos(rad) * (w ? w / 2 : radius);
      xOffset = Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      yOffsetW = Math.sin(rad) * (w ? w / 2 : radius);
      ctx.moveTo(x - xOffsetW, y - yOffset);
      ctx.lineTo(x + xOffsetW, y + yOffset);
      ctx.moveTo(x + yOffsetW, y - xOffset);
      ctx.lineTo(x - yOffsetW, y + xOffset);
      break;
    case "line":
      xOffset = w ? w / 2 : Math.cos(rad) * radius;
      yOffset = Math.sin(rad) * radius;
      ctx.moveTo(x - xOffset, y - yOffset);
      ctx.lineTo(x + xOffset, y + yOffset);
      break;
    case "dash":
      ctx.moveTo(x, y);
      ctx.lineTo(x + Math.cos(rad) * (w ? w / 2 : radius), y + Math.sin(rad) * radius);
      break;
    case false:
      ctx.closePath();
      break;
  }
  ctx.fill();
  if (options.borderWidth > 0) {
    ctx.stroke();
  }
}
function _isPointInArea(point, area, margin) {
  margin = margin || 0.5;
  return !area || point && point.x > area.left - margin && point.x < area.right + margin && point.y > area.top - margin && point.y < area.bottom + margin;
}
function clipArea(ctx, area) {
  ctx.save();
  ctx.beginPath();
  ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);
  ctx.clip();
}
function unclipArea(ctx) {
  ctx.restore();
}
function _steppedLineTo(ctx, previous, target, flip, mode) {
  if (!previous) {
    return ctx.lineTo(target.x, target.y);
  }
  if (mode === "middle") {
    const midpoint = (previous.x + target.x) / 2;
    ctx.lineTo(midpoint, previous.y);
    ctx.lineTo(midpoint, target.y);
  } else if (mode === "after" !== !!flip) {
    ctx.lineTo(previous.x, target.y);
  } else {
    ctx.lineTo(target.x, previous.y);
  }
  ctx.lineTo(target.x, target.y);
}
function _bezierCurveTo(ctx, previous, target, flip) {
  if (!previous) {
    return ctx.lineTo(target.x, target.y);
  }
  ctx.bezierCurveTo(flip ? previous.cp1x : previous.cp2x, flip ? previous.cp1y : previous.cp2y, flip ? target.cp2x : target.cp1x, flip ? target.cp2y : target.cp1y, target.x, target.y);
}
function setRenderOpts(ctx, opts) {
  if (opts.translation) {
    ctx.translate(opts.translation[0], opts.translation[1]);
  }
  if (!isNullOrUndef(opts.rotation)) {
    ctx.rotate(opts.rotation);
  }
  if (opts.color) {
    ctx.fillStyle = opts.color;
  }
  if (opts.textAlign) {
    ctx.textAlign = opts.textAlign;
  }
  if (opts.textBaseline) {
    ctx.textBaseline = opts.textBaseline;
  }
}
function decorateText(ctx, x, y, line, opts) {
  if (opts.strikethrough || opts.underline) {
    const metrics = ctx.measureText(line);
    const left = x - metrics.actualBoundingBoxLeft;
    const right = x + metrics.actualBoundingBoxRight;
    const top = y - metrics.actualBoundingBoxAscent;
    const bottom = y + metrics.actualBoundingBoxDescent;
    const yDecoration = opts.strikethrough ? (top + bottom) / 2 : bottom;
    ctx.strokeStyle = ctx.fillStyle;
    ctx.beginPath();
    ctx.lineWidth = opts.decorationWidth || 2;
    ctx.moveTo(left, yDecoration);
    ctx.lineTo(right, yDecoration);
    ctx.stroke();
  }
}
function drawBackdrop(ctx, opts) {
  const oldColor = ctx.fillStyle;
  ctx.fillStyle = opts.color;
  ctx.fillRect(opts.left, opts.top, opts.width, opts.height);
  ctx.fillStyle = oldColor;
}
function renderText(ctx, text, x, y, font, opts = {}) {
  const lines = isArray(text) ? text : [
    text
  ];
  const stroke = opts.strokeWidth > 0 && opts.strokeColor !== "";
  let i, line;
  ctx.save();
  ctx.font = font.string;
  setRenderOpts(ctx, opts);
  for (i = 0; i < lines.length; ++i) {
    line = lines[i];
    if (opts.backdrop) {
      drawBackdrop(ctx, opts.backdrop);
    }
    if (stroke) {
      if (opts.strokeColor) {
        ctx.strokeStyle = opts.strokeColor;
      }
      if (!isNullOrUndef(opts.strokeWidth)) {
        ctx.lineWidth = opts.strokeWidth;
      }
      ctx.strokeText(line, x, y, opts.maxWidth);
    }
    ctx.fillText(line, x, y, opts.maxWidth);
    decorateText(ctx, x, y, line, opts);
    y += Number(font.lineHeight);
  }
  ctx.restore();
}
function addRoundedRectPath(ctx, rect) {
  const { x, y, w, h, radius } = rect;
  ctx.arc(x + radius.topLeft, y + radius.topLeft, radius.topLeft, 1.5 * PI, PI, true);
  ctx.lineTo(x, y + h - radius.bottomLeft);
  ctx.arc(x + radius.bottomLeft, y + h - radius.bottomLeft, radius.bottomLeft, PI, HALF_PI, true);
  ctx.lineTo(x + w - radius.bottomRight, y + h);
  ctx.arc(x + w - radius.bottomRight, y + h - radius.bottomRight, radius.bottomRight, HALF_PI, 0, true);
  ctx.lineTo(x + w, y + radius.topRight);
  ctx.arc(x + w - radius.topRight, y + radius.topRight, radius.topRight, 0, -HALF_PI, true);
  ctx.lineTo(x + radius.topLeft, y);
}
var LINE_HEIGHT = /^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/;
var FONT_STYLE = /^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/;
function toLineHeight(value, size) {
  const matches = ("" + value).match(LINE_HEIGHT);
  if (!matches || matches[1] === "normal") {
    return size * 1.2;
  }
  value = +matches[2];
  switch (matches[3]) {
    case "px":
      return value;
    case "%":
      value /= 100;
      break;
  }
  return size * value;
}
var numberOrZero = (v) => +v || 0;
function _readValueToProps(value, props) {
  const ret = {};
  const objProps = isObject(props);
  const keys = objProps ? Object.keys(props) : props;
  const read = isObject(value) ? objProps ? (prop) => valueOrDefault(value[prop], value[props[prop]]) : (prop) => value[prop] : () => value;
  for (const prop of keys) {
    ret[prop] = numberOrZero(read(prop));
  }
  return ret;
}
function toTRBL(value) {
  return _readValueToProps(value, {
    top: "y",
    right: "x",
    bottom: "y",
    left: "x"
  });
}
function toTRBLCorners(value) {
  return _readValueToProps(value, [
    "topLeft",
    "topRight",
    "bottomLeft",
    "bottomRight"
  ]);
}
function toPadding(value) {
  const obj = toTRBL(value);
  obj.width = obj.left + obj.right;
  obj.height = obj.top + obj.bottom;
  return obj;
}
function toFont(options, fallback) {
  options = options || {};
  fallback = fallback || defaults.font;
  let size = valueOrDefault(options.size, fallback.size);
  if (typeof size === "string") {
    size = parseInt(size, 10);
  }
  let style = valueOrDefault(options.style, fallback.style);
  if (style && !("" + style).match(FONT_STYLE)) {
    console.warn('Invalid font style specified: "' + style + '"');
    style = void 0;
  }
  const font = {
    family: valueOrDefault(options.family, fallback.family),
    lineHeight: toLineHeight(valueOrDefault(options.lineHeight, fallback.lineHeight), size),
    size,
    style,
    weight: valueOrDefault(options.weight, fallback.weight),
    string: ""
  };
  font.string = toFontString(font);
  return font;
}
function resolve(inputs, context, index2, info) {
  let cacheable = true;
  let i, ilen, value;
  for (i = 0, ilen = inputs.length; i < ilen; ++i) {
    value = inputs[i];
    if (value === void 0) {
      continue;
    }
    if (context !== void 0 && typeof value === "function") {
      value = value(context);
      cacheable = false;
    }
    if (index2 !== void 0 && isArray(value)) {
      value = value[index2 % value.length];
      cacheable = false;
    }
    if (value !== void 0) {
      if (info && !cacheable) {
        info.cacheable = false;
      }
      return value;
    }
  }
}
function _addGrace(minmax, grace, beginAtZero) {
  const { min, max } = minmax;
  const change = toDimension(grace, (max - min) / 2);
  const keepZero = (value, add) => beginAtZero && value === 0 ? 0 : value + add;
  return {
    min: keepZero(min, -Math.abs(change)),
    max: keepZero(max, change)
  };
}
function createContext(parentContext, context) {
  return Object.assign(Object.create(parentContext), context);
}
function _createResolver(scopes, prefixes = [
  ""
], rootScopes, fallback, getTarget = () => scopes[0]) {
  const finalRootScopes = rootScopes || scopes;
  if (typeof fallback === "undefined") {
    fallback = _resolve("_fallback", scopes);
  }
  const cache = {
    [Symbol.toStringTag]: "Object",
    _cacheable: true,
    _scopes: scopes,
    _rootScopes: finalRootScopes,
    _fallback: fallback,
    _getTarget: getTarget,
    override: (scope) => _createResolver([
      scope,
      ...scopes
    ], prefixes, finalRootScopes, fallback)
  };
  return new Proxy(cache, {
    /**
    * A trap for the delete operator.
    */
    deleteProperty(target, prop) {
      delete target[prop];
      delete target._keys;
      delete scopes[0][prop];
      return true;
    },
    /**
    * A trap for getting property values.
    */
    get(target, prop) {
      return _cached(target, prop, () => _resolveWithPrefixes(prop, prefixes, scopes, target));
    },
    /**
    * A trap for Object.getOwnPropertyDescriptor.
    * Also used by Object.hasOwnProperty.
    */
    getOwnPropertyDescriptor(target, prop) {
      return Reflect.getOwnPropertyDescriptor(target._scopes[0], prop);
    },
    /**
    * A trap for Object.getPrototypeOf.
    */
    getPrototypeOf() {
      return Reflect.getPrototypeOf(scopes[0]);
    },
    /**
    * A trap for the in operator.
    */
    has(target, prop) {
      return getKeysFromAllScopes(target).includes(prop);
    },
    /**
    * A trap for Object.getOwnPropertyNames and Object.getOwnPropertySymbols.
    */
    ownKeys(target) {
      return getKeysFromAllScopes(target);
    },
    /**
    * A trap for setting property values.
    */
    set(target, prop, value) {
      const storage = target._storage || (target._storage = getTarget());
      target[prop] = storage[prop] = value;
      delete target._keys;
      return true;
    }
  });
}
function _attachContext(proxy, context, subProxy, descriptorDefaults) {
  const cache = {
    _cacheable: false,
    _proxy: proxy,
    _context: context,
    _subProxy: subProxy,
    _stack: /* @__PURE__ */ new Set(),
    _descriptors: _descriptors(proxy, descriptorDefaults),
    setContext: (ctx) => _attachContext(proxy, ctx, subProxy, descriptorDefaults),
    override: (scope) => _attachContext(proxy.override(scope), context, subProxy, descriptorDefaults)
  };
  return new Proxy(cache, {
    /**
    * A trap for the delete operator.
    */
    deleteProperty(target, prop) {
      delete target[prop];
      delete proxy[prop];
      return true;
    },
    /**
    * A trap for getting property values.
    */
    get(target, prop, receiver) {
      return _cached(target, prop, () => _resolveWithContext(target, prop, receiver));
    },
    /**
    * A trap for Object.getOwnPropertyDescriptor.
    * Also used by Object.hasOwnProperty.
    */
    getOwnPropertyDescriptor(target, prop) {
      return target._descriptors.allKeys ? Reflect.has(proxy, prop) ? {
        enumerable: true,
        configurable: true
      } : void 0 : Reflect.getOwnPropertyDescriptor(proxy, prop);
    },
    /**
    * A trap for Object.getPrototypeOf.
    */
    getPrototypeOf() {
      return Reflect.getPrototypeOf(proxy);
    },
    /**
    * A trap for the in operator.
    */
    has(target, prop) {
      return Reflect.has(proxy, prop);
    },
    /**
    * A trap for Object.getOwnPropertyNames and Object.getOwnPropertySymbols.
    */
    ownKeys() {
      return Reflect.ownKeys(proxy);
    },
    /**
    * A trap for setting property values.
    */
    set(target, prop, value) {
      proxy[prop] = value;
      delete target[prop];
      return true;
    }
  });
}
function _descriptors(proxy, defaults2 = {
  scriptable: true,
  indexable: true
}) {
  const { _scriptable = defaults2.scriptable, _indexable = defaults2.indexable, _allKeys = defaults2.allKeys } = proxy;
  return {
    allKeys: _allKeys,
    scriptable: _scriptable,
    indexable: _indexable,
    isScriptable: isFunction(_scriptable) ? _scriptable : () => _scriptable,
    isIndexable: isFunction(_indexable) ? _indexable : () => _indexable
  };
}
var readKey = (prefix, name) => prefix ? prefix + _capitalize(name) : name;
var needsSubResolver = (prop, value) => isObject(value) && prop !== "adapters" && (Object.getPrototypeOf(value) === null || value.constructor === Object);
function _cached(target, prop, resolve2) {
  if (Object.prototype.hasOwnProperty.call(target, prop) || prop === "constructor") {
    return target[prop];
  }
  const value = resolve2();
  target[prop] = value;
  return value;
}
function _resolveWithContext(target, prop, receiver) {
  const { _proxy, _context, _subProxy, _descriptors: descriptors2 } = target;
  let value = _proxy[prop];
  if (isFunction(value) && descriptors2.isScriptable(prop)) {
    value = _resolveScriptable(prop, value, target, receiver);
  }
  if (isArray(value) && value.length) {
    value = _resolveArray(prop, value, target, descriptors2.isIndexable);
  }
  if (needsSubResolver(prop, value)) {
    value = _attachContext(value, _context, _subProxy && _subProxy[prop], descriptors2);
  }
  return value;
}
function _resolveScriptable(prop, getValue, target, receiver) {
  const { _proxy, _context, _subProxy, _stack } = target;
  if (_stack.has(prop)) {
    throw new Error("Recursion detected: " + Array.from(_stack).join("->") + "->" + prop);
  }
  _stack.add(prop);
  let value = getValue(_context, _subProxy || receiver);
  _stack.delete(prop);
  if (needsSubResolver(prop, value)) {
    value = createSubResolver(_proxy._scopes, _proxy, prop, value);
  }
  return value;
}
function _resolveArray(prop, value, target, isIndexable) {
  const { _proxy, _context, _subProxy, _descriptors: descriptors2 } = target;
  if (typeof _context.index !== "undefined" && isIndexable(prop)) {
    return value[_context.index % value.length];
  } else if (isObject(value[0])) {
    const arr = value;
    const scopes = _proxy._scopes.filter((s) => s !== arr);
    value = [];
    for (const item of arr) {
      const resolver = createSubResolver(scopes, _proxy, prop, item);
      value.push(_attachContext(resolver, _context, _subProxy && _subProxy[prop], descriptors2));
    }
  }
  return value;
}
function resolveFallback(fallback, prop, value) {
  return isFunction(fallback) ? fallback(prop, value) : fallback;
}
var getScope = (key, parent) => key === true ? parent : typeof key === "string" ? resolveObjectKey(parent, key) : void 0;
function addScopes(set2, parentScopes, key, parentFallback, value) {
  for (const parent of parentScopes) {
    const scope = getScope(key, parent);
    if (scope) {
      set2.add(scope);
      const fallback = resolveFallback(scope._fallback, key, value);
      if (typeof fallback !== "undefined" && fallback !== key && fallback !== parentFallback) {
        return fallback;
      }
    } else if (scope === false && typeof parentFallback !== "undefined" && key !== parentFallback) {
      return null;
    }
  }
  return false;
}
function createSubResolver(parentScopes, resolver, prop, value) {
  const rootScopes = resolver._rootScopes;
  const fallback = resolveFallback(resolver._fallback, prop, value);
  const allScopes = [
    ...parentScopes,
    ...rootScopes
  ];
  const set2 = /* @__PURE__ */ new Set();
  set2.add(value);
  let key = addScopesFromKey(set2, allScopes, prop, fallback || prop, value);
  if (key === null) {
    return false;
  }
  if (typeof fallback !== "undefined" && fallback !== prop) {
    key = addScopesFromKey(set2, allScopes, fallback, key, value);
    if (key === null) {
      return false;
    }
  }
  return _createResolver(Array.from(set2), [
    ""
  ], rootScopes, fallback, () => subGetTarget(resolver, prop, value));
}
function addScopesFromKey(set2, allScopes, key, fallback, item) {
  while (key) {
    key = addScopes(set2, allScopes, key, fallback, item);
  }
  return key;
}
function subGetTarget(resolver, prop, value) {
  const parent = resolver._getTarget();
  if (!(prop in parent)) {
    parent[prop] = {};
  }
  const target = parent[prop];
  if (isArray(target) && isObject(value)) {
    return value;
  }
  return target || {};
}
function _resolveWithPrefixes(prop, prefixes, scopes, proxy) {
  let value;
  for (const prefix of prefixes) {
    value = _resolve(readKey(prefix, prop), scopes);
    if (typeof value !== "undefined") {
      return needsSubResolver(prop, value) ? createSubResolver(scopes, proxy, prop, value) : value;
    }
  }
}
function _resolve(key, scopes) {
  for (const scope of scopes) {
    if (!scope) {
      continue;
    }
    const value = scope[key];
    if (typeof value !== "undefined") {
      return value;
    }
  }
}
function getKeysFromAllScopes(target) {
  let keys = target._keys;
  if (!keys) {
    keys = target._keys = resolveKeysFromAllScopes(target._scopes);
  }
  return keys;
}
function resolveKeysFromAllScopes(scopes) {
  const set2 = /* @__PURE__ */ new Set();
  for (const scope of scopes) {
    for (const key of Object.keys(scope).filter((k) => !k.startsWith("_"))) {
      set2.add(key);
    }
  }
  return Array.from(set2);
}
var EPSILON = Number.EPSILON || 1e-14;
var getPoint = (points, i) => i < points.length && !points[i].skip && points[i];
var getValueAxis = (indexAxis) => indexAxis === "x" ? "y" : "x";
function splineCurve(firstPoint, middlePoint, afterPoint, t) {
  const previous = firstPoint.skip ? middlePoint : firstPoint;
  const current = middlePoint;
  const next = afterPoint.skip ? middlePoint : afterPoint;
  const d01 = distanceBetweenPoints(current, previous);
  const d12 = distanceBetweenPoints(next, current);
  let s01 = d01 / (d01 + d12);
  let s12 = d12 / (d01 + d12);
  s01 = isNaN(s01) ? 0 : s01;
  s12 = isNaN(s12) ? 0 : s12;
  const fa = t * s01;
  const fb = t * s12;
  return {
    previous: {
      x: current.x - fa * (next.x - previous.x),
      y: current.y - fa * (next.y - previous.y)
    },
    next: {
      x: current.x + fb * (next.x - previous.x),
      y: current.y + fb * (next.y - previous.y)
    }
  };
}
function monotoneAdjust(points, deltaK, mK) {
  const pointsLen = points.length;
  let alphaK, betaK, tauK, squaredMagnitude, pointCurrent;
  let pointAfter = getPoint(points, 0);
  for (let i = 0; i < pointsLen - 1; ++i) {
    pointCurrent = pointAfter;
    pointAfter = getPoint(points, i + 1);
    if (!pointCurrent || !pointAfter) {
      continue;
    }
    if (almostEquals(deltaK[i], 0, EPSILON)) {
      mK[i] = mK[i + 1] = 0;
      continue;
    }
    alphaK = mK[i] / deltaK[i];
    betaK = mK[i + 1] / deltaK[i];
    squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);
    if (squaredMagnitude <= 9) {
      continue;
    }
    tauK = 3 / Math.sqrt(squaredMagnitude);
    mK[i] = alphaK * tauK * deltaK[i];
    mK[i + 1] = betaK * tauK * deltaK[i];
  }
}
function monotoneCompute(points, mK, indexAxis = "x") {
  const valueAxis = getValueAxis(indexAxis);
  const pointsLen = points.length;
  let delta, pointBefore, pointCurrent;
  let pointAfter = getPoint(points, 0);
  for (let i = 0; i < pointsLen; ++i) {
    pointBefore = pointCurrent;
    pointCurrent = pointAfter;
    pointAfter = getPoint(points, i + 1);
    if (!pointCurrent) {
      continue;
    }
    const iPixel = pointCurrent[indexAxis];
    const vPixel = pointCurrent[valueAxis];
    if (pointBefore) {
      delta = (iPixel - pointBefore[indexAxis]) / 3;
      pointCurrent[`cp1${indexAxis}`] = iPixel - delta;
      pointCurrent[`cp1${valueAxis}`] = vPixel - delta * mK[i];
    }
    if (pointAfter) {
      delta = (pointAfter[indexAxis] - iPixel) / 3;
      pointCurrent[`cp2${indexAxis}`] = iPixel + delta;
      pointCurrent[`cp2${valueAxis}`] = vPixel + delta * mK[i];
    }
  }
}
function splineCurveMonotone(points, indexAxis = "x") {
  const valueAxis = getValueAxis(indexAxis);
  const pointsLen = points.length;
  const deltaK = Array(pointsLen).fill(0);
  const mK = Array(pointsLen);
  let i, pointBefore, pointCurrent;
  let pointAfter = getPoint(points, 0);
  for (i = 0; i < pointsLen; ++i) {
    pointBefore = pointCurrent;
    pointCurrent = pointAfter;
    pointAfter = getPoint(points, i + 1);
    if (!pointCurrent) {
      continue;
    }
    if (pointAfter) {
      const slopeDelta = pointAfter[indexAxis] - pointCurrent[indexAxis];
      deltaK[i] = slopeDelta !== 0 ? (pointAfter[valueAxis] - pointCurrent[valueAxis]) / slopeDelta : 0;
    }
    mK[i] = !pointBefore ? deltaK[i] : !pointAfter ? deltaK[i - 1] : sign(deltaK[i - 1]) !== sign(deltaK[i]) ? 0 : (deltaK[i - 1] + deltaK[i]) / 2;
  }
  monotoneAdjust(points, deltaK, mK);
  monotoneCompute(points, mK, indexAxis);
}
function capControlPoint(pt, min, max) {
  return Math.max(Math.min(pt, max), min);
}
function capBezierPoints(points, area) {
  let i, ilen, point, inArea, inAreaPrev;
  let inAreaNext = _isPointInArea(points[0], area);
  for (i = 0, ilen = points.length; i < ilen; ++i) {
    inAreaPrev = inArea;
    inArea = inAreaNext;
    inAreaNext = i < ilen - 1 && _isPointInArea(points[i + 1], area);
    if (!inArea) {
      continue;
    }
    point = points[i];
    if (inAreaPrev) {
      point.cp1x = capControlPoint(point.cp1x, area.left, area.right);
      point.cp1y = capControlPoint(point.cp1y, area.top, area.bottom);
    }
    if (inAreaNext) {
      point.cp2x = capControlPoint(point.cp2x, area.left, area.right);
      point.cp2y = capControlPoint(point.cp2y, area.top, area.bottom);
    }
  }
}
function _updateBezierControlPoints(points, options, area, loop, indexAxis) {
  let i, ilen, point, controlPoints;
  if (options.spanGaps) {
    points = points.filter((pt) => !pt.skip);
  }
  if (options.cubicInterpolationMode === "monotone") {
    splineCurveMonotone(points, indexAxis);
  } else {
    let prev = loop ? points[points.length - 1] : points[0];
    for (i = 0, ilen = points.length; i < ilen; ++i) {
      point = points[i];
      controlPoints = splineCurve(prev, point, points[Math.min(i + 1, ilen - (loop ? 0 : 1)) % ilen], options.tension);
      point.cp1x = controlPoints.previous.x;
      point.cp1y = controlPoints.previous.y;
      point.cp2x = controlPoints.next.x;
      point.cp2y = controlPoints.next.y;
      prev = point;
    }
  }
  if (options.capBezierPoints) {
    capBezierPoints(points, area);
  }
}
function _isDomSupported() {
  return typeof window !== "undefined" && typeof document !== "undefined";
}
function _getParentNode(domNode) {
  let parent = domNode.parentNode;
  if (parent && parent.toString() === "[object ShadowRoot]") {
    parent = parent.host;
  }
  return parent;
}
function parseMaxStyle(styleValue, node, parentProperty) {
  let valueInPixels;
  if (typeof styleValue === "string") {
    valueInPixels = parseInt(styleValue, 10);
    if (styleValue.indexOf("%") !== -1) {
      valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];
    }
  } else {
    valueInPixels = styleValue;
  }
  return valueInPixels;
}
var getComputedStyle = (element) => element.ownerDocument.defaultView.getComputedStyle(element, null);
function getStyle(el, property) {
  return getComputedStyle(el).getPropertyValue(property);
}
var positions = [
  "top",
  "right",
  "bottom",
  "left"
];
function getPositionedStyle(styles, style, suffix) {
  const result = {};
  suffix = suffix ? "-" + suffix : "";
  for (let i = 0; i < 4; i++) {
    const pos = positions[i];
    result[pos] = parseFloat(styles[style + "-" + pos + suffix]) || 0;
  }
  result.width = result.left + result.right;
  result.height = result.top + result.bottom;
  return result;
}
var useOffsetPos = (x, y, target) => (x > 0 || y > 0) && (!target || !target.shadowRoot);
function getCanvasPosition(e, canvas) {
  const touches = e.touches;
  const source = touches && touches.length ? touches[0] : e;
  const { offsetX, offsetY } = source;
  let box = false;
  let x, y;
  if (useOffsetPos(offsetX, offsetY, e.target)) {
    x = offsetX;
    y = offsetY;
  } else {
    const rect = canvas.getBoundingClientRect();
    x = source.clientX - rect.left;
    y = source.clientY - rect.top;
    box = true;
  }
  return {
    x,
    y,
    box
  };
}
function getRelativePosition(event, chart) {
  if ("native" in event) {
    return event;
  }
  const { canvas, currentDevicePixelRatio } = chart;
  const style = getComputedStyle(canvas);
  const borderBox = style.boxSizing === "border-box";
  const paddings = getPositionedStyle(style, "padding");
  const borders = getPositionedStyle(style, "border", "width");
  const { x, y, box } = getCanvasPosition(event, canvas);
  const xOffset = paddings.left + (box && borders.left);
  const yOffset = paddings.top + (box && borders.top);
  let { width, height } = chart;
  if (borderBox) {
    width -= paddings.width + borders.width;
    height -= paddings.height + borders.height;
  }
  return {
    x: Math.round((x - xOffset) / width * canvas.width / currentDevicePixelRatio),
    y: Math.round((y - yOffset) / height * canvas.height / currentDevicePixelRatio)
  };
}
function getContainerSize(canvas, width, height) {
  let maxWidth, maxHeight;
  if (width === void 0 || height === void 0) {
    const container = canvas && _getParentNode(canvas);
    if (!container) {
      width = canvas.clientWidth;
      height = canvas.clientHeight;
    } else {
      const rect = container.getBoundingClientRect();
      const containerStyle = getComputedStyle(container);
      const containerBorder = getPositionedStyle(containerStyle, "border", "width");
      const containerPadding = getPositionedStyle(containerStyle, "padding");
      width = rect.width - containerPadding.width - containerBorder.width;
      height = rect.height - containerPadding.height - containerBorder.height;
      maxWidth = parseMaxStyle(containerStyle.maxWidth, container, "clientWidth");
      maxHeight = parseMaxStyle(containerStyle.maxHeight, container, "clientHeight");
    }
  }
  return {
    width,
    height,
    maxWidth: maxWidth || INFINITY,
    maxHeight: maxHeight || INFINITY
  };
}
var round1 = (v) => Math.round(v * 10) / 10;
function getMaximumSize(canvas, bbWidth, bbHeight, aspectRatio) {
  const style = getComputedStyle(canvas);
  const margins = getPositionedStyle(style, "margin");
  const maxWidth = parseMaxStyle(style.maxWidth, canvas, "clientWidth") || INFINITY;
  const maxHeight = parseMaxStyle(style.maxHeight, canvas, "clientHeight") || INFINITY;
  const containerSize = getContainerSize(canvas, bbWidth, bbHeight);
  let { width, height } = containerSize;
  if (style.boxSizing === "content-box") {
    const borders = getPositionedStyle(style, "border", "width");
    const paddings = getPositionedStyle(style, "padding");
    width -= paddings.width + borders.width;
    height -= paddings.height + borders.height;
  }
  width = Math.max(0, width - margins.width);
  height = Math.max(0, aspectRatio ? width / aspectRatio : height - margins.height);
  width = round1(Math.min(width, maxWidth, containerSize.maxWidth));
  height = round1(Math.min(height, maxHeight, containerSize.maxHeight));
  if (width && !height) {
    height = round1(width / 2);
  }
  const maintainHeight = bbWidth !== void 0 || bbHeight !== void 0;
  if (maintainHeight && aspectRatio && containerSize.height && height > containerSize.height) {
    height = containerSize.height;
    width = round1(Math.floor(height * aspectRatio));
  }
  return {
    width,
    height
  };
}
function retinaScale(chart, forceRatio, forceStyle) {
  const pixelRatio = forceRatio || 1;
  const deviceHeight = Math.floor(chart.height * pixelRatio);
  const deviceWidth = Math.floor(chart.width * pixelRatio);
  chart.height = Math.floor(chart.height);
  chart.width = Math.floor(chart.width);
  const canvas = chart.canvas;
  if (canvas.style && (forceStyle || !canvas.style.height && !canvas.style.width)) {
    canvas.style.height = `${chart.height}px`;
    canvas.style.width = `${chart.width}px`;
  }
  if (chart.currentDevicePixelRatio !== pixelRatio || canvas.height !== deviceHeight || canvas.width !== deviceWidth) {
    chart.currentDevicePixelRatio = pixelRatio;
    canvas.height = deviceHeight;
    canvas.width = deviceWidth;
    chart.ctx.setTransform(pixelRatio, 0, 0, pixelRatio, 0, 0);
    return true;
  }
  return false;
}
var supportsEventListenerOptions = (function() {
  let passiveSupported = false;
  try {
    const options = {
      get passive() {
        passiveSupported = true;
        return false;
      }
    };
    if (_isDomSupported()) {
      window.addEventListener("test", null, options);
      window.removeEventListener("test", null, options);
    }
  } catch (e) {
  }
  return passiveSupported;
})();
function readUsedSize(element, property) {
  const value = getStyle(element, property);
  const matches = value && value.match(/^(\d+)(\.\d+)?px$/);
  return matches ? +matches[1] : void 0;
}
function _pointInLine(p1, p2, t, mode) {
  return {
    x: p1.x + t * (p2.x - p1.x),
    y: p1.y + t * (p2.y - p1.y)
  };
}
function _steppedInterpolation(p1, p2, t, mode) {
  return {
    x: p1.x + t * (p2.x - p1.x),
    y: mode === "middle" ? t < 0.5 ? p1.y : p2.y : mode === "after" ? t < 1 ? p1.y : p2.y : t > 0 ? p2.y : p1.y
  };
}
function _bezierInterpolation(p1, p2, t, mode) {
  const cp1 = {
    x: p1.cp2x,
    y: p1.cp2y
  };
  const cp2 = {
    x: p2.cp1x,
    y: p2.cp1y
  };
  const a = _pointInLine(p1, cp1, t);
  const b = _pointInLine(cp1, cp2, t);
  const c = _pointInLine(cp2, p2, t);
  const d = _pointInLine(a, b, t);
  const e = _pointInLine(b, c, t);
  return _pointInLine(d, e, t);
}
var getRightToLeftAdapter = function(rectX, width) {
  return {
    x(x) {
      return rectX + rectX + width - x;
    },
    setWidth(w) {
      width = w;
    },
    textAlign(align) {
      if (align === "center") {
        return align;
      }
      return align === "right" ? "left" : "right";
    },
    xPlus(x, value) {
      return x - value;
    },
    leftForLtr(x, itemWidth) {
      return x - itemWidth;
    }
  };
};
var getLeftToRightAdapter = function() {
  return {
    x(x) {
      return x;
    },
    setWidth(w) {
    },
    textAlign(align) {
      return align;
    },
    xPlus(x, value) {
      return x + value;
    },
    leftForLtr(x, _itemWidth) {
      return x;
    }
  };
};
function getRtlAdapter(rtl, rectX, width) {
  return rtl ? getRightToLeftAdapter(rectX, width) : getLeftToRightAdapter();
}
function overrideTextDirection(ctx, direction) {
  let style, original;
  if (direction === "ltr" || direction === "rtl") {
    style = ctx.canvas.style;
    original = [
      style.getPropertyValue("direction"),
      style.getPropertyPriority("direction")
    ];
    style.setProperty("direction", direction, "important");
    ctx.prevTextDirection = original;
  }
}
function restoreTextDirection(ctx, original) {
  if (original !== void 0) {
    delete ctx.prevTextDirection;
    ctx.canvas.style.setProperty("direction", original[0], original[1]);
  }
}
function propertyFn(property) {
  if (property === "angle") {
    return {
      between: _angleBetween,
      compare: _angleDiff,
      normalize: _normalizeAngle
    };
  }
  return {
    between: _isBetween,
    compare: (a, b) => a - b,
    normalize: (x) => x
  };
}
function normalizeSegment({ start, end, count, loop, style }) {
  return {
    start: start % count,
    end: end % count,
    loop: loop && (end - start + 1) % count === 0,
    style
  };
}
function getSegment(segment, points, bounds) {
  const { property, start: startBound, end: endBound } = bounds;
  const { between, normalize } = propertyFn(property);
  const count = points.length;
  let { start, end, loop } = segment;
  let i, ilen;
  if (loop) {
    start += count;
    end += count;
    for (i = 0, ilen = count; i < ilen; ++i) {
      if (!between(normalize(points[start % count][property]), startBound, endBound)) {
        break;
      }
      start--;
      end--;
    }
    start %= count;
    end %= count;
  }
  if (end < start) {
    end += count;
  }
  return {
    start,
    end,
    loop,
    style: segment.style
  };
}
function _boundSegment(segment, points, bounds) {
  if (!bounds) {
    return [
      segment
    ];
  }
  const { property, start: startBound, end: endBound } = bounds;
  const count = points.length;
  const { compare, between, normalize } = propertyFn(property);
  const { start, end, loop, style } = getSegment(segment, points, bounds);
  const result = [];
  let inside = false;
  let subStart = null;
  let value, point, prevValue;
  const startIsBefore = () => between(startBound, prevValue, value) && compare(startBound, prevValue) !== 0;
  const endIsBefore = () => compare(endBound, value) === 0 || between(endBound, prevValue, value);
  const shouldStart = () => inside || startIsBefore();
  const shouldStop = () => !inside || endIsBefore();
  for (let i = start, prev = start; i <= end; ++i) {
    point = points[i % count];
    if (point.skip) {
      continue;
    }
    value = normalize(point[property]);
    if (value === prevValue) {
      continue;
    }
    inside = between(value, startBound, endBound);
    if (subStart === null && shouldStart()) {
      subStart = compare(value, startBound) === 0 ? i : prev;
    }
    if (subStart !== null && shouldStop()) {
      result.push(normalizeSegment({
        start: subStart,
        end: i,
        loop,
        count,
        style
      }));
      subStart = null;
    }
    prev = i;
    prevValue = value;
  }
  if (subStart !== null) {
    result.push(normalizeSegment({
      start: subStart,
      end,
      loop,
      count,
      style
    }));
  }
  return result;
}
function _boundSegments(line, bounds) {
  const result = [];
  const segments = line.segments;
  for (let i = 0; i < segments.length; i++) {
    const sub = _boundSegment(segments[i], line.points, bounds);
    if (sub.length) {
      result.push(...sub);
    }
  }
  return result;
}
function findStartAndEnd(points, count, loop, spanGaps) {
  let start = 0;
  let end = count - 1;
  if (loop && !spanGaps) {
    while (start < count && !points[start].skip) {
      start++;
    }
  }
  while (start < count && points[start].skip) {
    start++;
  }
  start %= count;
  if (loop) {
    end += start;
  }
  while (end > start && points[end % count].skip) {
    end--;
  }
  end %= count;
  return {
    start,
    end
  };
}
function solidSegments(points, start, max, loop) {
  const count = points.length;
  const result = [];
  let last = start;
  let prev = points[start];
  let end;
  for (end = start + 1; end <= max; ++end) {
    const cur = points[end % count];
    if (cur.skip || cur.stop) {
      if (!prev.skip) {
        loop = false;
        result.push({
          start: start % count,
          end: (end - 1) % count,
          loop
        });
        start = last = cur.stop ? end : null;
      }
    } else {
      last = end;
      if (prev.skip) {
        start = end;
      }
    }
    prev = cur;
  }
  if (last !== null) {
    result.push({
      start: start % count,
      end: last % count,
      loop
    });
  }
  return result;
}
function _computeSegments(line, segmentOptions) {
  const points = line.points;
  const spanGaps = line.options.spanGaps;
  const count = points.length;
  if (!count) {
    return [];
  }
  const loop = !!line._loop;
  const { start, end } = findStartAndEnd(points, count, loop, spanGaps);
  if (spanGaps === true) {
    return splitByStyles(line, [
      {
        start,
        end,
        loop
      }
    ], points, segmentOptions);
  }
  const max = end < start ? end + count : end;
  const completeLoop = !!line._fullLoop && start === 0 && end === count - 1;
  return splitByStyles(line, solidSegments(points, start, max, completeLoop), points, segmentOptions);
}
function splitByStyles(line, segments, points, segmentOptions) {
  if (!segmentOptions || !segmentOptions.setContext || !points) {
    return segments;
  }
  return doSplitByStyles(line, segments, points, segmentOptions);
}
function doSplitByStyles(line, segments, points, segmentOptions) {
  const chartContext = line._chart.getContext();
  const baseStyle = readStyle(line.options);
  const { _datasetIndex: datasetIndex, options: { spanGaps } } = line;
  const count = points.length;
  const result = [];
  let prevStyle = baseStyle;
  let start = segments[0].start;
  let i = start;
  function addStyle(s, e, l, st) {
    const dir = spanGaps ? -1 : 1;
    if (s === e) {
      return;
    }
    s += count;
    while (points[s % count].skip) {
      s -= dir;
    }
    while (points[e % count].skip) {
      e += dir;
    }
    if (s % count !== e % count) {
      result.push({
        start: s % count,
        end: e % count,
        loop: l,
        style: st
      });
      prevStyle = st;
      start = e % count;
    }
  }
  for (const segment of segments) {
    start = spanGaps ? start : segment.start;
    let prev = points[start % count];
    let style;
    for (i = start + 1; i <= segment.end; i++) {
      const pt = points[i % count];
      style = readStyle(segmentOptions.setContext(createContext(chartContext, {
        type: "segment",
        p0: prev,
        p1: pt,
        p0DataIndex: (i - 1) % count,
        p1DataIndex: i % count,
        datasetIndex
      })));
      if (styleChanged(style, prevStyle)) {
        addStyle(start, i - 1, segment.loop, prevStyle);
      }
      prev = pt;
      prevStyle = style;
    }
    if (start < i - 1) {
      addStyle(start, i - 1, segment.loop, prevStyle);
    }
  }
  return result;
}
function readStyle(options) {
  return {
    backgroundColor: options.backgroundColor,
    borderCapStyle: options.borderCapStyle,
    borderDash: options.borderDash,
    borderDashOffset: options.borderDashOffset,
    borderJoinStyle: options.borderJoinStyle,
    borderWidth: options.borderWidth,
    borderColor: options.borderColor
  };
}
function styleChanged(style, prevStyle) {
  if (!prevStyle) {
    return false;
  }
  const cache = [];
  const replacer = function(key, value) {
    if (!isPatternOrGradient(value)) {
      return value;
    }
    if (!cache.includes(value)) {
      cache.push(value);
    }
    return cache.indexOf(value);
  };
  return JSON.stringify(style, replacer) !== JSON.stringify(prevStyle, replacer);
}

// node_modules/.pnpm/chart.js@4.4.6/node_modules/chart.js/dist/chart.js
var Animator = class {
  constructor() {
    this._request = null;
    this._charts = /* @__PURE__ */ new Map();
    this._running = false;
    this._lastDate = void 0;
  }
  _notify(chart, anims, date, type) {
    const callbacks = anims.listeners[type];
    const numSteps = anims.duration;
    callbacks.forEach((fn) => fn({
      chart,
      initial: anims.initial,
      numSteps,
      currentStep: Math.min(date - anims.start, numSteps)
    }));
  }
  _refresh() {
    if (this._request) {
      return;
    }
    this._running = true;
    this._request = requestAnimFrame.call(window, () => {
      this._update();
      this._request = null;
      if (this._running) {
        this._refresh();
      }
    });
  }
  _update(date = Date.now()) {
    let remaining = 0;
    this._charts.forEach((anims, chart) => {
      if (!anims.running || !anims.items.length) {
        return;
      }
      const items = anims.items;
      let i = items.length - 1;
      let draw2 = false;
      let item;
      for (; i >= 0; --i) {
        item = items[i];
        if (item._active) {
          if (item._total > anims.duration) {
            anims.duration = item._total;
          }
          item.tick(date);
          draw2 = true;
        } else {
          items[i] = items[items.length - 1];
          items.pop();
        }
      }
      if (draw2) {
        chart.draw();
        this._notify(chart, anims, date, "progress");
      }
      if (!items.length) {
        anims.running = false;
        this._notify(chart, anims, date, "complete");
        anims.initial = false;
      }
      remaining += items.length;
    });
    this._lastDate = date;
    if (remaining === 0) {
      this._running = false;
    }
  }
  _getAnims(chart) {
    const charts = this._charts;
    let anims = charts.get(chart);
    if (!anims) {
      anims = {
        running: false,
        initial: true,
        items: [],
        listeners: {
          complete: [],
          progress: []
        }
      };
      charts.set(chart, anims);
    }
    return anims;
  }
  listen(chart, event, cb) {
    this._getAnims(chart).listeners[event].push(cb);
  }
  add(chart, items) {
    if (!items || !items.length) {
      return;
    }
    this._getAnims(chart).items.push(...items);
  }
  has(chart) {
    return this._getAnims(chart).items.length > 0;
  }
  start(chart) {
    const anims = this._charts.get(chart);
    if (!anims) {
      return;
    }
    anims.running = true;
    anims.start = Date.now();
    anims.duration = anims.items.reduce((acc, cur) => Math.max(acc, cur._duration), 0);
    this._refresh();
  }
  running(chart) {
    if (!this._running) {
      return false;
    }
    const anims = this._charts.get(chart);
    if (!anims || !anims.running || !anims.items.length) {
      return false;
    }
    return true;
  }
  stop(chart) {
    const anims = this._charts.get(chart);
    if (!anims || !anims.items.length) {
      return;
    }
    const items = anims.items;
    let i = items.length - 1;
    for (; i >= 0; --i) {
      items[i].cancel();
    }
    anims.items = [];
    this._notify(chart, anims, Date.now(), "complete");
  }
  remove(chart) {
    return this._charts.delete(chart);
  }
};
var animator = /* @__PURE__ */ new Animator();
var transparent = "transparent";
var interpolators = {
  boolean(from2, to2, factor) {
    return factor > 0.5 ? to2 : from2;
  },
  color(from2, to2, factor) {
    const c0 = color(from2 || transparent);
    const c1 = c0.valid && color(to2 || transparent);
    return c1 && c1.valid ? c1.mix(c0, factor).hexString() : to2;
  },
  number(from2, to2, factor) {
    return from2 + (to2 - from2) * factor;
  }
};
var Animation = class {
  constructor(cfg, target, prop, to2) {
    const currentValue = target[prop];
    to2 = resolve([
      cfg.to,
      to2,
      currentValue,
      cfg.from
    ]);
    const from2 = resolve([
      cfg.from,
      currentValue,
      to2
    ]);
    this._active = true;
    this._fn = cfg.fn || interpolators[cfg.type || typeof from2];
    this._easing = effects[cfg.easing] || effects.linear;
    this._start = Math.floor(Date.now() + (cfg.delay || 0));
    this._duration = this._total = Math.floor(cfg.duration);
    this._loop = !!cfg.loop;
    this._target = target;
    this._prop = prop;
    this._from = from2;
    this._to = to2;
    this._promises = void 0;
  }
  active() {
    return this._active;
  }
  update(cfg, to2, date) {
    if (this._active) {
      this._notify(false);
      const currentValue = this._target[this._prop];
      const elapsed = date - this._start;
      const remain = this._duration - elapsed;
      this._start = date;
      this._duration = Math.floor(Math.max(remain, cfg.duration));
      this._total += elapsed;
      this._loop = !!cfg.loop;
      this._to = resolve([
        cfg.to,
        to2,
        currentValue,
        cfg.from
      ]);
      this._from = resolve([
        cfg.from,
        currentValue,
        to2
      ]);
    }
  }
  cancel() {
    if (this._active) {
      this.tick(Date.now());
      this._active = false;
      this._notify(false);
    }
  }
  tick(date) {
    const elapsed = date - this._start;
    const duration = this._duration;
    const prop = this._prop;
    const from2 = this._from;
    const loop = this._loop;
    const to2 = this._to;
    let factor;
    this._active = from2 !== to2 && (loop || elapsed < duration);
    if (!this._active) {
      this._target[prop] = to2;
      this._notify(true);
      return;
    }
    if (elapsed < 0) {
      this._target[prop] = from2;
      return;
    }
    factor = elapsed / duration % 2;
    factor = loop && factor > 1 ? 2 - factor : factor;
    factor = this._easing(Math.min(1, Math.max(0, factor)));
    this._target[prop] = this._fn(from2, to2, factor);
  }
  wait() {
    const promises = this._promises || (this._promises = []);
    return new Promise((res, rej) => {
      promises.push({
        res,
        rej
      });
    });
  }
  _notify(resolved) {
    const method = resolved ? "res" : "rej";
    const promises = this._promises || [];
    for (let i = 0; i < promises.length; i++) {
      promises[i][method]();
    }
  }
};
var Animations = class {
  constructor(chart, config) {
    this._chart = chart;
    this._properties = /* @__PURE__ */ new Map();
    this.configure(config);
  }
  configure(config) {
    if (!isObject(config)) {
      return;
    }
    const animationOptions = Object.keys(defaults.animation);
    const animatedProps = this._properties;
    Object.getOwnPropertyNames(config).forEach((key) => {
      const cfg = config[key];
      if (!isObject(cfg)) {
        return;
      }
      const resolved = {};
      for (const option of animationOptions) {
        resolved[option] = cfg[option];
      }
      (isArray(cfg.properties) && cfg.properties || [
        key
      ]).forEach((prop) => {
        if (prop === key || !animatedProps.has(prop)) {
          animatedProps.set(prop, resolved);
        }
      });
    });
  }
  _animateOptions(target, values) {
    const newOptions = values.options;
    const options = resolveTargetOptions(target, newOptions);
    if (!options) {
      return [];
    }
    const animations = this._createAnimations(options, newOptions);
    if (newOptions.$shared) {
      awaitAll(target.options.$animations, newOptions).then(() => {
        target.options = newOptions;
      }, () => {
      });
    }
    return animations;
  }
  _createAnimations(target, values) {
    const animatedProps = this._properties;
    const animations = [];
    const running = target.$animations || (target.$animations = {});
    const props = Object.keys(values);
    const date = Date.now();
    let i;
    for (i = props.length - 1; i >= 0; --i) {
      const prop = props[i];
      if (prop.charAt(0) === "$") {
        continue;
      }
      if (prop === "options") {
        animations.push(...this._animateOptions(target, values));
        continue;
      }
      const value = values[prop];
      let animation = running[prop];
      const cfg = animatedProps.get(prop);
      if (animation) {
        if (cfg && animation.active()) {
          animation.update(cfg, value, date);
          continue;
        } else {
          animation.cancel();
        }
      }
      if (!cfg || !cfg.duration) {
        target[prop] = value;
        continue;
      }
      running[prop] = animation = new Animation(cfg, target, prop, value);
      animations.push(animation);
    }
    return animations;
  }
  update(target, values) {
    if (this._properties.size === 0) {
      Object.assign(target, values);
      return;
    }
    const animations = this._createAnimations(target, values);
    if (animations.length) {
      animator.add(this._chart, animations);
      return true;
    }
  }
};
function awaitAll(animations, properties) {
  const running = [];
  const keys = Object.keys(properties);
  for (let i = 0; i < keys.length; i++) {
    const anim = animations[keys[i]];
    if (anim && anim.active()) {
      running.push(anim.wait());
    }
  }
  return Promise.all(running);
}
function resolveTargetOptions(target, newOptions) {
  if (!newOptions) {
    return;
  }
  let options = target.options;
  if (!options) {
    target.options = newOptions;
    return;
  }
  if (options.$shared) {
    target.options = options = Object.assign({}, options, {
      $shared: false,
      $animations: {}
    });
  }
  return options;
}
function scaleClip(scale, allowedOverflow) {
  const opts = scale && scale.options || {};
  const reverse = opts.reverse;
  const min = opts.min === void 0 ? allowedOverflow : 0;
  const max = opts.max === void 0 ? allowedOverflow : 0;
  return {
    start: reverse ? max : min,
    end: reverse ? min : max
  };
}
function defaultClip(xScale, yScale, allowedOverflow) {
  if (allowedOverflow === false) {
    return false;
  }
  const x = scaleClip(xScale, allowedOverflow);
  const y = scaleClip(yScale, allowedOverflow);
  return {
    top: y.end,
    right: x.end,
    bottom: y.start,
    left: x.start
  };
}
function toClip(value) {
  let t, r, b, l;
  if (isObject(value)) {
    t = value.top;
    r = value.right;
    b = value.bottom;
    l = value.left;
  } else {
    t = r = b = l = value;
  }
  return {
    top: t,
    right: r,
    bottom: b,
    left: l,
    disabled: value === false
  };
}
function getSortedDatasetIndices(chart, filterVisible) {
  const keys = [];
  const metasets = chart._getSortedDatasetMetas(filterVisible);
  let i, ilen;
  for (i = 0, ilen = metasets.length; i < ilen; ++i) {
    keys.push(metasets[i].index);
  }
  return keys;
}
function applyStack(stack, value, dsIndex, options = {}) {
  const keys = stack.keys;
  const singleMode = options.mode === "single";
  let i, ilen, datasetIndex, otherValue;
  if (value === null) {
    return;
  }
  let found = false;
  for (i = 0, ilen = keys.length; i < ilen; ++i) {
    datasetIndex = +keys[i];
    if (datasetIndex === dsIndex) {
      found = true;
      if (options.all) {
        continue;
      }
      break;
    }
    otherValue = stack.values[datasetIndex];
    if (isNumberFinite(otherValue) && (singleMode || value === 0 || sign(value) === sign(otherValue))) {
      value += otherValue;
    }
  }
  if (!found && !options.all) {
    return 0;
  }
  return value;
}
function convertObjectDataToArray(data, meta) {
  const { iScale, vScale } = meta;
  const iAxisKey = iScale.axis === "x" ? "x" : "y";
  const vAxisKey = vScale.axis === "x" ? "x" : "y";
  const keys = Object.keys(data);
  const adata = new Array(keys.length);
  let i, ilen, key;
  for (i = 0, ilen = keys.length; i < ilen; ++i) {
    key = keys[i];
    adata[i] = {
      [iAxisKey]: key,
      [vAxisKey]: data[key]
    };
  }
  return adata;
}
function isStacked(scale, meta) {
  const stacked = scale && scale.options.stacked;
  return stacked || stacked === void 0 && meta.stack !== void 0;
}
function getStackKey(indexScale, valueScale, meta) {
  return `${indexScale.id}.${valueScale.id}.${meta.stack || meta.type}`;
}
function getUserBounds(scale) {
  const { min, max, minDefined, maxDefined } = scale.getUserBounds();
  return {
    min: minDefined ? min : Number.NEGATIVE_INFINITY,
    max: maxDefined ? max : Number.POSITIVE_INFINITY
  };
}
function getOrCreateStack(stacks, stackKey, indexValue) {
  const subStack = stacks[stackKey] || (stacks[stackKey] = {});
  return subStack[indexValue] || (subStack[indexValue] = {});
}
function getLastIndexInStack(stack, vScale, positive, type) {
  for (const meta of vScale.getMatchingVisibleMetas(type).reverse()) {
    const value = stack[meta.index];
    if (positive && value > 0 || !positive && value < 0) {
      return meta.index;
    }
  }
  return null;
}
function updateStacks(controller, parsed) {
  const { chart, _cachedMeta: meta } = controller;
  const stacks = chart._stacks || (chart._stacks = {});
  const { iScale, vScale, index: datasetIndex } = meta;
  const iAxis = iScale.axis;
  const vAxis = vScale.axis;
  const key = getStackKey(iScale, vScale, meta);
  const ilen = parsed.length;
  let stack;
  for (let i = 0; i < ilen; ++i) {
    const item = parsed[i];
    const { [iAxis]: index2, [vAxis]: value } = item;
    const itemStacks = item._stacks || (item._stacks = {});
    stack = itemStacks[vAxis] = getOrCreateStack(stacks, key, index2);
    stack[datasetIndex] = value;
    stack._top = getLastIndexInStack(stack, vScale, true, meta.type);
    stack._bottom = getLastIndexInStack(stack, vScale, false, meta.type);
    const visualValues = stack._visualValues || (stack._visualValues = {});
    visualValues[datasetIndex] = value;
  }
}
function getFirstScaleId(chart, axis) {
  const scales = chart.scales;
  return Object.keys(scales).filter((key) => scales[key].axis === axis).shift();
}
function createDatasetContext(parent, index2) {
  return createContext(parent, {
    active: false,
    dataset: void 0,
    datasetIndex: index2,
    index: index2,
    mode: "default",
    type: "dataset"
  });
}
function createDataContext(parent, index2, element) {
  return createContext(parent, {
    active: false,
    dataIndex: index2,
    parsed: void 0,
    raw: void 0,
    element,
    index: index2,
    mode: "default",
    type: "data"
  });
}
function clearStacks(meta, items) {
  const datasetIndex = meta.controller.index;
  const axis = meta.vScale && meta.vScale.axis;
  if (!axis) {
    return;
  }
  items = items || meta._parsed;
  for (const parsed of items) {
    const stacks = parsed._stacks;
    if (!stacks || stacks[axis] === void 0 || stacks[axis][datasetIndex] === void 0) {
      return;
    }
    delete stacks[axis][datasetIndex];
    if (stacks[axis]._visualValues !== void 0 && stacks[axis]._visualValues[datasetIndex] !== void 0) {
      delete stacks[axis]._visualValues[datasetIndex];
    }
  }
}
var isDirectUpdateMode = (mode) => mode === "reset" || mode === "none";
var cloneIfNotShared = (cached, shared) => shared ? cached : Object.assign({}, cached);
var createStack = (canStack, meta, chart) => canStack && !meta.hidden && meta._stacked && {
  keys: getSortedDatasetIndices(chart, true),
  values: null
};
var DatasetController = class {
  static defaults = {};
  static datasetElementType = null;
  static dataElementType = null;
  constructor(chart, datasetIndex) {
    this.chart = chart;
    this._ctx = chart.ctx;
    this.index = datasetIndex;
    this._cachedDataOpts = {};
    this._cachedMeta = this.getMeta();
    this._type = this._cachedMeta.type;
    this.options = void 0;
    this._parsing = false;
    this._data = void 0;
    this._objectData = void 0;
    this._sharedOptions = void 0;
    this._drawStart = void 0;
    this._drawCount = void 0;
    this.enableOptionSharing = false;
    this.supportsDecimation = false;
    this.$context = void 0;
    this._syncList = [];
    this.datasetElementType = new.target.datasetElementType;
    this.dataElementType = new.target.dataElementType;
    this.initialize();
  }
  initialize() {
    const meta = this._cachedMeta;
    this.configure();
    this.linkScales();
    meta._stacked = isStacked(meta.vScale, meta);
    this.addElements();
    if (this.options.fill && !this.chart.isPluginEnabled("filler")) {
      console.warn("Tried to use the 'fill' option without the 'Filler' plugin enabled. Please import and register the 'Filler' plugin and make sure it is not disabled in the options");
    }
  }
  updateIndex(datasetIndex) {
    if (this.index !== datasetIndex) {
      clearStacks(this._cachedMeta);
    }
    this.index = datasetIndex;
  }
  linkScales() {
    const chart = this.chart;
    const meta = this._cachedMeta;
    const dataset = this.getDataset();
    const chooseId = (axis, x, y, r) => axis === "x" ? x : axis === "r" ? r : y;
    const xid = meta.xAxisID = valueOrDefault(dataset.xAxisID, getFirstScaleId(chart, "x"));
    const yid = meta.yAxisID = valueOrDefault(dataset.yAxisID, getFirstScaleId(chart, "y"));
    const rid = meta.rAxisID = valueOrDefault(dataset.rAxisID, getFirstScaleId(chart, "r"));
    const indexAxis = meta.indexAxis;
    const iid = meta.iAxisID = chooseId(indexAxis, xid, yid, rid);
    const vid = meta.vAxisID = chooseId(indexAxis, yid, xid, rid);
    meta.xScale = this.getScaleForId(xid);
    meta.yScale = this.getScaleForId(yid);
    meta.rScale = this.getScaleForId(rid);
    meta.iScale = this.getScaleForId(iid);
    meta.vScale = this.getScaleForId(vid);
  }
  getDataset() {
    return this.chart.data.datasets[this.index];
  }
  getMeta() {
    return this.chart.getDatasetMeta(this.index);
  }
  getScaleForId(scaleID) {
    return this.chart.scales[scaleID];
  }
  _getOtherScale(scale) {
    const meta = this._cachedMeta;
    return scale === meta.iScale ? meta.vScale : meta.iScale;
  }
  reset() {
    this._update("reset");
  }
  _destroy() {
    const meta = this._cachedMeta;
    if (this._data) {
      unlistenArrayEvents(this._data, this);
    }
    if (meta._stacked) {
      clearStacks(meta);
    }
  }
  _dataCheck() {
    const dataset = this.getDataset();
    const data = dataset.data || (dataset.data = []);
    const _data = this._data;
    if (isObject(data)) {
      const meta = this._cachedMeta;
      this._data = convertObjectDataToArray(data, meta);
    } else if (_data !== data) {
      if (_data) {
        unlistenArrayEvents(_data, this);
        const meta = this._cachedMeta;
        clearStacks(meta);
        meta._parsed = [];
      }
      if (data && Object.isExtensible(data)) {
        listenArrayEvents(data, this);
      }
      this._syncList = [];
      this._data = data;
    }
  }
  addElements() {
    const meta = this._cachedMeta;
    this._dataCheck();
    if (this.datasetElementType) {
      meta.dataset = new this.datasetElementType();
    }
  }
  buildOrUpdateElements(resetNewElements) {
    const meta = this._cachedMeta;
    const dataset = this.getDataset();
    let stackChanged = false;
    this._dataCheck();
    const oldStacked = meta._stacked;
    meta._stacked = isStacked(meta.vScale, meta);
    if (meta.stack !== dataset.stack) {
      stackChanged = true;
      clearStacks(meta);
      meta.stack = dataset.stack;
    }
    this._resyncElements(resetNewElements);
    if (stackChanged || oldStacked !== meta._stacked) {
      updateStacks(this, meta._parsed);
      meta._stacked = isStacked(meta.vScale, meta);
    }
  }
  configure() {
    const config = this.chart.config;
    const scopeKeys = config.datasetScopeKeys(this._type);
    const scopes = config.getOptionScopes(this.getDataset(), scopeKeys, true);
    this.options = config.createResolver(scopes, this.getContext());
    this._parsing = this.options.parsing;
    this._cachedDataOpts = {};
  }
  parse(start, count) {
    const { _cachedMeta: meta, _data: data } = this;
    const { iScale, _stacked } = meta;
    const iAxis = iScale.axis;
    let sorted = start === 0 && count === data.length ? true : meta._sorted;
    let prev = start > 0 && meta._parsed[start - 1];
    let i, cur, parsed;
    if (this._parsing === false) {
      meta._parsed = data;
      meta._sorted = true;
      parsed = data;
    } else {
      if (isArray(data[start])) {
        parsed = this.parseArrayData(meta, data, start, count);
      } else if (isObject(data[start])) {
        parsed = this.parseObjectData(meta, data, start, count);
      } else {
        parsed = this.parsePrimitiveData(meta, data, start, count);
      }
      const isNotInOrderComparedToPrev = () => cur[iAxis] === null || prev && cur[iAxis] < prev[iAxis];
      for (i = 0; i < count; ++i) {
        meta._parsed[i + start] = cur = parsed[i];
        if (sorted) {
          if (isNotInOrderComparedToPrev()) {
            sorted = false;
          }
          prev = cur;
        }
      }
      meta._sorted = sorted;
    }
    if (_stacked) {
      updateStacks(this, parsed);
    }
  }
  parsePrimitiveData(meta, data, start, count) {
    const { iScale, vScale } = meta;
    const iAxis = iScale.axis;
    const vAxis = vScale.axis;
    const labels = iScale.getLabels();
    const singleScale = iScale === vScale;
    const parsed = new Array(count);
    let i, ilen, index2;
    for (i = 0, ilen = count; i < ilen; ++i) {
      index2 = i + start;
      parsed[i] = {
        [iAxis]: singleScale || iScale.parse(labels[index2], index2),
        [vAxis]: vScale.parse(data[index2], index2)
      };
    }
    return parsed;
  }
  parseArrayData(meta, data, start, count) {
    const { xScale, yScale } = meta;
    const parsed = new Array(count);
    let i, ilen, index2, item;
    for (i = 0, ilen = count; i < ilen; ++i) {
      index2 = i + start;
      item = data[index2];
      parsed[i] = {
        x: xScale.parse(item[0], index2),
        y: yScale.parse(item[1], index2)
      };
    }
    return parsed;
  }
  parseObjectData(meta, data, start, count) {
    const { xScale, yScale } = meta;
    const { xAxisKey = "x", yAxisKey = "y" } = this._parsing;
    const parsed = new Array(count);
    let i, ilen, index2, item;
    for (i = 0, ilen = count; i < ilen; ++i) {
      index2 = i + start;
      item = data[index2];
      parsed[i] = {
        x: xScale.parse(resolveObjectKey(item, xAxisKey), index2),
        y: yScale.parse(resolveObjectKey(item, yAxisKey), index2)
      };
    }
    return parsed;
  }
  getParsed(index2) {
    return this._cachedMeta._parsed[index2];
  }
  getDataElement(index2) {
    return this._cachedMeta.data[index2];
  }
  applyStack(scale, parsed, mode) {
    const chart = this.chart;
    const meta = this._cachedMeta;
    const value = parsed[scale.axis];
    const stack = {
      keys: getSortedDatasetIndices(chart, true),
      values: parsed._stacks[scale.axis]._visualValues
    };
    return applyStack(stack, value, meta.index, {
      mode
    });
  }
  updateRangeFromParsed(range, scale, parsed, stack) {
    const parsedValue = parsed[scale.axis];
    let value = parsedValue === null ? NaN : parsedValue;
    const values = stack && parsed._stacks[scale.axis];
    if (stack && values) {
      stack.values = values;
      value = applyStack(stack, parsedValue, this._cachedMeta.index);
    }
    range.min = Math.min(range.min, value);
    range.max = Math.max(range.max, value);
  }
  getMinMax(scale, canStack) {
    const meta = this._cachedMeta;
    const _parsed = meta._parsed;
    const sorted = meta._sorted && scale === meta.iScale;
    const ilen = _parsed.length;
    const otherScale = this._getOtherScale(scale);
    const stack = createStack(canStack, meta, this.chart);
    const range = {
      min: Number.POSITIVE_INFINITY,
      max: Number.NEGATIVE_INFINITY
    };
    const { min: otherMin, max: otherMax } = getUserBounds(otherScale);
    let i, parsed;
    function _skip() {
      parsed = _parsed[i];
      const otherValue = parsed[otherScale.axis];
      return !isNumberFinite(parsed[scale.axis]) || otherMin > otherValue || otherMax < otherValue;
    }
    for (i = 0; i < ilen; ++i) {
      if (_skip()) {
        continue;
      }
      this.updateRangeFromParsed(range, scale, parsed, stack);
      if (sorted) {
        break;
      }
    }
    if (sorted) {
      for (i = ilen - 1; i >= 0; --i) {
        if (_skip()) {
          continue;
        }
        this.updateRangeFromParsed(range, scale, parsed, stack);
        break;
      }
    }
    return range;
  }
  getAllParsedValues(scale) {
    const parsed = this._cachedMeta._parsed;
    const values = [];
    let i, ilen, value;
    for (i = 0, ilen = parsed.length; i < ilen; ++i) {
      value = parsed[i][scale.axis];
      if (isNumberFinite(value)) {
        values.push(value);
      }
    }
    return values;
  }
  getMaxOverflow() {
    return false;
  }
  getLabelAndValue(index2) {
    const meta = this._cachedMeta;
    const iScale = meta.iScale;
    const vScale = meta.vScale;
    const parsed = this.getParsed(index2);
    return {
      label: iScale ? "" + iScale.getLabelForValue(parsed[iScale.axis]) : "",
      value: vScale ? "" + vScale.getLabelForValue(parsed[vScale.axis]) : ""
    };
  }
  _update(mode) {
    const meta = this._cachedMeta;
    this.update(mode || "default");
    meta._clip = toClip(valueOrDefault(this.options.clip, defaultClip(meta.xScale, meta.yScale, this.getMaxOverflow())));
  }
  update(mode) {
  }
  draw() {
    const ctx = this._ctx;
    const chart = this.chart;
    const meta = this._cachedMeta;
    const elements = meta.data || [];
    const area = chart.chartArea;
    const active = [];
    const start = this._drawStart || 0;
    const count = this._drawCount || elements.length - start;
    const drawActiveElementsOnTop = this.options.drawActiveElementsOnTop;
    let i;
    if (meta.dataset) {
      meta.dataset.draw(ctx, area, start, count);
    }
    for (i = start; i < start + count; ++i) {
      const element = elements[i];
      if (element.hidden) {
        continue;
      }
      if (element.active && drawActiveElementsOnTop) {
        active.push(element);
      } else {
        element.draw(ctx, area);
      }
    }
    for (i = 0; i < active.length; ++i) {
      active[i].draw(ctx, area);
    }
  }
  getStyle(index2, active) {
    const mode = active ? "active" : "default";
    return index2 === void 0 && this._cachedMeta.dataset ? this.resolveDatasetElementOptions(mode) : this.resolveDataElementOptions(index2 || 0, mode);
  }
  getContext(index2, active, mode) {
    const dataset = this.getDataset();
    let context;
    if (index2 >= 0 && index2 < this._cachedMeta.data.length) {
      const element = this._cachedMeta.data[index2];
      context = element.$context || (element.$context = createDataContext(this.getContext(), index2, element));
      context.parsed = this.getParsed(index2);
      context.raw = dataset.data[index2];
      context.index = context.dataIndex = index2;
    } else {
      context = this.$context || (this.$context = createDatasetContext(this.chart.getContext(), this.index));
      context.dataset = dataset;
      context.index = context.datasetIndex = this.index;
    }
    context.active = !!active;
    context.mode = mode;
    return context;
  }
  resolveDatasetElementOptions(mode) {
    return this._resolveElementOptions(this.datasetElementType.id, mode);
  }
  resolveDataElementOptions(index2, mode) {
    return this._resolveElementOptions(this.dataElementType.id, mode, index2);
  }
  _resolveElementOptions(elementType, mode = "default", index2) {
    const active = mode === "active";
    const cache = this._cachedDataOpts;
    const cacheKey = elementType + "-" + mode;
    const cached = cache[cacheKey];
    const sharing = this.enableOptionSharing && defined(index2);
    if (cached) {
      return cloneIfNotShared(cached, sharing);
    }
    const config = this.chart.config;
    const scopeKeys = config.datasetElementScopeKeys(this._type, elementType);
    const prefixes = active ? [
      `${elementType}Hover`,
      "hover",
      elementType,
      ""
    ] : [
      elementType,
      ""
    ];
    const scopes = config.getOptionScopes(this.getDataset(), scopeKeys);
    const names2 = Object.keys(defaults.elements[elementType]);
    const context = () => this.getContext(index2, active, mode);
    const values = config.resolveNamedOptions(scopes, names2, context, prefixes);
    if (values.$shared) {
      values.$shared = sharing;
      cache[cacheKey] = Object.freeze(cloneIfNotShared(values, sharing));
    }
    return values;
  }
  _resolveAnimations(index2, transition, active) {
    const chart = this.chart;
    const cache = this._cachedDataOpts;
    const cacheKey = `animation-${transition}`;
    const cached = cache[cacheKey];
    if (cached) {
      return cached;
    }
    let options;
    if (chart.options.animation !== false) {
      const config = this.chart.config;
      const scopeKeys = config.datasetAnimationScopeKeys(this._type, transition);
      const scopes = config.getOptionScopes(this.getDataset(), scopeKeys);
      options = config.createResolver(scopes, this.getContext(index2, active, transition));
    }
    const animations = new Animations(chart, options && options.animations);
    if (options && options._cacheable) {
      cache[cacheKey] = Object.freeze(animations);
    }
    return animations;
  }
  getSharedOptions(options) {
    if (!options.$shared) {
      return;
    }
    return this._sharedOptions || (this._sharedOptions = Object.assign({}, options));
  }
  includeOptions(mode, sharedOptions) {
    return !sharedOptions || isDirectUpdateMode(mode) || this.chart._animationsDisabled;
  }
  _getSharedOptions(start, mode) {
    const firstOpts = this.resolveDataElementOptions(start, mode);
    const previouslySharedOptions = this._sharedOptions;
    const sharedOptions = this.getSharedOptions(firstOpts);
    const includeOptions = this.includeOptions(mode, sharedOptions) || sharedOptions !== previouslySharedOptions;
    this.updateSharedOptions(sharedOptions, mode, firstOpts);
    return {
      sharedOptions,
      includeOptions
    };
  }
  updateElement(element, index2, properties, mode) {
    if (isDirectUpdateMode(mode)) {
      Object.assign(element, properties);
    } else {
      this._resolveAnimations(index2, mode).update(element, properties);
    }
  }
  updateSharedOptions(sharedOptions, mode, newOptions) {
    if (sharedOptions && !isDirectUpdateMode(mode)) {
      this._resolveAnimations(void 0, mode).update(sharedOptions, newOptions);
    }
  }
  _setStyle(element, index2, mode, active) {
    element.active = active;
    const options = this.getStyle(index2, active);
    this._resolveAnimations(index2, mode, active).update(element, {
      options: !active && this.getSharedOptions(options) || options
    });
  }
  removeHoverStyle(element, datasetIndex, index2) {
    this._setStyle(element, index2, "active", false);
  }
  setHoverStyle(element, datasetIndex, index2) {
    this._setStyle(element, index2, "active", true);
  }
  _removeDatasetHoverStyle() {
    const element = this._cachedMeta.dataset;
    if (element) {
      this._setStyle(element, void 0, "active", false);
    }
  }
  _setDatasetHoverStyle() {
    const element = this._cachedMeta.dataset;
    if (element) {
      this._setStyle(element, void 0, "active", true);
    }
  }
  _resyncElements(resetNewElements) {
    const data = this._data;
    const elements = this._cachedMeta.data;
    for (const [method, arg1, arg2] of this._syncList) {
      this[method](arg1, arg2);
    }
    this._syncList = [];
    const numMeta = elements.length;
    const numData = data.length;
    const count = Math.min(numData, numMeta);
    if (count) {
      this.parse(0, count);
    }
    if (numData > numMeta) {
      this._insertElements(numMeta, numData - numMeta, resetNewElements);
    } else if (numData < numMeta) {
      this._removeElements(numData, numMeta - numData);
    }
  }
  _insertElements(start, count, resetNewElements = true) {
    const meta = this._cachedMeta;
    const data = meta.data;
    const end = start + count;
    let i;
    const move = (arr) => {
      arr.length += count;
      for (i = arr.length - 1; i >= end; i--) {
        arr[i] = arr[i - count];
      }
    };
    move(data);
    for (i = start; i < end; ++i) {
      data[i] = new this.dataElementType();
    }
    if (this._parsing) {
      move(meta._parsed);
    }
    this.parse(start, count);
    if (resetNewElements) {
      this.updateElements(data, start, count, "reset");
    }
  }
  updateElements(element, start, count, mode) {
  }
  _removeElements(start, count) {
    const meta = this._cachedMeta;
    if (this._parsing) {
      const removed = meta._parsed.splice(start, count);
      if (meta._stacked) {
        clearStacks(meta, removed);
      }
    }
    meta.data.splice(start, count);
  }
  _sync(args) {
    if (this._parsing) {
      this._syncList.push(args);
    } else {
      const [method, arg1, arg2] = args;
      this[method](arg1, arg2);
    }
    this.chart._dataChanges.push([
      this.index,
      ...args
    ]);
  }
  _onDataPush() {
    const count = arguments.length;
    this._sync([
      "_insertElements",
      this.getDataset().data.length - count,
      count
    ]);
  }
  _onDataPop() {
    this._sync([
      "_removeElements",
      this._cachedMeta.data.length - 1,
      1
    ]);
  }
  _onDataShift() {
    this._sync([
      "_removeElements",
      0,
      1
    ]);
  }
  _onDataSplice(start, count) {
    if (count) {
      this._sync([
        "_removeElements",
        start,
        count
      ]);
    }
    const newCount = arguments.length - 2;
    if (newCount) {
      this._sync([
        "_insertElements",
        start,
        newCount
      ]);
    }
  }
  _onDataUnshift() {
    this._sync([
      "_insertElements",
      0,
      arguments.length
    ]);
  }
};
var LineController = class extends DatasetController {
  static id = "line";
  static defaults = {
    datasetElementType: "line",
    dataElementType: "point",
    showLine: true,
    spanGaps: false
  };
  static overrides = {
    scales: {
      _index_: {
        type: "category"
      },
      _value_: {
        type: "linear"
      }
    }
  };
  initialize() {
    this.enableOptionSharing = true;
    this.supportsDecimation = true;
    super.initialize();
  }
  update(mode) {
    const meta = this._cachedMeta;
    const { dataset: line, data: points = [], _dataset } = meta;
    const animationsDisabled = this.chart._animationsDisabled;
    let { start, count } = _getStartAndCountOfVisiblePoints(meta, points, animationsDisabled);
    this._drawStart = start;
    this._drawCount = count;
    if (_scaleRangesChanged(meta)) {
      start = 0;
      count = points.length;
    }
    line._chart = this.chart;
    line._datasetIndex = this.index;
    line._decimated = !!_dataset._decimated;
    line.points = points;
    const options = this.resolveDatasetElementOptions(mode);
    if (!this.options.showLine) {
      options.borderWidth = 0;
    }
    options.segment = this.options.segment;
    this.updateElement(line, void 0, {
      animated: !animationsDisabled,
      options
    }, mode);
    this.updateElements(points, start, count, mode);
  }
  updateElements(points, start, count, mode) {
    const reset = mode === "reset";
    const { iScale, vScale, _stacked, _dataset } = this._cachedMeta;
    const { sharedOptions, includeOptions } = this._getSharedOptions(start, mode);
    const iAxis = iScale.axis;
    const vAxis = vScale.axis;
    const { spanGaps, segment } = this.options;
    const maxGapLength = isNumber(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;
    const directUpdate = this.chart._animationsDisabled || reset || mode === "none";
    const end = start + count;
    const pointsCount = points.length;
    let prevParsed = start > 0 && this.getParsed(start - 1);
    for (let i = 0; i < pointsCount; ++i) {
      const point = points[i];
      const properties = directUpdate ? point : {};
      if (i < start || i >= end) {
        properties.skip = true;
        continue;
      }
      const parsed = this.getParsed(i);
      const nullData = isNullOrUndef(parsed[vAxis]);
      const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);
      const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? this.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);
      properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;
      properties.stop = i > 0 && Math.abs(parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;
      if (segment) {
        properties.parsed = parsed;
        properties.raw = _dataset.data[i];
      }
      if (includeOptions) {
        properties.options = sharedOptions || this.resolveDataElementOptions(i, point.active ? "active" : mode);
      }
      if (!directUpdate) {
        this.updateElement(point, i, properties, mode);
      }
      prevParsed = parsed;
    }
  }
  getMaxOverflow() {
    const meta = this._cachedMeta;
    const dataset = meta.dataset;
    const border = dataset.options && dataset.options.borderWidth || 0;
    const data = meta.data || [];
    if (!data.length) {
      return border;
    }
    const firstPoint = data[0].size(this.resolveDataElementOptions(0));
    const lastPoint = data[data.length - 1].size(this.resolveDataElementOptions(data.length - 1));
    return Math.max(border, firstPoint, lastPoint) / 2;
  }
  draw() {
    const meta = this._cachedMeta;
    meta.dataset.updateControlPoints(this.chart.chartArea, meta.iScale.axis);
    super.draw();
  }
};
function abstract() {
  throw new Error("This method is not implemented: Check that a complete date adapter is provided.");
}
var DateAdapterBase = class _DateAdapterBase {
  /**
  * Override default date adapter methods.
  * Accepts type parameter to define options type.
  * @example
  * Chart._adapters._date.override<{myAdapterOption: string}>({
  *   init() {
  *     console.log(this.options.myAdapterOption);
  *   }
  * })
  */
  static override(members) {
    Object.assign(_DateAdapterBase.prototype, members);
  }
  options;
  constructor(options) {
    this.options = options || {};
  }
  // eslint-disable-next-line @typescript-eslint/no-empty-function
  init() {
  }
  formats() {
    return abstract();
  }
  parse() {
    return abstract();
  }
  format() {
    return abstract();
  }
  add() {
    return abstract();
  }
  diff() {
    return abstract();
  }
  startOf() {
    return abstract();
  }
  endOf() {
    return abstract();
  }
};
var adapters = {
  _date: DateAdapterBase
};
function binarySearch(metaset, axis, value, intersect) {
  const { controller, data, _sorted } = metaset;
  const iScale = controller._cachedMeta.iScale;
  if (iScale && axis === iScale.axis && axis !== "r" && _sorted && data.length) {
    const lookupMethod = iScale._reversePixels ? _rlookupByKey : _lookupByKey;
    if (!intersect) {
      return lookupMethod(data, axis, value);
    } else if (controller._sharedOptions) {
      const el = data[0];
      const range = typeof el.getRange === "function" && el.getRange(axis);
      if (range) {
        const start = lookupMethod(data, axis, value - range);
        const end = lookupMethod(data, axis, value + range);
        return {
          lo: start.lo,
          hi: end.hi
        };
      }
    }
  }
  return {
    lo: 0,
    hi: data.length - 1
  };
}
function evaluateInteractionItems(chart, axis, position, handler, intersect) {
  const metasets = chart.getSortedVisibleDatasetMetas();
  const value = position[axis];
  for (let i = 0, ilen = metasets.length; i < ilen; ++i) {
    const { index: index2, data } = metasets[i];
    const { lo, hi } = binarySearch(metasets[i], axis, value, intersect);
    for (let j = lo; j <= hi; ++j) {
      const element = data[j];
      if (!element.skip) {
        handler(element, index2, j);
      }
    }
  }
}
function getDistanceMetricForAxis(axis) {
  const useX = axis.indexOf("x") !== -1;
  const useY = axis.indexOf("y") !== -1;
  return function(pt1, pt2) {
    const deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;
    const deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;
    return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
  };
}
function getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) {
  const items = [];
  if (!includeInvisible && !chart.isPointInArea(position)) {
    return items;
  }
  const evaluationFunc = function(element, datasetIndex, index2) {
    if (!includeInvisible && !_isPointInArea(element, chart.chartArea, 0)) {
      return;
    }
    if (element.inRange(position.x, position.y, useFinalPosition)) {
      items.push({
        element,
        datasetIndex,
        index: index2
      });
    }
  };
  evaluateInteractionItems(chart, axis, position, evaluationFunc, true);
  return items;
}
function getNearestRadialItems(chart, position, axis, useFinalPosition) {
  let items = [];
  function evaluationFunc(element, datasetIndex, index2) {
    const { startAngle, endAngle } = element.getProps([
      "startAngle",
      "endAngle"
    ], useFinalPosition);
    const { angle } = getAngleFromPoint(element, {
      x: position.x,
      y: position.y
    });
    if (_angleBetween(angle, startAngle, endAngle)) {
      items.push({
        element,
        datasetIndex,
        index: index2
      });
    }
  }
  evaluateInteractionItems(chart, axis, position, evaluationFunc);
  return items;
}
function getNearestCartesianItems(chart, position, axis, intersect, useFinalPosition, includeInvisible) {
  let items = [];
  const distanceMetric = getDistanceMetricForAxis(axis);
  let minDistance = Number.POSITIVE_INFINITY;
  function evaluationFunc(element, datasetIndex, index2) {
    const inRange = element.inRange(position.x, position.y, useFinalPosition);
    if (intersect && !inRange) {
      return;
    }
    const center = element.getCenterPoint(useFinalPosition);
    const pointInArea = !!includeInvisible || chart.isPointInArea(center);
    if (!pointInArea && !inRange) {
      return;
    }
    const distance = distanceMetric(position, center);
    if (distance < minDistance) {
      items = [
        {
          element,
          datasetIndex,
          index: index2
        }
      ];
      minDistance = distance;
    } else if (distance === minDistance) {
      items.push({
        element,
        datasetIndex,
        index: index2
      });
    }
  }
  evaluateInteractionItems(chart, axis, position, evaluationFunc);
  return items;
}
function getNearestItems(chart, position, axis, intersect, useFinalPosition, includeInvisible) {
  if (!includeInvisible && !chart.isPointInArea(position)) {
    return [];
  }
  return axis === "r" && !intersect ? getNearestRadialItems(chart, position, axis, useFinalPosition) : getNearestCartesianItems(chart, position, axis, intersect, useFinalPosition, includeInvisible);
}
function getAxisItems(chart, position, axis, intersect, useFinalPosition) {
  const items = [];
  const rangeMethod = axis === "x" ? "inXRange" : "inYRange";
  let intersectsItem = false;
  evaluateInteractionItems(chart, axis, position, (element, datasetIndex, index2) => {
    if (element[rangeMethod] && element[rangeMethod](position[axis], useFinalPosition)) {
      items.push({
        element,
        datasetIndex,
        index: index2
      });
      intersectsItem = intersectsItem || element.inRange(position.x, position.y, useFinalPosition);
    }
  });
  if (intersect && !intersectsItem) {
    return [];
  }
  return items;
}
var Interaction = {
  evaluateInteractionItems,
  modes: {
    index(chart, e, options, useFinalPosition) {
      const position = getRelativePosition(e, chart);
      const axis = options.axis || "x";
      const includeInvisible = options.includeInvisible || false;
      const items = options.intersect ? getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) : getNearestItems(chart, position, axis, false, useFinalPosition, includeInvisible);
      const elements = [];
      if (!items.length) {
        return [];
      }
      chart.getSortedVisibleDatasetMetas().forEach((meta) => {
        const index2 = items[0].index;
        const element = meta.data[index2];
        if (element && !element.skip) {
          elements.push({
            element,
            datasetIndex: meta.index,
            index: index2
          });
        }
      });
      return elements;
    },
    dataset(chart, e, options, useFinalPosition) {
      const position = getRelativePosition(e, chart);
      const axis = options.axis || "xy";
      const includeInvisible = options.includeInvisible || false;
      let items = options.intersect ? getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible) : getNearestItems(chart, position, axis, false, useFinalPosition, includeInvisible);
      if (items.length > 0) {
        const datasetIndex = items[0].datasetIndex;
        const data = chart.getDatasetMeta(datasetIndex).data;
        items = [];
        for (let i = 0; i < data.length; ++i) {
          items.push({
            element: data[i],
            datasetIndex,
            index: i
          });
        }
      }
      return items;
    },
    point(chart, e, options, useFinalPosition) {
      const position = getRelativePosition(e, chart);
      const axis = options.axis || "xy";
      const includeInvisible = options.includeInvisible || false;
      return getIntersectItems(chart, position, axis, useFinalPosition, includeInvisible);
    },
    nearest(chart, e, options, useFinalPosition) {
      const position = getRelativePosition(e, chart);
      const axis = options.axis || "xy";
      const includeInvisible = options.includeInvisible || false;
      return getNearestItems(chart, position, axis, options.intersect, useFinalPosition, includeInvisible);
    },
    x(chart, e, options, useFinalPosition) {
      const position = getRelativePosition(e, chart);
      return getAxisItems(chart, position, "x", options.intersect, useFinalPosition);
    },
    y(chart, e, options, useFinalPosition) {
      const position = getRelativePosition(e, chart);
      return getAxisItems(chart, position, "y", options.intersect, useFinalPosition);
    }
  }
};
var STATIC_POSITIONS = [
  "left",
  "top",
  "right",
  "bottom"
];
function filterByPosition(array, position) {
  return array.filter((v) => v.pos === position);
}
function filterDynamicPositionByAxis(array, axis) {
  return array.filter((v) => STATIC_POSITIONS.indexOf(v.pos) === -1 && v.box.axis === axis);
}
function sortByWeight(array, reverse) {
  return array.sort((a, b) => {
    const v0 = reverse ? b : a;
    const v1 = reverse ? a : b;
    return v0.weight === v1.weight ? v0.index - v1.index : v0.weight - v1.weight;
  });
}
function wrapBoxes(boxes) {
  const layoutBoxes = [];
  let i, ilen, box, pos, stack, stackWeight;
  for (i = 0, ilen = (boxes || []).length; i < ilen; ++i) {
    box = boxes[i];
    ({ position: pos, options: { stack, stackWeight = 1 } } = box);
    layoutBoxes.push({
      index: i,
      box,
      pos,
      horizontal: box.isHorizontal(),
      weight: box.weight,
      stack: stack && pos + stack,
      stackWeight
    });
  }
  return layoutBoxes;
}
function buildStacks(layouts2) {
  const stacks = {};
  for (const wrap of layouts2) {
    const { stack, pos, stackWeight } = wrap;
    if (!stack || !STATIC_POSITIONS.includes(pos)) {
      continue;
    }
    const _stack = stacks[stack] || (stacks[stack] = {
      count: 0,
      placed: 0,
      weight: 0,
      size: 0
    });
    _stack.count++;
    _stack.weight += stackWeight;
  }
  return stacks;
}
function setLayoutDims(layouts2, params) {
  const stacks = buildStacks(layouts2);
  const { vBoxMaxWidth, hBoxMaxHeight } = params;
  let i, ilen, layout;
  for (i = 0, ilen = layouts2.length; i < ilen; ++i) {
    layout = layouts2[i];
    const { fullSize } = layout.box;
    const stack = stacks[layout.stack];
    const factor = stack && layout.stackWeight / stack.weight;
    if (layout.horizontal) {
      layout.width = factor ? factor * vBoxMaxWidth : fullSize && params.availableWidth;
      layout.height = hBoxMaxHeight;
    } else {
      layout.width = vBoxMaxWidth;
      layout.height = factor ? factor * hBoxMaxHeight : fullSize && params.availableHeight;
    }
  }
  return stacks;
}
function buildLayoutBoxes(boxes) {
  const layoutBoxes = wrapBoxes(boxes);
  const fullSize = sortByWeight(layoutBoxes.filter((wrap) => wrap.box.fullSize), true);
  const left = sortByWeight(filterByPosition(layoutBoxes, "left"), true);
  const right = sortByWeight(filterByPosition(layoutBoxes, "right"));
  const top = sortByWeight(filterByPosition(layoutBoxes, "top"), true);
  const bottom = sortByWeight(filterByPosition(layoutBoxes, "bottom"));
  const centerHorizontal = filterDynamicPositionByAxis(layoutBoxes, "x");
  const centerVertical = filterDynamicPositionByAxis(layoutBoxes, "y");
  return {
    fullSize,
    leftAndTop: left.concat(top),
    rightAndBottom: right.concat(centerVertical).concat(bottom).concat(centerHorizontal),
    chartArea: filterByPosition(layoutBoxes, "chartArea"),
    vertical: left.concat(right).concat(centerVertical),
    horizontal: top.concat(bottom).concat(centerHorizontal)
  };
}
function getCombinedMax(maxPadding, chartArea, a, b) {
  return Math.max(maxPadding[a], chartArea[a]) + Math.max(maxPadding[b], chartArea[b]);
}
function updateMaxPadding(maxPadding, boxPadding) {
  maxPadding.top = Math.max(maxPadding.top, boxPadding.top);
  maxPadding.left = Math.max(maxPadding.left, boxPadding.left);
  maxPadding.bottom = Math.max(maxPadding.bottom, boxPadding.bottom);
  maxPadding.right = Math.max(maxPadding.right, boxPadding.right);
}
function updateDims(chartArea, params, layout, stacks) {
  const { pos, box } = layout;
  const maxPadding = chartArea.maxPadding;
  if (!isObject(pos)) {
    if (layout.size) {
      chartArea[pos] -= layout.size;
    }
    const stack = stacks[layout.stack] || {
      size: 0,
      count: 1
    };
    stack.size = Math.max(stack.size, layout.horizontal ? box.height : box.width);
    layout.size = stack.size / stack.count;
    chartArea[pos] += layout.size;
  }
  if (box.getPadding) {
    updateMaxPadding(maxPadding, box.getPadding());
  }
  const newWidth = Math.max(0, params.outerWidth - getCombinedMax(maxPadding, chartArea, "left", "right"));
  const newHeight = Math.max(0, params.outerHeight - getCombinedMax(maxPadding, chartArea, "top", "bottom"));
  const widthChanged = newWidth !== chartArea.w;
  const heightChanged = newHeight !== chartArea.h;
  chartArea.w = newWidth;
  chartArea.h = newHeight;
  return layout.horizontal ? {
    same: widthChanged,
    other: heightChanged
  } : {
    same: heightChanged,
    other: widthChanged
  };
}
function handleMaxPadding(chartArea) {
  const maxPadding = chartArea.maxPadding;
  function updatePos(pos) {
    const change = Math.max(maxPadding[pos] - chartArea[pos], 0);
    chartArea[pos] += change;
    return change;
  }
  chartArea.y += updatePos("top");
  chartArea.x += updatePos("left");
  updatePos("right");
  updatePos("bottom");
}
function getMargins(horizontal, chartArea) {
  const maxPadding = chartArea.maxPadding;
  function marginForPositions(positions2) {
    const margin = {
      left: 0,
      top: 0,
      right: 0,
      bottom: 0
    };
    positions2.forEach((pos) => {
      margin[pos] = Math.max(chartArea[pos], maxPadding[pos]);
    });
    return margin;
  }
  return horizontal ? marginForPositions([
    "left",
    "right"
  ]) : marginForPositions([
    "top",
    "bottom"
  ]);
}
function fitBoxes(boxes, chartArea, params, stacks) {
  const refitBoxes = [];
  let i, ilen, layout, box, refit, changed;
  for (i = 0, ilen = boxes.length, refit = 0; i < ilen; ++i) {
    layout = boxes[i];
    box = layout.box;
    box.update(layout.width || chartArea.w, layout.height || chartArea.h, getMargins(layout.horizontal, chartArea));
    const { same, other } = updateDims(chartArea, params, layout, stacks);
    refit |= same && refitBoxes.length;
    changed = changed || other;
    if (!box.fullSize) {
      refitBoxes.push(layout);
    }
  }
  return refit && fitBoxes(refitBoxes, chartArea, params, stacks) || changed;
}
function setBoxDims(box, left, top, width, height) {
  box.top = top;
  box.left = left;
  box.right = left + width;
  box.bottom = top + height;
  box.width = width;
  box.height = height;
}
function placeBoxes(boxes, chartArea, params, stacks) {
  const userPadding = params.padding;
  let { x, y } = chartArea;
  for (const layout of boxes) {
    const box = layout.box;
    const stack = stacks[layout.stack] || {
      count: 1,
      placed: 0,
      weight: 1
    };
    const weight = layout.stackWeight / stack.weight || 1;
    if (layout.horizontal) {
      const width = chartArea.w * weight;
      const height = stack.size || box.height;
      if (defined(stack.start)) {
        y = stack.start;
      }
      if (box.fullSize) {
        setBoxDims(box, userPadding.left, y, params.outerWidth - userPadding.right - userPadding.left, height);
      } else {
        setBoxDims(box, chartArea.left + stack.placed, y, width, height);
      }
      stack.start = y;
      stack.placed += width;
      y = box.bottom;
    } else {
      const height = chartArea.h * weight;
      const width = stack.size || box.width;
      if (defined(stack.start)) {
        x = stack.start;
      }
      if (box.fullSize) {
        setBoxDims(box, x, userPadding.top, width, params.outerHeight - userPadding.bottom - userPadding.top);
      } else {
        setBoxDims(box, x, chartArea.top + stack.placed, width, height);
      }
      stack.start = x;
      stack.placed += height;
      x = box.right;
    }
  }
  chartArea.x = x;
  chartArea.y = y;
}
var layouts = {
  addBox(chart, item) {
    if (!chart.boxes) {
      chart.boxes = [];
    }
    item.fullSize = item.fullSize || false;
    item.position = item.position || "top";
    item.weight = item.weight || 0;
    item._layers = item._layers || function() {
      return [
        {
          z: 0,
          draw(chartArea) {
            item.draw(chartArea);
          }
        }
      ];
    };
    chart.boxes.push(item);
  },
  removeBox(chart, layoutItem) {
    const index2 = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;
    if (index2 !== -1) {
      chart.boxes.splice(index2, 1);
    }
  },
  configure(chart, item, options) {
    item.fullSize = options.fullSize;
    item.position = options.position;
    item.weight = options.weight;
  },
  update(chart, width, height, minPadding) {
    if (!chart) {
      return;
    }
    const padding = toPadding(chart.options.layout.padding);
    const availableWidth = Math.max(width - padding.width, 0);
    const availableHeight = Math.max(height - padding.height, 0);
    const boxes = buildLayoutBoxes(chart.boxes);
    const verticalBoxes = boxes.vertical;
    const horizontalBoxes = boxes.horizontal;
    each(chart.boxes, (box) => {
      if (typeof box.beforeLayout === "function") {
        box.beforeLayout();
      }
    });
    const visibleVerticalBoxCount = verticalBoxes.reduce((total, wrap) => wrap.box.options && wrap.box.options.display === false ? total : total + 1, 0) || 1;
    const params = Object.freeze({
      outerWidth: width,
      outerHeight: height,
      padding,
      availableWidth,
      availableHeight,
      vBoxMaxWidth: availableWidth / 2 / visibleVerticalBoxCount,
      hBoxMaxHeight: availableHeight / 2
    });
    const maxPadding = Object.assign({}, padding);
    updateMaxPadding(maxPadding, toPadding(minPadding));
    const chartArea = Object.assign({
      maxPadding,
      w: availableWidth,
      h: availableHeight,
      x: padding.left,
      y: padding.top
    }, padding);
    const stacks = setLayoutDims(verticalBoxes.concat(horizontalBoxes), params);
    fitBoxes(boxes.fullSize, chartArea, params, stacks);
    fitBoxes(verticalBoxes, chartArea, params, stacks);
    if (fitBoxes(horizontalBoxes, chartArea, params, stacks)) {
      fitBoxes(verticalBoxes, chartArea, params, stacks);
    }
    handleMaxPadding(chartArea);
    placeBoxes(boxes.leftAndTop, chartArea, params, stacks);
    chartArea.x += chartArea.w;
    chartArea.y += chartArea.h;
    placeBoxes(boxes.rightAndBottom, chartArea, params, stacks);
    chart.chartArea = {
      left: chartArea.left,
      top: chartArea.top,
      right: chartArea.left + chartArea.w,
      bottom: chartArea.top + chartArea.h,
      height: chartArea.h,
      width: chartArea.w
    };
    each(boxes.chartArea, (layout) => {
      const box = layout.box;
      Object.assign(box, chart.chartArea);
      box.update(chartArea.w, chartArea.h, {
        left: 0,
        top: 0,
        right: 0,
        bottom: 0
      });
    });
  }
};
var BasePlatform = class {
  acquireContext(canvas, aspectRatio) {
  }
  releaseContext(context) {
    return false;
  }
  addEventListener(chart, type, listener) {
  }
  removeEventListener(chart, type, listener) {
  }
  getDevicePixelRatio() {
    return 1;
  }
  getMaximumSize(element, width, height, aspectRatio) {
    width = Math.max(0, width || element.width);
    height = height || element.height;
    return {
      width,
      height: Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height)
    };
  }
  isAttached(canvas) {
    return true;
  }
  updateConfig(config) {
  }
};
var BasicPlatform = class extends BasePlatform {
  acquireContext(item) {
    return item && item.getContext && item.getContext("2d") || null;
  }
  updateConfig(config) {
    config.options.animation = false;
  }
};
var EXPANDO_KEY = "$chartjs";
var EVENT_TYPES = {
  touchstart: "mousedown",
  touchmove: "mousemove",
  touchend: "mouseup",
  pointerenter: "mouseenter",
  pointerdown: "mousedown",
  pointermove: "mousemove",
  pointerup: "mouseup",
  pointerleave: "mouseout",
  pointerout: "mouseout"
};
var isNullOrEmpty = (value) => value === null || value === "";
function initCanvas(canvas, aspectRatio) {
  const style = canvas.style;
  const renderHeight = canvas.getAttribute("height");
  const renderWidth = canvas.getAttribute("width");
  canvas[EXPANDO_KEY] = {
    initial: {
      height: renderHeight,
      width: renderWidth,
      style: {
        display: style.display,
        height: style.height,
        width: style.width
      }
    }
  };
  style.display = style.display || "block";
  style.boxSizing = style.boxSizing || "border-box";
  if (isNullOrEmpty(renderWidth)) {
    const displayWidth = readUsedSize(canvas, "width");
    if (displayWidth !== void 0) {
      canvas.width = displayWidth;
    }
  }
  if (isNullOrEmpty(renderHeight)) {
    if (canvas.style.height === "") {
      canvas.height = canvas.width / (aspectRatio || 2);
    } else {
      const displayHeight = readUsedSize(canvas, "height");
      if (displayHeight !== void 0) {
        canvas.height = displayHeight;
      }
    }
  }
  return canvas;
}
var eventListenerOptions = supportsEventListenerOptions ? {
  passive: true
} : false;
function addListener(node, type, listener) {
  if (node) {
    node.addEventListener(type, listener, eventListenerOptions);
  }
}
function removeListener(chart, type, listener) {
  if (chart && chart.canvas) {
    chart.canvas.removeEventListener(type, listener, eventListenerOptions);
  }
}
function fromNativeEvent(event, chart) {
  const type = EVENT_TYPES[event.type] || event.type;
  const { x, y } = getRelativePosition(event, chart);
  return {
    type,
    chart,
    native: event,
    x: x !== void 0 ? x : null,
    y: y !== void 0 ? y : null
  };
}
function nodeListContains(nodeList, canvas) {
  for (const node of nodeList) {
    if (node === canvas || node.contains(canvas)) {
      return true;
    }
  }
}
function createAttachObserver(chart, type, listener) {
  const canvas = chart.canvas;
  const observer = new MutationObserver((entries) => {
    let trigger = false;
    for (const entry of entries) {
      trigger = trigger || nodeListContains(entry.addedNodes, canvas);
      trigger = trigger && !nodeListContains(entry.removedNodes, canvas);
    }
    if (trigger) {
      listener();
    }
  });
  observer.observe(document, {
    childList: true,
    subtree: true
  });
  return observer;
}
function createDetachObserver(chart, type, listener) {
  const canvas = chart.canvas;
  const observer = new MutationObserver((entries) => {
    let trigger = false;
    for (const entry of entries) {
      trigger = trigger || nodeListContains(entry.removedNodes, canvas);
      trigger = trigger && !nodeListContains(entry.addedNodes, canvas);
    }
    if (trigger) {
      listener();
    }
  });
  observer.observe(document, {
    childList: true,
    subtree: true
  });
  return observer;
}
var drpListeningCharts = /* @__PURE__ */ new Map();
var oldDevicePixelRatio = 0;
function onWindowResize() {
  const dpr = window.devicePixelRatio;
  if (dpr === oldDevicePixelRatio) {
    return;
  }
  oldDevicePixelRatio = dpr;
  drpListeningCharts.forEach((resize, chart) => {
    if (chart.currentDevicePixelRatio !== dpr) {
      resize();
    }
  });
}
function listenDevicePixelRatioChanges(chart, resize) {
  if (!drpListeningCharts.size) {
    window.addEventListener("resize", onWindowResize);
  }
  drpListeningCharts.set(chart, resize);
}
function unlistenDevicePixelRatioChanges(chart) {
  drpListeningCharts.delete(chart);
  if (!drpListeningCharts.size) {
    window.removeEventListener("resize", onWindowResize);
  }
}
function createResizeObserver(chart, type, listener) {
  const canvas = chart.canvas;
  const container = canvas && _getParentNode(canvas);
  if (!container) {
    return;
  }
  const resize = throttled((width, height) => {
    const w = container.clientWidth;
    listener(width, height);
    if (w < container.clientWidth) {
      listener();
    }
  }, window);
  const observer = new ResizeObserver((entries) => {
    const entry = entries[0];
    const width = entry.contentRect.width;
    const height = entry.contentRect.height;
    if (width === 0 && height === 0) {
      return;
    }
    resize(width, height);
  });
  observer.observe(container);
  listenDevicePixelRatioChanges(chart, resize);
  return observer;
}
function releaseObserver(chart, type, observer) {
  if (observer) {
    observer.disconnect();
  }
  if (type === "resize") {
    unlistenDevicePixelRatioChanges(chart);
  }
}
function createProxyAndListen(chart, type, listener) {
  const canvas = chart.canvas;
  const proxy = throttled((event) => {
    if (chart.ctx !== null) {
      listener(fromNativeEvent(event, chart));
    }
  }, chart);
  addListener(canvas, type, proxy);
  return proxy;
}
var DomPlatform = class extends BasePlatform {
  acquireContext(canvas, aspectRatio) {
    const context = canvas && canvas.getContext && canvas.getContext("2d");
    if (context && context.canvas === canvas) {
      initCanvas(canvas, aspectRatio);
      return context;
    }
    return null;
  }
  releaseContext(context) {
    const canvas = context.canvas;
    if (!canvas[EXPANDO_KEY]) {
      return false;
    }
    const initial = canvas[EXPANDO_KEY].initial;
    [
      "height",
      "width"
    ].forEach((prop) => {
      const value = initial[prop];
      if (isNullOrUndef(value)) {
        canvas.removeAttribute(prop);
      } else {
        canvas.setAttribute(prop, value);
      }
    });
    const style = initial.style || {};
    Object.keys(style).forEach((key) => {
      canvas.style[key] = style[key];
    });
    canvas.width = canvas.width;
    delete canvas[EXPANDO_KEY];
    return true;
  }
  addEventListener(chart, type, listener) {
    this.removeEventListener(chart, type);
    const proxies = chart.$proxies || (chart.$proxies = {});
    const handlers = {
      attach: createAttachObserver,
      detach: createDetachObserver,
      resize: createResizeObserver
    };
    const handler = handlers[type] || createProxyAndListen;
    proxies[type] = handler(chart, type, listener);
  }
  removeEventListener(chart, type) {
    const proxies = chart.$proxies || (chart.$proxies = {});
    const proxy = proxies[type];
    if (!proxy) {
      return;
    }
    const handlers = {
      attach: releaseObserver,
      detach: releaseObserver,
      resize: releaseObserver
    };
    const handler = handlers[type] || removeListener;
    handler(chart, type, proxy);
    proxies[type] = void 0;
  }
  getDevicePixelRatio() {
    return window.devicePixelRatio;
  }
  getMaximumSize(canvas, width, height, aspectRatio) {
    return getMaximumSize(canvas, width, height, aspectRatio);
  }
  isAttached(canvas) {
    const container = canvas && _getParentNode(canvas);
    return !!(container && container.isConnected);
  }
};
function _detectPlatform(canvas) {
  if (!_isDomSupported() || typeof OffscreenCanvas !== "undefined" && canvas instanceof OffscreenCanvas) {
    return BasicPlatform;
  }
  return DomPlatform;
}
var Element = class {
  static defaults = {};
  static defaultRoutes = void 0;
  x;
  y;
  active = false;
  options;
  $animations;
  tooltipPosition(useFinalPosition) {
    const { x, y } = this.getProps([
      "x",
      "y"
    ], useFinalPosition);
    return {
      x,
      y
    };
  }
  hasValue() {
    return isNumber(this.x) && isNumber(this.y);
  }
  getProps(props, final) {
    const anims = this.$animations;
    if (!final || !anims) {
      return this;
    }
    const ret = {};
    props.forEach((prop) => {
      ret[prop] = anims[prop] && anims[prop].active() ? anims[prop]._to : this[prop];
    });
    return ret;
  }
};
function autoSkip(scale, ticks) {
  const tickOpts = scale.options.ticks;
  const determinedMaxTicks = determineMaxTicks(scale);
  const ticksLimit = Math.min(tickOpts.maxTicksLimit || determinedMaxTicks, determinedMaxTicks);
  const majorIndices = tickOpts.major.enabled ? getMajorIndices(ticks) : [];
  const numMajorIndices = majorIndices.length;
  const first = majorIndices[0];
  const last = majorIndices[numMajorIndices - 1];
  const newTicks = [];
  if (numMajorIndices > ticksLimit) {
    skipMajors(ticks, newTicks, majorIndices, numMajorIndices / ticksLimit);
    return newTicks;
  }
  const spacing = calculateSpacing(majorIndices, ticks, ticksLimit);
  if (numMajorIndices > 0) {
    let i, ilen;
    const avgMajorSpacing = numMajorIndices > 1 ? Math.round((last - first) / (numMajorIndices - 1)) : null;
    skip(ticks, newTicks, spacing, isNullOrUndef(avgMajorSpacing) ? 0 : first - avgMajorSpacing, first);
    for (i = 0, ilen = numMajorIndices - 1; i < ilen; i++) {
      skip(ticks, newTicks, spacing, majorIndices[i], majorIndices[i + 1]);
    }
    skip(ticks, newTicks, spacing, last, isNullOrUndef(avgMajorSpacing) ? ticks.length : last + avgMajorSpacing);
    return newTicks;
  }
  skip(ticks, newTicks, spacing);
  return newTicks;
}
function determineMaxTicks(scale) {
  const offset = scale.options.offset;
  const tickLength = scale._tickSize();
  const maxScale = scale._length / tickLength + (offset ? 0 : 1);
  const maxChart = scale._maxLength / tickLength;
  return Math.floor(Math.min(maxScale, maxChart));
}
function calculateSpacing(majorIndices, ticks, ticksLimit) {
  const evenMajorSpacing = getEvenSpacing(majorIndices);
  const spacing = ticks.length / ticksLimit;
  if (!evenMajorSpacing) {
    return Math.max(spacing, 1);
  }
  const factors = _factorize(evenMajorSpacing);
  for (let i = 0, ilen = factors.length - 1; i < ilen; i++) {
    const factor = factors[i];
    if (factor > spacing) {
      return factor;
    }
  }
  return Math.max(spacing, 1);
}
function getMajorIndices(ticks) {
  const result = [];
  let i, ilen;
  for (i = 0, ilen = ticks.length; i < ilen; i++) {
    if (ticks[i].major) {
      result.push(i);
    }
  }
  return result;
}
function skipMajors(ticks, newTicks, majorIndices, spacing) {
  let count = 0;
  let next = majorIndices[0];
  let i;
  spacing = Math.ceil(spacing);
  for (i = 0; i < ticks.length; i++) {
    if (i === next) {
      newTicks.push(ticks[i]);
      count++;
      next = majorIndices[count * spacing];
    }
  }
}
function skip(ticks, newTicks, spacing, majorStart, majorEnd) {
  const start = valueOrDefault(majorStart, 0);
  const end = Math.min(valueOrDefault(majorEnd, ticks.length), ticks.length);
  let count = 0;
  let length, i, next;
  spacing = Math.ceil(spacing);
  if (majorEnd) {
    length = majorEnd - majorStart;
    spacing = length / Math.floor(length / spacing);
  }
  next = start;
  while (next < 0) {
    count++;
    next = Math.round(start + count * spacing);
  }
  for (i = Math.max(start, 0); i < end; i++) {
    if (i === next) {
      newTicks.push(ticks[i]);
      count++;
      next = Math.round(start + count * spacing);
    }
  }
}
function getEvenSpacing(arr) {
  const len = arr.length;
  let i, diff;
  if (len < 2) {
    return false;
  }
  for (diff = arr[0], i = 1; i < len; ++i) {
    if (arr[i] - arr[i - 1] !== diff) {
      return false;
    }
  }
  return diff;
}
var reverseAlign = (align) => align === "left" ? "right" : align === "right" ? "left" : align;
var offsetFromEdge = (scale, edge, offset) => edge === "top" || edge === "left" ? scale[edge] + offset : scale[edge] - offset;
var getTicksLimit = (ticksLength, maxTicksLimit) => Math.min(maxTicksLimit || ticksLength, ticksLength);
function sample(arr, numItems) {
  const result = [];
  const increment = arr.length / numItems;
  const len = arr.length;
  let i = 0;
  for (; i < len; i += increment) {
    result.push(arr[Math.floor(i)]);
  }
  return result;
}
function getPixelForGridLine(scale, index2, offsetGridLines) {
  const length = scale.ticks.length;
  const validIndex2 = Math.min(index2, length - 1);
  const start = scale._startPixel;
  const end = scale._endPixel;
  const epsilon = 1e-6;
  let lineValue = scale.getPixelForTick(validIndex2);
  let offset;
  if (offsetGridLines) {
    if (length === 1) {
      offset = Math.max(lineValue - start, end - lineValue);
    } else if (index2 === 0) {
      offset = (scale.getPixelForTick(1) - lineValue) / 2;
    } else {
      offset = (lineValue - scale.getPixelForTick(validIndex2 - 1)) / 2;
    }
    lineValue += validIndex2 < index2 ? offset : -offset;
    if (lineValue < start - epsilon || lineValue > end + epsilon) {
      return;
    }
  }
  return lineValue;
}
function garbageCollect(caches, length) {
  each(caches, (cache) => {
    const gc = cache.gc;
    const gcLen = gc.length / 2;
    let i;
    if (gcLen > length) {
      for (i = 0; i < gcLen; ++i) {
        delete cache.data[gc[i]];
      }
      gc.splice(0, gcLen);
    }
  });
}
function getTickMarkLength(options) {
  return options.drawTicks ? options.tickLength : 0;
}
function getTitleHeight(options, fallback) {
  if (!options.display) {
    return 0;
  }
  const font = toFont(options.font, fallback);
  const padding = toPadding(options.padding);
  const lines = isArray(options.text) ? options.text.length : 1;
  return lines * font.lineHeight + padding.height;
}
function createScaleContext(parent, scale) {
  return createContext(parent, {
    scale,
    type: "scale"
  });
}
function createTickContext(parent, index2, tick) {
  return createContext(parent, {
    tick,
    index: index2,
    type: "tick"
  });
}
function titleAlign(align, position, reverse) {
  let ret = _toLeftRightCenter(align);
  if (reverse && position !== "right" || !reverse && position === "right") {
    ret = reverseAlign(ret);
  }
  return ret;
}
function titleArgs(scale, offset, position, align) {
  const { top, left, bottom, right, chart } = scale;
  const { chartArea, scales } = chart;
  let rotation = 0;
  let maxWidth, titleX, titleY;
  const height = bottom - top;
  const width = right - left;
  if (scale.isHorizontal()) {
    titleX = _alignStartEnd(align, left, right);
    if (isObject(position)) {
      const positionAxisID = Object.keys(position)[0];
      const value = position[positionAxisID];
      titleY = scales[positionAxisID].getPixelForValue(value) + height - offset;
    } else if (position === "center") {
      titleY = (chartArea.bottom + chartArea.top) / 2 + height - offset;
    } else {
      titleY = offsetFromEdge(scale, position, offset);
    }
    maxWidth = right - left;
  } else {
    if (isObject(position)) {
      const positionAxisID = Object.keys(position)[0];
      const value = position[positionAxisID];
      titleX = scales[positionAxisID].getPixelForValue(value) - width + offset;
    } else if (position === "center") {
      titleX = (chartArea.left + chartArea.right) / 2 - width + offset;
    } else {
      titleX = offsetFromEdge(scale, position, offset);
    }
    titleY = _alignStartEnd(align, bottom, top);
    rotation = position === "left" ? -HALF_PI : HALF_PI;
  }
  return {
    titleX,
    titleY,
    maxWidth,
    rotation
  };
}
var Scale = class _Scale extends Element {
  constructor(cfg) {
    super();
    this.id = cfg.id;
    this.type = cfg.type;
    this.options = void 0;
    this.ctx = cfg.ctx;
    this.chart = cfg.chart;
    this.top = void 0;
    this.bottom = void 0;
    this.left = void 0;
    this.right = void 0;
    this.width = void 0;
    this.height = void 0;
    this._margins = {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    };
    this.maxWidth = void 0;
    this.maxHeight = void 0;
    this.paddingTop = void 0;
    this.paddingBottom = void 0;
    this.paddingLeft = void 0;
    this.paddingRight = void 0;
    this.axis = void 0;
    this.labelRotation = void 0;
    this.min = void 0;
    this.max = void 0;
    this._range = void 0;
    this.ticks = [];
    this._gridLineItems = null;
    this._labelItems = null;
    this._labelSizes = null;
    this._length = 0;
    this._maxLength = 0;
    this._longestTextCache = {};
    this._startPixel = void 0;
    this._endPixel = void 0;
    this._reversePixels = false;
    this._userMax = void 0;
    this._userMin = void 0;
    this._suggestedMax = void 0;
    this._suggestedMin = void 0;
    this._ticksLength = 0;
    this._borderValue = 0;
    this._cache = {};
    this._dataLimitsCached = false;
    this.$context = void 0;
  }
  init(options) {
    this.options = options.setContext(this.getContext());
    this.axis = options.axis;
    this._userMin = this.parse(options.min);
    this._userMax = this.parse(options.max);
    this._suggestedMin = this.parse(options.suggestedMin);
    this._suggestedMax = this.parse(options.suggestedMax);
  }
  parse(raw, index2) {
    return raw;
  }
  getUserBounds() {
    let { _userMin, _userMax, _suggestedMin, _suggestedMax } = this;
    _userMin = finiteOrDefault(_userMin, Number.POSITIVE_INFINITY);
    _userMax = finiteOrDefault(_userMax, Number.NEGATIVE_INFINITY);
    _suggestedMin = finiteOrDefault(_suggestedMin, Number.POSITIVE_INFINITY);
    _suggestedMax = finiteOrDefault(_suggestedMax, Number.NEGATIVE_INFINITY);
    return {
      min: finiteOrDefault(_userMin, _suggestedMin),
      max: finiteOrDefault(_userMax, _suggestedMax),
      minDefined: isNumberFinite(_userMin),
      maxDefined: isNumberFinite(_userMax)
    };
  }
  getMinMax(canStack) {
    let { min, max, minDefined, maxDefined } = this.getUserBounds();
    let range;
    if (minDefined && maxDefined) {
      return {
        min,
        max
      };
    }
    const metas = this.getMatchingVisibleMetas();
    for (let i = 0, ilen = metas.length; i < ilen; ++i) {
      range = metas[i].controller.getMinMax(this, canStack);
      if (!minDefined) {
        min = Math.min(min, range.min);
      }
      if (!maxDefined) {
        max = Math.max(max, range.max);
      }
    }
    min = maxDefined && min > max ? max : min;
    max = minDefined && min > max ? min : max;
    return {
      min: finiteOrDefault(min, finiteOrDefault(max, min)),
      max: finiteOrDefault(max, finiteOrDefault(min, max))
    };
  }
  getPadding() {
    return {
      left: this.paddingLeft || 0,
      top: this.paddingTop || 0,
      right: this.paddingRight || 0,
      bottom: this.paddingBottom || 0
    };
  }
  getTicks() {
    return this.ticks;
  }
  getLabels() {
    const data = this.chart.data;
    return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels || [];
  }
  getLabelItems(chartArea = this.chart.chartArea) {
    const items = this._labelItems || (this._labelItems = this._computeLabelItems(chartArea));
    return items;
  }
  beforeLayout() {
    this._cache = {};
    this._dataLimitsCached = false;
  }
  beforeUpdate() {
    callback(this.options.beforeUpdate, [
      this
    ]);
  }
  update(maxWidth, maxHeight, margins) {
    const { beginAtZero, grace, ticks: tickOpts } = this.options;
    const sampleSize = tickOpts.sampleSize;
    this.beforeUpdate();
    this.maxWidth = maxWidth;
    this.maxHeight = maxHeight;
    this._margins = margins = Object.assign({
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    }, margins);
    this.ticks = null;
    this._labelSizes = null;
    this._gridLineItems = null;
    this._labelItems = null;
    this.beforeSetDimensions();
    this.setDimensions();
    this.afterSetDimensions();
    this._maxLength = this.isHorizontal() ? this.width + margins.left + margins.right : this.height + margins.top + margins.bottom;
    if (!this._dataLimitsCached) {
      this.beforeDataLimits();
      this.determineDataLimits();
      this.afterDataLimits();
      this._range = _addGrace(this, grace, beginAtZero);
      this._dataLimitsCached = true;
    }
    this.beforeBuildTicks();
    this.ticks = this.buildTicks() || [];
    this.afterBuildTicks();
    const samplingEnabled = sampleSize < this.ticks.length;
    this._convertTicksToLabels(samplingEnabled ? sample(this.ticks, sampleSize) : this.ticks);
    this.configure();
    this.beforeCalculateLabelRotation();
    this.calculateLabelRotation();
    this.afterCalculateLabelRotation();
    if (tickOpts.display && (tickOpts.autoSkip || tickOpts.source === "auto")) {
      this.ticks = autoSkip(this, this.ticks);
      this._labelSizes = null;
      this.afterAutoSkip();
    }
    if (samplingEnabled) {
      this._convertTicksToLabels(this.ticks);
    }
    this.beforeFit();
    this.fit();
    this.afterFit();
    this.afterUpdate();
  }
  configure() {
    let reversePixels = this.options.reverse;
    let startPixel, endPixel;
    if (this.isHorizontal()) {
      startPixel = this.left;
      endPixel = this.right;
    } else {
      startPixel = this.top;
      endPixel = this.bottom;
      reversePixels = !reversePixels;
    }
    this._startPixel = startPixel;
    this._endPixel = endPixel;
    this._reversePixels = reversePixels;
    this._length = endPixel - startPixel;
    this._alignToPixels = this.options.alignToPixels;
  }
  afterUpdate() {
    callback(this.options.afterUpdate, [
      this
    ]);
  }
  beforeSetDimensions() {
    callback(this.options.beforeSetDimensions, [
      this
    ]);
  }
  setDimensions() {
    if (this.isHorizontal()) {
      this.width = this.maxWidth;
      this.left = 0;
      this.right = this.width;
    } else {
      this.height = this.maxHeight;
      this.top = 0;
      this.bottom = this.height;
    }
    this.paddingLeft = 0;
    this.paddingTop = 0;
    this.paddingRight = 0;
    this.paddingBottom = 0;
  }
  afterSetDimensions() {
    callback(this.options.afterSetDimensions, [
      this
    ]);
  }
  _callHooks(name) {
    this.chart.notifyPlugins(name, this.getContext());
    callback(this.options[name], [
      this
    ]);
  }
  beforeDataLimits() {
    this._callHooks("beforeDataLimits");
  }
  determineDataLimits() {
  }
  afterDataLimits() {
    this._callHooks("afterDataLimits");
  }
  beforeBuildTicks() {
    this._callHooks("beforeBuildTicks");
  }
  buildTicks() {
    return [];
  }
  afterBuildTicks() {
    this._callHooks("afterBuildTicks");
  }
  beforeTickToLabelConversion() {
    callback(this.options.beforeTickToLabelConversion, [
      this
    ]);
  }
  generateTickLabels(ticks) {
    const tickOpts = this.options.ticks;
    let i, ilen, tick;
    for (i = 0, ilen = ticks.length; i < ilen; i++) {
      tick = ticks[i];
      tick.label = callback(tickOpts.callback, [
        tick.value,
        i,
        ticks
      ], this);
    }
  }
  afterTickToLabelConversion() {
    callback(this.options.afterTickToLabelConversion, [
      this
    ]);
  }
  beforeCalculateLabelRotation() {
    callback(this.options.beforeCalculateLabelRotation, [
      this
    ]);
  }
  calculateLabelRotation() {
    const options = this.options;
    const tickOpts = options.ticks;
    const numTicks = getTicksLimit(this.ticks.length, options.ticks.maxTicksLimit);
    const minRotation = tickOpts.minRotation || 0;
    const maxRotation = tickOpts.maxRotation;
    let labelRotation = minRotation;
    let tickWidth, maxHeight, maxLabelDiagonal;
    if (!this._isVisible() || !tickOpts.display || minRotation >= maxRotation || numTicks <= 1 || !this.isHorizontal()) {
      this.labelRotation = minRotation;
      return;
    }
    const labelSizes = this._getLabelSizes();
    const maxLabelWidth = labelSizes.widest.width;
    const maxLabelHeight = labelSizes.highest.height;
    const maxWidth = _limitValue(this.chart.width - maxLabelWidth, 0, this.maxWidth);
    tickWidth = options.offset ? this.maxWidth / numTicks : maxWidth / (numTicks - 1);
    if (maxLabelWidth + 6 > tickWidth) {
      tickWidth = maxWidth / (numTicks - (options.offset ? 0.5 : 1));
      maxHeight = this.maxHeight - getTickMarkLength(options.grid) - tickOpts.padding - getTitleHeight(options.title, this.chart.options.font);
      maxLabelDiagonal = Math.sqrt(maxLabelWidth * maxLabelWidth + maxLabelHeight * maxLabelHeight);
      labelRotation = toDegrees(Math.min(Math.asin(_limitValue((labelSizes.highest.height + 6) / tickWidth, -1, 1)), Math.asin(_limitValue(maxHeight / maxLabelDiagonal, -1, 1)) - Math.asin(_limitValue(maxLabelHeight / maxLabelDiagonal, -1, 1))));
      labelRotation = Math.max(minRotation, Math.min(maxRotation, labelRotation));
    }
    this.labelRotation = labelRotation;
  }
  afterCalculateLabelRotation() {
    callback(this.options.afterCalculateLabelRotation, [
      this
    ]);
  }
  afterAutoSkip() {
  }
  beforeFit() {
    callback(this.options.beforeFit, [
      this
    ]);
  }
  fit() {
    const minSize = {
      width: 0,
      height: 0
    };
    const { chart, options: { ticks: tickOpts, title: titleOpts, grid: gridOpts } } = this;
    const display = this._isVisible();
    const isHorizontal = this.isHorizontal();
    if (display) {
      const titleHeight = getTitleHeight(titleOpts, chart.options.font);
      if (isHorizontal) {
        minSize.width = this.maxWidth;
        minSize.height = getTickMarkLength(gridOpts) + titleHeight;
      } else {
        minSize.height = this.maxHeight;
        minSize.width = getTickMarkLength(gridOpts) + titleHeight;
      }
      if (tickOpts.display && this.ticks.length) {
        const { first, last, widest, highest } = this._getLabelSizes();
        const tickPadding = tickOpts.padding * 2;
        const angleRadians = toRadians(this.labelRotation);
        const cos = Math.cos(angleRadians);
        const sin = Math.sin(angleRadians);
        if (isHorizontal) {
          const labelHeight = tickOpts.mirror ? 0 : sin * widest.width + cos * highest.height;
          minSize.height = Math.min(this.maxHeight, minSize.height + labelHeight + tickPadding);
        } else {
          const labelWidth = tickOpts.mirror ? 0 : cos * widest.width + sin * highest.height;
          minSize.width = Math.min(this.maxWidth, minSize.width + labelWidth + tickPadding);
        }
        this._calculatePadding(first, last, sin, cos);
      }
    }
    this._handleMargins();
    if (isHorizontal) {
      this.width = this._length = chart.width - this._margins.left - this._margins.right;
      this.height = minSize.height;
    } else {
      this.width = minSize.width;
      this.height = this._length = chart.height - this._margins.top - this._margins.bottom;
    }
  }
  _calculatePadding(first, last, sin, cos) {
    const { ticks: { align, padding }, position } = this.options;
    const isRotated = this.labelRotation !== 0;
    const labelsBelowTicks = position !== "top" && this.axis === "x";
    if (this.isHorizontal()) {
      const offsetLeft = this.getPixelForTick(0) - this.left;
      const offsetRight = this.right - this.getPixelForTick(this.ticks.length - 1);
      let paddingLeft = 0;
      let paddingRight = 0;
      if (isRotated) {
        if (labelsBelowTicks) {
          paddingLeft = cos * first.width;
          paddingRight = sin * last.height;
        } else {
          paddingLeft = sin * first.height;
          paddingRight = cos * last.width;
        }
      } else if (align === "start") {
        paddingRight = last.width;
      } else if (align === "end") {
        paddingLeft = first.width;
      } else if (align !== "inner") {
        paddingLeft = first.width / 2;
        paddingRight = last.width / 2;
      }
      this.paddingLeft = Math.max((paddingLeft - offsetLeft + padding) * this.width / (this.width - offsetLeft), 0);
      this.paddingRight = Math.max((paddingRight - offsetRight + padding) * this.width / (this.width - offsetRight), 0);
    } else {
      let paddingTop = last.height / 2;
      let paddingBottom = first.height / 2;
      if (align === "start") {
        paddingTop = 0;
        paddingBottom = first.height;
      } else if (align === "end") {
        paddingTop = last.height;
        paddingBottom = 0;
      }
      this.paddingTop = paddingTop + padding;
      this.paddingBottom = paddingBottom + padding;
    }
  }
  _handleMargins() {
    if (this._margins) {
      this._margins.left = Math.max(this.paddingLeft, this._margins.left);
      this._margins.top = Math.max(this.paddingTop, this._margins.top);
      this._margins.right = Math.max(this.paddingRight, this._margins.right);
      this._margins.bottom = Math.max(this.paddingBottom, this._margins.bottom);
    }
  }
  afterFit() {
    callback(this.options.afterFit, [
      this
    ]);
  }
  isHorizontal() {
    const { axis, position } = this.options;
    return position === "top" || position === "bottom" || axis === "x";
  }
  isFullSize() {
    return this.options.fullSize;
  }
  _convertTicksToLabels(ticks) {
    this.beforeTickToLabelConversion();
    this.generateTickLabels(ticks);
    let i, ilen;
    for (i = 0, ilen = ticks.length; i < ilen; i++) {
      if (isNullOrUndef(ticks[i].label)) {
        ticks.splice(i, 1);
        ilen--;
        i--;
      }
    }
    this.afterTickToLabelConversion();
  }
  _getLabelSizes() {
    let labelSizes = this._labelSizes;
    if (!labelSizes) {
      const sampleSize = this.options.ticks.sampleSize;
      let ticks = this.ticks;
      if (sampleSize < ticks.length) {
        ticks = sample(ticks, sampleSize);
      }
      this._labelSizes = labelSizes = this._computeLabelSizes(ticks, ticks.length, this.options.ticks.maxTicksLimit);
    }
    return labelSizes;
  }
  _computeLabelSizes(ticks, length, maxTicksLimit) {
    const { ctx, _longestTextCache: caches } = this;
    const widths = [];
    const heights = [];
    const increment = Math.floor(length / getTicksLimit(length, maxTicksLimit));
    let widestLabelSize = 0;
    let highestLabelSize = 0;
    let i, j, jlen, label, tickFont, fontString, cache, lineHeight, width, height, nestedLabel;
    for (i = 0; i < length; i += increment) {
      label = ticks[i].label;
      tickFont = this._resolveTickFontOptions(i);
      ctx.font = fontString = tickFont.string;
      cache = caches[fontString] = caches[fontString] || {
        data: {},
        gc: []
      };
      lineHeight = tickFont.lineHeight;
      width = height = 0;
      if (!isNullOrUndef(label) && !isArray(label)) {
        width = _measureText(ctx, cache.data, cache.gc, width, label);
        height = lineHeight;
      } else if (isArray(label)) {
        for (j = 0, jlen = label.length; j < jlen; ++j) {
          nestedLabel = label[j];
          if (!isNullOrUndef(nestedLabel) && !isArray(nestedLabel)) {
            width = _measureText(ctx, cache.data, cache.gc, width, nestedLabel);
            height += lineHeight;
          }
        }
      }
      widths.push(width);
      heights.push(height);
      widestLabelSize = Math.max(width, widestLabelSize);
      highestLabelSize = Math.max(height, highestLabelSize);
    }
    garbageCollect(caches, length);
    const widest = widths.indexOf(widestLabelSize);
    const highest = heights.indexOf(highestLabelSize);
    const valueAt = (idx) => ({
      width: widths[idx] || 0,
      height: heights[idx] || 0
    });
    return {
      first: valueAt(0),
      last: valueAt(length - 1),
      widest: valueAt(widest),
      highest: valueAt(highest),
      widths,
      heights
    };
  }
  getLabelForValue(value) {
    return value;
  }
  getPixelForValue(value, index2) {
    return NaN;
  }
  getValueForPixel(pixel) {
  }
  getPixelForTick(index2) {
    const ticks = this.ticks;
    if (index2 < 0 || index2 > ticks.length - 1) {
      return null;
    }
    return this.getPixelForValue(ticks[index2].value);
  }
  getPixelForDecimal(decimal) {
    if (this._reversePixels) {
      decimal = 1 - decimal;
    }
    const pixel = this._startPixel + decimal * this._length;
    return _int16Range(this._alignToPixels ? _alignPixel(this.chart, pixel, 0) : pixel);
  }
  getDecimalForPixel(pixel) {
    const decimal = (pixel - this._startPixel) / this._length;
    return this._reversePixels ? 1 - decimal : decimal;
  }
  getBasePixel() {
    return this.getPixelForValue(this.getBaseValue());
  }
  getBaseValue() {
    const { min, max } = this;
    return min < 0 && max < 0 ? max : min > 0 && max > 0 ? min : 0;
  }
  getContext(index2) {
    const ticks = this.ticks || [];
    if (index2 >= 0 && index2 < ticks.length) {
      const tick = ticks[index2];
      return tick.$context || (tick.$context = createTickContext(this.getContext(), index2, tick));
    }
    return this.$context || (this.$context = createScaleContext(this.chart.getContext(), this));
  }
  _tickSize() {
    const optionTicks = this.options.ticks;
    const rot = toRadians(this.labelRotation);
    const cos = Math.abs(Math.cos(rot));
    const sin = Math.abs(Math.sin(rot));
    const labelSizes = this._getLabelSizes();
    const padding = optionTicks.autoSkipPadding || 0;
    const w = labelSizes ? labelSizes.widest.width + padding : 0;
    const h = labelSizes ? labelSizes.highest.height + padding : 0;
    return this.isHorizontal() ? h * cos > w * sin ? w / cos : h / sin : h * sin < w * cos ? h / cos : w / sin;
  }
  _isVisible() {
    const display = this.options.display;
    if (display !== "auto") {
      return !!display;
    }
    return this.getMatchingVisibleMetas().length > 0;
  }
  _computeGridLineItems(chartArea) {
    const axis = this.axis;
    const chart = this.chart;
    const options = this.options;
    const { grid, position, border } = options;
    const offset = grid.offset;
    const isHorizontal = this.isHorizontal();
    const ticks = this.ticks;
    const ticksLength = ticks.length + (offset ? 1 : 0);
    const tl = getTickMarkLength(grid);
    const items = [];
    const borderOpts = border.setContext(this.getContext());
    const axisWidth = borderOpts.display ? borderOpts.width : 0;
    const axisHalfWidth = axisWidth / 2;
    const alignBorderValue = function(pixel) {
      return _alignPixel(chart, pixel, axisWidth);
    };
    let borderValue, i, lineValue, alignedLineValue;
    let tx1, ty1, tx2, ty2, x1, y1, x2, y2;
    if (position === "top") {
      borderValue = alignBorderValue(this.bottom);
      ty1 = this.bottom - tl;
      ty2 = borderValue - axisHalfWidth;
      y1 = alignBorderValue(chartArea.top) + axisHalfWidth;
      y2 = chartArea.bottom;
    } else if (position === "bottom") {
      borderValue = alignBorderValue(this.top);
      y1 = chartArea.top;
      y2 = alignBorderValue(chartArea.bottom) - axisHalfWidth;
      ty1 = borderValue + axisHalfWidth;
      ty2 = this.top + tl;
    } else if (position === "left") {
      borderValue = alignBorderValue(this.right);
      tx1 = this.right - tl;
      tx2 = borderValue - axisHalfWidth;
      x1 = alignBorderValue(chartArea.left) + axisHalfWidth;
      x2 = chartArea.right;
    } else if (position === "right") {
      borderValue = alignBorderValue(this.left);
      x1 = chartArea.left;
      x2 = alignBorderValue(chartArea.right) - axisHalfWidth;
      tx1 = borderValue + axisHalfWidth;
      tx2 = this.left + tl;
    } else if (axis === "x") {
      if (position === "center") {
        borderValue = alignBorderValue((chartArea.top + chartArea.bottom) / 2 + 0.5);
      } else if (isObject(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        borderValue = alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value));
      }
      y1 = chartArea.top;
      y2 = chartArea.bottom;
      ty1 = borderValue + axisHalfWidth;
      ty2 = ty1 + tl;
    } else if (axis === "y") {
      if (position === "center") {
        borderValue = alignBorderValue((chartArea.left + chartArea.right) / 2);
      } else if (isObject(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        borderValue = alignBorderValue(this.chart.scales[positionAxisID].getPixelForValue(value));
      }
      tx1 = borderValue - axisHalfWidth;
      tx2 = tx1 - tl;
      x1 = chartArea.left;
      x2 = chartArea.right;
    }
    const limit = valueOrDefault(options.ticks.maxTicksLimit, ticksLength);
    const step = Math.max(1, Math.ceil(ticksLength / limit));
    for (i = 0; i < ticksLength; i += step) {
      const context = this.getContext(i);
      const optsAtIndex = grid.setContext(context);
      const optsAtIndexBorder = border.setContext(context);
      const lineWidth = optsAtIndex.lineWidth;
      const lineColor = optsAtIndex.color;
      const borderDash = optsAtIndexBorder.dash || [];
      const borderDashOffset = optsAtIndexBorder.dashOffset;
      const tickWidth = optsAtIndex.tickWidth;
      const tickColor = optsAtIndex.tickColor;
      const tickBorderDash = optsAtIndex.tickBorderDash || [];
      const tickBorderDashOffset = optsAtIndex.tickBorderDashOffset;
      lineValue = getPixelForGridLine(this, i, offset);
      if (lineValue === void 0) {
        continue;
      }
      alignedLineValue = _alignPixel(chart, lineValue, lineWidth);
      if (isHorizontal) {
        tx1 = tx2 = x1 = x2 = alignedLineValue;
      } else {
        ty1 = ty2 = y1 = y2 = alignedLineValue;
      }
      items.push({
        tx1,
        ty1,
        tx2,
        ty2,
        x1,
        y1,
        x2,
        y2,
        width: lineWidth,
        color: lineColor,
        borderDash,
        borderDashOffset,
        tickWidth,
        tickColor,
        tickBorderDash,
        tickBorderDashOffset
      });
    }
    this._ticksLength = ticksLength;
    this._borderValue = borderValue;
    return items;
  }
  _computeLabelItems(chartArea) {
    const axis = this.axis;
    const options = this.options;
    const { position, ticks: optionTicks } = options;
    const isHorizontal = this.isHorizontal();
    const ticks = this.ticks;
    const { align, crossAlign, padding, mirror } = optionTicks;
    const tl = getTickMarkLength(options.grid);
    const tickAndPadding = tl + padding;
    const hTickAndPadding = mirror ? -padding : tickAndPadding;
    const rotation = -toRadians(this.labelRotation);
    const items = [];
    let i, ilen, tick, label, x, y, textAlign, pixel, font, lineHeight, lineCount, textOffset;
    let textBaseline = "middle";
    if (position === "top") {
      y = this.bottom - hTickAndPadding;
      textAlign = this._getXAxisLabelAlignment();
    } else if (position === "bottom") {
      y = this.top + hTickAndPadding;
      textAlign = this._getXAxisLabelAlignment();
    } else if (position === "left") {
      const ret = this._getYAxisLabelAlignment(tl);
      textAlign = ret.textAlign;
      x = ret.x;
    } else if (position === "right") {
      const ret = this._getYAxisLabelAlignment(tl);
      textAlign = ret.textAlign;
      x = ret.x;
    } else if (axis === "x") {
      if (position === "center") {
        y = (chartArea.top + chartArea.bottom) / 2 + tickAndPadding;
      } else if (isObject(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        y = this.chart.scales[positionAxisID].getPixelForValue(value) + tickAndPadding;
      }
      textAlign = this._getXAxisLabelAlignment();
    } else if (axis === "y") {
      if (position === "center") {
        x = (chartArea.left + chartArea.right) / 2 - tickAndPadding;
      } else if (isObject(position)) {
        const positionAxisID = Object.keys(position)[0];
        const value = position[positionAxisID];
        x = this.chart.scales[positionAxisID].getPixelForValue(value);
      }
      textAlign = this._getYAxisLabelAlignment(tl).textAlign;
    }
    if (axis === "y") {
      if (align === "start") {
        textBaseline = "top";
      } else if (align === "end") {
        textBaseline = "bottom";
      }
    }
    const labelSizes = this._getLabelSizes();
    for (i = 0, ilen = ticks.length; i < ilen; ++i) {
      tick = ticks[i];
      label = tick.label;
      const optsAtIndex = optionTicks.setContext(this.getContext(i));
      pixel = this.getPixelForTick(i) + optionTicks.labelOffset;
      font = this._resolveTickFontOptions(i);
      lineHeight = font.lineHeight;
      lineCount = isArray(label) ? label.length : 1;
      const halfCount = lineCount / 2;
      const color2 = optsAtIndex.color;
      const strokeColor = optsAtIndex.textStrokeColor;
      const strokeWidth = optsAtIndex.textStrokeWidth;
      let tickTextAlign = textAlign;
      if (isHorizontal) {
        x = pixel;
        if (textAlign === "inner") {
          if (i === ilen - 1) {
            tickTextAlign = !this.options.reverse ? "right" : "left";
          } else if (i === 0) {
            tickTextAlign = !this.options.reverse ? "left" : "right";
          } else {
            tickTextAlign = "center";
          }
        }
        if (position === "top") {
          if (crossAlign === "near" || rotation !== 0) {
            textOffset = -lineCount * lineHeight + lineHeight / 2;
          } else if (crossAlign === "center") {
            textOffset = -labelSizes.highest.height / 2 - halfCount * lineHeight + lineHeight;
          } else {
            textOffset = -labelSizes.highest.height + lineHeight / 2;
          }
        } else {
          if (crossAlign === "near" || rotation !== 0) {
            textOffset = lineHeight / 2;
          } else if (crossAlign === "center") {
            textOffset = labelSizes.highest.height / 2 - halfCount * lineHeight;
          } else {
            textOffset = labelSizes.highest.height - lineCount * lineHeight;
          }
        }
        if (mirror) {
          textOffset *= -1;
        }
        if (rotation !== 0 && !optsAtIndex.showLabelBackdrop) {
          x += lineHeight / 2 * Math.sin(rotation);
        }
      } else {
        y = pixel;
        textOffset = (1 - lineCount) * lineHeight / 2;
      }
      let backdrop;
      if (optsAtIndex.showLabelBackdrop) {
        const labelPadding = toPadding(optsAtIndex.backdropPadding);
        const height = labelSizes.heights[i];
        const width = labelSizes.widths[i];
        let top = textOffset - labelPadding.top;
        let left = 0 - labelPadding.left;
        switch (textBaseline) {
          case "middle":
            top -= height / 2;
            break;
          case "bottom":
            top -= height;
            break;
        }
        switch (textAlign) {
          case "center":
            left -= width / 2;
            break;
          case "right":
            left -= width;
            break;
          case "inner":
            if (i === ilen - 1) {
              left -= width;
            } else if (i > 0) {
              left -= width / 2;
            }
            break;
        }
        backdrop = {
          left,
          top,
          width: width + labelPadding.width,
          height: height + labelPadding.height,
          color: optsAtIndex.backdropColor
        };
      }
      items.push({
        label,
        font,
        textOffset,
        options: {
          rotation,
          color: color2,
          strokeColor,
          strokeWidth,
          textAlign: tickTextAlign,
          textBaseline,
          translation: [
            x,
            y
          ],
          backdrop
        }
      });
    }
    return items;
  }
  _getXAxisLabelAlignment() {
    const { position, ticks } = this.options;
    const rotation = -toRadians(this.labelRotation);
    if (rotation) {
      return position === "top" ? "left" : "right";
    }
    let align = "center";
    if (ticks.align === "start") {
      align = "left";
    } else if (ticks.align === "end") {
      align = "right";
    } else if (ticks.align === "inner") {
      align = "inner";
    }
    return align;
  }
  _getYAxisLabelAlignment(tl) {
    const { position, ticks: { crossAlign, mirror, padding } } = this.options;
    const labelSizes = this._getLabelSizes();
    const tickAndPadding = tl + padding;
    const widest = labelSizes.widest.width;
    let textAlign;
    let x;
    if (position === "left") {
      if (mirror) {
        x = this.right + padding;
        if (crossAlign === "near") {
          textAlign = "left";
        } else if (crossAlign === "center") {
          textAlign = "center";
          x += widest / 2;
        } else {
          textAlign = "right";
          x += widest;
        }
      } else {
        x = this.right - tickAndPadding;
        if (crossAlign === "near") {
          textAlign = "right";
        } else if (crossAlign === "center") {
          textAlign = "center";
          x -= widest / 2;
        } else {
          textAlign = "left";
          x = this.left;
        }
      }
    } else if (position === "right") {
      if (mirror) {
        x = this.left + padding;
        if (crossAlign === "near") {
          textAlign = "right";
        } else if (crossAlign === "center") {
          textAlign = "center";
          x -= widest / 2;
        } else {
          textAlign = "left";
          x -= widest;
        }
      } else {
        x = this.left + tickAndPadding;
        if (crossAlign === "near") {
          textAlign = "left";
        } else if (crossAlign === "center") {
          textAlign = "center";
          x += widest / 2;
        } else {
          textAlign = "right";
          x = this.right;
        }
      }
    } else {
      textAlign = "right";
    }
    return {
      textAlign,
      x
    };
  }
  _computeLabelArea() {
    if (this.options.ticks.mirror) {
      return;
    }
    const chart = this.chart;
    const position = this.options.position;
    if (position === "left" || position === "right") {
      return {
        top: 0,
        left: this.left,
        bottom: chart.height,
        right: this.right
      };
    }
    if (position === "top" || position === "bottom") {
      return {
        top: this.top,
        left: 0,
        bottom: this.bottom,
        right: chart.width
      };
    }
  }
  drawBackground() {
    const { ctx, options: { backgroundColor }, left, top, width, height } = this;
    if (backgroundColor) {
      ctx.save();
      ctx.fillStyle = backgroundColor;
      ctx.fillRect(left, top, width, height);
      ctx.restore();
    }
  }
  getLineWidthForValue(value) {
    const grid = this.options.grid;
    if (!this._isVisible() || !grid.display) {
      return 0;
    }
    const ticks = this.ticks;
    const index2 = ticks.findIndex((t) => t.value === value);
    if (index2 >= 0) {
      const opts = grid.setContext(this.getContext(index2));
      return opts.lineWidth;
    }
    return 0;
  }
  drawGrid(chartArea) {
    const grid = this.options.grid;
    const ctx = this.ctx;
    const items = this._gridLineItems || (this._gridLineItems = this._computeGridLineItems(chartArea));
    let i, ilen;
    const drawLine = (p1, p2, style) => {
      if (!style.width || !style.color) {
        return;
      }
      ctx.save();
      ctx.lineWidth = style.width;
      ctx.strokeStyle = style.color;
      ctx.setLineDash(style.borderDash || []);
      ctx.lineDashOffset = style.borderDashOffset;
      ctx.beginPath();
      ctx.moveTo(p1.x, p1.y);
      ctx.lineTo(p2.x, p2.y);
      ctx.stroke();
      ctx.restore();
    };
    if (grid.display) {
      for (i = 0, ilen = items.length; i < ilen; ++i) {
        const item = items[i];
        if (grid.drawOnChartArea) {
          drawLine({
            x: item.x1,
            y: item.y1
          }, {
            x: item.x2,
            y: item.y2
          }, item);
        }
        if (grid.drawTicks) {
          drawLine({
            x: item.tx1,
            y: item.ty1
          }, {
            x: item.tx2,
            y: item.ty2
          }, {
            color: item.tickColor,
            width: item.tickWidth,
            borderDash: item.tickBorderDash,
            borderDashOffset: item.tickBorderDashOffset
          });
        }
      }
    }
  }
  drawBorder() {
    const { chart, ctx, options: { border, grid } } = this;
    const borderOpts = border.setContext(this.getContext());
    const axisWidth = border.display ? borderOpts.width : 0;
    if (!axisWidth) {
      return;
    }
    const lastLineWidth = grid.setContext(this.getContext(0)).lineWidth;
    const borderValue = this._borderValue;
    let x1, x2, y1, y2;
    if (this.isHorizontal()) {
      x1 = _alignPixel(chart, this.left, axisWidth) - axisWidth / 2;
      x2 = _alignPixel(chart, this.right, lastLineWidth) + lastLineWidth / 2;
      y1 = y2 = borderValue;
    } else {
      y1 = _alignPixel(chart, this.top, axisWidth) - axisWidth / 2;
      y2 = _alignPixel(chart, this.bottom, lastLineWidth) + lastLineWidth / 2;
      x1 = x2 = borderValue;
    }
    ctx.save();
    ctx.lineWidth = borderOpts.width;
    ctx.strokeStyle = borderOpts.color;
    ctx.beginPath();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x2, y2);
    ctx.stroke();
    ctx.restore();
  }
  drawLabels(chartArea) {
    const optionTicks = this.options.ticks;
    if (!optionTicks.display) {
      return;
    }
    const ctx = this.ctx;
    const area = this._computeLabelArea();
    if (area) {
      clipArea(ctx, area);
    }
    const items = this.getLabelItems(chartArea);
    for (const item of items) {
      const renderTextOptions = item.options;
      const tickFont = item.font;
      const label = item.label;
      const y = item.textOffset;
      renderText(ctx, label, 0, y, tickFont, renderTextOptions);
    }
    if (area) {
      unclipArea(ctx);
    }
  }
  drawTitle() {
    const { ctx, options: { position, title, reverse } } = this;
    if (!title.display) {
      return;
    }
    const font = toFont(title.font);
    const padding = toPadding(title.padding);
    const align = title.align;
    let offset = font.lineHeight / 2;
    if (position === "bottom" || position === "center" || isObject(position)) {
      offset += padding.bottom;
      if (isArray(title.text)) {
        offset += font.lineHeight * (title.text.length - 1);
      }
    } else {
      offset += padding.top;
    }
    const { titleX, titleY, maxWidth, rotation } = titleArgs(this, offset, position, align);
    renderText(ctx, title.text, 0, 0, font, {
      color: title.color,
      maxWidth,
      rotation,
      textAlign: titleAlign(align, position, reverse),
      textBaseline: "middle",
      translation: [
        titleX,
        titleY
      ]
    });
  }
  draw(chartArea) {
    if (!this._isVisible()) {
      return;
    }
    this.drawBackground();
    this.drawGrid(chartArea);
    this.drawBorder();
    this.drawTitle();
    this.drawLabels(chartArea);
  }
  _layers() {
    const opts = this.options;
    const tz = opts.ticks && opts.ticks.z || 0;
    const gz = valueOrDefault(opts.grid && opts.grid.z, -1);
    const bz = valueOrDefault(opts.border && opts.border.z, 0);
    if (!this._isVisible() || this.draw !== _Scale.prototype.draw) {
      return [
        {
          z: tz,
          draw: (chartArea) => {
            this.draw(chartArea);
          }
        }
      ];
    }
    return [
      {
        z: gz,
        draw: (chartArea) => {
          this.drawBackground();
          this.drawGrid(chartArea);
          this.drawTitle();
        }
      },
      {
        z: bz,
        draw: () => {
          this.drawBorder();
        }
      },
      {
        z: tz,
        draw: (chartArea) => {
          this.drawLabels(chartArea);
        }
      }
    ];
  }
  getMatchingVisibleMetas(type) {
    const metas = this.chart.getSortedVisibleDatasetMetas();
    const axisID = this.axis + "AxisID";
    const result = [];
    let i, ilen;
    for (i = 0, ilen = metas.length; i < ilen; ++i) {
      const meta = metas[i];
      if (meta[axisID] === this.id && (!type || meta.type === type)) {
        result.push(meta);
      }
    }
    return result;
  }
  _resolveTickFontOptions(index2) {
    const opts = this.options.ticks.setContext(this.getContext(index2));
    return toFont(opts.font);
  }
  _maxDigits() {
    const fontSize = this._resolveTickFontOptions(0).lineHeight;
    return (this.isHorizontal() ? this.width : this.height) / fontSize;
  }
};
var TypedRegistry = class {
  constructor(type, scope, override) {
    this.type = type;
    this.scope = scope;
    this.override = override;
    this.items = /* @__PURE__ */ Object.create(null);
  }
  isForType(type) {
    return Object.prototype.isPrototypeOf.call(this.type.prototype, type.prototype);
  }
  register(item) {
    const proto = Object.getPrototypeOf(item);
    let parentScope;
    if (isIChartComponent(proto)) {
      parentScope = this.register(proto);
    }
    const items = this.items;
    const id = item.id;
    const scope = this.scope + "." + id;
    if (!id) {
      throw new Error("class does not have id: " + item);
    }
    if (id in items) {
      return scope;
    }
    items[id] = item;
    registerDefaults(item, scope, parentScope);
    if (this.override) {
      defaults.override(item.id, item.overrides);
    }
    return scope;
  }
  get(id) {
    return this.items[id];
  }
  unregister(item) {
    const items = this.items;
    const id = item.id;
    const scope = this.scope;
    if (id in items) {
      delete items[id];
    }
    if (scope && id in defaults[scope]) {
      delete defaults[scope][id];
      if (this.override) {
        delete overrides[id];
      }
    }
  }
};
function registerDefaults(item, scope, parentScope) {
  const itemDefaults = merge(/* @__PURE__ */ Object.create(null), [
    parentScope ? defaults.get(parentScope) : {},
    defaults.get(scope),
    item.defaults
  ]);
  defaults.set(scope, itemDefaults);
  if (item.defaultRoutes) {
    routeDefaults(scope, item.defaultRoutes);
  }
  if (item.descriptors) {
    defaults.describe(scope, item.descriptors);
  }
}
function routeDefaults(scope, routes) {
  Object.keys(routes).forEach((property) => {
    const propertyParts = property.split(".");
    const sourceName = propertyParts.pop();
    const sourceScope = [
      scope
    ].concat(propertyParts).join(".");
    const parts = routes[property].split(".");
    const targetName = parts.pop();
    const targetScope = parts.join(".");
    defaults.route(sourceScope, sourceName, targetScope, targetName);
  });
}
function isIChartComponent(proto) {
  return "id" in proto && "defaults" in proto;
}
var Registry = class {
  constructor() {
    this.controllers = new TypedRegistry(DatasetController, "datasets", true);
    this.elements = new TypedRegistry(Element, "elements");
    this.plugins = new TypedRegistry(Object, "plugins");
    this.scales = new TypedRegistry(Scale, "scales");
    this._typedRegistries = [
      this.controllers,
      this.scales,
      this.elements
    ];
  }
  add(...args) {
    this._each("register", args);
  }
  remove(...args) {
    this._each("unregister", args);
  }
  addControllers(...args) {
    this._each("register", args, this.controllers);
  }
  addElements(...args) {
    this._each("register", args, this.elements);
  }
  addPlugins(...args) {
    this._each("register", args, this.plugins);
  }
  addScales(...args) {
    this._each("register", args, this.scales);
  }
  getController(id) {
    return this._get(id, this.controllers, "controller");
  }
  getElement(id) {
    return this._get(id, this.elements, "element");
  }
  getPlugin(id) {
    return this._get(id, this.plugins, "plugin");
  }
  getScale(id) {
    return this._get(id, this.scales, "scale");
  }
  removeControllers(...args) {
    this._each("unregister", args, this.controllers);
  }
  removeElements(...args) {
    this._each("unregister", args, this.elements);
  }
  removePlugins(...args) {
    this._each("unregister", args, this.plugins);
  }
  removeScales(...args) {
    this._each("unregister", args, this.scales);
  }
  _each(method, args, typedRegistry) {
    [
      ...args
    ].forEach((arg) => {
      const reg = typedRegistry || this._getRegistryForType(arg);
      if (typedRegistry || reg.isForType(arg) || reg === this.plugins && arg.id) {
        this._exec(method, reg, arg);
      } else {
        each(arg, (item) => {
          const itemReg = typedRegistry || this._getRegistryForType(item);
          this._exec(method, itemReg, item);
        });
      }
    });
  }
  _exec(method, registry2, component) {
    const camelMethod = _capitalize(method);
    callback(component["before" + camelMethod], [], component);
    registry2[method](component);
    callback(component["after" + camelMethod], [], component);
  }
  _getRegistryForType(type) {
    for (let i = 0; i < this._typedRegistries.length; i++) {
      const reg = this._typedRegistries[i];
      if (reg.isForType(type)) {
        return reg;
      }
    }
    return this.plugins;
  }
  _get(id, typedRegistry, type) {
    const item = typedRegistry.get(id);
    if (item === void 0) {
      throw new Error('"' + id + '" is not a registered ' + type + ".");
    }
    return item;
  }
};
var registry = /* @__PURE__ */ new Registry();
var PluginService = class {
  constructor() {
    this._init = [];
  }
  notify(chart, hook, args, filter) {
    if (hook === "beforeInit") {
      this._init = this._createDescriptors(chart, true);
      this._notify(this._init, chart, "install");
    }
    const descriptors2 = filter ? this._descriptors(chart).filter(filter) : this._descriptors(chart);
    const result = this._notify(descriptors2, chart, hook, args);
    if (hook === "afterDestroy") {
      this._notify(descriptors2, chart, "stop");
      this._notify(this._init, chart, "uninstall");
    }
    return result;
  }
  _notify(descriptors2, chart, hook, args) {
    args = args || {};
    for (const descriptor of descriptors2) {
      const plugin = descriptor.plugin;
      const method = plugin[hook];
      const params = [
        chart,
        args,
        descriptor.options
      ];
      if (callback(method, params, plugin) === false && args.cancelable) {
        return false;
      }
    }
    return true;
  }
  invalidate() {
    if (!isNullOrUndef(this._cache)) {
      this._oldCache = this._cache;
      this._cache = void 0;
    }
  }
  _descriptors(chart) {
    if (this._cache) {
      return this._cache;
    }
    const descriptors2 = this._cache = this._createDescriptors(chart);
    this._notifyStateChanges(chart);
    return descriptors2;
  }
  _createDescriptors(chart, all) {
    const config = chart && chart.config;
    const options = valueOrDefault(config.options && config.options.plugins, {});
    const plugins = allPlugins(config);
    return options === false && !all ? [] : createDescriptors(chart, plugins, options, all);
  }
  _notifyStateChanges(chart) {
    const previousDescriptors = this._oldCache || [];
    const descriptors2 = this._cache;
    const diff = (a, b) => a.filter((x) => !b.some((y) => x.plugin.id === y.plugin.id));
    this._notify(diff(previousDescriptors, descriptors2), chart, "stop");
    this._notify(diff(descriptors2, previousDescriptors), chart, "start");
  }
};
function allPlugins(config) {
  const localIds = {};
  const plugins = [];
  const keys = Object.keys(registry.plugins.items);
  for (let i = 0; i < keys.length; i++) {
    plugins.push(registry.getPlugin(keys[i]));
  }
  const local = config.plugins || [];
  for (let i = 0; i < local.length; i++) {
    const plugin = local[i];
    if (plugins.indexOf(plugin) === -1) {
      plugins.push(plugin);
      localIds[plugin.id] = true;
    }
  }
  return {
    plugins,
    localIds
  };
}
function getOpts(options, all) {
  if (!all && options === false) {
    return null;
  }
  if (options === true) {
    return {};
  }
  return options;
}
function createDescriptors(chart, { plugins, localIds }, options, all) {
  const result = [];
  const context = chart.getContext();
  for (const plugin of plugins) {
    const id = plugin.id;
    const opts = getOpts(options[id], all);
    if (opts === null) {
      continue;
    }
    result.push({
      plugin,
      options: pluginOpts(chart.config, {
        plugin,
        local: localIds[id]
      }, opts, context)
    });
  }
  return result;
}
function pluginOpts(config, { plugin, local }, opts, context) {
  const keys = config.pluginScopeKeys(plugin);
  const scopes = config.getOptionScopes(opts, keys);
  if (local && plugin.defaults) {
    scopes.push(plugin.defaults);
  }
  return config.createResolver(scopes, context, [
    ""
  ], {
    scriptable: false,
    indexable: false,
    allKeys: true
  });
}
function getIndexAxis(type, options) {
  const datasetDefaults = defaults.datasets[type] || {};
  const datasetOptions = (options.datasets || {})[type] || {};
  return datasetOptions.indexAxis || options.indexAxis || datasetDefaults.indexAxis || "x";
}
function getAxisFromDefaultScaleID(id, indexAxis) {
  let axis = id;
  if (id === "_index_") {
    axis = indexAxis;
  } else if (id === "_value_") {
    axis = indexAxis === "x" ? "y" : "x";
  }
  return axis;
}
function getDefaultScaleIDFromAxis(axis, indexAxis) {
  return axis === indexAxis ? "_index_" : "_value_";
}
function idMatchesAxis(id) {
  if (id === "x" || id === "y" || id === "r") {
    return id;
  }
}
function axisFromPosition(position) {
  if (position === "top" || position === "bottom") {
    return "x";
  }
  if (position === "left" || position === "right") {
    return "y";
  }
}
function determineAxis(id, ...scaleOptions) {
  if (idMatchesAxis(id)) {
    return id;
  }
  for (const opts of scaleOptions) {
    const axis = opts.axis || axisFromPosition(opts.position) || id.length > 1 && idMatchesAxis(id[0].toLowerCase());
    if (axis) {
      return axis;
    }
  }
  throw new Error(`Cannot determine type of '${id}' axis. Please provide 'axis' or 'position' option.`);
}
function getAxisFromDataset(id, axis, dataset) {
  if (dataset[axis + "AxisID"] === id) {
    return {
      axis
    };
  }
}
function retrieveAxisFromDatasets(id, config) {
  if (config.data && config.data.datasets) {
    const boundDs = config.data.datasets.filter((d) => d.xAxisID === id || d.yAxisID === id);
    if (boundDs.length) {
      return getAxisFromDataset(id, "x", boundDs[0]) || getAxisFromDataset(id, "y", boundDs[0]);
    }
  }
  return {};
}
function mergeScaleConfig(config, options) {
  const chartDefaults = overrides[config.type] || {
    scales: {}
  };
  const configScales = options.scales || {};
  const chartIndexAxis = getIndexAxis(config.type, options);
  const scales = /* @__PURE__ */ Object.create(null);
  Object.keys(configScales).forEach((id) => {
    const scaleConf = configScales[id];
    if (!isObject(scaleConf)) {
      return console.error(`Invalid scale configuration for scale: ${id}`);
    }
    if (scaleConf._proxy) {
      return console.warn(`Ignoring resolver passed as options for scale: ${id}`);
    }
    const axis = determineAxis(id, scaleConf, retrieveAxisFromDatasets(id, config), defaults.scales[scaleConf.type]);
    const defaultId = getDefaultScaleIDFromAxis(axis, chartIndexAxis);
    const defaultScaleOptions = chartDefaults.scales || {};
    scales[id] = mergeIf(/* @__PURE__ */ Object.create(null), [
      {
        axis
      },
      scaleConf,
      defaultScaleOptions[axis],
      defaultScaleOptions[defaultId]
    ]);
  });
  config.data.datasets.forEach((dataset) => {
    const type = dataset.type || config.type;
    const indexAxis = dataset.indexAxis || getIndexAxis(type, options);
    const datasetDefaults = overrides[type] || {};
    const defaultScaleOptions = datasetDefaults.scales || {};
    Object.keys(defaultScaleOptions).forEach((defaultID) => {
      const axis = getAxisFromDefaultScaleID(defaultID, indexAxis);
      const id = dataset[axis + "AxisID"] || axis;
      scales[id] = scales[id] || /* @__PURE__ */ Object.create(null);
      mergeIf(scales[id], [
        {
          axis
        },
        configScales[id],
        defaultScaleOptions[defaultID]
      ]);
    });
  });
  Object.keys(scales).forEach((key) => {
    const scale = scales[key];
    mergeIf(scale, [
      defaults.scales[scale.type],
      defaults.scale
    ]);
  });
  return scales;
}
function initOptions(config) {
  const options = config.options || (config.options = {});
  options.plugins = valueOrDefault(options.plugins, {});
  options.scales = mergeScaleConfig(config, options);
}
function initData(data) {
  data = data || {};
  data.datasets = data.datasets || [];
  data.labels = data.labels || [];
  return data;
}
function initConfig(config) {
  config = config || {};
  config.data = initData(config.data);
  initOptions(config);
  return config;
}
var keyCache = /* @__PURE__ */ new Map();
var keysCached = /* @__PURE__ */ new Set();
function cachedKeys(cacheKey, generate) {
  let keys = keyCache.get(cacheKey);
  if (!keys) {
    keys = generate();
    keyCache.set(cacheKey, keys);
    keysCached.add(keys);
  }
  return keys;
}
var addIfFound = (set2, obj, key) => {
  const opts = resolveObjectKey(obj, key);
  if (opts !== void 0) {
    set2.add(opts);
  }
};
var Config = class {
  constructor(config) {
    this._config = initConfig(config);
    this._scopeCache = /* @__PURE__ */ new Map();
    this._resolverCache = /* @__PURE__ */ new Map();
  }
  get platform() {
    return this._config.platform;
  }
  get type() {
    return this._config.type;
  }
  set type(type) {
    this._config.type = type;
  }
  get data() {
    return this._config.data;
  }
  set data(data) {
    this._config.data = initData(data);
  }
  get options() {
    return this._config.options;
  }
  set options(options) {
    this._config.options = options;
  }
  get plugins() {
    return this._config.plugins;
  }
  update() {
    const config = this._config;
    this.clearCache();
    initOptions(config);
  }
  clearCache() {
    this._scopeCache.clear();
    this._resolverCache.clear();
  }
  datasetScopeKeys(datasetType) {
    return cachedKeys(datasetType, () => [
      [
        `datasets.${datasetType}`,
        ""
      ]
    ]);
  }
  datasetAnimationScopeKeys(datasetType, transition) {
    return cachedKeys(`${datasetType}.transition.${transition}`, () => [
      [
        `datasets.${datasetType}.transitions.${transition}`,
        `transitions.${transition}`
      ],
      [
        `datasets.${datasetType}`,
        ""
      ]
    ]);
  }
  datasetElementScopeKeys(datasetType, elementType) {
    return cachedKeys(`${datasetType}-${elementType}`, () => [
      [
        `datasets.${datasetType}.elements.${elementType}`,
        `datasets.${datasetType}`,
        `elements.${elementType}`,
        ""
      ]
    ]);
  }
  pluginScopeKeys(plugin) {
    const id = plugin.id;
    const type = this.type;
    return cachedKeys(`${type}-plugin-${id}`, () => [
      [
        `plugins.${id}`,
        ...plugin.additionalOptionScopes || []
      ]
    ]);
  }
  _cachedScopes(mainScope, resetCache) {
    const _scopeCache = this._scopeCache;
    let cache = _scopeCache.get(mainScope);
    if (!cache || resetCache) {
      cache = /* @__PURE__ */ new Map();
      _scopeCache.set(mainScope, cache);
    }
    return cache;
  }
  getOptionScopes(mainScope, keyLists, resetCache) {
    const { options, type } = this;
    const cache = this._cachedScopes(mainScope, resetCache);
    const cached = cache.get(keyLists);
    if (cached) {
      return cached;
    }
    const scopes = /* @__PURE__ */ new Set();
    keyLists.forEach((keys) => {
      if (mainScope) {
        scopes.add(mainScope);
        keys.forEach((key) => addIfFound(scopes, mainScope, key));
      }
      keys.forEach((key) => addIfFound(scopes, options, key));
      keys.forEach((key) => addIfFound(scopes, overrides[type] || {}, key));
      keys.forEach((key) => addIfFound(scopes, defaults, key));
      keys.forEach((key) => addIfFound(scopes, descriptors, key));
    });
    const array = Array.from(scopes);
    if (array.length === 0) {
      array.push(/* @__PURE__ */ Object.create(null));
    }
    if (keysCached.has(keyLists)) {
      cache.set(keyLists, array);
    }
    return array;
  }
  chartOptionScopes() {
    const { options, type } = this;
    return [
      options,
      overrides[type] || {},
      defaults.datasets[type] || {},
      {
        type
      },
      defaults,
      descriptors
    ];
  }
  resolveNamedOptions(scopes, names2, context, prefixes = [
    ""
  ]) {
    const result = {
      $shared: true
    };
    const { resolver, subPrefixes } = getResolver(this._resolverCache, scopes, prefixes);
    let options = resolver;
    if (needContext(resolver, names2)) {
      result.$shared = false;
      context = isFunction(context) ? context() : context;
      const subResolver = this.createResolver(scopes, context, subPrefixes);
      options = _attachContext(resolver, context, subResolver);
    }
    for (const prop of names2) {
      result[prop] = options[prop];
    }
    return result;
  }
  createResolver(scopes, context, prefixes = [
    ""
  ], descriptorDefaults) {
    const { resolver } = getResolver(this._resolverCache, scopes, prefixes);
    return isObject(context) ? _attachContext(resolver, context, void 0, descriptorDefaults) : resolver;
  }
};
function getResolver(resolverCache, scopes, prefixes) {
  let cache = resolverCache.get(scopes);
  if (!cache) {
    cache = /* @__PURE__ */ new Map();
    resolverCache.set(scopes, cache);
  }
  const cacheKey = prefixes.join();
  let cached = cache.get(cacheKey);
  if (!cached) {
    const resolver = _createResolver(scopes, prefixes);
    cached = {
      resolver,
      subPrefixes: prefixes.filter((p) => !p.toLowerCase().includes("hover"))
    };
    cache.set(cacheKey, cached);
  }
  return cached;
}
var hasFunction = (value) => isObject(value) && Object.getOwnPropertyNames(value).some((key) => isFunction(value[key]));
function needContext(proxy, names2) {
  const { isScriptable, isIndexable } = _descriptors(proxy);
  for (const prop of names2) {
    const scriptable = isScriptable(prop);
    const indexable = isIndexable(prop);
    const value = (indexable || scriptable) && proxy[prop];
    if (scriptable && (isFunction(value) || hasFunction(value)) || indexable && isArray(value)) {
      return true;
    }
  }
  return false;
}
var version = "4.4.6";
var KNOWN_POSITIONS = [
  "top",
  "bottom",
  "left",
  "right",
  "chartArea"
];
function positionIsHorizontal(position, axis) {
  return position === "top" || position === "bottom" || KNOWN_POSITIONS.indexOf(position) === -1 && axis === "x";
}
function compare2Level(l1, l2) {
  return function(a, b) {
    return a[l1] === b[l1] ? a[l2] - b[l2] : a[l1] - b[l1];
  };
}
function onAnimationsComplete(context) {
  const chart = context.chart;
  const animationOptions = chart.options.animation;
  chart.notifyPlugins("afterRender");
  callback(animationOptions && animationOptions.onComplete, [
    context
  ], chart);
}
function onAnimationProgress(context) {
  const chart = context.chart;
  const animationOptions = chart.options.animation;
  callback(animationOptions && animationOptions.onProgress, [
    context
  ], chart);
}
function getCanvas(item) {
  if (_isDomSupported() && typeof item === "string") {
    item = document.getElementById(item);
  } else if (item && item.length) {
    item = item[0];
  }
  if (item && item.canvas) {
    item = item.canvas;
  }
  return item;
}
var instances = {};
var getChart = (key) => {
  const canvas = getCanvas(key);
  return Object.values(instances).filter((c) => c.canvas === canvas).pop();
};
function moveNumericKeys(obj, start, move) {
  const keys = Object.keys(obj);
  for (const key of keys) {
    const intKey = +key;
    if (intKey >= start) {
      const value = obj[key];
      delete obj[key];
      if (move > 0 || intKey > start) {
        obj[intKey + move] = value;
      }
    }
  }
}
function determineLastEvent(e, lastEvent, inChartArea, isClick) {
  if (!inChartArea || e.type === "mouseout") {
    return null;
  }
  if (isClick) {
    return lastEvent;
  }
  return e;
}
function getSizeForArea(scale, chartArea, field) {
  return scale.options.clip ? scale[field] : chartArea[field];
}
function getDatasetArea(meta, chartArea) {
  const { xScale, yScale } = meta;
  if (xScale && yScale) {
    return {
      left: getSizeForArea(xScale, chartArea, "left"),
      right: getSizeForArea(xScale, chartArea, "right"),
      top: getSizeForArea(yScale, chartArea, "top"),
      bottom: getSizeForArea(yScale, chartArea, "bottom")
    };
  }
  return chartArea;
}
var Chart = class {
  static defaults = defaults;
  static instances = instances;
  static overrides = overrides;
  static registry = registry;
  static version = version;
  static getChart = getChart;
  static register(...items) {
    registry.add(...items);
    invalidatePlugins();
  }
  static unregister(...items) {
    registry.remove(...items);
    invalidatePlugins();
  }
  constructor(item, userConfig) {
    const config = this.config = new Config(userConfig);
    const initialCanvas = getCanvas(item);
    const existingChart = getChart(initialCanvas);
    if (existingChart) {
      throw new Error("Canvas is already in use. Chart with ID '" + existingChart.id + "' must be destroyed before the canvas with ID '" + existingChart.canvas.id + "' can be reused.");
    }
    const options = config.createResolver(config.chartOptionScopes(), this.getContext());
    this.platform = new (config.platform || _detectPlatform(initialCanvas))();
    this.platform.updateConfig(config);
    const context = this.platform.acquireContext(initialCanvas, options.aspectRatio);
    const canvas = context && context.canvas;
    const height = canvas && canvas.height;
    const width = canvas && canvas.width;
    this.id = uid();
    this.ctx = context;
    this.canvas = canvas;
    this.width = width;
    this.height = height;
    this._options = options;
    this._aspectRatio = this.aspectRatio;
    this._layers = [];
    this._metasets = [];
    this._stacks = void 0;
    this.boxes = [];
    this.currentDevicePixelRatio = void 0;
    this.chartArea = void 0;
    this._active = [];
    this._lastEvent = void 0;
    this._listeners = {};
    this._responsiveListeners = void 0;
    this._sortedMetasets = [];
    this.scales = {};
    this._plugins = new PluginService();
    this.$proxies = {};
    this._hiddenIndices = {};
    this.attached = false;
    this._animationsDisabled = void 0;
    this.$context = void 0;
    this._doResize = debounce((mode) => this.update(mode), options.resizeDelay || 0);
    this._dataChanges = [];
    instances[this.id] = this;
    if (!context || !canvas) {
      console.error("Failed to create chart: can't acquire context from the given item");
      return;
    }
    animator.listen(this, "complete", onAnimationsComplete);
    animator.listen(this, "progress", onAnimationProgress);
    this._initialize();
    if (this.attached) {
      this.update();
    }
  }
  get aspectRatio() {
    const { options: { aspectRatio, maintainAspectRatio }, width, height, _aspectRatio } = this;
    if (!isNullOrUndef(aspectRatio)) {
      return aspectRatio;
    }
    if (maintainAspectRatio && _aspectRatio) {
      return _aspectRatio;
    }
    return height ? width / height : null;
  }
  get data() {
    return this.config.data;
  }
  set data(data) {
    this.config.data = data;
  }
  get options() {
    return this._options;
  }
  set options(options) {
    this.config.options = options;
  }
  get registry() {
    return registry;
  }
  _initialize() {
    this.notifyPlugins("beforeInit");
    if (this.options.responsive) {
      this.resize();
    } else {
      retinaScale(this, this.options.devicePixelRatio);
    }
    this.bindEvents();
    this.notifyPlugins("afterInit");
    return this;
  }
  clear() {
    clearCanvas(this.canvas, this.ctx);
    return this;
  }
  stop() {
    animator.stop(this);
    return this;
  }
  resize(width, height) {
    if (!animator.running(this)) {
      this._resize(width, height);
    } else {
      this._resizeBeforeDraw = {
        width,
        height
      };
    }
  }
  _resize(width, height) {
    const options = this.options;
    const canvas = this.canvas;
    const aspectRatio = options.maintainAspectRatio && this.aspectRatio;
    const newSize = this.platform.getMaximumSize(canvas, width, height, aspectRatio);
    const newRatio = options.devicePixelRatio || this.platform.getDevicePixelRatio();
    const mode = this.width ? "resize" : "attach";
    this.width = newSize.width;
    this.height = newSize.height;
    this._aspectRatio = this.aspectRatio;
    if (!retinaScale(this, newRatio, true)) {
      return;
    }
    this.notifyPlugins("resize", {
      size: newSize
    });
    callback(options.onResize, [
      this,
      newSize
    ], this);
    if (this.attached) {
      if (this._doResize(mode)) {
        this.render();
      }
    }
  }
  ensureScalesHaveIDs() {
    const options = this.options;
    const scalesOptions = options.scales || {};
    each(scalesOptions, (axisOptions, axisID) => {
      axisOptions.id = axisID;
    });
  }
  buildOrUpdateScales() {
    const options = this.options;
    const scaleOpts = options.scales;
    const scales = this.scales;
    const updated = Object.keys(scales).reduce((obj, id) => {
      obj[id] = false;
      return obj;
    }, {});
    let items = [];
    if (scaleOpts) {
      items = items.concat(Object.keys(scaleOpts).map((id) => {
        const scaleOptions = scaleOpts[id];
        const axis = determineAxis(id, scaleOptions);
        const isRadial = axis === "r";
        const isHorizontal = axis === "x";
        return {
          options: scaleOptions,
          dposition: isRadial ? "chartArea" : isHorizontal ? "bottom" : "left",
          dtype: isRadial ? "radialLinear" : isHorizontal ? "category" : "linear"
        };
      }));
    }
    each(items, (item) => {
      const scaleOptions = item.options;
      const id = scaleOptions.id;
      const axis = determineAxis(id, scaleOptions);
      const scaleType = valueOrDefault(scaleOptions.type, item.dtype);
      if (scaleOptions.position === void 0 || positionIsHorizontal(scaleOptions.position, axis) !== positionIsHorizontal(item.dposition)) {
        scaleOptions.position = item.dposition;
      }
      updated[id] = true;
      let scale = null;
      if (id in scales && scales[id].type === scaleType) {
        scale = scales[id];
      } else {
        const scaleClass = registry.getScale(scaleType);
        scale = new scaleClass({
          id,
          type: scaleType,
          ctx: this.ctx,
          chart: this
        });
        scales[scale.id] = scale;
      }
      scale.init(scaleOptions, options);
    });
    each(updated, (hasUpdated, id) => {
      if (!hasUpdated) {
        delete scales[id];
      }
    });
    each(scales, (scale) => {
      layouts.configure(this, scale, scale.options);
      layouts.addBox(this, scale);
    });
  }
  _updateMetasets() {
    const metasets = this._metasets;
    const numData = this.data.datasets.length;
    const numMeta = metasets.length;
    metasets.sort((a, b) => a.index - b.index);
    if (numMeta > numData) {
      for (let i = numData; i < numMeta; ++i) {
        this._destroyDatasetMeta(i);
      }
      metasets.splice(numData, numMeta - numData);
    }
    this._sortedMetasets = metasets.slice(0).sort(compare2Level("order", "index"));
  }
  _removeUnreferencedMetasets() {
    const { _metasets: metasets, data: { datasets } } = this;
    if (metasets.length > datasets.length) {
      delete this._stacks;
    }
    metasets.forEach((meta, index2) => {
      if (datasets.filter((x) => x === meta._dataset).length === 0) {
        this._destroyDatasetMeta(index2);
      }
    });
  }
  buildOrUpdateControllers() {
    const newControllers = [];
    const datasets = this.data.datasets;
    let i, ilen;
    this._removeUnreferencedMetasets();
    for (i = 0, ilen = datasets.length; i < ilen; i++) {
      const dataset = datasets[i];
      let meta = this.getDatasetMeta(i);
      const type = dataset.type || this.config.type;
      if (meta.type && meta.type !== type) {
        this._destroyDatasetMeta(i);
        meta = this.getDatasetMeta(i);
      }
      meta.type = type;
      meta.indexAxis = dataset.indexAxis || getIndexAxis(type, this.options);
      meta.order = dataset.order || 0;
      meta.index = i;
      meta.label = "" + dataset.label;
      meta.visible = this.isDatasetVisible(i);
      if (meta.controller) {
        meta.controller.updateIndex(i);
        meta.controller.linkScales();
      } else {
        const ControllerClass = registry.getController(type);
        const { datasetElementType, dataElementType } = defaults.datasets[type];
        Object.assign(ControllerClass, {
          dataElementType: registry.getElement(dataElementType),
          datasetElementType: datasetElementType && registry.getElement(datasetElementType)
        });
        meta.controller = new ControllerClass(this, i);
        newControllers.push(meta.controller);
      }
    }
    this._updateMetasets();
    return newControllers;
  }
  _resetElements() {
    each(this.data.datasets, (dataset, datasetIndex) => {
      this.getDatasetMeta(datasetIndex).controller.reset();
    }, this);
  }
  reset() {
    this._resetElements();
    this.notifyPlugins("reset");
  }
  update(mode) {
    const config = this.config;
    config.update();
    const options = this._options = config.createResolver(config.chartOptionScopes(), this.getContext());
    const animsDisabled = this._animationsDisabled = !options.animation;
    this._updateScales();
    this._checkEventBindings();
    this._updateHiddenIndices();
    this._plugins.invalidate();
    if (this.notifyPlugins("beforeUpdate", {
      mode,
      cancelable: true
    }) === false) {
      return;
    }
    const newControllers = this.buildOrUpdateControllers();
    this.notifyPlugins("beforeElementsUpdate");
    let minPadding = 0;
    for (let i = 0, ilen = this.data.datasets.length; i < ilen; i++) {
      const { controller } = this.getDatasetMeta(i);
      const reset = !animsDisabled && newControllers.indexOf(controller) === -1;
      controller.buildOrUpdateElements(reset);
      minPadding = Math.max(+controller.getMaxOverflow(), minPadding);
    }
    minPadding = this._minPadding = options.layout.autoPadding ? minPadding : 0;
    this._updateLayout(minPadding);
    if (!animsDisabled) {
      each(newControllers, (controller) => {
        controller.reset();
      });
    }
    this._updateDatasets(mode);
    this.notifyPlugins("afterUpdate", {
      mode
    });
    this._layers.sort(compare2Level("z", "_idx"));
    const { _active, _lastEvent } = this;
    if (_lastEvent) {
      this._eventHandler(_lastEvent, true);
    } else if (_active.length) {
      this._updateHoverStyles(_active, _active, true);
    }
    this.render();
  }
  _updateScales() {
    each(this.scales, (scale) => {
      layouts.removeBox(this, scale);
    });
    this.ensureScalesHaveIDs();
    this.buildOrUpdateScales();
  }
  _checkEventBindings() {
    const options = this.options;
    const existingEvents = new Set(Object.keys(this._listeners));
    const newEvents = new Set(options.events);
    if (!setsEqual(existingEvents, newEvents) || !!this._responsiveListeners !== options.responsive) {
      this.unbindEvents();
      this.bindEvents();
    }
  }
  _updateHiddenIndices() {
    const { _hiddenIndices } = this;
    const changes = this._getUniformDataChanges() || [];
    for (const { method, start, count } of changes) {
      const move = method === "_removeElements" ? -count : count;
      moveNumericKeys(_hiddenIndices, start, move);
    }
  }
  _getUniformDataChanges() {
    const _dataChanges = this._dataChanges;
    if (!_dataChanges || !_dataChanges.length) {
      return;
    }
    this._dataChanges = [];
    const datasetCount = this.data.datasets.length;
    const makeSet = (idx) => new Set(_dataChanges.filter((c) => c[0] === idx).map((c, i) => i + "," + c.splice(1).join(",")));
    const changeSet = makeSet(0);
    for (let i = 1; i < datasetCount; i++) {
      if (!setsEqual(changeSet, makeSet(i))) {
        return;
      }
    }
    return Array.from(changeSet).map((c) => c.split(",")).map((a) => ({
      method: a[1],
      start: +a[2],
      count: +a[3]
    }));
  }
  _updateLayout(minPadding) {
    if (this.notifyPlugins("beforeLayout", {
      cancelable: true
    }) === false) {
      return;
    }
    layouts.update(this, this.width, this.height, minPadding);
    const area = this.chartArea;
    const noArea = area.width <= 0 || area.height <= 0;
    this._layers = [];
    each(this.boxes, (box) => {
      if (noArea && box.position === "chartArea") {
        return;
      }
      if (box.configure) {
        box.configure();
      }
      this._layers.push(...box._layers());
    }, this);
    this._layers.forEach((item, index2) => {
      item._idx = index2;
    });
    this.notifyPlugins("afterLayout");
  }
  _updateDatasets(mode) {
    if (this.notifyPlugins("beforeDatasetsUpdate", {
      mode,
      cancelable: true
    }) === false) {
      return;
    }
    for (let i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
      this.getDatasetMeta(i).controller.configure();
    }
    for (let i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
      this._updateDataset(i, isFunction(mode) ? mode({
        datasetIndex: i
      }) : mode);
    }
    this.notifyPlugins("afterDatasetsUpdate", {
      mode
    });
  }
  _updateDataset(index2, mode) {
    const meta = this.getDatasetMeta(index2);
    const args = {
      meta,
      index: index2,
      mode,
      cancelable: true
    };
    if (this.notifyPlugins("beforeDatasetUpdate", args) === false) {
      return;
    }
    meta.controller._update(mode);
    args.cancelable = false;
    this.notifyPlugins("afterDatasetUpdate", args);
  }
  render() {
    if (this.notifyPlugins("beforeRender", {
      cancelable: true
    }) === false) {
      return;
    }
    if (animator.has(this)) {
      if (this.attached && !animator.running(this)) {
        animator.start(this);
      }
    } else {
      this.draw();
      onAnimationsComplete({
        chart: this
      });
    }
  }
  draw() {
    let i;
    if (this._resizeBeforeDraw) {
      const { width, height } = this._resizeBeforeDraw;
      this._resizeBeforeDraw = null;
      this._resize(width, height);
    }
    this.clear();
    if (this.width <= 0 || this.height <= 0) {
      return;
    }
    if (this.notifyPlugins("beforeDraw", {
      cancelable: true
    }) === false) {
      return;
    }
    const layers = this._layers;
    for (i = 0; i < layers.length && layers[i].z <= 0; ++i) {
      layers[i].draw(this.chartArea);
    }
    this._drawDatasets();
    for (; i < layers.length; ++i) {
      layers[i].draw(this.chartArea);
    }
    this.notifyPlugins("afterDraw");
  }
  _getSortedDatasetMetas(filterVisible) {
    const metasets = this._sortedMetasets;
    const result = [];
    let i, ilen;
    for (i = 0, ilen = metasets.length; i < ilen; ++i) {
      const meta = metasets[i];
      if (!filterVisible || meta.visible) {
        result.push(meta);
      }
    }
    return result;
  }
  getSortedVisibleDatasetMetas() {
    return this._getSortedDatasetMetas(true);
  }
  _drawDatasets() {
    if (this.notifyPlugins("beforeDatasetsDraw", {
      cancelable: true
    }) === false) {
      return;
    }
    const metasets = this.getSortedVisibleDatasetMetas();
    for (let i = metasets.length - 1; i >= 0; --i) {
      this._drawDataset(metasets[i]);
    }
    this.notifyPlugins("afterDatasetsDraw");
  }
  _drawDataset(meta) {
    const ctx = this.ctx;
    const clip = meta._clip;
    const useClip = !clip.disabled;
    const area = getDatasetArea(meta, this.chartArea);
    const args = {
      meta,
      index: meta.index,
      cancelable: true
    };
    if (this.notifyPlugins("beforeDatasetDraw", args) === false) {
      return;
    }
    if (useClip) {
      clipArea(ctx, {
        left: clip.left === false ? 0 : area.left - clip.left,
        right: clip.right === false ? this.width : area.right + clip.right,
        top: clip.top === false ? 0 : area.top - clip.top,
        bottom: clip.bottom === false ? this.height : area.bottom + clip.bottom
      });
    }
    meta.controller.draw();
    if (useClip) {
      unclipArea(ctx);
    }
    args.cancelable = false;
    this.notifyPlugins("afterDatasetDraw", args);
  }
  isPointInArea(point) {
    return _isPointInArea(point, this.chartArea, this._minPadding);
  }
  getElementsAtEventForMode(e, mode, options, useFinalPosition) {
    const method = Interaction.modes[mode];
    if (typeof method === "function") {
      return method(this, e, options, useFinalPosition);
    }
    return [];
  }
  getDatasetMeta(datasetIndex) {
    const dataset = this.data.datasets[datasetIndex];
    const metasets = this._metasets;
    let meta = metasets.filter((x) => x && x._dataset === dataset).pop();
    if (!meta) {
      meta = {
        type: null,
        data: [],
        dataset: null,
        controller: null,
        hidden: null,
        xAxisID: null,
        yAxisID: null,
        order: dataset && dataset.order || 0,
        index: datasetIndex,
        _dataset: dataset,
        _parsed: [],
        _sorted: false
      };
      metasets.push(meta);
    }
    return meta;
  }
  getContext() {
    return this.$context || (this.$context = createContext(null, {
      chart: this,
      type: "chart"
    }));
  }
  getVisibleDatasetCount() {
    return this.getSortedVisibleDatasetMetas().length;
  }
  isDatasetVisible(datasetIndex) {
    const dataset = this.data.datasets[datasetIndex];
    if (!dataset) {
      return false;
    }
    const meta = this.getDatasetMeta(datasetIndex);
    return typeof meta.hidden === "boolean" ? !meta.hidden : !dataset.hidden;
  }
  setDatasetVisibility(datasetIndex, visible) {
    const meta = this.getDatasetMeta(datasetIndex);
    meta.hidden = !visible;
  }
  toggleDataVisibility(index2) {
    this._hiddenIndices[index2] = !this._hiddenIndices[index2];
  }
  getDataVisibility(index2) {
    return !this._hiddenIndices[index2];
  }
  _updateVisibility(datasetIndex, dataIndex, visible) {
    const mode = visible ? "show" : "hide";
    const meta = this.getDatasetMeta(datasetIndex);
    const anims = meta.controller._resolveAnimations(void 0, mode);
    if (defined(dataIndex)) {
      meta.data[dataIndex].hidden = !visible;
      this.update();
    } else {
      this.setDatasetVisibility(datasetIndex, visible);
      anims.update(meta, {
        visible
      });
      this.update((ctx) => ctx.datasetIndex === datasetIndex ? mode : void 0);
    }
  }
  hide(datasetIndex, dataIndex) {
    this._updateVisibility(datasetIndex, dataIndex, false);
  }
  show(datasetIndex, dataIndex) {
    this._updateVisibility(datasetIndex, dataIndex, true);
  }
  _destroyDatasetMeta(datasetIndex) {
    const meta = this._metasets[datasetIndex];
    if (meta && meta.controller) {
      meta.controller._destroy();
    }
    delete this._metasets[datasetIndex];
  }
  _stop() {
    let i, ilen;
    this.stop();
    animator.remove(this);
    for (i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
      this._destroyDatasetMeta(i);
    }
  }
  destroy() {
    this.notifyPlugins("beforeDestroy");
    const { canvas, ctx } = this;
    this._stop();
    this.config.clearCache();
    if (canvas) {
      this.unbindEvents();
      clearCanvas(canvas, ctx);
      this.platform.releaseContext(ctx);
      this.canvas = null;
      this.ctx = null;
    }
    delete instances[this.id];
    this.notifyPlugins("afterDestroy");
  }
  toBase64Image(...args) {
    return this.canvas.toDataURL(...args);
  }
  bindEvents() {
    this.bindUserEvents();
    if (this.options.responsive) {
      this.bindResponsiveEvents();
    } else {
      this.attached = true;
    }
  }
  bindUserEvents() {
    const listeners = this._listeners;
    const platform = this.platform;
    const _add = (type, listener2) => {
      platform.addEventListener(this, type, listener2);
      listeners[type] = listener2;
    };
    const listener = (e, x, y) => {
      e.offsetX = x;
      e.offsetY = y;
      this._eventHandler(e);
    };
    each(this.options.events, (type) => _add(type, listener));
  }
  bindResponsiveEvents() {
    if (!this._responsiveListeners) {
      this._responsiveListeners = {};
    }
    const listeners = this._responsiveListeners;
    const platform = this.platform;
    const _add = (type, listener2) => {
      platform.addEventListener(this, type, listener2);
      listeners[type] = listener2;
    };
    const _remove = (type, listener2) => {
      if (listeners[type]) {
        platform.removeEventListener(this, type, listener2);
        delete listeners[type];
      }
    };
    const listener = (width, height) => {
      if (this.canvas) {
        this.resize(width, height);
      }
    };
    let detached;
    const attached = () => {
      _remove("attach", attached);
      this.attached = true;
      this.resize();
      _add("resize", listener);
      _add("detach", detached);
    };
    detached = () => {
      this.attached = false;
      _remove("resize", listener);
      this._stop();
      this._resize(0, 0);
      _add("attach", attached);
    };
    if (platform.isAttached(this.canvas)) {
      attached();
    } else {
      detached();
    }
  }
  unbindEvents() {
    each(this._listeners, (listener, type) => {
      this.platform.removeEventListener(this, type, listener);
    });
    this._listeners = {};
    each(this._responsiveListeners, (listener, type) => {
      this.platform.removeEventListener(this, type, listener);
    });
    this._responsiveListeners = void 0;
  }
  updateHoverStyle(items, mode, enabled) {
    const prefix = enabled ? "set" : "remove";
    let meta, item, i, ilen;
    if (mode === "dataset") {
      meta = this.getDatasetMeta(items[0].datasetIndex);
      meta.controller["_" + prefix + "DatasetHoverStyle"]();
    }
    for (i = 0, ilen = items.length; i < ilen; ++i) {
      item = items[i];
      const controller = item && this.getDatasetMeta(item.datasetIndex).controller;
      if (controller) {
        controller[prefix + "HoverStyle"](item.element, item.datasetIndex, item.index);
      }
    }
  }
  getActiveElements() {
    return this._active || [];
  }
  setActiveElements(activeElements) {
    const lastActive = this._active || [];
    const active = activeElements.map(({ datasetIndex, index: index2 }) => {
      const meta = this.getDatasetMeta(datasetIndex);
      if (!meta) {
        throw new Error("No dataset found at index " + datasetIndex);
      }
      return {
        datasetIndex,
        element: meta.data[index2],
        index: index2
      };
    });
    const changed = !_elementsEqual(active, lastActive);
    if (changed) {
      this._active = active;
      this._lastEvent = null;
      this._updateHoverStyles(active, lastActive);
    }
  }
  notifyPlugins(hook, args, filter) {
    return this._plugins.notify(this, hook, args, filter);
  }
  isPluginEnabled(pluginId) {
    return this._plugins._cache.filter((p) => p.plugin.id === pluginId).length === 1;
  }
  _updateHoverStyles(active, lastActive, replay) {
    const hoverOptions = this.options.hover;
    const diff = (a, b) => a.filter((x) => !b.some((y) => x.datasetIndex === y.datasetIndex && x.index === y.index));
    const deactivated = diff(lastActive, active);
    const activated = replay ? active : diff(active, lastActive);
    if (deactivated.length) {
      this.updateHoverStyle(deactivated, hoverOptions.mode, false);
    }
    if (activated.length && hoverOptions.mode) {
      this.updateHoverStyle(activated, hoverOptions.mode, true);
    }
  }
  _eventHandler(e, replay) {
    const args = {
      event: e,
      replay,
      cancelable: true,
      inChartArea: this.isPointInArea(e)
    };
    const eventFilter = (plugin) => (plugin.options.events || this.options.events).includes(e.native.type);
    if (this.notifyPlugins("beforeEvent", args, eventFilter) === false) {
      return;
    }
    const changed = this._handleEvent(e, replay, args.inChartArea);
    args.cancelable = false;
    this.notifyPlugins("afterEvent", args, eventFilter);
    if (changed || args.changed) {
      this.render();
    }
    return this;
  }
  _handleEvent(e, replay, inChartArea) {
    const { _active: lastActive = [], options } = this;
    const useFinalPosition = replay;
    const active = this._getActiveElements(e, lastActive, inChartArea, useFinalPosition);
    const isClick = _isClickEvent(e);
    const lastEvent = determineLastEvent(e, this._lastEvent, inChartArea, isClick);
    if (inChartArea) {
      this._lastEvent = null;
      callback(options.onHover, [
        e,
        active,
        this
      ], this);
      if (isClick) {
        callback(options.onClick, [
          e,
          active,
          this
        ], this);
      }
    }
    const changed = !_elementsEqual(active, lastActive);
    if (changed || replay) {
      this._active = active;
      this._updateHoverStyles(active, lastActive, replay);
    }
    this._lastEvent = lastEvent;
    return changed;
  }
  _getActiveElements(e, lastActive, inChartArea, useFinalPosition) {
    if (e.type === "mouseout") {
      return [];
    }
    if (!inChartArea) {
      return lastActive;
    }
    const hoverOptions = this.options.hover;
    return this.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions, useFinalPosition);
  }
};
function invalidatePlugins() {
  return each(Chart.instances, (chart) => chart._plugins.invalidate());
}
function setStyle(ctx, options, style = options) {
  ctx.lineCap = valueOrDefault(style.borderCapStyle, options.borderCapStyle);
  ctx.setLineDash(valueOrDefault(style.borderDash, options.borderDash));
  ctx.lineDashOffset = valueOrDefault(style.borderDashOffset, options.borderDashOffset);
  ctx.lineJoin = valueOrDefault(style.borderJoinStyle, options.borderJoinStyle);
  ctx.lineWidth = valueOrDefault(style.borderWidth, options.borderWidth);
  ctx.strokeStyle = valueOrDefault(style.borderColor, options.borderColor);
}
function lineTo(ctx, previous, target) {
  ctx.lineTo(target.x, target.y);
}
function getLineMethod(options) {
  if (options.stepped) {
    return _steppedLineTo;
  }
  if (options.tension || options.cubicInterpolationMode === "monotone") {
    return _bezierCurveTo;
  }
  return lineTo;
}
function pathVars(points, segment, params = {}) {
  const count = points.length;
  const { start: paramsStart = 0, end: paramsEnd = count - 1 } = params;
  const { start: segmentStart, end: segmentEnd } = segment;
  const start = Math.max(paramsStart, segmentStart);
  const end = Math.min(paramsEnd, segmentEnd);
  const outside = paramsStart < segmentStart && paramsEnd < segmentStart || paramsStart > segmentEnd && paramsEnd > segmentEnd;
  return {
    count,
    start,
    loop: segment.loop,
    ilen: end < start && !outside ? count + end - start : end - start
  };
}
function pathSegment(ctx, line, segment, params) {
  const { points, options } = line;
  const { count, start, loop, ilen } = pathVars(points, segment, params);
  const lineMethod = getLineMethod(options);
  let { move = true, reverse } = params || {};
  let i, point, prev;
  for (i = 0; i <= ilen; ++i) {
    point = points[(start + (reverse ? ilen - i : i)) % count];
    if (point.skip) {
      continue;
    } else if (move) {
      ctx.moveTo(point.x, point.y);
      move = false;
    } else {
      lineMethod(ctx, prev, point, reverse, options.stepped);
    }
    prev = point;
  }
  if (loop) {
    point = points[(start + (reverse ? ilen : 0)) % count];
    lineMethod(ctx, prev, point, reverse, options.stepped);
  }
  return !!loop;
}
function fastPathSegment(ctx, line, segment, params) {
  const points = line.points;
  const { count, start, ilen } = pathVars(points, segment, params);
  const { move = true, reverse } = params || {};
  let avgX = 0;
  let countX = 0;
  let i, point, prevX, minY, maxY, lastY;
  const pointIndex = (index2) => (start + (reverse ? ilen - index2 : index2)) % count;
  const drawX = () => {
    if (minY !== maxY) {
      ctx.lineTo(avgX, maxY);
      ctx.lineTo(avgX, minY);
      ctx.lineTo(avgX, lastY);
    }
  };
  if (move) {
    point = points[pointIndex(0)];
    ctx.moveTo(point.x, point.y);
  }
  for (i = 0; i <= ilen; ++i) {
    point = points[pointIndex(i)];
    if (point.skip) {
      continue;
    }
    const x = point.x;
    const y = point.y;
    const truncX = x | 0;
    if (truncX === prevX) {
      if (y < minY) {
        minY = y;
      } else if (y > maxY) {
        maxY = y;
      }
      avgX = (countX * avgX + x) / ++countX;
    } else {
      drawX();
      ctx.lineTo(x, y);
      prevX = truncX;
      countX = 0;
      minY = maxY = y;
    }
    lastY = y;
  }
  drawX();
}
function _getSegmentMethod(line) {
  const opts = line.options;
  const borderDash = opts.borderDash && opts.borderDash.length;
  const useFastPath = !line._decimated && !line._loop && !opts.tension && opts.cubicInterpolationMode !== "monotone" && !opts.stepped && !borderDash;
  return useFastPath ? fastPathSegment : pathSegment;
}
function _getInterpolationMethod(options) {
  if (options.stepped) {
    return _steppedInterpolation;
  }
  if (options.tension || options.cubicInterpolationMode === "monotone") {
    return _bezierInterpolation;
  }
  return _pointInLine;
}
function strokePathWithCache(ctx, line, start, count) {
  let path = line._path;
  if (!path) {
    path = line._path = new Path2D();
    if (line.path(path, start, count)) {
      path.closePath();
    }
  }
  setStyle(ctx, line.options);
  ctx.stroke(path);
}
function strokePathDirect(ctx, line, start, count) {
  const { segments, options } = line;
  const segmentMethod = _getSegmentMethod(line);
  for (const segment of segments) {
    setStyle(ctx, options, segment.style);
    ctx.beginPath();
    if (segmentMethod(ctx, line, segment, {
      start,
      end: start + count - 1
    })) {
      ctx.closePath();
    }
    ctx.stroke();
  }
}
var usePath2D = typeof Path2D === "function";
function draw(ctx, line, start, count) {
  if (usePath2D && !line.options.segment) {
    strokePathWithCache(ctx, line, start, count);
  } else {
    strokePathDirect(ctx, line, start, count);
  }
}
var LineElement = class extends Element {
  static id = "line";
  static defaults = {
    borderCapStyle: "butt",
    borderDash: [],
    borderDashOffset: 0,
    borderJoinStyle: "miter",
    borderWidth: 3,
    capBezierPoints: true,
    cubicInterpolationMode: "default",
    fill: false,
    spanGaps: false,
    stepped: false,
    tension: 0
  };
  static defaultRoutes = {
    backgroundColor: "backgroundColor",
    borderColor: "borderColor"
  };
  static descriptors = {
    _scriptable: true,
    _indexable: (name) => name !== "borderDash" && name !== "fill"
  };
  constructor(cfg) {
    super();
    this.animated = true;
    this.options = void 0;
    this._chart = void 0;
    this._loop = void 0;
    this._fullLoop = void 0;
    this._path = void 0;
    this._points = void 0;
    this._segments = void 0;
    this._decimated = false;
    this._pointsUpdated = false;
    this._datasetIndex = void 0;
    if (cfg) {
      Object.assign(this, cfg);
    }
  }
  updateControlPoints(chartArea, indexAxis) {
    const options = this.options;
    if ((options.tension || options.cubicInterpolationMode === "monotone") && !options.stepped && !this._pointsUpdated) {
      const loop = options.spanGaps ? this._loop : this._fullLoop;
      _updateBezierControlPoints(this._points, options, chartArea, loop, indexAxis);
      this._pointsUpdated = true;
    }
  }
  set points(points) {
    this._points = points;
    delete this._segments;
    delete this._path;
    this._pointsUpdated = false;
  }
  get points() {
    return this._points;
  }
  get segments() {
    return this._segments || (this._segments = _computeSegments(this, this.options.segment));
  }
  first() {
    const segments = this.segments;
    const points = this.points;
    return segments.length && points[segments[0].start];
  }
  last() {
    const segments = this.segments;
    const points = this.points;
    const count = segments.length;
    return count && points[segments[count - 1].end];
  }
  interpolate(point, property) {
    const options = this.options;
    const value = point[property];
    const points = this.points;
    const segments = _boundSegments(this, {
      property,
      start: value,
      end: value
    });
    if (!segments.length) {
      return;
    }
    const result = [];
    const _interpolate = _getInterpolationMethod(options);
    let i, ilen;
    for (i = 0, ilen = segments.length; i < ilen; ++i) {
      const { start, end } = segments[i];
      const p1 = points[start];
      const p2 = points[end];
      if (p1 === p2) {
        result.push(p1);
        continue;
      }
      const t = Math.abs((value - p1[property]) / (p2[property] - p1[property]));
      const interpolated = _interpolate(p1, p2, t, options.stepped);
      interpolated[property] = point[property];
      result.push(interpolated);
    }
    return result.length === 1 ? result[0] : result;
  }
  pathSegment(ctx, segment, params) {
    const segmentMethod = _getSegmentMethod(this);
    return segmentMethod(ctx, this, segment, params);
  }
  path(ctx, start, count) {
    const segments = this.segments;
    const segmentMethod = _getSegmentMethod(this);
    let loop = this._loop;
    start = start || 0;
    count = count || this.points.length - start;
    for (const segment of segments) {
      loop &= segmentMethod(ctx, this, segment, {
        start,
        end: start + count - 1
      });
    }
    return !!loop;
  }
  draw(ctx, chartArea, start, count) {
    const options = this.options || {};
    const points = this.points || [];
    if (points.length && options.borderWidth) {
      ctx.save();
      draw(ctx, this, start, count);
      ctx.restore();
    }
    if (this.animated) {
      this._pointsUpdated = false;
      this._path = void 0;
    }
  }
};
function inRange$1(el, pos, axis, useFinalPosition) {
  const options = el.options;
  const { [axis]: value } = el.getProps([
    axis
  ], useFinalPosition);
  return Math.abs(pos - value) < options.radius + options.hitRadius;
}
var PointElement = class extends Element {
  static id = "point";
  parsed;
  skip;
  stop;
  /**
  * @type {any}
  */
  static defaults = {
    borderWidth: 1,
    hitRadius: 1,
    hoverBorderWidth: 1,
    hoverRadius: 4,
    pointStyle: "circle",
    radius: 3,
    rotation: 0
  };
  /**
  * @type {any}
  */
  static defaultRoutes = {
    backgroundColor: "backgroundColor",
    borderColor: "borderColor"
  };
  constructor(cfg) {
    super();
    this.options = void 0;
    this.parsed = void 0;
    this.skip = void 0;
    this.stop = void 0;
    if (cfg) {
      Object.assign(this, cfg);
    }
  }
  inRange(mouseX, mouseY, useFinalPosition) {
    const options = this.options;
    const { x, y } = this.getProps([
      "x",
      "y"
    ], useFinalPosition);
    return Math.pow(mouseX - x, 2) + Math.pow(mouseY - y, 2) < Math.pow(options.hitRadius + options.radius, 2);
  }
  inXRange(mouseX, useFinalPosition) {
    return inRange$1(this, mouseX, "x", useFinalPosition);
  }
  inYRange(mouseY, useFinalPosition) {
    return inRange$1(this, mouseY, "y", useFinalPosition);
  }
  getCenterPoint(useFinalPosition) {
    const { x, y } = this.getProps([
      "x",
      "y"
    ], useFinalPosition);
    return {
      x,
      y
    };
  }
  size(options) {
    options = options || this.options || {};
    let radius = options.radius || 0;
    radius = Math.max(radius, radius && options.hoverRadius || 0);
    const borderWidth = radius && options.borderWidth || 0;
    return (radius + borderWidth) * 2;
  }
  draw(ctx, area) {
    const options = this.options;
    if (this.skip || options.radius < 0.1 || !_isPointInArea(this, area, this.size(options) / 2)) {
      return;
    }
    ctx.strokeStyle = options.borderColor;
    ctx.lineWidth = options.borderWidth;
    ctx.fillStyle = options.backgroundColor;
    drawPoint(ctx, options, this.x, this.y);
  }
  getRange() {
    const options = this.options || {};
    return options.radius + options.hitRadius;
  }
};
function _segments(line, target, property) {
  const segments = line.segments;
  const points = line.points;
  const tpoints = target.points;
  const parts = [];
  for (const segment of segments) {
    let { start, end } = segment;
    end = _findSegmentEnd(start, end, points);
    const bounds = _getBounds(property, points[start], points[end], segment.loop);
    if (!target.segments) {
      parts.push({
        source: segment,
        target: bounds,
        start: points[start],
        end: points[end]
      });
      continue;
    }
    const targetSegments = _boundSegments(target, bounds);
    for (const tgt of targetSegments) {
      const subBounds = _getBounds(property, tpoints[tgt.start], tpoints[tgt.end], tgt.loop);
      const fillSources = _boundSegment(segment, points, subBounds);
      for (const fillSource of fillSources) {
        parts.push({
          source: fillSource,
          target: tgt,
          start: {
            [property]: _getEdge(bounds, subBounds, "start", Math.max)
          },
          end: {
            [property]: _getEdge(bounds, subBounds, "end", Math.min)
          }
        });
      }
    }
  }
  return parts;
}
function _getBounds(property, first, last, loop) {
  if (loop) {
    return;
  }
  let start = first[property];
  let end = last[property];
  if (property === "angle") {
    start = _normalizeAngle(start);
    end = _normalizeAngle(end);
  }
  return {
    property,
    start,
    end
  };
}
function _pointsFromSegments(boundary, line) {
  const { x = null, y = null } = boundary || {};
  const linePoints = line.points;
  const points = [];
  line.segments.forEach(({ start, end }) => {
    end = _findSegmentEnd(start, end, linePoints);
    const first = linePoints[start];
    const last = linePoints[end];
    if (y !== null) {
      points.push({
        x: first.x,
        y
      });
      points.push({
        x: last.x,
        y
      });
    } else if (x !== null) {
      points.push({
        x,
        y: first.y
      });
      points.push({
        x,
        y: last.y
      });
    }
  });
  return points;
}
function _findSegmentEnd(start, end, points) {
  for (; end > start; end--) {
    const point = points[end];
    if (!isNaN(point.x) && !isNaN(point.y)) {
      break;
    }
  }
  return end;
}
function _getEdge(a, b, prop, fn) {
  if (a && b) {
    return fn(a[prop], b[prop]);
  }
  return a ? a[prop] : b ? b[prop] : 0;
}
function _createBoundaryLine(boundary, line) {
  let points = [];
  let _loop = false;
  if (isArray(boundary)) {
    _loop = true;
    points = boundary;
  } else {
    points = _pointsFromSegments(boundary, line);
  }
  return points.length ? new LineElement({
    points,
    options: {
      tension: 0
    },
    _loop,
    _fullLoop: _loop
  }) : null;
}
function _shouldApplyFill(source) {
  return source && source.fill !== false;
}
function _resolveTarget(sources, index2, propagate) {
  const source = sources[index2];
  let fill2 = source.fill;
  const visited = [
    index2
  ];
  let target;
  if (!propagate) {
    return fill2;
  }
  while (fill2 !== false && visited.indexOf(fill2) === -1) {
    if (!isNumberFinite(fill2)) {
      return fill2;
    }
    target = sources[fill2];
    if (!target) {
      return false;
    }
    if (target.visible) {
      return fill2;
    }
    visited.push(fill2);
    fill2 = target.fill;
  }
  return false;
}
function _decodeFill(line, index2, count) {
  const fill2 = parseFillOption(line);
  if (isObject(fill2)) {
    return isNaN(fill2.value) ? false : fill2;
  }
  let target = parseFloat(fill2);
  if (isNumberFinite(target) && Math.floor(target) === target) {
    return decodeTargetIndex(fill2[0], index2, target, count);
  }
  return [
    "origin",
    "start",
    "end",
    "stack",
    "shape"
  ].indexOf(fill2) >= 0 && fill2;
}
function decodeTargetIndex(firstCh, index2, target, count) {
  if (firstCh === "-" || firstCh === "+") {
    target = index2 + target;
  }
  if (target === index2 || target < 0 || target >= count) {
    return false;
  }
  return target;
}
function _getTargetPixel(fill2, scale) {
  let pixel = null;
  if (fill2 === "start") {
    pixel = scale.bottom;
  } else if (fill2 === "end") {
    pixel = scale.top;
  } else if (isObject(fill2)) {
    pixel = scale.getPixelForValue(fill2.value);
  } else if (scale.getBasePixel) {
    pixel = scale.getBasePixel();
  }
  return pixel;
}
function _getTargetValue(fill2, scale, startValue) {
  let value;
  if (fill2 === "start") {
    value = startValue;
  } else if (fill2 === "end") {
    value = scale.options.reverse ? scale.min : scale.max;
  } else if (isObject(fill2)) {
    value = fill2.value;
  } else {
    value = scale.getBaseValue();
  }
  return value;
}
function parseFillOption(line) {
  const options = line.options;
  const fillOption = options.fill;
  let fill2 = valueOrDefault(fillOption && fillOption.target, fillOption);
  if (fill2 === void 0) {
    fill2 = !!options.backgroundColor;
  }
  if (fill2 === false || fill2 === null) {
    return false;
  }
  if (fill2 === true) {
    return "origin";
  }
  return fill2;
}
function _buildStackLine(source) {
  const { scale, index: index2, line } = source;
  const points = [];
  const segments = line.segments;
  const sourcePoints = line.points;
  const linesBelow = getLinesBelow(scale, index2);
  linesBelow.push(_createBoundaryLine({
    x: null,
    y: scale.bottom
  }, line));
  for (let i = 0; i < segments.length; i++) {
    const segment = segments[i];
    for (let j = segment.start; j <= segment.end; j++) {
      addPointsBelow(points, sourcePoints[j], linesBelow);
    }
  }
  return new LineElement({
    points,
    options: {}
  });
}
function getLinesBelow(scale, index2) {
  const below = [];
  const metas = scale.getMatchingVisibleMetas("line");
  for (let i = 0; i < metas.length; i++) {
    const meta = metas[i];
    if (meta.index === index2) {
      break;
    }
    if (!meta.hidden) {
      below.unshift(meta.dataset);
    }
  }
  return below;
}
function addPointsBelow(points, sourcePoint, linesBelow) {
  const postponed = [];
  for (let j = 0; j < linesBelow.length; j++) {
    const line = linesBelow[j];
    const { first, last, point } = findPoint(line, sourcePoint, "x");
    if (!point || first && last) {
      continue;
    }
    if (first) {
      postponed.unshift(point);
    } else {
      points.push(point);
      if (!last) {
        break;
      }
    }
  }
  points.push(...postponed);
}
function findPoint(line, sourcePoint, property) {
  const point = line.interpolate(sourcePoint, property);
  if (!point) {
    return {};
  }
  const pointValue = point[property];
  const segments = line.segments;
  const linePoints = line.points;
  let first = false;
  let last = false;
  for (let i = 0; i < segments.length; i++) {
    const segment = segments[i];
    const firstValue = linePoints[segment.start][property];
    const lastValue = linePoints[segment.end][property];
    if (_isBetween(pointValue, firstValue, lastValue)) {
      first = pointValue === firstValue;
      last = pointValue === lastValue;
      break;
    }
  }
  return {
    first,
    last,
    point
  };
}
var simpleArc = class {
  constructor(opts) {
    this.x = opts.x;
    this.y = opts.y;
    this.radius = opts.radius;
  }
  pathSegment(ctx, bounds, opts) {
    const { x, y, radius } = this;
    bounds = bounds || {
      start: 0,
      end: TAU
    };
    ctx.arc(x, y, radius, bounds.end, bounds.start, true);
    return !opts.bounds;
  }
  interpolate(point) {
    const { x, y, radius } = this;
    const angle = point.angle;
    return {
      x: x + Math.cos(angle) * radius,
      y: y + Math.sin(angle) * radius,
      angle
    };
  }
};
function _getTarget(source) {
  const { chart, fill: fill2, line } = source;
  if (isNumberFinite(fill2)) {
    return getLineByIndex(chart, fill2);
  }
  if (fill2 === "stack") {
    return _buildStackLine(source);
  }
  if (fill2 === "shape") {
    return true;
  }
  const boundary = computeBoundary(source);
  if (boundary instanceof simpleArc) {
    return boundary;
  }
  return _createBoundaryLine(boundary, line);
}
function getLineByIndex(chart, index2) {
  const meta = chart.getDatasetMeta(index2);
  const visible = meta && chart.isDatasetVisible(index2);
  return visible ? meta.dataset : null;
}
function computeBoundary(source) {
  const scale = source.scale || {};
  if (scale.getPointPositionForValue) {
    return computeCircularBoundary(source);
  }
  return computeLinearBoundary(source);
}
function computeLinearBoundary(source) {
  const { scale = {}, fill: fill2 } = source;
  const pixel = _getTargetPixel(fill2, scale);
  if (isNumberFinite(pixel)) {
    const horizontal = scale.isHorizontal();
    return {
      x: horizontal ? pixel : null,
      y: horizontal ? null : pixel
    };
  }
  return null;
}
function computeCircularBoundary(source) {
  const { scale, fill: fill2 } = source;
  const options = scale.options;
  const length = scale.getLabels().length;
  const start = options.reverse ? scale.max : scale.min;
  const value = _getTargetValue(fill2, scale, start);
  const target = [];
  if (options.grid.circular) {
    const center = scale.getPointPositionForValue(0, start);
    return new simpleArc({
      x: center.x,
      y: center.y,
      radius: scale.getDistanceFromCenterForValue(value)
    });
  }
  for (let i = 0; i < length; ++i) {
    target.push(scale.getPointPositionForValue(i, value));
  }
  return target;
}
function _drawfill(ctx, source, area) {
  const target = _getTarget(source);
  const { line, scale, axis } = source;
  const lineOpts = line.options;
  const fillOption = lineOpts.fill;
  const color2 = lineOpts.backgroundColor;
  const { above = color2, below = color2 } = fillOption || {};
  if (target && line.points.length) {
    clipArea(ctx, area);
    doFill(ctx, {
      line,
      target,
      above,
      below,
      area,
      scale,
      axis
    });
    unclipArea(ctx);
  }
}
function doFill(ctx, cfg) {
  const { line, target, above, below, area, scale } = cfg;
  const property = line._loop ? "angle" : cfg.axis;
  ctx.save();
  if (property === "x" && below !== above) {
    clipVertical(ctx, target, area.top);
    fill(ctx, {
      line,
      target,
      color: above,
      scale,
      property
    });
    ctx.restore();
    ctx.save();
    clipVertical(ctx, target, area.bottom);
  }
  fill(ctx, {
    line,
    target,
    color: below,
    scale,
    property
  });
  ctx.restore();
}
function clipVertical(ctx, target, clipY) {
  const { segments, points } = target;
  let first = true;
  let lineLoop = false;
  ctx.beginPath();
  for (const segment of segments) {
    const { start, end } = segment;
    const firstPoint = points[start];
    const lastPoint = points[_findSegmentEnd(start, end, points)];
    if (first) {
      ctx.moveTo(firstPoint.x, firstPoint.y);
      first = false;
    } else {
      ctx.lineTo(firstPoint.x, clipY);
      ctx.lineTo(firstPoint.x, firstPoint.y);
    }
    lineLoop = !!target.pathSegment(ctx, segment, {
      move: lineLoop
    });
    if (lineLoop) {
      ctx.closePath();
    } else {
      ctx.lineTo(lastPoint.x, clipY);
    }
  }
  ctx.lineTo(target.first().x, clipY);
  ctx.closePath();
  ctx.clip();
}
function fill(ctx, cfg) {
  const { line, target, property, color: color2, scale } = cfg;
  const segments = _segments(line, target, property);
  for (const { source: src, target: tgt, start, end } of segments) {
    const { style: { backgroundColor = color2 } = {} } = src;
    const notShape = target !== true;
    ctx.save();
    ctx.fillStyle = backgroundColor;
    clipBounds(ctx, scale, notShape && _getBounds(property, start, end));
    ctx.beginPath();
    const lineLoop = !!line.pathSegment(ctx, src);
    let loop;
    if (notShape) {
      if (lineLoop) {
        ctx.closePath();
      } else {
        interpolatedLineTo(ctx, target, end, property);
      }
      const targetLoop = !!target.pathSegment(ctx, tgt, {
        move: lineLoop,
        reverse: true
      });
      loop = lineLoop && targetLoop;
      if (!loop) {
        interpolatedLineTo(ctx, target, start, property);
      }
    }
    ctx.closePath();
    ctx.fill(loop ? "evenodd" : "nonzero");
    ctx.restore();
  }
}
function clipBounds(ctx, scale, bounds) {
  const { top, bottom } = scale.chart.chartArea;
  const { property, start, end } = bounds || {};
  if (property === "x") {
    ctx.beginPath();
    ctx.rect(start, top, end - start, bottom - top);
    ctx.clip();
  }
}
function interpolatedLineTo(ctx, target, point, property) {
  const interpolatedPoint = target.interpolate(point, property);
  if (interpolatedPoint) {
    ctx.lineTo(interpolatedPoint.x, interpolatedPoint.y);
  }
}
var index = {
  id: "filler",
  afterDatasetsUpdate(chart, _args, options) {
    const count = (chart.data.datasets || []).length;
    const sources = [];
    let meta, i, line, source;
    for (i = 0; i < count; ++i) {
      meta = chart.getDatasetMeta(i);
      line = meta.dataset;
      source = null;
      if (line && line.options && line instanceof LineElement) {
        source = {
          visible: chart.isDatasetVisible(i),
          index: i,
          fill: _decodeFill(line, i, count),
          chart,
          axis: meta.controller.options.indexAxis,
          scale: meta.vScale,
          line
        };
      }
      meta.$filler = source;
      sources.push(source);
    }
    for (i = 0; i < count; ++i) {
      source = sources[i];
      if (!source || source.fill === false) {
        continue;
      }
      source.fill = _resolveTarget(sources, i, options.propagate);
    }
  },
  beforeDraw(chart, _args, options) {
    const draw2 = options.drawTime === "beforeDraw";
    const metasets = chart.getSortedVisibleDatasetMetas();
    const area = chart.chartArea;
    for (let i = metasets.length - 1; i >= 0; --i) {
      const source = metasets[i].$filler;
      if (!source) {
        continue;
      }
      source.line.updateControlPoints(area, source.axis);
      if (draw2 && source.fill) {
        _drawfill(chart.ctx, source, area);
      }
    }
  },
  beforeDatasetsDraw(chart, _args, options) {
    if (options.drawTime !== "beforeDatasetsDraw") {
      return;
    }
    const metasets = chart.getSortedVisibleDatasetMetas();
    for (let i = metasets.length - 1; i >= 0; --i) {
      const source = metasets[i].$filler;
      if (_shouldApplyFill(source)) {
        _drawfill(chart.ctx, source, chart.chartArea);
      }
    }
  },
  beforeDatasetDraw(chart, args, options) {
    const source = args.meta.$filler;
    if (!_shouldApplyFill(source) || options.drawTime !== "beforeDatasetDraw") {
      return;
    }
    _drawfill(chart.ctx, source, chart.chartArea);
  },
  defaults: {
    propagate: true,
    drawTime: "beforeDatasetDraw"
  }
};
var Title = class extends Element {
  constructor(config) {
    super();
    this.chart = config.chart;
    this.options = config.options;
    this.ctx = config.ctx;
    this._padding = void 0;
    this.top = void 0;
    this.bottom = void 0;
    this.left = void 0;
    this.right = void 0;
    this.width = void 0;
    this.height = void 0;
    this.position = void 0;
    this.weight = void 0;
    this.fullSize = void 0;
  }
  update(maxWidth, maxHeight) {
    const opts = this.options;
    this.left = 0;
    this.top = 0;
    if (!opts.display) {
      this.width = this.height = this.right = this.bottom = 0;
      return;
    }
    this.width = this.right = maxWidth;
    this.height = this.bottom = maxHeight;
    const lineCount = isArray(opts.text) ? opts.text.length : 1;
    this._padding = toPadding(opts.padding);
    const textSize = lineCount * toFont(opts.font).lineHeight + this._padding.height;
    if (this.isHorizontal()) {
      this.height = textSize;
    } else {
      this.width = textSize;
    }
  }
  isHorizontal() {
    const pos = this.options.position;
    return pos === "top" || pos === "bottom";
  }
  _drawArgs(offset) {
    const { top, left, bottom, right, options } = this;
    const align = options.align;
    let rotation = 0;
    let maxWidth, titleX, titleY;
    if (this.isHorizontal()) {
      titleX = _alignStartEnd(align, left, right);
      titleY = top + offset;
      maxWidth = right - left;
    } else {
      if (options.position === "left") {
        titleX = left + offset;
        titleY = _alignStartEnd(align, bottom, top);
        rotation = PI * -0.5;
      } else {
        titleX = right - offset;
        titleY = _alignStartEnd(align, top, bottom);
        rotation = PI * 0.5;
      }
      maxWidth = bottom - top;
    }
    return {
      titleX,
      titleY,
      maxWidth,
      rotation
    };
  }
  draw() {
    const ctx = this.ctx;
    const opts = this.options;
    if (!opts.display) {
      return;
    }
    const fontOpts = toFont(opts.font);
    const lineHeight = fontOpts.lineHeight;
    const offset = lineHeight / 2 + this._padding.top;
    const { titleX, titleY, maxWidth, rotation } = this._drawArgs(offset);
    renderText(ctx, opts.text, 0, 0, fontOpts, {
      color: opts.color,
      maxWidth,
      rotation,
      textAlign: _toLeftRightCenter(opts.align),
      textBaseline: "middle",
      translation: [
        titleX,
        titleY
      ]
    });
  }
};
function createTitle(chart, titleOpts) {
  const title = new Title({
    ctx: chart.ctx,
    options: titleOpts,
    chart
  });
  layouts.configure(chart, title, titleOpts);
  layouts.addBox(chart, title);
  chart.titleBlock = title;
}
var plugin_title = {
  id: "title",
  _element: Title,
  start(chart, _args, options) {
    createTitle(chart, options);
  },
  stop(chart) {
    const titleBlock = chart.titleBlock;
    layouts.removeBox(chart, titleBlock);
    delete chart.titleBlock;
  },
  beforeUpdate(chart, _args, options) {
    const title = chart.titleBlock;
    layouts.configure(chart, title, options);
    title.options = options;
  },
  defaults: {
    align: "center",
    display: false,
    font: {
      weight: "bold"
    },
    fullSize: true,
    padding: 10,
    position: "top",
    text: "",
    weight: 2e3
  },
  defaultRoutes: {
    color: "color"
  },
  descriptors: {
    _scriptable: true,
    _indexable: false
  }
};
var positioners = {
  average(items) {
    if (!items.length) {
      return false;
    }
    let i, len;
    let xSet = /* @__PURE__ */ new Set();
    let y = 0;
    let count = 0;
    for (i = 0, len = items.length; i < len; ++i) {
      const el = items[i].element;
      if (el && el.hasValue()) {
        const pos = el.tooltipPosition();
        xSet.add(pos.x);
        y += pos.y;
        ++count;
      }
    }
    if (count === 0 || xSet.size === 0) {
      return false;
    }
    const xAverage = [
      ...xSet
    ].reduce((a, b) => a + b) / xSet.size;
    return {
      x: xAverage,
      y: y / count
    };
  },
  nearest(items, eventPosition) {
    if (!items.length) {
      return false;
    }
    let x = eventPosition.x;
    let y = eventPosition.y;
    let minDistance = Number.POSITIVE_INFINITY;
    let i, len, nearestElement;
    for (i = 0, len = items.length; i < len; ++i) {
      const el = items[i].element;
      if (el && el.hasValue()) {
        const center = el.getCenterPoint();
        const d = distanceBetweenPoints(eventPosition, center);
        if (d < minDistance) {
          minDistance = d;
          nearestElement = el;
        }
      }
    }
    if (nearestElement) {
      const tp = nearestElement.tooltipPosition();
      x = tp.x;
      y = tp.y;
    }
    return {
      x,
      y
    };
  }
};
function pushOrConcat(base, toPush) {
  if (toPush) {
    if (isArray(toPush)) {
      Array.prototype.push.apply(base, toPush);
    } else {
      base.push(toPush);
    }
  }
  return base;
}
function splitNewlines(str) {
  if ((typeof str === "string" || str instanceof String) && str.indexOf("\n") > -1) {
    return str.split("\n");
  }
  return str;
}
function createTooltipItem(chart, item) {
  const { element, datasetIndex, index: index2 } = item;
  const controller = chart.getDatasetMeta(datasetIndex).controller;
  const { label, value } = controller.getLabelAndValue(index2);
  return {
    chart,
    label,
    parsed: controller.getParsed(index2),
    raw: chart.data.datasets[datasetIndex].data[index2],
    formattedValue: value,
    dataset: controller.getDataset(),
    dataIndex: index2,
    datasetIndex,
    element
  };
}
function getTooltipSize(tooltip, options) {
  const ctx = tooltip.chart.ctx;
  const { body, footer, title } = tooltip;
  const { boxWidth, boxHeight } = options;
  const bodyFont = toFont(options.bodyFont);
  const titleFont = toFont(options.titleFont);
  const footerFont = toFont(options.footerFont);
  const titleLineCount = title.length;
  const footerLineCount = footer.length;
  const bodyLineItemCount = body.length;
  const padding = toPadding(options.padding);
  let height = padding.height;
  let width = 0;
  let combinedBodyLength = body.reduce((count, bodyItem) => count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length, 0);
  combinedBodyLength += tooltip.beforeBody.length + tooltip.afterBody.length;
  if (titleLineCount) {
    height += titleLineCount * titleFont.lineHeight + (titleLineCount - 1) * options.titleSpacing + options.titleMarginBottom;
  }
  if (combinedBodyLength) {
    const bodyLineHeight = options.displayColors ? Math.max(boxHeight, bodyFont.lineHeight) : bodyFont.lineHeight;
    height += bodyLineItemCount * bodyLineHeight + (combinedBodyLength - bodyLineItemCount) * bodyFont.lineHeight + (combinedBodyLength - 1) * options.bodySpacing;
  }
  if (footerLineCount) {
    height += options.footerMarginTop + footerLineCount * footerFont.lineHeight + (footerLineCount - 1) * options.footerSpacing;
  }
  let widthPadding = 0;
  const maxLineWidth = function(line) {
    width = Math.max(width, ctx.measureText(line).width + widthPadding);
  };
  ctx.save();
  ctx.font = titleFont.string;
  each(tooltip.title, maxLineWidth);
  ctx.font = bodyFont.string;
  each(tooltip.beforeBody.concat(tooltip.afterBody), maxLineWidth);
  widthPadding = options.displayColors ? boxWidth + 2 + options.boxPadding : 0;
  each(body, (bodyItem) => {
    each(bodyItem.before, maxLineWidth);
    each(bodyItem.lines, maxLineWidth);
    each(bodyItem.after, maxLineWidth);
  });
  widthPadding = 0;
  ctx.font = footerFont.string;
  each(tooltip.footer, maxLineWidth);
  ctx.restore();
  width += padding.width;
  return {
    width,
    height
  };
}
function determineYAlign(chart, size) {
  const { y, height } = size;
  if (y < height / 2) {
    return "top";
  } else if (y > chart.height - height / 2) {
    return "bottom";
  }
  return "center";
}
function doesNotFitWithAlign(xAlign, chart, options, size) {
  const { x, width } = size;
  const caret = options.caretSize + options.caretPadding;
  if (xAlign === "left" && x + width + caret > chart.width) {
    return true;
  }
  if (xAlign === "right" && x - width - caret < 0) {
    return true;
  }
}
function determineXAlign(chart, options, size, yAlign) {
  const { x, width } = size;
  const { width: chartWidth, chartArea: { left, right } } = chart;
  let xAlign = "center";
  if (yAlign === "center") {
    xAlign = x <= (left + right) / 2 ? "left" : "right";
  } else if (x <= width / 2) {
    xAlign = "left";
  } else if (x >= chartWidth - width / 2) {
    xAlign = "right";
  }
  if (doesNotFitWithAlign(xAlign, chart, options, size)) {
    xAlign = "center";
  }
  return xAlign;
}
function determineAlignment(chart, options, size) {
  const yAlign = size.yAlign || options.yAlign || determineYAlign(chart, size);
  return {
    xAlign: size.xAlign || options.xAlign || determineXAlign(chart, options, size, yAlign),
    yAlign
  };
}
function alignX(size, xAlign) {
  let { x, width } = size;
  if (xAlign === "right") {
    x -= width;
  } else if (xAlign === "center") {
    x -= width / 2;
  }
  return x;
}
function alignY(size, yAlign, paddingAndSize) {
  let { y, height } = size;
  if (yAlign === "top") {
    y += paddingAndSize;
  } else if (yAlign === "bottom") {
    y -= height + paddingAndSize;
  } else {
    y -= height / 2;
  }
  return y;
}
function getBackgroundPoint(options, size, alignment, chart) {
  const { caretSize, caretPadding, cornerRadius } = options;
  const { xAlign, yAlign } = alignment;
  const paddingAndSize = caretSize + caretPadding;
  const { topLeft, topRight, bottomLeft, bottomRight } = toTRBLCorners(cornerRadius);
  let x = alignX(size, xAlign);
  const y = alignY(size, yAlign, paddingAndSize);
  if (yAlign === "center") {
    if (xAlign === "left") {
      x += paddingAndSize;
    } else if (xAlign === "right") {
      x -= paddingAndSize;
    }
  } else if (xAlign === "left") {
    x -= Math.max(topLeft, bottomLeft) + caretSize;
  } else if (xAlign === "right") {
    x += Math.max(topRight, bottomRight) + caretSize;
  }
  return {
    x: _limitValue(x, 0, chart.width - size.width),
    y: _limitValue(y, 0, chart.height - size.height)
  };
}
function getAlignedX(tooltip, align, options) {
  const padding = toPadding(options.padding);
  return align === "center" ? tooltip.x + tooltip.width / 2 : align === "right" ? tooltip.x + tooltip.width - padding.right : tooltip.x + padding.left;
}
function getBeforeAfterBodyLines(callback2) {
  return pushOrConcat([], splitNewlines(callback2));
}
function createTooltipContext(parent, tooltip, tooltipItems) {
  return createContext(parent, {
    tooltip,
    tooltipItems,
    type: "tooltip"
  });
}
function overrideCallbacks(callbacks, context) {
  const override = context && context.dataset && context.dataset.tooltip && context.dataset.tooltip.callbacks;
  return override ? callbacks.override(override) : callbacks;
}
var defaultCallbacks = {
  beforeTitle: noop,
  title(tooltipItems) {
    if (tooltipItems.length > 0) {
      const item = tooltipItems[0];
      const labels = item.chart.data.labels;
      const labelCount = labels ? labels.length : 0;
      if (this && this.options && this.options.mode === "dataset") {
        return item.dataset.label || "";
      } else if (item.label) {
        return item.label;
      } else if (labelCount > 0 && item.dataIndex < labelCount) {
        return labels[item.dataIndex];
      }
    }
    return "";
  },
  afterTitle: noop,
  beforeBody: noop,
  beforeLabel: noop,
  label(tooltipItem) {
    if (this && this.options && this.options.mode === "dataset") {
      return tooltipItem.label + ": " + tooltipItem.formattedValue || tooltipItem.formattedValue;
    }
    let label = tooltipItem.dataset.label || "";
    if (label) {
      label += ": ";
    }
    const value = tooltipItem.formattedValue;
    if (!isNullOrUndef(value)) {
      label += value;
    }
    return label;
  },
  labelColor(tooltipItem) {
    const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);
    const options = meta.controller.getStyle(tooltipItem.dataIndex);
    return {
      borderColor: options.borderColor,
      backgroundColor: options.backgroundColor,
      borderWidth: options.borderWidth,
      borderDash: options.borderDash,
      borderDashOffset: options.borderDashOffset,
      borderRadius: 0
    };
  },
  labelTextColor() {
    return this.options.bodyColor;
  },
  labelPointStyle(tooltipItem) {
    const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);
    const options = meta.controller.getStyle(tooltipItem.dataIndex);
    return {
      pointStyle: options.pointStyle,
      rotation: options.rotation
    };
  },
  afterLabel: noop,
  afterBody: noop,
  beforeFooter: noop,
  footer: noop,
  afterFooter: noop
};
function invokeCallbackWithFallback(callbacks, name, ctx, arg) {
  const result = callbacks[name].call(ctx, arg);
  if (typeof result === "undefined") {
    return defaultCallbacks[name].call(ctx, arg);
  }
  return result;
}
var Tooltip = class extends Element {
  static positioners = positioners;
  constructor(config) {
    super();
    this.opacity = 0;
    this._active = [];
    this._eventPosition = void 0;
    this._size = void 0;
    this._cachedAnimations = void 0;
    this._tooltipItems = [];
    this.$animations = void 0;
    this.$context = void 0;
    this.chart = config.chart;
    this.options = config.options;
    this.dataPoints = void 0;
    this.title = void 0;
    this.beforeBody = void 0;
    this.body = void 0;
    this.afterBody = void 0;
    this.footer = void 0;
    this.xAlign = void 0;
    this.yAlign = void 0;
    this.x = void 0;
    this.y = void 0;
    this.height = void 0;
    this.width = void 0;
    this.caretX = void 0;
    this.caretY = void 0;
    this.labelColors = void 0;
    this.labelPointStyles = void 0;
    this.labelTextColors = void 0;
  }
  initialize(options) {
    this.options = options;
    this._cachedAnimations = void 0;
    this.$context = void 0;
  }
  _resolveAnimations() {
    const cached = this._cachedAnimations;
    if (cached) {
      return cached;
    }
    const chart = this.chart;
    const options = this.options.setContext(this.getContext());
    const opts = options.enabled && chart.options.animation && options.animations;
    const animations = new Animations(this.chart, opts);
    if (opts._cacheable) {
      this._cachedAnimations = Object.freeze(animations);
    }
    return animations;
  }
  getContext() {
    return this.$context || (this.$context = createTooltipContext(this.chart.getContext(), this, this._tooltipItems));
  }
  getTitle(context, options) {
    const { callbacks } = options;
    const beforeTitle = invokeCallbackWithFallback(callbacks, "beforeTitle", this, context);
    const title = invokeCallbackWithFallback(callbacks, "title", this, context);
    const afterTitle = invokeCallbackWithFallback(callbacks, "afterTitle", this, context);
    let lines = [];
    lines = pushOrConcat(lines, splitNewlines(beforeTitle));
    lines = pushOrConcat(lines, splitNewlines(title));
    lines = pushOrConcat(lines, splitNewlines(afterTitle));
    return lines;
  }
  getBeforeBody(tooltipItems, options) {
    return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks, "beforeBody", this, tooltipItems));
  }
  getBody(tooltipItems, options) {
    const { callbacks } = options;
    const bodyItems = [];
    each(tooltipItems, (context) => {
      const bodyItem = {
        before: [],
        lines: [],
        after: []
      };
      const scoped = overrideCallbacks(callbacks, context);
      pushOrConcat(bodyItem.before, splitNewlines(invokeCallbackWithFallback(scoped, "beforeLabel", this, context)));
      pushOrConcat(bodyItem.lines, invokeCallbackWithFallback(scoped, "label", this, context));
      pushOrConcat(bodyItem.after, splitNewlines(invokeCallbackWithFallback(scoped, "afterLabel", this, context)));
      bodyItems.push(bodyItem);
    });
    return bodyItems;
  }
  getAfterBody(tooltipItems, options) {
    return getBeforeAfterBodyLines(invokeCallbackWithFallback(options.callbacks, "afterBody", this, tooltipItems));
  }
  getFooter(tooltipItems, options) {
    const { callbacks } = options;
    const beforeFooter = invokeCallbackWithFallback(callbacks, "beforeFooter", this, tooltipItems);
    const footer = invokeCallbackWithFallback(callbacks, "footer", this, tooltipItems);
    const afterFooter = invokeCallbackWithFallback(callbacks, "afterFooter", this, tooltipItems);
    let lines = [];
    lines = pushOrConcat(lines, splitNewlines(beforeFooter));
    lines = pushOrConcat(lines, splitNewlines(footer));
    lines = pushOrConcat(lines, splitNewlines(afterFooter));
    return lines;
  }
  _createItems(options) {
    const active = this._active;
    const data = this.chart.data;
    const labelColors = [];
    const labelPointStyles = [];
    const labelTextColors = [];
    let tooltipItems = [];
    let i, len;
    for (i = 0, len = active.length; i < len; ++i) {
      tooltipItems.push(createTooltipItem(this.chart, active[i]));
    }
    if (options.filter) {
      tooltipItems = tooltipItems.filter((element, index2, array) => options.filter(element, index2, array, data));
    }
    if (options.itemSort) {
      tooltipItems = tooltipItems.sort((a, b) => options.itemSort(a, b, data));
    }
    each(tooltipItems, (context) => {
      const scoped = overrideCallbacks(options.callbacks, context);
      labelColors.push(invokeCallbackWithFallback(scoped, "labelColor", this, context));
      labelPointStyles.push(invokeCallbackWithFallback(scoped, "labelPointStyle", this, context));
      labelTextColors.push(invokeCallbackWithFallback(scoped, "labelTextColor", this, context));
    });
    this.labelColors = labelColors;
    this.labelPointStyles = labelPointStyles;
    this.labelTextColors = labelTextColors;
    this.dataPoints = tooltipItems;
    return tooltipItems;
  }
  update(changed, replay) {
    const options = this.options.setContext(this.getContext());
    const active = this._active;
    let properties;
    let tooltipItems = [];
    if (!active.length) {
      if (this.opacity !== 0) {
        properties = {
          opacity: 0
        };
      }
    } else {
      const position = positioners[options.position].call(this, active, this._eventPosition);
      tooltipItems = this._createItems(options);
      this.title = this.getTitle(tooltipItems, options);
      this.beforeBody = this.getBeforeBody(tooltipItems, options);
      this.body = this.getBody(tooltipItems, options);
      this.afterBody = this.getAfterBody(tooltipItems, options);
      this.footer = this.getFooter(tooltipItems, options);
      const size = this._size = getTooltipSize(this, options);
      const positionAndSize = Object.assign({}, position, size);
      const alignment = determineAlignment(this.chart, options, positionAndSize);
      const backgroundPoint = getBackgroundPoint(options, positionAndSize, alignment, this.chart);
      this.xAlign = alignment.xAlign;
      this.yAlign = alignment.yAlign;
      properties = {
        opacity: 1,
        x: backgroundPoint.x,
        y: backgroundPoint.y,
        width: size.width,
        height: size.height,
        caretX: position.x,
        caretY: position.y
      };
    }
    this._tooltipItems = tooltipItems;
    this.$context = void 0;
    if (properties) {
      this._resolveAnimations().update(this, properties);
    }
    if (changed && options.external) {
      options.external.call(this, {
        chart: this.chart,
        tooltip: this,
        replay
      });
    }
  }
  drawCaret(tooltipPoint, ctx, size, options) {
    const caretPosition = this.getCaretPosition(tooltipPoint, size, options);
    ctx.lineTo(caretPosition.x1, caretPosition.y1);
    ctx.lineTo(caretPosition.x2, caretPosition.y2);
    ctx.lineTo(caretPosition.x3, caretPosition.y3);
  }
  getCaretPosition(tooltipPoint, size, options) {
    const { xAlign, yAlign } = this;
    const { caretSize, cornerRadius } = options;
    const { topLeft, topRight, bottomLeft, bottomRight } = toTRBLCorners(cornerRadius);
    const { x: ptX, y: ptY } = tooltipPoint;
    const { width, height } = size;
    let x1, x2, x3, y1, y2, y3;
    if (yAlign === "center") {
      y2 = ptY + height / 2;
      if (xAlign === "left") {
        x1 = ptX;
        x2 = x1 - caretSize;
        y1 = y2 + caretSize;
        y3 = y2 - caretSize;
      } else {
        x1 = ptX + width;
        x2 = x1 + caretSize;
        y1 = y2 - caretSize;
        y3 = y2 + caretSize;
      }
      x3 = x1;
    } else {
      if (xAlign === "left") {
        x2 = ptX + Math.max(topLeft, bottomLeft) + caretSize;
      } else if (xAlign === "right") {
        x2 = ptX + width - Math.max(topRight, bottomRight) - caretSize;
      } else {
        x2 = this.caretX;
      }
      if (yAlign === "top") {
        y1 = ptY;
        y2 = y1 - caretSize;
        x1 = x2 - caretSize;
        x3 = x2 + caretSize;
      } else {
        y1 = ptY + height;
        y2 = y1 + caretSize;
        x1 = x2 + caretSize;
        x3 = x2 - caretSize;
      }
      y3 = y1;
    }
    return {
      x1,
      x2,
      x3,
      y1,
      y2,
      y3
    };
  }
  drawTitle(pt, ctx, options) {
    const title = this.title;
    const length = title.length;
    let titleFont, titleSpacing, i;
    if (length) {
      const rtlHelper = getRtlAdapter(options.rtl, this.x, this.width);
      pt.x = getAlignedX(this, options.titleAlign, options);
      ctx.textAlign = rtlHelper.textAlign(options.titleAlign);
      ctx.textBaseline = "middle";
      titleFont = toFont(options.titleFont);
      titleSpacing = options.titleSpacing;
      ctx.fillStyle = options.titleColor;
      ctx.font = titleFont.string;
      for (i = 0; i < length; ++i) {
        ctx.fillText(title[i], rtlHelper.x(pt.x), pt.y + titleFont.lineHeight / 2);
        pt.y += titleFont.lineHeight + titleSpacing;
        if (i + 1 === length) {
          pt.y += options.titleMarginBottom - titleSpacing;
        }
      }
    }
  }
  _drawColorBox(ctx, pt, i, rtlHelper, options) {
    const labelColor = this.labelColors[i];
    const labelPointStyle = this.labelPointStyles[i];
    const { boxHeight, boxWidth } = options;
    const bodyFont = toFont(options.bodyFont);
    const colorX = getAlignedX(this, "left", options);
    const rtlColorX = rtlHelper.x(colorX);
    const yOffSet = boxHeight < bodyFont.lineHeight ? (bodyFont.lineHeight - boxHeight) / 2 : 0;
    const colorY = pt.y + yOffSet;
    if (options.usePointStyle) {
      const drawOptions = {
        radius: Math.min(boxWidth, boxHeight) / 2,
        pointStyle: labelPointStyle.pointStyle,
        rotation: labelPointStyle.rotation,
        borderWidth: 1
      };
      const centerX = rtlHelper.leftForLtr(rtlColorX, boxWidth) + boxWidth / 2;
      const centerY = colorY + boxHeight / 2;
      ctx.strokeStyle = options.multiKeyBackground;
      ctx.fillStyle = options.multiKeyBackground;
      drawPoint(ctx, drawOptions, centerX, centerY);
      ctx.strokeStyle = labelColor.borderColor;
      ctx.fillStyle = labelColor.backgroundColor;
      drawPoint(ctx, drawOptions, centerX, centerY);
    } else {
      ctx.lineWidth = isObject(labelColor.borderWidth) ? Math.max(...Object.values(labelColor.borderWidth)) : labelColor.borderWidth || 1;
      ctx.strokeStyle = labelColor.borderColor;
      ctx.setLineDash(labelColor.borderDash || []);
      ctx.lineDashOffset = labelColor.borderDashOffset || 0;
      const outerX = rtlHelper.leftForLtr(rtlColorX, boxWidth);
      const innerX = rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX, 1), boxWidth - 2);
      const borderRadius = toTRBLCorners(labelColor.borderRadius);
      if (Object.values(borderRadius).some((v) => v !== 0)) {
        ctx.beginPath();
        ctx.fillStyle = options.multiKeyBackground;
        addRoundedRectPath(ctx, {
          x: outerX,
          y: colorY,
          w: boxWidth,
          h: boxHeight,
          radius: borderRadius
        });
        ctx.fill();
        ctx.stroke();
        ctx.fillStyle = labelColor.backgroundColor;
        ctx.beginPath();
        addRoundedRectPath(ctx, {
          x: innerX,
          y: colorY + 1,
          w: boxWidth - 2,
          h: boxHeight - 2,
          radius: borderRadius
        });
        ctx.fill();
      } else {
        ctx.fillStyle = options.multiKeyBackground;
        ctx.fillRect(outerX, colorY, boxWidth, boxHeight);
        ctx.strokeRect(outerX, colorY, boxWidth, boxHeight);
        ctx.fillStyle = labelColor.backgroundColor;
        ctx.fillRect(innerX, colorY + 1, boxWidth - 2, boxHeight - 2);
      }
    }
    ctx.fillStyle = this.labelTextColors[i];
  }
  drawBody(pt, ctx, options) {
    const { body } = this;
    const { bodySpacing, bodyAlign, displayColors, boxHeight, boxWidth, boxPadding } = options;
    const bodyFont = toFont(options.bodyFont);
    let bodyLineHeight = bodyFont.lineHeight;
    let xLinePadding = 0;
    const rtlHelper = getRtlAdapter(options.rtl, this.x, this.width);
    const fillLineOfText = function(line) {
      ctx.fillText(line, rtlHelper.x(pt.x + xLinePadding), pt.y + bodyLineHeight / 2);
      pt.y += bodyLineHeight + bodySpacing;
    };
    const bodyAlignForCalculation = rtlHelper.textAlign(bodyAlign);
    let bodyItem, textColor, lines, i, j, ilen, jlen;
    ctx.textAlign = bodyAlign;
    ctx.textBaseline = "middle";
    ctx.font = bodyFont.string;
    pt.x = getAlignedX(this, bodyAlignForCalculation, options);
    ctx.fillStyle = options.bodyColor;
    each(this.beforeBody, fillLineOfText);
    xLinePadding = displayColors && bodyAlignForCalculation !== "right" ? bodyAlign === "center" ? boxWidth / 2 + boxPadding : boxWidth + 2 + boxPadding : 0;
    for (i = 0, ilen = body.length; i < ilen; ++i) {
      bodyItem = body[i];
      textColor = this.labelTextColors[i];
      ctx.fillStyle = textColor;
      each(bodyItem.before, fillLineOfText);
      lines = bodyItem.lines;
      if (displayColors && lines.length) {
        this._drawColorBox(ctx, pt, i, rtlHelper, options);
        bodyLineHeight = Math.max(bodyFont.lineHeight, boxHeight);
      }
      for (j = 0, jlen = lines.length; j < jlen; ++j) {
        fillLineOfText(lines[j]);
        bodyLineHeight = bodyFont.lineHeight;
      }
      each(bodyItem.after, fillLineOfText);
    }
    xLinePadding = 0;
    bodyLineHeight = bodyFont.lineHeight;
    each(this.afterBody, fillLineOfText);
    pt.y -= bodySpacing;
  }
  drawFooter(pt, ctx, options) {
    const footer = this.footer;
    const length = footer.length;
    let footerFont, i;
    if (length) {
      const rtlHelper = getRtlAdapter(options.rtl, this.x, this.width);
      pt.x = getAlignedX(this, options.footerAlign, options);
      pt.y += options.footerMarginTop;
      ctx.textAlign = rtlHelper.textAlign(options.footerAlign);
      ctx.textBaseline = "middle";
      footerFont = toFont(options.footerFont);
      ctx.fillStyle = options.footerColor;
      ctx.font = footerFont.string;
      for (i = 0; i < length; ++i) {
        ctx.fillText(footer[i], rtlHelper.x(pt.x), pt.y + footerFont.lineHeight / 2);
        pt.y += footerFont.lineHeight + options.footerSpacing;
      }
    }
  }
  drawBackground(pt, ctx, tooltipSize, options) {
    const { xAlign, yAlign } = this;
    const { x, y } = pt;
    const { width, height } = tooltipSize;
    const { topLeft, topRight, bottomLeft, bottomRight } = toTRBLCorners(options.cornerRadius);
    ctx.fillStyle = options.backgroundColor;
    ctx.strokeStyle = options.borderColor;
    ctx.lineWidth = options.borderWidth;
    ctx.beginPath();
    ctx.moveTo(x + topLeft, y);
    if (yAlign === "top") {
      this.drawCaret(pt, ctx, tooltipSize, options);
    }
    ctx.lineTo(x + width - topRight, y);
    ctx.quadraticCurveTo(x + width, y, x + width, y + topRight);
    if (yAlign === "center" && xAlign === "right") {
      this.drawCaret(pt, ctx, tooltipSize, options);
    }
    ctx.lineTo(x + width, y + height - bottomRight);
    ctx.quadraticCurveTo(x + width, y + height, x + width - bottomRight, y + height);
    if (yAlign === "bottom") {
      this.drawCaret(pt, ctx, tooltipSize, options);
    }
    ctx.lineTo(x + bottomLeft, y + height);
    ctx.quadraticCurveTo(x, y + height, x, y + height - bottomLeft);
    if (yAlign === "center" && xAlign === "left") {
      this.drawCaret(pt, ctx, tooltipSize, options);
    }
    ctx.lineTo(x, y + topLeft);
    ctx.quadraticCurveTo(x, y, x + topLeft, y);
    ctx.closePath();
    ctx.fill();
    if (options.borderWidth > 0) {
      ctx.stroke();
    }
  }
  _updateAnimationTarget(options) {
    const chart = this.chart;
    const anims = this.$animations;
    const animX = anims && anims.x;
    const animY = anims && anims.y;
    if (animX || animY) {
      const position = positioners[options.position].call(this, this._active, this._eventPosition);
      if (!position) {
        return;
      }
      const size = this._size = getTooltipSize(this, options);
      const positionAndSize = Object.assign({}, position, this._size);
      const alignment = determineAlignment(chart, options, positionAndSize);
      const point = getBackgroundPoint(options, positionAndSize, alignment, chart);
      if (animX._to !== point.x || animY._to !== point.y) {
        this.xAlign = alignment.xAlign;
        this.yAlign = alignment.yAlign;
        this.width = size.width;
        this.height = size.height;
        this.caretX = position.x;
        this.caretY = position.y;
        this._resolveAnimations().update(this, point);
      }
    }
  }
  _willRender() {
    return !!this.opacity;
  }
  draw(ctx) {
    const options = this.options.setContext(this.getContext());
    let opacity = this.opacity;
    if (!opacity) {
      return;
    }
    this._updateAnimationTarget(options);
    const tooltipSize = {
      width: this.width,
      height: this.height
    };
    const pt = {
      x: this.x,
      y: this.y
    };
    opacity = Math.abs(opacity) < 1e-3 ? 0 : opacity;
    const padding = toPadding(options.padding);
    const hasTooltipContent = this.title.length || this.beforeBody.length || this.body.length || this.afterBody.length || this.footer.length;
    if (options.enabled && hasTooltipContent) {
      ctx.save();
      ctx.globalAlpha = opacity;
      this.drawBackground(pt, ctx, tooltipSize, options);
      overrideTextDirection(ctx, options.textDirection);
      pt.y += padding.top;
      this.drawTitle(pt, ctx, options);
      this.drawBody(pt, ctx, options);
      this.drawFooter(pt, ctx, options);
      restoreTextDirection(ctx, options.textDirection);
      ctx.restore();
    }
  }
  getActiveElements() {
    return this._active || [];
  }
  setActiveElements(activeElements, eventPosition) {
    const lastActive = this._active;
    const active = activeElements.map(({ datasetIndex, index: index2 }) => {
      const meta = this.chart.getDatasetMeta(datasetIndex);
      if (!meta) {
        throw new Error("Cannot find a dataset at index " + datasetIndex);
      }
      return {
        datasetIndex,
        element: meta.data[index2],
        index: index2
      };
    });
    const changed = !_elementsEqual(lastActive, active);
    const positionChanged = this._positionChanged(active, eventPosition);
    if (changed || positionChanged) {
      this._active = active;
      this._eventPosition = eventPosition;
      this._ignoreReplayEvents = true;
      this.update(true);
    }
  }
  handleEvent(e, replay, inChartArea = true) {
    if (replay && this._ignoreReplayEvents) {
      return false;
    }
    this._ignoreReplayEvents = false;
    const options = this.options;
    const lastActive = this._active || [];
    const active = this._getActiveElements(e, lastActive, replay, inChartArea);
    const positionChanged = this._positionChanged(active, e);
    const changed = replay || !_elementsEqual(active, lastActive) || positionChanged;
    if (changed) {
      this._active = active;
      if (options.enabled || options.external) {
        this._eventPosition = {
          x: e.x,
          y: e.y
        };
        this.update(true, replay);
      }
    }
    return changed;
  }
  _getActiveElements(e, lastActive, replay, inChartArea) {
    const options = this.options;
    if (e.type === "mouseout") {
      return [];
    }
    if (!inChartArea) {
      return lastActive.filter((i) => this.chart.data.datasets[i.datasetIndex] && this.chart.getDatasetMeta(i.datasetIndex).controller.getParsed(i.index) !== void 0);
    }
    const active = this.chart.getElementsAtEventForMode(e, options.mode, options, replay);
    if (options.reverse) {
      active.reverse();
    }
    return active;
  }
  _positionChanged(active, e) {
    const { caretX, caretY, options } = this;
    const position = positioners[options.position].call(this, active, e);
    return position !== false && (caretX !== position.x || caretY !== position.y);
  }
};
var plugin_tooltip = {
  id: "tooltip",
  _element: Tooltip,
  positioners,
  afterInit(chart, _args, options) {
    if (options) {
      chart.tooltip = new Tooltip({
        chart,
        options
      });
    }
  },
  beforeUpdate(chart, _args, options) {
    if (chart.tooltip) {
      chart.tooltip.initialize(options);
    }
  },
  reset(chart, _args, options) {
    if (chart.tooltip) {
      chart.tooltip.initialize(options);
    }
  },
  afterDraw(chart) {
    const tooltip = chart.tooltip;
    if (tooltip && tooltip._willRender()) {
      const args = {
        tooltip
      };
      if (chart.notifyPlugins("beforeTooltipDraw", __spreadProps(__spreadValues({}, args), {
        cancelable: true
      })) === false) {
        return;
      }
      tooltip.draw(chart.ctx);
      chart.notifyPlugins("afterTooltipDraw", args);
    }
  },
  afterEvent(chart, args) {
    if (chart.tooltip) {
      const useFinalPosition = args.replay;
      if (chart.tooltip.handleEvent(args.event, useFinalPosition, args.inChartArea)) {
        args.changed = true;
      }
    }
  },
  defaults: {
    enabled: true,
    external: null,
    position: "average",
    backgroundColor: "rgba(0,0,0,0.8)",
    titleColor: "#fff",
    titleFont: {
      weight: "bold"
    },
    titleSpacing: 2,
    titleMarginBottom: 6,
    titleAlign: "left",
    bodyColor: "#fff",
    bodySpacing: 2,
    bodyFont: {},
    bodyAlign: "left",
    footerColor: "#fff",
    footerSpacing: 2,
    footerMarginTop: 6,
    footerFont: {
      weight: "bold"
    },
    footerAlign: "left",
    padding: 6,
    caretPadding: 2,
    caretSize: 5,
    cornerRadius: 6,
    boxHeight: (ctx, opts) => opts.bodyFont.size,
    boxWidth: (ctx, opts) => opts.bodyFont.size,
    multiKeyBackground: "#fff",
    displayColors: true,
    boxPadding: 0,
    borderColor: "rgba(0,0,0,0)",
    borderWidth: 0,
    animation: {
      duration: 400,
      easing: "easeOutQuart"
    },
    animations: {
      numbers: {
        type: "number",
        properties: [
          "x",
          "y",
          "width",
          "height",
          "caretX",
          "caretY"
        ]
      },
      opacity: {
        easing: "linear",
        duration: 200
      }
    },
    callbacks: defaultCallbacks
  },
  defaultRoutes: {
    bodyFont: "font",
    footerFont: "font",
    titleFont: "font"
  },
  descriptors: {
    _scriptable: (name) => name !== "filter" && name !== "itemSort" && name !== "external",
    _indexable: false,
    callbacks: {
      _scriptable: false,
      _indexable: false
    },
    animation: {
      _fallback: false
    },
    animations: {
      _fallback: "animation"
    }
  },
  additionalOptionScopes: [
    "interaction"
  ]
};
var addIfString = (labels, raw, index2, addedLabels) => {
  if (typeof raw === "string") {
    index2 = labels.push(raw) - 1;
    addedLabels.unshift({
      index: index2,
      label: raw
    });
  } else if (isNaN(raw)) {
    index2 = null;
  }
  return index2;
};
function findOrAddLabel(labels, raw, index2, addedLabels) {
  const first = labels.indexOf(raw);
  if (first === -1) {
    return addIfString(labels, raw, index2, addedLabels);
  }
  const last = labels.lastIndexOf(raw);
  return first !== last ? index2 : first;
}
var validIndex = (index2, max) => index2 === null ? null : _limitValue(Math.round(index2), 0, max);
function _getLabelForValue(value) {
  const labels = this.getLabels();
  if (value >= 0 && value < labels.length) {
    return labels[value];
  }
  return value;
}
var CategoryScale = class extends Scale {
  static id = "category";
  static defaults = {
    ticks: {
      callback: _getLabelForValue
    }
  };
  constructor(cfg) {
    super(cfg);
    this._startValue = void 0;
    this._valueRange = 0;
    this._addedLabels = [];
  }
  init(scaleOptions) {
    const added = this._addedLabels;
    if (added.length) {
      const labels = this.getLabels();
      for (const { index: index2, label } of added) {
        if (labels[index2] === label) {
          labels.splice(index2, 1);
        }
      }
      this._addedLabels = [];
    }
    super.init(scaleOptions);
  }
  parse(raw, index2) {
    if (isNullOrUndef(raw)) {
      return null;
    }
    const labels = this.getLabels();
    index2 = isFinite(index2) && labels[index2] === raw ? index2 : findOrAddLabel(labels, raw, valueOrDefault(index2, raw), this._addedLabels);
    return validIndex(index2, labels.length - 1);
  }
  determineDataLimits() {
    const { minDefined, maxDefined } = this.getUserBounds();
    let { min, max } = this.getMinMax(true);
    if (this.options.bounds === "ticks") {
      if (!minDefined) {
        min = 0;
      }
      if (!maxDefined) {
        max = this.getLabels().length - 1;
      }
    }
    this.min = min;
    this.max = max;
  }
  buildTicks() {
    const min = this.min;
    const max = this.max;
    const offset = this.options.offset;
    const ticks = [];
    let labels = this.getLabels();
    labels = min === 0 && max === labels.length - 1 ? labels : labels.slice(min, max + 1);
    this._valueRange = Math.max(labels.length - (offset ? 0 : 1), 1);
    this._startValue = this.min - (offset ? 0.5 : 0);
    for (let value = min; value <= max; value++) {
      ticks.push({
        value
      });
    }
    return ticks;
  }
  getLabelForValue(value) {
    return _getLabelForValue.call(this, value);
  }
  configure() {
    super.configure();
    if (!this.isHorizontal()) {
      this._reversePixels = !this._reversePixels;
    }
  }
  getPixelForValue(value) {
    if (typeof value !== "number") {
      value = this.parse(value);
    }
    return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);
  }
  getPixelForTick(index2) {
    const ticks = this.ticks;
    if (index2 < 0 || index2 > ticks.length - 1) {
      return null;
    }
    return this.getPixelForValue(ticks[index2].value);
  }
  getValueForPixel(pixel) {
    return Math.round(this._startValue + this.getDecimalForPixel(pixel) * this._valueRange);
  }
  getBasePixel() {
    return this.bottom;
  }
};
function generateTicks$1(generationOptions, dataRange) {
  const ticks = [];
  const MIN_SPACING = 1e-14;
  const { bounds, step, min, max, precision, count, maxTicks, maxDigits, includeBounds } = generationOptions;
  const unit = step || 1;
  const maxSpaces = maxTicks - 1;
  const { min: rmin, max: rmax } = dataRange;
  const minDefined = !isNullOrUndef(min);
  const maxDefined = !isNullOrUndef(max);
  const countDefined = !isNullOrUndef(count);
  const minSpacing = (rmax - rmin) / (maxDigits + 1);
  let spacing = niceNum((rmax - rmin) / maxSpaces / unit) * unit;
  let factor, niceMin, niceMax, numSpaces;
  if (spacing < MIN_SPACING && !minDefined && !maxDefined) {
    return [
      {
        value: rmin
      },
      {
        value: rmax
      }
    ];
  }
  numSpaces = Math.ceil(rmax / spacing) - Math.floor(rmin / spacing);
  if (numSpaces > maxSpaces) {
    spacing = niceNum(numSpaces * spacing / maxSpaces / unit) * unit;
  }
  if (!isNullOrUndef(precision)) {
    factor = Math.pow(10, precision);
    spacing = Math.ceil(spacing * factor) / factor;
  }
  if (bounds === "ticks") {
    niceMin = Math.floor(rmin / spacing) * spacing;
    niceMax = Math.ceil(rmax / spacing) * spacing;
  } else {
    niceMin = rmin;
    niceMax = rmax;
  }
  if (minDefined && maxDefined && step && almostWhole((max - min) / step, spacing / 1e3)) {
    numSpaces = Math.round(Math.min((max - min) / spacing, maxTicks));
    spacing = (max - min) / numSpaces;
    niceMin = min;
    niceMax = max;
  } else if (countDefined) {
    niceMin = minDefined ? min : niceMin;
    niceMax = maxDefined ? max : niceMax;
    numSpaces = count - 1;
    spacing = (niceMax - niceMin) / numSpaces;
  } else {
    numSpaces = (niceMax - niceMin) / spacing;
    if (almostEquals(numSpaces, Math.round(numSpaces), spacing / 1e3)) {
      numSpaces = Math.round(numSpaces);
    } else {
      numSpaces = Math.ceil(numSpaces);
    }
  }
  const decimalPlaces = Math.max(_decimalPlaces(spacing), _decimalPlaces(niceMin));
  factor = Math.pow(10, isNullOrUndef(precision) ? decimalPlaces : precision);
  niceMin = Math.round(niceMin * factor) / factor;
  niceMax = Math.round(niceMax * factor) / factor;
  let j = 0;
  if (minDefined) {
    if (includeBounds && niceMin !== min) {
      ticks.push({
        value: min
      });
      if (niceMin < min) {
        j++;
      }
      if (almostEquals(Math.round((niceMin + j * spacing) * factor) / factor, min, relativeLabelSize(min, minSpacing, generationOptions))) {
        j++;
      }
    } else if (niceMin < min) {
      j++;
    }
  }
  for (; j < numSpaces; ++j) {
    const tickValue = Math.round((niceMin + j * spacing) * factor) / factor;
    if (maxDefined && tickValue > max) {
      break;
    }
    ticks.push({
      value: tickValue
    });
  }
  if (maxDefined && includeBounds && niceMax !== max) {
    if (ticks.length && almostEquals(ticks[ticks.length - 1].value, max, relativeLabelSize(max, minSpacing, generationOptions))) {
      ticks[ticks.length - 1].value = max;
    } else {
      ticks.push({
        value: max
      });
    }
  } else if (!maxDefined || niceMax === max) {
    ticks.push({
      value: niceMax
    });
  }
  return ticks;
}
function relativeLabelSize(value, minSpacing, { horizontal, minRotation }) {
  const rad = toRadians(minRotation);
  const ratio = (horizontal ? Math.sin(rad) : Math.cos(rad)) || 1e-3;
  const length = 0.75 * minSpacing * ("" + value).length;
  return Math.min(minSpacing / ratio, length);
}
var LinearScaleBase = class extends Scale {
  constructor(cfg) {
    super(cfg);
    this.start = void 0;
    this.end = void 0;
    this._startValue = void 0;
    this._endValue = void 0;
    this._valueRange = 0;
  }
  parse(raw, index2) {
    if (isNullOrUndef(raw)) {
      return null;
    }
    if ((typeof raw === "number" || raw instanceof Number) && !isFinite(+raw)) {
      return null;
    }
    return +raw;
  }
  handleTickRangeOptions() {
    const { beginAtZero } = this.options;
    const { minDefined, maxDefined } = this.getUserBounds();
    let { min, max } = this;
    const setMin = (v) => min = minDefined ? min : v;
    const setMax = (v) => max = maxDefined ? max : v;
    if (beginAtZero) {
      const minSign = sign(min);
      const maxSign = sign(max);
      if (minSign < 0 && maxSign < 0) {
        setMax(0);
      } else if (minSign > 0 && maxSign > 0) {
        setMin(0);
      }
    }
    if (min === max) {
      let offset = max === 0 ? 1 : Math.abs(max * 0.05);
      setMax(max + offset);
      if (!beginAtZero) {
        setMin(min - offset);
      }
    }
    this.min = min;
    this.max = max;
  }
  getTickLimit() {
    const tickOpts = this.options.ticks;
    let { maxTicksLimit, stepSize } = tickOpts;
    let maxTicks;
    if (stepSize) {
      maxTicks = Math.ceil(this.max / stepSize) - Math.floor(this.min / stepSize) + 1;
      if (maxTicks > 1e3) {
        console.warn(`scales.${this.id}.ticks.stepSize: ${stepSize} would result generating up to ${maxTicks} ticks. Limiting to 1000.`);
        maxTicks = 1e3;
      }
    } else {
      maxTicks = this.computeTickLimit();
      maxTicksLimit = maxTicksLimit || 11;
    }
    if (maxTicksLimit) {
      maxTicks = Math.min(maxTicksLimit, maxTicks);
    }
    return maxTicks;
  }
  computeTickLimit() {
    return Number.POSITIVE_INFINITY;
  }
  buildTicks() {
    const opts = this.options;
    const tickOpts = opts.ticks;
    let maxTicks = this.getTickLimit();
    maxTicks = Math.max(2, maxTicks);
    const numericGeneratorOptions = {
      maxTicks,
      bounds: opts.bounds,
      min: opts.min,
      max: opts.max,
      precision: tickOpts.precision,
      step: tickOpts.stepSize,
      count: tickOpts.count,
      maxDigits: this._maxDigits(),
      horizontal: this.isHorizontal(),
      minRotation: tickOpts.minRotation || 0,
      includeBounds: tickOpts.includeBounds !== false
    };
    const dataRange = this._range || this;
    const ticks = generateTicks$1(numericGeneratorOptions, dataRange);
    if (opts.bounds === "ticks") {
      _setMinAndMaxByKey(ticks, this, "value");
    }
    if (opts.reverse) {
      ticks.reverse();
      this.start = this.max;
      this.end = this.min;
    } else {
      this.start = this.min;
      this.end = this.max;
    }
    return ticks;
  }
  configure() {
    const ticks = this.ticks;
    let start = this.min;
    let end = this.max;
    super.configure();
    if (this.options.offset && ticks.length) {
      const offset = (end - start) / Math.max(ticks.length - 1, 1) / 2;
      start -= offset;
      end += offset;
    }
    this._startValue = start;
    this._endValue = end;
    this._valueRange = end - start;
  }
  getLabelForValue(value) {
    return formatNumber(value, this.chart.options.locale, this.options.ticks.format);
  }
};
var LinearScale = class extends LinearScaleBase {
  static id = "linear";
  static defaults = {
    ticks: {
      callback: Ticks.formatters.numeric
    }
  };
  determineDataLimits() {
    const { min, max } = this.getMinMax(true);
    this.min = isNumberFinite(min) ? min : 0;
    this.max = isNumberFinite(max) ? max : 1;
    this.handleTickRangeOptions();
  }
  computeTickLimit() {
    const horizontal = this.isHorizontal();
    const length = horizontal ? this.width : this.height;
    const minRotation = toRadians(this.options.ticks.minRotation);
    const ratio = (horizontal ? Math.sin(minRotation) : Math.cos(minRotation)) || 1e-3;
    const tickFont = this._resolveTickFontOptions(0);
    return Math.ceil(length / Math.min(40, tickFont.lineHeight / ratio));
  }
  getPixelForValue(value) {
    return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);
  }
  getValueForPixel(pixel) {
    return this._startValue + this.getDecimalForPixel(pixel) * this._valueRange;
  }
};
var log10Floor = (v) => Math.floor(log10(v));
var changeExponent = (v, m) => Math.pow(10, log10Floor(v) + m);
function isMajor(tickVal) {
  const remain = tickVal / Math.pow(10, log10Floor(tickVal));
  return remain === 1;
}
function steps(min, max, rangeExp) {
  const rangeStep = Math.pow(10, rangeExp);
  const start = Math.floor(min / rangeStep);
  const end = Math.ceil(max / rangeStep);
  return end - start;
}
function startExp(min, max) {
  const range = max - min;
  let rangeExp = log10Floor(range);
  while (steps(min, max, rangeExp) > 10) {
    rangeExp++;
  }
  while (steps(min, max, rangeExp) < 10) {
    rangeExp--;
  }
  return Math.min(rangeExp, log10Floor(min));
}
function generateTicks(generationOptions, { min, max }) {
  min = finiteOrDefault(generationOptions.min, min);
  const ticks = [];
  const minExp = log10Floor(min);
  let exp = startExp(min, max);
  let precision = exp < 0 ? Math.pow(10, Math.abs(exp)) : 1;
  const stepSize = Math.pow(10, exp);
  const base = minExp > exp ? Math.pow(10, minExp) : 0;
  const start = Math.round((min - base) * precision) / precision;
  const offset = Math.floor((min - base) / stepSize / 10) * stepSize * 10;
  let significand = Math.floor((start - offset) / Math.pow(10, exp));
  let value = finiteOrDefault(generationOptions.min, Math.round((base + offset + significand * Math.pow(10, exp)) * precision) / precision);
  while (value < max) {
    ticks.push({
      value,
      major: isMajor(value),
      significand
    });
    if (significand >= 10) {
      significand = significand < 15 ? 15 : 20;
    } else {
      significand++;
    }
    if (significand >= 20) {
      exp++;
      significand = 2;
      precision = exp >= 0 ? 1 : precision;
    }
    value = Math.round((base + offset + significand * Math.pow(10, exp)) * precision) / precision;
  }
  const lastTick = finiteOrDefault(generationOptions.max, value);
  ticks.push({
    value: lastTick,
    major: isMajor(lastTick),
    significand
  });
  return ticks;
}
var LogarithmicScale = class extends Scale {
  static id = "logarithmic";
  static defaults = {
    ticks: {
      callback: Ticks.formatters.logarithmic,
      major: {
        enabled: true
      }
    }
  };
  constructor(cfg) {
    super(cfg);
    this.start = void 0;
    this.end = void 0;
    this._startValue = void 0;
    this._valueRange = 0;
  }
  parse(raw, index2) {
    const value = LinearScaleBase.prototype.parse.apply(this, [
      raw,
      index2
    ]);
    if (value === 0) {
      this._zero = true;
      return void 0;
    }
    return isNumberFinite(value) && value > 0 ? value : null;
  }
  determineDataLimits() {
    const { min, max } = this.getMinMax(true);
    this.min = isNumberFinite(min) ? Math.max(0, min) : null;
    this.max = isNumberFinite(max) ? Math.max(0, max) : null;
    if (this.options.beginAtZero) {
      this._zero = true;
    }
    if (this._zero && this.min !== this._suggestedMin && !isNumberFinite(this._userMin)) {
      this.min = min === changeExponent(this.min, 0) ? changeExponent(this.min, -1) : changeExponent(this.min, 0);
    }
    this.handleTickRangeOptions();
  }
  handleTickRangeOptions() {
    const { minDefined, maxDefined } = this.getUserBounds();
    let min = this.min;
    let max = this.max;
    const setMin = (v) => min = minDefined ? min : v;
    const setMax = (v) => max = maxDefined ? max : v;
    if (min === max) {
      if (min <= 0) {
        setMin(1);
        setMax(10);
      } else {
        setMin(changeExponent(min, -1));
        setMax(changeExponent(max, 1));
      }
    }
    if (min <= 0) {
      setMin(changeExponent(max, -1));
    }
    if (max <= 0) {
      setMax(changeExponent(min, 1));
    }
    this.min = min;
    this.max = max;
  }
  buildTicks() {
    const opts = this.options;
    const generationOptions = {
      min: this._userMin,
      max: this._userMax
    };
    const ticks = generateTicks(generationOptions, this);
    if (opts.bounds === "ticks") {
      _setMinAndMaxByKey(ticks, this, "value");
    }
    if (opts.reverse) {
      ticks.reverse();
      this.start = this.max;
      this.end = this.min;
    } else {
      this.start = this.min;
      this.end = this.max;
    }
    return ticks;
  }
  getLabelForValue(value) {
    return value === void 0 ? "0" : formatNumber(value, this.chart.options.locale, this.options.ticks.format);
  }
  configure() {
    const start = this.min;
    super.configure();
    this._startValue = log10(start);
    this._valueRange = log10(this.max) - log10(start);
  }
  getPixelForValue(value) {
    if (value === void 0 || value === 0) {
      value = this.min;
    }
    if (value === null || isNaN(value)) {
      return NaN;
    }
    return this.getPixelForDecimal(value === this.min ? 0 : (log10(value) - this._startValue) / this._valueRange);
  }
  getValueForPixel(pixel) {
    const decimal = this.getDecimalForPixel(pixel);
    return Math.pow(10, this._startValue + decimal * this._valueRange);
  }
};
function getTickBackdropHeight(opts) {
  const tickOpts = opts.ticks;
  if (tickOpts.display && opts.display) {
    const padding = toPadding(tickOpts.backdropPadding);
    return valueOrDefault(tickOpts.font && tickOpts.font.size, defaults.font.size) + padding.height;
  }
  return 0;
}
function measureLabelSize(ctx, font, label) {
  label = isArray(label) ? label : [
    label
  ];
  return {
    w: _longestText(ctx, font.string, label),
    h: label.length * font.lineHeight
  };
}
function determineLimits(angle, pos, size, min, max) {
  if (angle === min || angle === max) {
    return {
      start: pos - size / 2,
      end: pos + size / 2
    };
  } else if (angle < min || angle > max) {
    return {
      start: pos - size,
      end: pos
    };
  }
  return {
    start: pos,
    end: pos + size
  };
}
function fitWithPointLabels(scale) {
  const orig = {
    l: scale.left + scale._padding.left,
    r: scale.right - scale._padding.right,
    t: scale.top + scale._padding.top,
    b: scale.bottom - scale._padding.bottom
  };
  const limits = Object.assign({}, orig);
  const labelSizes = [];
  const padding = [];
  const valueCount = scale._pointLabels.length;
  const pointLabelOpts = scale.options.pointLabels;
  const additionalAngle = pointLabelOpts.centerPointLabels ? PI / valueCount : 0;
  for (let i = 0; i < valueCount; i++) {
    const opts = pointLabelOpts.setContext(scale.getPointLabelContext(i));
    padding[i] = opts.padding;
    const pointPosition = scale.getPointPosition(i, scale.drawingArea + padding[i], additionalAngle);
    const plFont = toFont(opts.font);
    const textSize = measureLabelSize(scale.ctx, plFont, scale._pointLabels[i]);
    labelSizes[i] = textSize;
    const angleRadians = _normalizeAngle(scale.getIndexAngle(i) + additionalAngle);
    const angle = Math.round(toDegrees(angleRadians));
    const hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);
    const vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);
    updateLimits(limits, orig, angleRadians, hLimits, vLimits);
  }
  scale.setCenterPoint(orig.l - limits.l, limits.r - orig.r, orig.t - limits.t, limits.b - orig.b);
  scale._pointLabelItems = buildPointLabelItems(scale, labelSizes, padding);
}
function updateLimits(limits, orig, angle, hLimits, vLimits) {
  const sin = Math.abs(Math.sin(angle));
  const cos = Math.abs(Math.cos(angle));
  let x = 0;
  let y = 0;
  if (hLimits.start < orig.l) {
    x = (orig.l - hLimits.start) / sin;
    limits.l = Math.min(limits.l, orig.l - x);
  } else if (hLimits.end > orig.r) {
    x = (hLimits.end - orig.r) / sin;
    limits.r = Math.max(limits.r, orig.r + x);
  }
  if (vLimits.start < orig.t) {
    y = (orig.t - vLimits.start) / cos;
    limits.t = Math.min(limits.t, orig.t - y);
  } else if (vLimits.end > orig.b) {
    y = (vLimits.end - orig.b) / cos;
    limits.b = Math.max(limits.b, orig.b + y);
  }
}
function createPointLabelItem(scale, index2, itemOpts) {
  const outerDistance = scale.drawingArea;
  const { extra, additionalAngle, padding, size } = itemOpts;
  const pointLabelPosition = scale.getPointPosition(index2, outerDistance + extra + padding, additionalAngle);
  const angle = Math.round(toDegrees(_normalizeAngle(pointLabelPosition.angle + HALF_PI)));
  const y = yForAngle(pointLabelPosition.y, size.h, angle);
  const textAlign = getTextAlignForAngle(angle);
  const left = leftForTextAlign(pointLabelPosition.x, size.w, textAlign);
  return {
    visible: true,
    x: pointLabelPosition.x,
    y,
    textAlign,
    left,
    top: y,
    right: left + size.w,
    bottom: y + size.h
  };
}
function isNotOverlapped(item, area) {
  if (!area) {
    return true;
  }
  const { left, top, right, bottom } = item;
  const apexesInArea = _isPointInArea({
    x: left,
    y: top
  }, area) || _isPointInArea({
    x: left,
    y: bottom
  }, area) || _isPointInArea({
    x: right,
    y: top
  }, area) || _isPointInArea({
    x: right,
    y: bottom
  }, area);
  return !apexesInArea;
}
function buildPointLabelItems(scale, labelSizes, padding) {
  const items = [];
  const valueCount = scale._pointLabels.length;
  const opts = scale.options;
  const { centerPointLabels, display } = opts.pointLabels;
  const itemOpts = {
    extra: getTickBackdropHeight(opts) / 2,
    additionalAngle: centerPointLabels ? PI / valueCount : 0
  };
  let area;
  for (let i = 0; i < valueCount; i++) {
    itemOpts.padding = padding[i];
    itemOpts.size = labelSizes[i];
    const item = createPointLabelItem(scale, i, itemOpts);
    items.push(item);
    if (display === "auto") {
      item.visible = isNotOverlapped(item, area);
      if (item.visible) {
        area = item;
      }
    }
  }
  return items;
}
function getTextAlignForAngle(angle) {
  if (angle === 0 || angle === 180) {
    return "center";
  } else if (angle < 180) {
    return "left";
  }
  return "right";
}
function leftForTextAlign(x, w, align) {
  if (align === "right") {
    x -= w;
  } else if (align === "center") {
    x -= w / 2;
  }
  return x;
}
function yForAngle(y, h, angle) {
  if (angle === 90 || angle === 270) {
    y -= h / 2;
  } else if (angle > 270 || angle < 90) {
    y -= h;
  }
  return y;
}
function drawPointLabelBox(ctx, opts, item) {
  const { left, top, right, bottom } = item;
  const { backdropColor } = opts;
  if (!isNullOrUndef(backdropColor)) {
    const borderRadius = toTRBLCorners(opts.borderRadius);
    const padding = toPadding(opts.backdropPadding);
    ctx.fillStyle = backdropColor;
    const backdropLeft = left - padding.left;
    const backdropTop = top - padding.top;
    const backdropWidth = right - left + padding.width;
    const backdropHeight = bottom - top + padding.height;
    if (Object.values(borderRadius).some((v) => v !== 0)) {
      ctx.beginPath();
      addRoundedRectPath(ctx, {
        x: backdropLeft,
        y: backdropTop,
        w: backdropWidth,
        h: backdropHeight,
        radius: borderRadius
      });
      ctx.fill();
    } else {
      ctx.fillRect(backdropLeft, backdropTop, backdropWidth, backdropHeight);
    }
  }
}
function drawPointLabels(scale, labelCount) {
  const { ctx, options: { pointLabels } } = scale;
  for (let i = labelCount - 1; i >= 0; i--) {
    const item = scale._pointLabelItems[i];
    if (!item.visible) {
      continue;
    }
    const optsAtIndex = pointLabels.setContext(scale.getPointLabelContext(i));
    drawPointLabelBox(ctx, optsAtIndex, item);
    const plFont = toFont(optsAtIndex.font);
    const { x, y, textAlign } = item;
    renderText(ctx, scale._pointLabels[i], x, y + plFont.lineHeight / 2, plFont, {
      color: optsAtIndex.color,
      textAlign,
      textBaseline: "middle"
    });
  }
}
function pathRadiusLine(scale, radius, circular, labelCount) {
  const { ctx } = scale;
  if (circular) {
    ctx.arc(scale.xCenter, scale.yCenter, radius, 0, TAU);
  } else {
    let pointPosition = scale.getPointPosition(0, radius);
    ctx.moveTo(pointPosition.x, pointPosition.y);
    for (let i = 1; i < labelCount; i++) {
      pointPosition = scale.getPointPosition(i, radius);
      ctx.lineTo(pointPosition.x, pointPosition.y);
    }
  }
}
function drawRadiusLine(scale, gridLineOpts, radius, labelCount, borderOpts) {
  const ctx = scale.ctx;
  const circular = gridLineOpts.circular;
  const { color: color2, lineWidth } = gridLineOpts;
  if (!circular && !labelCount || !color2 || !lineWidth || radius < 0) {
    return;
  }
  ctx.save();
  ctx.strokeStyle = color2;
  ctx.lineWidth = lineWidth;
  ctx.setLineDash(borderOpts.dash || []);
  ctx.lineDashOffset = borderOpts.dashOffset;
  ctx.beginPath();
  pathRadiusLine(scale, radius, circular, labelCount);
  ctx.closePath();
  ctx.stroke();
  ctx.restore();
}
function createPointLabelContext(parent, index2, label) {
  return createContext(parent, {
    label,
    index: index2,
    type: "pointLabel"
  });
}
var RadialLinearScale = class extends LinearScaleBase {
  static id = "radialLinear";
  static defaults = {
    display: true,
    animate: true,
    position: "chartArea",
    angleLines: {
      display: true,
      lineWidth: 1,
      borderDash: [],
      borderDashOffset: 0
    },
    grid: {
      circular: false
    },
    startAngle: 0,
    ticks: {
      showLabelBackdrop: true,
      callback: Ticks.formatters.numeric
    },
    pointLabels: {
      backdropColor: void 0,
      backdropPadding: 2,
      display: true,
      font: {
        size: 10
      },
      callback(label) {
        return label;
      },
      padding: 5,
      centerPointLabels: false
    }
  };
  static defaultRoutes = {
    "angleLines.color": "borderColor",
    "pointLabels.color": "color",
    "ticks.color": "color"
  };
  static descriptors = {
    angleLines: {
      _fallback: "grid"
    }
  };
  constructor(cfg) {
    super(cfg);
    this.xCenter = void 0;
    this.yCenter = void 0;
    this.drawingArea = void 0;
    this._pointLabels = [];
    this._pointLabelItems = [];
  }
  setDimensions() {
    const padding = this._padding = toPadding(getTickBackdropHeight(this.options) / 2);
    const w = this.width = this.maxWidth - padding.width;
    const h = this.height = this.maxHeight - padding.height;
    this.xCenter = Math.floor(this.left + w / 2 + padding.left);
    this.yCenter = Math.floor(this.top + h / 2 + padding.top);
    this.drawingArea = Math.floor(Math.min(w, h) / 2);
  }
  determineDataLimits() {
    const { min, max } = this.getMinMax(false);
    this.min = isNumberFinite(min) && !isNaN(min) ? min : 0;
    this.max = isNumberFinite(max) && !isNaN(max) ? max : 0;
    this.handleTickRangeOptions();
  }
  computeTickLimit() {
    return Math.ceil(this.drawingArea / getTickBackdropHeight(this.options));
  }
  generateTickLabels(ticks) {
    LinearScaleBase.prototype.generateTickLabels.call(this, ticks);
    this._pointLabels = this.getLabels().map((value, index2) => {
      const label = callback(this.options.pointLabels.callback, [
        value,
        index2
      ], this);
      return label || label === 0 ? label : "";
    }).filter((v, i) => this.chart.getDataVisibility(i));
  }
  fit() {
    const opts = this.options;
    if (opts.display && opts.pointLabels.display) {
      fitWithPointLabels(this);
    } else {
      this.setCenterPoint(0, 0, 0, 0);
    }
  }
  setCenterPoint(leftMovement, rightMovement, topMovement, bottomMovement) {
    this.xCenter += Math.floor((leftMovement - rightMovement) / 2);
    this.yCenter += Math.floor((topMovement - bottomMovement) / 2);
    this.drawingArea -= Math.min(this.drawingArea / 2, Math.max(leftMovement, rightMovement, topMovement, bottomMovement));
  }
  getIndexAngle(index2) {
    const angleMultiplier = TAU / (this._pointLabels.length || 1);
    const startAngle = this.options.startAngle || 0;
    return _normalizeAngle(index2 * angleMultiplier + toRadians(startAngle));
  }
  getDistanceFromCenterForValue(value) {
    if (isNullOrUndef(value)) {
      return NaN;
    }
    const scalingFactor = this.drawingArea / (this.max - this.min);
    if (this.options.reverse) {
      return (this.max - value) * scalingFactor;
    }
    return (value - this.min) * scalingFactor;
  }
  getValueForDistanceFromCenter(distance) {
    if (isNullOrUndef(distance)) {
      return NaN;
    }
    const scaledDistance = distance / (this.drawingArea / (this.max - this.min));
    return this.options.reverse ? this.max - scaledDistance : this.min + scaledDistance;
  }
  getPointLabelContext(index2) {
    const pointLabels = this._pointLabels || [];
    if (index2 >= 0 && index2 < pointLabels.length) {
      const pointLabel = pointLabels[index2];
      return createPointLabelContext(this.getContext(), index2, pointLabel);
    }
  }
  getPointPosition(index2, distanceFromCenter, additionalAngle = 0) {
    const angle = this.getIndexAngle(index2) - HALF_PI + additionalAngle;
    return {
      x: Math.cos(angle) * distanceFromCenter + this.xCenter,
      y: Math.sin(angle) * distanceFromCenter + this.yCenter,
      angle
    };
  }
  getPointPositionForValue(index2, value) {
    return this.getPointPosition(index2, this.getDistanceFromCenterForValue(value));
  }
  getBasePosition(index2) {
    return this.getPointPositionForValue(index2 || 0, this.getBaseValue());
  }
  getPointLabelPosition(index2) {
    const { left, top, right, bottom } = this._pointLabelItems[index2];
    return {
      left,
      top,
      right,
      bottom
    };
  }
  drawBackground() {
    const { backgroundColor, grid: { circular } } = this.options;
    if (backgroundColor) {
      const ctx = this.ctx;
      ctx.save();
      ctx.beginPath();
      pathRadiusLine(this, this.getDistanceFromCenterForValue(this._endValue), circular, this._pointLabels.length);
      ctx.closePath();
      ctx.fillStyle = backgroundColor;
      ctx.fill();
      ctx.restore();
    }
  }
  drawGrid() {
    const ctx = this.ctx;
    const opts = this.options;
    const { angleLines, grid, border } = opts;
    const labelCount = this._pointLabels.length;
    let i, offset, position;
    if (opts.pointLabels.display) {
      drawPointLabels(this, labelCount);
    }
    if (grid.display) {
      this.ticks.forEach((tick, index2) => {
        if (index2 !== 0 || index2 === 0 && this.min < 0) {
          offset = this.getDistanceFromCenterForValue(tick.value);
          const context = this.getContext(index2);
          const optsAtIndex = grid.setContext(context);
          const optsAtIndexBorder = border.setContext(context);
          drawRadiusLine(this, optsAtIndex, offset, labelCount, optsAtIndexBorder);
        }
      });
    }
    if (angleLines.display) {
      ctx.save();
      for (i = labelCount - 1; i >= 0; i--) {
        const optsAtIndex = angleLines.setContext(this.getPointLabelContext(i));
        const { color: color2, lineWidth } = optsAtIndex;
        if (!lineWidth || !color2) {
          continue;
        }
        ctx.lineWidth = lineWidth;
        ctx.strokeStyle = color2;
        ctx.setLineDash(optsAtIndex.borderDash);
        ctx.lineDashOffset = optsAtIndex.borderDashOffset;
        offset = this.getDistanceFromCenterForValue(opts.reverse ? this.min : this.max);
        position = this.getPointPosition(i, offset);
        ctx.beginPath();
        ctx.moveTo(this.xCenter, this.yCenter);
        ctx.lineTo(position.x, position.y);
        ctx.stroke();
      }
      ctx.restore();
    }
  }
  drawBorder() {
  }
  drawLabels() {
    const ctx = this.ctx;
    const opts = this.options;
    const tickOpts = opts.ticks;
    if (!tickOpts.display) {
      return;
    }
    const startAngle = this.getIndexAngle(0);
    let offset, width;
    ctx.save();
    ctx.translate(this.xCenter, this.yCenter);
    ctx.rotate(startAngle);
    ctx.textAlign = "center";
    ctx.textBaseline = "middle";
    this.ticks.forEach((tick, index2) => {
      if (index2 === 0 && this.min >= 0 && !opts.reverse) {
        return;
      }
      const optsAtIndex = tickOpts.setContext(this.getContext(index2));
      const tickFont = toFont(optsAtIndex.font);
      offset = this.getDistanceFromCenterForValue(this.ticks[index2].value);
      if (optsAtIndex.showLabelBackdrop) {
        ctx.font = tickFont.string;
        width = ctx.measureText(tick.label).width;
        ctx.fillStyle = optsAtIndex.backdropColor;
        const padding = toPadding(optsAtIndex.backdropPadding);
        ctx.fillRect(-width / 2 - padding.left, -offset - tickFont.size / 2 - padding.top, width + padding.width, tickFont.size + padding.height);
      }
      renderText(ctx, tick.label, 0, -offset, tickFont, {
        color: optsAtIndex.color,
        strokeColor: optsAtIndex.textStrokeColor,
        strokeWidth: optsAtIndex.textStrokeWidth
      });
    });
    ctx.restore();
  }
  drawTitle() {
  }
};
var INTERVALS = {
  millisecond: {
    common: true,
    size: 1,
    steps: 1e3
  },
  second: {
    common: true,
    size: 1e3,
    steps: 60
  },
  minute: {
    common: true,
    size: 6e4,
    steps: 60
  },
  hour: {
    common: true,
    size: 36e5,
    steps: 24
  },
  day: {
    common: true,
    size: 864e5,
    steps: 30
  },
  week: {
    common: false,
    size: 6048e5,
    steps: 4
  },
  month: {
    common: true,
    size: 2628e6,
    steps: 12
  },
  quarter: {
    common: false,
    size: 7884e6,
    steps: 4
  },
  year: {
    common: true,
    size: 3154e7
  }
};
var UNITS = /* @__PURE__ */ Object.keys(INTERVALS);
function sorter(a, b) {
  return a - b;
}
function parse(scale, input) {
  if (isNullOrUndef(input)) {
    return null;
  }
  const adapter = scale._adapter;
  const { parser, round: round2, isoWeekday } = scale._parseOpts;
  let value = input;
  if (typeof parser === "function") {
    value = parser(value);
  }
  if (!isNumberFinite(value)) {
    value = typeof parser === "string" ? adapter.parse(value, parser) : adapter.parse(value);
  }
  if (value === null) {
    return null;
  }
  if (round2) {
    value = round2 === "week" && (isNumber(isoWeekday) || isoWeekday === true) ? adapter.startOf(value, "isoWeek", isoWeekday) : adapter.startOf(value, round2);
  }
  return +value;
}
function determineUnitForAutoTicks(minUnit, min, max, capacity) {
  const ilen = UNITS.length;
  for (let i = UNITS.indexOf(minUnit); i < ilen - 1; ++i) {
    const interval = INTERVALS[UNITS[i]];
    const factor = interval.steps ? interval.steps : Number.MAX_SAFE_INTEGER;
    if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {
      return UNITS[i];
    }
  }
  return UNITS[ilen - 1];
}
function determineUnitForFormatting(scale, numTicks, minUnit, min, max) {
  for (let i = UNITS.length - 1; i >= UNITS.indexOf(minUnit); i--) {
    const unit = UNITS[i];
    if (INTERVALS[unit].common && scale._adapter.diff(max, min, unit) >= numTicks - 1) {
      return unit;
    }
  }
  return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];
}
function determineMajorUnit(unit) {
  for (let i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i) {
    if (INTERVALS[UNITS[i]].common) {
      return UNITS[i];
    }
  }
}
function addTick(ticks, time, timestamps) {
  if (!timestamps) {
    ticks[time] = true;
  } else if (timestamps.length) {
    const { lo, hi } = _lookup(timestamps, time);
    const timestamp = timestamps[lo] >= time ? timestamps[lo] : timestamps[hi];
    ticks[timestamp] = true;
  }
}
function setMajorTicks(scale, ticks, map2, majorUnit) {
  const adapter = scale._adapter;
  const first = +adapter.startOf(ticks[0].value, majorUnit);
  const last = ticks[ticks.length - 1].value;
  let major, index2;
  for (major = first; major <= last; major = +adapter.add(major, 1, majorUnit)) {
    index2 = map2[major];
    if (index2 >= 0) {
      ticks[index2].major = true;
    }
  }
  return ticks;
}
function ticksFromTimestamps(scale, values, majorUnit) {
  const ticks = [];
  const map2 = {};
  const ilen = values.length;
  let i, value;
  for (i = 0; i < ilen; ++i) {
    value = values[i];
    map2[value] = i;
    ticks.push({
      value,
      major: false
    });
  }
  return ilen === 0 || !majorUnit ? ticks : setMajorTicks(scale, ticks, map2, majorUnit);
}
var TimeScale = class extends Scale {
  static id = "time";
  static defaults = {
    bounds: "data",
    adapters: {},
    time: {
      parser: false,
      unit: false,
      round: false,
      isoWeekday: false,
      minUnit: "millisecond",
      displayFormats: {}
    },
    ticks: {
      source: "auto",
      callback: false,
      major: {
        enabled: false
      }
    }
  };
  constructor(props) {
    super(props);
    this._cache = {
      data: [],
      labels: [],
      all: []
    };
    this._unit = "day";
    this._majorUnit = void 0;
    this._offsets = {};
    this._normalized = false;
    this._parseOpts = void 0;
  }
  init(scaleOpts, opts = {}) {
    const time = scaleOpts.time || (scaleOpts.time = {});
    const adapter = this._adapter = new adapters._date(scaleOpts.adapters.date);
    adapter.init(opts);
    mergeIf(time.displayFormats, adapter.formats());
    this._parseOpts = {
      parser: time.parser,
      round: time.round,
      isoWeekday: time.isoWeekday
    };
    super.init(scaleOpts);
    this._normalized = opts.normalized;
  }
  parse(raw, index2) {
    if (raw === void 0) {
      return null;
    }
    return parse(this, raw);
  }
  beforeLayout() {
    super.beforeLayout();
    this._cache = {
      data: [],
      labels: [],
      all: []
    };
  }
  determineDataLimits() {
    const options = this.options;
    const adapter = this._adapter;
    const unit = options.time.unit || "day";
    let { min, max, minDefined, maxDefined } = this.getUserBounds();
    function _applyBounds(bounds) {
      if (!minDefined && !isNaN(bounds.min)) {
        min = Math.min(min, bounds.min);
      }
      if (!maxDefined && !isNaN(bounds.max)) {
        max = Math.max(max, bounds.max);
      }
    }
    if (!minDefined || !maxDefined) {
      _applyBounds(this._getLabelBounds());
      if (options.bounds !== "ticks" || options.ticks.source !== "labels") {
        _applyBounds(this.getMinMax(false));
      }
    }
    min = isNumberFinite(min) && !isNaN(min) ? min : +adapter.startOf(Date.now(), unit);
    max = isNumberFinite(max) && !isNaN(max) ? max : +adapter.endOf(Date.now(), unit) + 1;
    this.min = Math.min(min, max - 1);
    this.max = Math.max(min + 1, max);
  }
  _getLabelBounds() {
    const arr = this.getLabelTimestamps();
    let min = Number.POSITIVE_INFINITY;
    let max = Number.NEGATIVE_INFINITY;
    if (arr.length) {
      min = arr[0];
      max = arr[arr.length - 1];
    }
    return {
      min,
      max
    };
  }
  buildTicks() {
    const options = this.options;
    const timeOpts = options.time;
    const tickOpts = options.ticks;
    const timestamps = tickOpts.source === "labels" ? this.getLabelTimestamps() : this._generate();
    if (options.bounds === "ticks" && timestamps.length) {
      this.min = this._userMin || timestamps[0];
      this.max = this._userMax || timestamps[timestamps.length - 1];
    }
    const min = this.min;
    const max = this.max;
    const ticks = _filterBetween(timestamps, min, max);
    this._unit = timeOpts.unit || (tickOpts.autoSkip ? determineUnitForAutoTicks(timeOpts.minUnit, this.min, this.max, this._getLabelCapacity(min)) : determineUnitForFormatting(this, ticks.length, timeOpts.minUnit, this.min, this.max));
    this._majorUnit = !tickOpts.major.enabled || this._unit === "year" ? void 0 : determineMajorUnit(this._unit);
    this.initOffsets(timestamps);
    if (options.reverse) {
      ticks.reverse();
    }
    return ticksFromTimestamps(this, ticks, this._majorUnit);
  }
  afterAutoSkip() {
    if (this.options.offsetAfterAutoskip) {
      this.initOffsets(this.ticks.map((tick) => +tick.value));
    }
  }
  initOffsets(timestamps = []) {
    let start = 0;
    let end = 0;
    let first, last;
    if (this.options.offset && timestamps.length) {
      first = this.getDecimalForValue(timestamps[0]);
      if (timestamps.length === 1) {
        start = 1 - first;
      } else {
        start = (this.getDecimalForValue(timestamps[1]) - first) / 2;
      }
      last = this.getDecimalForValue(timestamps[timestamps.length - 1]);
      if (timestamps.length === 1) {
        end = last;
      } else {
        end = (last - this.getDecimalForValue(timestamps[timestamps.length - 2])) / 2;
      }
    }
    const limit = timestamps.length < 3 ? 0.5 : 0.25;
    start = _limitValue(start, 0, limit);
    end = _limitValue(end, 0, limit);
    this._offsets = {
      start,
      end,
      factor: 1 / (start + 1 + end)
    };
  }
  _generate() {
    const adapter = this._adapter;
    const min = this.min;
    const max = this.max;
    const options = this.options;
    const timeOpts = options.time;
    const minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, this._getLabelCapacity(min));
    const stepSize = valueOrDefault(options.ticks.stepSize, 1);
    const weekday = minor === "week" ? timeOpts.isoWeekday : false;
    const hasWeekday = isNumber(weekday) || weekday === true;
    const ticks = {};
    let first = min;
    let time, count;
    if (hasWeekday) {
      first = +adapter.startOf(first, "isoWeek", weekday);
    }
    first = +adapter.startOf(first, hasWeekday ? "day" : minor);
    if (adapter.diff(max, min, minor) > 1e5 * stepSize) {
      throw new Error(min + " and " + max + " are too far apart with stepSize of " + stepSize + " " + minor);
    }
    const timestamps = options.ticks.source === "data" && this.getDataTimestamps();
    for (time = first, count = 0; time < max; time = +adapter.add(time, stepSize, minor), count++) {
      addTick(ticks, time, timestamps);
    }
    if (time === max || options.bounds === "ticks" || count === 1) {
      addTick(ticks, time, timestamps);
    }
    return Object.keys(ticks).sort(sorter).map((x) => +x);
  }
  getLabelForValue(value) {
    const adapter = this._adapter;
    const timeOpts = this.options.time;
    if (timeOpts.tooltipFormat) {
      return adapter.format(value, timeOpts.tooltipFormat);
    }
    return adapter.format(value, timeOpts.displayFormats.datetime);
  }
  format(value, format) {
    const options = this.options;
    const formats = options.time.displayFormats;
    const unit = this._unit;
    const fmt = format || formats[unit];
    return this._adapter.format(value, fmt);
  }
  _tickFormatFunction(time, index2, ticks, format) {
    const options = this.options;
    const formatter = options.ticks.callback;
    if (formatter) {
      return callback(formatter, [
        time,
        index2,
        ticks
      ], this);
    }
    const formats = options.time.displayFormats;
    const unit = this._unit;
    const majorUnit = this._majorUnit;
    const minorFormat = unit && formats[unit];
    const majorFormat = majorUnit && formats[majorUnit];
    const tick = ticks[index2];
    const major = majorUnit && majorFormat && tick && tick.major;
    return this._adapter.format(time, format || (major ? majorFormat : minorFormat));
  }
  generateTickLabels(ticks) {
    let i, ilen, tick;
    for (i = 0, ilen = ticks.length; i < ilen; ++i) {
      tick = ticks[i];
      tick.label = this._tickFormatFunction(tick.value, i, ticks);
    }
  }
  getDecimalForValue(value) {
    return value === null ? NaN : (value - this.min) / (this.max - this.min);
  }
  getPixelForValue(value) {
    const offsets = this._offsets;
    const pos = this.getDecimalForValue(value);
    return this.getPixelForDecimal((offsets.start + pos) * offsets.factor);
  }
  getValueForPixel(pixel) {
    const offsets = this._offsets;
    const pos = this.getDecimalForPixel(pixel) / offsets.factor - offsets.end;
    return this.min + pos * (this.max - this.min);
  }
  _getLabelSize(label) {
    const ticksOpts = this.options.ticks;
    const tickLabelWidth = this.ctx.measureText(label).width;
    const angle = toRadians(this.isHorizontal() ? ticksOpts.maxRotation : ticksOpts.minRotation);
    const cosRotation = Math.cos(angle);
    const sinRotation = Math.sin(angle);
    const tickFontSize = this._resolveTickFontOptions(0).size;
    return {
      w: tickLabelWidth * cosRotation + tickFontSize * sinRotation,
      h: tickLabelWidth * sinRotation + tickFontSize * cosRotation
    };
  }
  _getLabelCapacity(exampleTime) {
    const timeOpts = this.options.time;
    const displayFormats = timeOpts.displayFormats;
    const format = displayFormats[timeOpts.unit] || displayFormats.millisecond;
    const exampleLabel = this._tickFormatFunction(exampleTime, 0, ticksFromTimestamps(this, [
      exampleTime
    ], this._majorUnit), format);
    const size = this._getLabelSize(exampleLabel);
    const capacity = Math.floor(this.isHorizontal() ? this.width / size.w : this.height / size.h) - 1;
    return capacity > 0 ? capacity : 1;
  }
  getDataTimestamps() {
    let timestamps = this._cache.data || [];
    let i, ilen;
    if (timestamps.length) {
      return timestamps;
    }
    const metas = this.getMatchingVisibleMetas();
    if (this._normalized && metas.length) {
      return this._cache.data = metas[0].controller.getAllParsedValues(this);
    }
    for (i = 0, ilen = metas.length; i < ilen; ++i) {
      timestamps = timestamps.concat(metas[i].controller.getAllParsedValues(this));
    }
    return this._cache.data = this.normalize(timestamps);
  }
  getLabelTimestamps() {
    const timestamps = this._cache.labels || [];
    let i, ilen;
    if (timestamps.length) {
      return timestamps;
    }
    const labels = this.getLabels();
    for (i = 0, ilen = labels.length; i < ilen; ++i) {
      timestamps.push(parse(this, labels[i]));
    }
    return this._cache.labels = this._normalized ? timestamps : this.normalize(timestamps);
  }
  normalize(values) {
    return _arrayUnique(values.sort(sorter));
  }
};
function interpolate2(table, val, reverse) {
  let lo = 0;
  let hi = table.length - 1;
  let prevSource, nextSource, prevTarget, nextTarget;
  if (reverse) {
    if (val >= table[lo].pos && val <= table[hi].pos) {
      ({ lo, hi } = _lookupByKey(table, "pos", val));
    }
    ({ pos: prevSource, time: prevTarget } = table[lo]);
    ({ pos: nextSource, time: nextTarget } = table[hi]);
  } else {
    if (val >= table[lo].time && val <= table[hi].time) {
      ({ lo, hi } = _lookupByKey(table, "time", val));
    }
    ({ time: prevSource, pos: prevTarget } = table[lo]);
    ({ time: nextSource, pos: nextTarget } = table[hi]);
  }
  const span = nextSource - prevSource;
  return span ? prevTarget + (nextTarget - prevTarget) * (val - prevSource) / span : prevTarget;
}
var TimeSeriesScale = class extends TimeScale {
  static id = "timeseries";
  static defaults = TimeScale.defaults;
  constructor(props) {
    super(props);
    this._table = [];
    this._minPos = void 0;
    this._tableRange = void 0;
  }
  initOffsets() {
    const timestamps = this._getTimestampsForTable();
    const table = this._table = this.buildLookupTable(timestamps);
    this._minPos = interpolate2(table, this.min);
    this._tableRange = interpolate2(table, this.max) - this._minPos;
    super.initOffsets(timestamps);
  }
  buildLookupTable(timestamps) {
    const { min, max } = this;
    const items = [];
    const table = [];
    let i, ilen, prev, curr, next;
    for (i = 0, ilen = timestamps.length; i < ilen; ++i) {
      curr = timestamps[i];
      if (curr >= min && curr <= max) {
        items.push(curr);
      }
    }
    if (items.length < 2) {
      return [
        {
          time: min,
          pos: 0
        },
        {
          time: max,
          pos: 1
        }
      ];
    }
    for (i = 0, ilen = items.length; i < ilen; ++i) {
      next = items[i + 1];
      prev = items[i - 1];
      curr = items[i];
      if (Math.round((next + prev) / 2) !== curr) {
        table.push({
          time: curr,
          pos: i / (ilen - 1)
        });
      }
    }
    return table;
  }
  _generate() {
    const min = this.min;
    const max = this.max;
    let timestamps = super.getDataTimestamps();
    if (!timestamps.includes(min) || !timestamps.length) {
      timestamps.splice(0, 0, min);
    }
    if (!timestamps.includes(max) || timestamps.length === 1) {
      timestamps.push(max);
    }
    return timestamps.sort((a, b) => a - b);
  }
  _getTimestampsForTable() {
    let timestamps = this._cache.all || [];
    if (timestamps.length) {
      return timestamps;
    }
    const data = this.getDataTimestamps();
    const label = this.getLabelTimestamps();
    if (data.length && label.length) {
      timestamps = this.normalize(data.concat(label));
    } else {
      timestamps = data.length ? data : label;
    }
    timestamps = this._cache.all = timestamps;
    return timestamps;
  }
  getDecimalForValue(value) {
    return (interpolate2(this._table, value) - this._minPos) / this._tableRange;
  }
  getValueForPixel(pixel) {
    const offsets = this._offsets;
    const decimal = this.getDecimalForPixel(pixel) / offsets.factor - offsets.end;
    return interpolate2(this._table, decimal * this._tableRange + this._minPos, true);
  }
};

// src/app/dashboard/components/reminders/reminder/reminder.component.ts
var _c0 = ["componentElm"];
function ReminderComponent_Conditional_0_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 17)(1, "label");
    \u0275\u0275text(2, " Follow up by ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 10);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "date");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("warning", ctx_r1.isInPast);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(5, 3, ctx_r1.reminder.scheduled_Utc, "MMM d, h:mm a"), " ");
  }
}
function ReminderComponent_Conditional_0_Conditional_23_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6)(1, "span", 10);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r1.reminder.reference.content, " ");
  }
}
function ReminderComponent_Conditional_0_Conditional_23_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 3);
    \u0275\u0275listener("click", function ReminderComponent_Conditional_0_Conditional_23_Conditional_3_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.goToOpportunity(ctx_r1.reminder.reference.referenceId));
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, " Open Appointment ");
    \u0275\u0275elementEnd()();
  }
}
function ReminderComponent_Conditional_0_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13);
    \u0275\u0275conditionalCreate(1, ReminderComponent_Conditional_0_Conditional_23_Conditional_1_Template, 3, 1, "div", 6);
    \u0275\u0275elementStart(2, "div", 2);
    \u0275\u0275conditionalCreate(3, ReminderComponent_Conditional_0_Conditional_23_Conditional_3_Template, 3, 0, "button", 18);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.reminder.reference.content.length > 0 ? 1 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.reminder.reference.type == ctx_r1.ReminderReferenceType.Appointment ? 3 : -1);
  }
}
function ReminderComponent_Conditional_0_Conditional_28_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 16);
    \u0275\u0275element(1, "i", 19);
    \u0275\u0275elementEnd();
  }
}
function ReminderComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 1)(1, "div", 2)(2, "button", 3);
    \u0275\u0275listener("click", function ReminderComponent_Conditional_0_Template_button_click_2_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.completeReminder());
    });
    \u0275\u0275element(3, "span", 4)(4, "i", 5);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 6)(6, "div", 7)(7, "h3");
    \u0275\u0275text(8);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "div", 8)(10, "div", 9)(11, "label");
    \u0275\u0275text(12, " Created By ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "span", 10);
    \u0275\u0275text(14);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(15, "div", 11)(16, "label");
    \u0275\u0275text(17, "On");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "span", 10);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "date");
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(21, ReminderComponent_Conditional_0_Conditional_21_Template, 6, 6, "div", 12);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "div", 6);
    \u0275\u0275conditionalCreate(23, ReminderComponent_Conditional_0_Conditional_23_Template, 4, 2, "div", 13);
    \u0275\u0275elementStart(24, "div", 14)(25, "p");
    \u0275\u0275text(26);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(27, "div", 15);
    \u0275\u0275conditionalCreate(28, ReminderComponent_Conditional_0_Conditional_28_Template, 2, 0, "div", 16);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("completed", ctx_r1.reminder.status == ctx_r1.ReminderStatus.Completed || ctx_r1.reminder.completing);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx_r1.reminder.title);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate2(" ", ctx_r1.reminder.creator == null ? null : ctx_r1.reminder.creator.firstName, " ", ctx_r1.reminder.creator == null ? null : ctx_r1.reminder.creator.lastName, " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(20, 10, ctx_r1.reminder.created_Utc, "MMM d, h:mm a"), " ");
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.reminder.scheduled_Utc != null ? 21 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.reminder.reference != null ? 23 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r1.reminder.note);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.reminder.priority == ctx_r1.ReminderPriority.Critical ? 28 : -1);
  }
}
var _ReminderComponent = class _ReminderComponent {
  constructor(reminderService, uiService, opportunityService, opporutnityUiService, routeService) {
    this.reminderService = reminderService;
    this.uiService = uiService;
    this.opportunityService = opportunityService;
    this.opporutnityUiService = opporutnityUiService;
    this.routeService = routeService;
    this.updated = new Subject();
    this.ReminderStatus = ReminderStatus;
    this.ReminderPriority = ReminderPriority;
    this.isInPast = false;
    this.ReminderReferenceType = ReminderReferenceType;
    this.activeUser = null;
    this.retrieved = new Subject();
  }
  completeReminder() {
    if (this.reminder != null) {
      const reminder = this.reminder;
      reminder.completing = true;
      setTimeout(() => {
        reminder.status = ReminderStatus.Completed;
        this.reminderService.storeReminder(reminder);
        this.updated.next();
      }, 750);
    }
  }
  initReminder() {
    if (this.reminder != null) {
      const now = /* @__PURE__ */ new Date();
      if (this.reminder.scheduled_Utc != null) {
        const scheduled = new Date(this.reminder.scheduled_Utc);
        if (scheduled < now) {
          this.isInPast = true;
        }
      }
    }
  }
  goToOpportunity(id) {
    this.opportunityService.getOpportunity(id).subscribe({
      next: (opportunity) => {
        if (opportunity != null) {
          switch (opportunity.status) {
            case OpportunityStatus.PendingSubmission:
              {
                this.opporutnityUiService.startPreparingEstimate(opportunity);
              }
              break;
            case OpportunityStatus.Submitted:
              {
                this.uiService.prompt("Appointment Already Submitted", "This appointment has already been submitted. Do you want to complete this reminder?", "Yes", "No").subscribe({
                  next: (confirmed) => {
                    if (confirmed) {
                      this.completeReminder();
                    }
                  }
                });
              }
              break;
            default: {
              this.routeService.viewRouteByType("Opportunity", [id], true);
            }
          }
        } else {
          this.uiService.prompt("Appointment Not Found", "The specified appointment could not be found. Please try again or contact support.", "Okay").subscribe({
            next: (confirmed) => {
            }
          });
        }
      }
    });
  }
  init() {
    this.initReminder();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_ReminderComponent.\u0275fac = function ReminderComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ReminderComponent)(\u0275\u0275directiveInject(ReminderService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(OpportunityUiService), \u0275\u0275directiveInject(DeviceRouteService));
};
_ReminderComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ReminderComponent, selectors: [["reminder"]], viewQuery: function ReminderComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { reminder: "reminder", activeUser: "activeUser" }, outputs: { updated: "updated", retrieved: "retrieved" }, standalone: false, decls: 1, vars: 1, consts: [[1, "reminder", 3, "completed"], [1, "reminder"], [1, "controls"], [1, "control", 3, "click"], [1, "fill"], [1, "fa-solid", "fa-check"], [1, "content"], [1, "title"], [1, "meta"], [1, "author"], [1, "value"], [1, "timestamp"], [1, "scheduled", 3, "warning"], [1, "reference"], [1, "notes"], [1, "priority"], [1, "icon", "critical"], [1, "scheduled"], [1, "control"], [1, "fa-sharp", "fa-light", "fa-triangle-exclamation"]], template: function ReminderComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, ReminderComponent_Conditional_0_Template, 29, 13, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.reminder != null ? 0 : -1);
  }
}, dependencies: [DatePipe], styles: ['\n\n.reminder[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  padding: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-right: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n  width: 2vw;\n  height: 2vw;\n  border-radius: 100%;\n  border: 0.2vw var(--color1) solid;\n  position: relative;\n  overflow: hidden;\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .fill[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: var(--color1);\n  border-radius: 100%;\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transition: transform 0.25s var(--easeInOutCirc);\n  -o-transition: transform 0.25s var(--easeInOutCirc);\n  -webkit-transition: transform 0.25s var(--easeInOutCirc);\n  transition: transform 0.25s var(--easeInOutCirc);\n}\n.reminder[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color2);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n  opacity: 0;\n  -moz-transition: opacity 0.4s linear;\n  -o-transition: opacity 0.4s linear;\n  -webkit-transition: opacity 0.4s linear;\n  transition: opacity 0.4s linear;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 80%;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%] {\n  margin-top: -0.2vw;\n  position: relative;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: inline-block;\n  position: relative;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%]:after {\n  display: block;\n  content: "";\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  width: 100%;\n  height: 0.1vw;\n  background-color: var(--color1);\n  pointer-events: none;\n  -moz-transform: scaleX(0);\n  -ms-transform: scaleX(0);\n  -o-transform: scaleX(0);\n  -webkit-transform: scaleX(0);\n  transform: scaleX(0);\n  -moz-transform-origin: left center;\n  -ms-transform-origin: left center;\n  -o-transform-origin: left center;\n  -webkit-transform-origin: left center;\n  transform-origin: left center;\n  -moz-transition: transform 0.5s var(--easeInOutCirc);\n  -o-transition: transform 0.5s var(--easeInOutCirc);\n  -webkit-transition: transform 0.5s var(--easeInOutCirc);\n  transition: transform 0.5s var(--easeInOutCirc);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  color: var(--color3);\n  margin-left: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  color: var(--color4Alt4);\n  margin-left: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled.warning[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]    > .scheduled.warning[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n  -moz-transition: opacity 0.2s var(--easeInOutCirc);\n  -o-transition: opacity 0.2s var(--easeInOutCirc);\n  -webkit-transition: opacity 0.2s var(--easeInOutCirc);\n  transition: opacity 0.2s var(--easeInOutCirc);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0.25vw 0.5vw;\n  background-color: rgba(var(--color5-raw), 0.2);\n  border-radius: 0.25vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  border-radius: 0.5vw;\n  background-color: var(--color3);\n  padding: 0.25vw 0.5vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .reference[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color2);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%] {\n  margin-top: 0.4vw;\n  display: flex;\n  align-items: flex-start;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  margin-left: 0.4vw;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 0.8vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date.scheduled[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color4);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date.completed[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--success);\n}\n.reminder[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .dates[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%] {\n  flex: 1;\n  text-align: right;\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%]    > .icon.important[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--warning);\n}\n.reminder[_ngcontent-%COMP%]    > .priority[_ngcontent-%COMP%]    > .icon.critical[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  color: var(--critical);\n}\n.reminder.completed[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .fill[_ngcontent-%COMP%] {\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n.reminder.completed[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n.reminder.completed[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%]:after {\n  -moz-transform: scaleX(1);\n  -ms-transform: scaleX(1);\n  -o-transform: scaleX(1);\n  -webkit-transform: scaleX(1);\n  transform: scaleX(1);\n}\n.reminder.completed[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  opacity: 0.6;\n}\n/*# sourceMappingURL=reminder.component.css.map */'] });
var ReminderComponent = _ReminderComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ReminderComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "reminder", template: `@if (reminder != null) {
  <div class="reminder"
    [class.completed]="reminder.status == ReminderStatus.Completed || reminder.completing">
    <div class="controls">
      <button class="control" (click)="completeReminder()">
        <span class="fill"></span>
        <i class="fa-solid fa-check"></i>
      </button>
    </div>
    <div class="content">
      <div class="title">
        <h3>{{reminder.title}}</h3>
        <div class="meta">
          <div class="author">
            <label>
              Created By
            </label>
            <span class="value">
              {{reminder.creator?.firstName}} {{reminder.creator?.lastName}}
            </span>
          </div>
          <div class="timestamp">
            <label>On</label>
            <span class="value">
              {{reminder.created_Utc | date:'MMM d, h:mm a'}}
            </span>
          </div>
        </div>
        @if (reminder.scheduled_Utc != null) {
          <div class="scheduled" [class.warning]="isInPast"
            >
            <label>
              Follow up by
            </label>
            <span class="value">
              {{reminder.scheduled_Utc | date:'MMM d, h:mm a'}}
            </span>
          </div>
        }
      </div>
      <div class="content">
        @if (reminder.reference != null) {
          <div class="reference">
            @if (reminder.reference.content.length > 0) {
              <div class="content">
                <span class="value">
                  {{reminder.reference.content}}
                </span>
              </div>
            }
            <div class="controls">
              @if (reminder.reference.type == ReminderReferenceType.Appointment) {
                <button class="control"
                  (click)="goToOpportunity(reminder.reference.referenceId)">
                  <label>
                    Open Appointment
                  </label>
                </button>
              }
            </div>
          </div>
        }
        <div class="notes">
          <p>{{reminder.note}}</p>
        </div>
      </div>
    </div>
    <div class="priority">
      @if (reminder.priority == ReminderPriority.Critical) {
        <div class="icon critical">
          <i class="fa-sharp fa-light fa-triangle-exclamation"></i>
        </div>
      }
    </div>
  </div>
}`, styles: ['/* src/app/dashboard/components/reminders/reminder/reminder.component.scss */\n.reminder {\n  display: flex;\n  align-items: flex-start;\n  padding: 1vw;\n}\n.reminder > .controls {\n  margin-right: 1vw;\n}\n.reminder > .controls > .control {\n  cursor: pointer;\n  display: block;\n  width: 2vw;\n  height: 2vw;\n  border-radius: 100%;\n  border: 0.2vw var(--color1) solid;\n  position: relative;\n  overflow: hidden;\n}\n.reminder > .controls > .control > .fill {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: var(--color1);\n  border-radius: 100%;\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transition: transform 0.25s var(--easeInOutCirc);\n  -o-transition: transform 0.25s var(--easeInOutCirc);\n  -webkit-transition: transform 0.25s var(--easeInOutCirc);\n  transition: transform 0.25s var(--easeInOutCirc);\n}\n.reminder > .controls > .control > i {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color2);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n  opacity: 0;\n  -moz-transition: opacity 0.4s linear;\n  -o-transition: opacity 0.4s linear;\n  -webkit-transition: opacity 0.4s linear;\n  transition: opacity 0.4s linear;\n}\n.reminder > .content {\n  width: 80%;\n}\n.reminder > .content > .title {\n  margin-top: -0.2vw;\n  position: relative;\n}\n.reminder > .content > .title h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: inline-block;\n  position: relative;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n.reminder > .content > .title h3:after {\n  display: block;\n  content: "";\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  width: 100%;\n  height: 0.1vw;\n  background-color: var(--color1);\n  pointer-events: none;\n  -moz-transform: scaleX(0);\n  -ms-transform: scaleX(0);\n  -o-transform: scaleX(0);\n  -webkit-transform: scaleX(0);\n  transform: scaleX(0);\n  -moz-transform-origin: left center;\n  -ms-transform-origin: left center;\n  -o-transform-origin: left center;\n  -webkit-transform-origin: left center;\n  transform-origin: left center;\n  -moz-transition: transform 0.5s var(--easeInOutCirc);\n  -o-transition: transform 0.5s var(--easeInOutCirc);\n  -webkit-transition: transform 0.5s var(--easeInOutCirc);\n  transition: transform 0.5s var(--easeInOutCirc);\n}\n.reminder > .content > .title > .meta {\n  display: flex;\n  align-items: center;\n}\n.reminder > .content > .title > .meta > .timestamp {\n  margin-left: 0.25vw;\n}\n.reminder > .content > .title > .meta label,\n.reminder > .content > .title > .meta .value {\n  display: inline-block;\n  vertical-align: middle;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.reminder > .content > .title > .meta .value {\n  color: var(--color3);\n  margin-left: 0.25vw;\n}\n.reminder > .content > .title > .scheduled {\n  display: flex;\n  align-items: center;\n}\n.reminder > .content > .title > .scheduled label,\n.reminder > .content > .title > .scheduled .value {\n  display: inline-block;\n  vertical-align: middle;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.reminder > .content > .title > .scheduled .value {\n  color: var(--color4Alt4);\n  margin-left: 0.25vw;\n}\n.reminder > .content > .title > .scheduled.warning label {\n  color: var(--error);\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n.reminder > .content > .title > .scheduled.warning .value {\n  color: var(--error);\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n.reminder > .content > .content {\n  margin-top: 0.4vw;\n  -moz-transition: opacity 0.2s var(--easeInOutCirc);\n  -o-transition: opacity 0.2s var(--easeInOutCirc);\n  -webkit-transition: opacity 0.2s var(--easeInOutCirc);\n  transition: opacity 0.2s var(--easeInOutCirc);\n}\n.reminder > .content > .content > .reference {\n  margin-top: 0.4vw;\n}\n.reminder > .content > .content > .reference > .content {\n  padding: 0.25vw 0.5vw;\n  background-color: rgba(var(--color5-raw), 0.2);\n  border-radius: 0.25vw;\n}\n.reminder > .content > .content > .reference > .content > .value {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color5Alt4);\n  font-weight: var(--strong);\n}\n.reminder > .content > .content > .reference > .controls {\n  margin-top: 0.4vw;\n}\n.reminder > .content > .content > .reference > .controls > .control {\n  cursor: pointer;\n  border-radius: 0.5vw;\n  background-color: var(--color3);\n  padding: 0.25vw 0.5vw;\n}\n.reminder > .content > .content > .reference > .controls > .control > label {\n  font-size: 1vw;\n  color: var(--color2);\n}\n.reminder > .content > .content > .notes {\n  margin-top: 0.4vw;\n}\n.reminder > .content > .content > .notes p {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n.reminder > .content > .content > .dates {\n  margin-top: 0.4vw;\n  display: flex;\n  align-items: flex-start;\n}\n.reminder > .content > .content > .dates > .date {\n  display: flex;\n  flex-direction: column;\n  margin-left: 0.4vw;\n}\n.reminder > .content > .content > .dates > .date label {\n  font-size: 0.8vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n.reminder > .content > .content > .dates > .date > .value {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n.reminder > .content > .content > .dates > .date.scheduled > label {\n  color: var(--color4);\n}\n.reminder > .content > .content > .dates > .date.completed > label {\n  color: var(--success);\n}\n.reminder > .content > .content > .dates > .date:first-child {\n  margin-left: 0;\n}\n.reminder > .priority {\n  flex: 1;\n  text-align: right;\n}\n.reminder > .priority > .icon i {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n.reminder > .priority > .icon.important i {\n  color: var(--warning);\n}\n.reminder > .priority > .icon.critical i {\n  color: var(--critical);\n}\n.reminder.completed > .controls > .control > .fill {\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n.reminder.completed > .controls > .control > i {\n  opacity: 1;\n}\n.reminder.completed > .meta > .title h3:after {\n  -moz-transform: scaleX(1);\n  -ms-transform: scaleX(1);\n  -o-transform: scaleX(1);\n  -webkit-transform: scaleX(1);\n  transform: scaleX(1);\n}\n.reminder.completed > .meta > .content {\n  opacity: 0.6;\n}\n/*# sourceMappingURL=reminder.component.css.map */\n'] }]
  }], () => [{ type: ReminderService }, { type: UiService }, { type: OpportunityService }, { type: OpportunityUiService }, { type: DeviceRouteService }], { reminder: [{
    type: Input,
    args: ["reminder"]
  }], updated: [{
    type: Output,
    args: ["updated"]
  }], activeUser: [{
    type: Input,
    args: ["activeUser"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], retrieved: [{
    type: Output,
    args: ["retrieved"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ReminderComponent, { className: "ReminderComponent" });
})();

// src/app/dashboard/components/reminders/reminders.component.ts
var _c02 = ["componentElm"];
function RemindersComponent_Conditional_32_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 12);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", true);
  }
}
function RemindersComponent_Conditional_33_For_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "reminder", 15);
    \u0275\u0275listener("updated", function RemindersComponent_Conditional_33_For_1_Template_reminder_updated_0_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.sortReminders());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const reminder_r3 = ctx.$implicit;
    \u0275\u0275property("reminder", reminder_r3);
  }
}
function RemindersComponent_Conditional_33_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275repeaterCreate(0, RemindersComponent_Conditional_33_For_1_Template, 1, 1, "reminder", 14, \u0275\u0275repeaterTrackByIdentity);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275repeater(ctx_r1.displayReminders);
  }
}
function RemindersComponent_Conditional_34_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275textInterpolate2(" You currently have no ", ctx_r1.selectedSort, " reminders with ", ctx_r1.selectedPriority, " priority. ");
  }
}
function RemindersComponent_Conditional_34_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275textInterpolate1(" You currently have no reminders with ", ctx_r1.selectedPriority, " priority. ");
  }
}
function RemindersComponent_Conditional_34_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13)(1, "p");
    \u0275\u0275conditionalCreate(2, RemindersComponent_Conditional_34_Conditional_2_Template, 1, 2);
    \u0275\u0275conditionalCreate(3, RemindersComponent_Conditional_34_Conditional_3_Template, 1, 1);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r1.selectedSort != "All" ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.selectedSort == "All" ? 3 : -1);
  }
}
var _RemindersComponent = class _RemindersComponent {
  constructor(uiService, orderByPipe, authRefService, reminderService, apiService) {
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.authRefService = authRefService;
    this.reminderService = reminderService;
    this.apiService = apiService;
    this.user = null;
    this.online = false;
    this.selectedSort = "Open";
    this.selectingSort = false;
    this.selectedPriority = "Critical";
    this.selectingPriority = false;
    this.updatingReminders = false;
    this.reminders = [];
    this.displayReminders = [];
    this.now = /* @__PURE__ */ new Date();
    this.ReminderStatus = ReminderStatus;
    this.ReminderPriority = ReminderPriority;
    this.activeUser = null;
    this.retrieved = new Subject();
  }
  get firstName() {
    return this.user?.firstName ?? "";
  }
  get profileImage() {
    return this.user?.profileImage_B64;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.user = user;
      }
    });
  }
  watchSync() {
    this.onlineSubscription = this.apiService.online.subscribe({
      next: (online) => {
        if (online) {
          if (!this.online) {
            this.online = true;
            this.syncReminders();
          }
        }
      }
    });
  }
  setSort(sort) {
    this.selectedSort = sort;
    this.selectingSort = false;
    this.sortReminders();
  }
  selectSort() {
    this.selectingSort = !this.selectingSort;
  }
  setPriority(priority) {
    this.selectedPriority = priority;
    this.selectingPriority = false;
    this.sortReminders();
  }
  selectPriority() {
    this.selectingPriority = !this.selectingPriority;
  }
  get showMissingRemindersMessage() {
    return this.displayReminders.length == 0 && !this.updatingReminders;
  }
  get showReminders() {
    return this.displayReminders.length > 0 && !this.updatingReminders;
  }
  get showRemindersLoader() {
    return this.updatingReminders;
  }
  syncReminders() {
    if (!this.updatingReminders) {
      this.updatingReminders = true;
      if (this.user != null) {
        this.reminderService.syncRemindersForUser(this.user.id).subscribe({
          next: (reminders) => {
            setTimeout(() => {
              this.getLocalReminders();
            }, 500);
          },
          error: () => {
            this.updatingReminders = false;
          }
        });
      }
    }
  }
  sortReminders() {
    const reminders = [];
    for (var i = 0, len = this.reminders.length; i < len; i++) {
      const reminder = this.reminders[i];
      switch (this.selectedSort) {
        case "All":
          {
            reminders.push(reminder);
          }
          break;
        case "Open":
          {
            if (reminder.status != ReminderStatus.Completed) {
              reminders.push(reminder);
            }
          }
          break;
        case "Completed":
          {
            if (reminder.status == ReminderStatus.Completed) {
              reminders.push(reminder);
            }
          }
          break;
      }
    }
    const sortedReminders = [];
    for (var i = 0, len = reminders.length; i < len; i++) {
      const reminder = reminders[i];
      switch (this.selectedPriority) {
        case "All":
          {
            sortedReminders.push(reminder);
          }
          break;
        case "Standard":
          {
            if (reminder.priority == ReminderPriority.Standard) {
              sortedReminders.push(reminder);
            }
          }
          break;
        case "Critical":
          {
            if (reminder.priority == ReminderPriority.Critical) {
              sortedReminders.push(reminder);
            }
          }
          break;
      }
    }
    this.displayReminders = this.orderByPipe.transform(sortedReminders, "lastUpdated_Utc", true);
  }
  getLocalReminders() {
    const activeUser = this.authRefService.user.getValue();
    if (activeUser != null) {
      this.reminderService.getReminders(activeUser.id).subscribe({
        next: (reminders) => {
          this.reminders = reminders;
          this.sortReminders();
          this.retrieved.next(this.reminders);
          this.updatingReminders = false;
        },
        error: () => {
          this.updatingReminders = false;
        }
      });
    }
  }
  updateReminders(reminders) {
    reminders.forEach((reminder) => {
      const existingReminder = this.reminders.find((x) => x.id == reminder.id);
      if (existingReminder == null) {
        this.reminders.push(reminder);
      }
    });
    this.sortReminders();
    this.retrieved.next(this.reminders);
  }
  initReminders() {
    this.savedReminderSubscription = this.reminderService.reminderSaved.subscribe({
      next: (reminders) => {
        this.getLocalReminders();
      }
    });
  }
  createReminder() {
    const user = this.authRefService.user.getValue();
    if (user != null && this.activeUser != null) {
      this.reminderService.manageReminder(void 0, user, this.activeUser);
    }
  }
  init() {
    this.watchUser();
    this.watchSync();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.reminderSubscription?.unsubscribe();
    this.savedReminderSubscription?.unsubscribe();
  }
};
_RemindersComponent.\u0275fac = function RemindersComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _RemindersComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(ReminderService), \u0275\u0275directiveInject(ApiService));
};
_RemindersComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _RemindersComponent, selectors: [["reminders"]], viewQuery: function RemindersComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { activeUser: "activeUser" }, outputs: { retrieved: "retrieved" }, standalone: false, decls: 35, vars: 15, consts: [["id", "tasks"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-plus"], [1, "secondary"], [1, "primary-controls"], [1, "secondary-controls"], [1, "control", "all", 3, "click"], [1, "control", "standard", 3, "click"], [1, "control", "critical", 3, "click"], [1, "reminders"], [3, "fill"], [1, "message"], [3, "reminder"], [3, "updated", "reminder"]], template: function RemindersComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "h1");
    \u0275\u0275text(4, "Your reminders");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 2)(6, "button", 3);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_6_listener() {
      return ctx.createReminder();
    });
    \u0275\u0275element(7, "i", 4);
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Add a reminder");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(10, "div", 5)(11, "div", 6)(12, "button", 3);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_12_listener() {
      return ctx.setSort("All");
    });
    \u0275\u0275elementStart(13, "label");
    \u0275\u0275text(14, "All Tasks");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(15, "button", 3);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_15_listener() {
      return ctx.setSort("Open");
    });
    \u0275\u0275elementStart(16, "label");
    \u0275\u0275text(17, "Open");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "button", 3);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_18_listener() {
      return ctx.setSort("Completed");
    });
    \u0275\u0275elementStart(19, "label");
    \u0275\u0275text(20, "Completed");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(21, "div", 7)(22, "button", 8);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_22_listener() {
      return ctx.setPriority("All");
    });
    \u0275\u0275elementStart(23, "label");
    \u0275\u0275text(24, "All Priorities");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(25, "button", 9);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_25_listener() {
      return ctx.setPriority("Standard");
    });
    \u0275\u0275elementStart(26, "label");
    \u0275\u0275text(27, "Normal");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(28, "button", 10);
    \u0275\u0275listener("click", function RemindersComponent_Template_button_click_28_listener() {
      return ctx.setPriority("Critical");
    });
    \u0275\u0275elementStart(29, "label");
    \u0275\u0275text(30, "Critical");
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(31, "div", 11);
    \u0275\u0275conditionalCreate(32, RemindersComponent_Conditional_32_Template, 1, 1, "loader", 12);
    \u0275\u0275conditionalCreate(33, RemindersComponent_Conditional_33_Template, 2, 0);
    \u0275\u0275conditionalCreate(34, RemindersComponent_Conditional_34_Template, 4, 2, "div", 13);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(12);
    \u0275\u0275classProp("active", ctx.selectedSort == "All");
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx.selectedSort == "Open");
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx.selectedSort == "Completed");
    \u0275\u0275advance(4);
    \u0275\u0275classProp("active", ctx.selectedPriority == "All");
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx.selectedPriority == "Standard");
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx.selectedPriority == "Critical");
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx.showRemindersLoader ? 32 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showReminders ? 33 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showMissingRemindersMessage ? 34 : -1);
  }
}, dependencies: [LoaderComponent, ReminderComponent], styles: ["\n\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: 1vw 2vw 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%] {\n  position: relative;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  padding: 0.5vw 0.8vw;\n  border-radius: 0.5vw;\n  background-color: transparent;\n  margin-left: 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n  cursor: pointer;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .primary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  display: flex;\n  align-items: center;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  white-space: nowrap;\n  text-align: center;\n  padding: 0.4vw 0.6vw;\n  border-radius: 0.5vw;\n  background-color: transparent;\n  margin-left: 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n  cursor: pointer;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 0.9vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.all[_ngcontent-%COMP%] {\n  background-color: var(--color1);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.standard[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.important[_ngcontent-%COMP%] {\n  background-color: var(--warning);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active.critical[_ngcontent-%COMP%] {\n  background-color: var(--critical);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#tasks[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .secondary-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  padding: 0 2vw 2vw;\n  position: relative;\n  z-index: 0;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  margin: 0 auto;\n  display: block;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 1s;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]   reminder[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 1.25vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]   reminder[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]   reminder[_ngcontent-%COMP%]:last-child {\n  border-bottom: none;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 10%;\n  width: 75%;\n}\n#tasks[_ngcontent-%COMP%]    > .reminders[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n/*# sourceMappingURL=reminders.component.css.map */"] });
var RemindersComponent = _RemindersComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(RemindersComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "reminders", template: `<section id="tasks">
  <header>
    <div class="primary">
      <h1>Your reminders</h1>
      <div class="controls">
        <button class="control" (click)="createReminder()">
          <i class="fa-solid fa-plus"></i>
          <label>Add a reminder</label>
        </button>
      </div>
    </div>
    <div class="secondary">
      <div class="primary-controls">
        <button class="control" (click)="setSort('All')" [class.active]="selectedSort == 'All'">
          <label>All Tasks</label>
        </button>
        <button class="control" (click)="setSort('Open')" [class.active]="selectedSort == 'Open'">
          <label>Open</label>
        </button>
        <button class="control" (click)="setSort('Completed')" [class.active]="selectedSort == 'Completed'">
          <label>Completed</label>
        </button>
      </div>
      <div class="secondary-controls">
        <button class="control all" (click)="setPriority('All')" [class.active]="selectedPriority == 'All'">
          <label>All Priorities</label>
        </button>
        <button class="control standard" (click)="setPriority('Standard')"
          [class.active]="selectedPriority == 'Standard'">
          <label>Normal</label>
        </button>
        <button class="control critical" (click)="setPriority('Critical')"
          [class.active]="selectedPriority == 'Critical'">
          <label>Critical</label>
        </button>
      </div>
    </div>
  </header>

  <div class="reminders">
    @if (showRemindersLoader) {
      <loader [fill]="true"></loader>
    }

    @if (showReminders) {
      @for (reminder of displayReminders; track reminder) {
        <reminder
          [reminder]="reminder"
          (updated)="sortReminders()"
          >
        </reminder>
      }
    }

    @if (showMissingRemindersMessage) {
      <div class="message">
        <p>
          @if (selectedSort != 'All') {
            You currently have no {{selectedSort}} reminders with {{selectedPriority}} priority.
          }
          @if (selectedSort == 'All') {
            You currently have no reminders with {{selectedPriority}} priority.
          }
        </p>
      </div>
    }
  </div>
</section>`, styles: ["/* src/app/dashboard/components/reminders/reminders.component.scss */\n#tasks > header {\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: 1vw 2vw 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#tasks > header > .primary {\n  display: flex;\n  align-items: center;\n}\n#tasks > header > .primary h1 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#tasks > header > .primary > .controls {\n  flex: 1;\n  width: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#tasks > header > .primary > .controls > .control {\n  margin-left: 0.5vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#tasks > header > .primary > .controls > .control > i,\n#tasks > header > .primary > .controls > .control > label {\n  color: var(--color3);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#tasks > header > .primary > .controls > .control > i {\n  font-size: 1.4vw;\n}\n#tasks > header > .primary > .controls > .control > label {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#tasks > header > .primary > .controls > .control:first-child {\n  margin-left: 0;\n}\n#tasks > header > .secondary {\n  margin-top: 0.5vw;\n}\n#tasks > header > .secondary > .primary-controls {\n  position: relative;\n}\n#tasks > header > .secondary > .primary-controls > .control {\n  padding: 0.5vw 0.8vw;\n  border-radius: 0.5vw;\n  background-color: transparent;\n  margin-left: 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n  cursor: pointer;\n}\n#tasks > header > .secondary > .primary-controls > .control > label {\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#tasks > header > .secondary > .primary-controls > .control.active {\n  background-color: var(--color5);\n}\n#tasks > header > .secondary > .primary-controls > .control.active > label {\n  color: var(--color2);\n}\n#tasks > header > .secondary > .primary-controls > .control:first-child {\n  margin-left: 0;\n}\n#tasks > header > .secondary > .secondary-controls {\n  margin-top: 0.5vw;\n  display: flex;\n  align-items: center;\n}\n#tasks > header > .secondary > .secondary-controls > .control {\n  white-space: nowrap;\n  text-align: center;\n  padding: 0.4vw 0.6vw;\n  border-radius: 0.5vw;\n  background-color: transparent;\n  margin-left: 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n  cursor: pointer;\n}\n#tasks > header > .secondary > .secondary-controls > .control > label {\n  font-size: 0.9vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#tasks > header > .secondary > .secondary-controls > .control.active.all {\n  background-color: var(--color1);\n}\n#tasks > header > .secondary > .secondary-controls > .control.active.standard {\n  background-color: var(--color3);\n}\n#tasks > header > .secondary > .secondary-controls > .control.active.important {\n  background-color: var(--warning);\n}\n#tasks > header > .secondary > .secondary-controls > .control.active.critical {\n  background-color: var(--critical);\n}\n#tasks > header > .secondary > .secondary-controls > .control.active > label {\n  color: var(--color2);\n}\n#tasks > header > .secondary > .secondary-controls > .control:first-child {\n  margin-left: 0;\n}\n#tasks > .reminders {\n  margin-top: 2vw;\n  padding: 0 2vw 2vw;\n  position: relative;\n  z-index: 0;\n}\n#tasks > .reminders > loader {\n  margin: 0 auto;\n  display: block;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 1s;\n}\n#tasks > .reminders reminder {\n  display: block;\n  margin-top: 1.25vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n}\n#tasks > .reminders reminder:first-child {\n  margin-top: 0;\n}\n#tasks > .reminders reminder:last-child {\n  border-bottom: none;\n}\n#tasks > .reminders > .message {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 10%;\n  width: 75%;\n}\n#tasks > .reminders > .message p {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n/*# sourceMappingURL=reminders.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: OrderByPipe }, { type: AuthRefService }, { type: ReminderService }, { type: ApiService }], { activeUser: [{
    type: Input,
    args: ["activeUser"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], retrieved: [{
    type: Output,
    args: ["retrieved"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(RemindersComponent, { className: "RemindersComponent" });
})();

// src/app/dashboard/components/rc/rc.component.ts
function RcComponent_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 4);
    \u0275\u0275element(1, "img", 21);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r0.profileImage, \u0275\u0275sanitizeUrl);
  }
}
function RcComponent_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.summaryText, " ");
  }
}
function RcComponent_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 5)(1, "p");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275element(3, "div", 22)(4, "div", 22);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r0.summaryLoaderLabel);
  }
}
function RcComponent_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 9);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, ctx_r0.closePercentage), "% ");
  }
}
function RcComponent_Conditional_40_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 18);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", true);
  }
}
function RcComponent_Conditional_41_For_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "opportunity-summary", 23);
  }
  if (rf & 2) {
    const opportunity_r2 = ctx.$implicit;
    \u0275\u0275property("opportunity", opportunity_r2);
  }
}
function RcComponent_Conditional_41_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19);
    \u0275\u0275repeaterCreate(1, RcComponent_Conditional_41_For_2_Template, 1, 1, "opportunity-summary", 23, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r0.todaysOpportunities);
  }
}
function RcComponent_Conditional_42_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 20)(1, "p");
    \u0275\u0275text(2, " You currently have no appointments scheduled for today. ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 24)(4, "button", 16);
    \u0275\u0275listener("click", function RcComponent_Conditional_42_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.goToBookOfBusiness());
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, " Go to Book of Business ");
    \u0275\u0275elementEnd()()()();
  }
}
Chart.register(CategoryScale, index, plugin_tooltip, LinearScale, LineController, LineElement, PointElement, plugin_title);
var _RcComponent = class _RcComponent {
  constructor(http, dashboardService, aiService, uiService, deviceRouteService, authRefService, orderByPipe, opportunityService, storageService, logService, apiService) {
    this.http = http;
    this.dashboardService = dashboardService;
    this.aiService = aiService;
    this.uiService = uiService;
    this.deviceRouteService = deviceRouteService;
    this.authRefService = authRefService;
    this.orderByPipe = orderByPipe;
    this.opportunityService = opportunityService;
    this.storageService = storageService;
    this.logService = logService;
    this.apiService = apiService;
    this.user = null;
    this.closePercentage = new BehaviorSubject(0);
    this.showClosePercentage = false;
    this.reminders = [];
    this.retrievingSummary = false;
    this.summaryLoaderLabel = "Your AI summary for today...";
    this.summaryText = "generating ai summmary...";
    this.online = false;
    this.OpportunityStatus = OpportunityStatus;
    this.todaysOpportunities = [];
    this.updatingOpportunities = false;
    this.userId = new BehaviorSubject(void 0);
    this.params = new BehaviorSubject([]);
    this.today = /* @__PURE__ */ new Date();
  }
  get firstName() {
    return this.user?.firstName ?? "";
  }
  get profileImage() {
    return this.user?.profileImage_B64;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.user = user;
      }
    });
  }
  calcClosePercentage() {
    if (this.user != null) {
      this.dashboardService.calcClosePercentage(this.user).then((percentage) => {
        this.closePercentage.next(percentage);
        this.showClosePercentage = true;
      });
    }
  }
  finalizeReminders(reminders) {
    this.reminders = reminders;
    this.initSummaryText();
  }
  initSummaryText() {
    this.summaryText = this.aiService.generateDailySummary(this.todaysOpportunities, this.reminders);
  }
  watchSync() {
    this.onlineSubscription = this.apiService.online.subscribe({
      next: (online) => {
        if (online && !this.online) {
          this.syncOpportunities();
        } else if (!online && this.online != online) {
          this.getLocalOpportunities();
        }
        this.online = online;
      }
    });
  }
  get showMissingOpportunitiesMessage() {
    return this.todaysOpportunities.length == 0 && !this.updatingOpportunities;
  }
  get showOpportunities() {
    return this.todaysOpportunities.length > 0 && !this.updatingOpportunities;
  }
  get showOpportunitiesLoader() {
    return this.updatingOpportunities;
  }
  get hasAppointments() {
    return this.todaysOpportunities.length > 0;
  }
  get loadingUpcomingOpportunities() {
    return this.updatingOpportunities;
  }
  sortOpportunities() {
    this.todaysOpportunities = this.orderByPipe.transform(this.todaysOpportunities, "scheduled_Utc", true);
  }
  getLocalOpportunities() {
    if (this.user != null) {
      this.opportunityService.getOpportunitiesForToday(this.user.id).subscribe({
        next: (opportunities) => {
          this.updateOpportunities(opportunities);
          this.updatingOpportunities = false;
        },
        error: () => {
          this.updatingOpportunities = false;
        }
      });
    }
  }
  syncOpportunities() {
    if (!this.updatingOpportunities) {
      this.updatingOpportunities = true;
      if (this.user != null) {
        this.opportunityService.syncTodayOpportunitiesForUser(this.user.id).subscribe({
          next: (opportunities) => {
            this.getLocalOpportunities();
            this.initSummaryText();
          },
          error: () => {
            this.updatingOpportunities = false;
          }
        });
      }
    }
  }
  updateOpportunities(opportunities) {
    for (var i = 0, len = opportunities.length; i < len; i++) {
      const appointment = opportunities[i];
      const existingAppointment = this.todaysOpportunities.find((x) => x.id == appointment.id);
      if (existingAppointment == null) {
        this.todaysOpportunities.push(appointment);
      }
    }
    this.sortOpportunities();
    this.calcClosePercentage();
  }
  promptToRefreshOpportunities() {
    this.uiService.prompt("Refresh Today's Appointments", "Do you wish to manually check for new appointments for today?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.syncOpportunities();
        }
      }
    });
  }
  goToBookOfBusiness() {
    this.deviceRouteService.viewRouteByType("BookOfBusiness", [], true);
  }
  // #endregion
  // #region Ledger
  syncLedger() {
    this.storageService.remoteStoreOpportunityLedgerEntries().subscribe({
      next: () => {
      },
      error: (e) => {
        this.logService.log(JSON.stringify(e), `RC DASHBOARD: Failed to remotely store outstanding ledger entries.`).subscribe();
      }
    });
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        let route = params[0]?.toLowerCase();
        if (route != null) {
        }
      }
    });
  }
  init() {
    this.syncLedger();
    this.watchParams();
    this.watchUser();
    this.watchSync();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
    this.paramsSubscription?.unsubscribe();
    this.onlineSubscription?.unsubscribe();
  }
};
_RcComponent.\u0275fac = function RcComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _RcComponent)(\u0275\u0275directiveInject(HttpClient), \u0275\u0275directiveInject(DashboardService), \u0275\u0275directiveInject(AiService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(StorageService), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(ApiService));
};
_RcComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _RcComponent, selectors: [["rc-view"]], inputs: { userId: "userId", route: "route", params: "params" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 43, vars: 13, consts: [["id", "rcView"], [1, "primary"], [1, "content"], [1, "summary", "card"], [1, "profile"], [1, "loader"], [1, "closing"], [1, "tile"], [1, "bg"], [1, "value"], [1, "focus"], [1, "column", "tasks"], [3, "retrieved", "activeUser"], [1, "column", "opportunities"], [1, "secondary"], [1, "icon-controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrows-rotate"], [3, "fill"], [1, "opportunities"], [1, "message"], [3, "src"], [1, "bar"], [3, "opportunity"], [1, "controls"]], template: function RcComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1)(2, "div", 2)(3, "div", 3);
    \u0275\u0275conditionalCreate(4, RcComponent_Conditional_4_Template, 2, 1, "div", 4);
    \u0275\u0275elementStart(5, "div", 2)(6, "header")(7, "h2");
    \u0275\u0275text(8);
    \u0275\u0275pipe(9, "date");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "h3");
    \u0275\u0275text(11);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(12, "div", 2);
    \u0275\u0275conditionalCreate(13, RcComponent_Conditional_13_Template, 2, 1, "p");
    \u0275\u0275conditionalCreate(14, RcComponent_Conditional_14_Template, 5, 1, "div", 5);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(15, "div", 6)(16, "div", 7);
    \u0275\u0275element(17, "div", 8);
    \u0275\u0275elementStart(18, "div", 2)(19, "label");
    \u0275\u0275text(20, "Current Week");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(21, "h3");
    \u0275\u0275text(22, "Gross Close Percentage");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(23, "p");
    \u0275\u0275text(24, "Your appointment sell-through rate.");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(25, RcComponent_Conditional_25_Template, 3, 3, "span", 9);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(26, "div", 10)(27, "div", 2)(28, "div", 11)(29, "reminders", 12);
    \u0275\u0275listener("retrieved", function RcComponent_Template_reminders_retrieved_29_listener($event) {
      return ctx.finalizeReminders($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(30, "div", 13)(31, "header")(32, "div", 1)(33, "h2");
    \u0275\u0275text(34, " Today's Appointments ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(35, "div", 14)(36, "div", 15)(37, "button", 16);
    \u0275\u0275listener("click", function RcComponent_Template_button_click_37_listener() {
      return ctx.promptToRefreshOpportunities();
    });
    \u0275\u0275element(38, "i", 17);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(39, "div", 2);
    \u0275\u0275conditionalCreate(40, RcComponent_Conditional_40_Template, 1, 1, "loader", 18);
    \u0275\u0275conditionalCreate(41, RcComponent_Conditional_41_Template, 3, 0, "div", 19);
    \u0275\u0275conditionalCreate(42, RcComponent_Conditional_42_Template, 7, 0, "div", 20);
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx.profileImage != null ? 4 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("Your daily summary for ", \u0275\u0275pipeBind2(9, 10, ctx.today, "EEEE, MMMM d"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("Welcome back, ", ctx.firstName);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.retrievingSummary ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.retrievingSummary ? 14 : -1);
    \u0275\u0275advance(11);
    \u0275\u0275conditional(ctx.showClosePercentage ? 25 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275property("activeUser", ctx.user);
    \u0275\u0275advance(11);
    \u0275\u0275conditional(ctx.showOpportunitiesLoader ? 40 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showOpportunities ? 41 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showMissingOpportunitiesMessage ? 42 : -1);
  }
}, dependencies: [LoaderComponent, OpportunitySummaryComponent, RemindersComponent, AsyncPipe, DatePipe], styles: [`

@-webkit-keyframes _ngcontent-%COMP%_closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
@-moz-keyframes closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
@-o-keyframes closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
@keyframes _ngcontent-%COMP%_closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
#rcView[_ngcontent-%COMP%] {
  position: absolute;
  top: calc(6vw + var(--systemOffset-top));
  left: 2vw;
  right: 2vw;
  bottom: 2vw;
  display: flex;
  flex-direction: column;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  display: flex;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%] {
  width: 70%;
  border-radius: 1vw;
  position: relative;
  overflow: hidden;
  border-radius: 1vw;
  background-color: var(--color6);
  border: 0.1vw var(--color6Alt3) solid;
  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  display: flex;
  align-items: flex-start;
  height: 15vw;
  margin-right: 1vw;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  flex: 1;
  width: 100%;
  position: relative;
  z-index: 1;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {
  padding: 1vw;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {
  line-height: 1;
  font-size: 2.2vw;
  white-space: nowrap;
  color: var(--color1);
  font-weight: var(--stronger);
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {
  font-size: 1.6vw;
  color: var(--color1Alt3);
  font-weight: var(--stdweight);
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  padding: 0.5vw 1vw 1vw;
  background-color: rgba(var(--color6-raw), 0.6);
  -webkit-backdrop-filter: blur(0.5vw);
  -moz-backdrop-filter: blur(0.5vw);
  -o-backdrop-filter: blur(0.5vw);
  -ms-backdrop-filter: blur(0.5vw);
  backdrop-filter: blur(0.5vw);
  border-radius: 1vw;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {
  font-size: 1.4vw;
  color: var(--color1);
  font-weight: var(--strong);
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {
  font-size: 1.2vw;
  color: var(--color1Alt2);
  font-weight: var(--strongest);
  font-style: italic;
  text-transform: lowercase;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%] {
  margin-top: 0.8vw;
  border-radius: 999px;
  position: relative;
  height: 1.4vw;
  background-color: var(--color2Alt2);
  overflow: hidden;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:before {
  content: "";
  display: block;
  position: absolute;
  border-radius: 999px;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  -moz-transform: translateX(-100%);
  -ms-transform: translateX(-100%);
  -o-transform: translateX(-100%);
  -webkit-transform: translateX(-100%);
  transform: translateX(-100%);
  -moz-animation-name: barLoader;
  -ms-animation-name: barLoader;
  -o-animation-name: barLoader;
  -webkit-animation-name: barLoader;
  animation-name: barLoader;
  -moz-animation-iteration-count: infinite;
  -ms-animation-iteration-count: infinite;
  -o-animation-iteration-count: infinite;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 3s;
  -ms-animation-duration: 3s;
  -o-animation-duration: 3s;
  -webkit-animation-duration: 3s;
  animation-duration: 3s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 0s;
  -ms-animation-delay: 0s;
  -o-animation-delay: 0s;
  -webkit-animation-delay: 0s;
  animation-delay: 0s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
  background-color: var(--color2Alt1);
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(2):before {
  -moz-animation-name: barLoader;
  -ms-animation-name: barLoader;
  -o-animation-name: barLoader;
  -webkit-animation-name: barLoader;
  animation-name: barLoader;
  -moz-animation-iteration-count: infinite;
  -ms-animation-iteration-count: infinite;
  -o-animation-iteration-count: infinite;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 3s;
  -ms-animation-duration: 3s;
  -o-animation-duration: 3s;
  -webkit-animation-duration: 3s;
  animation-duration: 3s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 0.5s;
  -ms-animation-delay: 0.5s;
  -o-animation-delay: 0.5s;
  -webkit-animation-delay: 0.5s;
  animation-delay: 0.5s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(3):before {
  -moz-animation-name: barLoader;
  -ms-animation-name: barLoader;
  -o-animation-name: barLoader;
  -webkit-animation-name: barLoader;
  animation-name: barLoader;
  -moz-animation-iteration-count: infinite;
  -ms-animation-iteration-count: infinite;
  -o-animation-iteration-count: infinite;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 3s;
  -ms-animation-duration: 3s;
  -o-animation-duration: 3s;
  -webkit-animation-duration: 3s;
  animation-duration: 3s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 1s;
  -ms-animation-delay: 1s;
  -o-animation-delay: 1s;
  -webkit-animation-delay: 1s;
  animation-delay: 1s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%] {
  width: 10vw;
  height: 100%;
  overflow: hidden;
  z-index: 0;
  pointer-events: none;
  mix-blend-mode: multiply;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {
  height: 100%;
  width: 100%;
  -webkit-object-fit: cover;
  -moz-object-fit: cover;
  -o-background-size: cover;
  object-fit: cover;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%] {
  width: 30%;
  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%] {
  width: 100%;
  height: 100%;
  border: 0.1vw var(--color1) solid;
  position: relative;
  border-radius: 1vw;
  overflow: hidden;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 0;
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100%25' height='100%25' viewBox='0 0 800 400'%3E%3Cdefs%3E%3CradialGradient id='a' cx='396' cy='281' r='514' gradientUnits='userSpaceOnUse'%3E%3Cstop offset='0' stop-color='%23D18'/%3E%3Cstop offset='1' stop-color='%23330000'/%3E%3C/radialGradient%3E%3ClinearGradient id='b' gradientUnits='userSpaceOnUse' x1='400' y1='148' x2='400' y2='333'%3E%3Cstop offset='0' stop-color='%23FA3' stop-opacity='0'/%3E%3Cstop offset='1' stop-color='%23FA3' stop-opacity='0.5'/%3E%3C/linearGradient%3E%3C/defs%3E%3Crect fill='url(%23a)' width='800' height='400'/%3E%3Cg fill-opacity='0.4'%3E%3Ccircle fill='url(%23b)' cx='267.5' cy='61' r='300'/%3E%3Ccircle fill='url(%23b)' cx='532.5' cy='61' r='300'/%3E%3Ccircle fill='url(%23b)' cx='400' cy='30' r='300'/%3E%3C/g%3E%3C/svg%3E");
  background-size: cover;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  width: 100%;
  padding: 1vw 2vw;
  z-index: 1;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {
  font-size: 1.4vw;
  text-transform: uppercase;
  color: var(--color2);
  font-weight: var(--strong);
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {
  font-size: 2.2vw;
  color: var(--color2);
  line-height: 1;
  font-weight: var(--stronger);
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {
  color: var(--color2Alt2);
  font-size: 1.6vw;
}
#rcView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .tile[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {
  display: block;
  font-size: 7vw;
  color: var(--color2);
  font-weight: var(--strongest);
  line-height: 1;
  -moz-animation-name: closeLoadIn;
  -ms-animation-name: closeLoadIn;
  -o-animation-name: closeLoadIn;
  -webkit-animation-name: _ngcontent-%COMP%_closeLoadIn;
  animation-name: _ngcontent-%COMP%_closeLoadIn;
  -moz-animation-iteration-count: 1;
  -ms-animation-iteration-count: 1;
  -o-animation-iteration-count: 1;
  -webkit-animation-iteration-count: 1;
  animation-iteration-count: 1;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 2s;
  -ms-animation-duration: 2s;
  -o-animation-duration: 2s;
  -webkit-animation-duration: 2s;
  animation-duration: 2s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 0s;
  -ms-animation-delay: 0s;
  -o-animation-delay: 0s;
  -webkit-animation-delay: 0s;
  animation-delay: 0s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%] {
  flex: 1;
  margin-top: 1vw;
  position: relative;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {
  height: 100%;
  position: relative;
  border-radius: 1vw;
  background-color: var(--color2);
  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  margin-left: 1vw;
  overflow-x: hidden;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {
  margin-left: 0;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tasks[_ngcontent-%COMP%] {
  width: calc(40% - 0.5vw);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%] {
  height: 100%;
  width: calc(60% - 0.5vw);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {
  z-index: 1;
  padding: 1vw;
  background-color: var(--color2);
  border-bottom: 0.1vw var(--color2Alt2) solid;
  position: sticky;
  top: 0;
  z-index: 1;
  display: flex;
  align-items: center;
  justify-content: space-between;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {
  font-size: 1.6vw;
  color: var(--color1);
  font-weight: var(--strong);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {
  margin-left: 1vw;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%] {
  display: flex;
  align-items: center;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  cursor: pointer;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {
  font-size: 1.6vw;
  color: var(--color3);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {
  margin-top: 0.25vw;
  text-transform: uppercase;
  font-size: 0.7vw;
  color: var(--color3);
  font-weight: var(--stronger);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  padding-top: 2vw;
  position: relative;
  z-index: 0;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {
  margin: 0 auto;
  display: block;
  width: 10vw;
  height: 10vw;
  --fillSpeed: 1s;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .opportunities[_ngcontent-%COMP%] {
  height: 100%;
  width: 100%;
  overflow-x: hidden;
  padding: 0 1vw 1vw;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .opportunities[_ngcontent-%COMP%]    > opportunity-summary[_ngcontent-%COMP%] {
  display: block;
  width: 100%;
  margin-top: 1vw;
  border-radius: 0.5vw;
  overflow: hidden;
  border: 0.1vw var(--color2Alt2) solid;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .opportunities[_ngcontent-%COMP%]    > opportunity-summary[_ngcontent-%COMP%]:first-child {
  margin-top: 0;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {
  margin: 5vw auto 0;
  width: 60%;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {
  font-size: 2vw;
  color: var(--color1Alt2);
  font-weight: var(--ltweight);
  text-align: center;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%] {
  margin-top: 1vw;
  display: flex;
  justify-content: center;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {
  cursor: pointer;
  display: block;
  text-align: center;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {
  font-size: 2vw;
  color: var(--color3);
  font-weight: var(--ltweight);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%] {
  position: relative;
  overflow: hidden;
  height: 100%;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 1vw;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {
  font-size: 1.6vw;
  color: var(--color1);
  font-weight: var(--strong);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {
  cursor: pointer;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {
  font-size: 1.8vw;
  color: var(--color1);
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {
  position: relative;
  height: 100%;
  flex: 1;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%] {
  border-radius: 0.5vw;
  overflow: hidden;
  opacity: 0;
  -moz-transition: opacity 0.2s linear;
  -o-transition: opacity 0.2s linear;
  -webkit-transition: opacity 0.2s linear;
  transition: opacity 0.2s linear;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%]   #routeMap[_ngcontent-%COMP%] {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap.active[_ngcontent-%COMP%] {
  opacity: 1;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {
  position: absolute;
  left: 50%;
  -moz-transform: translate3d(-50%, 0, 0);
  -ms-transform: translate3d(-50%, 0, 0);
  -o-transform: translate3d(-50%, 0, 0);
  -webkit-transform: translate3d(-50%, 0, 0);
  transform: translate3d(-50%, 0, 0);
  top: 2vw;
  z-index: 1;
  display: flex;
  flex-direction: column;
  align-items: center;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {
  display: block;
  height: 8vw;
  width: 8vw;
  -webkit-filter: saturate(0);
  -moz-filter: saturate(0);
  -o-filter: saturate(0);
  -ms-filter: saturate(0);
  filter: saturate(0);
  opacity: 0.6;
}
#rcView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {
  margin-top: 1vw;
  font-size: 1.6vw;
  white-space: nowrap;
  color: var(--color1Alt1);
  font-weight: var(--ltweight);
}
/*# sourceMappingURL=rc.component.css.map */`] });
var RcComponent = _RcComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(RcComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "rc-view", providers: [OrderByPipe], template: `<section id="rcView">
  <div class="primary">
    <div class="content">
      <div class="summary card">
        @if (profileImage != null) {
          <div class="profile">
            <img [src]="profileImage" />
          </div>
        }
        <div class="content">
          <header>
            <h2>Your daily summary for {{today | date:'EEEE, MMMM d'}}</h2>
            <h3>Welcome back, {{firstName}}</h3>
          </header>
          <div class="content">
            @if (!retrievingSummary) {
              <p>
                {{summaryText}}
              </p>
            }
            @if (retrievingSummary) {
              <div class="loader">
                <p>{{summaryLoaderLabel}}</p>
                <div class="bar"></div>
                <div class="bar"></div>
              </div>
            }
          </div>
        </div>
      </div>
      <div class="closing">
        <div class="tile">
          <div class="bg"></div>
          <div class="content">
            <label>Current Week</label>
            <h3>Gross Close Percentage</h3>
            <p>Your appointment sell-through rate.</p>
            @if (showClosePercentage) {
              <span class="value">
                {{closePercentage | async}}%
              </span>
            }
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="focus">
    <div class="content">
      <div class="column tasks">
        <reminders
          [activeUser]="user"
          (retrieved)="finalizeReminders($event)">
        </reminders>
      </div>
      <div class="column opportunities">
        <header>
          <div class="primary">
            <h2>
              Today's Appointments
            </h2>
          </div>
          <div class="secondary">
            <div class="icon-controls">
              <button class="control" (click)="promptToRefreshOpportunities()">
                <i class="fa-solid fa-arrows-rotate"></i>
              </button>
            </div>
          </div>
        </header>
        <div class="content">
          @if (showOpportunitiesLoader) {
            <loader [fill]="true"></loader>
          }

          @if (showOpportunities) {
            <div class="opportunities">
              @for (opportunity of todaysOpportunities; track opportunity) {
                <opportunity-summary [opportunity]="opportunity">
                </opportunity-summary>
              }
            </div>
          }
          @if (showMissingOpportunitiesMessage) {
            <div class="message">
              <p>
                You currently have no appointments scheduled for today.
              </p>
              <div class="controls">
                <button class="control" (click)="goToBookOfBusiness()">
                  <label>
                    Go to Book of Business
                  </label>
                </button>
              </div>
            </div>
          }
        </div>
      </div>
    </div>
  </div>
</section>`, styles: [`/* src/app/dashboard/components/rc/rc.component.scss */
@-webkit-keyframes closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
@-moz-keyframes closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
@-o-keyframes closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
@keyframes closeLoadIn {
  0% {
    opacity: 0;
    -webkit-filter: blur(5vw);
    -moz-filter: blur(5vw);
    -o-filter: blur(5vw);
    -ms-filter: blur(5vw);
    filter: blur(5vw);
  }
  100% {
    opacity: 1;
    -webkit-filter: blur(0);
    -moz-filter: blur(0);
    -o-filter: blur(0);
    -ms-filter: blur(0);
    filter: blur(0);
  }
}
#rcView {
  position: absolute;
  top: calc(6vw + var(--systemOffset-top));
  left: 2vw;
  right: 2vw;
  bottom: 2vw;
  display: flex;
  flex-direction: column;
}
#rcView > .primary > .content {
  display: flex;
}
#rcView > .primary > .content > .summary {
  width: 70%;
  border-radius: 1vw;
  position: relative;
  overflow: hidden;
  border-radius: 1vw;
  background-color: var(--color6);
  border: 0.1vw var(--color6Alt3) solid;
  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  display: flex;
  align-items: flex-start;
  height: 15vw;
  margin-right: 1vw;
}
#rcView > .primary > .content > .summary > .content {
  flex: 1;
  width: 100%;
  position: relative;
  z-index: 1;
}
#rcView > .primary > .content > .summary > .content > header {
  padding: 1vw;
}
#rcView > .primary > .content > .summary > .content > header h2 {
  line-height: 1;
  font-size: 2.2vw;
  white-space: nowrap;
  color: var(--color1);
  font-weight: var(--stronger);
}
#rcView > .primary > .content > .summary > .content > header h3 {
  font-size: 1.6vw;
  color: var(--color1Alt3);
  font-weight: var(--stdweight);
}
#rcView > .primary > .content > .summary > .content > .content {
  padding: 0.5vw 1vw 1vw;
  background-color: rgba(var(--color6-raw), 0.6);
  -webkit-backdrop-filter: blur(0.5vw);
  -moz-backdrop-filter: blur(0.5vw);
  -o-backdrop-filter: blur(0.5vw);
  -ms-backdrop-filter: blur(0.5vw);
  backdrop-filter: blur(0.5vw);
  border-radius: 1vw;
}
#rcView > .primary > .content > .summary > .content > .content > p {
  font-size: 1.4vw;
  color: var(--color1);
  font-weight: var(--strong);
}
#rcView > .primary > .content > .summary > .content > .content > .loader > p {
  font-size: 1.2vw;
  color: var(--color1Alt2);
  font-weight: var(--strongest);
  font-style: italic;
  text-transform: lowercase;
}
#rcView > .primary > .content > .summary > .content > .content > .loader > .bar {
  margin-top: 0.8vw;
  border-radius: 999px;
  position: relative;
  height: 1.4vw;
  background-color: var(--color2Alt2);
  overflow: hidden;
}
#rcView > .primary > .content > .summary > .content > .content > .loader > .bar:before {
  content: "";
  display: block;
  position: absolute;
  border-radius: 999px;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  -moz-transform: translateX(-100%);
  -ms-transform: translateX(-100%);
  -o-transform: translateX(-100%);
  -webkit-transform: translateX(-100%);
  transform: translateX(-100%);
  -moz-animation-name: barLoader;
  -ms-animation-name: barLoader;
  -o-animation-name: barLoader;
  -webkit-animation-name: barLoader;
  animation-name: barLoader;
  -moz-animation-iteration-count: infinite;
  -ms-animation-iteration-count: infinite;
  -o-animation-iteration-count: infinite;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 3s;
  -ms-animation-duration: 3s;
  -o-animation-duration: 3s;
  -webkit-animation-duration: 3s;
  animation-duration: 3s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 0s;
  -ms-animation-delay: 0s;
  -o-animation-delay: 0s;
  -webkit-animation-delay: 0s;
  animation-delay: 0s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
  background-color: var(--color2Alt1);
}
#rcView > .primary > .content > .summary > .content > .content > .loader > .bar:nth-of-type(2):before {
  -moz-animation-name: barLoader;
  -ms-animation-name: barLoader;
  -o-animation-name: barLoader;
  -webkit-animation-name: barLoader;
  animation-name: barLoader;
  -moz-animation-iteration-count: infinite;
  -ms-animation-iteration-count: infinite;
  -o-animation-iteration-count: infinite;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 3s;
  -ms-animation-duration: 3s;
  -o-animation-duration: 3s;
  -webkit-animation-duration: 3s;
  animation-duration: 3s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 0.5s;
  -ms-animation-delay: 0.5s;
  -o-animation-delay: 0.5s;
  -webkit-animation-delay: 0.5s;
  animation-delay: 0.5s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
}
#rcView > .primary > .content > .summary > .content > .content > .loader > .bar:nth-of-type(3):before {
  -moz-animation-name: barLoader;
  -ms-animation-name: barLoader;
  -o-animation-name: barLoader;
  -webkit-animation-name: barLoader;
  animation-name: barLoader;
  -moz-animation-iteration-count: infinite;
  -ms-animation-iteration-count: infinite;
  -o-animation-iteration-count: infinite;
  -webkit-animation-iteration-count: infinite;
  animation-iteration-count: infinite;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 3s;
  -ms-animation-duration: 3s;
  -o-animation-duration: 3s;
  -webkit-animation-duration: 3s;
  animation-duration: 3s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 1s;
  -ms-animation-delay: 1s;
  -o-animation-delay: 1s;
  -webkit-animation-delay: 1s;
  animation-delay: 1s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
}
#rcView > .primary > .content > .summary > .profile {
  width: 10vw;
  height: 100%;
  overflow: hidden;
  z-index: 0;
  pointer-events: none;
  mix-blend-mode: multiply;
}
#rcView > .primary > .content > .summary > .profile img {
  height: 100%;
  width: 100%;
  -webkit-object-fit: cover;
  -moz-object-fit: cover;
  -o-background-size: cover;
  object-fit: cover;
}
#rcView > .primary > .content > .closing {
  width: 30%;
  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
}
#rcView > .primary > .content > .closing > .tile {
  width: 100%;
  height: 100%;
  border: 0.1vw var(--color1) solid;
  position: relative;
  border-radius: 1vw;
  overflow: hidden;
}
#rcView > .primary > .content > .closing > .tile > .bg {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 0;
  background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100%25' height='100%25' viewBox='0 0 800 400'%3E%3Cdefs%3E%3CradialGradient id='a' cx='396' cy='281' r='514' gradientUnits='userSpaceOnUse'%3E%3Cstop offset='0' stop-color='%23D18'/%3E%3Cstop offset='1' stop-color='%23330000'/%3E%3C/radialGradient%3E%3ClinearGradient id='b' gradientUnits='userSpaceOnUse' x1='400' y1='148' x2='400' y2='333'%3E%3Cstop offset='0' stop-color='%23FA3' stop-opacity='0'/%3E%3Cstop offset='1' stop-color='%23FA3' stop-opacity='0.5'/%3E%3C/linearGradient%3E%3C/defs%3E%3Crect fill='url(%23a)' width='800' height='400'/%3E%3Cg fill-opacity='0.4'%3E%3Ccircle fill='url(%23b)' cx='267.5' cy='61' r='300'/%3E%3Ccircle fill='url(%23b)' cx='532.5' cy='61' r='300'/%3E%3Ccircle fill='url(%23b)' cx='400' cy='30' r='300'/%3E%3C/g%3E%3C/svg%3E");
  background-size: cover;
}
#rcView > .primary > .content > .closing > .tile > .content {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  width: 100%;
  padding: 1vw 2vw;
  z-index: 1;
}
#rcView > .primary > .content > .closing > .tile > .content label {
  font-size: 1.4vw;
  text-transform: uppercase;
  color: var(--color2);
  font-weight: var(--strong);
}
#rcView > .primary > .content > .closing > .tile > .content h3 {
  font-size: 2.2vw;
  color: var(--color2);
  line-height: 1;
  font-weight: var(--stronger);
}
#rcView > .primary > .content > .closing > .tile > .content p {
  color: var(--color2Alt2);
  font-size: 1.6vw;
}
#rcView > .primary > .content > .closing > .tile > .content > .value {
  display: block;
  font-size: 7vw;
  color: var(--color2);
  font-weight: var(--strongest);
  line-height: 1;
  -moz-animation-name: closeLoadIn;
  -ms-animation-name: closeLoadIn;
  -o-animation-name: closeLoadIn;
  -webkit-animation-name: closeLoadIn;
  animation-name: closeLoadIn;
  -moz-animation-iteration-count: 1;
  -ms-animation-iteration-count: 1;
  -o-animation-iteration-count: 1;
  -webkit-animation-iteration-count: 1;
  animation-iteration-count: 1;
  -moz-animation-timing-function: linear;
  -ms-animation-timing-function: linear;
  -o-animation-timing-function: linear;
  -webkit-animation-timing-function: linear;
  animation-timing-function: linear;
  -moz-animation-duration: 2s;
  -ms-animation-duration: 2s;
  -o-animation-duration: 2s;
  -webkit-animation-duration: 2s;
  animation-duration: 2s;
  -moz-animation-direction: normal;
  -ms-animation-direction: normal;
  -o-animation-direction: normal;
  -webkit-animation-direction: normal;
  animation-direction: normal;
  -moz-animation-delay: 0s;
  -ms-animation-delay: 0s;
  -o-animation-delay: 0s;
  -webkit-animation-delay: 0s;
  animation-delay: 0s;
  -moz-animation-fill-mode: forwards;
  -ms-animation-fill-mode: forwards;
  -o-animation-fill-mode: forwards;
  -webkit-animation-fill-mode: forwards;
  animation-fill-mode: forwards;
}
#rcView > .focus {
  flex: 1;
  margin-top: 1vw;
  position: relative;
}
#rcView > .focus > .content {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
}
#rcView > .focus > .content > .column {
  height: 100%;
  position: relative;
  border-radius: 1vw;
  background-color: var(--color2);
  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));
  margin-left: 1vw;
  overflow-x: hidden;
}
#rcView > .focus > .content > .column:first-child {
  margin-left: 0;
}
#rcView > .focus > .content .tasks {
  width: calc(40% - 0.5vw);
}
#rcView > .focus > .content .opportunities {
  height: 100%;
  width: calc(60% - 0.5vw);
}
#rcView > .focus > .content .opportunities > header {
  z-index: 1;
  padding: 1vw;
  background-color: var(--color2);
  border-bottom: 0.1vw var(--color2Alt2) solid;
  position: sticky;
  top: 0;
  z-index: 1;
  display: flex;
  align-items: center;
  justify-content: space-between;
}
#rcView > .focus > .content .opportunities > header > .primary h2 {
  font-size: 1.6vw;
  color: var(--color1);
  font-weight: var(--strong);
}
#rcView > .focus > .content .opportunities > header > .secondary {
  margin-left: 1vw;
}
#rcView > .focus > .content .opportunities > header > .secondary > .icon-controls {
  display: flex;
  align-items: center;
}
#rcView > .focus > .content .opportunities > header > .secondary > .icon-controls > .control {
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  cursor: pointer;
}
#rcView > .focus > .content .opportunities > header > .secondary > .icon-controls > .control > i {
  font-size: 1.6vw;
  color: var(--color3);
}
#rcView > .focus > .content .opportunities > header > .secondary > .icon-controls > .control > label {
  margin-top: 0.25vw;
  text-transform: uppercase;
  font-size: 0.7vw;
  color: var(--color3);
  font-weight: var(--stronger);
}
#rcView > .focus > .content .opportunities > .content {
  padding-top: 2vw;
  position: relative;
  z-index: 0;
}
#rcView > .focus > .content .opportunities > .content > loader {
  margin: 0 auto;
  display: block;
  width: 10vw;
  height: 10vw;
  --fillSpeed: 1s;
}
#rcView > .focus > .content .opportunities > .content > .opportunities {
  height: 100%;
  width: 100%;
  overflow-x: hidden;
  padding: 0 1vw 1vw;
}
#rcView > .focus > .content .opportunities > .content > .opportunities > opportunity-summary {
  display: block;
  width: 100%;
  margin-top: 1vw;
  border-radius: 0.5vw;
  overflow: hidden;
  border: 0.1vw var(--color2Alt2) solid;
}
#rcView > .focus > .content .opportunities > .content > .opportunities > opportunity-summary:first-child {
  margin-top: 0;
}
#rcView > .focus > .content .opportunities > .content > .message {
  margin: 5vw auto 0;
  width: 60%;
}
#rcView > .focus > .content .opportunities > .content > .message p {
  font-size: 2vw;
  color: var(--color1Alt2);
  font-weight: var(--ltweight);
  text-align: center;
}
#rcView > .focus > .content .opportunities > .content > .message .controls {
  margin-top: 1vw;
  display: flex;
  justify-content: center;
}
#rcView > .focus > .content .opportunities > .content > .message .controls > .control {
  cursor: pointer;
  display: block;
  text-align: center;
}
#rcView > .focus > .content .opportunities > .content > .message .controls > .control > label {
  font-size: 2vw;
  color: var(--color3);
  font-weight: var(--ltweight);
}
#rcView > .focus > .content .map {
  position: relative;
  overflow: hidden;
  height: 100%;
}
#rcView > .focus > .content .map > header {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 1vw;
}
#rcView > .focus > .content .map > header > .primary h2 {
  font-size: 1.6vw;
  color: var(--color1);
  font-weight: var(--strong);
}
#rcView > .focus > .content .map > header > .controls > .control {
  cursor: pointer;
}
#rcView > .focus > .content .map > header > .controls > .control > i {
  font-size: 1.8vw;
  color: var(--color1);
}
#rcView > .focus > .content .map > .content {
  position: relative;
  height: 100%;
  flex: 1;
}
#rcView > .focus > .content .map > .content > .map-wrap {
  border-radius: 0.5vw;
  overflow: hidden;
  opacity: 0;
  -moz-transition: opacity 0.2s linear;
  -o-transition: opacity 0.2s linear;
  -webkit-transition: opacity 0.2s linear;
  transition: opacity 0.2s linear;
}
#rcView > .focus > .content .map > .content > .map-wrap #routeMap {
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
}
#rcView > .focus > .content .map > .content > .map-wrap.active {
  opacity: 1;
}
#rcView > .focus > .content .map > .content > .loader {
  position: absolute;
  left: 50%;
  -moz-transform: translate3d(-50%, 0, 0);
  -ms-transform: translate3d(-50%, 0, 0);
  -o-transform: translate3d(-50%, 0, 0);
  -webkit-transform: translate3d(-50%, 0, 0);
  transform: translate3d(-50%, 0, 0);
  top: 2vw;
  z-index: 1;
  display: flex;
  flex-direction: column;
  align-items: center;
}
#rcView > .focus > .content .map > .content > .loader > loader {
  display: block;
  height: 8vw;
  width: 8vw;
  -webkit-filter: saturate(0);
  -moz-filter: saturate(0);
  -o-filter: saturate(0);
  -ms-filter: saturate(0);
  filter: saturate(0);
  opacity: 0.6;
}
#rcView > .focus > .content .map > .content > .loader > p {
  margin-top: 1vw;
  font-size: 1.6vw;
  white-space: nowrap;
  color: var(--color1Alt1);
  font-weight: var(--ltweight);
}
/*# sourceMappingURL=rc.component.css.map */
`] }]
  }], () => [{ type: HttpClient }, { type: DashboardService }, { type: AiService }, { type: UiService }, { type: DeviceRouteService }, { type: AuthRefService }, { type: OrderByPipe }, { type: OpportunityService }, { type: StorageService }, { type: LogService }, { type: ApiService }], { userId: [{
    type: Input,
    args: ["userId"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], params: [{
    type: Input,
    args: ["params"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(RcComponent, { className: "RcComponent" });
})();

// src/app/dashboard/components/rgm/rgm.component.ts
function RgmComponent_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 4);
    \u0275\u0275element(1, "img", 19);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r0.profileImage, \u0275\u0275sanitizeUrl);
  }
}
function RgmComponent_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.summaryText, " ");
  }
}
function RgmComponent_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 5)(1, "p");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275element(3, "div", 20)(4, "div", 20);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r0.summaryLoaderLabel);
  }
}
function RgmComponent_For_24_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 24);
    \u0275\u0275element(1, "img", 19);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const member_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("src", member_r3.profileImage_B64, \u0275\u0275sanitizeUrl);
  }
}
function RgmComponent_For_24_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 25);
    \u0275\u0275element(1, "i", 30);
    \u0275\u0275elementEnd();
  }
}
function RgmComponent_For_24_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 28)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const member_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", member_r3.emailAddress, " ");
  }
}
function RgmComponent_For_24_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 28)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "phone");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const member_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 1, member_r3.phone), " ");
  }
}
function RgmComponent_For_24_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 29)(1, "label");
    \u0275\u0275text(2, "Current Week Close Percentage");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 31);
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const member_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("", member_r3.closePercentage, "%");
  }
}
function RgmComponent_For_24_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 21);
    \u0275\u0275listener("click", function RgmComponent_For_24_Template_div_click_0_listener() {
      const member_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.setActiveMember(member_r3));
    });
    \u0275\u0275elementStart(1, "div", 22);
    \u0275\u0275element(2, "canvas", 23);
    \u0275\u0275conditionalCreate(3, RgmComponent_For_24_Conditional_3_Template, 2, 1, "div", 24);
    \u0275\u0275conditionalCreate(4, RgmComponent_For_24_Conditional_4_Template, 2, 0, "div", 25);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 26)(6, "div", 27)(7, "h3");
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(9, RgmComponent_For_24_Conditional_9_Template, 3, 1, "div", 28);
    \u0275\u0275conditionalCreate(10, RgmComponent_For_24_Conditional_10_Template, 4, 3, "div", 28);
    \u0275\u0275conditionalCreate(11, RgmComponent_For_24_Conditional_11_Template, 5, 1, "div", 29);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const member_r3 = ctx.$implicit;
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classProp("active", (ctx_r0.activeMember == null ? null : ctx_r0.activeMember.id) == member_r3.id);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(member_r3.profileImage_B64 != null ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(member_r3.profileImage_B64 == null ? 4 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(member_r3.fullName);
    \u0275\u0275advance();
    \u0275\u0275conditional(member_r3.emailAddress != null ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(member_r3.phone != null ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(member_r3.closePercentage != null ? 11 : -1);
  }
}
function RgmComponent_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 9)(1, "p");
    \u0275\u0275text(2, " No team members. ");
    \u0275\u0275elementEnd()();
  }
}
function RgmComponent_For_43_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 17);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const option_r4 = ctx.$implicit;
    \u0275\u0275property("ngValue", option_r4.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", option_r4.name);
  }
}
function RgmComponent_Conditional_44_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 18);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", true);
  }
}
function RgmComponent_Conditional_45_For_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "opportunity-summary", 33);
  }
  if (rf & 2) {
    const opportunity_r5 = ctx.$implicit;
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("opportunity", opportunity_r5)("manager", ctx_r0.user)("management", true);
  }
}
function RgmComponent_Conditional_45_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 32);
    \u0275\u0275repeaterCreate(1, RgmComponent_Conditional_45_For_2_Template, 1, 3, "opportunity-summary", 33, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 34)(4, "p");
    \u0275\u0275text(5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "p");
    \u0275\u0275text(7, "Use the search if you're looking for a specific appointment.");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r0.visibleOpportunities);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("Showing ", ctx_r0.visibleOpportunities.length, " of the most recent appointments.");
  }
}
function RgmComponent_Conditional_46_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 9)(1, "p");
    \u0275\u0275text(2, " No matching appointments found. ");
    \u0275\u0275elementEnd()();
  }
}
Chart.register(CategoryScale, index, plugin_tooltip, LinearScale, LineController, LineElement, PointElement, plugin_title);
var _RgmComponent = class _RgmComponent {
  constructor(http, dashboardService, aiService, deviceRouteService, authRefService, orderByPipe, opportunityService, apiService) {
    this.http = http;
    this.dashboardService = dashboardService;
    this.aiService = aiService;
    this.deviceRouteService = deviceRouteService;
    this.authRefService = authRefService;
    this.orderByPipe = orderByPipe;
    this.opportunityService = opportunityService;
    this.apiService = apiService;
    this.user = null;
    this.retrievingSummary = false;
    this.summaryLoaderLabel = "Your AI summary for today...";
    this.summaryText = "generating ai summmary...";
    this.online = false;
    this.OpportunityStatus = OpportunityStatus;
    this.retrievingOpportunities = false;
    this.visibleOpportunities = [];
    this.syncingOpportunities = false;
    this.sortOptions = [];
    this.statusOptions = [];
    this.searchInput = "";
    this.userId = new BehaviorSubject(void 0);
    this.params = new BehaviorSubject([]);
    this.today = /* @__PURE__ */ new Date();
  }
  get firstName() {
    return this.user?.firstName ?? "";
  }
  get profileImage() {
    return this.user?.profileImage_B64;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.user = user;
        this.initTeam();
      }
    });
  }
  get teamMembers() {
    return this.user?.teamMembers ?? [];
  }
  get hasTeamMembers() {
    return this.teamMembers.length > 0;
  }
  setActiveMember(member) {
    this.activeMember = member;
    this.visibleOpportunities = [];
    if (this.online) {
      this.syncOpportunities();
    } else {
      this.getOpportunities();
    }
  }
  initTeam() {
    if (this.teamMembers.length > 0) {
      this.setActiveMember(this.teamMembers[0]);
    }
  }
  calcClosePercentages() {
    this.teamMembers.forEach((member) => {
      this.dashboardService.calcClosePercentage(member).then((percentage) => {
        member.closePercentage = percentage;
      });
    });
  }
  initSummaryText() {
    this.summaryText = this.aiService.generateManagerSummary(this.teamMembers, this.visibleOpportunities, this.activeMember);
  }
  watchOnline() {
    this.onlineSubscription = this.apiService.online.subscribe({
      next: (online) => {
        this.online = online;
      }
    });
  }
  get hasVisibleOpportunities() {
    return this.visibleOpportunities.length > 0;
  }
  get loadingUpcomingOpportunity() {
    return this.retrievingOpportunities;
  }
  get showOpportunitiesLoader() {
    return this.syncingOpportunities;
  }
  get showVisibleOpportunities() {
    return this.hasVisibleOpportunities && !this.syncingOpportunities;
  }
  get showMissingOpportunitiesMessage() {
    return !this.hasVisibleOpportunities && !this.syncingOpportunities;
  }
  syncOpportunities() {
    if (this.activeMember != null) {
      this.syncingSubscription?.unsubscribe();
      this.syncingOpportunities = true;
      this.initSummaryText();
      this.syncingSubscription = this.opportunityService.syncOpportunitiesForUser(this.activeMember.id).subscribe({
        next: (opportunities) => {
          setTimeout(() => {
            this.getOpportunities();
          }, 500);
        },
        error: () => {
          this.syncingOpportunities = false;
        }
      });
    }
  }
  getOpportunities() {
    if (this.activeMember != null) {
      this.gettingSubscription?.unsubscribe();
      this.syncingOpportunities = true;
      this.initSummaryText();
      if (this.activeStatus != null) {
        this.gettingSubscription = this.opportunityService.getOpportunitiesByStatus(this.activeStatus, this.activeMember.id).subscribe({
          next: (opportunities) => {
            this.updateOpportunities(opportunities);
            this.initSummaryText();
            setTimeout(() => {
              this.syncingOpportunities = false;
            }, 1e3);
          }
        });
      } else {
        this.gettingSubscription = this.opportunityService.getOpportunitiesForUser(this.activeMember.id).subscribe({
          next: (opportunities) => {
            this.updateOpportunities(opportunities);
            this.initSummaryText();
            setTimeout(() => {
              this.syncingOpportunities = false;
            }, 1e3);
          }
        });
      }
    }
  }
  updateOpportunities(opportunities) {
    this.visibleOpportunities = this.orderByPipe.transform(opportunities, "scheduled_Utc", true);
  }
  goToOpportunities() {
    this.deviceRouteService.viewRouteByType("Opportunities", ["all"], true);
  }
  initOpportunities(user) {
    if (user != null) {
      this.initSortOptions();
      this.syncOpportunities();
      this.initSummaryText();
    }
  }
  sortOpportunities(property, descending = false) {
    this.visibleOpportunities = this.orderByPipe.transform(this.visibleOpportunities, property, descending);
  }
  initSortOptions() {
    const sortOptions = [];
    const statusOptions = [];
    sortOptions.push(new SortOption("scheduled_Utc", "Scheduled"));
    sortOptions.push(new SortOption("lastUpdated_Utc", "Last Updated"));
    this.activeSort = sortOptions[0].id;
    statusOptions.push(new SortOption(void 0, "All"));
    statusOptions.push(new SortOption(OpportunityStatus.Open, "Open"));
    statusOptions.push(new SortOption(OpportunityStatus.Dispositioned, "Dispositioned"));
    statusOptions.push(new SortOption(OpportunityStatus.InProgress, "In Progress"));
    this.activeStatus = void 0;
    this.sortOptions = sortOptions;
    this.statusOptions = statusOptions;
  }
  searchOpportunities() {
    window.clearTimeout(this.searchDebounce);
    this.searchDebounce = window.setTimeout(() => {
      if (this.searchInput.length > 0) {
        if (this.activeMember != null) {
          this.opportunityService.searchOpportunities(this.searchInput, this.activeMember.id, this.activeStatus).subscribe({
            next: (opportunities) => {
              this.updateOpportunities(opportunities);
            }
          });
        }
      } else {
        this.getOpportunities();
      }
    }, 500);
  }
  filterOpportunities() {
    if (this.activeMember != null) {
      this.getOpportunities();
    }
  }
  get showLoader() {
    return this.retrievingOpportunities;
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        let route = params[0]?.toLowerCase();
        if (route != null) {
        }
      }
    });
  }
  init() {
    this.watchOnline();
    this.watchParams();
    this.watchUser();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
    this.paramsSubscription?.unsubscribe();
    this.onlineSubscription?.unsubscribe();
  }
};
_RgmComponent.\u0275fac = function RgmComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _RgmComponent)(\u0275\u0275directiveInject(HttpClient), \u0275\u0275directiveInject(DashboardService), \u0275\u0275directiveInject(AiService), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(ApiService));
};
_RgmComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _RgmComponent, selectors: [["rgm-view"]], inputs: { userId: "userId", route: "route", params: "params" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 47, vars: 15, consts: [["id", "rgmView"], [1, "primary"], [1, "content"], [1, "summary", "card"], [1, "profile"], [1, "loader"], [1, "focus"], [1, "column", "team"], [1, "member", 3, "active"], [1, "message"], [1, "column", "opportunities"], [1, "search"], [1, "input"], ["type", "text", "placeholder", "Search appointments...", 3, "ngModelChange", "input", "ngModel"], [1, "sorting"], [1, "control"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [3, "fill"], [3, "src"], [1, "bar"], [1, "member", 3, "click"], [1, "avatar"], ["width", "3", "height", "4"], [1, "image"], [1, "placeholder"], [1, "meta"], [1, "name"], [1, "contact"], [1, "closing"], [1, "fa-solid", "fa-user"], [1, "value"], [1, "opportunities"], [3, "opportunity", "manager", "management"], [1, "message", "subtle"]], template: function RgmComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1)(2, "div", 2)(3, "div", 3);
    \u0275\u0275conditionalCreate(4, RgmComponent_Conditional_4_Template, 2, 1, "div", 4);
    \u0275\u0275elementStart(5, "div", 2)(6, "header")(7, "h2");
    \u0275\u0275text(8);
    \u0275\u0275pipe(9, "date");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "h3");
    \u0275\u0275text(11);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(12, "div", 2);
    \u0275\u0275conditionalCreate(13, RgmComponent_Conditional_13_Template, 2, 1, "p");
    \u0275\u0275conditionalCreate(14, RgmComponent_Conditional_14_Template, 5, 1, "div", 5);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(15, "div", 6)(16, "div", 2)(17, "div", 7)(18, "header")(19, "div", 1)(20, "h2");
    \u0275\u0275text(21, " Your Team ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(22, "div", 2);
    \u0275\u0275repeaterCreate(23, RgmComponent_For_24_Template, 12, 8, "div", 8, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275conditionalCreate(25, RgmComponent_Conditional_25_Template, 3, 0, "div", 9);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(26, "div", 10)(27, "header")(28, "div", 1)(29, "h2");
    \u0275\u0275text(30);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(31, "div", 2)(32, "header")(33, "div", 11)(34, "div", 12)(35, "input", 13);
    \u0275\u0275twoWayListener("ngModelChange", function RgmComponent_Template_input_ngModelChange_35_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.searchInput, $event) || (ctx.searchInput = $event);
      return $event;
    });
    \u0275\u0275listener("input", function RgmComponent_Template_input_input_35_listener() {
      return ctx.searchOpportunities();
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(36, "div", 14)(37, "div", 15)(38, "label");
    \u0275\u0275text(39, "Status");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(40, "div", 12)(41, "select", 16);
    \u0275\u0275twoWayListener("ngModelChange", function RgmComponent_Template_select_ngModelChange_41_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.activeStatus, $event) || (ctx.activeStatus = $event);
      return $event;
    });
    \u0275\u0275listener("change", function RgmComponent_Template_select_change_41_listener() {
      return ctx.filterOpportunities();
    });
    \u0275\u0275repeaterCreate(42, RgmComponent_For_43_Template, 2, 2, "option", 17, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275conditionalCreate(44, RgmComponent_Conditional_44_Template, 1, 1, "loader", 18);
    \u0275\u0275conditionalCreate(45, RgmComponent_Conditional_45_Template, 8, 1);
    \u0275\u0275conditionalCreate(46, RgmComponent_Conditional_46_Template, 3, 0, "div", 9);
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx.profileImage != null ? 4 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("Your team summary for ", \u0275\u0275pipeBind2(9, 12, ctx.today, "EEEE, MMMM d"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("Welcome back, ", ctx.firstName);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.retrievingSummary ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.retrievingSummary ? 14 : -1);
    \u0275\u0275advance(9);
    \u0275\u0275repeater(ctx.teamMembers);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.hasTeamMembers ? 25 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", ctx.activeMember == null ? null : ctx.activeMember.fullName, "'s Appointments ");
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.searchInput);
    \u0275\u0275advance(6);
    \u0275\u0275twoWayProperty("ngModel", ctx.activeStatus);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.statusOptions);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.showOpportunitiesLoader ? 44 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showVisibleOpportunities ? 45 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showMissingOpportunitiesMessage ? 46 : -1);
  }
}, dependencies: [LoaderComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, OpportunitySummaryComponent, NgModel, DatePipe, PhoneFormatPipe], styles: ['\n\n@-webkit-keyframes _ngcontent-%COMP%_closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-moz-keyframes closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-o-keyframes closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n#rgmView[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 2vw;\n  right: 2vw;\n  bottom: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%] {\n  border-radius: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n  background-color: var(--color6);\n  border: 0.1vw var(--color6Alt3) solid;\n  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  display: flex;\n  align-items: flex-start;\n  height: 15vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n  position: relative;\n  z-index: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 2.2vw;\n  white-space: nowrap;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw 1vw;\n  background-color: rgba(var(--color6-raw), 0.6);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  border-radius: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strongest);\n  font-style: italic;\n  text-transform: lowercase;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%] {\n  margin-top: 0.8vw;\n  border-radius: 999px;\n  position: relative;\n  height: 1.4vw;\n  background-color: var(--color2Alt2);\n  overflow: hidden;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:before {\n  content: "";\n  display: block;\n  position: absolute;\n  border-radius: 999px;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  -moz-transform: translateX(-100%);\n  -ms-transform: translateX(-100%);\n  -o-transform: translateX(-100%);\n  -webkit-transform: translateX(-100%);\n  transform: translateX(-100%);\n  -moz-animation-name: barLoader;\n  -ms-animation-name: barLoader;\n  -o-animation-name: barLoader;\n  -webkit-animation-name: barLoader;\n  animation-name: barLoader;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 3s;\n  -ms-animation-duration: 3s;\n  -o-animation-duration: 3s;\n  -webkit-animation-duration: 3s;\n  animation-duration: 3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  background-color: var(--color2Alt1);\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(2):before {\n  -moz-animation-name: barLoader;\n  -ms-animation-name: barLoader;\n  -o-animation-name: barLoader;\n  -webkit-animation-name: barLoader;\n  animation-name: barLoader;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 3s;\n  -ms-animation-duration: 3s;\n  -o-animation-duration: 3s;\n  -webkit-animation-duration: 3s;\n  animation-duration: 3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.5s;\n  -ms-animation-delay: 0.5s;\n  -o-animation-delay: 0.5s;\n  -webkit-animation-delay: 0.5s;\n  animation-delay: 0.5s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-of-type(3):before {\n  -moz-animation-name: barLoader;\n  -ms-animation-name: barLoader;\n  -o-animation-name: barLoader;\n  -webkit-animation-name: barLoader;\n  animation-name: barLoader;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 3s;\n  -ms-animation-duration: 3s;\n  -o-animation-duration: 3s;\n  -webkit-animation-duration: 3s;\n  animation-duration: 3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 1s;\n  -ms-animation-delay: 1s;\n  -o-animation-delay: 1s;\n  -webkit-animation-delay: 1s;\n  animation-delay: 1s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%] {\n  width: 10vw;\n  height: 100%;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  mix-blend-mode: multiply;\n}\n#rgmView[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .summary[_ngcontent-%COMP%]    > .profile[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%] {\n  flex: 1;\n  margin-top: 1vw;\n  position: relative;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  height: 100%;\n  position: relative;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  margin-left: 1vw;\n  overflow-x: hidden;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  z-index: 1;\n  padding: 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  position: relative;\n  max-height: 100%;\n  z-index: 0;\n  overflow-x: hidden;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n  text-align: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]:not(.subtle) {\n  width: 50%;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message.subtle[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message.subtle[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  position: relative;\n  top: initial;\n  font-size: 1.6vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%] {\n  width: calc(40% - 0.5vw);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 1vw 1vw 6vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  cursor: pointer;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s, background-color 0.2s;\n  -o-transition: border-color 0.2s, background-color 0.2s;\n  -webkit-transition: border-color 0.2s, background-color 0.2s;\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%] {\n  height: 15vw;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  position: relative;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  height: 100%;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  mix-blend-mode: multiply;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]    > img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .placeholder[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color3Alt4-raw), 0.2);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .avatar[_ngcontent-%COMP%]    > .placeholder[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 4vw;\n  color: var(--color3Alt3);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  flex: 1;\n  margin: 0 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  line-height: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .contact[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  color: var(--color3);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-decoration: none;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  margin-right: 0.25vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .closing[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1.8vw;\n  color: var(--color5Alt4);\n  font-weight: var(--strongest);\n  -moz-animation-name: closeLoadIn;\n  -ms-animation-name: closeLoadIn;\n  -o-animation-name: closeLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_closeLoadIn;\n  animation-name: _ngcontent-%COMP%_closeLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 2s;\n  -ms-animation-duration: 2s;\n  -o-animation-duration: 2s;\n  -webkit-animation-duration: 2s;\n  animation-duration: 2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member.active[_ngcontent-%COMP%] {\n  border-color: var(--color3Alt3);\n  background-color: rgba(var(--color3-raw), 0.1);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .team[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .member[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%] {\n  width: calc(60% - 0.5vw);\n  position: relative;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 2vw 1vw 6vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.1vw 0.5vw rgba(var(--black-raw), 0.1);\n  padding: 0.5vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%] {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%] {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 0.8vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  margin-top: 5vw;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 1s;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .opportunities[_ngcontent-%COMP%] {\n  width: 100%;\n  margin-top: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .opportunities[_ngcontent-%COMP%]    > opportunity-summary[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .opportunities[_ngcontent-%COMP%]    > opportunity-summary[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .opportunities[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]:not(.subtle) {\n  top: 8vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%] {\n  position: relative;\n  overflow: hidden;\n  height: 100%;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  flex: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%] {\n  border-radius: 0.5vw;\n  overflow: hidden;\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap[_ngcontent-%COMP%]   #routeMap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .map-wrap.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 2vw;\n  z-index: 1;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 8vw;\n  width: 8vw;\n  -webkit-filter: saturate(0);\n  -moz-filter: saturate(0);\n  -o-filter: saturate(0);\n  -ms-filter: saturate(0);\n  filter: saturate(0);\n  opacity: 0.6;\n}\n#rgmView[_ngcontent-%COMP%]    > .focus[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .map[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  font-size: 1.6vw;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  font-weight: var(--ltweight);\n}\nloader[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  right: 0.5vw;\n  bottom: 0.5vw;\n  width: 3vw;\n  height: 3vw;\n  --fillSpeed: 2s;\n}\n/*# sourceMappingURL=rgm.component.css.map */'] });
var RgmComponent = _RgmComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(RgmComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "rgm-view", providers: [OrderByPipe], template: `<section id="rgmView">
  <div class="primary">
    <div class="content">
      <div class="summary card">
        @if (profileImage != null) {
          <div class="profile">
            <img [src]="profileImage" />
          </div>
        }
        <div class="content">
          <header>
            <h2>Your team summary for {{today | date:'EEEE, MMMM d'}}</h2>
            <h3>Welcome back, {{firstName}}</h3>
          </header>
          <div class="content">
            @if (!retrievingSummary) {
              <p>
                {{summaryText}}
              </p>
            }
            @if (retrievingSummary) {
              <div class="loader">
                <p>{{summaryLoaderLabel}}</p>
                <div class="bar"></div>
                <div class="bar"></div>
              </div>
            }
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="focus">
    <div class="content">
      <div class="column team">
        <header>
          <div class="primary">
            <h2>
              Your Team
            </h2>
          </div>
        </header>
        <div class="content">
          @for (member of teamMembers; track member) {
            <div class="member"
              (click)="setActiveMember(member)"
              [class.active]="activeMember?.id == member.id"
              >
              <div class="avatar">
                <canvas width="3" height="4"></canvas>
                @if (member.profileImage_B64 != null) {
                  <div class="image">
                    <img [src]="member.profileImage_B64" />
                  </div>
                }
                @if (member.profileImage_B64 == null) {
                  <div class="placeholder">
                    <i class="fa-solid fa-user"></i>
                  </div>
                }
              </div>
              <div class="meta">
                <div class="name">
                  <h3>{{member.fullName}}</h3>
                </div>
                @if (member.emailAddress != null) {
                  <div class="contact">
                    <label>
                      {{member.emailAddress}}
                    </label>
                  </div>
                }
                @if (member.phone != null) {
                  <div class="contact">
                    <label>
                      {{member.phone | phone}}
                    </label>
                  </div>
                }
                @if (member.closePercentage != null) {
                  <div class="closing">
                    <label>Current Week Close Percentage</label>
                    <span class="value">{{member.closePercentage}}%</span>
                  </div>
                }
              </div>
            </div>
          }
          @if (!hasTeamMembers) {
            <div class="message">
              <p>
                No team members.
              </p>
            </div>
          }
        </div>
      </div>
      <div class="column opportunities">
        <header>
          <div class="primary">
            <h2>
              {{activeMember?.fullName}}'s Appointments
            </h2>
          </div>
        </header>
        <div class="content">
          <header>
            <div class="search">
              <div class="input">
                <input type="text"
                  [(ngModel)]="searchInput"
                  (input)="searchOpportunities()"
                  placeholder="Search appointments..." />
              </div>
            </div>
            <div class="sorting">
              <div class="control">
                <label>Status</label>
                <div class="input">
                  <select [(ngModel)]="activeStatus" (change)="filterOpportunities()">
                    @for (option of statusOptions; track option) {
                      <option [ngValue]="option.id">
                      {{option.name}}</option>
                    }
                  </select>
                </div>
              </div>
            </div>
          </header>

          @if (showOpportunitiesLoader) {
            <loader [fill]="true"></loader>
          }

          @if (showVisibleOpportunities) {
            <div class="opportunities">
              @for (opportunity of visibleOpportunities; track opportunity) {
                <opportunity-summary
                  [opportunity]="opportunity"
                  [manager]="user"
                  [management]="true">
                </opportunity-summary>
              }
            </div>
            <div class="message subtle">
              <p>Showing {{visibleOpportunities.length}} of the most recent appointments.</p>
              <p>Use the search if you're looking for a specific appointment.</p>
            </div>
          }

          @if (showMissingOpportunitiesMessage) {
            <div class="message">
              <p>
                No matching appointments found.
              </p>
            </div>
          }
        </div>
      </div>
    </div>
  </div>
</section>`, styles: ['/* src/app/dashboard/components/rgm/rgm.component.scss */\n@-webkit-keyframes closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-moz-keyframes closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-o-keyframes closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@keyframes closeLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n#rgmView {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 2vw;\n  right: 2vw;\n  bottom: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#rgmView > .primary > .content > .summary {\n  border-radius: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n  background-color: var(--color6);\n  border: 0.1vw var(--color6Alt3) solid;\n  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  display: flex;\n  align-items: flex-start;\n  height: 15vw;\n}\n#rgmView > .primary > .content > .summary > .content {\n  flex: 1;\n  width: 100%;\n  position: relative;\n  z-index: 1;\n}\n#rgmView > .primary > .content > .summary > .content > header {\n  padding: 1vw;\n}\n#rgmView > .primary > .content > .summary > .content > header h2 {\n  line-height: 1;\n  font-size: 2.2vw;\n  white-space: nowrap;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#rgmView > .primary > .content > .summary > .content > header h3 {\n  font-size: 1.6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#rgmView > .primary > .content > .summary > .content > .content {\n  padding: 0.5vw 1vw 1vw;\n  background-color: rgba(var(--color6-raw), 0.6);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  border-radius: 1vw;\n}\n#rgmView > .primary > .content > .summary > .content > .content > p {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView > .primary > .content > .summary > .content > .content > .loader > p {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strongest);\n  font-style: italic;\n  text-transform: lowercase;\n}\n#rgmView > .primary > .content > .summary > .content > .content > .loader > .bar {\n  margin-top: 0.8vw;\n  border-radius: 999px;\n  position: relative;\n  height: 1.4vw;\n  background-color: var(--color2Alt2);\n  overflow: hidden;\n}\n#rgmView > .primary > .content > .summary > .content > .content > .loader > .bar:before {\n  content: "";\n  display: block;\n  position: absolute;\n  border-radius: 999px;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  -moz-transform: translateX(-100%);\n  -ms-transform: translateX(-100%);\n  -o-transform: translateX(-100%);\n  -webkit-transform: translateX(-100%);\n  transform: translateX(-100%);\n  -moz-animation-name: barLoader;\n  -ms-animation-name: barLoader;\n  -o-animation-name: barLoader;\n  -webkit-animation-name: barLoader;\n  animation-name: barLoader;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 3s;\n  -ms-animation-duration: 3s;\n  -o-animation-duration: 3s;\n  -webkit-animation-duration: 3s;\n  animation-duration: 3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  background-color: var(--color2Alt1);\n}\n#rgmView > .primary > .content > .summary > .content > .content > .loader > .bar:nth-of-type(2):before {\n  -moz-animation-name: barLoader;\n  -ms-animation-name: barLoader;\n  -o-animation-name: barLoader;\n  -webkit-animation-name: barLoader;\n  animation-name: barLoader;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 3s;\n  -ms-animation-duration: 3s;\n  -o-animation-duration: 3s;\n  -webkit-animation-duration: 3s;\n  animation-duration: 3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.5s;\n  -ms-animation-delay: 0.5s;\n  -o-animation-delay: 0.5s;\n  -webkit-animation-delay: 0.5s;\n  animation-delay: 0.5s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#rgmView > .primary > .content > .summary > .content > .content > .loader > .bar:nth-of-type(3):before {\n  -moz-animation-name: barLoader;\n  -ms-animation-name: barLoader;\n  -o-animation-name: barLoader;\n  -webkit-animation-name: barLoader;\n  animation-name: barLoader;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 3s;\n  -ms-animation-duration: 3s;\n  -o-animation-duration: 3s;\n  -webkit-animation-duration: 3s;\n  animation-duration: 3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 1s;\n  -ms-animation-delay: 1s;\n  -o-animation-delay: 1s;\n  -webkit-animation-delay: 1s;\n  animation-delay: 1s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#rgmView > .primary > .content > .summary > .profile {\n  width: 10vw;\n  height: 100%;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  mix-blend-mode: multiply;\n}\n#rgmView > .primary > .content > .summary > .profile img {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rgmView > .focus {\n  flex: 1;\n  margin-top: 1vw;\n  position: relative;\n}\n#rgmView > .focus > .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n}\n#rgmView > .focus > .content > .column {\n  height: 100%;\n  position: relative;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  -webkit-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -moz-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -o-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  -ms-filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  filter: drop-shadow(0 3px 2px rgba(var(--color1-raw), 0.1));\n  margin-left: 1vw;\n  overflow-x: hidden;\n}\n#rgmView > .focus > .content > .column > header {\n  z-index: 1;\n  padding: 1vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#rgmView > .focus > .content > .column > header > .primary h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView > .focus > .content > .column > .content {\n  padding-top: 1vw;\n  position: relative;\n  max-height: 100%;\n  z-index: 0;\n  overflow-x: hidden;\n}\n#rgmView > .focus > .content > .column > .content > .message p {\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#rgmView > .focus > .content > .column > .content > .message .controls {\n  margin-top: 1vw;\n  display: flex;\n  justify-content: center;\n}\n#rgmView > .focus > .content > .column > .content > .message .controls > .control {\n  cursor: pointer;\n  display: block;\n  text-align: center;\n}\n#rgmView > .focus > .content > .column > .content > .message .controls > .control > label {\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n}\n#rgmView > .focus > .content > .column > .content > .message:not(.subtle) {\n  width: 50%;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n}\n#rgmView > .focus > .content > .column > .content > .message.subtle {\n  margin-top: 2vw;\n}\n#rgmView > .focus > .content > .column > .content > .message.subtle > p {\n  position: relative;\n  top: initial;\n  font-size: 1.6vw;\n}\n#rgmView > .focus > .content > .column:first-child {\n  margin-left: 0;\n}\n#rgmView > .focus > .content .team {\n  width: calc(40% - 0.5vw);\n}\n#rgmView > .focus > .content .team > .content {\n  padding: 1vw 1vw 6vw;\n}\n#rgmView > .focus > .content .team > .content > .member {\n  display: flex;\n  align-items: center;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  cursor: pointer;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s, background-color 0.2s;\n  -o-transition: border-color 0.2s, background-color 0.2s;\n  -webkit-transition: border-color 0.2s, background-color 0.2s;\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#rgmView > .focus > .content .team > .content > .member > .avatar {\n  height: 15vw;\n  overflow: hidden;\n  z-index: 0;\n  pointer-events: none;\n  position: relative;\n}\n#rgmView > .focus > .content .team > .content > .member > .avatar canvas {\n  height: 100%;\n}\n#rgmView > .focus > .content .team > .content > .member > .avatar > .image {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  mix-blend-mode: multiply;\n}\n#rgmView > .focus > .content .team > .content > .member > .avatar > .image > img {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n#rgmView > .focus > .content .team > .content > .member > .avatar > .placeholder {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color3Alt4-raw), 0.2);\n}\n#rgmView > .focus > .content .team > .content > .member > .avatar > .placeholder > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 4vw;\n  color: var(--color3Alt3);\n}\n#rgmView > .focus > .content .team > .content > .member > .meta {\n  flex: 1;\n  margin: 0 1vw;\n}\n#rgmView > .focus > .content .team > .content > .member > .meta > .name h3 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  line-height: 1;\n}\n#rgmView > .focus > .content .team > .content > .member > .meta > .contact label {\n  color: var(--color3);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-decoration: none;\n}\n#rgmView > .focus > .content .team > .content > .member > .meta > .closing {\n  margin-top: 0.5vw;\n}\n#rgmView > .focus > .content .team > .content > .member > .meta > .closing > label {\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  margin-right: 0.25vw;\n}\n#rgmView > .focus > .content .team > .content > .member > .meta > .closing > .value {\n  line-height: 1;\n  display: block;\n  font-size: 1.8vw;\n  color: var(--color5Alt4);\n  font-weight: var(--strongest);\n  -moz-animation-name: closeLoadIn;\n  -ms-animation-name: closeLoadIn;\n  -o-animation-name: closeLoadIn;\n  -webkit-animation-name: closeLoadIn;\n  animation-name: closeLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 2s;\n  -ms-animation-duration: 2s;\n  -o-animation-duration: 2s;\n  -webkit-animation-duration: 2s;\n  animation-duration: 2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#rgmView > .focus > .content .team > .content > .member.active {\n  border-color: var(--color3Alt3);\n  background-color: rgba(var(--color3-raw), 0.1);\n}\n#rgmView > .focus > .content .team > .content > .member:first-child {\n  margin-top: 0;\n}\n#rgmView > .focus > .content .opportunities {\n  width: calc(60% - 0.5vw);\n  position: relative;\n}\n#rgmView > .focus > .content .opportunities > .content {\n  padding: 2vw 1vw 6vw;\n}\n#rgmView > .focus > .content .opportunities > .content > header {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.1vw 0.5vw rgba(var(--black-raw), 0.1);\n  padding: 0.5vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .search {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .search > .input input {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .sorting {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .sorting > .control {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .sorting > .control > label {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 0.8vw;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .sorting > .control > .input select {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#rgmView > .focus > .content .opportunities > .content > header > .sorting > .control:first-child {\n  margin-left: 0;\n}\n#rgmView > .focus > .content .opportunities > .content > loader {\n  display: block;\n  position: relative;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  margin-top: 5vw;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 1s;\n}\n#rgmView > .focus > .content .opportunities > .content > .opportunities {\n  width: 100%;\n  margin-top: 1vw;\n}\n#rgmView > .focus > .content .opportunities > .content > .opportunities > opportunity-summary {\n  display: block;\n  width: 100%;\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#rgmView > .focus > .content .opportunities > .content > .opportunities > opportunity-summary:first-child {\n  margin-top: 0;\n}\n#rgmView > .focus > .content .opportunities > .content > .message:not(.subtle) {\n  top: 8vw;\n}\n#rgmView > .focus > .content .map {\n  position: relative;\n  overflow: hidden;\n  height: 100%;\n}\n#rgmView > .focus > .content .map > header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#rgmView > .focus > .content .map > header > .primary h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#rgmView > .focus > .content .map > header > .controls > .control {\n  cursor: pointer;\n}\n#rgmView > .focus > .content .map > header > .controls > .control > i {\n  font-size: 1.8vw;\n  color: var(--color1);\n}\n#rgmView > .focus > .content .map > .content {\n  position: relative;\n  height: 100%;\n  flex: 1;\n}\n#rgmView > .focus > .content .map > .content > .map-wrap {\n  border-radius: 0.5vw;\n  overflow: hidden;\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#rgmView > .focus > .content .map > .content > .map-wrap #routeMap {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#rgmView > .focus > .content .map > .content > .map-wrap.active {\n  opacity: 1;\n}\n#rgmView > .focus > .content .map > .content > .loader {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 2vw;\n  z-index: 1;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n#rgmView > .focus > .content .map > .content > .loader > loader {\n  display: block;\n  height: 8vw;\n  width: 8vw;\n  -webkit-filter: saturate(0);\n  -moz-filter: saturate(0);\n  -o-filter: saturate(0);\n  -ms-filter: saturate(0);\n  filter: saturate(0);\n  opacity: 0.6;\n}\n#rgmView > .focus > .content .map > .content > .loader > p {\n  margin-top: 1vw;\n  font-size: 1.6vw;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  font-weight: var(--ltweight);\n}\nloader {\n  display: block;\n  position: absolute;\n  right: 0.5vw;\n  bottom: 0.5vw;\n  width: 3vw;\n  height: 3vw;\n  --fillSpeed: 2s;\n}\n/*# sourceMappingURL=rgm.component.css.map */\n'] }]
  }], () => [{ type: HttpClient }, { type: DashboardService }, { type: AiService }, { type: DeviceRouteService }, { type: AuthRefService }, { type: OrderByPipe }, { type: OpportunityService }, { type: ApiService }], { userId: [{
    type: Input,
    args: ["userId"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], params: [{
    type: Input,
    args: ["params"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(RgmComponent, { className: "RgmComponent" });
})();

// src/app/dashboard/components/layout/layout.component.ts
var _c03 = ["componentElm"];
function DashboardLayoutComponent_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "rc-view", 6);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.loadDirection));
    \u0275\u0275classProp("rendered", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.rendered)("animate", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.animating)("closing", ctx_r0.rcRoute == null ? null : ctx_r0.rcRoute.closing);
    \u0275\u0275property("params", ctx_r0.routeParams)("route", ctx_r0.rcRoute);
  }
}
function DashboardLayoutComponent_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "rgm-view", 6);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.loadDirection));
    \u0275\u0275classProp("rendered", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.rendered)("animate", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.animating)("closing", ctx_r0.rgmRoute == null ? null : ctx_r0.rgmRoute.closing);
    \u0275\u0275property("params", ctx_r0.routeParams)("route", ctx_r0.rgmRoute);
  }
}
var _DashboardLayoutComponent = class _DashboardLayoutComponent {
  constructor(deviceRouteService, uiService, appService, dashboardService) {
    this.deviceRouteService = deviceRouteService;
    this.uiService = uiService;
    this.appService = appService;
    this.dashboardService = dashboardService;
    this.params = new BehaviorSubject([]);
    this.routeParams = new BehaviorSubject([]);
    this.routeLabel = "Your day at a glance";
    this.checkingForUpdate = false;
  }
  get routesInitialized() {
    return this.dashboardService.routesInitialized;
  }
  get routes() {
    return this.dashboardService.routeService.routes;
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        const componentElm = this.componentElm?.nativeElement;
        if (componentElm != null) {
          let route = params[0]?.toLowerCase();
          if (route != null) {
            const routeMatches = Object.values(DashboardRouteType).includes(route);
            const routeParams = params.slice(1);
            this.routeParams.next(routeParams);
            if (routeMatches) {
              if (!this.routesInitialized) {
                this.dashboardService.initRoutes(route, componentElm);
              } else {
                this.viewRoute(route);
              }
            } else {
              if (!this.routesInitialized) {
                this.dashboardService.initRoutes(void 0, componentElm);
              }
            }
          } else {
            if (!this.routesInitialized) {
              this.dashboardService.initRoutes(void 0, componentElm);
            }
          }
        }
      }
    });
  }
  viewRoute(name) {
    if (name != null) {
      this.dashboardService.routeService.viewRoute(name, RouteLoadDirection.Forward, true);
    }
  }
  watchRoute() {
    this.routeSubscription = this.dashboardService.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
            case DashboardRouteType.team:
              {
                this.routeLabel = "Your team at a glance";
              }
              break;
            case DashboardRouteType.today: {
              this.routeLabel = "Your day at a glance";
            }
          }
        }
      }
    });
  }
  initRouting() {
    setTimeout(() => {
      this.watchParams();
      this.watchRoute();
    }, 0);
  }
  // #endregion
  // #region RC
  get rcRoute() {
    return this.routes[DashboardRouteType.today];
  }
  // #endregion
  // #region RGM
  get rgmRoute() {
    return this.routes[DashboardRouteType.team];
  }
  checkForUpdate() {
    if (!this.checkingForUpdate) {
      this.checkingForUpdate = true;
      if (Capacitor.isNativePlatform()) {
        this.appService.checkNativeUpdate().then((update) => {
          if (update != null) {
            this.uiService.prompt("Update Available", `A new version (${update.version}) is available. Please update to continue.`, "Okay").subscribe({
              next: (confirmed) => {
                this.checkingForUpdate = false;
                this.appService.updatingApp = true;
                this.appService.downloadAndApplyUpdate(update).then((updated) => {
                  if (!updated) {
                    this.appService.updatingApp = false;
                  }
                }).catch(() => {
                  this.appService.updatingApp = false;
                });
              }
            });
          } else {
            this.checkingForUpdate = false;
          }
        }).catch(() => {
          this.checkingForUpdate = false;
        });
      } else {
        this.appService.checkWebUpdate().then((update) => {
          if (update != null) {
            this.uiService.prompt("Update Available", `A new version (${update.version}) is available. Please update to continue.`, "Okay").subscribe({
              next: () => {
                this.appService.updatingApp = true;
                setTimeout(() => {
                  const url = new URL(window.location.href);
                  url.searchParams.set("_", Date.now().toString());
                  window.location.href = url.toString();
                }, 2e3);
              }
            });
          } else {
            this.checkingForUpdate = false;
          }
        }).catch(() => {
          this.checkingForUpdate = false;
        });
      }
    }
  }
  init() {
    this.checkForUpdate();
    this.initRouting();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.paramsSubscription?.unsubscribe();
    this.routeSubscription?.unsubscribe();
  }
};
_DashboardLayoutComponent.\u0275fac = function DashboardLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DashboardLayoutComponent)(\u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(AppService), \u0275\u0275directiveInject(DashboardService));
};
_DashboardLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _DashboardLayoutComponent, selectors: [["ng-component"]], viewQuery: function DashboardLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 12, vars: 3, consts: [["componentElm", ""], ["id", "dashboardLayout"], [1, "primary"], [1, "secondary"], [1, "routes"], [3, "class", "params", "route", "rendered", "animate", "closing"], [3, "params", "route"]], template: function DashboardLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h1");
    \u0275\u0275text(5, "Dashboard");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "div", 3)(7, "h2");
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 4);
    \u0275\u0275conditionalCreate(10, DashboardLayoutComponent_Conditional_10_Template, 1, 11, "rc-view", 5);
    \u0275\u0275conditionalCreate(11, DashboardLayoutComponent_Conditional_11_Template, 1, 11, "rgm-view", 5);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx.routeLabel);
    \u0275\u0275advance(2);
    \u0275\u0275conditional((ctx.rcRoute == null ? null : ctx.rcRoute.active) ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.rgmRoute == null ? null : ctx.rgmRoute.active) ? 11 : -1);
  }
}, dependencies: [RcComponent, RgmComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#dashboardLayout[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var DashboardLayoutComponent = _DashboardLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DashboardLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '<section id="dashboardLayout" #componentElm>\n  <header>\n    <div class="primary">\n      <h1>Dashboard</h1>\n    </div>\n    <div class="secondary">\n      <h2>{{routeLabel}}</h2>\n    </div>\n  </header>\n\n  <div class="routes">\n    @if (rcRoute?.active) {\n      <rc-view\n        class="route {{rcRoute?.loadDirection}}"\n        [params]="routeParams"\n        [route]="rcRoute"\n        [class.rendered]="rcRoute?.rendered"\n        [class.animate]="rcRoute?.animating"\n      [class.closing]="rcRoute?.closing"></rc-view>\n    }\n    @if (rgmRoute?.active) {\n      <rgm-view\n        class="route {{rgmRoute?.loadDirection}}"\n        [params]="routeParams"\n        [route]="rgmRoute"\n        [class.rendered]="rgmRoute?.rendered"\n        [class.animate]="rgmRoute?.animating"\n      [class.closing]="rgmRoute?.closing"></rgm-view>\n    }\n  </div>\n\n</section>', styles: ["/* src/app/dashboard/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#dashboardLayout {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#dashboardLayout > header {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#dashboardLayout > header > .primary h1 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#dashboardLayout > header > .secondary {\n  margin-left: 1vw;\n}\n#dashboardLayout > header > .secondary h2 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#dashboardLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#dashboardLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#dashboardLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#dashboardLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: DeviceRouteService }, { type: UiService }, { type: AppService }, { type: DashboardService }], { params: [{
    type: Input,
    args: ["params"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(DashboardLayoutComponent, { className: "DashboardLayoutComponent" });
})();

// src/app/shared/appointments/components/estimate-submission/estimate-submission.component.ts
var _c04 = ["previewElm"];
var _c1 = ["exportElm"];
var _c2 = ["apptDocument"];
function EstimateSubmissionComponent_Conditional_0_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 12);
    \u0275\u0275element(1, "div", 43, 0);
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13);
    \u0275\u0275element(1, "loader", 44);
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Preparing Documents");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("fill", false);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "p");
    \u0275\u0275text(2, " Please complete your documents before submitting the job. ");
    \u0275\u0275elementEnd()();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 17)(1, "h3");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate2("", ctx_r1.customer.firstName, " ", ctx_r1.customer.lastName);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r1.address.friendlyAddress);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_24_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("E-Mail: ", ctx_r1.customerEmail);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "h4");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "phone");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Phone: ", \u0275\u0275pipeBind1(3, 1, ctx_r1.customerPhone));
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 20)(1, "header")(2, "div", 6)(3, "h4");
    \u0275\u0275text(4, "Final Sales Price");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(5, "div", 10)(6, "span", 32);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "currency");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(8, 1, ctx_r1.price.finalPrice, "USD"), " ");
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_49_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 14);
    \u0275\u0275text(1, " You have designated an invalid install date. ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_For_58_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0);
    \u0275\u0275pipe(1, "phone");
  }
  if (rf & 2) {
    const shop_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275textInterpolate1(" - ", \u0275\u0275pipeBind1(1, 1, shop_r3.phoneNumber), " ");
  }
}
function EstimateSubmissionComponent_Conditional_0_For_58_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 29);
    \u0275\u0275text(1);
    \u0275\u0275conditionalCreate(2, EstimateSubmissionComponent_Conditional_0_For_58_Conditional_2_Template, 2, 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const shop_r3 = ctx.$implicit;
    \u0275\u0275property("ngValue", shop_r3.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", shop_r3.name, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(shop_r3.phoneNumber != null ? 2 : -1);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_59_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 14);
    \u0275\u0275text(1, " You must specify a preferred shop. ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_67_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Missing Payment Information ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_68_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 32);
    \u0275\u0275text(1, " Ready to Submit ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_71_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 45);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_71_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.managePayments());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Manage Payments");
    \u0275\u0275elementEnd()();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_80_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Please Complete Payment Information ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_81_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Awaiting Signatures ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_82_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 31);
    \u0275\u0275text(1, " Awaiting Customer Signatures ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_83_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 32);
    \u0275\u0275text(1, " Ready to Submit ");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_86_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 46);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_86_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.sendDocumentsForSignature());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Send for e-Signature");
    \u0275\u0275elementEnd()();
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_87_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 42);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_87_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.reviewSignedDocuments());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Save or Send Signed Copies");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("disabled", !ctx_r1.canSendDocumentsToCustomer);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_88_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_88_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r7);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startSigningForCustomer());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Sign for Customer");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("disabled", !ctx_r1.canReviewDocuments);
  }
}
function EstimateSubmissionComponent_Conditional_0_Conditional_89_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Conditional_89_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startSigningForConsultant());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Sign for Consultant");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("disabled", !ctx_r1.canReviewDocuments);
  }
}
function EstimateSubmissionComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 3)(1, "header")(2, "div", 6)(3, "h3");
    \u0275\u0275text(4, " Submit Job ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 7)(6, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeView());
    });
    \u0275\u0275element(7, "i", 9);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 10)(9, "div", 6)(10, "header")(11, "h4");
    \u0275\u0275text(12, "Review Final Job Documents");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(13, "div", 11);
    \u0275\u0275conditionalCreate(14, EstimateSubmissionComponent_Conditional_0_Conditional_14_Template, 3, 0, "div", 12);
    \u0275\u0275conditionalCreate(15, EstimateSubmissionComponent_Conditional_0_Conditional_15_Template, 4, 1, "div", 13);
    \u0275\u0275conditionalCreate(16, EstimateSubmissionComponent_Conditional_0_Conditional_16_Template, 3, 0, "div", 14);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(17, "div", 15)(18, "div", 16);
    \u0275\u0275conditionalCreate(19, EstimateSubmissionComponent_Conditional_0_Conditional_19_Template, 3, 2, "div", 17);
    \u0275\u0275elementStart(20, "div", 18)(21, "h4");
    \u0275\u0275text(22);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(23, EstimateSubmissionComponent_Conditional_0_Conditional_23_Template, 3, 1, "div", 19);
    \u0275\u0275conditionalCreate(24, EstimateSubmissionComponent_Conditional_0_Conditional_24_Template, 3, 1, "div", 19);
    \u0275\u0275conditionalCreate(25, EstimateSubmissionComponent_Conditional_0_Conditional_25_Template, 4, 3, "div", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(26, EstimateSubmissionComponent_Conditional_0_Conditional_26_Template, 9, 4, "div", 20);
    \u0275\u0275elementStart(27, "div", 21)(28, "header")(29, "div", 6)(30, "H4");
    \u0275\u0275text(31, "Operation Notes");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(32, "div", 10)(33, "div", 22)(34, "div", 23)(35, "div", 24)(36, "textarea", 25);
    \u0275\u0275twoWayListener("ngModelChange", function EstimateSubmissionComponent_Conditional_0_Template_textarea_ngModelChange_36_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.operationsNote, $event) || (ctx_r1.operationsNote = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(37, "div", 26)(38, "header")(39, "div", 6)(40, "h4");
    \u0275\u0275text(41, "Shop Information");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(42, "div", 10)(43, "div", 22)(44, "div", 23)(45, "label");
    \u0275\u0275text(46, "Preferred Install Date");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(47, "div", 24)(48, "input", 27);
    \u0275\u0275twoWayListener("ngModelChange", function EstimateSubmissionComponent_Conditional_0_Template_input_ngModelChange_48_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.preferredInstallDateTimestamp, $event) || (ctx_r1.preferredInstallDateTimestamp = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("blur", function EstimateSubmissionComponent_Conditional_0_Template_input_blur_48_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateInstallDate());
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(49, EstimateSubmissionComponent_Conditional_0_Conditional_49_Template, 2, 0, "p", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(50, "div", 23)(51, "label");
    \u0275\u0275text(52, "Preferred Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(53, "div", 24)(54, "select", 28);
    \u0275\u0275twoWayListener("ngModelChange", function EstimateSubmissionComponent_Conditional_0_Template_select_ngModelChange_54_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.preferredShopId, $event) || (ctx_r1.preferredShopId = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("change", function EstimateSubmissionComponent_Conditional_0_Template_select_change_54_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateShop());
    });
    \u0275\u0275elementStart(55, "option", 29);
    \u0275\u0275text(56, "-- Select a Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275repeaterCreate(57, EstimateSubmissionComponent_Conditional_0_For_58_Template, 3, 3, "option", 29, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(59, EstimateSubmissionComponent_Conditional_0_Conditional_59_Template, 2, 0, "p", 14);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(60, "div", 30)(61, "header")(62, "div", 6)(63, "h4");
    \u0275\u0275text(64, "Payments");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(65, "h5");
    \u0275\u0275text(66, " Status: ");
    \u0275\u0275conditionalCreate(67, EstimateSubmissionComponent_Conditional_0_Conditional_67_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(68, EstimateSubmissionComponent_Conditional_0_Conditional_68_Template, 2, 0, "span", 32);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(69, "div", 15)(70, "div", 7);
    \u0275\u0275conditionalCreate(71, EstimateSubmissionComponent_Conditional_0_Conditional_71_Template, 3, 0, "button", 33);
    \u0275\u0275elementEnd()()();
    \u0275\u0275element(72, "div", 10);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(73, "div", 34)(74, "header")(75, "div", 6)(76, "h4");
    \u0275\u0275text(77, "Document Review");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(78, "h5");
    \u0275\u0275text(79, " Status: ");
    \u0275\u0275conditionalCreate(80, EstimateSubmissionComponent_Conditional_0_Conditional_80_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(81, EstimateSubmissionComponent_Conditional_0_Conditional_81_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(82, EstimateSubmissionComponent_Conditional_0_Conditional_82_Template, 2, 0, "span", 31);
    \u0275\u0275conditionalCreate(83, EstimateSubmissionComponent_Conditional_0_Conditional_83_Template, 2, 0, "span", 32);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(84, "div", 15)(85, "div", 7);
    \u0275\u0275conditionalCreate(86, EstimateSubmissionComponent_Conditional_0_Conditional_86_Template, 3, 0, "button", 35);
    \u0275\u0275conditionalCreate(87, EstimateSubmissionComponent_Conditional_0_Conditional_87_Template, 3, 1, "button", 36);
    \u0275\u0275conditionalCreate(88, EstimateSubmissionComponent_Conditional_0_Conditional_88_Template, 3, 1, "button", 37);
    \u0275\u0275conditionalCreate(89, EstimateSubmissionComponent_Conditional_0_Conditional_89_Template, 3, 1, "button", 37);
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(90, "div", 38)(91, "div", 39);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_div_click_91_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.toggleConfirmation());
    });
    \u0275\u0275elementStart(92, "div", 24);
    \u0275\u0275element(93, "i", 40)(94, "i", 41);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(95, "label");
    \u0275\u0275text(96, "Tap to confirm you have verified all information is accurate before submitting.");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(97, "div", 7)(98, "button", 42);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_button_click_98_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.closeView());
    });
    \u0275\u0275elementStart(99, "label");
    \u0275\u0275text(100, "Cancel");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(101, "button", 8);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_0_Template_button_click_101_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.submitEstimate());
    });
    \u0275\u0275elementStart(102, "label");
    \u0275\u0275text(103, "Submit Job");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", ctx_r1.submittingEstimate);
    \u0275\u0275advance(8);
    \u0275\u0275conditional(ctx_r1.hasDocumentsToPreview ? 14 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showDocumentsLoader ? 15 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.hasDocumentsToPreview ? 16 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.customer != null ? 19 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("Job ", ctx_r1.appointment.jobId);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.address != null ? 23 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.customerEmail != null ? 24 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.customerPhone != null ? 25 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.price != null ? 26 : -1);
    \u0275\u0275advance(10);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.operationsNote);
    \u0275\u0275advance(8);
    \u0275\u0275classProp("invalid", !ctx_r1.shopDateValid);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.preferredInstallDateTimestamp);
    \u0275\u0275property("min", ctx_r1.minInstallDate);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.shopDateValid ? 49 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.preferredShopId);
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", void 0);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r1.shops);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx_r1.shopValid ? 59 : -1);
    \u0275\u0275advance(8);
    \u0275\u0275conditional(!ctx_r1.canSubmitPayments ? 67 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSubmitPayments ? 68 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.canManagePayments ? 71 : -1);
    \u0275\u0275advance(9);
    \u0275\u0275conditional(!ctx_r1.canReviewDocuments ? 80 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showDocumentSignaturesMessage ? 81 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showCustomerSignaturesMessage ? 82 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSubmitDocuments ? 83 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.canSendForSignature ? 86 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSubmitDocuments ? 87 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSignDocuments ? 88 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.canSignDocuments ? 89 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("checked", ctx_r1.confirmed);
    \u0275\u0275advance(7);
    \u0275\u0275property("disabled", ctx_r1.submittingEstimate);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx_r1.canSubmitEstimate);
  }
}
function EstimateSubmissionComponent_Conditional_1_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 49);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(2, 1, ctx_r1.estimateProgress), "%");
  }
}
function EstimateSubmissionComponent_Conditional_1_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 50);
    \u0275\u0275text(1, "Estimate Processing");
    \u0275\u0275elementEnd();
  }
}
function EstimateSubmissionComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "aside", 4);
    \u0275\u0275element(1, "div", 47);
    \u0275\u0275elementStart(2, "div", 48)(3, "button", 45);
    \u0275\u0275listener("click", function EstimateSubmissionComponent_Conditional_1_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.promptToStopSendingEstimate());
    });
    \u0275\u0275element(4, "i", 9);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 13);
    \u0275\u0275conditionalCreate(6, EstimateSubmissionComponent_Conditional_1_Conditional_6_Template, 3, 3, "span", 49);
    \u0275\u0275conditionalCreate(7, EstimateSubmissionComponent_Conditional_1_Conditional_7_Template, 2, 0, "span", 50);
    \u0275\u0275element(8, "loader", 51);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Preparing & Sending Estimate");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275conditional(!ctx_r1.showEstimateProcessing ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.showEstimateProcessing ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("progress", true)("percent", ctx_r1.estimateProgress);
  }
}
function EstimateSubmissionComponent_Conditional_2_For_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "appointment-document", 54, 2);
    \u0275\u0275listener("rendered", function EstimateSubmissionComponent_Conditional_2_For_4_Template_appointment_document_rendered_0_listener() {
      const document_r11 = \u0275\u0275restoreView(_r10).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.renderDocument(document_r11));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const document_r11 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("appointmentContent", ctx_r1.content)("appointment", ctx_r1.appointment)("signing", true)("document", document_r11);
  }
}
function EstimateSubmissionComponent_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 5)(1, "div", 52, 1);
    \u0275\u0275repeaterCreate(3, EstimateSubmissionComponent_Conditional_2_For_4_Template, 2, 4, "appointment-document", 53, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx_r1.documents);
  }
}
var _EstimateSubmissionComponent = class _EstimateSubmissionComponent {
  constructor(appointmentService, appointmentUiService, contentService, uiService, orderByPipe) {
    this.appointmentService = appointmentService;
    this.appointmentUiService = appointmentUiService;
    this.contentService = contentService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.paymentDetails = [];
    this.apptDocuments = new QueryList();
    this.consultantValid = false;
    this.customerValid = false;
    this.sendingDocuments = false;
    this.closingSendDocuments = false;
    this.renderingDocuments = true;
    this.renderedDocuments = [];
    this.documents = [];
    this.minInstallDate = getDateOnly(/* @__PURE__ */ new Date());
    this.submittingEstimate = false;
    this.canStopSendingEstimate = false;
    this.estimateProgress = new BehaviorSubject(0);
    this.confirmed = false;
    this.today = /* @__PURE__ */ new Date();
  }
  initAppointment() {
    if (this.appointment != null) {
      this.initShop();
      this.initPaymentDetails();
      this.initDocuments();
    }
  }
  get lastUpdated() {
    return this.appointment?.lastUpdated_Utc ?? /* @__PURE__ */ new Date();
  }
  // #endregion
  // #region Customer
  get customer() {
    return this.appointment?.customer;
  }
  get customerName() {
    if (this.customer != null) {
      return `${this.customer.firstName} ${this.customer.lastName}`;
    }
    return "";
  }
  get customerEmail() {
    const email = this.customer?.contactInformation.find((x) => x.type == ContactInformationType.Email);
    return email?.value;
  }
  get customerPhone() {
    const phone = this.customer?.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
    return phone?.value;
  }
  get payments() {
    return this.appointment?.payments ?? [];
  }
  get canSubmitPayments() {
    return this.appointment?.paymentsValidForEstimate ?? false;
  }
  get canManagePayments() {
    return this.appointment != null && !this.appointment.documentsValidForEstimate && this.appointment.paymentsValidForEstimate;
  }
  managePayments() {
    if (this.appointment != null) {
      this.appointmentUiService.startMakingPayments(this.appointment);
    }
  }
  initPaymentDetails() {
    if (this.appointment?.paymentSetting != null) {
      for (var i = 0, len = this.appointment.paymentSetting.details.length; i < len; i++) {
        const detail = this.appointment.paymentSetting.details[i];
        detail.updatedAmount$ = new Subject();
        if (i == 1 && this.appointment.paymentSetting.details.length > 2) {
          detail.canEditAmount = false;
        } else {
          detail.canEditAmount = true;
        }
        this.paymentDetails.push(detail);
      }
      this.paymentDetails = this.orderByPipe.transform(this.paymentDetails, "priority", false);
    }
  }
  get hasDocumentsToPreview() {
    return this.appointment?.documentsValidForEstimate ?? false;
  }
  get canSend() {
    return !this.sendingDocuments && !this.renderingDocuments;
  }
  get showDocumentsLoader() {
    return this.renderingDocuments && this.hasDocumentsToPreview;
  }
  get canSubmitDocuments() {
    return this.canReviewDocuments && (this.appointment?.documentsValidForEstimate ?? false);
  }
  get canReviewDocuments() {
    return this.appointment?.paymentsValidForEstimate ?? false;
  }
  get canSendDocumentsToCustomer() {
    return this.appointment?.documentsValidForEstimate ?? false;
  }
  get canSendForSignature() {
    return this.consultantValid && this.appointment != null && this.appointment?.paymentsValidForEstimate && !this.appointment?.documentsValidForEstimate;
  }
  get canSignDocuments() {
    return this.appointment != null && !this.appointment.documentsValidForEstimate;
  }
  get showDocumentSignaturesMessage() {
    return !this.canSubmitDocuments && this.canReviewDocuments && this.appointment != null && !this.appointment.documentsValidForEstimate && !this.showCustomerSignaturesMessage;
  }
  get showCustomerSignaturesMessage() {
    return !this.canSubmitDocuments && this.canReviewDocuments && this.consultantValid && !this.customerValid;
  }
  watchDocumentSigning() {
    this.documentSigningSubscription = this.appointmentUiService.signingDocuments.subscribe({
      next: (appointment) => {
        if (appointment == null) {
          this.initDocuments();
        }
      }
    });
  }
  generatePrice() {
    const price = this.appointment?.customPrice ?? this.appointment?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.appointment?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.appointment.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.appointment != null) {
      const content = {
        appointmentId: this.appointment.id,
        created_Utc: this.appointment.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.appointment.scheduled_Utc,
        property: this.appointment.property,
        jobId: this.appointment.jobId?.toString(),
        job: this.appointment.job,
        consultant: this.appointment.assignedTo,
        customer: this.appointment.customer,
        price: this.generatePrice(),
        documents: this.appointment.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  checkSigningValidity() {
    if (this.appointment != null) {
      let consultantValid = true;
      let customerValid = true;
      for (var i = 0, len = this.appointment.documents.length; i < len; i++) {
        const document2 = this.appointment.documents[i];
        document2.checkSigningValidity();
        if (!document2.consultantValid) {
          consultantValid = false;
        }
        if (!document2.customerValid) {
          customerValid = false;
        }
      }
      this.consultantValid = consultantValid;
      this.customerValid = customerValid;
      this.appointment.checkDocumentValidity();
      this.appointment.changed$.next();
    }
  }
  initDocuments() {
    this.checkSigningValidity();
    if (this.appointment?.documentsValidForEstimate) {
      this.generateContent();
      this.appointment.documents.forEach((document2) => {
        const name = document2.name.toLowerCase();
        if (name != "repipe info sheet" && !name.includes("sample warranty")) {
          this.documents.push(document2);
        }
      });
      this.documents = this.orderByPipe.transform(this.documents, "displayOrder", false);
    } else {
      if (this.documentSigningSubscription == null) {
        this.watchDocumentSigning();
      }
    }
  }
  sortRenderedDocuments() {
    if (this.renderedDocuments != null && this.renderedDocuments.length > 0) {
      this.renderedDocuments = this.orderByPipe.transform(this.renderedDocuments, "displayOrder", false);
    }
  }
  checkFinalizeRender() {
    if (this.renderedDocuments.length == this.documents.length) {
      this.sortRenderedDocuments();
      this.renderDocuments();
    }
  }
  renderDocuments() {
    const previewElm = this.previewElm?.nativeElement;
    if (previewElm != null) {
      this.renderedDocuments.forEach((document2) => {
        if (document2.image != null) {
          previewElm.appendChild(document2.image);
        } else if (document2.canvas != null) {
          previewElm.appendChild(document2.canvas);
        }
      });
    }
    this.renderingDocuments = false;
  }
  renderDocument(document2) {
    const apptDocument = this.apptDocuments.find((x) => x.document?.id == document2.id);
    if (apptDocument != null) {
      apptDocument.exportDocument(1, 1).then((canvas) => {
        const renderedDocument = {
          displayOrder: document2.displayOrder,
          name: document2.name,
          canvas,
          image: void 0
        };
        if (this.renderedDocuments != null) {
          this.renderedDocuments.push(renderedDocument);
        } else {
          this.renderedDocuments = [renderedDocument];
        }
        this.checkFinalizeRender();
      });
    }
  }
  reviewSignedDocuments() {
    if (this.appointment != null) {
      this.appointmentUiService.startSendingExecutedDocuments(this.appointment);
    }
  }
  sendDocumentsForSignature() {
    if (this.appointment != null) {
      this.appointmentUiService.startSendingDocuments(this.appointment);
    }
  }
  startSigningForCustomer() {
    if (this.appointment?.customer != null) {
      const customerName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
      this.appointmentUiService.startSigningDocuments(this.appointment, customerName, true);
    }
  }
  startSigningForConsultant() {
    if (this.appointment?.assignedTo != null) {
      const consultantName = `${this.appointment.assignedTo.firstName} ${this.appointment.assignedTo.lastName}`;
      this.appointmentUiService.startSigningDocuments(this.appointment, consultantName, true);
    }
  }
  get shops() {
    return this.appointment?.availableShops ?? [];
  }
  get shopValid() {
    return this.preferredShopId != null;
  }
  get shopDateValid() {
    return this.preferredInstallDateTimestamp == null || this.preferredInstallDateTimestamp > this.minInstallDate;
  }
  initShop() {
    this.preferredShopId = this.appointment?.selectedShopId;
    this.preferredInstallDateTimestamp = this.appointment?.preferredInstallDate;
  }
  updateShop() {
    if (this.appointment != null) {
      this.appointment.selectedShopId = this.preferredShopId;
      this.appointmentService.storeAppointment(this.appointment);
    }
  }
  updateInstallDate() {
    if (this.appointment != null) {
      this.appointment.preferredInstallDate = this.preferredInstallDateTimestamp;
      this.appointmentService.storeAppointment(this.appointment);
    }
  }
  // #endregion
  // #region Address
  get address() {
    return this.appointment?.property?.address;
  }
  // #endregion
  // #region Price
  get price() {
    return this.appointment?.customPrice ?? this.appointment?.price;
  }
  get showEstimateProcessing() {
    const progress = this.estimateProgress.getValue();
    return progress == 100;
  }
  get canSubmitEstimate() {
    return this.appointment != null && !this.submittingEstimate && this.canSubmitDocuments && this.canSubmitPayments && this.shopDateValid && this.shopValid && this.confirmed;
  }
  promptToStopSendingEstimate() {
    this.uiService.prompt("Don't Want to Wait?", "Your estimate may still be submitted. Are you sure you want to stop waiting?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.submittingEstimate = false;
          window.clearTimeout(this.estimateTimeout);
        }
      }
    });
  }
  submitEstimate() {
    return __async(this, null, function* () {
      if (!this.submittingEstimate && this.appointment != null && this.appointment.documentsValidForEstimate) {
        const appointment = this.appointment;
        this.submittingEstimate = true;
        setTimeout(() => __async(this, null, function* () {
          const pdfRender = yield this.contentService.documentRendersToPdf(this.renderedDocuments);
          this.estimateTimeout = window.setTimeout(() => {
            this.canStopSendingEstimate = true;
            this.uiService.prompt("Taking a While?", "Submitting the estimate seems to be taking a while. You may be on a poor connection or experiencing other issues. Do you want to cancel and try again later?", "Yes, Try Later", "No, Keep Waiting").subscribe({
              next: (confirmed) => {
                if (confirmed) {
                  this.submittingEstimate = false;
                }
              }
            });
          }, 45e3);
          this.estimateProgress.next(0);
          this.appointmentService.submitEstimate(appointment, pdfRender.pdf, pdfRender.documents, this.operationsNote, this.preferredShopId, this.preferredInstallDateTimestamp).subscribe({
            next: (e) => {
              if ("progress" in e) {
                this.estimateProgress.next(e.progress);
              } else {
                window.clearTimeout(this.estimateTimeout);
                this.uiService.prompt("Estimate Submitted", `You successfully submitted your estimate for Job ${appointment.jobId}. Thank you!`, "Ok").subscribe({
                  next: () => {
                    if (this.appointment != null) {
                      this.appointment.status = AppointmentStatus.Submitted;
                      this.appointmentService.storeAppointment(this.appointment);
                    }
                    this.closeView();
                    this.submittingEstimate = false;
                  }
                });
              }
            },
            error: () => {
              window.clearTimeout(this.estimateTimeout);
              this.uiService.prompt("Failed to Submit Estimate", "There was a problem submitting the estimate to NetSuite. Please try again later.", "Okay").subscribe({
                next: (confirmed) => {
                  this.submittingEstimate = false;
                  window.clearTimeout(this.estimateTimeout);
                }
              });
            }
          });
        }), 0);
      }
    });
  }
  toggleConfirmation() {
    this.confirmed = !this.confirmed;
  }
  closeView() {
    this.appointmentUiService.stopPreparingEstimate();
  }
  init() {
    if (this.appointment != null) {
      this.initAppointment();
    }
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.appointmentSubscription?.unsubscribe();
    this.documentSigningSubscription?.unsubscribe();
  }
};
_EstimateSubmissionComponent.\u0275fac = function EstimateSubmissionComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _EstimateSubmissionComponent)(\u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(AppointmentUiService), \u0275\u0275directiveInject(ContentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_EstimateSubmissionComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _EstimateSubmissionComponent, selectors: [["estimate-submission"]], viewQuery: function EstimateSubmissionComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
    \u0275\u0275viewQuery(_c1, 5);
    \u0275\u0275viewQuery(_c2, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.previewElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.exportElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.apptDocuments = _t);
  }
}, inputs: { appointment: "appointment" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 3, vars: 3, consts: [["previewElm", ""], ["exportElm", ""], ["apptDocument", ""], ["id", "estimateSubmission"], ["id", "submittingEstimate"], ["id", "renderingDocuments"], [1, "primary"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "preview-wrap"], [1, "render-wrap"], [1, "loader"], [1, "message"], [1, "secondary"], [1, "meta", "section"], [1, "customer"], [1, "job"], [1, "info"], [1, "price", "section"], [1, "operation-notes", "section"], [1, "form"], [1, "input-wrap"], [1, "input"], ["rows", "3", "placeholder", "Notes to Operations", 3, "ngModelChange", "ngModel"], [1, "shop", "section"], ["type", "date", 3, "ngModelChange", "blur", "ngModel", "min"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [1, "payments", "section"], [1, "value", "warning"], [1, "value"], [1, "control"], [1, "documents", "section"], [1, "control", "alternate"], [1, "control", "alternate", 3, "disabled"], [1, "control", 3, "disabled"], [1, "confirmation"], [1, "input-wrap", 3, "click"], [1, "fa-regular", "fa-circle", "unchecked"], [1, "fa-solid", "fa-circle-check", "checked"], [1, "control", "alternate", 3, "click", "disabled"], [1, "render"], [3, "fill"], [1, "control", 3, "click"], [1, "control", "alternate", 3, "click"], [1, "bg"], [1, "modal"], [1, "progress"], [1, "processing"], [3, "progress", "percent"], [1, "document"], [3, "appointmentContent", "appointment", "signing", "document"], [3, "rendered", "appointmentContent", "appointment", "signing", "document"]], template: function EstimateSubmissionComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, EstimateSubmissionComponent_Conditional_0_Template, 104, 34, "div", 3);
    \u0275\u0275conditionalCreate(1, EstimateSubmissionComponent_Conditional_1_Template, 11, 4, "aside", 4);
    \u0275\u0275conditionalCreate(2, EstimateSubmissionComponent_Conditional_2_Template, 5, 0, "aside", 5);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.appointment != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.submittingEstimate ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.appointment != null ? 2 : -1);
  }
}, dependencies: [AppointmentDocumentComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, LoaderComponent, NgModel, AsyncPipe, CurrencyPipe, PhoneFormatPipe], styles: ["\n\n#estimateSubmission[_ngcontent-%COMP%] {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 1.3vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color4Alt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%]    > .value.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  border-color: var(--color5);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus, \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .info[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.meta[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.price[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 3vw;\n  color: var(--success);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 100%;\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  flex: 1;\n  display: block;\n  font-size: 1.1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  text-align: right;\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--stronger);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.documents[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  width: calc(60% - 1vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 1;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     canvas, \n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .render-wrap[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]     img {\n  display: block;\n  width: 100%;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2-raw), 0.8);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 60%;\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .preview-wrap[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  width: 40%;\n  margin-left: 1vw;\n  padding-left: 1vw;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt3) solid;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  width: 3vw;\n  text-align: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 2.6vw;\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.unchecked[_ngcontent-%COMP%] {\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.checked[_ngcontent-%COMP%] {\n  display: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  flex: 1;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n  line-height: 1;\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.unchecked[_ngcontent-%COMP%] {\n  display: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .confirmation[_ngcontent-%COMP%]    > .input-wrap.checked[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   i.checked[_ngcontent-%COMP%] {\n  display: block;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding-bottom: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#estimateSubmission[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#loader[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: center;\n  margin: 2vw 0;\n}\n#loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 1s;\n}\n@-webkit-keyframes _ngcontent-%COMP%_estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: estimateModalLoadIn;\n  -ms-animation-name: estimateModalLoadIn;\n  -o-animation-name: estimateModalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_estimateModalLoadIn;\n  animation-name: _ngcontent-%COMP%_estimateModalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%] {\n  font-size: 4vw;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#submittingEstimate[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#renderingDocuments[_ngcontent-%COMP%] {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#renderingDocuments[_ngcontent-%COMP%]    > .document[_ngcontent-%COMP%]   appointment-document[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=estimate-submission.component.css.map */"] });
var EstimateSubmissionComponent = _EstimateSubmissionComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(EstimateSubmissionComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "estimate-submission", providers: [OrderByPipe], template: `@if (appointment != null) {
  <div id="estimateSubmission">
    <header>
      <div class="primary">
        <h3>
          Submit Job
        </h3>
      </div>
      <div class="controls">
        <button class="control" [disabled]="submittingEstimate" (click)="closeView()">
          <i class="fa-solid fa-xmark"></i>
        </button>
      </div>
    </header>
    <div class="content">
      <div class="primary">
        <header>
          <h4>Review Final Job Documents</h4>
        </header>
        <div class="preview-wrap">
          @if (hasDocumentsToPreview) {
            <div class="render-wrap">
              <div class="render" #previewElm></div>
            </div>
          }
          @if (showDocumentsLoader) {
            <div class="loader">
              <loader [fill]="false"></loader>
              <label>Preparing Documents</label>
            </div>
          }
          @if (!hasDocumentsToPreview) {
            <div class="message">
              <p>
                Please complete your documents before submitting the job.
              </p>
            </div>
          }
        </div>
      </div>
      <div class="secondary">
        <div class="meta section">
          @if (customer != null) {
            <div class="customer">
              <h3>{{customer.firstName}} {{customer.lastName}}</h3>
            </div>
          }
          <div class="job">
            <h4>Job {{appointment.jobId}}</h4>
          </div>
          @if (address != null) {
            <div class="info">
              <h4>{{address.friendlyAddress}}</h4>
            </div>
          }
          @if (customerEmail != null) {
            <div class="info">
              <h4>E-Mail: {{customerEmail}}</h4>
            </div>
          }
          @if (customerPhone != null) {
            <div class="info">
              <h4>Phone: {{customerPhone | phone}}</h4>
            </div>
          }
        </div>
        @if (price != null) {
          <div class="price section">
            <header>
              <div class="primary">
                <h4>Final Sales Price</h4>
              </div>
            </header>
            <div class="content">
              <span class="value">
                {{price.finalPrice | currency:'USD'}}
              </span>
            </div>
          </div>
        }
        <div class="operation-notes section">
          <header>
            <div class="primary">
              <H4>Operation Notes</H4>
            </div>
          </header>
          <div class="content">
            <div class="form">
              <div class="input-wrap">
                <div class="input">
                  <textarea rows="3" [(ngModel)]="operationsNote" placeholder="Notes to Operations"></textarea>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="shop section">
          <header>
            <div class="primary">
              <h4>Shop Information</h4>
            </div>
          </header>
          <div class="content">
            <div class="form">
              <div class="input-wrap" [class.invalid]="!shopDateValid">
                <label>Preferred Install Date</label>
                <div class="input">
                  <input
                    [(ngModel)]="preferredInstallDateTimestamp"
                    (blur)="updateInstallDate()"
                    [min]="minInstallDate" type="date" />
                </div>
                @if (!shopDateValid) {
                  <p class="message">
                    You have designated an invalid install date.
                  </p>
                }
              </div>
              <div class="input-wrap">
                <label>Preferred Shop</label>
                <div class="input">
                  <select [(ngModel)]="preferredShopId" (change)="updateShop()">
                    <option [ngValue]="undefined">-- Select a Shop</option>
                    @for (shop of shops; track shop) {
                      <option [ngValue]="shop.id">
                        {{shop.name}}
                        @if (shop.phoneNumber != null) {
                          - {{shop.phoneNumber | phone}}
                        }
                      </option>
                    }
                  </select>
                </div>
                @if (!shopValid) {
                  <p class="message">
                    You must specify a preferred shop.
                  </p>
                }
              </div>
            </div>
          </div>
        </div>
        <div class="payments section">
          <header>
            <div class="primary">
              <h4>Payments</h4>
              <h5>
                Status:
                @if (!canSubmitPayments) {
                  <span class="value warning">
                    Missing Payment Information
                  </span>
                }
                @if (canSubmitPayments) {
                  <span class="value">
                    Ready to Submit
                  </span>
                }
              </h5>
            </div>
            <div class="secondary">
              <div class="controls">
                @if (canManagePayments) {
                  <button class="control" (click)="managePayments()">
                    <label>Manage Payments</label>
                  </button>
                }
              </div>
            </div>
          </header>
          <div class="content">
          </div>
        </div>
        <div class="documents section">
          <header>
            <div class="primary">
              <h4>Document Review</h4>
              <h5>
                Status:
                @if (!canReviewDocuments) {
                  <span class="value warning">
                    Please Complete Payment Information
                  </span>
                }
                @if (showDocumentSignaturesMessage) {
                  <span class="value warning">
                    Awaiting Signatures
                  </span>
                }
                @if (showCustomerSignaturesMessage) {
                  <span class="value warning">
                    Awaiting Customer Signatures
                  </span>
                }
                @if (canSubmitDocuments) {
                  <span class="value">
                    Ready to Submit
                  </span>
                }
              </h5>
            </div>
            <div class="secondary">
              <div class="controls">
                @if (canSendForSignature) {
                  <button class="control alternate"
                    (click)="sendDocumentsForSignature()">
                    <label>Send for e-Signature</label>
                  </button>
                }
                @if (canSubmitDocuments) {
                  <button class="control alternate" [disabled]="!canSendDocumentsToCustomer" (click)="reviewSignedDocuments()">
                    <label>Save or Send Signed Copies</label>
                  </button>
                }
                @if (canSignDocuments) {
                  <button class="control" [disabled]="!canReviewDocuments" (click)="startSigningForCustomer()">
                    <label>Sign for Customer</label>
                  </button>
                }
                @if (canSignDocuments) {
                  <button class="control" [disabled]="!canReviewDocuments" (click)="startSigningForConsultant()">
                    <label>Sign for Consultant</label>
                  </button>
                }
              </div>
            </div>
          </header>
        </div>
      </div>
    </div>
    <div class="confirmation">
      <div class="input-wrap" [class.checked]="confirmed" (click)="toggleConfirmation()">
        <div class="input">
          <i class="fa-regular fa-circle unchecked"></i>
          <i class="fa-solid fa-circle-check checked"></i>
        </div>
        <label>Tap to confirm you have verified all information is accurate before submitting.</label>
      </div>
    </div>
    <div class="controls">
      <button class="control alternate" [disabled]="submittingEstimate" (click)="closeView()">
        <label>Cancel</label>
      </button>
      <button class="control" [disabled]="!canSubmitEstimate" (click)="submitEstimate()">
        <label>Submit Job</label>
      </button>
    </div>
  </div>
}

@if (submittingEstimate) {
  <aside id="submittingEstimate">
    <div class="bg"></div>
    <div class="modal">
      <button class="control" (click)="promptToStopSendingEstimate()">
        <i class="fa-solid fa-xmark"></i>
      </button>
      <div class="loader">
        @if (!showEstimateProcessing) {
          <span class="progress">{{estimateProgress | async}}%</span>
        }
        @if (showEstimateProcessing) {
          <span class="processing">Estimate Processing</span>
        }
        <loader [progress]="true" [percent]="estimateProgress"></loader>
      </div>
      <label>Preparing & Sending Estimate</label>
    </div>
  </aside>
}

@if (appointment != null) {
  <aside id="renderingDocuments">
    <div class="document" #exportElm>
      @for (document of documents; track document) {
        <appointment-document
          #apptDocument
          [appointmentContent]="content"
          [appointment]="appointment"
          [signing]="true"
          (rendered)="renderDocument(document)"
        [document]="document"></appointment-document>
      }
    </div>
  </aside>
}`, styles: ["/* src/app/shared/appointments/components/estimate-submission/estimate-submission.component.scss */\n#estimateSubmission {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#estimateSubmission > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#estimateSubmission > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission > header > .primary > h3 > .job {\n  color: var(--color5);\n}\n#estimateSubmission > header > .controls > .control {\n  cursor: pointer;\n}\n#estimateSubmission > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#estimateSubmission > .content {\n  flex: 1;\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#estimateSubmission > .content .section {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section > header {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#estimateSubmission > .content .section > header > .primary {\n  flex: 1;\n}\n#estimateSubmission > .content .section > header > .primary h4 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .content .section > header > .primary h5 {\n  line-height: 1;\n  font-size: 1.3vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#estimateSubmission > .content .section > header > .primary h5 > .value {\n  color: var(--color4Alt4);\n}\n#estimateSubmission > .content .section > header > .primary h5 > .value.warning {\n  color: var(--error);\n}\n#estimateSubmission > .content .section > header > .secondary > .controls {\n  display: flex;\n  flex-direction: column;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control > label {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control.alternate {\n  border-color: var(--color5);\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control.alternate > label {\n  color: var(--color5);\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission > .content .section > header > .secondary > .controls > .control:first-child {\n  margin-top: 0;\n}\n#estimateSubmission > .content .section > .content {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap {\n  margin-top: 0.5vw;\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input input,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input select,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input textarea {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.4vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input input:focus,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input select:focus,\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .input textarea:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission > .content .section > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#estimateSubmission > .content .section.meta > .customer h3 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.meta > .info {\n  margin-top: 0.25vw;\n}\n#estimateSubmission > .content .section.meta > .info h4 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.meta > .job {\n  margin-top: 0.25vw;\n}\n#estimateSubmission > .content .section.meta > .job h4 {\n  font-size: 1.6vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.price > .content > .value {\n  display: block;\n  font-size: 3vw;\n  color: var(--success);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#estimateSubmission > .content .section.payments {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission > .content .section.payments > .content {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail {\n  margin-top: 1vw;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .content {\n  width: 100%;\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .content > label {\n  flex: 1;\n  display: block;\n  font-size: 1.1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .content > .amount > .value {\n  display: block;\n  text-align: right;\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--stronger);\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#estimateSubmission > .content .section.payments > .content > .details > .detail:first-child {\n  margin-top: 0;\n}\n#estimateSubmission > .content .section.documents {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmission > .content .section:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#estimateSubmission > .content > .primary {\n  width: calc(60% - 1vw);\n  height: 100%;\n  position: relative;\n  background-color: var(--color1Alt3);\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission > .content > .primary > header {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: auto;\n  z-index: 1;\n  padding: 0.5vw;\n  background-color: var(--color1Alt4);\n}\n#estimateSubmission > .content > .primary > header h4 {\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-size: 1.2vw;\n  text-align: center;\n}\n#estimateSubmission > .content > .primary > .preview-wrap {\n  position: absolute;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  border-radius: 0.5vw;\n  overflow: hidden;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding-top: 1.8vw;\n  overflow-x: hidden;\n  background-color: var(--color2);\n  z-index: 0;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap > .render {\n  width: 100%;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap > .render ::ng-deep canvas,\n#estimateSubmission > .content > .primary > .preview-wrap > .render-wrap > .render ::ng-deep img {\n  display: block;\n  width: 100%;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .message {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2-raw), 0.8);\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .message > p {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 60%;\n  display: block;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .loader {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 5s;\n}\n#estimateSubmission > .content > .primary > .preview-wrap > .loader > label {\n  display: block;\n  text-align: center;\n  margin-top: 0.5vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n}\n#estimateSubmission > .content > .secondary {\n  width: 40%;\n  margin-left: 1vw;\n  padding-left: 1vw;\n}\n#estimateSubmission > .confirmation {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt3) solid;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission > .confirmation > .input-wrap {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#estimateSubmission > .confirmation > .input-wrap > .input {\n  width: 3vw;\n  text-align: center;\n}\n#estimateSubmission > .confirmation > .input-wrap > .input i {\n  font-size: 2.6vw;\n  color: var(--color1);\n}\n#estimateSubmission > .confirmation > .input-wrap > .input i.unchecked {\n  display: block;\n}\n#estimateSubmission > .confirmation > .input-wrap > .input i.checked {\n  display: none;\n}\n#estimateSubmission > .confirmation > .input-wrap > label {\n  flex: 1;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  margin-left: 0.5vw;\n  line-height: 1;\n  display: block;\n}\n#estimateSubmission > .confirmation > .input-wrap.checked > .input i {\n  font-size: 2vw;\n  color: var(--color1);\n}\n#estimateSubmission > .confirmation > .input-wrap.checked > .input i.unchecked {\n  display: none;\n}\n#estimateSubmission > .confirmation > .input-wrap.checked > .input i.checked {\n  display: block;\n}\n#estimateSubmission > .controls {\n  margin-top: 1vw;\n  padding-bottom: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#estimateSubmission > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#estimateSubmission > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#estimateSubmission > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#estimateSubmission > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#estimateSubmission > .controls > .control.success {\n  background-color: var(--success);\n}\n#estimateSubmission > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmission > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#estimateSubmission > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#estimateSubmission > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#estimateSubmission > .controls > .control:first-child {\n  margin-left: 0;\n}\n#loader {\n  display: flex;\n  justify-content: center;\n  margin: 2vw 0;\n}\n#loader > loader {\n  display: block;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 1s;\n}\n@-webkit-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes estimateModalLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n#submittingEstimate > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate > .modal {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: estimateModalLoadIn;\n  -ms-animation-name: estimateModalLoadIn;\n  -o-animation-name: estimateModalLoadIn;\n  -webkit-animation-name: estimateModalLoadIn;\n  animation-name: estimateModalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#submittingEstimate > .modal > .control {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#submittingEstimate > .modal > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#submittingEstimate > .modal > .loader {\n  position: relative;\n}\n#submittingEstimate > .modal > .loader > .progress,\n#submittingEstimate > .modal > .loader > .processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#submittingEstimate > .modal > .loader > .progress {\n  font-size: 4vw;\n}\n#submittingEstimate > .modal > .loader > .processing {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#submittingEstimate > .modal > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#submittingEstimate > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#renderingDocuments {\n  position: fixed;\n  bottom: 100%;\n  right: 100%;\n  width: 1200px;\n}\n#renderingDocuments > .document {\n  width: 100%;\n}\n#renderingDocuments > .document appointment-document {\n  display: block;\n  width: 100%;\n}\n/*# sourceMappingURL=estimate-submission.component.css.map */\n"] }]
  }], () => [{ type: AppointmentService }, { type: AppointmentUiService }, { type: ContentService }, { type: UiService }, { type: OrderByPipe }], { appointment: [{
    type: Input,
    args: ["appointment"]
  }], apptDocuments: [{
    type: ViewChildren,
    args: ["apptDocument"]
  }], previewElm: [{
    type: ViewChild,
    args: ["previewElm"]
  }], exportElm: [{
    type: ViewChild,
    args: ["exportElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(EstimateSubmissionComponent, { className: "EstimateSubmissionComponent" });
})();

// src/app/shared/appointments/components/appointment-signing/appointment-signing.component.ts
var _c05 = ["componentElm"];
function AppointmentSigningComponent_For_15_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div")(1, "appointment-document", 18);
    \u0275\u0275listener("changed", function AppointmentSigningComponent_For_15_Conditional_0_Template_appointment_document_changed_1_listener() {
      \u0275\u0275restoreView(_r2);
      const document_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.documentChanged(document_r3));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const document_r3 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("document-wrap ", document_r3.uiDirection));
    \u0275\u0275classProp("rendering", ctx_r3.finalizingDocument);
    \u0275\u0275advance();
    \u0275\u0275property("appointmentContent", ctx_r3.content)("appointment", ctx_r3.appointment)("signer", ctx_r3.signer)("execute", false)("document", document_r3);
  }
}
function AppointmentSigningComponent_For_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, AppointmentSigningComponent_For_15_Conditional_0_Template, 2, 10, "div", 17);
  }
  if (rf & 2) {
    const document_r3 = ctx.$implicit;
    \u0275\u0275conditional(document_r3.active ? 0 : -1);
  }
}
function AppointmentSigningComponent_Conditional_18_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 8)(1, "label");
    \u0275\u0275text(2, " Document is missing signatures. ");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSigningComponent_Conditional_30_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "signing-consent", 19);
    \u0275\u0275listener("close", function AppointmentSigningComponent_Conditional_30_Template_signing_consent_close_0_listener($event) {
      \u0275\u0275restoreView(_r5);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.finalizeConsent($event));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("consenters", ctx_r3.consenters);
  }
}
var _AppointmentSigningComponent = class _AppointmentSigningComponent {
  constructor(uiService, documentService, appointmentService, appointmentUiService, orderByPipe, changeDetector) {
    this.uiService = uiService;
    this.documentService = documentService;
    this.appointmentService = appointmentService;
    this.appointmentUiService = appointmentUiService;
    this.orderByPipe = orderByPipe;
    this.changeDetector = changeDetector;
    this.activeDocumentIndex = 0;
    this.finalizingDocument = false;
    this.customerFacing = false;
    this.retrievingDocuments = false;
    this.documents = [];
    this.consenting = false;
    this.consenters = new BehaviorSubject([]);
    this.backLabel = "Previous Document";
    this.forwardLabel = "Next Document";
    this.back = new Subject();
    this.previousDocumentAvailable = false;
    this.navigating = false;
    this.rendering = false;
    this.close = new Subject();
  }
  get customerName() {
    if (this.appointment?.customer != null) {
      return `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
    }
    return "";
  }
  generatePrice() {
    const price = this.appointment?.customPrice ?? this.appointment?.price;
    if (price) {
      return {
        details: price.details,
        customItems: price.customItems,
        price: price.finalPrice
      };
    }
    return void 0;
  }
  generatePayments() {
    const payments = [];
    if (this.appointment?.paymentSetting != null) {
      const details = this.orderByPipe.transform(this.appointment.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const payment = {
          description: detail.name,
          amount: detail.amount
        };
        payments.push(payment);
      });
    }
    return payments;
  }
  generateContent() {
    if (this.appointment != null) {
      const content = {
        appointmentId: this.appointment.id,
        created_Utc: this.appointment.scheduled_Utc,
        lastUpdated_Utc: /* @__PURE__ */ new Date(),
        scheduled_Utc: this.appointment.scheduled_Utc,
        property: this.appointment.property,
        jobId: this.appointment.jobId?.toString(),
        job: this.appointment.job,
        consultant: this.appointment.assignedTo,
        customer: this.appointment.customer,
        price: this.generatePrice(),
        documents: this.appointment.documents,
        payments: this.generatePayments(),
        recipient: void 0,
        completed: false
      };
      this.content = content;
    }
  }
  get canFinalizeDocument() {
    return this.activeDocument != null && this.activeDocument.validForExecution;
  }
  get canSendForSignature() {
    return this.activeDocument != null && !this.activeDocument.validForExecution;
  }
  get showMissingSignaturesWarning() {
    return !this.navigating && this.activeDocument != null && this.activeDocument.rendered && !this.activeDocument.validForExecution && this.activeDocument.checkedValidation;
  }
  finalizeDocument(promptOnSuccess = true) {
    return new Promise((res, rej) => {
      this.finalizingDocument = true;
      setTimeout(() => {
        const componentElm = this.componentElm?.nativeElement;
        if (this.activeDocument != null && componentElm != null) {
          const viewerElm = componentElm.querySelector(".render");
          if (viewerElm != null) {
            this.activeDocument.renderCanvas(viewerElm).then((b64) => {
              if (promptOnSuccess) {
                this.uiService.prompt("Document Finalized", "A finalized copy of the document was rendered and exported for storage.", "Ok").subscribe({
                  next: () => {
                    this.finalizingDocument = false;
                    res();
                  }
                });
              } else {
                this.finalizingDocument = false;
                res();
              }
            }).catch((e) => {
              this.uiService.prompt("Failed to Finalize", "There was an issue finalizing the document. Please try again or contact support.", "Ok").subscribe({
                next: () => {
                  this.finalizingDocument = false;
                  rej();
                }
              });
            });
          } else {
            rej();
          }
        }
      }, 32);
    });
  }
  promptToFinalizeDocument() {
    return new Promise((res, rej) => {
      if (this.canFinalizeDocument) {
        this.uiService.prompt("Finalize Document", `Finalizing the document will render an executed copy for storage with the appointment
                        and overwrite any previously finalized copy. Are you sure you want to continue?`, "Yes", "No").subscribe({
          next: (confirmed) => {
            if (confirmed) {
              this.finalizeDocument().then(() => res()).catch(() => rej());
            } else {
              rej();
            }
          }
        });
      }
    });
  }
  setActiveDocument(index2, direction = "forward") {
    window.clearTimeout(this.documentTimer);
    this.navigating = true;
    if (this.activeDocument != null) {
      switch (direction) {
        case "forward":
          {
            this.activeDocument.uiDirection = "loading-out";
          }
          break;
        case "reverse":
          {
            this.activeDocument.uiDirection = "loading-out-reverse";
          }
          break;
      }
    }
    const nextDocument = this.documents[index2];
    if (nextDocument != null) {
      switch (direction) {
        case "forward":
          {
            nextDocument.uiDirection = "loading-in";
          }
          break;
        case "reverse":
          {
            nextDocument.uiDirection = "loading-in-reverse";
          }
          break;
      }
      nextDocument.active = true;
    }
    this.documentTimer = window.setTimeout(() => {
      this.documents.forEach((document2) => {
        if (document2.id != nextDocument.id) {
          document2.active = false;
          document2.uiDirection = "";
        }
      });
      nextDocument.uiDirection = "loaded";
      this.activeDocument = nextDocument;
      this.activeDocumentIndex = index2;
      this.navigating = false;
      this.setNavigation();
    }, 500);
  }
  // #endregion
  // #region Send Final
  get showSendFinal() {
    return this.appointment?.documentsValidForEstimate ?? false;
  }
  promptToSendFinal() {
    if (this.appointment != null) {
      const clonedAppointment = this.appointmentService.cloneAppointment(this.appointment);
      if (clonedAppointment != null) {
        this.appointmentUiService.startSendingExecutedDocuments(clonedAppointment);
      }
    }
  }
  // #endregion
  // #region Send for Signatures
  get showSendSignatures() {
    return !this.appointment?.documentsValidForEstimate;
  }
  promptToSendToCustomer() {
    if (this.appointment != null) {
      const clonedAppointment = this.appointmentService.cloneAppointment(this.appointment);
      if (clonedAppointment != null) {
        this.appointmentUiService.startSendingDocuments(clonedAppointment);
      }
    }
  }
  get showDocumentLoader() {
    return this.finalizingDocument;
  }
  documentChanged(document2) {
    this.appointment?.changed$.next();
    this.documentService.updateSigners(this.documents);
    this.setNavigation();
  }
  generateSigners(document2) {
    const signers = [];
    let customerAdded = false;
    let consultantAdded = false;
    if (document2.mapping != null) {
      for (var i = 0, len = document2.mapping.pages.length; i < len; i++) {
        const page = document2.mapping.pages[i];
        for (var j = 0, jlen = page.fields.length; j < jlen; j++) {
          const field = page.fields[j];
          if ((field.id?.includes("initial.customer") || field.id?.includes("signature.customer")) && !customerAdded) {
            if (this.appointment?.customer != null) {
              const fullName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
              const email = this.appointment.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
              const phone = this.appointment.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
              const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
              signers.push(signer);
              customerAdded = true;
            }
          }
          if ((field.id?.includes("initial.consultant") || field.id?.includes("signature.consultant")) && !consultantAdded) {
            if (this.appointment?.assignedTo != null) {
              const fullName = `${this.appointment.assignedTo.firstName} ${this.appointment.assignedTo.lastName}`;
              const email = this.appointment.assignedTo.emailAddress;
              const phone = this.appointment.assignedTo.phone;
              const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
              signers.push(signer);
              consultantAdded = true;
            }
          }
        }
      }
    }
    if (document2.content != null) {
      if ((document2.content.includes("initial.customer") || document2.content.includes("signature.customer")) && !customerAdded) {
        if (this.appointment?.customer != null) {
          const fullName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
          const email = this.appointment.customer.contactInformation.find((x) => x.type == ContactInformationType.Email);
          const phone = this.appointment.customer.contactInformation.find((x) => x.type == ContactInformationType.CellPhone);
          const signer = new DocumentSigner(document2.id, fullName, false, phone?.value, email?.value, DocumentSignerType.Customer);
          signers.push(signer);
          customerAdded = true;
        }
      }
      if ((document2.content.includes("initial.consultant") || document2.content.includes("signature.consultant")) && !consultantAdded) {
        if (this.appointment?.assignedTo != null) {
          const fullName = `${this.appointment.assignedTo.firstName} ${this.appointment.assignedTo.lastName}`;
          const email = this.appointment.assignedTo.emailAddress;
          const phone = this.appointment.assignedTo.phone;
          const signer = new DocumentSigner(document2.id, fullName, false, phone, email, DocumentSignerType.Consultant);
          signers.push(signer);
          consultantAdded = true;
        }
      }
    }
    return signers;
  }
  initDocuments() {
    if (this.appointment != null) {
      let documents = [];
      for (var i = 0, len = this.appointment.documents.length; i < len; i++) {
        const document2 = this.appointment.documents[i];
        document2.active = false;
        if (document2.displayInSigning && (!this.customerFacing || document2.customerFacing)) {
          if (!document2.executed && document2.signers.length == 0) {
            document2.signers = this.generateSigners(document2);
          }
          documents.push(document2);
        }
      }
      documents = this.orderByPipe.transform(documents, "displayOrder", false);
      this.documents = documents;
      this.setActiveDocument(0);
      setTimeout(() => {
        this.verifyConsent();
      }, 0);
    }
  }
  finalizeConsent(consenters) {
    if (this.appointment != null) {
      for (var i = 0, len = consenters.length; i < len; i++) {
        const consenter = consenters[i];
        if (consenter.consented) {
          this.appointment.documents.forEach((document2) => {
            const existingConsenter = document2.signers.find((x) => x.fullName == consenter.fullName);
            if (existingConsenter == null) {
              document2.signers.push(consenter);
            }
          });
        }
      }
    }
    this.consenting = false;
    this.appointment?.changed$.next();
    const activeConsenter = consenters.find((x) => x.fullName == this.signer);
    if (activeConsenter != null && !activeConsenter.consented) {
      this.closeView();
    }
  }
  verifyConsent() {
    const consenters = [];
    for (var i = 0, len = this.documents.length; i < len; i++) {
      const document2 = this.documents[i];
      for (var j = 0, jlen = document2.signers.length; j < jlen; j++) {
        const signer = document2.signers[j];
        if (signer.consent == null) {
          const existingConsenter = consenters.find((x) => x.fullName == signer.fullName);
          if (existingConsenter == null && signer.fullName == this.signer) {
            consenters.push(signer);
          }
        }
      }
    }
    this.consenters.next(consenters);
    if (consenters.length > 0) {
      this.consenting = true;
    } else {
      this.consenting = false;
    }
  }
  // #endregion
  // #region Completion
  promptToCompleteDocuments() {
    if (this.appointment?.customer != null) {
      this.appointment.checkDocumentValidity();
      if (this.appointment != null) {
        this.appointmentService.storeAppointment(this.appointment);
      }
      this.closeView();
    }
  }
  get canGoForward() {
    return !this.navigating && !this.finalizingDocument && (this.activeDocument == null || this.activeDocument.rendered);
  }
  get canGoBack() {
    return !this.navigating && !this.finalizingDocument && this.previousDocumentAvailable;
  }
  setNavigation() {
    window.clearTimeout(this.navigationDebounce);
    this.navigationDebounce = window.setTimeout(() => {
      const nextDocument = this.documents[this.activeDocumentIndex + 1];
      if (nextDocument != null) {
        this.forwardLabel = "Next Document";
      } else {
        this.forwardLabel = "Complete Documents";
      }
      if (this.activeDocument != null) {
        const previousDocument = this.documents[this.activeDocumentIndex - 1];
        if (previousDocument != null) {
          this.previousDocumentAvailable = true;
        } else {
          this.previousDocumentAvailable = false;
        }
      }
    }, 0);
  }
  goBack() {
    const previousDocument = this.documents[this.activeDocumentIndex - 1];
    if (previousDocument != null) {
      this.setActiveDocument(this.activeDocumentIndex - 1, "reverse");
    } else {
      this.back.next();
    }
  }
  goForward() {
    const nextDocument = this.documents[this.activeDocumentIndex + 1];
    if (nextDocument != null) {
      if (this.activeDocument?.validForExecution) {
        this.finalizeDocument(false).then(() => {
          this.setActiveDocument(this.activeDocumentIndex + 1, "forward");
        });
      } else {
        this.setActiveDocument(this.activeDocumentIndex + 1, "forward");
      }
    } else {
      if (this.activeDocument?.validForExecution) {
        this.finalizeDocument(false).then(() => {
          this.promptToCompleteDocuments();
        });
      } else {
        this.promptToCompleteDocuments();
      }
    }
  }
  promptToCloseView() {
    if (this.appointment != null) {
      this.appointment.checkDocumentValidity();
      if (this.appointment.documentsValidForEstimate) {
        this.closeView();
      } else {
        this.uiService.prompt("Unfinished Documents", `There are still documents needing signatures. Are you sure you want to go back?`, "Yes", "No").subscribe({
          next: (confirmed) => {
            if (confirmed) {
              this.closeView();
            }
          }
        });
      }
    }
  }
  closeView() {
    this.appointmentUiService.stopSigningDocuments();
  }
  init() {
    this.generateContent();
    this.initDocuments();
    this.setNavigation();
    setTimeout(() => {
      this.changeDetector.detectChanges();
    }, 0);
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_AppointmentSigningComponent.\u0275fac = function AppointmentSigningComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentSigningComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(AppointmentUiService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(ChangeDetectorRef));
};
_AppointmentSigningComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentSigningComponent, selectors: [["appointment-signing"]], viewQuery: function AppointmentSigningComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c05, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", signer: "signer", customerFacing: "customerFacing" }, outputs: { back: "back", close: "close" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 31, vars: 13, consts: [["componentElm", ""], ["id", "appointmentDocuments"], [1, "primary"], [1, "secondary"], [1, "close-control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "documents"], [1, "meta"], [1, "validation"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], ["id", "consent"], [1, "bg"], [3, "consenters"], [3, "class", "rendering"], [3, "changed", "appointmentContent", "appointment", "signer", "execute", "document"], [3, "close", "consenters"]], template: function AppointmentSigningComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "main", 1, 0)(2, "header")(3, "div", 2)(4, "h3");
    \u0275\u0275text(5, " Signing Documents for ");
    \u0275\u0275elementStart(6, "em");
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(8, "h4");
    \u0275\u0275text(9);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "div", 3)(11, "button", 4);
    \u0275\u0275listener("click", function AppointmentSigningComponent_Template_button_click_11_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.promptToCloseView());
    });
    \u0275\u0275element(12, "i", 5);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(13, "div", 6);
    \u0275\u0275repeaterCreate(14, AppointmentSigningComponent_For_15_Template, 1, 1, null, null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(16, "div", 7)(17, "div", 2);
    \u0275\u0275conditionalCreate(18, AppointmentSigningComponent_Conditional_18_Template, 3, 0, "div", 8);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(19, "div", 9)(20, "button", 10);
    \u0275\u0275listener("click", function AppointmentSigningComponent_Template_button_click_20_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goBack());
    });
    \u0275\u0275element(21, "i", 11);
    \u0275\u0275elementStart(22, "label");
    \u0275\u0275text(23);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "button", 12);
    \u0275\u0275listener("click", function AppointmentSigningComponent_Template_button_click_24_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goForward());
    });
    \u0275\u0275element(25, "i", 13);
    \u0275\u0275elementStart(26, "label");
    \u0275\u0275text(27);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(28, "aside", 14);
    \u0275\u0275element(29, "div", 15);
    \u0275\u0275conditionalCreate(30, AppointmentSigningComponent_Conditional_30_Template, 1, 1, "signing-consent", 16);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate2("", ctx.appointment == null ? null : ctx.appointment.jobId, " - ", ctx.customerName);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" Signer: ", ctx.signer, " ");
    \u0275\u0275advance(4);
    \u0275\u0275classProp("rendering", ctx.finalizingDocument);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.documents);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx.showMissingSignaturesWarning ? 18 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canGoBack);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.backLabel);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canGoForward);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.forwardLabel);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.consenting);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.consenting ? 30 : -1);
  }
}, dependencies: [AppointmentDocumentComponent, ConsentComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-moz-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-o-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-moz-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-o-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n#appointmentDocuments[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: 0 1vw 1vw;\n  display: flex;\n  flex-direction: column;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2Alt1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%]    > em[_ngcontent-%COMP%] {\n  font-style: normal;\n  color: var(--color5Alt1);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  line-height: 1;\n  font-weight: var(--ltweight);\n  color: var(--color4Alt2);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  position: relative;\n  display: flex;\n  align-items: center;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  border: 0.1vw var(--color2) solid;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls.execution[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 100%;\n  right: 0;\n  margin-top: 0.25vw;\n  width: 100%;\n  color: var(--color2Alt2);\n  font-size: 0.6vw;\n  pointer-events: none;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .close-control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .close-control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%] {\n  flex: 1;\n  position: relative;\n  border: 0.1vw var(--color1Alt1) solid;\n  border-radius: 0.25vw;\n  background-color: var(--color1Alt5);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 2vw;\n  right: 2vw;\n  bottom: 0;\n  overflow-x: hidden;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-in[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadIn;\n  -ms-animation-name: documentLoadIn;\n  -o-animation-name: documentLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadIn;\n  animation-name: _ngcontent-%COMP%_documentLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-out[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadOut;\n  -ms-animation-name: documentLoadOut;\n  -o-animation-name: documentLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadOut;\n  animation-name: _ngcontent-%COMP%_documentLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-in-reverse[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadInReverse;\n  -ms-animation-name: documentLoadInReverse;\n  -o-animation-name: documentLoadInReverse;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadInReverse;\n  animation-name: _ngcontent-%COMP%_documentLoadInReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap.loading-out-reverse[_ngcontent-%COMP%] {\n  -moz-animation-name: documentLoadOutReverse;\n  -ms-animation-name: documentLoadOutReverse;\n  -o-animation-name: documentLoadOutReverse;\n  -webkit-animation-name: _ngcontent-%COMP%_documentLoadOutReverse;\n  animation-name: _ngcontent-%COMP%_documentLoadOutReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > .document-wrap[_ngcontent-%COMP%]     .document {\n  opacity: 1;\n  background-color: var(--color2);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents.rendering[_ngcontent-%COMP%]     .document {\n  opacity: 0.4;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents.rendering[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  pointer-events: none;\n  display: block;\n  position: absolute;\n  right: 1vw;\n  bottom: 1vw;\n  z-index: 1;\n  width: 5vw;\n  height: 5vw;\n  --fillSpeed: 1s;\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 0 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .validation[_ngcontent-%COMP%] {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.35vw 0.75vw;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .validation[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#appointmentDocuments[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n#consent[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#consent[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#consent.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#consent.active[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#consent.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#consent.closing[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=appointment-signing.component.css.map */"] });
var AppointmentSigningComponent = _AppointmentSigningComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentSigningComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "appointment-signing", providers: [OrderByPipe], template: '<main id="appointmentDocuments" #componentElm>\n  <header>\n    <div class="primary">\n      <h3>\n        Signing Documents for <em>{{appointment?.jobId}} - {{customerName}}</em>\n      </h3>\n      <h4>\n        Signer: {{signer}}\n      </h4>\n    </div>\n    <div class="secondary">\n      <button class="close-control" (click)="promptToCloseView()">\n        <i class="fa-solid fa-xmark"></i>\n      </button>\n    </div>\n  </header>\n  <div class="documents"\n    [class.rendering]="finalizingDocument">\n    @for (document of documents; track document) {\n      @if (document.active) {\n        <div\n          class="document-wrap {{document.uiDirection}}"\n          [class.rendering]="finalizingDocument"\n          >\n          <appointment-document\n            (changed)="documentChanged(document)"\n            [appointmentContent]="content"\n            [appointment]="appointment"\n            [signer]="signer"\n            [execute]="false"\n          [document]="document"></appointment-document>\n        </div>\n      }\n    }\n  </div>\n  <div class="meta">\n    <div class="primary">\n      @if (showMissingSignaturesWarning) {\n        <div class="validation">\n          <label>\n            Document is missing signatures.\n          </label>\n        </div>\n      }\n    </div>\n    <div class="controls">\n      <button class="control" [disabled]="!canGoBack" (click)="goBack()">\n        <i class="fa-solid fa-arrow-left-long"></i>\n        <label>{{backLabel}}</label>\n      </button>\n      <button class="control success" [disabled]="!canGoForward" (click)="goForward()">\n        <i class="fa-solid fa-arrow-right-long"></i>\n        <label>{{forwardLabel}}</label>\n      </button>\n    </div>\n  </div>\n</main>\n\n<aside id="consent" [class.active]="consenting">\n  <div class="bg"></div>\n  @if (consenting) {\n    <signing-consent\n      [consenters]="consenters"\n    (close)="finalizeConsent($event)"></signing-consent>\n  }\n</aside>', styles: ["/* src/app/shared/appointments/components/appointment-signing/appointment-signing.component.scss */\n@-webkit-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes documentLoadIn {\n  0% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-moz-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-o-keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@keyframes documentLoadOut {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n}\n@-webkit-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-moz-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-o-keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@keyframes documentLoadOutReverse {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(100vw);\n    -ms-transform: translateX(100vw);\n    -o-transform: translateX(100vw);\n    -webkit-transform: translateX(100vw);\n    transform: translateX(100vw);\n  }\n}\n@-webkit-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes documentLoadInReverse {\n  0% {\n    -moz-transform: translateX(-100vw);\n    -ms-transform: translateX(-100vw);\n    -o-transform: translateX(-100vw);\n    -webkit-transform: translateX(-100vw);\n    transform: translateX(-100vw);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n#appointmentDocuments {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: 0 1vw 1vw;\n  display: flex;\n  flex-direction: column;\n}\n#appointmentDocuments > header {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#appointmentDocuments > header > .primary h3 {\n  font-size: 1.2vw;\n  color: var(--color2Alt1);\n  font-weight: var(--stdweight);\n  text-transform: uppercase;\n}\n#appointmentDocuments > header > .primary h3 > em {\n  font-style: normal;\n  color: var(--color5Alt1);\n}\n#appointmentDocuments > header > .primary h4 {\n  font-size: 2vw;\n  line-height: 1;\n  font-weight: var(--ltweight);\n  color: var(--color4Alt2);\n}\n#appointmentDocuments > header > .secondary {\n  display: flex;\n  align-items: center;\n}\n#appointmentDocuments > header > .secondary > .controls {\n  margin-left: 1vw;\n  position: relative;\n  display: flex;\n  align-items: center;\n}\n#appointmentDocuments > header > .secondary > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  border: 0.1vw var(--color2) solid;\n}\n#appointmentDocuments > header > .secondary > .controls > .control > i:last-child,\n#appointmentDocuments > header > .secondary > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#appointmentDocuments > header > .secondary > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#appointmentDocuments > header > .secondary > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDocuments > header > .secondary > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentDocuments > header > .secondary > .controls > .control:first-child {\n  margin-left: 0;\n}\n#appointmentDocuments > header > .secondary > .controls.execution > .meta {\n  position: absolute;\n  top: 100%;\n  right: 0;\n  margin-top: 0.25vw;\n  width: 100%;\n  color: var(--color2Alt2);\n  font-size: 0.6vw;\n  pointer-events: none;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#appointmentDocuments > header > .secondary > .controls:first-child {\n  margin-left: 0;\n}\n#appointmentDocuments > header > .secondary > .close-control {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#appointmentDocuments > header > .secondary > .close-control > i {\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#appointmentDocuments > .documents {\n  flex: 1;\n  position: relative;\n  border: 0.1vw var(--color1Alt1) solid;\n  border-radius: 0.25vw;\n  background-color: var(--color1Alt5);\n}\n#appointmentDocuments > .documents > .document-wrap {\n  position: absolute;\n  top: 0;\n  left: 2vw;\n  right: 2vw;\n  bottom: 0;\n  overflow-x: hidden;\n}\n#appointmentDocuments > .documents > .document-wrap.loading-in {\n  -moz-animation-name: documentLoadIn;\n  -ms-animation-name: documentLoadIn;\n  -o-animation-name: documentLoadIn;\n  -webkit-animation-name: documentLoadIn;\n  animation-name: documentLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments > .documents > .document-wrap.loading-out {\n  -moz-animation-name: documentLoadOut;\n  -ms-animation-name: documentLoadOut;\n  -o-animation-name: documentLoadOut;\n  -webkit-animation-name: documentLoadOut;\n  animation-name: documentLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments > .documents > .document-wrap.loading-in-reverse {\n  -moz-animation-name: documentLoadInReverse;\n  -ms-animation-name: documentLoadInReverse;\n  -o-animation-name: documentLoadInReverse;\n  -webkit-animation-name: documentLoadInReverse;\n  animation-name: documentLoadInReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments > .documents > .document-wrap.loading-out-reverse {\n  -moz-animation-name: documentLoadOutReverse;\n  -ms-animation-name: documentLoadOutReverse;\n  -o-animation-name: documentLoadOutReverse;\n  -webkit-animation-name: documentLoadOutReverse;\n  animation-name: documentLoadOutReverse;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeOutQuad);\n  -ms-animation-timing-function: var(--easeOutQuad);\n  -o-animation-timing-function: var(--easeOutQuad);\n  -webkit-animation-timing-function: var(--easeOutQuad);\n  animation-timing-function: var(--easeOutQuad);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  pointer-events: none;\n}\n#appointmentDocuments > .documents > .document-wrap ::ng-deep .document {\n  opacity: 1;\n  background-color: var(--color2);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentDocuments > .documents.rendering ::ng-deep .document {\n  opacity: 0.4;\n}\n#appointmentDocuments > .documents.rendering > loader {\n  opacity: 1;\n}\n#appointmentDocuments > .documents > loader {\n  pointer-events: none;\n  display: block;\n  position: absolute;\n  right: 1vw;\n  bottom: 1vw;\n  z-index: 1;\n  width: 5vw;\n  height: 5vw;\n  --fillSpeed: 1s;\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentDocuments > .meta {\n  margin-top: 1vw;\n  padding: 0 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#appointmentDocuments > .meta > .primary > .validation {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.35vw 0.75vw;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#appointmentDocuments > .meta > .primary > .validation label {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#appointmentDocuments > .meta > .controls {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#appointmentDocuments > .meta > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentDocuments > .meta > .controls > .control > i:last-child,\n#appointmentDocuments > .meta > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#appointmentDocuments > .meta > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#appointmentDocuments > .meta > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentDocuments > .meta > .controls > .control.success {\n  background-color: var(--success);\n}\n#appointmentDocuments > .meta > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#appointmentDocuments > .meta > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#appointmentDocuments > .meta > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentDocuments > .meta > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#appointmentDocuments > .meta > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#appointmentDocuments > .meta > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#appointmentDocuments > .meta > .controls > .control:first-child {\n  margin-left: 0;\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n#consent {\n  pointer-events: none;\n}\n#consent > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent > signing-consent {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent.active {\n  pointer-events: initial;\n}\n#consent.active > .bg {\n  opacity: 1;\n}\n#consent.active > signing-consent {\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#consent.closing > .bg {\n  opacity: 0;\n}\n#consent.closing > signing-consent {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=appointment-signing.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: DocumentService }, { type: AppointmentService }, { type: AppointmentUiService }, { type: OrderByPipe }, { type: ChangeDetectorRef }], { appointment: [{
    type: Input
  }], signer: [{
    type: Input,
    args: ["signer"]
  }], customerFacing: [{
    type: Input,
    args: ["customerFacing"]
  }], back: [{
    type: Output,
    args: ["back"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AppointmentSigningComponent, { className: "AppointmentSigningComponent" });
})();

// src/app/shared/appointments/components/appointment-summary/appointment-summary.component.ts
var import_leaflet = __toESM(require_leaflet_src());
var _c06 = ["componentElm"];
function AppointmentSummaryComponent_Conditional_0_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 7)(1, "h3");
    \u0275\u0275text(2, "Emergency");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 10);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate2(" ", ctx_r0.address.city, ", ", ctx_r0.address.regionIso3166, " ");
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "label");
    \u0275\u0275text(2, "Price:");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 13);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "currency");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(5, 1, ctx_r0.displayPrice, "USD"), " ");
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1, " Accepted ");
    \u0275\u0275elementEnd();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_24_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1, " Not Accepted ");
    \u0275\u0275elementEnd();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 16);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "date");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" on ", \u0275\u0275pipeBind2(2, 1, ctx_r0.appointment.accepted_Utc, "MMM dd, yyyy h:mm a"), " ");
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_26_For_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 23);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r2 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", item_r2, " ");
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 17)(1, "label");
    \u0275\u0275text(2, " Attachment Items: ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 22);
    \u0275\u0275repeaterCreate(4, AppointmentSummaryComponent_Conditional_0_Conditional_26_For_5_Template, 2, 1, "span", 23, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx_r0.attachmentItems);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_27_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 25)(1, "p", 13);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r0.dispositionStatus.note);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_27_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 18)(1, "label");
    \u0275\u0275text(2, " Disposition Status ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 24)(4, "span", 13);
    \u0275\u0275text(5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "span", 20);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(9, AppointmentSummaryComponent_Conditional_0_Conditional_27_Conditional_9_Template, 3, 1, "div", 25);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(ctx_r0.dispositionStatus.name);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" on ", \u0275\u0275pipeBind2(8, 3, ctx_r0.dispositionStatus.created_Utc, "MMM dd, yyyy h:mm a"));
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r0.dispositionStatus.note != null ? 9 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 32);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.acceptAppointment());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Accept");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(4);
    \u0275\u0275property("disabled", ctx_r0.acceptingAppointment);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.goToAppointment(ctx_r0.appointment.id));
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Open");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 31)(1, "p");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_3_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.promptToGoToAppointment(ctx_r0.outstandingAppointmentId));
    });
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, "Go to Appointment");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(4);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r0.openStatus, " ");
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 21);
    \u0275\u0275conditionalCreate(1, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_1_Template, 3, 1, "button", 29);
    \u0275\u0275conditionalCreate(2, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_2_Template, 3, 0, "button", 30);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(3, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Conditional_3_Template, 6, 1, "div", 31);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.canAccept ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.canOpen ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.showOpenWarning ? 3 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 21)(1, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_1_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r7);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.goToAppointment(ctx_r0.appointment.id));
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Open");
    \u0275\u0275elementEnd()()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_2_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 34);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_2_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.promptToReopenAppointment());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Reopen");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 21);
    \u0275\u0275conditionalCreate(1, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_2_Conditional_1_Template, 3, 0, "button", 33);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.canReopenAppointment ? 1 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_3_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 34);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_3_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.promptToReopenAppointment());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Reopen");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 21);
    \u0275\u0275conditionalCreate(1, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_3_Conditional_1_Template, 3, 0, "button", 33);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.canReopenAppointment ? 1 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 21)(1, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_4_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.viewDetails());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "View Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "button", 34);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_4_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.sendDocumentsForSignature());
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6, "Send for E-Signature");
    \u0275\u0275elementEnd()()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_5_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 34);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_5_Conditional_4_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r12);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.promptToPrepareEstimate());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Submit Job");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 21)(1, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_5_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.viewDetails());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "View Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(4, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_5_Conditional_4_Template, 3, 0, "button", 33);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx_r0.canPrepareEstimate ? 4 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_6_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 34);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_6_Conditional_4_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r0 = \u0275\u0275nextContext(4);
      return \u0275\u0275resetView(ctx_r0.promptToPrepareEstimate());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Prepare Estimate");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 21)(1, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_6_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r13);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.viewDetails());
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "View Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(4, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_6_Conditional_4_Template, 3, 0, "button", 33);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx_r0.canPrepareEstimate ? 4 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_35_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275conditionalCreate(0, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_0_Template, 4, 3);
    \u0275\u0275conditionalCreate(1, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_1_Template, 4, 0, "div", 21);
    \u0275\u0275conditionalCreate(2, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_2_Template, 2, 1, "div", 21);
    \u0275\u0275conditionalCreate(3, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_3_Template, 2, 1, "div", 21);
    \u0275\u0275conditionalCreate(4, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_4_Template, 7, 0, "div", 21);
    \u0275\u0275conditionalCreate(5, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_5_Template, 5, 1, "div", 21);
    \u0275\u0275conditionalCreate(6, AppointmentSummaryComponent_Conditional_0_Conditional_35_Conditional_6_Template, 5, 1, "div", 21);
    \u0275\u0275elementStart(7, "div", 26)(8, "div", 27)(9, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.remoteExportAppointment());
    });
    \u0275\u0275elementStart(10, "label");
    \u0275\u0275text(11, "Export to Server");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(12, "div", 27)(13, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_35_Template_button_click_13_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.exportAppointment());
    });
    \u0275\u0275elementStart(14, "label");
    \u0275\u0275text(15, "Export to Device");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.Open ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.InProgress ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.Dispositioned ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.Canceled ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.PendingSignatures ? 4 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.PendingSubmission ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.Submitted ? 6 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_36_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r16 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_36_Conditional_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r16);
      const ctx_r0 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r0.viewDetails());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "View Details");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentSummaryComponent_Conditional_0_Conditional_36_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 21);
    \u0275\u0275conditionalCreate(1, AppointmentSummaryComponent_Conditional_0_Conditional_36_Conditional_1_Template, 3, 0, "button", 30);
    \u0275\u0275elementStart(2, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_0_Conditional_36_Template_button_click_2_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r0 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r0.goToAppointment(ctx_r0.appointment.id));
    });
    \u0275\u0275elementStart(3, "label");
    \u0275\u0275text(4, "Open");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.status == ctx_r0.AppointmentStatus.Submitted ? 1 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 2);
    \u0275\u0275element(2, "canvas", 3)(3, "div", 4);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "div", 5)(5, "div", 6);
    \u0275\u0275conditionalCreate(6, AppointmentSummaryComponent_Conditional_0_Conditional_6_Template, 3, 0, "div", 7);
    \u0275\u0275elementStart(7, "div", 8)(8, "h2");
    \u0275\u0275text(9);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "div", 9);
    \u0275\u0275conditionalCreate(11, AppointmentSummaryComponent_Conditional_0_Conditional_11_Template, 2, 2, "span", 10);
    \u0275\u0275text(12, " on ");
    \u0275\u0275elementStart(13, "span", 11);
    \u0275\u0275text(14);
    \u0275\u0275pipe(15, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "div", 12)(17, "label");
    \u0275\u0275text(18, "Job:");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(19, "span", 13);
    \u0275\u0275text(20);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(21, AppointmentSummaryComponent_Conditional_0_Conditional_21_Template, 6, 4, "div", 14);
    \u0275\u0275elementStart(22, "div", 15);
    \u0275\u0275conditionalCreate(23, AppointmentSummaryComponent_Conditional_0_Conditional_23_Template, 2, 0, "label");
    \u0275\u0275conditionalCreate(24, AppointmentSummaryComponent_Conditional_0_Conditional_24_Template, 2, 0, "label");
    \u0275\u0275conditionalCreate(25, AppointmentSummaryComponent_Conditional_0_Conditional_25_Template, 3, 4, "span", 16);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(26, AppointmentSummaryComponent_Conditional_0_Conditional_26_Template, 6, 0, "div", 17);
    \u0275\u0275conditionalCreate(27, AppointmentSummaryComponent_Conditional_0_Conditional_27_Template, 10, 6, "div", 18);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "div", 19)(29, "div")(30, "span", 13);
    \u0275\u0275text(31);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "span", 20);
    \u0275\u0275text(33);
    \u0275\u0275pipe(34, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(35, AppointmentSummaryComponent_Conditional_0_Conditional_35_Template, 16, 7);
    \u0275\u0275conditionalCreate(36, AppointmentSummaryComponent_Conditional_0_Conditional_36_Template, 5, 1, "div", 21);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx_r0.mapRendered);
    \u0275\u0275attribute("id", ctx_r0.mapElmId);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r0.appointment.isEmergency ? 6 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate2("", ctx_r0.customer == null ? null : ctx_r0.customer.firstName, " ", ctx_r0.customer == null ? null : ctx_r0.customer.lastName);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r0.address != null ? 11 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(15, 24, ctx_r0.appointment.scheduled_Utc, "MMM dd, yyyy h:mm a"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", ctx_r0.appointment.jobId, " ");
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.hasPrice ? 21 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("accepted", ctx_r0.accepted);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.accepted ? 23 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r0.accepted ? 24 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.appointment.accepted_Utc != null && ctx_r0.accepted ? 25 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.hasAttachmentItems ? 26 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.dispositionStatus != null ? 27 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("status ", ctx_r0.appointment.status));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r0.status, " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" on ", \u0275\u0275pipeBind2(34, 27, ctx_r0.appointment.lastUpdated_Utc, "MM/dd/yyyy @ h:mm a"), " ");
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx_r0.management ? 35 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.management ? 36 : -1);
  }
}
function AppointmentSummaryComponent_Conditional_1_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 40);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "async");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(2, 1, ctx_r0.exportProgress), "%");
  }
}
function AppointmentSummaryComponent_Conditional_1_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 41);
    \u0275\u0275text(1, "Processing");
    \u0275\u0275elementEnd();
  }
}
function AppointmentSummaryComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "aside", 35);
    \u0275\u0275element(1, "div", 36);
    \u0275\u0275elementStart(2, "div", 37)(3, "button", 28);
    \u0275\u0275listener("click", function AppointmentSummaryComponent_Conditional_1_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r17);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.promptToStopExporting());
    });
    \u0275\u0275element(4, "i", 38);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 39);
    \u0275\u0275conditionalCreate(6, AppointmentSummaryComponent_Conditional_1_Conditional_6_Template, 3, 3, "span", 40);
    \u0275\u0275conditionalCreate(7, AppointmentSummaryComponent_Conditional_1_Conditional_7_Template, 2, 0, "span", 41);
    \u0275\u0275element(8, "loader", 42);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Preparing & Exporting Appointment");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r0.closingExportAppointment);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx_r0.showExportProgress ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r0.showExportProgress ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("progress", true)("percent", ctx_r0.exportProgress);
  }
}
var _AppointmentSummaryComponent = class _AppointmentSummaryComponent {
  constructor(uiService, appointmentService, appointmentUiService, authRefService, deviceRouteService, orderByPipe, datePipe, contentService) {
    this.uiService = uiService;
    this.appointmentService = appointmentService;
    this.appointmentUiService = appointmentUiService;
    this.authRefService = authRefService;
    this.deviceRouteService = deviceRouteService;
    this.orderByPipe = orderByPipe;
    this.datePipe = datePipe;
    this.contentService = contentService;
    this.AppointmentStatus = AppointmentStatus;
    this.exportingAppointment = false;
    this.closingExportAppointment = false;
    this.exportProgress = new BehaviorSubject(0);
    this.showExportProgress = true;
    this.activeUser = null;
    this.displayPrice = 0;
    this.mapRendered = false;
    this.acceptingAppointment = false;
    this.canOpen = false;
    this.initializedOpen = false;
    this.attachmentItems = [];
    this.management = false;
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.activeUser != null && this.appointment?.assignedTo != null && this.activeUser.id == this.appointment.assignedTo.id;
  }
  get status() {
    if (this.appointment != null) {
      switch (this.appointment.status) {
        case AppointmentStatus.Canceled:
          return "Canceled";
        case AppointmentStatus.Dispositioned:
          return "Dispositioned";
        case AppointmentStatus.InProgress:
          return "In Progress";
        case AppointmentStatus.Open:
          return "Open";
        case AppointmentStatus.PendingSubmission:
          return "Waiting to Submit";
        case AppointmentStatus.Submitted:
          return "Submitted";
        case AppointmentStatus.PendingSignatures:
          return "Awaiting Customer Signatures";
      }
    }
    return void 0;
  }
  remoteExportAppointment() {
    if (this.appointment != null) {
      const appointment = this.appointment;
      if (!this.exportingAppointment) {
        this.uiService.prompt("Manually Sync Appointment", "Manually syncing appointment is intended for support situations and may take a moment to complete. Are you sure you want to manually sync?", "Yes", "No").subscribe({
          next: (confirmed) => {
            if (confirmed) {
              this.exportingAppointment = true;
              this.exportingTimeout = window.setTimeout(() => {
                this.uiService.prompt("Taking a While?", "Sending the quote seems to be taking a while. You may be on a poor connection or experiencing other issues. Do you want to cancel and try again later?", "Yes, Try Later", "No, Keep Waiting").subscribe({
                  next: (confirmed2) => {
                    if (confirmed2) {
                      this.stopExportingAppointment();
                    }
                  }
                });
              }, 45e3);
              setTimeout(() => {
                const jobId = `${appointment.jobId}`;
                const fileName = `${jobId}-${(/* @__PURE__ */ new Date()).toISOString()}`;
                this.contentService.compressData(appointment, `${fileName}.json`).then((compressedAppointment) => {
                  this.appointmentService.remoteExportAppointment(jobId, compressedAppointment).subscribe({
                    next: (e) => {
                      if ("progress" in e) {
                        this.exportProgress.next(e.progress);
                        if (e.progress == 100) {
                          this.showExportProgress = false;
                        } else {
                          this.showExportProgress = true;
                        }
                      } else {
                        window.clearTimeout(this.exportingTimeout);
                        this.stopExportingAppointment();
                        this.uiService.prompt("Appointment Synced", "The appointment data was successfully synced.", "Okay").subscribe({
                          next: () => {
                          }
                        });
                      }
                    },
                    error: () => {
                      window.clearTimeout(this.exportingTimeout);
                      this.uiService.prompt("Failed to Sync", "There was an issue syncing your appointment. Please try again or to contact support.", "Okay").subscribe({
                        next: () => {
                          this.stopExportingAppointment();
                        }
                      });
                    }
                  });
                });
              }, 16);
            } else {
              this.stopExportingAppointment();
            }
          }
        });
      }
    }
  }
  promptToStopExporting() {
    this.uiService.prompt("Don't Want to Wait?", "Your appointment export may stillb e sent. Are you sure you want to stop waiting?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.stopExportingAppointment();
        }
      }
    });
  }
  stopExportingAppointment() {
    window.clearTimeout(this.exportingTimer);
    this.closingExportAppointment = true;
    this.exportingTimer = window.setTimeout(() => {
      this.exportingAppointment = false;
      this.closingExportAppointment = false;
      this.showExportProgress = true;
      this.exportProgress.next(0);
    }, 250);
  }
  exportAppointment() {
    return __async(this, null, function* () {
      if (this.appointment != null && !this.exportingAppointment) {
        const appointment = this.appointment;
        this.uiService.prompt("Export Appointment to Device?", "Exporting the raw appointment data is intended for support scenarios. Are you sure you want to export the appointment data to your device?", "Yes", "No").subscribe({
          next: (confirmed) => __async(this, null, function* () {
            if (confirmed) {
              this.exportingAppointment = true;
              setTimeout(() => {
                this.appointmentService.exportAppointment(appointment).then(() => {
                  this.stopExportingAppointment();
                  this.uiService.prompt("Appointment Data Exported", `Your appointment data has been saved. Please contact support for futher instructions.`, "Okay").subscribe({ next: () => {
                  } });
                }).catch(() => {
                  this.stopExportingAppointment();
                  this.uiService.prompt("Failed to Export", `There was an issue exporting your appointment data. Please try again or contact support.`, "Okay").subscribe({ next: () => {
                  } });
                });
              }, 16);
            } else {
              this.stopExportingAppointment();
            }
          })
        });
      }
    });
  }
  // #endregion
  // #region Documents
  sendDocumentsForSignature() {
    if (this.appointment != null) {
      this.appointmentUiService.startSendingDocuments(this.appointment);
    }
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
        if (this.activeUser != null) {
          this.activeUser.phone = "+18014997396";
        }
      }
    });
  }
  // #endregion
  // #region Dispositioning
  get isDispositioned() {
    return this.appointment?.dispositionStatus != null;
  }
  get dispositionStatus() {
    return this.appointment?.dispositionStatus;
  }
  get canReopenAppointment() {
    return this.appointment?.status == AppointmentStatus.Dispositioned;
  }
  promptToReopenAppointment() {
    if (this.appointment != null) {
      switch (this.appointment.status) {
        case AppointmentStatus.Dispositioned:
          {
            const dispositionStatus = this.appointment.dispositionStatus?.name ?? "Other";
            this.uiService.prompt("Reopen Appointment?", `This appointment was previously dispositioned as ${dispositionStatus}. Are you sure you want to reopen it?`, "Yes", "No").subscribe({
              next: (confirmed) => {
                if (confirmed && this.appointment != null) {
                  this.appointment.status = AppointmentStatus.Open;
                  this.appointmentService.storeAppointment(this.appointment);
                  this.initCanOpen();
                }
              }
            });
          }
          break;
        case AppointmentStatus.Canceled:
          {
            this.uiService.prompt("Reopen Appointment?", `This appointment was previously canceled. Are you sure you want to reopen it?`, "Yes", "No").subscribe({
              next: (confirmed) => {
                if (confirmed && this.appointment != null) {
                  this.appointment.status = AppointmentStatus.Open;
                  this.appointmentService.storeAppointment(this.appointment);
                  this.initCanOpen();
                }
              }
            });
          }
          break;
      }
    }
  }
  watchChanges() {
    this.changeSubscription?.unsubscribe();
    if (this.appointment != null) {
      this.changeSubscription = this.appointment.changed$.subscribe({
        next: () => {
          if (this.appointment != null) {
            this.appointmentService.storeAppointment(this.appointment);
          }
        }
      });
    }
  }
  // #endregion
  // #region Details
  viewDetails() {
    if (this.appointment != null) {
      this.appointmentUiService.viewDetails(this.appointment);
    }
  }
  // #endregion
  // #region Estimates
  get canPrepareEstimate() {
    return this.appointment != null && (this.appointment.status == AppointmentStatus.PendingSubmission || this.appointment.status == AppointmentStatus.PendingSignatures) && this.appointment.price?.finalPrice != null && this.appointment.price?.finalPrice > 0 && !this.management;
  }
  promptToPrepareEstimate() {
    if (this.appointment != null) {
      this.appointmentUiService.startPreparingEstimate(this.appointment);
    }
  }
  // #endregion
  // #region Customer
  get customer() {
    return this.appointment?.customer;
  }
  get hasPrice() {
    return this.displayPrice != 0;
  }
  initPricing() {
    this.displayPrice = this.appointment?.customPrice?.finalPrice ?? this.appointment?.price?.finalPrice ?? 0;
  }
  // #endregion
  // #region Status
  get statusLabel() {
    if (this.appointment != null) {
      switch (this.appointment.status) {
        case AppointmentStatus.Open:
          return "Open";
        case AppointmentStatus.Canceled:
          return "Canceled";
        case AppointmentStatus.InProgress:
          return "In Progress";
      }
    }
    return "";
  }
  // #endregion
  // #region Address
  get address() {
    return this.appointment?.property?.address;
  }
  // #endregion
  // #region Issues
  get hasIssues() {
    return this.appointment?.opportunityPlumbingIssues != null && this.appointment.opportunityPlumbingIssues.length > 0;
  }
  // #endregion
  // #region Contact
  get email() {
    const contactInfo = this.appointment?.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Email) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasEmail() {
    return this.email != null;
  }
  get phone() {
    const contactInfo = this.appointment?.customer?.contactInformation ?? [];
    for (var i = 0, len = contactInfo.length; i < len; i++) {
      const info = contactInfo[i];
      if (info.type == ContactInformationType.Phone) {
        return info.value;
      }
    }
    return void 0;
  }
  get hasPhone() {
    return this.email != null;
  }
  get mapElmId() {
    return `map${this.appointment?.id}`;
  }
  get mapLink() {
    return `https://www.google.com/maps/dir/?api=1&destination=${this.mappingAddress}`;
  }
  get friendlyAddress() {
    return this.address?.friendlyAddress;
  }
  get mappingAddress() {
    return this.address?.mappingAddress;
  }
  initMap() {
    setTimeout(() => {
      if (this.mappingAddress != null && this.mapElmId != null) {
        this.map = new import_leaflet.Map(this.mapElmId, {
          zoomControl: false,
          dragging: false,
          attributionControl: false
        }).setView([37.7749, -122.4194], 13);
        (0, import_leaflet.tileLayer)("https://{s}.basemaps.cartocdn.com/rastertiles/voyager/{z}/{x}/{y}{r}.png", {
          subdomains: "abcd",
          maxZoom: 13
        }).addTo(this.map);
        this.mapAddress(this.mappingAddress);
      }
    }, 0);
  }
  mapAddress(address, retries = 0) {
    this.appointmentService.getCoordinatesForAddress(address).subscribe({
      next: (coords) => {
        if (this.map != null) {
          const coordinates = new import_leaflet.LatLng(coords.lat, coords.lon);
          this.map.setView(coordinates, 15);
          (0, import_leaflet.marker)(coordinates, {
            icon: (0, import_leaflet.icon)({
              iconSize: [25, 41],
              iconAnchor: [13, 41],
              iconUrl: "assets/images/maps/marker.svg"
            })
          }).bindPopup(`<b>${address}</b>`).addTo(this.map);
          this.mapRendered = true;
        }
      },
      error: () => {
        if (retries < 3) {
          setTimeout(() => {
            this.mapAddress(address, retries + 1);
          }, 500);
        } else {
          this.mapRendered = false;
        }
      }
    });
  }
  get accepted() {
    return this.appointment?.accepted ?? false;
  }
  acceptAppointment() {
    if (this.appointment != null && !this.acceptingAppointment) {
      this.acceptingAppointment = true;
      this.appointmentService.acceptAppointment(this.appointment.id).subscribe({
        next: () => {
          if (this.appointment != null) {
            this.appointment.accepted = true;
            this.appointmentService.storeAppointment(this.appointment);
          }
          this.acceptingAppointment = false;
          this.initCanOpen();
        },
        error: () => {
          this.acceptingAppointment = false;
        }
      });
    }
  }
  get canAccept() {
    return this.appointment != null && !this.appointment.accepted && !this.management;
  }
  get showOpenWarning() {
    return !this.canOpen && this.appointment != null && this.initializedOpen && this.outstandingAppointmentId != null && this.appointment.accepted;
  }
  goToAppointment(id) {
    this.deviceRouteService.viewRouteByType("Appointment", [id], true);
  }
  promptToGoToAppointment(id) {
    if (id != null) {
      this.uiService.prompt("Open Outstanding Appointment?", "Do you want to go to your outstanding appointment?", "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed) {
            this.goToAppointment(id);
          }
        }
      });
    }
  }
  initCanOpen() {
    return __async(this, null, function* () {
      if (this.appointment?.scheduled_Utc != null) {
        if (this.management || this.appointment.status != AppointmentStatus.Open) {
          this.canOpen = false;
        } else {
          const price = this.appointment.customPrice ?? this.appointment.price;
          if (price?.finalPrice != null && price.finalPrice > 0) {
            this.canOpen = true;
          } else {
            const activeUser = this.authRefService.user.getValue();
            if (activeUser != null) {
              const startDate = "2020-01-01";
              const scheduled = new Date(this.appointment.scheduled_Utc);
              const endYear = scheduled.getFullYear();
              const endMonth = scheduled.getMonth() + 1;
              let endMonthStr = `${endMonth}`;
              if (endMonth < 10) {
                endMonthStr = `0${endMonth}`;
              }
              const endDate = scheduled.getDate();
              let endDateStr = `${endDate}`;
              if (endDate < 10) {
                endDateStr = `0${endDate}`;
              }
              const mergedEndDate = `${endYear}-${endMonthStr}-${endDateStr}`;
              this.appointmentService.getAppointmentsForDateRange(startDate, mergedEndDate, activeUser.id).subscribe({
                next: (appointments) => {
                  if (this.appointment != null) {
                    const sortedAppointments = this.orderByPipe.transform(appointments, "scheduled_Utc", true);
                    let hasUnfinishedAppointment = false;
                    for (var i = 0, len = sortedAppointments.length; i < len; i++) {
                      const prevAppointment = sortedAppointments[i];
                      if (prevAppointment.id != this.appointment.id && prevAppointment.scheduled_Utc != null && this.appointment.scheduled_Utc != null && prevAppointment.scheduled_Utc < this.appointment.scheduled_Utc) {
                        if (prevAppointment.status == AppointmentStatus.Open) {
                          const scheduled2 = this.datePipe.transform(prevAppointment.scheduled_Utc, "MMMM dd");
                          const customerName = prevAppointment.customer?.lastName;
                          this.openStatus = `Unavailable. Your appointment on ${scheduled2} (${prevAppointment.jobId} ${customerName}) has not been dispositioned.`;
                          this.outstandingAppointmentId = prevAppointment.id;
                          hasUnfinishedAppointment = true;
                          break;
                        }
                      }
                    }
                    if (!hasUnfinishedAppointment && this.appointment.status == AppointmentStatus.Open && this.appointment.accepted) {
                      this.canOpen = true;
                    }
                  }
                }
              });
            }
          }
        }
      }
      this.initializedOpen = true;
    });
  }
  get hasAttachmentItems() {
    return this.attachmentItems.length > 0;
  }
  initAttachmentItems() {
    if (this.appointment?.price != null) {
      this.appointment.price.details.forEach((detail) => {
        detail.lineItems.forEach((lineItem) => {
          if (lineItem.isAttachment) {
            if (!this.attachmentItems.includes(lineItem.skuCategory)) {
              this.attachmentItems.push(lineItem.skuCategory);
            }
          }
        });
      });
    }
  }
  // #endregion
  // #region Summary
  get showSummary() {
    return this.appointment != null && this.appointment.status == AppointmentStatus.Submitted;
  }
  init() {
    this.watchUser();
    this.initMap();
    this.initPricing();
    this.initAttachmentItems();
    this.watchChanges();
    this.initCanOpen();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
    this.changeSubscription?.unsubscribe();
  }
};
_AppointmentSummaryComponent.\u0275fac = function AppointmentSummaryComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentSummaryComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(AppointmentUiService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(ContentService));
};
_AppointmentSummaryComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentSummaryComponent, selectors: [["appointment-summary"]], viewQuery: function AppointmentSummaryComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c06, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", management: "management" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe,
  DatePipe
])], decls: 2, vars: 2, consts: [[1, "appointment"], ["id", "exportingAppointment", 3, "closing"], [1, "map"], ["width", "5", "height", "3"], [1, "render"], [1, "content"], [1, "primary"], [1, "emergency"], [1, "customer"], [1, "meta"], [1, "address"], [1, "time"], [1, "job"], [1, "value"], [1, "price"], [1, "acceptance"], [1, "date"], [1, "attachments"], [1, "disposition"], [1, "secondary"], [1, "timestamp"], [1, "controls"], [1, "items"], [1, "item"], [1, "status"], [1, "note"], [1, "data-export"], [1, "export"], [1, "control", 3, "click"], [1, "control", "alternate", 3, "disabled"], [1, "control"], [1, "warning"], [1, "control", "alternate", 3, "click", "disabled"], [1, "control", "alternate"], [1, "control", "alternate", 3, "click"], ["id", "exportingAppointment"], [1, "bg"], [1, "modal"], [1, "fa-solid", "fa-xmark"], [1, "loader"], [1, "progress"], [1, "processing"], [3, "progress", "percent"]], template: function AppointmentSummaryComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, AppointmentSummaryComponent_Conditional_0_Template, 37, 30, "div", 0);
    \u0275\u0275conditionalCreate(1, AppointmentSummaryComponent_Conditional_1_Template, 11, 6, "aside", 1);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.appointment != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.exportingAppointment ? 1 : -1);
  }
}, dependencies: [LoaderComponent, AsyncPipe, CurrencyPipe, DatePipe], styles: ['\n\n.appointment[_ngcontent-%COMP%] {\n  display: flex;\n  position: relative;\n  z-index: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%] {\n  position: relative;\n  width: 25%;\n  z-index: 0;\n  background-color: var(--color6);\n}\n.appointment[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.3s linear;\n  -o-transition: opacity 0.3s linear;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear;\n}\n.appointment[_ngcontent-%COMP%]    > .map[_ngcontent-%COMP%]    > .render.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 1vw;\n  flex: 1;\n  display: flex;\n  align-items: flex-start;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  flex: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .emergency[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color3) solid;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]   .value[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color3Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.Canceled[_ngcontent-%COMP%] {\n  border-left-color: var(--color1);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.Canceled[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.Canceled[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--color1Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%] {\n  border-left-color: var(--color5);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--color5Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .customer[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .address[_ngcontent-%COMP%] {\n  color: var(--color3Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .time[_ngcontent-%COMP%] {\n  color: var(--color3Alt4);\n  white-space: nowrap;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .emergency[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color1) solid;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .canceled[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--errorAlt3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .acceptance.accepted[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--successAlt3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%] {\n  margin-right: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n  position: relative;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:after {\n  content: ", ";\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:last-of-type {\n  margin-right: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .attachments[_ngcontent-%COMP%]    > .items[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:last-of-type:after {\n  content: "";\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-weight: var(--stronger);\n  font-size: 1.2vw;\n  color: var(--color5);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .disposition[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-weight: var(--stdweight);\n  font-size: 1.2vw;\n  font-style: italic;\n  color: var(--color1);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  width: 15vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%] {\n  margin-bottom: 2vw;\n  text-align: right;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .pricing[_ngcontent-%COMP%]    > .total[_ngcontent-%COMP%] {\n  display: inline-block;\n  font-size: 2vw;\n  line-height: 1;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--color3);\n  border-radius: 999px;\n  border: 0.1vw var(--color3Alt3) solid;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.open[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.open[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  border-color: transparent;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%] {\n  background-color: rgba(var(--error-raw), 0.1);\n  border: 0.125vw var(--error) solid;\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  color: var(--errorAlt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n  text-align: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--error);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  padding: 0.25vw 1vw;\n  border-radius: 0.5vw;\n  background-color: rgba(var(--success-raw), 0.2);\n  border: 0.125vw var(--color1) solid;\n  margin-bottom: 1vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  text-align: center;\n  display: block;\n  font-size: 1.1vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-align: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Open[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Open[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Dispositioned[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-color: var(--color5);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Dispositioned[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.InProgress[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Submitted[_ngcontent-%COMP%] {\n  background-color: rgba(var(--success-raw), 0.1);\n  border-color: var(--success);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .status.Submitted[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--successAlt4);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%] {\n  margin-top: 3vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1Alt2);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  text-align: right;\n  display: flex;\n  align-items: center;\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.appointment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .data-export[_ngcontent-%COMP%]    > .export[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-left: 0.25vw;\n  font-size: 1vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n}\n@-webkit-keyframes _ngcontent-%COMP%_exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: exportLoadIn;\n  -ms-animation-name: exportLoadIn;\n  -o-animation-name: exportLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_exportLoadIn;\n  animation-name: _ngcontent-%COMP%_exportLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: relative;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%], \n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .progress[_ngcontent-%COMP%] {\n  font-size: 4vw;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > .processing[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#exportingAppointment[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#exportingAppointment.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingAppointment.closing[_ngcontent-%COMP%]    > .modal[_ngcontent-%COMP%] {\n  -moz-animation-name: exportLoadOut;\n  -ms-animation-name: exportLoadOut;\n  -o-animation-name: exportLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_exportLoadOut;\n  animation-name: _ngcontent-%COMP%_exportLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=appointment-summary.component.css.map */'] });
var AppointmentSummaryComponent = _AppointmentSummaryComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentSummaryComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "appointment-summary", providers: [
      OrderByPipe,
      DatePipe
    ], template: `@if (appointment != null) {
  <div class="appointment">
    <div class="map">
      <canvas width="5" height="3"></canvas>
      <div class="render" [class.active]="mapRendered" [attr.id]="mapElmId"></div>
    </div>
    <div class="content">
      <div class="primary">
        @if (appointment.isEmergency) {
          <div class="emergency">
            <h3>Emergency</h3>
          </div>
        }
        <div class="customer">
          <h2>{{customer?.firstName}} {{customer?.lastName}}</h2>
        </div>
        <div class="meta">
          @if (address != null) {
            <span class="address">
              {{address.city}}, {{address.regionIso3166}}
            </span>
          }
          on
          <span class="time">
            {{appointment.scheduled_Utc | date:'MMM dd, yyyy h:mm a'}}
          </span>
        </div>
        <div class="job">
          <label>Job:</label>
          <span class="value">
            {{appointment.jobId}}
          </span>
        </div>
        @if (hasPrice) {
          <div class="price">
            <label>Price:</label>
            <span class="value">
              {{displayPrice | currency:'USD'}}
            </span>
          </div>
        }
        <div class="acceptance" [class.accepted]="accepted">
          @if (accepted) {
            <label>
              Accepted
            </label>
          }
          @if (!accepted) {
            <label>
              Not Accepted
            </label>
          }
          @if (appointment.accepted_Utc != null && accepted) {
            <span class="date">
              on {{appointment.accepted_Utc | date:'MMM dd, yyyy h:mm a'}}
            </span>
          }
        </div>
        @if (hasAttachmentItems) {
          <div class="attachments">
            <label>
              Attachment Items:
            </label>
            <div class="items">
              @for (item of attachmentItems; track item) {
                <span class="item">
                  {{item}}
                </span>
              }
            </div>
          </div>
        }
        @if (dispositionStatus != null) {
          <div class="disposition">
            <label>
              Disposition Status
            </label>
            <div class="status">
              <span class="value">{{dispositionStatus.name}}</span>
              <span class="timestamp"> on {{dispositionStatus.created_Utc | date:'MMM dd, yyyy h:mm a'}}</span>
            </div>
            @if (dispositionStatus.note != null) {
              <div class="note">
                <p class="value">{{dispositionStatus.note}}</p>
              </div>
            }
          </div>
        }
      </div>
      <div class="secondary">
        <div class="status {{appointment.status}}">
          <span class="value">
            {{status}}
          </span>
          <span class="timestamp">
            on {{appointment.lastUpdated_Utc | date:'MM/dd/yyyy @ h:mm a'}}
          </span>
        </div>
        @if (!management) {
          @if (appointment.status == AppointmentStatus.Open) {
            <div class="controls">
              @if (canAccept) {
                <button
                  class="control alternate"
                  [disabled]="acceptingAppointment"
                  (click)="acceptAppointment()"
                  >
                  <label>Accept</label>
                </button>
              }
              @if (canOpen) {
                <button class="control" (click)="goToAppointment(appointment.id)">
                  <label>Open</label>
                </button>
              }
            </div>
            @if (showOpenWarning) {
              <div class="warning">
                <p>
                  {{openStatus}}
                </p>
                <button class="control" (click)="promptToGoToAppointment(outstandingAppointmentId)">
                  <label>Go to Appointment</label>
                </button>
              </div>
            }
          }
          @if (appointment.status == AppointmentStatus.InProgress) {
            <div class="controls">
              <button class="control" (click)="goToAppointment(appointment.id)">
                <label>Open</label>
              </button>
            </div>
          }
          @if (appointment.status == AppointmentStatus.Dispositioned) {
            <div class="controls">
              @if (canReopenAppointment) {
                <button class="control alternate" (click)="promptToReopenAppointment()">
                  <label>Reopen</label>
                </button>
              }
            </div>
          }
          @if (appointment.status == AppointmentStatus.Canceled) {
            <div class="controls">
              @if (canReopenAppointment) {
                <button class="control alternate" (click)="promptToReopenAppointment()">
                  <label>Reopen</label>
                </button>
              }
            </div>
          }
          @if (appointment.status == AppointmentStatus.PendingSignatures) {
            <div class="controls">
              <button class="control" (click)="viewDetails()">
                <label>View Details</label>
              </button>
              <button class="control alternate" (click)="sendDocumentsForSignature()">
                <label>Send for E-Signature</label>
              </button>
            </div>
          }
          @if (appointment.status == AppointmentStatus.PendingSubmission) {
            <div class="controls">
              <button class="control" (click)="viewDetails()">
                <label>View Details</label>
              </button>
              @if (canPrepareEstimate) {
                <button class="control alternate" (click)="promptToPrepareEstimate()">
                  <label>Submit Job</label>
                </button>
              }
            </div>
          }
          @if (appointment.status == AppointmentStatus.Submitted) {
            <div class="controls">
              <button class="control" (click)="viewDetails()">
                <label>View Details</label>
              </button>
              @if (canPrepareEstimate) {
                <button class="control alternate" (click)="promptToPrepareEstimate()">
                  <label>Prepare Estimate</label>
                </button>
              }
            </div>
          }
          <div class="data-export">
            <div class="export">
              <button class="control" (click)="remoteExportAppointment()">
                <label>Export to Server</label>
              </button>
            </div>
            <div class="export">
              <button class="control" (click)="exportAppointment()">
                <label>Export to Device</label>
              </button>
            </div>
          </div>
        }
        @if (management) {
          <div class="controls">
            @if (appointment.status == AppointmentStatus.Submitted) {
              <button class="control" (click)="viewDetails()">
                <label>View Details</label>
              </button>
            }
            <button class="control" (click)="goToAppointment(appointment.id)">
              <label>Open</label>
            </button>
          </div>
        }
      </div>
    </div>
  </div>
}

@if (exportingAppointment) {
  <aside id="exportingAppointment" [class.closing]="closingExportAppointment">
    <div class="bg"></div>
    <div class="modal">
      <button class="control" (click)="promptToStopExporting()">
        <i class="fa-solid fa-xmark"></i>
      </button>
      <div class="loader">
        @if (showExportProgress) {
          <span class="progress">{{exportProgress | async}}%</span>
        }
        @if (!showExportProgress) {
          <span class="processing">Processing</span>
        }
        <loader [progress]="true" [percent]="exportProgress"></loader>
      </div>
      <label>Preparing & Exporting Appointment</label>
    </div>
  </aside>
}`, styles: ['/* src/app/shared/appointments/components/appointment-summary/appointment-summary.component.scss */\n.appointment {\n  display: flex;\n  position: relative;\n  z-index: 0;\n}\n.appointment > .map {\n  position: relative;\n  width: 25%;\n  z-index: 0;\n  background-color: var(--color6);\n}\n.appointment > .map > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.3s linear;\n  -o-transition: opacity 0.3s linear;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear;\n}\n.appointment > .map > .render.active {\n  opacity: 1;\n}\n.appointment > .content {\n  position: relative;\n  padding: 1vw;\n  flex: 1;\n  display: flex;\n  align-items: flex-start;\n}\n.appointment > .content > .primary {\n  flex: 1;\n}\n.appointment > .content > .primary > .emergency {\n  font-size: 1.4vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.appointment > .content > .primary > .status {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color3) solid;\n}\n.appointment > .content > .primary > .status > label {\n  font-size: 1.2vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.appointment > .content > .primary > .status .value {\n  font-size: 1.2vw;\n  color: var(--color3Alt4);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.appointment > .content > .primary > .status.Canceled {\n  border-left-color: var(--color1);\n}\n.appointment > .content > .primary > .status.Canceled h3 {\n  color: var(--color1);\n}\n.appointment > .content > .primary > .status.Canceled p {\n  color: var(--color1Alt4);\n}\n.appointment > .content > .primary > .status.InProgress {\n  border-left-color: var(--color5);\n}\n.appointment > .content > .primary > .status.InProgress h3 {\n  color: var(--color5);\n}\n.appointment > .content > .primary > .status.InProgress p {\n  color: var(--color5Alt4);\n}\n.appointment > .content > .primary > .status:first-child {\n  margin-top: 0;\n}\n.appointment > .content > .primary > .customer h2 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment > .content > .primary > .meta {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n.appointment > .content > .primary > .meta > .address {\n  color: var(--color3Alt4);\n}\n.appointment > .content > .primary > .meta > .time {\n  color: var(--color3Alt4);\n  white-space: nowrap;\n}\n.appointment > .content > .primary > .emergency {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  display: block;\n}\n.appointment > .content > .primary > .canceled {\n  margin-top: 0.5vw;\n  margin-bottom: 0.5vw;\n  padding-left: 0.5vw;\n  border-left: 0.5vw var(--color1) solid;\n}\n.appointment > .content > .primary > .canceled h3 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n  text-transform: uppercase;\n  font-style: italic;\n}\n.appointment > .content > .primary > .canceled p {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.appointment > .content > .primary > .canceled:first-child {\n  margin-top: 0;\n}\n.appointment > .content > .primary > .job {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment > .content > .primary > .job label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment > .content > .primary > .job > .value {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n}\n.appointment > .content > .primary > .price {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment > .content > .primary > .price label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment > .content > .primary > .price > .value {\n  margin-left: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.appointment > .content > .primary > .acceptance {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: center;\n}\n.appointment > .content > .primary > .acceptance label {\n  font-size: 1.2vw;\n  color: var(--errorAlt3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n.appointment > .content > .primary > .acceptance > .date {\n  margin-left: 0.25vw;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.appointment > .content > .primary > .acceptance.accepted > label {\n  color: var(--successAlt3);\n}\n.appointment > .content > .primary > .attachments {\n  margin-top: 0.5vw;\n}\n.appointment > .content > .primary > .attachments label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment > .content > .primary > .attachments > .items {\n  margin-top: 0.25vw;\n}\n.appointment > .content > .primary > .attachments > .items > .item {\n  margin-right: 0.25vw;\n  display: inline-block;\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stronger);\n  position: relative;\n}\n.appointment > .content > .primary > .attachments > .items > .item:after {\n  content: ", ";\n}\n.appointment > .content > .primary > .attachments > .items > .item:last-of-type {\n  margin-right: 0;\n}\n.appointment > .content > .primary > .attachments > .items > .item:last-of-type:after {\n  content: "";\n}\n.appointment > .content > .primary > .disposition {\n  margin-top: 0.5vw;\n}\n.appointment > .content > .primary > .disposition label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n.appointment > .content > .primary > .disposition > .status {\n  margin-top: 0.25vw;\n}\n.appointment > .content > .primary > .disposition > .status > .value {\n  font-weight: var(--stronger);\n  font-size: 1.2vw;\n  color: var(--color5);\n}\n.appointment > .content > .primary > .disposition > .status > .timestamp {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n.appointment > .content > .primary > .disposition > .note {\n  margin-top: 0;\n}\n.appointment > .content > .primary > .disposition > .note > .value {\n  font-weight: var(--stdweight);\n  font-size: 1.2vw;\n  font-style: italic;\n  color: var(--color1);\n}\n.appointment > .content > .secondary {\n  margin-left: 1vw;\n  width: 15vw;\n}\n.appointment > .content > .secondary > .pricing {\n  margin-bottom: 2vw;\n  text-align: right;\n}\n.appointment > .content > .secondary > .pricing > .total {\n  display: inline-block;\n  font-size: 2vw;\n  line-height: 1;\n  color: var(--successAlt3);\n  font-weight: var(--stronger);\n}\n.appointment > .content > .secondary > .controls > .control {\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--color3);\n  border-radius: 999px;\n  border: 0.1vw var(--color3Alt3) solid;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.appointment > .content > .secondary > .controls > .control > label {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.appointment > .content > .secondary > .controls > .control.alternate {\n  background-color: var(--color5);\n  border-color: var(--color5Alt4);\n}\n.appointment > .content > .secondary > .controls > .control.open {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.appointment > .content > .secondary > .controls > .control.open > label {\n  color: var(--color3);\n}\n.appointment > .content > .secondary > .controls > .control[disabled] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n.appointment > .content > .secondary > .controls > .control:active {\n  border-color: transparent;\n}\n.appointment > .content > .secondary > .controls > .control:first-child {\n  margin-top: 0;\n}\n.appointment > .content > .secondary > .warning {\n  background-color: rgba(var(--error-raw), 0.1);\n  border: 0.125vw var(--error) solid;\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n}\n.appointment > .content > .secondary > .warning > p {\n  color: var(--errorAlt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n  text-align: center;\n}\n.appointment > .content > .secondary > .warning > .control {\n  display: block;\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  background-color: var(--error);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  cursor: pointer;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  -moz-transition: border-color 0.1s;\n  -o-transition: border-color 0.1s;\n  -webkit-transition: border-color 0.1s;\n  transition: border-color 0.1s;\n}\n.appointment > .content > .secondary > .warning > .control > label {\n  font-size: 1vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.appointment > .content > .secondary > .status {\n  padding: 0.25vw 1vw;\n  border-radius: 0.5vw;\n  background-color: rgba(var(--success-raw), 0.2);\n  border: 0.125vw var(--color1) solid;\n  margin-bottom: 1vw;\n}\n.appointment > .content > .secondary > .status > .value {\n  text-align: center;\n  display: block;\n  font-size: 1.1vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strongest);\n}\n.appointment > .content > .secondary > .status > .timestamp {\n  display: block;\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  text-align: center;\n}\n.appointment > .content > .secondary > .status.Open {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.appointment > .content > .secondary > .status.Open > .value {\n  color: var(--color3);\n}\n.appointment > .content > .secondary > .status.Dispositioned {\n  background-color: rgba(var(--color5-raw), 0.1);\n  border-color: var(--color5);\n}\n.appointment > .content > .secondary > .status.Dispositioned > .value {\n  color: var(--color5);\n}\n.appointment > .content > .secondary > .status.InProgress {\n  background-color: rgba(var(--color3-raw), 0.1);\n  border-color: var(--color3);\n}\n.appointment > .content > .secondary > .status.InProgress > .value {\n  color: var(--color3);\n}\n.appointment > .content > .secondary > .status.Submitted {\n  background-color: rgba(var(--success-raw), 0.1);\n  border-color: var(--success);\n}\n.appointment > .content > .secondary > .status.Submitted > .value {\n  color: var(--successAlt4);\n}\n.appointment > .content > .secondary > .data-export {\n  margin-top: 3vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n.appointment > .content > .secondary > .data-export > .export {\n  margin-top: 0.5vw;\n}\n.appointment > .content > .secondary > .data-export > .export > .control {\n  cursor: pointer;\n}\n.appointment > .content > .secondary > .data-export > .export > .control > label {\n  color: var(--color1Alt2);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n.appointment > .content > .secondary > .data-export > .export > .timestamp {\n  text-align: right;\n  display: flex;\n  align-items: center;\n}\n.appointment > .content > .secondary > .data-export > .export > .timestamp > label {\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n.appointment > .content > .secondary > .data-export > .export > .timestamp > .value {\n  margin-left: 0.25vw;\n  font-size: 1vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n}\n@-webkit-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-moz-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-o-keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@keyframes exportLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n}\n@-webkit-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-moz-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-o-keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@keyframes exportLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: translate(-50%, -50%) scale(1);\n    -ms-transform: translate(-50%, -50%) scale(1);\n    -o-transform: translate(-50%, -50%) scale(1);\n    -webkit-transform: translate(-50%, -50%) scale(1);\n    transform: translate(-50%, -50%) scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: translate(-50%, -50%) scale(0.9);\n    -ms-transform: translate(-50%, -50%) scale(0.9);\n    -o-transform: translate(-50%, -50%) scale(0.9);\n    -webkit-transform: translate(-50%, -50%) scale(0.9);\n    transform: translate(-50%, -50%) scale(0.9);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#exportingAppointment > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingAppointment > .modal {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-animation-name: exportLoadIn;\n  -ms-animation-name: exportLoadIn;\n  -o-animation-name: exportLoadIn;\n  -webkit-animation-name: exportLoadIn;\n  animation-name: exportLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingAppointment > .modal > .control {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n}\n#exportingAppointment > .modal > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#exportingAppointment > .modal > .loader {\n  position: relative;\n}\n#exportingAppointment > .modal > .loader > .progress,\n#exportingAppointment > .modal > .loader > .processing {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  max-width: 100%;\n  display: block;\n  text-align: center;\n  z-index: 1;\n  font-weight: var(--stronger);\n  color: var(--color2);\n}\n#exportingAppointment > .modal > .loader > .progress {\n  font-size: 4vw;\n}\n#exportingAppointment > .modal > .loader > .processing {\n  font-size: 1.3vw;\n  text-transform: uppercase;\n}\n#exportingAppointment > .modal > .loader > loader {\n  display: block;\n  margin: 0 auto;\n  position: relative;\n  width: 14vw;\n  height: 14vw;\n  --fillSpeed: 5s;\n}\n#exportingAppointment > .modal label {\n  display: block;\n  text-align: center;\n  margin-top: 1vw;\n  color: var(--color1);\n  font-size: 2.2vw;\n  font-weight: var(--ltweight);\n}\n#exportingAppointment.closing > .bg {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#exportingAppointment.closing > .modal {\n  -moz-animation-name: exportLoadOut;\n  -ms-animation-name: exportLoadOut;\n  -o-animation-name: exportLoadOut;\n  -webkit-animation-name: exportLoadOut;\n  animation-name: exportLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=appointment-summary.component.css.map */\n'] }]
  }], () => [{ type: UiService }, { type: AppointmentService }, { type: AppointmentUiService }, { type: AuthRefService }, { type: DeviceRouteService }, { type: OrderByPipe }, { type: DatePipe }, { type: ContentService }], { appointment: [{
    type: Input,
    args: ["appointment"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], management: [{
    type: Input,
    args: ["management"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AppointmentSummaryComponent, { className: "AppointmentSummaryComponent" });
})();

// src/app/shared/appointments/components/appointment-payments/appointment-payments.component.ts
var _c07 = ["componentElm"];
function AppointmentPaymentsComponent_Conditional_17_For_2_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1, " You must indicate an approval amount greater than $0.00 to include this lender on the job. ");
    \u0275\u0275elementEnd();
  }
}
function AppointmentPaymentsComponent_Conditional_17_For_2_Conditional_20_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1, " You must indicate an application Id. ");
    \u0275\u0275elementEnd();
  }
}
function AppointmentPaymentsComponent_Conditional_17_For_2_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 28)(1, "label");
    \u0275\u0275text(2, "Applied On");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 17);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "date");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const lender_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(5, 1, lender_r3.applied_Utc, "MM/dd/yyyy hh:mm a z"), " ");
  }
}
function AppointmentPaymentsComponent_Conditional_17_For_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 20)(1, "button", 5);
    \u0275\u0275listener("click", function AppointmentPaymentsComponent_Conditional_17_For_2_Template_button_click_1_listener() {
      const lender_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.promptToRemoveLender(lender_r3));
    });
    \u0275\u0275element(2, "i", 21);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 22)(4, "div", 23)(5, "label");
    \u0275\u0275text(6, "Lender");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "span", 17);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "div", 16)(10, "label");
    \u0275\u0275text(11, "Approved Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "div", 24)(13, "currency-input", 25);
    \u0275\u0275listener("currencyOutput", function AppointmentPaymentsComponent_Conditional_17_For_2_Template_currency_input_currencyOutput_13_listener($event) {
      const lender_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.updateLenderAmount(lender_r3, $event));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(14, AppointmentPaymentsComponent_Conditional_17_For_2_Conditional_14_Template, 2, 0, "p", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "div", 26)(16, "label");
    \u0275\u0275text(17, "Application Id");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "div", 24)(19, "input", 27);
    \u0275\u0275twoWayListener("ngModelChange", function AppointmentPaymentsComponent_Conditional_17_For_2_Template_input_ngModelChange_19_listener($event) {
      const lender_r3 = \u0275\u0275restoreView(_r2).$implicit;
      \u0275\u0275twoWayBindingSet(lender_r3.applicationId, $event) || (lender_r3.applicationId = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(20, AppointmentPaymentsComponent_Conditional_17_For_2_Conditional_20_Template, 2, 0, "p", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(21, AppointmentPaymentsComponent_Conditional_17_For_2_Conditional_21_Template, 6, 4, "div", 28);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const lender_r3 = ctx.$implicit;
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate1(" ", lender_r3.name, " ");
    \u0275\u0275advance(5);
    \u0275\u0275property("currencyInput", lender_r3.amountFinanced);
    \u0275\u0275advance();
    \u0275\u0275conditional(lender_r3.amountFinanced != null && lender_r3.amountFinanced <= 0 ? 14 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", lender_r3.applicationId);
    \u0275\u0275advance();
    \u0275\u0275conditional(lender_r3.applicationId == null ? 20 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(lender_r3.applied_Utc != null ? 21 : -1);
  }
}
function AppointmentPaymentsComponent_Conditional_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 9);
    \u0275\u0275repeaterCreate(1, AppointmentPaymentsComponent_Conditional_17_For_2_Template, 22, 6, "div", 20, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r3.lenders);
  }
}
function AppointmentPaymentsComponent_For_20_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 5);
    \u0275\u0275listener("click", function AppointmentPaymentsComponent_For_20_Conditional_0_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const method_r6 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.addLender(method_r6));
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const method_r6 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" Add ", method_r6.name, " ");
  }
}
function AppointmentPaymentsComponent_For_20_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, AppointmentPaymentsComponent_For_20_Conditional_0_Template, 3, 1, "button", 29);
  }
  if (rf & 2) {
    const method_r6 = ctx.$implicit;
    \u0275\u0275conditional(!method_r6.added ? 0 : -1);
  }
}
function AppointmentPaymentsComponent_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "p");
    \u0275\u0275text(2, "A payment is required to finalize the job.");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentPaymentsComponent_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "p");
    \u0275\u0275text(2, "Your total payments must at least meet the deposit amount to finalize the job.");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentPaymentsComponent_For_29_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 12)(1, "button", 18);
    \u0275\u0275listener("click", function AppointmentPaymentsComponent_For_29_Template_button_click_1_listener() {
      const \u0275$index_116_r8 = \u0275\u0275restoreView(_r7).$index;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.removePayment(\u0275$index_116_r8));
    });
    \u0275\u0275element(2, "i", 21);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 22)(4, "div", 30)(5, "label");
    \u0275\u0275text(6, "Payment Method");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "span", 17);
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(9, "div", 16)(10, "label");
    \u0275\u0275text(11, "Payment Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "span", 17);
    \u0275\u0275text(13);
    \u0275\u0275pipe(14, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(15, "div", 31)(16, "label");
    \u0275\u0275text(17, "Timestamp");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "span", 17);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "date");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const payment_r9 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !payment_r9.appliedManually);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", payment_r9.paymentMethod == null ? null : payment_r9.paymentMethod.name, " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(14, 4, payment_r9.amount, payment_r9.iso4217), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(20, 7, payment_r9.timeStamp_Utc, "MM/dd/yyyy hh:mm a"), " ");
  }
}
function AppointmentPaymentsComponent_Conditional_30_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "p");
    \u0275\u0275text(2, " No payments have yet been recorded on this appointment. ");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentPaymentsComponent_Conditional_35_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "p");
    \u0275\u0275text(2, "Your recorded payments don't match the deposit amount. Are you sure your payment details are correct?");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentPaymentsComponent_Conditional_36_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "p");
    \u0275\u0275text(2, "Your payment details don't match the total price of the job.");
    \u0275\u0275elementEnd()();
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 32);
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 24)(1, "currency-input", 35);
    \u0275\u0275listener("currencyOutput", function AppointmentPaymentsComponent_For_39_Conditional_6_Template_currency_input_currencyOutput_1_listener($event) {
      \u0275\u0275restoreView(_r10);
      const detail_r11 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.updateDetail($event, detail_r11));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("maxAmount", detail_r11.maximumAmount)("minAmount", detail_r11.minimumAmount)("update", detail_r11.updatedAmount$)("currencyInput", detail_r11.amount);
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 17);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "currency");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(2, 1, detail_r11.amount, "USD"), " ");
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "currency");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" The specified amount must be lower than ", \u0275\u0275pipeBind2(2, 1, detail_r11.maximumAmount, "USD"), ". ");
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "currency");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" The specified amount must be higher than ", \u0275\u0275pipeBind2(2, 1, detail_r11.minimumAmount, "USD"), ". ");
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_11_For_2_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1, " You must enter an amount, even if it's $0.00. ");
    \u0275\u0275elementEnd();
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_11_For_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 16)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 24)(4, "currency-input", 25);
    \u0275\u0275listener("currencyOutput", function AppointmentPaymentsComponent_For_39_Conditional_11_For_2_Template_currency_input_currencyOutput_4_listener($event) {
      const amount_r13 = \u0275\u0275restoreView(_r12).$implicit;
      const ctx_r3 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r3.updateDetailLenderAmount($event, amount_r13));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(5, AppointmentPaymentsComponent_For_39_Conditional_11_For_2_Conditional_5_Template, 2, 0, "p", 11);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const amount_r13 = ctx.$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" Amount Financed by ", amount_r13.name, " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("currencyInput", amount_r13.amount);
    \u0275\u0275advance();
    \u0275\u0275conditional(amount_r13.amount == null ? 5 : -1);
  }
}
function AppointmentPaymentsComponent_For_39_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 34);
    \u0275\u0275repeaterCreate(1, AppointmentPaymentsComponent_For_39_Conditional_11_For_2_Template, 6, 3, "div", 16, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const detail_r11 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275repeater(detail_r11.lenderAmounts);
  }
}
function AppointmentPaymentsComponent_For_39_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "div", 7)(2, "label");
    \u0275\u0275conditionalCreate(3, AppointmentPaymentsComponent_For_39_Conditional_3_Template, 1, 0, "i", 32);
    \u0275\u0275text(4);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 16);
    \u0275\u0275conditionalCreate(6, AppointmentPaymentsComponent_For_39_Conditional_6_Template, 2, 4, "div", 24);
    \u0275\u0275conditionalCreate(7, AppointmentPaymentsComponent_For_39_Conditional_7_Template, 3, 4, "span", 17);
    \u0275\u0275elementStart(8, "div", 33);
    \u0275\u0275conditionalCreate(9, AppointmentPaymentsComponent_For_39_Conditional_9_Template, 3, 4, "p", 11);
    \u0275\u0275conditionalCreate(10, AppointmentPaymentsComponent_For_39_Conditional_10_Template, 3, 4, "p", 11);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(11, AppointmentPaymentsComponent_For_39_Conditional_11_Template, 3, 0, "div", 34);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const detail_r11 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275classProp("editable", detail_r11.canEditAmount);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(detail_r11.canEditAmount ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", detail_r11.name, " ");
    \u0275\u0275advance(2);
    \u0275\u0275conditional(detail_r11.canEditAmount ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!detail_r11.canEditAmount ? 7 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(detail_r11.maximumAmount != null && detail_r11.amount > detail_r11.maximumAmount ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(detail_r11.amount < detail_r11.minimumAmount ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(detail_r11.lenderAmounts.length > 0 ? 11 : -1);
  }
}
var _AppointmentPaymentsComponent = class _AppointmentPaymentsComponent {
  constructor(appointmentService, appointmentUiService, paymentsService, uiService, orderByPipe, currencyPipe) {
    this.appointmentService = appointmentService;
    this.appointmentUiService = appointmentUiService;
    this.paymentsService = paymentsService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.currencyPipe = currencyPipe;
    this.details = [];
    this.totalDetailAmount = 0;
    this.LenderApplicationStatus = LenderApplicationStatus;
    this.lenders = [];
    this.PaymentMethodType = PaymentMethodType;
    this.transactMethods = [];
    this.paymentMethods = [];
    this.financeMethods = [];
    this.makingPayment = false;
    this.totalPaid = 0;
    this.payments = [];
    this.canSave = false;
  }
  // #endregion
  // #region Price
  get price() {
    return this.appointment?.customPrice ?? this.appointment?.price;
  }
  get finalPrice() {
    return this.price?.finalPrice ?? 0;
  }
  get remainingAmount() {
    return this.finalPrice - this.totalPaid;
  }
  get paymentsMatchDeposit() {
    return safeEquivalentPrice(this.totalPaid) == safeEquivalentPrice(this.depositAmount);
  }
  get showMismatchedTotalWarning() {
    return Math.ceil(this.totalDetailAmount) != Math.ceil(this.finalPrice);
  }
  updateTotalDetailAmount() {
    this.totalDetailAmount = 0;
    this.details.forEach((detail) => {
      this.totalDetailAmount = this.totalDetailAmount + detail.amount;
    });
  }
  updateDetail(result, detail) {
    if (this.appointment?.paymentSetting != null && result.amount != null) {
      if (this.finalPrice > 0 && result.amount != null) {
        if (detail.canEditAmount) {
          const totalDetails = this.details.length;
          detail.amount = result.amount;
          switch (totalDetails) {
            case 2:
              {
                const firstDetail = this.details[0];
                const secondDetail = this.details[1];
                if (firstDetail.id == detail.id) {
                  secondDetail.amount = this.finalPrice - detail.amount;
                  secondDetail.updatedAmount$.next(secondDetail.amount);
                }
              }
              break;
            case 3: {
              const firstDetail = this.details[0];
              const secondDetail = this.details[1];
              const thirdDetail = this.details[2];
              if (firstDetail.id == detail.id) {
                secondDetail.amount = this.finalPrice - detail.amount - thirdDetail.amount;
              } else if (thirdDetail.id == detail.id) {
                secondDetail.amount = this.finalPrice - detail.amount - firstDetail.amount;
              }
              secondDetail.updatedAmount$.next(secondDetail.amount);
            }
          }
        } else {
          detail.updatedAmount$.next(detail.amount);
        }
        this.updateTotalDetailAmount();
        this.updateValidation();
      }
    }
  }
  updateDetailLenderAmount(result, lenderAmount) {
    lenderAmount.amount = result.amount;
    this.updateValidation();
  }
  initDetails() {
    if (this.appointment?.paymentSetting != null) {
      let details = this.appointment.paymentSetting.details;
      let clonedDetails = [];
      details = this.orderByPipe.transform(this.appointment.paymentSetting.details, "priority", false);
      details.forEach((detail) => {
        const clonedDetail = structuredClone(detail);
        clonedDetail.updatedAmount$ = new Subject();
        clonedDetail.updatedAmount$.next(clonedDetail.amount);
        if (clonedDetail.lenderAmounts == null) {
          clonedDetail.lenderAmounts = [];
        }
        clonedDetails.push(clonedDetail);
      });
      const totalDetails = clonedDetails.length;
      switch (totalDetails) {
        case 2:
          {
            const firstDetail = clonedDetails[0];
            firstDetail.canEditAmount = true;
            const secondDetail = clonedDetails[1];
            secondDetail.canEditAmount = false;
          }
          break;
        case 3: {
          const firstDetail = clonedDetails[0];
          firstDetail.canEditAmount = true;
          const secondDetail = clonedDetails[1];
          secondDetail.canEditAmount = false;
          const thirdDetail = clonedDetails[2];
          thirdDetail.canEditAmount = true;
        }
      }
      this.details = clonedDetails;
      this.updateTotalDetailAmount();
      this.updateValidation();
    }
  }
  get hasLenders() {
    return this.lenders.length > 0;
  }
  addLender(method) {
    const lender = {
      name: method.name,
      applicationId: void 0,
      applied_Utc: void 0,
      applicationStatus: void 0,
      amountRequested: 0,
      amountFinanced: 0,
      applied: false
    };
    this.lenders.push(lender);
    method.added = true;
    this.details.forEach((detail) => {
      if (detail.lenderAmounts.length > 0) {
        const matchingLender = detail.lenderAmounts.find((x) => x.name == lender.name);
        if (matchingLender == null) {
          detail.lenderAmounts.push({
            name: lender.name,
            amount: void 0
          });
        } else {
          matchingLender.amount = void 0;
        }
      } else {
        detail.lenderAmounts = [
          {
            name: lender.name,
            amount: void 0
          }
        ];
      }
    });
    this.updateValidation();
  }
  promptToRemoveLender(lender) {
    this.uiService.prompt(`Remove ${lender.name}`, `Are you sure you want to remove ${lender.name} as a lender on the job?`, "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.removeLender(lender);
        }
      }
    });
  }
  updateLenderAmount(lender, result) {
    window.clearTimeout(this.lenderAmountDebounce);
    lender.amountFinanced = result.amount;
    this.updateValidation();
  }
  removeLender(lender) {
    const method = this.financeMethods.find((x) => x.name == lender.name);
    if (method != null) {
      method.added = false;
    }
    const index2 = this.lenders.findIndex((x) => x.name == lender.name);
    this.lenders.splice(index2, 1);
    this.details.forEach((detail) => {
      const matchingLenderIndex = detail.lenderAmounts.findIndex((x) => x.name == lender.name);
      detail.lenderAmounts.splice(matchingLenderIndex, 1);
    });
    this.updateValidation();
  }
  applyForFinancing(lender) {
    const lenderName = lender.name.toLowerCase();
    const componentElm = this.componentElm?.nativeElement;
    if (componentElm != null && this.appointment != null) {
      switch (lenderName) {
        case "greensky finance":
          {
            this.paymentsService.initGreenSky(componentElm, this.appointment).subscribe({
              next: (payment) => {
                if (payment != null) {
                  this.registerPayment(payment);
                }
                this.makingPayment = false;
                lender.applied = true;
                lender.applied_Utc = /* @__PURE__ */ new Date();
              },
              error: () => {
                this.uiService.prompt("GreenSky Unavailable", "We were unable to load the GreenSky application. Please try again or apply in the GreenSky app.", "Ok").subscribe({
                  next: (confirmed) => {
                    this.makingPayment = false;
                    lender.applied = true;
                    lender.applied_Utc = /* @__PURE__ */ new Date();
                  }
                });
              }
            });
          }
          break;
        case "ftl":
          {
            this.paymentsService.startApplyingForExternalLender("https://beta.apptracker.ftlfinance.com/C220703");
            lender.applied = true;
            lender.applied_Utc = /* @__PURE__ */ new Date();
          }
          break;
      }
    }
  }
  initLenders() {
    if (this.appointment?.paymentSetting != null) {
      let lenders = this.appointment.lenders;
      let clonedLenders = [];
      lenders.forEach((lender) => {
        const matchingPaymentMethod = this.financeMethods.find((x) => x.name == lender.name);
        if (matchingPaymentMethod != null) {
          const clonedLender = structuredClone(lender);
          clonedLender.applied = true;
          matchingPaymentMethod.added = true;
          clonedLenders.push(clonedLender);
        }
      });
      this.lenders = clonedLenders;
      this.updateValidation();
    }
  }
  findPaymentMethod(id) {
    return this.paymentMethods.find((x) => x.id == id);
  }
  initMethods() {
    const financeMethods = [];
    const transactMethods = [];
    const paymentMethods = this.appointment?.paymentSetting?.methods ?? [];
    const clonedPaymentMehods = [];
    paymentMethods.forEach((method) => {
      const clonedMethod = structuredClone(method);
      clonedPaymentMehods.push(clonedMethod);
    });
    clonedPaymentMehods.forEach((method) => {
      if (method.type == PaymentMethodType.Financing) {
        financeMethods.push(method);
      } else if (method.type == PaymentMethodType.EPayment && method.name != "Bluepay") {
        transactMethods.push(method);
      }
    });
    this.financeMethods = financeMethods;
    this.transactMethods = transactMethods;
    this.paymentMethods = clonedPaymentMehods;
  }
  get hasPayments() {
    return this.payments.length > 0;
  }
  get canMakePayment() {
    return !this.makingPayment;
  }
  get depositAmount() {
    const deposit = this.details.find((x) => x.name.toLowerCase().includes("deposit"));
    const amount = deposit?.amount ?? 0;
    return safePrice(amount);
  }
  get depositAmountRemaining() {
    const remaining = this.depositAmount - this.totalPaid;
    if (remaining >= 0) {
      return remaining;
    } else {
      return 0;
    }
  }
  get showPaymentsWarning() {
    return this.depositAmount > 0 && !this.hasPayments;
  }
  get showInsufficientPaymentsWarning() {
    return this.totalPaid < this.depositAmount;
  }
  calcTotalPaid() {
    let totalPaid = 0;
    this.payments.forEach((payment) => {
      totalPaid = totalPaid + payment.amount;
    });
    this.totalPaid = totalPaid;
  }
  removePayment(i) {
    this.uiService.prompt("Remove Manual Payment?", "Are you sure you wish to remove this manual payment?", "Yes", "No, Cancel").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          if (this.appointment != null) {
            this.payments.splice(i, 1);
            this.updateValidation();
          }
        }
      }
    });
  }
  registerPayment(payment) {
    if (payment.paymentMethodId != null) {
      payment.paymentMethod = this.findPaymentMethod(payment.paymentMethodId);
    }
    if (this.payments != null) {
      this.payments.push(payment);
    } else {
      this.payments = [payment];
    }
    this.calcTotalPaid();
    this.updateValidation();
  }
  makePayment(method = void 0) {
    const componentElm = this.componentElm?.nativeElement;
    if (this.canMakePayment && componentElm != null && this.appointment != null) {
      this.makingPayment = true;
      if (method != null) {
        const methodName = method.name.toLowerCase();
        switch (methodName) {
          case "ebiz charge":
            {
              setTimeout(() => {
                this.uiService.prompt("EBiz Charge Unavailable", "We encountered an issue loading Ebiz Charge. You can capture the payment elsewhere and record it as an external payment, instead.", "Okay").subscribe({
                  next: (confirmed) => {
                    this.makingPayment = false;
                  }
                });
              }, 1e3);
            }
            break;
        }
      } else {
        this.manualPaymentSubscription = this.paymentsService.manualPayment.subscribe({
          next: (payment) => {
            if (payment != null) {
              this.registerPayment(payment);
            }
            this.makingPayment = false;
            this.manualPaymentSubscription?.unsubscribe();
          }
        });
        const paymentTip = `REMAINING DEPOSIT AMOUNT: ${this.currencyPipe.transform(this.depositAmountRemaining, "USD")}`;
        this.paymentsService.startMakingManualPayment(this.paymentMethods, paymentTip);
      }
    }
  }
  initPayments() {
    const payments = this.appointment?.payments ?? [];
    const clonedPayments = [];
    payments.forEach((payment) => {
      const clonedPayment = structuredClone(payment);
      if (clonedPayment.paymentMethodId != null) {
        clonedPayment.paymentMethod = this.findPaymentMethod(clonedPayment.paymentMethodId);
        if (clonedPayment.paymentMethod != null) {
          clonedPayments.push(clonedPayment);
        }
      }
    });
    this.payments = clonedPayments;
    this.calcTotalPaid();
    this.updateValidation();
  }
  updateValidation() {
    if (this.appointment?.paymentSetting != null) {
      const tempAppointment = new Appointment();
      tempAppointment.price = structuredClone(this.price);
      tempAppointment.lenders = structuredClone(this.lenders);
      tempAppointment.payments = structuredClone(this.payments);
      tempAppointment.paymentSetting = structuredClone(this.appointment.paymentSetting);
      tempAppointment.paymentSetting.details = this.details;
      tempAppointment.paymentSetting.methods = this.paymentMethods;
      const detailsValid = this.appointment.validatePaymentDetails(true, tempAppointment, this.hasLenders);
      const lendersValid = this.appointment.validateLenders(true, tempAppointment);
      this.canSave = this.paymentsMatchDeposit && lendersValid && detailsValid;
    }
  }
  promptToSave() {
    this.uiService.prompt("Caution!", `Your changes will overwrite any existing payment information on the appointment and generate new documents which will need to be signed.
                Any existing signed documents will be deleted.
                Are you sure you wish to save payment information?`, "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed && this.appointment?.paymentSetting != null && this.canSave) {
          this.appointment.paymentSetting.details = deepClone(this.details) ?? [];
          this.appointment.paymentSetting.methods = deepClone(this.paymentMethods) ?? [];
          this.appointment.lenders = deepClone(this.lenders) ?? [];
          this.appointment.payments = deepClone(this.payments) ?? [];
          this.appointment.checkPaymentsValidity();
          this.appointment.generateDocuments();
          this.appointmentService.storeAppointment(this.appointment);
          this.appointmentUiService.stopMakingPayments();
        }
      }
    });
  }
  save() {
    if (this.appointment?.paymentSetting != null && this.canSave) {
      this.promptToSave();
    }
  }
  isNaN(value) {
    return window.isNaN(value);
  }
  closeView() {
    this.uiService.prompt("Are you sure?", "Any unsaved changes to payment information will be lost. Are you sure you want to stop managing payments on the appointment?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.appointmentUiService.stopMakingPayments();
        }
      }
    });
  }
  init() {
    this.initMethods();
    this.initDetails();
    this.initPayments();
    this.initLenders();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.manualPaymentSubscription?.unsubscribe();
  }
};
_AppointmentPaymentsComponent.\u0275fac = function AppointmentPaymentsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentPaymentsComponent)(\u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(AppointmentUiService), \u0275\u0275directiveInject(PaymentsService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(CurrencyPipe));
};
_AppointmentPaymentsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentPaymentsComponent, selectors: [["appointment-payments"]], viewQuery: function AppointmentPaymentsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c07, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment" }, standalone: false, features: [\u0275\u0275ProvidersFeature([
  OrderByPipe,
  CurrencyPipe
])], decls: 55, vars: 13, consts: [["componentElm", ""], ["id", "appointmentPayments"], [1, "primary"], [1, "job"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "financing", "section"], [1, "lenders"], [1, "payments", "section"], [1, "message"], [1, "payment"], [1, "details", "section"], [1, "detail"], [1, "detail", "total"], [1, "amount"], [1, "value"], [1, "control", 3, "click", "disabled"], [1, "control", "success", 3, "click", "disabled"], [1, "lender"], [1, "fa-solid", "fa-trash"], [1, "details"], [1, "name"], [1, "input"], [3, "currencyOutput", "currencyInput"], [1, "application"], ["type", "text", 3, "ngModelChange", "ngModel"], [1, "applied"], [1, "control"], [1, "method"], [1, "timestamp"], [1, "fa-solid", "fa-pencil"], [1, "messages"], [1, "lender-amounts"], [3, "currencyOutput", "maxAmount", "minAmount", "update", "currencyInput"]], template: function AppointmentPaymentsComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h3");
    \u0275\u0275text(5, " Manage Payments for ");
    \u0275\u0275elementStart(6, "span", 3);
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 4)(9, "button", 5);
    \u0275\u0275listener("click", function AppointmentPaymentsComponent_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.closeView());
    });
    \u0275\u0275element(10, "i", 6);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(11, "div", 7)(12, "div", 8)(13, "header")(14, "h2");
    \u0275\u0275text(15, "Financing");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(16, "div", 7);
    \u0275\u0275conditionalCreate(17, AppointmentPaymentsComponent_Conditional_17_Template, 3, 0, "div", 9);
    \u0275\u0275elementStart(18, "div", 4);
    \u0275\u0275repeaterCreate(19, AppointmentPaymentsComponent_For_20_Template, 1, 1, null, null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(21, "div", 10)(22, "header")(23, "h2");
    \u0275\u0275text(24, "Payments Received");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(25, AppointmentPaymentsComponent_Conditional_25_Template, 3, 0, "div", 11);
    \u0275\u0275conditionalCreate(26, AppointmentPaymentsComponent_Conditional_26_Template, 3, 0, "div", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(27, "div", 7);
    \u0275\u0275repeaterCreate(28, AppointmentPaymentsComponent_For_29_Template, 21, 10, "div", 12, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(30, AppointmentPaymentsComponent_Conditional_30_Template, 3, 0, "div", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(31, "div", 13)(32, "header")(33, "h2");
    \u0275\u0275text(34, "Payment Details");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(35, AppointmentPaymentsComponent_Conditional_35_Template, 3, 0, "div", 11);
    \u0275\u0275conditionalCreate(36, AppointmentPaymentsComponent_Conditional_36_Template, 3, 0, "div", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(37, "div", 7);
    \u0275\u0275repeaterCreate(38, AppointmentPaymentsComponent_For_39_Template, 12, 9, "div", 14, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementStart(40, "div", 15)(41, "div", 7)(42, "label");
    \u0275\u0275text(43, "Total Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(44, "div", 16)(45, "span", 17);
    \u0275\u0275text(46);
    \u0275\u0275pipe(47, "currency");
    \u0275\u0275elementEnd()()()()()()();
    \u0275\u0275elementStart(48, "div", 4)(49, "button", 18);
    \u0275\u0275listener("click", function AppointmentPaymentsComponent_Template_button_click_49_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.makePayment());
    });
    \u0275\u0275elementStart(50, "label");
    \u0275\u0275text(51, "Record an External Payment");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(52, "button", 19);
    \u0275\u0275listener("click", function AppointmentPaymentsComponent_Template_button_click_52_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.save());
    });
    \u0275\u0275elementStart(53, "label");
    \u0275\u0275text(54, "Save & Close");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" Job ", ctx.appointment == null ? null : ctx.appointment.jobId, " ");
    \u0275\u0275advance(10);
    \u0275\u0275conditional(ctx.hasLenders ? 17 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.financeMethods);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx.showPaymentsWarning ? 25 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showInsufficientPaymentsWarning ? 26 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.payments);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.hasPayments ? 30 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx.paymentsMatchDeposit ? 35 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showMismatchedTotalWarning ? 36 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.details);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(47, 10, ctx.finalPrice, "USD"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canMakePayment);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canSave);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, CurrencyInputComponent, NgModel, CurrencyPipe, DatePipe], styles: ["\n\n#appointmentPayments[_ngcontent-%COMP%] {\n  position: relative;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 1vw 0;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%] {\n  width: 50%;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  max-height: 50vw;\n  overflow-x: hidden;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color2-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  position: sticky;\n  padding: 1vw;\n  top: 0;\n  z-index: 1;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message.warning[_ngcontent-%COMP%] {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 0 1vw;\n  z-index: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .section[_ngcontent-%COMP%]:last-child {\n  border-right: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.3vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .tips[_ngcontent-%COMP%]   .tip[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: block;\n  width: 100%;\n  font-size: 1.2vw;\n  color: var(--color4Alt4);\n  font-weight: var(--stdweight);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   currency-input[_ngcontent-%COMP%]     input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stronger);\n  text-align: right;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .messages[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: flex-end;\n  flex-direction: column;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  width: 90%;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   currency-input[_ngcontent-%COMP%]     input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lender-amounts[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content.editable[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .messages[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  margin-left: 5vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-bottom-style: solid;\n  border-bottom-color: var(--color2Alt3);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.total[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--successAlt3);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%] {\n  margin-left: 5vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  border-bottom-color: var(--color2Alt3);\n  border-bottom-style: solid;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.1vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail.remaining[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--errorAlt4);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  padding: 0.25vw 0.5vw;\n  border-radius: 0.5vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s;\n  -o-transition: border-color 0.2s;\n  -webkit-transition: border-color 0.2s;\n  transition: border-color 0.2s;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus {\n  border-color: var(--color3);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--error);\n  font-weight: var(--strong);\n  text-align: justify;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]:first-child, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]:first-child, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]:first-child, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .applied[_ngcontent-%COMP%]:first-child, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .application[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-top: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color2);\n  border: 0.1vw var(--color1) solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .lenders[_ngcontent-%COMP%]    > .lender[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  flex-direction: column;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  width: 100%;\n  position: relative;\n  margin-top: 1vw;\n  padding: 1.25vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--successAlt4);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n  display: block;\n  width: 100%;\n  text-align: center;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]:only-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]   label[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n  display: block;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .method[_ngcontent-%COMP%]:first-child, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]:first-child, \n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .timestamp[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 4vw;\n  background-color: var(--error);\n  cursor: pointer;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payment[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 0 2vw;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .payments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  text-align: center;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  background-color: var(--color1);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.EPayment[_ngcontent-%COMP%] {\n  background-color: var(--color5);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.Financing[_ngcontent-%COMP%] {\n  background-color: var(--successAlt3);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.Cash[_ngcontent-%COMP%], \n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.Check[_ngcontent-%COMP%] {\n  background-color: var(--color1);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#appointmentPayments[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=appointment-payments.component.css.map */"] });
var AppointmentPaymentsComponent = _AppointmentPaymentsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentPaymentsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "appointment-payments", providers: [
      OrderByPipe,
      CurrencyPipe
    ], template: `<section id="appointmentPayments" #componentElm>
  <header>
    <div class="primary">
      <h3>
        Manage Payments for
        <span class="job">
          Job {{appointment?.jobId}}
        </span>
      </h3>
    </div>
    <div class="controls">
      <button class="control" (click)="closeView()">
        <i class="fa-solid fa-xmark"></i>
      </button>
    </div>
  </header>

  <div class="content">
    <div class="financing section">
      <header>
        <h2>Financing</h2>
      </header>

      <div class="content">
        @if (hasLenders) {
          <div class="lenders">
            @for (lender of lenders; track lender) {
              <div class="lender">
                <button class="control" (click)="promptToRemoveLender(lender)">
                  <i class="fa-solid fa-trash"></i>
                </button>
                <div class="details">
                  <div class="name">
                    <label>Lender</label>
                    <span class="value">
                      {{lender.name}}
                    </span>
                  </div>
                  <div class="amount">
                    <label>Approved Amount</label>
                    <div class="input">
                      <currency-input (currencyOutput)="updateLenderAmount(lender,$event)"
                      [currencyInput]="lender.amountFinanced"></currency-input>
                    </div>
                    @if (lender.amountFinanced != null && lender.amountFinanced <= 0) {
                      <p class="message">
                        You must indicate an approval amount greater than $0.00 to include this lender on
                        the job.
                      </p>
                    }
                  </div>
                  <div class="application">
                    <label>Application Id</label>
                    <div class="input">
                      <input [(ngModel)]="lender.applicationId" type="text" />
                    </div>
                    @if (lender.applicationId == null) {
                      <p class="message">
                        You must indicate an application Id.
                      </p>
                    }
                  </div>
                  @if (lender.applied_Utc != null) {
                    <div class="applied">
                      <label>Applied On</label>
                      <span class="value">
                        {{lender.applied_Utc | date: 'MM/dd/yyyy hh:mm a z'}}
                      </span>
                    </div>
                  }
                  <!-- <div class="controls">
                  <button class="control" (click)="applyForFinancing(lender)" *ngIf="!lender.applied">
                    <label>Apply for Financing</label>
                  </button>
                </div> -->
              </div>
            </div>
          }
        </div>
      }
      <div class="controls">
        @for (method of financeMethods; track method) {
          @if (!method.added) {
            <button class="control" (click)="addLender(method)">
              <label>
                Add {{method.name}}
              </label>
            </button>
          }
        }
      </div>
    </div>
  </div>
  <div class="payments section">
    <header>
      <h2>Payments Received</h2>

      @if (showPaymentsWarning) {
        <div class="message">
          <p>A payment is required to finalize the job.</p>
        </div>
      }

      @if (showInsufficientPaymentsWarning) {
        <div class="message">
          <p>Your total payments must at least meet the deposit amount to finalize the job.</p>
        </div>
      }
    </header>

    <div class="content">
      @for (payment of payments; track payment; let i = $index) {
        <div class="payment">
          <button class="control" [disabled]="!payment.appliedManually" (click)="removePayment(i)">
            <i class="fa-solid fa-trash"></i>
          </button>
          <div class="details">
            <div class="method">
              <label>Payment Method</label>
              <span class="value">
                {{payment.paymentMethod?.name}}
              </span>
            </div>
            <div class="amount">
              <label>Payment Amount</label>
              <span class="value">
                {{payment.amount | currency:payment.iso4217}}
              </span>
            </div>
            <div class="timestamp">
              <label>Timestamp</label>
              <span class="value">
                {{payment.timeStamp_Utc | date: 'MM/dd/yyyy hh:mm a'}}
              </span>
            </div>
          </div>
        </div>
      }
    </div>

    @if (!hasPayments) {
      <div class="message">
        <p>
          No payments have yet been recorded on this appointment.
        </p>
      </div>
    }
  </div>
  <div class="details section">
    <header>
      <h2>Payment Details</h2>

      @if (!paymentsMatchDeposit) {
        <div class="message">
          <p>Your recorded payments don't match the deposit amount. Are you sure your payment details are correct?</p>
        </div>
      }

      @if (showMismatchedTotalWarning) {
        <div class="message">
          <p>Your payment details don't match the total price of the job.</p>
        </div>
      }
    </header>

    <div class="content">
      @for (detail of details; track detail) {
        <div class="detail">
          <div class="content" [class.editable]="detail.canEditAmount">
            <label>
              @if (detail.canEditAmount) {
                <i class="fa-solid fa-pencil"></i>
              }
              {{detail.name}}
            </label>
            <div class="amount">
              @if (detail.canEditAmount) {
                <div class="input">
                  <currency-input
                    [maxAmount]="detail.maximumAmount"
                    [minAmount]="detail.minimumAmount"
                    [update]="detail.updatedAmount$"
                    (currencyOutput)="updateDetail($event,detail)"
                  [currencyInput]="detail.amount"></currency-input>
                </div>
              }
              @if (!detail.canEditAmount) {
                <span class="value">
                  {{detail.amount | currency:'USD'}}
                </span>
              }
              <div class="messages">
                @if (detail.maximumAmount != null && detail.amount > detail.maximumAmount) {
                  <p class="message"
                    >
                    The specified amount must be lower than {{detail.maximumAmount | currency:'USD'}}.
                  </p>
                }
                @if (detail.amount < detail.minimumAmount) {
                  <p class="message">
                    The specified amount must be higher than {{detail.minimumAmount | currency:'USD'}}.
                  </p>
                }
              </div>
            </div>
            @if (detail.lenderAmounts.length > 0) {
              <div class="lender-amounts">
                @for (amount of detail.lenderAmounts; track amount) {
                  <div class="amount">
                    <label>
                      Amount Financed by {{amount.name}}
                    </label>
                    <div class="input">
                      <currency-input (currencyOutput)="updateDetailLenderAmount($event,amount)"
                      [currencyInput]="amount.amount"></currency-input>
                    </div>
                    @if (amount.amount == null) {
                      <p class="message">
                        You must enter an amount, even if it's $0.00.
                      </p>
                    }
                  </div>
                }
              </div>
            }
          </div>
        </div>
      }
      <div class="detail total">
        <div class="content">
          <label>Total Amount</label>
          <div class="amount">
            <span class="value">
              {{finalPrice | currency:'USD'}}
            </span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="controls">
  <!-- <button class="control {{method.type}}" *ngFor="let method of transactMethods" [disabled]="!canMakePayment"
  (click)="makePayment(method)">
  <label *ngIf="method.type == PaymentMethodType.Financing">
    Apply for {{method.name}}
  </label>
  <label *ngIf="method.type == PaymentMethodType.EPayment">Pay by {{method.name}}</label>
</button> -->
<button class="control" [disabled]="!canMakePayment" (click)="makePayment()">
  <label>Record an External Payment</label>
</button>
<button class="control success" [disabled]="!canSave" (click)="save()">
  <label>Save & Close</label>
</button>
</div>
</section>`, styles: ["/* src/app/shared/appointments/components/appointment-payments/appointment-payments.component.scss */\n#appointmentPayments {\n  position: relative;\n}\n#appointmentPayments > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#appointmentPayments > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#appointmentPayments > header > .primary > h3 > .job {\n  color: var(--color5);\n}\n#appointmentPayments > header > .controls > .control {\n  cursor: pointer;\n}\n#appointmentPayments > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#appointmentPayments > .content {\n  padding: 1vw 0;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n}\n#appointmentPayments > .content > .section {\n  width: 50%;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  max-height: 50vw;\n  overflow-x: hidden;\n}\n#appointmentPayments > .content > .section > header {\n  background-color: rgba(var(--color2-raw), 0.8);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  position: sticky;\n  padding: 1vw;\n  top: 0;\n  z-index: 1;\n}\n#appointmentPayments > .content > .section > header h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#appointmentPayments > .content > .section > header > .message {\n  margin-top: 0.5vw;\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#appointmentPayments > .content > .section > header > .message p {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#appointmentPayments > .content > .section > header > .message.warning {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#appointmentPayments > .content > .section > .content {\n  position: relative;\n  padding: 0 1vw;\n  z-index: 0;\n}\n#appointmentPayments > .content > .section:last-child {\n  border-right: none;\n}\n#appointmentPayments > .content > .details > .content > .detail {\n  margin-top: 1vw;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content {\n  width: 100%;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > label {\n  display: block;\n  width: 100%;\n  font-size: 1.3vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .tips .tip {\n  margin-top: 0.25vw;\n  display: block;\n  width: 100%;\n  font-size: 1.2vw;\n  color: var(--color4Alt4);\n  font-weight: var(--stdweight);\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .amount {\n  margin-top: 0.25vw;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .amount > .input {\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .amount > .input currency-input ::ng-deep input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .amount > .value {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stronger);\n  text-align: right;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .amount > .messages > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts {\n  margin-top: 0.25vw;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts > .amount {\n  margin-top: 0.25vw;\n  display: flex;\n  align-items: flex-end;\n  flex-direction: column;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts > .amount > label {\n  font-size: 1.2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts > .amount > .input {\n  width: 90%;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts > .amount > .input currency-input ::ng-deep input {\n  display: block;\n  width: 100%;\n  text-align: right;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts > .amount > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#appointmentPayments > .content > .details > .content > .detail > .content > .lender-amounts > .amount:first-child {\n  margin-top: 0;\n}\n#appointmentPayments > .content > .details > .content > .detail > .content.editable > label {\n  color: var(--color1);\n}\n#appointmentPayments > .content > .details > .content > .detail > .messages > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#appointmentPayments > .content > .details > .content > .detail.total {\n  margin-top: 2vw;\n  margin-left: 5vw;\n}\n#appointmentPayments > .content > .details > .content > .detail.total > .content {\n  border-bottom-style: solid;\n  border-bottom-color: var(--color2Alt3);\n}\n#appointmentPayments > .content > .details > .content > .detail.total > .content > label {\n  font-size: 1.2vw;\n}\n#appointmentPayments > .content > .details > .content > .detail.total > .content > .amount > .value {\n  font-size: 1.4vw;\n  color: var(--successAlt3);\n}\n#appointmentPayments > .content > .details > .content > .detail.remaining {\n  margin-left: 5vw;\n}\n#appointmentPayments > .content > .details > .content > .detail.remaining > .content {\n  border-bottom-color: var(--color2Alt3);\n  border-bottom-style: solid;\n}\n#appointmentPayments > .content > .details > .content > .detail.remaining > .content > label {\n  font-size: 1.1vw;\n}\n#appointmentPayments > .content > .details > .content > .detail.remaining > .content > .amount > .value {\n  font-size: 1.2vw;\n  color: var(--errorAlt4);\n}\n#appointmentPayments > .content > .details > .content > .detail:first-child {\n  margin-top: 0;\n}\n#appointmentPayments > .content > .financing > .content > .lenders > .lender {\n  margin-top: 1vw;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n  position: relative;\n}\n#appointmentPayments > .content > .financing > .content > .lenders > .lender > .details {\n  margin-left: 4vw;\n  flex: 1;\n  padding: 1vw 1.5vw;\n}\n#appointmentPayments > .content > .financing > .content > .lenders > .lender > .details > .name,\n#appointmentPayments > .content > .financing > .content > .lenders > .lender > .details > .amount,\n#appointmentPayments > .content > .financing > .content > .lenders > .lender > .details > .timestamp,\n#appointmentPa