import {
  SortOption
} from "./chunk-HY3MWTYR.js";
import {
  OpportunitySummaryComponent,
  SharedOpportunityModule
} from "./chunk-ILT2E66G.js";
import "./chunk-ZIGK756M.js";
import "./chunk-BVPRWDLB.js";
import "./chunk-ZEKYPX2O.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  AppointmentService
} from "./chunk-RSQODXYC.js";
import "./chunk-MSDZORKH.js";
import "./chunk-HJJU6GQE.js";
import "./chunk-JKLRDWLP.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  LogService,
  OpportunityService
} from "./chunk-MSWJJQQ3.js";
import "./chunk-HRZODZCB.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import "./chunk-IVJ6NEFT.js";
import {
  ApiService
} from "./chunk-LCOXJZOJ.js";
import {
  AuthRefService,
  OpportunityStatus,
  StorageService
} from "./chunk-M3LFBN7N.js";
import "./chunk-N36JE2BE.js";
import "./chunk-4HOJYYKK.js";
import {
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  DefaultValueAccessor,
  FormsModule,
  Injectable,
  Injector,
  Input,
  LoaderComponent,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  OrderByPipe,
  ReactiveFormsModule,
  Router,
  SelectControlValueAccessor,
  UiModule,
  ViewChild,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵreference,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-IT26RCSL.js";
import "./chunk-RVA4KI76.js";

// src/app/book-of-business/models/navigation.ts
var AppointmentsRouteType;
(function(AppointmentsRouteType2) {
  AppointmentsRouteType2["all"] = "all";
})(AppointmentsRouteType || (AppointmentsRouteType = {}));

// src/app/book-of-business/services/bookofbusiness.service.ts
var _BookOfBusinessService = class _BookOfBusinessService {
  constructor(appointmentService, storageService, routeService) {
    this.appointmentService = appointmentService;
    this.storageService = storageService;
    this.routeService = routeService;
    this.routesInitialized = false;
  }
  initRoutes(initialRouteType = void 0, componentElm) {
    setTimeout(() => {
      if (componentElm != null) {
        const routes = {
          [AppointmentsRouteType.all]: new InternalRoute(AppointmentsRouteType.all)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : AppointmentsRouteType.all;
        this.routeService.init(routes, initialRoute, 250, componentElm);
        this.routesInitialized = true;
      }
    }, 0);
  }
};
_BookOfBusinessService.\u0275fac = function BookOfBusinessService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _BookOfBusinessService)(\u0275\u0275inject(AppointmentService), \u0275\u0275inject(StorageService), \u0275\u0275inject(InternalRouteService));
};
_BookOfBusinessService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _BookOfBusinessService, factory: _BookOfBusinessService.\u0275fac, providedIn: "root" });
var BookOfBusinessService = _BookOfBusinessService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(BookOfBusinessService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: AppointmentService }, { type: StorageService }, { type: InternalRouteService }], null);
})();

// src/app/book-of-business/components/all/all.component.ts
var _c0 = ["componentElm"];
function AllComponent_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 4);
    \u0275\u0275listener("click", function AllComponent_Conditional_6_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r1);
      const uploadElm_r2 = \u0275\u0275reference(3);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.selectUpload(uploadElm_r2));
    });
    \u0275\u0275element(1, "i", 17);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(2, "input", 18, 0);
    \u0275\u0275listener("input", function AllComponent_Conditional_6_Template_input_input_2_listener() {
      \u0275\u0275restoreView(_r1);
      const uploadElm_r2 = \u0275\u0275reference(3);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.selectFile(uploadElm_r2));
    });
    \u0275\u0275elementEnd();
  }
}
function AllComponent_For_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 12);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const option_r4 = ctx.$implicit;
    \u0275\u0275property("ngValue", option_r4.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(option_r4.name);
  }
}
function AllComponent_Conditional_18_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 13);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", true);
  }
}
function AllComponent_Conditional_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "p");
    \u0275\u0275text(2, "You are currently offline.");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4, " Your device will retrieve the latest appointments when it comes back online. ");
    \u0275\u0275elementEnd()();
  }
}
function AllComponent_Conditional_20_For_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19);
    \u0275\u0275element(1, "opportunity-summary", 21);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const opportunity_r5 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("opportunity", opportunity_r5);
  }
}
function AllComponent_Conditional_20_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275repeaterCreate(0, AllComponent_Conditional_20_For_1_Template, 2, 1, "div", 19, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementStart(2, "div", 20)(3, "p");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "p");
    \u0275\u0275text(6, "Use the search if you're looking for a specific appointment.");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275repeater(ctx_r2.visibleOpportunities);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" Showing ", ctx_r2.visibleOpportunities.length, " of the most recent appointments. ");
  }
}
function AllComponent_Conditional_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 15)(1, "p");
    \u0275\u0275text(2, "No appointments available.");
    \u0275\u0275elementEnd()();
  }
}
function AllComponent_Conditional_22_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "loader", 16);
  }
  if (rf & 2) {
    \u0275\u0275property("fill", true);
  }
}
var _AllComponent = class _AllComponent {
  constructor(router, bookOfBusinessService, apiService, authRefService, opportunityService, appointmentService, storageService, logService, uiService, orderByPipe) {
    this.router = router;
    this.bookOfBusinessService = bookOfBusinessService;
    this.apiService = apiService;
    this.authRefService = authRefService;
    this.opportunityService = opportunityService;
    this.appointmentService = appointmentService;
    this.storageService = storageService;
    this.logService = logService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.activeUser = null;
    this.online = false;
    this.opportunities = [];
    this.visibleOpportunities = [];
    this.updatingOpportunities = false;
    this.searchInput = "";
    this.sortOptions = [];
    this.statusOptions = [];
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Admin
  get showUploadControl() {
    return this.activeUser != null && this.activeUser.emailAddress == "jeffrey.wilbur@repipespecialists.com";
  }
  uploadAppointment(file) {
    const reader = new FileReader();
    reader.onload = (ev) => {
      try {
        const appointment = JSON.parse(ev.target?.result);
        this.appointmentService.storeAppointment(appointment, true);
      } catch (err) {
        console.error(`INVALID APPOINTMENT JSON TO UPLOAD: ${JSON.stringify(err)}`);
      }
    };
    reader.readAsText(file);
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.uploadAppointment(file);
    }
  }
  selectUpload(fileInputElm) {
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  watchSync() {
    this.onlineSubscription = this.apiService.online.subscribe({
      next: (online) => {
        if (online && !this.online) {
          this.syncOpportunities();
        } else if (!online && this.online != online) {
          this.getLocalOpportunities();
        }
        this.online = online;
      }
    });
  }
  promptToSyncAllOpportunities() {
    this.syncOpportunities(true);
  }
  syncOpportunities(forceAll = false) {
    if (!this.updatingOpportunities) {
      this.updatingOpportunities = true;
      if (this.activeUser != null) {
        this.opportunityService.syncOpportunitiesForUser(this.activeUser.id, forceAll).subscribe({
          next: (opportunities) => {
            this.getLocalOpportunities();
          },
          error: () => {
            this.updatingOpportunities = false;
          }
        });
      }
    }
  }
  get hasVisibleOpportunities() {
    return this.visibleOpportunities.length > 0;
  }
  get showVisibleOpportunities() {
    return this.hasVisibleOpportunities && !this.updatingOpportunities;
  }
  get showMissingOpportunitiesMessage() {
    return !this.hasVisibleOpportunities && !this.updatingOpportunities;
  }
  get showOpportunitiesLoader() {
    return this.updatingOpportunities;
  }
  getLocalOpportunities() {
    if (this.activeUser != null) {
      this.updatingOpportunities = true;
      if (this.activeStatus != null) {
        this.opportunityService.getOpportunitiesByStatus(this.activeStatus, this.activeUser.id).subscribe({
          next: (opportunities) => {
            this.updateOpportunities(opportunities);
            this.updatingOpportunities = false;
          }
        });
      } else {
        this.opportunityService.getOpportunitiesForUser(this.activeUser.id).subscribe({
          next: (opportunities) => {
            this.updateOpportunities(opportunities);
            this.updatingOpportunities = false;
          }
        });
      }
    }
  }
  updateOpportunities(opportunities) {
    this.visibleOpportunities = this.orderByPipe.transform(opportunities, "scheduled_Utc", true);
  }
  searchOpportunities() {
    window.clearTimeout(this.searchDebounce);
    this.searchDebounce = window.setTimeout(() => {
      this.updatingOpportunities = true;
      if (this.searchInput.length > 0) {
        if (this.activeUser != null) {
          this.opportunityService.searchOpportunities(this.searchInput, this.activeUser.id, this.activeStatus).subscribe({
            next: (opportunities) => {
              this.updateOpportunities(opportunities);
              setTimeout(() => {
                this.updatingOpportunities = false;
              }, 1e3);
            }
          });
        }
      } else {
        this.getLocalOpportunities();
      }
    }, 500);
  }
  filterOpportunities() {
    this.getLocalOpportunities();
  }
  initSortOptions() {
    const sortOptions = [];
    const statusOptions = [];
    sortOptions.push(new SortOption("scheduled_Utc", "Scheduled"));
    sortOptions.push(new SortOption("lastUpdated_Utc", "Last Updated"));
    this.activeSort = sortOptions[0].id;
    statusOptions.push(new SortOption(void 0, "All"));
    statusOptions.push(new SortOption(OpportunityStatus.Open, "Open"));
    statusOptions.push(new SortOption(OpportunityStatus.Dispositioned, "Dispositioned"));
    statusOptions.push(new SortOption(OpportunityStatus.InProgress, "In Progress"));
    statusOptions.push(new SortOption(OpportunityStatus.PendingSignatures, "Waiting for Signature"));
    statusOptions.push(new SortOption(OpportunityStatus.PendingSubmission, "Waiting to Submit"));
    statusOptions.push(new SortOption(OpportunityStatus.Submitted, "Submitted"));
    this.activeStatus = void 0;
    this.sortOptions = sortOptions;
    this.statusOptions = statusOptions;
  }
  // #endregion
  // #region Ledger
  syncLedger() {
    this.storageService.remoteStoreOpportunityLedgerEntries().subscribe({
      next: () => {
      },
      error: (e) => {
        this.logService.log(JSON.stringify(e), `BOOKOFBUSINESS: Failed to remotely store outstanding ledger entries.`).subscribe();
      }
    });
  }
  get showLoader() {
    return this.updatingOpportunities;
  }
  init() {
    this.initSortOptions();
    this.watchUser();
    this.watchSync();
    this.syncLedger();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
    this.appointmentSubscription?.unsubscribe();
    this.onlineSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_AllComponent.\u0275fac = function AllComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AllComponent)(\u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(BookOfBusinessService), \u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(StorageService), \u0275\u0275directiveInject(LogService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_AllComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AllComponent, selectors: [["all"]], viewQuery: function AllComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { route: "route" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 23, vars: 8, consts: [["uploadElm", ""], ["id", "allAppointments"], [1, "content"], [1, "icon-controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrows-rotate"], [1, "search"], [1, "input"], ["type", "text", "placeholder", "Search appointments...", 3, "ngModelChange", "input", "ngModel"], [1, "sorting"], [1, "control"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [3, "fill"], [1, "warning"], [1, "message"], ["id", "syncLoader", 3, "fill"], [1, "fa-solid", "fa-upload"], ["type", "file", "accept", ".json,application/json", 3, "input"], [1, "opportunity"], [1, "message", "subtle"], [3, "opportunity"]], template: function AllComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1)(1, "header")(2, "div", 2)(3, "div", 3)(4, "button", 4);
    \u0275\u0275listener("click", function AllComponent_Template_button_click_4_listener() {
      return ctx.promptToSyncAllOpportunities();
    });
    \u0275\u0275element(5, "i", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(6, AllComponent_Conditional_6_Template, 4, 0);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "div", 6)(8, "div", 7)(9, "input", 8);
    \u0275\u0275twoWayListener("ngModelChange", function AllComponent_Template_input_ngModelChange_9_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.searchInput, $event) || (ctx.searchInput = $event);
      return $event;
    });
    \u0275\u0275listener("input", function AllComponent_Template_input_input_9_listener() {
      return ctx.searchOpportunities();
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(10, "div", 9)(11, "div", 10)(12, "label");
    \u0275\u0275text(13, "Status");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "div", 7)(15, "select", 11);
    \u0275\u0275twoWayListener("ngModelChange", function AllComponent_Template_select_ngModelChange_15_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.activeStatus, $event) || (ctx.activeStatus = $event);
      return $event;
    });
    \u0275\u0275listener("change", function AllComponent_Template_select_change_15_listener() {
      return ctx.filterOpportunities();
    });
    \u0275\u0275repeaterCreate(16, AllComponent_For_17_Template, 2, 2, "option", 12, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275conditionalCreate(18, AllComponent_Conditional_18_Template, 1, 1, "loader", 13);
    \u0275\u0275conditionalCreate(19, AllComponent_Conditional_19_Template, 5, 0, "div", 14);
    \u0275\u0275conditionalCreate(20, AllComponent_Conditional_20_Template, 7, 1);
    \u0275\u0275conditionalCreate(21, AllComponent_Conditional_21_Template, 3, 0, "div", 15);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(22, AllComponent_Conditional_22_Template, 1, 1, "loader", 16);
  }
  if (rf & 2) {
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx.showUploadControl ? 6 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275twoWayProperty("ngModel", ctx.searchInput);
    \u0275\u0275advance(6);
    \u0275\u0275twoWayProperty("ngModel", ctx.activeStatus);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.statusOptions);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.showOpportunitiesLoader ? 18 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.online ? 19 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showVisibleOpportunities ? 20 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showMissingOpportunitiesMessage ? 21 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showLoader ? 22 : -1);
  }
}, dependencies: [LoaderComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, OpportunitySummaryComponent, NgModel], styles: ["\n\n#allAppointments[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  padding: calc(6vw + var(--systemOffset-top)) 5vw 5vw 5vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%] {\n  padding-left: 1vw;\n  display: flex;\n  align-items: center;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  cursor: pointer;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color3);\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-transform: uppercase;\n  font-size: 0.7vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon-controls[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  position: absolute;\n  visibility: hidden;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 0 2vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.8vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%] {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  display: flex;\n  align-items: center;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#allAppointments[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#allAppointments[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: calc(20vh + var(--systemOffset-top));\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 1s;\n}\n#allAppointments[_ngcontent-%COMP%]    > .opportunity[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#allAppointments[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%] {\n  width: 95%;\n  margin: 2vw auto;\n  background-color: var(--color5Alt3);\n  border: 0.2vw var(--color5Alt4) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#allAppointments[_ngcontent-%COMP%]    > .warning[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#allAppointments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 3.2vw;\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n#allAppointments[_ngcontent-%COMP%]    > .message.subtle[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#allAppointments[_ngcontent-%COMP%]    > .message.subtle[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  position: relative;\n  top: initial;\n  font-size: 2.2vw;\n}\n#syncLoader[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  right: 0.5vw;\n  bottom: 0.5vw;\n  width: 3vw;\n  height: 3vw;\n  --fillSpeed: 2s;\n}\n/*# sourceMappingURL=all.component.css.map */"] });
var AllComponent = _AllComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AllComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "all", providers: [OrderByPipe], template: `<section id="allAppointments">
  <header>
    <div class="content">
      <div class="icon-controls">
        <button class="control" (click)="promptToSyncAllOpportunities()">
          <i class="fa-solid fa-arrows-rotate"></i>
        </button>
        @if (showUploadControl) {
          <button class="control" (click)="selectUpload(uploadElm)">
            <i class="fa-solid fa-upload"></i>
          </button>
          <input
            #uploadElm
            (input)="selectFile(uploadElm)"
            type="file"
            accept=".json,application/json"
          />
        }
      </div>
      <div class="search">
        <div class="input">
          <input
            type="text"
            [(ngModel)]="searchInput"
            (input)="searchOpportunities()"
            placeholder="Search appointments..."
          />
        </div>
      </div>
      <div class="sorting">
        <div class="control">
          <label>Status</label>
          <div class="input">
            <select [(ngModel)]="activeStatus" (change)="filterOpportunities()">
              @for (option of statusOptions; track option) {
                <option [ngValue]="option.id">{{ option.name }}</option>
              }
            </select>
          </div>
        </div>
      </div>
    </div>
  </header>

  @if (showOpportunitiesLoader) {
    <loader [fill]="true"></loader>
  }

  @if (!online) {
    <div class="warning">
      <p>You are currently offline.</p>
      <p>
        Your device will retrieve the latest appointments when it comes back
        online.
      </p>
    </div>
  }

  @if (showVisibleOpportunities) {
    @for (opportunity of visibleOpportunities; track opportunity) {
      <div class="opportunity">
        <opportunity-summary [opportunity]="opportunity"> </opportunity-summary>
      </div>
    }
    <div class="message subtle">
      <p>
        Showing {{ visibleOpportunities.length }} of the most recent
        appointments.
      </p>
      <p>Use the search if you're looking for a specific appointment.</p>
    </div>
  }

  @if (showMissingOpportunitiesMessage) {
    <div class="message">
      <p>No appointments available.</p>
    </div>
  }
</section>

@if (showLoader) {
  <loader id="syncLoader" [fill]="true"></loader>
}
`, styles: ["/* src/app/book-of-business/components/all/all.component.scss */\n#allAppointments {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  padding: calc(6vw + var(--systemOffset-top)) 5vw 5vw 5vw;\n}\n#allAppointments > header {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n}\n#allAppointments > header > .content {\n  display: flex;\n  align-items: center;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#allAppointments > header > .content > .icon-controls {\n  padding-left: 1vw;\n  display: flex;\n  align-items: center;\n}\n#allAppointments > header > .content > .icon-controls > .control {\n  margin-left: 1vw;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  cursor: pointer;\n}\n#allAppointments > header > .content > .icon-controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color3);\n}\n#allAppointments > header > .content > .icon-controls > .control > label {\n  margin-top: 0.25vw;\n  text-transform: uppercase;\n  font-size: 0.7vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n}\n#allAppointments > header > .content > .icon-controls > .control:first-child {\n  margin-left: 0;\n}\n#allAppointments > header > .content > .icon-controls > input {\n  position: absolute;\n  visibility: hidden;\n}\n#allAppointments > header > .content > .search {\n  flex: 1;\n  padding: 0 2vw;\n}\n#allAppointments > header > .content > .search > .input input {\n  display: block;\n  width: 100%;\n  font-size: 1.8vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#allAppointments > header > .content > .sorting {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  display: flex;\n  align-items: center;\n}\n#allAppointments > header > .content > .sorting > .control {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#allAppointments > header > .content > .sorting > .control > label {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#allAppointments > header > .content > .sorting > .control > .input select {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#allAppointments > header > .content > .sorting > .control:first-child {\n  margin-left: 0;\n}\n#allAppointments > loader {\n  display: block;\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: calc(20vh + var(--systemOffset-top));\n  width: 10vw;\n  height: 10vw;\n  --fillSpeed: 1s;\n}\n#allAppointments > .opportunity {\n  margin-top: 2vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n}\n#allAppointments > .warning {\n  width: 95%;\n  margin: 2vw auto;\n  background-color: var(--color5Alt3);\n  border: 0.2vw var(--color5Alt4) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#allAppointments > .warning p {\n  font-size: 1.2vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#allAppointments > .message {\n  margin-top: 2vw;\n}\n#allAppointments > .message > p {\n  font-size: 3.2vw;\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n#allAppointments > .message.subtle {\n  margin-top: 2vw;\n}\n#allAppointments > .message.subtle > p {\n  position: relative;\n  top: initial;\n  font-size: 2.2vw;\n}\n#syncLoader {\n  display: block;\n  position: absolute;\n  right: 0.5vw;\n  bottom: 0.5vw;\n  width: 3vw;\n  height: 3vw;\n  --fillSpeed: 2s;\n}\n/*# sourceMappingURL=all.component.css.map */\n"] }]
  }], () => [{ type: Router }, { type: BookOfBusinessService }, { type: ApiService }, { type: AuthRefService }, { type: OpportunityService }, { type: AppointmentService }, { type: StorageService }, { type: LogService }, { type: UiService }, { type: OrderByPipe }], { route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AllComponent, { className: "AllComponent" });
})();

// src/app/book-of-business/components/layout/layout.component.ts
var _c02 = ["componentElm"];
function AppointmentsLayoutComponent_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "all", 6);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.animating)("closing", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.closing)("rendered", ctx_r0.allRoute == null ? null : ctx_r0.allRoute.rendered);
    \u0275\u0275property("route", ctx_r0.allRoute);
  }
}
var _AppointmentsLayoutComponent = class _AppointmentsLayoutComponent {
  constructor(bookOfBusinessService) {
    this.bookOfBusinessService = bookOfBusinessService;
    this.params = new BehaviorSubject([]);
    this.routeParams = new BehaviorSubject([]);
    this.routeLabel = "Appointments";
  }
  get routesInitialized() {
    return this.bookOfBusinessService.routesInitialized;
  }
  get routes() {
    return this.bookOfBusinessService.routeService.routes;
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        const componentElm = this.componentElm?.nativeElement;
        if (componentElm != null) {
          let route = params[0]?.toLowerCase();
          if (route != null) {
            const routeMatches = Object.values(AppointmentsRouteType).includes(route);
            const routeParams = params.slice(1);
            this.routeParams.next(routeParams);
            if (routeMatches) {
              if (!this.routesInitialized) {
                this.bookOfBusinessService.initRoutes(route, componentElm);
              } else {
                this.viewRoute(route);
              }
            } else {
              if (!this.routesInitialized) {
                this.bookOfBusinessService.initRoutes(void 0, componentElm);
              }
            }
          } else {
            if (!this.routesInitialized) {
              this.bookOfBusinessService.initRoutes(void 0, componentElm);
            }
          }
        }
      }
    });
  }
  viewRoute(name) {
    if (name != null) {
      this.bookOfBusinessService.routeService.viewRoute(name, RouteLoadDirection.Forward, true);
    }
  }
  watchRoute() {
    this.routeSubscription = this.bookOfBusinessService.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
            case AppointmentsRouteType.all:
              {
                this.routeLabel = "Appointments";
              }
              break;
          }
        }
      }
    });
  }
  initRouting() {
    setTimeout(() => {
      this.watchParams();
      this.watchRoute();
    }, 0);
  }
  // #endregion
  // #region All
  get allRoute() {
    return this.routes[AppointmentsRouteType.all];
  }
  init() {
    this.initRouting();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.paramsSubscription?.unsubscribe();
    this.routeSubscription?.unsubscribe();
  }
};
_AppointmentsLayoutComponent.\u0275fac = function AppointmentsLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentsLayoutComponent)(\u0275\u0275directiveInject(BookOfBusinessService));
};
_AppointmentsLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentsLayoutComponent, selectors: [["ng-component"]], viewQuery: function AppointmentsLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 11, vars: 2, consts: [["componentElm", ""], ["id", "appointmentsLayout"], [1, "primary"], [1, "secondary"], [1, "routes"], [3, "class", "animate", "closing", "rendered", "route"], [3, "route"]], template: function AppointmentsLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h1");
    \u0275\u0275text(5, "Book of Business");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "div", 3)(7, "h2");
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 4);
    \u0275\u0275conditionalCreate(10, AppointmentsLayoutComponent_Conditional_10_Template, 1, 10, "all", 5);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx.routeLabel);
    \u0275\u0275advance(2);
    \u0275\u0275conditional((ctx.allRoute == null ? null : ctx.allRoute.active) ? 10 : -1);
  }
}, dependencies: [AllComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#appointmentsLayout[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#appointmentsLayout[_ngcontent-%COMP%]    > .loader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var AppointmentsLayoutComponent = _AppointmentsLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentsLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '<section id="appointmentsLayout" #componentElm>\n  <header>\n    <div class="primary">\n      <h1>Book of Business</h1>\n    </div>\n    <div class="secondary">\n      <h2>{{routeLabel}}</h2>\n    </div>\n  </header>\n\n  <div class="routes">\n    @if (allRoute?.active) {\n      <all class="route {{allRoute?.loadDirection}}"\n        [class.animate]="allRoute?.animating"\n        [class.closing]="allRoute?.closing"\n        [class.rendered]="allRoute?.rendered"\n      [route]="allRoute"></all>\n    }\n  </div>\n\n</section>', styles: ["/* src/app/book-of-business/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#appointmentsLayout {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#appointmentsLayout > header {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#appointmentsLayout > header > .primary h1 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#appointmentsLayout > header > .secondary {\n  margin-left: 1vw;\n}\n#appointmentsLayout > header > .secondary h2 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#appointmentsLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#appointmentsLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#appointmentsLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#appointmentsLayout > .loader {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#appointmentsLayout > .loader > loader {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#appointmentsLayout > .loader.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: BookOfBusinessService }], { params: [{
    type: Input,
    args: ["params"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AppointmentsLayoutComponent, { className: "AppointmentsLayoutComponent" });
})();

// src/app/book-of-business/book-of-business.module.ts
var _BookOfBusinessModule = class _BookOfBusinessModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    if (!customElements.get("global-bookofbusiness")) {
      const el = createCustomElement(AppointmentsLayoutComponent, { injector: this.injector });
      customElements.define("global-bookofbusiness", el);
    }
  }
};
_BookOfBusinessModule.\u0275fac = function BookOfBusinessModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _BookOfBusinessModule)(\u0275\u0275inject(Injector));
};
_BookOfBusinessModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _BookOfBusinessModule });
_BookOfBusinessModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  BookOfBusinessService,
  InternalRouteService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  CommonModule,
  UiModule,
  ReactiveFormsModule,
  SharedOpportunityModule,
  FormsModule
] });
var BookOfBusinessModule = _BookOfBusinessModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(BookOfBusinessModule, [{
    type: NgModule,
    args: [{
      declarations: [
        AppointmentsLayoutComponent,
        AllComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        CommonModule,
        UiModule,
        ReactiveFormsModule,
        SharedOpportunityModule,
        FormsModule
      ],
      providers: [
        BookOfBusinessService,
        InternalRouteService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  BookOfBusinessModule
};
//# sourceMappingURL=chunk-3FGMFHL2.js.map
