import {
  AppointmentUiService
} from "./chunk-CH5VOHLL.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  AppointmentStatus
} from "./chunk-N36JE2BE.js";
import {
  Injectable,
  Subject,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";
import {
  __async
} from "./chunk-RVA4KI76.js";

// src/app/appointment/models/navigation.ts
var AppointmentRouteType;
(function(AppointmentRouteType2) {
  AppointmentRouteType2["Diagram"] = "Diagram";
  AppointmentRouteType2["Summary"] = "Summary";
  AppointmentRouteType2["CheckIn"] = "CheckIn";
  AppointmentRouteType2["Presentation"] = "Presentation";
  AppointmentRouteType2["Needs"] = "Needs";
  AppointmentRouteType2["Completion"] = "Completion";
  AppointmentRouteType2["Inspection"] = "Inspection";
  AppointmentRouteType2["JobSummary"] = "JobSummary";
  AppointmentRouteType2["Pricing"] = "Pricing";
  AppointmentRouteType2["Negotiation"] = "Negotiation";
})(AppointmentRouteType || (AppointmentRouteType = {}));

// src/app/appointment/services/appointment.service.ts
var _LocalAppointmentService = class _LocalAppointmentService {
  constructor(appointmentUiService, routeService) {
    this.appointmentUiService = appointmentUiService;
    this.routeService = routeService;
    this.activeUser = null;
    this.isAssignedUser = false;
    this.backLabel = "Go Back";
    this.forwardLabel = "Go Forward";
    this.customLabel = "Custom";
    this.canGoBack = false;
    this.goBack$ = new Subject();
    this.canGoForward = false;
    this.goForward$ = new Subject();
    this.canGoCustom = false;
    this.goCustom$ = new Subject();
    this.showCustomNavControl = false;
    this.showCustomNavIndicator = true;
    this.viewingPhoto = false;
    this.managingPhotos = false;
    this.closingManagePhotos = false;
    this.managingAdditionalConsiderations = false;
    this.showConsiderationPrices = false;
    this.showQuoteControl = false;
  }
  get canModifyAppointment() {
    return this.appointment != null && this.activeUser?.id == this.appointment.assignedTo?.id && this.appointment.status != AppointmentStatus.Canceled && this.appointment.status != AppointmentStatus.Dispositioned && this.appointment.status != AppointmentStatus.PendingSubmission && this.appointment.status != AppointmentStatus.Submitted;
  }
  setActiveUser(user) {
    this.activeUser = user;
  }
  setBackLabel(label) {
    this.backLabel = label;
  }
  setForwardLabel(label) {
    this.forwardLabel = label;
  }
  setCustomLabel(label) {
    this.customLabel = label;
  }
  // #endregion
  // #region Routes
  initRoutes(appointment, componentElm) {
    return __async(this, null, function* () {
      const routes = {
        "Summary": new InternalRoute(AppointmentRouteType.Summary),
        "CheckIn": new InternalRoute(AppointmentRouteType.CheckIn),
        "Needs": new InternalRoute(AppointmentRouteType.Needs),
        "Presentation": new InternalRoute(AppointmentRouteType.Presentation),
        "Completion": new InternalRoute(AppointmentRouteType.Completion),
        "Inspection": new InternalRoute(AppointmentRouteType.Inspection),
        "JobSummary": new InternalRoute(AppointmentRouteType.JobSummary),
        "Pricing": new InternalRoute(AppointmentRouteType.Pricing),
        "Negotiation": new InternalRoute(AppointmentRouteType.Negotiation)
      };
      let state = "Summary";
      if (appointment.status == AppointmentStatus.PendingSubmission) {
        state = "Completion";
      }
      const matchingRoute = AppointmentRouteType[state];
      if (matchingRoute != null) {
        this.routeService.init(routes, matchingRoute, 250, componentElm);
      } else {
        this.routeService.init(routes, AppointmentRouteType.Summary, 250, componentElm);
      }
    });
  }
  viewPhoto(src) {
    this.photoSrc = src;
    this.viewingPhoto = true;
  }
  stopViewingPhoto() {
    this.viewingPhoto = false;
    setTimeout(() => {
      this.photoSrc = void 0;
    }, 500);
  }
  managePhotos(entity) {
    if (!this.managingPhotos) {
      window.clearTimeout(this.managePhotosTimer);
      this.closingManagePhotos = false;
      this.managingPhotos = true;
      this.managingPhotosEntity = entity;
    }
  }
  stopManagingPhotos() {
    window.clearTimeout(this.managePhotosTimer);
    this.closingManagePhotos = true;
    this.managePhotosTimer = window.setTimeout(() => {
      this.managingPhotos = false;
      this.closingManagePhotos = false;
      this.managingPhotosEntity = void 0;
    }, 200);
  }
  manageAdditionalConsiderations(showPrices = false) {
    this.managingAdditionalConsiderations = true;
    this.showConsiderationPrices = showPrices;
  }
  stopManagingAdditionalConsiderations() {
    this.managingAdditionalConsiderations = false;
  }
  // #endregion
  // #region Summary
  startSummary(appointment) {
  }
  goToSummary(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.Summary, RouteLoadDirection.Reverse, true);
  }
  completeSummary(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.CheckIn, RouteLoadDirection.Forward, true);
  }
  // #endregion
  // #region Check-In
  startCheckIn(appointment) {
    appointment.changed$.next();
  }
  goToCheckIn(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.CheckIn, RouteLoadDirection.Reverse, true);
  }
  checkIn(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.Needs, RouteLoadDirection.Forward, true);
  }
  // #endregion
  // #region Customer Needs
  startNeeds(appointment) {
  }
  goToNeeds(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.Needs, RouteLoadDirection.Reverse, true);
  }
  submitCustomerNeeds(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.Inspection, RouteLoadDirection.Forward, true);
  }
  // #endregion  
  // #region Inspection
  startInspection(appointment) {
  }
  goToInspection(appointment) {
    this.routeService.viewRoute(AppointmentRouteType.Inspection, RouteLoadDirection.Reverse, true);
  }
  completeInspection(appointment) {
  }
  // #endregion  
  // #region DetailedSummary
  startDetailedSummary(appointment) {
  }
  completeDetailedSummary(appointment) {
  }
  // #endregion
  // #region Presentation
  startPresentation(appointment) {
  }
  completePresentation(appointment) {
  }
};
_LocalAppointmentService.\u0275fac = function LocalAppointmentService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LocalAppointmentService)(\u0275\u0275inject(AppointmentUiService), \u0275\u0275inject(InternalRouteService));
};
_LocalAppointmentService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _LocalAppointmentService, factory: _LocalAppointmentService.\u0275fac, providedIn: "root" });
var LocalAppointmentService = _LocalAppointmentService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LocalAppointmentService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: AppointmentUiService }, { type: InternalRouteService }], null);
})();

export {
  AppointmentRouteType,
  LocalAppointmentService
};
//# sourceMappingURL=chunk-MOCMVSMU.js.map
