import {
  AppointmentRouteType,
  LocalAppointmentService
} from "./chunk-MOCMVSMU.js";
import {
  AppointmentUiService
} from "./chunk-CH5VOHLL.js";
import {
  DeviceRouteService,
  ReminderPriority,
  ReminderReferenceType,
  ReminderService
} from "./chunk-ZEKYPX2O.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  AppointmentService
} from "./chunk-RSQODXYC.js";
import "./chunk-JKLRDWLP.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import "./chunk-HRZODZCB.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import {
  StorageService
} from "./chunk-M3LFBN7N.js";
import {
  AppointmentStatus,
  getDateOnly
} from "./chunk-N36JE2BE.js";
import "./chunk-4HOJYYKK.js";
import {
  BehaviorSubject,
  CommonModule,
  Component,
  DefaultValueAccessor,
  FormsModule,
  Injectable,
  Injector,
  Input,
  NgControlStatus,
  NgModel,
  NgModule,
  OrderByPipe,
  ReactiveFormsModule,
  Subject,
  UiModule,
  ViewChild,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtext,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-IT26RCSL.js";
import "./chunk-RVA4KI76.js";

// src/app/appointment/completion/models/navigation.ts
var AppointmentCompletionRouteType;
(function(AppointmentCompletionRouteType2) {
  AppointmentCompletionRouteType2["completion"] = "completion";
})(AppointmentCompletionRouteType || (AppointmentCompletionRouteType = {}));

// src/app/appointment/completion/services/completion.service.ts
var _AppointmentCompletionService = class _AppointmentCompletionService {
  constructor(appointmentService, storageService, routeService) {
    this.appointmentService = appointmentService;
    this.storageService = storageService;
    this.routeService = routeService;
    this.routesInitialized = false;
  }
  initRoutes(initialRouteType = void 0, appointment, componentElm) {
    const routes = {
      [AppointmentCompletionRouteType.completion]: new InternalRoute(AppointmentCompletionRouteType.completion)
    };
    let initialRoute = AppointmentCompletionRouteType.completion;
    this.routeService.init(routes, initialRoute, 500, componentElm);
    this.routesInitialized = true;
  }
};
_AppointmentCompletionService.\u0275fac = function AppointmentCompletionService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentCompletionService)(\u0275\u0275inject(AppointmentService), \u0275\u0275inject(StorageService), \u0275\u0275inject(InternalRouteService));
};
_AppointmentCompletionService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _AppointmentCompletionService, factory: _AppointmentCompletionService.\u0275fac, providedIn: "root" });
var AppointmentCompletionService = _AppointmentCompletionService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentCompletionService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: AppointmentService }, { type: StorageService }, { type: InternalRouteService }], null);
})();

// src/app/appointment/completion/components/completion/completion.component.ts
var _c0 = ["componentElm"];
function CompletionComponent_Conditional_18_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 8);
    \u0275\u0275text(1, " You have designated an invalid install date. ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 10);
    \u0275\u0275text(1, " Missing Payment Information ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_27_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 11);
    \u0275\u0275text(1, " Ready to Submit ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_30_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 21);
    \u0275\u0275listener("click", function CompletionComponent_Conditional_30_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.managePayments());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Manage Payments");
    \u0275\u0275elementEnd()();
  }
}
function CompletionComponent_Conditional_39_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 10);
    \u0275\u0275text(1, " Please Complete Payment Information ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_40_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 10);
    \u0275\u0275text(1, " Awaiting Signatures ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_41_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 10);
    \u0275\u0275text(1, " Awaiting Customer Signatures ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_42_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 11);
    \u0275\u0275text(1, " Ready to Submit ");
    \u0275\u0275elementEnd();
  }
}
function CompletionComponent_Conditional_45_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 25);
    \u0275\u0275listener("click", function CompletionComponent_Conditional_45_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.sendDocumentsForSignature());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Send for e-Signature");
    \u0275\u0275elementEnd()();
  }
}
function CompletionComponent_Conditional_46_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 26);
    \u0275\u0275listener("click", function CompletionComponent_Conditional_46_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.reviewSignedDocuments());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Save or Share Signed Copies");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("disabled", !ctx_r1.canSendDocumentsToCustomer);
  }
}
function CompletionComponent_Conditional_47_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 27);
    \u0275\u0275listener("click", function CompletionComponent_Conditional_47_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startSigningForCustomer());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Sign for Customer");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("disabled", !ctx_r1.canReviewDocuments);
  }
}
function CompletionComponent_Conditional_48_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 27);
    \u0275\u0275listener("click", function CompletionComponent_Conditional_48_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r6);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startSigningForConsultant());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2, "Sign for Consultant");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("disabled", !ctx_r1.canReviewDocuments);
  }
}
var _CompletionComponent = class _CompletionComponent {
  constructor(localAppointmentService, appointmentService, appointmentUiService, orderByPipe, deviceRouteService, reminderService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.appointmentUiService = appointmentUiService;
    this.orderByPipe = orderByPipe;
    this.deviceRouteService = deviceRouteService;
    this.reminderService = reminderService;
    this.uiService = uiService;
    this.minInstallDate = getDateOnly(/* @__PURE__ */ new Date());
    this.paymentDetails = [];
    this.consultantValid = false;
    this.customerValid = false;
  }
  // #region Authorization
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get shopDateValid() {
    return this.preferredInstallDateTimestamp == null || this.preferredInstallDateTimestamp > this.minInstallDate;
  }
  initShop() {
    this.preferredInstallDateTimestamp = this.appointment?.preferredInstallDate;
  }
  updateInstallDate() {
    if (this.appointment != null) {
      this.appointment.preferredInstallDate = this.preferredInstallDateTimestamp;
      this.appointment.changed$.next();
    }
  }
  get payments() {
    return this.appointment?.payments ?? [];
  }
  get canSubmitPayments() {
    return this.appointment?.paymentsValidForEstimate ?? false;
  }
  get canManagePayments() {
    return this.appointment != null && (!this.appointment.documentsValidForEstimate || !this.appointment.paymentsValidForEstimate);
  }
  watchPayments() {
    this.paymentSubscription?.unsubscribe();
    this.paymentSubscription = this.appointmentUiService.managingPayments.subscribe({
      next: (appointment) => {
        if (appointment == null) {
          this.checkSigningValidity();
        }
      }
    });
  }
  managePayments() {
    if (this.appointment != null) {
      this.appointmentUiService.startMakingPayments(this.appointment);
      this.watchPayments();
    }
  }
  initPaymentDetails() {
    if (this.appointment?.paymentSetting != null) {
      for (var i = 0, len = this.appointment.paymentSetting.details.length; i < len; i++) {
        const detail = this.appointment.paymentSetting.details[i];
        detail.updatedAmount$ = new Subject();
        if (i == 1 && this.appointment.paymentSetting.details.length > 2) {
          detail.canEditAmount = false;
        } else {
          detail.canEditAmount = true;
        }
        this.paymentDetails.push(detail);
      }
      this.paymentDetails = this.orderByPipe.transform(this.paymentDetails, "priority", false);
    }
  }
  get documents() {
    return this.appointment?.documents ?? [];
  }
  get canSubmitDocuments() {
    return this.canReviewDocuments && (this.appointment?.documentsValidForEstimate ?? false);
  }
  get canReviewDocuments() {
    return this.appointment?.paymentsValidForEstimate ?? false;
  }
  get canSendDocumentsToCustomer() {
    return this.appointment?.documentsValidForEstimate ?? false;
  }
  get canSaveDocuments() {
    return this.appointment != null && this.appointment.documentsValidForEstimate;
  }
  get canSendForSignature() {
    return this.consultantValid && this.appointment != null && this.appointment?.paymentsValidForEstimate && !this.appointment?.documentsValidForEstimate;
  }
  get canSignDocuments() {
    return this.appointment != null && !this.appointment.documentsValidForEstimate;
  }
  get showDocumentSignaturesMessage() {
    return !this.canSubmitDocuments && this.canReviewDocuments && this.appointment != null && !this.appointment.documentsValidForEstimate && !this.showCustomerSignaturesMessage;
  }
  get showCustomerSignaturesMessage() {
    return !this.canSubmitDocuments && this.canReviewDocuments && this.consultantValid && !this.customerValid;
  }
  watchSigning() {
    this.signingSubscription?.unsubscribe();
    this.signingSubscription = this.appointmentUiService.signingDocuments.subscribe({
      next: (appointment) => {
        if (appointment == null) {
          this.checkSigningValidity();
        }
      }
    });
  }
  watchSendForSignature() {
    this.sendingForSignatureSubscription?.unsubscribe();
    this.sendingForSignatureSubscription = this.appointmentUiService.documentsSentForSigning.subscribe({
      next: (id) => {
        if (this.appointment != null && id == this.appointment.id) {
          this.appointment.status = AppointmentStatus.PendingSignatures;
          this.completeAppointment();
        }
      }
    });
  }
  checkSigningValidity() {
    if (this.appointment != null) {
      let consultantValid = true;
      let customerValid = true;
      for (var i = 0, len = this.appointment.documents.length; i < len; i++) {
        const document = this.appointment.documents[i];
        document.checkSigningValidity();
        if (!document.consultantValid) {
          consultantValid = false;
        }
        if (!document.customerValid) {
          customerValid = false;
        }
      }
      this.consultantValid = consultantValid;
      this.customerValid = customerValid;
      this.appointment.checkDocumentValidity();
      this.appointment.changed$.next();
    }
  }
  startSigningForCustomer() {
    if (this.appointment?.customer != null) {
      const customerName = `${this.appointment.customer.firstName} ${this.appointment.customer.lastName}`;
      this.appointmentUiService.startSigningDocuments(this.appointment, customerName, true);
      this.watchSigning();
    }
  }
  startSigningForConsultant() {
    if (this.appointment?.assignedTo != null) {
      const consultantName = `${this.appointment.assignedTo.firstName} ${this.appointment.assignedTo.lastName}`;
      this.appointmentUiService.startSigningDocuments(this.appointment, consultantName, true);
      this.watchSigning();
    }
  }
  reviewSignedDocuments() {
    if (this.appointment != null) {
      this.appointmentUiService.startSendingExecutedDocuments(this.appointment);
    }
  }
  sendDocumentsForSignature() {
    if (this.appointment != null) {
      this.appointmentUiService.startSendingDocuments(this.appointment);
      this.watchSendForSignature();
    }
  }
  initDocuments() {
    this.checkSigningValidity();
  }
  // #endregion
  // #region Navigation
  get canComplete() {
    return this.appointment != null && this.appointment.paymentsValidForEstimate && this.localAppointmentService.isAssignedUser;
  }
  goBack() {
    this.localAppointmentService.routeService.viewRoute(AppointmentRouteType.Negotiation, RouteLoadDirection.Reverse, true);
  }
  complete() {
    if (this.appointment?.customer != null && this.canComplete) {
      if (this.appointment.documentsValidForEstimate) {
        this.uiService.prompt("Completing Appointment", `Do you need to provide or send a copy of the documents to ${this.appointment.customer.firstName}?`, "Yes", "I already have").subscribe({
          next: (confirmed) => {
            if (this.appointment != null) {
              if (confirmed) {
                this.reviewSignedDocuments();
              } else {
                this.appointment.status = AppointmentStatus.PendingSubmission;
                this.completeAppointment();
              }
            }
          }
        });
      } else {
        this.uiService.prompt("Job Documents Incomplete", `Your job documents are incomplete. Only complete the appointment if you're planning to complete them later.`, "Okay", "Go Back").subscribe({
          next: (confirmed) => {
            if (this.appointment != null) {
              if (confirmed) {
                this.appointment.status = AppointmentStatus.PendingSignatures;
                this.completeAppointment();
              }
            }
          }
        });
      }
    }
  }
  createSubmissionReminder() {
    if (this.appointment?.jobId != null && this.appointment.assignedTo != null) {
      this.reminderService.createReminder(this.appointment.assignedTo, this.appointment.assignedTo, `Submit Job ${this.appointment.jobId}`, "Finalize and submit your sold job", ReminderPriority.Critical, /* @__PURE__ */ new Date(), this.appointment.id, ReminderReferenceType.Appointment);
    }
  }
  completeAppointment() {
    if (this.appointment != null) {
      this.createSubmissionReminder();
      this.appointment.dispositionStatus = void 0;
      this.appointment.statusDescription = void 0;
      this.appointmentService.storeAppointment(this.appointment);
      this.deviceRouteService.viewRouteByType("Dashboard");
    }
  }
  init() {
    this.initShop();
    this.initPaymentDetails();
    this.initDocuments();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_CompletionComponent.\u0275fac = function CompletionComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _CompletionComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(AppointmentUiService), \u0275\u0275directiveInject(OrderByPipe), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(ReminderService), \u0275\u0275directiveInject(UiService));
};
_CompletionComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _CompletionComponent, selectors: [["completion"]], viewQuery: function CompletionComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 60, vars: 16, consts: [["id", "completion"], [1, "primary"], [1, "content"], [1, "shop", "section"], [1, "form"], [1, "input-wrap"], [1, "input"], ["type", "date", 3, "ngModelChange", "blur", "ngModel", "min"], [1, "message"], [1, "payments", "section"], [1, "value", "warning"], [1, "value"], [1, "secondary"], [1, "controls"], [1, "control"], [1, "documents", "section"], [1, "control", "alternate"], [1, "control", "alternate", 3, "disabled"], [1, "control", 3, "disabled"], ["id", "mainNav"], [1, "island"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click"], [1, "fa-solid", "fa-check"], [1, "control", "alternate", 3, "click"], [1, "control", "alternate", 3, "click", "disabled"], [1, "control", 3, "click", "disabled"]], template: function CompletionComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "h1");
    \u0275\u0275text(4, " Finalize Appointment ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(5, "div", 2)(6, "div", 3)(7, "header")(8, "div", 1)(9, "h4");
    \u0275\u0275text(10, "Shop Information");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(11, "div", 2)(12, "div", 4)(13, "div", 5)(14, "label");
    \u0275\u0275text(15, "Preferred Install Date");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(16, "div", 6)(17, "input", 7);
    \u0275\u0275twoWayListener("ngModelChange", function CompletionComponent_Template_input_ngModelChange_17_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.preferredInstallDateTimestamp, $event) || (ctx.preferredInstallDateTimestamp = $event);
      return $event;
    });
    \u0275\u0275listener("blur", function CompletionComponent_Template_input_blur_17_listener() {
      return ctx.updateInstallDate();
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(18, CompletionComponent_Conditional_18_Template, 2, 0, "p", 8);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(19, "div", 9)(20, "header")(21, "div", 1)(22, "h4");
    \u0275\u0275text(23, "Payments");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(24, "h5");
    \u0275\u0275text(25, " Status: ");
    \u0275\u0275conditionalCreate(26, CompletionComponent_Conditional_26_Template, 2, 0, "span", 10);
    \u0275\u0275conditionalCreate(27, CompletionComponent_Conditional_27_Template, 2, 0, "span", 11);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(28, "div", 12)(29, "div", 13);
    \u0275\u0275conditionalCreate(30, CompletionComponent_Conditional_30_Template, 3, 0, "button", 14);
    \u0275\u0275elementEnd()()();
    \u0275\u0275element(31, "div", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "div", 15)(33, "header")(34, "div", 1)(35, "h4");
    \u0275\u0275text(36, "Document Review");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(37, "h5");
    \u0275\u0275text(38, " Status: ");
    \u0275\u0275conditionalCreate(39, CompletionComponent_Conditional_39_Template, 2, 0, "span", 10);
    \u0275\u0275conditionalCreate(40, CompletionComponent_Conditional_40_Template, 2, 0, "span", 10);
    \u0275\u0275conditionalCreate(41, CompletionComponent_Conditional_41_Template, 2, 0, "span", 10);
    \u0275\u0275conditionalCreate(42, CompletionComponent_Conditional_42_Template, 2, 0, "span", 11);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(43, "div", 12)(44, "div", 13);
    \u0275\u0275conditionalCreate(45, CompletionComponent_Conditional_45_Template, 3, 0, "button", 16);
    \u0275\u0275conditionalCreate(46, CompletionComponent_Conditional_46_Template, 3, 1, "button", 17);
    \u0275\u0275conditionalCreate(47, CompletionComponent_Conditional_47_Template, 3, 1, "button", 18);
    \u0275\u0275conditionalCreate(48, CompletionComponent_Conditional_48_Template, 3, 1, "button", 18);
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275elementStart(49, "nav", 19)(50, "div", 20)(51, "div", 13)(52, "button", 21);
    \u0275\u0275listener("click", function CompletionComponent_Template_button_click_52_listener() {
      return ctx.goBack();
    });
    \u0275\u0275element(53, "i", 22);
    \u0275\u0275elementStart(54, "label");
    \u0275\u0275text(55, "Back to Price Finalization");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(56, "button", 23);
    \u0275\u0275listener("click", function CompletionComponent_Template_button_click_56_listener() {
      return ctx.complete();
    });
    \u0275\u0275element(57, "i", 24);
    \u0275\u0275elementStart(58, "label");
    \u0275\u0275text(59, "Complete Appointment");
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(13);
    \u0275\u0275classProp("invalid", !ctx.shopDateValid);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx.preferredInstallDateTimestamp);
    \u0275\u0275property("min", ctx.minInstallDate);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.shopDateValid ? 18 : -1);
    \u0275\u0275advance(8);
    \u0275\u0275conditional(!ctx.canSubmitPayments ? 26 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canSubmitPayments ? 27 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.canManagePayments ? 30 : -1);
    \u0275\u0275advance(9);
    \u0275\u0275conditional(!ctx.canReviewDocuments ? 39 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showDocumentSignaturesMessage ? 40 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showCustomerSignaturesMessage ? 41 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canSubmitDocuments ? 42 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.canSendForSignature ? 45 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canSaveDocuments ? 46 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canSignDocuments ? 47 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canSignDocuments ? 48 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel], styles: ["\n\n.tooltip[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */", "\n\n#completion[_ngcontent-%COMP%] {\n  position: relative;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 75vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  margin: 10vh auto 0;\n}\n#completion[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0.75vw 1vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#completion[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 1.6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  color: var(--color4Alt4);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h5[_ngcontent-%COMP%]    > .value.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  border: 0.1vw var(--color3) solid;\n  background-color: var(--color2);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.3vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  border-color: var(--color5);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.6vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus, \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 100%;\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  flex: 1;\n  display: block;\n  font-size: 1.1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  text-align: right;\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--stronger);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.payments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section.documents[_ngcontent-%COMP%] {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .section[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=completion.component.css.map */"] });
var CompletionComponent = _CompletionComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CompletionComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "completion", providers: [OrderByPipe], template: '<section id="completion">\n  <header>\n    <div class="primary">\n      <h1>\n        Finalize Appointment\n      </h1>\n    </div>\n  </header>\n  <div class="content">\n    <div class="shop section">\n      <header>\n        <div class="primary">\n          <h4>Shop Information</h4>\n        </div>\n      </header>\n\n      <div class="content">\n        <div class="form">\n          <div class="input-wrap" [class.invalid]="!shopDateValid">\n            <label>Preferred Install Date</label>\n            <div class="input">\n              <input\n                [(ngModel)]="preferredInstallDateTimestamp"\n                [min]="minInstallDate"\n                (blur)="updateInstallDate()"\n                type="date" />\n            </div>\n            @if (!shopDateValid) {\n              <p class="message">\n                You have designated an invalid install date.\n              </p>\n            }\n          </div>\n        </div>\n      </div>\n    </div>\n    <div class="payments section">\n      <header>\n        <div class="primary">\n          <h4>Payments</h4>\n          <h5>\n            Status:\n            @if (!canSubmitPayments) {\n              <span class="value warning">\n                Missing Payment Information\n              </span>\n            }\n            @if (canSubmitPayments) {\n              <span class="value">\n                Ready to Submit\n              </span>\n            }\n          </h5>\n        </div>\n        <div class="secondary">\n          <div class="controls">\n            @if (canManagePayments) {\n              <button class="control" (click)="managePayments()">\n                <label>Manage Payments</label>\n              </button>\n            }\n          </div>\n        </div>\n      </header>\n\n      <div class="content">\n      </div>\n    </div>\n    <div class="documents section">\n      <header>\n        <div class="primary">\n          <h4>Document Review</h4>\n          <h5>\n            Status:\n            @if (!canReviewDocuments) {\n              <span class="value warning">\n                Please Complete Payment Information\n              </span>\n            }\n            @if (showDocumentSignaturesMessage) {\n              <span class="value warning">\n                Awaiting Signatures\n              </span>\n            }\n            @if (showCustomerSignaturesMessage) {\n              <span class="value warning">\n                Awaiting Customer Signatures\n              </span>\n            }\n            @if (canSubmitDocuments) {\n              <span class="value">\n                Ready to Submit\n              </span>\n            }\n          </h5>\n        </div>\n        <div class="secondary">\n          <div class="controls">\n            @if (canSendForSignature) {\n              <button class="control alternate"\n                (click)="sendDocumentsForSignature()">\n                <label>Send for e-Signature</label>\n              </button>\n            }\n            @if (canSaveDocuments) {\n              <button class="control alternate" [disabled]="!canSendDocumentsToCustomer" (click)="reviewSignedDocuments()">\n                <label>Save or Share Signed Copies</label>\n              </button>\n            }\n            @if (canSignDocuments) {\n              <button class="control" [disabled]="!canReviewDocuments" (click)="startSigningForCustomer()">\n                <label>Sign for Customer</label>\n              </button>\n            }\n            @if (canSignDocuments) {\n              <button class="control" [disabled]="!canReviewDocuments" (click)="startSigningForConsultant()">\n                <label>Sign for Consultant</label>\n              </button>\n            }\n          </div>\n        </div>\n      </header>\n    </div>\n  </div>\n</section>\n\n<nav id="mainNav">\n  <div class="island">\n    <div class="controls">\n      <button class="control" (click)="goBack()">\n        <i class="fa-solid fa-arrow-left-long"></i>\n        <label>Back to Price Finalization</label>\n      </button>\n      <button class="control success" (click)="complete()">\n        <i class="fa-solid fa-check"></i>\n        <label>Complete Appointment</label>\n      </button>\n    </div>\n  </div>\n</nav>', styles: ["/* src/app/shared/ui/components/tooltips/tooltips.component.scss */\n.tooltip {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip > .control {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip > h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip > p {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip > .controls {\n  margin-top: 0.5vw;\n}\n.tooltip > .controls > .control {\n  cursor: pointer;\n  display: block;\n}\n.tooltip > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */\n", "/* src/app/appointment/completion/components/completion/completion.component.scss */\n#completion {\n  position: relative;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 75vw;\n  border-radius: 1vw;\n  overflow: hidden;\n  margin: 10vh auto 0;\n}\n#completion > header {\n  padding: 0.75vw 1vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#completion > header h1 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#completion > .content {\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#completion > .content .section {\n  margin-top: 1vw;\n}\n#completion > .content .section > header {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#completion > .content .section > header > .primary {\n  flex: 1;\n}\n#completion > .content .section > header > .primary h4 {\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#completion > .content .section > header > .primary h5 {\n  line-height: 1;\n  font-size: 1.6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n}\n#completion > .content .section > header > .primary h5 > .value {\n  color: var(--color4Alt4);\n}\n#completion > .content .section > header > .primary h5 > .value.warning {\n  color: var(--error);\n}\n#completion > .content .section > header > .secondary > .controls {\n  display: flex;\n  align-items: center;\n}\n#completion > .content .section > header > .secondary > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.6vw 1.6vw;\n  border-radius: 0.75vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  border: 0.1vw var(--color3) solid;\n  background-color: var(--color2);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#completion > .content .section > header > .secondary > .controls > .control > label {\n  display: block;\n  width: 100%;\n  font-size: 1.3vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n  text-align: center;\n}\n#completion > .content .section > header > .secondary > .controls > .control.alternate {\n  border-color: var(--color5);\n}\n#completion > .content .section > header > .secondary > .controls > .control.alternate > label {\n  color: var(--color5);\n}\n#completion > .content .section > header > .secondary > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#completion > .content .section > header > .secondary > .controls > .control:first-child {\n  margin-left: 0;\n}\n#completion > .content .section > .content {\n  margin-top: 1vw;\n}\n#completion > .content .section > .content > .form > .input-wrap {\n  margin-top: 0.5vw;\n}\n#completion > .content .section > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#completion > .content .section > .content > .form > .input-wrap > .input input,\n#completion > .content .section > .content > .form > .input-wrap > .input select,\n#completion > .content .section > .content > .form > .input-wrap > .input textarea {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.25vw 0.5vw;\n  font-size: 1.6vw;\n  font-weight: var(--stdweight);\n  resize: none;\n}\n#completion > .content .section > .content > .form > .input-wrap > .input input:focus,\n#completion > .content .section > .content > .form > .input-wrap > .input select:focus,\n#completion > .content .section > .content > .form > .input-wrap > .input textarea:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n#completion > .content .section > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#completion > .content .section > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#completion > .content .section.payments {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#completion > .content .section.payments > .content {\n  margin-top: 1vw;\n}\n#completion > .content .section.payments > .content > .details > .detail {\n  margin-top: 1vw;\n}\n#completion > .content .section.payments > .content > .details > .detail > .content {\n  width: 100%;\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n  border-bottom: 0.1vw var(--color1Alt3) dashed;\n}\n#completion > .content .section.payments > .content > .details > .detail > .content > label {\n  flex: 1;\n  display: block;\n  font-size: 1.1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#completion > .content .section.payments > .content > .details > .detail > .content > .amount > .value {\n  display: block;\n  text-align: right;\n  font-size: 1.8vw;\n  color: var(--successAlt4);\n  font-weight: var(--stronger);\n}\n#completion > .content .section.payments > .content > .details > .detail > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1vw;\n  font-weight: var(--strong);\n}\n#completion > .content .section.payments > .content > .details > .detail:first-child {\n  margin-top: 0;\n}\n#completion > .content .section.documents {\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#completion > .content .section:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=completion.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: AppointmentUiService }, { type: OrderByPipe }, { type: DeviceRouteService }, { type: ReminderService }, { type: UiService }], { appointment: [{
    type: Input,
    args: ["appointment"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(CompletionComponent, { className: "CompletionComponent" });
})();

// src/app/appointment/completion/components/layout/layout.component.ts
var _c02 = ["componentElm"];
function CompletionLayoutComponent_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "completion", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.animating)("closing", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.closing)("rendered", ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.rendered);
    \u0275\u0275property("appointment", ctx_r0.appointment)("route", ctx_r0.completionRoute);
  }
}
function CompletionLayoutComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "div", 2);
    \u0275\u0275conditionalCreate(3, CompletionLayoutComponent_Conditional_0_Conditional_3_Template, 1, 11, "completion", 3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275conditional((ctx_r0.completionRoute == null ? null : ctx_r0.completionRoute.active) ? 3 : -1);
  }
}
var _CompletionLayoutComponent = class _CompletionLayoutComponent {
  constructor(localAppointmentService, completionService) {
    this.localAppointmentService = localAppointmentService;
    this.completionService = completionService;
    this.routeParams = new BehaviorSubject([]);
    this.viewingItemizedPricing = false;
    this.closingItemizedPricing = false;
  }
  get routesInitialized() {
    return this.completionService.routesInitialized;
  }
  get routes() {
    return this.completionService.routeService.routes;
  }
  watchParams() {
    if (this.route != null) {
      this.paramsSubscription = this.route.params.subscribe({
        next: (params) => {
          const componentElm = this.componentElm?.nativeElement;
          if (componentElm != null && this.appointment != null) {
            let route = params[0]?.toLowerCase();
            if (route != null) {
              const routeMatches = Object.values(AppointmentCompletionRouteType).includes(route);
              const routeParams = params.slice(1);
              this.routeParams.next(routeParams);
              if (routeMatches) {
                if (!this.routesInitialized) {
                  this.completionService.initRoutes(route, this.appointment, componentElm);
                } else {
                  this.viewRoute(route);
                }
              } else {
                if (!this.routesInitialized) {
                  this.completionService.initRoutes(void 0, this.appointment, componentElm);
                }
              }
            } else {
              if (!this.routesInitialized) {
                this.completionService.initRoutes(void 0, this.appointment, componentElm);
              }
            }
          }
        }
      });
    }
  }
  viewRoute(name) {
    if (name != null) {
      this.completionService.routeService.viewRoute(name, RouteLoadDirection.Forward, true);
    }
  }
  watchRoute() {
    this.routeSubscription = this.completionService.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
          }
        }
      }
    });
  }
  initRouting() {
    if (this.appointment?.customPrice?.finalPrice == null || this.appointment.customPrice.finalPrice <= 0) {
      const componentElm = this.componentElm?.nativeElement;
      if (componentElm != null && this.appointment != null) {
        this.completionService.initRoutes(AppointmentCompletionRouteType.completion, this.appointment, componentElm);
      }
    }
    setTimeout(() => {
      this.watchParams();
      this.watchRoute();
    }, 0);
  }
  viewItemizedPricing() {
    window.clearTimeout(this.itemizedPricingTimer);
    this.closingItemizedPricing = false;
    this.viewingItemizedPricing = true;
  }
  stopViewingItemizedPricing() {
    window.clearTimeout(this.itemizedPricingTimer);
    this.closingItemizedPricing = true;
    this.itemizedPricingTimer = window.setTimeout(() => {
      this.viewingItemizedPricing = false;
      this.closingItemizedPricing = false;
    }, 250);
  }
  // #endregion
  // #region Internal Adjust
  get completionRoute() {
    return this.routes[AppointmentCompletionRouteType.completion];
  }
  // #endregion
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  // #endregion
  // #region Navigation
  get routeService() {
    return this.localAppointmentService.routeService;
  }
  init() {
    if (this.appointment != null) {
      this.initRouting();
    }
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_CompletionLayoutComponent.\u0275fac = function CompletionLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _CompletionLayoutComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentCompletionService));
};
_CompletionLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _CompletionLayoutComponent, selectors: [["ng-component"]], viewQuery: function CompletionLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 1, vars: 1, consts: [["componentElm", ""], ["id", "completionLayout"], [1, "routes"], [3, "class", "appointment", "animate", "closing", "rendered", "route"], [3, "appointment", "route"]], template: function CompletionLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, CompletionLayoutComponent_Conditional_0_Template, 4, 1, "section", 1);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.appointment != null ? 0 : -1);
  }
}, dependencies: [CompletionComponent], styles: ['\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  will-change: transform;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10;\n  background-color: rgba(var(--color1-raw), 0.2);\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n/*# sourceMappingURL=layout.component.css.map */'] });
var CompletionLayoutComponent = _CompletionLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CompletionLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '@if (appointment != null) {\n  <section id="completionLayout" #componentElm>\n    <div class="routes">\n      @if (completionRoute?.active) {\n        <completion class="route {{completionRoute?.loadDirection}}"\n          [appointment]="appointment"\n          [class.animate]="completionRoute?.animating"\n          [class.closing]="completionRoute?.closing"\n          [class.rendered]="completionRoute?.rendered"\n        [route]="completionRoute"></completion>\n      }\n    </div>\n  </section>\n}', styles: ['/* src/app/appointment/completion/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#negotiationLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  will-change: transform;\n}\n#negotiationLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#negotiationLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10;\n  background-color: rgba(var(--color1-raw), 0.2);\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n/*# sourceMappingURL=layout.component.css.map */\n'] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentCompletionService }], { appointment: [{
    type: Input,
    args: ["appointment"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(CompletionLayoutComponent, { className: "CompletionLayoutComponent" });
})();

// src/app/appointment/completion/completion.module.ts
var _CompletionModule = class _CompletionModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(CompletionLayoutComponent, { injector: this.injector });
    customElements.define("appointment-completion", el);
  }
};
_CompletionModule.\u0275fac = function CompletionModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _CompletionModule)(\u0275\u0275inject(Injector));
};
_CompletionModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _CompletionModule });
_CompletionModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  AppointmentCompletionService,
  InternalRouteService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var CompletionModule = _CompletionModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(CompletionModule, [{
    type: NgModule,
    args: [{
      declarations: [
        CompletionLayoutComponent,
        CompletionComponent
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        AppointmentCompletionService,
        InternalRouteService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  CompletionModule
};
//# sourceMappingURL=chunk-MOOYWWAH.js.map
