import {
  ConsentComponent,
  DocumentService,
  OpportunityDocumentComponent,
  SharedDocumentsModule
} from "./chunk-MSDZORKH.js";
import "./chunk-HJJU6GQE.js";
import "./chunk-JKLRDWLP.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  OpportunityService
} from "./chunk-MSWJJQQ3.js";
import "./chunk-HRZODZCB.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import "./chunk-LCOXJZOJ.js";
import "./chunk-M3LFBN7N.js";
import "./chunk-N36JE2BE.js";
import "./chunk-4HOJYYKK.js";
import {
  ActivatedRoute,
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  LoaderComponent,
  NgModule,
  OrderByPipe,
  RouterModule,
  UiModule,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1
} from "./chunk-VAMMRICA.js";
import "./chunk-IT26RCSL.js";
import "./chunk-RVA4KI76.js";

// src/app/documents/components/layout/layout.component.ts
function DocumentLayoutComponent_Conditional_0_Conditional_0_For_9_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 16)(1, "opportunity-document", 17);
    \u0275\u0275listener("changed", function DocumentLayoutComponent_Conditional_0_Conditional_0_For_9_Conditional_0_Template_opportunity_document_changed_1_listener() {
      \u0275\u0275restoreView(_r2);
      const document_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r3.documentChanged(document_r3));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const document_r3 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("content", ctx_r3.content)("signing", true)("execute", false)("document", document_r3);
  }
}
function DocumentLayoutComponent_Conditional_0_Conditional_0_For_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, DocumentLayoutComponent_Conditional_0_Conditional_0_For_9_Conditional_0_Template, 2, 4, "div", 16);
  }
  if (rf & 2) {
    const document_r3 = ctx.$implicit;
    \u0275\u0275conditional(document_r3.active ? 0 : -1);
  }
}
function DocumentLayoutComponent_Conditional_0_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "main", 1)(1, "header")(2, "div", 7)(3, "h1");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "h2");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(7, "div", 8);
    \u0275\u0275repeaterCreate(8, DocumentLayoutComponent_Conditional_0_Conditional_0_For_9_Template, 1, 1, null, null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "nav", 9)(11, "div", 10)(12, "div", 11)(13, "button", 12);
    \u0275\u0275listener("click", function DocumentLayoutComponent_Conditional_0_Conditional_0_Template_button_click_13_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.goBack());
    });
    \u0275\u0275element(14, "i", 13);
    \u0275\u0275elementStart(15, "label");
    \u0275\u0275text(16);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(17, "button", 14);
    \u0275\u0275listener("click", function DocumentLayoutComponent_Conditional_0_Conditional_0_Template_button_click_17_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.goForward());
    });
    \u0275\u0275element(18, "i", 15);
    \u0275\u0275elementStart(19, "label");
    \u0275\u0275text(20);
    \u0275\u0275elementEnd()()()()()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("Welcome back, ", ctx_r3.recipientName);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Job: ", ctx_r3.content == null ? null : ctx_r3.content.jobId);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r3.documents);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx_r3.canGoBack);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r3.backLabel);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r3.canGoForward);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r3.forwardLabel);
  }
}
function DocumentLayoutComponent_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "signing-consent", 18);
    \u0275\u0275listener("close", function DocumentLayoutComponent_Conditional_0_Conditional_3_Template_signing_consent_close_0_listener($event) {
      \u0275\u0275restoreView(_r5);
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.finalizeConsent($event));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275property("consenters", ctx_r3.consenters);
  }
}
function DocumentLayoutComponent_Conditional_0_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 5);
    \u0275\u0275element(1, "div", 3);
    \u0275\u0275elementStart(2, "div", 19)(3, "div", 20);
    \u0275\u0275element(4, "img", 21);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "h2");
    \u0275\u0275text(6, "You're all finished!");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "p");
    \u0275\u0275text(8, " Thank you for completing your documents, we are grateful for your business! Please contact your consultant for additional assistance. ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "p");
    \u0275\u0275text(10, "You may now close this window.");
    \u0275\u0275elementEnd()()();
  }
}
function DocumentLayoutComponent_Conditional_0_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 6);
    \u0275\u0275element(1, "div", 3);
    \u0275\u0275elementStart(2, "div", 19)(3, "div", 20);
    \u0275\u0275element(4, "img", 21);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "h2");
    \u0275\u0275text(6, "Invite Was Not Found");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "p");
    \u0275\u0275text(8, " Your provided invite code to sign documents in not valid. Please contact support at ");
    \u0275\u0275elementStart(9, "a", 22);
    \u0275\u0275text(10, "support@repipe.com");
    \u0275\u0275elementEnd();
    \u0275\u0275text(11, " for additional assistance. ");
    \u0275\u0275elementEnd()()();
  }
}
function DocumentLayoutComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, DocumentLayoutComponent_Conditional_0_Conditional_0_Template, 21, 6, "main", 1);
    \u0275\u0275elementStart(1, "aside", 2);
    \u0275\u0275element(2, "div", 3);
    \u0275\u0275conditionalCreate(3, DocumentLayoutComponent_Conditional_0_Conditional_3_Template, 1, 1, "signing-consent", 4);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(4, DocumentLayoutComponent_Conditional_0_Conditional_4_Template, 11, 0, "aside", 5);
    \u0275\u0275conditionalCreate(5, DocumentLayoutComponent_Conditional_0_Conditional_5_Template, 12, 0, "aside", 6);
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275conditional(ctx_r3.showDocuments ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r3.consenting);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx_r3.consenting ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r3.showCompletion ? 4 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r3.showNoAccess ? 5 : -1);
  }
}
function DocumentLayoutComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 23);
    \u0275\u0275element(1, "div", 3)(2, "loader", 24);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r3.closingLoader);
    \u0275\u0275advance(2);
    \u0275\u0275property("fill", true);
  }
}
var _DocumentLayoutComponent = class _DocumentLayoutComponent {
  constructor(uiService, documentService, route, orderByPipe) {
    this.uiService = uiService;
    this.documentService = documentService;
    this.route = route;
    this.orderByPipe = orderByPipe;
    this.signerKey = null;
    this.onlyCustomerFacing = true;
    this.activeDocumentIndex = 0;
    this.retrievingDocuments = false;
    this.documents = [];
    this.completingDocuments = false;
    this.canCompleteDocuments = false;
    this.consenting = false;
    this.consenters = new BehaviorSubject([]);
    this.backLabel = "Previous Document";
    this.forwardLabel = "Next Document";
    this.canGoBack = false;
    this.canGoForward = false;
    this.showLoader = true;
    this.closingLoader = false;
  }
  get recipient() {
    return this.content?.recipient;
  }
  get recipientName() {
    return this.recipient?.fullName;
  }
  get showDocuments() {
    return !this.showNoAccess && !this.showCompletion;
  }
  get showCompletion() {
    return this.content?.completed ?? false;
  }
  documentChanged(document2) {
    this.documentService.updateSigners(this.documents);
    this.checkDocumentValidity();
    this.setNavigation();
  }
  checkDocumentValidity() {
    window.clearTimeout(this.validationDebounce);
    this.validationDebounce = window.setTimeout(() => {
      const documentElm = document.getElementById("documentElm");
      if (this.activeDocument != null && this.content != null && this.recipient != null && documentElm != null) {
        let canCompleteDocuments = true;
        const documentStr = documentElm.innerHTML;
        const initialCount = documentStr.match(/initials mandatory customer/g)?.length || 0;
        const validInitialCount = documentStr.match(/initials mandatory customer valid/g)?.length || 0;
        const signatureCount = documentStr.match(/signature mandatory customer/g)?.length || 0;
        const validSignatureCount = documentStr.match(/signature mandatory customer valid/g)?.length || 0;
        const initialsValid = initialCount == validInitialCount;
        const signaturesValid = signatureCount == validSignatureCount;
        this.activeDocument.validForSigner = initialsValid && signaturesValid;
        if (this.activeDocument.validForSigner) {
          for (var i = 0, len = this.documents.length; i < len; i++) {
            const existingDocument = this.documents[i];
            if (existingDocument.validForSigner) {
              canCompleteDocuments = false;
              break;
            }
          }
        } else {
          canCompleteDocuments = false;
        }
        this.canCompleteDocuments = canCompleteDocuments;
      } else {
        this.canCompleteDocuments = false;
      }
      this.setNavigation();
    }, 1e3);
  }
  initDocuments() {
    if (this.content != null) {
      let documents = [];
      for (var i = 0, len = this.content.documents.length; i < len; i++) {
        const document2 = this.content.documents[i];
        if (document2.displayInSigning && (document2.customerFacing || !this.onlyCustomerFacing)) {
          document2.active = false;
          if (!document2.executed && document2.signers.length == 0) {
            document2.signers = this.documentService.generateOpportunitySigners(document2, this.content);
          }
          documents.push(document2);
        }
      }
      documents = this.orderByPipe.transform(documents, "displayOrder", false);
      this.documents = documents;
      this.hideLoader();
      this.setActiveDocument(0);
      this.verifyConsent();
    }
  }
  retrieveDocuments() {
    if (!this.retrievingDocuments && this.signerKey != null) {
      this.retrievingDocuments = true;
      this.documentService.getOpportunityContent(this.signerKey).subscribe({
        next: (content) => {
          this.content = content;
          if (!content.completed) {
            this.initDocuments();
          } else {
            this.hideLoader();
          }
          this.retrievingDocuments = false;
        },
        error: () => {
          this.retrievingDocuments = false;
          this.hideLoader();
        }
      });
    }
  }
  setActiveDocument(index) {
    const document2 = this.documents[index];
    this.documents.forEach((document3) => {
      document3.active = false;
    });
    if (document2 != null) {
      document2.active = true;
      this.canCompleteDocuments = false;
    }
    this.activeDocument = document2;
    this.activeDocumentIndex = index;
    this.setNavigation();
  }
  completeDocuments() {
    if (!this.completingDocuments && this.content?.opportunityId != null && this.signerKey != null) {
      this.completingDocuments = true;
      this.uiService.prompt("Complete Your Documents?", "Are you ready to submit your completed documents?", "Yes, Finish", "No, Go Back").subscribe({
        next: (confirmed) => {
          if (confirmed && this.signerKey != null && this.recipientName != null && this.content?.opportunityId != null) {
            this.documentService.completeOpportunityDocuments(this.signerKey, this.recipientName, this.content.opportunityId, this.documents).subscribe({
              next: () => {
                if (this.content != null) {
                  this.content.completed = true;
                  this.completingDocuments = false;
                }
              },
              error: () => {
                this.uiService.prompt("Unable to Complete Documents", "We encountered an issue completing your documents. Please try again.", "Okay").subscribe({
                  next: () => {
                    this.completingDocuments = false;
                  }
                });
              }
            });
          } else {
            this.completingDocuments = false;
          }
        }
      });
    }
  }
  finalizeConsent(consenters) {
    if (consenters.length > 0) {
      this.content?.documents.forEach((document2) => {
        document2.signers = consenters;
      });
    }
    this.consenting = false;
  }
  verifyConsent() {
    const consenters = [];
    for (var i = 0, len = this.documents.length; i < len; i++) {
      const document2 = this.documents[i];
      for (var j = 0, jlen = document2.signers.length; j < jlen; j++) {
        const signer = document2.signers[j];
        if (signer.consent == null && signer.fullName == this.recipient?.fullName) {
          const existingConsenter = consenters.find((x) => x.fullName == signer.fullName);
          if (existingConsenter == null) {
            consenters.push(signer);
          }
        }
      }
    }
    if (consenters.length > 0) {
      this.consenting = true;
    } else {
      this.consenting = false;
    }
    setTimeout(() => {
      this.consenters.next(consenters);
    }, 16);
  }
  setNavigation() {
    window.clearTimeout(this.navigationDebounce);
    this.navigationDebounce = window.setTimeout(() => {
      if (this.activeDocument != null && this.activeDocument.validForSigner) {
        const nextDocument = this.documents[this.activeDocumentIndex + 1];
        if (nextDocument != null) {
          this.forwardLabel = "Next Document";
        } else {
          this.forwardLabel = "Complete Documents";
        }
        this.canGoForward = true;
      } else {
        this.canGoForward = false;
      }
      if (this.activeDocument != null) {
        const previousDocument = this.documents[this.activeDocumentIndex - 1];
        if (previousDocument != null) {
          this.canGoBack = true;
        } else {
          this.canGoBack = false;
        }
      }
    }, 150);
  }
  goBack() {
    const previousDocument = this.documents[this.activeDocumentIndex - 1];
    if (previousDocument != null) {
      this.setActiveDocument(this.activeDocumentIndex - 1);
    }
  }
  goForward() {
    const nextDocument = this.documents[this.activeDocumentIndex + 1];
    if (nextDocument != null) {
      this.setActiveDocument(this.activeDocumentIndex + 1);
    } else {
      this.completeDocuments();
    }
  }
  get showContent() {
    return !this.showLoader && (this.showDocuments || this.showNoAccess || this.showCompletion);
  }
  get showNoAccess() {
    return !this.showLoader && (this.signerKey == null || this.content == null);
  }
  hideLoader() {
    this.closingLoader = true;
    setTimeout(() => {
      this.showLoader = false;
      this.verifyConsent();
    }, 2e3);
  }
  init() {
    if (this.signerKey != null) {
      this.retrieveDocuments();
    } else {
      this.hideLoader();
    }
  }
  // #endregion
  ngOnInit() {
    this.route.paramMap.subscribe((params) => {
      this.signerKey = params.get("signerKey");
      this.init();
    });
  }
  ngOnDestroy() {
  }
};
_DocumentLayoutComponent.\u0275fac = function DocumentLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DocumentLayoutComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DocumentService), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(OrderByPipe));
};
_DocumentLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _DocumentLayoutComponent, selectors: [["layout"]], standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 2, vars: 2, consts: [["id", "loader", 3, "closing"], ["id", "documentsLayout"], ["id", "consent"], [1, "bg"], [3, "consenters"], ["id", "completion"], ["id", "noAccess"], [1, "primary"], [1, "documents"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], ["id", "documentElm", 1, "document-wrap"], [3, "changed", "content", "signing", "execute", "document"], [3, "close", "consenters"], [1, "content"], [1, "logo"], ["src", "/assets/images/logo.svg"], ["href", "mailto:support@repipe.com"], ["id", "loader"], [3, "fill"]], template: function DocumentLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, DocumentLayoutComponent_Conditional_0_Template, 6, 6);
    \u0275\u0275conditionalCreate(1, DocumentLayoutComponent_Conditional_1_Template, 3, 3, "aside", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.showContent ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showLoader ? 1 : -1);
  }
}, dependencies: [LoaderComponent, OpportunityDocumentComponent, ConsentComponent], styles: ["\n\n#documentsLayout[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n#documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  z-index: 1;\n}\n#documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%] {\n  position: relative;\n}\n#documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]     .document {\n  background-color: var(--color2);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  background-color: var(--color2);\n  border-radius: 999px;\n  opacity: 1;\n  -moz-transition: opacity 0.25s 0.25s;\n  -o-transition: opacity 0.25s 0.25s;\n  -webkit-transition: opacity 0.25s 0.25s;\n  transition: opacity 0.25s 0.25s;\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#consent[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#consent[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#consent.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#consent.active[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#noAccess[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#noAccess[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  z-index: 1;\n}\n#noAccess[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  width: 70vw;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n  background-color: var(--color2);\n  border: 0.2vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  padding: 2vw;\n}\n#noAccess[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%] {\n  text-align: center;\n}\n#noAccess[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%]   img[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .logo[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 25vw;\n}\n#noAccess[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  margin-top: 3vw;\n  font-size: 4.5vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  text-align: center;\n}\n#noAccess[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  font-size: 2.8vw;\n  color: var(--color1Alt4);\n  line-height: 1;\n  font-weight: var(--stdweight);\n  text-align: center;\n}\n#noAccess[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%]    > a[_ngcontent-%COMP%], \n#completion[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%]    > a[_ngcontent-%COMP%] {\n  color: var(--color3);\n  text-decoration: underline;\n  display: inline-block;\n}\n#loader[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10000;\n  background-color: var(--color2);\n  opacity: 1;\n  -moz-transition: opacity 2s 2s;\n  -o-transition: opacity 2s 2s;\n  -webkit-transition: opacity 2s 2s;\n  transition: opacity 2s 2s;\n}\n#loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 10001;\n  width: 20vw;\n  height: 20vw;\n  --fillSpeed: 2s;\n  opacity: 1;\n  -moz-transition: opacity 2s 2s;\n  -o-transition: opacity 2s 2s;\n  -webkit-transition: opacity 2s 2s;\n  transition: opacity 2s 2s;\n}\n#loader.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#loader.closing[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n@media only screen and (max-width: 1200px), only screen and (hover: none), only screen and (pointer: coarse) {\n  #documentsLayout[_ngcontent-%COMP%] {\n    position: fixed;\n    top: var(--systemOffset-top);\n    left: 0;\n    right: 0;\n    bottom: var(--systemOffset-bottom);\n    padding: 0 1vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n    position: sticky;\n    top: 0;\n    padding: 1vw 2vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n    font-size: 2.4vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    margin-left: 1vw;\n    font-size: 2.4vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%] {\n    flex: 1;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]     .document {\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    padding: 0 1vw;\n    border: 0.2vw var(--color2Alt3) solid;\n    border-radius: 1vw;\n    overflow-x: hidden;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%] {\n    padding: 2vw 0;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n    padding: 0.5vw 1vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n    margin-left: 1vw;\n    padding: 0.8vw 2vw;\n    border: 0.1vw transparent solid;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n   #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n    margin-left: 0.5vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n    font-size: 1.2vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 1.2vw;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: flex-start;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n    font-size: 5vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    margin-top: 1vw;\n    font-size: 5vw;\n    line-height: 1;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]     .document {\n    padding: 0 2vw;\n    overflow: scroll;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n    bottom: 2vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n    margin-left: 3vw;\n    padding: 1.5vw 3vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n   #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n    margin-left: 2vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n    font-size: 4vw;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 3vw;\n  }\n  #consent[_ngcontent-%COMP%]    > signing-consent[_ngcontent-%COMP%] {\n    width: 95vw;\n  }\n}\n@media only screen and (min-width: 1201px) and (hover: hover) and (pointer: fine) {\n    body {\n    overflow: initial;\n    background-color: var(--color2Alt2);\n    overscroll-behavior: none;\n  }\n  #documentsLayout[_ngcontent-%COMP%] {\n    position: relative;\n    width: 1240px;\n    margin: 0 auto;\n    padding: 0 10px;\n    background-color: var(--color2);\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n    padding: 10px 20px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n    font-size: 32px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n    margin-left: 10px;\n    font-size: 32px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]    > .documents[_ngcontent-%COMP%]     .document {\n    padding: 0 10px;\n    border: 2px var(--color2Alt3) solid;\n    border-radius: 8px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%] {\n    padding: 20px 0;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n    padding: 8px 12px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n    margin-left: 8px;\n    padding: 14px 20px;\n    border: 0.1vw transparent solid;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n   #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n    margin-left: 8px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n    font-size: 16px;\n  }\n  #documentsLayout[_ngcontent-%COMP%]   #mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n    font-size: 16px;\n  }\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var DocumentLayoutComponent = _DocumentLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DocumentLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "layout", providers: [OrderByPipe], template: `@if (showContent) {
  @if (showDocuments) {
    <main id="documentsLayout">
      <header>
        <div class="primary">
          <h1>Welcome back, {{recipientName}}</h1>
          <h2>Job: {{content?.jobId}}</h2>
        </div>
      </header>
      <div class="documents">
        @for (document of documents; track document) {
          @if (document.active) {
            <div id="documentElm" class="document-wrap">
              <opportunity-document
                (changed)="documentChanged(document)"
                [content]="content"
                [signing]="true"
                [execute]="false"
              [document]="document"></opportunity-document>
            </div>
          }
        }
      </div>
      <nav id="mainNav">
        <div class="island">
          <div class="controls">
            <button class="control" [disabled]="!canGoBack" (click)="goBack()">
              <i class="fa-solid fa-arrow-left-long"></i>
              <label>{{backLabel}}</label>
            </button>
            <button class="control success" [disabled]="!canGoForward" (click)="goForward()">
              <i class="fa-solid fa-arrow-right-long"></i>
              <label>{{forwardLabel}}</label>
            </button>
          </div>
        </div>
      </nav>
    </main>
  }
  <aside id="consent" [class.active]="consenting">
    <div class="bg"></div>
    @if (consenting) {
      <signing-consent
        [consenters]="consenters"
      (close)="finalizeConsent($event)"></signing-consent>
    }
  </aside>
  @if (showCompletion) {
    <aside id="completion">
      <div class="bg"></div>
      <div class="content">
        <div class="logo">
          <img src="/assets/images/logo.svg" />
        </div>
        <h2>You're all finished!</h2>
        <p>
          Thank you for completing your documents, we are grateful for your business! Please contact your consultant
          for additional assistance.
        </p>
        <p>You may now close this window.</p>
      </div>
    </aside>
  }
  @if (showNoAccess) {
    <aside id="noAccess">
      <div class="bg"></div>
      <div class="content">
        <div class="logo">
          <img src="/assets/images/logo.svg" />
        </div>
        <h2>Invite Was Not Found</h2>
        <p>
          Your provided invite code to sign documents in not valid. Please contact support at
          <a href="mailto:support@repipe.com">support&#64;repipe.com</a> for additional assistance.
        </p>
      </div>
    </aside>
  }
}

@if (showLoader) {
  <aside id="loader" [class.closing]="closingLoader">
    <div class="bg"></div>
    <loader [fill]="true"></loader>
  </aside>
}`, styles: ["/* src/app/documents/components/layout/layout.component.scss */\n#documentsLayout {\n  display: flex;\n  flex-direction: column;\n}\n#documentsLayout > header {\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  z-index: 1;\n}\n#documentsLayout > header > .primary {\n  display: flex;\n  align-items: center;\n}\n#documentsLayout > header > .primary h1 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#documentsLayout > header > .primary h2 {\n  margin-left: 1vw;\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#documentsLayout > .documents {\n  position: relative;\n}\n#documentsLayout > .documents ::ng-deep .document {\n  background-color: var(--color2);\n}\n#documentsLayout #mainNav > .island {\n  display: flex;\n  justify-content: flex-end;\n  background-color: var(--color2);\n  border-radius: 999px;\n  opacity: 1;\n  -moz-transition: opacity 0.25s 0.25s;\n  -o-transition: opacity 0.25s 0.25s;\n  -webkit-transition: opacity 0.25s 0.25s;\n  transition: opacity 0.25s 0.25s;\n}\n#documentsLayout #mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#documentsLayout #mainNav > .island > .controls > .control {\n  position: relative;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#documentsLayout #mainNav > .island > .controls > .control > i {\n  color: var(--color2);\n}\n#documentsLayout #mainNav > .island > .controls > .control > label {\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#documentsLayout #mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#documentsLayout #mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#documentsLayout #mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#documentsLayout #mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#documentsLayout #mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#documentsLayout #mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#documentsLayout #mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#documentsLayout #mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#consent {\n  pointer-events: none;\n}\n#consent > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  background-color: rgba(var(--color1-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent > signing-consent {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#consent.active {\n  pointer-events: initial;\n}\n#consent.active > .bg {\n  opacity: 1;\n}\n#consent.active > signing-consent {\n  opacity: 1;\n}\n#noAccess,\n#completion {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#noAccess > .bg,\n#completion > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  z-index: 1;\n}\n#noAccess > .content,\n#completion > .content {\n  width: 70vw;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 2;\n  background-color: var(--color2);\n  border: 0.2vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  padding: 2vw;\n}\n#noAccess > .content > .logo,\n#completion > .content > .logo {\n  text-align: center;\n}\n#noAccess > .content > .logo img,\n#completion > .content > .logo img {\n  width: 25vw;\n}\n#noAccess > .content > h2,\n#completion > .content > h2 {\n  margin-top: 3vw;\n  font-size: 4.5vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  text-align: center;\n}\n#noAccess > .content > p,\n#completion > .content > p {\n  margin-top: 2vw;\n  font-size: 2.8vw;\n  color: var(--color1Alt4);\n  line-height: 1;\n  font-weight: var(--stdweight);\n  text-align: center;\n}\n#noAccess > .content > p > a,\n#completion > .content > p > a {\n  color: var(--color3);\n  text-decoration: underline;\n  display: inline-block;\n}\n#loader > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10000;\n  background-color: var(--color2);\n  opacity: 1;\n  -moz-transition: opacity 2s 2s;\n  -o-transition: opacity 2s 2s;\n  -webkit-transition: opacity 2s 2s;\n  transition: opacity 2s 2s;\n}\n#loader > loader {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 10001;\n  width: 20vw;\n  height: 20vw;\n  --fillSpeed: 2s;\n  opacity: 1;\n  -moz-transition: opacity 2s 2s;\n  -o-transition: opacity 2s 2s;\n  -webkit-transition: opacity 2s 2s;\n  transition: opacity 2s 2s;\n}\n#loader.closing > .bg {\n  opacity: 0;\n}\n#loader.closing > loader {\n  opacity: 0;\n}\n@media only screen and (max-width: 1200px), only screen and (hover: none), only screen and (pointer: coarse) {\n  #documentsLayout {\n    position: fixed;\n    top: var(--systemOffset-top);\n    left: 0;\n    right: 0;\n    bottom: var(--systemOffset-bottom);\n    padding: 0 1vw;\n  }\n  #documentsLayout > header {\n    position: sticky;\n    top: 0;\n    padding: 1vw 2vw;\n  }\n  #documentsLayout > header > .primary h1 {\n    font-size: 2.4vw;\n  }\n  #documentsLayout > header > .primary h2 {\n    margin-left: 1vw;\n    font-size: 2.4vw;\n  }\n  #documentsLayout > .documents {\n    flex: 1;\n  }\n  #documentsLayout > .documents ::ng-deep .document {\n    position: absolute;\n    top: 0;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    padding: 0 1vw;\n    border: 0.2vw var(--color2Alt3) solid;\n    border-radius: 1vw;\n    overflow-x: hidden;\n  }\n  #documentsLayout #mainNav {\n    padding: 2vw 0;\n  }\n  #documentsLayout #mainNav > .island {\n    padding: 0.5vw 1vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control {\n    margin-left: 1vw;\n    padding: 0.8vw 2vw;\n    border: 0.1vw transparent solid;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > i:last-child,\n  #documentsLayout #mainNav > .island > .controls > .control > label:last-child {\n    margin-left: 0.5vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > i {\n    font-size: 1.2vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > label {\n    font-size: 1.2vw;\n  }\n}\n@media only screen and (max-width: 768px) {\n  #documentsLayout > header > .primary {\n    flex-direction: column;\n    align-items: flex-start;\n  }\n  #documentsLayout > header > .primary h1 {\n    font-size: 5vw;\n  }\n  #documentsLayout > header > .primary h2 {\n    margin-top: 1vw;\n    font-size: 5vw;\n    line-height: 1;\n  }\n  #documentsLayout > .documents ::ng-deep .document {\n    padding: 0 2vw;\n    overflow: scroll;\n  }\n  #documentsLayout #mainNav > .island {\n    bottom: 2vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control {\n    margin-left: 3vw;\n    padding: 1.5vw 3vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > i:last-child,\n  #documentsLayout #mainNav > .island > .controls > .control > label:last-child {\n    margin-left: 2vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > i {\n    font-size: 4vw;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > label {\n    font-size: 3vw;\n  }\n  #consent > signing-consent {\n    width: 95vw;\n  }\n}\n@media only screen and (min-width: 1201px) and (hover: hover) and (pointer: fine) {\n  ::ng-deep body {\n    overflow: initial;\n    background-color: var(--color2Alt2);\n    overscroll-behavior: none;\n  }\n  #documentsLayout {\n    position: relative;\n    width: 1240px;\n    margin: 0 auto;\n    padding: 0 10px;\n    background-color: var(--color2);\n  }\n  #documentsLayout > header {\n    padding: 10px 20px;\n  }\n  #documentsLayout > header > .primary h1 {\n    font-size: 32px;\n  }\n  #documentsLayout > header > .primary h2 {\n    margin-left: 10px;\n    font-size: 32px;\n  }\n  #documentsLayout > .documents ::ng-deep .document {\n    padding: 0 10px;\n    border: 2px var(--color2Alt3) solid;\n    border-radius: 8px;\n  }\n  #documentsLayout #mainNav {\n    padding: 20px 0;\n  }\n  #documentsLayout #mainNav > .island {\n    padding: 8px 12px;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control {\n    margin-left: 8px;\n    padding: 14px 20px;\n    border: 0.1vw transparent solid;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > i:last-child,\n  #documentsLayout #mainNav > .island > .controls > .control > label:last-child {\n    margin-left: 8px;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > i {\n    font-size: 16px;\n  }\n  #documentsLayout #mainNav > .island > .controls > .control > label {\n    font-size: 16px;\n  }\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: DocumentService }, { type: ActivatedRoute }, { type: OrderByPipe }], null);
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(DocumentLayoutComponent, { className: "DocumentLayoutComponent" });
})();

// src/app/documents/document-routing.module.ts
var routes = [
  {
    path: "",
    component: DocumentLayoutComponent
  }
];
var _DocumentRoutingModule = class _DocumentRoutingModule {
};
_DocumentRoutingModule.\u0275fac = function DocumentRoutingModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DocumentRoutingModule)();
};
_DocumentRoutingModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _DocumentRoutingModule });
_DocumentRoutingModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [RouterModule.forChild(routes), RouterModule] });
var DocumentRoutingModule = _DocumentRoutingModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DocumentRoutingModule, [{
    type: NgModule,
    args: [{
      imports: [RouterModule.forChild(routes)],
      exports: [RouterModule]
    }]
  }], null, null);
})();

// src/app/documents/documents.module.ts
var _DocumentModule = class _DocumentModule {
};
_DocumentModule.\u0275fac = function DocumentModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DocumentModule)();
};
_DocumentModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _DocumentModule });
_DocumentModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  OpportunityService,
  OrderByPipe,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  CommonModule,
  UiModule,
  SharedDocumentsModule,
  DocumentRoutingModule
] });
var DocumentModule = _DocumentModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DocumentModule, [{
    type: NgModule,
    args: [{
      declarations: [
        DocumentLayoutComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        CommonModule,
        UiModule,
        SharedDocumentsModule,
        DocumentRoutingModule
      ],
      providers: [
        OpportunityService,
        OrderByPipe,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], null, null);
})();
export {
  DocumentModule
};
//# sourceMappingURL=chunk-ULAMUOP2.js.map
