import {
  AdministrationService
} from "./chunk-RFRQWW6A.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  AppointmentStatus
} from "./chunk-N36JE2BE.js";
import {
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  FormsModule,
  HttpClient,
  Injectable,
  Injector,
  Input,
  LoaderComponent,
  NgModule,
  OrderByPipe,
  ReactiveFormsModule,
  UiModule,
  ViewChild,
  provideHttpClient,
  setClassMetadata,
  tap,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtext,
  ɵɵtextInterpolate1,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-RVA4KI76.js";

// src/app/administration/appointments/models/navigation.ts
var RouteType;
(function(RouteType2) {
  RouteType2["appointments"] = "manage";
})(RouteType || (RouteType = {}));

// src/app/administration/appointments/services/appointments.service.ts
var _AppointmentsManagementService = class _AppointmentsManagementService {
  constructor(http) {
    this.http = http;
  }
  getManagedAppointments(limit, offset) {
    const url = `{{api}}/appointments/manage/${limit}/${offset}`;
    return this.http.get(url);
  }
  exportAppointment(appointment) {
    const url = `{{api}}/appointments/manage/export/${appointment.id}`;
    return this.http.get(url).pipe(tap((response) => {
      const a = document.createElement("a");
      const dataStr = "data:text/json;charset=utf-8," + encodeURIComponent(JSON.stringify(response));
      a.setAttribute("href", dataStr);
      a.setAttribute("download", `${appointment.id}_export.json`);
      a.click();
      a.remove();
    }));
  }
  revertAppointment(appointmentId) {
    const url = `{{api}}/appointments/manage/revert/${appointmentId}`;
    const headers = { "Content-Type": "application/json" };
    return this.http.post(url, null, { headers }).pipe(tap(() => {
    }));
  }
  // #region Estimates
  getAppointmentSubmissions(appointmentId) {
    const url = `{{api}}/estimates/${appointmentId}/submissions`;
    return this.http.get(url);
  }
  submitEstimate(appointment) {
    const url = `{{api}}/estimates/submit/${appointment.id}`;
    return this.http.post(url, null);
  }
};
_AppointmentsManagementService.\u0275fac = function AppointmentsManagementService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentsManagementService)(\u0275\u0275inject(HttpClient));
};
_AppointmentsManagementService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _AppointmentsManagementService, factory: _AppointmentsManagementService.\u0275fac, providedIn: "root" });
var AppointmentsManagementService = _AppointmentsManagementService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentsManagementService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }], null);
})();

// src/app/administration/appointments/components/appointments/appointments.component.ts
var _c0 = ["componentElm"];
function AppointmentsComponent_Conditional_1_Conditional_7_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_7_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 8);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 5);
    \u0275\u0275conditionalCreate(1, AppointmentsComponent_Conditional_1_Conditional_7_Conditional_1_Template, 1, 0, "i", 7);
    \u0275\u0275conditionalCreate(2, AppointmentsComponent_Conditional_1_Conditional_7_Conditional_2_Template, 1, 0, "i", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.sortDescending ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.sortDescending ? 2 : -1);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_11_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_11_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 8);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 5);
    \u0275\u0275conditionalCreate(1, AppointmentsComponent_Conditional_1_Conditional_11_Conditional_1_Template, 1, 0, "i", 7);
    \u0275\u0275conditionalCreate(2, AppointmentsComponent_Conditional_1_Conditional_11_Conditional_2_Template, 1, 0, "i", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.sortDescending ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.sortDescending ? 2 : -1);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_15_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_15_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 8);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 5);
    \u0275\u0275conditionalCreate(1, AppointmentsComponent_Conditional_1_Conditional_15_Conditional_1_Template, 1, 0, "i", 7);
    \u0275\u0275conditionalCreate(2, AppointmentsComponent_Conditional_1_Conditional_15_Conditional_2_Template, 1, 0, "i", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.sortDescending ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.sortDescending ? 2 : -1);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_25_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_25_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 8);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_25_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 5);
    \u0275\u0275conditionalCreate(1, AppointmentsComponent_Conditional_1_Conditional_25_Conditional_1_Template, 1, 0, "i", 7);
    \u0275\u0275conditionalCreate(2, AppointmentsComponent_Conditional_1_Conditional_25_Conditional_2_Template, 1, 0, "i", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.sortDescending ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.sortDescending ? 2 : -1);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_29_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 7);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_29_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 8);
  }
}
function AppointmentsComponent_Conditional_1_Conditional_29_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 5);
    \u0275\u0275conditionalCreate(1, AppointmentsComponent_Conditional_1_Conditional_29_Conditional_1_Template, 1, 0, "i", 7);
    \u0275\u0275conditionalCreate(2, AppointmentsComponent_Conditional_1_Conditional_29_Conditional_2_Template, 1, 0, "i", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.sortDescending ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.sortDescending ? 2 : -1);
  }
}
function AppointmentsComponent_Conditional_1_For_32_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "tr")(1, "td", 2)(2, "button", 9);
    \u0275\u0275listener("click", function AppointmentsComponent_Conditional_1_For_32_Template_button_click_2_listener() {
      const appointment_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.revert(appointment_r4));
    });
    \u0275\u0275elementStart(3, "label");
    \u0275\u0275text(4, "Revert");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(5, "td", 10)(6, "span", 11);
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(8, "td")(9, "span", 11);
    \u0275\u0275text(10);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(11, "td")(12, "span", 11);
    \u0275\u0275text(13);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(14, "td")(15, "span", 11);
    \u0275\u0275text(16);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(17, "td")(18, "span", 11);
    \u0275\u0275text(19);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(20, "td")(21, "span", 11);
    \u0275\u0275text(22);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(23, "td")(24, "span", 11);
    \u0275\u0275text(25);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const appointment_r4 = ctx.$implicit;
    \u0275\u0275classProp("disabled", appointment_r4.reverting);
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", appointment_r4.id, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", appointment_r4.jobId, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", appointment_r4.netSuiteId, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", appointment_r4.assignedName, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", appointment_r4.customerName, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", appointment_r4.status, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", appointment_r4.dispositionStatus, " ");
  }
}
function AppointmentsComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 1)(1, "table")(2, "thead");
    \u0275\u0275element(3, "th", 2);
    \u0275\u0275elementStart(4, "th", 3);
    \u0275\u0275listener("click", function AppointmentsComponent_Conditional_1_Template_th_click_4_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.setSort("id"));
    });
    \u0275\u0275elementStart(5, "span", 4);
    \u0275\u0275text(6, " Id ");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(7, AppointmentsComponent_Conditional_1_Conditional_7_Template, 3, 2, "span", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "th", 3);
    \u0275\u0275listener("click", function AppointmentsComponent_Conditional_1_Template_th_click_8_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.setSort("jobId"));
    });
    \u0275\u0275elementStart(9, "span", 4);
    \u0275\u0275text(10, " Job ");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(11, AppointmentsComponent_Conditional_1_Conditional_11_Template, 3, 2, "span", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "th", 3);
    \u0275\u0275listener("click", function AppointmentsComponent_Conditional_1_Template_th_click_12_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.setSort("netSuiteId"));
    });
    \u0275\u0275elementStart(13, "span", 4);
    \u0275\u0275text(14, " Opportunity ");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(15, AppointmentsComponent_Conditional_1_Conditional_15_Template, 3, 2, "span", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(16, "th")(17, "span", 4);
    \u0275\u0275text(18, " Assigned To ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "th")(20, "span", 4);
    \u0275\u0275text(21, " Customer ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(22, "th", 3);
    \u0275\u0275listener("click", function AppointmentsComponent_Conditional_1_Template_th_click_22_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.setSort("status"));
    });
    \u0275\u0275elementStart(23, "span", 4);
    \u0275\u0275text(24, " Status ");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(25, AppointmentsComponent_Conditional_1_Conditional_25_Template, 3, 2, "span", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "th", 3);
    \u0275\u0275listener("click", function AppointmentsComponent_Conditional_1_Template_th_click_26_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.setSort("dispositionStatus"));
    });
    \u0275\u0275elementStart(27, "span", 4);
    \u0275\u0275text(28, " Disposition Status ");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(29, AppointmentsComponent_Conditional_1_Conditional_29_Template, 3, 2, "span", 5);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(30, "tbody");
    \u0275\u0275repeaterCreate(31, AppointmentsComponent_Conditional_1_For_32_Template, 26, 9, "tr", 6, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(7);
    \u0275\u0275conditional(ctx_r1.sort == "id" ? 7 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx_r1.sort == "jobId" ? 11 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx_r1.sort == "netSuiteId" ? 15 : -1);
    \u0275\u0275advance(10);
    \u0275\u0275conditional(ctx_r1.sort == "status" ? 25 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(ctx_r1.sort == "dispositionStatus" ? 29 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r1.sortedAppointments);
  }
}
var _AppointmentsComponent = class _AppointmentsComponent {
  constructor(mgmtService, uiService, orderByPipe) {
    this.mgmtService = mgmtService;
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.retrievingAppointments = false;
    this.AppointmentStatus = AppointmentStatus;
    this.appointments = [];
    this.sortedAppointments = [];
    this.retrievalLimit = 200;
    this.retrievalOffset = 0;
    this.retrievingEstimateSubmissions = false;
    this.appointmentSubmissions = [];
    this.sort = "lastUpdated_Utc";
    this.sortDescending = true;
  }
  get hasAppointments() {
    return this.appointments.length > 0;
  }
  getAppointments() {
    this.retrievingAppointments = true;
    this.mgmtService.getManagedAppointments(this.retrievalLimit, this.retrievalOffset).subscribe({
      next: (appointments) => {
        this.appointments = appointments;
        this.sortAppointments();
        this.retrievingAppointments = false;
      },
      error: () => {
        this.retrievingAppointments = false;
      }
    });
  }
  revert(appointment) {
    appointment.reverting = true;
    this.uiService.prompt(`Revert Job ${appointment.jobId}?`, "Reverting an appointment will reset all of its data. This is unrecoverable. Continue?", "Yes, Revert", "No, Cancel").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.mgmtService.revertAppointment(appointment.id).subscribe({
            next: () => {
              this.uiService.prompt(`Job ${appointment.jobId} Reverted`, "The appointment has been reverted back to a default state.", "Okay").subscribe({
                next: () => {
                  appointment.status = AppointmentStatus.Open;
                  appointment.dispositionStatus = void 0;
                  appointment.reverting = false;
                }
              });
            },
            error: () => {
              this.uiService.prompt(`Failed to Revert Job ${appointment.jobId}`, "There was an issue reverting the appointment. Please try again.", "Okay").subscribe({
                next: () => {
                  appointment.reverting = false;
                }
              });
            }
          });
        } else {
          appointment.reverting = false;
        }
      }
    });
  }
  export(appointment) {
    this.mgmtService.exportAppointment(appointment).subscribe({
      next: () => {
      }
    });
  }
  get showEstimateSubmissions() {
    return this.submittingAppointment != null;
  }
  get hasAppointmentSubmissions() {
    return this.appointmentSubmissions.length > 0;
  }
  promptToSubmitAppointment(appointment) {
    this.submittingAppointment = appointment;
    this.getEstimateSubmissions(appointment.id);
  }
  stopSubmittingEstimate() {
    this.submittingAppointment = void 0;
    this.appointmentSubmissions = [];
  }
  getEstimateSubmissions(appointmentId) {
    this.retrievingEstimateSubmissions = true;
    this.mgmtService.getAppointmentSubmissions(appointmentId).subscribe({
      next: (appEvents) => {
        this.appointmentSubmissions = appEvents;
        this.retrievingEstimateSubmissions = false;
      },
      error: () => {
        this.retrievingEstimateSubmissions = false;
      }
    });
  }
  submitEstimate() {
    if (this.submittingAppointment != null && !this.submittingAppointment.submittingEstimate) {
      this.submittingAppointment.submittingEstimate = true;
      this.mgmtService.submitEstimate(this.submittingAppointment).subscribe({
        next: () => {
          if (this.submittingAppointment != null) {
            this.submittingAppointment.status = AppointmentStatus.Submitted;
            this.submittingAppointment.submittingEstimate = false;
            this.getEstimateSubmissions(this.submittingAppointment.id);
          }
        },
        error: () => {
          if (this.submittingAppointment != null) {
            this.submittingAppointment.submittingEstimate = false;
          }
        }
      });
    }
  }
  sortAppointments() {
    this.sortedAppointments = this.orderByPipe.transform(this.appointments, this.sort, this.sortDescending);
  }
  setSort(sort) {
    if (this.sort == sort) {
      this.toggleSortDirection();
    }
    this.sort = sort;
    this.sortAppointments();
  }
  toggleSortDirection() {
    this.sortDescending = !this.sortDescending;
  }
  // #endregion
  // #region UI
  get showLoader() {
    return this.retrievingAppointments;
  }
  init() {
    this.getAppointments();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_AppointmentsComponent.\u0275fac = function AppointmentsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentsComponent)(\u0275\u0275directiveInject(AppointmentsManagementService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_AppointmentsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AppointmentsComponent, selectors: [["appointments"]], viewQuery: function AppointmentsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { route: "route" }, standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 3, vars: 3, consts: [["id", "appointments"], [1, "content"], [1, "controls"], [3, "click"], [1, "title"], [1, "icon"], [3, "disabled"], [1, "fa-solid", "fa-caret-up"], [1, "fa-solid", "fa-caret-down"], [1, "control", 3, "click"], [1, "id"], [1, "value"]], template: function AppointmentsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0);
    \u0275\u0275conditionalCreate(1, AppointmentsComponent_Conditional_1_Template, 33, 5, "div", 1);
    \u0275\u0275elementEnd();
    \u0275\u0275element(2, "loader");
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.hasAppointments ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.showLoader);
  }
}, dependencies: [LoaderComponent], styles: ["\n\n#appointments[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  width: 100%;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%] {\n  min-width: 100%;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   th.controls[_ngcontent-%COMP%], \n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   td.controls[_ngcontent-%COMP%] {\n  width: 15vw;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  padding: 0.6vw 0;\n  background-color: var(--color2Alt3);\n  position: relative;\n  border-right: 0.1vw var(--color1Alt1) solid;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]    > .title[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  padding: 0 2vw;\n  color: var(--color1);\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  right: 1.2vw;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]:last-child {\n  border-right: none;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%] {\n  border-top: 0.1vw var(--color1Alt1) solid;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n  padding: 0.4vw 1vw;\n  border-right: 0.1vw var(--color2Alt3) solid;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.2vw;\n  color: var(--color1);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  padding: 0.4vw 1vw;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:focus-within {\n  border-color: var(--color3);\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td.id[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 1vw;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td.controls[_ngcontent-%COMP%] {\n  text-align: center;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td.controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: inline-block;\n  width: 8vw;\n  padding: 0.5vw;\n  border-radius: 0.5vw;\n  background-color: var(--color3);\n  border: 0.05vw var(--color2Alt4) solid;\n  cursor: pointer;\n  text-align: center;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td.controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-size: 1.2vw;\n  text-transform: uppercase;\n  font-weight: var(--strong);\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%]:last-child {\n  border-right: none;\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]:nth-child(even) {\n  background-color: var(--color2Alt2);\n}\n#appointments[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr.disabled[_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmissions[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: var(--sideNav-layer);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 70vw;\n  height: 60vh;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  margin-left: 1vw;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  padding: 2vw 0;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  text-align: center;\n  font-size: 1.8vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .submissions[_ngcontent-%COMP%]    > .submission[_ngcontent-%COMP%] {\n  border-left: 0.5vw var(--color1Alt3) solid;\n  padding-left: 0.5vw;\n  margin-top: 1vw;\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .submissions[_ngcontent-%COMP%]    > .submission[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: inline;\n  font-size: 1.6vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n}\n#estimateSubmissions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .submissions[_ngcontent-%COMP%]    > .submission[_ngcontent-%COMP%]    > span[_ngcontent-%COMP%] {\n  display: inline;\n  font-size: 1.6vw;\n  color: var(--color3Alt4);\n  font-weight: var(--stdweight);\n}\n#estimateSubmissions.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#estimateSubmissions.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#estimateSubmissions.active[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  opacity: 1;\n}\nloader[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=appointments.component.css.map */"] });
var AppointmentsComponent = _AppointmentsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "appointments", providers: [OrderByPipe], template: `<section id="appointments">
  @if (hasAppointments) {
    <div class="content">
      <table>
        <thead>
          <th class="controls">
          </th>
          <th (click)="setSort('id')">
            <span class="title">
              Id
            </span>
            @if (sort == 'id') {
              <span class="icon">
                @if (!sortDescending) {
                  <i class="fa-solid fa-caret-up"></i>
                }
                @if (sortDescending) {
                  <i class="fa-solid fa-caret-down"></i>
                }
              </span>
            }
          </th>
          <th (click)="setSort('jobId')">
            <span class="title">
              Job
            </span>
            @if (sort == 'jobId') {
              <span class="icon">
                @if (!sortDescending) {
                  <i class="fa-solid fa-caret-up"></i>
                }
                @if (sortDescending) {
                  <i class="fa-solid fa-caret-down"></i>
                }
              </span>
            }
          </th>
          <th (click)="setSort('netSuiteId')">
            <span class="title">
              Opportunity
            </span>
            @if (sort == 'netSuiteId') {
              <span class="icon">
                @if (!sortDescending) {
                  <i class="fa-solid fa-caret-up"></i>
                }
                @if (sortDescending) {
                  <i class="fa-solid fa-caret-down"></i>
                }
              </span>
            }
          </th>
          <th>
            <span class="title">
              Assigned To
            </span>
          </th>
          <th>
            <span class="title">
              Customer
            </span>
          </th>
          <th (click)="setSort('status')">
            <span class="title">
              Status
            </span>
            @if (sort == 'status') {
              <span class="icon">
                @if (!sortDescending) {
                  <i class="fa-solid fa-caret-up"></i>
                }
                @if (sortDescending) {
                  <i class="fa-solid fa-caret-down"></i>
                }
              </span>
            }
          </th>
          <th (click)="setSort('dispositionStatus')">
            <span class="title">
              Disposition Status
            </span>
            @if (sort == 'dispositionStatus') {
              <span class="icon">
                @if (!sortDescending) {
                  <i class="fa-solid fa-caret-up"></i>
                }
                @if (sortDescending) {
                  <i class="fa-solid fa-caret-down"></i>
                }
              </span>
            }
          </th>
        </thead>
        <tbody>
          @for (appointment of sortedAppointments; track appointment) {
            <tr [class.disabled]="appointment.reverting">
              <td class="controls">
                <button class="control" (click)="revert(appointment)">
                  <label>Revert</label>
                </button>
              </td>
              <td class="id">
                <span class="value">
                  {{appointment.id}}
                </span>
              </td>
              <td>
                <span class="value">
                  {{appointment.jobId}}
                </span>
              </td>
              <td>
                <span class="value">
                  {{appointment.netSuiteId}}
                </span>
              </td>
              <td>
                <span class="value">
                  {{appointment.assignedName}}
                </span>
              </td>
              <td>
                <span class="value">
                  {{appointment.customerName}}
                </span>
              </td>
              <td>
                <span class="value">
                  {{appointment.status}}
                </span>
              </td>
              <td>
                <span class="value">
                  {{appointment.dispositionStatus}}
                </span>
              </td>
            </tr>
          }
        </tbody>
      </table>
    </div>
  }
</section>

<loader [class.active]="showLoader"></loader>`, styles: ["/* src/app/administration/appointments/components/appointments/appointments.component.scss */\n#appointments {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n}\n#appointments > .content {\n  position: relative;\n  height: 100%;\n  width: 100%;\n}\n#appointments > .content > table {\n  min-width: 100%;\n}\n#appointments > .content > table th.controls,\n#appointments > .content > table td.controls {\n  width: 15vw;\n}\n#appointments > .content > table thead th {\n  padding: 0.6vw 0;\n  background-color: var(--color2Alt3);\n  position: relative;\n  border-right: 0.1vw var(--color1Alt1) solid;\n}\n#appointments > .content > table thead th > .title {\n  font-size: 1.2vw;\n  padding: 0 2vw;\n  color: var(--color1);\n}\n#appointments > .content > table thead th > .icon {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  right: 1.2vw;\n}\n#appointments > .content > table thead th > .icon i {\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n#appointments > .content > table thead th:last-child {\n  border-right: none;\n}\n#appointments > .content > table tbody tr {\n  border-top: 0.1vw var(--color1Alt1) solid;\n}\n#appointments > .content > table tbody tr td {\n  padding: 0.4vw 1vw;\n  border-right: 0.1vw var(--color2Alt3) solid;\n}\n#appointments > .content > table tbody tr td > .value {\n  display: block;\n  width: 100%;\n  font-size: 1.2vw;\n  color: var(--color1);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#appointments > .content > table tbody tr td > .input-wrap {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  padding: 0.4vw 1vw;\n  background-color: var(--color2);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#appointments > .content > table tbody tr td > .input-wrap select {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n#appointments > .content > table tbody tr td > .input-wrap:focus-within {\n  border-color: var(--color3);\n}\n#appointments > .content > table tbody tr td.id > .value {\n  font-size: 1vw;\n}\n#appointments > .content > table tbody tr td.controls {\n  text-align: center;\n}\n#appointments > .content > table tbody tr td.controls > .control {\n  display: inline-block;\n  width: 8vw;\n  padding: 0.5vw;\n  border-radius: 0.5vw;\n  background-color: var(--color3);\n  border: 0.05vw var(--color2Alt4) solid;\n  cursor: pointer;\n  text-align: center;\n}\n#appointments > .content > table tbody tr td.controls > .control > label {\n  color: var(--color2);\n  font-size: 1.2vw;\n  text-transform: uppercase;\n  font-weight: var(--strong);\n}\n#appointments > .content > table tbody tr td:last-child {\n  border-right: none;\n}\n#appointments > .content > table tbody tr:nth-child(even) {\n  background-color: var(--color2Alt2);\n}\n#appointments > .content > table tbody tr.disabled {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#estimateSubmissions {\n  pointer-events: none;\n}\n#estimateSubmissions > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: var(--sideNav-layer);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#estimateSubmissions > .content {\n  display: block;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 70vw;\n  height: 60vh;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#estimateSubmissions > .content > header {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#estimateSubmissions > .content > header > .primary {\n  padding: 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#estimateSubmissions > .content > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#estimateSubmissions > .content > header > .primary > .controls {\n  display: flex;\n  align-items: center;\n}\n#estimateSubmissions > .content > header > .primary > .controls > .control {\n  cursor: pointer;\n  margin-left: 1vw;\n}\n#estimateSubmissions > .content > header > .primary > .controls > .control > label {\n  color: var(--color3);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#estimateSubmissions > .content > header > .primary > .controls > .control > label[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#estimateSubmissions > .content > header > .primary > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#estimateSubmissions > .content > .content {\n  flex: 1;\n  overflow-x: hidden;\n  padding: 1vw;\n}\n#estimateSubmissions > .content > .content > .message {\n  padding: 2vw 0;\n}\n#estimateSubmissions > .content > .content > .message p {\n  text-align: center;\n  font-size: 1.8vw;\n  color: var(--color1Alt2);\n  font-weight: var(--ltweight);\n}\n#estimateSubmissions > .content > .content > .submissions > .submission {\n  border-left: 0.5vw var(--color1Alt3) solid;\n  padding-left: 0.5vw;\n  margin-top: 1vw;\n}\n#estimateSubmissions > .content > .content > .submissions > .submission > label {\n  display: inline;\n  font-size: 1.6vw;\n  color: var(--color1Alt4);\n  font-weight: var(--stdweight);\n}\n#estimateSubmissions > .content > .content > .submissions > .submission > span {\n  display: inline;\n  font-size: 1.6vw;\n  color: var(--color3Alt4);\n  font-weight: var(--stdweight);\n}\n#estimateSubmissions.active {\n  pointer-events: initial;\n}\n#estimateSubmissions.active > .bg {\n  opacity: 1;\n}\n#estimateSubmissions.active > .content {\n  opacity: 1;\n}\nloader {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=appointments.component.css.map */\n"] }]
  }], () => [{ type: AppointmentsManagementService }, { type: UiService }, { type: OrderByPipe }], { route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AppointmentsComponent, { className: "AppointmentsComponent" });
})();

// src/app/administration/appointments/components/layout/layout.component.ts
var _c02 = ["componentElm"];
function LayoutComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "appointments", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.loadDirection));
    \u0275\u0275classProp("rendered", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.rendered)("animate", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.animating)("closing", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.closing);
    \u0275\u0275property("route", ctx_r0.appointmentsRoute);
  }
}
var _LayoutComponent = class _LayoutComponent {
  constructor(routeService, adminService, uiService) {
    this.routeService = routeService;
    this.adminService = adminService;
    this.uiService = uiService;
    this.RouteType = RouteType;
    this.routesInitialized = false;
    this.params = new BehaviorSubject([]);
  }
  get routes() {
    return this.routeService.routes;
  }
  initRoutes(initialRouteType = void 0) {
    setTimeout(() => {
      if (this.componentElm != null) {
        const routes = {
          [RouteType.appointments]: new InternalRoute(RouteType.appointments)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : RouteType.appointments;
        this.routeService.init(routes, initialRoute, 250, this.componentElm.nativeElement);
        this.routeSubscription = this.routeService.activeRoute.subscribe({
          next: (route) => {
            if (route != null) {
              switch (route.type) {
                case RouteType.appointments:
                  {
                    this.setTitle("Appointment Management");
                  }
                  break;
              }
            }
          }
        });
        this.routesInitialized = true;
      }
    }, 0);
  }
  viewRoute(type) {
    if (type != null) {
      this.routeService.viewRoute(type, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Settings
  get appointmentsRoute() {
    return this.routes[RouteType.appointments];
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        let route = params[0]?.toLowerCase();
        if (route != null) {
          const routeMatches = Object.values(RouteType).includes(route);
          if (routeMatches) {
            if (!this.routesInitialized) {
              this.initRoutes(route);
            } else {
              this.viewRoute(route);
            }
          } else {
            if (!this.routesInitialized) {
              this.initRoutes();
            }
          }
        }
      }
    });
  }
  setTitle(routeTitle) {
    this.adminService.routeTitle.next(routeTitle);
  }
  init() {
    this.watchParams();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_LayoutComponent.\u0275fac = function LayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LayoutComponent)(\u0275\u0275directiveInject(InternalRouteService), \u0275\u0275directiveInject(AdministrationService), \u0275\u0275directiveInject(UiService));
};
_LayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _LayoutComponent, selectors: [["layout"]], viewQuery: function LayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 4, vars: 1, consts: [["componentElm", ""], ["id", "entitiesLayout"], [1, "routes"], [3, "class", "route", "rendered", "animate", "closing"], [3, "route"]], template: function LayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "div", 2);
    \u0275\u0275conditionalCreate(3, LayoutComponent_Conditional_3_Template, 1, 10, "appointments", 3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275conditional((ctx.appointmentsRoute == null ? null : ctx.appointmentsRoute.active) ? 3 : -1);
  }
}, dependencies: [AppointmentsComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#entitiesLayout[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var LayoutComponent = _LayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LayoutComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "layout", template: '<section id="entitiesLayout" #componentElm>\n  <div class="routes">\n    @if (appointmentsRoute?.active) {\n      <appointments\n        class="route {{appointmentsRoute?.loadDirection}}"\n        [route]="appointmentsRoute"\n        [class.rendered]="appointmentsRoute?.rendered"\n        [class.animate]="appointmentsRoute?.animating"\n      [class.closing]="appointmentsRoute?.closing"></appointments>\n    }\n  </div>\n</section>', styles: ["/* src/app/administration/appointments/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#entitiesLayout {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n}\n#entitiesLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#entitiesLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#entitiesLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: InternalRouteService }, { type: AdministrationService }, { type: UiService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], params: [{
    type: Input,
    args: ["params"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(LayoutComponent, { className: "LayoutComponent" });
})();

// src/app/administration/appointments/appointments.module.ts
var _AppointmentsModule = class _AppointmentsModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(LayoutComponent, { injector: this.injector });
    customElements.define("administration-appointments", el);
  }
};
_AppointmentsModule.\u0275fac = function AppointmentsModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AppointmentsModule)(\u0275\u0275inject(Injector));
};
_AppointmentsModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _AppointmentsModule });
_AppointmentsModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  InternalRouteService,
  AppointmentsManagementService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var AppointmentsModule = _AppointmentsModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AppointmentsModule, [{
    type: NgModule,
    args: [{
      declarations: [
        LayoutComponent,
        AppointmentsComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        InternalRouteService,
        AppointmentsManagementService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  AppointmentsModule
};
//# sourceMappingURL=chunk-6IS2TKBL.js.map
