import {
  ReminderPriority,
  ReminderStatus
} from "./chunk-ZEKYPX2O.js";
import {
  AuthRefService,
  OpportunityStatus
} from "./chunk-M3LFBN7N.js";
import {
  DatePipe,
  HttpClient,
  Injectable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/system/services/ai.service.ts
var _AiService = class _AiService {
  constructor(http, authRefService, datePipe) {
    this.http = http;
    this.authRefService = authRefService;
    this.datePipe = datePipe;
    this.activeUser = null;
    this.watchUser();
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Daily Summary
  generateDailySummary(opportunities, reminders) {
    if (this.activeUser != null) {
      const criticalReminders = [];
      reminders.forEach((reminder) => {
        if (reminder.priority == ReminderPriority.Critical && reminder.status != ReminderStatus.Completed) {
          criticalReminders.push(reminder);
        }
      });
      const openAppointments = [];
      opportunities.forEach((opportunity) => {
        if (opportunity.status != OpportunityStatus.Canceled) {
          openAppointments.push(opportunity);
        }
      });
      const appointmentWord = openAppointments.length == 1 ? "appointment" : "appointments";
      const reminderWord = criticalReminders.length == 1 ? "reminder" : "reminders";
      if (criticalReminders.length > 0 && openAppointments.length > 0) {
        const firstAppointmentDate = openAppointments[0].scheduled_Utc;
        const firstAppointmentDateStr = this.datePipe.transform(firstAppointmentDate, "h:mm a");
        return `
                    Today, you have ${criticalReminders.length} critical reminders to follow up on,
                    followed by ${openAppointments.length} ${appointmentWord} with the first starting at ${firstAppointmentDateStr}.
                `;
      } else if (openAppointments.length > 0) {
        const firstAppointmentDate = openAppointments[0].scheduled_Utc;
        const firstAppointmentDateStr = this.datePipe.transform(firstAppointmentDate, "h:mm a");
        return `
                    Today, you have ${openAppointments.length} ${appointmentWord} with the first starting at ${firstAppointmentDateStr}.
                `;
      } else if (criticalReminders.length > 0) {
        return `
                    Today, you have ${criticalReminders.length} ${reminderWord} to follow up on.
                    There are currently no appointments scheduled for today.
                `;
      } else {
        return `
                    You currently have no critical reminders or appointments scheduled for today.
                `;
      }
    }
    return "No summary available.";
  }
  generateManagerSummary(teamMembers, opportunities, activeTeamMember) {
    return `
            You currently have ${teamMembers.length} viewable consultants on your team.
        `;
  }
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
  }
};
_AiService.\u0275fac = function AiService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AiService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(AuthRefService), \u0275\u0275inject(DatePipe));
};
_AiService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _AiService, factory: _AiService.\u0275fac });
var AiService = _AiService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AiService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: AuthRefService }, { type: DatePipe }], null);
})();

export {
  AiService
};
//# sourceMappingURL=chunk-ACY4QHGY.js.map
