import {
  SystemService
} from "./chunk-ZCU5UWZD.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  OpportunityService
} from "./chunk-SVCL2W7C.js";
import {
  AuthRefService
} from "./chunk-M3LFBN7N.js";
import {
  BehaviorSubject,
  HttpClient,
  Injectable,
  Subject,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/opportunities/services/opportunity-ui.service.ts
var _OpportunityUiService = class _OpportunityUiService {
  constructor(http, systemService, authRefService, opportunityService, uiService) {
    this.http = http;
    this.systemService = systemService;
    this.authRefService = authRefService;
    this.opportunityService = opportunityService;
    this.uiService = uiService;
    this.activeUser = null;
    this.viewingLedger = new BehaviorSubject(void 0);
    this.stoppedViewingLedger = new Subject();
    this.sendingForQuote = new BehaviorSubject(void 0);
    this.stoppedSendingForQuote = new Subject();
    this.sendingExecutedDocuments = new BehaviorSubject(void 0);
    this.stoppedSendingExecutedDocuments = new Subject();
    this.documentsSentForSigning = new BehaviorSubject(void 0);
    this.sendingDocuments = new BehaviorSubject(void 0);
    this.stoppedSendingDocuments = new Subject();
    this.signingDocuments = new BehaviorSubject(void 0);
    this.stoppedSigningDocuments = new Subject();
    this.preparingEstimate = new BehaviorSubject(void 0);
    this.viewingDetails = new BehaviorSubject(void 0);
    this.managingPayments = new BehaviorSubject(void 0);
    this.watchUser();
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  startViewingLedger(opportunity) {
    this.viewingLedger.next(opportunity);
  }
  stopViewingLedger() {
    this.viewingLedger.next(void 0);
    this.stoppedViewingLedger.next();
  }
  startSendingQuote(opportunity) {
    if (this.activeUser != null) {
      if (opportunity.documents.length <= 0) {
        const canModifyOpportunity = this.opportunityService.canModifyOpportunity(opportunity);
        const newDocuments = opportunity.generateDocuments();
        if (canModifyOpportunity) {
          this.opportunityService.updateDocuments(opportunity, newDocuments, this.activeUser).then(() => {
            this.sendingForQuote.next(opportunity);
          });
        } else {
          opportunity.documents = newDocuments;
          this.sendingForQuote.next(opportunity);
        }
      } else {
        this.sendingForQuote.next(opportunity);
      }
    } else {
      this.uiService.prompt("Unable to Prepare Quote", "You do not have permission to prepare a quote. Please contact support or try logging in again.", "Okay").subscribe({
        next: () => {
        }
      });
    }
  }
  stopSendingQuote() {
    this.sendingForQuote.next(void 0);
    this.stoppedSendingForQuote.next();
  }
  startSendingExecutedDocuments(opportunity) {
    this.sendingExecutedDocuments.next(opportunity);
  }
  stopSendingExecutedDocuments() {
    this.sendingExecutedDocuments.next(void 0);
    this.stoppedSendingExecutedDocuments.next();
  }
  startSendingDocuments(opportunity) {
    this.sendingDocuments.next(opportunity);
  }
  stopSendingDocuments(sent = void 0) {
    this.documentsSentForSigning.next(sent);
    this.sendingDocuments.next(void 0);
    this.stoppedSendingDocuments.next();
  }
  startSigningDocuments(opportunity, signer, onlyCustomerFacing = false) {
    this.signingDocuments.next({
      opportunity,
      onlyCustomerFacing,
      signer
    });
  }
  stopSigningDocuments() {
    this.signingDocuments.next(void 0);
    this.stoppedSigningDocuments.next();
  }
  startPreparingEstimate(opportunity) {
    this.preparingEstimate.next(opportunity);
  }
  stopPreparingEstimate() {
    this.preparingEstimate.next(void 0);
  }
  viewDetails(opportunity) {
    this.viewingDetails.next(opportunity);
  }
  stopViewingDetails() {
    this.viewingDetails.next(void 0);
  }
  startMakingPayments(opportunity) {
    this.managingPayments.next(opportunity);
  }
  stopMakingPayments() {
    this.managingPayments.next(void 0);
  }
  // #endregion
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
  }
};
_OpportunityUiService.\u0275fac = function OpportunityUiService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityUiService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(SystemService), \u0275\u0275inject(AuthRefService), \u0275\u0275inject(OpportunityService), \u0275\u0275inject(UiService));
};
_OpportunityUiService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _OpportunityUiService, factory: _OpportunityUiService.\u0275fac });
var OpportunityUiService = _OpportunityUiService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityUiService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: SystemService }, { type: AuthRefService }, { type: OpportunityService }, { type: UiService }], null);
})();

export {
  OpportunityUiService
};
//# sourceMappingURL=chunk-EKTNPYLZ.js.map
