import {
  PersonalPresentation,
  PresentationContentType,
  PresentationPage,
  PresentationService
} from "./chunk-HKPPSG2L.js";
import {
  Draggable,
  gsapWithCSS
} from "./chunk-DZY2UUHE.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  ApiService
} from "./chunk-QFGEJYGO.js";
import {
  AuthRefService,
  StorageService
} from "./chunk-M3LFBN7N.js";
import "./chunk-N36JE2BE.js";
import "./chunk-IV25C5MY.js";
import {
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  DefaultValueAccessor,
  DomSanitizer,
  FormsModule,
  HttpClient,
  Injectable,
  Injector,
  Input,
  LoaderComponent,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  QueryList,
  ReactiveFormsModule,
  SelectControlValueAccessor,
  UiModule,
  ViewChild,
  ViewChildren,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeUrl,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-RVA4KI76.js";

// src/app/presentation/models/navigation.ts
var PresentationRouteType;
(function(PresentationRouteType2) {
  PresentationRouteType2["management"] = "management";
})(PresentationRouteType || (PresentationRouteType = {}));

// src/app/presentation/services/presentation.service.ts
var _PresentationManagementService = class _PresentationManagementService {
  constructor(presentationService, http, storageService, routeService) {
    this.presentationService = presentationService;
    this.http = http;
    this.storageService = storageService;
    this.routeService = routeService;
    this.routesInitialized = false;
  }
  initRoutes(initialRouteType = void 0, componentElm) {
    setTimeout(() => {
      if (componentElm != null) {
        const routes = {
          [PresentationRouteType.management]: new InternalRoute(PresentationRouteType.management)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : PresentationRouteType.management;
        this.routeService.init(routes, initialRoute, 250, componentElm);
        this.routesInitialized = true;
      }
    }, 0);
  }
  // #endregion
  // #region Content
  getAvailableCollections() {
    return this.presentationService.getAvailableCollections();
  }
  // #endregion
  // #region Personal Presentation
  getPresentationByName(userId, name) {
    return this.presentationService.getPresentationByName(userId, name);
  }
  storePresentation(presentation) {
    return this.presentationService.storePresentation(presentation);
  }
};
_PresentationManagementService.\u0275fac = function PresentationManagementService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationManagementService)(\u0275\u0275inject(PresentationService), \u0275\u0275inject(HttpClient), \u0275\u0275inject(StorageService), \u0275\u0275inject(InternalRouteService));
};
_PresentationManagementService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _PresentationManagementService, factory: _PresentationManagementService.\u0275fac, providedIn: "root" });
var PresentationManagementService = _PresentationManagementService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationManagementService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: PresentationService }, { type: HttpClient }, { type: StorageService }, { type: InternalRouteService }], null);
})();

// src/app/presentation/components/content-thumb/content-thumb.component.ts
var _c0 = ["componentElm"];
function ContentThumbComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "img", 3);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("src", ctx_r0.source, \u0275\u0275sanitizeUrl);
  }
}
var _ContentThumbComponent = class _ContentThumbComponent {
  constructor(apiService) {
    this.apiService = apiService;
    this.PresentationContentType = PresentationContentType;
  }
  initContent() {
    if (this.content != null) {
      if (this.content.thumb != null) {
        this.source = this.apiService.getContentUrl(this.content.thumb.fileName);
      } else {
        this.source = this.content.thumb_Url;
      }
    } else {
      this.source = void 0;
    }
  }
  init() {
    this.initContent();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_ContentThumbComponent.\u0275fac = function ContentThumbComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ContentThumbComponent)(\u0275\u0275directiveInject(ApiService));
};
_ContentThumbComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ContentThumbComponent, selectors: [["content-thumb"]], viewQuery: function ContentThumbComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { content: "content" }, standalone: false, decls: 8, vars: 2, consts: [[1, "content-thumb"], ["height", "3", "width", "4"], [1, "thumb"], ["draggable", "false", 3, "src"], [1, "meta"], [1, "name"]], template: function ContentThumbComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0);
    \u0275\u0275element(1, "canvas", 1);
    \u0275\u0275elementStart(2, "div", 2);
    \u0275\u0275conditionalCreate(3, ContentThumbComponent_Conditional_3_Template, 1, 1, "img", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "div", 4)(5, "div", 5)(6, "label");
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.source != null ? 3 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(ctx.content == null ? null : ctx.content.title);
  }
}, styles: ["\n\n.content-thumb[_ngcontent-%COMP%] {\n  position: relative;\n}\n.content-thumb[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.content-thumb[_ngcontent-%COMP%]    > .thumb[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.content-thumb[_ngcontent-%COMP%]    > .thumb[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n.content-thumb[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  position: absolute;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 0.5vw 1vw;\n}\n.content-thumb[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n/*# sourceMappingURL=content-thumb.component.css.map */"] });
var ContentThumbComponent = _ContentThumbComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ContentThumbComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "content-thumb", template: '<div class="content-thumb">\n  <canvas height="3" width="4"></canvas>\n  <div class="thumb">\n    @if (source != null) {\n      <img draggable="false" [src]="source" />\n    }\n  </div>\n  <div class="meta">\n    <div class="name">\n      <label>{{content?.title}}</label>\n    </div>\n  </div>\n</div>', styles: ["/* src/app/presentation/components/content-thumb/content-thumb.component.scss */\n.content-thumb {\n  position: relative;\n}\n.content-thumb > canvas {\n  width: 100%;\n}\n.content-thumb > .thumb {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.content-thumb > .thumb img {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n}\n.content-thumb > .meta {\n  position: absolute;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 0.5vw 1vw;\n}\n.content-thumb > .meta > .name > label {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n/*# sourceMappingURL=content-thumb.component.css.map */\n"] }]
  }], () => [{ type: ApiService }], { content: [{
    type: Input,
    args: ["content"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ContentThumbComponent, { className: "ContentThumbComponent" });
})();

// src/app/presentation/components/content-preview/content-preview.component.ts
var _c02 = ["componentElm"];
function ContentPreviewComponent_Conditional_0_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "img", 1);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("src", ctx_r0.source, \u0275\u0275sanitizeUrl);
  }
}
function ContentPreviewComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0);
    \u0275\u0275conditionalCreate(1, ContentPreviewComponent_Conditional_0_Conditional_1_Template, 1, 1, "img", 1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r0.contentToPreview.type == ctx_r0.PresentationContentType.Image ? 1 : -1);
  }
}
var _ContentPreviewComponent = class _ContentPreviewComponent {
  constructor(apiService) {
    this.apiService = apiService;
    this.PresentationContentType = PresentationContentType;
    this.content = new BehaviorSubject(void 0);
  }
  watchContent() {
    this.contentSubscription = this.content.subscribe({
      next: (content) => {
        this.contentToPreview = content;
        this.initContent();
      }
    });
  }
  initContent() {
    if (this.contentToPreview != null) {
      if (this.contentToPreview.source != null) {
        this.source = this.apiService.getContentUrl(this.contentToPreview.source.fileName);
      } else {
        this.source = this.contentToPreview.source_Url;
      }
    } else {
      this.source = void 0;
    }
  }
  init() {
    this.watchContent();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.contentSubscription?.unsubscribe();
  }
};
_ContentPreviewComponent.\u0275fac = function ContentPreviewComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ContentPreviewComponent)(\u0275\u0275directiveInject(ApiService));
};
_ContentPreviewComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ContentPreviewComponent, selectors: [["content-preview"]], viewQuery: function ContentPreviewComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { content: "content" }, standalone: false, decls: 1, vars: 1, consts: [[1, "content-preview"], [3, "src"]], template: function ContentPreviewComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, ContentPreviewComponent_Conditional_0_Template, 2, 1, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.contentToPreview != null ? 0 : -1);
  }
}, styles: ["\n\n.content-preview[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  text-align: center;\n}\n.content-preview[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n/*# sourceMappingURL=content-preview.component.css.map */"] });
var ContentPreviewComponent = _ContentPreviewComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ContentPreviewComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "content-preview", template: '@if (contentToPreview != null) {\n  <div class="content-preview">\n    @if (contentToPreview.type == PresentationContentType.Image) {\n      <img\n        [src]="source" />\n    }\n  </div>\n}', styles: ["/* src/app/presentation/components/content-preview/content-preview.component.scss */\n.content-preview {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  text-align: center;\n}\n.content-preview img {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n/*# sourceMappingURL=content-preview.component.css.map */\n"] }]
  }], () => [{ type: ApiService }], { content: [{
    type: Input,
    args: ["content"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ContentPreviewComponent, { className: "ContentPreviewComponent" });
})();

// src/app/presentation/components/preview/page/page.component.ts
var _c03 = ["componentElm"];
function PresentationPageComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1);
    \u0275\u0275element(2, "img", 2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275property("src", ctx_r0.contentSrc, \u0275\u0275sanitizeUrl);
  }
}
var _PresentationPageComponent = class _PresentationPageComponent {
  constructor(apiService, uiService, sanitizer) {
    this.apiService = apiService;
    this.uiService = uiService;
    this.sanitizer = sanitizer;
    this.PresentationContentType = PresentationContentType;
  }
  get content() {
    return this.page?.content;
  }
  initPage() {
    if (this.content != null) {
      switch (this.content.type) {
        case PresentationContentType.Image:
          {
            if (this.content.source != null) {
              this.contentSrc = this.apiService.getContentUrl(this.content.source.fileName);
            } else if (this.content.source_Url != null) {
              this.contentSrc = this.content.source_Url;
            }
          }
          break;
      }
    }
  }
  init() {
    this.initPage();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_PresentationPageComponent.\u0275fac = function PresentationPageComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationPageComponent)(\u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(DomSanitizer));
};
_PresentationPageComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PresentationPageComponent, selectors: [["page"]], viewQuery: function PresentationPageComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { page: "page" }, standalone: false, decls: 1, vars: 1, consts: [[1, "page"], [1, "image"], [3, "src"]], template: function PresentationPageComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, PresentationPageComponent_Conditional_0_Template, 3, 1, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.contentSrc != null ? 0 : -1);
  }
}, styles: ["\n\n.page[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.page[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n}\n.page[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n/*# sourceMappingURL=page.component.css.map */"] });
var PresentationPageComponent = _PresentationPageComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationPageComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "page", template: '@if (contentSrc != null) {\n  <div class="page">\n    <div class="image">\n      <img [src]="contentSrc" />\n    </div>\n  </div>\n}', styles: ["/* src/app/presentation/components/preview/page/page.component.scss */\n.page {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.page > .image {\n  height: 100%;\n  width: 100%;\n}\n.page > .image img {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n/*# sourceMappingURL=page.component.css.map */\n"] }]
  }], () => [{ type: ApiService }, { type: UiService }, { type: DomSanitizer }], { page: [{
    type: Input,
    args: ["page"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PresentationPageComponent, { className: "PresentationPageComponent" });
})();

// src/app/presentation/components/preview/preview.component.ts
var _c04 = ["componentElm"];
function PreviewPresentationComponent_For_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "page", 11);
  }
  if (rf & 2) {
    const page_r2 = ctx.$implicit;
    \u0275\u0275classProp("active", page_r2.active);
    \u0275\u0275property("page", page_r2);
  }
}
var _PreviewPresentationComponent = class _PreviewPresentationComponent {
  constructor(apiService) {
    this.apiService = apiService;
    this.activePageIndex = 0;
    this.forwardLabel = "Next Page";
    this.backLabel = "Previous Page";
    this.canGoBack = true;
    this.canGoForward = true;
  }
  get pages() {
    return this.presentation?.pageCollection?.pages ?? [];
  }
  get isFirstPage() {
    return this.activePageIndex == 0;
  }
  get isLastPage() {
    return this.activePageIndex == this.pages.length - 1;
  }
  setActivePage(page) {
    const index = this.pages.findIndex((x) => x.id == page.id);
    if (index != null) {
      this.pages.forEach((existingPage) => {
        if (existingPage.id != page.id) {
          existingPage.active = false;
        }
      });
      this.activePageIndex = index;
      page.active = true;
    }
    this.setCanGos();
  }
  initPresentation() {
    const activePage = this.pages[this.activePageIndex];
    if (activePage != null) {
      this.setActivePage(activePage);
    }
  }
  goPrev() {
    const prevPage = this.pages[this.activePageIndex - 1];
    if (prevPage != null) {
      this.setActivePage(prevPage);
    } else {
      this.canGoBack = false;
    }
    this.setCanGos();
  }
  goNext() {
    const nextPage = this.pages[this.activePageIndex + 1];
    if (nextPage != null) {
      this.setActivePage(nextPage);
    } else {
      this.canGoForward = false;
    }
    this.setCanGos();
  }
  setCanGos() {
    const prevPage = this.pages[this.activePageIndex - 1];
    const nextPage = this.pages[this.activePageIndex + 1];
    this.canGoBack = prevPage != null;
    this.canGoForward = nextPage != null;
  }
  init() {
    this.initPresentation();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_PreviewPresentationComponent.\u0275fac = function PreviewPresentationComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PreviewPresentationComponent)(\u0275\u0275directiveInject(ApiService));
};
_PreviewPresentationComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PreviewPresentationComponent, selectors: [["preview"]], viewQuery: function PreviewPresentationComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { presentation: "presentation" }, standalone: false, decls: 16, vars: 4, consts: [["componentElm", ""], ["id", "presentation"], [1, "pages"], [3, "page", "active"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], [3, "page"]], template: function PreviewPresentationComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "div", 2);
    \u0275\u0275repeaterCreate(3, PreviewPresentationComponent_For_4_Template, 1, 3, "page", 3, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "nav", 4)(6, "div", 5)(7, "div", 6)(8, "button", 7);
    \u0275\u0275listener("click", function PreviewPresentationComponent_Template_button_click_8_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goPrev());
    });
    \u0275\u0275element(9, "i", 8);
    \u0275\u0275elementStart(10, "label");
    \u0275\u0275text(11);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(12, "button", 9);
    \u0275\u0275listener("click", function PreviewPresentationComponent_Template_button_click_12_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goNext());
    });
    \u0275\u0275element(13, "i", 10);
    \u0275\u0275elementStart(14, "label");
    \u0275\u0275text(15);
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx.pages);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx.canGoBack);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.backLabel);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canGoForward);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.forwardLabel);
  }
}, dependencies: [PresentationPageComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-moz-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-o-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-moz-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-o-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-moz-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-o-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-moz-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-o-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n#presentation[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color3Alt5);\n  overflow: hidden;\n}\n#presentation[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: -100%;\n  left: -100%;\n  right: -100%;\n  bottom: -100%;\n  background-image: url(/assets/images/logo.svg);\n  background-position: center center;\n  background-size: 15vw 10vw;\n  opacity: 0.3;\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n  -webkit-filter: grayscale(100%);\n  -moz-filter: grayscale(100%);\n  -o-filter: grayscale(100%);\n  -ms-filter: grayscale(100%);\n  filter: grayscale(100%);\n}\n#presentation[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 0;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#presentation[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > page[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  background-color: var(--color1);\n  opacity: 0;\n  -moz-transition: opacity 0.3s linear;\n  -o-transition: opacity 0.3s linear;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear;\n}\n#presentation[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > page.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=preview.component.css.map */"] });
var PreviewPresentationComponent = _PreviewPresentationComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PreviewPresentationComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "preview", template: '<section id="presentation" #componentElm>\n  <div class="pages">\n    @for (page of pages; track page) {\n      <page\n        [page]="page"\n        [class.active]="page.active"\n      ></page>\n    }\n  </div>\n</section>\n\n<nav id="mainNav">\n  <div class="island">\n    <div class="controls">\n      <button class="control"\n        [disabled]="!canGoBack"\n        (click)="goPrev()">\n        <i class="fa-solid fa-arrow-left-long"></i>\n        <label>{{backLabel}}</label>\n      </button>\n      <button class="control success"\n        [disabled]="!canGoForward"\n        (click)="goNext()">\n        <i class="fa-solid fa-arrow-right-long"></i>\n        <label>{{forwardLabel}}</label>\n      </button>\n    </div>\n  </div>\n</nav>', styles: ["/* src/app/presentation/components/preview/preview.component.scss */\n@-webkit-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes contentLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-moz-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-o-keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@keyframes slideContentLoadIn {\n  0% {\n    -moz-transform: translateX(-25%);\n    -ms-transform: translateX(-25%);\n    -o-transform: translateX(-25%);\n    -webkit-transform: translateX(-25%);\n    transform: translateX(-25%);\n    opacity: 0;\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n    opacity: 1;\n  }\n}\n@-webkit-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes zoomContentLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-moz-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-o-keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@keyframes waterV {\n  0% {\n    -moz-transform: translatY(0);\n    -ms-transform: translatY(0);\n    -o-transform: translatY(0);\n    -webkit-transform: translatY(0);\n    transform: translatY(0);\n  }\n  100% {\n    -moz-transform: translateY(50%);\n    -ms-transform: translateY(50%);\n    -o-transform: translateY(50%);\n    -webkit-transform: translateY(50%);\n    transform: translateY(50%);\n  }\n}\n@-webkit-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-moz-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-o-keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@keyframes waterH {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(50%);\n    -ms-transform: translateX(50%);\n    -o-transform: translateX(50%);\n    -webkit-transform: translateX(50%);\n    transform: translateX(50%);\n  }\n}\n@-webkit-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-moz-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-o-keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@keyframes waterHR {\n  0% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n  100% {\n    -moz-transform: translateX(-50%);\n    -ms-transform: translateX(-50%);\n    -o-transform: translateX(-50%);\n    -webkit-transform: translateX(-50%);\n    transform: translateX(-50%);\n  }\n}\n@-webkit-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes elaborationLoadIn {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes cardLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n#presentation {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color3Alt5);\n  overflow: hidden;\n}\n#presentation > .bg {\n  position: absolute;\n  top: -100%;\n  left: -100%;\n  right: -100%;\n  bottom: -100%;\n  background-image: url(/assets/images/logo.svg);\n  background-position: center center;\n  background-size: 15vw 10vw;\n  opacity: 0.3;\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n  -webkit-filter: grayscale(100%);\n  -moz-filter: grayscale(100%);\n  -o-filter: grayscale(100%);\n  -ms-filter: grayscale(100%);\n  filter: grayscale(100%);\n}\n#presentation > .pages {\n  position: absolute;\n  z-index: 0;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#presentation > .pages > page {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  background-color: var(--color1);\n  opacity: 0;\n  -moz-transition: opacity 0.3s linear;\n  -o-transition: opacity 0.3s linear;\n  -webkit-transition: opacity 0.3s linear;\n  transition: opacity 0.3s linear;\n}\n#presentation > .pages > page.active {\n  opacity: 1;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=preview.component.css.map */\n"] }]
  }], () => [{ type: ApiService }], { presentation: [{
    type: Input,
    args: ["presentation"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PreviewPresentationComponent, { className: "PreviewPresentationComponent" });
})();

// src/app/presentation/components/management/management.component.ts
var _c05 = ["personalizedElm"];
var _c1 = ["componentElm"];
var _c2 = ["pageElm"];
var _c3 = ["additionElm"];
var _c4 = ["contentItemElm"];
function ManagementComponent_For_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 12);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const collection_r2 = ctx.$implicit;
    \u0275\u0275property("ngValue", collection_r2.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(collection_r2.name);
  }
}
function ManagementComponent_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13)(1, "p");
    \u0275\u0275text(2, "No presentation content.");
    \u0275\u0275elementEnd()();
  }
}
function ManagementComponent_For_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14, 2);
    \u0275\u0275element(2, "content-thumb", 25);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const contentItem_r3 = ctx.$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("content", contentItem_r3);
  }
}
function ManagementComponent_Conditional_26_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "div", 29, 3);
    \u0275\u0275element(3, "canvas", 30);
    \u0275\u0275elementStart(4, "div", 31)(5, "div", 32);
    \u0275\u0275element(6, "i", 33);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "label");
    \u0275\u0275text(8, "Drop Slide Here");
    \u0275\u0275elementEnd()()()();
  }
}
function ManagementComponent_For_28_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 31);
    \u0275\u0275element(1, "canvas", 30)(2, "content-thumb", 25);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const page_r5 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("content", page_r5.content);
  }
}
function ManagementComponent_For_28_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 19, 4)(2, "div", 34);
    \u0275\u0275conditionalCreate(3, ManagementComponent_For_28_Conditional_3_Template, 3, 1, "div", 31);
    \u0275\u0275elementStart(4, "div", 35)(5, "div", 36)(6, "label");
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "button", 22);
    \u0275\u0275listener("click", function ManagementComponent_For_28_Template_button_click_8_listener() {
      const ctx_r5 = \u0275\u0275restoreView(_r4);
      const page_r5 = ctx_r5.$implicit;
      const \u0275$index_68_r7 = ctx_r5.$index;
      const ctx_r7 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r7.deletePage(page_r5, \u0275$index_68_r7));
    });
    \u0275\u0275element(9, "i", 37);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const page_r5 = ctx.$implicit;
    \u0275\u0275classProp("new", page_r5.new);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(page_r5.content != null ? 3 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(page_r5.content == null ? null : page_r5.content.title);
  }
}
function ManagementComponent_Conditional_29_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 19)(1, "div", 29, 3);
    \u0275\u0275element(3, "canvas", 30);
    \u0275\u0275elementStart(4, "div", 31)(5, "div", 32);
    \u0275\u0275element(6, "i", 33);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "label");
    \u0275\u0275text(8, "Drop Slide Here");
    \u0275\u0275elementEnd()()()();
  }
}
function ManagementComponent_Conditional_36_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "content-preview", 25);
  }
  if (rf & 2) {
    const ctx_r7 = \u0275\u0275nextContext();
    \u0275\u0275property("content", ctx_r7.contentToPreview);
  }
}
function ManagementComponent_Conditional_43_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "preview", 27);
  }
  if (rf & 2) {
    const ctx_r7 = \u0275\u0275nextContext();
    \u0275\u0275property("presentation", ctx_r7.presentation);
  }
}
function ManagementComponent_Conditional_44_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 38);
    \u0275\u0275element(1, "loader", 39);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r7 = \u0275\u0275nextContext();
    \u0275\u0275classProp("closing", ctx_r7.closingLoader);
    \u0275\u0275advance();
    \u0275\u0275property("fill", true);
  }
}
gsapWithCSS.registerPlugin(Draggable);
var _ManagementComponent = class _ManagementComponent {
  constructor(presentationManagementService, authRefService, uiService) {
    this.presentationManagementService = presentationManagementService;
    this.authRefService = authRefService;
    this.uiService = uiService;
    this.user = null;
    this.previewingContent = false;
    this.contentToPreview = new BehaviorSubject(void 0);
    this.pageElms = new QueryList();
    this.additionsElms = new QueryList();
    this.draggableElms = new QueryList();
    this.dragStartX = 0;
    this.dragStartY = 0;
    this.dragWidth = 0;
    this.dragHeight = 0;
    this.dragTop = 0;
    this.dragLeft = 0;
    this.initialDeltaX = 0;
    this.initialDeltaY = 0;
    this.retrievingPresentation$ = new BehaviorSubject(true);
    this.pages = [];
    this.PresentationContentType = PresentationContentType;
    this.collections = [];
    this.availableContent = [];
    this.visibleContent = [];
    this.retrievingContent$ = new BehaviorSubject(true);
    this.searchInput = "";
    this.previewingPresentation = false;
    this.savingPresentation$ = new BehaviorSubject(false);
    this.closingLoader = false;
    this.showLoader = true;
  }
  // #region UI
  get isMobileDevice() {
    return this.uiService.isMobileDevice;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.user = user;
        if (user != null) {
          this.getPersonalPresentation();
        }
      }
    });
  }
  previewContent(content) {
    this.contentToPreview.next(content);
    this.previewingContent = true;
  }
  stopPreviewingContent() {
    window.clearTimeout(this.previewTimer);
    this.previewingContent = false;
    this.previewTimer = window.setTimeout(() => {
      this.contentToPreview.next(void 0);
    }, 250);
  }
  get dragWidthStyle() {
    return `${this.dragWidth}px`;
  }
  initDraggables() {
    setTimeout(() => {
      const personalizedElm = this.personalizedElm?.nativeElement;
      if (personalizedElm != null) {
        for (var i = 0, len = this.draggableElms.length; i < len; i++) {
          const draggableElm = this.draggableElms.get(i)?.nativeElement;
          const content = this.availableContent[i];
          if (draggableElm != null && content != null) {
            this.initDraggable(content, draggableElm, personalizedElm);
          }
        }
      }
    }, 0);
  }
  dropContent(content, i) {
    this.insertPageAfter(content, i);
  }
  initDraggable(content, elm, personalizedElm) {
    this.dragWidth = elm.offsetWidth;
    this.dragHeight = elm.offsetHeight;
    let hitElm;
    let hitIndex;
    let dragging = false;
    const draggable = Draggable.create(elm, {
      type: "x,y",
      trigger: elm,
      minimumMovement: 3,
      allowEventDefault: true,
      zIndexBoost: false,
      onPress: (e) => {
        this.initialDeltaX = 0;
        this.initialDeltaY = 0;
        const bounds = elm.getBoundingClientRect();
        this.dragTop = bounds.top;
        this.dragLeft = bounds.left;
        this.dragStartX = bounds.left;
        this.dragStartY = bounds.top;
      },
      onRelease: () => {
        if (!dragging) {
          this.previewContent(content);
        }
        dragging = false;
      },
      onDrag: (e) => {
        dragging = true;
        let hitDetect = false;
        elm.classList.add("dragging");
        if (draggable.hitTest(personalizedElm)) {
          personalizedElm.classList.add("hovering");
          elm.classList.add("hovering");
        } else {
          personalizedElm.classList.remove("hovering");
          elm.classList.remove("hovering");
        }
        for (var i = 0, len = this.pageElms.length; i < len; i++) {
          const pageElm = this.pageElms.get(i)?.nativeElement;
          if (pageElm != null) {
            if (draggable.hitTest(pageElm)) {
              elm.classList.add("dropping");
              hitDetect = true;
              const rect = pageElm.getBoundingClientRect();
              const pointerX = draggable.pointerX;
              const midPoint = rect.left + rect.width / 2;
              if (pointerX > midPoint) {
                hitIndex = i + 1;
                hitElm = pageElm;
                pageElm.classList.remove("hovering-left");
                pageElm.classList.add("hovering-right");
              } else {
                if (i == 0) {
                  hitIndex = i;
                  pageElm.classList.add("hovering-left");
                }
                pageElm.classList.remove("hovering-right");
              }
            } else {
              pageElm.classList.remove("hovering-left");
              pageElm.classList.remove("hovering-right");
            }
          }
        }
        for (var i = 0, len = this.additionsElms.length; i < len; i++) {
          const additionElm = this.additionsElms.get(i)?.nativeElement;
          if (additionElm != null) {
            if (draggable.hitTest(additionElm)) {
              additionElm.classList.add("hovering");
              elm.classList.add("dropping");
              hitDetect = true;
              if (this.hasPages) {
                hitIndex = this.pages.length;
              } else {
                hitIndex = i;
              }
              hitElm = additionElm;
              break;
            } else {
              additionElm.classList.remove("hovering");
            }
          }
        }
        if (!hitDetect) {
          hitIndex = void 0;
          hitElm?.classList.remove("hovering");
          hitElm?.classList.remove("hovering-left");
          hitElm?.classList.remove("hovering-right");
          hitElm = void 0;
          elm.classList.remove("dropping");
        }
      },
      onDragEnd: () => {
        dragging = false;
        gsapWithCSS.to(elm, { x: 0, y: 0, duration: 0.1 });
        elm.classList.remove("dragging");
        elm.classList.remove("dropping");
        personalizedElm.classList.remove("hovering");
        for (var i = 0, len = this.pageElms.length; i < len; i++) {
          const pageElm = this.pageElms.get(i)?.nativeElement;
          if (pageElm != null) {
            pageElm.classList.remove("hovering-left");
            pageElm.classList.remove("hovering-right");
          }
        }
        for (var i = 0, len = this.additionsElms.length; i < len; i++) {
          const additionElm = this.additionsElms.get(i)?.nativeElement;
          if (additionElm != null) {
            additionElm.classList.remove("hovering");
          }
        }
        if (hitIndex != null) {
          this.insertPageAfter(content, hitIndex);
        }
      }
    })[0];
  }
  dragPreview(content) {
  }
  get hasPages() {
    return this.pages.length > 0;
  }
  initPages(pages) {
    pages = pages.sort((a, b) => a.number - b.number);
    this.pages.push(...pages);
  }
  getPersonalPresentation() {
    if (this.user != null) {
      const user = this.user;
      this.retrievingPresentation$.next(true);
      this.presentationManagementService.getPresentationByName(this.user.id, "Default").subscribe({
        next: (presentation) => {
          this.presentation = presentation ?? new PersonalPresentation("Default", user.id);
          if (presentation?.pageCollection != null) {
            this.initPages(presentation.pageCollection.pages);
          }
          this.retrievingPresentation$.next(false);
        },
        error: () => {
          this.presentation = new PersonalPresentation("Default", user.id);
          this.retrievingPresentation$.next(false);
        }
      });
    }
  }
  initPresentationPages() {
  }
  sortPages() {
    for (var i = 0, len = this.pages.length; i < len; i++) {
      const page = this.pages[i];
      page.number = i + 1;
    }
  }
  selectPage(page) {
    this.insertingPageAfter = void 0;
    if (page.selected) {
      page.selected = false;
      this.selectedPage = void 0;
    } else {
      page.selected = true;
      this.selectedPage = page;
    }
  }
  deletePage(page, i) {
    this.uiService.prompt("Delete Slide?", "Are you sure you want to remove this slide?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.removePage(i);
        }
      }
    });
  }
  removePage(i) {
    this.pages.splice(i, 1);
    this.save();
  }
  insertPageAfter(content, pageIndex) {
    let canInsertPage = true;
    for (var i = 0, len = this.pages.length; i < len; i++) {
      const page = this.pages[i];
      if (page.content?.id == content.id) {
        canInsertPage = false;
      }
    }
    if (canInsertPage) {
      const newPage = new PresentationPage(content, pageIndex + 1);
      this.pages.splice(pageIndex, 0, newPage);
      this.sortPages();
      this.save();
    } else {
      this.uiService.prompt("Slide already exists", "This slide already exists in your presentation.", "Okay").subscribe({
        next: () => {
        }
      });
    }
  }
  get activeCollection() {
    return this.collections.find((x) => x.id == this.activeCollectionId);
  }
  get hasContent() {
    return this.visibleContent.length > 0;
  }
  setActiveCollection(i) {
    const collection = this.collections[i];
    if (collection != null) {
      this.activeCollectionId = collection.id;
      this.availableContent = collection.content;
      this.filterContent();
    }
  }
  getAvailableCollections() {
    this.retrievingContent$.next(true);
    this.presentationManagementService.getAvailableCollections().subscribe({
      next: (collections) => {
        this.collections = collections;
        this.setActiveCollection(0);
        this.retrievingContent$.next(false);
      },
      error: () => {
        this.retrievingContent$.next(false);
      }
    });
  }
  filterContent() {
    const visibleContent = [];
    const searchInput = this.searchInput.toLocaleLowerCase();
    this.availableContent.forEach((content) => {
      let matched = false;
      if (searchInput.length <= 0) {
        matched = true;
      } else {
        const title = content.title.toLocaleLowerCase();
        if (title.includes(searchInput)) {
          matched = true;
        }
      }
      if (matched) {
        visibleContent.push(content);
      }
    });
    this.visibleContent = visibleContent;
    this.initDraggables();
  }
  get canPreviewPresentation() {
    return this.presentation != null && this.presentation.pageCollection != null && this.presentation.pageCollection.pages.length > 0;
  }
  previewPresentation() {
    this.previewingPresentation = true;
  }
  stopPreviewingPresentation() {
    window.clearTimeout(this.previewPresentationTimer);
    this.previewingPresentation = false;
    this.previewPresentationTimer = window.setTimeout(() => {
      this.contentToPreview.next(void 0);
    }, 250);
  }
  get canSave() {
    return this.presentation != null && this.pages.length > 0;
  }
  save() {
    if (this.canSave) {
      window.clearTimeout(this.saveDebounce);
      this.saveDebounce = window.setTimeout(() => {
        if (this.presentation != null) {
          this.savingPresentation$.next(true);
          this.presentation.pageCollection = {
            pages: this.pages
          };
          this.presentationManagementService.storePresentation(this.presentation).subscribe({
            next: (response) => {
              this.savingPresentation$.next(false);
            },
            error: (response) => {
              this.savingPresentation$.next(false);
            }
          });
        }
      }, 250);
    }
  }
  closeLoader() {
    window.clearTimeout(this.loaderCloseTimer);
    const retrievingPresentation = this.retrievingPresentation$.getValue();
    const savingPresentation = this.savingPresentation$.getValue();
    const retrievingContent = this.retrievingContent$.getValue();
    if (!retrievingPresentation && !savingPresentation && !retrievingContent) {
      this.closingLoader = true;
      setTimeout(() => {
        this.showLoader = false;
      }, 1500);
    }
  }
  watchLoader() {
    this.loaderContentSubscription = this.retrievingContent$.subscribe({
      next: (retrieving) => {
        if (!retrieving) {
          this.closeLoader();
        } else {
          this.showLoader = true;
          this.closingLoader = false;
        }
      }
    });
    this.loaderPresentationSubscription = this.retrievingPresentation$.subscribe({
      next: (retrieving) => {
        if (!retrieving) {
          this.closeLoader();
        } else {
          this.showLoader = true;
          this.closingLoader = false;
        }
      }
    });
    this.loaderSavingSubscription = this.savingPresentation$.subscribe({
      next: (saving) => {
        if (!saving) {
          this.closeLoader();
        } else {
          this.showLoader = true;
          this.closingLoader = false;
        }
      }
    });
  }
  init() {
    this.watchUser();
    this.getAvailableCollections();
    this.watchLoader();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
    this.loaderContentSubscription?.unsubscribe();
    this.loaderSavingSubscription?.unsubscribe();
    this.loaderPresentationSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_ManagementComponent.\u0275fac = function ManagementComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ManagementComponent)(\u0275\u0275directiveInject(PresentationManagementService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(UiService));
};
_ManagementComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ManagementComponent, selectors: [["management"]], viewQuery: function ManagementComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c05, 5);
    \u0275\u0275viewQuery(_c1, 5);
    \u0275\u0275viewQuery(_c2, 5);
    \u0275\u0275viewQuery(_c3, 5);
    \u0275\u0275viewQuery(_c4, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.personalizedElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.pageElms = _t);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.additionsElms = _t);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.draggableElms = _t);
  }
}, inputs: { route: "route" }, standalone: false, decls: 45, vars: 15, consts: [["availableContentElm", ""], ["personalizedElm", ""], ["contentItemElm", ""], ["additionElm", ""], ["pageElm", ""], ["id", "presentationManagement"], [1, "search"], [1, "input"], ["type", "text", "placeholder", "Search content...", 3, "ngModelChange", "input", "ngModel"], [1, "sorting"], [1, "control"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [1, "message"], [1, "content-item"], [1, "personalized"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "pages"], [1, "page"], [1, "page", 3, "new"], ["id", "contentPreview"], [1, "control", 3, "click"], [1, "fa-solid", "fa-close"], [1, "preview"], [3, "content"], ["id", "presentationPreview"], [3, "presentation"], ["id", "loader", 3, "closing"], [1, "addition"], ["height", "3", "width", "4"], [1, "content"], [1, "icon"], [1, "fa-light", "fa-circle-plus"], [1, "page-content"], [1, "meta"], [1, "name"], [1, "fa-solid", "fa-trash-can"], ["id", "loader"], [1, "active", 3, "fill"]], template: function ManagementComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 5, 0)(2, "header")(3, "div", 6)(4, "div", 7)(5, "input", 8);
    \u0275\u0275twoWayListener("ngModelChange", function ManagementComponent_Template_input_ngModelChange_5_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.searchInput, $event) || (ctx.searchInput = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("input", function ManagementComponent_Template_input_input_5_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.filterContent());
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(6, "div", 9)(7, "div", 10)(8, "label");
    \u0275\u0275text(9, "Collection");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "div", 7)(11, "select", 11);
    \u0275\u0275twoWayListener("ngModelChange", function ManagementComponent_Template_select_ngModelChange_11_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.activeCollectionId, $event) || (ctx.activeCollectionId = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("change", function ManagementComponent_Template_select_change_11_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.filterContent());
    });
    \u0275\u0275repeaterCreate(12, ManagementComponent_For_13_Template, 2, 2, "option", 12, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275conditionalCreate(14, ManagementComponent_Conditional_14_Template, 3, 0, "div", 13);
    \u0275\u0275repeaterCreate(15, ManagementComponent_For_16_Template, 3, 1, "div", 14, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementStart(17, "div", 15, 1)(19, "header");
    \u0275\u0275element(20, "h2");
    \u0275\u0275elementStart(21, "div", 16)(22, "button", 17);
    \u0275\u0275listener("click", function ManagementComponent_Template_button_click_22_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.previewPresentation());
    });
    \u0275\u0275elementStart(23, "label");
    \u0275\u0275text(24, "Preview Your Presentation");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(25, "div", 18);
    \u0275\u0275conditionalCreate(26, ManagementComponent_Conditional_26_Template, 9, 0, "div", 19);
    \u0275\u0275repeaterCreate(27, ManagementComponent_For_28_Template, 10, 4, "div", 20, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275conditionalCreate(29, ManagementComponent_Conditional_29_Template, 9, 0, "div", 19);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(30, "aside", 21)(31, "header")(32, "div", 16)(33, "button", 22);
    \u0275\u0275listener("click", function ManagementComponent_Template_button_click_33_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.stopPreviewingContent());
    });
    \u0275\u0275element(34, "i", 23);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(35, "div", 24);
    \u0275\u0275conditionalCreate(36, ManagementComponent_Conditional_36_Template, 1, 1, "content-preview", 25);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(37, "aside", 26)(38, "header")(39, "div", 16)(40, "button", 22);
    \u0275\u0275listener("click", function ManagementComponent_Template_button_click_40_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.stopPreviewingPresentation());
    });
    \u0275\u0275element(41, "i", 23);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(42, "div", 24);
    \u0275\u0275conditionalCreate(43, ManagementComponent_Conditional_43_Template, 1, 1, "preview", 27);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(44, ManagementComponent_Conditional_44_Template, 2, 3, "aside", 28);
  }
  if (rf & 2) {
    \u0275\u0275classProp("no-content", !ctx.hasContent);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.searchInput);
    \u0275\u0275advance(6);
    \u0275\u0275twoWayProperty("ngModel", ctx.activeCollectionId);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.collections);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.hasContent ? 14 : -1);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.visibleContent);
    \u0275\u0275advance(7);
    \u0275\u0275property("disabled", !ctx.canPreviewPresentation);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(!ctx.hasPages ? 26 : -1);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.pages);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.hasPages ? 29 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.previewingContent);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx.contentToPreview != null ? 36 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.previewingPresentation);
    \u0275\u0275advance(6);
    \u0275\u0275conditional(ctx.previewingPresentation ? 43 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showLoader ? 44 : -1);
  }
}, dependencies: [LoaderComponent, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, NgModel, ContentThumbComponent, ContentPreviewComponent, PreviewPresentationComponent], styles: ['\n\n@-webkit-keyframes _ngcontent-%COMP%_pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n#presentationManagement[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: calc(6vw + var(--systemOffset-top)) 0 50vh 0;\n  overflow-x: hidden;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto 2vw;\n  z-index: 2;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]:before {\n  content: "";\n  position: absolute;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 100%;\n  height: calc(6vw + var(--systemOffset-top));\n  pointer-events: none;\n  z-index: 0;\n  background-color: var(--color2Alt1) 0%;\n  background-image:\n    linear-gradient(\n      to bottom,\n      var(--color2Alt1) 0%,\n      rgba(var(--color2Alt1-raw), 0.9) 100%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%] {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%] {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#presentationManagement[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 4vw;\n  top: calc(20vh + var(--systemOffset-top));\n  position: fixed;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n#presentationManagement.no-content[_ngcontent-%COMP%] {\n  overflow: hidden;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 0;\n  display: inline-block;\n  vertical-align: top;\n  width: calc(20% - 2.4vw - 2vw);\n  margin-top: 3vw;\n  margin-left: 3vw;\n  cursor: pointer;\n  -moz-transition: filter 0.1s linear;\n  -o-transition: filter 0.1s linear;\n  -webkit-transition: filter 0.1s linear;\n  transition: filter 0.1s linear;\n  -webkit-filter: brightness(100%);\n  -moz-filter: brightness(100%);\n  -o-filter: brightness(100%);\n  -ms-filter: brightness(100%);\n  filter: brightness(100%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  display: block;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  -moz-transition: transform 0.1s linear;\n  -o-transition: transform 0.1s linear;\n  -webkit-transition: transform 0.1s linear;\n  transition: transform 0.1s linear;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]:nth-of-type(5n+1) {\n  margin-left: 5vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]:nth-of-type(5n) {\n  margin-right: 5vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item[_ngcontent-%COMP%]:nth-of-type(-n+5) {\n  margin-top: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item.dragging[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  -moz-transform: scale(1.2);\n  -ms-transform: scale(1.2);\n  -o-transform: scale(1.2);\n  -webkit-transform: scale(1.2);\n  transform: scale(1.2);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item.dragging[_ngcontent-%COMP%] {\n  z-index: 1;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item.hovering[_ngcontent-%COMP%] {\n  -webkit-filter: brightness(90%);\n  -moz-filter: brightness(90%);\n  -o-filter: brightness(90%);\n  -ms-filter: brightness(90%);\n  filter: brightness(90%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item.dropping[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .content-item.dropping[_ngcontent-%COMP%] {\n  -webkit-filter: brightness(50%);\n  -moz-filter: brightness(50%);\n  -o-filter: brightness(50%);\n  -ms-filter: brightness(50%);\n  filter: brightness(50%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%] {\n  position: fixed;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0.5vw 2vw 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  border-radius: 999px;\n  background-color: var(--color2);\n  padding: 0.5vw 1vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 1vw;\n  overflow-y: hidden;\n  overflow-x: scroll;\n  font-size: 0;\n  white-space: nowrap;\n  background-color: var(--color2);\n  border-top: 0.2vw var(--color1) solid;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  height: 100%;\n  margin-left: 1vw;\n  white-space: nowrap;\n  font-size: 0;\n  position: relative;\n  -moz-transition: transform 0.2s linear;\n  -o-transition: transform 0.2s linear;\n  -webkit-transition: transform 0.2s linear;\n  transition: transform 0.2s linear;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  width: 16vw;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n  margin-left: 2vw;\n  margin-right: 2vw;\n  position: relative;\n  z-index: 0;\n  -moz-animation-name: pageLoadIn;\n  -ms-animation-name: pageLoadIn;\n  -o-animation-name: pageLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_pageLoadIn;\n  animation-name: _ngcontent-%COMP%_pageLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: 0.3s;\n  -ms-animation-duration: 0.3s;\n  -o-animation-duration: 0.3s;\n  -webkit-animation-duration: 0.3s;\n  animation-duration: 0.3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > content-thumb[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  position: absolute;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 0.5vw 1vw;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--error);\n  border: 0.2vw var(--color1) solid;\n  overflow: hidden;\n  border-radius: 100%;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]    > .page-content[_ngcontent-%COMP%]    + .addition[_ngcontent-%COMP%] {\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-animation-name: pageLoadIn;\n  -ms-animation-name: pageLoadIn;\n  -o-animation-name: pageLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_pageLoadIn;\n  animation-name: _ngcontent-%COMP%_pageLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: 0.3s;\n  -ms-animation-duration: 0.3s;\n  -o-animation-duration: 0.3s;\n  -webkit-animation-duration: 0.3s;\n  animation-duration: 0.3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.15s;\n  -ms-animation-delay: 0.15s;\n  -o-animation-delay: 0.15s;\n  -webkit-animation-delay: 0.15s;\n  animation-delay: 0.15s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n  width: 16vw;\n  position: relative;\n  cursor: pointer;\n  border: 0.2vw var(--color1Alt2) dashed;\n  border-radius: 1vw;\n  background-color: transparent;\n  -moz-transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n  -o-transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n  -webkit-transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n  transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  width: 100%;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  text-align: center;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 4vw;\n  color: var(--color1Alt4);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  text-align: center;\n  display: block;\n  margin-top: 0.5vw;\n  font-size: 1.4vw;\n  color: var(--color1Alt4);\n  font-weight: var(--ltweight);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition.hovering[_ngcontent-%COMP%] {\n  border-color: var(--success);\n  background-color: rgba(var(--success-raw), 0.1);\n  border-style: solid;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition.hovering[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--success);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]   .addition.hovering[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--success);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page.hovering-left[_ngcontent-%COMP%] {\n  -moz-transform: translateX(10%);\n  -ms-transform: translateX(10%);\n  -o-transform: translateX(10%);\n  -webkit-transform: translateX(10%);\n  transform: translateX(10%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page.hovering-right[_ngcontent-%COMP%] {\n  -moz-transform: translateX(-10%);\n  -ms-transform: translateX(-10%);\n  -o-transform: translateX(-10%);\n  -webkit-transform: translateX(-10%);\n  transform: translateX(-10%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page.hovering-right[_ngcontent-%COMP%]    + .page[_ngcontent-%COMP%] {\n  -moz-transform: translateX(10%);\n  -ms-transform: translateX(10%);\n  -o-transform: translateX(10%);\n  -webkit-transform: translateX(10%);\n  transform: translateX(10%);\n}\n#presentationManagement[_ngcontent-%COMP%]    > .personalized[_ngcontent-%COMP%]    > .pages[_ngcontent-%COMP%]    > .page.new[_ngcontent-%COMP%]    ~ .page[_ngcontent-%COMP%] {\n  -moz-animation-name: pageMoveOver;\n  -ms-animation-name: pageMoveOver;\n  -o-animation-name: pageMoveOver;\n  -webkit-animation-name: _ngcontent-%COMP%_pageMoveOver;\n  animation-name: _ngcontent-%COMP%_pageMoveOver;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: 0.3s;\n  -ms-animation-duration: 0.3s;\n  -o-animation-duration: 0.3s;\n  -webkit-animation-duration: 0.3s;\n  animation-duration: 0.3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#contentPreview[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n  z-index: 10;\n  opacity: 0;\n  -moz-transform: scale(0.5);\n  -ms-transform: scale(0.5);\n  -o-transform: scale(0.5);\n  -webkit-transform: scale(0.5);\n  transform: scale(0.5);\n  pointer-events: none;\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  -moz-transform-origin: center center;\n  -ms-transform-origin: center center;\n  -o-transform-origin: center center;\n  -webkit-transform-origin: center center;\n  transform-origin: center center;\n  background-color: var(--color1Alt4);\n  border: 1vw var(--color1) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#contentPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  z-index: 1;\n}\n#contentPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#contentPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--color1);\n  border: 0.2vw var(--color1Alt3) solid;\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#contentPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#contentPreview[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  text-align: center;\n  position: relative;\n  z-index: 0;\n}\n#contentPreview[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]   content-preview[_ngcontent-%COMP%] {\n  display: block;\n}\n#contentPreview.active[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n#presentationPreview[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n  z-index: 10;\n  opacity: 0;\n  -moz-transform: scale(0.5);\n  -ms-transform: scale(0.5);\n  -o-transform: scale(0.5);\n  -webkit-transform: scale(0.5);\n  transform: scale(0.5);\n  pointer-events: none;\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  -moz-transform-origin: center center;\n  -ms-transform-origin: center center;\n  -o-transform-origin: center center;\n  -webkit-transform-origin: center center;\n  transform-origin: center center;\n  background-color: var(--color1Alt4);\n  border: 1vw var(--color1) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#presentationPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  z-index: 1;\n}\n#presentationPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#presentationPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--color1);\n  border: 0.2vw var(--color1Alt3) solid;\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#presentationPreview[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#presentationPreview[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  text-align: center;\n  position: relative;\n  z-index: 0;\n}\n#presentationPreview[_ngcontent-%COMP%]    > .preview[_ngcontent-%COMP%]   content-preview[_ngcontent-%COMP%] {\n  display: block;\n}\n#presentationPreview.active[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n@-webkit-keyframes _ngcontent-%COMP%_loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#loader[_ngcontent-%COMP%] {\n  position: fixed;\n  z-index: 20;\n  right: 1vw;\n  bottom: 1vw;\n  pointer-events: none;\n  opacity: 0;\n  -moz-animation-name: loadIn;\n  -ms-animation-name: loadIn;\n  -o-animation-name: loadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_loadIn;\n  animation-name: _ngcontent-%COMP%_loadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  width: 5vw;\n  height: 5vw;\n  --fillSpeed: 1s;\n}\n#loader.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: loadOut;\n  -ms-animation-name: loadOut;\n  -o-animation-name: loadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_loadOut;\n  animation-name: _ngcontent-%COMP%_loadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 1s;\n  -ms-animation-duration: 1s;\n  -o-animation-duration: 1s;\n  -webkit-animation-duration: 1s;\n  animation-duration: 1s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=management.component.css.map */'] });
var ManagementComponent = _ManagementComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ManagementComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "management", template: '<section id="presentationManagement"\n  #availableContentElm\n  [class.no-content]="!hasContent">\n  <header>\n    <div class="search">\n      <div class="input">\n        <input type="text"\n          [(ngModel)]="searchInput"\n          (input)="filterContent()"\n          placeholder="Search content..." />\n      </div>\n    </div>\n    <div class="sorting">\n      <div class="control">\n        <label>Collection</label>\n        <div class="input">\n          <select [(ngModel)]="activeCollectionId" (change)="filterContent()">\n            @for (collection of collections; track collection) {\n              <option [ngValue]="collection.id">{{collection.name}}</option>\n            }\n          </select>\n        </div>\n      </div>\n    </div>\n  </header>\n  @if (!hasContent) {\n    <div class="message">\n      <p>No presentation content.</p>\n    </div>\n  }\n  @for (contentItem of visibleContent; track contentItem) {\n    <div class="content-item"\n      #contentItemElm\n      >\n      <content-thumb [content]="contentItem"></content-thumb>\n    </div>\n  }\n  <div class="personalized"\n    #personalizedElm>\n    <header>\n      <h2>\n      </h2>\n      <div class="controls">\n        <button class="control"\n          [disabled]="!canPreviewPresentation"\n          (click)="previewPresentation()">\n          <label>Preview Your Presentation</label>\n        </button>\n      </div>\n    </header>\n    <div class="pages">\n      @if (!hasPages) {\n        <div class="page">\n          <div class="addition" #additionElm>\n            <canvas height="3" width="4"></canvas>\n            <div class="content">\n              <div class="icon">\n                <i class="fa-light fa-circle-plus"></i>\n              </div>\n              <label>Drop Slide Here</label>\n            </div>\n          </div>\n        </div>\n      }\n      @for (page of pages; track page; let i = $index) {\n        <div class="page"\n          [class.new]="page.new"\n          #pageElm\n          >\n          <div class="page-content">\n            @if (page.content != null) {\n              <div class="content">\n                <canvas height="3" width="4"></canvas>\n                <content-thumb [content]="page.content"></content-thumb>\n              </div>\n            }\n            <div class="meta">\n              <div class="name">\n                <label>{{page.content?.title}}</label>\n              </div>\n            </div>\n            <button class="control" (click)="deletePage(page,i)">\n              <i class="fa-solid fa-trash-can"></i>\n            </button>\n          </div>\n        </div>\n      }\n      @if (hasPages) {\n        <div class="page">\n          <div class="addition" #additionElm>\n            <canvas height="3" width="4"></canvas>\n            <div class="content">\n              <div class="icon">\n                <i class="fa-light fa-circle-plus"></i>\n              </div>\n              <label>Drop Slide Here</label>\n            </div>\n          </div>\n        </div>\n      }\n    </div>\n  </div>\n</section>\n\n<aside id="contentPreview" [class.active]="previewingContent">\n  <header>\n    <div class="controls">\n      <button class="control"\n        (click)="stopPreviewingContent()">\n        <i class="fa-solid fa-close"></i>\n      </button>\n    </div>\n  </header>\n  <div class="preview">\n    @if (contentToPreview != null) {\n      <content-preview\n      [content]="contentToPreview"></content-preview>\n    }\n  </div>\n</aside>\n\n<aside id="presentationPreview" [class.active]="previewingPresentation">\n  <header>\n    <div class="controls">\n      <button class="control"\n        (click)="stopPreviewingPresentation()">\n        <i class="fa-solid fa-close"></i>\n      </button>\n    </div>\n  </header>\n  <div class="preview">\n    @if (previewingPresentation) {\n      <preview\n      [presentation]="presentation"></preview>\n    }\n  </div>\n</aside>\n\n@if (showLoader) {\n  <aside id="loader" [class.closing]="closingLoader">\n    <loader class="active" [fill]="true"></loader>\n  </aside>\n}', styles: ['/* src/app/presentation/components/management/management.component.scss */\n@-webkit-keyframes pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes pageLoadIn {\n  0% {\n    -moz-transform: scale(0);\n    -ms-transform: scale(0);\n    -o-transform: scale(0);\n    -webkit-transform: scale(0);\n    transform: scale(0);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes pageMoveOver {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n#presentationManagement {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  padding: calc(6vw + var(--systemOffset-top)) 0 50vh 0;\n  overflow-x: hidden;\n}\n#presentationManagement > header {\n  position: sticky;\n  top: 0;\n  width: 95%;\n  margin: 0 auto 2vw;\n  z-index: 2;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#presentationManagement > header:before {\n  content: "";\n  position: absolute;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 100%;\n  height: calc(6vw + var(--systemOffset-top));\n  pointer-events: none;\n  z-index: 0;\n  background-color: var(--color2Alt1) 0%;\n  background-image:\n    linear-gradient(\n      to bottom,\n      var(--color2Alt1) 0%,\n      rgba(var(--color2Alt1-raw), 0.9) 100%);\n}\n#presentationManagement > header > .search {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#presentationManagement > header > .search > .input input {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#presentationManagement > header > .sorting {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#presentationManagement > header > .sorting > .control {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#presentationManagement > header > .sorting > .control > label {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#presentationManagement > header > .sorting > .control > .input select {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#presentationManagement > header > .sorting > .control:first-child {\n  margin-left: 0;\n}\n#presentationManagement > .message > p {\n  font-size: 4vw;\n  top: calc(20vh + var(--systemOffset-top));\n  position: fixed;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n#presentationManagement.no-content {\n  overflow: hidden;\n}\n#presentationManagement > .content-item {\n  position: relative;\n  z-index: 0;\n  display: inline-block;\n  vertical-align: top;\n  width: calc(20% - 2.4vw - 2vw);\n  margin-top: 3vw;\n  margin-left: 3vw;\n  cursor: pointer;\n  -moz-transition: filter 0.1s linear;\n  -o-transition: filter 0.1s linear;\n  -webkit-transition: filter 0.1s linear;\n  transition: filter 0.1s linear;\n  -webkit-filter: brightness(100%);\n  -moz-filter: brightness(100%);\n  -o-filter: brightness(100%);\n  -ms-filter: brightness(100%);\n  filter: brightness(100%);\n}\n#presentationManagement > .content-item > content-thumb {\n  display: block;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 0.5vw;\n  overflow: hidden;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  -moz-transition: transform 0.1s linear;\n  -o-transition: transform 0.1s linear;\n  -webkit-transition: transform 0.1s linear;\n  transition: transform 0.1s linear;\n}\n#presentationManagement > .content-item:nth-of-type(5n+1) {\n  margin-left: 5vw;\n}\n#presentationManagement > .content-item:nth-of-type(5n) {\n  margin-right: 5vw;\n}\n#presentationManagement > .content-item:nth-of-type(-n+5) {\n  margin-top: 0;\n}\n#presentationManagement > .content-item.dragging > content-thumb {\n  -moz-transform: scale(1.2);\n  -ms-transform: scale(1.2);\n  -o-transform: scale(1.2);\n  -webkit-transform: scale(1.2);\n  transform: scale(1.2);\n}\n#presentationManagement > .content-item.dragging {\n  z-index: 1;\n}\n#presentationManagement > .content-item.hovering {\n  -webkit-filter: brightness(90%);\n  -moz-filter: brightness(90%);\n  -o-filter: brightness(90%);\n  -ms-filter: brightness(90%);\n  filter: brightness(90%);\n}\n#presentationManagement > .content-item.dropping > content-thumb {\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n}\n#presentationManagement > .content-item.dropping {\n  -webkit-filter: brightness(50%);\n  -moz-filter: brightness(50%);\n  -o-filter: brightness(50%);\n  -ms-filter: brightness(50%);\n  filter: brightness(50%);\n}\n#presentationManagement > .personalized {\n  position: fixed;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 0;\n}\n#presentationManagement > .personalized > header {\n  padding: 0.5vw 2vw 1vw;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#presentationManagement > .personalized > header h2 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#presentationManagement > .personalized > header > .controls {\n  display: flex;\n  align-items: center;\n  border-radius: 999px;\n  background-color: var(--color2);\n  padding: 0.5vw 1vw;\n}\n#presentationManagement > .personalized > header > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#presentationManagement > .personalized > header > .controls > .control > i:last-child,\n#presentationManagement > .personalized > header > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#presentationManagement > .personalized > header > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#presentationManagement > .personalized > header > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#presentationManagement > .personalized > header > .controls > .control.success {\n  background-color: var(--success);\n}\n#presentationManagement > .personalized > header > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#presentationManagement > .personalized > header > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#presentationManagement > .personalized > header > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#presentationManagement > .personalized > header > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#presentationManagement > .personalized > header > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#presentationManagement > .personalized > header > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#presentationManagement > .personalized > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#presentationManagement > .personalized > .pages {\n  padding: 1vw 2vw 1vw;\n  overflow-y: hidden;\n  overflow-x: scroll;\n  font-size: 0;\n  white-space: nowrap;\n  background-color: var(--color2);\n  border-top: 0.2vw var(--color1) solid;\n}\n#presentationManagement > .personalized > .pages > .page {\n  display: inline-block;\n  vertical-align: middle;\n  height: 100%;\n  margin-left: 1vw;\n  white-space: nowrap;\n  font-size: 0;\n  position: relative;\n  -moz-transition: transform 0.2s linear;\n  -o-transition: transform 0.2s linear;\n  -webkit-transition: transform 0.2s linear;\n  transition: transform 0.2s linear;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content {\n  display: inline-block;\n  vertical-align: middle;\n  width: 16vw;\n  border: 0.2vw var(--color1) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n  margin-left: 2vw;\n  margin-right: 2vw;\n  position: relative;\n  z-index: 0;\n  -moz-animation-name: pageLoadIn;\n  -ms-animation-name: pageLoadIn;\n  -o-animation-name: pageLoadIn;\n  -webkit-animation-name: pageLoadIn;\n  animation-name: pageLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: 0.3s;\n  -ms-animation-duration: 0.3s;\n  -o-animation-duration: 0.3s;\n  -webkit-animation-duration: 0.3s;\n  animation-duration: 0.3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .content {\n  position: relative;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .content > canvas {\n  width: 100%;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .content > content-thumb {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .meta {\n  position: absolute;\n  top: auto;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  padding: 0.5vw 1vw;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .meta > .name > label {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--ltweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .control {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--error);\n  border: 0.2vw var(--color1) solid;\n  overflow: hidden;\n  border-radius: 100%;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n#presentationManagement > .personalized > .pages > .page > .page-content:first-child {\n  margin-left: 0;\n}\n#presentationManagement > .personalized > .pages > .page > .page-content + .addition {\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-animation-name: pageLoadIn;\n  -ms-animation-name: pageLoadIn;\n  -o-animation-name: pageLoadIn;\n  -webkit-animation-name: pageLoadIn;\n  animation-name: pageLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: 0.3s;\n  -ms-animation-duration: 0.3s;\n  -o-animation-duration: 0.3s;\n  -webkit-animation-duration: 0.3s;\n  animation-duration: 0.3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.15s;\n  -ms-animation-delay: 0.15s;\n  -o-animation-delay: 0.15s;\n  -webkit-animation-delay: 0.15s;\n  animation-delay: 0.15s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationManagement > .personalized > .pages > .page .addition {\n  display: inline-block;\n  vertical-align: middle;\n  width: 16vw;\n  position: relative;\n  cursor: pointer;\n  border: 0.2vw var(--color1Alt2) dashed;\n  border-radius: 1vw;\n  background-color: transparent;\n  -moz-transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n  -o-transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n  -webkit-transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n  transition:\n    border-color 0.2s,\n    border-style 0.2s,\n    background-color 0.2s;\n}\n#presentationManagement > .personalized > .pages > .page .addition > canvas {\n  width: 100%;\n}\n#presentationManagement > .personalized > .pages > .page .addition > .content {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  width: 100%;\n}\n#presentationManagement > .personalized > .pages > .page .addition > .content > .icon {\n  text-align: center;\n}\n#presentationManagement > .personalized > .pages > .page .addition > .content > .icon > i {\n  font-size: 4vw;\n  color: var(--color1Alt4);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#presentationManagement > .personalized > .pages > .page .addition > .content > label {\n  text-align: center;\n  display: block;\n  margin-top: 0.5vw;\n  font-size: 1.4vw;\n  color: var(--color1Alt4);\n  font-weight: var(--ltweight);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#presentationManagement > .personalized > .pages > .page .addition.hovering {\n  border-color: var(--success);\n  background-color: rgba(var(--success-raw), 0.1);\n  border-style: solid;\n}\n#presentationManagement > .personalized > .pages > .page .addition.hovering > .content > .icon > i {\n  color: var(--success);\n}\n#presentationManagement > .personalized > .pages > .page .addition.hovering > .content > label {\n  color: var(--success);\n}\n#presentationManagement > .personalized > .pages > .page:first-child {\n  margin-left: 0;\n}\n#presentationManagement > .personalized > .pages > .page.hovering-left {\n  -moz-transform: translateX(10%);\n  -ms-transform: translateX(10%);\n  -o-transform: translateX(10%);\n  -webkit-transform: translateX(10%);\n  transform: translateX(10%);\n}\n#presentationManagement > .personalized > .pages > .page.hovering-right {\n  -moz-transform: translateX(-10%);\n  -ms-transform: translateX(-10%);\n  -o-transform: translateX(-10%);\n  -webkit-transform: translateX(-10%);\n  transform: translateX(-10%);\n}\n#presentationManagement > .personalized > .pages > .page.hovering-right + .page {\n  -moz-transform: translateX(10%);\n  -ms-transform: translateX(10%);\n  -o-transform: translateX(10%);\n  -webkit-transform: translateX(10%);\n  transform: translateX(10%);\n}\n#presentationManagement > .personalized > .pages > .page.new ~ .page {\n  -moz-animation-name: pageMoveOver;\n  -ms-animation-name: pageMoveOver;\n  -o-animation-name: pageMoveOver;\n  -webkit-animation-name: pageMoveOver;\n  animation-name: pageMoveOver;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: 0.3s;\n  -ms-animation-duration: 0.3s;\n  -o-animation-duration: 0.3s;\n  -webkit-animation-duration: 0.3s;\n  animation-duration: 0.3s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#contentPreview {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n  z-index: 10;\n  opacity: 0;\n  -moz-transform: scale(0.5);\n  -ms-transform: scale(0.5);\n  -o-transform: scale(0.5);\n  -webkit-transform: scale(0.5);\n  transform: scale(0.5);\n  pointer-events: none;\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  -moz-transform-origin: center center;\n  -ms-transform-origin: center center;\n  -o-transform-origin: center center;\n  -webkit-transform-origin: center center;\n  transform-origin: center center;\n  background-color: var(--color1Alt4);\n  border: 1vw var(--color1) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#contentPreview > header {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  z-index: 1;\n}\n#contentPreview > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#contentPreview > header > .controls > .control {\n  background-color: var(--color1);\n  border: 0.2vw var(--color1Alt3) solid;\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#contentPreview > header > .controls > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#contentPreview > .preview {\n  width: 100%;\n  height: 100%;\n  text-align: center;\n  position: relative;\n  z-index: 0;\n}\n#contentPreview > .preview content-preview {\n  display: block;\n}\n#contentPreview.active {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n#presentationPreview {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n  z-index: 10;\n  opacity: 0;\n  -moz-transform: scale(0.5);\n  -ms-transform: scale(0.5);\n  -o-transform: scale(0.5);\n  -webkit-transform: scale(0.5);\n  transform: scale(0.5);\n  pointer-events: none;\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  -moz-transform-origin: center center;\n  -ms-transform-origin: center center;\n  -o-transform-origin: center center;\n  -webkit-transform-origin: center center;\n  transform-origin: center center;\n  background-color: var(--color1Alt4);\n  border: 1vw var(--color1) solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#presentationPreview > header {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  z-index: 1;\n}\n#presentationPreview > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#presentationPreview > header > .controls > .control {\n  background-color: var(--color1);\n  border: 0.2vw var(--color1Alt3) solid;\n  border-radius: 100%;\n  height: 3vw;\n  width: 3vw;\n  cursor: pointer;\n  position: relative;\n}\n#presentationPreview > header > .controls > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.6vw;\n  color: var(--color2);\n}\n#presentationPreview > .preview {\n  width: 100%;\n  height: 100%;\n  text-align: center;\n  position: relative;\n  z-index: 0;\n}\n#presentationPreview > .preview content-preview {\n  display: block;\n}\n#presentationPreview.active {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n  pointer-events: initial;\n}\n@-webkit-keyframes loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes loadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes loadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#loader {\n  position: fixed;\n  z-index: 20;\n  right: 1vw;\n  bottom: 1vw;\n  pointer-events: none;\n  opacity: 0;\n  -moz-animation-name: loadIn;\n  -ms-animation-name: loadIn;\n  -o-animation-name: loadIn;\n  -webkit-animation-name: loadIn;\n  animation-name: loadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#loader > loader {\n  display: block;\n  position: relative;\n  width: 5vw;\n  height: 5vw;\n  --fillSpeed: 1s;\n}\n#loader.closing {\n  -moz-animation-name: loadOut;\n  -ms-animation-name: loadOut;\n  -o-animation-name: loadOut;\n  -webkit-animation-name: loadOut;\n  animation-name: loadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 1s;\n  -ms-animation-duration: 1s;\n  -o-animation-duration: 1s;\n  -webkit-animation-duration: 1s;\n  animation-duration: 1s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=management.component.css.map */\n'] }]
  }], () => [{ type: PresentationManagementService }, { type: AuthRefService }, { type: UiService }], { personalizedElm: [{
    type: ViewChild,
    args: ["personalizedElm"]
  }], pageElms: [{
    type: ViewChildren,
    args: ["pageElm"]
  }], additionsElms: [{
    type: ViewChildren,
    args: ["additionElm"]
  }], draggableElms: [{
    type: ViewChildren,
    args: ["contentItemElm"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ManagementComponent, { className: "ManagementComponent" });
})();

// src/app/presentation/components/layout/layout.component.ts
var _c06 = ["componentElm"];
function PresentationLayoutComponent_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "management", 6);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.managementRoute == null ? null : ctx_r0.managementRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.managementRoute == null ? null : ctx_r0.managementRoute.animating)("closing", ctx_r0.managementRoute == null ? null : ctx_r0.managementRoute.closing)("rendered", ctx_r0.managementRoute == null ? null : ctx_r0.managementRoute.rendered);
    \u0275\u0275property("route", ctx_r0.managementRoute);
  }
}
var _PresentationLayoutComponent = class _PresentationLayoutComponent {
  constructor(presentationManagementService) {
    this.presentationManagementService = presentationManagementService;
    this.params = new BehaviorSubject([]);
    this.routeParams = new BehaviorSubject([]);
    this.routeLabel = "Presentation";
  }
  get routesInitialized() {
    return this.presentationManagementService.routesInitialized;
  }
  get routes() {
    return this.presentationManagementService.routeService.routes;
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        const componentElm = this.componentElm?.nativeElement;
        if (componentElm != null) {
          let route = params[0]?.toLowerCase();
          if (route != null) {
            const routeMatches = Object.values(PresentationRouteType).includes(route);
            const routeParams = params.slice(1);
            this.routeParams.next(routeParams);
            if (routeMatches) {
              if (!this.routesInitialized) {
                this.presentationManagementService.initRoutes(route, componentElm);
              } else {
                this.viewRoute(route);
              }
            } else {
              if (!this.routesInitialized) {
                this.presentationManagementService.initRoutes(void 0, componentElm);
              }
            }
          } else {
            if (!this.routesInitialized) {
              this.presentationManagementService.initRoutes(void 0, componentElm);
            }
          }
        }
      }
    });
  }
  viewRoute(name) {
    if (name != null) {
      this.presentationManagementService.routeService.viewRoute(name, RouteLoadDirection.Forward, true);
    }
  }
  watchRoute() {
    this.routeSubscription = this.presentationManagementService.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
            case PresentationRouteType.management:
              {
                this.routeLabel = "Build Your Presentation";
              }
              break;
          }
        }
      }
    });
  }
  initRouting() {
    setTimeout(() => {
      this.watchParams();
      this.watchRoute();
    }, 0);
  }
  // #endregion
  // #region Management
  get managementRoute() {
    return this.routes[PresentationRouteType.management];
  }
  init() {
    this.initRouting();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.paramsSubscription?.unsubscribe();
    this.routeSubscription?.unsubscribe();
  }
};
_PresentationLayoutComponent.\u0275fac = function PresentationLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationLayoutComponent)(\u0275\u0275directiveInject(PresentationManagementService));
};
_PresentationLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PresentationLayoutComponent, selectors: [["ng-component"]], viewQuery: function PresentationLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c06, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 11, vars: 2, consts: [["componentElm", ""], ["id", "presentationLayout"], [1, "primary"], [1, "secondary"], [1, "routes"], [3, "class", "animate", "closing", "rendered", "route"], [3, "route"]], template: function PresentationLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h1");
    \u0275\u0275text(5, "Presentation");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "div", 3)(7, "h2");
    \u0275\u0275text(8);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 4);
    \u0275\u0275conditionalCreate(10, PresentationLayoutComponent_Conditional_10_Template, 1, 10, "management", 5);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx.routeLabel);
    \u0275\u0275advance(2);
    \u0275\u0275conditional((ctx.managementRoute == null ? null : ctx.managementRoute.active) ? 10 : -1);
  }
}, dependencies: [ManagementComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#presentationLayout[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#presentationLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#presentationLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#presentationLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#presentationLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#presentationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  will-change: transform;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%] {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .loader[_ngcontent-%COMP%]    > loader[_ngcontent-%COMP%] {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#presentationLayout[_ngcontent-%COMP%]    > .loader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var PresentationLayoutComponent = _PresentationLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '<section id="presentationLayout" #componentElm>\n  <header>\n    <div class="primary">\n      <h1>Presentation</h1>\n    </div>\n    <div class="secondary">\n      <h2>{{routeLabel}}</h2>\n    </div>\n  </header>\n\n  <div class="routes">\n    @if (managementRoute?.active) {\n      <management class="route {{managementRoute?.loadDirection}}"\n        [class.animate]="managementRoute?.animating"\n        [class.closing]="managementRoute?.closing"\n        [class.rendered]="managementRoute?.rendered"\n      [route]="managementRoute"></management>\n    }\n  </div>\n\n</section>', styles: ["/* src/app/presentation/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#presentationLayout {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#presentationLayout > header {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#presentationLayout > header > .primary h1 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#presentationLayout > header > .secondary {\n  margin-left: 1vw;\n}\n#presentationLayout > header > .secondary h2 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#presentationLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  will-change: transform;\n}\n#presentationLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#presentationLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#presentationLayout > .loader {\n  position: absolute;\n  right: 1.5vw;\n  bottom: 1.5vw;\n  z-index: 1;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#presentationLayout > .loader > loader {\n  display: block;\n  height: 4vw;\n  width: 4vw;\n}\n#presentationLayout > .loader.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: PresentationManagementService }], { params: [{
    type: Input,
    args: ["params"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PresentationLayoutComponent, { className: "PresentationLayoutComponent" });
})();

// src/app/presentation/presentation.module.ts
var _PresentationModule = class _PresentationModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    if (!customElements.get("global-presentation")) {
      const el = createCustomElement(PresentationLayoutComponent, { injector: this.injector });
      customElements.define("global-presentation", el);
    }
  }
};
_PresentationModule.\u0275fac = function PresentationModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationModule)(\u0275\u0275inject(Injector));
};
_PresentationModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _PresentationModule });
_PresentationModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  PresentationManagementService,
  InternalRouteService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  CommonModule,
  UiModule,
  ReactiveFormsModule,
  FormsModule
] });
var PresentationModule = _PresentationModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationModule, [{
    type: NgModule,
    args: [{
      declarations: [
        PresentationLayoutComponent,
        ContentThumbComponent,
        ContentPreviewComponent,
        ManagementComponent,
        PreviewPresentationComponent,
        PresentationPageComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        CommonModule,
        UiModule,
        ReactiveFormsModule,
        FormsModule
      ],
      providers: [
        PresentationManagementService,
        InternalRouteService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  PresentationModule
};
//# sourceMappingURL=chunk-RLPFCJP2.js.map
