import {
  AdministrationService
} from "./chunk-RFRQWW6A.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  AsyncPipe,
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  Injector,
  Input,
  NgModule,
  UiModule,
  ViewChild,
  createNgModule,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-RVA4KI76.js";

// src/app/administration/models/navigation.ts
var RouteType;
(function(RouteType2) {
  RouteType2["entities"] = "entities";
  RouteType2["netsuite"] = "netsuite";
  RouteType2["appointments"] = "appointments";
  RouteType2["system"] = "system";
})(RouteType || (RouteType = {}));

// src/app/administration/components/layout/layout.component.ts
var _c0 = ["componentElm"];
function LayoutComponent_Conditional_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "administration-entities", 7);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.entitiesRoute == null ? null : ctx_r0.entitiesRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.entitiesRoute == null ? null : ctx_r0.entitiesRoute.animating)("closing", ctx_r0.entitiesRoute == null ? null : ctx_r0.entitiesRoute.closing);
    \u0275\u0275property("params", ctx_r0.routeParams);
  }
}
function LayoutComponent_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "administration-netsuite", 7);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.netsuiteRoute == null ? null : ctx_r0.netsuiteRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.netsuiteRoute == null ? null : ctx_r0.netsuiteRoute.animating)("closing", ctx_r0.netsuiteRoute == null ? null : ctx_r0.netsuiteRoute.closing);
    \u0275\u0275property("params", ctx_r0.routeParams);
  }
}
function LayoutComponent_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "administration-appointments", 7);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.animating)("closing", ctx_r0.appointmentsRoute == null ? null : ctx_r0.appointmentsRoute.closing);
    \u0275\u0275property("params", ctx_r0.routeParams);
  }
}
function LayoutComponent_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "administration-system", 7);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.systemsRoute == null ? null : ctx_r0.systemsRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.systemsRoute == null ? null : ctx_r0.systemsRoute.animating)("closing", ctx_r0.systemsRoute == null ? null : ctx_r0.systemsRoute.closing);
    \u0275\u0275property("params", ctx_r0.routeParams);
  }
}
var _LayoutComponent = class _LayoutComponent {
  constructor(injector, routeService, adminService, uiService) {
    this.injector = injector;
    this.routeService = routeService;
    this.adminService = adminService;
    this.uiService = uiService;
    this.RouteType = RouteType;
    this.routesInitialized = false;
    this.params = new BehaviorSubject([]);
    this.routeParams = new BehaviorSubject(void 0);
  }
  get routeTitle() {
    return this.adminService.routeTitle;
  }
  get routes() {
    return this.routeService.routes;
  }
  initRoutes(initialRouteType = void 0) {
    setTimeout(() => {
      if (this.componentElm != null) {
        const routes = {
          [RouteType.entities]: new InternalRoute(RouteType.entities),
          [RouteType.netsuite]: new InternalRoute(RouteType.netsuite),
          [RouteType.appointments]: new InternalRoute(RouteType.appointments),
          [RouteType.system]: new InternalRoute(RouteType.system)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : RouteType.entities;
        this.routeService.init(routes, initialRoute, 250, this.componentElm.nativeElement);
        this.routeSubscription = this.routeService.activeRoute.subscribe({
          next: (route) => {
            if (route != null) {
              switch (route.type) {
                case RouteType.entities:
                  {
                    this.loadEntities();
                  }
                  break;
                case RouteType.netsuite:
                  {
                    this.loadNetSuite();
                  }
                  break;
                case RouteType.appointments:
                  {
                    this.loadAppointments();
                  }
                  break;
                case RouteType.system:
                  {
                    this.loadSystem();
                  }
                  break;
              }
            }
          }
        });
        this.routesInitialized = true;
      }
    }, 0);
  }
  viewRoute(name) {
    if (name != null) {
      this.routeService.viewRoute(name, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Appointments
  get appointmentsRoute() {
    return this.routes[RouteType.appointments];
  }
  loadAppointments() {
    if (!customElements.get("administration-appointments")) {
      import("./chunk-6IS2TKBL.js").then((mod) => mod.AppointmentsModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  // #endregion
  // #region Entities
  get entitiesRoute() {
    return this.routes[RouteType.entities];
  }
  loadEntities() {
    if (!customElements.get("administration-entities")) {
      import("./chunk-Y7B6TS4Y.js").then((mod) => mod.EntitiesModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  // #endregion
  // #region Entities
  get netsuiteRoute() {
    return this.routes[RouteType.netsuite];
  }
  loadNetSuite() {
    if (!customElements.get("administration-netsuite")) {
      import("./chunk-B2IRVW3M.js").then((mod) => mod.NetSuiteModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  // #endregion
  // #region System
  get systemsRoute() {
    return this.routes[RouteType.system];
  }
  loadSystem() {
    if (!customElements.get("administration-system")) {
      import("./chunk-6KGVPDP7.js").then((mod) => mod.SystemModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        let route = params[0]?.toLowerCase();
        if (route != null) {
          const routeMatches = Object.values(RouteType).includes(route);
          const routeParams = params.slice(1);
          this.routeParams.next(routeParams);
          if (routeMatches) {
            if (!this.routesInitialized) {
              this.initRoutes(route);
            } else {
              this.viewRoute(route);
            }
          } else {
            if (!this.routesInitialized) {
              this.initRoutes();
            }
          }
        }
      }
    });
  }
  init() {
    this.watchParams();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_LayoutComponent.\u0275fac = function LayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LayoutComponent)(\u0275\u0275directiveInject(Injector), \u0275\u0275directiveInject(InternalRouteService), \u0275\u0275directiveInject(AdministrationService), \u0275\u0275directiveInject(UiService));
};
_LayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _LayoutComponent, selectors: [["layout"]], viewQuery: function LayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 16, vars: 7, consts: [["componentElm", ""], ["id", "adminLayout"], [1, "primary"], [1, "secondary"], [1, "content"], [1, "routes"], [3, "class", "params", "animate", "closing"], [3, "params"]], template: function LayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h2");
    \u0275\u0275text(5, "Administration");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "h1");
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "async");
    \u0275\u0275elementEnd()();
    \u0275\u0275element(9, "div", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "div", 4)(11, "div", 5);
    \u0275\u0275conditionalCreate(12, LayoutComponent_Conditional_12_Template, 1, 8, "administration-entities", 6);
    \u0275\u0275conditionalCreate(13, LayoutComponent_Conditional_13_Template, 1, 8, "administration-netsuite", 6);
    \u0275\u0275conditionalCreate(14, LayoutComponent_Conditional_14_Template, 1, 8, "administration-appointments", 6);
    \u0275\u0275conditionalCreate(15, LayoutComponent_Conditional_15_Template, 1, 8, "administration-system", 6);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(8, 5, ctx.routeTitle));
    \u0275\u0275advance(5);
    \u0275\u0275conditional((ctx.entitiesRoute == null ? null : ctx.entitiesRoute.active) ? 12 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.netsuiteRoute == null ? null : ctx.netsuiteRoute.active) ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.appointmentsRoute == null ? null : ctx.appointmentsRoute.active) ? 14 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.systemsRoute == null ? null : ctx.systemsRoute.active) ? 15 : -1);
  }
}, dependencies: [AsyncPipe], styles: ["\n\n#adminLayout[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n  background-color: var(--color2Alt1);\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: calc(1vw + var(--systemOffset-top)) 2vw 1vw 2vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  position: relative;\n  left: var(--sideNav-adjust);\n  -moz-transition: left 0.2s linear;\n  -o-transition: left 0.2s linear;\n  -webkit-transition: left 0.2s linear;\n  transition: left 0.2s linear;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.1vw;\n  color: var(--color2Alt4);\n  text-transform: uppercase;\n  font-weight: var(--mdweight);\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  line-height: 1;\n  font-size: 2.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  -moz-transition: font-size 0.2s linear;\n  -o-transition: font-size 0.2s linear;\n  -webkit-transition: font-size 0.2s linear;\n  transition: font-size 0.2s linear;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 2vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color3);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#adminLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#adminLayout[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  height: 100%;\n  position: relative;\n}\n#adminLayout[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var LayoutComponent = _LayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LayoutComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "layout", template: '<section id="adminLayout" #componentElm>\n  <header>\n    <div class="primary">\n      <h2>Administration</h2>\n      <h1>{{routeTitle | async}}</h1>\n    </div>\n    <div class="secondary">\n    </div>\n  </header>\n  <div class="content">\n    <div class="routes">\n      @if (entitiesRoute?.active) {\n        <administration-entities\n          class="route {{entitiesRoute?.loadDirection}}"\n          [params]="routeParams"\n          [class.animate]="entitiesRoute?.animating"\n        [class.closing]="entitiesRoute?.closing"></administration-entities>\n      }\n      @if (netsuiteRoute?.active) {\n        <administration-netsuite\n          class="route {{netsuiteRoute?.loadDirection}}"\n          [params]="routeParams"\n          [class.animate]="netsuiteRoute?.animating"\n        [class.closing]="netsuiteRoute?.closing"></administration-netsuite>\n      }\n      @if (appointmentsRoute?.active) {\n        <administration-appointments\n          class="route {{appointmentsRoute?.loadDirection}}"\n          [params]="routeParams"\n          [class.animate]="appointmentsRoute?.animating"\n        [class.closing]="appointmentsRoute?.closing"></administration-appointments>\n      }\n      @if (systemsRoute?.active) {\n        <administration-system\n          class="route {{systemsRoute?.loadDirection}}"\n          [params]="routeParams"\n          [class.animate]="systemsRoute?.animating"\n        [class.closing]="systemsRoute?.closing"></administration-system>\n      }\n    </div>\n  </div>\n</section>', styles: ["/* src/app/administration/components/layout/layout.component.scss */\n#adminLayout {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n  background-color: var(--color2Alt1);\n}\n#adminLayout > header {\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  padding: calc(1vw + var(--systemOffset-top)) 2vw 1vw 2vw;\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#adminLayout > header > .primary {\n  position: relative;\n  left: var(--sideNav-adjust);\n  -moz-transition: left 0.2s linear;\n  -o-transition: left 0.2s linear;\n  -webkit-transition: left 0.2s linear;\n  transition: left 0.2s linear;\n}\n#adminLayout > header > .primary h2 {\n  font-size: 1.1vw;\n  color: var(--color2Alt4);\n  text-transform: uppercase;\n  font-weight: var(--mdweight);\n}\n#adminLayout > header > .primary h1 {\n  line-height: 1;\n  font-size: 2.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  -moz-transition: font-size 0.2s linear;\n  -o-transition: font-size 0.2s linear;\n  -webkit-transition: font-size 0.2s linear;\n  transition: font-size 0.2s linear;\n}\n#adminLayout > header > .secondary > .controls {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n#adminLayout > header > .secondary > .controls > .control {\n  margin-left: 2vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n#adminLayout > header > .secondary > .controls > .control > i,\n#adminLayout > header > .secondary > .controls > .control > label {\n  color: var(--color3);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#adminLayout > header > .secondary > .controls > .control > i {\n  font-size: 1.4vw;\n}\n#adminLayout > header > .secondary > .controls > .control > label {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#adminLayout > header > .secondary > .controls > .control.active > i,\n#adminLayout > header > .secondary > .controls > .control.active > label {\n  color: var(--color5);\n}\n#adminLayout > header > .secondary > .controls > .control:first-child {\n  margin-left: 0;\n}\n#adminLayout > .content {\n  flex: 1;\n  height: 100%;\n  position: relative;\n}\n#adminLayout > .content > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: Injector }, { type: InternalRouteService }, { type: AdministrationService }, { type: UiService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], params: [{
    type: Input,
    args: ["params"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(LayoutComponent, { className: "LayoutComponent" });
})();

// src/app/administration/administration.module.ts
var _AdministrationModule = class _AdministrationModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(LayoutComponent, { injector: this.injector });
    customElements.define("global-administration", el);
  }
};
_AdministrationModule.\u0275fac = function AdministrationModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AdministrationModule)(\u0275\u0275inject(Injector));
};
_AdministrationModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _AdministrationModule });
_AdministrationModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  InternalRouteService,
  AdministrationService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule
] });
var AdministrationModule = _AdministrationModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AdministrationModule, [{
    type: NgModule,
    args: [{
      declarations: [
        LayoutComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        UiModule,
        CommonModule
      ],
      providers: [
        InternalRouteService,
        AdministrationService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  AdministrationModule
};
//# sourceMappingURL=chunk-YKRRNNTK.js.map
