import {
  environment
} from "./chunk-IV25C5MY.js";
import {
  BehaviorSubject,
  HttpClient,
  Injectable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";

// src/app/shared/system/services/system.service.ts
var _SystemService = class _SystemService {
  constructor(http) {
    this.http = http;
    this.ip = new BehaviorSubject(void 0);
    this.deviceInfo = new BehaviorSubject(void 0);
    this.location = new BehaviorSubject(void 0);
    this.init();
  }
  init() {
    this.getDeviceInfo();
    this.getLocation();
  }
  getDeviceInfo() {
    const url = `${environment.API_URL}/system/device-info`;
    this.http.get(url).subscribe({
      next: (info) => {
        this.deviceInfo.next(info);
      }
    });
  }
  watchDeviceInfo() {
  }
  getLocation() {
    const location = this.location.getValue();
    if (navigator.geolocation != null && location != null) {
      navigator.geolocation.getCurrentPosition((pos) => {
        this.location.next(pos);
      }, (err) => {
      }, {
        enableHighAccuracy: true,
        timeout: 1e4,
        maximumAge: 0
      });
    }
  }
  // #endregion
  // #region Logs
  getLogs() {
    const url = `{{api}}/system/logs/all`;
    return this.http.get(url);
  }
  // #endregion
  ngOnDestroy() {
  }
};
_SystemService.\u0275fac = function SystemService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SystemService)(\u0275\u0275inject(HttpClient));
};
_SystemService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _SystemService, factory: _SystemService.\u0275fac });
var SystemService = _SystemService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SystemService, [{
    type: Injectable
  }], () => [{ type: HttpClient }], null);
})();

export {
  SystemService
};
//# sourceMappingURL=chunk-ZCU5UWZD.js.map
