import {
  AppointmentService
} from "./chunk-WJXFQPCB.js";
import {
  LogService,
  OpportunityService
} from "./chunk-62CCQ3GT.js";
import {
  ContentService
} from "./chunk-JNQRPNRP.js";
import {
  Opportunity,
  OpportunityStatus,
  StorageService
} from "./chunk-M3LFBN7N.js";
import {
  deepClone
} from "./chunk-N36JE2BE.js";
import {
  HttpClient,
  Injectable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";
import {
  __async
} from "./chunk-RVA4KI76.js";

// src/app/shared/opportunities/services/migration.service.ts
var _OpportunityMigrationService = class _OpportunityMigrationService {
  constructor(http, storageService, logService, contentService, appointmentService, opportunityService) {
    this.http = http;
    this.storageService = storageService;
    this.logService = logService;
    this.contentService = contentService;
    this.appointmentService = appointmentService;
    this.opportunityService = opportunityService;
    this.migrateAppointments();
  }
  // #region Appointments
  appointmentToOpportunity(appointment) {
    const opportunity = new Opportunity();
    opportunity.id = appointment.id;
    opportunity.jobId = appointment.jobId;
    opportunity.job = deepClone(appointment.job);
    opportunity.assignedTo = deepClone(appointment.assignedTo);
    opportunity.customer = deepClone(appointment.customer);
    opportunity.property = deepClone(appointment.property);
    opportunity.opportunityNotes = appointment.opportunityNotes;
    opportunity.opportunityTypes = appointment.opportunityTypes;
    opportunity.opportunityPlumbingIssues = appointment.opportunityPlumbingIssues;
    opportunity.opportunityCouponCode = appointment.opportunityCouponCode;
    opportunity.isEmergency = appointment.isEmergency;
    opportunity.status = OpportunityStatus[appointment.status];
    opportunity.statusDescription = appointment.statusDescription;
    opportunity.availablePromotions = deepClone(appointment.availablePromotions) ?? [];
    opportunity.availableFixtures = deepClone(appointment.availableFixtures) ?? [];
    opportunity.availableEntities = deepClone(appointment.availableEntities) ?? [];
    opportunity.availableSkus = deepClone(appointment.availableSkus) ?? [];
    opportunity.availablePaymentSettings = deepClone(appointment.availablePaymentSettings) ?? [];
    opportunity.availableDocuments = deepClone(appointment.availableDocuments) ?? [];
    opportunity.availableDispositionStatuses = deepClone(appointment.availableDispositionStatuses) ?? [];
    opportunity.availableShops = deepClone(appointment.availableShops) ?? [];
    opportunity.scheduled_Utc = appointment.scheduled_Utc;
    opportunity.created_Utc = appointment.created_Utc;
    opportunity.accepted = appointment.accepted;
    opportunity.accepted_Utc = appointment.accepted_Utc;
    opportunity.assigned_Utc = appointment.assigned_Utc;
    opportunity.dispositionStatus = appointment.dispositionStatus;
    opportunity.selectedShopId = appointment.selectedShopId;
    opportunity.preferredInstallDate = appointment.preferredInstallDate;
    opportunity.customerNeeds = deepClone(appointment.customerNeeds) ?? {};
    opportunity.paymentSetting = deepClone(appointment.paymentSetting);
    opportunity.payments = deepClone(appointment.payments) ?? [];
    opportunity.lenders = deepClone(appointment.lenders) ?? [];
    opportunity.price = deepClone(appointment.price);
    opportunity.customPrice = deepClone(appointment.customPrice);
    opportunity.documents = deepClone(appointment.documents) ?? [];
    return opportunity;
  }
  migrateAppointments() {
    return __async(this, null, function* () {
      const appointments = yield this.storageService.getAppointments(999);
      const results = [];
      for (var i = 0, len = appointments.length; i < len; i++) {
        const appointment = appointments[i];
        if (appointment.migratedToOpportunity_Utc == null) {
          try {
            const opportunity = this.appointmentToOpportunity(appointment);
            yield this.storageService.storeOpportunity(opportunity);
            appointment.migratedToOpportunity_Utc = /* @__PURE__ */ new Date();
            yield this.storageService.storeAppointment(appointment);
            results.push({
              appointmentId: appointment.id,
              migrated: true,
              message: void 0
            });
          } catch (e) {
            results.push({
              appointmentId: appointment.id,
              migrated: false,
              message: JSON.stringify(e)
            });
          }
        }
      }
      return results;
    });
  }
  // #endregion
  ngOnDestroy() {
  }
};
_OpportunityMigrationService.\u0275fac = function OpportunityMigrationService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityMigrationService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(StorageService), \u0275\u0275inject(LogService), \u0275\u0275inject(ContentService), \u0275\u0275inject(AppointmentService), \u0275\u0275inject(OpportunityService));
};
_OpportunityMigrationService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _OpportunityMigrationService, factory: _OpportunityMigrationService.\u0275fac });
var OpportunityMigrationService = _OpportunityMigrationService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityMigrationService, [{
    type: Injectable
  }], () => [{ type: HttpClient }, { type: StorageService }, { type: LogService }, { type: ContentService }, { type: AppointmentService }, { type: OpportunityService }], null);
})();

export {
  OpportunityMigrationService
};
//# sourceMappingURL=chunk-43BBUP6V.js.map
