import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute
} from "./chunk-PRTLXG5I.js";
import {
  AuthRefService,
  OpportunityStatus
} from "./chunk-M3LFBN7N.js";
import {
  Injectable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-VAMMRICA.js";
import {
  __async
} from "./chunk-RVA4KI76.js";

// src/app/opportunity/models/navigation.ts
var OpportunityRouteType;
(function(OpportunityRouteType2) {
  OpportunityRouteType2["diagram"] = "diagram";
  OpportunityRouteType2["summary"] = "summary";
  OpportunityRouteType2["checkin"] = "checkin";
  OpportunityRouteType2["presentation"] = "presentation";
  OpportunityRouteType2["needs"] = "needs";
  OpportunityRouteType2["completion"] = "completion";
  OpportunityRouteType2["inspection"] = "inspection";
  OpportunityRouteType2["jobsummary"] = "jobsummary";
  OpportunityRouteType2["pricing"] = "pricing";
  OpportunityRouteType2["negotiation"] = "negotiation";
})(OpportunityRouteType || (OpportunityRouteType = {}));

// src/app/opportunity/services/opportunity.service.ts
var _LiveOpportunityService = class _LiveOpportunityService {
  constructor(routeService, authRefService) {
    this.routeService = routeService;
    this.authRefService = authRefService;
    this.activeUser = null;
    this.viewingPhoto = false;
    this.managingPhotos = false;
    this.closingManagePhotos = false;
    this.managingAdditionalConsiderations = false;
    this.showConsiderationPrices = false;
    this.showQuoteControl = false;
    this.watchUser();
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  // #endregion
  // #region Routes
  initRoutes(opportunity, componentElm) {
    return __async(this, null, function* () {
      const routes = {
        "summary": new InternalRoute(OpportunityRouteType.summary),
        "checkin": new InternalRoute(OpportunityRouteType.checkin),
        "needs": new InternalRoute(OpportunityRouteType.needs),
        "presentation": new InternalRoute(OpportunityRouteType.presentation),
        "completion": new InternalRoute(OpportunityRouteType.completion),
        "inspection": new InternalRoute(OpportunityRouteType.inspection),
        "jobsummary": new InternalRoute(OpportunityRouteType.jobsummary),
        "pricing": new InternalRoute(OpportunityRouteType.pricing),
        "negotiation": new InternalRoute(OpportunityRouteType.negotiation)
      };
      let state = "summary";
      if (opportunity.status == OpportunityStatus.PendingSubmission) {
        state = "completion";
      }
      const matchingRoute = OpportunityRouteType[state];
      if (matchingRoute != null) {
        this.routeService.init(routes, matchingRoute, 250, componentElm);
      } else {
        this.routeService.init(routes, OpportunityRouteType.summary, 250, componentElm);
      }
    });
  }
  viewPhoto(src) {
    this.photoSrc = src;
    this.viewingPhoto = true;
  }
  stopViewingPhoto() {
    this.viewingPhoto = false;
    setTimeout(() => {
      this.photoSrc = void 0;
    }, 500);
  }
  managePhotos(entity) {
    if (!this.managingPhotos) {
      window.clearTimeout(this.managePhotosTimer);
      this.closingManagePhotos = false;
      this.managingPhotos = true;
      this.managingPhotosEntity = entity;
    }
  }
  stopManagingPhotos() {
    window.clearTimeout(this.managePhotosTimer);
    this.closingManagePhotos = true;
    this.managePhotosTimer = window.setTimeout(() => {
      this.managingPhotos = false;
      this.closingManagePhotos = false;
      this.managingPhotosEntity = void 0;
    }, 200);
  }
  manageAdditionalConsiderations(showPrices = false) {
    this.managingAdditionalConsiderations = true;
    this.showConsiderationPrices = showPrices;
  }
  stopManagingAdditionalConsiderations() {
    this.managingAdditionalConsiderations = false;
  }
  // #endregion
  ngOnDestroy() {
    this.userSubscription?.unsubscribe();
  }
};
_LiveOpportunityService.\u0275fac = function LiveOpportunityService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LiveOpportunityService)(\u0275\u0275inject(InternalRouteService), \u0275\u0275inject(AuthRefService));
};
_LiveOpportunityService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _LiveOpportunityService, factory: _LiveOpportunityService.\u0275fac, providedIn: "root" });
var LiveOpportunityService = _LiveOpportunityService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LiveOpportunityService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: InternalRouteService }, { type: AuthRefService }], null);
})();

export {
  OpportunityRouteType,
  LiveOpportunityService
};
//# sourceMappingURL=chunk-BCWCBUER.js.map
