import {
  AppointmentRouteType,
  LocalAppointmentService
} from "./chunk-MGVWDYTN.js";
import "./chunk-FKLBEDMY.js";
import {
  Draggable,
  gsapWithCSS
} from "./chunk-DZY2UUHE.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  AppointmentService
} from "./chunk-WJXFQPCB.js";
import "./chunk-QUJNR5CZ.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import "./chunk-JNQRPNRP.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import {
  StorageService
} from "./chunk-M3LFBN7N.js";
import {
  AppointmentFixture,
  AppointmentPropertyEntity,
  EntityAttributeType,
  NoteAudience,
  PropertyEntityType,
  RenderDimensions,
  toPng
} from "./chunk-N36JE2BE.js";
import "./chunk-DNHSR4U6.js";
import {
  CommonModule,
  Component,
  DefaultValueAccessor,
  FormsModule,
  Injectable,
  Injector,
  Input,
  NgControlStatus,
  NgModel,
  NgModule,
  OrderByPipe,
  Output,
  ReactiveFormsModule,
  Subject,
  UiModule,
  ViewChild,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnamespaceHTML,
  ɵɵnamespaceSVG,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind2,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵreference,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵresolveWindow,
  ɵɵrestoreView,
  ɵɵsanitizeUrl,
  ɵɵstyleProp,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtextInterpolate2,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-IT26RCSL.js";
import {
  __async
} from "./chunk-RVA4KI76.js";

// src/app/appointment/inspection/services/inspection.service.ts
var _InspectionService = class _InspectionService {
  constructor(storageService) {
    this.storageService = storageService;
  }
};
_InspectionService.\u0275fac = function InspectionService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _InspectionService)(\u0275\u0275inject(StorageService));
};
_InspectionService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _InspectionService, factory: _InspectionService.\u0275fac, providedIn: "root" });
var InspectionService = _InspectionService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(InspectionService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: StorageService }], null);
})();

// src/app/appointment/inspection/components/attributes/attributes.component.ts
var _c0 = ["componentElm"];
function AttributesComponent_For_2_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 5)(1, "p");
    \u0275\u0275text(2, "Can select multiple options.");
    \u0275\u0275elementEnd()();
  }
}
function AttributesComponent_For_2_Conditional_4_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 9)(1, "p");
    \u0275\u0275text(2, "Please answer the question.");
    \u0275\u0275elementEnd()();
  }
}
function AttributesComponent_For_2_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, AttributesComponent_For_2_Conditional_4_Conditional_0_Template, 3, 0, "span", 9);
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275conditional(!attribute_r1.valid ? 0 : -1);
  }
}
function AttributesComponent_For_2_Conditional_5_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 9)(1, "p");
    \u0275\u0275text(2, "Please select an available option.");
    \u0275\u0275elementEnd()();
  }
}
function AttributesComponent_For_2_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, AttributesComponent_For_2_Conditional_5_Conditional_0_Template, 3, 0, "span", 9);
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275conditional(!attribute_r1.valid ? 0 : -1);
  }
}
function AttributesComponent_For_2_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "input", 10, 0);
    \u0275\u0275listener("input", function AttributesComponent_For_2_Conditional_7_Template_input_input_0_listener() {
      \u0275\u0275restoreView(_r2);
      const inputElm_r3 = \u0275\u0275reference(1);
      const attribute_r1 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.setAttribute(attribute_r1, inputElm_r3.value));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment)("value", attribute_r1.values[0])("placeholder", attribute_r1.name + " Number");
  }
}
function AttributesComponent_For_2_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 11, 1);
    \u0275\u0275listener("click", function AttributesComponent_For_2_Conditional_8_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const attribute_r1 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.setAttribute(attribute_r1, "true"));
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3, "Yes");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "button", 11, 1);
    \u0275\u0275listener("click", function AttributesComponent_For_2_Conditional_8_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r5);
      const attribute_r1 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.setAttribute(attribute_r1, "false"));
    });
    \u0275\u0275elementStart(6, "label");
    \u0275\u0275text(7, "No");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("checked", attribute_r1.values.indexOf("true") > -1);
    \u0275\u0275property("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275classProp("checked", attribute_r1.values.indexOf("false") > -1);
    \u0275\u0275property("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment);
  }
}
function AttributesComponent_For_2_Conditional_9_For_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 11, 1);
    \u0275\u0275listener("click", function AttributesComponent_For_2_Conditional_9_For_1_Template_button_click_0_listener() {
      const value_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const attribute_r1 = \u0275\u0275nextContext(2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.setAttribute(attribute_r1, value_r7));
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const value_r7 = ctx.$implicit;
    const attribute_r1 = \u0275\u0275nextContext(2).$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("checked", attribute_r1.values.indexOf(value_r7) > -1);
    \u0275\u0275property("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(value_r7);
  }
}
function AttributesComponent_For_2_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275repeaterCreate(0, AttributesComponent_For_2_Conditional_9_For_1_Template, 4, 4, "button", 12, \u0275\u0275repeaterTrackByIdentity);
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275repeater(attribute_r1.possibleValues);
  }
}
function AttributesComponent_For_2_Conditional_10_For_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 11, 1);
    \u0275\u0275listener("click", function AttributesComponent_For_2_Conditional_10_For_1_Template_button_click_0_listener() {
      const value_r9 = \u0275\u0275restoreView(_r8).$implicit;
      const attribute_r1 = \u0275\u0275nextContext(2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.setAttribute(attribute_r1, value_r9));
    });
    \u0275\u0275elementStart(2, "label");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const value_r9 = ctx.$implicit;
    const attribute_r1 = \u0275\u0275nextContext(2).$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("checked", attribute_r1.values.indexOf(value_r9) > -1);
    \u0275\u0275property("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(value_r9);
  }
}
function AttributesComponent_For_2_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275repeaterCreate(0, AttributesComponent_For_2_Conditional_10_For_1_Template, 4, 4, "button", 12, \u0275\u0275repeaterTrackByIdentity);
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275repeater(attribute_r1.possibleValues);
  }
}
function AttributesComponent_For_2_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "input", 13, 0);
    \u0275\u0275listener("input", function AttributesComponent_For_2_Conditional_11_Template_input_input_0_listener() {
      \u0275\u0275restoreView(_r10);
      const inputElm_r11 = \u0275\u0275reference(1);
      const attribute_r1 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.setAttribute(attribute_r1, inputElm_r11.value));
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const attribute_r1 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment)("value", attribute_r1.values[0] ?? null)("placeholder", attribute_r1.name);
  }
}
function AttributesComponent_For_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 4)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(3, AttributesComponent_For_2_Conditional_3_Template, 3, 0, "span", 5);
    \u0275\u0275conditionalCreate(4, AttributesComponent_For_2_Conditional_4_Template, 1, 1);
    \u0275\u0275conditionalCreate(5, AttributesComponent_For_2_Conditional_5_Template, 1, 1);
    \u0275\u0275elementStart(6, "div", 6);
    \u0275\u0275conditionalCreate(7, AttributesComponent_For_2_Conditional_7_Template, 2, 3, "input", 7);
    \u0275\u0275conditionalCreate(8, AttributesComponent_For_2_Conditional_8_Template, 8, 6);
    \u0275\u0275conditionalCreate(9, AttributesComponent_For_2_Conditional_9_Template, 2, 0);
    \u0275\u0275conditionalCreate(10, AttributesComponent_For_2_Conditional_10_Template, 2, 0);
    \u0275\u0275conditionalCreate(11, AttributesComponent_For_2_Conditional_11_Template, 2, 3, "input", 8);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const attribute_r1 = ctx.$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("disabled", attribute_r1.disabled || !ctx_r3.canModifyAppointment)("hidden", attribute_r1.shouldHide);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(attribute_r1.name);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.MultiSelect ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.Input || attribute_r1.type == ctx_r3.EntityAttributeType.Number ? 4 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.Select || attribute_r1.type == ctx_r3.EntityAttributeType.MultiSelect || attribute_r1.type == ctx_r3.EntityAttributeType.Boolean ? 5 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.Number ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.Boolean ? 8 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.MultiSelect ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.Select ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(attribute_r1.type == ctx_r3.EntityAttributeType.Input ? 11 : -1);
  }
}
var _AttributesComponent = class _AttributesComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.EntityAttributeType = EntityAttributeType;
    this.attributes = [];
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  toggleAttributeValue(attribute, value) {
    if (value.length > 0) {
      const existingIndex = attribute.values.findIndex((x) => x == value);
      if (existingIndex <= -1) {
        if (attribute.type == EntityAttributeType.MultiSelect) {
          attribute.values.push(value);
        } else {
          attribute.values = [value];
        }
      } else {
        attribute.values.splice(existingIndex, 1);
      }
    } else {
      attribute.values = [];
    }
  }
  setAttribute(attribute, value) {
    this.toggleAttributeValue(attribute, value);
    attribute.touched = true;
    this.changeAttribute(attribute);
  }
  changeAttribute(attribute) {
    if (this.entity != null) {
      const functionName = attribute.functionName?.toLowerCase();
      switch (functionName) {
        case "update number of units":
          {
            if (attribute.values.length > 0) {
              try {
                const units = parseInt(attribute.values[0]);
                this.updateUnits(units).then((count) => {
                  attribute.values[0] = `${count}`;
                  this.appointment?.changed$.next();
                });
              } catch {
              }
            }
          }
          break;
        case "update number of rooms":
          {
            if (attribute.values[0] != null) {
              const rooms = parseInt(attribute.values[0]);
              this.updateRooms(rooms).then((count) => {
                attribute.values[0] = `${count}`;
                this.appointment?.changed$.next();
              });
            }
          }
          break;
        case "update number of floors":
          {
            if (attribute.values.length > 0) {
              try {
                const levels = parseInt(attribute.values[0]);
                this.updateFloors(levels).then((count) => {
                  attribute.values[0] = `${count}`;
                  this.appointment?.changed$.next();
                });
              } catch {
              }
            }
          }
          break;
        case "update number of structures":
          {
            if (attribute.values.length > 0) {
              try {
                const structures = parseInt(attribute.values[0]);
                this.updateStructures(structures).then((count) => {
                  attribute.values[0] = `${count}`;
                  this.appointment?.changed$.next();
                });
              } catch {
              }
            }
          }
          break;
        case "update entity name":
          {
            if (attribute.values[0] != null) {
              this.entity.name = attribute.values[0];
            } else {
              this.entity.name = this.entity.type;
            }
          }
          break;
      }
      if (this.appointment != null) {
        this.appointment.changed$.next();
      }
    }
  }
  initAttributes() {
  }
  // #endregion
  // #region Property
  get property() {
    return this.appointment?.property?.entity;
  }
  updateUnits(numUnits) {
    return new Promise((res, rej) => {
      if (this.property != null && this.availableUnit != null) {
        const units = this.property.entities;
        if (units.length < numUnits) {
          const delta = numUnits - units.length;
          for (var i = 0; i < delta; i++) {
            const newUnit = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableUnit.entityId, this.availableUnit.type, "Unit", 1, this.availableUnit.attributes, [], new RenderDimensions(0, 0, 0, 0, 0), {}, [], [], [], void 0, void 0, {});
            this.property.entities.push(newUnit);
          }
          res(numUnits);
        } else if (units.length > numUnits) {
          this.uiService.prompt("Are you sure?", "Reducing the number of units will delete any excessive units you've already inspected.", "Yes, that's fine", "No, go back").subscribe({
            next: (confirmed) => {
              if (confirmed && this.appointment != null && this.property != null) {
                this.property.entities = this.property.entities.slice(0, numUnits);
                res(numUnits);
              } else {
                res(units.length);
              }
            }
          });
        }
      }
      this.appointment?.changed$.next();
    });
  }
  // #endregion
  // #region Floor
  get floor() {
    const entity = this.entity;
    if (entity?.type == PropertyEntityType.Floor) {
      return entity;
    }
    return void 0;
  }
  updateRooms(roomCount) {
    return new Promise((res, rej) => {
      if (this.floor != null && this.appointment != null && this.availableRoom != null) {
        const rooms = this.floor.entities;
        const attributes = this.uiService.deepClone(this.availableRoom.attributes);
        const mappedAttributes = this.appointmentService.mapAttributes(attributes);
        if (rooms.length < roomCount) {
          const delta = roomCount - rooms.length;
          const width = 200;
          const height = 200;
          for (var i = 0; i < delta; i++) {
            const x = 15 + 225 * i;
            const y = 15;
            const roomCount2 = this.appointment.getRoomTypeCount("bathroom", this.appointment?.property?.entity?.entities) + 1;
            const newRoom = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableRoom.entityId, this.availableRoom.type, "Bathroom", roomCount2, mappedAttributes, [], new RenderDimensions(x, y, width, height, 0), {}, [], [], [], void 0, void 0, {});
            this.floor.entities.push(newRoom);
          }
          res(roomCount);
        } else if (rooms.length > roomCount) {
          this.uiService.prompt("Are you sure?", "Reducing the number of rooms will delete any excessive rooms on this floor you've already inspected.", "Yes, that's fine", "No, go back").subscribe({
            next: (confirmed) => {
              if (confirmed && this.appointment != null && this.floor != null) {
                this.floor.entities = this.floor.entities.slice(0, roomCount);
                res(roomCount);
              } else {
                res(rooms.length);
              }
            }
          });
        }
      }
      this.appointment?.changed$.next();
    });
  }
  // #endregion
  // #region Units
  get unit() {
    const entity = this.entity;
    if (entity?.type == PropertyEntityType.Unit) {
      return entity;
    }
    return void 0;
  }
  updateStructures(numStructures) {
    return new Promise((res, rej) => {
      if (this.unit != null && this.availableStructure != null) {
        const structures = this.unit.entities;
        if (structures.length < numStructures) {
          const delta = numStructures - structures.length;
          for (var i = 0; i < delta; i++) {
            let x = 50;
            let y = 50;
            let height = 300;
            let width = 300;
            if (this.renderElm != null) {
              width = this.renderElm.offsetWidth / 2.5;
              height = width;
              x = Math.floor(Math.random() * (this.renderElm.offsetWidth - 400 - 50 + 1)) + 50;
              y = Math.floor(Math.random() * (this.renderElm.offsetHeight - 400 - 50 + 1)) + 50;
            }
            const newStructure = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableStructure.entityId, this.availableStructure.type, "New Structure", 1, this.availableStructure.attributes, [], new RenderDimensions(x, y, width, height, 0), {}, [], [], [], void 0, void 0, {});
            this.unit.entities.push(newStructure);
          }
          res(numStructures);
        } else if (structures.length > numStructures) {
          this.uiService.prompt("Are you sure?", "Reducing the number of structures will delete any excessive structures on this floor you've already inspected.", "Yes, that's fine", "No, go back").subscribe({
            next: (confirmed) => {
              if (confirmed && this.appointment != null && this.unit != null) {
                this.unit.entities = this.unit.entities.slice(0, numStructures);
                res(numStructures);
              } else {
                res(structures.length);
              }
            }
          });
        }
      }
      this.appointment?.changed$.next();
    });
  }
  // #endregion
  // #region Structure
  get structure() {
    const entity = this.entity;
    if (entity?.type == PropertyEntityType.Structure) {
      return entity;
    }
    return void 0;
  }
  updateFloors(levels) {
    return new Promise((res, rej) => {
      if (this.structure != null && this.availableFloor != null) {
        const floors = this.structure.entities;
        if (floors.length < levels) {
          const delta = levels - floors.length;
          for (var i = 0; i < delta; i++) {
            const newFloor = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableFloor.entityId, this.availableFloor.type, "New Floor", 1, this.availableFloor.attributes, [], new RenderDimensions(0, 0, 0, 0, 0), {}, [], [], [], void 0, void 0, {});
            this.structure.entities.push(newFloor);
          }
        } else if (floors.length > levels) {
          this.uiService.prompt("Are you sure?", "Reducing the number of floors will delete any excessive floors on this floor you've already inspected.", "Yes, that's fine", "No, go back").subscribe({
            next: (confirmed) => {
              if (confirmed && this.appointment != null && this.structure != null) {
                this.structure.entities = this.structure.entities.slice(0, levels);
                res(levels);
              } else {
                res(floors.length);
              }
            }
          });
        }
      }
      this.appointment?.changed$.next();
    });
  }
  init() {
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_AttributesComponent.\u0275fac = function AttributesComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _AttributesComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_AttributesComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _AttributesComponent, selectors: [["attributes"]], viewQuery: function AttributesComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", availableFloor: "availableFloor", availableRoom: "availableRoom", availableStructure: "availableStructure", availableUnit: "availableUnit", availableEntities: "availableEntities", availableFixtures: "availableFixtures", entity: "entity", attributes: "attributes", renderElm: "renderElm" }, standalone: false, decls: 4, vars: 3, consts: [["inputElm", ""], ["optionElm", ""], [1, "form"], [1, "input-wrap", 3, "disabled", "hidden"], [1, "input-wrap"], [1, "message"], [1, "input"], ["type", "number", 3, "disabled", "value", "placeholder"], ["type", "text", 3, "disabled", "value", "placeholder"], [1, "validation"], ["type", "number", 3, "input", "disabled", "value", "placeholder"], [1, "option", 3, "click", "disabled"], [1, "option", 3, "disabled", "checked"], ["type", "text", 3, "input", "disabled", "value", "placeholder"]], template: function AttributesComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 2);
    \u0275\u0275repeaterCreate(1, AttributesComponent_For_2_Template, 12, 13, "div", 3, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275pipe(3, "orderBy");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275repeater(\u0275\u0275pipeBind2(3, 0, ctx.attributes, "displayOrder"));
  }
}, dependencies: [OrderByPipe], styles: ["\n\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  width: 100%;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  display: block;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-size: 1vw;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .validation[_ngcontent-%COMP%] {\n  display: block;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .validation[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  padding: 0.25vw 0 0.5vw;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  margin-top: 0.25vw;\n  cursor: pointer;\n  padding: 0.25vw 0.5vw;\n  border-radius: 999px;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2);\n  text-align: center;\n  -moz-transition: background-color 0.2s, border-color 0.2s;\n  -o-transition: background-color 0.2s, border-color 0.2s;\n  -webkit-transition: background-color 0.2s, border-color 0.2s;\n  transition: background-color 0.2s, border-color 0.2s;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option.checked[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n  border-color: transparent;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option.checked[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  background-color: var(--color2Alt1);\n  padding: 1vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  background-color: var(--color2);\n  -moz-transition: background-color 0.2s, border-color 0.2s;\n  -o-transition: background-color 0.2s, border-color 0.2s;\n  -webkit-transition: background-color 0.2s, border-color 0.2s;\n  transition: background-color 0.2s, border-color 0.2s;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus, \n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.form[_ngcontent-%COMP%]    > .input-wrap.disabled[_ngcontent-%COMP%] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap.hidden[_ngcontent-%COMP%] {\n  display: none;\n}\n.form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.form[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.form.disabled[_ngcontent-%COMP%] {\n  opacity: 0.2;\n  -webkit-filter: blur(1vw);\n  -moz-filter: blur(1vw);\n  -o-filter: blur(1vw);\n  -ms-filter: blur(1vw);\n  filter: blur(1vw);\n}\n/*# sourceMappingURL=attributes.component.css.map */"] });
var AttributesComponent = _AttributesComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(AttributesComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "attributes", template: `<div class="form">
  @for (attribute of attributes | orderBy:'displayOrder'; track attribute) {
    <div class="input-wrap" [class.disabled]="attribute.disabled || !canModifyAppointment" [class.hidden]="attribute.shouldHide"
      >
      <label>{{attribute.name}}</label>
      @if (attribute.type == EntityAttributeType.MultiSelect) {
        <span class="message">
          <p>Can select multiple options.</p>
        </span>
      }
      @if (attribute.type == EntityAttributeType.Input
        || attribute.type == EntityAttributeType.Number) {
        @if (!attribute.valid) {
          <span class="validation">
            <p>Please answer the question.</p>
          </span>
        }
      }
      @if (attribute.type == EntityAttributeType.Select
        || attribute.type == EntityAttributeType.MultiSelect
        || attribute.type == EntityAttributeType.Boolean) {
        @if (!attribute.valid) {
          <span class="validation">
            <p>Please select an available option.</p>
          </span>
        }
      }
      <div class="input">
        @if (attribute.type == EntityAttributeType.Number) {
          <input type="number" [disabled]="attribute.disabled || !canModifyAppointment" #inputElm [value]="attribute.values[0]"
            (input)="setAttribute(attribute,inputElm.value)" [placeholder]="attribute.name + ' Number'" />
        }
        @if (attribute.type == EntityAttributeType.Boolean) {
          <button class="option" #optionElm [disabled]="attribute.disabled || !canModifyAppointment"
            (click)="setAttribute(attribute,'true')" [class.checked]="attribute.values.indexOf('true') > -1">
            <label>Yes</label>
          </button>
          <button class="option" #optionElm [disabled]="attribute.disabled || !canModifyAppointment"
            (click)="setAttribute(attribute,'false')" [class.checked]="attribute.values.indexOf('false') > -1">
            <label>No</label>
          </button>
        }
        @if (attribute.type == EntityAttributeType.MultiSelect) {
          @for (value of attribute.possibleValues; track value) {
            <button class="option" #optionElm [disabled]="attribute.disabled || !canModifyAppointment"
              (click)="setAttribute(attribute,value)" [class.checked]="attribute.values.indexOf(value) > -1"
              >
              <label>{{value}}</label>
            </button>
          }
        }
        @if (attribute.type == EntityAttributeType.Select) {
          @for (value of attribute.possibleValues; track value) {
            <button class="option" #optionElm [disabled]="attribute.disabled || !canModifyAppointment"
              (click)="setAttribute(attribute,value)" [class.checked]="attribute.values.indexOf(value) > -1"
              >
              <label>{{value}}</label>
            </button>
          }
        }
        @if (attribute.type == EntityAttributeType.Input) {
          <input type="text" [disabled]="attribute.disabled || !canModifyAppointment" #inputElm [value]="attribute.values[0] ?? null"
            (input)="setAttribute(attribute,inputElm.value)" [placeholder]="attribute.name" />
        }
      </div>
    </div>
  }
</div>`, styles: ["/* src/app/appointment/inspection/components/attributes/attributes.component.scss */\n.form > .input-wrap {\n  margin-top: 1vw;\n}\n.form > .input-wrap label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  width: 100%;\n}\n.form > .input-wrap > .message {\n  display: block;\n}\n.form > .input-wrap > .message > p {\n  color: var(--color1Alt3);\n  font-weight: var(--stdweight);\n  font-size: 1vw;\n}\n.form > .input-wrap > .validation {\n  display: block;\n}\n.form > .input-wrap > .validation > p {\n  color: var(--error);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n.form > .input-wrap > .input {\n  padding: 0.25vw 0 0.5vw;\n}\n.form > .input-wrap > .input > .option {\n  display: block;\n  width: 100%;\n  margin-top: 0.25vw;\n  cursor: pointer;\n  padding: 0.25vw 0.5vw;\n  border-radius: 999px;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2);\n  text-align: center;\n  -moz-transition: background-color 0.2s, border-color 0.2s;\n  -o-transition: background-color 0.2s, border-color 0.2s;\n  -webkit-transition: background-color 0.2s, border-color 0.2s;\n  transition: background-color 0.2s, border-color 0.2s;\n}\n.form > .input-wrap > .input > .option label {\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n.form > .input-wrap > .input > .option.checked {\n  background-color: var(--color3);\n  border-color: transparent;\n}\n.form > .input-wrap > .input > .option.checked label {\n  color: var(--color2);\n}\n.form > .input-wrap > .input > .option:first-child {\n  margin-top: 0;\n}\n.form > .input-wrap > .input select,\n.form > .input-wrap > .input input,\n.form > .input-wrap > .input textarea {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  background-color: var(--color2Alt1);\n  padding: 1vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  background-color: var(--color2);\n  -moz-transition: background-color 0.2s, border-color 0.2s;\n  -o-transition: background-color 0.2s, border-color 0.2s;\n  -webkit-transition: background-color 0.2s, border-color 0.2s;\n  transition: background-color 0.2s, border-color 0.2s;\n}\n.form > .input-wrap > .input select:focus,\n.form > .input-wrap > .input input:focus,\n.form > .input-wrap > .input textarea:focus {\n  background-color: var(--color2);\n  border-color: var(--color3);\n}\n.form > .input-wrap.disabled {\n  opacity: 0.75;\n  pointer-events: none;\n}\n.form > .input-wrap.hidden {\n  display: none;\n}\n.form > .input-wrap:first-child {\n  margin-top: 0;\n}\n.form:first-child {\n  margin-top: 0;\n}\n.form.disabled {\n  opacity: 0.2;\n  -webkit-filter: blur(1vw);\n  -moz-filter: blur(1vw);\n  -o-filter: blur(1vw);\n  -ms-filter: blur(1vw);\n  filter: blur(1vw);\n}\n/*# sourceMappingURL=attributes.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], availableFloor: [{
    type: Input,
    args: ["availableFloor"]
  }], availableRoom: [{
    type: Input,
    args: ["availableRoom"]
  }], availableStructure: [{
    type: Input,
    args: ["availableStructure"]
  }], availableUnit: [{
    type: Input,
    args: ["availableUnit"]
  }], availableEntities: [{
    type: Input,
    args: ["availableEntities"]
  }], availableFixtures: [{
    type: Input,
    args: ["availableFixtures"]
  }], entity: [{
    type: Input,
    args: ["entity"]
  }], attributes: [{
    type: Input,
    args: ["attributes"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], renderElm: [{
    type: Input,
    args: ["renderElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(AttributesComponent, { className: "AttributesComponent" });
})();

// src/app/appointment/inspection/components/standalone-attributes/standalone-attributes.component.ts
var _c02 = ["componentElm"];
gsapWithCSS.registerPlugin(Draggable);
var _StandaaloneAttributesComponent = class _StandaaloneAttributesComponent {
  constructor(localAppointmentService) {
    this.localAppointmentService = localAppointmentService;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.attributes = [];
    this.close = new Subject();
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get canClose() {
    if (!this.canModifyAppointment) {
      return true;
    } else {
      if (this.entity != null) {
        return !this.entity.hasInvalidAttributes;
      }
      return false;
    }
  }
  closeView() {
    return __async(this, null, function* () {
      this.close.next();
    });
  }
  init() {
  }
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_StandaaloneAttributesComponent.\u0275fac = function StandaaloneAttributesComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _StandaaloneAttributesComponent)(\u0275\u0275directiveInject(LocalAppointmentService));
};
_StandaaloneAttributesComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _StandaaloneAttributesComponent, selectors: [["standalone-attributes"]], viewQuery: function StandaaloneAttributesComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", availableFloor: "availableFloor", availableRoom: "availableRoom", availableStructure: "availableStructure", availableUnit: "availableUnit", availableEntities: "availableEntities", availableFixtures: "availableFixtures", entity: "entity", attributes: "attributes", headerLabel: "headerLabel", saveLabel: "saveLabel", renderElm: "renderElm" }, outputs: { close: "close" }, standalone: false, decls: 10, vars: 13, consts: [[1, "standalone-attributes"], [1, "content"], [3, "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "renderElm", "attributes"], [1, "controls"], [1, "control", 3, "click", "disabled"]], template: function StandaaloneAttributesComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "header")(2, "h2");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "div", 1);
    \u0275\u0275element(5, "attributes", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 3)(7, "button", 4);
    \u0275\u0275listener("click", function StandaaloneAttributesComponent_Template_button_click_7_listener() {
      return ctx.closeView();
    });
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9);
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.headerLabel);
    \u0275\u0275advance(2);
    \u0275\u0275property("appointment", ctx.appointment)("entity", ctx.entity)("availableEntities", ctx.availableEntities)("availableFixtures", ctx.availableFixtures)("availableFloor", ctx.availableFloor)("availableRoom", ctx.availableRoom)("availableUnit", ctx.availableUnit)("availableStructure", ctx.availableStructure)("renderElm", ctx.renderElm)("attributes", ctx.attributes);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", !ctx.canClose);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx.saveLabel, " ");
  }
}, dependencies: [AttributesComponent], styles: ["\n\n.standalone-attributes[_ngcontent-%COMP%] {\n  padding: 1vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n}\n.standalone-attributes[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.standalone-attributes[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  height: 100%;\n  margin-top: 1vw;\n  padding: 1vw 0;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  overflow-x: hidden;\n}\n.standalone-attributes[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n.standalone-attributes[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  cursor: pointer;\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  background-color: var(--success);\n  text-align: center;\n}\n.standalone-attributes[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.standalone-attributes[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n/*# sourceMappingURL=standalone-attributes.component.css.map */"] });
var StandaaloneAttributesComponent = _StandaaloneAttributesComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(StandaaloneAttributesComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "standalone-attributes", template: '<div class="standalone-attributes">\n    <header>\n        <h2>{{headerLabel}}</h2>\n    </header>\n    <div class="content">\n        <attributes\n            [appointment]="appointment"\n            [entity]="entity"\n            [availableEntities]="availableEntities"\n            [availableFixtures]="availableFixtures"\n            [availableFloor]="availableFloor"\n            [availableRoom]="availableRoom"\n            [availableUnit]="availableUnit"\n            [availableStructure]="availableStructure"\n            [renderElm]="renderElm"\n            [attributes]="attributes"></attributes>\n    </div>\n    <div class="controls">\n        <button class="control" (click)="closeView()" [disabled]="!canClose">\n            <label>\n                {{saveLabel}}\n            </label>\n        </button>\n    </div>\n</div>', styles: ["/* src/app/appointment/inspection/components/standalone-attributes/standalone-attributes.component.scss */\n.standalone-attributes {\n  padding: 1vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: flex;\n  flex-direction: column;\n}\n.standalone-attributes > header h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.standalone-attributes > .content {\n  flex: 1;\n  height: 100%;\n  margin-top: 1vw;\n  padding: 1vw 0;\n  border-top: 0.1vw var(--color2Alt2) solid;\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  overflow-x: hidden;\n}\n.standalone-attributes > .controls {\n  margin-top: 1vw;\n}\n.standalone-attributes > .controls > .control {\n  display: block;\n  width: 100%;\n  cursor: pointer;\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  background-color: var(--success);\n  text-align: center;\n}\n.standalone-attributes > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.standalone-attributes > .controls > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n/*# sourceMappingURL=standalone-attributes.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }], { appointment: [{
    type: Input
  }], availableFloor: [{
    type: Input,
    args: ["availableFloor"]
  }], availableRoom: [{
    type: Input,
    args: ["availableRoom"]
  }], availableStructure: [{
    type: Input,
    args: ["availableStructure"]
  }], availableUnit: [{
    type: Input,
    args: ["availableUnit"]
  }], availableEntities: [{
    type: Input,
    args: ["availableEntities"]
  }], availableFixtures: [{
    type: Input,
    args: ["availableFixtures"]
  }], entity: [{
    type: Input,
    args: ["entity"]
  }], attributes: [{
    type: Input,
    args: ["attributes"]
  }], headerLabel: [{
    type: Input,
    args: ["headerLabel"]
  }], saveLabel: [{
    type: Input,
    args: ["saveLabel"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], renderElm: [{
    type: Input,
    args: ["renderElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(StandaaloneAttributesComponent, { className: "StandaaloneAttributesComponent" });
})();

// src/app/appointment/inspection/components/photo/photo.component.ts
function PhotoComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 1);
  }
}
function PhotoComponent_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "img", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("src", ctx_r0.src, \u0275\u0275sanitizeUrl);
  }
}
gsapWithCSS.registerPlugin(Draggable);
var _PhotoComponent = class _PhotoComponent {
  constructor() {
  }
  setPhotoSrc() {
    if (this.photo != null) {
      this.src = this.photo;
    }
  }
  init() {
    this.setPhotoSrc();
  }
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_PhotoComponent.\u0275fac = function PhotoComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PhotoComponent)();
};
_PhotoComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PhotoComponent, selectors: [["photo"]], inputs: { photo: "photo" }, standalone: false, decls: 3, vars: 2, consts: [[1, "render"], [1, "fa-regular", "fa-image-slash"], [3, "src"]], template: function PhotoComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0);
    \u0275\u0275conditionalCreate(1, PhotoComponent_Conditional_1_Template, 1, 0, "i", 1);
    \u0275\u0275conditionalCreate(2, PhotoComponent_Conditional_2_Template, 1, 1, "img", 2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.src == null ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.src != null ? 2 : -1);
  }
}, styles: ["\n\n.render[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  position: relative;\n  background-color: var(--color2Alt1);\n}\n.render[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 2vw;\n  color: var(--color2Alt2);\n}\n.render[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n  width: 100%;\n  height: 100%;\n}\n/*# sourceMappingURL=photo.component.css.map */"] });
var PhotoComponent = _PhotoComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PhotoComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "photo", template: '<div class="render">\n  @if (src == null) {\n    <i class="fa-regular fa-image-slash"></i>\n  }\n  @if (src != null) {\n    <img [src]="src" />\n  }\n</div>', styles: ["/* src/app/appointment/inspection/components/photo/photo.component.scss */\n.render {\n  height: 100%;\n  width: 100%;\n  position: relative;\n  background-color: var(--color2Alt1);\n}\n.render > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 2vw;\n  color: var(--color2Alt2);\n}\n.render img {\n  -webkit-object-fit: cover;\n  -moz-object-fit: cover;\n  -o-background-size: cover;\n  object-fit: cover;\n  width: 100%;\n  height: 100%;\n}\n/*# sourceMappingURL=photo.component.css.map */\n"] }]
  }], () => [], { photo: [{
    type: Input
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PhotoComponent, { className: "PhotoComponent" });
})();

// src/app/appointment/inspection/components/fixture/fixture.component.ts
var _c03 = ["componentElm"];
function FixtureComponent_Conditional_0_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13)(1, "h4");
    \u0275\u0275text(2, "Missing Information");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" Please take at least 1 photo of your ", ctx_r2.fixture.name, ". ");
  }
}
function FixtureComponent_Conditional_0_For_15_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 14)(1, "button", 10);
    \u0275\u0275listener("click", function FixtureComponent_Conditional_0_For_15_Template_button_click_1_listener() {
      const photo_r5 = \u0275\u0275restoreView(_r4).$implicit;
      const ctx_r2 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r2.deletePhoto(photo_r5));
    });
    \u0275\u0275element(2, "i", 22);
    \u0275\u0275elementEnd();
    \u0275\u0275element(3, "canvas", 23);
    \u0275\u0275elementStart(4, "photo", 24);
    \u0275\u0275listener("click", function FixtureComponent_Conditional_0_For_15_Template_photo_click_4_listener() {
      const photo_r5 = \u0275\u0275restoreView(_r4).$implicit;
      const ctx_r2 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r2.viewPhoto(photo_r5));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const photo_r5 = ctx.$implicit;
    const ctx_r2 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r2.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275property("photo", photo_r5);
  }
}
function FixtureComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 1)(1, "div", 7)(2, "div", 8)(3, "div", 9)(4, "header")(5, "div", 4)(6, "button", 10);
    \u0275\u0275listener("click", function FixtureComponent_Conditional_0_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r2 = \u0275\u0275reference(11);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.selectMedia(photoElm_r2));
    });
    \u0275\u0275element(7, "i", 11);
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Add Photo(s)");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "input", 12, 0);
    \u0275\u0275listener("input", function FixtureComponent_Conditional_0_Template_input_input_10_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r2 = \u0275\u0275reference(11);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.selectFile(photoElm_r2));
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(12, "div", 9);
    \u0275\u0275conditionalCreate(13, FixtureComponent_Conditional_0_Conditional_13_Template, 5, 1, "div", 13);
    \u0275\u0275repeaterCreate(14, FixtureComponent_Conditional_0_For_15_Template, 5, 2, "div", 14, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(16, "div", 15)(17, "div", 9)(18, "header")(19, "h2");
    \u0275\u0275text(20);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(21, "div", 9)(22, "div", 16);
    \u0275\u0275element(23, "attributes", 17);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(24, "div", 18)(25, "div", 19)(26, "label");
    \u0275\u0275text(27, "Notes for the Customer");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "textarea", 20);
    \u0275\u0275listener("input", function FixtureComponent_Conditional_0_Template_textarea_input_28_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateNotes(ctx_r2.NoteAudience.Customer));
    });
    \u0275\u0275twoWayListener("ngModelChange", function FixtureComponent_Conditional_0_Template_textarea_ngModelChange_28_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r2 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r2.customerNotes, $event) || (ctx_r2.customerNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(29, "div", 19)(30, "label");
    \u0275\u0275text(31, "Notes for the Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "textarea", 21);
    \u0275\u0275listener("input", function FixtureComponent_Conditional_0_Template_textarea_input_32_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateNotes(ctx_r2.NoteAudience.Shop));
    });
    \u0275\u0275twoWayListener("ngModelChange", function FixtureComponent_Conditional_0_Template_textarea_ngModelChange_32_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r2 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r2.shopNotes, $event) || (ctx_r2.shopNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()()()();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", !ctx_r2.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275property("accept", \u0275\u0275interpolate(ctx_r2.acceptFileTypes));
    \u0275\u0275advance(3);
    \u0275\u0275conditional(!ctx_r2.hasPhotos ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r2.photos);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate2("", ctx_r2.fixture.name, " ", ctx_r2.fixture.number, " Details");
    \u0275\u0275advance(3);
    \u0275\u0275property("appointment", ctx_r2.appointment)("entity", ctx_r2.fixture)("availableEntities", ctx_r2.availableEntities)("availableFixtures", ctx_r2.availableFixtures)("availableFloor", ctx_r2.availableFloor)("availableRoom", ctx_r2.availableFloor)("availableStructure", ctx_r2.availableStructure)("attributes", ctx_r2.attributes);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx_r2.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r2.customerNotes);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r2.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r2.shopNotes);
  }
}
function FixtureComponent_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Save & Close ", ctx_r2.fixture == null ? null : ctx_r2.fixture.name);
  }
}
function FixtureComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r2 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Close ", ctx_r2.fixture == null ? null : ctx_r2.fixture.name);
  }
}
var _FixtureComponent = class _FixtureComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.NoteAudience = NoteAudience;
    this.customerNotes = "";
    this.shopNotes = "";
    this.acceptFileTypes = "*.jpg,*.png,*.webp";
    this.acceptMimeTypes = ["image/jpeg", "image/jpg", "image/png", "image/webp"];
    this.photos = [];
    this.close = new Subject();
    this.deleted = new Subject();
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  update() {
    if (this.appointment != null) {
      this.appointment.changed$.next();
    }
  }
  updateNotes(type) {
    if (this.fixture != null) {
      switch (type) {
        case NoteAudience.Customer:
          this.fixture.notes[NoteAudience.Customer] = this.customerNotes;
          break;
        case NoteAudience.Shop:
          this.fixture.notes[NoteAudience.Shop] = this.shopNotes;
          break;
      }
      this.update();
    }
  }
  initNotes() {
    if (this.fixture != null) {
      this.customerNotes = this.fixture.notes[NoteAudience.Customer] ?? "";
      this.shopNotes = this.fixture.notes[NoteAudience.Shop] ?? "";
    }
  }
  get hasPhotos() {
    return this.photos.length > 0;
  }
  get viewingPhoto() {
    return this.localAppointmentService.viewingPhoto;
  }
  get photoSrc() {
    return this.localAppointmentService.photoSrc;
  }
  matchesMimeType(mimeType) {
    let i = this.acceptMimeTypes.length;
    while (i--) {
      const acceptMimeType = this.acceptMimeTypes[i];
      if (acceptMimeType == mimeType) {
        return true;
      }
    }
    return false;
  }
  setFile(deviceBlob, photos) {
    if (deviceBlob != null && this.matchesMimeType(deviceBlob.type)) {
      const url = URL.createObjectURL(deviceBlob);
      const srcImage = new Image();
      srcImage.onload = () => {
        URL.revokeObjectURL(url);
        const offscreenCanvas = document.createElement("canvas");
        const ctx = offscreenCanvas.getContext("2d");
        if (ctx != null) {
          const ratio = srcImage.width / 1024;
          let width = srcImage.width;
          let height = srcImage.height;
          if (ratio > 1) {
            width = 1024;
            height = Math.round(srcImage.height / ratio);
          }
          offscreenCanvas.width = width;
          offscreenCanvas.height = height;
          ctx.drawImage(srcImage, 0, 0, width, height);
          const base64Image = offscreenCanvas.toDataURL("image/jpeg");
          this.fixture?.photos_B64.push(base64Image);
          this.initPhotos();
          if (this.appointment != null) {
            this.appointment.changed$.next();
          }
          this.initPhotos();
        }
      };
      srcImage.src = url;
    }
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.setFile(file, this.photos);
    } else {
      this.setFile(void 0, this.photos);
    }
  }
  selectMedia(fileInputElm) {
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  deletePhoto(src) {
    if (this.fixture != null) {
      this.uiService.prompt("Delete Photo?", "Are you sure you want to delete this photo?", "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed && this.fixture != null) {
            for (var i = 0, len = this.fixture.photos.length; i < len; i++) {
              const photo = this.fixture.photos[i];
              if (photo.src == src) {
                this.fixture.photos.splice(i, 1);
                break;
              }
            }
            for (var i = 0, len = this.fixture.photos_B64.length; i < len; i++) {
              const photo = this.fixture.photos_B64[i];
              if (photo == src) {
                this.fixture.photos_B64.splice(i, 1);
                break;
              }
            }
            this.initPhotos();
            this.appointment?.changed$.next();
          }
        }
      });
    }
  }
  viewPhoto(photo) {
    this.localAppointmentService.viewPhoto(photo);
  }
  stopViewingPhoto() {
    this.localAppointmentService.stopViewingPhoto();
  }
  storePhotoMeta() {
    if (this.activePhoto != null) {
      if (this.photoName != null) {
        this.activePhoto.name = this.photoName;
      }
      if (this.photoNotes != null) {
        this.activePhoto.notes = this.photoNotes;
      }
    }
  }
  initPhotos() {
    const photos = [];
    if (this.fixture != null) {
      photos.push(...this.fixture.photos_B64);
      this.fixture.photos.forEach((photo) => {
        photos.push(photo.src);
      });
    }
    this.photos = photos;
  }
  // #endregion
  // #region Attributes
  get attributes() {
    return this.fixture?.attributes ?? [];
  }
  // #endregion
  // #region Removal
  removeFixture() {
    this.uiService.prompt(`Remove ${this.fixture?.name}`, `Are you sure you want to remove this ${this.fixture?.name}`, "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.deleted.next();
        }
      }
    });
  }
  get canClose() {
    if (!this.canModifyAppointment) {
      return true;
    } else {
      if (this.fixture != null) {
        return this.fixture.valid && this.hasPhotos;
      }
      return false;
    }
  }
  closeView() {
    this.close.next();
  }
  init() {
    this.initNotes();
    this.initPhotos();
    this.appointment?.changed$.next();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.fixtureSubscription?.unsubscribe();
  }
};
_FixtureComponent.\u0275fac = function FixtureComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FixtureComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_FixtureComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FixtureComponent, selectors: [["fixture"]], viewQuery: function FixtureComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", parent: "parent", availableFloor: "availableFloor", availableRoom: "availableRoom", availableStructure: "availableStructure", availableEntities: "availableEntities", availableFixtures: "availableFixtures", fixture: "fixture" }, outputs: { close: "close", deleted: "deleted" }, standalone: false, decls: 10, vars: 5, consts: [["photoElm", ""], ["id", "fixture"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", "warning", 3, "click"], [1, "control", "success", 3, "click", "disabled"], [1, "columns"], [1, "column", "photos"], [1, "content"], [1, "control", 3, "click", "disabled"], [1, "fa-regular", "fa-camera"], ["type", "file", 3, "input", "accept"], [1, "message"], [1, "photo"], [1, "fixture", "column"], [1, "attributes"], [3, "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure", "attributes"], [1, "notes"], [1, "note"], ["rows", "5", "placeholder", "If you have any notes for our customer, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["rows", "5", "placeholder", "If you have any notes important for the shop, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], [1, "fa-solid", "fa-trash-can"], ["width", "1", "height", "1"], [3, "click", "photo"]], template: function FixtureComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, FixtureComponent_Conditional_0_Template, 33, 18, "section", 1);
    \u0275\u0275elementStart(1, "nav", 2)(2, "div", 3)(3, "div", 4)(4, "button", 5);
    \u0275\u0275listener("click", function FixtureComponent_Template_button_click_4_listener() {
      return ctx.removeFixture();
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "button", 6);
    \u0275\u0275listener("click", function FixtureComponent_Template_button_click_7_listener() {
      return ctx.closeView();
    });
    \u0275\u0275conditionalCreate(8, FixtureComponent_Conditional_8_Template, 2, 1, "label");
    \u0275\u0275conditionalCreate(9, FixtureComponent_Conditional_9_Template, 2, 1, "label");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.fixture != null ? 0 : -1);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1("Remove ", ctx.fixture == null ? null : ctx.fixture.name);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canClose);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canModifyAppointment ? 8 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.canModifyAppointment ? 9 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel, AttributesComponent, PhotoComponent], styles: ['\n\n#fixture[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: auto;\n  right: 0;\n  bottom: 6vw;\n  width: 45vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%] {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0.75vw 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  justify-content: flex-end;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > i[_ngcontent-%COMP%], \n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  position: absolute;\n  visibility: hidden;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n  position: relative;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  z-index: 1;\n  top: 1vw;\n  background-color: var(--error);\n  border: 0.5vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  width: 90%;\n  padding: 0.75vw 1vw;\n  pointer-events: none;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  color: var(--color2);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-align: center;\n  line-height: 1.2;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%] {\n  width: 16vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color1-raw), 0.08);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--color2);\n  overflow: hidden;\n  border-radius: 100%;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   photo[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%] {\n  width: calc(100% - 16vw);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 1.5vw;\n  background-color: var(--color4Alt3);\n  border-left: 0.2vw var(--color4Alt4) solid;\n  justify-content: center;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt2);\n  padding: 1vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.fixture[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#fixture[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  border-left: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 9;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.warning[_ngcontent-%COMP%] {\n  background-color: var(--error);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.warning {\n  background-color: var(--errorAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n/*# sourceMappingURL=fixture.component.css.map */'] });
var FixtureComponent = _FixtureComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FixtureComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "fixture", template: '@if (fixture != null) {\n  <section id="fixture">\n    <div class="columns">\n      <div class="column photos">\n        <div class="content">\n          <header>\n            <div class="controls">\n              <button class="control" [disabled]="!canModifyAppointment" (click)="selectMedia(photoElm)">\n                <i class="fa-regular fa-camera"></i>\n                <label>Add Photo(s)</label>\n              </button>\n              <input #photoElm (input)="selectFile(photoElm)" type="file" accept="{{acceptFileTypes}}" />\n            </div>\n          </header>\n          <div class="content">\n            @if (!hasPhotos) {\n              <div class="message">\n                <h4>Missing Information</h4>\n                <p>\n                  Please take at least 1 photo of\n                  your {{fixture.name}}.\n                </p>\n              </div>\n            }\n            @for (photo of photos; track photo) {\n              <div class="photo">\n                <button class="control" [disabled]="!canModifyAppointment" (click)="deletePhoto(photo)">\n                  <i class="fa-solid fa-trash-can"></i>\n                </button>\n                <canvas width="1" height="1"></canvas>\n                <photo (click)="viewPhoto(photo)" [photo]="photo"></photo>\n              </div>\n            }\n          </div>\n        </div>\n      </div>\n      <div class="fixture column">\n        <div class="content">\n          <header>\n            <h2>{{fixture.name}} {{fixture.number}} Details</h2>\n          </header>\n          <div class="content">\n            <div class="attributes">\n              <attributes\n                [appointment]="appointment"\n                [entity]="fixture"\n                [availableEntities]="availableEntities"\n                [availableFixtures]="availableFixtures"\n                [availableFloor]="availableFloor"\n                [availableRoom]="availableFloor"\n                [availableStructure]="availableStructure"\n              [attributes]="attributes"></attributes>\n            </div>\n            <div class="notes">\n              <div class="note">\n                <label>Notes for the Customer</label>\n                <textarea\n                  [disabled]="!canModifyAppointment"\n                  rows="5"\n                  placeholder="If you have any notes for our customer, you can enter them here..."\n                  (input)="updateNotes(NoteAudience.Customer)"\n                [(ngModel)]="customerNotes"></textarea>\n              </div>\n              <div class="note">\n                <label>Notes for the Shop</label>\n                <textarea\n                  [disabled]="!canModifyAppointment"\n                  rows="5"\n                  placeholder="If you have any notes important for the shop, you can enter them here..."\n                  (input)="updateNotes(NoteAudience.Shop)"\n                [(ngModel)]="shopNotes"></textarea>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </section>\n}\n\n<nav id="mainNav">\n  <div class="island">\n    <div class="controls">\n      <button class="control warning" (click)="removeFixture()">\n        <label>Remove {{fixture?.name}}</label>\n      </button>\n      <button class="control success" [disabled]="!canClose" (click)="closeView()">\n        @if (canModifyAppointment) {\n          <label>Save & Close {{fixture?.name}}</label>\n        }\n        @if (!canModifyAppointment) {\n          <label>Close {{fixture?.name}}</label>\n        }\n      </button>\n    </div>\n  </div>\n</nav>', styles: ['/* src/app/appointment/inspection/components/fixture/fixture.component.scss */\n#fixture {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: auto;\n  right: 0;\n  bottom: 6vw;\n  width: 45vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#fixture .columns {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#fixture .columns > .column {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#fixture .columns > .column > .content {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#fixture .columns > .column > .content > header {\n  padding: 0.75vw 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  justify-content: flex-end;\n}\n#fixture .columns > .column > .content > header > h2 {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#fixture .columns > .column > .content > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#fixture .columns > .column > .content > header > .controls > .control {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#fixture .columns > .column > .content > header > .controls > .control > i,\n#fixture .columns > .column > .content > header > .controls > .control > label {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#fixture .columns > .column > .content > header > .controls > .control > i {\n  font-size: 1.2vw;\n}\n#fixture .columns > .column > .content > header > .controls > .control > label {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#fixture .columns > .column > .content > header > .controls > .control:active > i,\n#fixture .columns > .column > .content > header > .controls > .control:active > label {\n  color: var(--color5);\n}\n#fixture .columns > .column > .content > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#fixture .columns > .column > .content > header > .controls > input {\n  position: absolute;\n  visibility: hidden;\n}\n#fixture .columns > .column > .content > .content {\n  flex: 1;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n  position: relative;\n}\n#fixture .columns > .column > .content > .content > .message {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  z-index: 1;\n  top: 1vw;\n  background-color: var(--error);\n  border: 0.5vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  width: 90%;\n  padding: 0.75vw 1vw;\n  pointer-events: none;\n}\n#fixture .columns > .column > .content > .content > .message h4 {\n  font-size: 1.2vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#fixture .columns > .column > .content > .content > .message p {\n  margin-top: 0.5vw;\n  color: var(--color2);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-align: center;\n  line-height: 1.2;\n}\n#fixture .columns > .column > .content > .content > .control {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#fixture .columns > .column > .content > .content > .control > i {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#fixture .columns > .column > .content > .content > .control > label {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#fixture .columns > .column.photos {\n  width: 16vw;\n}\n#fixture .columns > .column.photos > .content > header {\n  background-color: rgba(var(--color1-raw), 0.08);\n}\n#fixture .columns > .column.photos > .content > .content > .photo {\n  margin-top: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n}\n#fixture .columns > .column.photos > .content > .content > .photo canvas {\n  width: 100%;\n}\n#fixture .columns > .column.photos > .content > .content > .photo > .control {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--color2);\n  overflow: hidden;\n  border-radius: 100%;\n}\n#fixture .columns > .column.photos > .content > .content > .photo > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n}\n#fixture .columns > .column.photos > .content > .content > .photo photo {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#fixture .columns > .column.photos > .content > .content > .photo:first-child {\n  margin-top: 0;\n}\n#fixture .columns > .column.fixture {\n  width: calc(100% - 16vw);\n}\n#fixture .columns > .column.fixture > .content > header {\n  padding: 1vw 1.5vw;\n  background-color: var(--color4Alt3);\n  border-left: 0.2vw var(--color4Alt4) solid;\n  justify-content: center;\n}\n#fixture .columns > .column.fixture > .content > header > h2 {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n}\n#fixture .columns > .column.fixture > .content > .content {\n  background-color: var(--color2Alt2);\n  padding: 1vw;\n}\n#fixture .columns > .column.fixture > .content > .content > .attributes {\n  margin-top: 1vw;\n}\n#fixture .columns > .column.fixture > .content > .content > .notes {\n  margin-top: 1vw;\n}\n#fixture .columns > .column.fixture > .content > .content > .notes > .note {\n  margin-top: 1vw;\n}\n#fixture .columns > .column.fixture > .content > .content > .notes > .note label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#fixture .columns > .column.fixture > .content > .content > .notes > .note textarea {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#fixture .columns > .column.fixture > .content > .content > .notes > .note:first-child {\n  margin-top: 0;\n}\n#fixture .columns > .column:first-child {\n  border-left: none;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 9;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.warning {\n  background-color: var(--error);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.warning {\n  background-color: var(--errorAlt4);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n/*# sourceMappingURL=fixture.component.css.map */\n'] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], parent: [{
    type: Input,
    args: ["parent"]
  }], availableFloor: [{
    type: Input,
    args: ["availableFloor"]
  }], availableRoom: [{
    type: Input,
    args: ["availableRoom"]
  }], availableStructure: [{
    type: Input,
    args: ["availableStructure"]
  }], availableEntities: [{
    type: Input,
    args: ["availableEntities"]
  }], availableFixtures: [{
    type: Input,
    args: ["availableFixtures"]
  }], fixture: [{
    type: Input,
    args: ["fixture"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }], deleted: [{
    type: Output,
    args: ["deleted"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FixtureComponent, { className: "FixtureComponent" });
})();

// src/app/appointment/inspection/components/fixtures/fixtures.component.ts
var _c04 = ["componentElm"];
function FixturesComponent_For_9_For_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 9, 0);
    \u0275\u0275listener("click", function FixturesComponent_For_9_For_6_Template_div_click_0_listener() {
      const fixture_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r2.selectFixture(fixture_r2));
    });
    \u0275\u0275elementStart(2, "div", 10);
    \u0275\u0275element(3, "canvas", 11)(4, "img", 12);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const fixture_r2 = ctx.$implicit;
    \u0275\u0275advance(4);
    \u0275\u0275property("src", fixture_r2.imageSrc_Base64, \u0275\u0275sanitizeUrl);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(fixture_r2.name);
  }
}
function FixturesComponent_For_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6)(1, "header")(2, "h3");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "div", 7);
    \u0275\u0275repeaterCreate(5, FixturesComponent_For_9_For_6_Template, 7, 2, "div", 8, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const category_r4 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(category_r4.name);
    \u0275\u0275advance();
    \u0275\u0275classProp("expanded", category_r4.active);
    \u0275\u0275advance();
    \u0275\u0275repeater(category_r4.fixtures);
  }
}
var _FixturesComponent = class _FixturesComponent {
  constructor(appointmentService, uiService) {
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.selectedFixture = new Subject();
    this.availableFixtures = [];
    this.close = new Subject();
  }
  selectFixture(fixture) {
    if (this.appointment != null) {
      const typeCount = this.appointment.getFixtureCount(fixture.imageSrc_Base64, this.appointment?.property?.entity?.entities) + 1;
      const attributes = this.uiService.deepClone(fixture.attributes);
      const mappedAttributes = this.appointmentService.mapAttributes(attributes);
      const newFixture = new AppointmentFixture(this.uiService.generateId(), fixture.entityId, fixture.name, fixture.imageSrc_Base64, typeCount, mappedAttributes, new RenderDimensions(0, 0, 0, 0, 0), [], [], {});
      this.selectedFixture.next(newFixture);
    }
  }
  initFixtures() {
    if (this.appointment != null) {
      this.appointment.availableFixtures.forEach((category) => {
        if (category.fixtures.length > 0) {
          this.availableFixtures.push(category);
        }
      });
    }
  }
  closeView() {
    this.close.next();
  }
  init() {
    this.initFixtures();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_FixturesComponent.\u0275fac = function FixturesComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FixturesComponent)(\u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_FixturesComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FixturesComponent, selectors: [["fixtures"]], viewQuery: function FixturesComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment" }, outputs: { selectedFixture: "selectedFixture", close: "close" }, standalone: false, decls: 10, vars: 0, consts: [["fixtureElm", ""], ["id", "fixtures"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "categories"], [1, "category"], [1, "fixtures"], [1, "fixture"], [1, "fixture", 3, "click"], [1, "image"], ["height", "1", "width", "1"], [3, "src"]], template: function FixturesComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1)(1, "header")(2, "h2");
    \u0275\u0275text(3, " Select a Fixture ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "div", 2)(5, "button", 3);
    \u0275\u0275listener("click", function FixturesComponent_Template_button_click_5_listener() {
      return ctx.closeView();
    });
    \u0275\u0275element(6, "i", 4);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(7, "div", 5);
    \u0275\u0275repeaterCreate(8, FixturesComponent_For_9_Template, 7, 3, "div", 6, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(8);
    \u0275\u0275repeater(ctx.availableFixtures);
  }
}, styles: ["\n\n#fixtures[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-y: scroll;\n}\n#fixtures[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw 2vw;\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#fixtures[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#fixtures[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#fixtures[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#fixtures[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n}\n#fixtures[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%] {\n  padding: 0 2vw 2vw;\n  margin-top: 1vw;\n  position: relative;\n  z-index: 0;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding-bottom: 0.5vw;\n  border-bottom: 0.1vw var(--color1) solid;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%] {\n  font-size: 0;\n  padding: 2vw 0;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: top;\n  width: calc(20% - 0.8vw);\n  font-size: 1rem;\n  margin-left: 1vw;\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  cursor: pointer;\n  padding: 1vw;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%] {\n  width: 75%;\n  margin: 0 auto;\n  position: relative;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  white-space: nowrap;\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  text-align: center;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%]:nth-child(-n+5) {\n  margin-top: 0;\n}\n#fixtures[_ngcontent-%COMP%]    > .categories[_ngcontent-%COMP%]    > .category[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]    > .fixture[_ngcontent-%COMP%]:nth-child(5n+1) {\n  margin-left: 0;\n}\n/*# sourceMappingURL=fixtures.component.css.map */"] });
var FixturesComponent = _FixturesComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FixturesComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "fixtures", template: '<div id="fixtures">\n  <header>\n    <h2>\n      Select a Fixture\n    </h2>\n    <div class="controls">\n      <button class="control" (click)="closeView()">\n        <i class="fa-solid fa-xmark"></i>\n      </button>\n    </div>\n  </header>\n  <div class="categories">\n    @for (category of availableFixtures; track category) {\n      <div class="category">\n        <header>\n          <h3>{{category.name}}</h3>\n        </header>\n        <div class="fixtures" [class.expanded]="category.active">\n          @for (fixture of category.fixtures; track fixture) {\n            <div class="fixture" (click)="selectFixture(fixture)" #fixtureElm\n              >\n              <div class="image">\n                <canvas height="1" width="1"></canvas>\n                <img [src]="fixture.imageSrc_Base64" />\n              </div>\n              <label>{{fixture.name}}</label>\n            </div>\n          }\n        </div>\n      </div>\n    }\n  </div>\n</div>', styles: ["/* src/app/appointment/inspection/components/fixtures/fixtures.component.scss */\n#fixtures {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-y: scroll;\n}\n#fixtures > header {\n  background-color: var(--color2Alt1);\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw 2vw;\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n}\n#fixtures > header > h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#fixtures > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#fixtures > header > .controls > .control {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#fixtures > header > .controls > .control > i {\n  font-size: 2vw;\n  color: var(--color1);\n}\n#fixtures > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#fixtures > .categories {\n  padding: 0 2vw 2vw;\n  margin-top: 1vw;\n  position: relative;\n  z-index: 0;\n}\n#fixtures > .categories > .category > header {\n  padding-bottom: 0.5vw;\n  border-bottom: 0.1vw var(--color1) solid;\n}\n#fixtures > .categories > .category > header h3 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#fixtures > .categories > .category > .fixtures {\n  font-size: 0;\n  padding: 2vw 0;\n}\n#fixtures > .categories > .category > .fixtures > .fixture {\n  display: inline-block;\n  vertical-align: top;\n  width: calc(20% - 0.8vw);\n  font-size: 1rem;\n  margin-left: 1vw;\n  margin-top: 1vw;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  cursor: pointer;\n  padding: 1vw;\n}\n#fixtures > .categories > .category > .fixtures > .fixture .image {\n  width: 75%;\n  margin: 0 auto;\n  position: relative;\n}\n#fixtures > .categories > .category > .fixtures > .fixture .image canvas {\n  width: 100%;\n}\n#fixtures > .categories > .category > .fixtures > .fixture .image img {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#fixtures > .categories > .category > .fixtures > .fixture > label {\n  white-space: nowrap;\n  margin-top: 0.5vw;\n  display: block;\n  width: 100%;\n  font-size: 1vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  text-align: center;\n}\n#fixtures > .categories > .category > .fixtures > .fixture:nth-child(-n+5) {\n  margin-top: 0;\n}\n#fixtures > .categories > .category > .fixtures > .fixture:nth-child(5n+1) {\n  margin-left: 0;\n}\n/*# sourceMappingURL=fixtures.component.css.map */\n"] }]
  }], () => [{ type: AppointmentService }, { type: UiService }], { appointment: [{
    type: Input
  }], selectedFixture: [{
    type: Output,
    args: ["selectedFixture"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FixturesComponent, { className: "FixturesComponent" });
})();

// src/app/appointment/inspection/components/fixture-render/fixture-render.component.ts
var _c05 = ["componentElm"];
function FixtureRenderComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 4)(1, "div", 5);
    \u0275\u0275element(2, "canvas", 6)(3, "img", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 8)(7, "div", 9);
    \u0275\u0275listener("mousedown", function FixtureRenderComponent_Conditional_1_Template_div_mousedown_7_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("touchstart", function FixtureRenderComponent_Conditional_1_Template_div_touchstart_7_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("mouseup", function FixtureRenderComponent_Conditional_1_Template_div_mouseup_7_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.rotateL($event));
    })("touchend", function FixtureRenderComponent_Conditional_1_Template_div_touchend_7_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.rotateL($event));
    });
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(8, "svg", 10);
    \u0275\u0275element(9, "path", 11);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(10, "div", 12);
    \u0275\u0275listener("mousedown", function FixtureRenderComponent_Conditional_1_Template_div_mousedown_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("touchstart", function FixtureRenderComponent_Conditional_1_Template_div_touchstart_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("mouseup", function FixtureRenderComponent_Conditional_1_Template_div_mouseup_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.rotateR($event));
    })("touchend", function FixtureRenderComponent_Conditional_1_Template_div_touchend_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.rotateR($event));
    });
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(11, "svg", 10);
    \u0275\u0275element(12, "path", 11);
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("moving", ctx_r1.fixture.moving);
    \u0275\u0275advance();
    \u0275\u0275styleProp("transform", ctx_r1.rotationTransform);
    \u0275\u0275advance(2);
    \u0275\u0275property("src", ctx_r1.fixture.imageSrc_Base64, \u0275\u0275sanitizeUrl);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r1.fixtureLabel);
  }
}
var _FixtureRenderComponent = class _FixtureRenderComponent {
  constructor(appointmentService, uiService) {
    this.appointmentService = appointmentService;
    this.uiService = uiService;
  }
  get fixtureLabel() {
    if (this.fixture?.name != null) {
      return `${this.fixture.name} ${this.fixture.number}`;
    }
    return "";
  }
  // #endregion
  // #region Rotation
  get rotationTransform() {
    if (this.fixture?.renderDimensions != null) {
      return `rotate(${this.fixture.renderDimensions.rotation}deg)`;
    }
    return "";
  }
  rotateL(e) {
    e.stopPropagation();
    e.preventDefault();
    if (this.fixture?.renderDimensions != null) {
      let newRotation = this.fixture.renderDimensions.rotation - 45;
      if (newRotation == -360) {
        newRotation = -0;
      }
      this.fixture.renderDimensions.rotation = newRotation;
    }
  }
  rotateR(e) {
    e.stopPropagation();
    e.preventDefault();
    if (this.fixture?.renderDimensions != null) {
      let newRotation = this.fixture.renderDimensions.rotation + 45;
      if (newRotation == 360) {
        newRotation = 0;
      }
      this.fixture.renderDimensions.rotation = newRotation;
    }
  }
  killEvent(e) {
    e.stopPropagation();
  }
  init() {
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_FixtureRenderComponent.\u0275fac = function FixtureRenderComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FixtureRenderComponent)(\u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_FixtureRenderComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _FixtureRenderComponent, selectors: [["fixture-render"]], viewQuery: function FixtureRenderComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c05, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { parent: "parent", fixture: "fixture" }, standalone: false, decls: 5, vars: 1, consts: [[1, "fixture", 3, "moving"], ["id", "filter", 1, "defs-only"], ["id", "moving", "color-interpolation-filters", "sRGB", "x", "0", "y", "0", "height", "100%", "width", "100%"], ["type", "matrix", "values", "0.95 0 0 0 0.05 \n              0.63 0 0 0 0.37  \n              0.45 0 0 0 0.55 \n              0    0 0 1 0"], [1, "fixture"], [1, "image"], ["height", "1", "width", "1"], ["draggable", "false", 3, "src"], [1, "rotation", "no-render"], [1, "rotate", "l", 3, "mousedown", "touchstart", "mouseup", "touchend"], ["id", "rotateIcon", "xmlns", "http://www.w3.org/2000/svg", "version", "1.1", "viewBox", "0 0 800 672.3"], ["d", "M565.8,527v145.3l234.2-234.2-234.2-234.2v147C289.8,330.1,66.9,186.4,12.6,0,4.4,28.4,0,57.9,0,88c0,227.7,247.7,415,565.8,439Z", 1, "path"], [1, "rotate", "r", 3, "mousedown", "touchstart", "mouseup", "touchend"]], template: function FixtureRenderComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275conditionalCreate(1, FixtureRenderComponent_Conditional_1_Template, 13, 6, "div", 0);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(2, "svg", 1)(3, "filter", 2);
    \u0275\u0275element(4, "feColorMatrix", 3);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.fixture != null ? 1 : -1);
  }
}, styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n.fixture[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.fixture[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%] {\n  width: 75%;\n  margin: 0 auto;\n  position: relative;\n}\n.fixture[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n.fixture[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.fixture[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  white-space: nowrap;\n  display: block;\n  font-size: var(--fixtureFontSize);\n  color: var(--color1);\n  font-weight: var(--strong);\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  bottom: 0;\n}\n.fixture[_ngcontent-%COMP%]    > .rotation[_ngcontent-%COMP%]   .rotate[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(50% - 1vw);\n  transform-origin: center center;\n  height: 1.4vw;\n  border: 0.1vw var(--color1) solid;\n  border-radius: 0.5vw;\n  cursor: pointer;\n  padding: 0.2vw;\n}\n.fixture[_ngcontent-%COMP%]    > .rotation[_ngcontent-%COMP%]   .rotate[_ngcontent-%COMP%]   svg[_ngcontent-%COMP%] {\n  height: 100%;\n}\n.fixture[_ngcontent-%COMP%]    > .rotation[_ngcontent-%COMP%]   .rotate[_ngcontent-%COMP%]   svg[_ngcontent-%COMP%]   .path[_ngcontent-%COMP%] {\n  fill: var(--color1);\n}\n.fixture[_ngcontent-%COMP%]    > .rotation[_ngcontent-%COMP%]   .rotate.l[_ngcontent-%COMP%] {\n  right: 100%;\n  -moz-transform: rotate(90deg);\n  -ms-transform: rotate(90deg);\n  -o-transform: rotate(90deg);\n  -webkit-transform: rotate(90deg);\n  transform: rotate(90deg);\n}\n.fixture[_ngcontent-%COMP%]    > .rotation[_ngcontent-%COMP%]   .rotate.r[_ngcontent-%COMP%] {\n  left: 100%;\n  -moz-transform: rotate(-90deg) scaleX(-1);\n  -ms-transform: rotate(-90deg) scaleX(-1);\n  -o-transform: rotate(-90deg) scaleX(-1);\n  -webkit-transform: rotate(-90deg) scaleX(-1);\n  transform: rotate(-90deg) scaleX(-1);\n}\n.fixture.moving[_ngcontent-%COMP%]   .image[_ngcontent-%COMP%] {\n  filter: url(#moving);\n}\n#filter[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  position: absolute;\n}\n/*# sourceMappingURL=fixture-render.component.css.map */"] });
var FixtureRenderComponent = _FixtureRenderComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FixtureRenderComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "fixture-render", template: '<ng-container>\n  @if (fixture != null) {\n    <div class="fixture"\n      [class.moving]="fixture.moving">\n      <div class="image" [style.transform]="rotationTransform">\n        <canvas height="1" width="1"></canvas>\n        <img draggable="false" [src]="fixture.imageSrc_Base64" />\n      </div>\n      <label>{{fixtureLabel}}</label>\n      <div class="rotation no-render">\n        <div class="rotate l"\n          (mousedown)="killEvent($event)"\n          (touchstart)="killEvent($event)"\n          (mouseup)="rotateL($event)"\n          (touchend)="rotateL($event)">\n          <svg id="rotateIcon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 800 672.3">\n            <path class="path"\n              d="M565.8,527v145.3l234.2-234.2-234.2-234.2v147C289.8,330.1,66.9,186.4,12.6,0,4.4,28.4,0,57.9,0,88c0,227.7,247.7,415,565.8,439Z" />\n          </svg>\n        </div>\n        <div class="rotate r"\n          (mousedown)="killEvent($event)"\n          (touchstart)="killEvent($event)"\n          (mouseup)="rotateR($event)"\n          (touchend)="rotateR($event)">\n          <svg id="rotateIcon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 800 672.3">\n            <path class="path"\n              d="M565.8,527v145.3l234.2-234.2-234.2-234.2v147C289.8,330.1,66.9,186.4,12.6,0,4.4,28.4,0,57.9,0,88c0,227.7,247.7,415,565.8,439Z" />\n          </svg>\n        </div>\n      </div>\n    </div>\n  }\n\n  <svg id="filter" class="defs-only">\n    <filter id="moving" color-interpolation-filters="sRGB" x="0" y="0" height="100%" width="100%">\n            <feColorMatrix type="matrix" values="0.95 0 0 0 0.05 \n              0.63 0 0 0 0.37  \n              0.45 0 0 0 0.55 \n              0    0 0 1 0" />\n    </filter>\n  </svg>\n</ng-container>', styles: ["/* src/app/appointment/inspection/components/fixture-render/fixture-render.component.scss */\n@-webkit-keyframes loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes loadIn {\n  0% {\n    -moz-transform: scale(5);\n    -ms-transform: scale(5);\n    -o-transform: scale(5);\n    -webkit-transform: scale(5);\n    transform: scale(5);\n  }\n  100% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n.fixture {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.fixture .image {\n  width: 75%;\n  margin: 0 auto;\n  position: relative;\n}\n.fixture .image canvas {\n  width: 100%;\n}\n.fixture .image img {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.fixture > label {\n  white-space: nowrap;\n  display: block;\n  font-size: var(--fixtureFontSize);\n  color: var(--color1);\n  font-weight: var(--strong);\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  bottom: 0;\n}\n.fixture > .rotation .rotate {\n  position: absolute;\n  top: calc(50% - 1vw);\n  transform-origin: center center;\n  height: 1.4vw;\n  border: 0.1vw var(--color1) solid;\n  border-radius: 0.5vw;\n  cursor: pointer;\n  padding: 0.2vw;\n}\n.fixture > .rotation .rotate svg {\n  height: 100%;\n}\n.fixture > .rotation .rotate svg .path {\n  fill: var(--color1);\n}\n.fixture > .rotation .rotate.l {\n  right: 100%;\n  -moz-transform: rotate(90deg);\n  -ms-transform: rotate(90deg);\n  -o-transform: rotate(90deg);\n  -webkit-transform: rotate(90deg);\n  transform: rotate(90deg);\n}\n.fixture > .rotation .rotate.r {\n  left: 100%;\n  -moz-transform: rotate(-90deg) scaleX(-1);\n  -ms-transform: rotate(-90deg) scaleX(-1);\n  -o-transform: rotate(-90deg) scaleX(-1);\n  -webkit-transform: rotate(-90deg) scaleX(-1);\n  transform: rotate(-90deg) scaleX(-1);\n}\n.fixture.moving .image {\n  filter: url(#moving);\n}\n#filter {\n  opacity: 0;\n  pointer-events: none;\n  position: absolute;\n}\n/*# sourceMappingURL=fixture-render.component.css.map */\n"] }]
  }], () => [{ type: AppointmentService }, { type: UiService }], { parent: [{
    type: Input,
    args: ["parent"]
  }], fixture: [{
    type: Input,
    args: ["fixture"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(FixtureRenderComponent, { className: "FixtureRenderComponent" });
})();

// src/app/appointment/inspection/components/room/room.component.ts
var _c06 = ["renderElm"];
var _c1 = ["componentElm"];
function RoomComponent_Conditional_0_For_28_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 45);
    \u0275\u0275text(1, " Missing Information ");
    \u0275\u0275elementEnd();
  }
}
function RoomComponent_Conditional_0_For_28_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 43, 2);
    \u0275\u0275listener("mouseup", function RoomComponent_Conditional_0_For_28_Template_div_mouseup_0_listener() {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectFixture(fixture_r4));
    })("touchend", function RoomComponent_Conditional_0_For_28_Template_div_touchend_0_listener() {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectFixture(fixture_r4));
    });
    \u0275\u0275elementStart(2, "fixture-render", 44);
    \u0275\u0275listener("touchstart", function RoomComponent_Conditional_0_For_28_Template_fixture_render_touchstart_2_listener($event) {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const fixtureElm_r5 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, fixtureElm_r5, fixture_r4));
    })("mousedown", function RoomComponent_Conditional_0_For_28_Template_fixture_render_mousedown_2_listener($event) {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const fixtureElm_r5 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, fixtureElm_r5, fixture_r4));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "footer");
    \u0275\u0275conditionalCreate(4, RoomComponent_Conditional_0_For_28_Conditional_4_Template, 2, 0, "p", 45);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const fixture_r4 = ctx.$implicit;
    \u0275\u0275styleProp("transform", fixture_r4.renderDimensions.transform);
    \u0275\u0275advance(2);
    \u0275\u0275property("fixture", fixture_r4);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!fixture_r4.valid ? 4 : -1);
  }
}
function RoomComponent_Conditional_0_Conditional_40_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 29)(1, "h4");
    \u0275\u0275text(2, "Missing Information");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" Please take at least 1 photo of your ", ctx_r1.room.name, ". ");
  }
}
function RoomComponent_Conditional_0_For_42_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 30)(1, "button", 16);
    \u0275\u0275listener("click", function RoomComponent_Conditional_0_For_42_Template_button_click_1_listener() {
      const photo_r8 = \u0275\u0275restoreView(_r7).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.deletePhoto(photo_r8));
    });
    \u0275\u0275element(2, "i", 46);
    \u0275\u0275elementEnd();
    \u0275\u0275element(3, "canvas", 47);
    \u0275\u0275elementStart(4, "photo", 48);
    \u0275\u0275listener("click", function RoomComponent_Conditional_0_For_42_Template_photo_click_4_listener() {
      const photo_r8 = \u0275\u0275restoreView(_r7).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.viewPhoto(photo_r8));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const photo_r8 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275property("photo", photo_r8);
  }
}
function RoomComponent_Conditional_0_Conditional_69_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "standalone-attributes", 49);
    \u0275\u0275listener("close", function RoomComponent_Conditional_0_Conditional_69_Template_standalone_attributes_close_0_listener() {
      \u0275\u0275restoreView(_r9);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.stopEditingAttributes());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275nextContext();
    const renderElm_r10 = \u0275\u0275reference(11);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("entity", ctx_r1.room)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableUnit", ctx_r1.availableUnit)("availableStructure", ctx_r1.availableStructure)("attributes", ctx_r1.attributes)("renderElm", renderElm_r10)("headerLabel", "Please Complete Room Details")("saveLabel", "Continue Inspecting Room");
  }
}
function RoomComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 12);
    \u0275\u0275listener("touchend", function RoomComponent_Conditional_0_Template_section_touchend_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopMoving($event));
    }, \u0275\u0275resolveWindow)("mouseup", function RoomComponent_Conditional_0_Template_section_mouseup_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopMoving($event));
    }, \u0275\u0275resolveWindow);
    \u0275\u0275elementStart(1, "div", 13)(2, "div", 14)(3, "div", 15)(4, "header")(5, "div", 6)(6, "button", 16);
    \u0275\u0275listener("click", function RoomComponent_Conditional_0_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectFixtures());
    });
    \u0275\u0275element(7, "i", 17);
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Add Fixture To Room");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(10, "div", 18, 0);
    \u0275\u0275listener("mousemove", function RoomComponent_Conditional_0_Template_div_mousemove_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.moveEntity($event));
    })("touchmove", function RoomComponent_Conditional_0_Template_div_touchmove_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.moveEntity($event));
    });
    \u0275\u0275elementStart(12, "div", 19);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(13, "svg", 20);
    \u0275\u0275element(14, "path", 21);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(15, "label");
    \u0275\u0275text(16, "Rear of Property");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(17, "svg", 20);
    \u0275\u0275element(18, "path", 21);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(19, "div", 22);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(20, "svg", 20);
    \u0275\u0275element(21, "path", 23);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(22, "label");
    \u0275\u0275text(23, "Front of Property");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(24, "svg", 20);
    \u0275\u0275element(25, "path", 23);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(26, "div", 24);
    \u0275\u0275listener("click", function RoomComponent_Conditional_0_Template_div_click_26_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.unselectFixture());
    }, \u0275\u0275resolveWindow);
    \u0275\u0275repeaterCreate(27, RoomComponent_Conditional_0_For_28_Template, 5, 4, "div", 25, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(29, "div", 26)(30, "div", 15)(31, "header")(32, "div", 6)(33, "button", 16);
    \u0275\u0275listener("click", function RoomComponent_Conditional_0_Template_button_click_33_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r6 = \u0275\u0275reference(38);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectMedia(photoElm_r6));
    });
    \u0275\u0275element(34, "i", 27);
    \u0275\u0275elementStart(35, "label");
    \u0275\u0275text(36, "Add Photo(s)");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(37, "input", 28, 1);
    \u0275\u0275listener("input", function RoomComponent_Conditional_0_Template_input_input_37_listener() {
      \u0275\u0275restoreView(_r1);
      const photoElm_r6 = \u0275\u0275reference(38);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectFile(photoElm_r6));
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(39, "div", 15);
    \u0275\u0275conditionalCreate(40, RoomComponent_Conditional_0_Conditional_40_Template, 5, 1, "div", 29);
    \u0275\u0275repeaterCreate(41, RoomComponent_Conditional_0_For_42_Template, 5, 2, "div", 30, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(43, "div", 31)(44, "div", 15)(45, "header")(46, "h2");
    \u0275\u0275text(47, " Inspecting ");
    \u0275\u0275elementStart(48, "span", 32);
    \u0275\u0275text(49);
    \u0275\u0275elementEnd();
    \u0275\u0275text(50);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(51, "div", 15)(52, "div", 33)(53, "h3");
    \u0275\u0275text(54, "Tip: Inspecting the Bathroom");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(55, "p");
    \u0275\u0275text(56, " Add fixtures and take photos of your bathroom. ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(57, "div", 34)(58, "div", 35)(59, "label");
    \u0275\u0275text(60, "Notes for the Customer");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(61, "textarea", 36);
    \u0275\u0275listener("input", function RoomComponent_Conditional_0_Template_textarea_input_61_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateNotes(ctx_r1.NoteAudience.Customer));
    });
    \u0275\u0275twoWayListener("ngModelChange", function RoomComponent_Conditional_0_Template_textarea_ngModelChange_61_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.customerNotes, $event) || (ctx_r1.customerNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(62, "div", 35)(63, "label");
    \u0275\u0275text(64, "Notes for the Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(65, "textarea", 37);
    \u0275\u0275listener("input", function RoomComponent_Conditional_0_Template_textarea_input_65_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateNotes(ctx_r1.NoteAudience.Shop));
    });
    \u0275\u0275twoWayListener("ngModelChange", function RoomComponent_Conditional_0_Template_textarea_ngModelChange_65_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.shopNotes, $event) || (ctx_r1.shopNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()()();
    \u0275\u0275elementStart(66, "aside", 38);
    \u0275\u0275element(67, "div", 10);
    \u0275\u0275elementStart(68, "div", 39);
    \u0275\u0275conditionalCreate(69, RoomComponent_Conditional_0_Conditional_69_Template, 1, 12, "standalone-attributes", 40);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(70, "aside", 41);
    \u0275\u0275element(71, "div", 10);
    \u0275\u0275elementStart(72, "fixtures", 42);
    \u0275\u0275listener("close", function RoomComponent_Conditional_0_Template_fixtures_close_72_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopSelectingFixtures());
    })("selectedFixture", function RoomComponent_Conditional_0_Template_fixtures_selectedFixture_72_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.addFixture($event));
    });
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(21);
    \u0275\u0275repeater(ctx_r1.fixtures);
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275property("accept", \u0275\u0275interpolate(ctx_r1.acceptFileTypes))("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(!ctx_r1.hasPhotos ? 40 : -1);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r1.photos);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate2("", ctx_r1.room.name, " ", ctx_r1.room.number);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" on the ", ctx_r1.parent == null ? null : ctx_r1.parent.name, " ");
    \u0275\u0275advance(11);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.customerNotes);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.shopNotes);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.editingAttributes);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.showAttributesUI ? 69 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.selectingFixture);
    \u0275\u0275advance(2);
    \u0275\u0275property("appointment", ctx_r1.appointment);
  }
}
function RoomComponent_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Save & Close ", ctx_r1.room == null ? null : ctx_r1.room.name);
  }
}
function RoomComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Close ", ctx_r1.room == null ? null : ctx_r1.room.name);
  }
}
function RoomComponent_Conditional_12_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "fixture", 50);
    \u0275\u0275listener("click", function RoomComponent_Conditional_12_Template_fixture_click_0_listener($event) {
      \u0275\u0275restoreView(_r11);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("close", function RoomComponent_Conditional_12_Template_fixture_close_0_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopEditingFixture());
    })("deleted", function RoomComponent_Conditional_12_Template_fixture_deleted_0_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.removeFixture());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("fixture", ctx_r1.selectedFixture)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableStructure", ctx_r1.availableStructure);
  }
}
var _RoomComponent = class _RoomComponent {
  constructor(localAppointmentService, appointmentService, uiService, inspectionService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.inspectionService = inspectionService;
    this.relWidth = 0;
    this.relHeight = 0;
    this.relX = 0;
    this.relY = 0;
    this.cursorPosition = {
      initialX: 0,
      initialY: 0,
      x: 0,
      y: 0,
      totalX: 0,
      totalY: 0
    };
    this.renderPosition = {
      offsetWidth: 0,
      offsetHeight: 0,
      offsetX: 0,
      offsetY: 0
    };
    this.editingFixture = false;
    this.selectingFixture = false;
    this.showDeleteFixturePrompt = false;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.NoteAudience = NoteAudience;
    this.customerNotes = "";
    this.shopNotes = "";
    this.editingAttributes = false;
    this.showAttributesUI = false;
    this.acceptFileTypes = "*.jpg,*.png,*.webp";
    this.acceptMimeTypes = ["image/jpeg", "image/jpg", "image/png", "image/webp"];
    this.photos = [];
    this.close = new Subject();
    this.deleted = new Subject();
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  update() {
    if (this.appointment != null) {
      this.appointment.changed$.next();
    }
  }
  colliding(newX, newWidth, newY, newHeight) {
    if (this.room != null) {
      for (var i = 0, len = this.room.entities.length; i < len; i++) {
        const entity = this.room.entities[i];
        const minX = entity.renderDimensions.x - newWidth;
        const minY = entity.renderDimensions.y - newHeight;
        const maxX = entity.renderDimensions.width + entity.renderDimensions.x;
        const maxY = entity.renderDimensions.height + entity.renderDimensions.y;
        if (newX > minX && newX < maxX && newY > minY && newY < maxY) {
          return true;
        }
      }
    }
    return false;
  }
  startMoving(e, elm, entity) {
    if (!entity.moving) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      this.cursorPosition.totalX = 0;
      this.cursorPosition.totalY = 0;
      if (isTouch) {
        this.cursorPosition.initialX = e.touches[0].clientX;
        this.cursorPosition.initialY = e.touches[0].clientY;
      } else {
        this.cursorPosition.initialX = e.clientX;
        this.cursorPosition.initialY = e.clientY;
      }
      this.renderPosition.offsetHeight = elm.offsetHeight;
      this.renderPosition.offsetWidth = elm.offsetWidth;
      this.renderPosition.offsetX = elm.offsetWidth / 2;
      this.renderPosition.offsetY = elm.offsetHeight / 2;
      this.movingEntity = entity;
    }
  }
  stopMoving(e) {
    return __async(this, null, function* () {
      if (this.movingEntity?.moving) {
        this.movingEntity.moving = false;
        this.render(50);
      }
      this.movingEntity = void 0;
      this.fixtures.forEach((fixture) => {
        fixture.moving = false;
      });
    });
  }
  moveEntity(e) {
    if (this.canModifyAppointment) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.movingEntity != null && !this.movingEntity.resizing) {
        if (this.cursorPosition.totalX > 3 || this.cursorPosition.totalX < -3 || this.cursorPosition.totalY > 3 || this.cursorPosition.totalY < -3) {
          this.movingEntity.moving = true;
        }
        if (isTouch) {
          this.cursorPosition.x = e.touches[0].clientX;
          this.cursorPosition.y = e.touches[0].clientY;
        } else {
          this.cursorPosition.x = e.clientX;
          this.cursorPosition.y = e.clientY;
        }
        const deltaX = this.cursorPosition.x - this.cursorPosition.initialX;
        const deltaY = this.cursorPosition.y - this.cursorPosition.initialY;
        let newX = this.movingEntity.renderDimensions.x + deltaX;
        let newY = this.movingEntity.renderDimensions.y + deltaY;
        const maxX = this.relWidth - this.renderPosition.offsetWidth;
        const maxY = this.relHeight - this.renderPosition.offsetHeight;
        if (newX < 0) {
          newX = 0;
        } else if (newX > maxX) {
          newX = maxX;
        }
        if (newY < 0) {
          newY = 0;
        } else if (newY > maxY) {
          newY = maxY;
        }
        const colliding = this.colliding(newX, this.renderPosition.offsetWidth, newY, this.renderPosition.offsetHeight);
        if (!colliding || this.movingEntity instanceof AppointmentPropertyEntity) {
          this.movingEntity.renderDimensions.x = newX;
          this.movingEntity.renderDimensions.y = newY;
          this.cursorPosition.initialX = this.cursorPosition.x;
          this.cursorPosition.initialY = this.cursorPosition.y;
          this.cursorPosition.totalX = this.cursorPosition.totalX + deltaX;
          this.cursorPosition.totalY = this.cursorPosition.totalX + deltaY;
        }
      }
    }
  }
  render(delayInMs = 50) {
    return new Promise((res, rej) => {
      window.clearTimeout(this.renderDebounce);
      this.renderDebounce = window.setTimeout(() => {
        const renderElm = this.renderElm?.nativeElement;
        const room = this.room;
        if (renderElm != null && room != null) {
          toPng(renderElm, {
            quality: 1,
            backgroundColor: "#fff",
            skipFonts: true,
            filter: (renderElm2) => {
              return !renderElm2.classList?.contains("no-render");
            }
          }).then((png) => {
            room.updateRender(png);
            this.appointment?.changed$.next();
            res();
          }).catch(() => {
            rej();
          });
        } else {
          rej();
        }
      }, delayInMs);
    });
  }
  initRender() {
    setTimeout(() => {
      const renderElm = this.renderElm?.nativeElement;
      if (renderElm != null) {
        const bounds = renderElm.getBoundingClientRect();
        this.relX = bounds.left;
        this.relY = bounds.top;
        this.relWidth = renderElm.offsetWidth;
        this.relHeight = renderElm.offsetHeight;
        this.initAttributes();
      }
    }, 250);
  }
  get fixtures() {
    return this.room?.fixtures ?? [];
  }
  removeFixture() {
    return __async(this, null, function* () {
      if (this.selectedFixture != null) {
        this.stopEditingFixture(false);
        for (var i = 0, len = this.fixtures.length; i < len; i++) {
          const fixture = this.fixtures[i];
          if (fixture.id == this.selectedFixture.id) {
            this.fixtures.splice(i, 1);
            this.selectedFixture = void 0;
            this.update();
            break;
          }
        }
        this.render(0);
      }
    });
  }
  stopSelectingFixtures() {
    this.selectingFixture = false;
  }
  selectFixtures() {
    this.selectingFixture = true;
  }
  selectFixture(fixture) {
    if (!fixture.moving && this.selectedFixture?.id != fixture.id) {
      if (this.selectedFixture?.id == fixture.id) {
        this.stopEditingFixture();
      } else {
        this.selectedFixture = fixture;
        this.editingFixture = true;
      }
    }
  }
  stopEditingFixture(showTip = true) {
    window.clearTimeout(this.editingFixtureTimer);
    this.editingFixture = false;
    this.editingFixtureTimer = window.setTimeout(() => {
      this.selectedFixture = void 0;
    }, 250);
  }
  unselectFixture() {
    this.stopEditingFixture();
  }
  addFixture(fixture) {
    return __async(this, null, function* () {
      if (this.room != null) {
        fixture.renderDimensions.x = this.relWidth / 2 - window.innerWidth * 0.02;
        fixture.renderDimensions.y = this.relHeight / 2 - window.innerWidth * 0.02;
        this.room.fixtures.push(fixture);
        this.stopSelectingFixtures();
        this.selectFixture(fixture);
        this.render(0);
      }
    });
  }
  promptToDeleteFixture(fixture) {
    this.fixtureToDelete = fixture;
    this.showDeleteFixturePrompt = true;
  }
  cancelDeletingFixture() {
    this.showDeleteFixturePrompt = false;
    this.fixtureToDelete = void 0;
  }
  updateNotes(type) {
    if (this.room != null) {
      switch (type) {
        case NoteAudience.Customer:
          this.room.notes[NoteAudience.Customer] = this.customerNotes;
          break;
        case NoteAudience.Shop:
          this.room.notes[NoteAudience.Shop] = this.shopNotes;
          break;
      }
      this.update();
    }
  }
  initNotes() {
    if (this.room != null) {
      this.customerNotes = this.room.notes[NoteAudience.Customer] ?? "";
      this.shopNotes = this.room.notes[NoteAudience.Shop] ?? "";
    }
  }
  get attributes() {
    return this.room?.attributes ?? [];
  }
  editAttributes() {
    this.editingAttributes = true;
    this.showAttributesUI = true;
  }
  stopEditingAttributes() {
    return __async(this, null, function* () {
      window.clearTimeout(this.attributesTimer);
      this.editingAttributes = false;
      this.attributesTimer = window.setTimeout(() => __async(this, null, function* () {
        this.showAttributesUI = false;
        this.render(0);
      }), 250);
    });
  }
  initAttributes() {
    if (this.room != null) {
      if (this.room.hasInvalidAttributes && this.canModifyAppointment) {
        this.editAttributes();
      }
    }
  }
  get hasPhotos() {
    return this.photos.length > 0;
  }
  get viewingPhoto() {
    return this.localAppointmentService.viewingPhoto;
  }
  get photoSrc() {
    return this.localAppointmentService.photoSrc;
  }
  matchesMimeType(mimeType) {
    let i = this.acceptMimeTypes.length;
    while (i--) {
      const acceptMimeType = this.acceptMimeTypes[i];
      if (acceptMimeType == mimeType) {
        return true;
      }
    }
    return false;
  }
  setFile(deviceBlob, photos) {
    if (deviceBlob != null && this.matchesMimeType(deviceBlob.type)) {
      const url = URL.createObjectURL(deviceBlob);
      const srcImage = new Image();
      srcImage.onload = () => {
        URL.revokeObjectURL(url);
        const offscreenCanvas = document.createElement("canvas");
        const ctx = offscreenCanvas.getContext("2d");
        if (ctx != null) {
          const ratio = srcImage.width / 1024;
          let width = srcImage.width;
          let height = srcImage.height;
          if (ratio > 1) {
            width = 1024;
            height = Math.round(srcImage.height / ratio);
          }
          offscreenCanvas.width = width;
          offscreenCanvas.height = height;
          ctx.drawImage(srcImage, 0, 0, width, height);
          const base64Image = offscreenCanvas.toDataURL("image/jpeg");
          this.room?.photos_B64.push(base64Image);
          this.initPhotos();
          if (this.appointment != null) {
            this.appointment.changed$.next();
          }
        }
      };
      srcImage.src = url;
    }
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.setFile(file, this.photos);
    } else {
      this.setFile(void 0, this.photos);
    }
  }
  selectMedia(fileInputElm) {
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  deletePhoto(src) {
    if (this.room != null) {
      this.uiService.prompt("Delete Photo?", "Are you sure you want to delete this photo?", "Yes", "No").subscribe({
        next: (confirmed) => {
          if (confirmed && this.room != null) {
            for (var i = 0, len = this.room.photos.length; i < len; i++) {
              const photo = this.room.photos[i];
              if (photo.src == src) {
                this.room.photos.splice(i, 1);
                break;
              }
            }
            for (var i = 0, len = this.room.photos_B64.length; i < len; i++) {
              const photo = this.room.photos_B64[i];
              if (photo == src) {
                this.room.photos_B64.splice(i, 1);
                break;
              }
            }
            this.initPhotos();
            this.appointment?.changed$.next();
          }
        }
      });
    }
  }
  viewPhoto(photo) {
    this.localAppointmentService.viewPhoto(photo);
  }
  stopViewingPhoto() {
    this.localAppointmentService.stopViewingPhoto();
  }
  storePhotoMeta() {
    if (this.activePhoto != null) {
      if (this.photoName != null) {
        this.activePhoto.name = this.photoName;
      }
      if (this.photoNotes != null) {
        this.activePhoto.notes = this.photoNotes;
      }
    }
  }
  initPhotos() {
    const photos = [];
    if (this.room != null) {
      photos.push(...this.room.photos_B64);
      this.room.photos.forEach((room) => {
        photos.push(room.src);
      });
    }
    this.photos = photos;
  }
  // #endregion
  // #region Removal
  removeRoom() {
    this.deleted.next();
  }
  killEvent(e) {
    e.stopPropagation();
  }
  get canClose() {
    if (!this.canModifyAppointment) {
      return true;
    } else {
      if (this.room != null) {
        return this.room.valid && this.hasPhotos;
      }
      return false;
    }
  }
  closeView() {
    return __async(this, null, function* () {
      this.render(0).finally(() => {
        this.close.next();
      });
    });
  }
  init() {
    this.initRender();
    this.initNotes();
    this.initPhotos();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_RoomComponent.\u0275fac = function RoomComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _RoomComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(InspectionService));
};
_RoomComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _RoomComponent, selectors: [["room"]], viewQuery: function RoomComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c06, 5);
    \u0275\u0275viewQuery(_c1, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.renderElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", parent: "parent", availableFloor: "availableFloor", availableRoom: "availableRoom", availableUnit: "availableUnit", availableStructure: "availableStructure", availableEntities: "availableEntities", availableFixtures: "availableFixtures", room: "room" }, outputs: { close: "close", deleted: "deleted" }, standalone: false, decls: 13, vars: 10, consts: [["renderElm", ""], ["photoElm", ""], ["fixtureElm", ""], ["id", "room"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click"], [1, "control", "success", 3, "click", "disabled"], ["id", "fixture"], [1, "bg"], [3, "appointment", "fixture", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure"], ["id", "room", 3, "touchend", "mouseup"], [1, "columns"], [1, "column", "diagram"], [1, "content"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-plus"], [1, "render", 3, "mousemove", "touchmove"], [1, "rear"], ["xmlns", "http://www.w3.org/2000/svg", "viewBox", "0 0 384 512"], ["d", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z"], [1, "front"], ["d", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"], [1, "fixtures", 3, "click"], [1, "fixture", 3, "transform"], [1, "column", "photos"], [1, "fa-regular", "fa-camera"], ["type", "file", 3, "input", "disabled", "accept"], [1, "message"], [1, "photo"], [1, "room", "column"], [1, "bathroom"], [1, "tooltip"], [1, "notes"], [1, "note"], ["rows", "5", "placeholder", "If you have any notes for our customer, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["rows", "5", "placeholder", "If you have any notes important for the shop, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["id", "standaloneAttributes"], [1, "attributes"], [3, "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "renderElm", "headerLabel", "saveLabel"], ["id", "fixtures"], [3, "close", "selectedFixture", "appointment"], [1, "fixture", 3, "mouseup", "touchend"], [3, "touchstart", "mousedown", "fixture"], [1, "warning", "no-render"], [1, "fa-solid", "fa-trash-can"], ["width", "1", "height", "1"], [3, "click", "photo"], [3, "close", "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "renderElm", "headerLabel", "saveLabel"], [3, "click", "close", "deleted", "appointment", "fixture", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure"]], template: function RoomComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, RoomComponent_Conditional_0_Template, 73, 19, "section", 3);
    \u0275\u0275elementStart(1, "nav", 4)(2, "div", 5)(3, "div", 6)(4, "button", 7);
    \u0275\u0275listener("click", function RoomComponent_Template_button_click_4_listener() {
      return ctx.editAttributes();
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "button", 8);
    \u0275\u0275listener("click", function RoomComponent_Template_button_click_7_listener() {
      return ctx.closeView();
    });
    \u0275\u0275conditionalCreate(8, RoomComponent_Conditional_8_Template, 2, 1, "label");
    \u0275\u0275conditionalCreate(9, RoomComponent_Conditional_9_Template, 2, 1, "label");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(10, "aside", 9);
    \u0275\u0275element(11, "div", 10);
    \u0275\u0275conditionalCreate(12, RoomComponent_Conditional_12_Template, 1, 7, "fixture", 11);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.room != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("hidden", ctx.editingFixture || ctx.editingAttributes);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1("Change ", ctx.room == null ? null : ctx.room.name, " Details");
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canClose);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canModifyAppointment ? 8 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.canModifyAppointment ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.editingFixture);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.selectedFixture != null ? 12 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel, StandaaloneAttributesComponent, PhotoComponent, FixtureComponent, FixturesComponent, FixtureRenderComponent], styles: ['\n\n#room[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 6vw;\n  right: 0;\n  bottom: 6vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%] {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  padding: 0.75vw 1.5vw 0.75vw 1.5vw;\n  display: flex;\n  justify-content: flex-end;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > i[_ngcontent-%COMP%], \n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  position: absolute;\n  visibility: hidden;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n  position: relative;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  z-index: 1;\n  top: 1vw;\n  background-color: var(--error);\n  border: 0.5vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  width: 90%;\n  padding: 0.75vw 1vw;\n  pointer-events: none;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  color: var(--color2);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-align: center;\n  line-height: 1.2;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%] {\n  width: calc(75% - 16vw);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  flex: 1;\n  background-color: var(--color2);\n  position: relative;\n  overflow: hidden;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%], \n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  display: flex;\n  align-items: center;\n  pointer-events: none;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%]    > svg[_ngcontent-%COMP%], \n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%]    > svg[_ngcontent-%COMP%] {\n  height: 1.2vw;\n  fill: var(--color1);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%], \n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin: 0 1vw;\n  font-size: 1.4vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  white-space: nowrap;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%] {\n  bottom: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%] {\n  top: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 2;\n  cursor: pointer;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  will-change: transform;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]   fixture-render[_ngcontent-%COMP%] {\n  display: block;\n  width: 8vw;\n  height: 9vw;\n  position: relative;\n  --fixtureFontSize: 1vw;\n  will-change: transform;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 0.9vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.diagram[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-style: italic;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%] {\n  width: 16vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color1-raw), 0.08);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--color2);\n  overflow: hidden;\n  border-radius: 100%;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]   photo[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.photos[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .photo[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%] {\n  width: 25%;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 1.5vw;\n  background-color: var(--color3Alt3);\n  border-left: 0.2vw var(--color3Alt4) solid;\n  justify-content: center;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%]    > .bathroom[_ngcontent-%COMP%] {\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt2);\n  padding: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%] {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n  line-height: 1;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.room[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#room[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  border-left: none;\n}\n#room[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#room[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#room[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#room[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#room[_ngcontent-%COMP%]   #fixtures[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color1-raw), 0.1);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#room[_ngcontent-%COMP%]   #fixtures[_ngcontent-%COMP%]    > fixtures[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 20%;\n  right: 20%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#room[_ngcontent-%COMP%]   #fixtures.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#room[_ngcontent-%COMP%]   #fixtures.active[_ngcontent-%COMP%]    > fixtures[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#room[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%] {\n  z-index: 2;\n}\n#room[_ngcontent-%COMP%]   .tooltip.general[_ngcontent-%COMP%] {\n  bottom: 1vw;\n  right: 1vw;\n  width: 22vw;\n}\n#room[_ngcontent-%COMP%]   .tooltip.general[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n}\n#room[_ngcontent-%COMP%]   .tooltip.general[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 9;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes _ngcontent-%COMP%_childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#fixture[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 6;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #fixture {\n  z-index: 7;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadOut;\n  animation-name: _ngcontent-%COMP%_childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #fixture {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadIn;\n  animation-name: _ngcontent-%COMP%_childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=room.component.css.map */'] });
var RoomComponent = _RoomComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(RoomComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "room", template: `@if (room != null) {
  <section id="room" (window:touchend)="stopMoving($event)" (window:mouseup)="stopMoving($event)">
    <div class="columns">
      <div class="column diagram">
        <div class="content">
          <header>
            <div class="controls">
              <button class="control" [disabled]="!canModifyAppointment" (click)="selectFixtures()">
                <i class="fa-solid fa-plus"></i>
                <label>Add Fixture To Room</label>
              </button>
            </div>
          </header>
          <div class="render" (mousemove)="moveEntity($event)" (touchmove)="moveEntity($event)" #renderElm>
            <div class="rear">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z" />
              </svg>
              <label>Rear of Property</label>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z" />
              </svg>
            </div>
            <div class="front">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z" />
              </svg>
              <label>Front of Property</label>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z" />
              </svg>
            </div>
            <div class="fixtures" (window:click)="unselectFixture()">
              @for (fixture of fixtures; track fixture) {
                <div class="fixture" #fixtureElm (mouseup)="selectFixture(fixture)"
                  (touchend)="selectFixture(fixture)"
                  [style.transform]="fixture.renderDimensions.transform">
                  <fixture-render [fixture]="fixture" (touchstart)="startMoving($event,fixtureElm,fixture)"
                  (mousedown)="startMoving($event,fixtureElm,fixture)"></fixture-render>
                  <footer>
                    @if (!fixture.valid) {
                      <p class="warning no-render">
                        Missing Information
                      </p>
                    }
                  </footer>
                </div>
              }
            </div>
          </div>
        </div>
      </div>
      <div class="column photos">
        <div class="content">
          <header>
            <div class="controls">
              <button class="control" [disabled]="!canModifyAppointment" (click)="selectMedia(photoElm)">
                <i class="fa-regular fa-camera"></i>
                <label>Add Photo(s)</label>
              </button>
              <input #photoElm [disabled]="!canModifyAppointment" (input)="selectFile(photoElm)" type="file" accept="{{acceptFileTypes}}" />
            </div>
          </header>
          <div class="content">
            @if (!hasPhotos) {
              <div class="message">
                <h4>Missing Information</h4>
                <p>
                  Please take at least 1 photo of
                  your {{room.name}}.
                </p>
              </div>
            }
            @for (photo of photos; track photo) {
              <div class="photo">
                <button class="control" [disabled]="!canModifyAppointment" (click)="deletePhoto(photo)">
                  <i class="fa-solid fa-trash-can"></i>
                </button>
                <canvas width="1" height="1"></canvas>
                <photo (click)="viewPhoto(photo)" [photo]="photo"></photo>
              </div>
            }
          </div>
        </div>
      </div>
      <div class="room column">
        <div class="content">
          <header>
            <h2>
              Inspecting
              <span class="bathroom">{{room.name}} {{room.number}}</span>
              on the
              {{parent?.name}}
            </h2>
          </header>
          <div class="content">
            <div class="tooltip">
              <h3>Tip: Inspecting the Bathroom</h3>
              <p>
                Add fixtures and take photos of your bathroom.
              </p>
            </div>
            <div class="notes">
              <div class="note">
                <label>Notes for the Customer</label>
                <textarea
                  [disabled]="!canModifyAppointment"
                  rows="5"
                  placeholder="If you have any notes for our customer, you can enter them here..."
                  (input)="updateNotes(NoteAudience.Customer)"
                [(ngModel)]="customerNotes"></textarea>
              </div>
              <div class="note">
                <label>Notes for the Shop</label>
                <textarea
                  [disabled]="!canModifyAppointment"
                  rows="5"
                  placeholder="If you have any notes important for the shop, you can enter them here..."
                  (input)="updateNotes(NoteAudience.Shop)"
                [(ngModel)]="shopNotes"></textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <aside id="standaloneAttributes" [class.active]="editingAttributes">
      <div class="bg"></div>
      <div class="attributes">
        @if (showAttributesUI) {
          <standalone-attributes
            [appointment]="appointment"
            [entity]="room"
            [availableEntities]="availableEntities"
            [availableFixtures]="availableFixtures"
            [availableFloor]="availableFloor"
            [availableRoom]="availableRoom"
            [availableUnit]="availableUnit"
            [availableStructure]="availableStructure"
            [attributes]="attributes"
            [renderElm]="renderElm"
            [headerLabel]="'Please Complete Room Details'"
            [saveLabel]="'Continue Inspecting Room'"
          (close)="stopEditingAttributes()"></standalone-attributes>
        }
      </div>
    </aside>
    <aside id="fixtures" [class.active]="selectingFixture">
      <div class="bg"></div>
      <fixtures [appointment]="appointment" (close)="stopSelectingFixtures()" (selectedFixture)="addFixture($event)">
      </fixtures>
    </aside>
  </section>
}

<nav id="mainNav" [class.hidden]="editingFixture || editingAttributes">
  <div class="island">
    <div class="controls">
      <button class="control" (click)="editAttributes()">
        <label>Change {{room?.name}} Details</label>
      </button>
      <button class="control success" [disabled]="!canClose" (click)="closeView()">
        @if (canModifyAppointment) {
          <label>Save & Close {{room?.name}}</label>
        }
        @if (!canModifyAppointment) {
          <label>Close {{room?.name}}</label>
        }
      </button>
    </div>
  </div>
</nav>

<aside id="fixture" [class.active]="editingFixture">
  <div class="bg"></div>

  @if (selectedFixture != null) {
    <fixture
      (click)="killEvent($event)"
      [appointment]="appointment"
      [fixture]="selectedFixture"
      (close)="stopEditingFixture()"
      (deleted)="removeFixture()"
      [availableEntities]="availableEntities"
      [availableFixtures]="availableFixtures"
      [availableFloor]="availableFloor"
      [availableRoom]="availableRoom"
    [availableStructure]="availableStructure"></fixture>
  }
</aside>`, styles: ['/* src/app/appointment/inspection/components/room/room.component.scss */\n#room {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 6vw;\n  right: 0;\n  bottom: 6vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#room .columns {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#room .columns > .column {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#room .columns > .column > .content {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#room .columns > .column > .content > header {\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  padding: 0.75vw 1.5vw 0.75vw 1.5vw;\n  display: flex;\n  justify-content: flex-end;\n}\n#room .columns > .column > .content > header > h2 {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#room .columns > .column > .content > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#room .columns > .column > .content > header > .controls > .control {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#room .columns > .column > .content > header > .controls > .control > i,\n#room .columns > .column > .content > header > .controls > .control > label {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#room .columns > .column > .content > header > .controls > .control > i {\n  font-size: 1.2vw;\n}\n#room .columns > .column > .content > header > .controls > .control > label {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#room .columns > .column > .content > header > .controls > .control:active > i,\n#room .columns > .column > .content > header > .controls > .control:active > label {\n  color: var(--color5);\n}\n#room .columns > .column > .content > header > .controls > .control[disabled] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#room .columns > .column > .content > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#room .columns > .column > .content > header > .controls > input {\n  position: absolute;\n  visibility: hidden;\n}\n#room .columns > .column > .content > .content {\n  flex: 1;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n  position: relative;\n}\n#room .columns > .column > .content > .content > .message {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  z-index: 1;\n  top: 1vw;\n  background-color: var(--error);\n  border: 0.5vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  width: 90%;\n  padding: 0.75vw 1vw;\n  pointer-events: none;\n}\n#room .columns > .column > .content > .content > .message h4 {\n  font-size: 1.2vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#room .columns > .column > .content > .content > .message p {\n  margin-top: 0.5vw;\n  color: var(--color2);\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  text-align: center;\n  line-height: 1.2;\n}\n#room .columns > .column > .content > .content > .control {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#room .columns > .column > .content > .content > .control > i {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#room .columns > .column > .content > .content > .control > label {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#room .columns > .column.diagram {\n  width: calc(75% - 16vw);\n}\n#room .columns > .column.diagram > .content {\n  position: relative;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n#room .columns > .column.diagram > .content > .render {\n  flex: 1;\n  background-color: var(--color2);\n  position: relative;\n  overflow: hidden;\n}\n#room .columns > .column.diagram > .content > .render > .front,\n#room .columns > .column.diagram > .content > .render > .rear {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  display: flex;\n  align-items: center;\n  pointer-events: none;\n}\n#room .columns > .column.diagram > .content > .render > .front > svg,\n#room .columns > .column.diagram > .content > .render > .rear > svg {\n  height: 1.2vw;\n  fill: var(--color1);\n}\n#room .columns > .column.diagram > .content > .render > .front > label,\n#room .columns > .column.diagram > .content > .render > .rear > label {\n  margin: 0 1vw;\n  font-size: 1.4vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  white-space: nowrap;\n}\n#room .columns > .column.diagram > .content > .render > .front {\n  bottom: 1vw;\n}\n#room .columns > .column.diagram > .content > .render > .rear {\n  top: 1vw;\n}\n#room .columns > .column.diagram > .content > .render > .fixtures .fixture {\n  position: absolute;\n  z-index: 2;\n  cursor: pointer;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  will-change: transform;\n}\n#room .columns > .column.diagram > .content > .render > .fixtures .fixture fixture-render {\n  display: block;\n  width: 8vw;\n  height: 9vw;\n  position: relative;\n  --fixtureFontSize: 1vw;\n  will-change: transform;\n}\n#room .columns > .column.diagram > .content > .render > .fixtures .fixture > footer {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#room .columns > .column.diagram > .content > .render > .fixtures .fixture > footer > p {\n  font-size: 0.9vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#room .columns > .column.diagram > .content > .render > .fixtures .fixture > footer > p.warning {\n  color: var(--error);\n  font-style: italic;\n}\n#room .columns > .column.photos {\n  width: 16vw;\n}\n#room .columns > .column.photos > .content > header {\n  background-color: rgba(var(--color1-raw), 0.08);\n}\n#room .columns > .column.photos > .content > .content > .photo {\n  margin-top: 1vw;\n  position: relative;\n  overflow: hidden;\n  border-radius: 1vw;\n}\n#room .columns > .column.photos > .content > .content > .photo canvas {\n  width: 100%;\n}\n#room .columns > .column.photos > .content > .content > .photo > .control {\n  position: absolute;\n  z-index: 1;\n  top: 1vw;\n  right: 1vw;\n  cursor: pointer;\n  height: 3vw;\n  width: 3vw;\n  background-color: var(--color2);\n  overflow: hidden;\n  border-radius: 100%;\n}\n#room .columns > .column.photos > .content > .content > .photo > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n}\n#room .columns > .column.photos > .content > .content > .photo photo {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#room .columns > .column.photos > .content > .content > .photo:first-child {\n  margin-top: 0;\n}\n#room .columns > .column.room {\n  width: 25%;\n}\n#room .columns > .column.room > .content > header {\n  padding: 1vw 1.5vw;\n  background-color: var(--color3Alt3);\n  border-left: 0.2vw var(--color3Alt4) solid;\n  justify-content: center;\n}\n#room .columns > .column.room > .content > header > h2 {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n}\n#room .columns > .column.room > .content > header > h2 > .bathroom {\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n#room .columns > .column.room > .content > .content {\n  background-color: var(--color2Alt2);\n  padding: 1vw;\n}\n#room .columns > .column.room > .content > .content .tooltip {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#room .columns > .column.room > .content > .content .tooltip h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n  line-height: 1;\n}\n#room .columns > .column.room > .content > .content .tooltip p {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#room .columns > .column.room > .content > .content > .notes {\n  margin-top: 1vw;\n}\n#room .columns > .column.room > .content > .content > .notes > .note {\n  margin-top: 1vw;\n}\n#room .columns > .column.room > .content > .content > .notes > .note label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#room .columns > .column.room > .content > .content > .notes > .note textarea {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#room .columns > .column.room > .content > .content > .notes > .note:first-child {\n  margin-top: 0;\n}\n#room .columns > .column:first-child {\n  border-left: none;\n}\n#room #standaloneAttributes > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#room #standaloneAttributes > .attributes {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#room #standaloneAttributes.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#room #standaloneAttributes.active > .attributes {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#room #fixtures > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color1-raw), 0.1);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#room #fixtures > fixtures {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 20%;\n  right: 20%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#room #fixtures.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#room #fixtures.active > fixtures {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#room .tooltip {\n  z-index: 2;\n}\n#room .tooltip.general {\n  bottom: 1vw;\n  right: 1vw;\n  width: 22vw;\n}\n#room .tooltip.general h3 {\n  font-size: 1.6vw;\n}\n#room .tooltip.general p {\n  font-size: 1.5vw;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 9;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#fixture > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 6;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#fixture > fixture ::ng-deep #fixture {\n  z-index: 7;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: childLoadOut;\n  animation-name: childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture > fixture ::ng-deep #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: childNavLoadOut;\n  animation-name: childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#fixture.active > fixture ::ng-deep #fixture {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: childLoadIn;\n  animation-name: childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active > fixture ::ng-deep #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: childNavLoadIn;\n  animation-name: childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=room.component.css.map */\n'] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }, { type: InspectionService }], { appointment: [{
    type: Input
  }], parent: [{
    type: Input,
    args: ["parent"]
  }], renderElm: [{
    type: ViewChild,
    args: ["renderElm"]
  }], availableFloor: [{
    type: Input,
    args: ["availableFloor"]
  }], availableRoom: [{
    type: Input,
    args: ["availableRoom"]
  }], availableUnit: [{
    type: Input,
    args: ["availableUnit"]
  }], availableStructure: [{
    type: Input,
    args: ["availableStructure"]
  }], availableEntities: [{
    type: Input,
    args: ["availableEntities"]
  }], availableFixtures: [{
    type: Input,
    args: ["availableFixtures"]
  }], room: [{
    type: Input,
    args: ["room"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }], deleted: [{
    type: Output,
    args: ["deleted"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(RoomComponent, { className: "RoomComponent" });
})();

// src/app/appointment/inspection/components/room-render/room-render.component.ts
var _c07 = ["componentElm"];
function RoomRenderComponent_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 1);
    \u0275\u0275element(1, "img", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx_r1.room.localRender, \u0275\u0275sanitizeUrl);
  }
}
function RoomRenderComponent_Conditional_0_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "div", 2);
  }
}
function RoomRenderComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 0)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(3, RoomRenderComponent_Conditional_0_Conditional_3_Template, 2, 1, "div", 1);
    \u0275\u0275conditionalCreate(4, RoomRenderComponent_Conditional_0_Conditional_4_Template, 1, 0, "div", 2);
    \u0275\u0275elementStart(5, "div", 3);
    \u0275\u0275listener("mousemove", function RoomRenderComponent_Conditional_0_Template_div_mousemove_5_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.resize($event));
    }, \u0275\u0275resolveWindow)("touchmove", function RoomRenderComponent_Conditional_0_Template_div_touchmove_5_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.resize($event));
    }, \u0275\u0275resolveWindow)("mouseup", function RoomRenderComponent_Conditional_0_Template_div_mouseup_5_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopResizing($event));
    }, \u0275\u0275resolveWindow)("touchend", function RoomRenderComponent_Conditional_0_Template_div_touchend_5_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopResizing($event));
    }, \u0275\u0275resolveWindow);
    \u0275\u0275elementStart(6, "div", 4);
    \u0275\u0275listener("mousedown", function RoomRenderComponent_Conditional_0_Template_div_mousedown_6_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "nw"));
    })("touchstart", function RoomRenderComponent_Conditional_0_Template_div_touchstart_6_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "nw"));
    });
    \u0275\u0275element(7, "i", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "div", 6);
    \u0275\u0275listener("mousedown", function RoomRenderComponent_Conditional_0_Template_div_mousedown_8_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "ne"));
    })("touchstart", function RoomRenderComponent_Conditional_0_Template_div_touchstart_8_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "nw"));
    });
    \u0275\u0275element(9, "i", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "div", 8);
    \u0275\u0275listener("mousedown", function RoomRenderComponent_Conditional_0_Template_div_mousedown_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "se"));
    })("touchstart", function RoomRenderComponent_Conditional_0_Template_div_touchstart_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "se"));
    });
    \u0275\u0275element(11, "i", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "div", 9);
    \u0275\u0275listener("mousedown", function RoomRenderComponent_Conditional_0_Template_div_mousedown_12_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "sw"));
    })("touchstart", function RoomRenderComponent_Conditional_0_Template_div_touchstart_12_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "sw"));
    });
    \u0275\u0275element(13, "i", 7);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r1.roomLabel);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.room.localRender != null ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.room.localRender == null ? 4 : -1);
  }
}
var _RoomRenderComponent = class _RoomRenderComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.resizeDirection = "";
    this.resizePositioning = {
      initialX: 0,
      initialY: 0,
      relX: 0,
      relY: 0,
      relHeight: 0,
      relWidth: 0,
      maxX: 0,
      maxY: 0,
      x: 0,
      y: 0
    };
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get roomLabel() {
    if (this.room?.name != null) {
      return `${this.room.name[0]} ${this.room.number}`;
    }
    return "";
  }
  startResizing(e, direction) {
    this.resizeDirection = direction;
    e.stopPropagation();
    const isTouch = "touches" in e && e instanceof TouchEvent;
    if (isTouch) {
      this.resizePositioning.initialX = e.touches[0].clientX;
      this.resizePositioning.initialY = e.touches[0].clientY;
    } else {
      this.resizePositioning.initialX = e.clientX;
      this.resizePositioning.initialY = e.clientY;
    }
    this.resizePositioning.relX = this.room?.renderDimensions.x ?? 0;
    this.resizePositioning.relY = this.room?.renderDimensions.y ?? 0;
    this.resizePositioning.relHeight = this.room?.renderDimensions.height ?? 0;
    this.resizePositioning.relWidth = this.room?.renderDimensions.width ?? 0;
    if (this.parentElm != null) {
      this.resizePositioning.maxX = this.parentElm.offsetWidth;
      this.resizePositioning.maxY = this.parentElm.offsetHeight;
    }
    if (this.room != null) {
      this.room.resizing = true;
    }
  }
  resize(e) {
    if (this.canModifyAppointment) {
      e.stopPropagation();
      switch (this.resizeDirection) {
        case "nw":
          this.resizeNw(e);
          break;
        case "ne":
          this.resizeNe(e);
          break;
        case "sw":
          this.resizeSw(e);
          break;
        case "se":
          this.resizeSe(e);
          break;
      }
    }
  }
  resizeNw(e) {
    if (this.room != null) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.room.resizing && this.room.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.room.renderDimensions.x = this.resizePositioning.relX - x;
          if (this.room.renderDimensions.x < 0) {
            this.room.renderDimensions.x = 0;
          } else {
            this.room.renderDimensions.width = x + this.resizePositioning.relWidth;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth - x;
          if (newWidth < 140) {
            newWidth = 140;
          } else {
            this.room.renderDimensions.x = this.resizePositioning.relX + x;
            const maxX = this.resizePositioning.maxX - this.room.renderDimensions.width;
            if (this.room.renderDimensions.x > maxX) {
              this.room.renderDimensions.x = maxX;
              newWidth = this.room.renderDimensions.width;
            }
          }
          this.room.renderDimensions.width = newWidth;
        }
        this.room.renderDimensions.height = this.room.renderDimensions.width;
      }
    }
  }
  resizeNe(e) {
    const isTouch = "touches" in e && e instanceof TouchEvent;
    if (this.room != null) {
      if (this.room.resizing && this.room.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.room.renderDimensions.width = this.resizePositioning.relWidth - x;
          if (this.room.renderDimensions.width < 140) {
            this.room.renderDimensions.width = 140;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth + x;
          const totalX = newWidth + this.room.renderDimensions.x;
          if (totalX <= this.resizePositioning.maxX) {
            this.room.renderDimensions.width = this.resizePositioning.relWidth + x;
          } else {
            this.room.renderDimensions.width = this.resizePositioning.maxX - this.room.renderDimensions.x;
          }
        }
        this.room.renderDimensions.height = this.room.renderDimensions.width;
      }
    }
  }
  resizeSe(e) {
    if (this.room != null) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.room.resizing && this.room?.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.room.renderDimensions.width = this.resizePositioning.relWidth - x;
          if (this.room.renderDimensions.width < 140) {
            this.room.renderDimensions.width = 140;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth + x;
          const totalX = newWidth + this.room.renderDimensions.x;
          if (totalX <= this.resizePositioning.maxX) {
            this.room.renderDimensions.width = this.resizePositioning.relWidth + x;
          } else {
            this.room.renderDimensions.width = this.resizePositioning.maxX - this.room.renderDimensions.x;
          }
        }
      }
    }
  }
  resizeSw(e) {
    if (this.room != null) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.room.resizing && this.room?.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.room.renderDimensions.x = this.resizePositioning.relX - x;
          if (this.room.renderDimensions.x < 0) {
            this.room.renderDimensions.x = 0;
          } else {
            this.room.renderDimensions.width = x + this.resizePositioning.relWidth;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth - x;
          if (newWidth < 140) {
            newWidth = 140;
          } else {
            this.room.renderDimensions.x = this.resizePositioning.relX + x;
            const maxX = this.resizePositioning.maxX - this.room.renderDimensions.width;
            if (this.room.renderDimensions.x > maxX) {
              this.room.renderDimensions.x = maxX;
              newWidth = this.room.renderDimensions.width;
            }
          }
          this.room.renderDimensions.width = newWidth;
        }
      }
    }
  }
  stopResizing(e) {
    e.stopPropagation();
    setTimeout(() => {
      if (this.room != null) {
        this.room.resizing = false;
        this.resizeDirection = "";
      }
    }, 0);
  }
  init() {
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_RoomRenderComponent.\u0275fac = function RoomRenderComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _RoomRenderComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_RoomRenderComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _RoomRenderComponent, selectors: [["room-render"]], viewQuery: function RoomRenderComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c07, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { parent: "parent", parentElm: "parentElm", room: "room" }, standalone: false, decls: 1, vars: 1, consts: [[1, "room"], [1, "render"], [1, "placeholder"], [1, "corners", "no-render", 3, "mousemove", "touchmove", "mouseup", "touchend"], [1, "corner", "nw", 3, "mousedown", "touchstart"], [1, "fa-solid", "fa-up-right-and-down-left-from-center", "fa-flip-horizontal"], [1, "corner", "ne", 3, "mousedown", "touchstart"], [1, "fa-solid", "fa-up-right-and-down-left-from-center"], [1, "corner", "se", 3, "mousedown", "touchstart"], [1, "corner", "sw", 3, "mousedown", "touchstart"], ["draggable", "false", 3, "src"]], template: function RoomRenderComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, RoomRenderComponent_Conditional_0_Template, 14, 3, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.room != null ? 0 : -1);
  }
}, styles: ["\n\n.room[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2-raw), 0.8);\n  border: 0.5vw var(--color3) solid;\n  border-radius: 0.25vw;\n}\n.room[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  z-index: 1;\n  bottom: 3vw;\n  white-space: none;\n  color: var(--color3);\n  font-size: var(--roomFontSize);\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n.room[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.room[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 2vw;\n  width: 2vw;\n  background-color: var(--color2);\n  border: 0.2vw var(--color1) solid;\n  cursor: pointer;\n  z-index: 1;\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner[_ngcontent-%COMP%]    > i.fa-flip-horizontal[_ngcontent-%COMP%] {\n  -moz-transform: translate(-50%, -50%) scaleX(-1);\n  -ms-transform: translate(-50%, -50%) scaleX(-1);\n  -o-transform: translate(-50%, -50%) scaleX(-1);\n  -webkit-transform: translate(-50%, -50%) scaleX(-1);\n  transform: translate(-50%, -50%) scaleX(-1);\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.nw[_ngcontent-%COMP%] {\n  top: 0;\n  left: 0;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.ne[_ngcontent-%COMP%] {\n  top: 0;\n  right: 0;\n  -moz-transform: translate(50%, -50%);\n  -ms-transform: translate(50%, -50%);\n  -o-transform: translate(50%, -50%);\n  -webkit-transform: translate(50%, -50%);\n  transform: translate(50%, -50%);\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.sw[_ngcontent-%COMP%] {\n  bottom: 0;\n  left: 0;\n  -moz-transform: translate(-50%, 50%);\n  -ms-transform: translate(-50%, 50%);\n  -o-transform: translate(-50%, 50%);\n  -webkit-transform: translate(-50%, 50%);\n  transform: translate(-50%, 50%);\n}\n.room[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.se[_ngcontent-%COMP%] {\n  bottom: 0;\n  right: 0;\n  -moz-transform: translate(50%, 50%);\n  -ms-transform: translate(50%, 50%);\n  -o-transform: translate(50%, 50%);\n  -webkit-transform: translate(50%, 50%);\n  transform: translate(50%, 50%);\n}\n/*# sourceMappingURL=room-render.component.css.map */"] });
var RoomRenderComponent = _RoomRenderComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(RoomRenderComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "room-render", template: `@if (room != null) {
  <div class="room">
    <label>{{roomLabel}}</label>
    @if (room.localRender != null) {
      <div class="render">
        <img draggable="false" [src]="room.localRender" />
      </div>
    }
    @if (room.localRender == null) {
      <div class="placeholder"></div>
    }
    <div class="corners no-render"
      (window:mousemove)="resize($event)"
      (window:touchmove)="resize($event)"
      (window:mouseup)="stopResizing($event)"
      (window:touchend)="stopResizing($event)">
      <div class="corner nw"
        (mousedown)="startResizing($event,'nw')"
        (touchstart)="startResizing($event,'nw')">
        <i class="fa-solid fa-up-right-and-down-left-from-center fa-flip-horizontal"></i>
      </div>
      <div class="corner ne"
        (mousedown)="startResizing($event,'ne')"
        (touchstart)="startResizing($event,'nw')">
        <i class="fa-solid fa-up-right-and-down-left-from-center"></i>
      </div>
      <div class="corner se"
        (mousedown)="startResizing($event,'se')"
        (touchstart)="startResizing($event,'se')">
        <i class="fa-solid fa-up-right-and-down-left-from-center fa-flip-horizontal"></i>
      </div>
      <div class="corner sw"
        (mousedown)="startResizing($event,'sw')"
        (touchstart)="startResizing($event,'sw')">
        <i class="fa-solid fa-up-right-and-down-left-from-center"></i>
      </div>
    </div>
  </div>
}`, styles: ["/* src/app/appointment/inspection/components/room-render/room-render.component.scss */\n.room {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2-raw), 0.8);\n  border: 0.5vw var(--color3) solid;\n  border-radius: 0.25vw;\n}\n.room > label {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  z-index: 1;\n  bottom: 3vw;\n  white-space: none;\n  color: var(--color3);\n  font-size: var(--roomFontSize);\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n.room > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.room > .render img {\n  height: 100%;\n  width: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n.room > .corners > .corner {\n  position: absolute;\n  height: 2vw;\n  width: 2vw;\n  background-color: var(--color2);\n  border: 0.2vw var(--color1) solid;\n  cursor: pointer;\n  z-index: 1;\n}\n.room > .corners > .corner > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n.room > .corners > .corner > i.fa-flip-horizontal {\n  -moz-transform: translate(-50%, -50%) scaleX(-1);\n  -ms-transform: translate(-50%, -50%) scaleX(-1);\n  -o-transform: translate(-50%, -50%) scaleX(-1);\n  -webkit-transform: translate(-50%, -50%) scaleX(-1);\n  transform: translate(-50%, -50%) scaleX(-1);\n}\n.room > .corners > .corner.nw {\n  top: 0;\n  left: 0;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n.room > .corners > .corner.ne {\n  top: 0;\n  right: 0;\n  -moz-transform: translate(50%, -50%);\n  -ms-transform: translate(50%, -50%);\n  -o-transform: translate(50%, -50%);\n  -webkit-transform: translate(50%, -50%);\n  transform: translate(50%, -50%);\n}\n.room > .corners > .corner.sw {\n  bottom: 0;\n  left: 0;\n  -moz-transform: translate(-50%, 50%);\n  -ms-transform: translate(-50%, 50%);\n  -o-transform: translate(-50%, 50%);\n  -webkit-transform: translate(-50%, 50%);\n  transform: translate(-50%, 50%);\n}\n.room > .corners > .corner.se {\n  bottom: 0;\n  right: 0;\n  -moz-transform: translate(50%, 50%);\n  -ms-transform: translate(50%, 50%);\n  -o-transform: translate(50%, 50%);\n  -webkit-transform: translate(50%, 50%);\n  transform: translate(50%, 50%);\n}\n/*# sourceMappingURL=room-render.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { parent: [{
    type: Input,
    args: ["parent"]
  }], parentElm: [{
    type: Input,
    args: ["parentElm"]
  }], room: [{
    type: Input,
    args: ["room"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(RoomRenderComponent, { className: "RoomRenderComponent" });
})();

// src/app/appointment/inspection/components/structure/structure.component.ts
var _c08 = ["renderElm"];
var _c12 = ["componentElm"];
function StructureComponent_Conditional_0_For_36_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 50);
    \u0275\u0275text(1, " Missing Information ");
    \u0275\u0275elementEnd();
  }
}
function StructureComponent_Conditional_0_For_36_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 48, 1);
    \u0275\u0275listener("mouseup", function StructureComponent_Conditional_0_For_36_Template_div_mouseup_0_listener() {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectFixture(fixture_r4));
    })("touchend", function StructureComponent_Conditional_0_For_36_Template_div_touchend_0_listener() {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectFixture(fixture_r4));
    });
    \u0275\u0275elementStart(2, "fixture-render", 49);
    \u0275\u0275listener("touchstart", function StructureComponent_Conditional_0_For_36_Template_fixture_render_touchstart_2_listener($event) {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const fixtureElm_r5 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, fixtureElm_r5, fixture_r4));
    })("mousedown", function StructureComponent_Conditional_0_For_36_Template_fixture_render_mousedown_2_listener($event) {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const fixtureElm_r5 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, fixtureElm_r5, fixture_r4));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "footer");
    \u0275\u0275conditionalCreate(4, StructureComponent_Conditional_0_For_36_Conditional_4_Template, 2, 0, "p", 50);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const fixture_r4 = ctx.$implicit;
    \u0275\u0275styleProp("transform", fixture_r4.renderDimensions.transform);
    \u0275\u0275advance(2);
    \u0275\u0275property("fixture", fixture_r4);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!fixture_r4.valid ? 4 : -1);
  }
}
function StructureComponent_Conditional_0_For_39_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 50);
    \u0275\u0275text(1, " Missing Information ");
    \u0275\u0275elementEnd();
  }
}
function StructureComponent_Conditional_0_For_39_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 51, 2);
    \u0275\u0275listener("mouseup", function StructureComponent_Conditional_0_For_39_Template_div_mouseup_0_listener() {
      const room_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectRoom(room_r7));
    })("touchend", function StructureComponent_Conditional_0_For_39_Template_div_touchend_0_listener() {
      const room_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectRoom(room_r7));
    });
    \u0275\u0275elementStart(2, "room-render", 52);
    \u0275\u0275listener("mousedown", function StructureComponent_Conditional_0_For_39_Template_room_render_mousedown_2_listener($event) {
      const room_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const roomElm_r8 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, roomElm_r8, room_r7));
    })("touchstart", function StructureComponent_Conditional_0_For_39_Template_room_render_touchstart_2_listener($event) {
      const room_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const roomElm_r8 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, roomElm_r8, room_r7));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "footer");
    \u0275\u0275conditionalCreate(4, StructureComponent_Conditional_0_For_39_Conditional_4_Template, 2, 0, "p", 50);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const room_r7 = ctx.$implicit;
    \u0275\u0275nextContext();
    const renderElm_r9 = \u0275\u0275reference(19);
    \u0275\u0275styleProp("transform", room_r7.renderDimensions.transform);
    \u0275\u0275advance(2);
    \u0275\u0275styleProp("width", room_r7.renderDimensions.widthCss)("height", room_r7.renderDimensions.widthCss);
    \u0275\u0275property("room", room_r7)("parentElm", renderElm_r9);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!room_r7.valid ? 4 : -1);
  }
}
function StructureComponent_Conditional_0_Conditional_56_For_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 55);
    \u0275\u0275listener("click", function StructureComponent_Conditional_0_Conditional_56_For_6_Template_button_click_0_listener() {
      const floor_r11 = \u0275\u0275restoreView(_r10).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.selectFloor(floor_r11));
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "span", 56);
    \u0275\u0275text(4, " Missing Information ");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const floor_r11 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275classProp("active", (ctx_r1.selectedFloor == null ? null : ctx_r1.selectedFloor.id) == floor_r11.id)("warning", !floor_r11.valid);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(floor_r11.name);
  }
}
function StructureComponent_Conditional_0_Conditional_56_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 37)(1, "header")(2, "h3");
    \u0275\u0275text(3, "Switch to Another Floor");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "div", 53);
    \u0275\u0275repeaterCreate(5, StructureComponent_Conditional_0_Conditional_56_For_6_Template, 5, 5, "button", 54, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(5);
    \u0275\u0275repeater(ctx_r1.floors);
  }
}
function StructureComponent_Conditional_0_Conditional_69_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "standalone-attributes", 57);
    \u0275\u0275listener("close", function StructureComponent_Conditional_0_Conditional_69_Template_standalone_attributes_close_0_listener() {
      \u0275\u0275restoreView(_r12);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.stopEditingFloorAttributes());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275nextContext();
    const renderElm_r9 = \u0275\u0275reference(19);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("entity", ctx_r1.selectedFloor)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableUnit", ctx_r1.availableUnit)("availableStructure", ctx_r1.availableStructure)("attributes", ctx_r1.selectedFloor.attributes)("renderElm", renderElm_r9)("headerLabel", "Which Floor Are You Working On?")("saveLabel", "Continue Inspecting Floor");
  }
}
function StructureComponent_Conditional_0_Conditional_73_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "standalone-attributes", 57);
    \u0275\u0275listener("close", function StructureComponent_Conditional_0_Conditional_73_Template_standalone_attributes_close_0_listener() {
      \u0275\u0275restoreView(_r13);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.stopEditingAttributes());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275nextContext();
    const renderElm_r9 = \u0275\u0275reference(19);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("entity", ctx_r1.structure)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableUnit", ctx_r1.availableUnit)("availableStructure", ctx_r1.availableStructure)("attributes", ctx_r1.attributes)("renderElm", renderElm_r9)("headerLabel", "Please Complete Structure Details")("saveLabel", "Continue Inspecting Structure");
  }
}
function StructureComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 15);
    \u0275\u0275listener("touchend", function StructureComponent_Conditional_0_Template_section_touchend_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopMoving($event));
    }, \u0275\u0275resolveWindow)("mouseup", function StructureComponent_Conditional_0_Template_section_mouseup_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopMoving($event));
    }, \u0275\u0275resolveWindow);
    \u0275\u0275elementStart(1, "div", 16)(2, "div", 17)(3, "div", 18)(4, "header")(5, "div", 6)(6, "button", 19);
    \u0275\u0275listener("click", function StructureComponent_Conditional_0_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectFixtures());
    });
    \u0275\u0275element(7, "i", 20);
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Add Fixture Outside Bathroom(s)");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 19);
    \u0275\u0275listener("click", function StructureComponent_Conditional_0_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.editFloorAttributes());
    });
    \u0275\u0275element(11, "i", 21);
    \u0275\u0275elementStart(12, "label");
    \u0275\u0275text(13, "Change Number of Bathrooms");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(14, "button", 19);
    \u0275\u0275listener("click", function StructureComponent_Conditional_0_Template_button_click_14_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.managePhotos());
    });
    \u0275\u0275element(15, "i", 22);
    \u0275\u0275elementStart(16, "label");
    \u0275\u0275text(17);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(18, "div", 23, 0);
    \u0275\u0275listener("mousemove", function StructureComponent_Conditional_0_Template_div_mousemove_18_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.moveEntity($event));
    })("touchmove", function StructureComponent_Conditional_0_Template_div_touchmove_18_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.moveEntity($event));
    });
    \u0275\u0275elementStart(20, "div", 24);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(21, "svg", 25);
    \u0275\u0275element(22, "path", 26);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(23, "label");
    \u0275\u0275text(24, "Rear of Property");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(25, "svg", 25);
    \u0275\u0275element(26, "path", 26);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(27, "div", 27);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(28, "svg", 25);
    \u0275\u0275element(29, "path", 28);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(30, "label");
    \u0275\u0275text(31, "Front of Property");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(32, "svg", 25);
    \u0275\u0275element(33, "path", 28);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(34, "div", 29);
    \u0275\u0275repeaterCreate(35, StructureComponent_Conditional_0_For_36_Template, 5, 4, "div", 30, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(37, "div", 31);
    \u0275\u0275repeaterCreate(38, StructureComponent_Conditional_0_For_39_Template, 5, 9, "div", 32, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(40, "div", 33)(41, "div", 34)(42, "header")(43, "h2");
    \u0275\u0275text(44, " Inspecting the ");
    \u0275\u0275elementStart(45, "span", 35);
    \u0275\u0275text(46);
    \u0275\u0275elementEnd();
    \u0275\u0275text(47);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(48, "div", 34)(49, "div", 36)(50, "h3");
    \u0275\u0275text(51, "Tip: Inspecting the Floor");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(52, "p");
    \u0275\u0275text(53, " #1: Add fixtures that aren't in bathrooms or... ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(54, "p");
    \u0275\u0275text(55, " #2: Tap on a bathroom to work inside. ");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(56, StructureComponent_Conditional_0_Conditional_56_Template, 7, 0, "div", 37);
    \u0275\u0275elementStart(57, "div", 38)(58, "div", 39)(59, "label");
    \u0275\u0275text(60);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(61, "textarea", 40);
    \u0275\u0275listener("input", function StructureComponent_Conditional_0_Template_textarea_input_61_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateNotes(ctx_r1.NoteAudience.Customer));
    });
    \u0275\u0275twoWayListener("ngModelChange", function StructureComponent_Conditional_0_Template_textarea_ngModelChange_61_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.customerNotes, $event) || (ctx_r1.customerNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(62, "div", 39)(63, "label");
    \u0275\u0275text(64);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(65, "textarea", 41);
    \u0275\u0275listener("input", function StructureComponent_Conditional_0_Template_textarea_input_65_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateNotes(ctx_r1.NoteAudience.Shop));
    });
    \u0275\u0275twoWayListener("ngModelChange", function StructureComponent_Conditional_0_Template_textarea_ngModelChange_65_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.shopNotes, $event) || (ctx_r1.shopNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()()();
    \u0275\u0275elementStart(66, "aside", 42);
    \u0275\u0275element(67, "div", 11);
    \u0275\u0275elementStart(68, "div", 43);
    \u0275\u0275conditionalCreate(69, StructureComponent_Conditional_0_Conditional_69_Template, 1, 12, "standalone-attributes", 44);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(70, "aside", 45);
    \u0275\u0275element(71, "div", 11);
    \u0275\u0275elementStart(72, "div", 43);
    \u0275\u0275conditionalCreate(73, StructureComponent_Conditional_0_Conditional_73_Template, 1, 12, "standalone-attributes", 44);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(74, "aside", 46);
    \u0275\u0275element(75, "div", 11);
    \u0275\u0275elementStart(76, "fixtures", 47);
    \u0275\u0275listener("close", function StructureComponent_Conditional_0_Template_fixtures_close_76_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopSelectingFixtures());
    })("selectedFixture", function StructureComponent_Conditional_0_Template_fixtures_selectedFixture_76_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.addFixture($event));
    });
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("Manage ", ctx_r1.selectedFloor == null ? null : ctx_r1.selectedFloor.name, " Photo(s)");
    \u0275\u0275advance(18);
    \u0275\u0275repeater(ctx_r1.fixtures);
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx_r1.rooms);
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(ctx_r1.selectedFloor == null ? null : ctx_r1.selectedFloor.name);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" of the ", ctx_r1.structure.name, " ");
    \u0275\u0275advance(9);
    \u0275\u0275conditional(ctx_r1.floors.length > 1 ? 56 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1("", ctx_r1.selectedFloor == null ? null : ctx_r1.selectedFloor.name, " Notes for the Customer");
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.customerNotes);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("", ctx_r1.selectedFloor == null ? null : ctx_r1.selectedFloor.name, " Notes for the Shop");
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.shopNotes);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.editingFloorAttributes);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.selectedFloor != null ? 69 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.editingAttributes);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.showAttributesUI ? 73 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.selectingFixture);
    \u0275\u0275advance(2);
    \u0275\u0275property("appointment", ctx_r1.appointment);
  }
}
function StructureComponent_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 7);
    \u0275\u0275listener("click", function StructureComponent_Conditional_7_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.editFloorAttributes());
    });
    \u0275\u0275elementStart(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("Change ", ctx_r1.selectedFloor.name, " Details");
  }
}
function StructureComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Save & Close ", ctx_r1.structure == null ? null : ctx_r1.structure.name);
  }
}
function StructureComponent_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Close ", ctx_r1.structure == null ? null : ctx_r1.structure.name);
  }
}
function StructureComponent_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "room", 58);
    \u0275\u0275listener("click", function StructureComponent_Conditional_13_Template_room_click_0_listener($event) {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("close", function StructureComponent_Conditional_13_Template_room_close_0_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopEditingRoom());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("room", ctx_r1.selectedRoom)("parent", ctx_r1.selectedFloor)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableUnit", ctx_r1.availableUnit)("availableStructure", ctx_r1.availableStructure);
  }
}
function StructureComponent_Conditional_16_Template(rf, ctx) {
  if (rf & 1) {
    const _r16 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "fixture", 59);
    \u0275\u0275listener("click", function StructureComponent_Conditional_16_Template_fixture_click_0_listener($event) {
      \u0275\u0275restoreView(_r16);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("close", function StructureComponent_Conditional_16_Template_fixture_close_0_listener() {
      \u0275\u0275restoreView(_r16);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopEditingFixture());
    })("deleted", function StructureComponent_Conditional_16_Template_fixture_deleted_0_listener() {
      \u0275\u0275restoreView(_r16);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.removeFixture());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("fixture", ctx_r1.selectedFixture)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableStructure", ctx_r1.availableStructure);
  }
}
var _StructureComponent = class _StructureComponent {
  constructor(localAppointmentService, appointmentService, uiService, inspectionService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.inspectionService = inspectionService;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.NoteAudience = NoteAudience;
    this.customerNotes = "";
    this.shopNotes = "";
    this.editingFloorAttributes = false;
    this.showFloorAttributesUI = false;
    this.editingAttributes = false;
    this.showAttributesUI = false;
    this.acceptFileTypes = "*.jpg,*.png,*.webp";
    this.acceptMimeTypes = ["image/jpeg", "image/jpg", "image/png", "image/webp"];
    this.relWidth = 0;
    this.relHeight = 0;
    this.relX = 0;
    this.relY = 0;
    this.cursorPosition = {
      initialX: 0,
      initialY: 0,
      x: 0,
      y: 0,
      totalX: 0,
      totalY: 0
    };
    this.renderPosition = {
      offsetWidth: 0,
      offsetHeight: 0,
      offsetX: 0,
      offsetY: 0
    };
    this.editingFixture = false;
    this.selectingFixture = false;
    this.showDeleteFixturePrompt = false;
    this.editingRoom = false;
    this.showDeleteRoomPrompt = false;
    this.close = new Subject();
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  update() {
    if (this.appointment != null) {
      this.appointment.changed$.next();
    }
  }
  updateNotes(type) {
    if (this.selectedFloor != null) {
      switch (type) {
        case NoteAudience.Customer:
          this.selectedFloor.notes[NoteAudience.Customer] = this.customerNotes;
          break;
        case NoteAudience.Shop:
          this.selectedFloor.notes[NoteAudience.Shop] = this.shopNotes;
          break;
      }
      this.update();
    }
  }
  initNotes() {
    if (this.selectedFloor != null) {
      this.customerNotes = this.selectedFloor.notes[NoteAudience.Customer] ?? "";
      this.shopNotes = this.selectedFloor.notes[NoteAudience.Shop] ?? "";
    }
  }
  editFloorAttributes() {
    this.editingFloorAttributes = true;
    this.showFloorAttributesUI = true;
  }
  stopEditingFloorAttributes() {
    return __async(this, null, function* () {
      window.clearTimeout(this.floorAttributesTimer);
      this.editingFloorAttributes = false;
      this.attributesTimer = window.setTimeout(() => __async(this, null, function* () {
        this.showFloorAttributesUI = false;
        if (this.selectedFloor != null) {
          yield this.render();
        }
      }), 250);
    });
  }
  initFloorAttributes() {
    if (!this.editingAttributes) {
      if (this.selectedFloor != null) {
        if (this.selectedFloor.hasInvalidAttributes && this.canModifyAppointment) {
          this.editFloorAttributes();
        }
      }
    }
  }
  get attributes() {
    return this.structure?.attributes ?? [];
  }
  editAttributes() {
    this.editingAttributes = true;
    this.showAttributesUI = true;
  }
  stopEditingAttributes() {
    return __async(this, null, function* () {
      window.clearTimeout(this.attributesTimer);
      this.editingAttributes = false;
      this.attributesTimer = window.setTimeout(() => __async(this, null, function* () {
        this.showAttributesUI = false;
        this.initFloorAttributes();
        if (this.selectedFloor != null) {
          yield this.render();
        }
      }), 250);
    });
  }
  initAttributes() {
    if (this.structure != null) {
      if (this.structure.hasInvalidAttributes && this.canModifyAppointment) {
        this.editAttributes();
      }
    }
  }
  get photos() {
    return this.structure?.photos_B64 ?? [];
  }
  get viewingPhoto() {
    return this.localAppointmentService.viewingPhoto;
  }
  get photoSrc() {
    return this.localAppointmentService.photoSrc;
  }
  matchesMimeType(mimeType) {
    let i = this.acceptMimeTypes.length;
    while (i--) {
      const acceptMimeType = this.acceptMimeTypes[i];
      if (acceptMimeType == mimeType) {
        return true;
      }
    }
    return false;
  }
  setFile(deviceBlob, photos) {
    if (deviceBlob != null && this.matchesMimeType(deviceBlob.type)) {
      const url = URL.createObjectURL(deviceBlob);
      const srcImage = new Image();
      srcImage.onload = () => {
        URL.revokeObjectURL(url);
        const offscreenCanvas = document.createElement("canvas");
        const ctx = offscreenCanvas.getContext("2d");
        if (ctx != null) {
          const ratio = srcImage.width / 1024;
          let width = srcImage.width;
          let height = srcImage.height;
          if (ratio > 1) {
            width = 1024;
            height = Math.round(srcImage.height / ratio);
          }
          offscreenCanvas.width = width;
          offscreenCanvas.height = height;
          ctx.drawImage(srcImage, 0, 0, width, height);
          const base64Image = offscreenCanvas.toDataURL("image/jpeg");
          this.photos.push(base64Image);
          if (this.appointment != null) {
            this.appointment.changed$.next();
          }
        }
      };
      srcImage.src = url;
    }
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.setFile(file, this.photos);
    } else {
      this.setFile(void 0, this.photos);
    }
  }
  selectMedia(fileInputElm) {
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  deletePhoto(fileName) {
    if (this.structure != null) {
      for (var i = 0, len = this.structure.photos.length; i < len; i++) {
        const photo = this.structure.photos[i];
        if (photo.fileName == fileName) {
          this.structure.photos.splice(i, 1);
          break;
        }
      }
      for (var i = 0, len = this.structure.photos_B64.length; i < len; i++) {
        const photo = this.structure.photos_B64[i];
        if (photo == fileName) {
          this.structure.photos_B64.splice(i, 1);
          break;
        }
      }
      this.appointment?.changed$.next();
    }
  }
  viewPhoto(photo) {
    this.localAppointmentService.viewPhoto(photo);
  }
  stopViewingPhoto() {
    this.localAppointmentService.stopViewingPhoto();
  }
  storePhotoMeta() {
    if (this.activePhoto != null) {
      if (this.photoName != null) {
        this.activePhoto.name = this.photoName;
      }
      if (this.photoNotes != null) {
        this.activePhoto.notes = this.photoNotes;
      }
    }
  }
  colliding(newX, newWidth, newY, newHeight) {
    if (this.selectedFloor != null) {
      for (var i = 0, len = this.selectedFloor.entities.length; i < len; i++) {
        const entity = this.selectedFloor.entities[i];
        const minX = entity.renderDimensions.x - newWidth;
        const minY = entity.renderDimensions.y - newHeight;
        const maxX = entity.renderDimensions.width + entity.renderDimensions.x;
        const maxY = entity.renderDimensions.height + entity.renderDimensions.y;
        if (newX > minX && newX < maxX && newY > minY && newY < maxY) {
          return true;
        }
      }
    }
    return false;
  }
  startMoving(e, elm, entity) {
    if (!entity.moving) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      this.cursorPosition.totalX = 0;
      this.cursorPosition.totalY = 0;
      if (isTouch) {
        this.cursorPosition.initialX = e.touches[0].clientX;
        this.cursorPosition.initialY = e.touches[0].clientY;
      } else {
        this.cursorPosition.initialX = e.clientX;
        this.cursorPosition.initialY = e.clientY;
      }
      this.renderPosition.offsetHeight = elm.offsetHeight;
      this.renderPosition.offsetWidth = elm.offsetWidth;
      this.renderPosition.offsetX = elm.offsetWidth / 2;
      this.renderPosition.offsetY = elm.offsetHeight / 2;
      this.movingEntity = entity;
    }
  }
  stopMoving(e) {
    return __async(this, null, function* () {
      if (this.movingEntity?.moving) {
        this.movingEntity.moving = false;
        if (this.selectedFloor != null) {
          yield this.render(50);
        }
      }
      this.movingEntity = void 0;
      this.fixtures.forEach((fixture) => {
        fixture.moving = false;
      });
      this.rooms.forEach((room) => {
        room.moving = false;
      });
    });
  }
  moveEntity(e) {
    if (this.canModifyAppointment) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.movingEntity != null && !this.movingEntity.resizing) {
        if (this.cursorPosition.totalX > 3 || this.cursorPosition.totalX < -3 || this.cursorPosition.totalY > 3 || this.cursorPosition.totalY < -3) {
          this.movingEntity.moving = true;
        }
        if (isTouch) {
          this.cursorPosition.x = e.touches[0].clientX;
          this.cursorPosition.y = e.touches[0].clientY;
        } else {
          this.cursorPosition.x = e.clientX;
          this.cursorPosition.y = e.clientY;
        }
        const deltaX = this.cursorPosition.x - this.cursorPosition.initialX;
        const deltaY = this.cursorPosition.y - this.cursorPosition.initialY;
        let newX = this.movingEntity.renderDimensions.x + deltaX;
        let newY = this.movingEntity.renderDimensions.y + deltaY;
        const maxX = this.relWidth - this.renderPosition.offsetWidth;
        const maxY = this.relHeight - this.renderPosition.offsetHeight;
        if (newX < 0) {
          newX = 0;
        } else if (newX > maxX) {
          newX = maxX;
        }
        if (newY < 0) {
          newY = 0;
        } else if (newY > maxY) {
          newY = maxY;
        }
        const colliding = this.colliding(newX, this.renderPosition.offsetWidth, newY, this.renderPosition.offsetHeight);
        if (!colliding || this.movingEntity instanceof AppointmentPropertyEntity) {
          this.movingEntity.renderDimensions.x = newX;
          this.movingEntity.renderDimensions.y = newY;
          this.cursorPosition.initialX = this.cursorPosition.x;
          this.cursorPosition.initialY = this.cursorPosition.y;
          this.cursorPosition.totalX = this.cursorPosition.totalX + deltaX;
          this.cursorPosition.totalY = this.cursorPosition.totalX + deltaY;
        }
      }
    }
  }
  render(delayInMs = 50) {
    return new Promise((res, rej) => {
      window.clearTimeout(this.renderDebounce);
      const selectedFloor = this.selectedFloor;
      this.renderDebounce = window.setTimeout(() => {
        const renderElm = this.renderElm?.nativeElement;
        if (renderElm != null && selectedFloor != null) {
          toPng(renderElm, {
            quality: 1,
            backgroundColor: "#fff",
            skipFonts: true,
            filter: (renderElm2) => {
              return !renderElm2.classList?.contains("no-render");
            }
          }).then((png) => {
            selectedFloor.updateRender(png);
            this.appointment?.changed$.next();
            res();
          }).catch(() => {
            rej();
          });
        } else {
          rej();
        }
      }, delayInMs);
    });
  }
  initRender() {
    setTimeout(() => {
      const renderElm = this.renderElm?.nativeElement;
      if (renderElm != null) {
        const bounds = renderElm.getBoundingClientRect();
        this.relX = bounds.left;
        this.relY = bounds.top;
        this.relWidth = renderElm.offsetWidth;
        this.relHeight = renderElm.offsetHeight;
        this.initAttributes();
        this.initFloors();
      }
    }, 250);
  }
  get fixtures() {
    return this.selectedFloor?.fixtures ?? [];
  }
  removeFixture() {
    return __async(this, null, function* () {
      if (this.selectedFixture != null) {
        this.stopEditingFixture();
        for (var i = 0, len = this.fixtures.length; i < len; i++) {
          const fixture = this.fixtures[i];
          if (fixture.id == this.selectedFixture.id) {
            this.fixtures.splice(i, 1);
            this.selectedFixture = void 0;
            this.update();
            break;
          }
        }
        if (this.selectedFloor != null) {
          yield this.render();
        }
      }
    });
  }
  stopSelectingFixtures() {
    this.selectingFixture = false;
  }
  selectFixtures() {
    this.selectingFixture = true;
  }
  selectFixture(fixture) {
    if (!fixture.moving && this.selectedFixture?.id != fixture.id) {
      if (this.selectedFixture?.id == fixture.id) {
        this.stopEditingFixture();
      } else {
        this.selectedFixture = fixture;
        this.editingFixture = true;
      }
    }
  }
  stopEditingFixture() {
    return __async(this, null, function* () {
      window.clearTimeout(this.editingFixtureTimer);
      this.editingFixture = false;
      this.editingFixtureTimer = window.setTimeout(() => __async(this, null, function* () {
        this.selectedFixture = void 0;
        if (this.selectedFloor != null) {
          yield this.render();
        }
      }), 250);
    });
  }
  addFixture(fixture) {
    return __async(this, null, function* () {
      if (this.selectedFloor != null) {
        fixture.renderDimensions.x = this.relWidth / 2 - window.innerWidth * 0.02;
        fixture.renderDimensions.y = this.relHeight / 2 - window.innerWidth * 0.02;
        this.selectedFloor.fixtures.push(fixture);
        this.stopSelectingFixtures();
        this.selectFixture(fixture);
        yield this.render();
      }
    });
  }
  promptToDeleteFixture(fixture) {
    this.fixtureToDelete = fixture;
    this.showDeleteFixturePrompt = true;
  }
  cancelDeletingFixture() {
    this.showDeleteFixturePrompt = false;
    this.fixtureToDelete = void 0;
  }
  get rooms() {
    return this.selectedFloor?.entities ?? [];
  }
  removeRoom() {
    return __async(this, null, function* () {
      if (this.selectedRoom != null && this.selectedFloor != null) {
        this.stopEditingRoom(false);
        for (var i = 0, len = this.selectedFloor.entities.length; i < len; i++) {
          const room = this.selectedFloor.entities[i];
          if (room.id == this.selectedRoom.id) {
            this.selectedFloor.entities.splice(i, 1);
            for (var j = 0, jlen = this.selectedFloor.attributes.length; j < jlen; j++) {
              const attribute = this.selectedFloor.attributes[j];
              const name = attribute.name.toLowerCase();
              if (name == "number of bathrooms on floor") {
                attribute.values = [`${this.selectedFloor.entities.length}`];
              }
            }
            this.selectedRoom = void 0;
            this.update();
            break;
          }
        }
        yield this.render();
      }
    });
  }
  selectRoom(room) {
    if (!room.moving && !room.resizing && this.selectedRoom?.id != room.id) {
      this.selectedRoom = room;
      this.editingRoom = true;
    }
  }
  stopEditingRoom(showTip = true) {
    return __async(this, null, function* () {
      window.clearTimeout(this.roomEditingTimer);
      this.editingRoom = false;
      this.roomEditingTimer = window.setTimeout(() => __async(this, null, function* () {
        this.selectedRoom = void 0;
        if (this.selectedFloor != null) {
          yield this.render();
        }
      }), 250);
    });
  }
  addRoom() {
    return __async(this, null, function* () {
      if (this.selectedFloor != null && this.availableRoom != null) {
        let width = Math.round(this.relWidth / 2.5);
        let height = width;
        if (width <= 0) {
          width = 200;
        }
        if (height <= 0) {
          height = 200;
        }
        let x = Math.round(this.relWidth / 2 - width / 2);
        let y = Math.round(this.relHeight / 2 - height / 2);
        const attributes = this.uiService.deepClone(this.availableRoom.attributes);
        const mappedAttributes = this.appointmentService.mapAttributes(attributes);
        const newRoom = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableRoom.entityId, this.availableRoom.type, "New Room", 1, mappedAttributes, [], new RenderDimensions(x, y, width, height, 0), {}, [], [], [], void 0, void 0, {});
        this.selectedFloor.entities.push(newRoom);
        this.selectRoom(newRoom);
        yield this.render();
      }
    });
  }
  get floors() {
    return this.structure?.entities ?? [];
  }
  selectFloor(floor) {
    return __async(this, null, function* () {
      if (this.selectedFloor != null) {
        this.selectedFloor.active = false;
      }
      this.selectedFloor = floor;
      floor.active = true;
      this.initFloorAttributes();
      this.initNotes();
    });
  }
  addFloor() {
    if (this.structure != null && this.availableFloor != null) {
      let width = this.relWidth;
      let height = this.relHeight;
      const attributes = this.uiService.deepClone(this.availableFloor.attributes);
      const mappedAttributes = this.appointmentService.mapAttributes(attributes);
      const newFloor = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableFloor.entityId, this.availableFloor.type, "New Floor", 1, mappedAttributes, [], new RenderDimensions(0, 0, width, height, 0), {}, [], [], [], void 0, void 0, {});
      this.structure.entities.push(newFloor);
      this.selectFloor(newFloor);
    }
  }
  initFloors() {
    if (this.floors.length <= 0) {
      this.addFloor();
    } else {
      this.selectFloor(this.floors[0]);
    }
  }
  // #endregion
  // #region Photos
  managePhotos() {
    if (this.selectedFloor != null) {
      this.localAppointmentService.managePhotos(this.selectedFloor);
    }
  }
  killEvent(e) {
    e.stopPropagation();
  }
  get canClose() {
    return true;
  }
  closeView() {
    return __async(this, null, function* () {
      this.render(0).finally(() => {
        this.close.next();
      });
    });
  }
  init() {
    this.initRender();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_StructureComponent.\u0275fac = function StructureComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _StructureComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(InspectionService));
};
_StructureComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _StructureComponent, selectors: [["structure"]], viewQuery: function StructureComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c08, 5);
    \u0275\u0275viewQuery(_c12, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.renderElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", availableFloor: "availableFloor", availableRoom: "availableRoom", availableUnit: "availableUnit", availableStructure: "availableStructure", availableEntities: "availableEntities", availableFixtures: "availableFixtures", structure: "structure" }, outputs: { close: "close" }, standalone: false, decls: 17, vars: 14, consts: [["renderElm", ""], ["fixtureElm", ""], ["roomElm", ""], ["id", "structure"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click"], [1, "control"], [1, "control", "success", 3, "click", "disabled"], ["id", "roomView"], [1, "bg"], [3, "appointment", "room", "parent", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure"], ["id", "fixture"], [3, "appointment", "fixture", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure"], ["id", "structure", 3, "touchend", "mouseup"], [1, "columns"], [1, "column", "floors"], [1, "content", "diagram"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-plus"], [1, "fa-solid", "fa-toilet"], [1, "fa-solid", "fa-camera"], [1, "render", 3, "mousemove", "touchmove"], [1, "rear"], ["xmlns", "http://www.w3.org/2000/svg", "viewBox", "0 0 384 512"], ["d", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z"], [1, "front"], ["d", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"], [1, "fixtures"], [1, "fixture", 3, "transform"], [1, "rooms"], [1, "room", 3, "transform"], [1, "structure", "column"], [1, "content"], [1, "floor"], [1, "tooltip"], [1, "floors"], [1, "notes"], [1, "note"], ["rows", "5", "placeholder", "If you have any notes for our customer, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["rows", "5", "placeholder", "If you have any notes important for the shop, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["id", "standaloneFloorAttributes"], [1, "attributes"], [3, "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "renderElm", "headerLabel", "saveLabel"], ["id", "standaloneAttributes"], ["id", "fixtures"], [3, "close", "selectedFixture", "appointment"], [1, "fixture", 3, "mouseup", "touchend"], [3, "touchstart", "mousedown", "fixture"], [1, "warning", "no-render"], [1, "room", 3, "mouseup", "touchend"], [3, "mousedown", "touchstart", "room", "parentElm"], [1, "floors-wrap"], [1, "floor", 3, "active", "warning"], [1, "floor", 3, "click"], [1, "message"], [3, "close", "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "renderElm", "headerLabel", "saveLabel"], [3, "click", "close", "appointment", "room", "parent", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure"], [3, "click", "close", "deleted", "appointment", "fixture", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure"]], template: function StructureComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, StructureComponent_Conditional_0_Template, 77, 22, "section", 3);
    \u0275\u0275elementStart(1, "nav", 4)(2, "div", 5)(3, "div", 6)(4, "button", 7);
    \u0275\u0275listener("click", function StructureComponent_Template_button_click_4_listener() {
      return ctx.editAttributes();
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(7, StructureComponent_Conditional_7_Template, 3, 1, "button", 8);
    \u0275\u0275elementStart(8, "button", 9);
    \u0275\u0275listener("click", function StructureComponent_Template_button_click_8_listener() {
      return ctx.closeView();
    });
    \u0275\u0275conditionalCreate(9, StructureComponent_Conditional_9_Template, 2, 1, "label");
    \u0275\u0275conditionalCreate(10, StructureComponent_Conditional_10_Template, 2, 1, "label");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(11, "aside", 10);
    \u0275\u0275element(12, "div", 11);
    \u0275\u0275conditionalCreate(13, StructureComponent_Conditional_13_Template, 1, 9, "room", 12);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "aside", 13);
    \u0275\u0275element(15, "div", 11);
    \u0275\u0275conditionalCreate(16, StructureComponent_Conditional_16_Template, 1, 7, "fixture", 14);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.structure != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("hidden", ctx.editingRoom || ctx.editingFixture || ctx.editingAttributes || ctx.editingFloorAttributes);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1("Change ", ctx.structure == null ? null : ctx.structure.name, " Details");
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.selectedFloor != null ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canClose);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canModifyAppointment ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.canModifyAppointment ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.editingRoom);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.selectedRoom != null ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.editingFixture);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.selectedFixture != null ? 16 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel, StandaaloneAttributesComponent, FixtureComponent, FixturesComponent, FixtureRenderComponent, RoomComponent, RoomRenderComponent], styles: ['\n\n#structure[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 4vw;\n  right: 0;\n  bottom: 6vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%] {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  padding: 0.75vw 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > i[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  position: absolute;\n  visibility: hidden;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%] {\n  width: 75%;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  flex: 1;\n  background-color: var(--color2);\n  position: relative;\n  overflow: hidden;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  display: flex;\n  align-items: center;\n  pointer-events: none;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%]    > svg[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%]    > svg[_ngcontent-%COMP%] {\n  height: 1.2vw;\n  fill: var(--color1);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin: 0 1vw;\n  font-size: 1.4vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  white-space: nowrap;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .front[_ngcontent-%COMP%] {\n  bottom: 0.5vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rear[_ngcontent-%COMP%] {\n  top: 0.5vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  cursor: pointer;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  will-change: transform;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]   fixture-render[_ngcontent-%COMP%] {\n  display: block;\n  width: 5.5vw;\n  height: 5.5vw;\n  position: relative;\n  --fixtureFontSize: .8vw;\n  will-change: transform;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 0.8vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .fixtures[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-style: italic;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rooms[_ngcontent-%COMP%]   .room[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 2;\n  background-color: var(--color2);\n  will-change: transform;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rooms[_ngcontent-%COMP%]   .room[_ngcontent-%COMP%]    > room-render[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  cursor: pointer;\n  --roomFontSize: 1.6vw;\n  will-change: transform;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rooms[_ngcontent-%COMP%]   .room[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rooms[_ngcontent-%COMP%]   .room[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rooms[_ngcontent-%COMP%]   .room[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-style: italic;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.floors[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .rooms[_ngcontent-%COMP%]   .room.hovering[_ngcontent-%COMP%]:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color3-raw), 0.2);\n  z-index: 1;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%] {\n  width: 25%;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 1.5vw;\n  background-color: var(--color4Alt3);\n  border-left: 0.2vw var(--color4Alt4) solid;\n  justify-content: center;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%] {\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt2);\n  padding: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%] {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n  line-height: 1;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  width: 100%;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  margin-top: 0.25vw;\n  cursor: pointer;\n  padding: 0.25vw 0.5vw;\n  border-radius: 999px;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2Alt1);\n  text-align: center;\n  -moz-transition: background-color 0.2s, border-color 0.2s;\n  -o-transition: background-color 0.2s, border-color 0.2s;\n  -webkit-transition: background-color 0.2s, border-color 0.2s;\n  transition: background-color 0.2s, border-color 0.2s;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  text-align: center;\n  font-size: 1vw;\n  color: var(--color2Alt1);\n  font-weight: var(--strong);\n  display: block;\n  display: none;\n  text-transform: uppercase;\n  font-style: italic;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor.active[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor.active[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%]:not(.active).warning {\n  border-radius: 1.5vw;\n  border-color: var(--errorAlt4);\n  background-color: var(--error);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%]:not(.active).warning    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%]:not(.active).warning    > .message[_ngcontent-%COMP%] {\n  display: block;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .floors[_ngcontent-%COMP%]    > .floors-wrap[_ngcontent-%COMP%]    > .floor[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%] {\n  padding: 1vw;\n  border: 0.2vw transparent solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt3);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  margin-bottom: 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  padding-bottom: 0.5vw;\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  line-height: 1;\n  text-transform: uppercase;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 2vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  cursor: pointer;\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  background-color: var(--success);\n  text-align: center;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structure[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.floor[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#structure[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  border-left: none;\n}\n#structure[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   #standaloneFloorAttributes[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structure[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   #standaloneFloorAttributes[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 4;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#structure[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   #standaloneFloorAttributes.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structure[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   #standaloneFloorAttributes.active[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#structure[_ngcontent-%COMP%]   #fixtures[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color1-raw), 0.1);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structure[_ngcontent-%COMP%]   #fixtures[_ngcontent-%COMP%]    > fixtures[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 20%;\n  right: 20%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#structure[_ngcontent-%COMP%]   #fixtures.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structure[_ngcontent-%COMP%]   #fixtures.active[_ngcontent-%COMP%]    > fixtures[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#structure[_ngcontent-%COMP%]   #fixture[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structure[_ngcontent-%COMP%]   #fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: auto;\n  right: 0;\n  bottom: 0;\n  width: 45%;\n  z-index: 4;\n  background-color: var(--color2Alt1);\n  overflow: hidden;\n  pointer-events: none;\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n  -moz-transition: transform 0.2s;\n  -o-transition: transform 0.2s;\n  -webkit-transition: transform 0.2s;\n  transition: transform 0.2s;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#structure[_ngcontent-%COMP%]   #fixture.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structure[_ngcontent-%COMP%]   #fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%], \n#structure[_ngcontent-%COMP%]   #fixture.active[_ngcontent-%COMP%]    > room[_ngcontent-%COMP%] {\n  pointer-events: initial;\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n#structure[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%] {\n  z-index: 2;\n}\n#structure[_ngcontent-%COMP%]   .tooltip.general[_ngcontent-%COMP%] {\n  bottom: 1vw;\n  right: 1vw;\n  width: 22vw;\n}\n#structure[_ngcontent-%COMP%]   .tooltip.general[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n}\n#structure[_ngcontent-%COMP%]   .tooltip.general[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 3;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes _ngcontent-%COMP%_childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#roomView[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 5;\n  background-color: rgba(var(--color2Alt1-raw), 0.7);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#roomView[_ngcontent-%COMP%]    > room[_ngcontent-%COMP%]     #room {\n  z-index: 6;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadOut;\n  animation-name: _ngcontent-%COMP%_childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#roomView[_ngcontent-%COMP%]    > room[_ngcontent-%COMP%]     #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#roomView.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#roomView.active[_ngcontent-%COMP%]    > room[_ngcontent-%COMP%]     #room {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadIn;\n  animation-name: _ngcontent-%COMP%_childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#roomView.active[_ngcontent-%COMP%]    > room[_ngcontent-%COMP%]     #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 5;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #fixture {\n  z-index: 6;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadOut;\n  animation-name: _ngcontent-%COMP%_childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #fixture {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadIn;\n  animation-name: _ngcontent-%COMP%_childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=structure.component.css.map */'] });
var StructureComponent = _StructureComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(StructureComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "structure", template: `@if (structure != null) {
  <section id="structure"
    (window:touchend)="stopMoving($event)"
    (window:mouseup)="stopMoving($event)">
    <div class="columns">
      <div class="column floors">
        <div class="content diagram">
          <header>
            <div class="controls">
              <button class="control" [disabled]="!canModifyAppointment" (click)="selectFixtures()">
                <i class="fa-solid fa-plus"></i>
                <label>Add Fixture Outside Bathroom(s)</label>
              </button>
              <button class="control" [disabled]="!canModifyAppointment" (click)="editFloorAttributes()">
                <i class="fa-solid fa-toilet"></i>
                <label>Change Number of Bathrooms</label>
              </button>
              <button class="control" [disabled]="!canModifyAppointment" (click)="managePhotos()">
                <i class="fa-solid fa-camera"></i>
                <label>Manage {{selectedFloor?.name}} Photo(s)</label>
              </button>
            </div>
          </header>
          <div class="render" (mousemove)="moveEntity($event)" (touchmove)="moveEntity($event)" #renderElm>
            <div class="rear">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z" />
              </svg>
              <label>Rear of Property</label>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z" />
              </svg>
            </div>
            <div class="front">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z" />
              </svg>
              <label>Front of Property</label>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path
                  d="M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z" />
              </svg>
            </div>
            <div class="fixtures">
              @for (fixture of fixtures; track fixture) {
                <div class="fixture" #fixtureElm (mouseup)="selectFixture(fixture)"
                  (touchend)="selectFixture(fixture)"
                  [style.transform]="fixture.renderDimensions.transform">
                  <fixture-render [fixture]="fixture" (touchstart)="startMoving($event,fixtureElm,fixture)"
                  (mousedown)="startMoving($event,fixtureElm,fixture)"></fixture-render>
                  <footer>
                    @if (!fixture.valid) {
                      <p class="warning no-render">
                        Missing Information
                      </p>
                    }
                  </footer>
                </div>
              }
            </div>
            <div class="rooms">
              @for (room of rooms; track room) {
                <div class="room"
                  (mouseup)="selectRoom(room)"
                  (touchend)="selectRoom(room)" #roomElm
                  [style.transform]="room.renderDimensions.transform">
                  <room-render [room]="room" [parentElm]="renderElm"
                    [style.width]="room.renderDimensions.widthCss"
                    [style.height]="room.renderDimensions.widthCss"
                    (mousedown)="startMoving($event,roomElm,room)"
                  (touchstart)="startMoving($event,roomElm,room)"></room-render>
                  <footer>
                    @if (!room.valid) {
                      <p class="warning no-render">
                        Missing Information
                      </p>
                    }
                  </footer>
                </div>
              }
            </div>
          </div>
        </div>
      </div>
      <div class="structure column">
        <div class="content">
          <header>
            <h2>
              Inspecting the
              <span class="floor">{{selectedFloor?.name}}</span>
              of the
              {{structure.name}}
            </h2>
          </header>
          <div class="content">
            <div class="tooltip">
              <h3>Tip: Inspecting the Floor</h3>
              <p>
                #1: Add fixtures that aren't in bathrooms or...
              </p>
              <p>
                #2: Tap on a bathroom to work inside.
              </p>
            </div>
            @if (floors.length > 1) {
              <div class="floors">
                <header>
                  <h3>Switch to Another Floor</h3>
                </header>
                <div class="floors-wrap">
                  @for (floor of floors; track floor) {
                    <button class="floor"
                      [class.active]="selectedFloor?.id == floor.id"
                      [class.warning]="!floor.valid"
                      (click)="selectFloor(floor)"
                      >
                      <label>{{floor.name}}</label>
                      <span class="message">
                        Missing Information
                      </span>
                    </button>
                  }
                </div>
              </div>
            }
            <div class="notes">
              <div class="note">
                <label>{{selectedFloor?.name}} Notes for the Customer</label>
                <textarea
                  [disabled]="!canModifyAppointment"
                  rows="5"
                  placeholder="If you have any notes for our customer, you can enter them here..."
                  (input)="updateNotes(NoteAudience.Customer)"
                [(ngModel)]="customerNotes"></textarea>
              </div>
              <div class="note">
                <label>{{selectedFloor?.name}} Notes for the Shop</label>
                <textarea
                  [disabled]="!canModifyAppointment"
                  rows="5"
                  placeholder="If you have any notes important for the shop, you can enter them here..."
                  (input)="updateNotes(NoteAudience.Shop)"
                [(ngModel)]="shopNotes"></textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <aside id="standaloneFloorAttributes" [class.active]="editingFloorAttributes">
      <div class="bg"></div>
      <div class="attributes">
        @if (selectedFloor != null) {
          <standalone-attributes
            [appointment]="appointment"
            [entity]="selectedFloor"
            [availableEntities]="availableEntities"
            [availableFixtures]="availableFixtures"
            [availableFloor]="availableFloor"
            [availableRoom]="availableRoom"
            [availableUnit]="availableUnit"
            [availableStructure]="availableStructure"
            [attributes]="selectedFloor.attributes"
            [renderElm]="renderElm"
            [headerLabel]="'Which Floor Are You Working On?'"
            [saveLabel]="'Continue Inspecting Floor'"
          (close)="stopEditingFloorAttributes()"></standalone-attributes>
        }
      </div>
    </aside>
    <aside id="standaloneAttributes" [class.active]="editingAttributes">
      <div class="bg"></div>
      <div class="attributes">
        @if (showAttributesUI) {
          <standalone-attributes
            [appointment]="appointment"
            [entity]="structure"
            [availableEntities]="availableEntities"
            [availableFixtures]="availableFixtures"
            [availableFloor]="availableFloor"
            [availableRoom]="availableRoom"
            [availableUnit]="availableUnit"
            [availableStructure]="availableStructure"
            [attributes]="attributes"
            [renderElm]="renderElm"
            [headerLabel]="'Please Complete Structure Details'"
            [saveLabel]="'Continue Inspecting Structure'"
          (close)="stopEditingAttributes()"></standalone-attributes>
        }
      </div>
    </aside>
    <aside id="fixtures" [class.active]="selectingFixture">
      <div class="bg"></div>
      <fixtures
        [appointment]="appointment"
        (close)="stopSelectingFixtures()"
        (selectedFixture)="addFixture($event)">
      </fixtures>
    </aside>
  </section>
}

<nav id="mainNav" [class.hidden]="editingRoom || editingFixture || editingAttributes || editingFloorAttributes">
  <div class="island">
    <div class="controls">
      <button class="control" (click)="editAttributes()">
        <label>Change {{structure?.name}} Details</label>
      </button>
      @if (selectedFloor != null) {
        <button class="control" (click)="editFloorAttributes()">
          <label>Change {{selectedFloor.name}} Details</label>
        </button>
      }
      <button class="control success" [disabled]="!canClose" (click)="closeView()">
        @if (canModifyAppointment) {
          <label>Save & Close {{structure?.name}}</label>
        }
        @if (!canModifyAppointment) {
          <label>Close {{structure?.name}}</label>
        }
      </button>
    </div>
  </div>
</nav>

<aside id="roomView" [class.active]="editingRoom">
  <div class="bg"></div>

  @if (selectedRoom != null) {
    <room
      (click)="killEvent($event)"
      [appointment]="appointment"
      [room]="selectedRoom"
      (close)="stopEditingRoom()"
      [parent]="selectedFloor"
      [availableEntities]="availableEntities"
      [availableFixtures]="availableFixtures"
      [availableFloor]="availableFloor"
      [availableRoom]="availableRoom"
      [availableUnit]="availableUnit"
      [availableStructure]="availableStructure">
    </room>
  }
</aside>

<aside id="fixture" [class.active]="editingFixture">
  <div class="bg"></div>

  @if (selectedFixture != null) {
    <fixture
      (click)="killEvent($event)"
      [appointment]="appointment"
      [fixture]="selectedFixture"
      (close)="stopEditingFixture()"
      (deleted)="removeFixture()"
      [availableEntities]="availableEntities"
      [availableFixtures]="availableFixtures"
      [availableFloor]="availableFloor"
      [availableRoom]="availableRoom"
    [availableStructure]="availableStructure"></fixture>
  }
</aside>`, styles: ['/* src/app/appointment/inspection/components/structure/structure.component.scss */\n#structure {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 4vw;\n  right: 0;\n  bottom: 6vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#structure .columns {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#structure .columns > .column {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#structure .columns > .column > .content {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#structure .columns > .column > .content > header {\n  display: flex;\n  justify-content: flex-end;\n  padding: 0.75vw 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#structure .columns > .column > .content > header > h2 {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#structure .columns > .column > .content > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#structure .columns > .column > .content > header > .controls > .control {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#structure .columns > .column > .content > header > .controls > .control > i,\n#structure .columns > .column > .content > header > .controls > .control > label {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#structure .columns > .column > .content > header > .controls > .control > i {\n  font-size: 1.2vw;\n}\n#structure .columns > .column > .content > header > .controls > .control > label {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#structure .columns > .column > .content > header > .controls > .control:active > i,\n#structure .columns > .column > .content > header > .controls > .control:active > label {\n  color: var(--color5);\n}\n#structure .columns > .column > .content > header > .controls > .control[disabled] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#structure .columns > .column > .content > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#structure .columns > .column > .content > header > .controls > input {\n  position: absolute;\n  visibility: hidden;\n}\n#structure .columns > .column > .content > .content {\n  flex: 1;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n}\n#structure .columns > .column > .content > .content > .control {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#structure .columns > .column > .content > .content > .control > i {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#structure .columns > .column > .content > .content > .control > label {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#structure .columns > .column.floors {\n  width: 75%;\n}\n#structure .columns > .column.floors > .diagram {\n  position: relative;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n#structure .columns > .column.floors > .diagram > .render {\n  flex: 1;\n  background-color: var(--color2);\n  position: relative;\n  overflow: hidden;\n}\n#structure .columns > .column.floors > .diagram > .render > .front,\n#structure .columns > .column.floors > .diagram > .render > .rear {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  display: flex;\n  align-items: center;\n  pointer-events: none;\n}\n#structure .columns > .column.floors > .diagram > .render > .front > svg,\n#structure .columns > .column.floors > .diagram > .render > .rear > svg {\n  height: 1.2vw;\n  fill: var(--color1);\n}\n#structure .columns > .column.floors > .diagram > .render > .front > label,\n#structure .columns > .column.floors > .diagram > .render > .rear > label {\n  margin: 0 1vw;\n  font-size: 1.4vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  white-space: nowrap;\n}\n#structure .columns > .column.floors > .diagram > .render > .front {\n  bottom: 0.5vw;\n}\n#structure .columns > .column.floors > .diagram > .render > .rear {\n  top: 0.5vw;\n}\n#structure .columns > .column.floors > .diagram > .render > .fixtures .fixture {\n  position: absolute;\n  z-index: 1;\n  cursor: pointer;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  will-change: transform;\n}\n#structure .columns > .column.floors > .diagram > .render > .fixtures .fixture fixture-render {\n  display: block;\n  width: 5.5vw;\n  height: 5.5vw;\n  position: relative;\n  --fixtureFontSize: .8vw;\n  will-change: transform;\n}\n#structure .columns > .column.floors > .diagram > .render > .fixtures .fixture > footer {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#structure .columns > .column.floors > .diagram > .render > .fixtures .fixture > footer > p {\n  font-size: 0.8vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#structure .columns > .column.floors > .diagram > .render > .fixtures .fixture > footer > p.warning {\n  color: var(--error);\n  font-style: italic;\n}\n#structure .columns > .column.floors > .diagram > .render > .rooms .room {\n  position: absolute;\n  z-index: 2;\n  background-color: var(--color2);\n  will-change: transform;\n}\n#structure .columns > .column.floors > .diagram > .render > .rooms .room > room-render {\n  display: block;\n  position: relative;\n  cursor: pointer;\n  --roomFontSize: 1.6vw;\n  will-change: transform;\n}\n#structure .columns > .column.floors > .diagram > .render > .rooms .room > footer {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#structure .columns > .column.floors > .diagram > .render > .rooms .room > footer > p {\n  font-size: 1vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#structure .columns > .column.floors > .diagram > .render > .rooms .room > footer > p.warning {\n  color: var(--error);\n  font-style: italic;\n}\n#structure .columns > .column.floors > .diagram > .render > .rooms .room.hovering:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color3-raw), 0.2);\n  z-index: 1;\n}\n#structure .columns > .column.structure {\n  width: 25%;\n}\n#structure .columns > .column.structure > .content > header {\n  padding: 1vw 1.5vw;\n  background-color: var(--color4Alt3);\n  border-left: 0.2vw var(--color4Alt4) solid;\n  justify-content: center;\n}\n#structure .columns > .column.structure > .content > header > h2 {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#structure .columns > .column.structure > .content > header > h2 > .floor {\n  font-weight: var(--stronger);\n  font-style: italic;\n}\n#structure .columns > .column.structure > .content > .content {\n  background-color: var(--color2Alt2);\n  padding: 1vw;\n}\n#structure .columns > .column.structure > .content > .content .tooltip {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#structure .columns > .column.structure > .content > .content .tooltip h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n  line-height: 1;\n}\n#structure .columns > .column.structure > .content > .content .tooltip p {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#structure .columns > .column.structure > .content > .content > .notes {\n  margin-top: 1vw;\n}\n#structure .columns > .column.structure > .content > .content > .notes > .note {\n  margin-top: 1vw;\n}\n#structure .columns > .column.structure > .content > .content > .notes > .note label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#structure .columns > .column.structure > .content > .content > .notes > .note textarea {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#structure .columns > .column.structure > .content > .content > .notes > .note:first-child {\n  margin-top: 0;\n}\n#structure .columns > .column.structure > .content > .content > .floors > header h3 {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n  width: 100%;\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap {\n  margin-top: 0.5vw;\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor {\n  display: block;\n  width: 100%;\n  margin-top: 0.25vw;\n  cursor: pointer;\n  padding: 0.25vw 0.5vw;\n  border-radius: 999px;\n  border: 0.1vw var(--color2Alt4) solid;\n  background-color: var(--color2Alt1);\n  text-align: center;\n  -moz-transition: background-color 0.2s, border-color 0.2s;\n  -o-transition: background-color 0.2s, border-color 0.2s;\n  -webkit-transition: background-color 0.2s, border-color 0.2s;\n  transition: background-color 0.2s, border-color 0.2s;\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor label {\n  display: block;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color1);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor > .message {\n  text-align: center;\n  font-size: 1vw;\n  color: var(--color2Alt1);\n  font-weight: var(--strong);\n  display: block;\n  display: none;\n  text-transform: uppercase;\n  font-style: italic;\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor.active {\n  background-color: var(--color3);\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor.active > label {\n  color: var(--color2);\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor:not(.active).warning {\n  border-radius: 1.5vw;\n  border-color: var(--errorAlt4);\n  background-color: var(--error);\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor:not(.active).warning > label {\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor:not(.active).warning > .message {\n  display: block;\n}\n#structure .columns > .column.structure > .content > .content > .floors > .floors-wrap > .floor:first-child {\n  margin-top: 0;\n}\n#structure .columns > .column.structure > .content > .content > .attributes {\n  margin-top: 1vw;\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor {\n  padding: 1vw;\n  border: 0.2vw transparent solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt3);\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > header {\n  margin-bottom: 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  padding-bottom: 0.5vw;\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > header > .primary h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > header > .primary h4 {\n  line-height: 1;\n  text-transform: uppercase;\n  font-size: 1vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > header > .image img {\n  height: 2vw;\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > .controls {\n  margin-top: 1vw;\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > .controls > .control {\n  display: block;\n  width: 100%;\n  cursor: pointer;\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  background-color: var(--success);\n  text-align: center;\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > .controls > .control.alternate {\n  background-color: var(--color3);\n}\n#structure .columns > .column.structure > .content > .content > .attributes.floor > .controls > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#structure .columns > .column:first-child {\n  border-left: none;\n}\n#structure #standaloneAttributes > .bg,\n#structure #standaloneFloorAttributes > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structure #standaloneAttributes > .attributes,\n#structure #standaloneFloorAttributes > .attributes {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 4;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#structure #standaloneAttributes.active > .bg,\n#structure #standaloneFloorAttributes.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structure #standaloneAttributes.active > .attributes,\n#structure #standaloneFloorAttributes.active > .attributes {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#structure #fixtures > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color1-raw), 0.1);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structure #fixtures > fixtures {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 20%;\n  right: 20%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#structure #fixtures.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structure #fixtures.active > fixtures {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#structure #fixture > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structure #fixture > fixture {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: auto;\n  right: 0;\n  bottom: 0;\n  width: 45%;\n  z-index: 4;\n  background-color: var(--color2Alt1);\n  overflow: hidden;\n  pointer-events: none;\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n  -moz-transition: transform 0.2s;\n  -o-transition: transform 0.2s;\n  -webkit-transition: transform 0.2s;\n  transition: transform 0.2s;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#structure #fixture.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structure #fixture.active > fixture,\n#structure #fixture.active > room {\n  pointer-events: initial;\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n#structure .tooltip {\n  z-index: 2;\n}\n#structure .tooltip.general {\n  bottom: 1vw;\n  right: 1vw;\n  width: 22vw;\n}\n#structure .tooltip.general h3 {\n  font-size: 1.6vw;\n}\n#structure .tooltip.general p {\n  font-size: 1.5vw;\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 3;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#roomView > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 5;\n  background-color: rgba(var(--color2Alt1-raw), 0.7);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#roomView > room ::ng-deep #room {\n  z-index: 6;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: childLoadOut;\n  animation-name: childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#roomView > room ::ng-deep #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: childNavLoadOut;\n  animation-name: childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#roomView.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#roomView.active > room ::ng-deep #room {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: childLoadIn;\n  animation-name: childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#roomView.active > room ::ng-deep #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: childNavLoadIn;\n  animation-name: childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 5;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#fixture > fixture ::ng-deep #fixture {\n  z-index: 6;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: childLoadOut;\n  animation-name: childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture > fixture ::ng-deep #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: childNavLoadOut;\n  animation-name: childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#fixture.active > fixture ::ng-deep #fixture {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: childLoadIn;\n  animation-name: childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active > fixture ::ng-deep #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: childNavLoadIn;\n  animation-name: childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=structure.component.css.map */\n'] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }, { type: InspectionService }], { appointment: [{
    type: Input
  }], availableFloor: [{
    type: Input,
    args: ["availableFloor"]
  }], availableRoom: [{
    type: Input,
    args: ["availableRoom"]
  }], availableUnit: [{
    type: Input,
    args: ["availableUnit"]
  }], availableStructure: [{
    type: Input,
    args: ["availableStructure"]
  }], availableEntities: [{
    type: Input,
    args: ["availableEntities"]
  }], availableFixtures: [{
    type: Input,
    args: ["availableFixtures"]
  }], structure: [{
    type: Input,
    args: ["structure"]
  }], renderElm: [{
    type: ViewChild,
    args: ["renderElm"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(StructureComponent, { className: "StructureComponent" });
})();

// src/app/appointment/inspection/components/structure-render/structure-render.component.ts
var _c09 = ["componentElm"];
function StructureRenderComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 0)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 1);
    \u0275\u0275listener("mousemove", function StructureRenderComponent_Conditional_0_Template_div_mousemove_3_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.resize($event));
    }, \u0275\u0275resolveWindow)("touchmove", function StructureRenderComponent_Conditional_0_Template_div_touchmove_3_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.resize($event));
    }, \u0275\u0275resolveWindow)("mouseup", function StructureRenderComponent_Conditional_0_Template_div_mouseup_3_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopResizing($event));
    }, \u0275\u0275resolveWindow)("touchend", function StructureRenderComponent_Conditional_0_Template_div_touchend_3_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopResizing($event));
    }, \u0275\u0275resolveWindow);
    \u0275\u0275elementStart(4, "div", 2);
    \u0275\u0275listener("mousedown", function StructureRenderComponent_Conditional_0_Template_div_mousedown_4_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "nw"));
    })("touchstart", function StructureRenderComponent_Conditional_0_Template_div_touchstart_4_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "nw"));
    });
    \u0275\u0275element(5, "i", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 4);
    \u0275\u0275listener("mousedown", function StructureRenderComponent_Conditional_0_Template_div_mousedown_6_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "ne"));
    })("touchstart", function StructureRenderComponent_Conditional_0_Template_div_touchstart_6_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "ne"));
    });
    \u0275\u0275element(7, "i", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "div", 6);
    \u0275\u0275listener("mousedown", function StructureRenderComponent_Conditional_0_Template_div_mousedown_8_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "se"));
    })("touchstart", function StructureRenderComponent_Conditional_0_Template_div_touchstart_8_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "se"));
    });
    \u0275\u0275element(9, "i", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "div", 7);
    \u0275\u0275listener("mousedown", function StructureRenderComponent_Conditional_0_Template_div_mousedown_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "sw"));
    })("touchstart", function StructureRenderComponent_Conditional_0_Template_div_touchstart_10_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.startResizing($event, "sw"));
    });
    \u0275\u0275element(11, "i", 5);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r1.structure.name);
  }
}
var _StructureRenderComponent = class _StructureRenderComponent {
  constructor(localAppointmentService, appointmentService, uiService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.resizeDirection = "";
    this.resizePositioning = {
      initialX: 0,
      initialY: 0,
      relX: 0,
      relY: 0,
      relHeight: 0,
      relWidth: 0,
      maxX: 0,
      maxY: 0,
      x: 0,
      y: 0
    };
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  startResizing(e, direction) {
    this.resizeDirection = direction;
    e.stopPropagation();
    const isTouch = "touches" in e && e instanceof TouchEvent;
    if (isTouch) {
      this.resizePositioning.initialX = e.touches[0].clientX;
      this.resizePositioning.initialY = e.touches[0].clientY;
    } else {
      this.resizePositioning.initialX = e.clientX;
      this.resizePositioning.initialY = e.clientY;
    }
    this.resizePositioning.relX = this.structure?.renderDimensions.x ?? 0;
    this.resizePositioning.relY = this.structure?.renderDimensions.y ?? 0;
    this.resizePositioning.relHeight = this.structure?.renderDimensions.height ?? 0;
    this.resizePositioning.relWidth = this.structure?.renderDimensions.width ?? 0;
    if (this.parentElm != null) {
      this.resizePositioning.maxX = this.parentElm.offsetWidth;
      this.resizePositioning.maxY = this.parentElm.offsetHeight;
    }
    if (this.structure != null) {
      this.structure.resizing = true;
    }
  }
  resize(e) {
    if (this.canModifyAppointment) {
      e.stopPropagation();
      switch (this.resizeDirection) {
        case "nw":
          this.resizeNw(e);
          break;
        case "ne":
          this.resizeNe(e);
          break;
        case "sw":
          this.resizeSw(e);
          break;
        case "se":
          this.resizeSe(e);
          break;
      }
    }
  }
  resizeNw(e) {
    if (this.structure != null) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.structure.resizing && this.structure.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.structure.renderDimensions.x = this.resizePositioning.relX - x;
          if (this.structure.renderDimensions.x < 0) {
            this.structure.renderDimensions.x = 0;
          } else {
            this.structure.renderDimensions.width = x + this.resizePositioning.relWidth;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth - x;
          if (newWidth < 140) {
            newWidth = 140;
          } else {
            this.structure.renderDimensions.x = this.resizePositioning.relX + x;
            const maxX = this.resizePositioning.maxX - this.structure.renderDimensions.width;
            if (this.structure.renderDimensions.x > maxX) {
              this.structure.renderDimensions.x = maxX;
              newWidth = this.structure.renderDimensions.width;
            }
          }
          this.structure.renderDimensions.width = newWidth;
        }
        if (deltaY < 0) {
          const y = Math.abs(deltaY);
          this.structure.renderDimensions.y = this.resizePositioning.relY - y;
          if (this.structure.renderDimensions.y < 0) {
            this.structure.renderDimensions.y = 0;
          } else {
            this.structure.renderDimensions.height = y + this.resizePositioning.relHeight;
          }
        } else {
          const y = Math.abs(deltaY);
          let newHeight = this.resizePositioning.relHeight - y;
          if (newHeight < 140) {
            newHeight = 140;
          } else {
            this.structure.renderDimensions.y = this.resizePositioning.relY + y;
            const maxY = this.resizePositioning.maxY - this.structure.renderDimensions.height;
            if (this.structure.renderDimensions.y > maxY) {
              this.structure.renderDimensions.y = maxY;
              newHeight = this.structure.renderDimensions.height;
            }
          }
          this.structure.renderDimensions.height = newHeight;
        }
      }
    }
  }
  resizeNe(e) {
    const isTouch = "touches" in e && e instanceof TouchEvent;
    if (this.structure != null) {
      if (this.structure.resizing && this.structure.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.structure.renderDimensions.width = this.resizePositioning.relWidth - x;
          if (this.structure.renderDimensions.width < 140) {
            this.structure.renderDimensions.width = 140;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth + x;
          const totalX = newWidth + this.structure.renderDimensions.x;
          if (totalX <= this.resizePositioning.maxX) {
            this.structure.renderDimensions.width = this.resizePositioning.relWidth + x;
          } else {
            this.structure.renderDimensions.width = this.resizePositioning.maxX - this.structure.renderDimensions.x;
          }
        }
        if (deltaY < 0) {
          const y = Math.abs(deltaY);
          this.structure.renderDimensions.y = this.resizePositioning.relY - y;
          if (this.structure.renderDimensions.y < 0) {
            this.structure.renderDimensions.y = 0;
          } else {
            this.structure.renderDimensions.height = y + this.resizePositioning.relHeight;
          }
        } else {
          const y = Math.abs(deltaY);
          let newHeight = this.resizePositioning.relHeight - y;
          if (newHeight < 140) {
            newHeight = 140;
          } else {
            this.structure.renderDimensions.y = this.resizePositioning.relY + y;
            const maxY = this.resizePositioning.maxY - this.structure.renderDimensions.height;
            if (this.structure.renderDimensions.y > maxY) {
              this.structure.renderDimensions.y = maxY;
              newHeight = this.structure.renderDimensions.height;
            }
          }
          this.structure.renderDimensions.height = newHeight;
        }
      }
    }
  }
  resizeSe(e) {
    if (this.structure != null) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.structure.resizing && this.structure?.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.structure.renderDimensions.width = this.resizePositioning.relWidth - x;
          if (this.structure.renderDimensions.width < 140) {
            this.structure.renderDimensions.width = 140;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth + x;
          const totalX = newWidth + this.structure.renderDimensions.x;
          if (totalX <= this.resizePositioning.maxX) {
            this.structure.renderDimensions.width = this.resizePositioning.relWidth + x;
          } else {
            this.structure.renderDimensions.width = this.resizePositioning.maxX - this.structure.renderDimensions.x;
          }
        }
        if (deltaY < 0) {
          const y = Math.abs(deltaY);
          this.structure.renderDimensions.height = this.resizePositioning.relHeight - y;
          if (this.structure.renderDimensions.height < 140) {
            this.structure.renderDimensions.height = 140;
          }
        } else {
          const y = Math.abs(deltaY);
          let newHeight = this.resizePositioning.relHeight + y;
          const totalY = newHeight + this.structure.renderDimensions.y;
          if (totalY <= this.resizePositioning.maxY) {
            this.structure.renderDimensions.height = this.resizePositioning.relHeight + y;
          } else {
            this.structure.renderDimensions.height = this.resizePositioning.maxY - this.structure.renderDimensions.y;
          }
        }
      }
    }
  }
  resizeSw(e) {
    if (this.structure != null) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.structure.resizing && this.structure?.renderDimensions != null) {
        if (isTouch) {
          this.resizePositioning.x = e.touches[0].clientX;
          this.resizePositioning.y = e.touches[0].clientY;
        } else {
          this.resizePositioning.x = e.clientX;
          this.resizePositioning.y = e.clientY;
        }
        const deltaX = this.resizePositioning.x - this.resizePositioning.initialX;
        const deltaY = this.resizePositioning.y - this.resizePositioning.initialY;
        if (deltaX < 0) {
          const x = Math.abs(deltaX);
          this.structure.renderDimensions.x = this.resizePositioning.relX - x;
          if (this.structure.renderDimensions.x < 0) {
            this.structure.renderDimensions.x = 0;
          } else {
            this.structure.renderDimensions.width = x + this.resizePositioning.relWidth;
          }
        } else {
          const x = Math.abs(deltaX);
          let newWidth = this.resizePositioning.relWidth - x;
          if (newWidth < 140) {
            newWidth = 140;
          } else {
            this.structure.renderDimensions.x = this.resizePositioning.relX + x;
            const maxX = this.resizePositioning.maxX - this.structure.renderDimensions.width;
            if (this.structure.renderDimensions.x > maxX) {
              this.structure.renderDimensions.x = maxX;
              newWidth = this.structure.renderDimensions.width;
            }
          }
          this.structure.renderDimensions.width = newWidth;
        }
        if (deltaY < 0) {
          const y = Math.abs(deltaY);
          this.structure.renderDimensions.height = this.resizePositioning.relHeight - y;
          if (this.structure.renderDimensions.height < 140) {
            this.structure.renderDimensions.height = 140;
          }
        } else {
          const y = Math.abs(deltaY);
          let newHeight = this.resizePositioning.relHeight + y;
          const totalY = newHeight + this.structure.renderDimensions.y;
          if (totalY <= this.resizePositioning.maxY) {
            this.structure.renderDimensions.height = this.resizePositioning.relHeight + y;
          } else {
            this.structure.renderDimensions.height = this.resizePositioning.maxY - this.structure.renderDimensions.y;
          }
        }
      }
    }
  }
  stopResizing(e) {
    e.stopPropagation();
    setTimeout(() => {
      if (this.structure != null) {
        this.structure.resizing = false;
        this.resizeDirection = "";
      }
    }, 0);
  }
  init() {
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_StructureRenderComponent.\u0275fac = function StructureRenderComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _StructureRenderComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService));
};
_StructureRenderComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _StructureRenderComponent, selectors: [["structure-render"]], viewQuery: function StructureRenderComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c09, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { parent: "parent", parentElm: "parentElm", structure: "structure" }, standalone: false, decls: 1, vars: 1, consts: [[1, "structure"], [1, "corners", "no-render", 3, "mousemove", "touchmove", "mouseup", "touchend"], [1, "corner", "nw", 3, "mousedown", "touchstart"], [1, "fa-solid", "fa-up-right-and-down-left-from-center", "fa-flip-horizontal"], [1, "corner", "ne", 3, "mousedown", "touchstart"], [1, "fa-solid", "fa-up-right-and-down-left-from-center"], [1, "corner", "se", 3, "mousedown", "touchstart"], [1, "corner", "sw", 3, "mousedown", "touchstart"]], template: function StructureRenderComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, StructureRenderComponent_Conditional_0_Template, 12, 1, "div", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.structure != null ? 0 : -1);
  }
}, styles: ["\n\n.structure[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border: 0.2vw var(--color1Alt1) solid;\n  background-color: var(--color2Alt2);\n}\n.structure[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  white-space: none;\n  color: var(--color1);\n  font-size: var(--structureFontSize);\n  font-weight: var(--strong);\n  display: block;\n  white-space: nowrap;\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 2vw;\n  width: 2vw;\n  background-color: var(--color2);\n  border: 0.2vw var(--color1) solid;\n  cursor: pointer;\n  z-index: 1;\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner[_ngcontent-%COMP%]    > i.fa-flip-horizontal[_ngcontent-%COMP%] {\n  -moz-transform: translate(-50%, -50%) scaleX(-1);\n  -ms-transform: translate(-50%, -50%) scaleX(-1);\n  -o-transform: translate(-50%, -50%) scaleX(-1);\n  -webkit-transform: translate(-50%, -50%) scaleX(-1);\n  transform: translate(-50%, -50%) scaleX(-1);\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.nw[_ngcontent-%COMP%] {\n  top: 0;\n  left: 0;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.ne[_ngcontent-%COMP%] {\n  top: 0;\n  right: 0;\n  -moz-transform: translate(50%, -50%);\n  -ms-transform: translate(50%, -50%);\n  -o-transform: translate(50%, -50%);\n  -webkit-transform: translate(50%, -50%);\n  transform: translate(50%, -50%);\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.sw[_ngcontent-%COMP%] {\n  bottom: 0;\n  left: 0;\n  -moz-transform: translate(-50%, 50%);\n  -ms-transform: translate(-50%, 50%);\n  -o-transform: translate(-50%, 50%);\n  -webkit-transform: translate(-50%, 50%);\n  transform: translate(-50%, 50%);\n}\n.structure[_ngcontent-%COMP%]    > .corners[_ngcontent-%COMP%]    > .corner.se[_ngcontent-%COMP%] {\n  bottom: 0;\n  right: 0;\n  -moz-transform: translate(50%, 50%);\n  -ms-transform: translate(50%, 50%);\n  -o-transform: translate(50%, 50%);\n  -webkit-transform: translate(50%, 50%);\n  transform: translate(50%, 50%);\n}\n/*# sourceMappingURL=structure-render.component.css.map */"] });
var StructureRenderComponent = _StructureRenderComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(StructureRenderComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "structure-render", template: `@if (structure != null) {
  <div class="structure">
    <label>{{structure.name}}</label>
    <div class="corners no-render"
      (window:mousemove)="resize($event)"
      (window:touchmove)="resize($event)"
      (window:mouseup)="stopResizing($event)"
      (window:touchend)="stopResizing($event)">
      <div class="corner nw"
        (mousedown)="startResizing($event,'nw')"
        (touchstart)="startResizing($event,'nw')">
        <i class="fa-solid fa-up-right-and-down-left-from-center fa-flip-horizontal"></i>
      </div>
      <div class="corner ne"
        (mousedown)="startResizing($event,'ne')"
        (touchstart)="startResizing($event,'ne')">
        <i class="fa-solid fa-up-right-and-down-left-from-center"></i>
      </div>
      <div class="corner se"
        (mousedown)="startResizing($event,'se')"
        (touchstart)="startResizing($event,'se')">
        <i class="fa-solid fa-up-right-and-down-left-from-center fa-flip-horizontal"></i>
      </div>
      <div class="corner sw"
        (mousedown)="startResizing($event,'sw')"
        (touchstart)="startResizing($event,'sw')">
        <i class="fa-solid fa-up-right-and-down-left-from-center"></i>
      </div>
    </div>
  </div>
}`, styles: ["/* src/app/appointment/inspection/components/structure-render/structure-render.component.scss */\n.structure {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  border: 0.2vw var(--color1Alt1) solid;\n  background-color: var(--color2Alt2);\n}\n.structure > label {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  white-space: none;\n  color: var(--color1);\n  font-size: var(--structureFontSize);\n  font-weight: var(--strong);\n  display: block;\n  white-space: nowrap;\n}\n.structure > .corners > .corner {\n  position: absolute;\n  height: 2vw;\n  width: 2vw;\n  background-color: var(--color2);\n  border: 0.2vw var(--color1) solid;\n  cursor: pointer;\n  z-index: 1;\n}\n.structure > .corners > .corner > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 1.4vw;\n  color: var(--color1);\n}\n.structure > .corners > .corner > i.fa-flip-horizontal {\n  -moz-transform: translate(-50%, -50%) scaleX(-1);\n  -ms-transform: translate(-50%, -50%) scaleX(-1);\n  -o-transform: translate(-50%, -50%) scaleX(-1);\n  -webkit-transform: translate(-50%, -50%) scaleX(-1);\n  transform: translate(-50%, -50%) scaleX(-1);\n}\n.structure > .corners > .corner.nw {\n  top: 0;\n  left: 0;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n.structure > .corners > .corner.ne {\n  top: 0;\n  right: 0;\n  -moz-transform: translate(50%, -50%);\n  -ms-transform: translate(50%, -50%);\n  -o-transform: translate(50%, -50%);\n  -webkit-transform: translate(50%, -50%);\n  transform: translate(50%, -50%);\n}\n.structure > .corners > .corner.sw {\n  bottom: 0;\n  left: 0;\n  -moz-transform: translate(-50%, 50%);\n  -ms-transform: translate(-50%, 50%);\n  -o-transform: translate(-50%, 50%);\n  -webkit-transform: translate(-50%, 50%);\n  transform: translate(-50%, 50%);\n}\n.structure > .corners > .corner.se {\n  bottom: 0;\n  right: 0;\n  -moz-transform: translate(50%, 50%);\n  -ms-transform: translate(50%, 50%);\n  -o-transform: translate(50%, 50%);\n  -webkit-transform: translate(50%, 50%);\n  transform: translate(50%, 50%);\n}\n/*# sourceMappingURL=structure-render.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }], { parent: [{
    type: Input,
    args: ["parent"]
  }], parentElm: [{
    type: Input,
    args: ["parentElm"]
  }], structure: [{
    type: Input,
    args: ["structure"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(StructureRenderComponent, { className: "StructureRenderComponent" });
})();

// src/app/appointment/inspection/components/unit/unit.component.ts
var _c010 = ["renderElm"];
var _c13 = ["componentElm"];
function UnitComponent_Conditional_0_For_24_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 43);
    \u0275\u0275text(1, " Missing Information ");
    \u0275\u0275elementEnd();
  }
}
function UnitComponent_Conditional_0_For_24_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 41, 1);
    \u0275\u0275listener("mouseup", function UnitComponent_Conditional_0_For_24_Template_div_mouseup_0_listener() {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectFixture(fixture_r4));
    })("touchend", function UnitComponent_Conditional_0_For_24_Template_div_touchend_0_listener() {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectFixture(fixture_r4));
    });
    \u0275\u0275elementStart(2, "fixture-render", 42);
    \u0275\u0275listener("touchstart", function UnitComponent_Conditional_0_For_24_Template_fixture_render_touchstart_2_listener($event) {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const fixtureElm_r5 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, fixtureElm_r5, fixture_r4));
    })("mousedown", function UnitComponent_Conditional_0_For_24_Template_fixture_render_mousedown_2_listener($event) {
      const fixture_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const fixtureElm_r5 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, fixtureElm_r5, fixture_r4));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "footer");
    \u0275\u0275conditionalCreate(4, UnitComponent_Conditional_0_For_24_Conditional_4_Template, 2, 0, "p", 43);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const fixture_r4 = ctx.$implicit;
    \u0275\u0275styleProp("transform", fixture_r4.renderDimensions.transform);
    \u0275\u0275advance(2);
    \u0275\u0275property("fixture", fixture_r4);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!fixture_r4.valid ? 4 : -1);
  }
}
function UnitComponent_Conditional_0_For_27_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 43);
    \u0275\u0275text(1, " Missing Information ");
    \u0275\u0275elementEnd();
  }
}
function UnitComponent_Conditional_0_For_27_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 44, 2);
    \u0275\u0275listener("mouseup", function UnitComponent_Conditional_0_For_27_Template_div_mouseup_0_listener() {
      const structure_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectStructure(structure_r7));
    })("touchend", function UnitComponent_Conditional_0_For_27_Template_div_touchend_0_listener() {
      const structure_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.selectStructure(structure_r7));
    });
    \u0275\u0275elementStart(2, "structure-render", 45);
    \u0275\u0275listener("mousedown", function UnitComponent_Conditional_0_For_27_Template_structure_render_mousedown_2_listener($event) {
      const structure_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const structureElm_r8 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, structureElm_r8, structure_r7));
    })("touchstart", function UnitComponent_Conditional_0_For_27_Template_structure_render_touchstart_2_listener($event) {
      const structure_r7 = \u0275\u0275restoreView(_r6).$implicit;
      const structureElm_r8 = \u0275\u0275reference(1);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.startMoving($event, structureElm_r8, structure_r7));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "footer");
    \u0275\u0275conditionalCreate(4, UnitComponent_Conditional_0_For_27_Conditional_4_Template, 2, 0, "p", 43);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const structure_r7 = ctx.$implicit;
    \u0275\u0275nextContext();
    const renderElm_r9 = \u0275\u0275reference(15);
    \u0275\u0275styleProp("transform", structure_r7.renderDimensions.transform);
    \u0275\u0275advance(2);
    \u0275\u0275styleProp("width", structure_r7.renderDimensions.widthCss)("height", structure_r7.renderDimensions.heightCss);
    \u0275\u0275property("structure", structure_r7)("parentElm", renderElm_r9);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!structure_r7.valid ? 4 : -1);
  }
}
function UnitComponent_Conditional_0_Conditional_39_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span");
    \u0275\u0275text(1, "structure");
    \u0275\u0275elementEnd();
  }
}
function UnitComponent_Conditional_0_Conditional_40_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span");
    \u0275\u0275text(1, "structures");
    \u0275\u0275elementEnd();
  }
}
function UnitComponent_Conditional_0_Conditional_56_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "standalone-attributes", 46);
    \u0275\u0275listener("close", function UnitComponent_Conditional_0_Conditional_56_Template_standalone_attributes_close_0_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.stopEditingAttributes());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275nextContext();
    const renderElm_r9 = \u0275\u0275reference(15);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("entity", ctx_r1.unit)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableUnit", ctx_r1.availableUnit)("availableStructure", ctx_r1.availableStructure)("attributes", ctx_r1.attributes)("renderElm", renderElm_r9)("headerLabel", "Please Complete Unit Details")("saveLabel", "Continue Inspecting Unit");
  }
}
function UnitComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 14);
    \u0275\u0275listener("touchend", function UnitComponent_Conditional_0_Template_section_touchend_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopMoving($event));
    }, \u0275\u0275resolveWindow)("mouseup", function UnitComponent_Conditional_0_Template_section_mouseup_0_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopMoving($event));
    }, \u0275\u0275resolveWindow);
    \u0275\u0275elementStart(1, "div", 15)(2, "div", 16)(3, "div", 17)(4, "header")(5, "div", 6)(6, "button", 18);
    \u0275\u0275listener("click", function UnitComponent_Conditional_0_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectFixtures());
    });
    \u0275\u0275element(7, "i", 19);
    \u0275\u0275elementStart(8, "label");
    \u0275\u0275text(9, "Add Fixture Outside Structure(s)");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(10, "button", 18);
    \u0275\u0275listener("click", function UnitComponent_Conditional_0_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.managePhotos());
    });
    \u0275\u0275element(11, "i", 20);
    \u0275\u0275elementStart(12, "label");
    \u0275\u0275text(13);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(14, "div", 21, 0);
    \u0275\u0275listener("mousemove", function UnitComponent_Conditional_0_Template_div_mousemove_14_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.moveEntity($event));
    })("touchmove", function UnitComponent_Conditional_0_Template_div_touchmove_14_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.moveEntity($event));
    });
    \u0275\u0275elementStart(16, "div", 22);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(17, "svg", 23);
    \u0275\u0275element(18, "path", 24);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(19, "label");
    \u0275\u0275text(20, "Street");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(21, "svg", 23);
    \u0275\u0275element(22, "path", 24);
    \u0275\u0275elementEnd()();
    \u0275\u0275repeaterCreate(23, UnitComponent_Conditional_0_For_24_Template, 5, 4, "div", 25, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(25, "div", 26);
    \u0275\u0275repeaterCreate(26, UnitComponent_Conditional_0_For_27_Template, 5, 9, "div", 27, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(28, "div", 28)(29, "div", 29)(30, "header")(31, "h2");
    \u0275\u0275text(32);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(33, "div", 29)(34, "div", 30)(35, "h3");
    \u0275\u0275text(36, "Tip: Fixtures & Structures");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(37, "p");
    \u0275\u0275text(38, " #1: Add a fixture outside your ");
    \u0275\u0275conditionalCreate(39, UnitComponent_Conditional_0_Conditional_39_Template, 2, 0, "span");
    \u0275\u0275conditionalCreate(40, UnitComponent_Conditional_0_Conditional_40_Template, 2, 0, "span");
    \u0275\u0275text(41, " or... ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(42, "p");
    \u0275\u0275text(43, " #2: Tap on a structure to work inside. ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(44, "div", 31)(45, "div", 32)(46, "label");
    \u0275\u0275text(47, "Notes for the Customer");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(48, "textarea", 33);
    \u0275\u0275listener("input", function UnitComponent_Conditional_0_Template_textarea_input_48_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateNotes(ctx_r1.NoteAudience.Customer));
    });
    \u0275\u0275twoWayListener("ngModelChange", function UnitComponent_Conditional_0_Template_textarea_ngModelChange_48_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.customerNotes, $event) || (ctx_r1.customerNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(49, "div", 32)(50, "label");
    \u0275\u0275text(51, "Notes for the Shop");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(52, "textarea", 34);
    \u0275\u0275listener("input", function UnitComponent_Conditional_0_Template_textarea_input_52_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.updateNotes(ctx_r1.NoteAudience.Shop));
    });
    \u0275\u0275twoWayListener("ngModelChange", function UnitComponent_Conditional_0_Template_textarea_ngModelChange_52_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.shopNotes, $event) || (ctx_r1.shopNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()()();
    \u0275\u0275elementStart(53, "aside", 35);
    \u0275\u0275element(54, "div", 10);
    \u0275\u0275elementStart(55, "div", 36);
    \u0275\u0275conditionalCreate(56, UnitComponent_Conditional_0_Conditional_56_Template, 1, 12, "standalone-attributes", 37);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(57, "aside", 38)(58, "div", 39);
    \u0275\u0275listener("click", function UnitComponent_Conditional_0_Template_div_click_58_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopSelectingFixtures());
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(59, "fixtures", 40);
    \u0275\u0275listener("close", function UnitComponent_Conditional_0_Template_fixtures_close_59_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopSelectingFixtures());
    })("click", function UnitComponent_Conditional_0_Template_fixtures_click_59_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("selectedFixture", function UnitComponent_Conditional_0_Template_fixtures_selectedFixture_59_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.addFixture($event));
    });
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("Manage ", ctx_r1.unit.name, " / Outside Photo(s)");
    \u0275\u0275advance(10);
    \u0275\u0275repeater(ctx_r1.fixtures);
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx_r1.structures);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1("Inspecting ", ctx_r1.unit.name, " / Outside");
    \u0275\u0275advance(7);
    \u0275\u0275conditional(ctx_r1.structures.length == 1 ? 39 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.structures.length != 1 ? 40 : -1);
    \u0275\u0275advance(8);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.customerNotes);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r1.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.shopNotes);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.editingAttributes);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx_r1.showAttributesUI ? 56 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.selectingFixture);
    \u0275\u0275advance(2);
    \u0275\u0275property("appointment", ctx_r1.appointment);
  }
}
function UnitComponent_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Save & Close ", ctx_r1.unit == null ? null : ctx_r1.unit.name);
  }
}
function UnitComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "label");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("Close ", ctx_r1.unit == null ? null : ctx_r1.unit.name);
  }
}
function UnitComponent_Conditional_12_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "structure", 47);
    \u0275\u0275listener("close", function UnitComponent_Conditional_12_Template_structure_close_0_listener() {
      \u0275\u0275restoreView(_r11);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopEditingStructure());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("structure", ctx_r1.selectedStructure)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableUnit", ctx_r1.availableUnit)("availableStructure", ctx_r1.availableStructure);
  }
}
function UnitComponent_Conditional_15_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "fixture", 48);
    \u0275\u0275listener("click", function UnitComponent_Conditional_15_Template_fixture_click_0_listener($event) {
      \u0275\u0275restoreView(_r12);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.killEvent($event));
    })("close", function UnitComponent_Conditional_15_Template_fixture_close_0_listener() {
      \u0275\u0275restoreView(_r12);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.stopEditingFixture());
    })("deleted", function UnitComponent_Conditional_15_Template_fixture_deleted_0_listener() {
      \u0275\u0275restoreView(_r12);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.removeFixture());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r1.appointment)("fixture", ctx_r1.selectedFixture)("availableEntities", ctx_r1.availableEntities)("availableFixtures", ctx_r1.availableFixtures)("availableFloor", ctx_r1.availableFloor)("availableRoom", ctx_r1.availableRoom)("availableStructure", ctx_r1.availableStructure);
  }
}
var _UnitComponent = class _UnitComponent {
  constructor(localAppointmentService, appointmentService, uiService, inspectionService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.inspectionService = inspectionService;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.NoteAudience = NoteAudience;
    this.customerNotes = "";
    this.shopNotes = "";
    this.editingAttributes = false;
    this.showAttributesUI = false;
    this.acceptFileTypes = "*.jpg,*.png,*.webp";
    this.acceptMimeTypes = ["image/jpeg", "image/jpg", "image/png", "image/webp"];
    this.relWidth = 0;
    this.relHeight = 0;
    this.relX = 0;
    this.relY = 0;
    this.cursorPosition = {
      initialX: 0,
      initialY: 0,
      x: 0,
      y: 0,
      totalX: 0,
      totalY: 0
    };
    this.renderPosition = {
      offsetWidth: 0,
      offsetHeight: 0,
      offsetX: 0,
      offsetY: 0
    };
    this.editingFixture = false;
    this.selectingFixture = false;
    this.showDeleteFixturePrompt = false;
    this.showFixtureHelp = true;
    this.editingStructure = false;
    this.showDeleteStructurePrompt = false;
    this.close = new Subject();
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  update() {
    if (this.appointment != null) {
      this.appointment.changed$.next();
    }
  }
  updateNotes(type) {
    if (this.unit != null) {
      switch (type) {
        case NoteAudience.Customer:
          this.unit.notes[NoteAudience.Customer] = this.customerNotes;
          break;
        case NoteAudience.Shop:
          this.unit.notes[NoteAudience.Shop] = this.shopNotes;
          break;
      }
      this.update();
    }
  }
  initNotes() {
    if (this.unit != null) {
      this.customerNotes = this.unit.notes[NoteAudience.Customer] ?? "";
      this.shopNotes = this.unit.notes[NoteAudience.Shop] ?? "";
    }
  }
  get attributes() {
    return this.unit?.attributes ?? [];
  }
  editAttributes() {
    this.editingAttributes = true;
    this.showAttributesUI = true;
  }
  stopEditingAttributes() {
    return __async(this, null, function* () {
      window.clearTimeout(this.attributesTimer);
      this.editingAttributes = false;
      this.attributesTimer = window.setTimeout(() => __async(this, null, function* () {
        this.showAttributesUI = false;
        this.render();
      }), 250);
    });
  }
  initAttributes() {
    if (this.unit != null) {
      if (this.unit.hasInvalidAttributes && this.canModifyAppointment) {
        this.editAttributes();
      }
    }
  }
  get photos() {
    return this.unit?.photos_B64 ?? [];
  }
  get viewingPhoto() {
    return this.localAppointmentService.viewingPhoto;
  }
  get photoSrc() {
    return this.localAppointmentService.photoSrc;
  }
  matchesMimeType(mimeType) {
    let i = this.acceptMimeTypes.length;
    while (i--) {
      const acceptMimeType = this.acceptMimeTypes[i];
      if (acceptMimeType == mimeType) {
        return true;
      }
    }
    return false;
  }
  setFile(deviceBlob, photos) {
    if (deviceBlob != null && this.matchesMimeType(deviceBlob.type)) {
      const url = URL.createObjectURL(deviceBlob);
      const srcImage = new Image();
      srcImage.onload = () => {
        URL.revokeObjectURL(url);
        const offscreenCanvas = document.createElement("canvas");
        const ctx = offscreenCanvas.getContext("2d");
        if (ctx != null) {
          const ratio = srcImage.width / 1024;
          let width = srcImage.width;
          let height = srcImage.height;
          if (ratio > 1) {
            width = 1024;
            height = Math.round(srcImage.height / ratio);
          }
          offscreenCanvas.width = width;
          offscreenCanvas.height = height;
          ctx.drawImage(srcImage, 0, 0, width, height);
          const base64Image = offscreenCanvas.toDataURL("image/jpeg");
          this.photos.push(base64Image);
          if (this.appointment != null) {
            this.appointment.changed$.next();
          }
        }
      };
      srcImage.src = url;
    }
  }
  selectFile(elm) {
    if (elm.files != null) {
      const file = elm.files[0];
      this.setFile(file, this.photos);
    } else {
      this.setFile(void 0, this.photos);
    }
  }
  selectMedia(fileInputElm) {
    setTimeout(() => {
      if (fileInputElm != null) {
        fileInputElm.click();
      }
    }, 0);
  }
  deletePhoto(fileName) {
    if (this.unit != null) {
      for (var i = 0, len = this.unit.photos.length; i < len; i++) {
        const photo = this.unit.photos[i];
        if (photo.fileName == fileName) {
          this.unit.photos.splice(i, 1);
          break;
        }
      }
      for (var i = 0, len = this.unit.photos_B64.length; i < len; i++) {
        const photo = this.unit.photos_B64[i];
        if (photo == fileName) {
          this.unit.photos_B64.splice(i, 1);
          break;
        }
      }
      this.appointment?.changed$.next();
    }
  }
  viewPhoto(photo) {
    this.localAppointmentService.viewPhoto(photo);
  }
  stopViewingPhoto() {
    this.localAppointmentService.stopViewingPhoto();
  }
  storePhotoMeta() {
    if (this.activePhoto != null) {
      if (this.photoName != null) {
        this.activePhoto.name = this.photoName;
      }
      if (this.photoNotes != null) {
        this.activePhoto.notes = this.photoNotes;
      }
    }
  }
  colliding(newX, newWidth, newY, newHeight) {
    if (this.unit != null) {
      for (var i = 0, len = this.unit.entities.length; i < len; i++) {
        const entity = this.unit.entities[i];
        const minX = entity.renderDimensions.x - newWidth;
        const minY = entity.renderDimensions.y - newHeight;
        const maxX = entity.renderDimensions.width + entity.renderDimensions.x;
        const maxY = entity.renderDimensions.height + entity.renderDimensions.y;
        if (newX > minX && newX < maxX && newY > minY && newY < maxY) {
          return true;
        }
      }
    }
    return false;
  }
  startMoving(e, elm, entity) {
    if (!entity.moving) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      this.cursorPosition.totalX = 0;
      this.cursorPosition.totalY = 0;
      if (isTouch) {
        this.cursorPosition.initialX = e.touches[0].clientX;
        this.cursorPosition.initialY = e.touches[0].clientY;
      } else {
        this.cursorPosition.initialX = e.clientX;
        this.cursorPosition.initialY = e.clientY;
      }
      this.renderPosition.offsetHeight = elm.offsetHeight;
      this.renderPosition.offsetWidth = elm.offsetWidth;
      this.renderPosition.offsetX = elm.offsetWidth / 2;
      this.renderPosition.offsetY = elm.offsetHeight / 2;
      this.movingEntity = entity;
    }
  }
  stopMoving(e) {
    return __async(this, null, function* () {
      if (this.movingEntity?.moving) {
        this.movingEntity.moving = false;
        this.render(50);
      }
      this.movingEntity = void 0;
      this.fixtures.forEach((fixture) => {
        fixture.moving = false;
      });
      this.structures.forEach((structure) => {
        structure.moving = false;
      });
    });
  }
  moveEntity(e) {
    if (this.canModifyAppointment) {
      const isTouch = "touches" in e && e instanceof TouchEvent;
      if (this.movingEntity != null && !this.movingEntity.resizing) {
        if (this.cursorPosition.totalX > 3 || this.cursorPosition.totalX < -3 || this.cursorPosition.totalY > 3 || this.cursorPosition.totalY < -3) {
          this.movingEntity.moving = true;
        }
        if (isTouch) {
          this.cursorPosition.x = e.touches[0].clientX;
          this.cursorPosition.y = e.touches[0].clientY;
        } else {
          this.cursorPosition.x = e.clientX;
          this.cursorPosition.y = e.clientY;
        }
        const deltaX = this.cursorPosition.x - this.cursorPosition.initialX;
        const deltaY = this.cursorPosition.y - this.cursorPosition.initialY;
        let newX = this.movingEntity.renderDimensions.x + deltaX;
        let newY = this.movingEntity.renderDimensions.y + deltaY;
        const maxX = this.relWidth - this.renderPosition.offsetWidth;
        const maxY = this.relHeight - this.renderPosition.offsetHeight;
        if (newX < 0) {
          newX = 0;
        } else if (newX > maxX) {
          newX = maxX;
        }
        if (newY < 0) {
          newY = 0;
        } else if (newY > maxY) {
          newY = maxY;
        }
        const colliding = this.colliding(newX, this.renderPosition.offsetWidth, newY, this.renderPosition.offsetHeight);
        if (!colliding || this.movingEntity instanceof AppointmentPropertyEntity) {
          this.movingEntity.renderDimensions.x = newX;
          this.movingEntity.renderDimensions.y = newY;
          this.cursorPosition.initialX = this.cursorPosition.x;
          this.cursorPosition.initialY = this.cursorPosition.y;
          this.cursorPosition.totalX = this.cursorPosition.totalX + deltaX;
          this.cursorPosition.totalY = this.cursorPosition.totalX + deltaY;
        }
      }
    }
  }
  render(delayInMs = 50) {
    return new Promise((res, rej) => {
      window.clearTimeout(this.renderDebounce);
      this.renderDebounce = window.setTimeout(() => {
        const renderElm = this.renderElm?.nativeElement;
        const unit = this.unit;
        if (renderElm != null && unit != null) {
          toPng(renderElm, {
            quality: 1,
            backgroundColor: "#fff",
            skipFonts: true,
            filter: (renderElm2) => {
              return !renderElm2.classList?.contains("no-render");
            }
          }).then((png) => {
            unit.updateRender(png);
            this.appointment?.changed$.next();
            res();
          }).catch(() => {
            rej();
          });
        } else {
          rej();
        }
      }, delayInMs);
    });
  }
  initRender() {
    setTimeout(() => {
      const renderElm = this.renderElm?.nativeElement;
      if (renderElm != null) {
        const bounds = renderElm.getBoundingClientRect();
        this.relX = bounds.left;
        this.relY = bounds.top;
        this.relWidth = renderElm.offsetWidth;
        this.relHeight = renderElm.offsetHeight;
        this.initAttributes();
      }
    }, 251);
  }
  hideFixtureHelp() {
    this.showFixtureHelp = false;
  }
  get fixtures() {
    return this.unit?.fixtures ?? [];
  }
  removeFixture() {
    return __async(this, null, function* () {
      if (this.selectedFixture != null) {
        this.stopEditingFixture(false);
        for (var i = 0, len = this.fixtures.length; i < len; i++) {
          const fixture = this.fixtures[i];
          if (fixture.id == this.selectedFixture.id) {
            this.fixtures.splice(i, 1);
            this.selectedFixture = void 0;
            this.update();
            break;
          }
        }
        this.render();
      }
    });
  }
  stopSelectingFixtures() {
    this.selectingFixture = false;
  }
  selectFixtures() {
    this.selectingFixture = true;
  }
  selectFixture(fixture) {
    if (!fixture.moving && this.selectedFixture?.id != fixture.id) {
      if (this.selectedFixture?.id == fixture.id) {
        this.stopEditingFixture();
      } else {
        this.selectedFixture = fixture;
        this.editingFixture = true;
      }
    }
  }
  stopEditingFixture(showTip = true) {
    return __async(this, null, function* () {
      window.clearTimeout(this.editingFixtureTimer);
      this.editingFixture = false;
      this.editingFixtureTimer = window.setTimeout(() => __async(this, null, function* () {
        this.selectedFixture = void 0;
        this.render();
      }), 250);
    });
  }
  unselectFixture() {
    this.stopEditingFixture();
  }
  addFixture(fixture) {
    return __async(this, null, function* () {
      if (this.unit != null) {
        fixture.renderDimensions.x = 50;
        fixture.renderDimensions.y = 50;
        this.fixtures.push(fixture);
        this.selectFixture(fixture);
        this.appointment?.changed$.next();
        this.stopSelectingFixtures();
        this.render();
      }
    });
  }
  promptToDeleteFixture(fixture) {
    this.fixtureToDelete = fixture;
    this.showDeleteFixturePrompt = true;
  }
  cancelDeletingFixture() {
    this.showDeleteFixturePrompt = false;
    this.fixtureToDelete = void 0;
  }
  // #endregion
  // #region Photos
  managePhotos() {
    if (this.unit != null) {
      this.localAppointmentService.managePhotos(this.unit);
    }
  }
  get structures() {
    return this.unit?.entities ?? [];
  }
  selectStructure(structure) {
    if (!structure.moving && !structure.resizing && this.selectedStructure?.id != structure.id) {
      this.selectedStructure = structure;
      this.editingStructure = true;
    }
  }
  stopEditingStructure() {
    return __async(this, null, function* () {
      window.clearTimeout(this.structureEditingTimer);
      this.editingStructure = false;
      this.structureEditingTimer = window.setTimeout(() => __async(this, null, function* () {
        this.selectedStructure = void 0;
        this.render();
      }), 250);
    });
  }
  promptToDeleteStructure(structure) {
    this.structureToDelete = structure;
    this.showDeleteStructurePrompt = true;
  }
  cancelDeletingRoom() {
    this.showDeleteStructurePrompt = false;
    this.structureToDelete = void 0;
  }
  killEvent(e) {
    e.stopPropagation();
  }
  get canClose() {
    return true;
  }
  closeView() {
    return __async(this, null, function* () {
      this.render(0).finally(() => {
        this.close.next();
      });
    });
  }
  init() {
    this.initRender();
    this.initNotes();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_UnitComponent.\u0275fac = function UnitComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _UnitComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(InspectionService));
};
_UnitComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _UnitComponent, selectors: [["unit"]], viewQuery: function UnitComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c010, 5);
    \u0275\u0275viewQuery(_c13, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.renderElm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", availableFloor: "availableFloor", availableRoom: "availableRoom", availableUnit: "availableUnit", availableStructure: "availableStructure", availableEntities: "availableEntities", availableFixtures: "availableFixtures", unit: "unit" }, outputs: { close: "close" }, standalone: false, decls: 16, vars: 13, consts: [["renderElm", ""], ["fixtureElm", ""], ["structureElm", ""], ["id", "unit"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click"], [1, "control", "success", 3, "click", "disabled"], ["id", "structureView"], [1, "bg"], [3, "appointment", "structure", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure"], ["id", "fixture"], [3, "appointment", "fixture", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure"], ["id", "unit", 3, "touchend", "mouseup"], [1, "columns"], [1, "column", "structures"], [1, "content", "diagram"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-plus"], [1, "fa-solid", "fa-camera"], [1, "render", 3, "mousemove", "touchmove"], [1, "street"], ["xmlns", "http://www.w3.org/2000/svg", "viewBox", "0 0 384 512"], ["d", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"], [1, "fixture", 3, "transform"], [1, "structures"], [1, "structure", 3, "transform"], [1, "unit", "column"], [1, "content"], [1, "tooltip"], [1, "notes"], [1, "note"], ["rows", "5", "placeholder", "If you have any notes for our customer, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["rows", "5", "placeholder", "If you have any notes important for the shop, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["id", "standaloneAttributes"], [1, "attributes"], [3, "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "renderElm", "headerLabel", "saveLabel"], ["id", "fixtures"], [1, "bg", 3, "click"], [3, "close", "click", "selectedFixture", "appointment"], [1, "fixture", 3, "mouseup", "touchend"], [3, "touchstart", "mousedown", "fixture"], [1, "warning", "no-render"], [1, "structure", 3, "mouseup", "touchend"], [3, "mousedown", "touchstart", "structure", "parentElm"], [3, "close", "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "renderElm", "headerLabel", "saveLabel"], [3, "close", "appointment", "structure", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure"], [3, "click", "close", "deleted", "appointment", "fixture", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableStructure"]], template: function UnitComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, UnitComponent_Conditional_0_Template, 60, 16, "section", 3);
    \u0275\u0275elementStart(1, "nav", 4)(2, "div", 5)(3, "div", 6)(4, "button", 7);
    \u0275\u0275listener("click", function UnitComponent_Template_button_click_4_listener() {
      return ctx.editAttributes();
    });
    \u0275\u0275elementStart(5, "label");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "button", 8);
    \u0275\u0275listener("click", function UnitComponent_Template_button_click_7_listener() {
      return ctx.closeView();
    });
    \u0275\u0275conditionalCreate(8, UnitComponent_Conditional_8_Template, 2, 1, "label");
    \u0275\u0275conditionalCreate(9, UnitComponent_Conditional_9_Template, 2, 1, "label");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(10, "aside", 9);
    \u0275\u0275element(11, "div", 10);
    \u0275\u0275conditionalCreate(12, UnitComponent_Conditional_12_Template, 1, 8, "structure", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "aside", 12);
    \u0275\u0275element(14, "div", 10);
    \u0275\u0275conditionalCreate(15, UnitComponent_Conditional_15_Template, 1, 7, "fixture", 13);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.unit != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("hidden", ctx.editingStructure || ctx.editingFixture || ctx.editingAttributes);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1("Change ", ctx.unit == null ? null : ctx.unit.name, " Details");
    \u0275\u0275advance();
    \u0275\u0275property("disabled", !ctx.canClose);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canModifyAppointment ? 8 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.canModifyAppointment ? 9 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.editingStructure);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.selectedStructure != null ? 12 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.editingFixture);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.selectedFixture != null ? 15 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel, StandaaloneAttributesComponent, StructureComponent, FixtureComponent, FixturesComponent, FixtureRenderComponent, StructureRenderComponent], styles: ['\n\n#unit[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 2vw;\n  right: 0;\n  bottom: 6vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%] {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: flex-end;\n  padding: 0.75vw 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  position: relative;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%], \n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > i[_ngcontent-%COMP%], \n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active    > label[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  position: absolute;\n  visibility: hidden;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%] {\n  width: 75%;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%] {\n  position: relative;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  flex: 1;\n  background-color: var(--color2);\n  position: relative;\n  overflow: hidden;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .street[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  bottom: 0.5vw;\n  display: flex;\n  align-items: center;\n  pointer-events: none;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .street[_ngcontent-%COMP%]    > svg[_ngcontent-%COMP%] {\n  height: 1.2vw;\n  fill: var(--color1);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .street[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin: 0 1vw;\n  font-size: 1.4vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 2;\n  cursor: pointer;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  will-change: transform;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]     {\n  -webkit-user-drag: none;\n  user-drag: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]   fixture-render[_ngcontent-%COMP%] {\n  display: block;\n  width: 5.5vw;\n  height: 5.5vw;\n  position: relative;\n  --fixtureFontSize: .8vw;\n  will-change: transform;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  display: flex;\n  justify-content: center;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 0.8vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .fixture[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-style: italic;\n  white-space: nowrap;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .structures[_ngcontent-%COMP%]   .structure[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 1;\n  will-change: transform;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .structures[_ngcontent-%COMP%]   .structure[_ngcontent-%COMP%]    > structure-render[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  cursor: pointer;\n  --structureFontSize: 1vw;\n  will-change: transform;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .structures[_ngcontent-%COMP%]   .structure[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .structures[_ngcontent-%COMP%]   .structure[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.structures[_ngcontent-%COMP%]    > .diagram[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]    > .structures[_ngcontent-%COMP%]   .structure[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-style: italic;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%] {\n  width: 25%;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 1.5vw;\n  background-color: var(--color1Alt3);\n  border-left: 0.2vw var(--color1Alt4) solid;\n  justify-content: center;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt2);\n  border-left: 0.2vw var(--color2Alt4) solid;\n  padding: 1vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%] {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n  line-height: 1;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.fixture[_ngcontent-%COMP%] {\n  padding: 1vw;\n  border: 0.2vw var(--color3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt3);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.fixture[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  margin-bottom: 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  padding-bottom: 0.5vw;\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.fixture[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.fixture[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  line-height: 1;\n  text-transform: uppercase;\n  font-size: 1vw;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .attributes.fixture[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .image[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  height: 2vw;\n}\n#unit[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  border-left: none;\n}\n#unit[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#unit[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 4;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#unit[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#unit[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#unit[_ngcontent-%COMP%]   #fixtures[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#unit[_ngcontent-%COMP%]   #fixtures[_ngcontent-%COMP%]    > fixtures[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 20%;\n  right: 20%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#unit[_ngcontent-%COMP%]   #fixtures.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#unit[_ngcontent-%COMP%]   #fixtures.active[_ngcontent-%COMP%]    > fixtures[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 3;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes _ngcontent-%COMP%_childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#structureView[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structureView[_ngcontent-%COMP%]    > structure[_ngcontent-%COMP%]     #structure {\n  z-index: 4;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadOut;\n  animation-name: _ngcontent-%COMP%_childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#structureView[_ngcontent-%COMP%]    > structure[_ngcontent-%COMP%]     #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#structureView.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structureView.active[_ngcontent-%COMP%]    > structure[_ngcontent-%COMP%]     #structure {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadIn;\n  animation-name: _ngcontent-%COMP%_childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#structureView.active[_ngcontent-%COMP%]    > structure[_ngcontent-%COMP%]     #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #fixture {\n  z-index: 4;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadOut;\n  animation-name: _ngcontent-%COMP%_childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  animation-name: _ngcontent-%COMP%_childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #fixture {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childLoadIn;\n  animation-name: _ngcontent-%COMP%_childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active[_ngcontent-%COMP%]    > fixture[_ngcontent-%COMP%]     #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  animation-name: _ngcontent-%COMP%_childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=unit.component.css.map */'] });
var UnitComponent = _UnitComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(UnitComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "unit", template: `@if (unit != null) {
  <section id="unit"
    (window:touchend)="stopMoving($event)"
    (window:mouseup)="stopMoving($event)">
    <div class="columns">
      <div class="column structures">
        <div class="content diagram">
          <header>
            <div class="controls">
              <button class="control" [disabled]="!canModifyAppointment"  (click)="selectFixtures()">
                <i class="fa-solid fa-plus"></i>
                <label>Add Fixture Outside Structure(s)</label>
              </button>
              <button class="control" [disabled]="!canModifyAppointment" (click)="managePhotos()">
                <i class="fa-solid fa-camera"></i>
                <label>Manage {{unit.name}} / Outside Photo(s)</label>
              </button>
            </div>
          </header>
          <div class="render"
            (mousemove)="moveEntity($event)"
            (touchmove)="moveEntity($event)"
            #renderElm>
            <div class="street">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path d="M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"/>
              </svg>
              <label>Street</label>
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                <path d="M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"/>
              </svg>
            </div>
            @for (fixture of fixtures; track fixture) {
              <div class="fixture"
                #fixtureElm
                (mouseup)="selectFixture(fixture)"
                (touchend)="selectFixture(fixture)"
                [style.transform]="fixture.renderDimensions.transform">
                <fixture-render
                  [fixture]="fixture"
                  (touchstart)="startMoving($event,fixtureElm,fixture)"
                (mousedown)="startMoving($event,fixtureElm,fixture)"></fixture-render>
                <footer>
                  @if (!fixture.valid) {
                    <p class="warning no-render">
                      Missing Information
                    </p>
                  }
                </footer>
              </div>
            }
            <div class="structures">
              @for (structure of structures; track structure) {
                <div class="structure"
                  #structureElm
                  (mouseup)="selectStructure(structure)"
                  (touchend)="selectStructure(structure)"
                  [style.transform]="structure.renderDimensions.transform">
                  <structure-render
                    [structure]="structure"
                    [parentElm]="renderElm"
                    [style.width]="structure.renderDimensions.widthCss"
                    [style.height]="structure.renderDimensions.heightCss"
                    (mousedown)="startMoving($event,structureElm,structure)"
                  (touchstart)="startMoving($event,structureElm,structure)"></structure-render>
                  <footer>
                    @if (!structure.valid) {
                      <p class="warning no-render">
                        Missing Information
                      </p>
                    }
                  </footer>
                </div>
              }
            </div>
          </div>
        </div>
      </div>
      <div class="unit column">
        <div class="content">
          <header>
            <h2>Inspecting {{unit.name}} / Outside</h2>
          </header>
          <div class="content">
            <div class="tooltip">
              <h3>Tip: Fixtures & Structures</h3>
              <p>
                #1: Add a fixture outside your
                @if (structures.length == 1) {
                  <span>structure</span>
                }
                @if (structures.length != 1) {
                  <span>structures</span>
                  } or...
                </p>
                <p>
                  #2: Tap on a structure to work inside.
                </p>
              </div>
              <div class="notes">
                <div class="note">
                  <label>Notes for the Customer</label>
                  <textarea
                    [disabled]="!canModifyAppointment"
                    rows="5"
                    placeholder="If you have any notes for our customer, you can enter them here..."
                    (input)="updateNotes(NoteAudience.Customer)"
                  [(ngModel)]="customerNotes"></textarea>
                </div>
                <div class="note">
                  <label>Notes for the Shop</label>
                  <textarea
                    [disabled]="!canModifyAppointment"
                    rows="5"
                    placeholder="If you have any notes important for the shop, you can enter them here..."
                    (input)="updateNotes(NoteAudience.Shop)"
                  [(ngModel)]="shopNotes"></textarea>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <aside id="standaloneAttributes" [class.active]="editingAttributes">
        <div class="bg"></div>
        <div class="attributes">
          @if (showAttributesUI) {
            <standalone-attributes
              [appointment]="appointment"
              [entity]="unit"
              [availableEntities]="availableEntities"
              [availableFixtures]="availableFixtures"
              [availableFloor]="availableFloor"
              [availableRoom]="availableRoom"
              [availableUnit]="availableUnit"
              [availableStructure]="availableStructure"
              [attributes]="attributes"
              [renderElm]="renderElm"
              [headerLabel]="'Please Complete Unit Details'"
              [saveLabel]="'Continue Inspecting Unit'"
            (close)="stopEditingAttributes()"></standalone-attributes>
          }
        </div>
      </aside>
      <aside id="fixtures" [class.active]="selectingFixture">
        <div class="bg" (click)="stopSelectingFixtures()"></div>
        <fixtures
          [appointment]="appointment"
          (close)="stopSelectingFixtures()"
          (click)="killEvent($event)"
          (selectedFixture)="addFixture($event)">
        </fixtures>
      </aside>
    </section>
  }

  <nav id="mainNav" [class.hidden]="editingStructure || editingFixture || editingAttributes">
    <div class="island">
      <div class="controls">
        <button class="control" (click)="editAttributes()">
          <label>Change {{unit?.name}} Details</label>
        </button>
        <button class="control success" [disabled]="!canClose" (click)="closeView()">
          @if (canModifyAppointment) {
            <label>Save & Close {{unit?.name}}</label>
          }
          @if (!canModifyAppointment) {
            <label>Close {{unit?.name}}</label>
          }
        </button>
      </div>
    </div>
  </nav>

  <aside id="structureView" [class.active]="editingStructure">
    <div class="bg"></div>
    @if (selectedStructure != null) {
      <structure
        [appointment]="appointment"
        [structure]="selectedStructure"
        [availableEntities]="availableEntities"
        [availableFixtures]="availableFixtures"
        [availableFloor]="availableFloor"
        [availableRoom]="availableRoom"
        [availableUnit]="availableUnit"
        [availableStructure]="availableStructure"
        (close)="stopEditingStructure()">
      </structure>
    }
  </aside>

  <aside id="fixture" [class.active]="editingFixture">
    <div class="bg"></div>

    @if (selectedFixture != null) {
      <fixture
        (click)="killEvent($event)"
        [appointment]="appointment"
        [fixture]="selectedFixture"
        (close)="stopEditingFixture()"
        (deleted)="removeFixture()"
        [availableEntities]="availableEntities"
        [availableFixtures]="availableFixtures"
        [availableFloor]="availableFloor"
        [availableRoom]="availableRoom"
      [availableStructure]="availableStructure"></fixture>
    }
  </aside>`, styles: ['/* src/app/appointment/inspection/components/unit/unit.component.scss */\n#unit {\n  position: absolute;\n  top: calc(6vw + var(--systemOffset-top));\n  left: 2vw;\n  right: 0;\n  bottom: 6vw;\n  background-color: var(--color2Alt3);\n  border: 0.1vw var(--color2Alt4) solid;\n  box-shadow: -0.2vw 0 1vw rgba(var(--black-raw), 0.1);\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  overflow: hidden;\n}\n#unit .columns {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#unit .columns > .column {\n  display: inline-block;\n  vertical-align: top;\n  height: 100%;\n  font-size: 1rem;\n}\n#unit .columns > .column > .content {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#unit .columns > .column > .content > header {\n  display: flex;\n  justify-content: flex-end;\n  padding: 0.75vw 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  position: relative;\n}\n#unit .columns > .column > .content > header > h2 {\n  color: var(--color1);\n  font-weight: var(--stronger);\n  font-size: 1.4vw;\n  line-height: 1;\n}\n#unit .columns > .column > .content > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#unit .columns > .column > .content > header > .controls > .control {\n  margin-left: 1vw;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 999px;\n  background-color: var(--color3Alt3);\n  padding: 0.75vw 1vw;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#unit .columns > .column > .content > header > .controls > .control > i,\n#unit .columns > .column > .content > header > .controls > .control > label {\n  color: var(--color2);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#unit .columns > .column > .content > header > .controls > .control > i {\n  font-size: 1.2vw;\n}\n#unit .columns > .column > .content > header > .controls > .control > label {\n  margin-left: 0.5vw;\n  line-height: 1;\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n}\n#unit .columns > .column > .content > header > .controls > .control:active > i,\n#unit .columns > .column > .content > header > .controls > .control:active > label {\n  color: var(--color5);\n}\n#unit .columns > .column > .content > header > .controls > .control[disabled] {\n  opacity: 0.75;\n  pointer-events: none;\n}\n#unit .columns > .column > .content > header > .controls > .control:first-child {\n  margin-left: 0;\n}\n#unit .columns > .column > .content > header > .controls > input {\n  position: absolute;\n  visibility: hidden;\n}\n#unit .columns > .column > .content > .content {\n  flex: 1;\n  padding: 1vw 1vw 5vw;\n  overflow-x: hidden;\n}\n#unit .columns > .column > .content > .content > .control {\n  display: block;\n  width: 100%;\n  border: 0.1vw var(--color2Alt4) solid;\n  cursor: pointer;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  background-color: var(--color2Alt1);\n  padding: 2vw 0;\n  border-radius: 1vw;\n}\n#unit .columns > .column > .content > .content > .control > i {\n  font-size: 2vw;\n  color: var(--color3);\n}\n#unit .columns > .column > .content > .content > .control > label {\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#unit .columns > .column.structures {\n  width: 75%;\n}\n#unit .columns > .column.structures > .diagram {\n  position: relative;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n#unit .columns > .column.structures > .diagram > .render {\n  flex: 1;\n  background-color: var(--color2);\n  position: relative;\n  overflow: hidden;\n}\n#unit .columns > .column.structures > .diagram > .render > .street {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  bottom: 0.5vw;\n  display: flex;\n  align-items: center;\n  pointer-events: none;\n}\n#unit .columns > .column.structures > .diagram > .render > .street > svg {\n  height: 1.2vw;\n  fill: var(--color1);\n}\n#unit .columns > .column.structures > .diagram > .render > .street > label {\n  margin: 0 1vw;\n  font-size: 1.4vw;\n  text-transform: uppercase;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#unit .columns > .column.structures > .diagram > .render .fixture {\n  position: absolute;\n  z-index: 2;\n  cursor: pointer;\n  border: 0.2vw transparent solid;\n  border-radius: 1vw;\n  will-change: transform;\n}\n#unit .columns > .column.structures > .diagram > .render .fixture ::ng-deep {\n  -webkit-user-drag: none;\n  user-drag: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n#unit .columns > .column.structures > .diagram > .render .fixture fixture-render {\n  display: block;\n  width: 5.5vw;\n  height: 5.5vw;\n  position: relative;\n  --fixtureFontSize: .8vw;\n  will-change: transform;\n}\n#unit .columns > .column.structures > .diagram > .render .fixture > footer {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  display: flex;\n  justify-content: center;\n}\n#unit .columns > .column.structures > .diagram > .render .fixture > footer > p {\n  font-size: 0.8vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#unit .columns > .column.structures > .diagram > .render .fixture > footer > p.warning {\n  color: var(--error);\n  font-style: italic;\n  white-space: nowrap;\n}\n#unit .columns > .column.structures > .diagram > .render > .structures .structure {\n  position: absolute;\n  z-index: 1;\n  will-change: transform;\n}\n#unit .columns > .column.structures > .diagram > .render > .structures .structure > structure-render {\n  display: block;\n  position: relative;\n  cursor: pointer;\n  --structureFontSize: 1vw;\n  will-change: transform;\n}\n#unit .columns > .column.structures > .diagram > .render > .structures .structure > footer {\n  position: absolute;\n  left: 50%;\n  -moz-transform: translate3d(-50%, 0, 0);\n  -ms-transform: translate3d(-50%, 0, 0);\n  -o-transform: translate3d(-50%, 0, 0);\n  -webkit-transform: translate3d(-50%, 0, 0);\n  transform: translate3d(-50%, 0, 0);\n  top: 100%;\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#unit .columns > .column.structures > .diagram > .render > .structures .structure > footer > p {\n  font-size: 1vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#unit .columns > .column.structures > .diagram > .render > .structures .structure > footer > p.warning {\n  color: var(--error);\n  font-style: italic;\n}\n#unit .columns > .column.unit {\n  width: 25%;\n}\n#unit .columns > .column.unit > .content > header {\n  padding: 1vw 1.5vw;\n  background-color: var(--color1Alt3);\n  border-left: 0.2vw var(--color1Alt4) solid;\n  justify-content: center;\n}\n#unit .columns > .column.unit > .content > header > h2 {\n  font-size: 2.2vw;\n  text-align: center;\n  color: var(--color2);\n}\n#unit .columns > .column.unit > .content > .content {\n  background-color: var(--color2Alt2);\n  border-left: 0.2vw var(--color2Alt4) solid;\n  padding: 1vw;\n}\n#unit .columns > .column.unit > .content > .content .tooltip {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#unit .columns > .column.unit > .content > .content .tooltip h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n  line-height: 1;\n}\n#unit .columns > .column.unit > .content > .content .tooltip p {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#unit .columns > .column.unit > .content > .content > .notes > .note {\n  margin-top: 1vw;\n}\n#unit .columns > .column.unit > .content > .content > .notes > .note label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#unit .columns > .column.unit > .content > .content > .notes > .note textarea {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n}\n#unit .columns > .column.unit > .content > .content > .notes > .note textarea:focus {\n  border-color: var(--color3);\n}\n#unit .columns > .column.unit > .content > .content > .notes > .note:first-child {\n  margin-top: 0;\n}\n#unit .columns > .column.unit > .content > .content > .attributes {\n  margin-top: 1vw;\n}\n#unit .columns > .column.unit > .content > .content > .attributes.fixture {\n  padding: 1vw;\n  border: 0.2vw var(--color3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt3);\n}\n#unit .columns > .column.unit > .content > .content > .attributes.fixture > header {\n  margin-bottom: 1vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  padding-bottom: 0.5vw;\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#unit .columns > .column.unit > .content > .content > .attributes.fixture > header > .primary h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#unit .columns > .column.unit > .content > .content > .attributes.fixture > header > .primary h4 {\n  line-height: 1;\n  text-transform: uppercase;\n  font-size: 1vw;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n}\n#unit .columns > .column.unit > .content > .content > .attributes.fixture > header > .image img {\n  height: 2vw;\n}\n#unit .columns > .column:first-child {\n  border-left: none;\n}\n#unit #standaloneAttributes > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#unit #standaloneAttributes > .attributes {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 4;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#unit #standaloneAttributes.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#unit #standaloneAttributes.active > .attributes {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#unit #fixtures > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#unit #fixtures > fixtures {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 20%;\n  right: 20%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#unit #fixtures.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#unit #fixtures.active > fixtures {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: 3;\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes childLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes childLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes childNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes childNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#structureView > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#structureView > structure ::ng-deep #structure {\n  z-index: 4;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: childLoadOut;\n  animation-name: childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#structureView > structure ::ng-deep #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: childNavLoadOut;\n  animation-name: childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#structureView.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#structureView.active > structure ::ng-deep #structure {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: childLoadIn;\n  animation-name: childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#structureView.active > structure ::ng-deep #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: childNavLoadIn;\n  animation-name: childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 3;\n  background-color: rgba(var(--color2Alt1-raw), 0.5);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#fixture > fixture ::ng-deep #fixture {\n  z-index: 4;\n  -moz-animation-name: childLoadOut;\n  -ms-animation-name: childLoadOut;\n  -o-animation-name: childLoadOut;\n  -webkit-animation-name: childLoadOut;\n  animation-name: childLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture > fixture ::ng-deep #mainNav > .island {\n  -moz-animation-name: childNavLoadOut;\n  -ms-animation-name: childNavLoadOut;\n  -o-animation-name: childNavLoadOut;\n  -webkit-animation-name: childNavLoadOut;\n  animation-name: childNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#fixture.active > fixture ::ng-deep #fixture {\n  -moz-animation-name: childLoadIn;\n  -ms-animation-name: childLoadIn;\n  -o-animation-name: childLoadIn;\n  -webkit-animation-name: childLoadIn;\n  animation-name: childLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#fixture.active > fixture ::ng-deep #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: childNavLoadIn;\n  -ms-animation-name: childNavLoadIn;\n  -o-animation-name: childNavLoadIn;\n  -webkit-animation-name: childNavLoadIn;\n  animation-name: childNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=unit.component.css.map */\n'] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }, { type: InspectionService }], { appointment: [{
    type: Input
  }], availableFloor: [{
    type: Input,
    args: ["availableFloor"]
  }], availableRoom: [{
    type: Input,
    args: ["availableRoom"]
  }], availableUnit: [{
    type: Input,
    args: ["availableUnit"]
  }], availableStructure: [{
    type: Input,
    args: ["availableStructure"]
  }], availableEntities: [{
    type: Input,
    args: ["availableEntities"]
  }], availableFixtures: [{
    type: Input,
    args: ["availableFixtures"]
  }], unit: [{
    type: Input,
    args: ["unit"]
  }], renderElm: [{
    type: ViewChild,
    args: ["renderElm"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(UnitComponent, { className: "UnitComponent" });
})();

// src/app/appointment/inspection/components/property-details/property-details.component.ts
var _c011 = ["componentElm"];
function PropertyDetailsComponent_Conditional_0_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "p");
    \u0275\u0275text(2, " Select the number of units on the property before proceeding with your inspection. ");
    \u0275\u0275elementEnd()();
  }
}
function PropertyDetailsComponent_Conditional_0_For_8_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 28);
    \u0275\u0275element(1, "img", 31);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const unit_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("src", unit_r3.localRender, \u0275\u0275sanitizeUrl);
  }
}
function PropertyDetailsComponent_Conditional_0_For_8_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 29)(1, "label");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const unit_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(unit_r3.name);
  }
}
function PropertyDetailsComponent_Conditional_0_For_8_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 30);
    \u0275\u0275text(1, " Missing Information ");
    \u0275\u0275elementEnd();
  }
}
function PropertyDetailsComponent_Conditional_0_For_8_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 26);
    \u0275\u0275listener("click", function PropertyDetailsComponent_Conditional_0_For_8_Template_div_click_0_listener() {
      const unit_r3 = \u0275\u0275restoreView(_r2).$implicit;
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.selectUnit(unit_r3));
    });
    \u0275\u0275elementStart(1, "div", 13);
    \u0275\u0275element(2, "canvas", 27);
    \u0275\u0275conditionalCreate(3, PropertyDetailsComponent_Conditional_0_For_8_Conditional_3_Template, 2, 1, "div", 28);
    \u0275\u0275conditionalCreate(4, PropertyDetailsComponent_Conditional_0_For_8_Conditional_4_Template, 3, 1, "div", 29);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "footer");
    \u0275\u0275conditionalCreate(6, PropertyDetailsComponent_Conditional_0_For_8_Conditional_6_Template, 2, 0, "p", 30);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const unit_r3 = ctx.$implicit;
    \u0275\u0275advance(3);
    \u0275\u0275conditional(unit_r3.localRender != null ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(unit_r3.localRender == null ? 4 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!unit_r3.valid ? 6 : -1);
  }
}
function PropertyDetailsComponent_Conditional_0_Conditional_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 18)(1, "h3");
    \u0275\u0275text(2, "Tip: Start the Inspection");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4, " To continue, tap on the unit you're ready to inspect. ");
    \u0275\u0275elementEnd()();
  }
}
function PropertyDetailsComponent_Conditional_0_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 18)(1, "h3");
    \u0275\u0275text(2, "Tip: The Repipe Value");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "p");
    \u0275\u0275text(4, " When you're done inspecting the property, you can continue to The Repipe Value. ");
    \u0275\u0275elementEnd()();
  }
}
function PropertyDetailsComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 11)(2, "div", 12)(3, "div", 13)(4, "div", 13);
    \u0275\u0275conditionalCreate(5, PropertyDetailsComponent_Conditional_0_Conditional_5_Template, 3, 0, "div", 14);
    \u0275\u0275elementStart(6, "div", 15);
    \u0275\u0275repeaterCreate(7, PropertyDetailsComponent_Conditional_0_For_8_Template, 7, 3, "div", 16, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(9, "div", 17)(10, "div", 13)(11, "div", 13);
    \u0275\u0275conditionalCreate(12, PropertyDetailsComponent_Conditional_0_Conditional_12_Template, 5, 0, "div", 18);
    \u0275\u0275conditionalCreate(13, PropertyDetailsComponent_Conditional_0_Conditional_13_Template, 5, 0, "div", 18);
    \u0275\u0275elementStart(14, "div", 19)(15, "div", 20)(16, "label");
    \u0275\u0275text(17, "Customer Notes");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "textarea", 21);
    \u0275\u0275listener("input", function PropertyDetailsComponent_Conditional_0_Template_textarea_input_18_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.updateNotes(ctx_r3.NoteAudience.Customer));
    });
    \u0275\u0275twoWayListener("ngModelChange", function PropertyDetailsComponent_Conditional_0_Template_textarea_ngModelChange_18_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r3.customerNotes, $event) || (ctx_r3.customerNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "div", 20)(20, "label");
    \u0275\u0275text(21, "Shop Notes");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "textarea", 22);
    \u0275\u0275listener("input", function PropertyDetailsComponent_Conditional_0_Template_textarea_input_22_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.updateNotes(ctx_r3.NoteAudience.Shop));
    });
    \u0275\u0275twoWayListener("ngModelChange", function PropertyDetailsComponent_Conditional_0_Template_textarea_ngModelChange_22_listener($event) {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r3.shopNotes, $event) || (ctx_r3.shopNotes = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()()();
    \u0275\u0275elementStart(23, "aside", 23);
    \u0275\u0275element(24, "div", 9);
    \u0275\u0275elementStart(25, "div", 24)(26, "standalone-attributes", 25);
    \u0275\u0275listener("close", function PropertyDetailsComponent_Conditional_0_Template_standalone_attributes_close_26_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.stopEditingAttributes());
    });
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx_r3.hasUnits ? 5 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx_r3.units);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx_r3.property.valid ? 12 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r3.property.valid ? 13 : -1);
    \u0275\u0275advance(5);
    \u0275\u0275property("disabled", !ctx_r3.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r3.customerNotes);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx_r3.canModifyAppointment);
    \u0275\u0275twoWayProperty("ngModel", ctx_r3.shopNotes);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r3.editingAttributes);
    \u0275\u0275advance(3);
    \u0275\u0275property("appointment", ctx_r3.appointment)("entity", ctx_r3.property)("availableEntities", ctx_r3.availableEntities)("availableFixtures", ctx_r3.availableFixtures)("availableFloor", ctx_r3.availableFloor)("availableRoom", ctx_r3.availableRoom)("availableUnit", ctx_r3.availableUnit)("availableStructure", ctx_r3.availableStructure)("attributes", ctx_r3.attributes)("headerLabel", "Please Complete Property Details")("saveLabel", "Continue Inspection");
  }
}
function PropertyDetailsComponent_Conditional_17_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "unit", 32);
    \u0275\u0275listener("close", function PropertyDetailsComponent_Conditional_17_Template_unit_close_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.stopEditingUnit());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("appointment", ctx_r3.appointment)("unit", ctx_r3.selectedUnit)("availableEntities", ctx_r3.availableEntities)("availableFixtures", ctx_r3.availableFixtures)("availableFloor", ctx_r3.availableFloor)("availableRoom", ctx_r3.availableRoom)("availableUnit", ctx_r3.availableUnit)("availableStructure", ctx_r3.availableStructure);
  }
}
var _PropertyDetailsComponent = class _PropertyDetailsComponent {
  constructor(localAppointmentService, appointmentService, uiService, inspectionService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.inspectionService = inspectionService;
    this.availableEntities = [];
    this.availableFixtures = [];
    this.NoteAudience = NoteAudience;
    this.customerNotes = "";
    this.shopNotes = "";
    this.editingAttributes = false;
    this.showAttributesUI = false;
    this.editingUnit = false;
  }
  // #region Authentication
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  update() {
    this.appointment?.changed$.next();
  }
  initAvailableEntities() {
    let availableProperty;
    let availableStructure;
    let availableRoom;
    let availableUnit;
    let availableFloor;
    const availableEntities = [];
    const availableFixtures = [];
    if (this.appointment != null) {
      this.appointment.availableEntities.forEach((e) => {
        e.entities.forEach((ee) => {
          switch (ee.type) {
            case PropertyEntityType.Property:
              availableProperty = ee;
              break;
            case PropertyEntityType.Unit:
              availableUnit = ee;
              break;
            case PropertyEntityType.Structure:
              availableStructure = ee;
              break;
            case PropertyEntityType.Floor:
              availableFloor = ee;
              break;
            case PropertyEntityType.Room:
              availableRoom = ee;
              break;
          }
          availableEntities.push(ee);
        });
      });
      this.appointment.availableFixtures.forEach((f) => {
        f.fixtures.forEach((ff) => {
          availableFixtures.push(ff);
        });
      });
      this.appointment.changed$.next();
    }
    this.availableProperty = availableProperty;
    this.availableStructure = availableStructure;
    this.availableFloor = availableFloor;
    this.availableRoom = availableRoom;
    this.availableUnit = availableUnit;
    this.availableEntities = availableEntities;
    this.availableFixtures = availableFixtures;
  }
  initProperty() {
    if (this.appointment != null) {
      const property = this.appointment.property;
      if (property != null) {
        if (this.availableProperty != null && property.entity == null) {
          const attributes = this.uiService.deepClone(this.availableProperty.attributes);
          const mappedAttributes = this.appointmentService.mapAttributes(attributes);
          property.entity = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableProperty.entityId, this.availableProperty.type, "Property", 1, mappedAttributes, [], new RenderDimensions(0, 0, 0, 0, 0), {}, [], [], [], void 0, void 0, {});
          this.property = property.entity;
        } else {
          this.property = property.entity;
        }
        this.appointment.changed$.next();
        this.initAttributes();
      }
    }
  }
  updateNotes(type) {
    if (this.property != null) {
      switch (type) {
        case NoteAudience.Customer:
          this.property.notes[NoteAudience.Customer] = this.customerNotes;
          break;
        case NoteAudience.Shop:
          this.property.notes[NoteAudience.Shop] = this.shopNotes;
          break;
      }
      this.update();
    }
  }
  initNotes() {
    if (this.property != null) {
      this.customerNotes = this.property.notes[NoteAudience.Customer] ?? "";
      this.shopNotes = this.property.notes[NoteAudience.Shop] ?? "";
    }
  }
  get attributes() {
    return this.property?.attributes ?? [];
  }
  editAttributes() {
    this.editingAttributes = true;
    this.showAttributesUI = true;
  }
  stopEditingAttributes() {
    window.clearTimeout(this.attributesTimer);
    this.editingAttributes = false;
    this.attributesTimer = window.setTimeout(() => {
      this.showAttributesUI = false;
    }, 250);
  }
  initAttributes() {
    if (this.property != null) {
      if (this.property.hasInvalidAttributes) {
        this.editAttributes();
      }
    }
  }
  get units() {
    return this.property?.entities ?? [];
  }
  get hasUnits() {
    return this.units.length > 0;
  }
  // TEMP: short term hack
  get canAddUnit() {
    return this.units.length < 3;
  }
  inspectFirstUnit() {
    if (this.units.length > 0) {
      this.selectUnit(this.units[0]);
    }
  }
  selectUnit(unit) {
    this.selectedUnit = unit;
    this.editingUnit = true;
  }
  stopEditingUnit() {
    window.clearTimeout(this.editingUnitTimer);
    this.editingUnit = false;
    this.editingUnitTimer = window.setTimeout(() => {
      this.selectedUnit = void 0;
    }, 250);
  }
  addUnit() {
    if (this.property != null && this.availableUnit != null) {
      let unitAttribute;
      for (var i = 0, len = this.property.attributes.length; i < len; i++) {
        const attribute = this.property.attributes[i];
        if (attribute.name.toLowerCase() == "number of units") {
          unitAttribute = attribute;
          break;
        }
      }
      if (unitAttribute != null && this.property.entities.length < unitAttribute.possibleValues.length) {
        const newUnit = new AppointmentPropertyEntity(this.uiService.generateId(), this.availableUnit.entityId, this.availableUnit.type, "New Unit", 1, this.availableUnit.attributes, [], new RenderDimensions(0, 0, 0, 0, 0), {}, [], [], [], void 0, void 0, {});
        this.property.entities.push(newUnit);
        unitAttribute.values = [this.property.entities.length.toString()];
      }
      this.appointment?.changed$.next();
    }
  }
  // #endregion
  // #region Navigation
  get routeService() {
    return this.localAppointmentService.routeService;
  }
  get canGoForward() {
    return this.appointment?.property?.entity?.valid ?? false;
  }
  get canGoToPresentation() {
    return this.appointment?.inspectionCompleted ?? false;
  }
  goBack() {
    if (this.appointment != null) {
      this.localAppointmentService.goToNeeds(this.appointment);
    }
  }
  goForward() {
    this.routeService.viewRoute(AppointmentRouteType.Presentation, RouteLoadDirection.Forward, true);
  }
  init() {
    this.initAvailableEntities();
    this.initProperty();
    this.initNotes();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_PropertyDetailsComponent.\u0275fac = function PropertyDetailsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PropertyDetailsComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(InspectionService));
};
_PropertyDetailsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PropertyDetailsComponent, selectors: [["property-details"]], viewQuery: function PropertyDetailsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c011, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment" }, standalone: false, decls: 18, vars: 7, consts: [["id", "propertyDetails"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-arrow-left-long"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], ["id", "unitView"], [1, "bg"], [3, "appointment", "unit", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure"], [1, "columns"], [1, "column", "units"], [1, "content"], [1, "message"], [1, "units"], [1, "unit"], [1, "property", "column"], [1, "tooltip"], [1, "notes"], [1, "note"], ["rows", "5", "placeholder", "If you have any notes for our customer, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["rows", "5", "placeholder", "If you have any notes important for the shop, you can enter them here...", 3, "input", "ngModelChange", "disabled", "ngModel"], ["id", "standaloneAttributes"], [1, "attributes"], [3, "close", "appointment", "entity", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure", "attributes", "headerLabel", "saveLabel"], [1, "unit", 3, "click"], ["width", "1", "height", "1"], [1, "render"], [1, "placeholder"], [1, "warning", "no-render"], [3, "src"], [3, "close", "appointment", "unit", "availableEntities", "availableFixtures", "availableFloor", "availableRoom", "availableUnit", "availableStructure"]], template: function PropertyDetailsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, PropertyDetailsComponent_Conditional_0_Template, 27, 20, "section", 0);
    \u0275\u0275elementStart(1, "nav", 1)(2, "div", 2)(3, "div", 3)(4, "button", 4);
    \u0275\u0275listener("click", function PropertyDetailsComponent_Template_button_click_4_listener() {
      return ctx.goBack();
    });
    \u0275\u0275element(5, "i", 5);
    \u0275\u0275elementStart(6, "label");
    \u0275\u0275text(7, "Back to Needs Assessment");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(8, "button", 4);
    \u0275\u0275listener("click", function PropertyDetailsComponent_Template_button_click_8_listener() {
      return ctx.editAttributes();
    });
    \u0275\u0275elementStart(9, "label");
    \u0275\u0275text(10, "Change Property Details");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(11, "button", 6);
    \u0275\u0275listener("click", function PropertyDetailsComponent_Template_button_click_11_listener() {
      return ctx.goForward();
    });
    \u0275\u0275element(12, "i", 7);
    \u0275\u0275elementStart(13, "label");
    \u0275\u0275text(14, "The Repipe Selling Value");
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(15, "aside", 8);
    \u0275\u0275element(16, "div", 9);
    \u0275\u0275conditionalCreate(17, PropertyDetailsComponent_Conditional_17_Template, 1, 8, "unit", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.property != null ? 0 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("hidden", ctx.editingUnit);
    \u0275\u0275advance(10);
    \u0275\u0275property("disabled", !ctx.canGoToPresentation);
    \u0275\u0275advance(4);
    \u0275\u0275classProp("active", ctx.editingUnit);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.selectedUnit != null ? 17 : -1);
  }
}, dependencies: [DefaultValueAccessor, NgControlStatus, NgModel, StandaaloneAttributesComponent, UnitComponent], styles: ['\n\n#propertyDetails[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(7vw + var(--systemOffset-top));\n  left: 0;\n  right: 0;\n  bottom: 7vw;\n  overflow: hidden;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%] {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%] {\n  display: inline-block;\n  height: 100%;\n  vertical-align: middle;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  height: 100%;\n  overflow-x: hidden;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%] {\n  width: 75%;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  margin: 2vw 2vw 1.5vw;\n  padding: 2vw;\n  background-color: var(--color2Alt3);\n  border-radius: 1vw;\n  position: relative;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 65%;\n  text-align: center;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 3.4vw;\n  color: var(--color1Alt1);\n  font-weight: var(--ltweight);\n  font-style: italic;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%] {\n  display: flex;\n  flex-wrap: wrap;\n  align-items: flex-start;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%] {\n  display: block;\n  width: calc(33.3333333333% - 0.6666666667vw);\n  margin-top: 1vw;\n  margin-left: 1vw;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2);\n  padding: 1vw;\n  border-radius: 1vw;\n  position: relative;\n  overflow: hidden;\n  border: 0.2vw var(--color2Alt4) solid;\n  cursor: pointer;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: block;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .placeholder[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 2vw;\n  left: 2vw;\n  right: 2vw;\n  bottom: 2vw;\n  display: block;\n  border: 0.2vw var(--color1) solid;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .placeholder[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  display: block;\n  width: 100%;\n  text-align: center;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > p.warning[_ngcontent-%COMP%] {\n  color: var(--error);\n  font-style: italic;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]:nth-child(-n+3) {\n  margin-top: 0;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.units[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .units[_ngcontent-%COMP%]    > .unit[_ngcontent-%COMP%]:nth-child(3n+1) {\n  margin-left: 0;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%] {\n  width: 25%;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt2);\n  border: 0.1vw var(--color2Alt4) solid;\n  border-right: none;\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  padding: 1vw;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%] {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   .tooltip[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .notes[_ngcontent-%COMP%]    > .note[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  cursor: pointer;\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  background-color: var(--success);\n  text-align: center;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column.property[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#propertyDetails[_ngcontent-%COMP%]   .columns[_ngcontent-%COMP%]    > .column[_ngcontent-%COMP%]:first-child {\n  border-left: none;\n}\n#propertyDetails[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#propertyDetails[_ngcontent-%COMP%]   #standaloneAttributes[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#propertyDetails[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#propertyDetails[_ngcontent-%COMP%]   #standaloneAttributes.active[_ngcontent-%COMP%]    > .attributes[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  opacity: 1;\n  -moz-transition: opacity 0.25s 0.25s;\n  -o-transition: opacity 0.25s 0.25s;\n  -webkit-transition: opacity 0.25s 0.25s;\n  transition: opacity 0.25s 0.25s;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes _ngcontent-%COMP%_unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#unitView[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.3);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#unitView[_ngcontent-%COMP%]    > unit[_ngcontent-%COMP%]     #unit {\n  z-index: 2;\n  -moz-animation-name: unitLoadOut;\n  -ms-animation-name: unitLoadOut;\n  -o-animation-name: unitLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_unitLoadOut;\n  animation-name: _ngcontent-%COMP%_unitLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#unitView[_ngcontent-%COMP%]    > unit[_ngcontent-%COMP%]     #mainNav > .island {\n  -moz-animation-name: unitNavLoadOut;\n  -ms-animation-name: unitNavLoadOut;\n  -o-animation-name: unitNavLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_unitNavLoadOut;\n  animation-name: _ngcontent-%COMP%_unitNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#unitView.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#unitView.active[_ngcontent-%COMP%]    > unit[_ngcontent-%COMP%]     #unit {\n  -moz-animation-name: unitLoadIn;\n  -ms-animation-name: unitLoadIn;\n  -o-animation-name: unitLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_unitLoadIn;\n  animation-name: _ngcontent-%COMP%_unitLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#unitView.active[_ngcontent-%COMP%]    > unit[_ngcontent-%COMP%]     #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: unitNavLoadIn;\n  -ms-animation-name: unitNavLoadIn;\n  -o-animation-name: unitNavLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_unitNavLoadIn;\n  animation-name: _ngcontent-%COMP%_unitNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=property-details.component.css.map */'] });
var PropertyDetailsComponent = _PropertyDetailsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PropertyDetailsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "property-details", template: `@if (property != null) {
  <section id="propertyDetails">
    <div class="columns">
      <div class="column units">
        <div class="content">
          <div class="content">
            @if (!hasUnits) {
              <div class="message">
                <p>
                  Select the number of units on the property before proceeding with your inspection.
                </p>
              </div>
            }
            <div class="units">
              @for (unit of units; track unit) {
                <div class="unit" (click)="selectUnit(unit)">
                  <div class="content">
                    <canvas width="1" height="1"></canvas>
                    @if (unit.localRender != null) {
                      <div class="render">
                        <img [src]="unit.localRender" />
                      </div>
                    }
                    @if (unit.localRender == null) {
                      <div class="placeholder">
                        <label>{{unit.name}}</label>
                      </div>
                    }
                  </div>
                  <footer>
                    @if (!unit.valid) {
                      <p class="warning no-render">
                        Missing Information
                      </p>
                    }
                  </footer>
                </div>
              }
            </div>
          </div>
        </div>
      </div>
      <div class="property column">
        <div class="content">
          <div class="content">
            @if (!property.valid) {
              <div class="tooltip">
                <h3>Tip: Start the Inspection</h3>
                <p>
                  To continue, tap on the unit you're ready to inspect.
                </p>
              </div>
            }
            @if (property.valid) {
              <div class="tooltip">
                <h3>Tip: The Repipe Value</h3>
                <p>
                  When you're done inspecting the property, you can continue to The Repipe Value.
                </p>
              </div>
            }
            <div class="notes">
              <div class="note">
                <label>Customer Notes</label>
                <textarea
                  [disabled]="!canModifyAppointment"
                  rows="5"
                  placeholder="If you have any notes for our customer, you can enter them here..."
                (input)="updateNotes(NoteAudience.Customer)" [(ngModel)]="customerNotes"></textarea>
              </div>
              <div class="note">
                <label>Shop Notes</label>
                <textarea
                  [disabled]="!canModifyAppointment"
                  rows="5"
                  placeholder="If you have any notes important for the shop, you can enter them here..."
                (input)="updateNotes(NoteAudience.Shop)" [(ngModel)]="shopNotes"></textarea>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <aside id="standaloneAttributes" [class.active]="editingAttributes">
      <div class="bg"></div>
      <div class="attributes">
        <standalone-attributes
          [appointment]="appointment"
          [entity]="property"
          [availableEntities]="availableEntities"
          [availableFixtures]="availableFixtures"
          [availableFloor]="availableFloor"
          [availableRoom]="availableRoom"
          [availableUnit]="availableUnit"
          [availableStructure]="availableStructure"
          [attributes]="attributes"
          [headerLabel]="'Please Complete Property Details'"
          [saveLabel]="'Continue Inspection'"
        (close)="stopEditingAttributes()"></standalone-attributes>
      </div>
    </aside>
  </section>
}

<nav id="mainNav" [class.hidden]="editingUnit">
  <div class="island">
    <div class="controls">
      <button class="control" (click)="goBack()">
        <i class="fa-solid fa-arrow-left-long"></i>
        <label>Back to Needs Assessment</label>
      </button>
      <button class="control" (click)="editAttributes()">
        <label>Change Property Details</label>
      </button>
      <button class="control success" [disabled]="!canGoToPresentation" (click)="goForward()">
        <i class="fa-solid fa-arrow-right-long"></i>
        <label>The Repipe Selling Value</label>
      </button>
    </div>
  </div>
</nav>

<aside id="unitView" [class.active]="editingUnit">
  <div class="bg"></div>
  @if (selectedUnit != null) {
    <unit [appointment]="appointment"
      [unit]="selectedUnit"
      [availableEntities]="availableEntities"
      [availableFixtures]="availableFixtures"
      [availableFloor]="availableFloor"
      [availableRoom]="availableRoom"
      [availableUnit]="availableUnit"
      [availableStructure]="availableStructure"
    (close)="stopEditingUnit()"></unit>
  }
</aside>`, styles: ['/* src/app/appointment/inspection/components/property-details/property-details.component.scss */\n#propertyDetails {\n  position: absolute;\n  top: calc(7vw + var(--systemOffset-top));\n  left: 0;\n  right: 0;\n  bottom: 7vw;\n  overflow: hidden;\n}\n#propertyDetails .columns {\n  font-size: 0;\n  height: 100%;\n  width: 100%;\n}\n#propertyDetails .columns > .column {\n  display: inline-block;\n  height: 100%;\n  vertical-align: middle;\n}\n#propertyDetails .columns > .column > .content {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#propertyDetails .columns > .column > .content > .content {\n  flex: 1;\n  height: 100%;\n  overflow-x: hidden;\n  border-right: 0.1vw var(--color2Alt4) solid;\n  padding: 1vw 1vw 5vw;\n}\n#propertyDetails .columns > .column.units {\n  width: 75%;\n}\n#propertyDetails .columns > .column.units > .content > .content {\n  margin: 2vw 2vw 1.5vw;\n  padding: 2vw;\n  background-color: var(--color2Alt3);\n  border-radius: 1vw;\n  position: relative;\n}\n#propertyDetails .columns > .column.units > .content > .content > .message {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 65%;\n  text-align: center;\n}\n#propertyDetails .columns > .column.units > .content > .content > .message p {\n  font-size: 3.4vw;\n  color: var(--color1Alt1);\n  font-weight: var(--ltweight);\n  font-style: italic;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units {\n  display: flex;\n  flex-wrap: wrap;\n  align-items: flex-start;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit {\n  display: block;\n  width: calc(33.3333333333% - 0.6666666667vw);\n  margin-top: 1vw;\n  margin-left: 1vw;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > .content {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2);\n  padding: 1vw;\n  border-radius: 1vw;\n  position: relative;\n  overflow: hidden;\n  border: 0.2vw var(--color2Alt4) solid;\n  cursor: pointer;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > .content > canvas {\n  width: 100%;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > .content > .render {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  display: block;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > .content > .render img {\n  width: 100%;\n  height: 100%;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > .content > .placeholder {\n  position: absolute;\n  top: 2vw;\n  left: 2vw;\n  right: 2vw;\n  bottom: 2vw;\n  display: block;\n  border: 0.2vw var(--color1) solid;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > .content > .placeholder > label {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  display: block;\n  width: 100%;\n  text-align: center;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > footer {\n  margin-top: 0.25vw;\n  display: flex;\n  justify-content: center;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > footer > p {\n  font-size: 1vw;\n  text-transform: uppercase;\n  font-weight: var(--stronger);\n  white-space: nowrap;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit > footer > p.warning {\n  color: var(--error);\n  font-style: italic;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit:nth-child(-n+3) {\n  margin-top: 0;\n}\n#propertyDetails .columns > .column.units > .content > .content > .units > .unit:nth-child(3n+1) {\n  margin-left: 0;\n}\n#propertyDetails .columns > .column.property {\n  width: 25%;\n}\n#propertyDetails .columns > .column.property > .content {\n  position: relative;\n}\n#propertyDetails .columns > .column.property > .content > .content {\n  background-color: var(--color2Alt2);\n  border: 0.1vw var(--color2Alt4) solid;\n  border-right: none;\n  border-top-left-radius: 2vw;\n  border-bottom-left-radius: 2vw;\n  padding: 1vw;\n}\n#propertyDetails .columns > .column.property > .content > .content .tooltip {\n  border-radius: 1vw;\n  padding: 1vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  margin-bottom: 1vw;\n}\n#propertyDetails .columns > .column.property > .content > .content .tooltip h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  margin-bottom: 0.5vw;\n}\n#propertyDetails .columns > .column.property > .content > .content .tooltip p {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#propertyDetails .columns > .column.property > .content > .content > .notes > .note {\n  margin-top: 1vw;\n}\n#propertyDetails .columns > .column.property > .content > .content > .notes > .note label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  display: block;\n}\n#propertyDetails .columns > .column.property > .content > .content > .notes > .note textarea {\n  margin-top: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color1) solid;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  padding: 1vw;\n  display: block;\n  width: 100%;\n  font-family:\n    "Times New Roman",\n    Times,\n    serif;\n  resize: none;\n}\n#propertyDetails .columns > .column.property > .content > .content > .notes > .note:first-child {\n  margin-top: 0;\n}\n#propertyDetails .columns > .column.property > .content > .content > .controls {\n  margin-top: 1vw;\n}\n#propertyDetails .columns > .column.property > .content > .content > .controls > .control {\n  display: block;\n  width: 100%;\n  cursor: pointer;\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  background-color: var(--success);\n  text-align: center;\n}\n#propertyDetails .columns > .column.property > .content > .content > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n#propertyDetails .columns > .column.property > .content > .content > .controls > .control.alternate {\n  background-color: var(--color3);\n}\n#propertyDetails .columns > .column.property > .content > .content > .controls > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n#propertyDetails .columns > .column:first-child {\n  border-left: none;\n}\n#propertyDetails #standaloneAttributes > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.9);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#propertyDetails #standaloneAttributes > .attributes {\n  display: block;\n  position: absolute;\n  top: 5%;\n  left: 30%;\n  right: 30%;\n  bottom: 5%;\n  z-index: 2;\n  background-color: var(--color2Alt1);\n  border-radius: 1vw;\n  overflow: hidden;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n  -moz-transition: opacity 0.2s, transform 0.2s;\n  -o-transition: opacity 0.2s, transform 0.2s;\n  -webkit-transition: opacity 0.2s, transform 0.2s;\n  transition: opacity 0.2s, transform 0.2s;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#propertyDetails #standaloneAttributes.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#propertyDetails #standaloneAttributes.active > .attributes {\n  opacity: 1;\n  pointer-events: initial;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n  opacity: 1;\n  -moz-transition: opacity 0.25s 0.25s;\n  -o-transition: opacity 0.25s 0.25s;\n  -webkit-transition: opacity 0.25s 0.25s;\n  transition: opacity 0.25s 0.25s;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#mainNav.hidden > .island {\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.25s linear;\n  -o-transition: opacity 0.25s linear;\n  -webkit-transition: opacity 0.25s linear;\n  transition: opacity 0.25s linear;\n}\n@-webkit-keyframes unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-moz-keyframes unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-o-keyframes unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@keyframes unitLoadIn {\n  0% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n  100% {\n    -moz-transform: translateX(0);\n    -ms-transform: translateX(0);\n    -o-transform: translateX(0);\n    -webkit-transform: translateX(0);\n    transform: translateX(0);\n  }\n}\n@-webkit-keyframes unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes unitLoadOut {\n  to {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes unitNavLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-moz-keyframes unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@-o-keyframes unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n@keyframes unitNavLoadOut {\n  to {\n    opacity: 0;\n  }\n}\n#unitView > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  background-color: rgba(var(--color2Alt1-raw), 0.3);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#unitView > unit ::ng-deep #unit {\n  z-index: 2;\n  -moz-animation-name: unitLoadOut;\n  -ms-animation-name: unitLoadOut;\n  -o-animation-name: unitLoadOut;\n  -webkit-animation-name: unitLoadOut;\n  animation-name: unitLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#unitView > unit ::ng-deep #mainNav > .island {\n  -moz-animation-name: unitNavLoadOut;\n  -ms-animation-name: unitNavLoadOut;\n  -o-animation-name: unitNavLoadOut;\n  -webkit-animation-name: unitNavLoadOut;\n  animation-name: unitNavLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#unitView.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#unitView.active > unit ::ng-deep #unit {\n  -moz-animation-name: unitLoadIn;\n  -ms-animation-name: unitLoadIn;\n  -o-animation-name: unitLoadIn;\n  -webkit-animation-name: unitLoadIn;\n  animation-name: unitLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#unitView.active > unit ::ng-deep #mainNav > .island {\n  opacity: 0;\n  -moz-animation-name: unitNavLoadIn;\n  -ms-animation-name: unitNavLoadIn;\n  -o-animation-name: unitNavLoadIn;\n  -webkit-animation-name: unitNavLoadIn;\n  animation-name: unitNavLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0.3s;\n  -ms-animation-delay: 0.3s;\n  -o-animation-delay: 0.3s;\n  -webkit-animation-delay: 0.3s;\n  animation-delay: 0.3s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=property-details.component.css.map */\n'] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }, { type: InspectionService }], { appointment: [{
    type: Input
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PropertyDetailsComponent, { className: "PropertyDetailsComponent" });
})();

// src/app/appointment/inspection/components/layout/layout.component.ts
var _c012 = ["componentElm"];
function InspectionLayoutComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1);
    \u0275\u0275element(2, "property-details", 2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275property("appointment", ctx_r0.appointment);
  }
}
var _InspectionLayoutComponent = class _InspectionLayoutComponent {
  constructor(localAppointmentService, appointmentService, uiService, inspectionService) {
    this.localAppointmentService = localAppointmentService;
    this.appointmentService = appointmentService;
    this.uiService = uiService;
    this.inspectionService = inspectionService;
    this.invalidEntities = [];
    this.activeSection = "propertyDetails";
  }
  get canModifyAppointment() {
    return this.localAppointmentService.canModifyAppointment;
  }
  get property() {
    return this.appointment?.property?.entity;
  }
  get hasInvalidEntities() {
    return this.invalidEntities.length > 0;
  }
  setActiveSection(section) {
    this.activeSection = section;
  }
  init() {
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_InspectionLayoutComponent.\u0275fac = function InspectionLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _InspectionLayoutComponent)(\u0275\u0275directiveInject(LocalAppointmentService), \u0275\u0275directiveInject(AppointmentService), \u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(InspectionService));
};
_InspectionLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _InspectionLayoutComponent, selectors: [["ng-component"]], viewQuery: function InspectionLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c012, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointment: "appointment", route: "route" }, standalone: false, decls: 1, vars: 1, consts: [["id", "inspectionLayout"], [1, "content"], [3, "appointment"]], template: function InspectionLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, InspectionLayoutComponent_Conditional_0_Template, 3, 1, "section", 0);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.appointment != null ? 0 : -1);
  }
}, dependencies: [PropertyDetailsComponent], styles: ["\n\n#inspectionLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: calc(var(--navLayer) + 1);\n  top: calc(1.1vw + var(--systemOffset-top));\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  right: 8vw;\n  display: flex;\n  align-items: center;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#inspectionLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#inspectionLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  height: 3.5vw;\n  width: 3.5vw;\n  border-radius: 100%;\n  position: relative;\n  cursor: pointer;\n  display: block;\n  position: relative;\n}\n#inspectionLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n#inspectionLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%] {\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: translateX(0) translateY(0);\n  -ms-transform: translateX(0) translateY(0);\n  -o-transform: translateX(0) translateY(0);\n  -webkit-transform: translateX(0) translateY(0);\n  transform: translateX(0) translateY(0);\n}\n#inspectionLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.active[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color2-raw), 0.4);\n}\n#inspectionLayout[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   property-details[_ngcontent-%COMP%] {\n  display: block;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var InspectionLayoutComponent = _InspectionLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(InspectionLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '@if (appointment != null) {\n  <section id="inspectionLayout">\n    <div class="content">\n      <property-details [appointment]="appointment"></property-details>\n    </div>\n  </section>\n}', styles: ["/* src/app/appointment/inspection/components/layout/layout.component.scss */\n#inspectionLayout > header {\n  position: absolute;\n  z-index: calc(var(--navLayer) + 1);\n  top: calc(1.1vw + var(--systemOffset-top));\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.25vw 1vw;\n  right: 8vw;\n  display: flex;\n  align-items: center;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#inspectionLayout > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#inspectionLayout > header > .controls > .control {\n  height: 3.5vw;\n  width: 3.5vw;\n  border-radius: 100%;\n  position: relative;\n  cursor: pointer;\n  display: block;\n  position: relative;\n}\n#inspectionLayout > header > .controls > .control i {\n  font-size: 1.6vw;\n  color: var(--color1);\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n}\n#inspectionLayout > header > .controls > .control.nav-control {\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: translateX(0) translateY(0);\n  -ms-transform: translateX(0) translateY(0);\n  -o-transform: translateX(0) translateY(0);\n  -webkit-transform: translateX(0) translateY(0);\n  transform: translateX(0) translateY(0);\n}\n#inspectionLayout > header > .controls > .control.active {\n  background-color: rgba(var(--color2-raw), 0.4);\n}\n#inspectionLayout > .content property-details {\n  display: block;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: LocalAppointmentService }, { type: AppointmentService }, { type: UiService }, { type: InspectionService }], { appointment: [{
    type: Input
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(InspectionLayoutComponent, { className: "InspectionLayoutComponent" });
})();

// src/app/appointment/inspection/inspection.module.ts
var _InspectionModule = class _InspectionModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(InspectionLayoutComponent, { injector: this.injector });
    customElements.define("appointment-inspection", el);
  }
};
_InspectionModule.\u0275fac = function InspectionModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _InspectionModule)(\u0275\u0275inject(Injector));
};
_InspectionModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _InspectionModule });
_InspectionModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  InternalRouteService,
  InspectionService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var InspectionModule = _InspectionModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(InspectionModule, [{
    type: NgModule,
    args: [{
      declarations: [
        InspectionLayoutComponent,
        PropertyDetailsComponent,
        StandaaloneAttributesComponent,
        AttributesComponent,
        UnitComponent,
        StructureComponent,
        PhotoComponent,
        FixtureComponent,
        FixturesComponent,
        FixtureRenderComponent,
        StructureRenderComponent,
        RoomComponent,
        RoomRenderComponent
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        InternalRouteService,
        InspectionService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  InspectionModule
};
//# sourceMappingURL=chunk-DEO7UXB7.js.map
