import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import {
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  CurrencyPipe,
  DatePipe,
  DefaultValueAccessor,
  FormsModule,
  Injectable,
  Injector,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  OrderByPipe,
  ReactiveFormsModule,
  SelectControlValueAccessor,
  UiModule,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵinject,
  ɵɵlistener,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind2,
  ɵɵproperty,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵtext,
  ɵɵtextInterpolate1,
  ɵɵtextInterpolate2,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty
} from "./chunk-VAMMRICA.js";
import "./chunk-RVA4KI76.js";

// src/app/reporting/services/reporting.service.ts
var _ReportingService = class _ReportingService {
  constructor() {
  }
};
_ReportingService.\u0275fac = function ReportingService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ReportingService)();
};
_ReportingService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _ReportingService, factory: _ReportingService.\u0275fac, providedIn: "root" });
var ReportingService = _ReportingService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ReportingService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [], null);
})();

// src/app/reporting/components/sales-week/estimates/estimates.component.ts
function SalesWeekEstimatesComponent_For_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 8);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "date");
    \u0275\u0275pipe(3, "date");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const week_r1 = ctx.$implicit;
    \u0275\u0275property("ngValue", week_r1.weekId);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate2(" ", \u0275\u0275pipeBind2(2, 3, week_r1.startDate, "MMM dd, yyyy"), " - ", \u0275\u0275pipeBind2(3, 6, week_r1.endDate, "MMM dd, yyy"), " ");
  }
}
function SalesWeekEstimatesComponent_Conditional_14_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 10)(1, "h2");
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "currency");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5);
    \u0275\u0275pipe(6, "date");
    \u0275\u0275pipe(7, "date");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(3, 3, ctx_r1.activeWeek.totalNetCommission, "USD"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate2(" Total Commissions for ", \u0275\u0275pipeBind2(6, 6, ctx_r1.activeWeek.startDate, "MM/dd/yy"), " - ", \u0275\u0275pipeBind2(7, 9, ctx_r1.activeWeek.endDate, "MM/dd/yy"), " ");
  }
}
function SalesWeekEstimatesComponent_Conditional_14_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 11)(1, "p");
    \u0275\u0275text(2, "No commission estimates available.");
    \u0275\u0275elementEnd()();
  }
}
function SalesWeekEstimatesComponent_Conditional_14_Conditional_3_For_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 13)(1, "header")(2, "div", 1)(3, "div", 14)(4, "label");
    \u0275\u0275text(5, "Date Sold");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "span", 15);
    \u0275\u0275text(7);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(8, "div", 16)(9, "label");
    \u0275\u0275text(10, "Job Id");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(11, "span", 15);
    \u0275\u0275text(12);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(13, "div", 17)(14, "span", 15);
    \u0275\u0275text(15);
    \u0275\u0275pipe(16, "currency");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(17, "label");
    \u0275\u0275text(18, "Net Commission");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "div", 18)(20, "span", 15);
    \u0275\u0275text(21);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "label");
    \u0275\u0275text(23, "Commission Percent");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "div", 19)(25, "div", 20)(26, "label");
    \u0275\u0275text(27, "Customer Name");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "span", 15);
    \u0275\u0275text(29);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(30, "div", 20)(31, "label");
    \u0275\u0275text(32, "PAR Price");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(33, "span", 15);
    \u0275\u0275text(34);
    \u0275\u0275pipe(35, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(36, "div", 20)(37, "label");
    \u0275\u0275text(38, "ABL Price");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(39, "span", 15);
    \u0275\u0275text(40);
    \u0275\u0275pipe(41, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(42, "div", 20)(43, "label");
    \u0275\u0275text(44, "Contract Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(45, "span", 15);
    \u0275\u0275text(46);
    \u0275\u0275pipe(47, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(48, "div", 20)(49, "label");
    \u0275\u0275text(50, "Gross Profit");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(51, "span", 15);
    \u0275\u0275text(52);
    \u0275\u0275pipe(53, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(54, "div", 20)(55, "label");
    \u0275\u0275text(56, "CommissionableAmount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(57, "span", 15);
    \u0275\u0275text(58);
    \u0275\u0275pipe(59, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(60, "div", 20)(61, "label");
    \u0275\u0275text(62, "Overlist");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(63, "span", 15);
    \u0275\u0275text(64);
    \u0275\u0275pipe(65, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(66, "div", 20)(67, "label");
    \u0275\u0275text(68, "Over List Bonus");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(69, "span", 15);
    \u0275\u0275text(70);
    \u0275\u0275pipe(71, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(72, "div", 20)(73, "label");
    \u0275\u0275text(74, "Self Gen Bonus");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(75, "span", 15);
    \u0275\u0275text(76);
    \u0275\u0275pipe(77, "currency");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(78, "div", 20)(79, "label");
    \u0275\u0275text(80, "Credit Card Fee");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(81, "span", 15);
    \u0275\u0275text(82);
    \u0275\u0275pipe(83, "currency");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const estimate_r3 = ctx.$implicit;
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", estimate_r3.dateSold, " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", estimate_r3.jobId, " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(16, 14, estimate_r3.netCommission, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", estimate_r3.commissionPercent, "% ");
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate1(" ", estimate_r3.customerName, " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(35, 17, estimate_r3.parPrice, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(41, 20, estimate_r3.ablPrice, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(47, 23, estimate_r3.contractAmount, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(53, 26, estimate_r3.grossProfit, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(59, 29, estimate_r3.commissionableAmount, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(65, 32, estimate_r3.overlistAmount, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(71, 35, estimate_r3.overlistBonus, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(77, 38, estimate_r3.selfGenBonus, "USD"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(83, 41, estimate_r3.transactionFee, "USD"), " ");
  }
}
function SalesWeekEstimatesComponent_Conditional_14_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 12);
    \u0275\u0275repeaterCreate(1, SalesWeekEstimatesComponent_Conditional_14_Conditional_3_For_2_Template, 84, 44, "div", 13, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r1.displayEstimates);
  }
}
function SalesWeekEstimatesComponent_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 9);
    \u0275\u0275conditionalCreate(1, SalesWeekEstimatesComponent_Conditional_14_Conditional_1_Template, 8, 12, "div", 10);
    \u0275\u0275conditionalCreate(2, SalesWeekEstimatesComponent_Conditional_14_Conditional_2_Template, 3, 0, "div", 11);
    \u0275\u0275conditionalCreate(3, SalesWeekEstimatesComponent_Conditional_14_Conditional_3_Template, 3, 0, "div", 12);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.activeWeek != null ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx_r1.hasEstimates ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r1.hasEstimates ? 3 : -1);
  }
}
var _SalesWeekEstimatesComponent = class _SalesWeekEstimatesComponent {
  constructor(uiService, orderByPipe) {
    this.uiService = uiService;
    this.orderByPipe = orderByPipe;
    this.weeks = [];
    this.displayEstimates = [];
    this.searchInput = "";
  }
  get hasEstimates() {
    return this.displayEstimates.length > 0;
  }
  setActiveWeek(id) {
    this.activeWeek = this.weeks.find((x) => x.weekId == id);
    this.activeWeekId = id;
    this.filterEstimates();
  }
  initEstimates() {
  }
  filterEstimates() {
    const displayEstimates = [];
    const searchInput = this.searchInput.toLocaleLowerCase();
    if (this.activeWeek != null) {
      this.activeWeek.estimates.forEach((estimate) => {
        let matched = false;
        if (searchInput.length <= 0) {
          matched = true;
        } else {
          if (estimate.customerName != null) {
            const customerName = estimate.customerName.toLowerCase();
            if (customerName.includes(searchInput)) {
              matched = true;
            }
          }
          if (estimate.jobId != null) {
            const jobStr = estimate.jobId.toString();
            if (jobStr.includes(searchInput)) {
              matched = true;
            }
          }
        }
        if (matched) {
          displayEstimates.push(estimate);
        }
      });
    }
    this.displayEstimates = displayEstimates;
  }
  // #endregion
  // #region Bootstrapping
  init() {
    this.initEstimates();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_SalesWeekEstimatesComponent.\u0275fac = function SalesWeekEstimatesComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SalesWeekEstimatesComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(OrderByPipe));
};
_SalesWeekEstimatesComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SalesWeekEstimatesComponent, selectors: [["sales-week-estimates"]], standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 15, vars: 3, consts: [["id", "salesWeekEstimates"], [1, "primary"], [1, "search"], [1, "input"], ["type", "text", "placeholder", "Search estimates...", 3, "ngModelChange", "input", "ngModel"], [1, "sorting"], [1, "control"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [1, "estimates"], [1, "meta"], [1, "message"], [1, "estimate-wrap"], [1, "estimate"], [1, "date"], [1, "value"], [1, "job"], [1, "amount"], [1, "commission-percent"], [1, "details"], [1, "item"]], template: function SalesWeekEstimatesComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "div", 2)(4, "div", 3)(5, "input", 4);
    \u0275\u0275twoWayListener("ngModelChange", function SalesWeekEstimatesComponent_Template_input_ngModelChange_5_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.searchInput, $event) || (ctx.searchInput = $event);
      return $event;
    });
    \u0275\u0275listener("input", function SalesWeekEstimatesComponent_Template_input_input_5_listener() {
      return ctx.filterEstimates();
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(6, "div", 5)(7, "div", 6)(8, "label");
    \u0275\u0275text(9, "Sales Week");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "div", 3)(11, "select", 7);
    \u0275\u0275twoWayListener("ngModelChange", function SalesWeekEstimatesComponent_Template_select_ngModelChange_11_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.activeWeekId, $event) || (ctx.activeWeekId = $event);
      return $event;
    });
    \u0275\u0275listener("change", function SalesWeekEstimatesComponent_Template_select_change_11_listener() {
      return ctx.setActiveWeek(ctx.activeWeekId);
    });
    \u0275\u0275repeaterCreate(12, SalesWeekEstimatesComponent_For_13_Template, 4, 9, "option", 8, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()()()();
    \u0275\u0275conditionalCreate(14, SalesWeekEstimatesComponent_Conditional_14_Template, 4, 3, "div", 9);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.searchInput);
    \u0275\u0275advance(6);
    \u0275\u0275twoWayProperty("ngModel", ctx.activeWeekId);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.weeks);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.activeWeek ? 14 : -1);
  }
}, dependencies: [NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, NgModel, CurrencyPipe, DatePipe], styles: ["\n\n#salesWeekEstimates[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  padding: calc(6vw + var(--systemOffset-top)) 2vw 5vw 2vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  position: sticky;\n  top: 0;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%] {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .search[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%] {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .sorting[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  text-align: center;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 4vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  text-align: center;\n  font-size: 6vw;\n  font-weight: var(--stronger);\n  color: var(--color1Alt4);\n  font-style: italic;\n  line-height: 1;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 1vw;\n  text-align: center;\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  display: flex;\n  flex-wrap: wrap;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%] {\n  width: calc(25% - 1.125vw);\n  border-radius: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 1vw;\n  margin-left: 1.5vw;\n  margin-top: 1.5vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .date[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 1vw 2vw;\n  background-color: rgba(var(--success-raw), 0.1);\n  border: 0.2vw rgba(var(--success-raw), 0.2) solid;\n  border-radius: 1vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  font-size: 3.2vw;\n  color: var(--successAlt3);\n  text-shadow:\n    -2px -2px 2px var(--color2),\n    -2px 2px 2px var(--color2),\n    2px -2px 2px var(--color2),\n    2px 2px 2px var(--color2);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .amount[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  line-height: 1;\n  display: block;\n  text-align: center;\n  font-size: 1.2vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .commission-percent[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 1vw 2vw;\n  background-color: rgba(var(--color5-raw), 0.1);\n  border: 0.2vw rgba(var(--color5-raw), 0.2) solid;\n  border-radius: 1vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .commission-percent[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  text-align: center;\n  font-size: 3.2vw;\n  color: var(--color5Alt3);\n  text-shadow:\n    -2px -2px 2px var(--color2),\n    -2px 2px 2px var(--color2),\n    2px -2px 2px var(--color2),\n    2px 2px 2px var(--color2);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .commission-percent[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  line-height: 1;\n  display: block;\n  text-align: center;\n  font-size: 1.2vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  line-height: 1;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  line-height: 1;\n  display: block;\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--mdweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .item[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]:nth-child(-n+4) {\n  margin-top: 0;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .estimate-wrap[_ngcontent-%COMP%]    > .estimate[_ngcontent-%COMP%]:nth-child(4n+1) {\n  margin-left: 0;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#salesWeekEstimates[_ngcontent-%COMP%]    > .estimates[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 4vw;\n  top: calc(20vh + var(--systemOffset-top));\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n/*# sourceMappingURL=estimates.component.css.map */"] });
var SalesWeekEstimatesComponent = _SalesWeekEstimatesComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SalesWeekEstimatesComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "sales-week-estimates", providers: [OrderByPipe], template: `<section id="salesWeekEstimates">
  <header>
    <div class="primary">
      <div class="search">
        <div class="input">
          <input type="text" [(ngModel)]="searchInput" (input)="filterEstimates()"
            placeholder="Search estimates..." />
        </div>
      </div>
      <div class="sorting">
        <div class="control">
          <label>Sales Week</label>
          <div class="input">
            <select [(ngModel)]="activeWeekId" (change)="setActiveWeek(activeWeekId)">
              @for (week of weeks; track week) {
                <option [ngValue]="week.weekId">
                  {{week.startDate | date:'MMM dd, yyyy'}}
                  -
                  {{week.endDate | date:'MMM dd, yyy'}}
                </option>
              }
            </select>
          </div>
        </div>
      </div>
    </div>
  </header>

  @if (activeWeek) {
    <div class="estimates">
      @if (activeWeek != null) {
        <div class="meta">
          <h2>
            {{activeWeek.totalNetCommission | currency:'USD'}}
          </h2>
          <label>
            Total Commissions for
            {{activeWeek.startDate | date:'MM/dd/yy'}}
            -
            {{activeWeek.endDate | date:'MM/dd/yy'}}
          </label>
        </div>
      }
      @if (!hasEstimates) {
        <div class="message">
          <p>No commission estimates available.</p>
        </div>
      }
      @if (hasEstimates) {
        <div class="estimate-wrap">
          @for (estimate of displayEstimates; track estimate) {
            <div class="estimate">
              <header>
                <div class="primary">
                  <div class="date">
                    <label>Date Sold</label>
                    <span class="value">
                      {{estimate.dateSold}}
                    </span>
                  </div>
                  <div class="job">
                    <label>Job Id</label>
                    <span class="value">
                      {{estimate.jobId}}
                    </span>
                  </div>
                </div>
              </header>
              <div class="amount">
                <span class="value">
                  {{estimate.netCommission | currency:'USD'}}
                </span>
                <label>Net Commission</label>
              </div>
              <div class="commission-percent">
                <span class="value">
                  {{estimate.commissionPercent}}%
                </span>
                <label>Commission Percent</label>
              </div>
              <div class="details">
                <div class="item">
                  <label>Customer Name</label>
                  <span class="value">
                    {{estimate.customerName}}
                  </span>
                </div>
                <div class="item">
                  <label>PAR Price</label>
                  <span class="value">
                    {{estimate.parPrice | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>ABL Price</label>
                  <span class="value">
                    {{estimate.ablPrice | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>Contract Amount</label>
                  <span class="value">
                    {{estimate.contractAmount | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>Gross Profit</label>
                  <span class="value">
                    {{estimate.grossProfit | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>CommissionableAmount</label>
                  <span class="value">
                    {{estimate.commissionableAmount | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>Overlist</label>
                  <span class="value">
                    {{estimate.overlistAmount | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>Over List Bonus</label>
                  <span class="value">
                    {{estimate.overlistBonus | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>Self Gen Bonus</label>
                  <span class="value">
                    {{estimate.selfGenBonus | currency:'USD'}}
                  </span>
                </div>
                <div class="item">
                  <label>Credit Card Fee</label>
                  <span class="value">
                    {{estimate.transactionFee | currency:'USD'}}
                  </span>
                </div>
              </div>
            </div>
          }
        </div>
      }
    </div>
  }
</section>`, styles: ["/* src/app/reporting/components/sales-week/estimates/estimates.component.scss */\n#salesWeekEstimates {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  padding: calc(6vw + var(--systemOffset-top)) 2vw 5vw 2vw;\n}\n#salesWeekEstimates > header {\n  position: sticky;\n  top: 0;\n}\n#salesWeekEstimates > header > .primary {\n  width: 95%;\n  margin: 0 auto;\n  z-index: 1;\n  background-color: rgba(var(--color2-raw), 0.9);\n  border-radius: 999px;\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  padding: 1vw 2vw;\n  display: flex;\n  align-items: flex-end;\n}\n#salesWeekEstimates > header > .primary > .search {\n  flex: 1;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n}\n#salesWeekEstimates > header > .primary > .search > .input input {\n  display: block;\n  width: 100%;\n  font-size: 2vw;\n  color: var(--color3);\n  font-weight: var(--ltweight);\n  padding-bottom: 0.25vw;\n}\n#salesWeekEstimates > header > .primary > .sorting {\n  padding-bottom: 0.25vw;\n  padding-left: 2vw;\n  border-bottom: 0.1vw var(--color2Alt4) solid;\n  display: flex;\n  align-items: center;\n}\n#salesWeekEstimates > header > .primary > .sorting > .control {\n  display: block;\n  cursor: pointer;\n  margin-left: 2vw;\n}\n#salesWeekEstimates > header > .primary > .sorting > .control > label {\n  display: block;\n  text-transform: uppercase;\n  color: var(--color2Alt4);\n  font-weight: var(--strong);\n  font-size: 1vw;\n}\n#salesWeekEstimates > header > .primary > .sorting > .control > .input select {\n  display: block;\n  width: 100%;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#salesWeekEstimates > header > .primary > .sorting > .control:first-child {\n  margin-left: 0;\n}\n#salesWeekEstimates > header > .meta {\n  margin-top: 1vw;\n  text-align: center;\n}\n#salesWeekEstimates > header > .meta h2 {\n  font-size: 4vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#salesWeekEstimates > .estimates {\n  margin-top: 2vw;\n}\n#salesWeekEstimates > .estimates > .meta h2 {\n  text-align: center;\n  font-size: 6vw;\n  font-weight: var(--stronger);\n  color: var(--color1Alt4);\n  font-style: italic;\n  line-height: 1;\n}\n#salesWeekEstimates > .estimates > .meta > label {\n  display: block;\n  margin-top: 1vw;\n  text-align: center;\n  font-size: 2vw;\n  color: var(--color1Alt2);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates > .estimates > .estimate-wrap {\n  margin-top: 2vw;\n  display: flex;\n  flex-wrap: wrap;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate {\n  width: calc(25% - 1.125vw);\n  border-radius: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 1vw;\n  margin-left: 1.5vw;\n  margin-top: 1.5vw;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > header > .primary {\n  display: flex;\n  align-items: flex-start;\n  justify-content: space-between;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > header > .primary > .date > label {\n  line-height: 1;\n  display: block;\n  font-size: 1vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > header > .primary > .date > .value {\n  line-height: 1;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > header > .primary > .job {\n  margin-top: 0.25vw;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > header > .primary > .job > label {\n  line-height: 1;\n  display: block;\n  font-size: 1vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n  text-transform: uppercase;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > header > .primary > .job > .value {\n  line-height: 1;\n  display: block;\n  font-size: 1.6vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .amount {\n  margin-top: 1vw;\n  padding: 1vw 2vw;\n  background-color: rgba(var(--success-raw), 0.1);\n  border: 0.2vw rgba(var(--success-raw), 0.2) solid;\n  border-radius: 1vw;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .amount > .value {\n  display: block;\n  text-align: center;\n  font-size: 3.2vw;\n  color: var(--successAlt3);\n  text-shadow:\n    -2px -2px 2px var(--color2),\n    -2px 2px 2px var(--color2),\n    2px -2px 2px var(--color2),\n    2px 2px 2px var(--color2);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .amount > label {\n  margin-top: 0.25vw;\n  line-height: 1;\n  display: block;\n  text-align: center;\n  font-size: 1.2vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .commission-percent {\n  margin-top: 1vw;\n  padding: 1vw 2vw;\n  background-color: rgba(var(--color5-raw), 0.1);\n  border: 0.2vw rgba(var(--color5-raw), 0.2) solid;\n  border-radius: 1vw;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .commission-percent > .value {\n  display: block;\n  text-align: center;\n  font-size: 3.2vw;\n  color: var(--color5Alt3);\n  text-shadow:\n    -2px -2px 2px var(--color2),\n    -2px 2px 2px var(--color2),\n    2px -2px 2px var(--color2),\n    2px 2px 2px var(--color2);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .commission-percent > label {\n  margin-top: 0.25vw;\n  line-height: 1;\n  display: block;\n  text-align: center;\n  font-size: 1.2vw;\n  color: var(--color1Alt4);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .details {\n  margin-top: 2vw;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .details > .item {\n  margin-top: 1vw;\n  padding-top: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .details > .item > label {\n  line-height: 1;\n  display: block;\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  font-weight: var(--strong);\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .details > .item > .value {\n  margin-top: 0.25vw;\n  line-height: 1;\n  display: block;\n  font-size: 1.8vw;\n  color: var(--color1);\n  font-weight: var(--mdweight);\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate > .details > .item:first-child {\n  margin-top: 0;\n  padding-top: 0;\n  border-top: none;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate:nth-child(-n+4) {\n  margin-top: 0;\n}\n#salesWeekEstimates > .estimates > .estimate-wrap > .estimate:nth-child(4n+1) {\n  margin-left: 0;\n}\n#salesWeekEstimates > .estimates > .message {\n  margin-top: 2vw;\n}\n#salesWeekEstimates > .estimates > .message > p {\n  font-size: 4vw;\n  top: calc(20vh + var(--systemOffset-top));\n  font-weight: var(--ltweight);\n  font-style: italic;\n  white-space: nowrap;\n  color: var(--color1Alt1);\n  text-align: center;\n}\n/*# sourceMappingURL=estimates.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: OrderByPipe }], null);
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SalesWeekEstimatesComponent, { className: "SalesWeekEstimatesComponent" });
})();

// src/app/reporting/components/layout/layout.component.ts
var _ReportingLayoutComponent = class _ReportingLayoutComponent {
  constructor(uiService, reportingService) {
    this.uiService = uiService;
    this.reportingService = reportingService;
  }
  // #region Bootstrapping
  init() {
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_ReportingLayoutComponent.\u0275fac = function ReportingLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ReportingLayoutComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(ReportingService));
};
_ReportingLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ReportingLayoutComponent, selectors: [["ng-component"]], standalone: false, decls: 11, vars: 0, consts: [["componentElm", ""], ["id", "reportingLayout"], [1, "primary"], [1, "secondary"], [1, "routes"], [1, "route", "active", "rendered"]], template: function ReportingLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "header")(3, "div", 2)(4, "h1");
    \u0275\u0275text(5, "Reporting");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "div", 3)(7, "h2");
    \u0275\u0275text(8, "Commissions Preview");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 4);
    \u0275\u0275element(10, "sales-week-estimates", 5);
    \u0275\u0275elementEnd()();
  }
}, dependencies: [SalesWeekEstimatesComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#reportingLayout[_ngcontent-%COMP%] {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#reportingLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#reportingLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   h1[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#reportingLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n}\n#reportingLayout[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#reportingLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#reportingLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#reportingLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#reportingLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#reportingLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#reportingLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var ReportingLayoutComponent = _ReportingLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ReportingLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '<section id="reportingLayout" #componentElm>\n    <header>\n        <div class="primary">\n            <h1>Reporting</h1>\n        </div>\n        <div class="secondary">\n            <h2>Commissions Preview</h2>\n        </div>\n    </header>\n\n    <div class="routes">\n        <sales-week-estimates class="route active rendered"></sales-week-estimates>\n    </div>\n\n</section>', styles: ["/* src/app/reporting/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#reportingLayout {\n  padding: 1vw 2vw 4vw;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n  overflow-x: hidden;\n}\n#reportingLayout > header {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n  position: relative;\n  z-index: 1;\n}\n#reportingLayout > header > .primary h1 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n}\n#reportingLayout > header > .secondary {\n  margin-left: 1vw;\n}\n#reportingLayout > header > .secondary h2 {\n  font-size: 2.4vw;\n  font-weight: var(--ltweight);\n  color: var(--color3);\n}\n#reportingLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#reportingLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#reportingLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#reportingLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#reportingLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#reportingLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: ReportingService }], null);
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ReportingLayoutComponent, { className: "ReportingLayoutComponent" });
})();

// src/app/reporting/reporting.module.ts
var _ReportingModule = class _ReportingModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    if (!customElements.get("global-dashboard")) {
      const el = createCustomElement(ReportingLayoutComponent, { injector: this.injector });
      customElements.define("global-reporting", el);
    }
  }
};
_ReportingModule.\u0275fac = function ReportingModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ReportingModule)(\u0275\u0275inject(Injector));
};
_ReportingModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _ReportingModule });
_ReportingModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  ReportingService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  CommonModule,
  UiModule,
  ReactiveFormsModule,
  FormsModule
] });
var ReportingModule = _ReportingModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ReportingModule, [{
    type: NgModule,
    args: [{
      declarations: [
        ReportingLayoutComponent,
        SalesWeekEstimatesComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        CommonModule,
        UiModule,
        ReactiveFormsModule,
        FormsModule
      ],
      providers: [
        ReportingService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  ReportingModule
};
//# sourceMappingURL=chunk-HQJPTSN3.js.map
