import {
  AdministrationService
} from "./chunk-RFRQWW6A.js";
import {
  InternalRouteService
} from "./chunk-B4U6NSGR.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-PRTLXG5I.js";
import {
  createCustomElement
} from "./chunk-DQUMCYPT.js";
import {
  SystemService
} from "./chunk-QUJNR5CZ.js";
import {
  UiService
} from "./chunk-WUILV27O.js";
import "./chunk-DNHSR4U6.js";
import {
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  DefaultValueAccessor,
  FormsModule,
  HttpClient,
  Injectable,
  Injector,
  Input,
  LoaderComponent,
  NgControlStatus,
  NgModel,
  NgModule,
  ReactiveFormsModule,
  UiModule,
  ViewChild,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵsanitizeHtml,
  ɵɵtext,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-VAMMRICA.js";
import "./chunk-RVA4KI76.js";

// src/app/administration/system/models/navigation.ts
var RouteType;
(function(RouteType2) {
  RouteType2["logs"] = "logs";
  RouteType2["query"] = "query";
})(RouteType || (RouteType = {}));

// src/app/administration/system/services/system-admin.service.ts
var _SystemAdminService = class _SystemAdminService {
  constructor(http, systemService) {
    this.http = http;
    this.systemService = systemService;
  }
  // #region Queries
  queryData(query) {
    const url = `{{api}}/system/query/data`;
    const headers = { "Content-Type": "application/json" };
    const request = {
      query
    };
    return this.http.post(url, JSON.stringify(request), { headers });
  }
  // #endregion
  // #region Logs
  getLogs() {
    return this.systemService.getLogs();
  }
};
_SystemAdminService.\u0275fac = function SystemAdminService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SystemAdminService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(SystemService));
};
_SystemAdminService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _SystemAdminService, factory: _SystemAdminService.\u0275fac, providedIn: "root" });
var SystemAdminService = _SystemAdminService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SystemAdminService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }, { type: SystemService }], null);
})();

// src/app/administration/system/components/logs/logs.component.ts
var _c0 = ["componentElm"];
function LogsComponent_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "pre", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("innerHtml", ctx_r0.displayLogs, \u0275\u0275sanitizeHtml);
  }
}
var _LogsComponent = class _LogsComponent {
  constructor(systemAdminService) {
    this.systemAdminService = systemAdminService;
    this.searchInput = "";
    this.displayLogs = "";
    this.retrievingLogs = false;
  }
  searchLogs() {
    window.clearTimeout(this.searchDebounce);
    this.searchDebounce = window.setTimeout(() => {
      if (this.logs != null) {
        const logs = this.logs.logs;
        const regex = new RegExp(this.searchInput, "gi");
        const lines = logs.split(/\r\n|\n|\r/);
        const matchingLogs = lines.filter((line) => !this.searchInput || regex.test(line)).map((line) => this.searchInput ? line.replace(regex, (match) => `<span class="highlight">${match}</span>`) : line).join("\n");
        this.initDisplayLogs(matchingLogs);
      }
    }, 250);
  }
  initDisplayLogs(logs) {
    if (this.logs != null) {
      const chunkSize = 100 * 1024 / 2;
      this.displayLogs = logs.substring(0, chunkSize);
    } else {
      this.displayLogs = "";
    }
  }
  getLogs() {
    this.retrievingLogs = true;
    this.systemAdminService.getLogs().subscribe({
      next: (logs) => {
        this.logs = logs;
        this.initDisplayLogs(logs.logs);
        this.retrievingLogs = false;
      },
      error: () => {
        this.retrievingLogs = false;
      }
    });
  }
  // #endregion
  // #region UI
  get showLoader() {
    return this.retrievingLogs;
  }
  init() {
    this.getLogs();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_LogsComponent.\u0275fac = function LogsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LogsComponent)(\u0275\u0275directiveInject(SystemAdminService));
};
_LogsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _LogsComponent, selectors: [["logs"]], viewQuery: function LogsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { route: "route" }, standalone: false, decls: 7, vars: 4, consts: [["id", "logs"], [1, "input-wrap"], ["type", "text", "placeholder", "Search logs...", 3, "ngModelChange", "input", "ngModel"], [1, "content"], [3, "innerHtml"]], template: function LogsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "input", 2);
    \u0275\u0275twoWayListener("ngModelChange", function LogsComponent_Template_input_ngModelChange_3_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.searchInput, $event) || (ctx.searchInput = $event);
      return $event;
    });
    \u0275\u0275listener("input", function LogsComponent_Template_input_input_3_listener() {
      return ctx.searchLogs();
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(4, "div", 3);
    \u0275\u0275conditionalCreate(5, LogsComponent_Conditional_5_Template, 1, 1, "pre", 4);
    \u0275\u0275elementEnd()();
    \u0275\u0275element(6, "loader");
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275twoWayProperty("ngModel", ctx.searchInput);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.logs != null ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.showLoader);
  }
}, dependencies: [LoaderComponent, DefaultValueAccessor, NgControlStatus, NgModel], styles: ["\n\n#logs[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n  display: flex;\n  flex-direction: column;\n}\n#logs[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 2vw;\n  background-color: var(--color2);\n  position: sticky;\n  top: 0;\n}\n#logs[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  font-weight: var(--strong);\n  color: var(--color3);\n  display: block;\n  width: 100%;\n}\n#logs[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  height: 100%;\n  padding: 0 2vw;\n  margin-top: 2vw;\n}\n#logs[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   pre[_ngcontent-%COMP%] {\n  height: 100%;\n  display: block;\n  font-size: 1.4vw;\n  white-space: pre-wrap;\n}\nloader[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=logs.component.css.map */"] });
var LogsComponent = _LogsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LogsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "logs", template: '<section id="logs">\n  <header>\n    <div class="input-wrap">\n      <input type="text" placeholder="Search logs..." [(ngModel)]="searchInput" (input)="searchLogs()" />\n    </div>\n  </header>\n  <div class="content">\n    @if (logs != null) {\n      <pre [innerHtml]="displayLogs"></pre>\n    }\n  </div>\n</section>\n\n<loader [class.active]="showLoader"></loader>', styles: ["/* src/app/administration/system/components/logs/logs.component.scss */\n#logs {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n  display: flex;\n  flex-direction: column;\n}\n#logs > header {\n  padding: 1vw 2vw;\n  background-color: var(--color2);\n  position: sticky;\n  top: 0;\n}\n#logs > header > .input-wrap > input {\n  font-size: 1.6vw;\n  font-weight: var(--strong);\n  color: var(--color3);\n  display: block;\n  width: 100%;\n}\n#logs > .content {\n  flex: 1;\n  height: 100%;\n  padding: 0 2vw;\n  margin-top: 2vw;\n}\n#logs > .content pre {\n  height: 100%;\n  display: block;\n  font-size: 1.4vw;\n  white-space: pre-wrap;\n}\nloader {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=logs.component.css.map */\n"] }]
  }], () => [{ type: SystemAdminService }], { route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(LogsComponent, { className: "LogsComponent" });
})();

// src/app/administration/system/components/query/query.component.ts
var _c02 = ["componentElm"];
function QueryComponent_For_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "th");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const header_r1 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", header_r1, " ");
  }
}
function QueryComponent_For_11_For_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "td");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const header_r2 = ctx.$implicit;
    const entity_r3 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", entity_r3[header_r2], " ");
  }
}
function QueryComponent_For_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr");
    \u0275\u0275repeaterCreate(1, QueryComponent_For_11_For_2_Template, 2, 1, "td", null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx_r3.headers);
  }
}
var _QueryComponent = class _QueryComponent {
  constructor(systemAdminService) {
    this.systemAdminService = systemAdminService;
    this.headers = [];
    this.data = [];
    this.queryingData = false;
    this.displayLogs = "";
    this.retrievingLogs = false;
  }
  setHeaderNames(data) {
    if (data.length > 0 && typeof data[0] === "object" && data[0] !== null) {
      this.headers = Object.keys(data[0]);
    } else {
      this.headers = [];
    }
  }
  initData(data) {
    this.setHeaderNames(data);
    this.data = data;
  }
  queryData() {
    window.clearTimeout(this.queryTimer);
    this.queryTimer = window.setTimeout(() => {
      if (!this.queryingData && this.query != null) {
        this.queryingData = true;
        this.systemAdminService.queryData(this.query).subscribe({
          next: (response) => {
            if (response.data != null) {
              this.initData(response.data);
            }
            this.queryingData = false;
          },
          error: () => {
            this.queryingData = false;
          }
        });
      }
    }, 500);
  }
  initDisplayLogs(logs) {
    if (this.logs != null) {
      const chunkSize = 100 * 1024 / 2;
      this.displayLogs = logs.substring(0, chunkSize);
    } else {
      this.displayLogs = "";
    }
  }
  getLogs() {
    this.retrievingLogs = true;
    this.systemAdminService.getLogs().subscribe({
      next: (logs) => {
        this.logs = logs;
        this.initDisplayLogs(logs.logs);
        this.retrievingLogs = false;
      },
      error: () => {
        this.retrievingLogs = false;
      }
    });
  }
  // #endregion
  // #region UI
  get showLoader() {
    return this.retrievingLogs;
  }
  init() {
    this.getLogs();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_QueryComponent.\u0275fac = function QueryComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _QueryComponent)(\u0275\u0275directiveInject(SystemAdminService));
};
_QueryComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _QueryComponent, selectors: [["query"]], viewQuery: function QueryComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { route: "route" }, standalone: false, decls: 13, vars: 3, consts: [["id", "query"], [1, "input-wrap"], ["type", "text", "placeholder", "Query database...", 3, "ngModelChange", "input", "ngModel"], [1, "content"]], template: function QueryComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "input", 2);
    \u0275\u0275twoWayListener("ngModelChange", function QueryComponent_Template_input_ngModelChange_3_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.query, $event) || (ctx.query = $event);
      return $event;
    });
    \u0275\u0275listener("input", function QueryComponent_Template_input_input_3_listener() {
      return ctx.queryData();
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(4, "div", 3)(5, "table")(6, "thead");
    \u0275\u0275repeaterCreate(7, QueryComponent_For_8_Template, 2, 1, "th", null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "tbody");
    \u0275\u0275repeaterCreate(10, QueryComponent_For_11_Template, 3, 0, "tr", null, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275element(12, "loader");
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275twoWayProperty("ngModel", ctx.query);
    \u0275\u0275advance(4);
    \u0275\u0275repeater(ctx.headers);
    \u0275\u0275advance(3);
    \u0275\u0275repeater(ctx.data);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("active", ctx.showLoader);
  }
}, dependencies: [LoaderComponent, DefaultValueAccessor, NgControlStatus, NgModel], styles: ["\n\n#query[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n  display: flex;\n  flex-direction: column;\n}\n#query[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 1vw 2vw;\n  background-color: var(--color2);\n  position: sticky;\n  top: 0;\n}\n#query[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  font-weight: var(--strong);\n  color: var(--color3);\n  display: block;\n  width: 100%;\n}\n#query[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n  height: 100%;\n  padding: 0 2vw;\n  margin-top: 2vw;\n  width: 100%;\n  overflow: scroll;\n}\n#query[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  white-space: nowrap;\n}\n#query[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n}\n#query[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   tbody[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]:nth-child(even) {\n  background-color: var(--color2Alt1);\n}\nloader[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=query.component.css.map */"] });
var QueryComponent = _QueryComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(QueryComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "query", template: '<section id="query">\n  <header>\n    <div class="input-wrap">\n      <input type="text" placeholder="Query database..." [(ngModel)]="query" (input)="queryData()" />\n    </div>\n  </header>\n  <div class="content">\n    <table>\n      <thead>\n        @for (header of headers; track header) {\n          <th>\n            {{header}}\n          </th>\n        }\n      </thead>\n      <tbody>\n        @for (entity of data; track entity) {\n          <tr>\n            @for (header of headers; track header) {\n              <td>\n                {{entity[header]}}\n              </td>\n            }\n          </tr>\n        }\n      </tbody>\n    </table>\n  </div>\n</section>\n\n<loader [class.active]="showLoader"></loader>', styles: ["/* src/app/administration/system/components/query/query.component.scss */\n#query {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n  display: flex;\n  flex-direction: column;\n}\n#query > header {\n  padding: 1vw 2vw;\n  background-color: var(--color2);\n  position: sticky;\n  top: 0;\n}\n#query > header > .input-wrap > input {\n  font-size: 1.6vw;\n  font-weight: var(--strong);\n  color: var(--color3);\n  display: block;\n  width: 100%;\n}\n#query > .content {\n  flex: 1;\n  height: 100%;\n  padding: 0 2vw;\n  margin-top: 2vw;\n  width: 100%;\n  overflow: scroll;\n}\n#query > .content table thead th {\n  padding: 0.5vw 1vw;\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  white-space: nowrap;\n}\n#query > .content table tbody tr td {\n  padding: 0.5vw 1vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n  white-space: nowrap;\n}\n#query > .content table tbody tr:nth-child(even) {\n  background-color: var(--color2Alt1);\n}\nloader {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=query.component.css.map */\n"] }]
  }], () => [{ type: SystemAdminService }], { route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(QueryComponent, { className: "QueryComponent" });
})();

// src/app/administration/system/components/layout/layout.component.ts
var _c03 = ["componentElm"];
function LayoutComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "logs", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.logsRoute == null ? null : ctx_r0.logsRoute.loadDirection));
    \u0275\u0275classProp("rendered", ctx_r0.logsRoute == null ? null : ctx_r0.logsRoute.rendered)("animate", ctx_r0.logsRoute == null ? null : ctx_r0.logsRoute.animating)("closing", ctx_r0.logsRoute == null ? null : ctx_r0.logsRoute.closing);
    \u0275\u0275property("route", ctx_r0.logsRoute);
  }
}
function LayoutComponent_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "query", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.queryRoute == null ? null : ctx_r0.queryRoute.loadDirection));
    \u0275\u0275classProp("rendered", ctx_r0.queryRoute == null ? null : ctx_r0.queryRoute.rendered)("animate", ctx_r0.queryRoute == null ? null : ctx_r0.queryRoute.animating)("closing", ctx_r0.queryRoute == null ? null : ctx_r0.queryRoute.closing);
    \u0275\u0275property("route", ctx_r0.queryRoute);
  }
}
var _LayoutComponent = class _LayoutComponent {
  constructor(routeService, adminService, uiService) {
    this.routeService = routeService;
    this.adminService = adminService;
    this.uiService = uiService;
    this.RouteType = RouteType;
    this.routesInitialized = false;
    this.params = new BehaviorSubject([]);
  }
  get routes() {
    return this.routeService.routes;
  }
  initRoutes(initialRouteType = void 0) {
    setTimeout(() => {
      if (this.componentElm != null) {
        const routes = {
          [RouteType.logs]: new InternalRoute(RouteType.logs),
          [RouteType.query]: new InternalRoute(RouteType.query)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : RouteType.logs;
        this.routeService.init(routes, initialRoute, 250, this.componentElm.nativeElement);
        this.routeSubscription = this.routeService.activeRoute.subscribe({
          next: (route) => {
            if (route != null) {
              switch (route.type) {
                case RouteType.logs:
                  {
                    this.setTitle("System Logs");
                  }
                  break;
                case RouteType.query:
                  {
                    this.setTitle("Database Query");
                  }
                  break;
              }
            }
          }
        });
        this.routesInitialized = true;
      }
    }, 0);
  }
  viewRoute(type) {
    if (type != null) {
      this.routeService.viewRoute(type, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Logs
  get logsRoute() {
    return this.routes[RouteType.logs];
  }
  // #endregion
  // #region Query
  get queryRoute() {
    return this.routes[RouteType.query];
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        let route = params[0]?.toLowerCase();
        if (route != null) {
          const routeMatches = Object.values(RouteType).includes(route);
          if (routeMatches) {
            if (!this.routesInitialized) {
              this.initRoutes(route);
            } else {
              this.viewRoute(route);
            }
          } else {
            if (!this.routesInitialized) {
              this.initRoutes();
            }
          }
        }
      }
    });
  }
  setTitle(routeTitle) {
    this.adminService.routeTitle.next(routeTitle);
  }
  init() {
    this.watchParams();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_LayoutComponent.\u0275fac = function LayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LayoutComponent)(\u0275\u0275directiveInject(InternalRouteService), \u0275\u0275directiveInject(AdministrationService), \u0275\u0275directiveInject(UiService));
};
_LayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _LayoutComponent, selectors: [["layout"]], viewQuery: function LayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 5, vars: 2, consts: [["componentElm", ""], ["id", "entitiesLayout"], [1, "routes"], [3, "class", "route", "rendered", "animate", "closing"], [3, "route"]], template: function LayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "div", 2);
    \u0275\u0275conditionalCreate(3, LayoutComponent_Conditional_3_Template, 1, 10, "logs", 3);
    \u0275\u0275conditionalCreate(4, LayoutComponent_Conditional_4_Template, 1, 10, "query", 3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275conditional((ctx.logsRoute == null ? null : ctx.logsRoute.active) ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.queryRoute == null ? null : ctx.queryRoute.active) ? 4 : -1);
  }
}, dependencies: [LogsComponent, QueryComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#entitiesLayout[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var LayoutComponent = _LayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LayoutComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "layout", template: '<section id="entitiesLayout" #componentElm>\n  <div class="routes">\n    @if (logsRoute?.active) {\n      <logs\n        class="route {{logsRoute?.loadDirection}}"\n        [route]="logsRoute"\n        [class.rendered]="logsRoute?.rendered"\n        [class.animate]="logsRoute?.animating"\n      [class.closing]="logsRoute?.closing"></logs>\n    }\n    @if (queryRoute?.active) {\n      <query\n        class="route {{queryRoute?.loadDirection}}"\n        [route]="queryRoute"\n        [class.rendered]="queryRoute?.rendered"\n        [class.animate]="queryRoute?.animating"\n      [class.closing]="queryRoute?.closing"></query>\n    }\n  </div>\n</section>', styles: ["/* src/app/administration/system/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#entitiesLayout {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n}\n#entitiesLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#entitiesLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#entitiesLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: InternalRouteService }, { type: AdministrationService }, { type: UiService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], params: [{
    type: Input,
    args: ["params"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(LayoutComponent, { className: "LayoutComponent" });
})();

// src/app/administration/system/system.module.ts
var _SystemModule = class _SystemModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(LayoutComponent, { injector: this.injector });
    customElements.define("administration-system", el);
  }
};
_SystemModule.\u0275fac = function SystemModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SystemModule)(\u0275\u0275inject(Injector));
};
_SystemModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _SystemModule });
_SystemModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  InternalRouteService,
  SystemAdminService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var SystemModule = _SystemModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SystemModule, [{
    type: NgModule,
    args: [{
      declarations: [
        LayoutComponent,
        LogsComponent,
        QueryComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        InternalRouteService,
        SystemAdminService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  SystemModule
};
//# sourceMappingURL=chunk-Q5DLVR4O.js.map
