import {
  LiveOpportunityService,
  OpportunityRouteType
} from "./chunk-PW3AXHYQ.js";
import {
  InternalRouteService
} from "./chunk-6RSEFXQV.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-NWZAVPC4.js";
import {
  createCustomElement
} from "./chunk-4VXBNATF.js";
import {
  UiService
} from "./chunk-DQROWZRM.js";
import {
  OpportunityService
} from "./chunk-ZHMU5CV6.js";
import {
  PromotionType
} from "./chunk-2UWBL76P.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import "./chunk-6FRIKJSO.js";
import {
  deepClone
} from "./chunk-ZLJFMUW4.js";
import "./chunk-MZF2PAUH.js";
import {
  BehaviorSubject,
  CommonModule,
  Component,
  CurrencyInputComponent,
  CurrencyPipe,
  DefaultValueAccessor,
  FormsModule,
  Injectable,
  Injector,
  Input,
  MaxLengthValidator,
  NgControlStatus,
  NgModel,
  NgModule,
  OrderByPipe,
  ReactiveFormsModule,
  Subject,
  UiModule,
  ViewChild,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind2,
  ɵɵpipeBind3,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵrepeaterTrackByIndex,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-S237TOF5.js";
import "./chunk-IT26RCSL.js";
import {
  __async
} from "./chunk-RVA4KI76.js";

// src/app/opportunity/price-negotiation/models/navigation.ts
var OpportunityPricingRouteType;
(function(OpportunityPricingRouteType2) {
  OpportunityPricingRouteType2["adjust"] = "adjust";
  OpportunityPricingRouteType2["adjustedexternal"] = "adjustedexternal";
})(OpportunityPricingRouteType || (OpportunityPricingRouteType = {}));

// src/app/opportunity/price-negotiation/services/pricing.service.ts
var _OpportunityPricingService = class _OpportunityPricingService {
  constructor(liveOpportunityService, routeService) {
    this.liveOpportunityService = liveOpportunityService;
    this.routeService = routeService;
    this.routesInitialized = false;
  }
  initRoutes(initialRouteType = void 0, componentElm) {
    const routes = {
      [OpportunityPricingRouteType.adjust]: new InternalRoute(OpportunityPricingRouteType.adjust),
      [OpportunityPricingRouteType.adjustedexternal]: new InternalRoute(OpportunityPricingRouteType.adjustedexternal)
    };
    let initialRoute = OpportunityPricingRouteType.adjustedexternal;
    this.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
            case OpportunityPricingRouteType.adjustedexternal:
              {
                this.liveOpportunityService.showQuoteControl = true;
              }
              break;
            default:
              {
                this.liveOpportunityService.showQuoteControl = false;
              }
              break;
          }
        }
      }
    });
    this.routeService.init(routes, initialRoute, 500, componentElm);
    this.routesInitialized = true;
  }
};
_OpportunityPricingService.\u0275fac = function OpportunityPricingService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityPricingService)(\u0275\u0275inject(LiveOpportunityService), \u0275\u0275inject(InternalRouteService));
};
_OpportunityPricingService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _OpportunityPricingService, factory: _OpportunityPricingService.\u0275fac, providedIn: "root" });
var OpportunityPricingService = _OpportunityPricingService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityPricingService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: LiveOpportunityService }, { type: InternalRouteService }], null);
})();

// src/app/opportunity/price-negotiation/components/internal-adjust/internal-adjust.component.ts
var _c0 = ["pin1Elm"];
var _c1 = ["pin2Elm"];
var _c2 = ["pin3Elm"];
var _c3 = ["pin4Elm"];
var _c4 = ["componentElm"];
function InternalAdjustComponent_Conditional_0_For_8_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0);
  }
  if (rf & 2) {
    const promotion_r4 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275textInterpolate1(" ", promotion_r4.discount, "% Off ");
  }
}
function InternalAdjustComponent_Conditional_0_For_8_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0);
    \u0275\u0275pipe(1, "currency");
  }
  if (rf & 2) {
    const promotion_r4 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(1, 1, promotion_r4.discount, "USD"), " Off ");
  }
}
function InternalAdjustComponent_Conditional_0_For_8_Conditional_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275text(0, " Custom Amount Off ");
  }
}
function InternalAdjustComponent_Conditional_0_For_8_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 39)(1, "h6");
    \u0275\u0275text(2, "Automatically Applied");
    \u0275\u0275elementEnd()();
  }
}
function InternalAdjustComponent_Conditional_0_For_8_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 32);
    \u0275\u0275listener("click", function InternalAdjustComponent_Conditional_0_For_8_Template_div_click_0_listener() {
      const promotion_r4 = \u0275\u0275restoreView(_r3).$implicit;
      const ctx_r4 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r4.togglePromotion(promotion_r4));
    });
    \u0275\u0275elementStart(1, "button", 33);
    \u0275\u0275element(2, "i", 34);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 35)(4, "div", 36)(5, "h4");
    \u0275\u0275text(6);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "div", 37)(8, "div", 38)(9, "h6");
    \u0275\u0275conditionalCreate(10, InternalAdjustComponent_Conditional_0_For_8_Conditional_10_Template, 1, 1);
    \u0275\u0275conditionalCreate(11, InternalAdjustComponent_Conditional_0_For_8_Conditional_11_Template, 2, 4);
    \u0275\u0275conditionalCreate(12, InternalAdjustComponent_Conditional_0_For_8_Conditional_12_Template, 1, 0);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(13, InternalAdjustComponent_Conditional_0_For_8_Conditional_13_Template, 3, 0, "div", 39);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const promotion_r4 = ctx.$implicit;
    const ctx_r4 = \u0275\u0275nextContext(2);
    \u0275\u0275classProp("active", promotion_r4.active);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(promotion_r4.name);
    \u0275\u0275advance(4);
    \u0275\u0275conditional(promotion_r4.type == ctx_r4.PromotionType.Percent ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(promotion_r4.type == ctx_r4.PromotionType.Amount && !promotion_r4.manual ? 11 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(promotion_r4.type == ctx_r4.PromotionType.Amount && promotion_r4.manual ? 12 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(promotion_r4.autoApply ? 13 : -1);
  }
}
function InternalAdjustComponent_Conditional_0_Conditional_34_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 30)(1, "p");
    \u0275\u0275text(2, " Your customer price is below the ABL price. ");
    \u0275\u0275elementEnd()();
  }
}
function InternalAdjustComponent_Conditional_0_Conditional_35_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 30)(1, "p");
    \u0275\u0275text(2, " Your customer price is greater than the original price. ");
    \u0275\u0275elementEnd()();
  }
}
function InternalAdjustComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "section", 4)(1, "div", 18)(2, "div", 19)(3, "header")(4, "h2");
    \u0275\u0275text(5, "Available Promotions");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(6, "div", 12);
    \u0275\u0275repeaterCreate(7, InternalAdjustComponent_Conditional_0_For_8_Template, 14, 7, "div", 20, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 21)(10, "div", 22)(11, "div", 23)(12, "header")(13, "h3");
    \u0275\u0275text(14, "Target Price");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(15, "div", 24);
    \u0275\u0275element(16, "currency-input", 25);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(17, "div", 26)(18, "header")(19, "h3");
    \u0275\u0275text(20, "Your Original Price");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(21, "div", 24);
    \u0275\u0275element(22, "currency-input", 25);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(23, "div", 27)(24, "header")(25, "h3");
    \u0275\u0275text(26, "ABL");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(27, "div", 24);
    \u0275\u0275element(28, "currency-input", 25);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(29, "div", 28)(30, "header")(31, "h2");
    \u0275\u0275element(32, "i", 29);
    \u0275\u0275text(33, " New Price to the Customer");
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(34, InternalAdjustComponent_Conditional_0_Conditional_34_Template, 3, 0, "div", 30);
    \u0275\u0275conditionalCreate(35, InternalAdjustComponent_Conditional_0_Conditional_35_Template, 3, 0, "div", 30);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(36, "div", 12)(37, "div", 14)(38, "currency-input", 31);
    \u0275\u0275listener("currencyOutput", function InternalAdjustComponent_Conditional_0_Template_currency_input_currencyOutput_38_listener($event) {
      \u0275\u0275restoreView(_r2);
      const ctx_r4 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r4.updateFinalPrice($event));
    });
    \u0275\u0275elementEnd()()()()()();
  }
  if (rf & 2) {
    const ctx_r4 = \u0275\u0275nextContext();
    \u0275\u0275advance(7);
    \u0275\u0275repeater(ctx_r4.availablePromotions);
    \u0275\u0275advance(9);
    \u0275\u0275property("currencyInput", ctx_r4.originalPrice == null ? null : ctx_r4.originalPrice.targetPrice)("enabled", false);
    \u0275\u0275advance(6);
    \u0275\u0275property("currencyInput", ctx_r4.originalPrice == null ? null : ctx_r4.originalPrice.finalPrice)("enabled", false);
    \u0275\u0275advance(6);
    \u0275\u0275property("currencyInput", ctx_r4.originalPrice == null ? null : ctx_r4.originalPrice.ablPrice)("enabled", false);
    \u0275\u0275advance();
    \u0275\u0275classProp("warning", ctx_r4.warnOnPrice);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx_r4.warnAblPrice ? 34 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx_r4.warnFinalPrice ? 35 : -1);
    \u0275\u0275advance(3);
    \u0275\u0275property("enabled", ctx_r4.canModifyOpportunity)("currencyInput", ctx_r4.finalPrice)("update", ctx_r4.finalPrice$);
  }
}
var _InternalAdjustComponent = class _InternalAdjustComponent {
  constructor(liveOpportunityService, opportunityService, opportunityPricingService, uiService) {
    this.liveOpportunityService = liveOpportunityService;
    this.opportunityService = opportunityService;
    this.opportunityPricingService = opportunityPricingService;
    this.uiService = uiService;
    this.pin1 = "";
    this.pin2 = "";
    this.pin3 = "";
    this.pin4 = "";
    this.showProtection = true;
    this.availablePromotions = [];
    this.PromotionType = PromotionType;
    this.originalFinalPrice = 0;
    this.finalPrice = 0;
    this.finalPrice$ = new Subject();
    this.initialized = false;
  }
  // #endregion
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  // #endregion
  // #region Authentication
  get activeUser() {
    return this.liveOpportunityService.activeUser;
  }
  get validPin() {
    return this.pin1 == "1" && this.pin2 == "1" && this.pin3 == "1" && this.pin4 == "1";
  }
  get canValidateProtection() {
    return this.pin1.length == 1 && this.pin2.length == 1 && this.pin3.length == 1 && this.pin4.length == 1;
  }
  updatePin(input, e) {
    switch (input) {
      case 1:
        {
          if (e.key === "Backspace") {
          } else {
            const pin2Elm = this.pin2Elm?.nativeElement;
            this.pin2 = "";
            pin2Elm?.focus();
          }
        }
        break;
      case 2:
        {
          if (e.key === "Backspace") {
            const pin1Elm = this.pin1Elm?.nativeElement;
            pin1Elm?.focus();
          } else {
            const pin3Elm = this.pin3Elm?.nativeElement;
            this.pin3 = "";
            pin3Elm?.focus();
          }
        }
        break;
      case 3:
        {
          if (e.key === "Backspace") {
            const pin2Elm = this.pin2Elm?.nativeElement;
            pin2Elm?.focus();
          } else {
            const pin4Elm = this.pin4Elm?.nativeElement;
            this.pin4 = "";
            pin4Elm?.focus();
          }
        }
        break;
      case 4:
        {
          if (e.key === "Backspace") {
            const pin3Elm = this.pin3Elm?.nativeElement;
            pin3Elm?.focus();
          }
        }
        break;
    }
  }
  validateProtection() {
    if (this.validPin) {
      this.showProtection = false;
    }
  }
  togglePromotion(promotion) {
    if (this.canModifyOpportunity) {
      if (promotion.locked) {
        this.uiService.prompt("Promotion Locked", "Promotions can't be removed once they've been presented to the customer.", "Okay").subscribe({
          next: () => {
          }
        });
      } else if (this.canModifyOpportunity && this.customPrice != null && !promotion.autoApply) {
        const existingPromotion = this.customPrice.appliedPromotions.find((x) => x.id == promotion.id);
        if (existingPromotion == null) {
          this.opportunityService.applyPromotion(this.customPrice, promotion);
        } else {
          this.opportunityService.removePromotion(this.customPrice, promotion);
        }
        this.initPrices();
      }
    }
  }
  initPromotions() {
    if (this.opportunity != null && this.customPrice != null) {
      const availablePromotions = [];
      this.opportunity?.availablePromotions.forEach((promotion) => {
        if (!promotion.autoApply) {
          const existingPromotion = this.customPrice?.appliedPromotions.find((x) => x.id == promotion.id);
          if (existingPromotion != null) {
            promotion.active = true;
            promotion.appliedDiscount = existingPromotion.appliedDiscount;
          }
          availablePromotions.push(promotion);
        }
      });
      this.availablePromotions = availablePromotions;
    }
  }
  lockPromotions() {
    if (this.customPrice != null) {
      this.customPrice.appliedPromotions.forEach((promotion) => {
        promotion.locked = true;
      });
    }
  }
  // #endregion
  // #region Auto Prices
  get originalPrice() {
    return this.opportunity?.price;
  }
  get customPrice() {
    return this.opportunity?.customPrice;
  }
  get ablPrice() {
    return this.customPrice?.ablPrice ?? 0;
  }
  initPrices() {
    if (this.customPrice != null) {
      this.finalPrice = this.customPrice.finalPrice;
      this.originalFinalPrice = this.customPrice.finalPrice;
      this.finalPrice$.next(this.finalPrice);
    }
  }
  get warnOnPrice() {
    return this.warnAblPrice || this.warnFinalPrice;
  }
  get warnAblPrice() {
    return this.finalPrice < this.ablPrice;
  }
  get warnFinalPrice() {
    return this.finalPrice > this.originalFinalPrice;
  }
  updateFinalPrice(result) {
    if (result.amount != null && this.customPrice != null) {
      const price = this.customPrice;
      window.clearTimeout(this.finalPriceDebounce);
      const resultAmount = result.amount;
      this.finalPrice = resultAmount;
      this.customPrice.finalPrice = this.finalPrice;
      if (resultAmount <= this.originalFinalPrice) {
        this.finalPriceDebounce = window.setTimeout(() => {
          price.finalPrice = resultAmount;
        }, 250);
      }
    }
  }
  updatePrice() {
    return __async(this, null, function* () {
      if (this.opportunity != null && this.activeUser != null) {
        const price = deepClone(this.opportunity.customPrice);
        if (price != null) {
          yield this.opportunityService.updateCustomPrice(this.opportunity, price, this.activeUser);
        }
      }
    });
  }
  // #endregion
  // #region Navigation
  get canDisplayCustomerPrice() {
    return this?.customPrice?.finalPrice != null && this.originalPrice?.finalPrice != null && !this.warnFinalPrice;
  }
  goToExternalPricing() {
    return __async(this, null, function* () {
      if (this.canModifyOpportunity) {
        yield this.updatePrice();
        this.lockPromotions();
        this.opportunityPricingService.routeService.viewRoute(OpportunityPricingRouteType.adjustedexternal, RouteLoadDirection.Forward, true);
      } else {
        this.opportunityPricingService.routeService.viewRoute(OpportunityPricingRouteType.adjustedexternal, RouteLoadDirection.Forward, true);
      }
    });
  }
  killEvent(e) {
    e.stopPropagation();
  }
  init() {
    this.initPrices();
    this.initPromotions();
    setTimeout(() => {
      this.initialized = true;
    }, 0);
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_InternalAdjustComponent.\u0275fac = function InternalAdjustComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _InternalAdjustComponent)(\u0275\u0275directiveInject(LiveOpportunityService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(OpportunityPricingService), \u0275\u0275directiveInject(UiService));
};
_InternalAdjustComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _InternalAdjustComponent, selectors: [["internal-adjust"]], viewQuery: function InternalAdjustComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
    \u0275\u0275viewQuery(_c1, 5);
    \u0275\u0275viewQuery(_c2, 5);
    \u0275\u0275viewQuery(_c3, 5);
    \u0275\u0275viewQuery(_c4, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.pin1Elm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.pin2Elm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.pin3Elm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.pin4Elm = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity", route: "route" }, standalone: false, decls: 32, vars: 9, consts: [["pin1Elm", ""], ["pin2Elm", ""], ["pin3Elm", ""], ["pin4Elm", ""], ["id", "internalAdjust"], ["id", "mainNav"], [1, "island"], [1, "controls"], [1, "control", "success", 3, "click", "disabled"], [1, "fa-solid", "fa-arrow-right-long"], ["id", "protectedOverlay"], [1, "bg"], [1, "content"], [1, "pin"], [1, "input"], ["type", "tel", "maxlength", "1", 3, "ngModelChange", "keyup", "ngModel"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-lock-keyhole"], [1, "primary"], [1, "promotions", "tile"], [1, "promotion", 3, "active"], [1, "secondary"], [1, "auto-prices"], [1, "auto-price", "retail"], [1, "value"], [3, "currencyInput", "enabled"], [1, "auto-price", "promotional"], [1, "auto-price", "abl"], [1, "price", "tile"], [1, "fa-solid", "fa-pencil"], [1, "message"], [3, "currencyOutput", "enabled", "currencyInput", "update"], [1, "promotion", 3, "click"], [1, "control"], [1, "fa-solid", "fa-check"], [1, "meta"], [1, "name"], [1, "details"], [1, "discount"], [1, "auto"]], template: function InternalAdjustComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275conditionalCreate(0, InternalAdjustComponent_Conditional_0_Template, 39, 13, "section", 4);
    \u0275\u0275elementStart(1, "nav", 5)(2, "div", 6)(3, "div", 7)(4, "button", 8);
    \u0275\u0275listener("click", function InternalAdjustComponent_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goToExternalPricing());
    });
    \u0275\u0275element(5, "i", 9);
    \u0275\u0275elementStart(6, "label");
    \u0275\u0275text(7, "Display Price to Customer");
    \u0275\u0275elementEnd()()()()();
    \u0275\u0275elementStart(8, "div", 10);
    \u0275\u0275element(9, "div", 11);
    \u0275\u0275elementStart(10, "div", 12)(11, "header")(12, "h2");
    \u0275\u0275text(13, "Please enter your PIN to continue.");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(14, "div", 13)(15, "div", 14)(16, "input", 15, 0);
    \u0275\u0275twoWayListener("ngModelChange", function InternalAdjustComponent_Template_input_ngModelChange_16_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.pin1, $event) || (ctx.pin1 = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("keyup", function InternalAdjustComponent_Template_input_keyup_16_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.updatePin(1, $event));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(18, "div", 14)(19, "input", 15, 1);
    \u0275\u0275twoWayListener("ngModelChange", function InternalAdjustComponent_Template_input_ngModelChange_19_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.pin2, $event) || (ctx.pin2 = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("keyup", function InternalAdjustComponent_Template_input_keyup_19_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.updatePin(2, $event));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(21, "div", 14)(22, "input", 15, 2);
    \u0275\u0275twoWayListener("ngModelChange", function InternalAdjustComponent_Template_input_ngModelChange_22_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.pin3, $event) || (ctx.pin3 = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("keyup", function InternalAdjustComponent_Template_input_keyup_22_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.updatePin(3, $event));
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "div", 14)(25, "input", 15, 3);
    \u0275\u0275twoWayListener("ngModelChange", function InternalAdjustComponent_Template_input_ngModelChange_25_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.pin4, $event) || (ctx.pin4 = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("keyup", function InternalAdjustComponent_Template_input_keyup_25_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.updatePin(4, $event));
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(27, "div", 7)(28, "button", 16);
    \u0275\u0275listener("click", function InternalAdjustComponent_Template_button_click_28_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.validateProtection());
    });
    \u0275\u0275element(29, "i", 17);
    \u0275\u0275elementStart(30, "label");
    \u0275\u0275text(31, "Verify Access");
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.initialized ? 0 : -1);
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", !ctx.canDisplayCustomerPrice);
    \u0275\u0275advance(4);
    \u0275\u0275classProp("active", ctx.showProtection);
    \u0275\u0275advance(8);
    \u0275\u0275twoWayProperty("ngModel", ctx.pin1);
    \u0275\u0275advance(3);
    \u0275\u0275twoWayProperty("ngModel", ctx.pin2);
    \u0275\u0275advance(3);
    \u0275\u0275twoWayProperty("ngModel", ctx.pin3);
    \u0275\u0275advance(3);
    \u0275\u0275twoWayProperty("ngModel", ctx.pin4);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canValidateProtection);
  }
}, dependencies: [CurrencyInputComponent, DefaultValueAccessor, NgControlStatus, MaxLengthValidator, NgModel, CurrencyPipe], styles: ["\n\n.tooltip[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */", "\n\n#internalAdjust[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n  display: flex;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%] {\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  overflow-x: hidden;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0.75vw 1vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  margin-left: 0.5vw;\n}\n#internalAdjust[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%] {\n  width: 35%;\n  display: flex;\n  flex-direction: column;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0.5vw 1vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]   .tile[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 1.3vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 1vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.2vw var(--color2Alt2) solid;\n  position: relative;\n  overflow: hidden;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 3vw;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  background-color: var(--color2Alt2);\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2Alt4);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 1vw 2vw 1vw 4vw;\n  flex: 1;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .discount[_ngcontent-%COMP%]   h6[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  line-height: 1;\n  color: var(--greenAlt3);\n  font-weight: var(--stronger);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .auto[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  padding: 0.5vw 1vw;\n  border-radius: 999px;\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .details[_ngcontent-%COMP%]    > .auto[_ngcontent-%COMP%]   h6[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  color: rgb(153, 117, 0);\n  font-weight: var(--strong);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .name[_ngcontent-%COMP%]   h4[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  width: 25%;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  text-transform: uppercase;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input {\n  font-size: 1.8vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion.active[_ngcontent-%COMP%] {\n  border-color: var(--green);\n  background-color: rgba(var(--green-raw), 0.1);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--green);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .promotion.active[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%] {\n  margin-left: 2vw;\n  width: calc(65% - 2vw);\n  display: flex;\n  flex-direction: column;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  width: calc(50% - 1vw);\n  display: flex;\n  flex-direction: column;\n  border: 0.4vw transparent solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  padding: 0 1vw 0.25vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  font-weight: var(--strong);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  padding: 0.5vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  font-size: 2vw;\n  font-weight: var(--strong);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%] {\n  border-color: var(--color3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3Alt4-raw), 0.05);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.retail[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--color3Alt4);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%] {\n  border-color: var(--success);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--successAlt4-raw), 0.05);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.promotional[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--successAlt4);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%] {\n  border-color: var(--color4Alt3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color4Alt3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color4Alt4-raw), 0.05);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.par[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--color4Alt4);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%] {\n  border-color: var(--errorAlt3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--errorAlt3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  color: var(--color2);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  background-color: rgba(var(--errorAlt4-raw), 0.05);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price.abl[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%]     input {\n  color: var(--errorAlt4);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .auto-prices[_ngcontent-%COMP%]    > .auto-price[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 0 1vw;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input {\n  font-size: 9vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .price.warning[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  color: var(--errorAlt3);\n}\n#internalAdjust[_ngcontent-%COMP%]    > .secondary[_ngcontent-%COMP%]    > .price.warning[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input {\n  color: var(--error);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#protectedOverlay[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2);\n  z-index: calc(var(--navLayer) + 100);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 50vw;\n  z-index: calc(var(--navLayer) + 101);\n  opacity: 0;\n  -moz-transform: translate(-50%, -50%) scale(0.8);\n  -ms-transform: translate(-50%, -50%) scale(0.8);\n  -o-transform: translate(-50%, -50%) scale(0.8);\n  -webkit-transform: translate(-50%, -50%) scale(0.8);\n  transform: translate(-50%, -50%) scale(0.8);\n  -moz-transition: transform 0.2s, opacity 0.2s;\n  -o-transition: transform 0.2s, opacity 0.2s;\n  -webkit-transition: transform 0.2s, opacity 0.2s;\n  transition: transform 0.2s, opacity 0.2s;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  font-size: 3vw;\n  color: var(--color1);\n  text-align: center;\n  font-weight: var(--strong);\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .pin[_ngcontent-%COMP%] {\n  margin-top: 3vw;\n  display: flex;\n  justify-content: center;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .pin[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  border: 0.2vw var(--color2Alt4) solid;\n  width: 9vw;\n  border-radius: 1vw;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  margin-left: 1vw;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .pin[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 9vw;\n  text-align: center;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .pin[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]:focus-within {\n  border-color: var(--color3);\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .pin[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 3vw;\n  display: flex;\n  justify-content: center;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 1vw;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 3vw;\n  color: var(--color2);\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 2.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#protectedOverlay[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#protectedOverlay.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#protectedOverlay.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#protectedOverlay.active[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: translate(-50%, -50%) scale(1);\n  -ms-transform: translate(-50%, -50%) scale(1);\n  -o-transform: translate(-50%, -50%) scale(1);\n  -webkit-transform: translate(-50%, -50%) scale(1);\n  transform: translate(-50%, -50%) scale(1);\n}\n/*# sourceMappingURL=internal-adjust.component.css.map */"] });
var InternalAdjustComponent = _InternalAdjustComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(InternalAdjustComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "internal-adjust", template: `@if (initialized) {
  <section id="internalAdjust">
    <div class="primary">
      <div class="promotions tile">
        <header>
          <h2>Available Promotions</h2>
        </header>
        <div class="content">
          @for (promotion of availablePromotions; track promotion) {
            <div class="promotion"
              [class.active]="promotion.active"
              (click)="togglePromotion(promotion)"
              >
              <button class="control">
                <i class="fa-solid fa-check"></i>
              </button>
              <div class="meta">
                <div class="name">
                  <h4>{{promotion.name}}</h4>
                </div>
                <div class="details">
                  <div class="discount">
                    <h6>
                      @if (promotion.type == PromotionType.Percent) {
                        {{promotion.discount}}% Off
                      }
                      @if (promotion.type == PromotionType.Amount && !promotion.manual) {
                        {{promotion.discount | currency:'USD'}} Off
                      }
                      @if (promotion.type == PromotionType.Amount && promotion.manual) {
                        Custom Amount Off
                      }
                    </h6>
                  </div>
                  @if (promotion.autoApply) {
                    <div class="auto">
                      <h6>Automatically Applied</h6>
                    </div>
                  }
                </div>
              </div>
            </div>
          }
        </div>
      </div>
    </div>
    <div class="secondary">
      <div class="auto-prices">
        <div class="auto-price retail">
          <header>
            <h3>Target Price</h3>
          </header>
          <div class="value">
            <currency-input
              [currencyInput]="originalPrice?.targetPrice"
            [enabled]="false"></currency-input>
          </div>
        </div>
        <div class="auto-price promotional">
          <header>
            <h3>Your Original Price</h3>
          </header>
          <div class="value">
            <currency-input
              [currencyInput]="originalPrice?.finalPrice"
            [enabled]="false"></currency-input>
          </div>
        </div>
        <div class="auto-price abl">
          <header>
            <h3>ABL</h3>
          </header>
          <div class="value">
            <currency-input
              [currencyInput]="originalPrice?.ablPrice"
            [enabled]="false"></currency-input>
          </div>
        </div>
      </div>
      <div class="price tile" [class.warning]="warnOnPrice">
        <header>
          <h2><i class="fa-solid fa-pencil"></i> New Price to the Customer</h2>
          @if (warnAblPrice) {
            <div class="message">
              <p>
                Your customer price is below the ABL price.
              </p>
            </div>
          }
          @if (warnFinalPrice) {
            <div class="message">
              <p>
                Your customer price is greater than the original price.
              </p>
            </div>
          }
        </header>
        <div class="content">
          <div class="input">
            <currency-input
              [enabled]="canModifyOpportunity"
              [currencyInput]="finalPrice"
              [update]="finalPrice$"
            (currencyOutput)="updateFinalPrice($event)"></currency-input>
          </div>
        </div>
      </div>
    </div>
  </section>
}

<nav id="mainNav">
  <div class="island">
    <div class="controls">
      <button class="control success" (click)="goToExternalPricing()" [disabled]="!canDisplayCustomerPrice">
        <i class="fa-solid fa-arrow-right-long"></i>
        <label>Display Price to Customer</label>
      </button>
    </div>
  </div>
</nav>

<div id="protectedOverlay" [class.active]="showProtection">
  <div class="bg"></div>
  <div class="content">
    <header>
      <h2>Please enter your PIN to continue.</h2>
    </header>
    <div class="pin">
      <div class="input">
        <input [(ngModel)]="pin1" #pin1Elm (keyup)="updatePin(1,$event)" type="tel" maxlength="1" />
      </div>
      <div class="input">
        <input [(ngModel)]="pin2" #pin2Elm (keyup)="updatePin(2,$event)" type="tel" maxlength="1" />
      </div>
      <div class="input">
        <input [(ngModel)]="pin3" #pin3Elm (keyup)="updatePin(3,$event)" type="tel" maxlength="1" />
      </div>
      <div class="input">
        <input [(ngModel)]="pin4" #pin4Elm (keyup)="updatePin(4,$event)" type="tel" maxlength="1" />
      </div>
    </div>
    <div class="controls">
      <button class="control" [disabled]="!canValidateProtection" (click)="validateProtection()">
        <i class="fa-solid fa-lock-keyhole"></i>
        <label>Verify Access</label>
      </button>
    </div>
  </div>
</div>`, styles: ["/* src/app/shared/ui/components/tooltips/tooltips.component.scss */\n.tooltip {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip > .control {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip > h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip > p {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip > .controls {\n  margin-top: 0.5vw;\n}\n.tooltip > .controls > .control {\n  cursor: pointer;\n  display: block;\n}\n.tooltip > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */\n", "/* src/app/opportunity/price-negotiation/components/internal-adjust/internal-adjust.component.scss */\n#internalAdjust {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 6vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: 6vw;\n  display: flex;\n}\n#internalAdjust .tile {\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  overflow-x: hidden;\n}\n#internalAdjust .tile > header {\n  padding: 0.75vw 1vw;\n  background-color: var(--color2Alt3);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n}\n#internalAdjust .tile > header h2 {\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#internalAdjust .tile > header > .controls {\n  display: flex;\n  align-items: center;\n}\n#internalAdjust .tile > header > .controls > .control {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n}\n#internalAdjust .tile > header > .controls > .control i {\n  font-size: 1.2vw;\n  color: var(--color1);\n}\n#internalAdjust .tile > header > .controls > .control label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  margin-left: 0.5vw;\n}\n#internalAdjust .tile > header > .message p {\n  font-size: 1.2vw;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n#internalAdjust > .primary {\n  width: 35%;\n  display: flex;\n  flex-direction: column;\n}\n#internalAdjust > .primary .tile > header {\n  padding: 0.5vw 1vw;\n}\n#internalAdjust > .primary .tile > header h2 {\n  font-size: 1.3vw;\n}\n#internalAdjust > .primary > .promotions {\n  flex: 1;\n}\n#internalAdjust > .primary > .promotions > .content {\n  padding: 1vw;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion {\n  margin-top: 1vw;\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.2vw var(--color2Alt2) solid;\n  position: relative;\n  overflow: hidden;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: auto;\n  bottom: 0;\n  width: 3vw;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  background-color: var(--color2Alt2);\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .control > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  font-size: 2vw;\n  color: var(--color2Alt4);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .meta {\n  position: relative;\n  padding: 1vw 2vw 1vw 4vw;\n  flex: 1;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .meta > .details {\n  display: flex;\n  align-items: center;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .meta > .details > .discount h6 {\n  font-size: 1.6vw;\n  line-height: 1;\n  color: var(--greenAlt3);\n  font-weight: var(--stronger);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .meta > .details > .auto {\n  margin-left: 1vw;\n  padding: 0.5vw 1vw;\n  border-radius: 999px;\n  background-color: rgba(var(--yellow-raw), 0.2);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .meta > .details > .auto h6 {\n  font-size: 1vw;\n  color: rgb(153, 117, 0);\n  font-weight: var(--strong);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .meta > .name h4 {\n  font-size: 2vw;\n  line-height: 1;\n  color: var(--color1);\n  font-weight: var(--stronger);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .price {\n  margin-left: 1vw;\n  width: 25%;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .price > label {\n  font-size: 1.2vw;\n  text-transform: uppercase;\n  font-weight: var(--strong);\n  color: var(--color1);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion > .price > .input ::ng-deep input {\n  font-size: 1.8vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion:first-child {\n  margin-top: 0;\n}\n#internalAdjust > .primary > .promotions > .content > .promotion.active {\n  border-color: var(--green);\n  background-color: rgba(var(--green-raw), 0.1);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion.active > .control {\n  background-color: var(--green);\n}\n#internalAdjust > .primary > .promotions > .content > .promotion.active > .control > i {\n  color: var(--color2);\n}\n#internalAdjust > .secondary {\n  margin-left: 2vw;\n  width: calc(65% - 2vw);\n  display: flex;\n  flex-direction: column;\n}\n#internalAdjust > .secondary > .auto-prices {\n  display: flex;\n  align-items: flex-start;\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price {\n  margin-left: 1vw;\n  width: calc(50% - 1vw);\n  display: flex;\n  flex-direction: column;\n  border: 0.4vw transparent solid;\n  border-radius: 1vw;\n  overflow: hidden;\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price > header {\n  padding: 0 1vw 0.25vw;\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price > header h3 {\n  font-size: 1.6vw;\n  font-weight: var(--strong);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price > .value {\n  padding: 0.5vw;\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price > .value ::ng-deep input {\n  font-size: 2vw;\n  font-weight: var(--strong);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price:first-child {\n  margin-top: 0;\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.retail {\n  border-color: var(--color3);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.retail > header {\n  background-color: var(--color3);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.retail > header h3 {\n  color: var(--color2);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.retail > .value {\n  background-color: rgba(var(--color3Alt4-raw), 0.05);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.retail > .value ::ng-deep input {\n  color: var(--color3Alt4);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.promotional {\n  border-color: var(--success);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.promotional > header {\n  background-color: var(--success);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.promotional > header h3 {\n  color: var(--color2);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.promotional > .value {\n  background-color: rgba(var(--successAlt4-raw), 0.05);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.promotional > .value ::ng-deep input {\n  color: var(--successAlt4);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.par {\n  border-color: var(--color4Alt3);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.par > header {\n  background-color: var(--color4Alt3);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.par > header h3 {\n  color: var(--color2);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.par > .value {\n  background-color: rgba(var(--color4Alt4-raw), 0.05);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.par > .value ::ng-deep input {\n  color: var(--color4Alt4);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.abl {\n  border-color: var(--errorAlt3);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.abl > header {\n  background-color: var(--errorAlt3);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.abl > header h3 {\n  color: var(--color2);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.abl > .value {\n  background-color: rgba(var(--errorAlt4-raw), 0.05);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price.abl > .value ::ng-deep input {\n  color: var(--errorAlt4);\n}\n#internalAdjust > .secondary > .auto-prices > .auto-price:first-child {\n  margin-left: 0;\n}\n#internalAdjust > .secondary > .price {\n  margin-top: 2vw;\n}\n#internalAdjust > .secondary > .price > .content {\n  padding: 0 1vw;\n}\n#internalAdjust > .secondary > .price > .content > .input ::ng-deep input {\n  font-size: 9vw;\n  color: var(--color3);\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#internalAdjust > .secondary > .price.warning > header > .message p {\n  color: var(--errorAlt3);\n}\n#internalAdjust > .secondary > .price.warning > .content > .input ::ng-deep input {\n  color: var(--error);\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n#protectedOverlay {\n  pointer-events: none;\n}\n#protectedOverlay > .bg {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2);\n  z-index: calc(var(--navLayer) + 100);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#protectedOverlay > .content {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  width: 50vw;\n  z-index: calc(var(--navLayer) + 101);\n  opacity: 0;\n  -moz-transform: translate(-50%, -50%) scale(0.8);\n  -ms-transform: translate(-50%, -50%) scale(0.8);\n  -o-transform: translate(-50%, -50%) scale(0.8);\n  -webkit-transform: translate(-50%, -50%) scale(0.8);\n  transform: translate(-50%, -50%) scale(0.8);\n  -moz-transition: transform 0.2s, opacity 0.2s;\n  -o-transition: transform 0.2s, opacity 0.2s;\n  -webkit-transition: transform 0.2s, opacity 0.2s;\n  transition: transform 0.2s, opacity 0.2s;\n}\n#protectedOverlay > .content > header h2 {\n  font-size: 3vw;\n  color: var(--color1);\n  text-align: center;\n  font-weight: var(--strong);\n}\n#protectedOverlay > .content > .pin {\n  margin-top: 3vw;\n  display: flex;\n  justify-content: center;\n}\n#protectedOverlay > .content > .pin > .input {\n  border: 0.2vw var(--color2Alt4) solid;\n  width: 9vw;\n  border-radius: 1vw;\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  margin-left: 1vw;\n}\n#protectedOverlay > .content > .pin > .input input {\n  display: block;\n  width: 100%;\n  font-size: 9vw;\n  text-align: center;\n}\n#protectedOverlay > .content > .pin > .input:focus-within {\n  border-color: var(--color3);\n}\n#protectedOverlay > .content > .pin > .input:first-child {\n  margin-left: 0;\n}\n#protectedOverlay > .content > .controls {\n  margin-top: 3vw;\n  display: flex;\n  justify-content: center;\n}\n#protectedOverlay > .content > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#protectedOverlay > .content > .controls > .control > i:last-child,\n#protectedOverlay > .content > .controls > .control > label:last-child {\n  margin-left: 1vw;\n}\n#protectedOverlay > .content > .controls > .control > i {\n  font-size: 3vw;\n  color: var(--color2);\n}\n#protectedOverlay > .content > .controls > .control > label {\n  font-size: 2.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#protectedOverlay > .content > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#protectedOverlay > .content > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#protectedOverlay > .content > .controls > .control:first-child {\n  margin-left: 0;\n}\n#protectedOverlay.active {\n  pointer-events: initial;\n}\n#protectedOverlay.active > .bg {\n  opacity: 1;\n}\n#protectedOverlay.active > .content {\n  opacity: 1;\n  -moz-transform: translate(-50%, -50%) scale(1);\n  -ms-transform: translate(-50%, -50%) scale(1);\n  -o-transform: translate(-50%, -50%) scale(1);\n  -webkit-transform: translate(-50%, -50%) scale(1);\n  transform: translate(-50%, -50%) scale(1);\n}\n/*# sourceMappingURL=internal-adjust.component.css.map */\n"] }]
  }], () => [{ type: LiveOpportunityService }, { type: OpportunityService }, { type: OpportunityPricingService }, { type: UiService }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], pin1Elm: [{
    type: ViewChild,
    args: ["pin1Elm"]
  }], pin2Elm: [{
    type: ViewChild,
    args: ["pin2Elm"]
  }], pin3Elm: [{
    type: ViewChild,
    args: ["pin3Elm"]
  }], pin4Elm: [{
    type: ViewChild,
    args: ["pin4Elm"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(InternalAdjustComponent, { className: "InternalAdjustComponent", filePath: "src/app/opportunity/price-negotiation/components/internal-adjust/internal-adjust.component.ts", lineNumber: 33 });
})();

// src/app/opportunity/price-negotiation/components/external-adjust/external-adjust.component.ts
var _c02 = ["componentElm"];
function ExternalAdjustComponent_Conditional_8_For_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 14)(1, "div", 15);
    \u0275\u0275element(2, "i", 16);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 17)(4, "label");
    \u0275\u0275text(5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "span", 2);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "currency");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const promotion_r1 = ctx.$implicit;
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", promotion_r1.name, " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" -", \u0275\u0275pipeBind2(8, 2, promotion_r1.appliedDiscount, "USD"), " ");
  }
}
function ExternalAdjustComponent_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 3)(1, "h2");
    \u0275\u0275text(2, "Applied Promotions");
    \u0275\u0275elementEnd();
    \u0275\u0275repeaterCreate(3, ExternalAdjustComponent_Conditional_8_For_4_Template, 9, 5, "div", 14, \u0275\u0275repeaterTrackByIndex);
    \u0275\u0275pipe(5, "orderBy");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275classMap(ctx_r1.retailPriceClass);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(\u0275\u0275pipeBind3(5, 2, ctx_r1.promotions, "priority", false));
  }
}
var _ExternalAdjustComponent = class _ExternalAdjustComponent {
  constructor(liveOpportunityService, opportunityPricingService, opportunityService, uiService) {
    this.liveOpportunityService = liveOpportunityService;
    this.opportunityPricingService = opportunityPricingService;
    this.opportunityService = opportunityService;
    this.uiService = uiService;
    this.showingDetails = false;
    this.canGoForward = true;
  }
  // #endregion
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  showDetails() {
    this.showingDetails = true;
  }
  // #endregion
  // #region Custom Price
  get customPrice() {
    return this.opportunity?.customPrice;
  }
  // #endregion
  // #region Final Price
  get finalPrice() {
    return this.customPrice?.finalPrice ?? 0;
  }
  get retailPrice() {
    return this.customPrice?.targetPrice ?? 0;
  }
  get retailPriceClass() {
    if (this.retailPrice > 99999) {
      return "sixfigures";
    } else if (this.retailPrice > 9999) {
      return "fivefigures";
    } else {
      return "standard";
    }
  }
  get finalPriceClass() {
    if (this.finalPrice > 99999) {
      return "sixfigures";
    } else if (this.finalPrice > 9999) {
      return "fivefigures";
    } else {
      return "standard";
    }
  }
  get dailyAmount() {
    return this.finalPrice * 0.0156 / 30;
  }
  // #endregion
  // #region Promotions
  get promotions() {
    return this.customPrice?.appliedPromotions ?? [];
  }
  get hasPromotions() {
    return this.promotions.length > 0;
  }
  initPromotions() {
    if (this.customPrice != null) {
      this.customPrice.appliedPromotions.forEach((promotion) => {
        promotion.locked = true;
      });
    }
  }
  goBack() {
    this.opportunityPricingService.routeService.viewRoute(OpportunityPricingRouteType.adjust, RouteLoadDirection.Reverse, true);
  }
  goForward() {
    if (this.canModifyOpportunity) {
      this.uiService.prompt("Ready to Pay & Sign?", "Are you ready to finalize the appointment?", "Yes", "Not Yet").subscribe({
        next: (confirmed) => {
          if (confirmed && this.opportunity != null) {
            this.liveOpportunityService.routeService.viewRoute(OpportunityRouteType.completion, RouteLoadDirection.Forward, true);
          }
        }
      });
    }
  }
  adjustPrice() {
    if (!this.showingDetails) {
      this.showDetails();
    } else {
      this.opportunityPricingService.routeService.viewRoute(OpportunityPricingRouteType.adjust, RouteLoadDirection.Reverse, true);
    }
  }
  init() {
    if (this.opportunity != null) {
      this.initPromotions();
      this.liveOpportunityService.showQuoteControl = true;
    }
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_ExternalAdjustComponent.\u0275fac = function ExternalAdjustComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ExternalAdjustComponent)(\u0275\u0275directiveInject(LiveOpportunityService), \u0275\u0275directiveInject(OpportunityPricingService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(UiService));
};
_ExternalAdjustComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ExternalAdjustComponent, selectors: [["external-adjust"]], viewQuery: function ExternalAdjustComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity", route: "route" }, standalone: false, decls: 39, vars: 21, consts: [["id", "externalAdjust"], [1, "retail"], [1, "value"], [1, "promotions"], [1, "divider"], [1, "price"], [1, "final"], [1, "financing"], [1, "detail"], [1, "controls"], [1, "control-wrap", "internal"], [1, "control", "success", "subtle", 3, "click"], [1, "control-wrap", "external"], [1, "control", 3, "click"], [1, "promotion"], [1, "icon"], [1, "fa-solid", "fa-hands-holding-dollar"], [1, "meta"]], template: function ExternalAdjustComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1)(2, "h2");
    \u0275\u0275text(3, "Retail Price");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "div")(5, "span", 2);
    \u0275\u0275text(6);
    \u0275\u0275pipe(7, "currency");
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(8, ExternalAdjustComponent_Conditional_8_Template, 6, 6, "div", 3);
    \u0275\u0275element(9, "div", 4);
    \u0275\u0275elementStart(10, "div", 5)(11, "div", 6)(12, "h2");
    \u0275\u0275text(13, "Your Price Today");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "p");
    \u0275\u0275text(15, " (includes materials, installation, patching, cleanup and warranty) ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(16, "div")(17, "span", 2);
    \u0275\u0275text(18);
    \u0275\u0275pipe(19, "currency");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(20, "div", 4)(21, "label");
    \u0275\u0275text(22, "Or financing as low as");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(23, "div", 7)(24, "div", 8)(25, "span", 2);
    \u0275\u0275text(26);
    \u0275\u0275pipe(27, "currency");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "label");
    \u0275\u0275text(29, "per day");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(30, "p");
    \u0275\u0275text(31, " (Based on approved financing) ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(32, "div", 9)(33, "div", 10)(34, "button", 11);
    \u0275\u0275listener("click", function ExternalAdjustComponent_Template_button_click_34_listener() {
      return ctx.adjustPrice();
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(35, "div", 12)(36, "button", 13);
    \u0275\u0275listener("click", function ExternalAdjustComponent_Template_button_click_36_listener() {
      return ctx.goForward();
    });
    \u0275\u0275elementStart(37, "label");
    \u0275\u0275text(38, "Lock In Your Price Today!");
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275classProp("details", ctx.showingDetails);
    \u0275\u0275advance(4);
    \u0275\u0275classMap(\u0275\u0275interpolate1("price ", ctx.retailPriceClass));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(7, 12, ctx.retailPrice, "USD"), " ");
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.hasPromotions ? 8 : -1);
    \u0275\u0275advance(8);
    \u0275\u0275classMap(\u0275\u0275interpolate1("price ", ctx.finalPriceClass));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(19, 15, ctx.finalPrice, "USD"), " ");
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind2(27, 18, ctx.dailyAmount, "USD"));
  }
}, dependencies: [OrderByPipe, CurrencyPipe], styles: ["\n\n.tooltip[_ngcontent-%COMP%] {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n  display: block;\n}\n.tooltip[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */", "\n\n@-webkit-keyframes _ngcontent-%COMP%_priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-moz-keyframes priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-o-keyframes priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n#externalAdjust[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: calc(var(--systemOffset-bottom) + 7vw);\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  overflow: hidden;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(50% - 6vw);\n  left: 50%;\n  font-size: 6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--ltweight);\n  line-height: 1;\n  -moz-animation-name: priceLoadIn;\n  -ms-animation-name: priceLoadIn;\n  -o-animation-name: priceLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_priceLoadIn;\n  animation-name: _ngcontent-%COMP%_priceLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 2s;\n  -ms-animation-duration: 2s;\n  -o-animation-duration: 2s;\n  -webkit-animation-duration: 2s;\n  animation-duration: 2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  -moz-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -o-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -webkit-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  position: absolute;\n  top: calc(50% + 3vw);\n  left: 50%;\n  -moz-animation-name: priceLoadIn;\n  -ms-animation-name: priceLoadIn;\n  -o-animation-name: priceLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_priceLoadIn;\n  animation-name: _ngcontent-%COMP%_priceLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 2s;\n  -ms-animation-duration: 2s;\n  -o-animation-duration: 2s;\n  -webkit-animation-duration: 2s;\n  animation-duration: 2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  -moz-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -o-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -webkit-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 13vw;\n  color: var(--warningAlt4);\n  line-height: 1;\n  font-weight: var(--stronger);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 13vw;\n  left: 1vw;\n  width: 35%;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--ltweight);\n  line-height: 1;\n  -moz-transition: transform 2s;\n  -o-transition: transform 2s;\n  -webkit-transition: transform 2s;\n  transition: transform 2s;\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  white-space: nowrap;\n  -moz-transform: translateX(-200%);\n  -ms-transform: translateX(-200%);\n  -o-transform: translateX(-200%);\n  -webkit-transform: translateX(-200%);\n  transform: translateX(-200%);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  align-items: center;\n  border-radius: 2vw;\n  overflow: hidden;\n  background-color: var(--warningAlt1);\n  border: 0.2vw var(--warningAlt4) solid;\n  -moz-transition: transform 2s;\n  -o-transition: transform 2s;\n  -webkit-transition: transform 2s;\n  transition: transform 2s;\n  -moz-transform: translateX(-125%);\n  -ms-transform: translateX(-125%);\n  -o-transform: translateX(-125%);\n  -webkit-transform: translateX(-125%);\n  transform: translateX(-125%);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  width: 25%;\n  height: 8vw;\n  background-color: var(--warningAlt3);\n  position: relative;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 4vw;\n  color: rgba(var(--color2-raw), 0.8);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  flex: 1;\n  padding: 0 1vw;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  display: block;\n  color: rgba(var(--color2-raw), 0.8);\n  font-size: 1.6vw;\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 0.25vw;\n  font-size: 3.6vw;\n  color: var(--color2);\n  font-weight: var(--strongest);\n  display: block;\n  line-height: 1;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%]:first-of-type {\n  margin-top: 0;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .divider[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 40%;\n  height: 75%;\n  width: 0.2vw;\n  border-right: 0.2vw var(--color2Alt2) dotted;\n  -moz-transform: translateY(-200%);\n  -ms-transform: translateY(-200%);\n  -o-transform: translateY(-200%);\n  -webkit-transform: translateY(-200%);\n  transform: translateY(-200%);\n  -moz-transition: transform 1s 0.75s;\n  -o-transition: transform 1s 0.75s;\n  -webkit-transition: transform 1s 0.75s;\n  transition: transform 1s 0.75s;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n  -moz-transform: translateX(125%);\n  -ms-transform: translateX(125%);\n  -o-transform: translateX(125%);\n  -webkit-transform: translateX(125%);\n  transform: translateX(125%);\n  -moz-transition: transform 2s 0.5s;\n  -o-transition: transform 2s 0.5s;\n  -webkit-transition: transform 2s 0.5s;\n  transition: transform 2s 0.5s;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  font-size: 3.2vw;\n  color: var(--successAlt4);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 11vw;\n  color: var(--successAlt3);\n  line-height: 1;\n  font-weight: var(--stronger);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%]    > .price.sixfigures[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 8vw;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .final[_ngcontent-%COMP%]    > .price.fivefigures[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  font-size: 9.6vw;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .divider[_ngcontent-%COMP%] {\n  margin-top: 2vw;\n  width: 100%;\n  position: relative;\n  text-align: right;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .divider[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  position: relative;\n  z-index: 1;\n  display: inline-block;\n  font-size: 3vw;\n  background-color: var(--color2);\n  color: var(--color2Alt4);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  padding: 0 1vw;\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  font-size: 6vw;\n  color: var(--successAlt4);\n  line-height: 1;\n  font-weight: var(--stronger);\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > .detail[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  display: block;\n  font-size: 5vw;\n  color: var(--successAlt4);\n  line-height: 1;\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%]    > .financing[_ngcontent-%COMP%]    > p[_ngcontent-%COMP%] {\n  font-size: 1.8vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap.internal[_ngcontent-%COMP%] {\n  position: absolute;\n  left: 2vw;\n  bottom: 2vw;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap.internal[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  border-radius: 100%;\n  height: 2vw;\n  width: 2vw;\n  background-color: var(--color4);\n  border: 0.2vw var(--color4Alt4) solid;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap.external[_ngcontent-%COMP%] {\n  position: absolute;\n  right: 2vw;\n  bottom: 3vw;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap.external[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  background-color: var(--color3);\n  border: 0.5vw var(--color3Alt3) solid;\n  border-radius: 999px;\n  padding: 1vw 3vw;\n  opacity: 0;\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transform-origin: bottom center;\n  -ms-transform-origin: bottom center;\n  -o-transform-origin: bottom center;\n  -webkit-transform-origin: bottom center;\n  transform-origin: bottom center;\n  -moz-transition: transform 2s 1.25s, opacity 2s 1.25s;\n  -o-transition: transform 2s 1.25s, opacity 2s 1.25s;\n  -webkit-transition: transform 2s 1.25s, opacity 2s 1.25s;\n  transition: transform 2s 1.25s, opacity 2s 1.25s;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap.external[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n  white-space: nowrap;\n}\n#externalAdjust[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control-wrap.external.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  left: 1vw;\n  top: 1vw;\n  -moz-transform: translate(0, 0) scale(0.5);\n  -ms-transform: translate(0, 0) scale(0.5);\n  -o-transform: translate(0, 0) scale(0.5);\n  -webkit-transform: translate(0, 0) scale(0.5);\n  transform: translate(0, 0) scale(0.5);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  left: 1vw;\n  top: 4vw;\n  -moz-transform: translate(0, 0) scale(0.5);\n  -ms-transform: translate(0, 0) scale(0.5);\n  -o-transform: translate(0, 0) scale(0.5);\n  -webkit-transform: translate(0, 0) scale(0.5);\n  transform: translate(0, 0) scale(0.5);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > .price.sixfigures[_ngcontent-%COMP%] {\n  -moz-transform: translate(0, 0) scale(0.36);\n  -ms-transform: translate(0, 0) scale(0.36);\n  -o-transform: translate(0, 0) scale(0.36);\n  -webkit-transform: translate(0, 0) scale(0.36);\n  transform: translate(0, 0) scale(0.36);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .retail[_ngcontent-%COMP%]    > .price.fivefigures[_ngcontent-%COMP%] {\n  -moz-transform: translate(0, 0) scale(0.45);\n  -ms-transform: translate(0, 0) scale(0.45);\n  -o-transform: translate(0, 0) scale(0.45);\n  -webkit-transform: translate(0, 0) scale(0.45);\n  transform: translate(0, 0) scale(0.45);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > h2[_ngcontent-%COMP%] {\n  -moz-transform: translateX(0) scale(0.5);\n  -ms-transform: translateX(0) scale(0.5);\n  -o-transform: translateX(0) scale(0.5);\n  -webkit-transform: translateX(0) scale(0.5);\n  transform: translateX(0) scale(0.5);\n  margin-bottom: -2vw;\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > h2.sixfigures[_ngcontent-%COMP%] {\n  -moz-transform: translate(0, 0) scale(0.36);\n  -ms-transform: translate(0, 0) scale(0.36);\n  -o-transform: translate(0, 0) scale(0.36);\n  -webkit-transform: translate(0, 0) scale(0.36);\n  transform: translate(0, 0) scale(0.36);\n  margin-bottom: -3vw;\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > h2.fivefigures[_ngcontent-%COMP%] {\n  -moz-transform: translate(0, 0) scale(0.45);\n  -ms-transform: translate(0, 0) scale(0.45);\n  -o-transform: translate(0, 0) scale(0.45);\n  -webkit-transform: translate(0, 0) scale(0.45);\n  transform: translate(0, 0) scale(0.45);\n  margin-bottom: -2vw;\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .promotions[_ngcontent-%COMP%]    > .promotion[_ngcontent-%COMP%] {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .divider[_ngcontent-%COMP%] {\n  -moz-transform: translateY(0);\n  -ms-transform: translateY(0);\n  -o-transform: translateY(0);\n  -webkit-transform: translateY(0);\n  transform: translateY(0);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .price[_ngcontent-%COMP%] {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n#externalAdjust.details[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .external[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%]:last-child, \n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%]:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=external-adjust.component.css.map */"] });
var ExternalAdjustComponent = _ExternalAdjustComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ExternalAdjustComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "external-adjust", template: `<section id="externalAdjust" [class.details]="showingDetails">
  <div class="retail">
    <h2>Retail Price</h2>

    <div class="price {{retailPriceClass}}">
      <span class="value">
        {{retailPrice | currency:'USD'}}
      </span>
    </div>
  </div>
  @if (hasPromotions) {
    <div class="promotions">
      <h2 class="{{retailPriceClass}}">Applied Promotions</h2>
      @for (promotion of promotions | orderBy:'priority':false; track $index) {
        <div class="promotion">
          <div class="icon">
            <i class="fa-solid fa-hands-holding-dollar"></i>
          </div>
          <div class="meta">
            <label>
              {{promotion.name}}
            </label>
            <span class="value">
              -{{promotion.appliedDiscount | currency:'USD'}}
            </span>
          </div>
        </div>
      }
    </div>
  }

  <div class="divider"></div>

  <div class="price">
    <div class="final">
      <h2>Your Price Today</h2>

      <p>
        (includes materials, installation, patching, cleanup and warranty)
      </p>

      <div class="price {{finalPriceClass}}">
        <span class="value">
          {{finalPrice | currency:'USD'}}
        </span>
      </div>
    </div>
    <div class="divider">
      <label>Or financing as low as</label>
    </div>
    <div class="financing">
      <div class="detail">
        <span class="value">{{dailyAmount | currency:'USD'}}</span>
        <label>per day</label>
      </div>

      <p>
        (Based on approved financing)
      </p>
    </div>
  </div>
  <div class="controls">
    <div class="control-wrap internal">
      <button
        class="control success subtle"
      (click)="adjustPrice()"></button>
    </div>
    <div class="control-wrap external">
      <button class="control" (click)="goForward()">
        <label>Lock In Your Price Today!</label>
      </button>
    </div>
  </div>
</section>`, styles: ["/* src/app/shared/ui/components/tooltips/tooltips.component.scss */\n.tooltip {\n  position: absolute;\n  z-index: 11;\n  width: 24vw;\n  background-color: var(--color5Alt3);\n  border: 0.5vw var(--color5Alt4) solid;\n  box-shadow:\n    0 0 0.1vw var(--color2),\n    0 0 0.2vw var(--color2),\n    0 0 1vw var(--color2),\n    0 0 3vw var(--color2),\n    0 0 5vw var(--color2),\n    0 0 7vw var(--color2);\n  border-radius: 0.5vw;\n  padding: 1vw;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n.tooltip > .control {\n  position: absolute;\n  top: 0.5vw;\n  right: 0.5vw;\n  cursor: pointer;\n}\n.tooltip > .control > i {\n  font-size: 1.4vw;\n  color: var(--color2);\n}\n.tooltip > h3 {\n  font-size: 1.6vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  font-style: italic;\n}\n.tooltip > p {\n  margin-top: 0.5vw;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n  color: var(--color2Alt1);\n  line-height: 1.2;\n}\n.tooltip > .controls {\n  margin-top: 0.5vw;\n}\n.tooltip > .controls > .control {\n  cursor: pointer;\n  display: block;\n}\n.tooltip > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--stronger);\n}\n.tooltip.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=tooltips.component.css.map */\n", "/* src/app/opportunity/price-negotiation/components/external-adjust/external-adjust.component.scss */\n@-webkit-keyframes priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-moz-keyframes priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@-o-keyframes priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n@keyframes priceLoadIn {\n  0% {\n    opacity: 0;\n    -webkit-filter: blur(5vw);\n    -moz-filter: blur(5vw);\n    -o-filter: blur(5vw);\n    -ms-filter: blur(5vw);\n    filter: blur(5vw);\n  }\n  100% {\n    opacity: 1;\n    -webkit-filter: blur(0);\n    -moz-filter: blur(0);\n    -o-filter: blur(0);\n    -ms-filter: blur(0);\n    filter: blur(0);\n  }\n}\n#externalAdjust {\n  position: absolute;\n  top: calc(var(--systemOffset-top) + 7vw);\n  left: 2vw;\n  right: 2vw;\n  bottom: calc(var(--systemOffset-bottom) + 7vw);\n  background-color: var(--color2);\n  border-radius: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  padding: 2vw;\n  overflow: hidden;\n}\n#externalAdjust > .retail > h2 {\n  position: absolute;\n  top: calc(50% - 6vw);\n  left: 50%;\n  font-size: 6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--ltweight);\n  line-height: 1;\n  -moz-animation-name: priceLoadIn;\n  -ms-animation-name: priceLoadIn;\n  -o-animation-name: priceLoadIn;\n  -webkit-animation-name: priceLoadIn;\n  animation-name: priceLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 2s;\n  -ms-animation-duration: 2s;\n  -o-animation-duration: 2s;\n  -webkit-animation-duration: 2s;\n  animation-duration: 2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  -moz-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -o-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -webkit-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n}\n#externalAdjust > .retail > .price {\n  position: absolute;\n  top: calc(50% + 3vw);\n  left: 50%;\n  -moz-animation-name: priceLoadIn;\n  -ms-animation-name: priceLoadIn;\n  -o-animation-name: priceLoadIn;\n  -webkit-animation-name: priceLoadIn;\n  animation-name: priceLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 2s;\n  -ms-animation-duration: 2s;\n  -o-animation-duration: 2s;\n  -webkit-animation-duration: 2s;\n  animation-duration: 2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  -moz-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -o-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  -webkit-transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n  transition:\n    transform 1s,\n    left 1s,\n    top 1s;\n}\n#externalAdjust > .retail > .price > .value {\n  font-size: 13vw;\n  color: var(--warningAlt4);\n  line-height: 1;\n  font-weight: var(--stronger);\n}\n#externalAdjust > .promotions {\n  position: absolute;\n  top: 13vw;\n  left: 1vw;\n  width: 35%;\n}\n#externalAdjust > .promotions > h2 {\n  font-size: 6vw;\n  color: var(--color1Alt3);\n  font-weight: var(--ltweight);\n  line-height: 1;\n  -moz-transition: transform 2s;\n  -o-transition: transform 2s;\n  -webkit-transition: transform 2s;\n  transition: transform 2s;\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  white-space: nowrap;\n  -moz-transform: translateX(-200%);\n  -ms-transform: translateX(-200%);\n  -o-transform: translateX(-200%);\n  -webkit-transform: translateX(-200%);\n  transform: translateX(-200%);\n}\n#externalAdjust > .promotions > .promotion {\n  margin-top: 1vw;\n  display: flex;\n  align-items: center;\n  border-radius: 2vw;\n  overflow: hidden;\n  background-color: var(--warningAlt1);\n  border: 0.2vw var(--warningAlt4) solid;\n  -moz-transition: transform 2s;\n  -o-transition: transform 2s;\n  -webkit-transition: transform 2s;\n  transition: transform 2s;\n  -moz-transform: translateX(-125%);\n  -ms-transform: translateX(-125%);\n  -o-transform: translateX(-125%);\n  -webkit-transform: translateX(-125%);\n  transform: translateX(-125%);\n}\n#externalAdjust > .promotions > .promotion > .icon {\n  width: 25%;\n  height: 8vw;\n  background-color: var(--warningAlt3);\n  position: relative;\n}\n#externalAdjust > .promotions > .promotion > .icon > i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 4vw;\n  color: rgba(var(--color2-raw), 0.8);\n}\n#externalAdjust > .promotions > .promotion > .meta {\n  flex: 1;\n  padding: 0 1vw;\n}\n#externalAdjust > .promotions > .promotion > .meta > label {\n  display: block;\n  color: rgba(var(--color2-raw), 0.8);\n  font-size: 1.6vw;\n  font-weight: var(--stronger);\n  line-height: 1;\n}\n#externalAdjust > .promotions > .promotion > .meta > .value {\n  display: block;\n  margin-top: 0.25vw;\n  font-size: 3.6vw;\n  color: var(--color2);\n  font-weight: var(--strongest);\n  display: block;\n  line-height: 1;\n}\n#externalAdjust > .promotions > .promotion:first-of-type {\n  margin-top: 0;\n}\n#externalAdjust > .divider {\n  position: absolute;\n  left: 40%;\n  height: 75%;\n  width: 0.2vw;\n  border-right: 0.2vw var(--color2Alt2) dotted;\n  -moz-transform: translateY(-200%);\n  -ms-transform: translateY(-200%);\n  -o-transform: translateY(-200%);\n  -webkit-transform: translateY(-200%);\n  transform: translateY(-200%);\n  -moz-transition: transform 1s 0.75s;\n  -o-transition: transform 1s 0.75s;\n  -webkit-transition: transform 1s 0.75s;\n  transition: transform 1s 0.75s;\n}\n#externalAdjust > .price {\n  position: absolute;\n  top: 1vw;\n  right: 1vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n  -moz-transform: translateX(125%);\n  -ms-transform: translateX(125%);\n  -o-transform: translateX(125%);\n  -webkit-transform: translateX(125%);\n  transform: translateX(125%);\n  -moz-transition: transform 2s 0.5s;\n  -o-transition: transform 2s 0.5s;\n  -webkit-transition: transform 2s 0.5s;\n  transition: transform 2s 0.5s;\n}\n#externalAdjust > .price > .final {\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n#externalAdjust > .price > .final > h2 {\n  font-size: 3.2vw;\n  color: var(--successAlt4);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#externalAdjust > .price > .final > p {\n  font-size: 1.8vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n#externalAdjust > .price > .final > .price {\n  margin-top: 1vw;\n}\n#externalAdjust > .price > .final > .price > .value {\n  display: block;\n  font-size: 11vw;\n  color: var(--successAlt3);\n  line-height: 1;\n  font-weight: var(--stronger);\n}\n#externalAdjust > .price > .final > .price.sixfigures > .value {\n  font-size: 8vw;\n}\n#externalAdjust > .price > .final > .price.fivefigures > .value {\n  font-size: 9.6vw;\n}\n#externalAdjust > .price > .divider {\n  margin-top: 2vw;\n  width: 100%;\n  position: relative;\n  text-align: right;\n}\n#externalAdjust > .price > .divider > label {\n  position: relative;\n  z-index: 1;\n  display: inline-block;\n  font-size: 3vw;\n  background-color: var(--color2);\n  color: var(--color2Alt4);\n}\n#externalAdjust > .price > .financing {\n  margin-top: 1vw;\n  padding: 0 1vw;\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-end;\n}\n#externalAdjust > .price > .financing > .detail {\n  display: flex;\n  align-items: center;\n}\n#externalAdjust > .price > .financing > .detail > .value {\n  display: block;\n  font-size: 6vw;\n  color: var(--successAlt4);\n  line-height: 1;\n  font-weight: var(--stronger);\n}\n#externalAdjust > .price > .financing > .detail > label {\n  margin-left: 1vw;\n  display: block;\n  font-size: 5vw;\n  color: var(--successAlt4);\n  line-height: 1;\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n#externalAdjust > .price > .financing > p {\n  font-size: 1.8vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n#externalAdjust > .controls > .control-wrap > .control {\n  cursor: pointer;\n}\n#externalAdjust > .controls > .control-wrap > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#externalAdjust > .controls > .control-wrap > .control:first-child {\n  margin-left: 0;\n}\n#externalAdjust > .controls > .control-wrap.internal {\n  position: absolute;\n  left: 2vw;\n  bottom: 2vw;\n}\n#externalAdjust > .controls > .control-wrap.internal > .control {\n  border-radius: 100%;\n  height: 2vw;\n  width: 2vw;\n  background-color: var(--color4);\n  border: 0.2vw var(--color4Alt4) solid;\n}\n#externalAdjust > .controls > .control-wrap.external {\n  position: absolute;\n  right: 2vw;\n  bottom: 3vw;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#externalAdjust > .controls > .control-wrap.external > .control {\n  background-color: var(--color3);\n  border: 0.5vw var(--color3Alt3) solid;\n  border-radius: 999px;\n  padding: 1vw 3vw;\n  opacity: 0;\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transform-origin: bottom center;\n  -ms-transform-origin: bottom center;\n  -o-transform-origin: bottom center;\n  -webkit-transform-origin: bottom center;\n  transform-origin: bottom center;\n  -moz-transition: transform 2s 1.25s, opacity 2s 1.25s;\n  -o-transition: transform 2s 1.25s, opacity 2s 1.25s;\n  -webkit-transition: transform 2s 1.25s, opacity 2s 1.25s;\n  transition: transform 2s 1.25s, opacity 2s 1.25s;\n}\n#externalAdjust > .controls > .control-wrap.external > .control > label {\n  font-size: 4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n  white-space: nowrap;\n}\n#externalAdjust > .controls > .control-wrap.external.active {\n  opacity: 1;\n}\n#externalAdjust.details > .retail > h2 {\n  left: 1vw;\n  top: 1vw;\n  -moz-transform: translate(0, 0) scale(0.5);\n  -ms-transform: translate(0, 0) scale(0.5);\n  -o-transform: translate(0, 0) scale(0.5);\n  -webkit-transform: translate(0, 0) scale(0.5);\n  transform: translate(0, 0) scale(0.5);\n}\n#externalAdjust.details > .retail > .price {\n  left: 1vw;\n  top: 4vw;\n  -moz-transform: translate(0, 0) scale(0.5);\n  -ms-transform: translate(0, 0) scale(0.5);\n  -o-transform: translate(0, 0) scale(0.5);\n  -webkit-transform: translate(0, 0) scale(0.5);\n  transform: translate(0, 0) scale(0.5);\n}\n#externalAdjust.details > .retail > .price.sixfigures {\n  -moz-transform: translate(0, 0) scale(0.36);\n  -ms-transform: translate(0, 0) scale(0.36);\n  -o-transform: translate(0, 0) scale(0.36);\n  -webkit-transform: translate(0, 0) scale(0.36);\n  transform: translate(0, 0) scale(0.36);\n}\n#externalAdjust.details > .retail > .price.fivefigures {\n  -moz-transform: translate(0, 0) scale(0.45);\n  -ms-transform: translate(0, 0) scale(0.45);\n  -o-transform: translate(0, 0) scale(0.45);\n  -webkit-transform: translate(0, 0) scale(0.45);\n  transform: translate(0, 0) scale(0.45);\n}\n#externalAdjust.details > .promotions > h2 {\n  -moz-transform: translateX(0) scale(0.5);\n  -ms-transform: translateX(0) scale(0.5);\n  -o-transform: translateX(0) scale(0.5);\n  -webkit-transform: translateX(0) scale(0.5);\n  transform: translateX(0) scale(0.5);\n  margin-bottom: -2vw;\n}\n#externalAdjust.details > .promotions > h2.sixfigures {\n  -moz-transform: translate(0, 0) scale(0.36);\n  -ms-transform: translate(0, 0) scale(0.36);\n  -o-transform: translate(0, 0) scale(0.36);\n  -webkit-transform: translate(0, 0) scale(0.36);\n  transform: translate(0, 0) scale(0.36);\n  margin-bottom: -3vw;\n}\n#externalAdjust.details > .promotions > h2.fivefigures {\n  -moz-transform: translate(0, 0) scale(0.45);\n  -ms-transform: translate(0, 0) scale(0.45);\n  -o-transform: translate(0, 0) scale(0.45);\n  -webkit-transform: translate(0, 0) scale(0.45);\n  transform: translate(0, 0) scale(0.45);\n  margin-bottom: -2vw;\n}\n#externalAdjust.details > .promotions > .promotion {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n#externalAdjust.details > .divider {\n  -moz-transform: translateY(0);\n  -ms-transform: translateY(0);\n  -o-transform: translateY(0);\n  -webkit-transform: translateY(0);\n  transform: translateY(0);\n}\n#externalAdjust.details > .price {\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n}\n#externalAdjust.details > .controls > .external > .control {\n  opacity: 1;\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#mainNav > .island {\n  position: absolute;\n  bottom: 1vw;\n  right: 1vw;\n  z-index: calc(var(--navLayer) + 1);\n  background-color: var(--color2);\n  border-radius: 999px;\n  padding: 0.5vw 1vw;\n}\n#mainNav > .island > .controls {\n  display: flex;\n  align-items: center;\n}\n#mainNav > .island > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 999px;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#mainNav > .island > .controls > .control > i:last-child,\n#mainNav > .island > .controls > .control > label:last-child {\n  margin-left: 0.5vw;\n}\n#mainNav > .island > .controls > .control > i {\n  font-size: 1.2vw;\n  color: var(--color2);\n}\n#mainNav > .island > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#mainNav > .island > .controls > .control.success {\n  background-color: var(--success);\n}\n#mainNav > .island > .controls > .control.alternate {\n  background-color: var(--color2);\n  border-color: var(--color1);\n}\n#mainNav > .island > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#mainNav > .island > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#mainNav > .island > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#mainNav > .island > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#mainNav > .island > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#mainNav > .island > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=external-adjust.component.css.map */\n"] }]
  }], () => [{ type: LiveOpportunityService }, { type: OpportunityPricingService }, { type: OpportunityService }, { type: UiService }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ExternalAdjustComponent, { className: "ExternalAdjustComponent", filePath: "src/app/opportunity/price-negotiation/components/external-adjust/external-adjust.component.ts", lineNumber: 32 });
})();

// src/app/opportunity/price-negotiation/components/layout/layout.component.ts
var _c03 = ["componentElm"];
function PricingLayoutComponent_Conditional_0_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "internal-adjust", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.adjustRoute == null ? null : ctx_r0.adjustRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.adjustRoute == null ? null : ctx_r0.adjustRoute.animating)("closing", ctx_r0.adjustRoute == null ? null : ctx_r0.adjustRoute.closing)("rendered", ctx_r0.adjustRoute == null ? null : ctx_r0.adjustRoute.rendered);
    \u0275\u0275property("opportunity", ctx_r0.opportunity)("route", ctx_r0.adjustRoute);
  }
}
function PricingLayoutComponent_Conditional_0_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "external-adjust", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.externalAdjustRoute == null ? null : ctx_r0.externalAdjustRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.externalAdjustRoute == null ? null : ctx_r0.externalAdjustRoute.animating)("closing", ctx_r0.externalAdjustRoute == null ? null : ctx_r0.externalAdjustRoute.closing)("rendered", ctx_r0.externalAdjustRoute == null ? null : ctx_r0.externalAdjustRoute.rendered);
    \u0275\u0275property("opportunity", ctx_r0.opportunity)("route", ctx_r0.externalAdjustRoute);
  }
}
function PricingLayoutComponent_Conditional_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "div", 2);
    \u0275\u0275conditionalCreate(3, PricingLayoutComponent_Conditional_0_Conditional_3_Template, 1, 11, "internal-adjust", 3);
    \u0275\u0275conditionalCreate(4, PricingLayoutComponent_Conditional_0_Conditional_4_Template, 1, 11, "external-adjust", 3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275conditional((ctx_r0.adjustRoute == null ? null : ctx_r0.adjustRoute.active) ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx_r0.externalAdjustRoute == null ? null : ctx_r0.externalAdjustRoute.active) ? 4 : -1);
  }
}
var _PricingLayoutComponent = class _PricingLayoutComponent {
  constructor(liveOpportunityService, opportunityService, opportunityPricingService) {
    this.liveOpportunityService = liveOpportunityService;
    this.opportunityService = opportunityService;
    this.opportunityPricingService = opportunityPricingService;
    this.routeParams = new BehaviorSubject([]);
    this.viewingItemizedPricing = false;
    this.closingItemizedPricing = false;
  }
  get routesInitialized() {
    return this.opportunityPricingService.routesInitialized;
  }
  get routes() {
    return this.opportunityPricingService.routeService.routes;
  }
  watchParams() {
    if (this.route != null) {
      this.paramsSubscription = this.route.params.subscribe({
        next: (params) => {
          const componentElm = this.componentElm?.nativeElement;
          if (componentElm != null && this.opportunity != null) {
            let route = params[0]?.toLowerCase();
            if (route != null) {
              const routeMatches = Object.values(OpportunityPricingRouteType).includes(route);
              const routeParams = params.slice(1);
              this.routeParams.next(routeParams);
              if (routeMatches) {
                if (!this.routesInitialized) {
                  this.opportunityPricingService.initRoutes(route, componentElm);
                } else {
                  this.viewRoute(route);
                }
              } else {
                if (!this.routesInitialized) {
                  this.opportunityPricingService.initRoutes(void 0, componentElm);
                }
              }
            } else {
              if (!this.routesInitialized) {
                this.opportunityPricingService.initRoutes(void 0, componentElm);
              }
            }
          }
        }
      });
    }
  }
  viewRoute(name) {
    if (name != null) {
      this.opportunityPricingService.routeService.viewRoute(name, RouteLoadDirection.Forward, true);
    }
  }
  watchRoute() {
    this.routeSubscription = this.opportunityPricingService.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
          }
        }
      }
    });
  }
  initRouting() {
    if (this.opportunity?.customPrice?.finalPrice == null || this.opportunity.customPrice.finalPrice <= 0) {
      const componentElm = this.componentElm?.nativeElement;
      if (componentElm != null && this.opportunity != null) {
        this.opportunityPricingService.initRoutes(OpportunityPricingRouteType.adjustedexternal, componentElm);
      }
    }
    setTimeout(() => {
      this.watchParams();
      this.watchRoute();
    }, 0);
  }
  viewItemizedPricing() {
    window.clearTimeout(this.itemizedPricingTimer);
    this.closingItemizedPricing = false;
    this.viewingItemizedPricing = true;
  }
  stopViewingItemizedPricing() {
    window.clearTimeout(this.itemizedPricingTimer);
    this.closingItemizedPricing = true;
    this.itemizedPricingTimer = window.setTimeout(() => {
      this.viewingItemizedPricing = false;
      this.closingItemizedPricing = false;
    }, 250);
  }
  // #endregion
  // #region Internal Adjust
  get adjustRoute() {
    return this.routes[OpportunityPricingRouteType.adjust];
  }
  // #endregion
  // #region External
  get externalAdjustRoute() {
    return this.routes[OpportunityPricingRouteType.adjustedexternal];
  }
  // #endregion
  // #region Permissions
  get canModifyOpportunity() {
    if (this.opportunity != null) {
      return this.opportunityService.canModifyOpportunity(this.opportunity);
    }
    return false;
  }
  // #endregion
  // #region Navigation
  get routeService() {
    return this.liveOpportunityService.routeService;
  }
  init() {
    if (this.opportunity != null) {
      this.initRouting();
    }
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_PricingLayoutComponent.\u0275fac = function PricingLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PricingLayoutComponent)(\u0275\u0275directiveInject(LiveOpportunityService), \u0275\u0275directiveInject(OpportunityService), \u0275\u0275directiveInject(OpportunityPricingService));
};
_PricingLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _PricingLayoutComponent, selectors: [["ng-component"]], viewQuery: function PricingLayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { opportunity: "opportunity", route: "route" }, standalone: false, decls: 1, vars: 1, consts: [["componentElm", ""], ["id", "negotiationLayout"], [1, "routes"], [3, "class", "opportunity", "animate", "closing", "rendered", "route"], [3, "opportunity", "route"]], template: function PricingLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275conditionalCreate(0, PricingLayoutComponent_Conditional_0_Template, 5, 2, "section", 1);
  }
  if (rf & 2) {
    \u0275\u0275conditional(ctx.opportunity != null ? 0 : -1);
  }
}, dependencies: [InternalAdjustComponent, ExternalAdjustComponent], styles: ['\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  will-change: transform;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10;\n  background-color: rgba(var(--color1-raw), 0.2);\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n/*# sourceMappingURL=layout.component.css.map */'] });
var PricingLayoutComponent = _PricingLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PricingLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, template: '@if (opportunity != null) {\n  <section id="negotiationLayout" #componentElm>\n    <div class="routes">\n      @if (adjustRoute?.active) {\n        <internal-adjust class="route {{adjustRoute?.loadDirection}}"\n          [opportunity]="opportunity"\n          [class.animate]="adjustRoute?.animating"\n          [class.closing]="adjustRoute?.closing"\n          [class.rendered]="adjustRoute?.rendered"\n        [route]="adjustRoute"></internal-adjust>\n      }\n      @if (externalAdjustRoute?.active) {\n        <external-adjust class="route {{externalAdjustRoute?.loadDirection}}"\n          [opportunity]="opportunity"\n          [class.animate]="externalAdjustRoute?.animating"\n          [class.closing]="externalAdjustRoute?.closing"\n          [class.rendered]="externalAdjustRoute?.rendered"\n        [route]="externalAdjustRoute"></external-adjust>\n      }\n    </div>\n  </section>\n}', styles: ['/* src/app/opportunity/price-negotiation/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#negotiationLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  will-change: transform;\n}\n#negotiationLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#negotiationLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#negotiationLayout > .routes > .route:after {\n  content: "";\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 10;\n  background-color: rgba(var(--color1-raw), 0.2);\n  -webkit-backdrop-filter: blur(0.1vw);\n  -moz-backdrop-filter: blur(0.1vw);\n  -o-backdrop-filter: blur(0.1vw);\n  -ms-backdrop-filter: blur(0.1vw);\n  backdrop-filter: blur(0.1vw);\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n/*# sourceMappingURL=layout.component.css.map */\n'] }]
  }], () => [{ type: LiveOpportunityService }, { type: OpportunityService }, { type: OpportunityPricingService }], { opportunity: [{
    type: Input,
    args: ["opportunity"]
  }], route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(PricingLayoutComponent, { className: "PricingLayoutComponent", filePath: "src/app/opportunity/price-negotiation/components/layout/layout.component.ts", lineNumber: 29 });
})();

// src/app/opportunity/price-negotiation/price-negotiation.module.ts
var _PriceNegotiationModule = class _PriceNegotiationModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    if (!customElements.get("price-negotiation")) {
      const el = createCustomElement(PricingLayoutComponent, { injector: this.injector });
      customElements.define("price-negotiation", el);
    }
  }
};
_PriceNegotiationModule.\u0275fac = function PriceNegotiationModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PriceNegotiationModule)(\u0275\u0275inject(Injector));
};
_PriceNegotiationModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _PriceNegotiationModule });
_PriceNegotiationModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  OpportunityPricingService,
  InternalRouteService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var PriceNegotiationModule = _PriceNegotiationModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PriceNegotiationModule, [{
    type: NgModule,
    args: [{
      declarations: [
        PricingLayoutComponent,
        InternalAdjustComponent,
        ExternalAdjustComponent
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        OpportunityPricingService,
        InternalRouteService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  PriceNegotiationModule
};
//# sourceMappingURL=chunk-EYZCRWL5.js.map
