import {
  StorageService
} from "./chunk-6FRIKJSO.js";
import {
  generateId
} from "./chunk-ZLJFMUW4.js";
import {
  HttpClient,
  Injectable,
  Observable,
  setClassMetadata,
  ɵɵdefineInjectable,
  ɵɵinject
} from "./chunk-S237TOF5.js";

// src/app/shared/presentation/models/presentation.ts
var PresentationContent = class {
  constructor(id, source, source_Url, thumb, thumb_Url, type, title) {
    this.id = "";
    this.type = PresentationContentType.Image;
    this.title = "";
    this.id = id;
    this.source = source;
    this.source_Url = source_Url;
    this.thumb = thumb;
    this.thumb_Url = thumb_Url;
    this.type = type;
    this.title = title;
  }
};
var PresentationContentType;
(function(PresentationContentType2) {
  PresentationContentType2["Image"] = "Image";
  PresentationContentType2["Video"] = "Video";
  PresentationContentType2["Url"] = "Url";
  PresentationContentType2["Pdf"] = "Pdf";
})(PresentationContentType || (PresentationContentType = {}));
var PresentationPage = class {
  constructor(content, number) {
    this.number = 1;
    this.new = false;
    this.active = false;
    this.selected = false;
    this.new = true;
    this.content = new PresentationContent(content.id, content.source, content.source_Url, content.thumb, content.thumb_Url, content.type, content.title);
    this.number = number;
    setTimeout(() => {
      this.new = false;
    }, 250);
  }
};
var PersonalPresentation = class {
  constructor(name, userId) {
    this.id = generateId();
    this.userId = userId;
    this.name = name;
    this.created_Utc = /* @__PURE__ */ new Date();
    this.lastUpdated_Utc = /* @__PURE__ */ new Date();
    this.pageCollection = new PageCollection();
  }
};
var PageCollection = class {
  constructor() {
    this.pages = [];
  }
};

// src/app/shared/presentation/services/presentation.service.ts
var _PresentationService = class _PresentationService {
  constructor(http, storageService) {
    this.http = http;
    this.storageService = storageService;
  }
  // #region Content
  getAvailableCollections() {
    const url = "{{api}}/presentations/collections";
    return this.http.get(url);
  }
  // #endregion
  // #region Default Presentation
  getDefaultPresentation(userId) {
    return new Observable((o) => {
      this.getAvailableCollections().subscribe({
        next: (collections) => {
          const presentation = new PersonalPresentation(userId, "Default");
          for (var i = 0, len = collections.length; i < len; i++) {
            const collection = collections[i];
            if (collection.name == "Presentation Booklet") {
              for (var j = 1, jlen = collection.content.length + 1; j < jlen; j++) {
                const item = collection.content[j - 1];
                const page = new PresentationPage(item, j);
                presentation.pageCollection.pages.push(page);
              }
              break;
            }
          }
          o.next(presentation);
          o.complete();
        },
        error: () => {
          o.error();
          o.complete();
        }
      });
    });
  }
  // #endregion
  // #region Personal Presentation
  getPresentationByName(userId, name) {
    return new Observable((o) => {
      this.storageService.getPresentationByName(userId, name).then((presentation) => {
        if (presentation != null) {
          o.next(presentation);
          o.complete();
        } else {
          o.next(null);
          o.complete();
        }
      }).catch(() => {
        o.error();
        o.complete();
      });
    });
  }
  storePresentation(presentation) {
    return new Observable((o) => {
      this.storageService.storePresentation(presentation).then(() => {
        o.next();
        o.complete();
      }).catch(() => {
        o.error();
        o.complete();
      });
    });
  }
};
_PresentationService.\u0275fac = function PresentationService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PresentationService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(StorageService));
};
_PresentationService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _PresentationService, factory: _PresentationService.\u0275fac, providedIn: "root" });
var PresentationService = _PresentationService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PresentationService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }, { type: StorageService }], null);
})();

export {
  PresentationContentType,
  PresentationPage,
  PersonalPresentation,
  PresentationService
};
//# sourceMappingURL=chunk-KKLYLRR3.js.map
