import {
  SideNavService
} from "./chunk-ENO5HLAD.js";
import {
  PresentationService
} from "./chunk-KKLYLRR3.js";
import {
  AiService
} from "./chunk-UNH3YHYW.js";
import {
  EstimateSubmissionComponent,
  OpportunityDetailsComponent,
  OpportunityLedgerComponent,
  OpportunityPaymentsComponent,
  OpportunitySigningComponent,
  PaymentsService,
  SendDocumentsForSigningComponent,
  SendExecutedDocumentsComponent,
  SendQuoteComponent,
  SharedOpportunityModule,
  UserService
} from "./chunk-NPEXXEDA.js";
import "./chunk-ZIGK756M.js";
import {
  OpportunityUiService
} from "./chunk-SOO3P3LB.js";
import {
  DeviceRouteService,
  ReminderPriority,
  ReminderReferenceType,
  ReminderService
} from "./chunk-52MKHWPF.js";
import {
  DeviceRoute
} from "./chunk-NWZAVPC4.js";
import {
  createCustomElement
} from "./chunk-4VXBNATF.js";
import {
  OpportunityMigrationService
} from "./chunk-X3DPDDQ7.js";
import {
  AppService
} from "./chunk-4M45UUXA.js";
import "./chunk-XDMVTB42.js";
import {
  DocumentService
} from "./chunk-4VDNM36X.js";
import "./chunk-HJJU6GQE.js";
import "./chunk-66ZW56BE.js";
import {
  UiService
} from "./chunk-DQROWZRM.js";
import {
  OpportunityService
} from "./chunk-ZHMU5CV6.js";
import "./chunk-2UWBL76P.js";
import "./chunk-BN54ET2Y.js";
import "./chunk-7LL3CK47.js";
import {
  AuthService
} from "./chunk-CRUJNSPU.js";
import "./chunk-IVJ6NEFT.js";
import {
  ApiService
} from "./chunk-UFFVFEYG.js";
import {
  AuthRefService
} from "./chunk-6FRIKJSO.js";
import {
  DocumentSigner,
  DocumentSignerType,
  generateId
} from "./chunk-ZLJFMUW4.js";
import {
  environment
} from "./chunk-MZF2PAUH.js";
import {
  AsyncPipe,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  CurrencyInputComponent,
  DefaultValueAccessor,
  DomSanitizer,
  FormsModule,
  HttpClient,
  Injectable,
  Injector,
  Input,
  MaxLengthValidator,
  NgControlStatus,
  NgModel,
  NgModule,
  NgSelectOption,
  OrderByPipe,
  Output,
  ReactiveFormsModule,
  Router,
  RouterModule,
  SelectControlValueAccessor,
  Subject,
  UiModule,
  ViewChild,
  createNgModule,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵNgSelectMultipleOption,
  ɵsetClassDebugInfo,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeResourceUrl,
  ɵɵsanitizeUrl,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtextInterpolate2,
  ɵɵtextInterpolate3,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-S237TOF5.js";
import {
  Capacitor
} from "./chunk-IT26RCSL.js";
import {
  __async
} from "./chunk-RVA4KI76.js";

// src/app/main/models/navigation.ts
var MainRouteType;
(function(MainRouteType2) {
  MainRouteType2["Dashboard"] = "Dashboard";
  MainRouteType2["Authentication"] = "Authentication";
  MainRouteType2["Appointment"] = "Appointment";
  MainRouteType2["BookOfBusiness"] = "BookOfBusiness";
  MainRouteType2["Reporting"] = "Reporting";
  MainRouteType2["Administration"] = "Administration";
  MainRouteType2["Opportunity"] = "Opportunity";
  MainRouteType2["Presentation"] = "Presentation";
})(MainRouteType || (MainRouteType = {}));

// src/app/shared/payments/components/manual-payment/manual-payment.component.ts
var _c0 = ["componentElm"];
function ManualPaymentComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6)(1, "p");
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r0.tip, " ");
  }
}
function ManualPaymentComponent_Conditional_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1, " You must specify a payment amount. ");
    \u0275\u0275elementEnd();
  }
}
function ManualPaymentComponent_For_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 14);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const method_r2 = ctx.$implicit;
    \u0275\u0275property("ngValue", method_r2.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", method_r2.name, " ");
  }
}
function ManualPaymentComponent_Conditional_24_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1, " You must specify a payment method. ");
    \u0275\u0275elementEnd();
  }
}
function ManualPaymentComponent_Conditional_33_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p");
    \u0275\u0275text(1, " Please Sign Here ");
    \u0275\u0275elementEnd();
  }
}
function ManualPaymentComponent_Conditional_34_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "img", 19);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("src", ctx_r0.signature.signature_B64, \u0275\u0275sanitizeUrl);
  }
}
function ManualPaymentComponent_Conditional_35_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 21);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(2, "div", 22);
    \u0275\u0275text(3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.signature.hash_SHA256, " ");
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", ctx_r0.signature.timeStamp_Utc, " ");
  }
}
function ManualPaymentComponent_Conditional_36_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 11);
    \u0275\u0275text(1, " You must sign before you can record this external payment. ");
    \u0275\u0275elementEnd();
  }
}
var _ManualPaymentComponent = class _ManualPaymentComponent {
  constructor(authRefService, documentService, paymentsService) {
    this.authRefService = authRefService;
    this.documentService = documentService;
    this.paymentsService = paymentsService;
    this.user = null;
    this.fieldId = generateId();
    this.makingPayment = false;
  }
  watchUser() {
    this.userSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.user = user;
      }
    });
  }
  // #endregion
  // #region Tip
  get tip() {
    return this.paymentsService.manualPaymentTip;
  }
  get showTip() {
    return this.tip != null && this.tip.length > 0;
  }
  get methods() {
    return this.paymentsService.manualPaymentMethods ?? [];
  }
  get methodValid() {
    return this.selectedMethodId != null;
  }
  updateMethod() {
    this.selectedMethod = this.methods.find((x) => x.id == this.selectedMethodId);
  }
  initMethods() {
    setTimeout(() => {
      this.selectedMethodId == this.methods[0]?.id;
    }, 0);
  }
  get signatureValid() {
    return this.signature?.signature_B64 != null;
  }
  startSigning() {
    if (this.user != null) {
      const signer = new DocumentSigner(this.fieldId, this.user.fullName ?? "", false, this.user.phone, this.user.emailAddress, DocumentSignerType.Consultant);
      this.signatureSubscription = this.documentService.signature.subscribe({
        next: (update) => {
          this.signature = update.signature;
          this.signatureSubscription?.unsubscribe();
        }
      });
      this.documentService.startSigning(signer, this.fieldId, "");
    }
  }
  get amountValid() {
    return this.amount != null && this.amount > 0;
  }
  updateAmount(e) {
    this.amount = e.amount;
  }
  get canSubmitPayment() {
    return !this.makingPayment && this.amount != null && this.amount > 0 && this.selectedMethod != null && this.signature?.signature_B64 != null;
  }
  makePayment() {
    if (this.canSubmitPayment && this.selectedMethod != null && this.amount != null && this.amount > 0 && this.signature != null) {
      this.paymentsService.submitManualPayment(this.selectedMethod, this.amount);
      this.closeView();
    }
  }
  closeView() {
    this.paymentsService.stopMakingManualPayment();
  }
  init() {
    this.initMethods();
    this.watchUser();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.signatureSubscription?.unsubscribe();
    this.userSubscription?.unsubscribe();
  }
};
_ManualPaymentComponent.\u0275fac = function ManualPaymentComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ManualPaymentComponent)(\u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(DocumentService), \u0275\u0275directiveInject(PaymentsService));
};
_ManualPaymentComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ManualPaymentComponent, selectors: [["manual-payment"]], viewQuery: function ManualPaymentComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, standalone: false, decls: 44, vars: 17, consts: [["id", "manualPayment"], [1, "primary"], [1, "controls"], [1, "control", 3, "click", "disabled"], [1, "fa-solid", "fa-xmark"], [1, "content"], [1, "message", "warning"], [1, "form"], [1, "input-wrap"], [1, "input", "prominent"], [3, "currencyOutput"], [1, "message"], [1, "input"], [3, "ngModelChange", "change", "ngModel"], [3, "ngValue"], [1, "tip"], [1, "signature", 3, "click"], [1, "render"], ["width", "5", "height", "2"], [3, "src"], [1, "control", "alternate", 3, "click", "disabled"], [1, "hash"], [1, "timestamp"]], template: function ManualPaymentComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "header")(2, "div", 1)(3, "h3");
    \u0275\u0275text(4, " Record an External Payment ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 2)(6, "button", 3);
    \u0275\u0275listener("click", function ManualPaymentComponent_Template_button_click_6_listener() {
      return ctx.closeView();
    });
    \u0275\u0275element(7, "i", 4);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 5);
    \u0275\u0275conditionalCreate(9, ManualPaymentComponent_Conditional_9_Template, 3, 1, "div", 6);
    \u0275\u0275elementStart(10, "div", 7)(11, "div", 8)(12, "label");
    \u0275\u0275text(13, "Amount");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "div", 9)(15, "currency-input", 10);
    \u0275\u0275listener("currencyOutput", function ManualPaymentComponent_Template_currency_input_currencyOutput_15_listener($event) {
      return ctx.updateAmount($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(16, ManualPaymentComponent_Conditional_16_Template, 2, 0, "p", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(17, "div", 8)(18, "label");
    \u0275\u0275text(19, "Payment Method");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(20, "div", 12)(21, "select", 13);
    \u0275\u0275twoWayListener("ngModelChange", function ManualPaymentComponent_Template_select_ngModelChange_21_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.selectedMethodId, $event) || (ctx.selectedMethodId = $event);
      return $event;
    });
    \u0275\u0275listener("change", function ManualPaymentComponent_Template_select_change_21_listener() {
      return ctx.updateMethod();
    });
    \u0275\u0275repeaterCreate(22, ManualPaymentComponent_For_23_Template, 2, 2, "option", 14, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(24, ManualPaymentComponent_Conditional_24_Template, 2, 0, "p", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(25, "div", 8)(26, "label");
    \u0275\u0275text(27, "Signature");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "p", 15);
    \u0275\u0275text(29, " By signing below, I attest that I have either personally collected the deposit amount listed above or confirmed financing approval and payment authorization. ");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(30, "div", 16);
    \u0275\u0275listener("click", function ManualPaymentComponent_Template_div_click_30_listener() {
      return ctx.startSigning();
    });
    \u0275\u0275elementStart(31, "div", 17);
    \u0275\u0275element(32, "canvas", 18);
    \u0275\u0275conditionalCreate(33, ManualPaymentComponent_Conditional_33_Template, 2, 0, "p");
    \u0275\u0275conditionalCreate(34, ManualPaymentComponent_Conditional_34_Template, 1, 1, "img", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(35, ManualPaymentComponent_Conditional_35_Template, 4, 2);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(36, ManualPaymentComponent_Conditional_36_Template, 2, 0, "p", 11);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(37, "div", 2)(38, "button", 20);
    \u0275\u0275listener("click", function ManualPaymentComponent_Template_button_click_38_listener() {
      return ctx.closeView();
    });
    \u0275\u0275elementStart(39, "label");
    \u0275\u0275text(40, "Cancel");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(41, "button", 3);
    \u0275\u0275listener("click", function ManualPaymentComponent_Template_button_click_41_listener() {
      return ctx.makePayment();
    });
    \u0275\u0275elementStart(42, "label");
    \u0275\u0275text(43, "Submit Payment");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(6);
    \u0275\u0275property("disabled", ctx.makingPayment);
    \u0275\u0275advance(3);
    \u0275\u0275conditional(ctx.showTip ? 9 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("invalid", !ctx.amountValid);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(!ctx.amountValid ? 16 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("invalid", !ctx.methodValid);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx.selectedMethodId);
    \u0275\u0275advance();
    \u0275\u0275repeater(ctx.methods);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(!ctx.methodValid ? 24 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("invalid", !ctx.signatureValid);
    \u0275\u0275advance(8);
    \u0275\u0275conditional((ctx.signature == null ? null : ctx.signature.signature_B64) == null ? 33 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.signature == null ? null : ctx.signature.signature_B64) != null ? 34 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.signature != null ? 35 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!ctx.signatureValid ? 36 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx.makingPayment);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canSubmitPayment);
  }
}, dependencies: [NgSelectOption, \u0275NgSelectMultipleOption, SelectControlValueAccessor, NgControlStatus, CurrencyInputComponent, NgModel], styles: ["\n\n#manualPayment[_ngcontent-%COMP%] {\n  position: relative;\n}\n#manualPayment[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#manualPayment[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#manualPayment[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h4[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#manualPayment[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#manualPayment[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .message.warning[_ngcontent-%COMP%] {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .tip[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input, \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 3vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]:focus, \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]     input:focus, \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus, \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%]:focus {\n  border-color: var(--color3);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input.prominent[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input.prominent[_ngcontent-%COMP%]     input, \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input.prominent[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input.prominent[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  font-size: 5vw;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  position: relative;\n  border: 2px var(--color1) dotted;\n  border-radius: 0.5vw;\n  background-color: rgba(var(--success-raw), 0.1);\n  padding: 5px;\n  cursor: pointer;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   canvas[_ngcontent-%COMP%] {\n  width: 100%;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   p[_ngcontent-%COMP%] {\n  font-size: 3vw;\n  text-align: center;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  white-space: nowrap;\n  color: var(--color1Alt3);\n  font-style: italic;\n  font-weight: var(--ltweight);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .hash[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  font-size: 1vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%]   .timestamp[_ngcontent-%COMP%] {\n  text-align: right;\n  font-size: 1vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap.invalid[_ngcontent-%COMP%]    > .signature[_ngcontent-%COMP%]    > .render[_ngcontent-%COMP%] {\n  background-color: rgba(var(--yellow-raw), 0.1);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#manualPayment[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  padding: 1vw 0;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.alternate[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  color: var(--color1);\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.success[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active {\n  background-color: var(--color3Alt4);\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.success {\n  background-color: var(--successAlt4);\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#manualPayment[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=manual-payment.component.css.map */"] });
var ManualPaymentComponent = _ManualPaymentComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ManualPaymentComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "manual-payment", template: `<div id="manualPayment">
  <header>
    <div class="primary">
      <h3>
        Record an External Payment
      </h3>
    </div>
    <div class="controls">
      <button class="control" [disabled]="makingPayment" (click)="closeView()">
        <i class="fa-solid fa-xmark"></i>
      </button>
    </div>
  </header>
  <div class="content">
    @if (showTip) {
      <div class="message warning">
        <p>
          {{tip}}
        </p>
      </div>
    }
    <div class="form">
      <div class="input-wrap" [class.invalid]="!amountValid">
        <label>Amount</label>
        <div class="input prominent">
          <currency-input
          (currencyOutput)="updateAmount($event)"></currency-input>
        </div>
        @if (!amountValid) {
          <p class="message">
            You must specify a payment amount.
          </p>
        }
      </div>
      <div class="input-wrap" [class.invalid]="!methodValid">
        <label>Payment Method</label>
        <div class="input">
          <select [(ngModel)]="selectedMethodId" (change)="updateMethod()">
            @for (method of methods; track method) {
              <option [ngValue]="method.id">
                {{method.name}}
              </option>
            }
          </select>
        </div>
        @if (!methodValid) {
          <p class="message">
            You must specify a payment method.
          </p>
        }
      </div>
      <div class="input-wrap" [class.invalid]="!signatureValid">
        <label>Signature</label>
        <p class="tip">
          By signing below, I attest that I have either personally collected
          the deposit amount listed above or confirmed financing approval
          and payment authorization.
        </p>
        <div class="signature" (click)="startSigning()">
          <div class="render">
            <canvas width="5" height="2"></canvas>
            @if (signature?.signature_B64 == null) {
              <p>
                Please Sign Here
              </p>
            }
            @if (signature?.signature_B64 != null) {
              <img [src]="signature!.signature_B64" />
            }
          </div>
          @if (signature != null) {
            <div class='hash'>
              {{signature.hash_SHA256}}
            </div>
            <div class='timestamp'>
              {{signature.timeStamp_Utc}}
            </div>
          }
        </div>
        @if (!signatureValid) {
          <p class="message">
            You must sign before you can record this external payment.
          </p>
        }
      </div>
    </div>
  </div>
  <div class="controls">
    <button class="control alternate" [disabled]="makingPayment" (click)="closeView()">
      <label>Cancel</label>
    </button>
    <button class="control" [disabled]="!canSubmitPayment" (click)="makePayment()">
      <label>Submit Payment</label>
    </button>
  </div>
</div>`, styles: ["/* src/app/shared/payments/components/manual-payment/manual-payment.component.scss */\n#manualPayment {\n  position: relative;\n}\n#manualPayment > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#manualPayment > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#manualPayment > header > .primary > h4 {\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#manualPayment > header > .controls > .control {\n  cursor: pointer;\n}\n#manualPayment > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#manualPayment > .content {\n  padding: 1vw;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#manualPayment > .content > .message {\n  margin-top: 0.5vw;\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.3vw 0.6vw;\n  pointer-events: none;\n}\n#manualPayment > .content > .message p {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#manualPayment > .content > .message.warning {\n  background-color: var(--color5Alt3);\n  border-color: var(--color5Alt4);\n}\n#manualPayment > .content > .form {\n  margin-top: 1vw;\n}\n#manualPayment > .content > .form > .input-wrap {\n  margin-top: 1vw;\n}\n#manualPayment > .content > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#manualPayment > .content > .form > .input-wrap > .tip {\n  margin-top: 0.25vw;\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--stdweight);\n}\n#manualPayment > .content > .form > .input-wrap > .input {\n  margin-top: 0.5vw;\n}\n#manualPayment > .content > .form > .input-wrap > .input input,\n#manualPayment > .content > .form > .input-wrap > .input ::ng-deep input,\n#manualPayment > .content > .form > .input-wrap > .input select,\n#manualPayment > .content > .form > .input-wrap > .input textarea {\n  display: block;\n  resize: none;\n  width: 100%;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 0.5vw;\n  background-color: var(--color2Alt1);\n  padding: 0.5vw 1vw;\n  color: var(--color3);\n  font-size: 3vw;\n  font-weight: var(--strong);\n  -moz-transition: border-color 0.2s linear;\n  -o-transition: border-color 0.2s linear;\n  -webkit-transition: border-color 0.2s linear;\n  transition: border-color 0.2s linear;\n  resize: none;\n}\n#manualPayment > .content > .form > .input-wrap > .input input:focus,\n#manualPayment > .content > .form > .input-wrap > .input ::ng-deep input:focus,\n#manualPayment > .content > .form > .input-wrap > .input select:focus,\n#manualPayment > .content > .form > .input-wrap > .input textarea:focus {\n  border-color: var(--color3);\n}\n#manualPayment > .content > .form > .input-wrap > .input.prominent input,\n#manualPayment > .content > .form > .input-wrap > .input.prominent ::ng-deep input,\n#manualPayment > .content > .form > .input-wrap > .input.prominent select,\n#manualPayment > .content > .form > .input-wrap > .input.prominent textarea {\n  font-size: 5vw;\n}\n#manualPayment > .content > .form > .input-wrap > .signature {\n  margin-top: 0.5vw;\n}\n#manualPayment > .content > .form > .input-wrap > .signature > .render {\n  position: relative;\n  border: 2px var(--color1) dotted;\n  border-radius: 0.5vw;\n  background-color: rgba(var(--success-raw), 0.1);\n  padding: 5px;\n  cursor: pointer;\n}\n#manualPayment > .content > .form > .input-wrap > .signature > .render canvas {\n  width: 100%;\n}\n#manualPayment > .content > .form > .input-wrap > .signature > .render p {\n  font-size: 3vw;\n  text-align: center;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  white-space: nowrap;\n  color: var(--color1Alt3);\n  font-style: italic;\n  font-weight: var(--ltweight);\n}\n#manualPayment > .content > .form > .input-wrap > .signature > .render img {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  -webkit-object-fit: contain;\n  -moz-object-fit: contain;\n  -o-background-size: contain;\n  object-fit: contain;\n}\n#manualPayment > .content > .form > .input-wrap > .signature > .render .hash {\n  margin-top: 0.25vw;\n  text-align: right;\n  -ms-text-overflow: ellipsis;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  font-size: 1vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n}\n#manualPayment > .content > .form > .input-wrap > .signature > .render .timestamp {\n  text-align: right;\n  font-size: 1vw;\n  color: var(--color1Alt1);\n  font-weight: var(--stdweight);\n  line-height: 1;\n  white-space: nowrap;\n}\n#manualPayment > .content > .form > .input-wrap.invalid > .signature > .render {\n  background-color: rgba(var(--yellow-raw), 0.1);\n}\n#manualPayment > .content > .form > .input-wrap > .message {\n  margin-top: 0.25vw;\n  text-align: right;\n  color: var(--error);\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n}\n#manualPayment > .content > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n#manualPayment > .controls {\n  padding: 1vw 0;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n}\n#manualPayment > .controls > .control {\n  position: relative;\n  margin-left: 1vw;\n  padding: 0.8vw 2vw;\n  border-radius: 1vw;\n  cursor: pointer;\n  margin-left: 1vw;\n  display: flex;\n  align-items: center;\n  background-color: var(--color3);\n  border: 0.1vw transparent solid;\n  -moz-transition: background-color 0.1s linear;\n  -o-transition: background-color 0.1s linear;\n  -webkit-transition: background-color 0.1s linear;\n  transition: background-color 0.1s linear;\n}\n#manualPayment > .controls > .control > label {\n  font-size: 1.2vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#manualPayment > .controls > .control.alternate {\n  background-color: var(--color2Alt1);\n  border-color: var(--color1);\n}\n#manualPayment > .controls > .control.alternate > label {\n  color: var(--color1);\n}\n#manualPayment > .controls > .control.success {\n  background-color: var(--success);\n}\n#manualPayment > .controls > .control[disabled] {\n  opacity: 0.6;\n  pointer-events: none;\n}\n#manualPayment > .controls > .control:active {\n  background-color: var(--color3Alt4);\n}\n#manualPayment > .controls > .control:active.success {\n  background-color: var(--successAlt4);\n}\n#manualPayment > .controls > .control:active.alternate {\n  background-color: var(--color2Alt2);\n}\n#manualPayment > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=manual-payment.component.css.map */\n"] }]
  }], () => [{ type: AuthRefService }, { type: DocumentService }, { type: PaymentsService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ManualPaymentComponent, { className: "ManualPaymentComponent", filePath: "src/app/shared/payments/components/manual-payment/manual-payment.component.ts", lineNumber: 28 });
})();

// src/app/shared/payments/components/external-lender/external-lender.component.ts
var _c02 = ["componentElm"];
var _ExternalLenderComponent = class _ExternalLenderComponent {
  constructor(paymentsService) {
    this.paymentsService = paymentsService;
  }
  // #region Lender
  get lenderUrl() {
    return this.paymentsService.externalLenderUrl;
  }
  closeView() {
    this.paymentsService.stopMakingManualPayment();
  }
  init() {
  }
  // #endregion
  ngOnInit() {
  }
  ngOnDestroy() {
  }
};
_ExternalLenderComponent.\u0275fac = function ExternalLenderComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ExternalLenderComponent)(\u0275\u0275directiveInject(PaymentsService));
};
_ExternalLenderComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ExternalLenderComponent, selectors: [["external-lender"]], viewQuery: function ExternalLenderComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, standalone: false, decls: 10, vars: 1, consts: [["id", "externalLender"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "content"], [3, "src"]], template: function ExternalLenderComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "header")(2, "div", 1)(3, "h3");
    \u0275\u0275text(4, " Applying for Financing ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 2)(6, "button", 3);
    \u0275\u0275listener("click", function ExternalLenderComponent_Template_button_click_6_listener() {
      return ctx.closeView();
    });
    \u0275\u0275element(7, "i", 4);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(8, "div", 5);
    \u0275\u0275element(9, "iframe", 6);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(9);
    \u0275\u0275property("src", ctx.lenderUrl, \u0275\u0275sanitizeResourceUrl);
  }
}, styles: ["\n\n#externalLender[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#externalLender[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#externalLender[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#externalLender[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%]    > .job[_ngcontent-%COMP%] {\n  color: var(--color5);\n}\n#externalLender[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#externalLender[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#externalLender[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  flex: 1;\n}\n#externalLender[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]   iframe[_ngcontent-%COMP%] {\n  height: 100%;\n  width: 100%;\n  border: none;\n}\n/*# sourceMappingURL=external-lender.component.css.map */"] });
var ExternalLenderComponent = _ExternalLenderComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ExternalLenderComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "external-lender", template: '<section id="externalLender">\n    <header>\n        <div class="primary">\n            <h3>\n                Applying for Financing\n            </h3>\n        </div>\n        <div class="controls">\n            <button class="control" (click)="closeView()">\n                <i class="fa-solid fa-xmark"></i>\n            </button>\n        </div>\n    </header>\n\n    <div class="content">\n        <iframe [src]="lenderUrl"></iframe>\n    </div>\n</section>', styles: ["/* src/app/shared/payments/components/external-lender/external-lender.component.scss */\n#externalLender {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n#externalLender > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#externalLender > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#externalLender > header > .primary > h3 > .job {\n  color: var(--color5);\n}\n#externalLender > header > .controls > .control {\n  cursor: pointer;\n}\n#externalLender > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#externalLender > .content {\n  flex: 1;\n}\n#externalLender > .content iframe {\n  height: 100%;\n  width: 100%;\n  border: none;\n}\n/*# sourceMappingURL=external-lender.component.css.map */\n"] }]
  }], () => [{ type: PaymentsService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ExternalLenderComponent, { className: "ExternalLenderComponent", filePath: "src/app/shared/payments/components/external-lender/external-lender.component.ts", lineNumber: 24 });
})();

// src/app/main/components/side-nav/components/layout/layout.component.ts
function SideNavLayoutComponent_Conditional_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Conditional_9_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r1);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.goToDashboard(["team"]));
    });
    \u0275\u0275elementStart(1, "span", 4);
    \u0275\u0275element(2, "i", 13);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "label");
    \u0275\u0275text(4, " My Team ");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275classProp("active", ctx_r1.rgmRouteActive);
  }
}
function SideNavLayoutComponent_Conditional_28_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 2)(1, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Conditional_28_Template_button_click_1_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.goToAdmin(["appointments", "manage"]));
    });
    \u0275\u0275elementStart(2, "span", 4);
    \u0275\u0275element(3, "i", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(4, "label");
    \u0275\u0275text(5, " Appointment Management ");
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx_r1.appointmentManagementRouteActive);
  }
}
var _SideNavLayoutComponent = class _SideNavLayoutComponent {
  constructor(appService, authRefService, authService, sideNavService, router, uiService) {
    this.appService = appService;
    this.authRefService = authRefService;
    this.authService = authService;
    this.sideNavService = sideNavService;
    this.router = router;
    this.uiService = uiService;
    this.activeUser = null;
  }
  // #region App
  get version() {
    return environment.APP_VERSION;
  }
  updateApp() {
    return __async(this, null, function* () {
      if (Capacitor.isNativePlatform()) {
        const update = yield this.appService.checkNativeUpdate();
        if (update != null) {
          this.uiService.prompt("New App Version Available", "There is a new app version available. Do you want to update now?", "Yes", "No").subscribe({
            next: (confirmed) => {
              if (confirmed) {
                window.location.reload();
              }
            }
          });
        }
      } else {
        window.location.reload();
      }
    });
  }
  // #endregion
  // #region Training
  goToTraining() {
    this.sideNavService.goToTraining();
  }
  // #endregion
  // #region Reporting
  get reportingRouteActive() {
    return this.sideNavService.activeRoute?.type == "Reporting";
  }
  goToReporting() {
    this.sideNavService.goToRoute("Reporting");
    this.sideNavService.close();
  }
  // #endregion
  // #region Dashboard
  goToDashboard(params) {
    this.sideNavService.goToRoute("Dashboard", [params[0]]);
    this.sideNavService.close();
  }
  get dashboardRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Dashboard" && params[0] == "today";
    }
    return false;
  }
  get rgmRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Dashboard" && params[0] == "team";
    }
    return false;
  }
  get calendarRouteActive() {
    return this.sideNavService.activeRoute?.type == "Calendar";
  }
  goToCalendar() {
    this.sideNavService.goToRoute("Calendar");
    this.sideNavService.close();
  }
  // #endregion
  // #region Presentation
  get presentationRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Presentation";
    }
    return false;
  }
  goToPresentation() {
    this.sideNavService.goToRoute("Presentation");
    this.sideNavService.close();
  }
  // #endregion
  // #region Appointments
  get bookOfBusinessRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "BookOfBusiness";
    }
    return false;
  }
  goToBookOfBusiness() {
    this.sideNavService.goToRoute("BookOfBusiness");
    this.sideNavService.close();
  }
  // #endregion
  // #region Administration
  get showAdministrationRoutes() {
    return this.activeUser != null && (this.activeUser.emailAddress == "jeffrey.wilbur@repipespecialists.com" || this.activeUser.emailAddress == "tara.caso@repipespecialists.com" || this.activeUser.emailAddress == "tj.dean@repipespecialists.com");
  }
  get fixturesRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Administration" && params[0] == "entities" && params[1] == "fixtures";
    }
    return false;
  }
  get attributesRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Administration" && params[0] == "entities" && params[1] == "attributes";
    }
    return false;
  }
  get systemLogsRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Administration" && params[0] == "system" && params[1] == "logs";
    }
    return false;
  }
  get systemQueryRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Administration" && params[0] == "system" && params[1] == "query";
    }
    return false;
  }
  get appointmentManagementRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Administration" && params[0] == "appointments" && params[1] == "manage";
    }
    return false;
  }
  get netsuiteSyncRouteActive() {
    const route = this.sideNavService.activeRoute;
    if (route != null) {
      const params = route.params.getValue();
      return route.type == "Administration" && params[0] == "netsuite" && params[1] == "settings";
    }
    return false;
  }
  goToAdmin(params) {
    this.sideNavService.goToRoute("Administration", [params[0], params[1]]);
    this.sideNavService.close();
  }
  // #endregion
  // #region Sync
  manageSync() {
    this.sideNavService.close();
  }
  // #endregion
  // #region App Routes
  goToRoute(route) {
    this.router.navigate([route]);
  }
  get isManager() {
    return this.activeUser?.isManager ?? false;
  }
  watchAuth() {
    this.authSubscription = this.authRefService.user.subscribe({
      next: (user) => {
        this.activeUser = user;
      }
    });
  }
  logout() {
    this.uiService.prompt("Sign Out?", "Are you sure you want to sign out of In-Home Selling?", "Yes", "No").subscribe({
      next: (confirmed) => {
        if (confirmed) {
          this.authService.logout();
        }
      }
    });
  }
  // #endregion
  // #region Bootstrapping
  get active() {
    return this.sideNavService.active;
  }
  toggleSideNav() {
    this.sideNavService.toggleActive();
  }
  init() {
    this.watchAuth();
  }
  close() {
    this.sideNavService.close();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.authSubscription?.unsubscribe();
  }
};
_SideNavLayoutComponent.\u0275fac = function SideNavLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SideNavLayoutComponent)(\u0275\u0275directiveInject(AppService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(AuthService), \u0275\u0275directiveInject(SideNavService), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(UiService));
};
_SideNavLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SideNavLayoutComponent, selectors: [["side-nav"]], standalone: false, decls: 44, vars: 15, consts: [["id", "sideNav"], [1, "island"], [1, "routes"], [1, "route", 3, "click"], [1, "icon"], [1, "fa-duotone", "fa-solid", "fa-calendar"], [1, "route", 3, "active"], [1, "fa-duotone", "fa-solid", "fa-book"], [1, "fa-duotone", "fa-chart-sine"], [1, "fa-solid", "fa-tv"], [1, "fa-solid", "fa-books"], [1, "fa-solid", "fa-person-walking-dashed-line-arrow-right"], [1, "version", 3, "click"], [1, "fa-duotone", "fa-solid", "fa-people-group"], [1, "fa-duotone", "fa-calendars"]], template: function SideNavLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 0);
    \u0275\u0275pipe(1, "async");
    \u0275\u0275elementStart(2, "div", 1)(3, "div", 2)(4, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_4_listener() {
      return ctx.goToDashboard(["today"]);
    });
    \u0275\u0275elementStart(5, "span", 4);
    \u0275\u0275element(6, "i", 5);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(7, "label");
    \u0275\u0275text(8, " Dashboard ");
    \u0275\u0275elementEnd()();
    \u0275\u0275conditionalCreate(9, SideNavLayoutComponent_Conditional_9_Template, 5, 2, "button", 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "div", 2)(11, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_11_listener() {
      return ctx.goToBookOfBusiness();
    });
    \u0275\u0275elementStart(12, "span", 4);
    \u0275\u0275element(13, "i", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "label");
    \u0275\u0275text(15, " Book of Business ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(16, "div", 2)(17, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_17_listener() {
      return ctx.goToReporting();
    });
    \u0275\u0275elementStart(18, "span", 4);
    \u0275\u0275element(19, "i", 8);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(20, "label");
    \u0275\u0275text(21, " Commissions Preview ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(22, "div", 2)(23, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_23_listener() {
      return ctx.goToPresentation();
    });
    \u0275\u0275elementStart(24, "span", 4);
    \u0275\u0275element(25, "i", 9);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "label");
    \u0275\u0275text(27, " My Presentation ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(28, SideNavLayoutComponent_Conditional_28_Template, 6, 2, "div", 2);
    \u0275\u0275elementStart(29, "div", 2)(30, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_30_listener() {
      return ctx.goToTraining();
    });
    \u0275\u0275elementStart(31, "span", 4);
    \u0275\u0275element(32, "i", 10);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(33, "label");
    \u0275\u0275text(34, " The Repipe Selling Way ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(35, "div", 2)(36, "button", 3);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_36_listener() {
      return ctx.logout();
    });
    \u0275\u0275elementStart(37, "span", 4);
    \u0275\u0275element(38, "i", 11);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(39, "label");
    \u0275\u0275text(40, " Sign Out ");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(41, "footer")(42, "button", 12);
    \u0275\u0275listener("click", function SideNavLayoutComponent_Template_button_click_42_listener() {
      return ctx.updateApp();
    });
    \u0275\u0275text(43);
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    \u0275\u0275classProp("active", \u0275\u0275pipeBind1(1, 13, ctx.active));
    \u0275\u0275advance(4);
    \u0275\u0275classProp("active", ctx.dashboardRouteActive);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx.isManager ? 9 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("active", ctx.bookOfBusinessRouteActive);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx.reportingRouteActive);
    \u0275\u0275advance(6);
    \u0275\u0275classProp("active", ctx.presentationRouteActive);
    \u0275\u0275advance(5);
    \u0275\u0275conditional(ctx.showAdministrationRoutes ? 28 : -1);
    \u0275\u0275advance(15);
    \u0275\u0275textInterpolate1(" ", ctx.version, " ");
  }
}, dependencies: [AsyncPipe], styles: ["\n\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  position: fixed;\n  z-index: var(--sideNav-layer);\n  top: calc(1.5vw + var(--systemOffset-top));\n  left: 2vw;\n  background-color: var(--color2);\n  padding: 3vw 0 1vw;\n  border-radius: 999px;\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%] {\n  display: flex;\n  padding: 1vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  cursor: pointer;\n  position: relative;\n  margin-top: 1vw;\n  display: flex;\n  width: 100%;\n  align-items: center;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  display: block;\n  position: relative;\n  height: 4.2vw;\n  width: 4.2vw;\n  background-color: var(--color2);\n  border-radius: 100%;\n  -moz-transition: border-color 0.2s, background-color 0.2s;\n  -o-transition: border-color 0.2s, background-color 0.2s;\n  -webkit-transition: border-color 0.2s, background-color 0.2s;\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  color: var(--color1Alt1);\n  font-size: 2vw;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 100%;\n  margin-left: 2vw;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color2);\n  white-space: nowrap;\n  display: block;\n  -moz-transform: scale(0) translateY(-50%);\n  -ms-transform: scale(0) translateY(-50%);\n  -o-transform: scale(0) translateY(-50%);\n  -webkit-transform: scale(0) translateY(-50%);\n  transform: scale(0) translateY(-50%);\n  -moz-transform-origin: left center;\n  -ms-transform-origin: left center;\n  -o-transform-origin: left center;\n  -webkit-transform-origin: left center;\n  transform-origin: left center;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.active[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.active[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  color: var(--color3Alt1);\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]:first-child {\n  border-top: none;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%] {\n  padding: 0 1vw;\n}\n#sideNav[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > footer[_ngcontent-%COMP%]    > .version[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  text-align: center;\n  font-size: 0.8vw;\n  color: var(--color2Alt4);\n  font-weight: var(--ltweight);\n  text-transform: uppercase;\n}\n#sideNav.active[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%] {\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#sideNav.active[_ngcontent-%COMP%]    > .island[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  -moz-transform: scale(1) translateY(-50%);\n  -ms-transform: scale(1) translateY(-50%);\n  -o-transform: scale(1) translateY(-50%);\n  -webkit-transform: scale(1) translateY(-50%);\n  transform: scale(1) translateY(-50%);\n  -moz-transition: transform 0.5s 0.3s;\n  -o-transition: transform 0.5s 0.3s;\n  -webkit-transition: transform 0.5s 0.3s;\n  transition: transform 0.5s 0.3s;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var SideNavLayoutComponent = _SideNavLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SideNavLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "side-nav", template: `<aside id="sideNav" [class.active]="active | async">
  <div class="island">
    <div class="routes">
      <button class="route"
        [class.active]="dashboardRouteActive"
        (click)="goToDashboard(['today'])">
        <span class="icon">
          <i class="fa-duotone fa-solid fa-calendar"></i>
        </span>
        <label>
          Dashboard
        </label>
      </button>
      @if (isManager) {
        <button class="route"
          [class.active]="rgmRouteActive"
          (click)="goToDashboard(['team'])">
          <span class="icon">
            <i class="fa-duotone fa-solid fa-people-group"></i>
          </span>
          <label>
            My Team
          </label>
        </button>
      }
    </div>
    <div class="routes">
      <button class="route"
        [class.active]="bookOfBusinessRouteActive"
        (click)="goToBookOfBusiness()">
        <span class="icon">
          <i class="fa-duotone fa-solid fa-book"></i>
        </span>
        <label>
          Book of Business
        </label>
      </button>
    </div>
    <div class="routes">
      <button class="route"
        [class.active]="reportingRouteActive"
        (click)="goToReporting()">
        <span class="icon">
          <i class="fa-duotone fa-chart-sine"></i>
        </span>
        <label>
          Commissions Preview
        </label>
      </button>
    </div>
    <div class="routes">
      <button class="route"
        [class.active]="presentationRouteActive"
        (click)="goToPresentation()">
        <span class="icon">
          <i class="fa-solid fa-tv"></i>
        </span>
        <label>
          My Presentation
        </label>
      </button>
    </div>
    @if (showAdministrationRoutes) {
      <div class="routes">
        <button class="route"
          [class.active]="appointmentManagementRouteActive"
          (click)="goToAdmin(['appointments','manage'])">
          <span class="icon">
            <i class="fa-duotone fa-calendars"></i>
          </span>
          <label>
            Appointment Management
          </label>
        </button>
      </div>
    }
    <div class="routes">
      <button class="route" (click)="goToTraining()">
        <span class="icon">
          <i class="fa-solid fa-books"></i>
        </span>
        <label>
          The Repipe Selling Way
        </label>
      </button>
    </div>
    <div class="routes">
      <button class="route" (click)="logout()">
        <span class="icon">
          <i class="fa-solid fa-person-walking-dashed-line-arrow-right"></i>
        </span>
        <label>
          Sign Out
        </label>
      </button>
    </div>

    <footer>
      <button class="version" (click)="updateApp()">
        {{version}}
      </button>
    </footer>
  </div>
</aside>`, styles: ["/* src/app/main/components/side-nav/components/layout/layout.component.scss */\n#sideNav > .island {\n  position: fixed;\n  z-index: var(--sideNav-layer);\n  top: calc(1.5vw + var(--systemOffset-top));\n  left: 2vw;\n  background-color: var(--color2);\n  padding: 3vw 0 1vw;\n  border-radius: 999px;\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: scale(0);\n  -ms-transform: scale(0);\n  -o-transform: scale(0);\n  -webkit-transform: scale(0);\n  transform: scale(0);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n}\n#sideNav > .island > .routes {\n  display: flex;\n  padding: 1vw;\n  display: flex;\n  flex-direction: column;\n  align-items: flex-start;\n  border-top: 0.1vw var(--color2Alt2) solid;\n}\n#sideNav > .island > .routes > .route {\n  cursor: pointer;\n  position: relative;\n  margin-top: 1vw;\n  display: flex;\n  width: 100%;\n  align-items: center;\n}\n#sideNav > .island > .routes > .route > .icon {\n  display: block;\n  position: relative;\n  height: 4.2vw;\n  width: 4.2vw;\n  background-color: var(--color2);\n  border-radius: 100%;\n  -moz-transition: border-color 0.2s, background-color 0.2s;\n  -o-transition: border-color 0.2s, background-color 0.2s;\n  -webkit-transition: border-color 0.2s, background-color 0.2s;\n  transition: border-color 0.2s, background-color 0.2s;\n}\n#sideNav > .island > .routes > .route > .icon i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  color: var(--color1Alt1);\n  font-size: 2vw;\n}\n#sideNav > .island > .routes > .route > label {\n  position: absolute;\n  top: 50%;\n  left: 100%;\n  margin-left: 2vw;\n  font-size: 1.4vw;\n  font-weight: var(--strong);\n  color: var(--color2);\n  white-space: nowrap;\n  display: block;\n  -moz-transform: scale(0) translateY(-50%);\n  -ms-transform: scale(0) translateY(-50%);\n  -o-transform: scale(0) translateY(-50%);\n  -webkit-transform: scale(0) translateY(-50%);\n  transform: scale(0) translateY(-50%);\n  -moz-transform-origin: left center;\n  -ms-transform-origin: left center;\n  -o-transform-origin: left center;\n  -webkit-transform-origin: left center;\n  transform-origin: left center;\n}\n#sideNav > .island > .routes > .route.active > .icon {\n  background-color: rgba(var(--color3-raw), 0.2);\n}\n#sideNav > .island > .routes > .route.active > .icon > i {\n  color: var(--color3Alt1);\n}\n#sideNav > .island > .routes > .route:first-child {\n  margin-top: 0;\n}\n#sideNav > .island > .routes:first-child {\n  border-top: none;\n}\n#sideNav > .island > footer {\n  padding: 0 1vw;\n}\n#sideNav > .island > footer > .version {\n  display: block;\n  width: 100%;\n  text-align: center;\n  font-size: 0.8vw;\n  color: var(--color2Alt4);\n  font-weight: var(--ltweight);\n  text-transform: uppercase;\n}\n#sideNav.active > .island {\n  -moz-transform: scale(1);\n  -ms-transform: scale(1);\n  -o-transform: scale(1);\n  -webkit-transform: scale(1);\n  transform: scale(1);\n}\n#sideNav.active > .island > .routes > .route > label {\n  -moz-transform: scale(1) translateY(-50%);\n  -ms-transform: scale(1) translateY(-50%);\n  -o-transform: scale(1) translateY(-50%);\n  -webkit-transform: scale(1) translateY(-50%);\n  transform: scale(1) translateY(-50%);\n  -moz-transition: transform 0.5s 0.3s;\n  -o-transition: transform 0.5s 0.3s;\n  -webkit-transition: transform 0.5s 0.3s;\n  transition: transform 0.5s 0.3s;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: AppService }, { type: AuthRefService }, { type: AuthService }, { type: SideNavService }, { type: Router }, { type: UiService }], null);
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SideNavLayoutComponent, { className: "SideNavLayoutComponent", filePath: "src/app/main/components/side-nav/components/layout/layout.component.ts", lineNumber: 27 });
})();

// src/app/main/components/training/training.component.ts
var _c03 = ["componentElm"];
var _TrainingComponent = class _TrainingComponent {
  constructor(sanitizer) {
    this.sanitizer = sanitizer;
    this.trainingSrc = this.sanitizer.bypassSecurityTrustResourceUrl("https://dev.training.repipe.cloud");
  }
  init() {
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_TrainingComponent.\u0275fac = function TrainingComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _TrainingComponent)(\u0275\u0275directiveInject(DomSanitizer));
};
_TrainingComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _TrainingComponent, selectors: [["training"]], viewQuery: function TrainingComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, standalone: false, decls: 2, vars: 1, consts: [["id", "training"], [3, "src"]], template: function TrainingComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0);
    \u0275\u0275element(1, "iframe", 1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("src", ctx.trainingSrc, \u0275\u0275sanitizeResourceUrl);
  }
}, styles: ["\n\n#training[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#training[_ngcontent-%COMP%]   iframe[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n  border: none;\n}\n/*# sourceMappingURL=training.component.css.map */"] });
var TrainingComponent = _TrainingComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(TrainingComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "training", template: '<section id="training">\n    <iframe [src]="trainingSrc"></iframe>\n</section>', styles: ["/* src/app/main/components/training/training.component.scss */\n#training {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n#training iframe {\n  width: 100%;\n  height: 100%;\n  border: none;\n}\n/*# sourceMappingURL=training.component.css.map */\n"] }]
  }], () => [{ type: DomSanitizer }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(TrainingComponent, { className: "TrainingComponent", filePath: "src/app/main/components/training/training.component.ts", lineNumber: 21 });
})();

// src/app/main/components/opportunity-modules/opportunity-modules.component.ts
var _c04 = ["componentElm"];
function OpportunityModulesComponent_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "opportunity-details", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.detailsOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "estimate-submission", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.estimateOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "opportunity-payments", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.paymentsOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "send-for-signing", 11);
    \u0275\u0275listener("close", function OpportunityModulesComponent_Conditional_11_Template_send_for_signing_close_0_listener() {
      \u0275\u0275restoreView(_r2);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.stopSendingDocuments());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.sendingDocumentsOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_14_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "opportunity-ledger", 11);
    \u0275\u0275listener("close", function OpportunityModulesComponent_Conditional_14_Template_opportunity_ledger_close_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.stopViewingLedger());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.ledgerOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_17_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "send-quote", 11);
    \u0275\u0275listener("close", function OpportunityModulesComponent_Conditional_17_Template_send_quote_close_0_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.stopSendingQuote());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.sendingQuoteOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_20_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "send-executed-documents", 11);
    \u0275\u0275listener("close", function OpportunityModulesComponent_Conditional_20_Template_send_executed_documents_close_0_listener() {
      \u0275\u0275restoreView(_r5);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.stopSendingExecutedDocuments());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("opportunity", ctx_r0.sendingExecutedDocumentsOpportunity);
  }
}
function OpportunityModulesComponent_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "opportunity-signing", 10);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("signer", ctx_r0.signerName)("customerFacing", ctx_r0.onlySigningCustomerFacingDocuments)("opportunity", ctx_r0.documentsAppointment);
  }
}
var _OpportunityModulesComponent = class _OpportunityModulesComponent {
  constructor(opportunityUiService) {
    this.opportunityUiService = opportunityUiService;
    this.sendingDocuments = false;
    this.closingSendDocuments = false;
    this.sendingExecutedDocuments = false;
    this.closingSendExecutedDocuments = false;
    this.sendingQuote = false;
    this.closingSendQuote = false;
    this.signingDocuments = false;
    this.onlySigningCustomerFacingDocuments = false;
    this.closingDocuments = false;
    this.viewingDetails = false;
    this.closingDetails = false;
    this.preparingEstimate = false;
    this.closingEstimate = false;
    this.managingPayments = false;
    this.closingPayments = false;
    this.viewingLedger = false;
    this.closingLedger = false;
  }
  stopSendingDocuments() {
    window.clearTimeout(this.sendingDocumentsTimer);
    this.closingSendDocuments = true;
    this.sendingDocumentsTimer = window.setTimeout(() => {
      this.sendingDocuments = false;
      this.closingSendDocuments = false;
      this.sendingDocumentsOpportunity = void 0;
    }, 250);
  }
  startSendingDocuments() {
    window.clearTimeout(this.sendingDocumentsTimer);
    this.closingSendDocuments = false;
    this.sendingDocuments = true;
  }
  watchSendingDocuments() {
    this.sendingDocumentsSubscription = this.opportunityUiService.sendingDocuments.subscribe({
      next: (result) => {
        if (result != null) {
          this.sendingDocumentsOpportunity = result;
          setTimeout(() => {
            this.startSendingDocuments();
          }, 0);
        } else {
          this.stopSendingDocuments();
        }
      }
    });
  }
  stopSendingExecutedDocuments() {
    window.clearTimeout(this.sendingExecutedDocumentsTimer);
    this.closingSendExecutedDocuments = true;
    this.sendingExecutedDocumentsTimer = window.setTimeout(() => {
      this.sendingExecutedDocuments = false;
      this.closingSendExecutedDocuments = false;
      this.sendingExecutedDocumentsOpportunity = void 0;
    }, 250);
  }
  startSendingExecutedDocuments() {
    window.clearTimeout(this.sendingExecutedDocumentsTimer);
    this.closingSendExecutedDocuments = false;
    this.sendingExecutedDocuments = true;
  }
  watchSendingExecutedDocuments() {
    this.sendingExecutedDocumentsSubscription = this.opportunityUiService.sendingExecutedDocuments.subscribe({
      next: (result) => {
        if (result != null) {
          this.sendingExecutedDocumentsOpportunity = result;
          setTimeout(() => {
            this.startSendingExecutedDocuments();
          }, 0);
        } else {
          this.stopSendingExecutedDocuments();
        }
      }
    });
  }
  stopSendingQuote() {
    window.clearTimeout(this.sendingQuoteTimer);
    this.closingSendQuote = true;
    this.sendingQuoteTimer = window.setTimeout(() => {
      this.sendingQuote = false;
      this.closingSendQuote = false;
      this.sendingQuoteOpportunity = void 0;
    }, 250);
  }
  startSendingQuote() {
    window.clearTimeout(this.sendingQuoteTimer);
    this.closingSendQuote = false;
    this.sendingQuote = true;
  }
  watchQuote() {
    this.sendingQuoteSubscription = this.opportunityUiService.sendingForQuote.subscribe({
      next: (result) => {
        if (result != null) {
          this.sendingQuoteOpportunity = result;
          setTimeout(() => {
            this.startSendingQuote();
          }, 0);
        } else {
          this.stopSendingQuote();
        }
      }
    });
  }
  stopSigningDocuments() {
    window.clearTimeout(this.documentsTimer);
    this.closingDocuments = true;
    this.documentsTimer = window.setTimeout(() => {
      this.signingDocuments = false;
      this.closingDocuments = false;
      this.signerName = void 0;
      this.onlySigningCustomerFacingDocuments = false;
      this.documentsAppointment = void 0;
    }, 250);
  }
  startSigningDocuments() {
    window.clearTimeout(this.documentsTimer);
    this.closingDocuments = false;
    this.signingDocuments = true;
  }
  watchSigningDocuments() {
    this.documentsSubscription = this.opportunityUiService.signingDocuments.subscribe({
      next: (result) => {
        if (result?.opportunity != null) {
          this.documentsAppointment = result.opportunity;
          this.onlySigningCustomerFacingDocuments = result.onlyCustomerFacing;
          this.signerName = result.signer;
          setTimeout(() => {
            this.startSigningDocuments();
          }, 0);
        } else {
          this.stopSigningDocuments();
        }
      }
    });
  }
  stopViewingDetails() {
    window.clearTimeout(this.detailsTimer);
    this.closingDetails = true;
    this.detailsTimer = window.setTimeout(() => {
      this.viewingDetails = false;
      this.closingDetails = false;
      this.detailsOpportunity = void 0;
    }, 250);
  }
  startViewingDetails() {
    window.clearTimeout(this.detailsTimer);
    this.closingDetails = false;
    this.viewingDetails = true;
  }
  watchDetails() {
    this.detailsSubscription = this.opportunityUiService.viewingDetails.subscribe({
      next: (opportunity) => {
        if (opportunity != null) {
          this.detailsOpportunity = opportunity;
          this.startViewingDetails();
        } else {
          this.stopViewingDetails();
        }
      }
    });
  }
  stopPreparingEstimate() {
    window.clearTimeout(this.estimateTimer);
    this.closingEstimate = true;
    this.estimateTimer = window.setTimeout(() => {
      this.preparingEstimate = false;
      this.closingEstimate = false;
      this.estimateOpportunity = void 0;
    }, 250);
  }
  startPreparingEstimate() {
    window.clearTimeout(this.estimateTimer);
    this.closingEstimate = false;
    this.preparingEstimate = true;
  }
  watchPreparingEstimate() {
    this.estimateSubscription = this.opportunityUiService.preparingEstimate.subscribe({
      next: (opportunity) => {
        if (opportunity != null) {
          this.estimateOpportunity = opportunity;
          this.startPreparingEstimate();
        } else {
          this.stopPreparingEstimate();
        }
      }
    });
  }
  stopManagingPayments() {
    window.clearTimeout(this.paymentsTimer);
    this.closingPayments = true;
    this.paymentsTimer = window.setTimeout(() => {
      this.managingPayments = false;
      this.closingPayments = false;
      this.paymentsOpportunity = void 0;
    }, 250);
  }
  startManagingPayments() {
    window.clearTimeout(this.paymentsTimer);
    this.closingPayments = false;
    this.managingPayments = true;
  }
  watchPayments() {
    this.paymentsSubscription = this.opportunityUiService.managingPayments.subscribe({
      next: (opportunity) => {
        if (opportunity != null) {
          this.paymentsOpportunity = opportunity;
          this.startManagingPayments();
        } else {
          this.stopManagingPayments();
        }
      }
    });
  }
  stopViewingLedger() {
    window.clearTimeout(this.ledgerTimer);
    this.closingLedger = true;
    this.ledgerTimer = window.setTimeout(() => {
      this.viewingLedger = false;
      this.closingLedger = false;
      this.ledgerOpportunity = void 0;
    }, 250);
  }
  startViewingLedger() {
    window.clearTimeout(this.ledgerTimer);
    this.closingLedger = false;
    this.viewingLedger = true;
  }
  watchLedger() {
    this.ledgerSubscription = this.opportunityUiService.viewingLedger.subscribe({
      next: (opportunity) => {
        if (opportunity != null) {
          this.ledgerOpportunity = opportunity;
          this.startViewingLedger();
        } else {
          this.stopViewingLedger();
        }
      }
    });
  }
  init() {
    this.watchPreparingEstimate();
    this.watchPayments();
    this.watchSigningDocuments();
    this.watchSendingDocuments();
    this.watchQuote();
    this.watchSendingExecutedDocuments();
    this.watchDetails();
    this.watchLedger();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.estimateSubscription?.unsubscribe();
    this.documentsSubscription?.unsubscribe();
    this.sendingDocumentsSubscription?.unsubscribe();
    this.paymentsSubscription?.unsubscribe();
    this.sendingQuoteSubscription?.unsubscribe();
    this.sendingExecutedDocumentsSubscription?.unsubscribe();
    this.detailsSubscription?.unsubscribe();
    this.ledgerSubscription?.unsubscribe();
  }
};
_OpportunityModulesComponent.\u0275fac = function OpportunityModulesComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _OpportunityModulesComponent)(\u0275\u0275directiveInject(OpportunityUiService));
};
_OpportunityModulesComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _OpportunityModulesComponent, selectors: [["opportunity-modules"]], viewQuery: function OpportunityModulesComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, standalone: false, decls: 24, vars: 40, consts: [["id", "details"], [1, "bg"], [3, "opportunity"], ["id", "preparingEstimate"], ["id", "managingPayments"], ["id", "sendDocuments"], ["id", "ledger"], ["id", "sendingQuote"], ["id", "sendingExecutedDocuments"], ["id", "signing"], [3, "signer", "customerFacing", "opportunity"], [3, "close", "opportunity"]], template: function OpportunityModulesComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "aside", 0);
    \u0275\u0275element(1, "div", 1);
    \u0275\u0275conditionalCreate(2, OpportunityModulesComponent_Conditional_2_Template, 1, 1, "opportunity-details", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "aside", 3);
    \u0275\u0275element(4, "div", 1);
    \u0275\u0275conditionalCreate(5, OpportunityModulesComponent_Conditional_5_Template, 1, 1, "estimate-submission", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "aside", 4);
    \u0275\u0275element(7, "div", 1);
    \u0275\u0275conditionalCreate(8, OpportunityModulesComponent_Conditional_8_Template, 1, 1, "opportunity-payments", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "aside", 5);
    \u0275\u0275element(10, "div", 1);
    \u0275\u0275conditionalCreate(11, OpportunityModulesComponent_Conditional_11_Template, 1, 1, "send-for-signing", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "aside", 6);
    \u0275\u0275element(13, "div", 1);
    \u0275\u0275conditionalCreate(14, OpportunityModulesComponent_Conditional_14_Template, 1, 1, "opportunity-ledger", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(15, "aside", 7);
    \u0275\u0275element(16, "div", 1);
    \u0275\u0275conditionalCreate(17, OpportunityModulesComponent_Conditional_17_Template, 1, 1, "send-quote", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "aside", 8);
    \u0275\u0275element(19, "div", 1);
    \u0275\u0275conditionalCreate(20, OpportunityModulesComponent_Conditional_20_Template, 1, 1, "send-executed-documents", 2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(21, "aside", 9);
    \u0275\u0275element(22, "div", 1);
    \u0275\u0275conditionalCreate(23, OpportunityModulesComponent_Conditional_23_Template, 1, 3, "opportunity-signing", 10);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275classProp("active", ctx.viewingDetails)("closing", ctx.closingDetails);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.viewingDetails ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.preparingEstimate)("closing", ctx.closingEstimate);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.preparingEstimate ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.managingPayments)("closing", ctx.closingPayments);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.managingPayments ? 8 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.sendingDocuments)("closing", ctx.closingSendDocuments);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.sendingDocuments ? 11 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.viewingLedger)("closing", ctx.closingLedger);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.viewingLedger ? 14 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.sendingQuote)("closing", ctx.closingSendQuote);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.sendingQuote ? 17 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.sendingExecutedDocuments)("closing", ctx.closingSendExecutedDocuments);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.sendingExecutedDocuments ? 20 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.signingDocuments)("closing", ctx.closingDocuments);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.signingDocuments ? 23 : -1);
  }
}, dependencies: [EstimateSubmissionComponent, OpportunitySigningComponent, OpportunityPaymentsComponent, SendDocumentsForSigningComponent, SendQuoteComponent, SendExecutedDocumentsComponent, OpportunityDetailsComponent, OpportunityLedgerComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#details[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#details[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#details[_ngcontent-%COMP%]    > opportunity-details[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#details.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#details.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#details.active[_ngcontent-%COMP%]    > opportunity-details[_ngcontent-%COMP%] {\n  -moz-animation-name: detailsLoadIn;\n  -ms-animation-name: detailsLoadIn;\n  -o-animation-name: detailsLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_detailsLoadIn;\n  animation-name: _ngcontent-%COMP%_detailsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#details.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#details.closing[_ngcontent-%COMP%]    > opportunity-details[_ngcontent-%COMP%] {\n  -moz-animation-name: detailsLoadOut;\n  -ms-animation-name: detailsLoadOut;\n  -o-animation-name: detailsLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_detailsLoadOut;\n  animation-name: _ngcontent-%COMP%_detailsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n@-webkit-keyframes _ngcontent-%COMP%_estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#preparingEstimate[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#preparingEstimate[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#preparingEstimate[_ngcontent-%COMP%]    > estimate-submission[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 4);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#preparingEstimate.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#preparingEstimate.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#preparingEstimate.active[_ngcontent-%COMP%]    > estimate-submission[_ngcontent-%COMP%] {\n  -moz-animation-name: estimateLoadIn;\n  -ms-animation-name: estimateLoadIn;\n  -o-animation-name: estimateLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_estimateLoadIn;\n  animation-name: _ngcontent-%COMP%_estimateLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#preparingEstimate.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#preparingEstimate.closing[_ngcontent-%COMP%]    > estimate-submission[_ngcontent-%COMP%] {\n  -moz-animation-name: estimateLoadOut;\n  -ms-animation-name: estimateLoadOut;\n  -o-animation-name: estimateLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_estimateLoadOut;\n  animation-name: _ngcontent-%COMP%_estimateLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#managingPayments[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#managingPayments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#managingPayments[_ngcontent-%COMP%]    > opportunity-payments[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 90vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#managingPayments.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#managingPayments.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#managingPayments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#managingPayments.closing[_ngcontent-%COMP%]    > opportunity-payments[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-o-keyframes documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-o-keyframes documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@keyframes _ngcontent-%COMP%_documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n#sendingExecutedDocuments[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#sendingExecutedDocuments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#sendingExecutedDocuments[_ngcontent-%COMP%]    > send-executed-documents[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 98vw;\n  height: 98vh;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#sendingExecutedDocuments.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#sendingExecutedDocuments.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#sendingExecutedDocuments.active[_ngcontent-%COMP%]    > send-executed-documents[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingExecutedDocuments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#sendingExecutedDocuments.closing[_ngcontent-%COMP%]    > send-executed-documents[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#sendingQuote[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#sendingQuote[_ngcontent-%COMP%]    > send-quote[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 98vw;\n  height: 98vh;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  -moz-transform: translate(-50%, -50%) scale(0);\n  -ms-transform: translate(-50%, -50%) scale(0);\n  -o-transform: translate(-50%, -50%) scale(0);\n  -webkit-transform: translate(-50%, -50%) scale(0);\n  transform: translate(-50%, -50%) scale(0);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#sendingQuote.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#sendingQuote.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#sendingQuote.active[_ngcontent-%COMP%]    > send-quote[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#sendingQuote.closing[_ngcontent-%COMP%]    > send-quote[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendDocuments[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#sendDocuments[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#sendDocuments[_ngcontent-%COMP%]    > send-for-signing[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 50vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  -moz-transform: translate(-50%, -50%) scale(0);\n  -ms-transform: translate(-50%, -50%) scale(0);\n  -o-transform: translate(-50%, -50%) scale(0);\n  -webkit-transform: translate(-50%, -50%) scale(0);\n  transform: translate(-50%, -50%) scale(0);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#sendDocuments.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#sendDocuments.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#sendDocuments.active[_ngcontent-%COMP%]    > send-for-signing[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendDocuments.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#sendDocuments.closing[_ngcontent-%COMP%]    > send-for-signing[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#ledger[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#ledger[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#ledger[_ngcontent-%COMP%]    > opportunity-ledger[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 75vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  -moz-transform: translate(-50%, -50%) scale(0);\n  -ms-transform: translate(-50%, -50%) scale(0);\n  -o-transform: translate(-50%, -50%) scale(0);\n  -webkit-transform: translate(-50%, -50%) scale(0);\n  transform: translate(-50%, -50%) scale(0);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#ledger.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#ledger.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#ledger.active[_ngcontent-%COMP%]    > opportunity-ledger[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  animation-name: _ngcontent-%COMP%_documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#ledger.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#ledger.closing[_ngcontent-%COMP%]    > opportunity-ledger[_ngcontent-%COMP%] {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  animation-name: _ngcontent-%COMP%_documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n@-webkit-keyframes _ngcontent-%COMP%_signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes _ngcontent-%COMP%_signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes _ngcontent-%COMP%_signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#signing[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#signing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#signing[_ngcontent-%COMP%]    > opportunity-signing[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  z-index: calc(var(--sideNav-layer) + 4);\n  background-color: var(--color1Alt4);\n  border-radius: 2vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  overflow: hidden;\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n}\n#signing.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#signing.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#signing.active[_ngcontent-%COMP%]    > opportunity-signing[_ngcontent-%COMP%] {\n  -moz-animation-name: signingLoadIn;\n  -ms-animation-name: signingLoadIn;\n  -o-animation-name: signingLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_signingLoadIn;\n  animation-name: _ngcontent-%COMP%_signingLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#signing.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#signing.closing[_ngcontent-%COMP%]    > opportunity-signing[_ngcontent-%COMP%] {\n  -moz-animation-name: signingLoadOut;\n  -ms-animation-name: signingLoadOut;\n  -o-animation-name: signingLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_signingLoadOut;\n  animation-name: _ngcontent-%COMP%_signingLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=opportunity-modules.component.css.map */"] });
var OpportunityModulesComponent = _OpportunityModulesComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(OpportunityModulesComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "opportunity-modules", template: '\n\n<aside id="details" [class.active]="viewingDetails" [class.closing]="closingDetails">\n  <div class="bg"></div>\n  @if (viewingDetails) {\n    <opportunity-details\n    [opportunity]="detailsOpportunity"></opportunity-details>\n  }\n</aside>\n\n<aside id="preparingEstimate" [class.active]="preparingEstimate" [class.closing]="closingEstimate">\n  <div class="bg"></div>\n  @if (preparingEstimate) {\n    <estimate-submission\n    [opportunity]="estimateOpportunity"></estimate-submission>\n  }\n</aside>\n\n<aside id="managingPayments" [class.active]="managingPayments" [class.closing]="closingPayments ">\n  <div class="bg"></div>\n  @if (managingPayments) {\n    <opportunity-payments\n    [opportunity]="paymentsOpportunity"></opportunity-payments>\n  }\n</aside>\n\n<aside id="sendDocuments" [class.active]="sendingDocuments" [class.closing]="closingSendDocuments">\n  <div class="bg"></div>\n  @if (sendingDocuments) {\n    <send-for-signing\n      (close)="stopSendingDocuments()"\n    [opportunity]="sendingDocumentsOpportunity"></send-for-signing>\n  }\n</aside>\n\n<aside id="ledger" [class.active]="viewingLedger" [class.closing]="closingLedger">\n  <div class="bg"></div>\n  @if (viewingLedger) {\n    <opportunity-ledger\n      (close)="stopViewingLedger()"\n    [opportunity]="ledgerOpportunity"></opportunity-ledger>\n  }\n</aside>\n\n<aside id="sendingQuote" [class.active]="sendingQuote" [class.closing]="closingSendQuote">\n  <div class="bg"></div>\n  @if (sendingQuote) {\n    <send-quote\n      (close)="stopSendingQuote()"\n    [opportunity]="sendingQuoteOpportunity"></send-quote>\n  }\n</aside>\n\n<aside id="sendingExecutedDocuments" [class.active]="sendingExecutedDocuments" [class.closing]="closingSendExecutedDocuments">\n  <div class="bg"></div>\n  @if (sendingExecutedDocuments) {\n    <send-executed-documents\n      (close)="stopSendingExecutedDocuments()"\n    [opportunity]="sendingExecutedDocumentsOpportunity"></send-executed-documents>\n  }\n</aside>\n\n<aside id="signing" [class.active]="signingDocuments" [class.closing]="closingDocuments">\n  <div class="bg"></div>\n  @if (signingDocuments) {\n    <opportunity-signing\n      [signer]="signerName"\n      [customerFacing]="onlySigningCustomerFacingDocuments"\n    [opportunity]="documentsAppointment"></opportunity-signing>\n  }\n</aside>', styles: ["/* src/app/main/components/opportunity-modules/opportunity-modules.component.scss */\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-webkit-keyframes detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes detailsLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes detailsLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#details {\n  pointer-events: none;\n}\n#details > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#details > opportunity-details {\n  display: block;\n  position: fixed;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#details.active {\n  pointer-events: initial;\n}\n#details.active > .bg {\n  opacity: 1;\n}\n#details.active > opportunity-details {\n  -moz-animation-name: detailsLoadIn;\n  -ms-animation-name: detailsLoadIn;\n  -o-animation-name: detailsLoadIn;\n  -webkit-animation-name: detailsLoadIn;\n  animation-name: detailsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#details.closing > .bg {\n  opacity: 0;\n}\n#details.closing > opportunity-details {\n  -moz-animation-name: detailsLoadOut;\n  -ms-animation-name: detailsLoadOut;\n  -o-animation-name: detailsLoadOut;\n  -webkit-animation-name: detailsLoadOut;\n  animation-name: detailsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n@-webkit-keyframes estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes estimateLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes estimateLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#preparingEstimate {\n  pointer-events: none;\n}\n#preparingEstimate > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#preparingEstimate > estimate-submission {\n  display: block;\n  position: fixed;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 4);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#preparingEstimate.active {\n  pointer-events: initial;\n}\n#preparingEstimate.active > .bg {\n  opacity: 1;\n}\n#preparingEstimate.active > estimate-submission {\n  -moz-animation-name: estimateLoadIn;\n  -ms-animation-name: estimateLoadIn;\n  -o-animation-name: estimateLoadIn;\n  -webkit-animation-name: estimateLoadIn;\n  animation-name: estimateLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#preparingEstimate.closing > .bg {\n  opacity: 0;\n}\n#preparingEstimate.closing > estimate-submission {\n  -moz-animation-name: estimateLoadOut;\n  -ms-animation-name: estimateLoadOut;\n  -o-animation-name: estimateLoadOut;\n  -webkit-animation-name: estimateLoadOut;\n  animation-name: estimateLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#managingPayments {\n  pointer-events: none;\n}\n#managingPayments > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#managingPayments > opportunity-payments {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 90vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#managingPayments.active {\n  pointer-events: initial;\n}\n#managingPayments.active > .bg {\n  opacity: 1;\n}\n#managingPayments.closing > .bg {\n  opacity: 0;\n}\n#managingPayments.closing > opportunity-payments {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n@-webkit-keyframes documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-o-keyframes documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@keyframes documentsLoadIn {\n  0% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n}\n@-webkit-keyframes documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-moz-keyframes documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@-o-keyframes documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n@keyframes documentsLoadOut {\n  0% {\n    -moz-transform: scale(1) translate(-50%, -50%);\n    -ms-transform: scale(1) translate(-50%, -50%);\n    -o-transform: scale(1) translate(-50%, -50%);\n    -webkit-transform: scale(1) translate(-50%, -50%);\n    transform: scale(1) translate(-50%, -50%);\n  }\n  100% {\n    -moz-transform: scale(0) translate(-50%, -50%);\n    -ms-transform: scale(0) translate(-50%, -50%);\n    -o-transform: scale(0) translate(-50%, -50%);\n    -webkit-transform: scale(0) translate(-50%, -50%);\n    transform: scale(0) translate(-50%, -50%);\n  }\n}\n#sendingExecutedDocuments {\n  pointer-events: none;\n}\n#sendingExecutedDocuments > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#sendingExecutedDocuments > send-executed-documents {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 98vw;\n  height: 98vh;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#sendingExecutedDocuments.active {\n  pointer-events: initial;\n}\n#sendingExecutedDocuments.active > .bg {\n  opacity: 1;\n}\n#sendingExecutedDocuments.active > send-executed-documents {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: documentsLoadIn;\n  animation-name: documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingExecutedDocuments.closing > .bg {\n  opacity: 0;\n}\n#sendingExecutedDocuments.closing > send-executed-documents {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: documentsLoadOut;\n  animation-name: documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote {\n  pointer-events: none;\n}\n#sendingQuote > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  opacity: 0;\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#sendingQuote > send-quote {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 98vw;\n  height: 98vh;\n  border-radius: 2vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  -moz-transform: translate(-50%, -50%) scale(0);\n  -ms-transform: translate(-50%, -50%) scale(0);\n  -o-transform: translate(-50%, -50%) scale(0);\n  -webkit-transform: translate(-50%, -50%) scale(0);\n  transform: translate(-50%, -50%) scale(0);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#sendingQuote.active {\n  pointer-events: initial;\n}\n#sendingQuote.active > .bg {\n  opacity: 1;\n}\n#sendingQuote.active > send-quote {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: documentsLoadIn;\n  animation-name: documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendingQuote.closing > .bg {\n  opacity: 0;\n}\n#sendingQuote.closing > send-quote {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: documentsLoadOut;\n  animation-name: documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.5s;\n  -ms-animation-duration: 0.5s;\n  -o-animation-duration: 0.5s;\n  -webkit-animation-duration: 0.5s;\n  animation-duration: 0.5s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendDocuments {\n  pointer-events: none;\n}\n#sendDocuments > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#sendDocuments > send-for-signing {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 50vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  -moz-transform: translate(-50%, -50%) scale(0);\n  -ms-transform: translate(-50%, -50%) scale(0);\n  -o-transform: translate(-50%, -50%) scale(0);\n  -webkit-transform: translate(-50%, -50%) scale(0);\n  transform: translate(-50%, -50%) scale(0);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#sendDocuments.active {\n  pointer-events: initial;\n}\n#sendDocuments.active > .bg {\n  opacity: 1;\n}\n#sendDocuments.active > send-for-signing {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: documentsLoadIn;\n  animation-name: documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sendDocuments.closing > .bg {\n  opacity: 0;\n}\n#sendDocuments.closing > send-for-signing {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: documentsLoadOut;\n  animation-name: documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#ledger {\n  pointer-events: none;\n}\n#ledger > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  z-index: calc(var(--sideNav-layer) + 5);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#ledger > opportunity-ledger {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 75vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 6);\n  -moz-transform: translate(-50%, -50%) scale(0);\n  -ms-transform: translate(-50%, -50%) scale(0);\n  -o-transform: translate(-50%, -50%) scale(0);\n  -webkit-transform: translate(-50%, -50%) scale(0);\n  transform: translate(-50%, -50%) scale(0);\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n}\n#ledger.active {\n  pointer-events: initial;\n}\n#ledger.active > .bg {\n  opacity: 1;\n}\n#ledger.active > opportunity-ledger {\n  -moz-animation-name: documentsLoadIn;\n  -ms-animation-name: documentsLoadIn;\n  -o-animation-name: documentsLoadIn;\n  -webkit-animation-name: documentsLoadIn;\n  animation-name: documentsLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#ledger.closing > .bg {\n  opacity: 0;\n}\n#ledger.closing > opportunity-ledger {\n  -moz-animation-name: documentsLoadOut;\n  -ms-animation-name: documentsLoadOut;\n  -o-animation-name: documentsLoadOut;\n  -webkit-animation-name: documentsLoadOut;\n  animation-name: documentsLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n@-webkit-keyframes signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-moz-keyframes signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-o-keyframes signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@keyframes signingLoadIn {\n  0% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n  100% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n}\n@-webkit-keyframes signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-moz-keyframes signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@-o-keyframes signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n@keyframes signingLoadOut {\n  0% {\n    opacity: 1;\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n  }\n  100% {\n    opacity: 0;\n    -moz-transform: scale(0.9);\n    -ms-transform: scale(0.9);\n    -o-transform: scale(0.9);\n    -webkit-transform: scale(0.9);\n    transform: scale(0.9);\n  }\n}\n#signing {\n  pointer-events: none;\n}\n#signing > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 3);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#signing > opportunity-signing {\n  display: block;\n  position: fixed;\n  top: 1vw;\n  left: 1vw;\n  right: 1vw;\n  bottom: 1vw;\n  z-index: calc(var(--sideNav-layer) + 4);\n  background-color: var(--color1Alt4);\n  border-radius: 2vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  overflow: hidden;\n  opacity: 0;\n  -moz-transform: scale(0.8);\n  -ms-transform: scale(0.8);\n  -o-transform: scale(0.8);\n  -webkit-transform: scale(0.8);\n  transform: scale(0.8);\n}\n#signing.active {\n  pointer-events: initial;\n}\n#signing.active > .bg {\n  opacity: 1;\n}\n#signing.active > opportunity-signing {\n  -moz-animation-name: signingLoadIn;\n  -ms-animation-name: signingLoadIn;\n  -o-animation-name: signingLoadIn;\n  -webkit-animation-name: signingLoadIn;\n  animation-name: signingLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#signing.closing > .bg {\n  opacity: 0;\n}\n#signing.closing > opportunity-signing {\n  -moz-animation-name: signingLoadOut;\n  -ms-animation-name: signingLoadOut;\n  -o-animation-name: signingLoadOut;\n  -webkit-animation-name: signingLoadOut;\n  animation-name: signingLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.25s;\n  -ms-animation-duration: 0.25s;\n  -o-animation-duration: 0.25s;\n  -webkit-animation-duration: 0.25s;\n  animation-duration: 0.25s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=opportunity-modules.component.css.map */\n"] }]
  }], () => [{ type: OpportunityUiService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(OpportunityModulesComponent, { className: "OpportunityModulesComponent", filePath: "src/app/main/components/opportunity-modules/opportunity-modules.component.ts", lineNumber: 20 });
})();

// src/app/main/components/layout/layout.component.ts
function MainLayoutComponent_Conditional_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "global-opportunity");
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.opportunityRoute == null ? null : ctx_r0.opportunityRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.opportunityRoute == null ? null : ctx_r0.opportunityRoute.animating)("closing", ctx_r0.opportunityRoute == null ? null : ctx_r0.opportunityRoute.closing);
  }
}
function MainLayoutComponent_Conditional_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "global-bookofbusiness", 13);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.bookOfBusinessRoute == null ? null : ctx_r0.bookOfBusinessRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.bookOfBusinessRoute == null ? null : ctx_r0.bookOfBusinessRoute.animating)("closing", ctx_r0.bookOfBusinessRoute == null ? null : ctx_r0.bookOfBusinessRoute.closing);
    \u0275\u0275property("params", ctx_r0.bookOfBusinessRoute == null ? null : ctx_r0.bookOfBusinessRoute.params)("params", ctx_r0.bookOfBusinessRoute == null ? null : ctx_r0.bookOfBusinessRoute.params);
  }
}
function MainLayoutComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "global-dashboard", 13);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.dashboardRoute == null ? null : ctx_r0.dashboardRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.dashboardRoute == null ? null : ctx_r0.dashboardRoute.animating)("closing", ctx_r0.dashboardRoute == null ? null : ctx_r0.dashboardRoute.closing);
    \u0275\u0275property("params", ctx_r0.dashboardRoute == null ? null : ctx_r0.dashboardRoute.params);
  }
}
function MainLayoutComponent_Conditional_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "global-reporting");
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.reportingRoute == null ? null : ctx_r0.reportingRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.reportingRoute == null ? null : ctx_r0.reportingRoute.animating)("closing", ctx_r0.reportingRoute == null ? null : ctx_r0.reportingRoute.closing);
  }
}
function MainLayoutComponent_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "global-administration", 13);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.adminRoute == null ? null : ctx_r0.adminRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.adminRoute == null ? null : ctx_r0.adminRoute.animating)("closing", ctx_r0.adminRoute == null ? null : ctx_r0.adminRoute.closing);
    \u0275\u0275property("params", ctx_r0.adminRoute == null ? null : ctx_r0.adminRoute.params);
  }
}
function MainLayoutComponent_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "global-presentation", 13);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.loadDirection));
    \u0275\u0275classProp("animate", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.animating)("closing", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.closing);
    \u0275\u0275property("params", ctx_r0.presentationRoute == null ? null : ctx_r0.presentationRoute.params);
  }
}
function MainLayoutComponent_Conditional_7_Conditional_11_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "button", 21)(1, "label");
    \u0275\u0275text(2, "Offline");
    \u0275\u0275elementEnd()();
  }
}
function MainLayoutComponent_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "nav", 14);
    \u0275\u0275pipe(1, "async");
    \u0275\u0275elementStart(2, "div", 15);
    \u0275\u0275listener("click", function MainLayoutComponent_Conditional_7_Template_div_click_2_listener() {
      \u0275\u0275restoreView(_r2);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.closeSideNav());
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "div", 16)(4, "button", 17, 0);
    \u0275\u0275listener("click", function MainLayoutComponent_Conditional_7_Template_button_click_4_listener() {
      \u0275\u0275restoreView(_r2);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.toggleSideNav());
    });
    \u0275\u0275elementStart(6, "span", 18)(7, "span", 19);
    \u0275\u0275element(8, "span", 20)(9, "span", 20)(10, "span", 20);
    \u0275\u0275elementEnd()()();
    \u0275\u0275conditionalCreate(11, MainLayoutComponent_Conditional_7_Conditional_11_Template, 3, 0, "button", 21);
    \u0275\u0275elementEnd();
    \u0275\u0275element(12, "side-nav");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classProp("active", \u0275\u0275pipeBind1(1, 3, ctx_r0.sideNavActive));
    \u0275\u0275advance(11);
    \u0275\u0275conditional(!ctx_r0.online ? 11 : -1);
  }
}
function MainLayoutComponent_Conditional_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "manage-reminder", 22);
    \u0275\u0275listener("close", function MainLayoutComponent_Conditional_10_Template_manage_reminder_close_0_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.stopManagingReminder());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("reminder", ctx_r0.reminderToManage);
  }
}
function MainLayoutComponent_Conditional_13_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "manage-sync");
  }
}
function MainLayoutComponent_Conditional_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "manual-payment");
  }
}
function MainLayoutComponent_Conditional_19_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "external-lender");
  }
}
function MainLayoutComponent_Conditional_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 12)(1, "header")(2, "div", 23)(3, "h3");
    \u0275\u0275text(4, " The Repipe Selling Way ");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(5, "div", 16)(6, "button", 24);
    \u0275\u0275listener("click", function MainLayoutComponent_Conditional_23_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.closeTraining());
    });
    \u0275\u0275element(7, "i", 25);
    \u0275\u0275elementEnd()()();
    \u0275\u0275element(8, "training");
    \u0275\u0275elementEnd();
  }
}
var _MainLayoutComponent = class _MainLayoutComponent {
  constructor(injector, routeService, sideNavService, authRefService, apiService, reminderService, paymentsService, opportunityMigrationService) {
    this.injector = injector;
    this.routeService = routeService;
    this.sideNavService = sideNavService;
    this.authRefService = authRefService;
    this.apiService = apiService;
    this.reminderService = reminderService;
    this.paymentsService = paymentsService;
    this.opportunityMigrationService = opportunityMigrationService;
    this.MainRouteType = MainRouteType;
    this.authenticating = false;
    this.closingAuthentication = false;
    this.online = true;
  }
  // #region Side Nav
  get sideNavActive() {
    return this.sideNavService.active;
  }
  get canShowSideNav() {
    return (this.bookOfBusinessRoute?.active || this.appointmentRoute?.active || this.opportunityRoute?.active || this.reportingRoute?.active || this.adminRoute?.active || this.dashboardRoute?.active || this.presentationRoute?.active) ?? false;
  }
  toggleSideNav() {
    this.sideNavService.toggleActive();
  }
  closeSideNav() {
    this.sideNavService.close();
  }
  get routes() {
    return this.routeService.routes;
  }
  initRoutes() {
    const routes2 = {
      "Appointment": new DeviceRoute(MainRouteType.Appointment, "/appointment", false),
      "BookOfBusiness": new DeviceRoute(MainRouteType.BookOfBusiness, "/bookofbusiness", false),
      "Dashboard": new DeviceRoute(MainRouteType.Dashboard, "/dashboard", false),
      "Reporting": new DeviceRoute(MainRouteType.Reporting, "/reporting", false),
      "Administration": new DeviceRoute(MainRouteType.Administration, "/admin", false),
      "Opportunity": new DeviceRoute(MainRouteType.Opportunity, "/opportunity", false),
      "Presentation": new DeviceRoute(MainRouteType.Presentation, "/presentation", false)
    };
    this.routeService.init(routes2, routes2[MainRouteType.Dashboard], 500);
    this.routeSubscription = this.routeService.activeRoute.subscribe({
      next: (route) => {
        if (route != null) {
          switch (route.type) {
            case MainRouteType.Appointment:
              this.loadAppointment();
              break;
            case MainRouteType.BookOfBusiness:
              this.loadBookOfBusiness();
              break;
            case MainRouteType.Dashboard:
              this.loadDashboard();
              break;
            case MainRouteType.Reporting:
              this.loadReporting();
              break;
            case MainRouteType.Administration:
              this.loadAdministration();
              break;
            case MainRouteType.Opportunity:
              this.loadOpportunity();
              break;
            case MainRouteType.Presentation:
              this.loadPresentation();
              break;
          }
        }
      }
    });
  }
  destroyRoutes() {
    this.routeSubscription?.unsubscribe();
  }
  // #endregion
  // #region Dashboard
  get dashboardRoute() {
    return this.routes[MainRouteType.Dashboard];
  }
  loadDashboard() {
    if (!customElements.get("global-dashboard")) {
      import("./chunk-JRS2PAY5.js").then((mod) => mod.DashboardModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToDashboard() {
    if (this.appointmentRoute != null) {
      this.routeService.viewRouteByType(MainRouteType.Dashboard, [], true);
    }
  }
  // #endregion
  // #region Reporting
  get reportingRoute() {
    return this.routes[MainRouteType.Reporting];
  }
  loadReporting() {
    if (!customElements.get("global-reporting")) {
      import("./chunk-5UDLPZVU.js").then((mod) => mod.ReportingModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToReporting() {
    if (this.appointmentRoute != null) {
      this.routeService.viewRouteByType(MainRouteType.Reporting, [], true);
    }
  }
  // #endregion
  // #region Opportunity
  get opportunityRoute() {
    return this.routes[MainRouteType.Opportunity];
  }
  loadOpportunity() {
    if (!customElements.get("global-opportunity")) {
      import("./chunk-E3ZWTRMJ.js").then((mod) => mod.OpportunityModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToOpportunity(id) {
    this.routeService.viewRouteByType(MainRouteType.Opportunity, [id], true);
  }
  // #endregion
  // #region Appointment
  get appointmentRoute() {
    return this.routes[MainRouteType.Appointment];
  }
  loadAppointment() {
    if (!customElements.get("global-appointment")) {
      import("./chunk-JBBWWFVQ.js").then((mod) => mod.AppointmentModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  goToAppointment(id) {
    this.routeService.viewRouteByType(MainRouteType.Appointment, [id], true);
  }
  // #endregion
  // #region Manual Payment
  get makingManualPayment() {
    return this.paymentsService.makingManualPayment;
  }
  get closingManualPayment() {
    return this.paymentsService.closingManualPayment;
  }
  // #endregion
  // #region External Lender
  get applyingForExternalLender() {
    return this.paymentsService.applyingForExternalLender;
  }
  get closingExternalLender() {
    return this.paymentsService.closingExternalLender;
  }
  // #endregion
  // #region Presentation
  get presentationRoute() {
    return this.routes[MainRouteType.Presentation];
  }
  loadPresentation() {
    if (!customElements.get("global-presentation")) {
      import("./chunk-Q3M4N3V5.js").then((mod) => mod.PresentationModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  // #endregion
  // #region Appointments
  get bookOfBusinessRoute() {
    return this.routes[MainRouteType.BookOfBusiness];
  }
  loadBookOfBusiness() {
    if (!customElements.get("global-bookofbusiness")) {
      import("./chunk-KQFNWNX6.js").then((mod) => mod.BookOfBusinessModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  // #endregion
  // #region Adminiistration
  get adminRoute() {
    return this.routes[MainRouteType.Administration];
  }
  loadAdministration() {
    if (!customElements.get("global-administration")) {
      import("./chunk-TQVUADSA.js").then((mod) => mod.AdministrationModule).then((mod) => {
        createNgModule(mod, this.injector);
      });
    }
  }
  // #endregion
  // #region Training
  get trainingActive() {
    return this.sideNavService.trainingActive;
  }
  get closingTraining() {
    return this.sideNavService.closingTraining;
  }
  closeTraining() {
    this.sideNavService.closeTraining();
  }
  watchAuthentication() {
    clearTimeout(this.authTimer);
    clearTimeout(this.closeTimer);
    const initialTimer = setTimeout(() => {
      this.authenticating = false;
    }, 32);
    const start = (/* @__PURE__ */ new Date()).getTime();
    this.authSubscription = this.authRefService.authenticating.subscribe({
      next: (authenticating) => {
        if (!authenticating) {
          const now = (/* @__PURE__ */ new Date()).getTime();
          const delta = now - start;
          if (delta <= 64) {
            clearTimeout(initialTimer);
            this.closingAuthentication = false;
            this.authenticating = false;
          } else {
            this.closeTimer = window.setTimeout(() => {
              this.closingAuthentication = true;
            }, 2500);
            this.authTimer = window.setTimeout(() => {
              this.closingAuthentication = false;
              this.authenticating = false;
            }, 3500);
          }
        } else {
          this.authenticating = true;
        }
      }
    });
  }
  watchOnlineStatus() {
    this.onlineSubscription = this.apiService.online.subscribe({
      next: (online) => {
        this.online = online;
      }
    });
  }
  // #endregion
  // #region Syncing
  get managingSync() {
    return false;
  }
  // #endregion
  // #region Reminders
  get managingReminder() {
    return this.reminderService.managingReminder;
  }
  get reminderToManage() {
    return this.reminderService.reminderToManage;
  }
  stopManagingReminder() {
    this.reminderService.stopManagingReminder();
  }
  // #endregion
  // #region Bootstrapping
  init() {
    return __async(this, null, function* () {
      this.watchAuthentication();
      this.initRoutes();
      this.watchOnlineStatus();
    });
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
    this.destroyRoutes();
    this.onlineSubscription?.unsubscribe();
    this.authSubscription?.unsubscribe();
  }
};
_MainLayoutComponent.\u0275fac = function MainLayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _MainLayoutComponent)(\u0275\u0275directiveInject(Injector), \u0275\u0275directiveInject(DeviceRouteService), \u0275\u0275directiveInject(SideNavService), \u0275\u0275directiveInject(AuthRefService), \u0275\u0275directiveInject(ApiService), \u0275\u0275directiveInject(ReminderService), \u0275\u0275directiveInject(PaymentsService), \u0275\u0275directiveInject(OpportunityMigrationService));
};
_MainLayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _MainLayoutComponent, selectors: [["ng-component"]], standalone: false, features: [\u0275\u0275ProvidersFeature([OrderByPipe])], decls: 24, vars: 28, consts: [["sideNavControlElm", ""], ["id", "mainRoutes"], [3, "class", "animate", "closing"], [3, "class", "params", "animate", "closing"], ["id", "sideNav", 3, "active"], ["id", "manageReminder"], [1, "bg"], [3, "reminder"], ["id", "syncManagement"], ["id", "manualPayment"], ["id", "externalLender"], ["id", "training"], [1, "content"], [3, "params"], ["id", "sideNav"], [1, "bg", 3, "click"], [1, "controls"], [1, "control", "nav-control", 3, "click"], [1, "icon"], [1, "bars"], [1, "bar"], [1, "control", "offline"], [3, "close", "reminder"], [1, "primary"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"]], template: function MainLayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "main", 1);
    \u0275\u0275conditionalCreate(1, MainLayoutComponent_Conditional_1_Template, 1, 7, "global-opportunity", 2);
    \u0275\u0275conditionalCreate(2, MainLayoutComponent_Conditional_2_Template, 1, 9, "global-bookofbusiness", 3);
    \u0275\u0275conditionalCreate(3, MainLayoutComponent_Conditional_3_Template, 1, 8, "global-dashboard", 3);
    \u0275\u0275conditionalCreate(4, MainLayoutComponent_Conditional_4_Template, 1, 7, "global-reporting", 2);
    \u0275\u0275conditionalCreate(5, MainLayoutComponent_Conditional_5_Template, 1, 8, "global-administration", 3);
    \u0275\u0275conditionalCreate(6, MainLayoutComponent_Conditional_6_Template, 1, 8, "global-presentation", 3);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(7, MainLayoutComponent_Conditional_7_Template, 13, 5, "nav", 4);
    \u0275\u0275elementStart(8, "aside", 5);
    \u0275\u0275element(9, "div", 6);
    \u0275\u0275conditionalCreate(10, MainLayoutComponent_Conditional_10_Template, 1, 1, "manage-reminder", 7);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(11, "aside", 8);
    \u0275\u0275element(12, "div", 6);
    \u0275\u0275conditionalCreate(13, MainLayoutComponent_Conditional_13_Template, 1, 0, "manage-sync");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "aside", 9);
    \u0275\u0275element(15, "div", 6);
    \u0275\u0275conditionalCreate(16, MainLayoutComponent_Conditional_16_Template, 1, 0, "manual-payment");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(17, "aside", 10);
    \u0275\u0275element(18, "div", 6);
    \u0275\u0275conditionalCreate(19, MainLayoutComponent_Conditional_19_Template, 1, 0, "external-lender");
    \u0275\u0275elementEnd();
    \u0275\u0275element(20, "opportunity-modules");
    \u0275\u0275elementStart(21, "aside", 11);
    \u0275\u0275element(22, "div", 6);
    \u0275\u0275conditionalCreate(23, MainLayoutComponent_Conditional_23_Template, 9, 0, "div", 12);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.opportunityRoute == null ? null : ctx.opportunityRoute.active) ? 1 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.bookOfBusinessRoute == null ? null : ctx.bookOfBusinessRoute.active) ? 2 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.dashboardRoute == null ? null : ctx.dashboardRoute.active) ? 3 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.reportingRoute == null ? null : ctx.reportingRoute.active) ? 4 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.adminRoute == null ? null : ctx.adminRoute.active) ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional((ctx.presentationRoute == null ? null : ctx.presentationRoute.active) ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.canShowSideNav ? 7 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.managingReminder);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.reminderToManage != null ? 10 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.managingSync);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.managingSync ? 13 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.makingManualPayment)("closing", ctx.closingManualPayment);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.makingManualPayment ? 16 : -1);
    \u0275\u0275advance();
    \u0275\u0275classProp("active", ctx.applyingForExternalLender)("closing", ctx.closingExternalLender);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.applyingForExternalLender ? 19 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275classProp("active", ctx.trainingActive)("closing", ctx.closingTraining);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(ctx.trainingActive ? 23 : -1);
  }
}, dependencies: [ManualPaymentComponent, ExternalLenderComponent, SideNavLayoutComponent, TrainingComponent, OpportunityModulesComponent, AsyncPipe], styles: ['\n\n[_nghost-%COMP%] {\n  --routeTransition: .5s;\n  --sideNavTransition: .2s;\n}\n@-webkit-keyframes _ngcontent-%COMP%_unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@-moz-keyframes unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@-o-keyframes unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#mainRoutes[_ngcontent-%COMP%] {\n  position: fixed;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  -moz-transition: left 0.25s linear;\n  -o-transition: left 0.25s linear;\n  -webkit-transition: left 0.25s linear;\n  transition: left 0.25s linear;\n}\n#mainRoutes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  -moz-transition: left 0.2s linear;\n  -o-transition: left 0.2s linear;\n  -webkit-transition: left 0.2s linear;\n  transition: left 0.2s linear;\n}\n#mainRoutes[_ngcontent-%COMP%]    > .route.animate[_ngcontent-%COMP%] {\n  -moz-animation-name: loadRoute;\n  -ms-animation-name: loadRoute;\n  -o-animation-name: loadRoute;\n  -webkit-animation-name: _ngcontent-%COMP%_loadRoute;\n  animation-name: _ngcontent-%COMP%_loadRoute;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#mainRoutes[_ngcontent-%COMP%]    > .route.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: unloadRoute;\n  -ms-animation-name: unloadRoute;\n  -o-animation-name: unloadRoute;\n  -webkit-animation-name: _ngcontent-%COMP%_unloadRoute;\n  animation-name: _ngcontent-%COMP%_unloadRoute;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sideNav[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) - 1);\n  background-color: rgba(var(--color1-raw), 0.7);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  position: fixed;\n  z-index: calc(var(--sideNav-layer) + 1);\n  top: calc(0.5vw + var(--systemOffset-top));\n  left: 0.5vw;\n  display: flex;\n  align-items: center;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%] {\n  display: block;\n  height: 3.5vw;\n  width: 3.5vw;\n  position: relative;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   i[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 2vw;\n  color: var(--color1);\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%] {\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: translateX(0) translateY(0);\n  -ms-transform: translateX(0) translateY(0);\n  -o-transform: translateX(0) translateY(0);\n  -webkit-transform: translateX(0) translateY(0);\n  transform: translateX(0) translateY(0);\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]:before {\n  content: "";\n  display: block;\n  border-radius: 100%;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: transparent;\n  z-index: 0;\n  -moz-transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n  -o-transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n  -webkit-transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n  transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n  -moz-transform-origin: top center;\n  -ms-transform-origin: top center;\n  -o-transform-origin: top center;\n  -webkit-transform-origin: top center;\n  transform-origin: top center;\n  -moz-transition: transform 0.1s var(--easeInOutQuad);\n  -o-transition: transform 0.1s var(--easeInOutQuad);\n  -webkit-transition: transform 0.1s var(--easeInOutQuad);\n  transition: transform 0.1s var(--easeInOutQuad);\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%] {\n  display: block;\n  width: 1.6vw;\n  height: 0.22vw;\n  background-color: var(--color1);\n  border-radius: 999px;\n  margin-top: 0.3vw;\n  opacity: 1;\n  -moz-transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(1) {\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(3) {\n  -moz-transform-origin: bottom left;\n  -ms-transform-origin: bottom left;\n  -o-transform-origin: bottom left;\n  -webkit-transform-origin: bottom left;\n  transform-origin: bottom left;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.offline[_ngcontent-%COMP%] {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.35vw 0.75vw;\n  pointer-events: none;\n  opacity: 0.4;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.offline[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#sideNav[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.loader[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]   loader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  width: 2.5vw;\n  height: 2.5vw;\n  --fillSpeed: 2s;\n}\n#sideNav.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n  pointer-events: initial;\n}\n#sideNav.active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control.offline[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#sideNav.active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%] {\n  -moz-transform: translateX(2.15vw) translateY(1.5vw);\n  -ms-transform: translateX(2.15vw) translateY(1.5vw);\n  -o-transform: translateX(2.15vw) translateY(1.5vw);\n  -webkit-transform: translateX(2.15vw) translateY(1.5vw);\n  transform: translateX(2.15vw) translateY(1.5vw);\n}\n#sideNav.active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]:before {\n  background-color: var(--color2);\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n#sideNav.active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(1) {\n  -moz-transform: rotate(45deg);\n  -ms-transform: rotate(45deg);\n  -o-transform: rotate(45deg);\n  -webkit-transform: rotate(45deg);\n  transform: rotate(45deg);\n}\n#sideNav.active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(2) {\n  opacity: 0;\n}\n#sideNav.active[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .nav-control[_ngcontent-%COMP%]    > .icon[_ngcontent-%COMP%]    > .bars[_ngcontent-%COMP%]    > .bar[_ngcontent-%COMP%]:nth-child(3) {\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n}\n#manageReminder[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#manageReminder[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#manageReminder[_ngcontent-%COMP%]    > manage-reminder[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 2);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#manageReminder.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#manageReminder.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#manageReminder.active[_ngcontent-%COMP%]    > manage-reminder[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#syncManagement[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#syncManagement[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#syncManagement[_ngcontent-%COMP%]    > manage-sync[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 2);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#syncManagement.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#syncManagement.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#syncManagement.active[_ngcontent-%COMP%]    > manage-sync[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#externalLender[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#externalLender[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 9);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#externalLender[_ngcontent-%COMP%]    > external-lender[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 5vw;\n  left: 5vw;\n  right: 5vw;\n  bottom: 5vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 10);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#externalLender.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#externalLender.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#externalLender.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#externalLender.closing[_ngcontent-%COMP%]    > manual-payment[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#manualPayment[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#manualPayment[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#manualPayment[_ngcontent-%COMP%]    > manual-payment[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 8);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#manualPayment.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#manualPayment.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#manualPayment.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#manualPayment.closing[_ngcontent-%COMP%]    > manual-payment[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#training[_ngcontent-%COMP%] {\n  pointer-events: none;\n}\n#training[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  display: block;\n  position: fixed;\n  top: calc(var(--systemOffset-top) + 1vw);\n  left: 1vw;\n  right: 1vw;\n  bottom: calc(var(--systemOffset-bottom) + 1vw);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 8);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadIn;\n  animation-name: _ngcontent-%COMP%_modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  display: flex;\n  flex-direction: column;\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h4[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#training[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > training[_ngcontent-%COMP%] {\n  display: block;\n  flex: 1;\n  position: relative;\n  margin: 0 1vw 1vw;\n  border-radius: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n}\n#training.active[_ngcontent-%COMP%] {\n  pointer-events: initial;\n}\n#training.active[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n#training.closing[_ngcontent-%COMP%]    > .bg[_ngcontent-%COMP%] {\n  opacity: 0;\n}\n#training.closing[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_modalLoadOut;\n  animation-name: _ngcontent-%COMP%_modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */'] });
var MainLayoutComponent = _MainLayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(MainLayoutComponent, [{
    type: Component,
    args: [{ standalone: false, providers: [OrderByPipe], template: '<main id="mainRoutes">\n  @if (opportunityRoute?.active) {\n  <global-opportunity class="route {{opportunityRoute?.loadDirection}}" [class.animate]="opportunityRoute?.animating"\n    [class.closing]="opportunityRoute?.closing"></global-opportunity>\n  }\n  @if (bookOfBusinessRoute?.active) {\n  <global-bookofbusiness class="route {{bookOfBusinessRoute?.loadDirection}}" [params]="bookOfBusinessRoute?.params"\n    [params]="bookOfBusinessRoute?.params" [class.animate]="bookOfBusinessRoute?.animating"\n    [class.closing]="bookOfBusinessRoute?.closing"></global-bookofbusiness>\n  }\n  @if (dashboardRoute?.active) {\n  <global-dashboard class="route {{dashboardRoute?.loadDirection}}" [params]="dashboardRoute?.params"\n    [class.animate]="dashboardRoute?.animating" [class.closing]="dashboardRoute?.closing"></global-dashboard>\n  }\n  @if (reportingRoute?.active) {\n  <global-reporting class="route {{reportingRoute?.loadDirection}}" [class.animate]="reportingRoute?.animating"\n    [class.closing]="reportingRoute?.closing"></global-reporting>\n  }\n  @if (adminRoute?.active) {\n  <global-administration class="route {{adminRoute?.loadDirection}}" [params]="adminRoute?.params"\n    [class.animate]="adminRoute?.animating" [class.closing]="adminRoute?.closing"></global-administration>\n  }\n  @if (presentationRoute?.active) {\n  <global-presentation class="route {{presentationRoute?.loadDirection}}" [params]="presentationRoute?.params"\n    [class.animate]="presentationRoute?.animating" [class.closing]="presentationRoute?.closing"></global-presentation>\n  }\n</main>\n\n@if (canShowSideNav) {\n<nav id="sideNav" [class.active]="sideNavActive | async">\n  <div class="bg" (click)="closeSideNav()"></div>\n  <div class="controls">\n    <button class="control nav-control" #sideNavControlElm (click)="toggleSideNav()">\n      <span class="icon">\n        <span class="bars">\n          <span class="bar"></span>\n          <span class="bar"></span>\n          <span class="bar"></span>\n        </span>\n      </span>\n    </button>\n    @if (!online) {\n    <button class="control offline">\n      <label>Offline</label>\n    </button>\n    }\n  </div>\n  <side-nav></side-nav>\n</nav>\n}\n\n<aside id="manageReminder" [class.active]="managingReminder">\n  <div class="bg"></div>\n  @if (reminderToManage != null) {\n  <manage-reminder [reminder]="reminderToManage" (close)="stopManagingReminder()"></manage-reminder>\n  }\n</aside>\n\n<aside id="syncManagement" [class.active]="managingSync">\n  <div class="bg"></div>\n  @if (managingSync) {\n  <manage-sync></manage-sync>\n  }\n</aside>\n\n<aside id="manualPayment" [class.active]="makingManualPayment" [class.closing]="closingManualPayment">\n  <div class="bg"></div>\n  @if (makingManualPayment) {\n  <manual-payment></manual-payment>\n  }\n</aside>\n\n<aside id="externalLender" [class.active]="applyingForExternalLender" [class.closing]="closingExternalLender">\n  <div class="bg"></div>\n  @if (applyingForExternalLender) {\n  <external-lender></external-lender>\n  }\n</aside>\n\n<opportunity-modules></opportunity-modules>\n\n<aside id="training" [class.active]="trainingActive" [class.closing]="closingTraining">\n  <div class="bg"></div>\n  @if (trainingActive) {\n    <div class="content">\n      <header>\n        <div class="primary">\n          <h3>\n            The Repipe Selling Way\n          </h3>\n        </div>\n        <div class="controls">\n          <button class="control" (click)="closeTraining()">\n            <i class="fa-solid fa-xmark"></i>\n          </button>\n        </div>\n      </header>\n      <training></training>\n    </div>\n  }\n</aside>', styles: ['/* src/app/main/components/layout/layout.component.scss */\n:host {\n  --routeTransition: .5s;\n  --sideNavTransition: .2s;\n}\n@-webkit-keyframes unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@-moz-keyframes unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@-o-keyframes unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@keyframes unloadRoute {\n  0% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n  100% {\n    -moz-transform: translateY(-100%);\n    -ms-transform: translateY(-100%);\n    -o-transform: translateY(-100%);\n    -webkit-transform: translateY(-100%);\n    transform: translateY(-100%);\n  }\n}\n@-webkit-keyframes loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes loadRoute {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-moz-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-o-keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@keyframes modalLoadIn {\n  0% {\n    opacity: 0;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n@-webkit-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-moz-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@-o-keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n@keyframes modalLoadOut {\n  0% {\n    opacity: 1;\n  }\n  100% {\n    opacity: 0;\n  }\n}\n#mainRoutes {\n  position: fixed;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  -moz-transition: left 0.25s linear;\n  -o-transition: left 0.25s linear;\n  -webkit-transition: left 0.25s linear;\n  transition: left 0.25s linear;\n}\n#mainRoutes > .route {\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  -moz-transition: left 0.2s linear;\n  -o-transition: left 0.2s linear;\n  -webkit-transition: left 0.2s linear;\n  transition: left 0.2s linear;\n}\n#mainRoutes > .route.animate {\n  -moz-animation-name: loadRoute;\n  -ms-animation-name: loadRoute;\n  -o-animation-name: loadRoute;\n  -webkit-animation-name: loadRoute;\n  animation-name: loadRoute;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#mainRoutes > .route.closing {\n  -moz-animation-name: unloadRoute;\n  -ms-animation-name: unloadRoute;\n  -o-animation-name: unloadRoute;\n  -webkit-animation-name: unloadRoute;\n  animation-name: unloadRoute;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#sideNav > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) - 1);\n  background-color: rgba(var(--color1-raw), 0.7);\n  -webkit-backdrop-filter: blur(0.25vw);\n  -moz-backdrop-filter: blur(0.25vw);\n  -o-backdrop-filter: blur(0.25vw);\n  -ms-backdrop-filter: blur(0.25vw);\n  backdrop-filter: blur(0.25vw);\n  opacity: 0;\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n  pointer-events: none;\n}\n#sideNav > .controls {\n  position: fixed;\n  z-index: calc(var(--sideNav-layer) + 1);\n  top: calc(0.5vw + var(--systemOffset-top));\n  left: 0.5vw;\n  display: flex;\n  align-items: center;\n}\n#sideNav > .controls > .control {\n  margin-left: 1vw;\n  cursor: pointer;\n}\n#sideNav > .controls > .control > .icon {\n  display: block;\n  height: 3.5vw;\n  width: 3.5vw;\n  position: relative;\n}\n#sideNav > .controls > .control > .icon i {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  font-size: 2vw;\n  color: var(--color1);\n}\n#sideNav > .controls > .control.nav-control {\n  -moz-transition: transform 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad);\n  -moz-transform: translateX(0) translateY(0);\n  -ms-transform: translateX(0) translateY(0);\n  -o-transform: translateX(0) translateY(0);\n  -webkit-transform: translateX(0) translateY(0);\n  transform: translateX(0) translateY(0);\n}\n#sideNav > .controls > .control.nav-control > .icon:before {\n  content: "";\n  display: block;\n  border-radius: 100%;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: transparent;\n  z-index: 0;\n  -moz-transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n  -o-transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n  -webkit-transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n  transition: border-radius 0.2s var(--easeInOutQuad), background-color 0.2s var(--easeInOutQuad);\n}\n#sideNav > .controls > .control.nav-control > .icon > .bars {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  z-index: 1;\n  -moz-transform-origin: top center;\n  -ms-transform-origin: top center;\n  -o-transform-origin: top center;\n  -webkit-transform-origin: top center;\n  transform-origin: top center;\n  -moz-transition: transform 0.1s var(--easeInOutQuad);\n  -o-transition: transform 0.1s var(--easeInOutQuad);\n  -webkit-transition: transform 0.1s var(--easeInOutQuad);\n  transition: transform 0.1s var(--easeInOutQuad);\n}\n#sideNav > .controls > .control.nav-control > .icon > .bars > .bar {\n  display: block;\n  width: 1.6vw;\n  height: 0.22vw;\n  background-color: var(--color1);\n  border-radius: 999px;\n  margin-top: 0.3vw;\n  opacity: 1;\n  -moz-transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n  -o-transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n  -webkit-transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n  transition: transform 0.2s var(--easeInOutQuad), opacity 0.2s var(--easeInOutQuad);\n}\n#sideNav > .controls > .control.nav-control > .icon > .bars > .bar:nth-child(1) {\n  -moz-transform-origin: top left;\n  -ms-transform-origin: top left;\n  -o-transform-origin: top left;\n  -webkit-transform-origin: top left;\n  transform-origin: top left;\n}\n#sideNav > .controls > .control.nav-control > .icon > .bars > .bar:nth-child(3) {\n  -moz-transform-origin: bottom left;\n  -ms-transform-origin: bottom left;\n  -o-transform-origin: bottom left;\n  -webkit-transform-origin: bottom left;\n  transform-origin: bottom left;\n}\n#sideNav > .controls > .control.nav-control > .icon > .bars > .bar:first-child {\n  margin-top: 0;\n}\n#sideNav > .controls > .control.offline {\n  background-color: var(--error);\n  border: 0.2vw var(--errorAlt3) solid;\n  border-radius: 1vw;\n  padding: 0.35vw 0.75vw;\n  pointer-events: none;\n  opacity: 0.4;\n  -moz-transition: opacity 0.1s linear;\n  -o-transition: opacity 0.1s linear;\n  -webkit-transition: opacity 0.1s linear;\n  transition: opacity 0.1s linear;\n}\n#sideNav > .controls > .control.offline label {\n  font-size: 1vw;\n  font-weight: var(--stronger);\n  color: var(--color2);\n  text-align: center;\n  text-transform: uppercase;\n}\n#sideNav > .controls > .control.loader > .icon loader {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  display: block;\n  width: 2.5vw;\n  height: 2.5vw;\n  --fillSpeed: 2s;\n}\n#sideNav.active > .bg {\n  opacity: 1;\n  pointer-events: initial;\n}\n#sideNav.active > .controls > .control.offline {\n  opacity: 0;\n}\n#sideNav.active > .controls > .nav-control {\n  -moz-transform: translateX(2.15vw) translateY(1.5vw);\n  -ms-transform: translateX(2.15vw) translateY(1.5vw);\n  -o-transform: translateX(2.15vw) translateY(1.5vw);\n  -webkit-transform: translateX(2.15vw) translateY(1.5vw);\n  transform: translateX(2.15vw) translateY(1.5vw);\n}\n#sideNav.active > .controls > .nav-control > .icon:before {\n  background-color: var(--color2);\n  border-bottom-left-radius: 0;\n  border-bottom-right-radius: 0;\n}\n#sideNav.active > .controls > .nav-control > .icon > .bars > .bar:nth-child(1) {\n  -moz-transform: rotate(45deg);\n  -ms-transform: rotate(45deg);\n  -o-transform: rotate(45deg);\n  -webkit-transform: rotate(45deg);\n  transform: rotate(45deg);\n}\n#sideNav.active > .controls > .nav-control > .icon > .bars > .bar:nth-child(2) {\n  opacity: 0;\n}\n#sideNav.active > .controls > .nav-control > .icon > .bars > .bar:nth-child(3) {\n  -moz-transform: rotate(-45deg);\n  -ms-transform: rotate(-45deg);\n  -o-transform: rotate(-45deg);\n  -webkit-transform: rotate(-45deg);\n  transform: rotate(-45deg);\n}\n#manageReminder {\n  pointer-events: none;\n}\n#manageReminder > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#manageReminder > manage-reminder {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 2);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#manageReminder.active {\n  pointer-events: initial;\n}\n#manageReminder.active > .bg {\n  opacity: 1;\n}\n#manageReminder.active > manage-reminder {\n  opacity: 1;\n}\n#syncManagement {\n  pointer-events: none;\n}\n#syncManagement > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 1);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#syncManagement > manage-sync {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 2);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#syncManagement.active {\n  pointer-events: initial;\n}\n#syncManagement.active > .bg {\n  opacity: 1;\n}\n#syncManagement.active > manage-sync {\n  opacity: 1;\n}\n#externalLender {\n  pointer-events: none;\n}\n#externalLender > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 9);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#externalLender > external-lender {\n  display: block;\n  position: fixed;\n  top: 5vw;\n  left: 5vw;\n  right: 5vw;\n  bottom: 5vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 10);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#externalLender.active {\n  pointer-events: initial;\n}\n#externalLender.active > .bg {\n  opacity: 1;\n}\n#externalLender.closing > .bg {\n  opacity: 0;\n}\n#externalLender.closing > manual-payment {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#manualPayment {\n  pointer-events: none;\n}\n#manualPayment > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#manualPayment > manual-payment {\n  display: block;\n  position: fixed;\n  top: 50%;\n  left: 50%;\n  -moz-transform: translate(-50%, -50%);\n  -ms-transform: translate(-50%, -50%);\n  -o-transform: translate(-50%, -50%);\n  -webkit-transform: translate(-50%, -50%);\n  transform: translate(-50%, -50%);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  width: 40vw;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 8);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#manualPayment.active {\n  pointer-events: initial;\n}\n#manualPayment.active > .bg {\n  opacity: 1;\n}\n#manualPayment.closing > .bg {\n  opacity: 0;\n}\n#manualPayment.closing > manual-payment {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#training {\n  pointer-events: none;\n}\n#training > .bg {\n  position: fixed;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: calc(var(--sideNav-layer) + 6);\n  opacity: 0;\n  background-color: rgba(var(--color2-raw), 0.4);\n  -webkit-backdrop-filter: blur(0.5vw);\n  -moz-backdrop-filter: blur(0.5vw);\n  -o-backdrop-filter: blur(0.5vw);\n  -ms-backdrop-filter: blur(0.5vw);\n  backdrop-filter: blur(0.5vw);\n  -moz-transition: opacity 0.2s linear;\n  -o-transition: opacity 0.2s linear;\n  -webkit-transition: opacity 0.2s linear;\n  transition: opacity 0.2s linear;\n}\n#training > .content {\n  display: block;\n  position: fixed;\n  top: calc(var(--systemOffset-top) + 1vw);\n  left: 1vw;\n  right: 1vw;\n  bottom: calc(var(--systemOffset-bottom) + 1vw);\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 1vw;\n  z-index: calc(var(--sideNav-layer) + 8);\n  opacity: 0;\n  overflow: hidden;\n  box-shadow: 0 0.2vw 1vw rgba(var(--black-raw), 0.1);\n  -moz-animation-name: modalLoadIn;\n  -ms-animation-name: modalLoadIn;\n  -o-animation-name: modalLoadIn;\n  -webkit-animation-name: modalLoadIn;\n  animation-name: modalLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n  display: flex;\n  flex-direction: column;\n}\n#training > .content > header {\n  background-color: var(--color2);\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n#training > .content > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#training > .content > header > .primary > h4 {\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--strong);\n}\n#training > .content > header > .controls > .control {\n  cursor: pointer;\n}\n#training > .content > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n#training > .content > training {\n  display: block;\n  flex: 1;\n  position: relative;\n  margin: 0 1vw 1vw;\n  border-radius: 1vw;\n  border: 0.1vw var(--color2Alt2) solid;\n  overflow: hidden;\n}\n#training.active {\n  pointer-events: initial;\n}\n#training.active > .bg {\n  opacity: 1;\n}\n#training.closing > .bg {\n  opacity: 0;\n}\n#training.closing > .content {\n  -moz-animation-name: modalLoadOut;\n  -ms-animation-name: modalLoadOut;\n  -o-animation-name: modalLoadOut;\n  -webkit-animation-name: modalLoadOut;\n  animation-name: modalLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutCubic);\n  -ms-animation-timing-function: var(--easeInOutCubic);\n  -o-animation-timing-function: var(--easeInOutCubic);\n  -webkit-animation-timing-function: var(--easeInOutCubic);\n  animation-timing-function: var(--easeInOutCubic);\n  -moz-animation-duration: 0.2s;\n  -ms-animation-duration: 0.2s;\n  -o-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  animation-duration: 0.2s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */\n'] }]
  }], () => [{ type: Injector }, { type: DeviceRouteService }, { type: SideNavService }, { type: AuthRefService }, { type: ApiService }, { type: ReminderService }, { type: PaymentsService }, { type: OpportunityMigrationService }], null);
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(MainLayoutComponent, { className: "MainLayoutComponent", filePath: "src/app/main/components/layout/layout.component.ts", lineNumber: 32 });
})();

// src/app/main/components/dummy-route/dummy-route.component.ts
var _DummyRouteComponent = class _DummyRouteComponent {
  constructor() {
  }
};
_DummyRouteComponent.\u0275fac = function DummyRouteComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _DummyRouteComponent)();
};
_DummyRouteComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _DummyRouteComponent, selectors: [["ng-component"]], standalone: false, decls: 0, vars: 0, template: function DummyRouteComponent_Template(rf, ctx) {
}, encapsulation: 2 });
var DummyRouteComponent = _DummyRouteComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(DummyRouteComponent, [{
    type: Component,
    args: [{ standalone: false, template: "" }]
  }], () => [], null);
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(DummyRouteComponent, { className: "DummyRouteComponent", filePath: "src/app/main/components/dummy-route/dummy-route.component.ts", lineNumber: 9 });
})();

// src/app/main/main-routing.module.ts
var routes = [
  {
    path: "",
    component: MainLayoutComponent,
    children: [
      {
        path: "",
        component: DummyRouteComponent,
        pathMatch: "full"
      },
      {
        path: "**",
        component: DummyRouteComponent,
        pathMatch: "full"
      }
    ]
  }
];
var _MainRoutingModule = class _MainRoutingModule {
};
_MainRoutingModule.\u0275fac = function MainRoutingModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _MainRoutingModule)();
};
_MainRoutingModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _MainRoutingModule });
_MainRoutingModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [RouterModule.forChild(routes), RouterModule] });
var MainRoutingModule = _MainRoutingModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(MainRoutingModule, [{
    type: NgModule,
    args: [{
      imports: [RouterModule.forChild(routes)],
      exports: [RouterModule]
    }]
  }], null, null);
})();

// src/app/shared/payments/payments.module.ts
var _SharedPaymentsModule = class _SharedPaymentsModule {
};
_SharedPaymentsModule.\u0275fac = function SharedPaymentsModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SharedPaymentsModule)();
};
_SharedPaymentsModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _SharedPaymentsModule });
_SharedPaymentsModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [
  CommonModule,
  RouterModule,
  ReactiveFormsModule,
  UiModule,
  FormsModule
] });
var SharedPaymentsModule = _SharedPaymentsModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SharedPaymentsModule, [{
    type: NgModule,
    args: [{
      declarations: [
        ManualPaymentComponent,
        ExternalLenderComponent
      ],
      imports: [
        CommonModule,
        RouterModule,
        ReactiveFormsModule,
        UiModule,
        FormsModule
      ],
      /* Do not put any services in the Shared Module which need to share an instance across multiple modules
          Those should go in the app.module instead */
      providers: [],
      exports: [
        ManualPaymentComponent,
        ExternalLenderComponent
      ],
      schemas: [CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

// src/app/shared/reminders/components/manage-reminder/manage-reminder.component.ts
var _c05 = ["componentElm"];
function ManageReminderComponent_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "h4");
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate2(" for ", ctx_r0.recipient == null ? null : ctx_r0.recipient.firstName, " ", ctx_r0.recipient == null ? null : ctx_r0.recipient.lastName, " ");
  }
}
function ManageReminderComponent_For_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 11);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const appointment_r2 = ctx.$implicit;
    \u0275\u0275property("ngValue", appointment_r2.id);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate3(" ", appointment_r2.jobId, " ", appointment_r2.customer == null ? null : appointment_r2.customer.firstName, " ", appointment_r2.customer == null ? null : appointment_r2.customer.lastName, " ");
  }
}
var _ManageReminderComponent = class _ManageReminderComponent {
  constructor(uiService, reminderService) {
    this.uiService = uiService;
    this.reminderService = reminderService;
    this.appointments = [];
    this.ReminderPriority = ReminderPriority;
    this.priority = ReminderPriority.Standard;
    this.close = new Subject();
  }
  // #region UI
  get header() {
    if (this.reminder?.id != null) {
      return "Managing Reminder";
    }
    return "Create a Reminder";
  }
  // #endregion   
  // #region Creator
  get creator() {
    return this.reminder?.creator;
  }
  // #endregion
  // #region Recipient
  get recipient() {
    return this.reminder?.recipient;
  }
  get showRecipientLabel() {
    return this.creator?.id != this.recipient?.id;
  }
  initReminder() {
    if (this.reminder != null) {
      this.appointmentId = this.reminder.reference?.referenceId;
      this.title = this.reminder.title;
      this.note = this.reminder.note;
      this.priority = this.reminder.priority;
    }
  }
  // #endregion
  // #region Saving
  get canSave() {
    return this.title != null && this.priority != null && this.reminder?.creator != null && this.reminder?.recipient != null;
  }
  save() {
    if (this.canSave) {
      if (this.reminder != null) {
        if (this.reminder.id == null || this.reminder.id.length == 0) {
          this.reminder.id = this.uiService.generateId();
        }
        const appointment = this.appointments.find((x) => x.id == this.appointmentId);
        if (appointment != null) {
          const customerName = appointment.customer != null ? `${appointment.customer.firstName} ${appointment.customer.lastName}` : null;
          this.reminder.reference = {
            content: `Job ${appointment.jobId} | ${customerName}`,
            referenceId: appointment.id,
            type: ReminderReferenceType.Appointment
          };
        }
        this.reminder.title = this.title ?? "";
        this.reminder.note = this.note ?? "";
        if (this.appointmentId != null) {
          this.reminder.reference = {
            referenceId: this.appointmentId,
            type: ReminderReferenceType.Appointment,
            content: ""
          };
        }
        this.reminder.priority = this.priority;
        this.reminderService.storeReminder(this.reminder);
        this.closeView(this.reminder);
      }
    }
  }
  closeView(reminder = void 0) {
    this.close.next(reminder);
  }
  init() {
    this.initReminder();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_ManageReminderComponent.\u0275fac = function ManageReminderComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _ManageReminderComponent)(\u0275\u0275directiveInject(UiService), \u0275\u0275directiveInject(ReminderService));
};
_ManageReminderComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ManageReminderComponent, selectors: [["manage-reminder"]], viewQuery: function ManageReminderComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c05, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { appointments: "appointments", reminder: "reminder" }, outputs: { close: "close" }, standalone: false, decls: 42, vars: 10, consts: [[1, "reminder"], [1, "primary"], [1, "controls"], [1, "control", 3, "click"], [1, "fa-solid", "fa-xmark"], [1, "form"], [1, "input-wrap"], [1, "input"], ["type", "text", "maxlength", "50", "placeholder", "Reminder Title", 3, "ngModelChange", "ngModel"], [1, "appointments", "input-wrap"], [3, "ngModelChange", "ngModel"], [3, "ngValue"], ["placeholder", "Reminder Note", "rows", "5", 3, "ngModelChange", "ngModel"], [1, "control", 3, "click", "disabled"]], template: function ManageReminderComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "header")(2, "div", 1)(3, "h3");
    \u0275\u0275text(4);
    \u0275\u0275elementEnd();
    \u0275\u0275conditionalCreate(5, ManageReminderComponent_Conditional_5_Template, 2, 2, "h4");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 2)(7, "button", 3);
    \u0275\u0275listener("click", function ManageReminderComponent_Template_button_click_7_listener() {
      return ctx.closeView();
    });
    \u0275\u0275element(8, "i", 4);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(9, "div", 5)(10, "div", 6)(11, "label");
    \u0275\u0275text(12, "Title");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "div", 7)(14, "input", 8);
    \u0275\u0275twoWayListener("ngModelChange", function ManageReminderComponent_Template_input_ngModelChange_14_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.title, $event) || (ctx.title = $event);
      return $event;
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(15, "div", 9)(16, "label");
    \u0275\u0275text(17, "Appointment");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(18, "div", 7)(19, "select", 10);
    \u0275\u0275twoWayListener("ngModelChange", function ManageReminderComponent_Template_select_ngModelChange_19_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.appointmentId, $event) || (ctx.appointmentId = $event);
      return $event;
    });
    \u0275\u0275elementStart(20, "option", 11);
    \u0275\u0275text(21, "-- No Appointment --");
    \u0275\u0275elementEnd();
    \u0275\u0275repeaterCreate(22, ManageReminderComponent_For_23_Template, 2, 4, "option", 11, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(24, "div", 6)(25, "label");
    \u0275\u0275text(26, "Note");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(27, "div", 7)(28, "textarea", 12);
    \u0275\u0275twoWayListener("ngModelChange", function ManageReminderComponent_Template_textarea_ngModelChange_28_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.note, $event) || (ctx.note = $event);
      return $event;
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(29, "div", 6)(30, "label");
    \u0275\u0275text(31, "Priority");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "div", 7)(33, "select", 10);
    \u0275\u0275twoWayListener("ngModelChange", function ManageReminderComponent_Template_select_ngModelChange_33_listener($event) {
      \u0275\u0275twoWayBindingSet(ctx.priority, $event) || (ctx.priority = $event);
      return $event;
    });
    \u0275\u0275elementStart(34, "option", 11);
    \u0275\u0275text(35, "Standard");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(36, "option", 11);
    \u0275\u0275text(37, "Critical");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(38, "div", 2)(39, "button", 13);
    \u0275\u0275listener("click", function ManageReminderComponent_Template_button_click_39_listener() {
      return ctx.save();
    });
    \u0275\u0275elementStart(40, "label");
    \u0275\u0275text(41, "Save Reminder");
    \u0275\u0275elementEnd()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(ctx.header);
    \u0275\u0275advance();
    \u0275\u0275conditional(ctx.showRecipientLabel ? 5 : -1);
    \u0275\u0275advance(9);
    \u0275\u0275twoWayProperty("ngModel", ctx.title);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.appointmentId);
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", void 0);
    \u0275\u0275advance(2);
    \u0275\u0275repeater(ctx.appointments);
    \u0275\u0275advance(6);
    \u0275\u0275twoWayProperty("ngModel", ctx.note);
    \u0275\u0275advance(5);
    \u0275\u0275twoWayProperty("ngModel", ctx.priority);
    \u0275\u0275advance();
    \u0275\u0275property("ngValue", ctx.ReminderPriority.Standard);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngValue", ctx.ReminderPriority.Critical);
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx.canSave);
  }
}, dependencies: [NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, SelectControlValueAccessor, NgControlStatus, MaxLengthValidator, NgModel], styles: ["\n\n.reminder[_ngcontent-%COMP%] {\n  position: relative;\n}\n.reminder[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%] {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h3[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .primary[_ngcontent-%COMP%]    > h4[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.reminder[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  cursor: pointer;\n}\n.reminder[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > i[_ngcontent-%COMP%] {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%] {\n  padding: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  text-transform: uppercase;\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n  border: 0.1vw var(--color2Alt3) solid;\n  padding: 1vw;\n  border-radius: 0.5vw;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   select[_ngcontent-%COMP%], \n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], \n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  resize: none;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]:first-child {\n  margin-top: 0;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  display: flex;\n  justify-content: flex-end;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%] {\n  margin-left: 1vw;\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: var(--color3);\n  cursor: pointer;\n  text-align: center;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[disabled][_ngcontent-%COMP%] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n.reminder[_ngcontent-%COMP%]    > .form[_ngcontent-%COMP%]    > .controls[_ngcontent-%COMP%]    > .control[_ngcontent-%COMP%]:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=manage-reminder.component.css.map */"] });
var ManageReminderComponent = _ManageReminderComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(ManageReminderComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "manage-reminder", template: '<div class="reminder">\n  <header>\n    <div class="primary">\n      <h3>{{header}}</h3>\n      @if (showRecipientLabel) {\n        <h4>\n          for {{recipient?.firstName}} {{recipient?.lastName}}\n        </h4>\n      }\n    </div>\n    <div class="controls">\n      <button class="control" (click)="closeView()">\n        <i class="fa-solid fa-xmark"></i>\n      </button>\n    </div>\n  </header>\n  <div class="form">\n    <div class="input-wrap">\n      <label>Title</label>\n      <div class="input">\n        <input [(ngModel)]="title" type="text" maxlength="50" placeholder="Reminder Title" />\n      </div>\n    </div>\n    <div class="appointments input-wrap">\n      <label>Appointment</label>\n      <div class="input">\n        <select [(ngModel)]="appointmentId">\n          <option [ngValue]="undefined">-- No Appointment --</option>\n          @for (appointment of appointments; track appointment) {\n            <option\n              [ngValue]="appointment.id"\n              >\n              {{appointment.jobId}}\n              {{appointment.customer?.firstName}} {{appointment.customer?.lastName}}\n            </option>\n          }\n        </select>\n      </div>\n    </div>\n    <div class="input-wrap">\n      <label>Note</label>\n      <div class="input">\n        <textarea [(ngModel)]="note" placeholder="Reminder Note" rows="5"></textarea>\n      </div>\n    </div>\n    <div class="input-wrap">\n      <label>Priority</label>\n      <div class="input">\n        <select [(ngModel)]="priority">\n          <option [ngValue]="ReminderPriority.Standard">Standard</option>\n          <option [ngValue]="ReminderPriority.Critical">Critical</option>\n        </select>\n      </div>\n    </div>\n    <div class="controls">\n      <button class="control" [disabled]="!canSave" (click)="save()">\n        <label>Save Reminder</label>\n      </button>\n    </div>\n  </div>\n</div>', styles: ["/* src/app/shared/reminders/components/manage-reminder/manage-reminder.component.scss */\n.reminder {\n  position: relative;\n}\n.reminder > header {\n  background-color: var(--color2);\n  border-bottom: 0.1vw var(--color2Alt2) solid;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 1vw;\n}\n.reminder > header > .primary > h3 {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n.reminder > header > .primary > h4 {\n  font-size: 1.2vw;\n  color: var(--color5);\n  font-weight: var(--stdweight);\n  font-style: italic;\n}\n.reminder > header > .controls > .control {\n  cursor: pointer;\n}\n.reminder > header > .controls > .control > i {\n  font-size: 1.6vw;\n  color: var(--color1);\n}\n.reminder > .form {\n  padding: 1vw;\n}\n.reminder > .form > .input-wrap {\n  margin-top: 1vw;\n}\n.reminder > .form > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1Alt3);\n  text-transform: uppercase;\n  font-weight: var(--strong);\n}\n.reminder > .form > .input-wrap > .input {\n  margin-top: 0.5vw;\n  border: 0.1vw var(--color2Alt3) solid;\n  padding: 1vw;\n  border-radius: 0.5vw;\n}\n.reminder > .form > .input-wrap > .input select,\n.reminder > .form > .input-wrap > .input input,\n.reminder > .form > .input-wrap > .input textarea {\n  display: block;\n  width: 100%;\n  font-size: 1.4vw;\n  color: var(--color3);\n  font-weight: var(--strong);\n}\n.reminder > .form > .input-wrap > .input textarea {\n  resize: none;\n}\n.reminder > .form > .input-wrap:first-child {\n  margin-top: 0;\n}\n.reminder > .form > .controls {\n  margin-top: 1vw;\n  display: flex;\n  justify-content: flex-end;\n}\n.reminder > .form > .controls > .control {\n  margin-left: 1vw;\n  border-radius: 0.5vw;\n  padding: 0.5vw 1vw;\n  background-color: var(--color3);\n  cursor: pointer;\n  text-align: center;\n}\n.reminder > .form > .controls > .control > label {\n  font-size: 1.4vw;\n  color: var(--color2);\n  font-weight: var(--strong);\n}\n.reminder > .form > .controls > .control[disabled] {\n  opacity: 0.4;\n  pointer-events: none;\n}\n.reminder > .form > .controls > .control:first-child {\n  margin-left: 0;\n}\n/*# sourceMappingURL=manage-reminder.component.css.map */\n"] }]
  }], () => [{ type: UiService }, { type: ReminderService }], { appointments: [{
    type: Input,
    args: ["appointments"]
  }], reminder: [{
    type: Input,
    args: ["reminder"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], close: [{
    type: Output,
    args: ["close"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ManageReminderComponent, { className: "ManageReminderComponent", filePath: "src/app/shared/reminders/components/manage-reminder/manage-reminder.component.ts", lineNumber: 21 });
})();

// src/app/shared/reminders/reminder.module.ts
var _SharedReminderModule = class _SharedReminderModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(ManageReminderComponent, { injector: this.injector });
    customElements.define("manage-reminder", el);
  }
};
_SharedReminderModule.\u0275fac = function SharedReminderModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SharedReminderModule)(\u0275\u0275inject(Injector));
};
_SharedReminderModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _SharedReminderModule });
_SharedReminderModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  CommonModule,
  UiModule,
  ReactiveFormsModule,
  FormsModule
] });
var SharedReminderModule = _SharedReminderModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SharedReminderModule, [{
    type: NgModule,
    args: [{
      declarations: [
        ManageReminderComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        CommonModule,
        UiModule,
        ReactiveFormsModule,
        FormsModule
      ],
      providers: [
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();

// src/app/shared/data/data.module.ts
var _SharedDataModule = class _SharedDataModule {
};
_SharedDataModule.\u0275fac = function SharedDataModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SharedDataModule)();
};
_SharedDataModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _SharedDataModule });
_SharedDataModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ imports: [
  CommonModule,
  RouterModule,
  UiModule,
  ReactiveFormsModule,
  FormsModule
] });
var SharedDataModule = _SharedDataModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SharedDataModule, [{
    type: NgModule,
    args: [{
      declarations: [],
      imports: [
        CommonModule,
        RouterModule,
        UiModule,
        ReactiveFormsModule,
        FormsModule
      ],
      /* Do not put any services in the Shared Module which need to share an instance across multiple modules
          Those should go in the app.module instead */
      providers: [],
      exports: [],
      schemas: [CUSTOM_ELEMENTS_SCHEMA]
    }]
  }], null, null);
})();

// src/app/shared/events/models/event.ts
var RepipeEvent = class {
  constructor(type, subType, referenceId, note = "") {
    this.note = "";
    this.referenceId = referenceId;
    this.type = type;
    this.note = note;
    this.subType = subType;
  }
};
var RepipeEventType;
(function(RepipeEventType2) {
  RepipeEventType2["Lead"] = "Lead";
  RepipeEventType2["Appointment"] = "Appointment";
  RepipeEventType2["Render"] = "Render";
})(RepipeEventType || (RepipeEventType = {}));

// src/app/shared/events/services/event.service.ts
var _EventService = class _EventService {
  constructor() {
  }
  // #region Events
  storeEvent(type, subType, note, referenceId) {
    const event = new RepipeEvent(type, subType, referenceId, note);
  }
};
_EventService.\u0275fac = function EventService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _EventService)();
};
_EventService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _EventService, factory: _EventService.\u0275fac });
var EventService = _EventService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(EventService, [{
    type: Injectable
  }], () => [], null);
})();

// src/app/shared/fixtures/services/fixture.service.ts
var _FixtureService = class _FixtureService {
  constructor(http) {
    this.http = http;
    this.init();
  }
  getAvailableFixtures(marketId) {
    const url = `{{api}}/fixtures/${marketId}`;
    return this.http.get(url);
  }
  // #region Bootstrapping
  init() {
  }
};
_FixtureService.\u0275fac = function FixtureService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _FixtureService)(\u0275\u0275inject(HttpClient));
};
_FixtureService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _FixtureService, factory: _FixtureService.\u0275fac, providedIn: "root" });
var FixtureService = _FixtureService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(FixtureService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }], null);
})();

// src/app/shared/properties/services/property.service.ts
var _PropertyService = class _PropertyService {
  constructor(http) {
    this.http = http;
    this.init();
  }
  getAvailablePropertyEntities(marketId) {
    const url = `{{api}}/properties/${marketId}`;
    return this.http.get(url);
  }
  // #region Bootstrapping
  init() {
  }
};
_PropertyService.\u0275fac = function PropertyService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _PropertyService)(\u0275\u0275inject(HttpClient));
};
_PropertyService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _PropertyService, factory: _PropertyService.\u0275fac, providedIn: "root" });
var PropertyService = _PropertyService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(PropertyService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }], null);
})();

// src/app/main/main.module.ts
var _MainModule = class _MainModule {
};
_MainModule.\u0275fac = function MainModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _MainModule)();
};
_MainModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _MainModule });
_MainModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  DeviceRouteService,
  AiService,
  EventService,
  FixtureService,
  SharedOpportunityModule,
  ReminderService,
  PropertyService,
  UserService,
  SideNavService,
  PaymentsService,
  PresentationService,
  OpportunityService,
  OpportunityUiService,
  OpportunityMigrationService,
  OrderByPipe,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  CommonModule,
  UiModule,
  SharedDataModule,
  SharedPaymentsModule,
  SharedReminderModule,
  SharedOpportunityModule,
  MainRoutingModule
] });
var MainModule = _MainModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(MainModule, [{
    type: NgModule,
    args: [{
      declarations: [
        MainLayoutComponent,
        SideNavLayoutComponent,
        TrainingComponent,
        DummyRouteComponent,
        OpportunityModulesComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        CommonModule,
        UiModule,
        SharedDataModule,
        SharedPaymentsModule,
        SharedReminderModule,
        SharedOpportunityModule,
        MainRoutingModule
      ],
      providers: [
        DeviceRouteService,
        AiService,
        EventService,
        FixtureService,
        SharedOpportunityModule,
        ReminderService,
        PropertyService,
        UserService,
        SideNavService,
        PaymentsService,
        PresentationService,
        OpportunityService,
        OpportunityUiService,
        OpportunityMigrationService,
        OrderByPipe,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], null, null);
})();
export {
  MainModule
};
//# sourceMappingURL=chunk-VV44BUIF.js.map
