import {
  AdministrationService
} from "./chunk-HFHXWAGX.js";
import {
  InternalRouteService
} from "./chunk-6RSEFXQV.js";
import {
  InternalRoute,
  RouteLoadDirection
} from "./chunk-NWZAVPC4.js";
import {
  createCustomElement
} from "./chunk-4VXBNATF.js";
import {
  UiService
} from "./chunk-DQROWZRM.js";
import {
  BehaviorSubject,
  CUSTOM_ELEMENTS_SCHEMA,
  CommonModule,
  Component,
  DatePipe,
  DefaultValueAccessor,
  FormsModule,
  HttpClient,
  Injectable,
  Injector,
  Input,
  LoaderComponent,
  NgControlStatus,
  NgModel,
  NgModule,
  NumberValueAccessor,
  OrderByPipe,
  ReactiveFormsModule,
  UiModule,
  ViewChild,
  map,
  provideHttpClient,
  setClassMetadata,
  withInterceptorsFromDi,
  ɵsetClassDebugInfo,
  ɵɵadvance,
  ɵɵclassMap,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵconditionalCreate,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵinterpolate1,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnamespaceHTML,
  ɵɵnamespaceSVG,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind2,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵrepeater,
  ɵɵrepeaterCreate,
  ɵɵrepeaterTrackByIdentity,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-S237TOF5.js";
import "./chunk-RVA4KI76.js";

// src/app/administration/netsuite/models/navigation.ts
var RouteType;
(function(RouteType2) {
  RouteType2["settings"] = "settings";
})(RouteType || (RouteType = {}));

// src/app/administration/netsuite/models/settings.ts
var NetSuiteSyncSetting = class {
  constructor() {
    this.name = "";
    this.frequencyInSeconds = 0;
    this.enabled = true;
    this.newFrequency = 0;
    this.storing = false;
  }
  /* Local */
  get healthy() {
    return this.enabled && this.status == "Successful";
  }
};

// src/app/administration/netsuite/services/netsuite.service.ts
var _NetSuiteService = class _NetSuiteService {
  constructor(http) {
    this.http = http;
  }
  // #region Sync Settings
  getSyncSettings() {
    const url = `{{api}}/sync/netsuite/settings/all`;
    return this.http.get(url).pipe(map((settings) => {
      const mappedSettings = [];
      settings.forEach((setting) => {
        const mappedSetting = Object.assign(new NetSuiteSyncSetting(), setting);
        mappedSetting.newFrequency = mappedSetting.frequencyInSeconds;
        if (mappedSetting.nextSync_Utc != null) {
          const nextSync_Utc = new Date(mappedSetting.nextSync_Utc);
          mappedSetting.nextSync = nextSync_Utc.toISOString().slice(0, 16);
        }
        mappedSettings.push(mappedSetting);
      });
      return mappedSettings;
    }));
  }
  enableSetting(name) {
    const url = `{{api}}/sync/netsuite/settings/${name}/enable`;
    return this.http.put(url, null);
  }
  disableSetting(name) {
    const url = `{{api}}/sync/netsuite/settings/${name}/disable`;
    return this.http.put(url, null);
  }
};
_NetSuiteService.\u0275fac = function NetSuiteService_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _NetSuiteService)(\u0275\u0275inject(HttpClient));
};
_NetSuiteService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _NetSuiteService, factory: _NetSuiteService.\u0275fac, providedIn: "root" });
var NetSuiteService = _NetSuiteService;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(NetSuiteService, [{
    type: Injectable,
    args: [{
      providedIn: "root"
    }]
  }], () => [{ type: HttpClient }], null);
})();

// src/app/administration/netsuite/components/settings/settings.component.ts
var _c0 = ["componentElm"];
function SettingsComponent_For_4_Conditional_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 6);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(1, "svg", 21);
    \u0275\u0275element(2, "polyline", 22);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275element(3, "div", 23);
    \u0275\u0275elementEnd();
  }
}
function SettingsComponent_For_4_Conditional_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 7);
    \u0275\u0275element(1, "div", 14);
    \u0275\u0275elementEnd();
  }
}
function SettingsComponent_For_4_Conditional_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 8);
    \u0275\u0275element(1, "textarea", 24);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const setting_r2 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngModel", setting_r2.message);
  }
}
function SettingsComponent_For_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 4)(1, "header")(2, "h3");
    \u0275\u0275text(3);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(4, "div", 5);
    \u0275\u0275conditionalCreate(5, SettingsComponent_For_4_Conditional_5_Template, 4, 0, "div", 6);
    \u0275\u0275conditionalCreate(6, SettingsComponent_For_4_Conditional_6_Template, 2, 0, "div", 7);
    \u0275\u0275conditionalCreate(7, SettingsComponent_For_4_Conditional_7_Template, 2, 1, "div", 8);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "div", 9)(9, "div", 10)(10, "div", 11)(11, "label");
    \u0275\u0275text(12, "Enabled?");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "div", 12)(14, "button", 13);
    \u0275\u0275listener("click", function SettingsComponent_For_4_Template_button_click_14_listener() {
      const setting_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.toggleEnabled(setting_r2));
    });
    \u0275\u0275element(15, "span", 14);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(16, "div", 15)(17, "label");
    \u0275\u0275text(18, "Last Successful Sync");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(19, "span", 16);
    \u0275\u0275text(20);
    \u0275\u0275pipe(21, "date");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(22, "div", 17)(23, "div", 11)(24, "label");
    \u0275\u0275text(25, "Frequency (in Seconds)");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(26, "div", 12)(27, "input", 18);
    \u0275\u0275twoWayListener("ngModelChange", function SettingsComponent_For_4_Template_input_ngModelChange_27_listener($event) {
      const setting_r2 = \u0275\u0275restoreView(_r1).$implicit;
      \u0275\u0275twoWayBindingSet(setting_r2.newFrequency, $event) || (setting_r2.newFrequency = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(28, "div", 19)(29, "div", 11)(30, "label");
    \u0275\u0275text(31, "Scheduled Next Sync");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(32, "div", 12)(33, "input", 20);
    \u0275\u0275listener("change", function SettingsComponent_For_4_Template_input_change_33_listener() {
      const setting_r2 = \u0275\u0275restoreView(_r1).$implicit;
      const ctx_r2 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r2.updateNextSync(setting_r2));
    });
    \u0275\u0275twoWayListener("ngModelChange", function SettingsComponent_For_4_Template_input_ngModelChange_33_listener($event) {
      const setting_r2 = \u0275\u0275restoreView(_r1).$implicit;
      \u0275\u0275twoWayBindingSet(setting_r2.nextSync, $event) || (setting_r2.nextSync = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd()()()()()();
  }
  if (rf & 2) {
    const setting_r2 = ctx.$implicit;
    \u0275\u0275classProp("disabled", setting_r2.storing);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(setting_r2.name);
    \u0275\u0275advance(2);
    \u0275\u0275conditional(setting_r2.healthy ? 5 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(!setting_r2.healthy ? 6 : -1);
    \u0275\u0275advance();
    \u0275\u0275conditional(setting_r2.message != null ? 7 : -1);
    \u0275\u0275advance(7);
    \u0275\u0275classProp("enabled", setting_r2.enabled);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind2(21, 11, setting_r2.lastSync_Utc, "MMM dd, yyyy hh:mm a"), " ");
    \u0275\u0275advance(7);
    \u0275\u0275twoWayProperty("ngModel", setting_r2.newFrequency);
    \u0275\u0275advance(6);
    \u0275\u0275twoWayProperty("ngModel", setting_r2.nextSync);
  }
}
var _SettingsComponent = class _SettingsComponent {
  constructor(netSuiteService) {
    this.netSuiteService = netSuiteService;
    this.retrievingSyncSettings = false;
    this.syncSettings = [];
  }
  get storingSetting() {
    return this.syncSettings.find((x) => x.storing) != null;
  }
  getSyncSettings() {
    window.clearTimeout(this.syncTimer);
    this.retrievingSyncSettings = true;
    this.netSuiteService.getSyncSettings().subscribe({
      next: (settings) => {
        this.syncSettings = settings;
        this.retrievingSyncSettings = false;
        this.syncTimer = window.setTimeout(() => {
          this.getSyncSettings();
        }, 6e4);
      }
    });
  }
  toggleEnabled(setting) {
    setting.enabled = !setting.enabled;
    setting.storing = true;
    if (setting.enabled) {
      this.netSuiteService.enableSetting(setting.name).subscribe({
        next: () => {
          setting.storing = false;
        },
        error: () => {
          setting.storing = false;
        }
      });
    } else {
      this.netSuiteService.disableSetting(setting.name).subscribe({
        next: () => {
          setting.storing = false;
        },
        error: () => {
          setting.storing = false;
        }
      });
    }
  }
  updateNextSync(setting) {
  }
  // #endregion
  // #region UI
  get showLoader() {
    return this.retrievingSyncSettings || this.storingSetting;
  }
  init() {
    this.getSyncSettings();
  }
  // #endregion
  ngAfterViewInit() {
    setTimeout(() => {
      this.init();
      setTimeout(() => {
        if (this.route != null) {
          this.route.initialized.next();
        }
      }, 32);
    }, 16);
  }
  ngOnDestroy() {
  }
};
_SettingsComponent.\u0275fac = function SettingsComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _SettingsComponent)(\u0275\u0275directiveInject(NetSuiteService));
};
_SettingsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _SettingsComponent, selectors: [["settings"]], viewQuery: function SettingsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { route: "route" }, standalone: false, decls: 7, vars: 5, consts: [["id", "syncSettings"], [1, "content"], [1, "settings"], [1, "setting", 3, "disabled"], [1, "setting"], [1, "status"], [1, "heartbeat"], [1, "flatline"], [1, "message"], [1, "meta"], [1, "enabled"], [1, "input-wrap"], [1, "input"], [1, "option-control", 3, "click"], [1, "indicator"], [1, "last-sync"], [1, "value"], [1, "frequency"], ["type", "number", 3, "ngModelChange", "ngModel"], [1, "next-sync"], ["type", "datetime-local", 3, "change", "ngModelChange", "ngModel"], ["version", "1.0", "xmlns", "http://www.w3.org/2000/svg", 0, "xmlns", "xlink", "http://www.w3.org/1999/xlink", "x", "0px", "y", "0px", "viewBox", "0 0 150 73", "enable-background", "new 0 0 150 73", 0, "xml", "space", "preserve"], ["fill", "none", "stroke-miterlimit", "10", "points", "0,45.486 38.514,45.486 44.595,33.324 50.676,45.486 57.771,45.486 62.838,55.622 71.959,9 80.067,63.729 84.122,45.486 97.297,45.486 103.379,40.419 110.473,45.486 150,45.486"], [1, "fader"], ["rows", "3", "readonly", "", 3, "ngModel"]], template: function SettingsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 0)(1, "div", 1)(2, "div", 2);
    \u0275\u0275repeaterCreate(3, SettingsComponent_For_4_Template, 34, 14, "div", 3, \u0275\u0275repeaterTrackByIdentity);
    \u0275\u0275pipe(5, "orderBy");
    \u0275\u0275elementEnd()()();
    \u0275\u0275element(6, "loader");
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275repeater(\u0275\u0275pipeBind2(5, 2, ctx.syncSettings, "name"));
    \u0275\u0275advance(3);
    \u0275\u0275classProp("active", ctx.showLoader);
  }
}, dependencies: [LoaderComponent, DefaultValueAccessor, NumberValueAccessor, NgControlStatus, NgModel, OrderByPipe, DatePipe], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes _ngcontent-%COMP%_flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n#syncSettings[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%] {\n  position: relative;\n  padding: 2vw 5vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: flex-start;\n  flex-wrap: wrap;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%] {\n  width: calc(33.3333333333% - 1.3333333333vw);\n  margin-left: 2vw;\n  margin-top: 2vw;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  padding: 2vw;\n  -moz-transition: opacity 0.4s linear;\n  -o-transition: opacity 0.4s linear;\n  -webkit-transition: opacity 0.4s linear;\n  transition: opacity 0.4s linear;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > header[_ngcontent-%COMP%]   h3[_ngcontent-%COMP%] {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .heartbeat[_ngcontent-%COMP%] {\n  height: 10vw;\n  position: relative;\n  overflow: hidden;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .heartbeat[_ngcontent-%COMP%]   svg[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .heartbeat[_ngcontent-%COMP%]   svg[_ngcontent-%COMP%]   polyline[_ngcontent-%COMP%] {\n  stroke: var(--success);\n  stroke-width: 0.2vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .heartbeat[_ngcontent-%COMP%]   .fader[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2Alt1-raw), 1) 0%;\n  background-image:\n    linear-gradient(\n      to right,\n      rgba(var(--color2Alt1-raw), 1) 0%,\n      rgba(var(--color2Alt1-raw), 1) 50%,\n      rgba(var(--color2Alt1-raw), 0) 100%);\n  -moz-animation-name: heartRateOut;\n  -ms-animation-name: heartRateOut;\n  -o-animation-name: heartRateOut;\n  -webkit-animation-name: _ngcontent-%COMP%_heartRateOut;\n  animation-name: _ngcontent-%COMP%_heartRateOut;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 4s;\n  -ms-animation-duration: 4s;\n  -o-animation-duration: 4s;\n  -webkit-animation-duration: 4s;\n  animation-duration: 4s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .flatline[_ngcontent-%COMP%] {\n  height: 10vw;\n  position: relative;\n  overflow: hidden;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .flatline[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  height: 0.2vw;\n  width: 100%;\n  background-color: rgba(0, 0, 0, 0) 0%;\n  background-image:\n    linear-gradient(\n      to right,\n      rgba(0, 0, 0, 0) 0%,\n      rgba(var(--error-raw), 1) 25%,\n      rgba(var(--error-raw), 1) 50%,\n      rgba(var(--error-raw), 1) 75%,\n      rgba(0, 0, 0, 0) 100%);\n  -moz-animation-name: flatline;\n  -ms-animation-name: flatline;\n  -o-animation-name: flatline;\n  -webkit-animation-name: _ngcontent-%COMP%_flatline;\n  animation-name: _ngcontent-%COMP%_flatline;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 4s;\n  -ms-animation-duration: 4s;\n  -o-animation-duration: 4s;\n  -webkit-animation-duration: 4s;\n  animation-duration: 4s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%] {\n  margin: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt1) solid;\n  padding: 0.5vw;\n  border-radius: 0.5vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .status[_ngcontent-%COMP%]    > .message[_ngcontent-%COMP%]   textarea[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 6vw;\n  resize: none;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%] {\n  margin-top: 1vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .enabled[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .enabled[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .enabled[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option-control[_ngcontent-%COMP%] {\n  background-color: var(--color2Alt4);\n  width: 4.5vw;\n  height: 2.5vw;\n  border-radius: 999px;\n  position: relative;\n  cursor: pointer;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .enabled[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option-control[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%] {\n  height: 2vw;\n  width: 2vw;\n  position: absolute;\n  top: 0.25vw;\n  left: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 100%;\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n  -moz-transition: background-color 0.2s, transform 0.2s;\n  -o-transition: background-color 0.2s, transform 0.2s;\n  -webkit-transition: background-color 0.2s, transform 0.2s;\n  transition: background-color 0.2s, transform 0.2s;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .enabled[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option-control.enabled[_ngcontent-%COMP%] {\n  background-color: var(--success);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .enabled[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > .option-control.enabled[_ngcontent-%COMP%]    > .indicator[_ngcontent-%COMP%] {\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .last-sync[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .last-sync[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .last-sync[_ngcontent-%COMP%]    > .value[_ngcontent-%COMP%] {\n  display: block;\n  margin-top: 0.25vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--mdweight);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .frequency[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .frequency[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .frequency[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  border: 0.1vw var(--color2Alt4) solid;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .frequency[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .frequency[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]:focus-within    > input[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .next-sync[_ngcontent-%COMP%] {\n  margin-top: 0.5vw;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .next-sync[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > label[_ngcontent-%COMP%] {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .next-sync[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%] {\n  margin-top: 0.25vw;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  border: 0.1vw var(--color2Alt4) solid;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .next-sync[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]    > input[_ngcontent-%COMP%] {\n  display: block;\n  width: 100%;\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]    > .meta[_ngcontent-%COMP%]    > .next-sync[_ngcontent-%COMP%]    > .input-wrap[_ngcontent-%COMP%]    > .input[_ngcontent-%COMP%]:focus-within    > input[_ngcontent-%COMP%] {\n  color: var(--color3);\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting.disabled[_ngcontent-%COMP%] {\n  pointer-events: none;\n  opacity: 0.4;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]:first-child, \n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]:nth-child(3n+1) {\n  margin-left: 0;\n}\n#syncSettings[_ngcontent-%COMP%]    > .content[_ngcontent-%COMP%]    > .settings[_ngcontent-%COMP%]    > .setting[_ngcontent-%COMP%]:nth-child(-n+3) {\n  margin-top: 0;\n}\nloader[_ngcontent-%COMP%] {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active[_ngcontent-%COMP%] {\n  opacity: 1;\n}\n/*# sourceMappingURL=settings.component.css.map */"] });
var SettingsComponent = _SettingsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(SettingsComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "settings", template: `<section id="syncSettings">
  <div class="content">
    <div class="settings">
      @for (setting of syncSettings | orderBy:'name'; track setting) {
        <div class="setting" [class.disabled]="setting.storing"
          >
          <header>
            <h3>{{setting.name}}</h3>
          </header>
          <div class="status">
            @if (setting.healthy) {
              <div class="heartbeat">
                <svg version="1.0" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                  x="0px" y="0px" viewBox="0 0 150 73" enable-background="new 0 0 150 73"
                  xml:space="preserve">
                  <polyline fill="none" stroke-miterlimit="10"
                    points="0,45.486 38.514,45.486 44.595,33.324 50.676,45.486 57.771,45.486 62.838,55.622 71.959,9 80.067,63.729 84.122,45.486 97.297,45.486 103.379,40.419 110.473,45.486 150,45.486" />
                </svg>
                <div class="fader"></div>
              </div>
            }
            @if (!setting.healthy) {
              <div class="flatline">
                <div class="indicator"></div>
              </div>
            }
            @if (setting.message != null) {
              <div class="message">
                <textarea rows="3" readonly [ngModel]="setting.message"></textarea>
              </div>
            }
          </div>
          <div class="meta">
            <div class="enabled">
              <div class="input-wrap">
                <label>Enabled?</label>
                <div class="input">
                  <button class="option-control" (click)="toggleEnabled(setting)"
                    [class.enabled]="setting.enabled">
                    <span class="indicator"></span>
                  </button>
                </div>
              </div>
            </div>
            <div class="last-sync">
              <label>Last Successful Sync</label>
              <span class="value">
                {{setting.lastSync_Utc | date:'MMM dd, yyyy hh:mm a'}}
              </span>
            </div>
            <div class="frequency">
              <div class="input-wrap">
                <label>Frequency (in Seconds)</label>
                <div class="input">
                  <input type="number" [(ngModel)]="setting.newFrequency" />
                </div>
              </div>
            </div>
            <div class="next-sync">
              <div class="input-wrap">
                <label>Scheduled Next Sync</label>
                <div class="input">
                  <input type="datetime-local" (change)="updateNextSync(setting)"
                    [(ngModel)]="setting.nextSync" />
                </div>
              </div>
            </div>
          </div>
        </div>
      }
    </div>
  </div>
</section>

<loader [class.active]="showLoader"></loader>`, styles: ["/* src/app/administration/netsuite/components/settings/settings.component.scss */\n@-webkit-keyframes heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes heartRateOut {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-webkit-keyframes flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-moz-keyframes flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@-o-keyframes flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n@keyframes flatline {\n  0% {\n    -moz-transform: translateX(-100%);\n    -ms-transform: translateX(-100%);\n    -o-transform: translateX(-100%);\n    -webkit-transform: translateX(-100%);\n    transform: translateX(-100%);\n  }\n  100% {\n    -moz-transform: translateX(100%);\n    -ms-transform: translateX(100%);\n    -o-transform: translateX(100%);\n    -webkit-transform: translateX(100%);\n    transform: translateX(100%);\n  }\n}\n#syncSettings {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  z-index: 1;\n  overflow-x: hidden;\n}\n#syncSettings > .content {\n  position: relative;\n  padding: 2vw 5vw;\n}\n#syncSettings > .content > .settings {\n  display: flex;\n  align-items: flex-start;\n  flex-wrap: wrap;\n}\n#syncSettings > .content > .settings > .setting {\n  width: calc(33.3333333333% - 1.3333333333vw);\n  margin-left: 2vw;\n  margin-top: 2vw;\n  border: 0.1vw var(--color2Alt3) solid;\n  border-radius: 1vw;\n  background-color: var(--color2);\n  padding: 2vw;\n  -moz-transition: opacity 0.4s linear;\n  -o-transition: opacity 0.4s linear;\n  -webkit-transition: opacity 0.4s linear;\n  transition: opacity 0.4s linear;\n}\n#syncSettings > .content > .settings > .setting > header h3 {\n  font-size: 2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#syncSettings > .content > .settings > .setting > .status {\n  margin-top: 1vw;\n  background-color: var(--color2Alt1);\n  border: 0.1vw var(--color2Alt2) solid;\n  border-radius: 0.5vw;\n}\n#syncSettings > .content > .settings > .setting > .status > .heartbeat {\n  height: 10vw;\n  position: relative;\n  overflow: hidden;\n}\n#syncSettings > .content > .settings > .setting > .status > .heartbeat svg {\n  width: 100%;\n  height: 100%;\n}\n#syncSettings > .content > .settings > .setting > .status > .heartbeat svg polyline {\n  stroke: var(--success);\n  stroke-width: 0.2vw;\n}\n#syncSettings > .content > .settings > .setting > .status > .heartbeat .fader {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: rgba(var(--color2Alt1-raw), 1) 0%;\n  background-image:\n    linear-gradient(\n      to right,\n      rgba(var(--color2Alt1-raw), 1) 0%,\n      rgba(var(--color2Alt1-raw), 1) 50%,\n      rgba(var(--color2Alt1-raw), 0) 100%);\n  -moz-animation-name: heartRateOut;\n  -ms-animation-name: heartRateOut;\n  -o-animation-name: heartRateOut;\n  -webkit-animation-name: heartRateOut;\n  animation-name: heartRateOut;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 4s;\n  -ms-animation-duration: 4s;\n  -o-animation-duration: 4s;\n  -webkit-animation-duration: 4s;\n  animation-duration: 4s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#syncSettings > .content > .settings > .setting > .status > .flatline {\n  height: 10vw;\n  position: relative;\n  overflow: hidden;\n}\n#syncSettings > .content > .settings > .setting > .status > .flatline > .indicator {\n  position: absolute;\n  top: 50%;\n  -moz-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  -o-transform: translateY(-50%);\n  -webkit-transform: translateY(-50%);\n  transform: translateY(-50%);\n  height: 0.2vw;\n  width: 100%;\n  background-color: rgba(0, 0, 0, 0) 0%;\n  background-image:\n    linear-gradient(\n      to right,\n      rgba(0, 0, 0, 0) 0%,\n      rgba(var(--error-raw), 1) 25%,\n      rgba(var(--error-raw), 1) 50%,\n      rgba(var(--error-raw), 1) 75%,\n      rgba(0, 0, 0, 0) 100%);\n  -moz-animation-name: flatline;\n  -ms-animation-name: flatline;\n  -o-animation-name: flatline;\n  -webkit-animation-name: flatline;\n  animation-name: flatline;\n  -moz-animation-iteration-count: infinite;\n  -ms-animation-iteration-count: infinite;\n  -o-animation-iteration-count: infinite;\n  -webkit-animation-iteration-count: infinite;\n  animation-iteration-count: infinite;\n  -moz-animation-timing-function: linear;\n  -ms-animation-timing-function: linear;\n  -o-animation-timing-function: linear;\n  -webkit-animation-timing-function: linear;\n  animation-timing-function: linear;\n  -moz-animation-duration: 4s;\n  -ms-animation-duration: 4s;\n  -o-animation-duration: 4s;\n  -webkit-animation-duration: 4s;\n  animation-duration: 4s;\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#syncSettings > .content > .settings > .setting > .status > .message {\n  margin: 1vw;\n  background-color: var(--color2);\n  border: 0.1vw var(--color2Alt1) solid;\n  padding: 0.5vw;\n  border-radius: 0.5vw;\n}\n#syncSettings > .content > .settings > .setting > .status > .message textarea {\n  width: 100%;\n  height: 6vw;\n  resize: none;\n  font-size: 1.2vw;\n  font-weight: var(--stdweight);\n}\n#syncSettings > .content > .settings > .setting > .meta {\n  margin-top: 1vw;\n}\n#syncSettings > .content > .settings > .setting > .meta > .enabled > .input-wrap {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n#syncSettings > .content > .settings > .setting > .meta > .enabled > .input-wrap > label {\n  font-size: 1.4vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n}\n#syncSettings > .content > .settings > .setting > .meta > .enabled > .input-wrap > .input > .option-control {\n  background-color: var(--color2Alt4);\n  width: 4.5vw;\n  height: 2.5vw;\n  border-radius: 999px;\n  position: relative;\n  cursor: pointer;\n  -moz-transition: background-color 0.2s linear;\n  -o-transition: background-color 0.2s linear;\n  -webkit-transition: background-color 0.2s linear;\n  transition: background-color 0.2s linear;\n}\n#syncSettings > .content > .settings > .setting > .meta > .enabled > .input-wrap > .input > .option-control > .indicator {\n  height: 2vw;\n  width: 2vw;\n  position: absolute;\n  top: 0.25vw;\n  left: 0.25vw;\n  background-color: var(--color2);\n  border-radius: 100%;\n  -moz-transform: translateX(0);\n  -ms-transform: translateX(0);\n  -o-transform: translateX(0);\n  -webkit-transform: translateX(0);\n  transform: translateX(0);\n  -moz-transition: background-color 0.2s, transform 0.2s;\n  -o-transition: background-color 0.2s, transform 0.2s;\n  -webkit-transition: background-color 0.2s, transform 0.2s;\n  transition: background-color 0.2s, transform 0.2s;\n}\n#syncSettings > .content > .settings > .setting > .meta > .enabled > .input-wrap > .input > .option-control.enabled {\n  background-color: var(--success);\n}\n#syncSettings > .content > .settings > .setting > .meta > .enabled > .input-wrap > .input > .option-control.enabled > .indicator {\n  -moz-transform: translateX(100%);\n  -ms-transform: translateX(100%);\n  -o-transform: translateX(100%);\n  -webkit-transform: translateX(100%);\n  transform: translateX(100%);\n}\n#syncSettings > .content > .settings > .setting > .meta > .last-sync {\n  margin-top: 0.5vw;\n}\n#syncSettings > .content > .settings > .setting > .meta > .last-sync > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#syncSettings > .content > .settings > .setting > .meta > .last-sync > .value {\n  display: block;\n  margin-top: 0.25vw;\n  font-size: 1.6vw;\n  color: var(--color1);\n  font-weight: var(--mdweight);\n}\n#syncSettings > .content > .settings > .setting > .meta > .frequency {\n  margin-top: 0.5vw;\n}\n#syncSettings > .content > .settings > .setting > .meta > .frequency > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#syncSettings > .content > .settings > .setting > .meta > .frequency > .input-wrap > .input {\n  margin-top: 0.25vw;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  border: 0.1vw var(--color2Alt4) solid;\n}\n#syncSettings > .content > .settings > .setting > .meta > .frequency > .input-wrap > .input > input {\n  display: block;\n  width: 100%;\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#syncSettings > .content > .settings > .setting > .meta > .frequency > .input-wrap > .input:focus-within > input {\n  color: var(--color3);\n}\n#syncSettings > .content > .settings > .setting > .meta > .next-sync {\n  margin-top: 0.5vw;\n}\n#syncSettings > .content > .settings > .setting > .meta > .next-sync > .input-wrap > label {\n  font-size: 1.2vw;\n  color: var(--color1);\n  font-weight: var(--strong);\n  line-height: 1;\n}\n#syncSettings > .content > .settings > .setting > .meta > .next-sync > .input-wrap > .input {\n  margin-top: 0.25vw;\n  border-radius: 0.5vw;\n  padding: 0.5vw;\n  border: 0.1vw var(--color2Alt4) solid;\n}\n#syncSettings > .content > .settings > .setting > .meta > .next-sync > .input-wrap > .input > input {\n  display: block;\n  width: 100%;\n  font-size: 1.6vw;\n  color: var(--color1Alt2);\n  font-weight: var(--mdweight);\n  -moz-transition: color 0.2s linear;\n  -o-transition: color 0.2s linear;\n  -webkit-transition: color 0.2s linear;\n  transition: color 0.2s linear;\n}\n#syncSettings > .content > .settings > .setting > .meta > .next-sync > .input-wrap > .input:focus-within > input {\n  color: var(--color3);\n}\n#syncSettings > .content > .settings > .setting.disabled {\n  pointer-events: none;\n  opacity: 0.4;\n}\n#syncSettings > .content > .settings > .setting:first-child,\n#syncSettings > .content > .settings > .setting:nth-child(3n+1) {\n  margin-left: 0;\n}\n#syncSettings > .content > .settings > .setting:nth-child(-n+3) {\n  margin-top: 0;\n}\nloader {\n  position: absolute;\n  bottom: 2vw;\n  right: 2vw;\n  height: 4vw;\n  width: 4vw;\n  z-index: 2;\n  display: block;\n  opacity: 0;\n  pointer-events: none;\n  -moz-transition: opacity 0.5s linear;\n  -o-transition: opacity 0.5s linear;\n  -webkit-transition: opacity 0.5s linear;\n  transition: opacity 0.5s linear;\n}\nloader.active {\n  opacity: 1;\n}\n/*# sourceMappingURL=settings.component.css.map */\n"] }]
  }], () => [{ type: NetSuiteService }], { route: [{
    type: Input,
    args: ["route"]
  }], componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(SettingsComponent, { className: "SettingsComponent", filePath: "src/app/administration/netsuite/components/settings/settings.component.ts", lineNumber: 19 });
})();

// src/app/administration/netsuite/components/layout/layout.component.ts
var _c02 = ["componentElm"];
function LayoutComponent_Conditional_3_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "settings", 4);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275classMap(\u0275\u0275interpolate1("route ", ctx_r0.settingsRoute == null ? null : ctx_r0.settingsRoute.loadDirection));
    \u0275\u0275classProp("rendered", ctx_r0.settingsRoute == null ? null : ctx_r0.settingsRoute.rendered)("animate", ctx_r0.settingsRoute == null ? null : ctx_r0.settingsRoute.animating)("closing", ctx_r0.settingsRoute == null ? null : ctx_r0.settingsRoute.closing);
    \u0275\u0275property("route", ctx_r0.settingsRoute);
  }
}
var _LayoutComponent = class _LayoutComponent {
  constructor(routeService, adminService, uiService) {
    this.routeService = routeService;
    this.adminService = adminService;
    this.uiService = uiService;
    this.RouteType = RouteType;
    this.routesInitialized = false;
    this.params = new BehaviorSubject([]);
  }
  get routes() {
    return this.routeService.routes;
  }
  initRoutes(initialRouteType = void 0) {
    setTimeout(() => {
      if (this.componentElm != null) {
        const routes = {
          [RouteType.settings]: new InternalRoute(RouteType.settings)
        };
        const initialRoute = initialRouteType != null ? initialRouteType : RouteType.settings;
        this.routeService.init(routes, initialRoute, 250, this.componentElm.nativeElement);
        this.routeSubscription = this.routeService.activeRoute.subscribe({
          next: (route) => {
            if (route != null) {
              switch (route.type) {
                case RouteType.settings:
                  {
                    this.setTitle("NetSuite Sync Modules");
                  }
                  break;
              }
            }
          }
        });
        this.routesInitialized = true;
      }
    }, 0);
  }
  viewRoute(type) {
    if (type != null) {
      this.routeService.viewRoute(type, RouteLoadDirection.Forward, true);
    }
  }
  // #endregion
  // #region Settings
  get settingsRoute() {
    return this.routes[RouteType.settings];
  }
  watchParams() {
    this.paramsSubscription = this.params.subscribe({
      next: (params) => {
        let route = params[0]?.toLowerCase();
        if (route != null) {
          const routeMatches = Object.values(RouteType).includes(route);
          if (routeMatches) {
            if (!this.routesInitialized) {
              this.initRoutes(route);
            } else {
              this.viewRoute(route);
            }
          } else {
            if (!this.routesInitialized) {
              this.initRoutes();
            }
          }
        }
      }
    });
  }
  setTitle(routeTitle) {
    this.adminService.routeTitle.next(routeTitle);
  }
  init() {
    this.watchParams();
  }
  // #endregion
  ngOnInit() {
    this.init();
  }
  ngOnDestroy() {
  }
};
_LayoutComponent.\u0275fac = function LayoutComponent_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _LayoutComponent)(\u0275\u0275directiveInject(InternalRouteService), \u0275\u0275directiveInject(AdministrationService), \u0275\u0275directiveInject(UiService));
};
_LayoutComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _LayoutComponent, selectors: [["layout"]], viewQuery: function LayoutComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.componentElm = _t.first);
  }
}, inputs: { params: "params" }, standalone: false, decls: 4, vars: 1, consts: [["componentElm", ""], ["id", "entitiesLayout"], [1, "routes"], [3, "class", "route", "rendered", "animate", "closing"], [3, "route"]], template: function LayoutComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "section", 1, 0)(2, "div", 2);
    \u0275\u0275conditionalCreate(3, LayoutComponent_Conditional_3_Template, 1, 10, "settings", 3);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(3);
    \u0275\u0275conditional((ctx.settingsRoute == null ? null : ctx.settingsRoute.active) ? 3 : -1);
  }
}, dependencies: [SettingsComponent], styles: ["\n\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes _ngcontent-%COMP%_reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#entitiesLayout[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%] {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route[_ngcontent-%COMP%]:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.forward.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate[_ngcontent-%COMP%]:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout[_ngcontent-%COMP%]    > .routes[_ngcontent-%COMP%]    > .route.reverse.animate.closing[_ngcontent-%COMP%] {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  animation-name: _ngcontent-%COMP%_reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */"] });
var LayoutComponent = _LayoutComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(LayoutComponent, [{
    type: Component,
    args: [{ standalone: false, selector: "layout", template: '<section id="entitiesLayout" #componentElm>\n  <div class="routes">\n    @if (settingsRoute?.active) {\n      <settings\n        class="route {{settingsRoute?.loadDirection}}"\n        [route]="settingsRoute"\n        [class.rendered]="settingsRoute?.rendered"\n        [class.animate]="settingsRoute?.animating"\n      [class.closing]="settingsRoute?.closing"></settings>\n    }\n  </div>\n</section>', styles: ["/* src/app/administration/netsuite/components/layout/layout.component.scss */\n@-webkit-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes forwardRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes forwardRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-webkit-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-moz-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-o-keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@keyframes reverseRouteLoadIn {\n  0% {\n    -moz-transform: translateY(100%);\n    -ms-transform: translateY(100%);\n    -o-transform: translateY(100%);\n    -webkit-transform: translateY(100%);\n    transform: translateY(100%);\n  }\n  100% {\n    -moz-transform: translateY(0);\n    -ms-transform: translateY(0);\n    -o-transform: translateY(0);\n    -webkit-transform: translateY(0);\n    transform: translateY(0);\n  }\n}\n@-webkit-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-moz-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@-o-keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n@keyframes reverseRouteLoadOut {\n  0% {\n    -moz-transform: scale(1);\n    -ms-transform: scale(1);\n    -o-transform: scale(1);\n    -webkit-transform: scale(1);\n    transform: scale(1);\n    opacity: 1;\n  }\n  100% {\n    -moz-transform: scale(0.8);\n    -ms-transform: scale(0.8);\n    -o-transform: scale(0.8);\n    -webkit-transform: scale(0.8);\n    transform: scale(0.8);\n    opacity: 0;\n  }\n}\n#entitiesLayout {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background-color: var(--color2Alt1);\n}\n#entitiesLayout > .routes > .route {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow-x: hidden;\n  will-change: transform;\n}\n#entitiesLayout > .routes > .route:not(.rendered):not(.animate) {\n  opacity: 0;\n}\n#entitiesLayout > .routes > .route.forward.animate:not(.closing) {\n  -moz-animation-name: forwardRouteLoadIn;\n  -ms-animation-name: forwardRouteLoadIn;\n  -o-animation-name: forwardRouteLoadIn;\n  -webkit-animation-name: forwardRouteLoadIn;\n  animation-name: forwardRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.forward.animate.closing {\n  -moz-animation-name: forwardRouteLoadOut;\n  -ms-animation-name: forwardRouteLoadOut;\n  -o-animation-name: forwardRouteLoadOut;\n  -webkit-animation-name: forwardRouteLoadOut;\n  animation-name: forwardRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.reverse.animate:not(.closing) {\n  -moz-animation-name: reverseRouteLoadIn;\n  -ms-animation-name: reverseRouteLoadIn;\n  -o-animation-name: reverseRouteLoadIn;\n  -webkit-animation-name: reverseRouteLoadIn;\n  animation-name: reverseRouteLoadIn;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n#entitiesLayout > .routes > .route.reverse.animate.closing {\n  -moz-animation-name: reverseRouteLoadOut;\n  -ms-animation-name: reverseRouteLoadOut;\n  -o-animation-name: reverseRouteLoadOut;\n  -webkit-animation-name: reverseRouteLoadOut;\n  animation-name: reverseRouteLoadOut;\n  -moz-animation-iteration-count: 1;\n  -ms-animation-iteration-count: 1;\n  -o-animation-iteration-count: 1;\n  -webkit-animation-iteration-count: 1;\n  animation-iteration-count: 1;\n  -moz-animation-timing-function: var(--easeInOutQuad);\n  -ms-animation-timing-function: var(--easeInOutQuad);\n  -o-animation-timing-function: var(--easeInOutQuad);\n  -webkit-animation-timing-function: var(--easeInOutQuad);\n  animation-timing-function: var(--easeInOutQuad);\n  -moz-animation-duration: var(--routeTransition);\n  -ms-animation-duration: var(--routeTransition);\n  -o-animation-duration: var(--routeTransition);\n  -webkit-animation-duration: var(--routeTransition);\n  animation-duration: var(--routeTransition);\n  -moz-animation-direction: normal;\n  -ms-animation-direction: normal;\n  -o-animation-direction: normal;\n  -webkit-animation-direction: normal;\n  animation-direction: normal;\n  -moz-animation-delay: 0s;\n  -ms-animation-delay: 0s;\n  -o-animation-delay: 0s;\n  -webkit-animation-delay: 0s;\n  animation-delay: 0s;\n  -moz-animation-fill-mode: forwards;\n  -ms-animation-fill-mode: forwards;\n  -o-animation-fill-mode: forwards;\n  -webkit-animation-fill-mode: forwards;\n  animation-fill-mode: forwards;\n}\n/*# sourceMappingURL=layout.component.css.map */\n"] }]
  }], () => [{ type: InternalRouteService }, { type: AdministrationService }, { type: UiService }], { componentElm: [{
    type: ViewChild,
    args: ["componentElm"]
  }], params: [{
    type: Input,
    args: ["params"]
  }] });
})();
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(LayoutComponent, { className: "LayoutComponent", filePath: "src/app/administration/netsuite/components/layout/layout.component.ts", lineNumber: 23 });
})();

// src/app/administration/netsuite/netsuite.module.ts
var _NetSuiteModule = class _NetSuiteModule {
  constructor(injector) {
    this.injector = injector;
    this.ngDoBootstrap();
  }
  ngDoBootstrap() {
    const el = createCustomElement(LayoutComponent, { injector: this.injector });
    customElements.define("administration-netsuite", el);
  }
};
_NetSuiteModule.\u0275fac = function NetSuiteModule_Factory(__ngFactoryType__) {
  return new (__ngFactoryType__ || _NetSuiteModule)(\u0275\u0275inject(Injector));
};
_NetSuiteModule.\u0275mod = /* @__PURE__ */ \u0275\u0275defineNgModule({ type: _NetSuiteModule });
_NetSuiteModule.\u0275inj = /* @__PURE__ */ \u0275\u0275defineInjector({ providers: [
  InternalRouteService,
  NetSuiteService,
  provideHttpClient(withInterceptorsFromDi())
], imports: [
  UiModule,
  CommonModule,
  FormsModule,
  ReactiveFormsModule
] });
var NetSuiteModule = _NetSuiteModule;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && setClassMetadata(NetSuiteModule, [{
    type: NgModule,
    args: [{
      declarations: [
        LayoutComponent,
        SettingsComponent
      ],
      schemas: [
        CUSTOM_ELEMENTS_SCHEMA
      ],
      imports: [
        UiModule,
        CommonModule,
        FormsModule,
        ReactiveFormsModule
      ],
      providers: [
        InternalRouteService,
        NetSuiteService,
        provideHttpClient(withInterceptorsFromDi())
      ]
    }]
  }], () => [{ type: Injector }], null);
})();
export {
  NetSuiteModule
};
//# sourceMappingURL=chunk-XLGRX7AV.js.map
